(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   8806308,     148585]
NotebookOptionsPosition[   8793597,     148290]
NotebookOutlinePosition[   8794031,     148307]
CellTagsIndexPosition[   8793988,     148304]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Lab 08 - Gradient fields and level curves ", "Title",
 CellChangeTimes->{{3.545580350064847*^9, 3.545580355422383*^9}, {
  3.5456160119392223`*^9, 3.5456160130780244`*^9}, {3.5777802843481092`*^9, 
  3.577780289066533*^9}, {3.656339312239959*^9, 3.656339326120943*^9}, {
  3.656358487020174*^9, 3.656358489932745*^9}, {3.656371652800416*^9, 
  3.656371662805306*^9}, {3.656371707647746*^9, 3.6563717126938667`*^9}, {
  3.656430497895688*^9, 
  3.656430498907543*^9}},ExpressionUUID->"dced4873-ac11-415f-92e9-\
9975d3cd0971"],

Cell["Vince Kurtz", "Subtitle",
 CellChangeTimes->{{3.6564305160001087`*^9, 
  3.656430518054953*^9}},ExpressionUUID->"5182f24f-f2e8-4c76-97b5-\
757dcc4f119d"],

Cell[TextData[{
 "Consider a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]],ExpressionUUID->
  "a7047869-41ed-447d-8b21-410a8ddbcce8"],
 " of two variables.  The gradient of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]],ExpressionUUID->
  "db955e9b-4dd8-4016-a692-1f0807e9d49e"],
 " is a vector field ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["\[Del]", "\[RightVector]"], "f"}], TraditionalForm]],
  ExpressionUUID->"787bdd70-ed77-4632-8622-d8bb94c80ff6"],
 "=",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["F", "\[RightVector]"], "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["f", "x"], 
      OverscriptBox["i", "^"]}], "+", 
     RowBox[{
      SubscriptBox["f", "y"], 
      OverscriptBox["j", "^"]}]}]}], TraditionalForm]],ExpressionUUID->
  "895facc0-4670-4eaf-a9e7-82e0f7c320d0"],
 ". The gradient at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]],ExpressionUUID->
  "3f35ef70-669d-4544-9b24-c75acfc15398"],
 " is "
}], "Text",
 CellChangeTimes->{{3.5455826289363728`*^9, 3.545582646663145*^9}, {
   3.5455826768881674`*^9, 3.5455827588263607`*^9}, {3.656339453660355*^9, 
   3.6563397095899363`*^9}, {3.656339849901436*^9, 3.656339863395121*^9}, 
   3.65635643750189*^9, {3.656356485045575*^9, 3.65635654800352*^9}, {
   3.6563565851436253`*^9, 3.656356719484592*^9}, {3.656356754884363*^9, 
   3.656356813880569*^9}, {3.656357575512457*^9, 3.656357733214164*^9}, {
   3.656357905015839*^9, 3.6563579326820917`*^9}, {3.65635796424817*^9, 
   3.656358009034677*^9}, {3.6563717490683804`*^9, 
   3.656371751251749*^9}},ExpressionUUID->"d228e606-7bf7-4265-9bd3-\
e88b5ff63abb"],

Cell[CellGroupData[{

Cell["\<\
a vector pointing in the direction of maximum increase of the function.\
\>", "Item",
 CellChangeTimes->{{3.656357907904604*^9, 
  3.656357909899267*^9}},ExpressionUUID->"f33ff9a6-f9e8-4305-8090-\
d3d80ef0ec72"],

Cell[TextData[{
 "perpendicular to the contour line (level curve) of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]],ExpressionUUID->
  "8450f743-5b99-4b51-a3f9-44b27381dace"],
 " which passes through ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]],ExpressionUUID->
  "63307b2a-ffa1-4962-9f68-870b21adb06d"],
 ", that is, perpendicular to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", "k"}], TraditionalForm]],
  ExpressionUUID->"5da411a5-7d15-4d40-956d-a6f0e1a3c908"],
 "."
}], "Item",
 CellChangeTimes->{{3.656357907904604*^9, 3.656357922137479*^9}, {
  3.656358035126507*^9, 
  3.656358039040176*^9}},ExpressionUUID->"6e84a36b-89a9-4b20-bf87-\
a5d25f27d573"],

Cell["\<\
It\[CloseCurlyQuote]s magnitude is the slope (directional derivative) in that \
direction,\
\>", "Item",
 CellChangeTimes->{{3.656357907904604*^9, 
  3.656357970833547*^9}},ExpressionUUID->"b513b17d-46e4-4407-ac7d-\
a0bf002478b2"],

Cell[TextData[{
 "so, as the curves (contour lines) get further apart, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftDoubleBracketingBar]", 
    RowBox[{
     OverscriptBox["\[Del]", "\[RightVector]"], "f"}], 
    "\[RightDoubleBracketingBar]"}], TraditionalForm]],ExpressionUUID->
  "07672cf9-8b3a-415b-9c0a-891d30dfcf91"],
 " should get smaller."
}], "Item",
 CellChangeTimes->{{3.656357907904604*^9, 
  3.656357966707345*^9}},ExpressionUUID->"244e7e57-8ef1-4aa5-9a01-\
cc92dc997fba"]
}, Open  ]],

Cell["Check this out for a particular function:", "Text",
 CellChangeTimes->{{3.65635798765906*^9, 3.656357995685988*^9}, {
  3.65637178753053*^9, 
  3.65637179461045*^9}},ExpressionUUID->"78f53323-f1f4-469a-8adb-\
923f3374b6c8"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{GridBox[{
        {
         RowBox[{
          RowBox[{"f", "(", 
           RowBox[{"x", ",", "y"}], ")"}], "=", 
          FractionBox[
           SuperscriptBox["x", "2"], "4"]}]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}], "+", 
      FractionBox[
       SuperscriptBox["y", "2"], "9"]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"d219275c-ed84-4896-82bc-a7451bf07406"]], \
"Text",
 CellChangeTimes->{{3.6563568409915667`*^9, 3.656356848676772*^9}, {
  3.656356896522317*^9, 
  3.656356958918716*^9}},ExpressionUUID->"a9e12f73-0302-4b0f-98fa-\
f1f0a27af2ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myf", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "/", "4"}], "+", 
   RowBox[{
    RowBox[{"y", "^", "2"}], "/", "9"}]}]}]], "Input",
 CellChangeTimes->{{3.656357011022684*^9, 
  3.656357062101321*^9}},ExpressionUUID->"2c8798dc-774a-40de-bcf6-\
c93cb623544a"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["x", "2"], "4"], "+", 
  FractionBox[
   SuperscriptBox["y", "2"], "9"]}]], "Output",
 CellChangeTimes->{3.6563570666296043`*^9, 3.656364073130101*^9, 
  3.6564305499385643`*^9},ExpressionUUID->"a3d7c9e9-1313-4b0b-922b-\
90e1ec9584c8"]
}, Open  ]],

Cell["\[LineSeparator]The gradient of this function is...", "Text",
 CellChangeTimes->{{3.6563569942003937`*^9, 3.6563570009054337`*^9}, 
   3.6563580786997843`*^9},ExpressionUUID->"637b2259-0341-432a-a1a1-\
b970fa60afb1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myGradf", "=", 
  RowBox[{"Grad", "[", 
   RowBox[{"myf", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.656357072197816*^9, 3.656357082862822*^9}, {
  3.656357175284408*^9, 3.656357182204315*^9}, {3.656357252077417*^9, 
  3.656357258310945*^9}},ExpressionUUID->"ebbc309b-b2b7-4d3a-a5b2-\
e2983f36a3f8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["x", "2"], ",", 
   FractionBox[
    RowBox[{"2", " ", "y"}], "9"]}], "}"}]], "Output",
 CellChangeTimes->{3.656357083468433*^9, 3.656357183072921*^9, 
  3.656357261052652*^9, 3.6563640773626204`*^9, 
  3.656430556103096*^9},ExpressionUUID->"71f2abb4-6250-4a1e-bb76-\
37c14452a588"]
}, Open  ]],

Cell[TextData[StyleBox["\[LineSeparator]Overlaying Vector Fields/Gradient \
Fields", "Subsubsection",
 FontWeight->"Bold"]], "Text",
 CellChangeTimes->{{3.545586896615*^9, 3.5455869026140003`*^9}, {
   3.545588800658*^9, 3.545588804586*^9}, {3.5455899869229136`*^9, 
   3.545590002667488*^9}, 3.545617235548399*^9, {3.656357293062419*^9, 
   3.656357294966528*^9}, 
   3.656370081931305*^9},ExpressionUUID->"d703a79c-f519-4b5e-9a24-\
0b1cde63e804"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"p1", "=", 
  RowBox[{"VectorPlot", "[", 
   RowBox[{"myGradf", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"VectorColorFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"Red", "&"}], ")"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"p2", "=", 
  RowBox[{"ContourPlot", "[", 
   RowBox[{"myf", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"Contours", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p2", ",", "p1"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5456172445340147`*^9, 3.5456174056510973`*^9}, {
  3.5456175477673473`*^9, 3.5456175640849757`*^9}, {3.5456178161502185`*^9, 
  3.545617897816362*^9}, {3.5456179285172157`*^9, 3.54561793084162*^9}, {
  3.5777827942855997`*^9, 3.5777828228024*^9}, {3.5777829009896*^9, 
  3.5777829099128*^9}, {3.5777829489606*^9, 3.5777829619398003`*^9}, {
  3.577783095975*^9, 3.5777831053038*^9}, {3.5777832057902*^9, 
  3.5777832150098*^9}, {3.6563573392539597`*^9, 3.6563574078988667`*^9}, {
  3.6563581081151733`*^9, 3.656358116580297*^9}, {3.6563640488516808`*^9, 
  3.656364062264409*^9}},ExpressionUUID->"ace72321-baac-4816-bbf6-\
88a23616d858"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
    {Arrowheads[{{0.04587368524026634, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -3.835895278030231}, \
{-4.36923562443198, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.044858698282982175`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -3.287910238311627}, \
{-4.36923562443198, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.04398157175864748, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -2.739925198593023}, \
{-4.36923562443198, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.04325069393287603, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -2.1919401588744187`}, \
{-4.36923562443198, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.04267357994809448, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -1.6439551191558142`}, \
{-4.36923562443198, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.04225653031301002, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -1.0959700794372098`}, \
{-4.36923562443198, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.04200431300710784, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -0.5479850397186052}, \
{-4.36923562443198, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.041919903350326, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, -8.517398515440158*^-16}, \
{-4.36923562443198, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.04200431300710784, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, 
       0.5479850397186036}, {-4.36923562443198, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.04225653031301002, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, 1.095970079437208}, {-4.36923562443198,
        1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.04267357994809448, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, 
       1.6439551191558124`}, {-4.36923562443198, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.043250693932876026`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, 2.191940158874417}, {-4.36923562443198,
        2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.04398157175864748, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, 2.739925198593021}, {-4.36923562443198,
        2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.044858698282982175`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, 3.287910238311625}, {-4.36923562443198,
        3.569232618831229}}]}}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.6307643755680203`, 3.83589527803023}, {-4.36923562443198, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.04047441545604541, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.1120837504868746`, -3.835895278030231}, \
{-3.745059106655983, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.03932030163451397, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, -3.287910238311627}, \
{-3.7450591066559826`, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.038316601667509505`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, -2.739925198593023}, \
{-3.7450591066559826`, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.03747540306201995, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, -2.1919401588744187`}, \
{-3.7450591066559826`, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.036807848817500134`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, -1.6439551191558142`}, \
{-3.7450591066559826`, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.036323513914265956`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.1120837504868746`, -1.0959700794372098`}, \
{-3.745059106655983, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.036029787956420485`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, -0.5479850397186052}, \
{-3.7450591066559826`, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.035931345728850886`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.1120837504868746`, -8.517398515440158*^-16}, \
{-3.745059106655983, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.036029787956420485`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, 
       0.5479850397186036}, {-3.7450591066559826`, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.036323513914265956`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.1120837504868746`, 
       1.095970079437208}, {-3.745059106655983, 1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.036807848817500134`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, 
       1.6439551191558124`}, {-3.7450591066559826`, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.037475403062019984`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.1120837504868746`, 
       2.191940158874417}, {-3.745059106655983, 2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.038316601667509505`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, 
       2.739925198593021}, {-3.7450591066559826`, 2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.039320301634513964`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, 
       3.287910238311625}, {-3.7450591066559826`, 3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.04047441545604533, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.112083750486875, 3.83589527803023}, {-3.7450591066559826`,
        4.164104721969767}}]}}, 
    {Arrowheads[{{0.03526595043757587, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -3.835895278030231}, \
{-3.120882588879986, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.033935159855025814`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -3.287910238311627}, \
{-3.120882588879986, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.032766918028761666`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -2.739925198593023}, \
{-3.120882588879986, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.031779156508910805`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -2.1919401588744187`}, \
{-3.120882588879986, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.03098913823146652, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -1.6439551191558142`}, \
{-3.120882588879986, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.03041227740299734, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -1.0959700794372098`}, \
{-3.120882588879986, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.030060847857996557`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -0.5479850397186052}, \
{-3.120882588879986, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.02994278810737572, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, -8.517398515440158*^-16}, \
{-3.120882588879986, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.030060847857996557`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, 
       0.5479850397186036}, {-3.120882588879986, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.03041227740299734, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, 
       1.095970079437208}, {-3.120882588879986, 1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.030989138231466512`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, 
       1.6439551191558124`}, {-3.120882588879986, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.03177915650891079, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, 
       2.191940158874417}, {-3.120882588879986, 2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.032766918028761666`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, 
       2.739925198593021}, {-3.120882588879986, 2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.033935159855025814`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, 
       3.287910238311625}, {-3.120882588879986, 3.569232618831229}}]}}, 
    {Arrowheads[{{0.03526595043757583, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.5934031254057293`, 3.83589527803023}, {-3.120882588879986,
        4.164104721969767}}]}}, 
    {Arrowheads[{{0.030346694363538266`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -3.835895278030231}, \
{-2.4967060711039895`, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.02878940209373241, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -3.287910238311627}, \
{-2.4967060711039895`, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.027402655266087518`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -2.739925198593023}, \
{-2.4967060711039895`, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.026213534423009343`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -2.1919401588744187`}, \
{-2.4967060711039895`, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.025249975977362584`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -1.6439551191558142`}, \
{-2.4967060711039895`, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.02453856587833345, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -1.0959700794372098`}, \
{-2.4967060711039895`, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.024101642526393595`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -0.5479850397186052}, \
{-2.4967060711039895`, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.02395423048590058, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, -8.517398515440158*^-16}, \
{-2.4967060711039895`, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.024101642526393595`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, 
       0.5479850397186036}, {-2.4967060711039895`, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.024538565878333442`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, 
       1.095970079437208}, {-2.4967060711039895`, 1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.025249975977362577`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, 
       1.6439551191558124`}, {-2.4967060711039895`, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.02621353442300933, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, 
       2.191940158874417}, {-2.4967060711039895`, 2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.027402655266087518`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, 
       2.739925198593021}, {-2.4967060711039895`, 2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.02878940209373239, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, 
       3.287910238311625}, {-2.4967060711039895`, 3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.030346694363538224`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.074722500324584, 3.83589527803023}, {-2.4967060711039895`,
        4.164104721969767}}]}}, 
    {Arrowheads[{{0.02588208071415258, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -3.835895278030231}, \
{-1.872529553327992, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.02403726099651346, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -3.287910238311627}, \
{-1.872529553327992, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.022357677851958094`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -2.739925198593023}, \
{-1.872529553327992, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.020883238021106764`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -2.1919401588744187`}, \
{-1.872529553327992, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.019660150817257, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -1.6439551191558142`}, \
{-1.872529553327992, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.018737701531009985`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -1.0959700794372098`}, \
{-1.872529553327992, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.018161756957132964`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -0.5479850397186052}, \
{-1.872529553327992, -0.5948721031385393}}]}}, 
    {Arrowheads[{{0.01796567286442543, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, -8.517398515440158*^-16}, \
{-1.872529553327992, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.018161756957132964`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, 0.5479850397186036}, {-1.872529553327992,
        0.5948721031385374}}]}}, 
    {Arrowheads[{{0.01873770153100998, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, 1.095970079437208}, {-1.872529553327992, 
       1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.019660150817256992`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, 
       1.6439551191558124`}, {-1.872529553327992, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.02088323802110675, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, 2.191940158874417}, {-1.872529553327992, 
       2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.022357677851958094`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, 2.739925198593021}, {-1.872529553327992, 
       2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.024037260996513442`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, 3.287910238311625}, {-1.872529553327992, 
       3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.025882080714152524`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.556041875243438, 3.83589527803023}, {-1.872529553327992, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.02214876949551078, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -3.835895278030231}, \
{-1.248353035551995, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.019961858738250484`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -3.287910238311627}, \
{-1.248353035551995, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.017903956183014342`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -2.739925198593023}, \
{-1.248353035551995, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.016024840664342316`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -2.1919401588744187`}, \
{-1.248353035551995, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.014394701046866205`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -1.6439551191558142`}, \
{-1.248353035551995, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.013106767211504671`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -1.0959700794372098`}, \
{-1.248353035551995, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.012269282939166725`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -0.5479850397186052}, \
{-1.248353035551995, -0.5948721031385393}}]}}, 
    {Arrowheads[{{0.01197711524295029, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, -8.517398515440158*^-16}, \
{-1.248353035551995, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.012269282939166721`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, 
       0.5479850397186036}, {-1.248353035551995, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.013106767211504665`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, 
       1.095970079437208}, {-1.248353035551995, 1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.014394701046866194`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, 
       1.6439551191558124`}, {-1.248353035551995, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.0160248406643423, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, 
       2.191940158874417}, {-1.248353035551995, 2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.01790395618301433, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622924`, 
       2.739925198593021}, {-1.248353035551995, 2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.019961858738250463`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, 
       3.287910238311625}, {-1.248353035551995, 3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.022148769495510718`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.0373612501622922`, 3.83589527803023}, {-1.248353035551995,
        4.164104721969767}}]}}, 
    {Arrowheads[{{0.019569862621083595`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -3.835895278030231}, \
{-0.624176517775998, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.017055419582311163`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -3.287910238311627}, \
{-0.624176517775998, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.014593258027120377`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -2.739925198593023}, \
{-0.624176517775998, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.012215033817406115`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -2.1919401588744187`}, \
{-0.624176517775998, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.009980929369125245, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -1.6439551191558142`}, \
{-0.624176517775998, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.008012420332171161, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -1.0959700794372098`}, \
{-0.624176517775998, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.006553383605752341, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -0.5479850397186052}, \
{-0.624176517775998, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.005988557621475151, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, -8.517398515440158*^-16}, \
{-0.624176517775998, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.0065533836057523375`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, 
       0.5479850397186036}, {-0.624176517775998, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.008012420332171154, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, 1.095970079437208}, {-0.624176517775998,
        1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.009980929369125235, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, 
       1.6439551191558124`}, {-0.624176517775998, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.012215033817406091`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, 2.191940158874417}, {-0.624176517775998,
        2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.014593258027120377`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, 2.739925198593021}, {-0.624176517775998,
        2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.017055419582311142`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, 3.287910238311625}, {-0.624176517775998,
        3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.019569862621083522`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-0.5186806250811465, 3.83589527803023}, {-0.624176517775998, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.018631068155700484`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, -3.835895278030231}, \
{-9.701651980513714*^-16, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.015969486990600388`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, -3.287910238311627}, \
{-9.701651980513714*^-16, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.013307905825500314`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, -2.739925198593023}, \
{-9.701651980513714*^-16, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.010646324660400266`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, -2.1919401588744187`}, \
{-9.701651980513714*^-16, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.007984743495300194, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, -1.6439551191558142`}, \
{-9.701651980513714*^-16, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.005323162330200133, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, -1.0959700794372098`}, \
{-9.701651980513714*^-16, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.0026615811651000665`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, -0.5479850397186052}, \
{-9.701651980513714*^-16, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.0026615811651000605`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, 
       0.5479850397186036}, {-9.701651980513714*^-16, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.005323162330200121, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, 
       1.095970079437208}, {-9.701651980513714*^-16, 1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.007984743495300182, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, 
       1.6439551191558124`}, {-9.701651980513714*^-16, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.010646324660400242`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, 
       2.191940158874417}, {-9.701651980513714*^-16, 2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.013307905825500314`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, 
       2.739925198593021}, {-9.701651980513714*^-16, 2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.015969486990600364`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, 
       3.287910238311625}, {-9.701651980513714*^-16, 3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.018631068155700408`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.061916413488791*^-16, 
       3.83589527803023}, {-9.701651980513714*^-16, 4.164104721969767}}]}}, 
    {Arrowheads[{{0.019569862621083588`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, -3.835895278030231}, {
       0.6241765177759961, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.017055419582311156`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.518680625081145, -3.287910238311627}, {
       0.6241765177759961, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.01459325802712037, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, -2.739925198593023}, {
       0.6241765177759961, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.012215033817406108`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, -2.1919401588744187`}, {
       0.6241765177759961, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.009980929369125239, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, -1.6439551191558142`}, {
       0.6241765177759961, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.008012420332171153, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, -1.0959700794372098`}, {
       0.6241765177759961, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.006553383605752324, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.518680625081145, -0.5479850397186052}, {
       0.6241765177759961, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.005988557621475139, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, -8.517398515440158*^-16}, {
       0.6241765177759961, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.006553383605752327, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, 0.5479850397186036}, {0.6241765177759961,
        0.5948721031385374}}]}}, 
    {Arrowheads[{{0.008012420332171144, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, 1.095970079437208}, {0.6241765177759961, 
       1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.009980929369125225, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, 1.6439551191558124`}, {0.624176517775996,
        1.784616309415614}}]}}, 
    {Arrowheads[{{0.012215033817406086`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.5186806250811449, 2.191940158874417}, {0.6241765177759961, 
       2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.01459325802712037, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.518680625081145, 2.739925198593021}, {0.6241765177759961, 
       2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.017055419582311136`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.518680625081145, 3.287910238311625}, {0.6241765177759961, 
       3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.019569862621083515`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.518680625081145, 3.83589527803023}, {0.6241765177759961, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.022148769495510773`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -3.835895278030231}, {
       1.2483530355519932`, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.019961858738250477`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -3.287910238311627}, {
       1.2483530355519932`, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.01790395618301433, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -2.739925198593023}, {
       1.2483530355519932`, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.016024840664342305`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -2.1919401588744187`}, {
       1.2483530355519932`, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.014394701046866193`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -1.6439551191558142`}, {
       1.2483530355519932`, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.013106767211504658`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -1.0959700794372098`}, {
       1.2483530355519932`, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.01226928293916671, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -0.5479850397186052}, {
       1.2483530355519932`, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.011977115242950278`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, -8.517398515440158*^-16}, {
       1.2483530355519932`, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.012269282939166709`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, 0.5479850397186036}, {
       1.2483530355519932`, 0.5948721031385374}}]}}, 
    {Arrowheads[{{0.013106767211504654`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, 1.095970079437208}, {
       1.2483530355519932`, 1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.014394701046866186`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, 1.6439551191558124`}, {
       1.2483530355519932`, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.016024840664342288`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, 2.191940158874417}, {
       1.2483530355519932`, 2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.01790395618301433, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, 2.739925198593021}, {
       1.2483530355519932`, 2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.019961858738250456`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, 3.287910238311625}, {
       1.2483530355519932`, 3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.02214876949551071, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0373612501622906`, 3.83589527803023}, {1.2483530355519932`,
        4.164104721969767}}]}}, 
    {Arrowheads[{{0.025882080714152562`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -3.835895278030231}, {
       1.87252955332799, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.02403726099651344, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -3.287910238311627}, {
       1.87252955332799, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.022357677851958073`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -2.739925198593023}, {
       1.87252955332799, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.02088323802110674, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -2.1919401588744187`}, {
       1.87252955332799, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.01966015081725697, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -1.6439551191558142`}, {
       1.87252955332799, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.01873770153100996, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -1.0959700794372098`}, {
       1.87252955332799, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.01816175695713294, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -0.5479850397186052}, {
       1.87252955332799, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.017965672864425405`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, -8.517398515440158*^-16}, {
       1.87252955332799, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.018161756957132937`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, 0.5479850397186036}, {1.87252955332799, 
       0.5948721031385374}}]}}, 
    {Arrowheads[{{0.018737701531009957`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, 1.095970079437208}, {1.87252955332799, 
       1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.019660150817256968`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, 1.6439551191558124`}, {1.87252955332799,
        1.784616309415614}}]}}, 
    {Arrowheads[{{0.020883238021106726`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, 2.191940158874417}, {1.87252955332799, 
       2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.022357677851958073`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, 2.739925198593021}, {1.87252955332799, 
       2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.02403726099651342, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, 3.287910238311625}, {1.87252955332799, 
       3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.025882080714152506`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5560418752434364`, 3.83589527803023}, {1.87252955332799, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.030346694363538256`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -3.835895278030231}, {
       2.4967060711039872`, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.028789402093732385`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -3.287910238311627}, {
       2.4967060711039872`, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.027402655266087494`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -2.739925198593023}, {
       2.4967060711039872`, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.026213534423009315`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -2.1919401588744187`}, {
       2.4967060711039872`, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.02524997597736256, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -1.6439551191558142`}, {
       2.4967060711039872`, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.02453856587833342, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -1.0959700794372098`}, {
       2.4967060711039872`, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.02410164252639357, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -0.5479850397186052}, {
       2.4967060711039872`, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.023954230485900556`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, -8.517398515440158*^-16}, {
       2.4967060711039872`, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.02410164252639357, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, 0.5479850397186036}, {2.4967060711039872`,
        0.5948721031385374}}]}}, 
    {Arrowheads[{{0.024538565878333418`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, 1.095970079437208}, {2.4967060711039872`, 
       1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.025249975977362553`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, 1.6439551191558124`}, {
       2.4967060711039872`, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.02621353442300931, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, 2.191940158874417}, {2.4967060711039872`, 
       2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.027402655266087494`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, 2.739925198593021}, {2.4967060711039872`, 
       2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.02878940209373237, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, 3.287910238311625}, {2.4967060711039872`, 
       3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.030346694363538203`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.074722500324582, 3.83589527803023}, {2.4967060711039872`, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.03526595043757583, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, -3.835895278030231}, {
       3.120882588879984, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.03393515985502577, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, -3.287910238311627}, {
       3.120882588879984, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.03276691802876162, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, -2.739925198593023}, {
       3.120882588879984, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.03177915650891077, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.5934031254057275`, -2.1919401588744187`}, {
       3.120882588879984, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.030989138231466467`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, -1.6439551191558142`}, {
       3.120882588879984, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.03041227740299731, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.5934031254057275`, -1.0959700794372098`}, {
       3.120882588879984, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.030060847857996533`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.5934031254057275`, -0.5479850397186052}, {
       3.120882588879984, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.029942788107375693`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.5934031254057275`, -8.517398515440158*^-16}, {
       3.120882588879984, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.03006084785799651, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, 0.5479850397186036}, {3.120882588879984, 
       0.5948721031385374}}]}}, 
    {Arrowheads[{{0.030412277402997286`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, 1.095970079437208}, {3.120882588879984, 
       1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.03098913823146646, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, 1.6439551191558124`}, {3.120882588879984, 
       1.784616309415614}}]}}, 
    {Arrowheads[{{0.03177915650891075, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, 2.191940158874417}, {3.120882588879984, 
       2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.03276691802876164, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.5934031254057275`, 2.739925198593021}, {3.120882588879984, 
       2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.03393515985502576, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, 3.287910238311625}, {3.120882588879984, 
       3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.035265950437575785`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.593403125405728, 3.83589527803023}, {3.120882588879984, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.04047441545604536, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -3.835895278030231}, {
       3.745059106655981, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.03932030163451397, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -3.287910238311627}, {
       3.745059106655981, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.038316601667509505`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -2.739925198593023}, {
       3.745059106655981, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.03747540306201995, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -2.1919401588744187`}, {
       3.745059106655981, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.036807848817500134`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -1.6439551191558142`}, {
       3.745059106655981, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.03632351391426591, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -1.0959700794372098`}, {
       3.745059106655981, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.036029787956420485`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -0.5479850397186052}, {
       3.745059106655981, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.03593134572885083, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, -8.517398515440158*^-16}, {
       3.745059106655981, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.036029787956420485`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, 0.5479850397186036}, {3.745059106655981,
        0.5948721031385374}}]}}, 
    {Arrowheads[{{0.03632351391426591, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, 1.095970079437208}, {3.745059106655981, 
       1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.036807848817500134`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, 1.6439551191558124`}, {
       3.745059106655981, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.03747540306201994, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, 2.191940158874417}, {3.745059106655981, 
       2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.038316601667509505`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, 2.739925198593021}, {3.745059106655981, 
       2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.039320301634513964`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, 3.287910238311625}, {3.745059106655981, 
       3.5692326188312284`}}]}}, 
    {Arrowheads[{{0.04047441545604533, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1120837504868732`, 3.83589527803023}, {3.745059106655981, 
       4.164104721969767}}]}}, 
    {Arrowheads[{{0.04587368524026634, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -3.835895278030231}, {
       4.369235624431978, -4.164104721969769}}]}}, 
    {Arrowheads[{{0.044858698282982175`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -3.287910238311627}, {
       4.369235624431978, -3.5692326188312307`}}]}}, 
    {Arrowheads[{{0.04398157175864748, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -2.739925198593023}, {
       4.369235624431978, -2.9743605156926924`}}]}}, 
    {Arrowheads[{{0.04325069393287603, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -2.1919401588744187`}, {
       4.369235624431978, -2.3794884125541547`}}]}}, 
    {Arrowheads[{{0.04267357994809448, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -1.6439551191558142`}, {
       4.369235624431978, -1.784616309415616}}]}}, 
    {Arrowheads[{{0.04225653031301002, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -1.0959700794372098`}, {
       4.369235624431978, -1.1897442062770778`}}]}}, 
    {Arrowheads[{{0.04200431300710784, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -0.5479850397186052}, {
       4.369235624431978, -0.5948721031385392}}]}}, 
    {Arrowheads[{{0.041919903350326, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, -8.517398515440158*^-16}, {
       4.369235624431978, -9.246169878562348*^-16}}]}}, 
    {Arrowheads[{{0.04200431300710784, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, 0.5479850397186036}, {4.369235624431978,
        0.5948721031385374}}]}}, 
    {Arrowheads[{{0.04225653031301002, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, 1.095970079437208}, {4.369235624431978, 
       1.1897442062770758`}}]}}, 
    {Arrowheads[{{0.04267357994809448, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, 1.6439551191558124`}, {
       4.369235624431978, 1.784616309415614}}]}}, 
    {Arrowheads[{{0.043250693932876026`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, 2.191940158874417}, {4.369235624431978, 
       2.3794884125541524`}}]}}, 
    {Arrowheads[{{0.04398157175864748, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, 2.739925198593021}, {4.369235624431978, 
       2.9743605156926907`}}]}}, 
    {Arrowheads[{{0.044858698282982175`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, 3.287910238311625}, {4.369235624431978, 
       3.569232618831229}}]}}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.6307643755680186`, 3.83589527803023}, {4.369235624431978, 
       4.164104721969767}}]}}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "TransparentPolygonMesh" -> True},
  PlotRange->{{-4.404061017820885, 4.404061017820885}, {-4.404061017820885, 
   4.404061017820885}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.545617328399762*^9, 3.5456173861978636`*^9}, 
   3.545617566128579*^9, {3.5456178186618233`*^9, 3.545617900499567*^9}, 
   3.545617932417223*^9, 3.5777828248616*^9, 3.5777829107864*^9, 
   3.5777829631722*^9, {3.5777831071602*^9, 3.5777831380550003`*^9}, {
   3.5777832103454*^9, 3.5777832386594*^9}, 3.60911556494733*^9, 
   3.656357309961537*^9, 3.656357355258143*^9, {3.656357394052951*^9, 
   3.6563574091575317`*^9}, {3.656358110031333*^9, 3.656358117650107*^9}, {
   3.656364066976273*^9, 3.656364086096344*^9}, 
   3.656430563684225*^9},ExpressionUUID->"1fa35fdd-43bc-4b41-8d78-\
8279aa91223e"],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFnQm4jlX3/4/jzCMpkkQIZSqp9IZ7JxmikuaigRSaRLxJIk0nEYqURKIM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   "], {{
     {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmFtsVWUWx3c5e5991Jk3fRjnRYhg8GUeCphxvGQK1ERjIiC+mNgLNZrM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         "]], PolygonBox[CompressedData["
1:eJwllEtsjGEUhr/pzPf/vwQrG7XRxCVjYzG0IUIoFmxkFl2Q6ChJJWQajUuE
calqtDqMEZdEU7eFCEmliU1LaV2qF5FIqQ0RrVtcYtNEsfC8OYuTOe933nO+
7z/nPVNWU5fOljjn0lgCe+id64vzi90JnbsLXhxzrhO7BV4eOFeLfx1yU+Tc
FHAqYTmdxDfDT1HnImdHiZ/CBvErOPvr7Uwx1fwDfoyNkHsJK5DfCp4HtwEc
wn0KfoP/GhsmvgW8gXgPuEOY+8epVeQsg19Dzi7qzwenwDvgZ53dMQR/AfFR
1SJnGvEj4CL8heBfcNdz1hWzOwrgt+SMxeybX4K/ge8Rm6TGd/wi1oaf4yxL
vMfb21qxRmJrqV9F/Sz5a/CnU39Fwr7puWphg3HroXqZ9/b2Rs4ykdVQrTx2
HH8jnHSJvTHjbSaaTZL8WZH1SL3SNz4hfgF8Te+hZj24Es59Z29ajd8UWu1q
zmqJP8KGwANYN7GlcNYlrAfqRU53wr3B2YnIcpTbD7+L+AB4HP+DZgZORTYb
nS3CP8bZHN5fTr0G/BbOblOrA85hcpvBN8Hd4EPgssB6J464MwPjDoNPg8sD
09YLcAG8j5yP8Cu5ox3/n7e7pEFpcQ/8Kvhzie/Fn/Q2+37ieeJlWG/cOLPx
l8FJwt2N7QTnAvPVkyXgrVhbzDS3LbI7dbc0OUN69HZXnWqADwQ2C9U8GNgO
aZfU0/1wf4amLc3oB/7V0LSgnbiC/xWbiJsGv+A3S4Pgs1gL/qfQeifO59C+
Sd+mnfztbce0a9LsmdBmrFlLg33eZqbZjWHPvP0H6L9APXkAnhrY7kgjSWpv
0vc52yHtkjQhbUzAWQn3cmi7LE47/qrAYpqxZj1C/vaYzewd8ZOhfYt2Vrt7
Tj2Im4bP45dGpnXtgHah15v21AP1QjuoXXwPfhVaz9V7aa5aXG8x1VRtaUha
0htKA9OQtKSZVoBHQ+uFdla7+x8qCrv5
         "]]}]}, 
     {RGBColor[0.5237980769230769, 0.48778846153846156`, 0.5111538461538462], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mXnUlVUVxu99730H19JMLcUyxWQpVpQ4pAiCKeKEQ44fYCRoaipiMqmA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         "]], PolygonBox[CompressedData["
1:eJwtl2dwVVUUhV+59577Q0cBxY7gOIqKBcUSBRQCQXooCiEaktgQNEQCQSWh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         "]]}]}, 
     {RGBColor[0.7946634615384616, 0.5829807692307692, 0.3519230769230769], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXv0llWVx9/f+z43wTuaAi4RRy7eUFERbfACGmDKVS1QbIl5QxER0Z+a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         "]], PolygonBox[CompressedData["
1:eJwtlwuQz1UUx3//x+93f2ubsIisaa2EGPIodnqwbbFIu3YXrbWYdj1X3qxH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         "]]}]}, 
     {RGBColor[0.9264423076923077, 0.6861057692307692, 0.37197115384615376`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmwVcURxu+95545RzZREVFADYvbk+UhWCJqIDGR3SWCJoBJKYK4BitG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         "]], PolygonBox[CompressedData["
1:eJwtl3mwz1UYxn/b95xfV7Yml+i2ScoVUZQsudNCaCFLhWrIkkS3ERdNk8yk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         "]]}]}, 
     {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lltsVVUQhvc+PWfvUi4tl1MoUEi5JF5ARCGAFn3yQcEHJWgCookJKqYR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         "]], PolygonBox[CompressedData["
1:eJwtlEtIVVEUhvc917vPxUSKHiaocCuhgqDoQUTWqEFqg1IhMhOCXiRZNAhL
etigmpU9LEPI1B5EWlGTEHpRWpBhDTKTAq0oMbyUGQk9vp/V4Of8/1pr773O
WmvvxMbKNTsC51wxSAEL486tgNTBf3nnBkLndkecGyXoA7wTWw16DJ2OTg3N
lxV1bhH8B/gLzyJmJDSbfGXEbGbtTdAEP8L+9THn0vBPRieIWQxfi205fAm2
Y/BrxDfA1xFfi25DN6K3oU+jN5BvgrPyWFMO38Iem+BJYmLwezoTfgvch18E
dfCzoAl+gT1anK3ZSvwl0AoPQBu+Zm+xRej1+N5gq+C8L8Cjb6AfBbZGa++i
OwI7Q2e1oLvZ/wD+ffingjz0DGo8hXz/hPavtew3SOwJbMkU+6er6JfsUUh8
JzGv4OfAbHzt6GfwOayfGLWejUdnhharM3RWDugObI9seADOwK9ji8Kng9fw
UmzT4BFvuemfXsDTyScTHeGMSfjPq38Ry6Ee3gHSiK1GP4G3kvM8eCvoQvej
D0Wsx+r1gtB6kcSWgz/DWy2HsM3FV4ye4GwYv6MHYsY1U9/QveBz1P75Ob6S
0HqlnEbQ+XHLpZQ1BfD5oZ01Dl8dOh99PGI1Vq1lk08z3sf3qbfaagY1i++8
1UY1fA+vZv3BqP2z/r0rZrkrJ+W2CiyDZ7NmO/5K9G/23kPMTvhHb7OsGf4E
fwsKnM14HzyXmD54lWYEXoPtsbM9DsNLvM2KaqRa3QGXA+tpg2rlrfaawQzW
n/J291LBSXhR3GZxP6jCv1fzDL+NvxG+2lusZlazWxba7CtH5boybrVVTrno
Wfj7iT+KngkvCO0uqgaF8Ife9tadeaBee7u7PdgGvb0xemu0xxi8J2Z3V3dW
d7fd26zqjuquDnmrTS+2r/BRb2+JavATPuwtF9UwCd8FKgKbYc2yeqLeJJST
7mdos62ZbdZ8+v8+sFSzE1qtNMPD6r23Xqpmqt2VmL11ehP1Nv4DCVuyjA==

         "]]}]}}, {{}, 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVz0krhWEYBuAHHYSsDCvK2o5jKH6BYYGFjaGUKTJsZPgVppQ6Jc5ZOOqg
2KD4BdaKjTFssGHJZXF138/zvuc731c3Mts7kxcR4/QnIjqKIlaLI/b1lJ6V
Q+ZhOs1ddDNVGDFNE23mpGyX87Lc3Qq9kgxpcp5z7exXVplDr5Zn5l19jzQD
doPc6ndkOWDNvVGe9RdyHLJpN8mb/s4rix5/JI/ZdjbHt/7DCaek7BbI918F
nNtdsGM3YR4nwY350v6KpLlWNsga2Si3fOudO4/6E6WU0MyYOxus/78/9fSQ
cX/F+TJ9fr8kP/ng3tmXfJBlspUW/gDREjjq
         "]], 
        LineBox[{2188, 106, 1771, 1773, 1772, 2092, 1828, 1829, 1774, 1776, 
         1775, 2095, 1832, 1833, 1784, 1786, 1785, 2101, 1552, 1837, 2196, 
         1485, 2010, 1486, 1840, 1559, 1839, 1897, 1798, 1497, 1729, 1730, 
         1441, 1402, 1664, 1904, 1903, 1681, 1571, 1667, 1666, 1573, 2121, 
         2123, 2122, 1502, 1733, 1734, 1735, 1916, 1415}], 
        LineBox[{1805, 1806, 1736, 1448, 1687, 1688, 2036, 2037, 2034, 1507, 
         2035, 1620, 1621, 1515, 1809, 1514, 2046, 1417, 1368, 1737, 1738, 
         1689, 1690, 1691, 1878, 2063, 1524, 1877, 1455, 1958, 1456, 1743, 
         1537, 2070, 1816, 1817, 1745, 1747, 1746, 2077, 1821, 1822, 1757, 
         1759, 1758, 2083, 1826, 1827, 1767, 2188}]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVzr8rxHEcx/EPxd3mTMQgkoGSyaJDIVY3kMhgMJzcdRaO6UodNzCILmGw
UCY//gNnotyAgRUTIwviYXj2fL9e7/fn27d5Jp1IVYQQ0khUoTqEUe6PhNCH
Z/Mnj+hj/CrX8AuP6U44REN451/9GxcwgWv7G+xhHwcYdxNz/2Ff5CP51HzM
Z1x2U4k6uwZdI+7kB9yjSZ7kKUTR4i7CW97O4tz+AnmsYUeXRMl8hQ1soqib
x7S3GV71nR7zMrLoktvddeBL/sE3uvW13KnfNt96+2Quc1zeRb19UjeHCB7t
LnUlHJpXkDPneME+gwE55W0r5zGIuH6Ie7nt/9/sh3mRs1jCulzAH69QOl4=

         "]], LineBox[CompressedData["
1:eJwV0EsrBGAYhuFvymkGKYcVGwuEGlEWrFihFGaBSEooCilj5g+QlbJRSo3D
Ags/gHJeK6cSNlixtibXLO7u533e95uZpnpiITEfCSEsYi03hAPE80IYKgih
iYf5XZfKD2FLbtAlOG3ul/swYK7npG4Zq+6nzK1yAaL4xAfe7DbdN8uVbjrk
Ku7kcz7Ds5sc+ylMI2M+1Z8gYg5I6rbRqyvBivdL5nE5Lj+6ecIdHnCPRv01
3+ACV7hEnX7Mu1qOcQ0XchopTPrcDRzJh3jFC0a9HcGuvINM9je6q/D+j8v5
l2/1x7zndh9lKEWx/ZxdLPt9iOLHXRF/86xdj7s2tMjt/KUfy/5/5i5zNwZ1
M+Z1/APcqTb0
         "]]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVzzkvRFEYBuAzjKVFQyKWRFCMgobOUkgoSCgsiUbP2COxjIKQEIQG/0Cj
EVuorZVKdPgBBImxx6N48n7n/c69N7e4N97WHwkhjBFLD2GJRSYzQ5higgTT
lOlH5RgjNDovMGAeJM4wQxTqE9EQ+sx15lnmqGVeN5nmneZxuZURwiYbXDvX
2OfYVcts+cuV/tb+Uq7rY+YqWcmL/SvPlOlLqdBf/N/nlHPOKNcfyiP2OGCf
Ev295x+4o1hXRMH/v3CjO/HtHd2xXNPlm1P1ueaozJMzugS77mzLHrnMG1n2
SdnlbidR50fnVPkk02SzPiJTaPF8K912HfpP8xcf/PBNkz4p36mngXb32/Wr
rPAHPdk+xA==
         "]], LineBox[CompressedData["
1:eJwV0LsvQ2EYB+DP4DKTmCxMFomRRBhcB9cqcYuhdSmpVlKD0WKikyJidFt0
IdEu9RcIE7FIJSR2Yebp8OT3fb/3PTknpzmWjqSqQgjbtNeEkGWVaHUIfbUh
9DJXF8IsX7p5uUC/foApXcL+gpxwH2fFfJlv3apMENFPEiVtf5NO1sw65LrM
yHrZQN5ewfPXsiibdNXmM+6zvDqX9BfykisW9XHdh/Mn1+TJVb6Rkvk9+2Q5
1iV5dH7igBwnujQ/nv3lhltOdRlidv7cH5zvZIEiS5X30+jc5XufzcvuL/Jd
9ui6iZvv6PacW5xHOXNP2dkgyZDZIG/6ETnKMK12z3W7bNnLVP65foyybkpO
E6Wt8m90R/KQf6x2P+k=
         "]]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwl0jlMVGEUhuHfwhlI1EoLoZFSW4xEXBLXxthQaiIMklhAxsS4hCCggET2
0QQsNKitmoBGLIC4KxqlcUELtVPcg52Chc+JxZv3fOece+fOf29Z7cGq/KKU
0hguZlNqRrYopd7FKRXxJfkyWlAj9+nnOJ9JqRy16jrsxy+zCr2Ceh0fwoJe
v/yXb+Gk+7ShHdXy4bgHt9upVB/FEaySy3Dd3h3zUb7LN7jYfJLvyxP8gFfb
XaJfLefiWbFUXqP/yPy5/JineZn+G34iz/BTfstr7ZajxjyHFdggL+dhO8fw
wd4rPs8XUGI2YGdl/A+0mnXHs6t3Y4d6J7ZiO7bFeel32Pvh+p/4iu/4Fuei
/5m/4CNm8SnOTL/TdS3cFfeLM8IWnJab9VvVjbEnb1a/VL9z7Qt+z5X662PX
rIE3cj1v4uNoindm95zdIQxiSn7NeT7LZ1DAQ/kZ13MPd6ML9+RxPhDPwafQ
gdvySLwbLmCX38qgLc5b3qMuUZfiqr0xvSt8k+fju9HfxwP4jT75D1/DHE7I
e+NZkFEPZ/9/z/8AqXRkPw==
         "]]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], {}, {}}}],
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{-4, 4}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.545617328399762*^9, 3.5456173861978636`*^9}, 
   3.545617566128579*^9, {3.5456178186618233`*^9, 3.545617900499567*^9}, 
   3.545617932417223*^9, 3.5777828248616*^9, 3.5777829107864*^9, 
   3.5777829631722*^9, {3.5777831071602*^9, 3.5777831380550003`*^9}, {
   3.5777832103454*^9, 3.5777832386594*^9}, 3.60911556494733*^9, 
   3.656357309961537*^9, 3.656357355258143*^9, {3.656357394052951*^9, 
   3.6563574091575317`*^9}, {3.656358110031333*^9, 3.656358117650107*^9}, {
   3.656364066976273*^9, 3.656364086096344*^9}, 
   3.656430563886596*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"4e1f3ae6-e0f8-4e99-aa1f-b26907411a97"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJyFnQm4jlX3/4/jzCMpkkQIZSqp9IZ7JxmikuaigRSaRLxJIk0nEYqURKIM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    "], {{
      {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmFtsVWUWx3c5e5991Jk3fRjnRYhg8GUeCphxvGQK1ERjIiC+mNgLNZrM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          "]], PolygonBox[CompressedData["
1:eJwllEtsjGEUhr/pzPf/vwQrG7XRxCVjYzG0IUIoFmxkFl2Q6ChJJWQajUuE
calqtDqMEZdEU7eFCEmliU1LaV2qF5FIqQ0RrVtcYtNEsfC8OYuTOe933nO+
7z/nPVNWU5fOljjn0lgCe+id64vzi90JnbsLXhxzrhO7BV4eOFeLfx1yU+Tc
FHAqYTmdxDfDT1HnImdHiZ/CBvErOPvr7Uwx1fwDfoyNkHsJK5DfCp4HtwEc
wn0KfoP/GhsmvgW8gXgPuEOY+8epVeQsg19Dzi7qzwenwDvgZ53dMQR/AfFR
1SJnGvEj4CL8heBfcNdz1hWzOwrgt+SMxeybX4K/ge8Rm6TGd/wi1oaf4yxL
vMfb21qxRmJrqV9F/Sz5a/CnU39Fwr7puWphg3HroXqZ9/b2Rs4ykdVQrTx2
HH8jnHSJvTHjbSaaTZL8WZH1SL3SNz4hfgF8Te+hZj24Es59Z29ajd8UWu1q
zmqJP8KGwANYN7GlcNYlrAfqRU53wr3B2YnIcpTbD7+L+AB4HP+DZgZORTYb
nS3CP8bZHN5fTr0G/BbOblOrA85hcpvBN8Hd4EPgssB6J464MwPjDoNPg8sD
09YLcAG8j5yP8Cu5ox3/n7e7pEFpcQ/8Kvhzie/Fn/Q2+37ieeJlWG/cOLPx
l8FJwt2N7QTnAvPVkyXgrVhbzDS3LbI7dbc0OUN69HZXnWqADwQ2C9U8GNgO
aZfU0/1wf4amLc3oB/7V0LSgnbiC/xWbiJsGv+A3S4Pgs1gL/qfQeifO59C+
Sd+mnfztbce0a9LsmdBmrFlLg33eZqbZjWHPvP0H6L9APXkAnhrY7kgjSWpv
0vc52yHtkjQhbUzAWQn3cmi7LE47/qrAYpqxZj1C/vaYzewd8ZOhfYt2Vrt7
Tj2Im4bP45dGpnXtgHah15v21AP1QjuoXXwPfhVaz9V7aa5aXG8x1VRtaUha
0htKA9OQtKSZVoBHQ+uFdla7+x8qCrv5
          "]]}]}, 
      {RGBColor[0.5237980769230769, 0.48778846153846156`, 0.5111538461538462],
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mXnUlVUVxu99730H19JMLcUyxWQpVpQ4pAiCKeKEQ44fYCRoaipiMqmA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          "]], PolygonBox[CompressedData["
1:eJwtl2dwVVUUhV+59577Q0cBxY7gOIqKBcUSBRQCQXooCiEaktgQNEQCQSWh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          "]]}]}, 
      {RGBColor[0.7946634615384616, 0.5829807692307692, 0.3519230769230769], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXv0llWVx9/f+z43wTuaAi4RRy7eUFERbfACGmDKVS1QbIl5QxER0Z+a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          "]], PolygonBox[CompressedData["
1:eJwtlwuQz1UUx3//x+93f2ubsIisaa2EGPIodnqwbbFIu3YXrbWYdj1X3qxH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          "]]}]}, 
      {RGBColor[0.9264423076923077, 0.6861057692307692, 0.37197115384615376`],
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmwVcURxu+95545RzZREVFADYvbk+UhWCJqIDGR3SWCJoBJKYK4BitG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          "]], PolygonBox[CompressedData["
1:eJwtl3mwz1UYxn/b95xfV7Yml+i2ScoVUZQsudNCaCFLhWrIkkS3ERdNk8yk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          "]]}]}, 
      {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lltsVVUQhvc+PWfvUi4tl1MoUEi5JF5ARCGAFn3yQcEHJWgCookJKqYR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          "]], PolygonBox[CompressedData["
1:eJwtlEtIVVEUhvc917vPxUSKHiaocCuhgqDoQUTWqEFqg1IhMhOCXiRZNAhL
etigmpU9LEPI1B5EWlGTEHpRWpBhDTKTAq0oMbyUGQk9vp/V4Of8/1pr773O
WmvvxMbKNTsC51wxSAEL486tgNTBf3nnBkLndkecGyXoA7wTWw16DJ2OTg3N
lxV1bhH8B/gLzyJmJDSbfGXEbGbtTdAEP8L+9THn0vBPRieIWQxfi205fAm2
Y/BrxDfA1xFfi25DN6K3oU+jN5BvgrPyWFMO38Iem+BJYmLwezoTfgvch18E
dfCzoAl+gT1anK3ZSvwl0AoPQBu+Zm+xRej1+N5gq+C8L8Cjb6AfBbZGa++i
OwI7Q2e1oLvZ/wD+ffingjz0DGo8hXz/hPavtew3SOwJbMkU+6er6JfsUUh8
JzGv4OfAbHzt6GfwOayfGLWejUdnhharM3RWDugObI9seADOwK9ji8Kng9fw
UmzT4BFvuemfXsDTyScTHeGMSfjPq38Ry6Ee3gHSiK1GP4G3kvM8eCvoQvej
D0Wsx+r1gtB6kcSWgz/DWy2HsM3FV4ye4GwYv6MHYsY1U9/QveBz1P75Ob6S
0HqlnEbQ+XHLpZQ1BfD5oZ01Dl8dOh99PGI1Vq1lk08z3sf3qbfaagY1i++8
1UY1fA+vZv3BqP2z/r0rZrkrJ+W2CiyDZ7NmO/5K9G/23kPMTvhHb7OsGf4E
fwsKnM14HzyXmD54lWYEXoPtsbM9DsNLvM2KaqRa3QGXA+tpg2rlrfaawQzW
n/J291LBSXhR3GZxP6jCv1fzDL+NvxG+2lusZlazWxba7CtH5boybrVVTrno
Wfj7iT+KngkvCO0uqgaF8Ife9tadeaBee7u7PdgGvb0xemu0xxi8J2Z3V3dW
d7fd26zqjuquDnmrTS+2r/BRb2+JavATPuwtF9UwCd8FKgKbYc2yeqLeJJST
7mdos62ZbdZ8+v8+sFSzE1qtNMPD6r23Xqpmqt2VmL11ehP1Nv4DCVuyjA==

          "]]}]}}, {{}, 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVz0krhWEYBuAHHYSsDCvK2o5jKH6BYYGFjaGUKTJsZPgVppQ6Jc5ZOOqg
2KD4BdaKjTFssGHJZXF138/zvuc731c3Mts7kxcR4/QnIjqKIlaLI/b1lJ6V
Q+ZhOs1ddDNVGDFNE23mpGyX87Lc3Qq9kgxpcp5z7exXVplDr5Zn5l19jzQD
doPc6ndkOWDNvVGe9RdyHLJpN8mb/s4rix5/JI/ZdjbHt/7DCaek7BbI918F
nNtdsGM3YR4nwY350v6KpLlWNsga2Si3fOudO4/6E6WU0MyYOxus/78/9fSQ
cX/F+TJ9fr8kP/ng3tmXfJBlspUW/gDREjjq
          "]], 
         LineBox[{2188, 106, 1771, 1773, 1772, 2092, 1828, 1829, 1774, 1776, 
          1775, 2095, 1832, 1833, 1784, 1786, 1785, 2101, 1552, 1837, 2196, 
          1485, 2010, 1486, 1840, 1559, 1839, 1897, 1798, 1497, 1729, 1730, 
          1441, 1402, 1664, 1904, 1903, 1681, 1571, 1667, 1666, 1573, 2121, 
          2123, 2122, 1502, 1733, 1734, 1735, 1916, 1415}], 
         LineBox[{1805, 1806, 1736, 1448, 1687, 1688, 2036, 2037, 2034, 1507, 
          2035, 1620, 1621, 1515, 1809, 1514, 2046, 1417, 1368, 1737, 1738, 
          1689, 1690, 1691, 1878, 2063, 1524, 1877, 1455, 1958, 1456, 1743, 
          1537, 2070, 1816, 1817, 1745, 1747, 1746, 2077, 1821, 1822, 1757, 
          1759, 1758, 2083, 1826, 1827, 1767, 2188}]},
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVzr8rxHEcx/EPxd3mTMQgkoGSyaJDIVY3kMhgMJzcdRaO6UodNzCILmGw
UCY//gNnotyAgRUTIwviYXj2fL9e7/fn27d5Jp1IVYQQ0khUoTqEUe6PhNCH
Z/Mnj+hj/CrX8AuP6U44REN451/9GxcwgWv7G+xhHwcYdxNz/2Ff5CP51HzM
Z1x2U4k6uwZdI+7kB9yjSZ7kKUTR4i7CW97O4tz+AnmsYUeXRMl8hQ1soqib
x7S3GV71nR7zMrLoktvddeBL/sE3uvW13KnfNt96+2Quc1zeRb19UjeHCB7t
LnUlHJpXkDPneME+gwE55W0r5zGIuH6Ie7nt/9/sh3mRs1jCulzAH69QOl4=

          "]], LineBox[CompressedData["
1:eJwV0EsrBGAYhuFvymkGKYcVGwuEGlEWrFihFGaBSEooCilj5g+QlbJRSo3D
Ags/gHJeK6cSNlixtibXLO7u533e95uZpnpiITEfCSEsYi03hAPE80IYKgih
iYf5XZfKD2FLbtAlOG3ul/swYK7npG4Zq+6nzK1yAaL4xAfe7DbdN8uVbjrk
Ku7kcz7Ds5sc+ylMI2M+1Z8gYg5I6rbRqyvBivdL5nE5Lj+6ecIdHnCPRv01
3+ACV7hEnX7Mu1qOcQ0XchopTPrcDRzJh3jFC0a9HcGuvINM9je6q/D+j8v5
l2/1x7zndh9lKEWx/ZxdLPt9iOLHXRF/86xdj7s2tMjt/KUfy/5/5i5zNwZ1
M+Z1/APcqTb0
          "]]},
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVzzkvRFEYBuAzjKVFQyKWRFCMgobOUkgoSCgsiUbP2COxjIKQEIQG/0Cj
EVuorZVKdPgBBImxx6N48n7n/c69N7e4N97WHwkhjBFLD2GJRSYzQ5higgTT
lOlH5RgjNDovMGAeJM4wQxTqE9EQ+sx15lnmqGVeN5nmneZxuZURwiYbXDvX
2OfYVcts+cuV/tb+Uq7rY+YqWcmL/SvPlOlLqdBf/N/nlHPOKNcfyiP2OGCf
Ev295x+4o1hXRMH/v3CjO/HtHd2xXNPlm1P1ueaozJMzugS77mzLHrnMG1n2
SdnlbidR50fnVPkk02SzPiJTaPF8K912HfpP8xcf/PBNkz4p36mngXb32/Wr
rPAHPdk+xA==
          "]], LineBox[CompressedData["
1:eJwV0LsvQ2EYB+DP4DKTmCxMFomRRBhcB9cqcYuhdSmpVlKD0WKikyJidFt0
IdEu9RcIE7FIJSR2Yebp8OT3fb/3PTknpzmWjqSqQgjbtNeEkGWVaHUIfbUh
9DJXF8IsX7p5uUC/foApXcL+gpxwH2fFfJlv3apMENFPEiVtf5NO1sw65LrM
yHrZQN5ewfPXsiibdNXmM+6zvDqX9BfykisW9XHdh/Mn1+TJVb6Rkvk9+2Q5
1iV5dH7igBwnujQ/nv3lhltOdRlidv7cH5zvZIEiS5X30+jc5XufzcvuL/Jd
9ui6iZvv6PacW5xHOXNP2dkgyZDZIG/6ETnKMK12z3W7bNnLVP65foyybkpO
E6Wt8m90R/KQf6x2P+k=
          "]]},
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwl0jlMVGEUhuHfwhlI1EoLoZFSW4xEXBLXxthQaiIMklhAxsS4hCCggET2
0QQsNKitmoBGLIC4KxqlcUELtVPcg52Chc+JxZv3fOece+fOf29Z7cGq/KKU
0hguZlNqRrYopd7FKRXxJfkyWlAj9+nnOJ9JqRy16jrsxy+zCr2Ceh0fwoJe
v/yXb+Gk+7ShHdXy4bgHt9upVB/FEaySy3Dd3h3zUb7LN7jYfJLvyxP8gFfb
XaJfLefiWbFUXqP/yPy5/JineZn+G34iz/BTfstr7ZajxjyHFdggL+dhO8fw
wd4rPs8XUGI2YGdl/A+0mnXHs6t3Y4d6J7ZiO7bFeel32Pvh+p/4iu/4Fuei
/5m/4CNm8SnOTL/TdS3cFfeLM8IWnJab9VvVjbEnb1a/VL9z7Qt+z5X662PX
rIE3cj1v4uNoindm95zdIQxiSn7NeT7LZ1DAQ/kZ13MPd6ML9+RxPhDPwafQ
gdvySLwbLmCX38qgLc5b3qMuUZfiqr0xvSt8k+fju9HfxwP4jT75D1/DHE7I
e+NZkFEPZ/9/z/8AqXRkPw==
          "]]},
        "1"],
       Annotation[#, 1, "Tooltip"]& ], {}, {}}}], {{}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.04587368524026634, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -3.835895278030231}, \
{-4.36923562443198, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.044858698282982175`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -3.287910238311627}, \
{-4.36923562443198, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.04398157175864748, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -2.739925198593023}, \
{-4.36923562443198, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.04325069393287603, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -2.1919401588744187`}, \
{-4.36923562443198, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.04267357994809448, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -1.6439551191558142`}, \
{-4.36923562443198, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.04225653031301002, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -1.0959700794372098`}, \
{-4.36923562443198, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.04200431300710784, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -0.5479850397186052}, \
{-4.36923562443198, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.041919903350326, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, -8.517398515440158*^-16}, \
{-4.36923562443198, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.04200431300710784, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, 
        0.5479850397186036}, {-4.36923562443198, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.04225653031301002, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, 
        1.095970079437208}, {-4.36923562443198, 1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.04267357994809448, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, 
        1.6439551191558124`}, {-4.36923562443198, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.043250693932876026`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, 
        2.191940158874417}, {-4.36923562443198, 2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.04398157175864748, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, 
        2.739925198593021}, {-4.36923562443198, 2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.044858698282982175`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, 
        3.287910238311625}, {-4.36923562443198, 3.569232618831229}}]}}, 
     {Arrowheads[{{0.04587368524026631, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.6307643755680203`, 3.83589527803023}, {-4.36923562443198,
         4.164104721969767}}]}}, 
     {Arrowheads[{{0.04047441545604541, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.1120837504868746`, -3.835895278030231}, \
{-3.745059106655983, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.03932030163451397, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, -3.287910238311627}, \
{-3.7450591066559826`, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.038316601667509505`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, -2.739925198593023}, \
{-3.7450591066559826`, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.03747540306201995, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, -2.1919401588744187`}, \
{-3.7450591066559826`, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.036807848817500134`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, -1.6439551191558142`}, \
{-3.7450591066559826`, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.036323513914265956`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.1120837504868746`, -1.0959700794372098`}, \
{-3.745059106655983, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.036029787956420485`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, -0.5479850397186052}, \
{-3.7450591066559826`, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.035931345728850886`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.1120837504868746`, -8.517398515440158*^-16}, \
{-3.745059106655983, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.036029787956420485`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, 
        0.5479850397186036}, {-3.7450591066559826`, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.036323513914265956`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.1120837504868746`, 
        1.095970079437208}, {-3.745059106655983, 1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.036807848817500134`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, 
        1.6439551191558124`}, {-3.7450591066559826`, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.037475403062019984`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.1120837504868746`, 
        2.191940158874417}, {-3.745059106655983, 2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.038316601667509505`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, 
        2.739925198593021}, {-3.7450591066559826`, 2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.039320301634513964`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, 
        3.287910238311625}, {-3.7450591066559826`, 3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.04047441545604533, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.112083750486875, 
        3.83589527803023}, {-3.7450591066559826`, 4.164104721969767}}]}}, 
     {Arrowheads[{{0.03526595043757587, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -3.835895278030231}, \
{-3.120882588879986, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.033935159855025814`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -3.287910238311627}, \
{-3.120882588879986, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.032766918028761666`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -2.739925198593023}, \
{-3.120882588879986, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.031779156508910805`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -2.1919401588744187`}, \
{-3.120882588879986, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.03098913823146652, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -1.6439551191558142`}, \
{-3.120882588879986, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.03041227740299734, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -1.0959700794372098`}, \
{-3.120882588879986, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.030060847857996557`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -0.5479850397186052}, \
{-3.120882588879986, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.02994278810737572, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, -8.517398515440158*^-16}, \
{-3.120882588879986, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.030060847857996557`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, 
        0.5479850397186036}, {-3.120882588879986, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.03041227740299734, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, 
        1.095970079437208}, {-3.120882588879986, 1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.030989138231466512`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, 
        1.6439551191558124`}, {-3.120882588879986, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.03177915650891079, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, 
        2.191940158874417}, {-3.120882588879986, 2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.032766918028761666`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, 
        2.739925198593021}, {-3.120882588879986, 2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.033935159855025814`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, 
        3.287910238311625}, {-3.120882588879986, 3.569232618831229}}]}}, 
     {Arrowheads[{{0.03526595043757583, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.5934031254057293`, 
        3.83589527803023}, {-3.120882588879986, 4.164104721969767}}]}}, 
     {Arrowheads[{{0.030346694363538266`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -3.835895278030231}, \
{-2.4967060711039895`, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.02878940209373241, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -3.287910238311627}, \
{-2.4967060711039895`, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.027402655266087518`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -2.739925198593023}, \
{-2.4967060711039895`, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.026213534423009343`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -2.1919401588744187`}, \
{-2.4967060711039895`, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.025249975977362584`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -1.6439551191558142`}, \
{-2.4967060711039895`, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.02453856587833345, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -1.0959700794372098`}, \
{-2.4967060711039895`, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.024101642526393595`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -0.5479850397186052}, \
{-2.4967060711039895`, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.02395423048590058, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, -8.517398515440158*^-16}, \
{-2.4967060711039895`, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.024101642526393595`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, 
        0.5479850397186036}, {-2.4967060711039895`, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.024538565878333442`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, 
        1.095970079437208}, {-2.4967060711039895`, 1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.025249975977362577`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, 
        1.6439551191558124`}, {-2.4967060711039895`, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.02621353442300933, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, 
        2.191940158874417}, {-2.4967060711039895`, 2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.027402655266087518`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, 
        2.739925198593021}, {-2.4967060711039895`, 2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.02878940209373239, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, 
        3.287910238311625}, {-2.4967060711039895`, 3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.030346694363538224`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.074722500324584, 
        3.83589527803023}, {-2.4967060711039895`, 4.164104721969767}}]}}, 
     {Arrowheads[{{0.02588208071415258, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -3.835895278030231}, \
{-1.872529553327992, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.02403726099651346, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -3.287910238311627}, \
{-1.872529553327992, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.022357677851958094`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -2.739925198593023}, \
{-1.872529553327992, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.020883238021106764`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -2.1919401588744187`}, \
{-1.872529553327992, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.019660150817257, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -1.6439551191558142`}, \
{-1.872529553327992, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.018737701531009985`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -1.0959700794372098`}, \
{-1.872529553327992, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.018161756957132964`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -0.5479850397186052}, \
{-1.872529553327992, -0.5948721031385393}}]}}, 
     {Arrowheads[{{0.01796567286442543, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, -8.517398515440158*^-16}, \
{-1.872529553327992, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.018161756957132964`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, 
        0.5479850397186036}, {-1.872529553327992, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.01873770153100998, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, 1.095970079437208}, {-1.872529553327992,
         1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.019660150817256992`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, 
        1.6439551191558124`}, {-1.872529553327992, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.02088323802110675, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, 2.191940158874417}, {-1.872529553327992,
         2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.022357677851958094`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, 2.739925198593021}, {-1.872529553327992,
         2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.024037260996513442`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, 3.287910238311625}, {-1.872529553327992,
         3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.025882080714152524`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.556041875243438, 3.83589527803023}, {-1.872529553327992, 
        4.164104721969767}}]}}, 
     {Arrowheads[{{0.02214876949551078, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -3.835895278030231}, \
{-1.248353035551995, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.019961858738250484`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -3.287910238311627}, \
{-1.248353035551995, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.017903956183014342`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -2.739925198593023}, \
{-1.248353035551995, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.016024840664342316`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -2.1919401588744187`}, \
{-1.248353035551995, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.014394701046866205`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -1.6439551191558142`}, \
{-1.248353035551995, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.013106767211504671`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -1.0959700794372098`}, \
{-1.248353035551995, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.012269282939166725`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -0.5479850397186052}, \
{-1.248353035551995, -0.5948721031385393}}]}}, 
     {Arrowheads[{{0.01197711524295029, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, -8.517398515440158*^-16}, \
{-1.248353035551995, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.012269282939166721`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, 
        0.5479850397186036}, {-1.248353035551995, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.013106767211504665`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, 
        1.095970079437208}, {-1.248353035551995, 1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.014394701046866194`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, 
        1.6439551191558124`}, {-1.248353035551995, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.0160248406643423, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, 
        2.191940158874417}, {-1.248353035551995, 2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.01790395618301433, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622924`, 
        2.739925198593021}, {-1.248353035551995, 2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.019961858738250463`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, 
        3.287910238311625}, {-1.248353035551995, 3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.022148769495510718`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.0373612501622922`, 
        3.83589527803023}, {-1.248353035551995, 4.164104721969767}}]}}, 
     {Arrowheads[{{0.019569862621083595`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -3.835895278030231}, \
{-0.624176517775998, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.017055419582311163`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -3.287910238311627}, \
{-0.624176517775998, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.014593258027120377`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -2.739925198593023}, \
{-0.624176517775998, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.012215033817406115`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -2.1919401588744187`}, \
{-0.624176517775998, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.009980929369125245, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -1.6439551191558142`}, \
{-0.624176517775998, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.008012420332171161, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -1.0959700794372098`}, \
{-0.624176517775998, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.006553383605752341, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -0.5479850397186052}, \
{-0.624176517775998, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.005988557621475151, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, -8.517398515440158*^-16}, \
{-0.624176517775998, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.0065533836057523375`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, 
        0.5479850397186036}, {-0.624176517775998, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.008012420332171154, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, 
        1.095970079437208}, {-0.624176517775998, 1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.009980929369125235, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, 
        1.6439551191558124`}, {-0.624176517775998, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.012215033817406091`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, 
        2.191940158874417}, {-0.624176517775998, 2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.014593258027120377`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, 
        2.739925198593021}, {-0.624176517775998, 2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.017055419582311142`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, 
        3.287910238311625}, {-0.624176517775998, 3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.019569862621083522`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-0.5186806250811465, 3.83589527803023}, {-0.624176517775998,
         4.164104721969767}}]}}, 
     {Arrowheads[{{0.018631068155700484`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, -3.835895278030231}, \
{-9.701651980513714*^-16, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.015969486990600388`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, -3.287910238311627}, \
{-9.701651980513714*^-16, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.013307905825500314`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, -2.739925198593023}, \
{-9.701651980513714*^-16, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.010646324660400266`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, -2.1919401588744187`}, \
{-9.701651980513714*^-16, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.007984743495300194, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, -1.6439551191558142`}, \
{-9.701651980513714*^-16, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.005323162330200133, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, -1.0959700794372098`}, \
{-9.701651980513714*^-16, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.0026615811651000665`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, -0.5479850397186052}, \
{-9.701651980513714*^-16, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.0026615811651000605`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, 
        0.5479850397186036}, {-9.701651980513714*^-16, 
        0.5948721031385374}}]}}, 
     {Arrowheads[{{0.005323162330200121, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, 
        1.095970079437208}, {-9.701651980513714*^-16, 
        1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.007984743495300182, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, 
        1.6439551191558124`}, {-9.701651980513714*^-16, 
        1.784616309415614}}]}}, 
     {Arrowheads[{{0.010646324660400242`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, 
        2.191940158874417}, {-9.701651980513714*^-16, 
        2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.013307905825500314`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, 
        2.739925198593021}, {-9.701651980513714*^-16, 
        2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.015969486990600364`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, 
        3.287910238311625}, {-9.701651980513714*^-16, 
        3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.018631068155700408`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.061916413488791*^-16, 
        3.83589527803023}, {-9.701651980513714*^-16, 4.164104721969767}}]}}, 
     {Arrowheads[{{0.019569862621083588`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, -3.835895278030231}, {
        0.6241765177759961, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.017055419582311156`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.518680625081145, -3.287910238311627}, {
        0.6241765177759961, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.01459325802712037, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, -2.739925198593023}, {
        0.6241765177759961, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.012215033817406108`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, -2.1919401588744187`}, {
        0.6241765177759961, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.009980929369125239, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, -1.6439551191558142`}, {
        0.6241765177759961, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.008012420332171153, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, -1.0959700794372098`}, {
        0.6241765177759961, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.006553383605752324, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.518680625081145, -0.5479850397186052}, {
        0.6241765177759961, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.005988557621475139, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, -8.517398515440158*^-16}, {
        0.6241765177759961, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.006553383605752327, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, 0.5479850397186036}, {
        0.6241765177759961, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.008012420332171144, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, 1.095970079437208}, {0.6241765177759961,
         1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.009980929369125225, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, 1.6439551191558124`}, {
        0.624176517775996, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.012215033817406086`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.5186806250811449, 2.191940158874417}, {0.6241765177759961,
         2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.01459325802712037, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.518680625081145, 2.739925198593021}, {0.6241765177759961, 
        2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.017055419582311136`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.518680625081145, 3.287910238311625}, {0.6241765177759961, 
        3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.019569862621083515`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{0.518680625081145, 3.83589527803023}, {0.6241765177759961, 
        4.164104721969767}}]}}, 
     {Arrowheads[{{0.022148769495510773`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -3.835895278030231}, {
        1.2483530355519932`, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.019961858738250477`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -3.287910238311627}, {
        1.2483530355519932`, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.01790395618301433, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -2.739925198593023}, {
        1.2483530355519932`, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.016024840664342305`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -2.1919401588744187`}, {
        1.2483530355519932`, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.014394701046866193`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -1.6439551191558142`}, {
        1.2483530355519932`, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.013106767211504658`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -1.0959700794372098`}, {
        1.2483530355519932`, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.01226928293916671, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -0.5479850397186052}, {
        1.2483530355519932`, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.011977115242950278`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, -8.517398515440158*^-16}, {
        1.2483530355519932`, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.012269282939166709`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, 0.5479850397186036}, {
        1.2483530355519932`, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.013106767211504654`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, 1.095970079437208}, {
        1.2483530355519932`, 1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.014394701046866186`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, 1.6439551191558124`}, {
        1.2483530355519932`, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.016024840664342288`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, 2.191940158874417}, {
        1.2483530355519932`, 2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.01790395618301433, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, 2.739925198593021}, {
        1.2483530355519932`, 2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.019961858738250456`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, 3.287910238311625}, {
        1.2483530355519932`, 3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.02214876949551071, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.0373612501622906`, 3.83589527803023}, {
        1.2483530355519932`, 4.164104721969767}}]}}, 
     {Arrowheads[{{0.025882080714152562`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -3.835895278030231}, {
        1.87252955332799, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.02403726099651344, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -3.287910238311627}, {
        1.87252955332799, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.022357677851958073`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -2.739925198593023}, {
        1.87252955332799, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.02088323802110674, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -2.1919401588744187`}, {
        1.87252955332799, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.01966015081725697, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -1.6439551191558142`}, {
        1.87252955332799, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.01873770153100996, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -1.0959700794372098`}, {
        1.87252955332799, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.01816175695713294, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -0.5479850397186052}, {
        1.87252955332799, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.017965672864425405`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, -8.517398515440158*^-16}, {
        1.87252955332799, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.018161756957132937`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, 0.5479850397186036}, {1.87252955332799,
         0.5948721031385374}}]}}, 
     {Arrowheads[{{0.018737701531009957`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, 1.095970079437208}, {1.87252955332799, 
        1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.019660150817256968`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, 1.6439551191558124`}, {
        1.87252955332799, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.020883238021106726`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, 2.191940158874417}, {1.87252955332799, 
        2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.022357677851958073`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, 2.739925198593021}, {1.87252955332799, 
        2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.02403726099651342, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, 3.287910238311625}, {1.87252955332799, 
        3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.025882080714152506`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.5560418752434364`, 3.83589527803023}, {1.87252955332799, 
        4.164104721969767}}]}}, 
     {Arrowheads[{{0.030346694363538256`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -3.835895278030231}, {
        2.4967060711039872`, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.028789402093732385`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -3.287910238311627}, {
        2.4967060711039872`, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.027402655266087494`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -2.739925198593023}, {
        2.4967060711039872`, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.026213534423009315`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -2.1919401588744187`}, {
        2.4967060711039872`, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.02524997597736256, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -1.6439551191558142`}, {
        2.4967060711039872`, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.02453856587833342, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -1.0959700794372098`}, {
        2.4967060711039872`, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.02410164252639357, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -0.5479850397186052}, {
        2.4967060711039872`, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.023954230485900556`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, -8.517398515440158*^-16}, {
        2.4967060711039872`, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.02410164252639357, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, 0.5479850397186036}, {
        2.4967060711039872`, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.024538565878333418`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, 1.095970079437208}, {2.4967060711039872`,
         1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.025249975977362553`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, 1.6439551191558124`}, {
        2.4967060711039872`, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.02621353442300931, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, 2.191940158874417}, {2.4967060711039872`,
         2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.027402655266087494`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, 2.739925198593021}, {2.4967060711039872`,
         2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.02878940209373237, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, 3.287910238311625}, {2.4967060711039872`,
         3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.030346694363538203`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.074722500324582, 3.83589527803023}, {2.4967060711039872`, 
        4.164104721969767}}]}}, 
     {Arrowheads[{{0.03526595043757583, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, -3.835895278030231}, {
        3.120882588879984, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.03393515985502577, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, -3.287910238311627}, {
        3.120882588879984, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.03276691802876162, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, -2.739925198593023}, {
        3.120882588879984, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.03177915650891077, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.5934031254057275`, -2.1919401588744187`}, {
        3.120882588879984, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.030989138231466467`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, -1.6439551191558142`}, {
        3.120882588879984, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.03041227740299731, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.5934031254057275`, -1.0959700794372098`}, {
        3.120882588879984, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.030060847857996533`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.5934031254057275`, -0.5479850397186052}, {
        3.120882588879984, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.029942788107375693`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.5934031254057275`, -8.517398515440158*^-16}, {
        3.120882588879984, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.03006084785799651, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, 0.5479850397186036}, {3.120882588879984, 
        0.5948721031385374}}]}}, 
     {Arrowheads[{{0.030412277402997286`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, 1.095970079437208}, {3.120882588879984, 
        1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.03098913823146646, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, 1.6439551191558124`}, {3.120882588879984,
         1.784616309415614}}]}}, 
     {Arrowheads[{{0.03177915650891075, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, 2.191940158874417}, {3.120882588879984, 
        2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.03276691802876164, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.5934031254057275`, 2.739925198593021}, {3.120882588879984,
         2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.03393515985502576, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, 3.287910238311625}, {3.120882588879984, 
        3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.035265950437575785`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.593403125405728, 3.83589527803023}, {3.120882588879984, 
        4.164104721969767}}]}}, 
     {Arrowheads[{{0.04047441545604536, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -3.835895278030231}, {
        3.745059106655981, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.03932030163451397, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -3.287910238311627}, {
        3.745059106655981, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.038316601667509505`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -2.739925198593023}, {
        3.745059106655981, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.03747540306201995, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -2.1919401588744187`}, {
        3.745059106655981, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.036807848817500134`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -1.6439551191558142`}, {
        3.745059106655981, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.03632351391426591, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -1.0959700794372098`}, {
        3.745059106655981, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.036029787956420485`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -0.5479850397186052}, {
        3.745059106655981, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.03593134572885083, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, -8.517398515440158*^-16}, {
        3.745059106655981, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.036029787956420485`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, 0.5479850397186036}, {
        3.745059106655981, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.03632351391426591, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, 1.095970079437208}, {3.745059106655981,
         1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.036807848817500134`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, 1.6439551191558124`}, {
        3.745059106655981, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.03747540306201994, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, 2.191940158874417}, {3.745059106655981,
         2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.038316601667509505`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, 2.739925198593021}, {3.745059106655981,
         2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.039320301634513964`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, 3.287910238311625}, {3.745059106655981,
         3.5692326188312284`}}]}}, 
     {Arrowheads[{{0.04047441545604533, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.1120837504868732`, 3.83589527803023}, {3.745059106655981, 
        4.164104721969767}}]}}, 
     {Arrowheads[{{0.04587368524026634, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -3.835895278030231}, {
        4.369235624431978, -4.164104721969769}}]}}, 
     {Arrowheads[{{0.044858698282982175`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -3.287910238311627}, {
        4.369235624431978, -3.5692326188312307`}}]}}, 
     {Arrowheads[{{0.04398157175864748, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -2.739925198593023}, {
        4.369235624431978, -2.9743605156926924`}}]}}, 
     {Arrowheads[{{0.04325069393287603, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -2.1919401588744187`}, {
        4.369235624431978, -2.3794884125541547`}}]}}, 
     {Arrowheads[{{0.04267357994809448, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -1.6439551191558142`}, {
        4.369235624431978, -1.784616309415616}}]}}, 
     {Arrowheads[{{0.04225653031301002, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -1.0959700794372098`}, {
        4.369235624431978, -1.1897442062770778`}}]}}, 
     {Arrowheads[{{0.04200431300710784, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -0.5479850397186052}, {
        4.369235624431978, -0.5948721031385392}}]}}, 
     {Arrowheads[{{0.041919903350326, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, -8.517398515440158*^-16}, {
        4.369235624431978, -9.246169878562348*^-16}}]}}, 
     {Arrowheads[{{0.04200431300710784, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, 0.5479850397186036}, {
        4.369235624431978, 0.5948721031385374}}]}}, 
     {Arrowheads[{{0.04225653031301002, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, 1.095970079437208}, {4.369235624431978,
         1.1897442062770758`}}]}}, 
     {Arrowheads[{{0.04267357994809448, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, 1.6439551191558124`}, {
        4.369235624431978, 1.784616309415614}}]}}, 
     {Arrowheads[{{0.043250693932876026`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, 2.191940158874417}, {4.369235624431978,
         2.3794884125541524`}}]}}, 
     {Arrowheads[{{0.04398157175864748, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, 2.739925198593021}, {4.369235624431978,
         2.9743605156926907`}}]}}, 
     {Arrowheads[{{0.044858698282982175`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, 3.287910238311625}, {4.369235624431978,
         3.569232618831229}}]}}, 
     {Arrowheads[{{0.04587368524026631, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.6307643755680186`, 3.83589527803023}, {4.369235624431978, 
        4.164104721969767}}]}}}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{-4, 4}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.545617328399762*^9, 3.5456173861978636`*^9}, 
   3.545617566128579*^9, {3.5456178186618233`*^9, 3.545617900499567*^9}, 
   3.545617932417223*^9, 3.5777828248616*^9, 3.5777829107864*^9, 
   3.5777829631722*^9, {3.5777831071602*^9, 3.5777831380550003`*^9}, {
   3.5777832103454*^9, 3.5777832386594*^9}, 3.60911556494733*^9, 
   3.656357309961537*^9, 3.656357355258143*^9, {3.656357394052951*^9, 
   3.6563574091575317`*^9}, {3.656358110031333*^9, 3.656358117650107*^9}, {
   3.656364066976273*^9, 3.656364086096344*^9}, 
   3.656430564026699*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"b331f85e-b363-4d45-8d6e-452a8d7f7571"]
}, Open  ]],

Cell[TextData[{
 StyleBox["1.)",
  FontColor->RGBColor[1, 0, 0]],
 " Hopefully at any point the vectors should appear to be perpendicular to \
the contour lines.  \nIn order for this visual relationship to hold, the \
aspect ratio of the plot needs to be 1:  The number of pixels per ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],ExpressionUUID->
  "942d8fc5-65dc-4341-af59-e1df2de7d00d"],
 " unit and per ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],ExpressionUUID->
  "bb20b92b-89e8-48e2-a46b-acb793a4e540"],
 " unit need to be the same. \[LineSeparator]\[LineSeparator]Replot the \
vector field and contours from the same function above, but with ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],ExpressionUUID->
  "14c0e908-e66b-46f8-9494-d29a16f23f20"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],ExpressionUUID->
  "54cdca3a-ed6c-440d-a841-f7d908843c48"],
 " intervals which are *quite different* from each other.  See if the vectors \
still appear perpendicular to the contours."
}], "Text",
 CellChangeTimes->{{3.6563581799385366`*^9, 3.656358458182705*^9}, {
  3.656358509990416*^9, 3.6563587532459393`*^9}, {3.656371894194461*^9, 
  3.656371917031529*^9}, {3.6563719679205723`*^9, 
  3.656371982574153*^9}},ExpressionUUID->"040618ec-1db7-42d9-9613-\
53942bf36a74"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"p1", "=", 
  RowBox[{"VectorPlot", "[", 
   RowBox[{"myGradf", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "100"}], ",", "100"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"VectorColorFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"Red", "&"}], ")"}]}]}], "]"}]}], "\n", 
 RowBox[{"p2", "=", 
  RowBox[{"ContourPlot", "[", 
   RowBox[{"myf", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "100"}], ",", "100"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{"p2", ",", "p1"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6564306301114087`*^9, 
  3.6564307147112794`*^9}},ExpressionUUID->"2364b908-e62b-41c0-a0cf-\
7fcbc09e4cfd"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
    {Arrowheads[{{0.03335821094834732, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-92.85256023805036, -3.8729344042320064`}, \
{-107.14743976194963`, -4.127065595767994}}]}}, 
    {Arrowheads[{{0.03335681282065341, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-92.85256023805036, -3.3196580607702915`}, \
{-107.14743976194963`, -3.537484796372566}}]}}, 
    {Arrowheads[{{0.033355629743754556`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-92.85256023805036, -2.7663817173085765`}, \
{-107.14743976194963`, -2.947903996977139}}]}}, 
    {Arrowheads[{{0.033354661740534045`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-92.85256023805036, -2.2131053738468616`}, \
{-107.14743976194963`, -2.3583231975817114`}}]}}, 
    {Arrowheads[{{0.0333539088297176, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-92.85256023805036, -1.6598290303851464`}, \
{-107.14743976194963`, -1.7687423981862838`}}]}}, 
    {Arrowheads[{{0.03335337102587156, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-92.85256023805036, -1.1065526869234312`}, \
{-107.14743976194963`, -1.1791615987908561`}}]}}, 
    {Arrowheads[{{0.033353048339401434`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-92.85256023805036, -0.5532763434617161}, \
{-107.14743976194963`, -0.5895807993954285}}]}}, 
    {Arrowheads[{{0.03335294077655096, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-92.85256023805036, -8.599641896882574*^-16}, \
{-107.14743976194963`, -9.163926497119932*^-16}}]}}, 
    {Arrowheads[{{0.033353048339401434`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-92.85256023805036, 
       0.5532763434617143}, {-107.14743976194963`, 0.5895807993954266}}]}}, 
    {Arrowheads[{{0.03335337102587156, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-92.85256023805036, 
       1.1065526869234295`}, {-107.14743976194963`, 1.1791615987908544`}}]}}, 
    {Arrowheads[{{0.0333539088297176, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-92.85256023805036, 
       1.6598290303851446`}, {-107.14743976194963`, 1.7687423981862818`}}]}}, 
    {Arrowheads[{{0.033354661740534045`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-92.85256023805036, 2.21310537384686}, {-107.14743976194963`,
        2.3583231975817096`}}]}}, 
    {Arrowheads[{{0.033355629743754556`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-92.85256023805036, 
       2.7663817173085747`}, {-107.14743976194963`, 2.947903996977137}}]}}, 
    {Arrowheads[{{0.03335681282065341, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-92.85256023805036, 
       3.3196580607702897`}, {-107.14743976194963`, 3.5374847963725644`}}]}}, 
    {Arrowheads[{{0.03335821094834732, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-92.85256023805036, 
       3.8729344042320046`}, {-107.14743976194963`, 4.127065595767992}}]}}, 
    {Arrowheads[{{0.028594383309711993`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-79.58790877547173, -3.8729344042320064`}, \
{-91.84066265309968, -4.127065595767994}}]}}, 
    {Arrowheads[{{0.028592752241440575`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-79.58790877547173, -3.3196580607702915`}, \
{-91.84066265309968, -3.537484796372566}}]}}, 
    {Arrowheads[{{0.02859137203407246, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-79.58790877547173, -2.7663817173085765`}, \
{-91.84066265309968, -2.947903996977139}}]}}, 
    {Arrowheads[{{0.028590242723938893`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-79.58790877547173, -2.2131053738468616`}, \
{-91.84066265309967, -2.3583231975817114`}}]}}, 
    {Arrowheads[{{0.02858936434077209, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-79.58790877547173, -1.6598290303851464`}, \
{-91.84066265309968, -1.7687423981862838`}}]}}, 
    {Arrowheads[{{0.028588736907700998`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-79.58790877547173, -1.1065526869234312`}, \
{-91.84066265309968, -1.1791615987908561`}}]}}, 
    {Arrowheads[{{0.028588360441248562`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-79.58790877547173, -0.5532763434617161}, \
{-91.84066265309968, -0.5895807993954285}}]}}, 
    {Arrowheads[{{0.02858823495132941, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-79.58790877547173, -8.599641896882574*^-16}, \
{-91.84066265309968, -9.163926497119932*^-16}}]}}, 
    {Arrowheads[{{0.028588360441248562`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-79.58790877547173, 0.5532763434617143}, {-91.84066265309968,
        0.5895807993954266}}]}}, 
    {Arrowheads[{{0.028588736907700998`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-79.58790877547173, 
       1.1065526869234295`}, {-91.84066265309968, 1.1791615987908544`}}]}}, 
    {Arrowheads[{{0.02858936434077209, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-79.58790877547173, 
       1.6598290303851446`}, {-91.84066265309968, 1.7687423981862818`}}]}}, 
    {Arrowheads[{{0.028590242723938893`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-79.58790877547173, 2.21310537384686}, {-91.84066265309967, 
       2.3583231975817096`}}]}}, 
    {Arrowheads[{{0.02859137203407246, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-79.58790877547173, 
       2.7663817173085747`}, {-91.84066265309968, 2.947903996977137}}]}}, 
    {Arrowheads[{{0.028592752241440575`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-79.58790877547173, 
       3.3196580607702897`}, {-91.84066265309968, 3.5374847963725644`}}]}}, 
    {Arrowheads[{{0.028594383309711993`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-79.58790877547173, 
       3.8729344042320046`}, {-91.84066265309968, 4.127065595767992}}]}}, 
    {Arrowheads[{{0.023830906807186993`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-66.3232573128931, -3.8729344042320064`}, \
{-76.53388554424973, -4.127065595767994}}]}}, 
    {Arrowheads[{{0.023828949685844335`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-66.3232573128931, -3.3196580607702915`}, \
{-76.53388554424973, -3.537484796372566}}]}}, 
    {Arrowheads[{{0.023827293534533802`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-66.3232573128931, -2.7663817173085765`}, \
{-76.53388554424973, -2.947903996977139}}]}}, 
    {Arrowheads[{{0.023825938416017073`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-66.3232573128931, -2.2131053738468616`}, \
{-76.53388554424973, -2.3583231975817114`}}]}}, 
    {Arrowheads[{{0.023824884381660836`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-66.3232573128931, -1.6598290303851464`}, \
{-76.53388554424973, -1.7687423981862838`}}]}}, 
    {Arrowheads[{{0.023824131471427045`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-66.3232573128931, -1.1065526869234312`}, \
{-76.53388554424973, -1.1791615987908561`}}]}}, 
    {Arrowheads[{{0.02382367971386539, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-66.3232573128931, -0.5532763434617161}, \
{-76.53388554424973, -0.5895807993954285}}]}}, 
    {Arrowheads[{{0.023823529126107832`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-66.3232573128931, -8.599641896882574*^-16}, \
{-76.53388554424973, -9.163926497119932*^-16}}]}}, 
    {Arrowheads[{{0.02382367971386539, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-66.3232573128931, 0.5532763434617143}, {-76.53388554424973, 
       0.5895807993954266}}]}}, 
    {Arrowheads[{{0.023824131471427045`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-66.3232573128931, 1.1065526869234295`}, {-76.53388554424973,
        1.1791615987908544`}}]}}, 
    {Arrowheads[{{0.023824884381660836`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-66.3232573128931, 1.6598290303851446`}, {-76.53388554424973,
        1.768742398186282}}]}}, 
    {Arrowheads[{{0.023825938416017073`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-66.3232573128931, 2.21310537384686}, {-76.53388554424973, 
       2.3583231975817096`}}]}}, 
    {Arrowheads[{{0.023827293534533802`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-66.3232573128931, 2.7663817173085747`}, {-76.53388554424973,
        2.947903996977137}}]}}, 
    {Arrowheads[{{0.023828949685844335`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-66.3232573128931, 3.3196580607702897`}, {-76.53388554424973,
        3.5374847963725644`}}]}}, 
    {Arrowheads[{{0.023830906807186993`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-66.3232573128931, 3.8729344042320046`}, {-76.53388554424973,
        4.127065595767992}}]}}, 
    {Arrowheads[{{0.01906804459940055, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-53.058605850314486`, -3.8729344042320064`}, \
{-61.227108435399785`, -4.127065595767994}}]}}, 
    {Arrowheads[{{0.019065598567115535`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-53.058605850314486`, -3.3196580607702915`}, \
{-61.227108435399785`, -3.537484796372566}}]}}, 
    {Arrowheads[{{0.01906352860235307, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-53.058605850314486`, -2.7663817173085765`}, \
{-61.227108435399785`, -2.947903996977139}}]}}, 
    {Arrowheads[{{0.019061834827627046`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-53.058605850314486`, -2.2131053738468616`}, \
{-61.227108435399785`, -2.3583231975817114`}}]}}, 
    {Arrowheads[{{0.01906051734322559, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-53.058605850314486`, -1.6598290303851464`}, \
{-61.227108435399785`, -1.7687423981862838`}}]}}, 
    {Arrowheads[{{0.019059576227181386`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-53.058605850314486`, -1.1065526869234312`}, \
{-61.227108435399785`, -1.1791615987908561`}}]}}, 
    {Arrowheads[{{0.019059011535248582`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-53.058605850314486`, -0.5532763434617161}, \
{-61.227108435399785`, -0.5895807993954285}}]}}, 
    {Arrowheads[{{0.01905882330088627, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-53.058605850314486`, -8.599641896882574*^-16}, \
{-61.227108435399785`, -9.163926497119932*^-16}}]}}, 
    {Arrowheads[{{0.019059011535248582`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-53.058605850314486`, 
       0.5532763434617143}, {-61.227108435399785`, 0.5895807993954266}}]}}, 
    {Arrowheads[{{0.019059576227181386`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-53.058605850314486`, 
       1.1065526869234295`}, {-61.227108435399785`, 1.1791615987908544`}}]}}, 
    {Arrowheads[{{0.01906051734322559, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-53.058605850314486`, 
       1.6598290303851446`}, {-61.227108435399785`, 1.7687423981862818`}}]}}, 
    {Arrowheads[{{0.019061834827627046`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-53.058605850314486`, 
       2.21310537384686}, {-61.227108435399785`, 2.3583231975817096`}}]}}, 
    {Arrowheads[{{0.01906352860235307, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-53.058605850314486`, 
       2.7663817173085747`}, {-61.227108435399785`, 2.947903996977137}}]}}, 
    {Arrowheads[{{0.019065598567115535`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-53.058605850314486`, 
       3.3196580607702897`}, {-61.227108435399785`, 3.5374847963725644`}}]}}, 
    {Arrowheads[{{0.01906804459940055, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-53.058605850314486`, 
       3.8729344042320046`}, {-61.227108435399785`, 4.127065595767992}}]}}, 
    {Arrowheads[{{0.014306410228929764`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-39.79395438773586, -3.8729344042320064`}, \
{-45.920331326549835`, -4.127065595767994}}]}}, 
    {Arrowheads[{{0.014303149915878517`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-39.79395438773586, -3.3196580607702915`}, \
{-45.920331326549835`, -3.537484796372566}}]}}, 
    {Arrowheads[{{0.014300390608876081`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-39.79395438773586, -2.7663817173085765`}, \
{-45.920331326549835`, -2.947903996977139}}]}}, 
    {Arrowheads[{{0.014298132597980519`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-39.79395438773586, -2.2131053738468616`}, \
{-45.920331326549835`, -2.3583231975817114`}}]}}, 
    {Arrowheads[{{0.014296376120720287`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-39.79395438773586, -1.6598290303851464`}, \
{-45.920331326549835`, -1.7687423981862838`}}]}}, 
    {Arrowheads[{{0.014295121361969447`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-39.79395438773586, -1.1065526869234312`}, \
{-45.92033132654983, -1.1791615987908561`}}]}}, 
    {Arrowheads[{{0.014294368453850499`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-39.79395438773586, -0.5532763434617161}, \
{-45.920331326549835`, -0.5895807993954285}}]}}, 
    {Arrowheads[{{0.014294117475664706`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-39.79395438773586, -8.599641896882574*^-16}, \
{-45.920331326549835`, -9.163926497119932*^-16}}]}}, 
    {Arrowheads[{{0.014294368453850499`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-39.79395438773586, 
       0.5532763434617143}, {-45.920331326549835`, 0.5895807993954266}}]}}, 
    {Arrowheads[{{0.014295121361969447`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-39.79395438773586, 
       1.1065526869234295`}, {-45.92033132654983, 1.1791615987908544`}}]}}, 
    {Arrowheads[{{0.014296376120720287`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-39.79395438773586, 
       1.6598290303851446`}, {-45.920331326549835`, 1.7687423981862818`}}]}}, 
    {Arrowheads[{{0.014298132597980519`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-39.79395438773586, 2.21310537384686}, {-45.920331326549835`,
        2.3583231975817096`}}]}}, 
    {Arrowheads[{{0.014300390608876081`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-39.79395438773586, 
       2.7663817173085747`}, {-45.920331326549835`, 2.947903996977137}}]}}, 
    {Arrowheads[{{0.014303149915878517`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-39.79395438773586, 
       3.3196580607702897`}, {-45.920331326549835`, 3.5374847963725644`}}]}}, 
    {Arrowheads[{{0.014306410228929764`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-39.79395438773586, 
       3.8729344042320046`}, {-45.920331326549835`, 4.127065595767992}}]}}, 
    {Arrowheads[{{0.00954784088859488, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-26.52930292515724, -3.8729344042320064`}, \
{-30.613554217699885`, -4.127065595767994}}]}}, 
    {Arrowheads[{{0.009542954967492703, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-26.52930292515724, -3.3196580607702915`}, \
{-30.613554217699885`, -3.537484796372566}}]}}, 
    {Arrowheads[{{0.009538818771835919, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-26.52930292515724, -2.7663817173085765`}, \
{-30.613554217699885`, -2.947903996977139}}]}}, 
    {Arrowheads[{{0.009535433277252333, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-26.52930292515724, -2.2131053738468616`}, \
{-30.613554217699885`, -2.3583231975817114`}}]}}, 
    {Arrowheads[{{0.009532799283557759, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-26.52930292515724, -1.6598290303851464`}, \
{-30.613554217699885`, -1.7687423981862838`}}]}}, 
    {Arrowheads[{{0.009530917413813515, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-26.52930292515724, -1.1065526869234312`}, \
{-30.613554217699885`, -1.1791615987908561`}}]}}, 
    {Arrowheads[{{0.009529788113590685, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-26.52930292515724, -0.5532763434617161}, \
{-30.613554217699885`, -0.5895807993954285}}]}}, 
    {Arrowheads[{{0.009529411650443126, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-26.52930292515724, -8.599641896882574*^-16}, \
{-30.613554217699885`, -9.163926497119932*^-16}}]}}, 
    {Arrowheads[{{0.009529788113590685, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-26.52930292515724, 
       0.5532763434617143}, {-30.613554217699885`, 0.5895807993954266}}]}}, 
    {Arrowheads[{{0.009530917413813515, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-26.52930292515724, 
       1.1065526869234295`}, {-30.613554217699885`, 1.1791615987908544`}}]}}, 
    {Arrowheads[{{0.009532799283557759, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-26.52930292515724, 
       1.6598290303851446`}, {-30.613554217699885`, 1.7687423981862818`}}]}}, 
    {Arrowheads[{{0.009535433277252333, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-26.52930292515724, 2.21310537384686}, {-30.613554217699885`,
        2.3583231975817096`}}]}}, 
    {Arrowheads[{{0.009538818771835919, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-26.52930292515724, 
       2.7663817173085747`}, {-30.613554217699885`, 2.947903996977137}}]}}, 
    {Arrowheads[{{0.009542954967492703, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-26.52930292515724, 
       3.3196580607702897`}, {-30.613554217699885`, 3.5374847963725644`}}]}}, 
    {Arrowheads[{{0.00954784088859488, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-26.52930292515724, 
       3.8729344042320046`}, {-30.613554217699885`, 4.127065595767992}}]}}, 
    {Arrowheads[{{0.00480145819842508, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-13.264651462578614`, -3.8729344042320064`}, \
{-15.30677710884994, -4.127065595767994}}]}}, 
    {Arrowheads[{{0.004791735041599526, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-13.264651462578614`, -3.3196580607702915`}, \
{-15.30677710884994, -3.537484796372566}}]}}, 
    {Arrowheads[{{0.004783492318299303, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-13.264651462578614`, -2.7663817173085765`}, \
{-15.30677710884994, -2.947903996977139}}]}}, 
    {Arrowheads[{{0.004776737692424645, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-13.264651462578614`, -2.2131053738468616`}, \
{-15.30677710884994, -2.3583231975817114`}}]}}, 
    {Arrowheads[{{0.004771477483746356, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-13.264651462578614`, -1.6598290303851464`}, \
{-15.30677710884994, -1.7687423981862838`}}]}}, 
    {Arrowheads[{{0.004767716638626171, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-13.264651462578614`, -1.1065526869234312`}, \
{-15.30677710884994, -1.1791615987908561`}}]}}, 
    {Arrowheads[{{0.004765458706906762, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-13.264651462578614`, -0.5532763434617161}, \
{-15.30677710884994, -0.5895807993954285}}]}}, 
    {Arrowheads[{{0.0047647058252215675`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-13.264651462578614`, -8.599641896882574*^-16}, \
{-15.30677710884994, -9.163926497119932*^-16}}]}}, 
    {Arrowheads[{{0.004765458706906762, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-13.264651462578614`, 
       0.5532763434617143}, {-15.30677710884994, 0.5895807993954266}}]}}, 
    {Arrowheads[{{0.004767716638626171, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-13.264651462578614`, 
       1.1065526869234295`}, {-15.30677710884994, 1.1791615987908544`}}]}}, 
    {Arrowheads[{{0.004771477483746356, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-13.264651462578614`, 
       1.6598290303851446`}, {-15.30677710884994, 1.7687423981862818`}}]}}, 
    {Arrowheads[{{0.004776737692424645, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-13.264651462578614`, 2.21310537384686}, {-15.30677710884994,
        2.3583231975817096`}}]}}, 
    {Arrowheads[{{0.004783492318299303, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-13.264651462578614`, 
       2.7663817173085747`}, {-15.30677710884994, 2.947903996977137}}]}}, 
    {Arrowheads[{{0.004791735041599526, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-13.264651462578614`, 
       3.3196580607702897`}, {-15.30677710884994, 3.5374847963725644`}}]}}, 
    {Arrowheads[{{0.00480145819842508, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-13.264651462578614`, 
       3.8729344042320046`}, {-15.30677710884994, 4.127065595767992}}]}}, 
    {Arrowheads[{{0.0005929411693609074, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.89635682608107*^-15, -3.8729344042320064`}, {
       1.1419925246721935`*^-14, -4.127065595767994}}]}}, 
    {Arrowheads[{{0.000508235288023634, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.89635682608107*^-15, -3.3196580607702915`}, {
       1.1419925246721935`*^-14, -3.537484796372566}}]}}, 
    {Arrowheads[{{0.0004235294066863617, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.89635682608107*^-15, -2.7663817173085765`}, {
       1.1419925246721935`*^-14, -2.947903996977139}}]}}, 
    {Arrowheads[{{0.00033882352534908935`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.89635682608107*^-15, -2.2131053738468616`}, {
       1.1419925246721935`*^-14, -2.3583231975817114`}}]}}, 
    {Arrowheads[{{0.000254117644011817, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.89635682608107*^-15, -1.6598290303851464`}, {
       1.1419925246721935`*^-14, -1.7687423981862838`}}]}}, 
    {Arrowheads[{{0.00016941176267454467`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.89635682608107*^-15, -1.1065526869234312`}, {
       1.1419925246721935`*^-14, -1.1791615987908561`}}]}}, 
    {Arrowheads[{{0.00008470588133727234, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.89635682608107*^-15, -0.5532763434617161}, {
       1.1419925246721935`*^-14, -0.5895807993954285}}]}}, 
    {Arrowheads[{{3.557240769010676*^-18, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.89635682608107*^-15, -8.599641896882574*^-16}, {
       1.1419925246721935`*^-14, -9.163926497119932*^-16}}]}}, 
    {Arrowheads[{{0.00008470588133727208, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.89635682608107*^-15, 0.5532763434617143}, {
       1.1419925246721935`*^-14, 0.5895807993954266}}]}}, 
    {Arrowheads[{{0.00016941176267454467`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.89635682608107*^-15, 1.1065526869234295`}, {
       1.1419925246721935`*^-14, 1.1791615987908544`}}]}}, 
    {Arrowheads[{{0.00025411764401181647`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.89635682608107*^-15, 1.6598290303851446`}, {
       1.1419925246721935`*^-14, 1.7687423981862818`}}]}}, 
    {Arrowheads[{{0.00033882352534908935`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.89635682608107*^-15, 2.21310537384686}, {
       1.1419925246721934`*^-14, 2.3583231975817096`}}]}}, 
    {Arrowheads[{{0.0004235294066863617, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.89635682608107*^-15, 2.7663817173085747`}, {
       1.1419925246721935`*^-14, 2.947903996977137}}]}}, 
    {Arrowheads[{{0.000508235288023634, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.89635682608107*^-15, 3.3196580607702897`}, {
       1.1419925246721935`*^-14, 3.5374847963725644`}}]}}, 
    {Arrowheads[{{0.0005929411693609074, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.89635682608107*^-15, 3.8729344042320046`}, {
       1.1419925246721934`*^-14, 4.127065595767992}}]}}, 
    {Arrowheads[{{0.00480145819842508, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{13.264651462578634`, -3.8729344042320064`}, {
       15.306777108849959`, -4.127065595767994}}]}}, 
    {Arrowheads[{{0.004791735041599526, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{13.264651462578634`, -3.3196580607702915`}, {
       15.306777108849959`, -3.537484796372566}}]}}, 
    {Arrowheads[{{0.004783492318299303, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{13.264651462578634`, -2.7663817173085765`}, {
       15.306777108849959`, -2.947903996977139}}]}}, 
    {Arrowheads[{{0.004776737692424645, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{13.264651462578634`, -2.2131053738468616`}, {
       15.306777108849959`, -2.3583231975817114`}}]}}, 
    {Arrowheads[{{0.004771477483746356, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{13.264651462578634`, -1.6598290303851464`}, {
       15.306777108849959`, -1.7687423981862838`}}]}}, 
    {Arrowheads[{{0.004767716638626171, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{13.264651462578634`, -1.1065526869234312`}, {
       15.306777108849959`, -1.1791615987908561`}}]}}, 
    {Arrowheads[{{0.004765458706906762, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{13.264651462578634`, -0.5532763434617161}, {
       15.306777108849959`, -0.5895807993954285}}]}}, 
    {Arrowheads[{{0.0047647058252215675`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{13.264651462578634`, -8.599641896882574*^-16}, {
       15.306777108849959`, -9.163926497119932*^-16}}]}}, 
    {Arrowheads[{{0.004765458706906762, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{13.264651462578634`, 0.5532763434617143}, {
       15.306777108849959`, 0.5895807993954266}}]}}, 
    {Arrowheads[{{0.004767716638626171, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{13.264651462578634`, 1.1065526869234295`}, {
       15.306777108849959`, 1.1791615987908544`}}]}}, 
    {Arrowheads[{{0.004771477483746356, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{13.264651462578634`, 1.6598290303851446`}, {
       15.306777108849959`, 1.768742398186282}}]}}, 
    {Arrowheads[{{0.004776737692424645, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{13.264651462578634`, 2.21310537384686}, {15.306777108849959`,
        2.3583231975817096`}}]}}, 
    {Arrowheads[{{0.004783492318299303, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{13.264651462578634`, 2.7663817173085747`}, {
       15.306777108849959`, 2.947903996977137}}]}}, 
    {Arrowheads[{{0.004791735041599526, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{13.264651462578634`, 3.3196580607702897`}, {
       15.306777108849959`, 3.5374847963725644`}}]}}, 
    {Arrowheads[{{0.00480145819842508, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{13.264651462578634`, 3.8729344042320046`}, {
       15.306777108849959`, 4.127065595767992}}]}}, 
    {Arrowheads[{{0.009547840888594897, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{26.529302925157257`, -3.8729344042320064`}, {
       30.61355421769991, -4.127065595767994}}]}}, 
    {Arrowheads[{{0.009542954967492719, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{26.529302925157257`, -3.3196580607702915`}, {
       30.61355421769991, -3.537484796372566}}]}}, 
    {Arrowheads[{{0.009538818771835935, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{26.529302925157257`, -2.7663817173085765`}, {
       30.61355421769991, -2.947903996977139}}]}}, 
    {Arrowheads[{{0.00953543327725235, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{26.529302925157257`, -2.2131053738468616`}, {
       30.61355421769991, -2.3583231975817114`}}]}}, 
    {Arrowheads[{{0.009532799283557774, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{26.529302925157257`, -1.6598290303851464`}, {
       30.61355421769991, -1.7687423981862838`}}]}}, 
    {Arrowheads[{{0.00953091741381353, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{26.529302925157257`, -1.1065526869234312`}, {
       30.61355421769991, -1.1791615987908561`}}]}}, 
    {Arrowheads[{{0.009529788113590702, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{26.529302925157257`, -0.5532763434617161}, {
       30.61355421769991, -0.5895807993954285}}]}}, 
    {Arrowheads[{{0.009529411650443144, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{26.529302925157257`, -8.599641896882574*^-16}, {
       30.61355421769991, -9.163926497119932*^-16}}]}}, 
    {Arrowheads[{{0.009529788113590702, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{26.529302925157257`, 0.5532763434617143}, {30.61355421769991,
        0.5895807993954266}}]}}, 
    {Arrowheads[{{0.00953091741381353, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{26.529302925157257`, 1.1065526869234295`}, {
       30.61355421769991, 1.1791615987908544`}}]}}, 
    {Arrowheads[{{0.009532799283557774, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{26.529302925157257`, 1.6598290303851446`}, {
       30.61355421769991, 1.7687423981862818`}}]}}, 
    {Arrowheads[{{0.00953543327725235, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{26.529302925157257`, 2.21310537384686}, {30.61355421769991, 
       2.3583231975817096`}}]}}, 
    {Arrowheads[{{0.009538818771835935, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{26.529302925157257`, 2.7663817173085747`}, {
       30.61355421769991, 2.947903996977137}}]}}, 
    {Arrowheads[{{0.009542954967492719, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{26.529302925157257`, 3.3196580607702897`}, {
       30.61355421769991, 3.5374847963725644`}}]}}, 
    {Arrowheads[{{0.009547840888594897, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{26.529302925157257`, 3.8729344042320046`}, {
       30.61355421769991, 4.127065595767992}}]}}, 
    {Arrowheads[{{0.014306410228929764`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{39.79395438773588, -3.8729344042320064`}, {
       45.92033132654986, -4.127065595767994}}]}}, 
    {Arrowheads[{{0.014303149915878517`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{39.79395438773588, -3.3196580607702915`}, {
       45.92033132654986, -3.537484796372566}}]}}, 
    {Arrowheads[{{0.014300390608876081`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{39.79395438773588, -2.7663817173085765`}, {
       45.92033132654986, -2.947903996977139}}]}}, 
    {Arrowheads[{{0.014298132597980519`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{39.79395438773588, -2.2131053738468616`}, {
       45.92033132654986, -2.3583231975817114`}}]}}, 
    {Arrowheads[{{0.014296376120720287`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{39.79395438773588, -1.6598290303851464`}, {
       45.92033132654986, -1.7687423981862838`}}]}}, 
    {Arrowheads[{{0.014295121361969462`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{39.79395438773588, -1.1065526869234312`}, {
       45.92033132654986, -1.1791615987908561`}}]}}, 
    {Arrowheads[{{0.014294368453850499`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{39.79395438773588, -0.5532763434617161}, {
       45.92033132654986, -0.5895807993954285}}]}}, 
    {Arrowheads[{{0.014294117475664706`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{39.79395438773588, -8.599641896882574*^-16}, {
       45.92033132654986, -9.163926497119932*^-16}}]}}, 
    {Arrowheads[{{0.014294368453850499`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{39.79395438773588, 0.5532763434617143}, {45.92033132654986, 
       0.5895807993954266}}]}}, 
    {Arrowheads[{{0.014295121361969462`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{39.79395438773588, 1.1065526869234295`}, {45.92033132654986, 
       1.1791615987908544`}}]}}, 
    {Arrowheads[{{0.014296376120720287`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{39.79395438773588, 1.6598290303851446`}, {45.92033132654986, 
       1.7687423981862818`}}]}}, 
    {Arrowheads[{{0.014298132597980519`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{39.79395438773588, 2.21310537384686}, {45.92033132654986, 
       2.3583231975817096`}}]}}, 
    {Arrowheads[{{0.014300390608876081`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{39.79395438773588, 2.7663817173085747`}, {45.92033132654986, 
       2.947903996977137}}]}}, 
    {Arrowheads[{{0.014303149915878517`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{39.79395438773588, 3.3196580607702897`}, {45.92033132654986, 
       3.5374847963725644`}}]}}, 
    {Arrowheads[{{0.014306410228929764`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{39.79395438773588, 3.8729344042320046`}, {45.92033132654986, 
       4.127065595767992}}]}}, 
    {Arrowheads[{{0.019068044599400567`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{53.0586058503145, -3.8729344042320064`}, {
       61.227108435399806`, -4.127065595767994}}]}}, 
    {Arrowheads[{{0.01906559856711555, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{53.05860585031451, -3.3196580607702915`}, {
       61.22710843539981, -3.537484796372566}}]}}, 
    {Arrowheads[{{0.019063528602353084`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{53.05860585031451, -2.7663817173085765`}, {
       61.22710843539981, -2.947903996977139}}]}}, 
    {Arrowheads[{{0.01906183482762706, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{53.0586058503145, -2.2131053738468616`}, {
       61.227108435399806`, -2.3583231975817114`}}]}}, 
    {Arrowheads[{{0.019060517343225607`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{53.05860585031451, -1.6598290303851464`}, {
       61.22710843539981, -1.7687423981862838`}}]}}, 
    {Arrowheads[{{0.019059576227181404`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{53.05860585031451, -1.1065526869234312`}, {
       61.22710843539981, -1.1791615987908561`}}]}}, 
    {Arrowheads[{{0.0190590115352486, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{53.05860585031451, -0.5532763434617161}, {
       61.22710843539981, -0.5895807993954285}}]}}, 
    {Arrowheads[{{0.019058823300886287`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{53.05860585031451, -8.599641896882574*^-16}, {
       61.22710843539981, -9.163926497119932*^-16}}]}}, 
    {Arrowheads[{{0.0190590115352486, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{53.05860585031451, 0.5532763434617143}, {61.22710843539981, 
       0.5895807993954266}}]}}, 
    {Arrowheads[{{0.019059576227181404`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{53.05860585031451, 1.1065526869234295`}, {61.22710843539981, 
       1.1791615987908544`}}]}}, 
    {Arrowheads[{{0.019060517343225607`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{53.05860585031451, 1.6598290303851446`}, {61.22710843539981, 
       1.7687423981862818`}}]}}, 
    {Arrowheads[{{0.01906183482762706, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{53.0586058503145, 2.21310537384686}, {61.227108435399806`, 
       2.3583231975817096`}}]}}, 
    {Arrowheads[{{0.019063528602353084`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{53.05860585031451, 2.7663817173085747`}, {61.22710843539981, 
       2.947903996977137}}]}}, 
    {Arrowheads[{{0.01906559856711555, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{53.05860585031451, 3.3196580607702897`}, {61.22710843539981, 
       3.5374847963725644`}}]}}, 
    {Arrowheads[{{0.019068044599400567`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{53.0586058503145, 3.8729344042320046`}, {61.227108435399806`,
        4.127065595767992}}]}}, 
    {Arrowheads[{{0.023830906807186993`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{66.32325731289313, -3.8729344042320064`}, {
       76.53388554424976, -4.127065595767994}}]}}, 
    {Arrowheads[{{0.023828949685844335`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{66.32325731289313, -3.3196580607702915`}, {
       76.53388554424976, -3.537484796372566}}]}}, 
    {Arrowheads[{{0.023827293534533802`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{66.32325731289313, -2.7663817173085765`}, {
       76.53388554424976, -2.947903996977139}}]}}, 
    {Arrowheads[{{0.023825938416017073`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{66.32325731289313, -2.2131053738468616`}, {
       76.53388554424976, -2.3583231975817114`}}]}}, 
    {Arrowheads[{{0.023824884381660836`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{66.32325731289313, -1.6598290303851464`}, {
       76.53388554424976, -1.7687423981862838`}}]}}, 
    {Arrowheads[{{0.023824131471427045`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{66.32325731289313, -1.1065526869234312`}, {
       76.53388554424976, -1.1791615987908561`}}]}}, 
    {Arrowheads[{{0.02382367971386539, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{66.32325731289313, -0.5532763434617161}, {
       76.53388554424976, -0.5895807993954285}}]}}, 
    {Arrowheads[{{0.023823529126107832`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{66.32325731289313, -8.599641896882574*^-16}, {
       76.53388554424976, -9.163926497119932*^-16}}]}}, 
    {Arrowheads[{{0.02382367971386539, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{66.32325731289313, 0.5532763434617143}, {76.53388554424976, 
       0.5895807993954266}}]}}, 
    {Arrowheads[{{0.023824131471427045`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{66.32325731289313, 1.1065526869234295`}, {76.53388554424976, 
       1.1791615987908544`}}]}}, 
    {Arrowheads[{{0.023824884381660836`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{66.32325731289313, 1.6598290303851446`}, {76.53388554424976, 
       1.768742398186282}}]}}, 
    {Arrowheads[{{0.023825938416017073`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{66.32325731289313, 2.21310537384686}, {76.53388554424976, 
       2.3583231975817096`}}]}}, 
    {Arrowheads[{{0.023827293534533802`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{66.32325731289313, 2.7663817173085747`}, {76.53388554424976, 
       2.947903996977137}}]}}, 
    {Arrowheads[{{0.023828949685844335`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{66.32325731289313, 3.3196580607702897`}, {76.53388554424976, 
       3.5374847963725644`}}]}}, 
    {Arrowheads[{{0.023830906807186993`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{66.32325731289313, 3.8729344042320046`}, {76.53388554424976, 
       4.127065595767992}}]}}, 
    {Arrowheads[{{0.028594383309711993`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{79.58790877547176, -3.8729344042320064`}, {
       91.84066265309971, -4.127065595767994}}]}}, 
    {Arrowheads[{{0.028592752241440575`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{79.58790877547176, -3.3196580607702915`}, {
       91.84066265309971, -3.537484796372566}}]}}, 
    {Arrowheads[{{0.02859137203407246, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{79.58790877547176, -2.7663817173085765`}, {
       91.84066265309971, -2.947903996977139}}]}}, 
    {Arrowheads[{{0.028590242723938925`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{79.58790877547176, -2.2131053738468616`}, {
       91.84066265309971, -2.3583231975817114`}}]}}, 
    {Arrowheads[{{0.02858936434077209, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{79.58790877547176, -1.6598290303851464`}, {
       91.84066265309971, -1.7687423981862838`}}]}}, 
    {Arrowheads[{{0.028588736907700998`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{79.58790877547176, -1.1065526869234312`}, {
       91.84066265309971, -1.1791615987908561`}}]}}, 
    {Arrowheads[{{0.028588360441248562`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{79.58790877547176, -0.5532763434617161}, {
       91.84066265309971, -0.5895807993954285}}]}}, 
    {Arrowheads[{{0.02858823495132941, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{79.58790877547176, -8.599641896882574*^-16}, {
       91.84066265309971, -9.163926497119932*^-16}}]}}, 
    {Arrowheads[{{0.028588360441248562`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{79.58790877547176, 0.5532763434617143}, {91.84066265309971, 
       0.5895807993954266}}]}}, 
    {Arrowheads[{{0.028588736907700998`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{79.58790877547176, 1.1065526869234295`}, {91.84066265309971, 
       1.1791615987908544`}}]}}, 
    {Arrowheads[{{0.02858936434077209, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{79.58790877547176, 1.6598290303851446`}, {91.84066265309971, 
       1.7687423981862818`}}]}}, 
    {Arrowheads[{{0.028590242723938925`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{79.58790877547176, 2.21310537384686}, {91.84066265309971, 
       2.3583231975817096`}}]}}, 
    {Arrowheads[{{0.02859137203407246, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{79.58790877547176, 2.7663817173085747`}, {91.84066265309971, 
       2.947903996977137}}]}}, 
    {Arrowheads[{{0.028592752241440575`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{79.58790877547176, 3.3196580607702897`}, {91.84066265309971, 
       3.5374847963725644`}}]}}, 
    {Arrowheads[{{0.028594383309711993`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{79.58790877547176, 3.8729344042320046`}, {91.84066265309971, 
       4.127065595767992}}]}}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "TransparentPolygonMesh" -> True},
  PlotRange->{{-107.14856914468389`, 
   107.14856914468389`}, {-11.14856914468389, 11.14856914468389}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.6564306455085692`*^9, 
  3.6564307153348675`*^9}},ExpressionUUID->"9e351b24-ba0d-4e34-9fa9-\
d7c299c9af05"],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxtnQmcz9X3/63DLGYYLUSSLaWQRCp9rm3sDcaMZgaVSpbIUklUdkWbvSR9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   "], {{
     {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmwVsWVgO/9yePH/4oiyqJGAwgEFXn42FdZH2gmCgg6uEQQRxN1xC1O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         "]], PolygonBox[CompressedData["
1:eJwlk01IlVEQhifx3uxMtcmwhCAxhaCo3CRlC420VaVJi8IUwaIfjMRqkb+4
ddU2goIgEAIhCITiglRIxEVETBKJkJCKUozSRVLP9C5eeN75zpwzM+d8Ze03
mjoLzKwaFaLJZDaWMbsPf9xoNoF/im/Fz+Jb3WwUrs+atcGHUDd+F74KrkFD
+Er8MfgV+U/IryU2Tf5L/AN8MT6PX0nih8R+wv3ktJObJ9YHH3Tt3YE/AL9h
zQhrz+BnyP+DL4cfE1uHb7HmPOtzxLrhIlRlqmETfAmN4HP4y/Bh1Il/hq+G
c0m1xJ6T7L+T2Dm4iD1L4QE0b6pxEG5CR+F7xBrhPWhbVjnl8Ga0ntF8Ha6P
nrKa0Ql4PKn2qHGK8267eo8e7sTerlnGjI/AW1CDac+t8A5XbRErid5dd/eC
7xfgU2jYdKen4TrUi3+OPw7PcP44PEHsM+e/S5pFrJnD/8Av4Flq3+Hf6Au+
FP8LbnD1Hj2dhN8SG81oph/IzyedFTXM46eTZj+GX8BPJdUad/IJf5Y9Hplm
2hyHohW+7wX/svaa624b+X4dvuh6i5HTAi8l1RY1L8N3Xb29xvfAu11vJ950
GbzP9baj5v1wseutxhvbDt901Roz6oJXk2qJGazBV121xD9xBZ5NOus9fpF+
NrjuPnoogL/yHfz/D3yDK1xvO95MJfwPFrZ2qw==
         "]]}]}, 
     {RGBColor[0.5866663705809202, 0.5098827500444129, 0.47419612719843673`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuwVmUVxjfft7/97cspJCAQSEAUBClEKETQmFKgf0SRi8o1KIxzTBQ7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         "]], PolygonBox[CompressedData["
1:eJwll3m0jmUUxV/f9b33HZSQ8VbmKZWxwVirMv0TmYWIypiprislNKyERpkl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         "]]}]}, 
     {RGBColor[0.8994439509682004, 0.6198045834073548, 0.2903268786640611], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mXmQVdURxp9v7nv3nvvEhQSXAURkRhTFuJuIiVoCakAgKoILEYylkuAC
TmSIRhwyYMlSYAkIiQoKFUAxGjdSmkRMLFywTCoqqVQRRFOIaBEkFRdwy/eb
r/PHndP3vD7L7dP99Xd6+l5144U3VCuVyhj9aVL7Rb1SeTKrVO7Te1utUnlf
ncer/6OiUpmgvl1qD8srld56tuu3tWof1TNQY17K/I58m8Z+pt9HaGw9VSqT
Nbam9oHcOqvVv0S/v6XnJj3D9bysZ5ie6Xp+oae7dN7ReqM1dqvaperbpGeq
nvf0fpn6t6ldpnnv0JpHSx6l3zbqGdnkvW+P/Vf0+9eSx1W8l08lnyn522qf
1vsGyYMlb9Bzjp5bNOc/1d+uOdu135fUN5Q5ZZ/N6u8m/b/VvH++43r1D9P7
ZMnrog+dzzV+ovT3Mo9+/yjWpd0V8h0174+9Tat6n9jtXq27Rs9iPcvCztgP
u34aOhu07uq67cU6u+J7z1b7O72/Lbld37JN8q3aw1Ea31/PDP0+RuteUrP8
tHRKtQ+XeiR3kzxb+ndpXHfJt2qePybLj0rnGck9JM+Tzt665ZnS6ah6nkmS
75bczDySX0mWH9fYVyW3Sr6nsL/1lrxQOs8nyws4a409QvJS9b+ZLD9Z2j7V
OMfl6t+r95XqX5Pcv0ryV3XPv0I6/Wv2m7/GuaOP3TLZYFD0v62xAyQ/o7Fb
JZ/CutpDBV+W/ITEbeo/kbOVzgL198v9vltrfak5x0pncbLcqbFvJY9dLPnB
qufH56u5539B8mNV+x++917yfu4r7IfnhP/fLP0pud8/SD7XZdLZkTz2We2n
ofc98p/NDfvy94grjf1HzfHC9++o2597VRxPf696fsbtlN6YzL6BP6xT/2t6
f6jufa5s2MdWqN2j9cZxxlpzuHTH6umMeEVncMT05IjrJbn9uFnPCM3ZQayE
XbDPWZpvvfofqNvOw2O+NvxM6z2p/t+ofUo6S+s+09E1rzc9fIizHlT6zLDt
4NI+hC+dWtqm2Hao5BsLx8UMzbkx8xmz7gi1OzX/JP12snQ61Z4kndvUV9N6
50vnmtx+w/ip6t9H/adXjEf040tgJz6NP3Num6q291DNuVDt+ZpzUua1GDsu
t7+u1G+z1HbTnNcSC5n7+d7vauxczrVhPxgdZ3d57rXAavzqDY15QvLH7LnJ
8zysMWv1vkZtH/xZ8/dV/481Z4vkL9T/I8mHS96LvXPj2y9lq8vU3wscV/8N
pc/mxtL4BN4SRz8rfR63qv15aUy5XW27dF5sMv78NNkOUwufa2f4PL5zQpz3
dOm8K51faewPpHeI+j/RunPDd/gNTOJcbsHmyT68VPrnSf+b0v9vw/v9ft32
e13yn+r2t1f12+uSX1H7ZmZc4LyG5Y4NfHq45A8lXy35vNxYP7ZqP0YGzy8o
vefhpffdJasdn3nsMRXHEnMSa9gb+59LXEj+c92x8Sx4U3e+ek17+ovkjWpb
tO7ywJffNqzzeMM23hA4z97RXxq5hu8i3zyYfO53yh4HJmPlAcljBgee4HvX
Z/Zn/Jd3/BAMvzQ3jhMDk0KHPNOWOU99Kp1Lcp/D3OR5ehXGdfAanF+YrH94
xB8+Tyy0q29aZpwkntpj/raqZfrvTdZpLXyWnOmJpf354tzfRtx0xSq5DvtJ
/rhqHL4wN/4Si9cEvoPVd+fGNOJxYcQkfjUvdyyw996Z9z9Hax4UMvmrR+bc
d3zy+7eS8Qxcgw/cr3Z+cJ7DYk640ZF8R2bMPzJyBXg/X/Mfljmv9Y+98fug
5H2cnvy+IMYsij1PCZ9YEN/CHL1jnjWBseznLo2/Tv0HF/bDsZl9EluADfj8
o8En2DPxDw4MkZ3303u3+N5eybm8p9p7av4evmVZ+CdjlwUfWVP13paF3Cn9
IjMHoM1Dxk7Y67jMc+fBeeAY3UKnJXSYv2fYmfhvTdZrUXtnzXtln/AdvhfO
Q9yOD38mJ4CL4OdngQtnlMYD8hCYQP4Bd8F/4n9M2AosnRB5elqyDfeNHIsO
cQ0fIa9jf3LIlcEVwFj84IrMftQjfAksA9NOK73HCbHPjmT5G4XxnnzA3r/M
rMd+bk+eb7/gS+A+sXVE4fjp2bCP4CtNwRkWhc/MSY6PjsI4NSywF59ZHdwS
LBoVnAH+MDJ0wLfhIfP7yNCZkmzDm9U+Ujc3Bt+IR9YirncW5t//VtuUzFkz
2sLcd4/ac5L9arDaRXr+o7EPlo4LYoC99oqcxfzDk33ngmQcAAOwIRzh5djr
qYVz6K6G7ysfVO0bs5PlBzT/Hcljb5fuLM0/MzcmLwnOAs7D+fE/1uX3zty/
teW2L/6zPLjaQ1rr13H3eKxhXJ4a3LKLK0QePFM6B2hvuxvOFXByzpc54UVN
wSXaQ39k8CDsz1lNDwxvjnjn/jNQcybNuVNz7pd8j9g/7i7sGV/tiH2zZ76p
PbCC95uDW9K2hf90hk0Yuyi+l/5Lk/1jrNqLk/HsorjTwW/XBK/Ep7rH/WVx
7JNYaQ28Why+hw5r46dwGvgHPOTs0rZmH+Rf/Ks9zqKlcP74sOH71qw4u6HJ
awzhrpCMD/3U9iyc53ZIv3vhuNoueWByfB6XfG/C98hxhyZjVjP8Ohlnv5O8
3zVhN85hdcjYaVbYCrxYWzVn5ozmRn4Bz1oC9ybHGL4PHF4bGNo79OE5rbl5
OPojk+06IhmTwCZwnDX5ftaF99HPuuS/triPYCNsdbjseUBhfGxqmBPADQYU
5rhwqlMK88sunln4LgVGg8/kmccCx/rDidV/bGF8he+CsdhvctgQHCCntwUX
nZ95Dc7/ufCBjcmc/sKIiQHw2MwYyZwLg0s/FfOvlv4cyScWzhtzIndsjfpA
Dc6uvpmZeS/xBZ8jxh5K7j8usGF+6NAuyMwniaHO4CF7c9+d/iW7PZKsc1rh
XIhNTipsg86YZ0PEEr7MuuA2tibO+baBpb9/fqwFl+T88W34Fjbn7szdGo5B
XoM/wk2JY/Tho5uD57Au67Png+N9b9QZDil859tcM45sKy1/rvH71M3Z4HbE
1JaafZk7M+fdPXLdlOCxYOrWqA9gb+oU2Jw5uBeB89QUsHGP0j4Cf5odeXli
+AP3YfyyRTo7Ss9ZLZz3psY9iJoC339kco0ATnlCMkaD1c3qW5E592MfbIa/
dNUcCuedPqXrF9Qfeifzx5M1/6rM9y646LmF61D4at+4N6yKefh9VfgedYJp
USsgh68IvvGHZHlw4Rz4ds34CjflTPCH9eAFa0pnSWY+BLd5v7TNv9ZZHFqY
Z++vfc2u20/wDWz/ZeR99rI69gO+c96tpbkGnAOsIc/h0wNKz3Ff+Bjt/fFd
84KTgEVXBE+lLjYvMOf/tTxacuY7yff/q6PW1yfGLg+OB9fbnnyP+kmcz9WR
i+Gs/YIHkrf7BBe6KPLFtZx7w7zrUslb+C78vOFc3zPWWhIyGNsSa66L+1Sv
0OH3XpEXwELmgaNtSa5FXll4He6CT8T9BbvgO/jLpOAq8IKJwROwKXWBF+J+
RMwQL6MbxrtRhc+Msc1xb94Y85NXOLuDSuPYmVFLZf31oXN68PwRkcf2DayE
w4GX/QrnhJeCb29KHnt51Nm6/DPuIWDFkLijPx84Sc2O+9mxpfNIS9itM7AE
zHkjGYcvke7LyXF7QWFuDcc+o3C+4QzHF+Zh8DHO76lknx5U+O7SP+YHI/oH
Z5sf+x8Y94klwe2JS+ZHXpfsn2cFJveNPLEr6sz7Fz4vvuWWwEO4Nzz949y1
1y2lcQwMw0+2RU24KOwPe4KrEyucEWfLnhcEvyTHtsb+sVNr5OjlYTf2nwqv
Sd0LPJwRHBrMGxf8jZzdHDwHn2wO/4Rz4EM9S+ds8jSc8KuoT6wMrgRnYiz2
Oyr2g+6boc/eXwufHBI8Z0zUb96Ifr6FsTMijtkTdlzVMEdf3Yj6Vmbfha/B
O/Cx9ob3N7GwP3IHxyept3LPOSM5x1FPIc9tLi3vzl1/pA45mnpAwza+Kvb2
w7r3Rz3wraiNP1e6PnlZ+CD3YfgA9Ti48k0a+0nNuYE8ik/AIcBVcviskDcG
N4YjU+8Af48u7XfcV/kuagaMJfdSk6D+Tj6ifjUtuA3xynrjAy/n142ZXbgb
dbzntLcXJf++4f8HEEfdS9eLseO5yX5+V+Ruvpuz49vx6wXxHcOiBrAhONXS
uD9uCs4P9x9d91lz5tSx1gd+7C4du3lhrsRewTIwBo4EzmAL+Dl3tNkN/09i
TsM1a3B5VDJesQbzkxv5TjCFHAeekLupUV0fdaqtpc/uE9nyHcmbqAfm5nL4
IXbmfwDwmBNKc7OOiHHOCH3Oib0Sz8QynIWzhLdQe4ZzENvUmiZHzuVOz/+f
wOSxce+4oXCNChwEAzkr8vfMyJV74+yoA8GTbgu+S246MPgh/XA86obE3buF
fX1X8JkJhX0YX64Xtjm2p6bE+eCjnOfs+Bbq1tgUbKdejt93xWPu7yXXUNMk
HrdrvusKxxoxRw2V/5PxvdxLyUO7C/8/A/6R67tHBs8eHT74YvgKvkmOwT+P
CT4KNyePT4hcxl0aXv6Ffu+omz/w7WMjL5KHqZ/x7eQe6uvkEvIIGNARtvof
zlN8CA==
         "]], PolygonBox[CompressedData["
1:eJwllnnQjmUUxh/f977vdz/Pay87ZS/CRLaGkrJvydglUVNSiBTqyzZUlkkm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         "]]}]}, 
     {RGBColor[0.9498756439864985, 0.7446891099662463, 0.4446144963581453], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXm0VmUVxr/7Tec959xQUlATkwtqKUNqCZY24BDJkDmUSyPEC5hLBa4a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         "]], PolygonBox[CompressedData["
1:eJwtl3dsllUUxt9+bb/vvu9Xq2WUVGZZWkpRHAUUwo5SWpElpmJBpMQ4GCW4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         "]]}]}, 
     {RGBColor[0.9998401136969266, 0.8696002842423165, 0.5995043524604724], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXm0llUVxr/5nSDNzGkVmq2lRCVm4piCmKmoLAU1TQETvYAiOBSmIlAq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         "]], PolygonBox[CompressedData["
1:eJwtmHn0l1URxl++y+/33vtCLhgSJ0DpHCGpNBVZlD2TQE1URGVTkE0gVAgC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         "]]}]}, 
     {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lVts1kUQxZe20G/3r6KRBwgRgj5UH1QEeZBIiZEYiRcEY6EWuUmhFlS8
oCCSKBcLGmot95AiUSExVgNY4GslxEKhGiWlEKiQQrg0XCzQShFULPg7zPow
Oec/3+x8M7uzZ/tNen3UaxnOua1YJjbfO9cKuZRyrirbuT743grOTcAe6+rc
OHAAMb2ynBsIDsH6wXPBX4jfT/yHxNzJdyb+HmAKu0ZOD3bht3P4SxLncvi+
A34vWI0/l/wF4GhsMPwF8BNsInwxeJL8VeSvB0fw3RdeRZ7H4VvgzeT5G2sh
50L81yKXbyT2EHwUOMvZ/x4hZgs2kPzPkuNJfrsP/3DwA77z8S8Ap2HD4TXE
FsGfgE8Bl2JT4Z8FM/GfEqtVNdfB88g1iJyjwQa+G7s5tw88SA9PUUcN2Mle
d7A/18Emvl/Evx08gD0KT4OF5BxGzpfBebE21bg8WH79j3pQLyODxSk+nVit
qrk42J5qb/PBV2Nf6u9NbAT8HXAPaybDl8Dfjn79Pht7Hv4u+ByWR81fU/MY
eAG8Et5Crbuo+Wf1gb8OngdmYxVdnLuI/1Z4OzUn4CnWHGdtC3g6zo/maBs1
nIKfg1fDe7P2PPwV1hQRv4n4ifDbiSkNVpNqOwM2aS37fBA8y5oTxOwFK9mj
8iw7/z/gx+BtYAH2CHws2I31rfAs8AbfX/C/7ay9Aj+B/zJ4HTsN/xfchK2A
F5PzKnwd8W3EX4Ivh1+A1ye2D9qPw+oBvkP7lNjcan7Hxfs1SXcnzrZmvCf2
gHok9i74EHgZ/GH4IvhqeIAfgHeqD/hK+Br8t8G/oYbL/FcufAP+CvwbiFus
e4fvQZ0r/pX474Y/DS9P7Px0jml8M7E57Pm2lN1P3dOXQI91J+ZP8nUSn4OQ
HNKeaw6I/5Hfp3s7X53zWL6fga9P2dxofsbjm+EtXus2Y8Xw6fiPk3M9+Xdn
2yxqJsvAHM0b/mVJ7AfeSI56rJK+6sBG1twvXQPn8p2P/z1vuZSzCb4LvgL+
q7c1WjuI3J9ihdSwkVpWR+2Shq3B5hJzD7/vh6fhDWAZ9ga8D/6vou5J/3T2
N2fA23noXPZ429+b+wyvJaYEXgtfGvMon+6J7kuRN52SXkkvv4szrFkujfO/
m9+PxV7Uk+ZDc1JCzM6o1dJszbHmOUMzgkHdRny/Rd2T/mmeNFc/eJsbzc80
b32q38GsWwgvhPeCb9fMw6u9zahm9X1v+iUd+xL+Ef4M8rTiO6K9Jn5osLPR
Gc3zdpY60wpvd0N35Ftvd0l36h9vM6pZ3az7F2zeNHel3vRTOloTdXWVt/PW
ufeQzkT91zuQjrq6BL4o9qKejsbaVOP8YHOoecyMb5beLmmQtKhrsH7U19Rg
OiW9amft7/Cz8FvwX+S7mbXnvWmHNOQvb++r3tmOlGmNNCcVTFOkLS6Ypuie
HqbvtXH2NIPN/8+M9ilqlzSsPr6PJ+HfR12SPiVRb7sHy6Wc0oCG+L7rnW+L
etgB7qOmz6mtFtwb33e987q3ur8NKdNf6XA5ORck1q/6ro1rlwXrWb2vCqYd
0pBZwWZFM9M/2Juht+PjYPdN924y/D8k+D33
         "]], PolygonBox[CompressedData["
1:eJwtlFtMz1EcwE/9/13O+SHGg2ZYPJQHt8VDjcxmtoYhW0kZtVoXuc1lGj2o
KMxlpYuHaG4vLg9khAeU8sC6LbHFuvwX1lg0l2ni893Xw3f7fK/nnO/5nhOV
uTtpV7AxJhXxIynWmKVAJzwUBjtjbqKXoy+B9yGz4PUhxuyHJyAf0UeImQjP
RYrgtdjmwIuQevRC9IVwmWfMJ/TgIGOOw/HYHqDX4I+DjzpdO5X6xfAKpBn/
dWwJ8CHksM+YTfgL4d/st55aAWLG4GZqZuC7R3wTXEtMLz5CTA18Eknzacwp
uIGY2fhiJQdOp0Yc8f3YPnL+UfT36FUU+AZPIyfVrzlT4W1IMvVWkr9dzoI0
yV7RG+FIJJv4Bdimw1miE78KfzZcgOSjJ6LvhEOQGaw1TE4oHIxcDtKe+eAc
p71bTXyu3AWyF99y6s+EDTLk15y/7Dfcaa069DD4F7Z+v/bsJ/wH6TKaMw4f
87SXcqelcLL0H45nvRQ4BjmBPw1bNBzh9O5vUG+SnN/Tsw3ivw9/p2aE0TV/
SP8QH5yH7S39fUJOgPPPR+9AD4Qb0+fTGWtDb0Nfh34JaYePWO2l3EERvMPq
2pJTAD9nzcn4s9hDC1xnda8ykxfhFquzJjPdCltkjNwt2HpYb5w1RtHXoHej
P7I6+zLDj+EEJAq+hq0P/4jVs8qMfIVjkUi4Wmz4O6zOrsx4J1xm9a5kJsrh
XKt3IzOXB8cgU+AyYnrJv2W1VxXYbsN3rL6lavS78Cj7HWa/y7B1Ed9rdfbl
zbyD893/WSEmDy622mvJKYErrL5VmaFKeKvT2ZWep8Pt9LAjVGc6QP1zTnsr
M3wWfujp7MrMNsIHnf4N8kYPwB+cvtVoPpkhOIk1Fvu1Zhvxrz31DaL3wJlO
35LcYYa8NaezJ292M9ztaazMzB5qbXT6duUNboATsc2jfgP5A+y3x+pdie2N
nNdpL3LIqYSfWu213NkzeMBqruxxEH5p9S7lzl/BpU7/JnmzJfALT2vJG2mF
r1idJZnxq3Ct1VmSGbsAn7Z6VzJjZ+DzTmdb/twq+LPVv0b+rC/wP6JkxO4=

         "]]}]}}, {{}, 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0bsv5FEYBuCDwq2koCBBsbpV2ILCFnq3xLIK1m1dCvoNjcQ9xm0TuxFK
iUQx4xKEzhg6oSP8AeKyrHYXzxRPvu99z5mc5DdFHYMNAykhhBGi6SEsZYXw
i/vMEB55SNL/NV/4wzNP3Op3s0PYo9NvuukimhHCrDnHDAnnx0Ts7XTQyjfa
WHe/zqynhh13t6m155DLD+8NM0TEWZ4un1F5gnHm9AW6wuTb8iILSfpiXQnL
8ior/NR/0JWyJl/K/b5DzL7FJku6j87L2JcPOeC3vlz3ibh8QoJlfYWukjP5
gvPke/oq3Weu5BuuqZaPnMWZtE8zxYZv0mx+pZEmvtDCibunzNsXWSDmfp/Z
z3d66eHOfzTm7jgpchqpPOnfvB/s/8xX/pMlvwPtQk02
         "]], 
        LineBox[{3034, 120, 2476, 2478, 2477, 1982, 2009, 2324, 2323, 2468, 
         2467, 1980, 2007, 2313, 2312, 2457, 2456, 1978, 2005, 2302, 2301, 
         2446, 2445, 1976, 2003, 2291, 2290, 2435, 2434, 1974, 2001, 2752, 
         2280, 2416, 3029, 3031, 3030, 2045, 2790, 2791, 2679, 2681, 2680, 
         2231, 2677, 2678, 2674, 2676, 2675, 1972, 1999, 2276, 2275, 2412, 
         2411, 2036, 2574, 2575, 2571, 2573, 2572, 2026, 2948, 2949, 2553, 
         2555, 2554, 2031, 2551, 2552, 2548, 2550, 2549, 2569}], 
        LineBox[{1997, 2024, 2396, 2395, 2409, 2408, 2030, 2567, 2568, 2564, 
         2566, 2565, 2028, 3001, 3002, 2667, 2669, 2668, 2226, 2691, 2692, 
         2688, 2690, 2689, 1995, 2022, 2391, 2390, 2709, 2708, 2241, 2256, 
         2255, 2213, 2652, 2653, 2651, 2745, 2744, 1993, 2020, 3024, 3023, 
         2386, 2385, 2531, 2530, 1991, 2018, 2377, 2376, 2520, 2519, 1989, 
         2016, 2366, 2365, 2509, 2508, 1987, 2014, 2355, 2354, 2498, 2497, 
         1985, 2012, 2344, 2343, 3034}]},
       "2500"],
      Annotation[#, 2500, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0TsoRnEcxvG/wX1BZOEtC6FQIgaFEROKwf26uSWDIvXKpV4ppcQsSrFI
ym2wYLC4FErEZrNYDD6Gb9/n9zznnOXk9Y02j8SFEGYxnRTCV3II49zJXejG
pPsUH6khnPAdfhLZfSjf4ALv7gN+xRWucYallBAW0etbe+5meYZXPJ8tx3Om
O4GzeN5zc5xjS9flyhkc4VVblPNsubp8OcIFvGlb4Hxboa5ULuIy3rYtc7Gt
QlclV3I1H9hiXGL71tXJtVzPx7ZVLrc16hrkJm7kS9saV9nadC1yO7fyrW2d
a2z9ug55gDv5ybbB9bZR3aA8xkP8advimO2c+90DGMSj+0X/jCPP77uH9MM4
ku91v/7Lg7yDN/cuTyHdO2mI6ib+v8M93nvS/QG160It
         "]], LineBox[CompressedData["
1:eJwV0T9I1HEYB+D3OuHqPCfp3LzaypsEdWhJaQisFq3BpeGgzX8hLTV3o+DS
dBhdXkZWZGdQDlZX4SCKRmB0RdCUtmUJEXY9Nzx83vf9fH+33PHCxNB4IiKm
mT0c8f1IxJi83hoxKg9kZCIa8pr9tayxwite8sH9TypiwrfjXE1HTPLMfVDO
yYfe3ZULcoN13toP+e0kCW55W/D9I/eL5mHO2Qdp0V92v+K7un1JNyD7Oc0l
3Yhu07yo65O99HBed0H3zvxYl5ddnOSMbkC3bF7QHZM5OjmleyLvu3fILEfp
ds/7Zt5c0WVkK2lO6HK6krmsS8ig0bzTrpux39bt23/ziywpXVFX0v2w77JD
G3/dbujOynveld2+yjuyIqs85YH9pjdFauYvfG6+JVjjDXU+kaTKe9/u+Q+3
zT/lVvP/NU+xzDf7i+Y7/uk/2p+bV/kPXIBRoQ==
         "]]},
       "2000"],
      Annotation[#, 2000, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0DssQ1EcB+DTIt6MHpMySTBYEBsGol0MVomRaOMxec52qxCVagVFGLuK
AYlYRWIjQWJSE98dvvzO+Z3/uTf3JmYzU+lYCGGeWE0IS7UhLDPHc10I39Uh
3On3OagP4ZAsJVadr7Fo9k3+mb03d+Qsz7juWBaYsN401+T8g0++2NVv61us
fyjzG71Pv6PvsI7LCirJ6vdkt74xeh7N5PR52a9vlW20U9BfyWF9QnbSxYm+
JMf0PbKXPor6W5nSD8hBhrjUP8lp/Ygcje5yrX+RM/qqhhCS0V3W9RvRN7Ni
/y7jZh449T/OmNSlSLJFmgwL5l9l2f98NJ+jaP6Cc27s/wH9pzpP
         "]], LineBox[CompressedData["
1:eJwV0L8rxHEcx/GPuvLjDKIsbqBcSTFIblHHoLC5wcB2TNSZr5QoJSel1JWy
WP0BBgaLgTOLcud3kiTFJQwe3+HV8/V+Pb99h09HdiGTqwkh5CRWF8JhPIQj
eWwI4Ul+a0O4sv/gg/tezvmS7Nqf60OYx7x7Dv9wxDc7+h03iznbTPQPHOaK
+gU3jVnbFH7jILetl7gMTtomsIopbks/5sZw3DaKn9jHbeoH3BCmbWn8wB6u
oO9zKey3DeA7dnNr+h7Xi13R9/iGSW5VL3JJTNg68RXbuRV9g0tgk60NXyJy
S/oy14IxW3P0TtjKLUZvxTVG7+GO4zVXkbLk3etYkBv+Vqre/tL+hRV3Wc74
Uzmx/wN+s0C7
         "]]},
       "1500"],
      Annotation[#, 1500, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0D0oxHEcx/GvlHNn8FAGZ5CHktwiD4tcBp1MpBTjnYWBM+lKCSlFSqkr
UrJaldVutxu4dEkk6VLyMvx7fX7f9/bvLhTn1+siYtl3k4g4T0U8NUU0NEZ8
2AluJiNKbPN+1pJ2zU6xpG2x3buitdj1bOWOts209uLWYTczzSNtl11a1a3H
7mQvy9o++7RXt0G7nxleaQcc0N7cRuxhjvJaO2RGe3ebsLPM8lY75pD26Zaz
ZzjNO+2EY9qX26y9wDnea6cc177dFu08l/iglTmp1dzy9hoLfNTOOKX9uK38
/yuusqJdMKf9uhXtPW6wql3yD5OUMvA=
         "]], LineBox[CompressedData["
1:eJwVyz1IAlAYhtHboKmL2RSUg2ANLRVt1WptGpb0M0VLm03h6N7eEEIUBGEg
CGJCQnt7eylYNJVrOXgcDu/Hc7mZ0/NieSqEUKISC+EiHkLEftCjz3XCmx5z
D/jki5pe1ZPuH34ZcqNf6nPuP/4Zcadf6Rl3xEaZ5l6/tcv6jE0xy4Net+v6
vF0gzaPetlt61i6yREN/sTl9xa6yRlN/tXl9w25O/tLS3+yBnrPb7PCkv9sT
PW8L7NLRB/ZM37P7lHjWv21ZP7RHHNPVx6MFLIw=
         "]]},
       "1000"],
      Annotation[#, 1000, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwNyDkvAwAYgOGvFkmLUdVW14jaHN1ajBSbKyZXGBydSo2SJiINERHHX+jv
cnSgOqlnePImb3bnuHSUiIg1Gt0RH8mIT95p8sV1KuJHW3zT5pea39HQP+3S
BDek6CFJH73ckmaAfgbJUGeYEYYYY5Q7JphknCly3DPDLNPkmeOBIvMUWGSB
R5YpscQqKzyxwSbrbLPFM3vss8shB7xwyhknlDnnlQsuqXBFlTf+Aak8KSg=

         "]], LineBox[CompressedData["
1:eJwVzj0vA2AUhuFjKrqy686ss+4kEgubgU2ja/0Af8fQiFClqqpKaX2FiIg0
TdhYK3G9w5Wc3MPJk1svLm+NRcQKnUzEkOfJiCd2shFl2tqAR+2BkrZNS/vk
XuuzqW3Q1D7oaXesaas0tHdutS5L2iJ17Y0b7ZqCtsCJ9kpHuyKvzVPTXmhr
l8xps1TTdlraBTlthsO0naZ2zrQ2xUHaTkM7Y0IbZz9tp66d8seIStpOzX3M
Lz/spe1U3Ud888WuX/+44j2m
         "]]},
       "500"],
      Annotation[#, 500, "Tooltip"]& ], {}, {}}}],
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{-100, 100}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.6564306455085692`*^9, 3.6564306854694576`*^9}, 
   3.656430715521944*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"6403bb54-7993-43bd-9ad4-406256ec31e6"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxtnQmcz9X3/63DLGYYLUSSLaWQRCp9rm3sDcaMZgaVSpbIUklUdkWbvSR9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    "], {{
      {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmwVsWVgO/9yePH/4oiyqJGAwgEFXn42FdZH2gmCgg6uEQQRxN1xC1O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          "]], PolygonBox[CompressedData["
1:eJwlk01IlVEQhifx3uxMtcmwhCAxhaCo3CRlC420VaVJi8IUwaIfjMRqkb+4
ddU2goIgEAIhCITiglRIxEVETBKJkJCKUozSRVLP9C5eeN75zpwzM+d8Ze03
mjoLzKwaFaLJZDaWMbsPf9xoNoF/im/Fz+Jb3WwUrs+atcGHUDd+F74KrkFD
+Er8MfgV+U/IryU2Tf5L/AN8MT6PX0nih8R+wv3ktJObJ9YHH3Tt3YE/AL9h
zQhrz+BnyP+DL4cfE1uHb7HmPOtzxLrhIlRlqmETfAmN4HP4y/Bh1Il/hq+G
c0m1xJ6T7L+T2Dm4iD1L4QE0b6pxEG5CR+F7xBrhPWhbVjnl8Ga0ntF8Ha6P
nrKa0Ql4PKn2qHGK8267eo8e7sTerlnGjI/AW1CDac+t8A5XbRErid5dd/eC
7xfgU2jYdKen4TrUi3+OPw7PcP44PEHsM+e/S5pFrJnD/8Av4Flq3+Hf6Au+
FP8LbnD1Hj2dhN8SG81oph/IzyedFTXM46eTZj+GX8BPJdUad/IJf5Y9Hplm
2hyHohW+7wX/svaa624b+X4dvuh6i5HTAi8l1RY1L8N3Xb29xvfAu11vJ950
GbzP9baj5v1wseutxhvbDt901Roz6oJXk2qJGazBV121xD9xBZ5NOus9fpF+
NrjuPnoogL/yHfz/D3yDK1xvO95MJfwPFrZ2qw==
          "]]}]}, 
      {RGBColor[0.5866663705809202, 0.5098827500444129, 0.47419612719843673`],
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuwVmUVxjfft7/97cspJCAQSEAUBClEKETQmFKgf0SRi8o1KIxzTBQ7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          "]], PolygonBox[CompressedData["
1:eJwll3m0jmUUxV/f9b33HZSQ8VbmKZWxwVirMv0TmYWIypiprislNKyERpkl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          "]]}]}, 
      {RGBColor[0.8994439509682004, 0.6198045834073548, 0.2903268786640611], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mXmQVdURxp9v7nv3nvvEhQSXAURkRhTFuJuIiVoCakAgKoILEYylkuAC
TmSIRhwyYMlSYAkIiQoKFUAxGjdSmkRMLFywTCoqqVQRRFOIaBEkFRdwy/eb
r/PHndP3vD7L7dP99Xd6+l5144U3VCuVyhj9aVL7Rb1SeTKrVO7Te1utUnlf
ncer/6OiUpmgvl1qD8srld56tuu3tWof1TNQY17K/I58m8Z+pt9HaGw9VSqT
Nbam9oHcOqvVv0S/v6XnJj3D9bysZ5ie6Xp+oae7dN7ReqM1dqvaperbpGeq
nvf0fpn6t6ldpnnv0JpHSx6l3zbqGdnkvW+P/Vf0+9eSx1W8l08lnyn522qf
1vsGyYMlb9Bzjp5bNOc/1d+uOdu135fUN5Q5ZZ/N6u8m/b/VvH++43r1D9P7
ZMnrog+dzzV+ovT3Mo9+/yjWpd0V8h0174+9Tat6n9jtXq27Rs9iPcvCztgP
u34aOhu07uq67cU6u+J7z1b7O72/Lbld37JN8q3aw1Ea31/PDP0+RuteUrP8
tHRKtQ+XeiR3kzxb+ndpXHfJt2qePybLj0rnGck9JM+Tzt665ZnS6ah6nkmS
75bczDySX0mWH9fYVyW3Sr6nsL/1lrxQOs8nyws4a409QvJS9b+ZLD9Z2j7V
OMfl6t+r95XqX5Pcv0ryV3XPv0I6/Wv2m7/GuaOP3TLZYFD0v62xAyQ/o7Fb
JZ/CutpDBV+W/ITEbeo/kbOVzgL198v9vltrfak5x0pncbLcqbFvJY9dLPnB
qufH56u5539B8mNV+x++917yfu4r7IfnhP/fLP0pud8/SD7XZdLZkTz2We2n
ofc98p/NDfvy94grjf1HzfHC9++o2597VRxPf696fsbtlN6YzL6BP6xT/2t6
f6jufa5s2MdWqN2j9cZxxlpzuHTH6umMeEVncMT05IjrJbn9uFnPCM3ZQayE
XbDPWZpvvfofqNvOw2O+NvxM6z2p/t+ofUo6S+s+09E1rzc9fIizHlT6zLDt
4NI+hC+dWtqm2Hao5BsLx8UMzbkx8xmz7gi1OzX/JP12snQ61Z4kndvUV9N6
50vnmtx+w/ip6t9H/adXjEf040tgJz6NP3Num6q291DNuVDt+ZpzUua1GDsu
t7+u1G+z1HbTnNcSC5n7+d7vauxczrVhPxgdZ3d57rXAavzqDY15QvLH7LnJ
8zysMWv1vkZtH/xZ8/dV/481Z4vkL9T/I8mHS96LvXPj2y9lq8vU3wscV/8N
pc/mxtL4BN4SRz8rfR63qv15aUy5XW27dF5sMv78NNkOUwufa2f4PL5zQpz3
dOm8K51faewPpHeI+j/RunPDd/gNTOJcbsHmyT68VPrnSf+b0v9vw/v9ft32
e13yn+r2t1f12+uSX1H7ZmZc4LyG5Y4NfHq45A8lXy35vNxYP7ZqP0YGzy8o
vefhpffdJasdn3nsMRXHEnMSa9gb+59LXEj+c92x8Sx4U3e+ek17+ovkjWpb
tO7ywJffNqzzeMM23hA4z97RXxq5hu8i3zyYfO53yh4HJmPlAcljBgee4HvX
Z/Zn/Jd3/BAMvzQ3jhMDk0KHPNOWOU99Kp1Lcp/D3OR5ehXGdfAanF+YrH94
xB8+Tyy0q29aZpwkntpj/raqZfrvTdZpLXyWnOmJpf354tzfRtx0xSq5DvtJ
/rhqHL4wN/4Si9cEvoPVd+fGNOJxYcQkfjUvdyyw996Z9z9Hax4UMvmrR+bc
d3zy+7eS8Qxcgw/cr3Z+cJ7DYk640ZF8R2bMPzJyBXg/X/Mfljmv9Y+98fug
5H2cnvy+IMYsij1PCZ9YEN/CHL1jnjWBseznLo2/Tv0HF/bDsZl9EluADfj8
o8En2DPxDw4MkZ3303u3+N5eybm8p9p7av4evmVZ+CdjlwUfWVP13paF3Cn9
IjMHoM1Dxk7Y67jMc+fBeeAY3UKnJXSYv2fYmfhvTdZrUXtnzXtln/AdvhfO
Q9yOD38mJ4CL4OdngQtnlMYD8hCYQP4Bd8F/4n9M2AosnRB5elqyDfeNHIsO
cQ0fIa9jf3LIlcEVwFj84IrMftQjfAksA9NOK73HCbHPjmT5G4XxnnzA3r/M
rMd+bk+eb7/gS+A+sXVE4fjp2bCP4CtNwRkWhc/MSY6PjsI4NSywF59ZHdwS
LBoVnAH+MDJ0wLfhIfP7yNCZkmzDm9U+Ujc3Bt+IR9YirncW5t//VtuUzFkz
2sLcd4/ac5L9arDaRXr+o7EPlo4LYoC99oqcxfzDk33ngmQcAAOwIRzh5djr
qYVz6K6G7ysfVO0bs5PlBzT/Hcljb5fuLM0/MzcmLwnOAs7D+fE/1uX3zty/
teW2L/6zPLjaQ1rr13H3eKxhXJ4a3LKLK0QePFM6B2hvuxvOFXByzpc54UVN
wSXaQ39k8CDsz1lNDwxvjnjn/jNQcybNuVNz7pd8j9g/7i7sGV/tiH2zZ76p
PbCC95uDW9K2hf90hk0Yuyi+l/5Lk/1jrNqLk/HsorjTwW/XBK/Ep7rH/WVx
7JNYaQ28Why+hw5r46dwGvgHPOTs0rZmH+Rf/Ks9zqKlcP74sOH71qw4u6HJ
awzhrpCMD/3U9iyc53ZIv3vhuNoueWByfB6XfG/C98hxhyZjVjP8Ohlnv5O8
3zVhN85hdcjYaVbYCrxYWzVn5ozmRn4Bz1oC9ybHGL4PHF4bGNo79OE5rbl5
OPojk+06IhmTwCZwnDX5ftaF99HPuuS/triPYCNsdbjseUBhfGxqmBPADQYU
5rhwqlMK88sunln4LgVGg8/kmccCx/rDidV/bGF8he+CsdhvctgQHCCntwUX
nZ95Dc7/ufCBjcmc/sKIiQHw2MwYyZwLg0s/FfOvlv4cyScWzhtzIndsjfpA
Dc6uvpmZeS/xBZ8jxh5K7j8usGF+6NAuyMwniaHO4CF7c9+d/iW7PZKsc1rh
XIhNTipsg86YZ0PEEr7MuuA2tibO+baBpb9/fqwFl+T88W34Fjbn7szdGo5B
XoM/wk2JY/Tho5uD57Au67Png+N9b9QZDil859tcM45sKy1/rvH71M3Z4HbE
1JaafZk7M+fdPXLdlOCxYOrWqA9gb+oU2Jw5uBeB89QUsHGP0j4Cf5odeXli
+AP3YfyyRTo7Ss9ZLZz3psY9iJoC339kco0ATnlCMkaD1c3qW5E592MfbIa/
dNUcCuedPqXrF9Qfeifzx5M1/6rM9y646LmF61D4at+4N6yKefh9VfgedYJp
USsgh68IvvGHZHlw4Rz4ds34CjflTPCH9eAFa0pnSWY+BLd5v7TNv9ZZHFqY
Z++vfc2u20/wDWz/ZeR99rI69gO+c96tpbkGnAOsIc/h0wNKz3Ff+Bjt/fFd
84KTgEVXBE+lLjYvMOf/tTxacuY7yff/q6PW1yfGLg+OB9fbnnyP+kmcz9WR
i+Gs/YIHkrf7BBe6KPLFtZx7w7zrUslb+C78vOFc3zPWWhIyGNsSa66L+1Sv
0OH3XpEXwELmgaNtSa5FXll4He6CT8T9BbvgO/jLpOAq8IKJwROwKXWBF+J+
RMwQL6MbxrtRhc+Msc1xb94Y85NXOLuDSuPYmVFLZf31oXN68PwRkcf2DayE
w4GX/QrnhJeCb29KHnt51Nm6/DPuIWDFkLijPx84Sc2O+9mxpfNIS9itM7AE
zHkjGYcvke7LyXF7QWFuDcc+o3C+4QzHF+Zh8DHO76lknx5U+O7SP+YHI/oH
Z5sf+x8Y94klwe2JS+ZHXpfsn2cFJveNPLEr6sz7Fz4vvuWWwEO4Nzz949y1
1y2lcQwMw0+2RU24KOwPe4KrEyucEWfLnhcEvyTHtsb+sVNr5OjlYTf2nwqv
Sd0LPJwRHBrMGxf8jZzdHDwHn2wO/4Rz4EM9S+ds8jSc8KuoT6wMrgRnYiz2
Oyr2g+6boc/eXwufHBI8Z0zUb96Ifr6FsTMijtkTdlzVMEdf3Yj6Vmbfha/B
O/Cx9ob3N7GwP3IHxyept3LPOSM5x1FPIc9tLi3vzl1/pA45mnpAwza+Kvb2
w7r3Rz3wraiNP1e6PnlZ+CD3YfgA9Ti48k0a+0nNuYE8ik/AIcBVcviskDcG
N4YjU+8Af48u7XfcV/kuagaMJfdSk6D+Tj6ifjUtuA3xynrjAy/n142ZXbgb
dbzntLcXJf++4f8HEEfdS9eLseO5yX5+V+Ruvpuz49vx6wXxHcOiBrAhONXS
uD9uCs4P9x9d91lz5tSx1gd+7C4du3lhrsRewTIwBo4EzmAL+Dl3tNkN/09i
TsM1a3B5VDJesQbzkxv5TjCFHAeekLupUV0fdaqtpc/uE9nyHcmbqAfm5nL4
IXbmfwDwmBNKc7OOiHHOCH3Oib0Sz8QynIWzhLdQe4ZzENvUmiZHzuVOz/+f
wOSxce+4oXCNChwEAzkr8vfMyJV74+yoA8GTbgu+S246MPgh/XA86obE3buF
fX1X8JkJhX0YX64Xtjm2p6bE+eCjnOfs+Bbq1tgUbKdejt93xWPu7yXXUNMk
HrdrvusKxxoxRw2V/5PxvdxLyUO7C/8/A/6R67tHBs8eHT74YvgKvkmOwT+P
CT4KNyePT4hcxl0aXv6Ffu+omz/w7WMjL5KHqZ/x7eQe6uvkEvIIGNARtvof
zlN8CA==
          "]], PolygonBox[CompressedData["
1:eJwllnnQjmUUxh/f977vdz/Pay87ZS/CRLaGkrJvydglUVNSiBTqyzZUlkkm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          "]]}]}, 
      {RGBColor[0.9498756439864985, 0.7446891099662463, 0.4446144963581453], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXm0VmUVxr/7Tec959xQUlATkwtqKUNqCZY24BDJkDmUSyPEC5hLBa4a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          "]], PolygonBox[CompressedData["
1:eJwtl3dsllUUxt9+bb/vvu9Xq2WUVGZZWkpRHAUUwo5SWpElpmJBpMQ4GCW4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          "]]}]}, 
      {RGBColor[0.9998401136969266, 0.8696002842423165, 0.5995043524604724], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXm0llUVxr/5nSDNzGkVmq2lRCVm4piCmKmoLAU1TQETvYAiOBSmIlAq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          "]], PolygonBox[CompressedData["
1:eJwtmHn0l1URxl++y+/33vtCLhgSJ0DpHCGpNBVZlD2TQE1URGVTkE0gVAgC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          "]]}]}, 
      {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lVts1kUQxZe20G/3r6KRBwgRgj5UH1QEeZBIiZEYiRcEY6EWuUmhFlS8
oCCSKBcLGmot95AiUSExVgNY4GslxEKhGiWlEKiQQrg0XCzQShFULPg7zPow
Oec/3+x8M7uzZ/tNen3UaxnOua1YJjbfO9cKuZRyrirbuT743grOTcAe6+rc
OHAAMb2ynBsIDsH6wXPBX4jfT/yHxNzJdyb+HmAKu0ZOD3bht3P4SxLncvi+
A34vWI0/l/wF4GhsMPwF8BNsInwxeJL8VeSvB0fw3RdeRZ7H4VvgzeT5G2sh
50L81yKXbyT2EHwUOMvZ/x4hZgs2kPzPkuNJfrsP/3DwA77z8S8Ap2HD4TXE
FsGfgE8Bl2JT4Z8FM/GfEqtVNdfB88g1iJyjwQa+G7s5tw88SA9PUUcN2Mle
d7A/18Emvl/Evx08gD0KT4OF5BxGzpfBebE21bg8WH79j3pQLyODxSk+nVit
qrk42J5qb/PBV2Nf6u9NbAT8HXAPaybDl8Dfjn79Pht7Hv4u+ByWR81fU/MY
eAG8Et5Crbuo+Wf1gb8OngdmYxVdnLuI/1Z4OzUn4CnWHGdtC3g6zo/maBs1
nIKfg1fDe7P2PPwV1hQRv4n4ifDbiSkNVpNqOwM2aS37fBA8y5oTxOwFK9mj
8iw7/z/gx+BtYAH2CHws2I31rfAs8AbfX/C/7ay9Aj+B/zJ4HTsN/xfchK2A
F5PzKnwd8W3EX4Ivh1+A1ye2D9qPw+oBvkP7lNjcan7Hxfs1SXcnzrZmvCf2
gHok9i74EHgZ/GH4IvhqeIAfgHeqD/hK+Br8t8G/oYbL/FcufAP+CvwbiFus
e4fvQZ0r/pX474Y/DS9P7Px0jml8M7E57Pm2lN1P3dOXQI91J+ZP8nUSn4OQ
HNKeaw6I/5Hfp3s7X53zWL6fga9P2dxofsbjm+EtXus2Y8Xw6fiPk3M9+Xdn
2yxqJsvAHM0b/mVJ7AfeSI56rJK+6sBG1twvXQPn8p2P/z1vuZSzCb4LvgL+
q7c1WjuI3J9ihdSwkVpWR+2Shq3B5hJzD7/vh6fhDWAZ9ga8D/6vou5J/3T2
N2fA23noXPZ429+b+wyvJaYEXgtfGvMon+6J7kuRN52SXkkvv4szrFkujfO/
m9+PxV7Uk+ZDc1JCzM6o1dJszbHmOUMzgkHdRny/Rd2T/mmeNFc/eJsbzc80
b32q38GsWwgvhPeCb9fMw6u9zahm9X1v+iUd+xL+Ef4M8rTiO6K9Jn5osLPR
Gc3zdpY60wpvd0N35Ftvd0l36h9vM6pZ3az7F2zeNHel3vRTOloTdXWVt/PW
ufeQzkT91zuQjrq6BL4o9qKejsbaVOP8YHOoecyMb5beLmmQtKhrsH7U19Rg
OiW9amft7/Cz8FvwX+S7mbXnvWmHNOQvb++r3tmOlGmNNCcVTFOkLS6Ypuie
HqbvtXH2NIPN/8+M9ilqlzSsPr6PJ+HfR12SPiVRb7sHy6Wc0oCG+L7rnW+L
etgB7qOmz6mtFtwb33e987q3ur8NKdNf6XA5ORck1q/6ro1rlwXrWb2vCqYd
0pBZwWZFM9M/2Juht+PjYPdN924y/D8k+D33
          "]], PolygonBox[CompressedData["
1:eJwtlFtMz1EcwE/9/13O+SHGg2ZYPJQHt8VDjcxmtoYhW0kZtVoXuc1lGj2o
KMxlpYuHaG4vLg9khAeU8sC6LbHFuvwX1lg0l2ni893Xw3f7fK/nnO/5nhOV
uTtpV7AxJhXxIynWmKVAJzwUBjtjbqKXoy+B9yGz4PUhxuyHJyAf0UeImQjP
RYrgtdjmwIuQevRC9IVwmWfMJ/TgIGOOw/HYHqDX4I+DjzpdO5X6xfAKpBn/
dWwJ8CHksM+YTfgL4d/st55aAWLG4GZqZuC7R3wTXEtMLz5CTA18Eknzacwp
uIGY2fhiJQdOp0Yc8f3YPnL+UfT36FUU+AZPIyfVrzlT4W1IMvVWkr9dzoI0
yV7RG+FIJJv4Bdimw1miE78KfzZcgOSjJ6LvhEOQGaw1TE4oHIxcDtKe+eAc
p71bTXyu3AWyF99y6s+EDTLk15y/7Dfcaa069DD4F7Z+v/bsJ/wH6TKaMw4f
87SXcqelcLL0H45nvRQ4BjmBPw1bNBzh9O5vUG+SnN/Tsw3ivw9/p2aE0TV/
SP8QH5yH7S39fUJOgPPPR+9AD4Qb0+fTGWtDb0Nfh34JaYePWO2l3EERvMPq
2pJTAD9nzcn4s9hDC1xnda8ykxfhFquzJjPdCltkjNwt2HpYb5w1RtHXoHej
P7I6+zLDj+EEJAq+hq0P/4jVs8qMfIVjkUi4Wmz4O6zOrsx4J1xm9a5kJsrh
XKt3IzOXB8cgU+AyYnrJv2W1VxXYbsN3rL6lavS78Cj7HWa/y7B1Ed9rdfbl
zbyD893/WSEmDy622mvJKYErrL5VmaFKeKvT2ZWep8Pt9LAjVGc6QP1zTnsr
M3wWfujp7MrMNsIHnf4N8kYPwB+cvtVoPpkhOIk1Fvu1Zhvxrz31DaL3wJlO
35LcYYa8NaezJ292M9ztaazMzB5qbXT6duUNboATsc2jfgP5A+y3x+pdie2N
nNdpL3LIqYSfWu213NkzeMBqruxxEH5p9S7lzl/BpU7/JnmzJfALT2vJG2mF
r1idJZnxq3Ct1VmSGbsAn7Z6VzJjZ+DzTmdb/twq+LPVv0b+rC/wP6JkxO4=

          "]]}]}}, {{}, 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0bsv5FEYBuCDwq2koCBBsbpV2ILCFnq3xLIK1m1dCvoNjcQ9xm0TuxFK
iUQx4xKEzhg6oSP8AeKyrHYXzxRPvu99z5mc5DdFHYMNAykhhBGi6SEsZYXw
i/vMEB55SNL/NV/4wzNP3Op3s0PYo9NvuukimhHCrDnHDAnnx0Ts7XTQyjfa
WHe/zqynhh13t6m155DLD+8NM0TEWZ4un1F5gnHm9AW6wuTb8iILSfpiXQnL
8ior/NR/0JWyJl/K/b5DzL7FJku6j87L2JcPOeC3vlz3ibh8QoJlfYWukjP5
gvPke/oq3Weu5BuuqZaPnMWZtE8zxYZv0mx+pZEmvtDCibunzNsXWSDmfp/Z
z3d66eHOfzTm7jgpchqpPOnfvB/s/8xX/pMlvwPtQk02
          "]], 
         LineBox[{3034, 120, 2476, 2478, 2477, 1982, 2009, 2324, 2323, 2468, 
          2467, 1980, 2007, 2313, 2312, 2457, 2456, 1978, 2005, 2302, 2301, 
          2446, 2445, 1976, 2003, 2291, 2290, 2435, 2434, 1974, 2001, 2752, 
          2280, 2416, 3029, 3031, 3030, 2045, 2790, 2791, 2679, 2681, 2680, 
          2231, 2677, 2678, 2674, 2676, 2675, 1972, 1999, 2276, 2275, 2412, 
          2411, 2036, 2574, 2575, 2571, 2573, 2572, 2026, 2948, 2949, 2553, 
          2555, 2554, 2031, 2551, 2552, 2548, 2550, 2549, 2569}], 
         LineBox[{1997, 2024, 2396, 2395, 2409, 2408, 2030, 2567, 2568, 2564, 
          2566, 2565, 2028, 3001, 3002, 2667, 2669, 2668, 2226, 2691, 2692, 
          2688, 2690, 2689, 1995, 2022, 2391, 2390, 2709, 2708, 2241, 2256, 
          2255, 2213, 2652, 2653, 2651, 2745, 2744, 1993, 2020, 3024, 3023, 
          2386, 2385, 2531, 2530, 1991, 2018, 2377, 2376, 2520, 2519, 1989, 
          2016, 2366, 2365, 2509, 2508, 1987, 2014, 2355, 2354, 2498, 2497, 
          1985, 2012, 2344, 2343, 3034}]},
        "2500"],
       Annotation[#, 2500, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0TsoRnEcxvG/wX1BZOEtC6FQIgaFEROKwf26uSWDIvXKpV4ppcQsSrFI
ym2wYLC4FErEZrNYDD6Gb9/n9zznnOXk9Y02j8SFEGYxnRTCV3II49zJXejG
pPsUH6khnPAdfhLZfSjf4ALv7gN+xRWucYallBAW0etbe+5meYZXPJ8tx3Om
O4GzeN5zc5xjS9flyhkc4VVblPNsubp8OcIFvGlb4Hxboa5ULuIy3rYtc7Gt
QlclV3I1H9hiXGL71tXJtVzPx7ZVLrc16hrkJm7kS9saV9nadC1yO7fyrW2d
a2z9ug55gDv5ybbB9bZR3aA8xkP8advimO2c+90DGMSj+0X/jCPP77uH9MM4
ku91v/7Lg7yDN/cuTyHdO2mI6ib+v8M93nvS/QG160It
          "]], LineBox[CompressedData["
1:eJwV0T9I1HEYB+D3OuHqPCfp3LzaypsEdWhJaQisFq3BpeGgzX8hLTV3o+DS
dBhdXkZWZGdQDlZX4SCKRmB0RdCUtmUJEXY9Nzx83vf9fH+33PHCxNB4IiKm
mT0c8f1IxJi83hoxKg9kZCIa8pr9tayxwite8sH9TypiwrfjXE1HTPLMfVDO
yYfe3ZULcoN13toP+e0kCW55W/D9I/eL5mHO2Qdp0V92v+K7un1JNyD7Oc0l
3Yhu07yo65O99HBed0H3zvxYl5ddnOSMbkC3bF7QHZM5OjmleyLvu3fILEfp
ds/7Zt5c0WVkK2lO6HK6krmsS8ig0bzTrpux39bt23/ziywpXVFX0v2w77JD
G3/dbujOynveld2+yjuyIqs85YH9pjdFauYvfG6+JVjjDXU+kaTKe9/u+Q+3
zT/lVvP/NU+xzDf7i+Y7/uk/2p+bV/kPXIBRoQ==
          "]]},
        "2000"],
       Annotation[#, 2000, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0DssQ1EcB+DTIt6MHpMySTBYEBsGol0MVomRaOMxec52qxCVagVFGLuK
AYlYRWIjQWJSE98dvvzO+Z3/uTf3JmYzU+lYCGGeWE0IS7UhLDPHc10I39Uh
3On3OagP4ZAsJVadr7Fo9k3+mb03d+Qsz7juWBaYsN401+T8g0++2NVv61us
fyjzG71Pv6PvsI7LCirJ6vdkt74xeh7N5PR52a9vlW20U9BfyWF9QnbSxYm+
JMf0PbKXPor6W5nSD8hBhrjUP8lp/Ygcje5yrX+RM/qqhhCS0V3W9RvRN7Ni
/y7jZh449T/OmNSlSLJFmgwL5l9l2f98NJ+jaP6Cc27s/wH9pzpP
          "]], LineBox[CompressedData["
1:eJwV0L8rxHEcx/GPuvLjDKIsbqBcSTFIblHHoLC5wcB2TNSZr5QoJSel1JWy
WP0BBgaLgTOLcud3kiTFJQwe3+HV8/V+Pb99h09HdiGTqwkh5CRWF8JhPIQj
eWwI4Ul+a0O4sv/gg/tezvmS7Nqf60OYx7x7Dv9wxDc7+h03iznbTPQPHOaK
+gU3jVnbFH7jILetl7gMTtomsIopbks/5sZw3DaKn9jHbeoH3BCmbWn8wB6u
oO9zKey3DeA7dnNr+h7Xi13R9/iGSW5VL3JJTNg68RXbuRV9g0tgk60NXyJy
S/oy14IxW3P0TtjKLUZvxTVG7+GO4zVXkbLk3etYkBv+Vqre/tL+hRV3Wc74
Uzmx/wN+s0C7
          "]]},
        "1500"],
       Annotation[#, 1500, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0D0oxHEcx/GvlHNn8FAGZ5CHktwiD4tcBp1MpBTjnYWBM+lKCSlFSqkr
UrJaldVutxu4dEkk6VLyMvx7fX7f9/bvLhTn1+siYtl3k4g4T0U8NUU0NEZ8
2AluJiNKbPN+1pJ2zU6xpG2x3buitdj1bOWOts209uLWYTczzSNtl11a1a3H
7mQvy9o++7RXt0G7nxleaQcc0N7cRuxhjvJaO2RGe3ebsLPM8lY75pD26Zaz
ZzjNO+2EY9qX26y9wDnea6cc177dFu08l/iglTmp1dzy9hoLfNTOOKX9uK38
/yuusqJdMKf9uhXtPW6wql3yD5OUMvA=
          "]], LineBox[CompressedData["
1:eJwVyz1IAlAYhtHboKmL2RSUg2ANLRVt1WptGpb0M0VLm03h6N7eEEIUBGEg
CGJCQnt7eylYNJVrOXgcDu/Hc7mZ0/NieSqEUKISC+EiHkLEftCjz3XCmx5z
D/jki5pe1ZPuH34ZcqNf6nPuP/4Zcadf6Rl3xEaZ5l6/tcv6jE0xy4Net+v6
vF0gzaPetlt61i6yREN/sTl9xa6yRlN/tXl9w25O/tLS3+yBnrPb7PCkv9sT
PW8L7NLRB/ZM37P7lHjWv21ZP7RHHNPVx6MFLIw=
          "]]},
        "1000"],
       Annotation[#, 1000, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwNyDkvAwAYgOGvFkmLUdVW14jaHN1ajBSbKyZXGBydSo2SJiINERHHX+jv
cnSgOqlnePImb3bnuHSUiIg1Gt0RH8mIT95p8sV1KuJHW3zT5pea39HQP+3S
BDek6CFJH73ckmaAfgbJUGeYEYYYY5Q7JphknCly3DPDLNPkmeOBIvMUWGSB
R5YpscQqKzyxwSbrbLPFM3vss8shB7xwyhknlDnnlQsuqXBFlTf+Aak8KSg=

          "]], LineBox[CompressedData["
1:eJwVzj0vA2AUhuFjKrqy686ss+4kEgubgU2ja/0Af8fQiFClqqpKaX2FiIg0
TdhYK3G9w5Wc3MPJk1svLm+NRcQKnUzEkOfJiCd2shFl2tqAR+2BkrZNS/vk
XuuzqW3Q1D7oaXesaas0tHdutS5L2iJ17Y0b7ZqCtsCJ9kpHuyKvzVPTXmhr
l8xps1TTdlraBTlthsO0naZ2zrQ2xUHaTkM7Y0IbZz9tp66d8seIStpOzX3M
Lz/spe1U3Ud888WuX/+44j2m
          "]]},
        "500"],
       Annotation[#, 500, "Tooltip"]& ], {}, {}}}], {{}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.03335821094834732, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-92.85256023805036, -3.8729344042320064`}, \
{-107.14743976194963`, -4.127065595767994}}]}}, 
     {Arrowheads[{{0.03335681282065341, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-92.85256023805036, -3.3196580607702915`}, \
{-107.14743976194963`, -3.537484796372566}}]}}, 
     {Arrowheads[{{0.033355629743754556`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-92.85256023805036, -2.7663817173085765`}, \
{-107.14743976194963`, -2.947903996977139}}]}}, 
     {Arrowheads[{{0.033354661740534045`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-92.85256023805036, -2.2131053738468616`}, \
{-107.14743976194963`, -2.3583231975817114`}}]}}, 
     {Arrowheads[{{0.0333539088297176, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-92.85256023805036, -1.6598290303851464`}, \
{-107.14743976194963`, -1.7687423981862838`}}]}}, 
     {Arrowheads[{{0.03335337102587156, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-92.85256023805036, -1.1065526869234312`}, \
{-107.14743976194963`, -1.1791615987908561`}}]}}, 
     {Arrowheads[{{0.033353048339401434`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-92.85256023805036, -0.5532763434617161}, \
{-107.14743976194963`, -0.5895807993954285}}]}}, 
     {Arrowheads[{{0.03335294077655096, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-92.85256023805036, -8.599641896882574*^-16}, \
{-107.14743976194963`, -9.163926497119932*^-16}}]}}, 
     {Arrowheads[{{0.033353048339401434`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-92.85256023805036, 
        0.5532763434617143}, {-107.14743976194963`, 0.5895807993954266}}]}}, 
     {Arrowheads[{{0.03335337102587156, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-92.85256023805036, 
        1.1065526869234295`}, {-107.14743976194963`, 1.1791615987908544`}}]}}, 
     {Arrowheads[{{0.0333539088297176, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-92.85256023805036, 
        1.6598290303851446`}, {-107.14743976194963`, 1.7687423981862818`}}]}}, 
     {Arrowheads[{{0.033354661740534045`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-92.85256023805036, 
        2.21310537384686}, {-107.14743976194963`, 2.3583231975817096`}}]}}, 
     {Arrowheads[{{0.033355629743754556`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-92.85256023805036, 
        2.7663817173085747`}, {-107.14743976194963`, 2.947903996977137}}]}}, 
     {Arrowheads[{{0.03335681282065341, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-92.85256023805036, 
        3.3196580607702897`}, {-107.14743976194963`, 3.5374847963725644`}}]}}, 
     {Arrowheads[{{0.03335821094834732, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-92.85256023805036, 
        3.8729344042320046`}, {-107.14743976194963`, 4.127065595767992}}]}}, 
     {Arrowheads[{{0.028594383309711993`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-79.58790877547173, -3.8729344042320064`}, \
{-91.84066265309968, -4.127065595767994}}]}}, 
     {Arrowheads[{{0.028592752241440575`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-79.58790877547173, -3.3196580607702915`}, \
{-91.84066265309968, -3.537484796372566}}]}}, 
     {Arrowheads[{{0.02859137203407246, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-79.58790877547173, -2.7663817173085765`}, \
{-91.84066265309968, -2.947903996977139}}]}}, 
     {Arrowheads[{{0.028590242723938893`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-79.58790877547173, -2.2131053738468616`}, \
{-91.84066265309967, -2.3583231975817114`}}]}}, 
     {Arrowheads[{{0.02858936434077209, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-79.58790877547173, -1.6598290303851464`}, \
{-91.84066265309968, -1.7687423981862838`}}]}}, 
     {Arrowheads[{{0.028588736907700998`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-79.58790877547173, -1.1065526869234312`}, \
{-91.84066265309968, -1.1791615987908561`}}]}}, 
     {Arrowheads[{{0.028588360441248562`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-79.58790877547173, -0.5532763434617161}, \
{-91.84066265309968, -0.5895807993954285}}]}}, 
     {Arrowheads[{{0.02858823495132941, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-79.58790877547173, -8.599641896882574*^-16}, \
{-91.84066265309968, -9.163926497119932*^-16}}]}}, 
     {Arrowheads[{{0.028588360441248562`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-79.58790877547173, 
        0.5532763434617143}, {-91.84066265309968, 0.5895807993954266}}]}}, 
     {Arrowheads[{{0.028588736907700998`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-79.58790877547173, 
        1.1065526869234295`}, {-91.84066265309968, 1.1791615987908544`}}]}}, 
     {Arrowheads[{{0.02858936434077209, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-79.58790877547173, 
        1.6598290303851446`}, {-91.84066265309968, 1.7687423981862818`}}]}}, 
     {Arrowheads[{{0.028590242723938893`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-79.58790877547173, 2.21310537384686}, {-91.84066265309967, 
        2.3583231975817096`}}]}}, 
     {Arrowheads[{{0.02859137203407246, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-79.58790877547173, 
        2.7663817173085747`}, {-91.84066265309968, 2.947903996977137}}]}}, 
     {Arrowheads[{{0.028592752241440575`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-79.58790877547173, 
        3.3196580607702897`}, {-91.84066265309968, 3.5374847963725644`}}]}}, 
     {Arrowheads[{{0.028594383309711993`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-79.58790877547173, 
        3.8729344042320046`}, {-91.84066265309968, 4.127065595767992}}]}}, 
     {Arrowheads[{{0.023830906807186993`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-66.3232573128931, -3.8729344042320064`}, \
{-76.53388554424973, -4.127065595767994}}]}}, 
     {Arrowheads[{{0.023828949685844335`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-66.3232573128931, -3.3196580607702915`}, \
{-76.53388554424973, -3.537484796372566}}]}}, 
     {Arrowheads[{{0.023827293534533802`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-66.3232573128931, -2.7663817173085765`}, \
{-76.53388554424973, -2.947903996977139}}]}}, 
     {Arrowheads[{{0.023825938416017073`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-66.3232573128931, -2.2131053738468616`}, \
{-76.53388554424973, -2.3583231975817114`}}]}}, 
     {Arrowheads[{{0.023824884381660836`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-66.3232573128931, -1.6598290303851464`}, \
{-76.53388554424973, -1.7687423981862838`}}]}}, 
     {Arrowheads[{{0.023824131471427045`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-66.3232573128931, -1.1065526869234312`}, \
{-76.53388554424973, -1.1791615987908561`}}]}}, 
     {Arrowheads[{{0.02382367971386539, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-66.3232573128931, -0.5532763434617161}, \
{-76.53388554424973, -0.5895807993954285}}]}}, 
     {Arrowheads[{{0.023823529126107832`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-66.3232573128931, -8.599641896882574*^-16}, \
{-76.53388554424973, -9.163926497119932*^-16}}]}}, 
     {Arrowheads[{{0.02382367971386539, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-66.3232573128931, 0.5532763434617143}, {-76.53388554424973,
         0.5895807993954266}}]}}, 
     {Arrowheads[{{0.023824131471427045`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-66.3232573128931, 
        1.1065526869234295`}, {-76.53388554424973, 1.1791615987908544`}}]}}, 
     {Arrowheads[{{0.023824884381660836`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-66.3232573128931, 
        1.6598290303851446`}, {-76.53388554424973, 1.768742398186282}}]}}, 
     {Arrowheads[{{0.023825938416017073`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-66.3232573128931, 2.21310537384686}, {-76.53388554424973, 
        2.3583231975817096`}}]}}, 
     {Arrowheads[{{0.023827293534533802`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-66.3232573128931, 
        2.7663817173085747`}, {-76.53388554424973, 2.947903996977137}}]}}, 
     {Arrowheads[{{0.023828949685844335`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-66.3232573128931, 
        3.3196580607702897`}, {-76.53388554424973, 3.5374847963725644`}}]}}, 
     {Arrowheads[{{0.023830906807186993`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-66.3232573128931, 
        3.8729344042320046`}, {-76.53388554424973, 4.127065595767992}}]}}, 
     {Arrowheads[{{0.01906804459940055, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-53.058605850314486`, -3.8729344042320064`}, \
{-61.227108435399785`, -4.127065595767994}}]}}, 
     {Arrowheads[{{0.019065598567115535`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-53.058605850314486`, -3.3196580607702915`}, \
{-61.227108435399785`, -3.537484796372566}}]}}, 
     {Arrowheads[{{0.01906352860235307, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-53.058605850314486`, -2.7663817173085765`}, \
{-61.227108435399785`, -2.947903996977139}}]}}, 
     {Arrowheads[{{0.019061834827627046`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-53.058605850314486`, -2.2131053738468616`}, \
{-61.227108435399785`, -2.3583231975817114`}}]}}, 
     {Arrowheads[{{0.01906051734322559, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-53.058605850314486`, -1.6598290303851464`}, \
{-61.227108435399785`, -1.7687423981862838`}}]}}, 
     {Arrowheads[{{0.019059576227181386`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-53.058605850314486`, -1.1065526869234312`}, \
{-61.227108435399785`, -1.1791615987908561`}}]}}, 
     {Arrowheads[{{0.019059011535248582`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-53.058605850314486`, -0.5532763434617161}, \
{-61.227108435399785`, -0.5895807993954285}}]}}, 
     {Arrowheads[{{0.01905882330088627, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-53.058605850314486`, -8.599641896882574*^-16}, \
{-61.227108435399785`, -9.163926497119932*^-16}}]}}, 
     {Arrowheads[{{0.019059011535248582`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-53.058605850314486`, 
        0.5532763434617143}, {-61.227108435399785`, 0.5895807993954266}}]}}, 
     {Arrowheads[{{0.019059576227181386`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-53.058605850314486`, 
        1.1065526869234295`}, {-61.227108435399785`, 1.1791615987908544`}}]}}, 
     {Arrowheads[{{0.01906051734322559, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-53.058605850314486`, 
        1.6598290303851446`}, {-61.227108435399785`, 1.7687423981862818`}}]}}, 
     {Arrowheads[{{0.019061834827627046`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-53.058605850314486`, 
        2.21310537384686}, {-61.227108435399785`, 2.3583231975817096`}}]}}, 
     {Arrowheads[{{0.01906352860235307, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-53.058605850314486`, 
        2.7663817173085747`}, {-61.227108435399785`, 2.947903996977137}}]}}, 
     {Arrowheads[{{0.019065598567115535`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-53.058605850314486`, 
        3.3196580607702897`}, {-61.227108435399785`, 3.5374847963725644`}}]}}, 
     {Arrowheads[{{0.01906804459940055, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-53.058605850314486`, 
        3.8729344042320046`}, {-61.227108435399785`, 4.127065595767992}}]}}, 
     {Arrowheads[{{0.014306410228929764`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-39.79395438773586, -3.8729344042320064`}, \
{-45.920331326549835`, -4.127065595767994}}]}}, 
     {Arrowheads[{{0.014303149915878517`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-39.79395438773586, -3.3196580607702915`}, \
{-45.920331326549835`, -3.537484796372566}}]}}, 
     {Arrowheads[{{0.014300390608876081`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-39.79395438773586, -2.7663817173085765`}, \
{-45.920331326549835`, -2.947903996977139}}]}}, 
     {Arrowheads[{{0.014298132597980519`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-39.79395438773586, -2.2131053738468616`}, \
{-45.920331326549835`, -2.3583231975817114`}}]}}, 
     {Arrowheads[{{0.014296376120720287`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-39.79395438773586, -1.6598290303851464`}, \
{-45.920331326549835`, -1.7687423981862838`}}]}}, 
     {Arrowheads[{{0.014295121361969447`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-39.79395438773586, -1.1065526869234312`}, \
{-45.92033132654983, -1.1791615987908561`}}]}}, 
     {Arrowheads[{{0.014294368453850499`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-39.79395438773586, -0.5532763434617161}, \
{-45.920331326549835`, -0.5895807993954285}}]}}, 
     {Arrowheads[{{0.014294117475664706`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-39.79395438773586, -8.599641896882574*^-16}, \
{-45.920331326549835`, -9.163926497119932*^-16}}]}}, 
     {Arrowheads[{{0.014294368453850499`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-39.79395438773586, 
        0.5532763434617143}, {-45.920331326549835`, 0.5895807993954266}}]}}, 
     {Arrowheads[{{0.014295121361969447`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-39.79395438773586, 
        1.1065526869234295`}, {-45.92033132654983, 1.1791615987908544`}}]}}, 
     {Arrowheads[{{0.014296376120720287`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-39.79395438773586, 
        1.6598290303851446`}, {-45.920331326549835`, 1.7687423981862818`}}]}}, 
     {Arrowheads[{{0.014298132597980519`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-39.79395438773586, 
        2.21310537384686}, {-45.920331326549835`, 2.3583231975817096`}}]}}, 
     {Arrowheads[{{0.014300390608876081`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-39.79395438773586, 
        2.7663817173085747`}, {-45.920331326549835`, 2.947903996977137}}]}}, 
     {Arrowheads[{{0.014303149915878517`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-39.79395438773586, 
        3.3196580607702897`}, {-45.920331326549835`, 3.5374847963725644`}}]}}, 
     {Arrowheads[{{0.014306410228929764`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-39.79395438773586, 
        3.8729344042320046`}, {-45.920331326549835`, 4.127065595767992}}]}}, 
     {Arrowheads[{{0.00954784088859488, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-26.52930292515724, -3.8729344042320064`}, \
{-30.613554217699885`, -4.127065595767994}}]}}, 
     {Arrowheads[{{0.009542954967492703, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-26.52930292515724, -3.3196580607702915`}, \
{-30.613554217699885`, -3.537484796372566}}]}}, 
     {Arrowheads[{{0.009538818771835919, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-26.52930292515724, -2.7663817173085765`}, \
{-30.613554217699885`, -2.947903996977139}}]}}, 
     {Arrowheads[{{0.009535433277252333, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-26.52930292515724, -2.2131053738468616`}, \
{-30.613554217699885`, -2.3583231975817114`}}]}}, 
     {Arrowheads[{{0.009532799283557759, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-26.52930292515724, -1.6598290303851464`}, \
{-30.613554217699885`, -1.7687423981862838`}}]}}, 
     {Arrowheads[{{0.009530917413813515, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-26.52930292515724, -1.1065526869234312`}, \
{-30.613554217699885`, -1.1791615987908561`}}]}}, 
     {Arrowheads[{{0.009529788113590685, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-26.52930292515724, -0.5532763434617161}, \
{-30.613554217699885`, -0.5895807993954285}}]}}, 
     {Arrowheads[{{0.009529411650443126, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-26.52930292515724, -8.599641896882574*^-16}, \
{-30.613554217699885`, -9.163926497119932*^-16}}]}}, 
     {Arrowheads[{{0.009529788113590685, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-26.52930292515724, 
        0.5532763434617143}, {-30.613554217699885`, 0.5895807993954266}}]}}, 
     {Arrowheads[{{0.009530917413813515, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-26.52930292515724, 
        1.1065526869234295`}, {-30.613554217699885`, 1.1791615987908544`}}]}}, 
     {Arrowheads[{{0.009532799283557759, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-26.52930292515724, 
        1.6598290303851446`}, {-30.613554217699885`, 1.7687423981862818`}}]}}, 
     {Arrowheads[{{0.009535433277252333, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-26.52930292515724, 
        2.21310537384686}, {-30.613554217699885`, 2.3583231975817096`}}]}}, 
     {Arrowheads[{{0.009538818771835919, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-26.52930292515724, 
        2.7663817173085747`}, {-30.613554217699885`, 2.947903996977137}}]}}, 
     {Arrowheads[{{0.009542954967492703, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-26.52930292515724, 
        3.3196580607702897`}, {-30.613554217699885`, 3.5374847963725644`}}]}}, 
     {Arrowheads[{{0.00954784088859488, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-26.52930292515724, 
        3.8729344042320046`}, {-30.613554217699885`, 4.127065595767992}}]}}, 
     {Arrowheads[{{0.00480145819842508, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-13.264651462578614`, -3.8729344042320064`}, \
{-15.30677710884994, -4.127065595767994}}]}}, 
     {Arrowheads[{{0.004791735041599526, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-13.264651462578614`, -3.3196580607702915`}, \
{-15.30677710884994, -3.537484796372566}}]}}, 
     {Arrowheads[{{0.004783492318299303, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-13.264651462578614`, -2.7663817173085765`}, \
{-15.30677710884994, -2.947903996977139}}]}}, 
     {Arrowheads[{{0.004776737692424645, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-13.264651462578614`, -2.2131053738468616`}, \
{-15.30677710884994, -2.3583231975817114`}}]}}, 
     {Arrowheads[{{0.004771477483746356, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-13.264651462578614`, -1.6598290303851464`}, \
{-15.30677710884994, -1.7687423981862838`}}]}}, 
     {Arrowheads[{{0.004767716638626171, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-13.264651462578614`, -1.1065526869234312`}, \
{-15.30677710884994, -1.1791615987908561`}}]}}, 
     {Arrowheads[{{0.004765458706906762, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-13.264651462578614`, -0.5532763434617161}, \
{-15.30677710884994, -0.5895807993954285}}]}}, 
     {Arrowheads[{{0.0047647058252215675`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-13.264651462578614`, -8.599641896882574*^-16}, \
{-15.30677710884994, -9.163926497119932*^-16}}]}}, 
     {Arrowheads[{{0.004765458706906762, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-13.264651462578614`, 
        0.5532763434617143}, {-15.30677710884994, 0.5895807993954266}}]}}, 
     {Arrowheads[{{0.004767716638626171, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-13.264651462578614`, 
        1.1065526869234295`}, {-15.30677710884994, 1.1791615987908544`}}]}}, 
     {Arrowheads[{{0.004771477483746356, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-13.264651462578614`, 
        1.6598290303851446`}, {-15.30677710884994, 1.7687423981862818`}}]}}, 
     {Arrowheads[{{0.004776737692424645, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-13.264651462578614`, 
        2.21310537384686}, {-15.30677710884994, 2.3583231975817096`}}]}}, 
     {Arrowheads[{{0.004783492318299303, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-13.264651462578614`, 
        2.7663817173085747`}, {-15.30677710884994, 2.947903996977137}}]}}, 
     {Arrowheads[{{0.004791735041599526, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-13.264651462578614`, 
        3.3196580607702897`}, {-15.30677710884994, 3.5374847963725644`}}]}}, 
     {Arrowheads[{{0.00480145819842508, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-13.264651462578614`, 
        3.8729344042320046`}, {-15.30677710884994, 4.127065595767992}}]}}, 
     {Arrowheads[{{0.0005929411693609074, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{9.89635682608107*^-15, -3.8729344042320064`}, {
        1.1419925246721935`*^-14, -4.127065595767994}}]}}, 
     {Arrowheads[{{0.000508235288023634, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{9.89635682608107*^-15, -3.3196580607702915`}, {
        1.1419925246721935`*^-14, -3.537484796372566}}]}}, 
     {Arrowheads[{{0.0004235294066863617, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{9.89635682608107*^-15, -2.7663817173085765`}, {
        1.1419925246721935`*^-14, -2.947903996977139}}]}}, 
     {Arrowheads[{{0.00033882352534908935`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{9.89635682608107*^-15, -2.2131053738468616`}, {
        1.1419925246721935`*^-14, -2.3583231975817114`}}]}}, 
     {Arrowheads[{{0.000254117644011817, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{9.89635682608107*^-15, -1.6598290303851464`}, {
        1.1419925246721935`*^-14, -1.7687423981862838`}}]}}, 
     {Arrowheads[{{0.00016941176267454467`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{9.89635682608107*^-15, -1.1065526869234312`}, {
        1.1419925246721935`*^-14, -1.1791615987908561`}}]}}, 
     {Arrowheads[{{0.00008470588133727234, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{9.89635682608107*^-15, -0.5532763434617161}, {
        1.1419925246721935`*^-14, -0.5895807993954285}}]}}, 
     {Arrowheads[{{3.557240769010676*^-18, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{9.89635682608107*^-15, -8.599641896882574*^-16}, {
        1.1419925246721935`*^-14, -9.163926497119932*^-16}}]}}, 
     {Arrowheads[{{0.00008470588133727208, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{9.89635682608107*^-15, 0.5532763434617143}, {
        1.1419925246721935`*^-14, 0.5895807993954266}}]}}, 
     {Arrowheads[{{0.00016941176267454467`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{9.89635682608107*^-15, 1.1065526869234295`}, {
        1.1419925246721935`*^-14, 1.1791615987908544`}}]}}, 
     {Arrowheads[{{0.00025411764401181647`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{9.89635682608107*^-15, 1.6598290303851446`}, {
        1.1419925246721935`*^-14, 1.7687423981862818`}}]}}, 
     {Arrowheads[{{0.00033882352534908935`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{9.89635682608107*^-15, 2.21310537384686}, {
        1.1419925246721934`*^-14, 2.3583231975817096`}}]}}, 
     {Arrowheads[{{0.0004235294066863617, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{9.89635682608107*^-15, 2.7663817173085747`}, {
        1.1419925246721935`*^-14, 2.947903996977137}}]}}, 
     {Arrowheads[{{0.000508235288023634, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{9.89635682608107*^-15, 3.3196580607702897`}, {
        1.1419925246721935`*^-14, 3.5374847963725644`}}]}}, 
     {Arrowheads[{{0.0005929411693609074, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{9.89635682608107*^-15, 3.8729344042320046`}, {
        1.1419925246721934`*^-14, 4.127065595767992}}]}}, 
     {Arrowheads[{{0.00480145819842508, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{13.264651462578634`, -3.8729344042320064`}, {
        15.306777108849959`, -4.127065595767994}}]}}, 
     {Arrowheads[{{0.004791735041599526, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{13.264651462578634`, -3.3196580607702915`}, {
        15.306777108849959`, -3.537484796372566}}]}}, 
     {Arrowheads[{{0.004783492318299303, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{13.264651462578634`, -2.7663817173085765`}, {
        15.306777108849959`, -2.947903996977139}}]}}, 
     {Arrowheads[{{0.004776737692424645, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{13.264651462578634`, -2.2131053738468616`}, {
        15.306777108849959`, -2.3583231975817114`}}]}}, 
     {Arrowheads[{{0.004771477483746356, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{13.264651462578634`, -1.6598290303851464`}, {
        15.306777108849959`, -1.7687423981862838`}}]}}, 
     {Arrowheads[{{0.004767716638626171, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{13.264651462578634`, -1.1065526869234312`}, {
        15.306777108849959`, -1.1791615987908561`}}]}}, 
     {Arrowheads[{{0.004765458706906762, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{13.264651462578634`, -0.5532763434617161}, {
        15.306777108849959`, -0.5895807993954285}}]}}, 
     {Arrowheads[{{0.0047647058252215675`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{13.264651462578634`, -8.599641896882574*^-16}, {
        15.306777108849959`, -9.163926497119932*^-16}}]}}, 
     {Arrowheads[{{0.004765458706906762, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{13.264651462578634`, 0.5532763434617143}, {
        15.306777108849959`, 0.5895807993954266}}]}}, 
     {Arrowheads[{{0.004767716638626171, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{13.264651462578634`, 1.1065526869234295`}, {
        15.306777108849959`, 1.1791615987908544`}}]}}, 
     {Arrowheads[{{0.004771477483746356, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{13.264651462578634`, 1.6598290303851446`}, {
        15.306777108849959`, 1.768742398186282}}]}}, 
     {Arrowheads[{{0.004776737692424645, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{13.264651462578634`, 2.21310537384686}, {
        15.306777108849959`, 2.3583231975817096`}}]}}, 
     {Arrowheads[{{0.004783492318299303, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{13.264651462578634`, 2.7663817173085747`}, {
        15.306777108849959`, 2.947903996977137}}]}}, 
     {Arrowheads[{{0.004791735041599526, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{13.264651462578634`, 3.3196580607702897`}, {
        15.306777108849959`, 3.5374847963725644`}}]}}, 
     {Arrowheads[{{0.00480145819842508, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{13.264651462578634`, 3.8729344042320046`}, {
        15.306777108849959`, 4.127065595767992}}]}}, 
     {Arrowheads[{{0.009547840888594897, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{26.529302925157257`, -3.8729344042320064`}, {
        30.61355421769991, -4.127065595767994}}]}}, 
     {Arrowheads[{{0.009542954967492719, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{26.529302925157257`, -3.3196580607702915`}, {
        30.61355421769991, -3.537484796372566}}]}}, 
     {Arrowheads[{{0.009538818771835935, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{26.529302925157257`, -2.7663817173085765`}, {
        30.61355421769991, -2.947903996977139}}]}}, 
     {Arrowheads[{{0.00953543327725235, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{26.529302925157257`, -2.2131053738468616`}, {
        30.61355421769991, -2.3583231975817114`}}]}}, 
     {Arrowheads[{{0.009532799283557774, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{26.529302925157257`, -1.6598290303851464`}, {
        30.61355421769991, -1.7687423981862838`}}]}}, 
     {Arrowheads[{{0.00953091741381353, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{26.529302925157257`, -1.1065526869234312`}, {
        30.61355421769991, -1.1791615987908561`}}]}}, 
     {Arrowheads[{{0.009529788113590702, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{26.529302925157257`, -0.5532763434617161}, {
        30.61355421769991, -0.5895807993954285}}]}}, 
     {Arrowheads[{{0.009529411650443144, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{26.529302925157257`, -8.599641896882574*^-16}, {
        30.61355421769991, -9.163926497119932*^-16}}]}}, 
     {Arrowheads[{{0.009529788113590702, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{26.529302925157257`, 0.5532763434617143}, {
        30.61355421769991, 0.5895807993954266}}]}}, 
     {Arrowheads[{{0.00953091741381353, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{26.529302925157257`, 1.1065526869234295`}, {
        30.61355421769991, 1.1791615987908544`}}]}}, 
     {Arrowheads[{{0.009532799283557774, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{26.529302925157257`, 1.6598290303851446`}, {
        30.61355421769991, 1.7687423981862818`}}]}}, 
     {Arrowheads[{{0.00953543327725235, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{26.529302925157257`, 2.21310537384686}, {30.61355421769991, 
        2.3583231975817096`}}]}}, 
     {Arrowheads[{{0.009538818771835935, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{26.529302925157257`, 2.7663817173085747`}, {
        30.61355421769991, 2.947903996977137}}]}}, 
     {Arrowheads[{{0.009542954967492719, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{26.529302925157257`, 3.3196580607702897`}, {
        30.61355421769991, 3.5374847963725644`}}]}}, 
     {Arrowheads[{{0.009547840888594897, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{26.529302925157257`, 3.8729344042320046`}, {
        30.61355421769991, 4.127065595767992}}]}}, 
     {Arrowheads[{{0.014306410228929764`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{39.79395438773588, -3.8729344042320064`}, {
        45.92033132654986, -4.127065595767994}}]}}, 
     {Arrowheads[{{0.014303149915878517`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{39.79395438773588, -3.3196580607702915`}, {
        45.92033132654986, -3.537484796372566}}]}}, 
     {Arrowheads[{{0.014300390608876081`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{39.79395438773588, -2.7663817173085765`}, {
        45.92033132654986, -2.947903996977139}}]}}, 
     {Arrowheads[{{0.014298132597980519`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{39.79395438773588, -2.2131053738468616`}, {
        45.92033132654986, -2.3583231975817114`}}]}}, 
     {Arrowheads[{{0.014296376120720287`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{39.79395438773588, -1.6598290303851464`}, {
        45.92033132654986, -1.7687423981862838`}}]}}, 
     {Arrowheads[{{0.014295121361969462`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{39.79395438773588, -1.1065526869234312`}, {
        45.92033132654986, -1.1791615987908561`}}]}}, 
     {Arrowheads[{{0.014294368453850499`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{39.79395438773588, -0.5532763434617161}, {
        45.92033132654986, -0.5895807993954285}}]}}, 
     {Arrowheads[{{0.014294117475664706`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{39.79395438773588, -8.599641896882574*^-16}, {
        45.92033132654986, -9.163926497119932*^-16}}]}}, 
     {Arrowheads[{{0.014294368453850499`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{39.79395438773588, 0.5532763434617143}, {45.92033132654986, 
        0.5895807993954266}}]}}, 
     {Arrowheads[{{0.014295121361969462`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{39.79395438773588, 1.1065526869234295`}, {45.92033132654986,
         1.1791615987908544`}}]}}, 
     {Arrowheads[{{0.014296376120720287`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{39.79395438773588, 1.6598290303851446`}, {45.92033132654986,
         1.7687423981862818`}}]}}, 
     {Arrowheads[{{0.014298132597980519`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{39.79395438773588, 2.21310537384686}, {45.92033132654986, 
        2.3583231975817096`}}]}}, 
     {Arrowheads[{{0.014300390608876081`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{39.79395438773588, 2.7663817173085747`}, {45.92033132654986,
         2.947903996977137}}]}}, 
     {Arrowheads[{{0.014303149915878517`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{39.79395438773588, 3.3196580607702897`}, {45.92033132654986,
         3.5374847963725644`}}]}}, 
     {Arrowheads[{{0.014306410228929764`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{39.79395438773588, 3.8729344042320046`}, {45.92033132654986,
         4.127065595767992}}]}}, 
     {Arrowheads[{{0.019068044599400567`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{53.0586058503145, -3.8729344042320064`}, {
        61.227108435399806`, -4.127065595767994}}]}}, 
     {Arrowheads[{{0.01906559856711555, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{53.05860585031451, -3.3196580607702915`}, {
        61.22710843539981, -3.537484796372566}}]}}, 
     {Arrowheads[{{0.019063528602353084`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{53.05860585031451, -2.7663817173085765`}, {
        61.22710843539981, -2.947903996977139}}]}}, 
     {Arrowheads[{{0.01906183482762706, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{53.0586058503145, -2.2131053738468616`}, {
        61.227108435399806`, -2.3583231975817114`}}]}}, 
     {Arrowheads[{{0.019060517343225607`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{53.05860585031451, -1.6598290303851464`}, {
        61.22710843539981, -1.7687423981862838`}}]}}, 
     {Arrowheads[{{0.019059576227181404`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{53.05860585031451, -1.1065526869234312`}, {
        61.22710843539981, -1.1791615987908561`}}]}}, 
     {Arrowheads[{{0.0190590115352486, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{53.05860585031451, -0.5532763434617161}, {
        61.22710843539981, -0.5895807993954285}}]}}, 
     {Arrowheads[{{0.019058823300886287`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{53.05860585031451, -8.599641896882574*^-16}, {
        61.22710843539981, -9.163926497119932*^-16}}]}}, 
     {Arrowheads[{{0.0190590115352486, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{53.05860585031451, 0.5532763434617143}, {61.22710843539981, 
        0.5895807993954266}}]}}, 
     {Arrowheads[{{0.019059576227181404`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{53.05860585031451, 1.1065526869234295`}, {61.22710843539981,
         1.1791615987908544`}}]}}, 
     {Arrowheads[{{0.019060517343225607`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{53.05860585031451, 1.6598290303851446`}, {61.22710843539981,
         1.7687423981862818`}}]}}, 
     {Arrowheads[{{0.01906183482762706, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{53.0586058503145, 2.21310537384686}, {61.227108435399806`, 
        2.3583231975817096`}}]}}, 
     {Arrowheads[{{0.019063528602353084`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{53.05860585031451, 2.7663817173085747`}, {61.22710843539981,
         2.947903996977137}}]}}, 
     {Arrowheads[{{0.01906559856711555, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{53.05860585031451, 3.3196580607702897`}, {61.22710843539981,
         3.5374847963725644`}}]}}, 
     {Arrowheads[{{0.019068044599400567`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{53.0586058503145, 3.8729344042320046`}, {
        61.227108435399806`, 4.127065595767992}}]}}, 
     {Arrowheads[{{0.023830906807186993`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{66.32325731289313, -3.8729344042320064`}, {
        76.53388554424976, -4.127065595767994}}]}}, 
     {Arrowheads[{{0.023828949685844335`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{66.32325731289313, -3.3196580607702915`}, {
        76.53388554424976, -3.537484796372566}}]}}, 
     {Arrowheads[{{0.023827293534533802`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{66.32325731289313, -2.7663817173085765`}, {
        76.53388554424976, -2.947903996977139}}]}}, 
     {Arrowheads[{{0.023825938416017073`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{66.32325731289313, -2.2131053738468616`}, {
        76.53388554424976, -2.3583231975817114`}}]}}, 
     {Arrowheads[{{0.023824884381660836`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{66.32325731289313, -1.6598290303851464`}, {
        76.53388554424976, -1.7687423981862838`}}]}}, 
     {Arrowheads[{{0.023824131471427045`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{66.32325731289313, -1.1065526869234312`}, {
        76.53388554424976, -1.1791615987908561`}}]}}, 
     {Arrowheads[{{0.02382367971386539, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{66.32325731289313, -0.5532763434617161}, {
        76.53388554424976, -0.5895807993954285}}]}}, 
     {Arrowheads[{{0.023823529126107832`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{66.32325731289313, -8.599641896882574*^-16}, {
        76.53388554424976, -9.163926497119932*^-16}}]}}, 
     {Arrowheads[{{0.02382367971386539, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{66.32325731289313, 0.5532763434617143}, {76.53388554424976, 
        0.5895807993954266}}]}}, 
     {Arrowheads[{{0.023824131471427045`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{66.32325731289313, 1.1065526869234295`}, {76.53388554424976,
         1.1791615987908544`}}]}}, 
     {Arrowheads[{{0.023824884381660836`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{66.32325731289313, 1.6598290303851446`}, {76.53388554424976,
         1.768742398186282}}]}}, 
     {Arrowheads[{{0.023825938416017073`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{66.32325731289313, 2.21310537384686}, {76.53388554424976, 
        2.3583231975817096`}}]}}, 
     {Arrowheads[{{0.023827293534533802`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{66.32325731289313, 2.7663817173085747`}, {76.53388554424976,
         2.947903996977137}}]}}, 
     {Arrowheads[{{0.023828949685844335`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{66.32325731289313, 3.3196580607702897`}, {76.53388554424976,
         3.5374847963725644`}}]}}, 
     {Arrowheads[{{0.023830906807186993`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{66.32325731289313, 3.8729344042320046`}, {76.53388554424976,
         4.127065595767992}}]}}, 
     {Arrowheads[{{0.028594383309711993`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{79.58790877547176, -3.8729344042320064`}, {
        91.84066265309971, -4.127065595767994}}]}}, 
     {Arrowheads[{{0.028592752241440575`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{79.58790877547176, -3.3196580607702915`}, {
        91.84066265309971, -3.537484796372566}}]}}, 
     {Arrowheads[{{0.02859137203407246, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{79.58790877547176, -2.7663817173085765`}, {
        91.84066265309971, -2.947903996977139}}]}}, 
     {Arrowheads[{{0.028590242723938925`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{79.58790877547176, -2.2131053738468616`}, {
        91.84066265309971, -2.3583231975817114`}}]}}, 
     {Arrowheads[{{0.02858936434077209, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{79.58790877547176, -1.6598290303851464`}, {
        91.84066265309971, -1.7687423981862838`}}]}}, 
     {Arrowheads[{{0.028588736907700998`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{79.58790877547176, -1.1065526869234312`}, {
        91.84066265309971, -1.1791615987908561`}}]}}, 
     {Arrowheads[{{0.028588360441248562`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{79.58790877547176, -0.5532763434617161}, {
        91.84066265309971, -0.5895807993954285}}]}}, 
     {Arrowheads[{{0.02858823495132941, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{79.58790877547176, -8.599641896882574*^-16}, {
        91.84066265309971, -9.163926497119932*^-16}}]}}, 
     {Arrowheads[{{0.028588360441248562`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{79.58790877547176, 0.5532763434617143}, {91.84066265309971, 
        0.5895807993954266}}]}}, 
     {Arrowheads[{{0.028588736907700998`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{79.58790877547176, 1.1065526869234295`}, {91.84066265309971,
         1.1791615987908544`}}]}}, 
     {Arrowheads[{{0.02858936434077209, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{79.58790877547176, 1.6598290303851446`}, {91.84066265309971,
         1.7687423981862818`}}]}}, 
     {Arrowheads[{{0.028590242723938925`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{79.58790877547176, 2.21310537384686}, {91.84066265309971, 
        2.3583231975817096`}}]}}, 
     {Arrowheads[{{0.02859137203407246, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{79.58790877547176, 2.7663817173085747`}, {91.84066265309971,
         2.947903996977137}}]}}, 
     {Arrowheads[{{0.028592752241440575`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{79.58790877547176, 3.3196580607702897`}, {91.84066265309971,
         3.5374847963725644`}}]}}, 
     {Arrowheads[{{0.028594383309711993`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{79.58790877547176, 3.8729344042320046`}, {91.84066265309971,
         4.127065595767992}}]}}}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{-100, 100}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.6564306455085692`*^9, 3.6564306854694576`*^9}, 
   3.6564307156778407`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"dbddb07f-ea12-414f-ac21-a9dcfe72991a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["When is a vector field a gradient vector field?", "Subsubsection",
 CellChangeTimes->{{3.5455885641289597`*^9, 
  3.545588579646408*^9}},ExpressionUUID->"b211eb61-a733-43dd-a0d3-\
fb96d48bd6dc"],

Cell[TextData[{
 "For a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]],ExpressionUUID->
  "3c37872f-d5ac-4bfa-a3d0-3c15ba9783aa"],
 ", we saw the order of differentiation for the second derivatives doesn\
\[CloseCurlyQuote]t matter, that is:"
}], "Text",
 CellChangeTimes->{{3.5455886259709997`*^9, 3.5455886387539997`*^9}, {
  3.656358971728907*^9, 
  3.6563590754384336`*^9}},ExpressionUUID->"3b6e7b4b-502c-4b83-9de1-\
cdc6652ff024"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{
          SubscriptBox["f", "xy"], "=", 
          SubscriptBox["f", "yx"]}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           FractionBox["\[PartialD]", 
            RowBox[{"\[PartialD]", "y"}]], 
           SubscriptBox["f", "x"]}], "=", 
          RowBox[{
           FractionBox["\[PartialD]", 
            RowBox[{"\[PartialD]", "x"}]], 
           SubscriptBox["f", "y"]}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]],
 TextAlignment->
  Center,ExpressionUUID->"6b73a4dc-31a7-4755-9b9d-5de4c1a84f9d"]], "Text",
 CellChangeTimes->{{3.656359084786682*^9, 3.656359115483788*^9}, {
  3.656359152304276*^9, 
  3.65635917561523*^9}},ExpressionUUID->"e1e260c3-a349-4bda-bd95-\
9ba5632b1c04"],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]],ExpressionUUID->
  "fd2ec066-6e74-44a6-b028-17504f7e386e"],
 " and ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]],ExpressionUUID->
  "ac35f988-da9e-4955-a126-ef923276f5cf"],
 " be functions of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],ExpressionUUID->
  "5cd9fbe8-fe55-465a-843f-46edc5835df3"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],ExpressionUUID->
  "ba07ac63-c9b0-4942-8698-db1424f736c0"],
 ", and consider the vector field ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["F", "\[RightVector]"], "=", 
    RowBox[{
     RowBox[{"P", " ", 
      OverscriptBox["i", "^"]}], "+", 
     RowBox[{"Q", " ", 
      OverscriptBox["j", "^"]}]}]}], TraditionalForm]],ExpressionUUID->
  "d5141575-e875-4b5a-bf20-27f6b8549047"],
 ".   *If* ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["F", "\[RightVector]"], TraditionalForm]],ExpressionUUID->
  "e43595ce-5646-4cbe-81e2-5fd7d579066e"],
 " is the gradient of some function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]],ExpressionUUID->
  "4efb9cb7-dc87-42d0-a9b9-a9e1cc7c7118"],
 ", then it must be the case that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "=", 
    SubscriptBox["f", "x"]}], TraditionalForm]],ExpressionUUID->
  "04de329d-5fdb-4559-9693-dfe7fcae8cc3"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", "=", 
    SubscriptBox["f", "y"]}], TraditionalForm]],ExpressionUUID->
  "350b2c26-32d6-4c7f-8ac0-c9691158e671"],
 " and therefore it must be the case that"
}], "Text",
 CellChangeTimes->{{3.656359733290038*^9, 3.656359962848568*^9}, {
  3.656364135027217*^9, 
  3.656364153861373*^9}},ExpressionUUID->"2747feee-0b87-4136-a785-\
aba97a3e3d94"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {GridBox[{
          {
           RowBox[{"\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              FractionBox["\[PartialD]", 
               RowBox[{"\[PartialD]", "y"}]], "P"}], "=", 
             RowBox[{
              FractionBox["\[PartialD]", 
               RowBox[{"\[PartialD]", "x"}]], "Q"}]}]}]}
         },
         GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"7aa0f941-7e57-4794-8346-78e1b1b26a44"]], \
"Text",
 CellChangeTimes->{{3.6563599688825274`*^9, 
  3.656360009542758*^9}},ExpressionUUID->"8e456e89-54ba-426f-a84b-\
9a442c399e2a"],

Cell["When this is true, we say that", "Text",
 CellChangeTimes->{{3.6563594491616364`*^9, 3.6563595129327383`*^9}, {
   3.656359569879016*^9, 3.656359626986392*^9}, {3.656359675039352*^9, 
   3.656359676471216*^9}, {3.656364223349599*^9, 3.656364292925514*^9}, 
   3.6563643522907753`*^9, 
   3.6563644324760303`*^9},ExpressionUUID->"9bab1947-e473-4aa2-be12-\
76cab3c01eea"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   OverscriptBox["F", "\[RightVector]"], TraditionalForm]],ExpressionUUID->
  "6a037528-5603-47a7-879b-fe05deb729a5"],
 " is ",
 StyleBox["conservative",
  FontWeight->"Bold"],
 "."
}], "Item",
 CellChangeTimes->{{3.656364328061962*^9, 
  3.656364361100679*^9}},ExpressionUUID->"6ab78bb2-f0c7-451b-be71-\
bd76ee289c1f"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   OverscriptBox["F", "\[RightVector]"], TraditionalForm]],ExpressionUUID->
  "5d5b8ac1-9bc4-4e6b-b9a9-72ad0b63d579"],
 " is the gradient of a \[OpenCurlyDoubleQuote]",
 StyleBox["potential",
  FontWeight->"Bold"],
 "\[CloseCurlyDoubleQuote] function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]],ExpressionUUID->
  "0c93f334-a2dd-45f5-a54a-5a8ee9d37c55"],
 "."
}], "Item",
 CellChangeTimes->{{3.656364328061962*^9, 
  3.656364417298711*^9}},ExpressionUUID->"24a71c4e-395a-443b-a22f-\
4b5936ff098d"]
}, Open  ]],

Cell[TextData[{
 "\[LineSeparator]Make a ",
 StyleBox["VectorPlot[ ]",
  FontFamily->"Courier New"],
 "for each of the following vector fields. Test each one to see if it is ",
 StyleBox["conservative",
  FontSlant->"Italic"],
 " or not.  \[LineSeparator]\[LineSeparator]For the conservative ones, find \
(guess) the potential function, and graph contours of the potential function \
together with the vector field.\[LineSeparator]"
}], "Text",
 CellChangeTimes->{{3.656364336445902*^9, 3.656364336780198*^9}, {
   3.656364436476096*^9, 3.656364487870029*^9}, {3.656368661346973*^9, 
   3.656368734944528*^9}, {3.656368774033456*^9, 3.656368792360135*^9}, {
   3.656371198554747*^9, 3.65637120048291*^9}, {3.65637218644664*^9, 
   3.656372193407119*^9}, 3.6563722942974243`*^9, {3.656372520444907*^9, 
   3.656372552654418*^9}},ExpressionUUID->"1d2f6ee4-ebfc-4fc4-bffb-\
f5ed13c5aa57"],

Cell[TextData[{
 StyleBox["2.)",
  FontColor->RGBColor[1, 0, 0]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["F", "\[RightVector]"], "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"3", "x", " ", 
      SuperscriptBox["y", "2"], " ", 
      OverscriptBox["i", "^"]}], " ", "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"], "y", " ", 
      OverscriptBox["j", "^"]}]}]}], TraditionalForm]],ExpressionUUID->
  "26aa9e87-5e6c-4a11-ad7b-eb0fd0b0d21e"]
}], "Text",
 CellChangeTimes->{{3.656370248623249*^9, 3.6563703431699963`*^9}, {
  3.656370379052232*^9, 
  3.656370383265421*^9}},ExpressionUUID->"ab9de642-e5e2-406b-a0a1-\
00739ec385b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v2", "=", 
  RowBox[{"VectorPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"3", "x", " ", 
       SuperscriptBox["y", "2"]}], ",", 
      RowBox[{"3", 
       SuperscriptBox["x", "2"], "y"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"VectorColorFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"Red", "&"}], ")"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.656430806606965*^9, 3.656430840361664*^9}, {
  3.6564311797417912`*^9, 3.656431181794115*^9}, {3.6564312223974485`*^9, 
  3.6564312576039085`*^9}},ExpressionUUID->"1bd9e4d4-35ce-4d7f-99f8-\
44a0e902fa4d"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
    {Arrowheads[{{0.04587368524026638, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.285714285714285, -9.285714285714285}, \
{-10.714285714285715`, -10.714285714285715`}}]}}, 
    {Arrowheads[{{0.03661957214128819, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.475218658892128, -7.959183673469387}, \
{-10.524781341107872`, -9.183673469387756}}]}}, 
    {Arrowheads[{{0.028473340174100664`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.635568513119534, -6.632653061224489}, \
{-10.364431486880466`, -7.653061224489796}}]}}, 
    {Arrowheads[{{0.02134859125293253, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.7667638483965, -5.3061224489795915`}, \
{-10.233236151603498`, -6.122448979591836}}]}}, 
    {Arrowheads[{{0.015124736040578445`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.868804664723033, -3.9795918367346927`}, \
{-10.131195335276969`, -4.591836734693877}}]}}, 
    {Arrowheads[{{0.00963874482526197, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.941690962099125, -2.653061224489795}, \
{-10.058309037900875`, -3.0612244897959173`}}]}}, 
    {Arrowheads[{{0.004680988289823086, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.98542274052478, -1.3265306122448968`}, \
{-10.014577259475217`, -1.5306122448979578`}}]}}, 
    {Arrowheads[{{0.004680988289823097, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.98542274052478, 
       1.3265306122448992`}, {-10.014577259475217`, 1.5306122448979607`}}]}}, 
    {Arrowheads[{{0.009638744825261978, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.941690962099125, 
       2.653061224489797}, {-10.058309037900875`, 3.06122448979592}}]}}, 
    {Arrowheads[{{0.015124736040578424`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.868804664723031, 
       3.9795918367346954`}, {-10.131195335276967`, 4.591836734693879}}]}}, 
    {Arrowheads[{{0.02134859125293253, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.7667638483965, 5.306122448979593}, {-10.233236151603498`, 
       6.122448979591838}}]}}, 
    {Arrowheads[{{0.028473340174100647`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.635568513119534, 
       6.632653061224492}, {-10.364431486880466`, 7.6530612244897975`}}]}}, 
    {Arrowheads[{{0.03661957214128819, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.475218658892128, 
       7.959183673469389}, {-10.524781341107872`, 9.183673469387758}}]}}, 
    {Arrowheads[{{0.03661957214128819, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.959183673469387, -9.475218658892128}, \
{-9.183673469387756, -10.524781341107872`}}]}}, 
    {Arrowheads[{{0.02888838487433681, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.12161599333611, -8.12161599333611}, {-9.021241149521034, \
-9.021241149521034}}]}}, 
    {Arrowheads[{{0.022158516676423726`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.259058725531029, -6.768013327780091}, \
{-8.883798417326114, -7.517700957934193}}]}}, 
    {Arrowheads[{{0.016366937576713543`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.371511870054144, -5.414410662224073}, \
{-8.771345272802998, -6.014160766347355}}]}}, 
    {Arrowheads[{{0.011419136765807681`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.458975426905456, -4.060807996668054}, \
{-8.683881715951687, -4.510620574760516}}]}}, 
    {Arrowheads[{{0.007177376926577087, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.521449396084964, -2.7072053311120357`}, \
{-8.621407746772178, -3.0070803831736765`}}]}}, 
    {Arrowheads[{{0.003451490043452218, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.558933777592669, -1.3536026655560172`}, \
{-8.583923365264473, -1.5035401915868376`}}]}}, 
    {Arrowheads[{{0.0034514900434522225`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.558933777592669, 
       1.3536026655560196`}, {-8.583923365264473, 1.5035401915868403`}}]}}, 
    {Arrowheads[{{0.007177376926577087, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.521449396084964, 2.707205331112038}, {-8.621407746772178, 
       3.0070803831736788`}}]}}, 
    {Arrowheads[{{0.011419136765807662`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.458975426905456, 4.060807996668057}, {-8.683881715951687, 
       4.510620574760518}}]}}, 
    {Arrowheads[{{0.016366937576713567`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.371511870054144, 5.414410662224075}, {-8.771345272803, 
       6.014160766347357}}]}}, 
    {Arrowheads[{{0.022158516676423743`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.259058725531029, 6.768013327780094}, {-8.883798417326114, 
       7.5177009579341965`}}]}}, 
    {Arrowheads[{{0.028888384874336835`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.121615993336109, 8.12161599333611}, {-9.021241149521032, 
       9.021241149521035}}]}}, 
    {Arrowheads[{{0.028473340174100664`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.632653061224489, -9.635568513119534}, \
{-7.653061224489796, -10.364431486880466`}}]}}, 
    {Arrowheads[{{0.022158516676423726`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.768013327780091, -8.259058725531029}, \
{-7.517700957934193, -8.883798417326114}}]}}, 
    {Arrowheads[{{0.016717815320796758`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.8825489379425235`, -6.8825489379425235`}, \
{-7.403165347771761, -7.403165347771761}}]}}, 
    {Arrowheads[{{0.012110900511845513`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.976259891711786, -5.5060391503540185`}, \
{-7.309454394002498, -5.922532278217409}}]}}, 
    {Arrowheads[{{0.008271518207665708, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.04914618908788, -4.129529362765513}, {-7.236568096626406, \
-4.441899208663056}}]}}, 
    {Arrowheads[{{0.005092763532356943, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.101207830070804, -2.7530195751770083`}, \
{-7.184506455643482, -2.9612661391087034`}}]}}, 
    {Arrowheads[{{0.0024110776141148056`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.132444814660557, -1.3765097875885035`}, \
{-7.153269471053727, -1.480633069554351}}]}}, 
    {Arrowheads[{{0.002411077614114811, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.132444814660557, 
       1.3765097875885062`}, {-7.153269471053727, 1.480633069554354}}]}}, 
    {Arrowheads[{{0.005092763532356943, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.101207830070804, 2.753019575177011}, {-7.184506455643482, 
       2.961266139108706}}]}}, 
    {Arrowheads[{{0.008271518207665708, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.049146189087879, 4.129529362765516}, {-7.236568096626405, 
       4.441899208663059}}]}}, 
    {Arrowheads[{{0.012110900511845525`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.976259891711786, 5.506039150354021}, {-7.309454394002499, 
       5.922532278217411}}]}}, 
    {Arrowheads[{{0.016717815320796768`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.8825489379425235`, 
       6.882548937942526}, {-7.403165347771762, 7.403165347771764}}]}}, 
    {Arrowheads[{{0.022158516676423743`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.768013327780091, 8.25905872553103}, {-7.517700957934194, 
       8.883798417326116}}]}}, 
    {Arrowheads[{{0.02134859125293253, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.3061224489795915`, -9.7667638483965}, \
{-6.122448979591836, -10.233236151603498`}}]}}, 
    {Arrowheads[{{0.016366937576713543`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.414410662224073, -8.371511870054144}, \
{-6.014160766347355, -8.771345272802998}}]}}, 
    {Arrowheads[{{0.012110900511845513`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.5060391503540185`, -6.976259891711786}, \
{-5.922532278217409, -7.309454394002498}}]}}, 
    {Arrowheads[{{0.008559521444247946, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.581007913369429, -5.581007913369429}, \
{-5.8475635152019985`, -5.8475635152019985`}}]}}, 
    {Arrowheads[{{0.005674214678380669, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.639316951270303, -4.185755935027071}, \
{-5.789254477301124, -4.385672636401498}}]}}, 
    {Arrowheads[{{0.0033834479306096782`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.680966264056642, -2.7905039566847134`}, \
{-5.747605164514784, -2.9237817576009983`}}]}}, 
    {Arrowheads[{{0.0015596924307595727`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.705955851728445, -1.395251978342356}, \
{-5.722615576842981, -1.4618908788004983`}}]}}, 
    {Arrowheads[{{0.0015596924307595776`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.705955851728445, 
       1.3952519783423587`}, {-5.722615576842981, 1.4618908788005012`}}]}}, 
    {Arrowheads[{{0.003383447930609687, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.680966264056642, 2.790503956684716}, {-5.747605164514785, 
       2.923781757601001}}]}}, 
    {Arrowheads[{{0.005674214678380669, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.639316951270303, 4.185755935027074}, {-5.789254477301124, 
       4.385672636401501}}]}}, 
    {Arrowheads[{{0.008559521444247946, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.581007913369429, 
       5.581007913369431}, {-5.8475635152019985`, 5.847563515202001}}]}}, 
    {Arrowheads[{{0.012110900511845513`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.5060391503540185`, 
       6.976259891711789}, {-5.922532278217409, 7.3094543940025005`}}]}}, 
    {Arrowheads[{{0.016366937576713543`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.414410662224072, 8.371511870054146}, {-6.014160766347354, 
       8.771345272803}}]}}, 
    {Arrowheads[{{0.015124736040578445`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.9795918367346927`, -9.868804664723033}, \
{-4.591836734693877, -10.131195335276969`}}]}}, 
    {Arrowheads[{{0.011419136765807681`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.060807996668054, -8.458975426905456}, \
{-4.510620574760516, -8.683881715951687}}]}}, 
    {Arrowheads[{{0.008271518207665708, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.129529362765513, -7.04914618908788}, {-4.441899208663056, \
-7.236568096626406}}]}}, 
    {Arrowheads[{{0.005674214678380669, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.185755935027071, -5.639316951270303}, \
{-4.385672636401498, -5.789254477301124}}]}}, 
    {Arrowheads[{{0.0036110481092921083`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.229487713452727, -4.229487713452727}, \
{-4.3419408579758425`, -4.3419408579758425`}}]}}, 
    {Arrowheads[{{0.0020458671970891907`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.260724698042481, -2.819658475635151}, \
{-4.310703873386088, -2.894627238650561}}]}}, 
    {Arrowheads[{{0.0008971721158221315, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.279466888796334, -1.4098292378175747`}, \
{-4.291961682632235, -1.4473136193252798`}}]}}, 
    {Arrowheads[{{0.0008971721158221379, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.279466888796334, 
       1.4098292378175774`}, {-4.291961682632236, 1.4473136193252825`}}]}}, 
    {Arrowheads[{{0.0020458671970891907`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.260724698042481, 
       2.8196584756351535`}, {-4.310703873386088, 2.8946272386505636`}}]}}, 
    {Arrowheads[{{0.0036110481092921083`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.229487713452727, 4.22948771345273}, {-4.3419408579758425`,
        4.341940857975845}}]}}, 
    {Arrowheads[{{0.005674214678380685, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.185755935027071, 5.639316951270306}, {-4.385672636401499, 
       5.789254477301126}}]}}, 
    {Arrowheads[{{0.008271518207665708, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.129529362765513, 7.049146189087883}, {-4.441899208663056, 
       7.236568096626408}}]}}, 
    {Arrowheads[{{0.011419136765807681`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.060807996668054, 8.458975426905457}, {-4.510620574760516, 
       8.683881715951689}}]}}, 
    {Arrowheads[{{0.00963874482526197, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.653061224489795, -9.941690962099125}, \
{-3.0612244897959173`, -10.058309037900875`}}]}}, 
    {Arrowheads[{{0.007177376926577087, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.7072053311120357`, -8.521449396084964}, \
{-3.0070803831736765`, -8.621407746772178}}]}}, 
    {Arrowheads[{{0.005092763532356943, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.7530195751770083`, -7.101207830070804}, \
{-2.9612661391087034`, -7.184506455643482}}]}}, 
    {Arrowheads[{{0.0033834479306096782`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.7905039566847134`, -5.680966264056642}, \
{-2.9237817576009983`, -5.747605164514784}}]}}, 
    {Arrowheads[{{0.0020458671970891907`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.819658475635151, -4.260724698042481}, \
{-2.894627238650561, -4.310703873386088}}]}}, 
    {Arrowheads[{{0.0010699401805309861`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.84048313202832, -2.84048313202832}, {-2.873802582257391, \
-2.873802582257391}}]}}, 
    {Arrowheads[{{0.0004229309913262064, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.852977925864222, -1.4202415660141594`}, \
{-2.8613077884214895`, -1.436901291128695}}]}}, 
    {Arrowheads[{{0.0004229309913262064, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.852977925864222, 
       1.420241566014162}, {-2.8613077884214895`, 1.4369012911286976`}}]}}, 
    {Arrowheads[{{0.0010699401805309933`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.84048313202832, 2.840483132028323}, {-2.8738025822573916`,
        2.873802582257394}}]}}, 
    {Arrowheads[{{0.0020458671970891907`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.819658475635151, 4.260724698042484}, {-2.894627238650561, 
       4.310703873386091}}]}}, 
    {Arrowheads[{{0.0033834479306096782`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.7905039566847134`, 
       5.680966264056645}, {-2.9237817576009983`, 5.747605164514787}}]}}, 
    {Arrowheads[{{0.005092763532356943, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.7530195751770083`, 
       7.101207830070806}, {-2.9612661391087034`, 7.184506455643485}}]}}, 
    {Arrowheads[{{0.007177376926577078, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.7072053311120357`, 
       8.521449396084966}, {-3.007080383173676, 8.62140774677218}}]}}, 
    {Arrowheads[{{0.004680988289823086, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.3265306122448968`, -9.98542274052478}, \
{-1.5306122448979578`, -10.014577259475217`}}]}}, 
    {Arrowheads[{{0.003451490043452218, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.3536026655560172`, -8.558933777592669}, \
{-1.5035401915868376`, -8.583923365264473}}]}}, 
    {Arrowheads[{{0.0024110776141148056`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.3765097875885035`, -7.132444814660557}, \
{-1.480633069554351, -7.153269471053727}}]}}, 
    {Arrowheads[{{0.0015596924307595776`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.395251978342356, -5.705955851728445}, \
{-1.4618908788004985`, -5.722615576842981}}]}}, 
    {Arrowheads[{{0.0008971721158221379, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.4098292378175747`, -4.279466888796334}, \
{-1.4473136193252798`, -4.291961682632236}}]}}, 
    {Arrowheads[{{0.0004229309913262064, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.4202415660141594`, -2.852977925864222}, \
{-1.436901291128695, -2.8613077884214895`}}]}}, 
    {Arrowheads[{{0.00013374252256637148`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.4264889629321102`, -1.4264889629321102`}, \
{-1.430653894210744, -1.430653894210744}}]}}, 
    {Arrowheads[{{0.00013374252256637148`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.4264889629321102`, 
       1.426488962932113}, {-1.430653894210744, 1.4306538942107467`}}]}}, 
    {Arrowheads[{{0.0004229309913262064, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.4202415660141594`, 
       2.8529779258642245`}, {-1.436901291128695, 2.861307788421492}}]}}, 
    {Arrowheads[{{0.0008971721158221379, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.4098292378175747`, 
       4.279466888796336}, {-1.4473136193252798`, 4.291961682632238}}]}}, 
    {Arrowheads[{{0.0015596924307595776`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.395251978342356, 
       5.705955851728448}, {-1.4618908788004985`, 5.722615576842983}}]}}, 
    {Arrowheads[{{0.0024110776141148056`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.3765097875885035`, 7.13244481466056}, {-1.480633069554351,
        7.153269471053729}}]}}, 
    {Arrowheads[{{0.003451490043452218, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.3536026655560172`, 
       8.55893377759267}, {-1.5035401915868376`, 8.583923365264475}}]}}, 
    {Arrowheads[{{0.004680988289823097, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3265306122448992`, -9.98542274052478}, {
       1.5306122448979607`, -10.014577259475217`}}]}}, 
    {Arrowheads[{{0.0034514900434522225`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3536026655560196`, -8.558933777592669}, {
       1.5035401915868403`, -8.583923365264473}}]}}, 
    {Arrowheads[{{0.002411077614114811, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3765097875885062`, -7.132444814660557}, {
       1.480633069554354, -7.153269471053727}}]}}, 
    {Arrowheads[{{0.0015596924307595776`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3952519783423587`, -5.705955851728445}, {
       1.4618908788005012`, -5.722615576842981}}]}}, 
    {Arrowheads[{{0.0008971721158221379, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.4098292378175774`, -4.279466888796334}, {
       1.4473136193252825`, -4.291961682632236}}]}}, 
    {Arrowheads[{{0.0004229309913262064, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.420241566014162, -2.852977925864222}, {
       1.4369012911286976`, -2.8613077884214895`}}]}}, 
    {Arrowheads[{{0.00013374252256637148`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.426488962932113, -1.4264889629321102`}, {
       1.4306538942107467`, -1.430653894210744}}]}}, 
    {Arrowheads[{{0.00013374252256637148`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.426488962932113, 1.426488962932113}, {1.4306538942107467`, 
       1.4306538942107467`}}]}}, 
    {Arrowheads[{{0.00042293099132621086`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.420241566014162, 2.8529779258642245`}, {
       1.4369012911286978`, 2.861307788421492}}]}}, 
    {Arrowheads[{{0.0008971721158221428, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.4098292378175774`, 4.279466888796336}, {
       1.4473136193252827`, 4.291961682632238}}]}}, 
    {Arrowheads[{{0.0015596924307595776`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3952519783423587`, 5.705955851728448}, {
       1.4618908788005012`, 5.722615576842983}}]}}, 
    {Arrowheads[{{0.0024110776141148156`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.376509787588506, 7.13244481466056}, {1.480633069554354, 
       7.153269471053729}}]}}, 
    {Arrowheads[{{0.0034514900434522225`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3536026655560196`, 8.55893377759267}, {1.5035401915868403`,
        8.583923365264475}}]}}, 
    {Arrowheads[{{0.009638744825261978, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.653061224489797, -9.941690962099125}, {
       3.06122448979592, -10.058309037900875`}}]}}, 
    {Arrowheads[{{0.007177376926577096, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.707205331112038, -8.521449396084964}, {
       3.007080383173679, -8.621407746772178}}]}}, 
    {Arrowheads[{{0.005092763532356943, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.753019575177011, -7.101207830070804}, {
       2.961266139108706, -7.184506455643482}}]}}, 
    {Arrowheads[{{0.003383447930609687, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.790503956684716, -5.680966264056642}, {
       2.923781757601001, -5.747605164514785}}]}}, 
    {Arrowheads[{{0.0020458671970891907`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.8196584756351535`, -4.260724698042481}, {
       2.8946272386505636`, -4.310703873386088}}]}}, 
    {Arrowheads[{{0.0010699401805309933`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.840483132028323, -2.84048313202832}, {
       2.873802582257394, -2.8738025822573916`}}]}}, 
    {Arrowheads[{{0.0004229309913262064, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.8529779258642245`, -1.4202415660141594`}, {
       2.861307788421492, -1.436901291128695}}]}}, 
    {Arrowheads[{{0.00042293099132621086`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.8529779258642245`, 1.420241566014162}, {2.861307788421492, 
       1.4369012911286978`}}]}}, 
    {Arrowheads[{{0.0010699401805310002`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.840483132028323, 2.840483132028323}, {2.8738025822573943`, 
       2.8738025822573943`}}]}}, 
    {Arrowheads[{{0.0020458671970891994`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.8196584756351535`, 4.260724698042484}, {2.894627238650564, 
       4.310703873386091}}]}}, 
    {Arrowheads[{{0.003383447930609687, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.790503956684716, 5.680966264056645}, {2.923781757601001, 
       5.747605164514788}}]}}, 
    {Arrowheads[{{0.005092763532356952, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.753019575177011, 7.101207830070806}, {2.9612661391087065`, 
       7.184506455643485}}]}}, 
    {Arrowheads[{{0.007177376926577096, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.707205331112038, 8.521449396084966}, {3.007080383173679, 
       8.62140774677218}}]}}, 
    {Arrowheads[{{0.015124736040578424`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.9795918367346954`, -9.868804664723031}, {
       4.591836734693879, -10.131195335276967`}}]}}, 
    {Arrowheads[{{0.011419136765807662`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.060807996668057, -8.458975426905456}, {
       4.510620574760518, -8.683881715951687}}]}}, 
    {Arrowheads[{{0.008271518207665708, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.129529362765516, -7.049146189087879}, {
       4.441899208663059, -7.236568096626405}}]}}, 
    {Arrowheads[{{0.005674214678380669, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.185755935027074, -5.639316951270303}, {
       4.385672636401501, -5.789254477301124}}]}}, 
    {Arrowheads[{{0.0036110481092921083`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.22948771345273, -4.229487713452727}, {
       4.341940857975845, -4.3419408579758425`}}]}}, 
    {Arrowheads[{{0.0020458671970891907`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.260724698042484, -2.819658475635151}, {
       4.310703873386091, -2.894627238650561}}]}}, 
    {Arrowheads[{{0.0008971721158221379, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.279466888796336, -1.4098292378175747`}, {
       4.291961682632238, -1.4473136193252798`}}]}}, 
    {Arrowheads[{{0.0008971721158221428, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.279466888796336, 1.4098292378175774`}, {4.291961682632238, 
       1.4473136193252827`}}]}}, 
    {Arrowheads[{{0.0020458671970891907`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.260724698042484, 2.8196584756351535`}, {4.310703873386091, 
       2.8946272386505636`}}]}}, 
    {Arrowheads[{{0.0036110481092921083`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.22948771345273, 4.22948771345273}, {4.341940857975845, 
       4.341940857975845}}]}}, 
    {Arrowheads[{{0.005674214678380685, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.185755935027074, 5.639316951270306}, {4.385672636401502, 
       5.789254477301126}}]}}, 
    {Arrowheads[{{0.008271518207665725, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.129529362765516, 7.049146189087882}, {4.4418992086630595`, 
       7.236568096626407}}]}}, 
    {Arrowheads[{{0.011419136765807681`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.060807996668056, 8.458975426905457}, {4.510620574760518, 
       8.683881715951689}}]}}, 
    {Arrowheads[{{0.02134859125293253, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.306122448979593, -9.7667638483965}, {
       6.122448979591838, -10.233236151603498`}}]}}, 
    {Arrowheads[{{0.016366937576713567`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.414410662224075, -8.371511870054144}, {
       6.014160766347357, -8.771345272803}}]}}, 
    {Arrowheads[{{0.012110900511845525`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.506039150354021, -6.976259891711786}, {
       5.922532278217411, -7.309454394002499}}]}}, 
    {Arrowheads[{{0.008559521444247946, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.581007913369431, -5.581007913369429}, {
       5.847563515202001, -5.8475635152019985`}}]}}, 
    {Arrowheads[{{0.005674214678380685, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.639316951270306, -4.185755935027071}, {
       5.789254477301126, -4.385672636401499}}]}}, 
    {Arrowheads[{{0.0033834479306096782`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.680966264056645, -2.7905039566847134`}, {
       5.747605164514787, -2.9237817576009983`}}]}}, 
    {Arrowheads[{{0.0015596924307595776`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.705955851728448, -1.395251978342356}, {
       5.722615576842983, -1.4618908788004985`}}]}}, 
    {Arrowheads[{{0.0015596924307595776`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.705955851728448, 1.3952519783423587`}, {5.722615576842983, 
       1.4618908788005012`}}]}}, 
    {Arrowheads[{{0.003383447930609687, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.680966264056645, 2.790503956684716}, {5.747605164514788, 
       2.923781757601001}}]}}, 
    {Arrowheads[{{0.0056742146783806974`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.639316951270306, 4.185755935027074}, {5.789254477301127, 
       4.385672636401502}}]}}, 
    {Arrowheads[{{0.008559521444247946, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.581007913369431, 5.581007913369431}, {5.847563515202001, 
       5.847563515202001}}]}}, 
    {Arrowheads[{{0.01211090051184554, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.506039150354021, 6.976259891711789}, {5.922532278217412, 
       7.309454394002501}}]}}, 
    {Arrowheads[{{0.01636693757671358, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.414410662224075, 8.371511870054146}, {6.0141607663473575`, 
       8.771345272803002}}]}}, 
    {Arrowheads[{{0.028473340174100647`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.632653061224492, -9.635568513119534}, {
       7.6530612244897975`, -10.364431486880466`}}]}}, 
    {Arrowheads[{{0.022158516676423743`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.768013327780094, -8.259058725531029}, {
       7.5177009579341965`, -8.883798417326114}}]}}, 
    {Arrowheads[{{0.016717815320796768`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.882548937942526, -6.8825489379425235`}, {
       7.403165347771764, -7.403165347771762}}]}}, 
    {Arrowheads[{{0.012110900511845513`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.976259891711789, -5.5060391503540185`}, {
       7.3094543940025005`, -5.922532278217409}}]}}, 
    {Arrowheads[{{0.008271518207665708, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.049146189087883, -4.129529362765513}, {
       7.236568096626408, -4.441899208663056}}]}}, 
    {Arrowheads[{{0.005092763532356943, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.101207830070806, -2.7530195751770083`}, {
       7.184506455643485, -2.9612661391087034`}}]}}, 
    {Arrowheads[{{0.0024110776141148056`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.13244481466056, -1.3765097875885035`}, {
       7.153269471053729, -1.480633069554351}}]}}, 
    {Arrowheads[{{0.0024110776141148156`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.13244481466056, 1.376509787588506}, {7.153269471053729, 
       1.480633069554354}}]}}, 
    {Arrowheads[{{0.005092763532356952, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.101207830070806, 2.753019575177011}, {7.184506455643485, 
       2.9612661391087065`}}]}}, 
    {Arrowheads[{{0.008271518207665725, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.049146189087882, 4.129529362765516}, {7.236568096626407, 
       4.4418992086630595`}}]}}, 
    {Arrowheads[{{0.01211090051184554, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.976259891711789, 5.506039150354021}, {7.309454394002501, 
       5.922532278217412}}]}}, 
    {Arrowheads[{{0.016717815320796785`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.882548937942526, 6.882548937942526}, {7.403165347771765, 
       7.403165347771765}}]}}, 
    {Arrowheads[{{0.022158516676423743`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.768013327780094, 8.25905872553103}, {7.5177009579341965`, 
       8.883798417326116}}]}}, 
    {Arrowheads[{{0.03661957214128819, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.959183673469389, -9.475218658892128}, {
       9.183673469387758, -10.524781341107872`}}]}}, 
    {Arrowheads[{{0.02888838487433681, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.12161599333611, -8.121615993336109}, {
       9.021241149521034, -9.021241149521032}}]}}, 
    {Arrowheads[{{0.022158516676423743`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.25905872553103, -6.768013327780091}, {
       8.883798417326116, -7.517700957934194}}]}}, 
    {Arrowheads[{{0.016366937576713543`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.371511870054146, -5.414410662224072}, {
       8.771345272803, -6.014160766347354}}]}}, 
    {Arrowheads[{{0.011419136765807698`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.458975426905457, -4.0608079966680535`}, {
       8.683881715951689, -4.510620574760516}}]}}, 
    {Arrowheads[{{0.007177376926577087, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.521449396084966, -2.707205331112035}, {
       8.62140774677218, -3.007080383173676}}]}}, 
    {Arrowheads[{{0.003451490043452218, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.55893377759267, -1.3536026655560172`}, {
       8.583923365264475, -1.5035401915868376`}}]}}, 
    {Arrowheads[{{0.0034514900434522225`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.55893377759267, 1.3536026655560196`}, {8.583923365264475, 
       1.5035401915868403`}}]}}, 
    {Arrowheads[{{0.007177376926577096, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.521449396084966, 2.707205331112038}, {8.62140774677218, 
       3.007080383173679}}]}}, 
    {Arrowheads[{{0.011419136765807681`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.458975426905457, 4.060807996668056}, {8.683881715951689, 
       4.510620574760518}}]}}, 
    {Arrowheads[{{0.01636693757671358, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.371511870054146, 5.414410662224075}, {8.771345272803002, 
       6.0141607663473575`}}]}}, 
    {Arrowheads[{{0.022158516676423743`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.25905872553103, 6.768013327780094}, {8.883798417326116, 
       7.5177009579341965`}}]}}, 
    {Arrowheads[{{0.02888838487433681, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.12161599333611, 8.12161599333611}, {9.021241149521034, 
       9.021241149521034}}]}}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "TransparentPolygonMesh" -> True},
  PlotRange->{{-11.010152544552211`, 
   11.010152544552211`}, {-11.010152544552211`, 11.010152544552211`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.656430841655609*^9, 3.656431195613855*^9, {3.6564312441585193`*^9, 
   3.6564312584149995`*^9}},ExpressionUUID->"10b0fcc1-984d-4ae1-af50-\
41e67f7202bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"3", "x", " ", 
     SuperscriptBox["y", "2"]}], ",", "y"}], "]"}], "==", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"3", 
     SuperscriptBox["x", "2"], " ", "y"}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.656430897985193*^9, 3.656430914403146*^9}, {
  3.6564309548292365`*^9, 
  3.6564309605350666`*^9}},ExpressionUUID->"79b5f3f5-bb3a-48cb-94a5-\
dbc3ff941704"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.6564309167416005`*^9, 
  3.6564309611274753`*^9},ExpressionUUID->"83021f34-15e0-453e-918d-\
ecce497795ab"]
}, Open  ]],

Cell["\<\
This shows that the vector function is conservative. The potential function \
is as follows:\
\>", "Text",
 CellChangeTimes->{{3.656430967536841*^9, 
  3.6564310417955627`*^9}},ExpressionUUID->"8ae7ce65-54db-4118-81dc-\
54239097f9b3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pot2", "=", 
  RowBox[{
   RowBox[{"3", "/", "2"}], 
   SuperscriptBox["x", "2"], 
   SuperscriptBox["y", "2"]}]}]], "Input",
 CellChangeTimes->{{3.6564310490173907`*^9, 
  3.656431088515273*^9}},ExpressionUUID->"33da0d33-2171-41ca-bdd2-\
e8751278120c"],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "2"]}], "2"]], "Output",
 CellChangeTimes->{
  3.65643110576655*^9},ExpressionUUID->"64da1a92-d90b-44c4-b4b4-e734a0f624a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g2", "=", 
  RowBox[{"ContourPlot", "[", 
   RowBox[{"pot2", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6564311123020706`*^9, 3.6564311560173855`*^9}, {
   3.656431190138992*^9, 3.6564311913868237`*^9}, 
   3.656431278803455*^9},ExpressionUUID->"b1f3dcc9-876a-4111-9e33-\
5bcb3ffbd71d"],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJydnQe0lrWy9+lV2u59v7sIiqhIU46gUbAgWMBKEwV7QbCBvWJFj3pQKWID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   "], {{
     {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHm81lMex3/P73e7Pffe597nSSEZkkERFU1DG2ZKjOzSoCRahIRSUtb2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         "]], PolygonBox[CompressedData["
1:eJwtlmlsVlUQhi90+W57v++7V2QRmgj8EKVVJEAVTVwSKPhDMEUwUaBAy1aU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         "]]}]}, 
     {RGBColor[0.4092576492854195, 0.44753463712906116`, 0.578487516075025], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgvYllPWxx+97/M+h/t+nvsuKZRKGYcRJqnGkPkiHTAOlcyEMogKZfhU
kvkcPgz5XBLe0Dhkxsw4TMpEp0lJzIxD+UxIKCUM4xAVUzHf/9d/zfXNdT33
tfez77XX3nvttdf6r7Xvvc8eN2hsi0KhcEdDoaBf4YRioXBmU6HwQWOh8KEa
/rlLoXCwnmGlQuEnekapvamsdtFcqPrIvFBoVSkUzlbZUuVotQ0Sn1H630b/
z1PZKPrtTe67m9ouUnmVaC7Uu09UPzItFEaI9/CSeW6sFQrjVb6aFAoXN7o+
VfRT1D5AfB5TWc9Uiv5w8Zihtm6a9yTRfUeLuVHlU6KfqndHarzbVX6rPj1E
M0FjfSS+U0Szl9oX6P18PSv0v6ve1VXeLd47Gs3n2F3cD96zxXNvjTVZ9UoL
87hJz+/UfrTWuEp8+qh8t+h3tE8Sr1+o/jeNWW1h+qPE86lqoXCDeK3WvHZX
28/0fKv2rkWvmfXepj5dVW+IdRyh50H931djvCa6u1Q/Ru+26H8/lddKHiui
fazqzTHnSt39btJc9lC5QPt6iMZ6WPy6hKxGiOZXqreQDP5X7fupfoJoXhHv
Vprnefq/j3h2a/S7UZnnOlb0c7SWrXo3WG236umlPm+o/KLiPfq76I8WjzmN
HndfyWFu8F9c9dp3iL51o8fppfn8XPM5SH1fU3sf9Z2t9i/UPlBj9tczS/9L
ep5G38Tnbxrzh9E+U/1uKfkd+nJA0f2he0zlKvGZJ3kNY+9V/lXyGKF37dT+
kfbjdvX5WOXx6veO3l2hd4cXPWfmfrbeb1F9M4/mt6vKa7VXJ0kWo/XuTvGc
p/mPUfuLiWXWOfq2EZ9PVT+/hfWBEj25KXQbHT9VNEP09NNzsp4tDdZr1rce
2bfwvtHG3r2tPhfo/0sa66GyZdg6dLMa/NHZPUNv7xf9R6ofnvqcc8bvKXgu
laDfnlkvrxfP+ySne/V8I7oHVc7U067RurlOc7tB7TeXbTs+aLC8WzW6/USN
tZ/+j9ZYd6tfs57Jaj8m9g+5cz7a62mjsXtjCySHyyTDY9VvjfiNFU1RbZ2R
h+gaU+vE1eJ9pMZdLpqXNecPNedm/d+o8j09vVW/TeWdGvOOis/2XSqn63lb
fZrEp6/4fKO9OrXJNuBlPcXU+npNzXvwutrGaQ5vqt80Pbfq+Y2eh/R8Kj5n
iq6T6A/PbAP+GnbgNPUdqmewnpHiMWkX6/bB4n+66FPOkMqeRduapRWfyV/r
WSm57653z0oOp4p/W9WHqlyj5w8as5XmvFE0+6v9z7nPXM+yz3aD+B+l9q2i
6Vd323dF+xu9H1B2/7+Hfcfm/DOzfk4RzY2pdW69eLbVs1L0u6vspHO6tGx7
uEDlfD1fFmyHsC07xOuZot/RfoPG7aEz+AuVVT3L9L6H+M8RzWHoqv6Xkbno
R+j/vODJWXoh8dnhDKHPr4ROX1a3DRqvMtGcnlV7VeWVYSuwGfBYGHxY36Ky
1/hzjbu4bF9G2x/L1m/W9Eysa3G0Q9NJc3hU/T/I3PZ00C8ruw/yKuYe63bR
lnLT3JmYflHwgW5J2WcfGXas+j86gq480uA1sRbsRJvcMtlN5TWJ14GNQXbI
cIPq+yfeQ3Sho2R4WPin6xLPkbN7qurvi2ZwyGRe7EuHqnUN21FW+UTZdvHA
xHqCvjyJjpT9vlXsDWd5L/VtX3Wfn4j+I9G/pbGGqc9n2NDE/htswNhXaV0H
NNkP4fvBABvUfop0LNWc79Aaz1G9C3qTew+Xo8eivT9sTqJ5Dk7cr6XGOblu
PidxZuseawj7zzkOmzdE9BtFv5vaB6m+XvXWqt+ceD/Qd/ZwSewjvgGbxRov
F5+++r+3ZLVObZ+HbcJGYvOwk0/WjYX+wf5rji3V/rHa7w0fdp/Ki+tuv0pj
/kfqvr9PbV+xwz3F77PcOKOv2tcWbZP3DH3B5qMzn1fss/Gb8+vGSFPF/wTO
l9pniP876rs29gob2zp8KLhgc9nn7UXx6x4+8Iq62+5GR7Sfi7TmdmrrWjF2
2RJ7Dj905tPMfX8n2mdEs0TPHyreK84z+7Vr+ANk2LJqmYFz2ocPog5u6BZ+
EDuKPT1L7Z9oTQuDz/7YTJV9NO78xL4+l5yWS9c7qD5CshqU2X88qvfXpeGn
RXN1ap/xNthT79qqfj9+ODXfp9V+rur7qL4wN2ZZUzSvrbnX9bXKbdGGb2LM
/qEPA0ru2z9s+ciQD/M9K+b8nMa9XO+Oqtnu468OUPvqRtfRE/oPCp7sN34V
fdj0b7jghZLtYreCMXK70EEw4zLxPQccU/O4P5U8WibWJXSq2uT3zAe7OTL0
gfUjhwtSYy70Ctu4Qn1bq89SyeplbI7qp4h3O+1jz6p9Iu8PLBqXYmuwOWBL
7Bl2DfuJXcGXgUnQXzATew2/rtH3XMn4uaJ5ga3ABuCBlY0e6y3RDM/cPkLl
jU3Wb85nyybPn3VVpXttgu9+qjeXPB5nhzkxPvPpEHPDnu0Vtus2zWGqnlqj
6aDBHnYI+ww99qFT2Gps3l4xN+xZj1h7q9ADdKBX2EZouqjsXDV2GUP8UbZc
2NtPA4Ph2z+JPcVPHVR0fdeybXq3wH/gQPRnSOAI6ugRdXDpuopxF3apmthe
PgCWLBpHwgPcOCiw8YCogyGZH/PcUDBuxe8jB/oNCBrO3z5V22jq4G+w0BMh
FzDcGU0+g8wHvHNa9L0nNTbrmpsWGaFT7WN9D2jcmub8hv53r3v/e4UMhwQf
1jlN7w8J+g/q9isf1j3HgbEucCg+kRhhcOAu5vOldOgMzXVWZuw8NOY2Sm0/
xtaHjE+N9o51Y5kLE9vOzRXbWcotetRU+Fjr+VBt5cQx7vaK41rsBWelXdhe
6OExOrdt/77kMaZsLIs9AAOuCx1i7SsDf74d2Pea1P5lbcU2paFm+u+p/Yrc
9nqyylcrjtnAwsxjW8X+r73K8UVjvVmp9e2I1HoG7gefbKr4PXagktgW3VeL
+D9opoatBvdur9pmN9ccN70QdnJ50eMShwzK3d5ZY01Q/btqn5j7/fagITZk
bGLC6bFGYgNijXfD98/Qng3UmnrlxuBvNFpXsVv4xW9j/l/EGnqlnjP7szMW
CX89NOIm9KGY2N78qGbdfz14YiPfC3veNzA/Z61n6lzFwqrnyrj4Yvhz9oh3
FhS9d+gt8e4Xsa4nVW7QM7diW7E29npmrJG5Dcu9p900ziy1ra/YV48oOyaB
LzJZF/T4Oc7a9aJfofpYtb+S2y8zFjjs85At8gGDrA6/g26tCP0cGGecs3xJ
0WtmvawbudD+58Q29yTJ6vEm+2dw+5LEPmYWuCt1LHWi2mqRkyE3sy72EvnM
ijURd3MeegQf4jpsEPLvXjbGgI64nDkR7/XR2CWNdbTKS4u2Q/Tpof/bVX9e
5erM4wxNrF/b4jyCRdaFTUDuzBM/yDjlwELkCB6L+pTwm+DFFSX7qPcj/sdX
IUNyXMQmGyK2wHZzRi4r2mdBx5nDnvOuU804crLm+HjFuBbc/FXmeGybykcS
Y47B2sfry8bBPUN/0B1w7SmJ46uf5p7bypL9abnms7cWOel5VvU9c+eKyOdg
y45JHacOF4/lenc+Pji3r+sQvhL/BA2+GzxIDmmz/vdPrN/fiMfEon0s9OA3
zj+6NJKYXf8Xk8/LLNsJ6rc0t79/JjfOQtb4i/0CA5L/6Vgz9r1E/S4Sn1e0
ru9l9tdPRAyypmr9y+r2I+3C7zzO2cQXqzxIY6wX/YG57UQtznW15LUgh31S
t08mr5g5J7Ja9TNSY8VN6vt45jO3b+q4EP478UDVvnmc3s9JnX85NnXM3qB3
e4BzEpdja45DvgkMDA+wGXz+WDV2GS0+l+aOL44Sn0Ny5xCnZ8bMnwduJhey
KerYUfJHmwJDkH8iV3Na+DD8105fHf76ltTx5cFhP/vFGR8UmAB69BV7+HG0
Dwh/CsboHPTw6lL9f7zQJexDU5PxcLfAPPtEO2X/sC0DAoNQx85xBjmLWxs9
f3AvZ57zh31YEvIkvkAOxBLkhciJUEee2L/L4qzR1ipo2JM0MMybVduU/8ms
R6U44+Q1wDk3STZnZeazrupYlL4np/Yl4+P8kuOBP+PTb2Lof6/Axv/SRUr8
4GdFxwxge3wReQfsw2Op64+mtgNbY+1gH/KJ/5LHlthT/P+lYevYh0tiL9BR
dJX4ZprmfxT5B5XHi2fnf9OPNoE3iTPaxnxOz8zzncCznDF81vTEeY1K7njk
o4hJFkXOAz+yquQcFLnpQ1L7sor4DcltH7AT5M3JsX2h8ms9v1X//04ca+xd
st8mTzVF87xF416UGweT68JeUgebgPcfKXmMuWXzZ55J5vZq5v2pld3vgsz1
p6vGleBnYhTyYS9prIUNtpHcW5CfwE/gL36gdQyP3B05vPMz300Mqhunk+vn
nIH3OwXPfont3ndSx6zkCl5rMD4F14JRX8+cSyGnsjH3et/LWYBx57zMNh5b
T98bwb76/1hi24ENmZh6zydU7JsvrVuGl6h8K3f7mtwxEGOzL1cn9vfkHrh/
ICeCHVqROZdFTgv5v1yxbJ5V+wTi/MRzYT3Mh/gMOeH77kmcKyBnMEnP/prD
esl5VWbaAYlzQPi0YzPL++XYX3IprAs6eF8fuR3yBPDBNy+pW6/IcXJ30Rx+
B0x4V+BefMfMyOePye0v8BvEhOgK2Ar+X5W8H/iKT8KHYuOhR6+HZKZ5oupz
Rq6Ds4ZP5kxyHv8zt7/Gb4PFwC7IDpu0NPIe2HX8MrboZ+FHLo58MxicXDS4
fVHkht7MnB9fE7EId07gMPLejIWdg3ZhrJcz3Tv4TODORvXxmf0b/PGb91Sc
68F2g/+hXxZYi9zzo7Ef7MsN0qXxqfWYezBwPNgL/4hvJIeLfzwv8/3dKdqT
v2hffyxZza0738Ad3qjwnfjQTZl1Ly9b/5pjPuCrizK3L6larrPD3pFTYS+x
lytzn8uuiXFXQ9lx/dyQMbLtLj6vag6HZsZiKwLzgBGoo5/kSV4sOQczJfNa
9qg5ZsRmcS7AJtDhp8ipvBD0PSSTXfXunNxzfDywGbmOVwP/se/4JM7k1MS5
0Ra58+jgt74F+4eW4SPAxUNLxpHkB8kTbiDvUHf7HPKxyFl9d0kcg1IHs4Cp
bg9chbzwC/iEPyXO85DvYQ/gCUYF6w2LO9lF2C7xaUo8NnsGzUyNN5D8WmI5
gaVZO7msgSETfPiAqHMXyl0JuI57P3gSF5F3KUff40qm7x+xBfEseGFBYn/z
S2Jo/H7J/1nHxWWfueVhW4hP2WfOFHJbljtPRP4JXSDuQB9ujfmgr5R3Rh38
Cz36QK6Nc9OYWH7IkRh1SW4+xDHkwVgPcR73ya2j761Bz3q/yh0/ta3b/jSH
PqOTz4Re3hFxMPRTo8454kxMjTqx7PQ4y8TNU2M+b4ddgycyBc8Tb3KGGevj
4Hlb0BdrpgH7E+scFzJ/Me5Hzs1950c8fX5ue489xz79IHOu6n2935L5HmWr
ysWZ9yLlXq/uPbpXZYvEuYkFmX3dRSX7u/sip92dnKHG6EJspnJ0zZgrT2xv
uM8QWaFdbr/5htonJsbvxARjw+dw5qmPiziaM/TbOEd71m37z8XHJt4nvgXA
1iDfKxPn07Gpz6ucXvZ9H+MSv5BnI4bpE+3YwPWZ29/NnAPC/v4+sw2mDl4h
n05e/b2q7+PI2cGPM07+gfiR88Q540y9pHmOIwcV9zADgoZcZJvASNgZ8DFn
Cn2HPzp/duYzSFzLHnKGiSUZ57jgQ6zAPMhf4g/ZR/KNc2MsZIWPHhHfS+Dn
yMMTU+MfyAXhI8jR7h99Lw15va/xz6u5nfvDayJnPqPmbwZYF3vAuGOjPrlu
/ptFu6rs9tkRW10b8VWt7vF7J54DvorcH3kidHmbZDtJunEg5yJ3XEMdrIr/
mBZy4+59WuAobDPflvA9CfavGjahB/k07jXAArnzj4emjitZ+867xpKxOHhg
XGqcOEZr/2Hq2IrY6ynss+ifVHlzzXfK3C3fpv+91X5i6rtNYukdET+jX+vA
UzXfG9VSjwHWAeeQS+DulVjm2dAZ9hcMh60nDiM2Yv7EWT1z7+sB4v393Hmj
empafAL0D4edxAdxX70hMADjfhbYnjiFO2nOJHiNPAv7Qd9HKo6Nzqx7z4Zz
j6Sx6mo/U+W+mfncn5j3+uD/UNhmcgJgpdVl48q2cd/Hvd/OHGfF4yVxz8t9
L2d9bJxxzsHwiv3MpxFTwbNjbp4dcvvQh2L+fCsDNhpTs839deCBdnEXQZxF
/Mr8yetNy71Pu6SO34jjnkidiyIHSjzHtw7ENeRiwUpgJvSUOIm4Cbx/ce76
OJX31OxnGhL7Pc7zTr/Z5DsJsOcRkVPlOybuy7gDI+f0J/0fJT7P5/aN6Bgx
HHkFcnqsgfPHWeIcfVN1vm925D3mRlzG9ybsN3vB/Shx+DDRXFdzO98vYDew
CegQ8QfjEgN9Xfc3DHzLcFlqWzCRu+zce7EoN06YEmdqbeDP5pApZ4q816Qm
6zY6dmXNut0QMubOgFh7Q+4637/8Ks7LXwr+Zql31LH3zAd94P2R0X567jz4
wZGDmRRjPRf3fdz7EQdCQ96As4vtIB9C7p08H/lZciPHR/ybVTx/1sF3J+Tl
uFPCvnLGsbHEefTFJpMzhBd+9J34loZvasC/yAebj115NWzLYan998LM2BBs
wHnArp8VesLdPvkc8i98T0cu4IOwDceUbR84D+AkfDp5Be6xDo/8wfZoJxfH
917YWHLq5AnR/56R/yQPWo87S/KIxF4vha+tprZHX8Y3ILQh/39k9lt8R0Ds
hZ/F9vKtR1Po+pa6v6HaXHfcRR1exM3kdckPdIxvJIgvWdPRsS7KPlEnJiBW
AUPMjvOB/Fknd3boOLl+YjDirx11t29X+UC0c6dFPpu89pw455x3vmtjHvdG
X/Ad+zIyeM6MvlfEN3h8iweeJqaHnu8Gia3wNZyZGeF3wLJXRE6sZeo5bqs7
Zw9PeJNjaF/2ubo8c/35qmmQD7n65pAD+ISS2GxVxJsPRKxBzPtf8a0emGtG
5BmIw8g14zuwsdwnlQOfg13ALeS5wdPo8Pt189lY9z3Ak6GTG0I/wbDoEOPh
09ETcgHE6dwXIqcksa19OOwzWA8sh21ET8Hy6OQjQYM/Io6dH3gYX90y/DU4
eX7MszlsC/Ickft8noU9S63T3Bdxvz0z5NYy/D74iLsu8obck3QO+h2pc9jt
I/eBbLaGfA7N/S1gd+7QcvtCchjEcmAmYsa+uenbpR7zwdCT/wNgGZV7
         "]], PolygonBox[CompressedData["
1:eJwtmHeUVdUVxi/Me/PevPvevZeiiBAIYNQohNDRJWikWGOU4hKpIhLqIBqq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         "]]}]}, 
     {RGBColor[0.6037627488090325, 0.5158910618817686, 0.4641458601250416], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXn0VVUVxy/w+7377rujpqauQKksl+YEKdoKY0hbpqaAqUXlkEaFQqCR
psigaRmSmJVjKxOpENNAGbRASyBwwMoCRVhUAgHWcjEYKlrfj9/d6o/79r7n
7nPOPvvs+fW9cOzwMT2TJJmun16CH6+T5LOtJLm7TJLXBefqGaLxvEiSTe0k
ObpJkos11qNbg3qO1dieoHtLzyN6vqdP76mS5DUtOLIy3UKN7689BghfJHyh
ho/X3J6p56ztJMk+Gru/E9+D5qiW50zrSpJXtPfpwm8QL30073mNXdojSb4p
fKbovqX3v4pmvNZdonPcI3iAvu2v510af0rvewl+VGu8JNorNHe+5t0kvBBv
lcZX6X2+3neK7vOCy/Mk2SKeVoiXPws2WnelaLYLfy7T3MxrvCT6UVp/QW3e
DtJzqOaMrszDRK0zVt/H6OmtdQ9OTQf/nKNP0E8SXaP3vbVemZuve0vLpJVa
Lp/XmotF+0rls7H+JVpndcu8MGdWnPvAxOfiTIdqfKX466n3T0iGKzS2j2ha
gl2a11fjZwh/VXu/LXiSaPY0phmlvUbrrB/LfK/n6T1nX/H4eMs4MgLPUvM3
uMs8wNuJot+gbwMrn2Nt3HEuecwTXSnenuo2bx/rYZ1Bx9CBJ2vTH6e5twse
rfErNeePWucywZtFc754HS7eHhC/g4LPPPSmFDxZa05umwfeXxS8QM8b+j5N
tK8LztY679a97qdnumindFsOzAVOC/xm7fuQ8GNFf1dt/G7BO4IGnrfm1vdL
Sp8zibMsFd1/RLOstt6Bc96eYU/gyGN3yOQgnWcNOiNY1x4frLMuqn3v6NcO
7TFV4xM0tq943yF8gNaZnVrX1+u9v8b7dfyd82JH2zWe16bLassDOTA+tGU9
h5cDRPsvPScIX1xbj38jeI3m3dZlu/tn433z3Dq0Ts9WHenitnXrL3rflBky
jo/5ZNjhw1rrz4KPCN7d8lkeEs3QbtsGdjEwaI9LPAb934Sfk/kdfEvjfbvE
wy2peb9L4wsz3zt6+0ptff6y5Pbjlvdjr62l9WqL4C0am6HnJ4l5gQZ9uyS1
/oFDe3vQ1LqPf+qcH9H+x+t5RfgJgsfp2SZ8gOCFmnO96M8VvFrwKj3v1dyz
tOZ1Mb6w4/P1EQ+Pib99NT5c+POp8bGi+Yb47y18pMZX5R7rp7HB4meExn+v
92f0nBX4go79d0v0F6c+F3OeE09fk1z+IPhM8NAv8bl6xxmH6ftY3vUMavnO
uINjatvebxv7O/zeQsFp2uMU7EvyGKc5EzLf4RrRXS58teCLjcdfEOzk1kP8
+mSNTdLzZOI9oedM8PVsavngB/FthebNL62Xj5SW8W3dtsPjU8sWXUVneQdH
99FvdHu+eD1H+O2l+QNHh+4o7at6aP1B4mm71h3ceJ8rWo5P2OnFYc/I707B
E/W8HnLC531Z6xwmmlGCj+fmfa7u83eZ/Tjx7MWIWeje58I34iMfrhxLG8Gr
NX8guoL/rxwn98X34zOEzxI8J8b3Ezwz5u4l+KDgDnyx1l+u8x7NvWud0yqP
D8xNsyvONTezT8Qf4lOJy/hV9OjpLusSfmxtxPEdjfHztM5S7k3PztR6/nrk
DGnbOQH5QHfkCUOFn16Zrzm6k5mZfe04PdO7zCd+kbNx9vu6HId7texXBpWO
mfMb+5KuGMcPHRY5wMou3wd38VPt9TZ6UFqPsrC1i2rjH9f4Id2mOaXL/prz
7a1z3SSeNqeOqfj2I1v27++TfvcU3yPEw3rBdXq+JNpU52l1rMczUtvMz0R/
dmZ7IL7ix06J8RtL2zt2T3w+SeO/ELyhNH694A9S++KfdzkGHRU84JuJBfi4
PTrjD0X3huAuPTcJ31H5XKemtuvFIdNhkt2vdbYRwu8RzempaTg78LSgn1kZ
X5z7HqalvovzW/bz2NF9pXkYErF3WWqfdlzp9dnn0cp69LLOeKhkvlw0FxTm
BT5JD7+XGmd9fNiK0LfH9fEijf8pt98Cx9+ubtv+uCf2XB78s+eywL8QMfHv
mruksg6eXVnPxkdsJWf5TuQt2/RtqvCtlW3hZtG90LJ/Oj/8BvoN3/CMHyR+
kUOuyqwn0F7Ytj/Br3ynsD/b3PH9M0YsG1p77rWF9QY9xe8g4xtDDujzNZFH
odfkuOj2nC7TkKsDvxv49sp4u3BeyLy9JYN/516rFfEE28b/fzq1nWKvK9vO
ETgL8kJu5BSbK++5SWPzKsevNazZ2JftFuxVWx479XNq6XNdV1if0UnOf2tq
Pf552DExGpu9k3iaWudndxlfJfrdWuv76EZh33przCXGgt+d2F65b+6auoSc
jHzsttT7siZ56NTIUXqn9hfk1jdUjgk/yR0rBoTe3l/bd/TVvpsbx9FDCvvL
D6X2WedmzjlelNC/VNjGhpS2dXQCux4mfs5sO6/Gd86KPHx74xy9X+VYBc/Q
44MXp44zB9aBh88mP8QfkseRp+Ev0C/yH2LWhNz7bCN/S+23ueMDC9v8raX9
HPeM35uTep31sf+M4GFE4TrhstLxHx24MvzLLSF/4PcD/4D2Wyr8vMIyXBpx
lju8I+7xP5XxvUVT1s7FRjf2F/gN8ln83J1xX0dGbo5/Iwcg/iO3c9r2C7wf
UVvmyH5D6bP+gTqp7VoC20ZniMvoyf2N85g5jefjV1hzU2X7elnwb92OPeT/
xPzhbd9hz9oyRJZHa42NUZM8E/5pregnN/42RfCIzGuRQ3M/E7udlw5rjN9f
2MceErEGXcP2oaFOGhy8kWscEPk2ekJug25vzpxDY6/bBLdm9oUTY+9rBC+t
rOPUkbtiHeI7der00CVyh4GRP1zacjwiLu1TWwfQBXwLvua+8NOzAh/Z7XF8
DrXySVEvE/OA2PvE0jS3186F0Rl0Z1HIDrlho9Bz71/ptv2jM9TH7/AoX7Sp
sf280bG8nw75gK+Idc5tO59fEfJeGfL8Vuk108L3Rvym/srCH+Af0dXZwcOD
opskul8KDs5c+1HrEesYp55aXdqOvli7vicvwZ9fH/ZFzrMl6ohxWqd/5Mnk
y9xt79Bn/ATyxu7Wh23je0fX1uOvCi5o7GseaUwPDbaP3+wbcQRfeGLoOWPj
Ynxe45zj4cbxED+Jf5tZ2G+tbczL2OBnmMaHiP6H0fM4I871l8Cp18gVWOcx
6dWqxvteU9hWB0Rt+1pj/AqNL819pk9KHu8pHSOIFWOJeeSLje0Ee5kdNQ/n
64jmhtw9kj6i6ZFZb7hrHDB+dYi+nVXbTp4offet0AdqvQWZ/Qi2ujF4O7x0
PXBY6XiMnj7bcV3EvS3qOM/C3+HfNnbsr5YIZqVzGHKZDbnrwKeE9yK/15qf
0tjbhe1sXsdxF/3aWNl/PxV1PXEPeuQ5tfH4+bnliDynat6NlePRL3PHWnTr
hdL1NnX31Y35hv83K+sHerJIsI9g78y6is72CfzYyrnMeq1RRm1QC1aBf0rw
Us0/SPQfLbwGOL4UWS6Mns91+F7xcG3t2gWc+oWcqnfQ06OhLqA+GBV10BaN
DSpsS/QJuBvWxb7Io7lX7rTSt+Vaa07unge+jRwPHXkp6oM+lXtMBwte1VhP
0JeTC8ua/sr02nXGXyWna0vf63WCB8XcLwhOipg9uTQvS4IfahR6mkMjVqED
6MJ7G/PQt3FvaUHI5P2F/RK+ChsaFH2n4RFP8anUBMyh/wZOnQDNkqBn3xG5
9x4m3oZrzi7slh5LaX89pHG/Yf+2c+A5pX33A6Vpl4ddYA/YxbepBUr3OF4T
PKKw/m2J/tjg2Jc+CP5zT4wvid5Zxjky+yd0tpNZbzvxDXxJ7vrhvsrzFsRc
4lMWczdHP+UfgocXjov0e7Bj7h2bJdcm56b2HNl432NEuyy3P9oZMm+F3JjX
I+Y+VDmX/VXl+EoM+Ezjmow8jVhArFwTfdcZbe+3rZdtDxuchC027m8+2/y/
V0UcJeentqVuejlyhn9UrifJQReLfkzl/HJs5XORO0BPbfrpzL55bmP8V419
FXTwf1ThnKyoLbdNIVvg5uDhyfB7w6I3SJ5zV8RKcgDONTLytm2lx7bFODU9
ssX+icfE5dtq95WoB0aU7l2SZ0wp7ZuLyKPQq6VR17NnEfuuifxjdeS5T4b9
0l/fHPePrdNr3B78Lw0aclbuhRqeuP9y2zGYvGJj2/zx/dygoS+URk3N2uyB
TLjDd0efln4tOPpzVu6ew3Ddxc9K92qerl0vwi9++FDdwQbhH2wcH8DJD5aV
7s0tL503wNfh5FaN+fxQ/IfA+YhtWZz1nT5n1ALkp292nOdQQ4yP+6Le3C/6
r/jkD4dPxjfPrJ1z3lu7b3Fm5vg8uzH+C8GjGsvnSPpRkduTn+7OzfsHGvd4
9ws5LGwc64n5/5MR+07J/d/DuMq9D2qDk+ih5favBzeWNbaGv1odOobciNf0
jrlT+mn9Y699o7fMOHk6ORkxmZqY2pj4PitsCR2mZ0LPEP5GFe4/Hln7fxv6
QcQTakhqSWpl9mQd6mt6eP1i38/krqeoq7AF4iP9wZ65dYde0YWa30PjF9SO
UayNHFhnQttnGh/9J+6Ienxd+I3L2v7G+HNR48+OXPq5ONfJufOTPYX/uyIH
IBf4deV67DeV7Whn9DqwA96xBfrKL6Sus5AHe9MHeFfuXs+r4ZMuidhBzF0b
fQBqSM7ev/Lc9dGDwg/Rc8eHnVzbz22glm0cr/hfDl86OtZ8uvH6VxXOjciR
FggmuXmhJ0ruytrIBBlwdnpiczs+E/nd2x33PuZpzyca50vkTR+pzfM3iv/X
CeyLjNdHHX18bTlcXlgv0c9Ha+fQ5NJnl+7/0Aend/G72ndX5daX8eHPqQX/
GDTUwfy/CB+P177LJwR/n7vn/qD2mVC4D3tC/BczJvRneugha+7uuP6cXdsO
xoQPGfa/OlH4lto+nVqcWp//HannFkXv/Qzt1Snc53qtijos9OfrtWP65YJ7
Fe5fvFVZ36cFDb5uRvSj3vm/MjO/jE+Ps+P/eMcuxsU4er4udABd+LvuZYrm
3ljYp06OXAU4JXD67dgLPcBdHdd4P2rsP/qH/6JXvTBy7BVadyI1GLE0/lvk
P0Zqef5vgwZ/vi7u+sOlfdwDoplbuM6aV9hPsw45+/O5/6t4QnKYEz0ZejPo
Oz1ZZPBflagO0w==
         "]], PolygonBox[CompressedData["
1:eJwtmAlwVtUVxx8h+b4k733vPbYWOsMiLUrL2iprqxAQOy4oSdgpIhSKVSBW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         "]]}]}, 
     {RGBColor[0.7982678483326455, 0.584247486634476, 0.3498042041750582], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFWWt0VcUVPkBuzj33nDNnCsUK2Ai1ShBrxIIKS4taa4poQBSVolWEVV20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         "]], PolygonBox[CompressedData["
1:eJwtl3uUl+MWx99pfrfm9/u97yNONBjlcoaiDiZi0VE6pTpNFIlwilmy0A2x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         "]]}]}, 
     {RGBColor[0.914819959721447, 0.6570498993036176, 0.33594187513648577`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl32Ql1UVxx9gn9+zu7/nzZCXavGdVraySFpdXRVfskVD1owXQaeyLEqj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         "]], PolygonBox[CompressedData["
1:eJwtl3mUT2UYx+9oFube3723RCqDQpZKWbLNWFssoVFZEn9o1XJUJNlKC5FC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         "]]}]}, 
     {RGBColor[0.9458910618817686, 0.7347276547044215, 0.43226229183348264`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVmtslUUQ3dJ7+8Hd/fajCsQfoBArogGBYGK1La/EgCTFSESNwYSgEMMP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         "]], PolygonBox[CompressedData["
1:eJwtllls1UUUxqe09164d/7/W1SQKERAbcBEA9FEsEXAB6kLGElQgxIRhUQe
JJEdRQMaxGiioAIxioABCiqisqmA2iJC2AworQVEcMOHli2pBFP19/Hdh5N8
Z5kzM2eb6TVu0sinOoQQlkAVUI8khKOZEMZCb8UQ7oY+zYXwCdS5GMLVhRDm
o2uCrsK2L7QBfKA8hD7g3tBv8OOhRawdwpqZ4GpoNnwV+r/A6yXDV0DfDP6c
zbugfwzZPvjlUDN8Bfot4Hr0PeC/QV/IhjAF2Ur47fibBt8VVzeBe2E/u8T3
BA+CpmM7AJqFfR+ojrushnLo+sKvAZexpob1P+O/N3gX9gn8MCjCH+V+96Kr
ghZlHCPF6mHWb2X9l1A3/D2IrKXc6x8C34b9xxnfWXf/D74af7Pg17L2SfiL
5SUZ+gPI8tz1F86/HxwSY525I/6XV5KTTiGMKAuhLR9Cv4JjpZgr9oXEe+sO
j4LfTEN4DjwIn2+A9yF7Hv46fA4EL0E2t8QvBn9Y4nXfD8CrCl67m/1vYP9x
0Vg+97A+g+wY+32LzTXoVhadqzZkq8Bjsbk265iMwdfr+KzJ2ad8n+cOQ8tc
Y5dhvwP9opJ9A/gFqH/O9TUE+9/ZY6fKBv9/gB9HX4avSmzGg49Dz4C3YjOe
vY/Az0G/QncC72a/deiWwc9hvypku7LO6UH8NcFPy3nNCdUiNp3RTcRmP3hG
4twpZ9MT51y5V05Gs35D3r2zrGMIp9HtyrsX1sG3w3eB5mbsc5T2g3pWOAaN
4KGp97of/RBwsdK1OQKbzZxnILIJ8PepplPnQLlQTveq/5A1gF9Ev1m1iWxq
1j2yLXEPq5c/g+5BfwT6gniUq6aj76y7N6G/FdsFqWtDeywEn0x999Xwv0pX
dC7Vc9eDp7DHOnwtRXYRX68lPssW+CvwPxzqlHEMLsf+LDZTc87PP9hWc99W
YnWIPc9j273o3OsOPcBzUve2+LngK7FZyvp31cPoPyLek7OeSW3o2hP7Vj3s
QTeDNVU59+TZ6BqRTmdoRDcd6lthm5ngM0XnUj05Ef4HfKwt9e8p8MG81yse
L2F7Gpt5OcdIvf1E6trUzPwqugdU2xOR7UZ3tGCsmm/lLM3wE0p8C/y/RdeO
amQK9rfAH865hkcnnknq1TuQvY1+Y8FYPXwQ/fG8Z6Vm5p3wpxP71vod6FYX
3bsjkdUp3+iHZx1TxXZ50bNZshXgU9G9V0u9/gnexH7D0S9ENoi1NZzh5qxz
XJ16xl2adcg6wtdG19r7kmFfnjp2ilk7vs5Fvw2N0CT4R9izvXSfQ9h3KNmr
x9sKnmGqT9mMwfZE9NkWcKaT4GnoB2Q9ozWrVfOqffXQmsRvmN6yl6HuBe+p
vVXDZ3R/+LMZ19Pf0TFX7JSj+tQzSfUpmxvR1SbOh2J+F3hx9FnUY9/n7UO+
VKNbNKvhd6Dvhv47cP/UudiJrF/qnlD9aiadY6/J0b2p+XUB3SvRs0JvbC33
fy+69zQjG/N+I3UWvWH1rN8U3Yt6WjZGv3F6LzSjjxfcQ+ol9WBX9POjZ43e
0GHo9sD/FHzmveCZ0W+rcl6Dfjv87RW22RZ9Rp1VNfu09qv02zAYmzr2ezb6
b6AcDS76DVd/X8D+Ac3W0vzSG7BCb2nesbpUc7pLwbNRb9A7mu+JZ5HemPXo
vo7OrWaiZmNL9NupHm8F74uuXb0BegvWFHw2/UnmwddHzyK9MQ3Rfwb9HfRn
0N/hWHQt68+iv0vP6Nzpz5KVbd6xVkxeBYwq+m46o856OC29Reh/BP8Pbf9U
IA==
         "]]}]}, 
     {RGBColor[0.9769621640420901, 0.8124054101052254, 0.5285827085304795], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlltol3UYx3+5/f+zvb/3/ScE5gna1FFGMCyQZoag0cFF1E3zIqldGNLB
LnZRXSi2YAXVmDmn3agTc3jhiaahtaYIc9phW3Z0KkVlCToxQTuIfb58fxcv
z/M+7/N7Dt/n8HvrWlc//cqkEMIATxXPoTyEhdUhLKuE0FIK4RrPTj6sgE4q
h7AX/nQWwhp0hooQFuWWH0C2I4awHPkR+HeQ70G3Dv7t3Damwf/FswGdxikh
vId8EPl9yM7xrEWeI9uBr/llfzua2aZsj/CtGf5r6AA67WV/G4O/Z3IIWxQ3
Mc2DbiX+r5DPRr6e93UV88O1ITwBP4NvU4hhF7ZewM6j2D+F/Dg+H8Bnb8ny
z3nvgn+q7HzeR/8IdBP6J5BvKjvupZwZRf4w/mdnxmkQ3XZ8Xkx2qgvH+C/f
Ozg7hLya9xFiWsl7DzbbobuRn0D/Rmb9Ks4F6HK+9VU5NtlsQNZRce5j2Hg1
s94+/B5Ep7HGtdyemaq2nyJfhPxx3lt5n4udObeBUWF5F3R72ZiqTg283wr9
kth6k53DnNuf2UYdGN5dOJa7oG8W9rsOuiAznsJ1I89N+G7oTmy/WDaOB6Nj
rke/s2QMhfNYtF/5vxx9djX2bodv5mwnMeyC34bOTeSHorFsg/+HZwE6behs
Rn6ds7Owcw2+CZ1tmbFXXXVmSWG8H8xcM9WuHv4D5A+Ry4bC9VGO6knVR7Oh
Mx3Jhvr7pZJ7Tzn3cGYxZzdB22qMs/qwu+S89qOzFf4KdKDKdZe9j3gmF85L
+S1N+L+eeTbUa2fhf4o++zz8tML8mopnUrN5Bvn66LndQ2+srdjfj8j25vaz
O3eM6onmNDOK/090PsmNlTAbiq7NcehoyfMpTL+vdc5bkI+l2ezPPJ/iP4Y/
Wet+uoHsRHR9NSv9qdcPQLuj8ZiFzg/ov6xZIJbPovEdgB5D3oOdCXT2lZ2X
bF3Kne84Njuje0e7R7UUnoeRXUX3WI1nXv2henVF+5PfBmT1uevQmLnW51O9
p+eeuRnIm4mpH/nfnJ1d8YwtyYyFMFFvXCi5v4Wj+lV9ewX9N7BzCvkqZBcL
81Nlu2RMr6daqo5n0G/g2zB8k/IovMta4YcL751n4edWnNcc6NnCM7sS+ebC
NV0G/2HhXdkM/3t0bL9Fv0v+SO4zOnsJ3YWZ/cr/r9EYaL6/TX38HfRO/B2F
r4NWcsczkx2yODM+7ZrZknn1kLDsTXiOVLwTRyvGThi+VbgX1ZNTkf0SjefP
0XnK/nO57wztpKuZ9472zzPYuSXdB6O5MRJW32CzpeLaN+auh3LXztHeVy+s
wP79mWXa62OF51R7cd4Uz+tE5l3Vl86qfqrdBLr35s5RefelGkpH2Cgv+ahP
u3swepcoHsUtP6/VOJ/5mXtH92Ffrfd8a+HZupB66Xy0jz+glzPHphjV4y3p
jtadIJx114ymO1u7rKnsmLVThIVieBJs3o3pLD7Ho8+eho4Xju104ZkTnpqx
jdEzollRb6nHutGZmXlGNCtfRO/Vk2kfi9dMan9obhXXf+le032oe7Uz6ehf
oyPlovt/ZZqp6Zll+o/QHhfO59I9oB2ivnmscN53FJ457RD18arCO3c0+k4Q
ptrP/wMvM0fn
         "]], PolygonBox[CompressedData["
1:eJwtlUtolWcQhj/NOTma/3IUFC8VMU3Uoi20WtAqFkGltiqlUjBupLiwiNa6
cKFdKDaCm0JIajR2Y1U00oU3GgW1VsViLirJ8VLaREXxWtAEW6hX0uft+y8G
5v1nvm/mm3ln/srlXy9eMzCEsBbJIcOSELryIRxAHsQhLCmG8AmGf8A16E/5
1l8WQhsyMwrhBvgp+q/Ie+ChnL+M747yEM5XhHAL+zNsZ5Ap2OvBOe47BK5D
f4LPBXy3cuYX8CNkEvaz2N/Hf34awmPstYNC6CT+c+wt+PYhbxNrPvhL7HvA
PegL8JmZs89C9Gbur0E/iM8f6J8W/ZY3kEXoI7jjKvoM7BvQO7ijPu+clFs/
+BR4doE3kUt37FgPkGrVCjmtWMTsRL+NfV/eNVQtq4eEMJ67tmH/m/eMAbdj
2wjuBt/Dvxn8FzIR/yOJG7Gf9x9Gf4nPrpxzfEz8XnBDzneWwG8hE3KukWq1
L/L7PiTf71PnqFxXIJ285yXxjqOfwz6O9x/i2zLwEc73VDgH5bIa+R08HFxC
34u9A3wldX+VQx+xGlPXRxw5qtiR36ozN7GNiPyWdmQOuJX4ddg+476x6CNT
c0ccGoW+G/8ZWf/eIfaNyLVSzHbsLZFrrZr/AB6Z3a+aHee+ysjc6lJM8Afg
1jJzagH+x/hWq34Rfxj6xqJj/8i3Tehv4n8YPBj/ufi/Cz6d5fcn/hPARzN7
CTwK3FxmTp8A74pdu2nc/wLbjti1nyI+gZtic1szsRO9mxjrC+7nHezTs3y3
wPcr5FONnC+4p+ptGz2oGuR6aNYai55H+ZfQy1LzZTJ4q+Ylca90ZjN4auRZ
FGfuEv9V4n4phx7OfpTxeSnfzuntsWfzX6QZ3I/szvj4Db6tiWdJOY7n/mWx
sThWBe7J+ifOt3H/w9i7ZRXv/Rz956yf4tBO7Jdi11Y9qMZ2nW/rCn6D3lJZ
NHcVQ7FPxuaWejBa9cb+Vd412Y6+nPNL8+bH2sg9UC80o3div0lv0474Dnwm
tu8Bzo/BNi81l5RPFXizOFHw+zRLJxPvG337Fls9Mqvg92h3bEntK5+9nD+G
DCz3zDVo/6WeFfXsFbYvEtdqE/gWuDd1rWV/DW5PPGuK0ZC6RspNd85KzCFx
STW7lnrGNGvaaRfR1yXmpjgmrtUlngXNkGZJnBOXVL8+/HsT73L18Al6U+pd
qJ6VwK8T7wZx6H8upd49ylG51qaeZb1/T2SO6n7FnwbeELnfjfisxPc3+N1U
7hoUE+9s7W7NbAv5dBX9L9DO+Dj1ztLu0k65EPsfJJv+CT8l5pi4ph17X/8O
/GvLzfEB2m0VnhX1QLvuP2eMDiY=
         "]]}]}, 
     {RGBColor[1., 0.8957064518477176, 0.6481995972144704], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlEtIVVEUhreK19s995zrxuymPfVq2RvUsnJgT0gthSbVoAZGSAQaFYiT
HqRNs4GVTRoUUYPoQUFq0CCiEourBQWhBQmZ5aOURGrQt1g7GmzWOv9Z699r
r/XvnVfXuLsh1RhzlpXGmmeNuRoyZto35pBnzAzgerDVrEn8g2CDgTHNGcZM
4d8ktgX/ObmlxNSmGBPBrmVV4udiy8PG5LG6iekiPj+sewi20eHiS5z8P8Ea
hxN6Mxoo/28+dsYUr8buZc3g78Geimn+Sew+h6eybz+5x/DHyb3LeRrhvYf9
w3cr+Bj/K8ibAO9jL09ysN8i8PHvXLoxj6N6HjnXNPgK8FvgI+CJTGMGyC/E
GmIm4Kxh/2L4rxPzkZij+AF4HXmlnuZ+Bb+GXwzeAp6kpjNSA/Y+eAV4O3gl
a0xwOBPgw/jbwSbwjxPzBr+HdQR/AKwN7l/EvKecKr7fMa/FVmcp/Q7wO33t
r4//gtzD5K7BTw90lmX4Kaz9cLVR52viT4MXgQ1G9VyfsGWe9q6f2i6yNuFf
wj4hvon4dVZ1I/qpJ/YzOTfIXc4+3yNa4xz+/yC2Jqz9rQp0Fouscre62byM
6tkKA91H/sm8Euz3lPoPRDVOuIRnCPszpLOsDhTfQA0L3RxFp/VO28VWNS3a
zsLfgp/ET+DneqqBbvj7nJaS2Ldh7dtto1oudxqWPm3O0L4fJi4bvxmOpVYx
mcmXkOJxoxwyO9m7I9DcB8Scj2r/L2CTnLGXnB2BWtGDzDLL3cdl2AVWzy/9
Ex1JHYXwD7mel3g6J+lbe+w/V1GgmmpymsmBpwH/jrsr4tMu0wlPKzyPHN+r
kN7tnEDv61xs3CqPzH9boOfMZ99mX9+GuK96F+0lnS6lJ5XuLor2ZB4rfb33
M+xVYhUXbc52d3ME7WRa5YhZ1Y7cKZlrr+uN1LbEah9EvzKffPe2SP+6XJzc
y0Z3xgKrtcn96HLnzaGQWe4dk/csarVPot9VVucnd6jH6TPPU92JZv7V2u/e
FemN9ETm3kF8PTGXo3pfh13/Re+iVZnlrpi+J7UxPaecV7QpMxly2p709P0p
4P2ZimidUu+ou19Sr8yq1/Uk5qtmn/F/a6A8cTiuuHrSiP/gqb7nw5niq44e
RlQTsnc2MX8BkujYYA==
         "]], PolygonBox[CompressedData["
1:eJwtlEtIVVEUhrfpVfHcc64HMt/F1SztCRpJEVjYAzMKmjcRKiTQICGclIFG
DSobaNmkoAgbJAYNSgODBpIkeVNICS1I6IX2pJAa9P2sM1iw/rP2Xmvtf/3r
JJtaD7csc84dwTKwqYRzXdnO1WG1nnPdcWIx5/ZlOpcZOpfynTuHX8HZNPx3
xO8Q38+3LOIrsGlip8H5+E+Inye+FxwDfwbfAzeCs8GTgXOnspz7me5cE/W2
htFdcgzmUId4d8xyLoCv0d9OekuBp8Ep8CLnX2ATCetRverOc2r54DYwqd0A
59PBx4mN8C0DfzPWHNXfhH+LHAfJ/514I7U7sWriE8TrSdIDrgO/BjeCm8AB
OI38/eRfB75L/gY+/AI/oocu8AxWDF8z4O3kT2JnE9G3mHGcRv08rIXar8i3
PDTOxJ1yPI4bx+JaNd7HjUNxqTfdAFeCOzKtv7X4BaH1ppyF+NfjdlZ3LlO7
jB6eRe/LJT5L/+3gJfBR3tdI/GuWcTjE+YAzN/HL6L+DWFVo3GmGU9wd8K1W
KzaI/9S3eX7EyslXFBo3ylGM/yXH3iqNJLm/FLdZqeYB8r+N9KV5lQbGud62
i3gf+JhnvarnOfAO8A/OzmP14N3g35Eexsh1JmHcD4kP4qvo4Rv+IXpaib8B
u+9MExvxq0PL38+ZGvwHvr1NMz9J7srAtDeOVeG/9I1/7cgE/tVofzTjNs6P
BpZ7ih7egD9F+yDNSXs9Cds9abwXvyQ0ravHUnEXvV8a7CVXRmC9dYH/eTYj
zUqavQ3eExj34kBcDEf7KI7ElXZA3IrjubjNVLMdpmaK2WzzbBf0T9C/oR2c
R+4PykfuS77pUferiV3wTa+qUeQZJ+ORXufJX+OZrzu6W5JrXIjzBDgfG8Xv
pMYCd//k2GzE0frANDAS6b2PfBd923dxfAVc6NmuqAf1shgYN5qhtFIemtbF
0Wr8itD+ZZrZmtB2Qruhels4XxCYVvSPaQjsH6D72plyceUZF9K4tK4Za9bq
YYh+kp5pTz2q13zPtKkd0a7UhjY/vXmSt/717O36ptnqn6j9OsG3MfBDz7Sv
fqW1VNz+lZpJM/FZz85KY9Laf/xzxQM=
         "]], 
        PolygonBox[{{4401, 4400, 3060, 1913, 3805}, {3796, 1907, 3056, 4394, 
         4395}, {4386, 4385, 3927, 2041, 3929}, {4370, 4369, 3166, 1987, 
         3874}, {3734, 1855, 2994, 4385, 4386}, {3427, 3426, 4132, 2269, 
         4131}, {4354, 2041, 3928, 3376, 3377}, {3918, 2032, 3917, 4369, 
         4370}, {4395, 4394, 3055, 1906, 3793}, {3792, 1906, 3794, 3426, 
         3427}, {3377, 3376, 3919, 2032, 4352}, {4133, 2269, 3059, 4400, 
         4401}}]}]}, 
     {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{3617, 1730, 2795}, {2680, 1742, 2681}, {2683, 1745, 
         2682}, {3627, 1745, 2807}, {2804, 1742, 3626}, {2678, 1734, 2679}, {
         2675, 1730, 2674}, {2797, 1734, 3621}}], PolygonBox[CompressedData["
1:eJwtlEdMUEEURUfsQ/32XkAsscXuyt7AjhW7KHZBE9xZsHfFhoq9LtWlJCZu
dWMkutWYuCPs3XpOhsXN3Pdn/pT77nvDq2oranJCCJWgE/hZEMKdGMJNMCYL
4RfxQ/gDMIn4dx5r4YtAJ+Jd+SFsh98C31nbCC7Dy0FZbggtxLfhDWAs6wOY
Dd/mfvz7lf02wleBLsyNAJfgF0EJfDS4Dt8HvrF+JPFV+BVQCm/i/7XwCtCN
eAp4BG8Ck+F/md8MXw26EvcHJ+DHQT94M/Pr4StBZ+KSohDexPQm3zaYb2fg
p8Eg+B/Wb4pJA7UoLgzhCbwG9MiSJmozH3SED2SPrfB14CPrZ/DtFfyg56FN
PvEeeDVoZm0B8QH4fvCPuIF/1sDngA7MTQT34TfAF/5fwfnPYtJUbX2jb/WO
3lWN1XoeyGGukvUv4BdAMfFQcA5eb84KkgZqsQF84v++xMfgdaBPlu7gXXyT
b1Nztd8CWvNSDs2ld/bu9Zz3MqY3+bZS9H0bk8Zq/Zk99sZ0hme1Mi4GR0Av
9QOn4CfBgCx5Qm+U+Sb8NZ34eUx7uNcHxrkxfXOuEByCHwZFWYLcnJm7SLwT
/hhMhVez5/KYPK/3y4mXwq+BUVnSUC3VUC3NobnUc3rvB+PCmHJsrseDe/C7
YBx8GDgf057u3ca4RK+BvCzlxNxYQ9ZST+Ja+DLXsL438VH4bvA+P3lcr69Q
g9z0Bt9yFgzJUk7NrR7Wy+8YZ8XkOb3XwrggphyZq2l8ewrfAbpnKQfmwjM9
Ww/rZWvG2vEO3sWasraseWvfN/pWPa23rWlrW8/qXTVRG3Nqbj3Ts+0R9gp7
kL3InmJvsYfYS+wB9gJ7gL3AHmWvUiO1Mkfmyp5h77Bn2bv0nN5TQ7VsBBOY
ywVV7Z5rbf/mnDVmrc0Er2PyhN6wJq1NPak39aBe1GN6zR5gL7AmrU17gL3A
HmWvsobq2nPe1p4zc+cZnmXOzJ01aW3+B5oym0o=
         "]], 
        PolygonBox[{{2807, 1745, 2683, 2657, 4362}, {3306, 2652, 2682, 1745, 
         3627}, {3621, 1734, 2678, 2648, 3273}, {3260, 2647, 2674, 1730, 
         3617}, {2795, 1730, 2675, 2658, 4363}, {4364, 2659, 2679, 1734, 
         2797}, {3626, 1742, 2680, 2651, 3299}, {4361, 2656, 2681, 1742, 
         2804}}]}]}}, {{}, 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{2734, 4365, 3513, 4388, 4387, 2882, 4367, 4368, 3874, 4370, 
         3918, 4352, 3377, 4354, 3929, 4386, 3734, 2889, 4384, 2890, 4391, 
         4392, 3534, 4390, 4389}], 
        LineBox[{2736, 4406, 3519, 4375, 4374, 2796, 4364, 2797, 3621, 3273, 
         4358, 3216, 4353, 3355, 3256, 3257, 4357, 3260, 3617, 2795, 4363, 
         2794, 4372, 4373, 3503, 4377, 4376}], 
        LineBox[{2769, 3968, 4366, 3575, 4379, 4378, 4405, 4361, 2804, 3626, 
         3299, 4359, 3296, 3294, 4356, 4355, 3226, 4360, 3306, 3627, 2807, 
         4362, 4404, 4382, 4383, 3658, 4381, 4380}], 
        LineBox[{2771, 4407, 3589, 4403, 4402, 2919, 4408, 2917, 3805, 4401, 
         4133, 4131, 3427, 3792, 3793, 4395, 3796, 4393, 4371, 2915, 4398, 
         4399, 3784, 4397, 4396}]},
       "8000"],
      Annotation[#, 8000, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{2728, 3682, 2928, 3505, 3504, 3502, 2839, 3651, 2876, 3259, 
         2842, 3464, 2841, 3258, 2932, 3217, 3215, 3465, 2849, 3274, 2884, 
         3653, 2851, 3520, 2850, 3652, 2937, 3689, 3281}], 
        LineBox[{2741, 3329, 3537, 3536, 3535, 2996, 3737, 2891, 3733, 2994, 
         4385, 3927, 3928, 3376, 3919, 3917, 4369, 3166, 3875, 2883, 3716, 
         2979, 3514, 3915, 3916, 3321, 3372}], 
        LineBox[{2757, 3343, 4124, 3035, 3783, 3037, 3786, 2914, 3795, 3056, 
         4394, 3055, 3794, 3426, 4132, 3059, 4400, 3060, 3806, 2918, 3822, 
         3068, 3588, 3067, 3821, 3351, 3449}], 
        LineBox[{2776, 3991, 3990, 3989, 4050, 2871, 4052, 2873, 3659, 4000, 
         3305, 2868, 3470, 3224, 3225, 3613, 3295, 2866, 3469, 2867, 3300, 
         3625, 3624, 3656, 4048, 4049, 3657, 3608, 3609, 3966, 3967, 3289}]},
       "7000"],
      Annotation[#, 7000, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{2843, 3354, 2844, 3264, 3618, 3255, 2840, 3471, 3092, 3254, 
         3253, 2777, 2727, 3212, 2983, 3262, 3261, 2798, 3275, 3276, 3102, 
         3272, 3271, 2780, 2735, 3218, 2998, 3389, 2852, 3277, 3622, 3282, 
         2854, 3357, 3221}], 
        LineBox[{2874, 3366, 2875, 3314, 2927, 3312, 4051, 2872, 3444, 3066, 
         3231, 2775, 3367, 3301, 3302, 3156, 3304, 3303, 3348, 3297, 3298, 
         3054, 3223, 2768, 3364, 3291, 3292, 3144, 3498, 2865, 3293, 2913, 
         3290, 2864, 3362, 3222}], 
        LineBox[{3009, 3237, 3010, 3399, 2892, 3738, 2997, 3538, 3736, 3735, 
         3327, 3729, 3730, 3530, 3732, 3731, 2981, 3876, 3877, 3528, 3873, 
         3872, 3323, 3713, 3714, 3515, 2978, 3715, 2880, 3373, 2977, 3319, 
         3512}], LineBox[{3038, 3341, 3039, 3424, 2909, 3785, 3036, 3566, 
         3567, 2756, 3345, 2761, 3969, 3577, 3798, 3797, 3042, 3803, 3804, 
         3580, 3581, 2763, 3349, 2770, 3975, 3587, 3069, 3823, 2921, 3450, 
         3071, 3242, 3592}]},
       "6000"],
      Annotation[#, 6000, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{2733, 3318, 3320, 3369, 3368, 2881, 3868, 3869, 3516, 3517, 
         3518, 3374, 3926, 3925, 3529, 2992, 3728, 2982, 3882, 3170, 3531, 
         3532, 3533, 3385, 3933, 3932, 3539, 3756, 3755, 2893, 3400, 3401, 
         3238, 2783, 3398}], 
        LineBox[{2740, 4079, 4080, 3690, 2938, 3279, 3278, 3328, 3848, 3112, 
         3847, 3113, 3388, 3387, 4111, 2999, 3739, 3000, 3740, 2939, 3845, 
         3103, 3630, 4007, 4008, 3477, 3633, 3632, 3631, 3104, 3846, 2885, 
         3844, 3101, 3629, 4005, 4006, 3379, 4109, 2984, 3717, 2985, 3718, 
         2933, 3840, 3093, 3628, 4001, 4002, 3472, 3473, 3095, 3841, 3094, 
         4155, 3315, 3266, 3267, 2929, 3683, 3685, 3684, 3263}], 
        LineBox[{2760, 4093, 4094, 3700, 2954, 3288, 3287, 2803, 3858, 3146, 
         3857, 3147, 3497, 3496, 3641, 3640, 3639, 3208, 3911, 3239, 3901, 
         3194, 3899, 3193, 3900, 3440, 3644, 3643, 3642, 3149, 3859, 3252, 
         3861, 3157, 3650, 4045, 4046, 3499, 3649, 3648, 3647, 3211, 3912, 
         3240, 3904, 3197, 3902, 3196, 3903, 3445, 3446, 3163, 3864, 3162, 
         4257, 2806, 3309, 3310, 2959, 3703, 3705, 3704, 3313}], 
        LineBox[{2772, 2792, 3241, 3448, 3447, 2920, 3810, 3811, 3586, 3062, 
         3807, 3429, 3799, 3057, 3579, 3058, 3800, 3041, 3895, 3187, 3576, 
         3186, 3892, 3418, 3778, 3034, 3565, 3780, 3779, 2908, 3415, 3416, 
         3340, 3339, 3423}]},
       "5000"],
      Annotation[#, 5000, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{2855, 3692, 2942, 3623, 3995, 3280, 2853, 3404, 3219, 3220, 
         3233, 3234, 3199, 3905, 3200, 3906, 3111, 4184, 3114, 4181, 4183, 
         4182, 2800, 4173, 4174, 4172, 4176, 4175, 2986, 4262, 4263, 3920, 
         3921, 2737, 2781, 4307, 4308, 4306, 4310, 4309, 3100, 4170, 4171, 
         4167, 4169, 4168, 2799, 4157, 4158, 4156, 3096, 4159, 2969, 3913, 
         4347, 3165, 4259, 3914, 3507, 3506, 4350, 4351, 3265, 4349, 2845, 
         3474, 2846, 3268, 3620, 3619, 2930, 3686, 3213}], 
        LineBox[{2861, 3673, 2907, 3672, 2906, 3286, 2863, 3494, 2862, 3285, 
         2953, 3361, 3965, 3790, 3053, 3791, 3052, 4230, 3145, 4227, 4229, 
         4228, 3344, 4237, 4238, 4236, 4240, 4239, 3148, 4234, 4235, 4231, 
         4233, 4232, 3363, 2767, 3974, 3973, 4138, 4137, 3065, 4251, 4252, 
         4248, 4250, 4249, 3347, 4254, 4255, 4253, 3161, 4256, 3158, 3863, 
         3160, 3862, 3159, 3365, 2958, 3229, 3228, 3441, 2870, 3308, 2925, 
         3680, 2926, 3681, 3230}], 
        LineBox[{2973, 3317, 2878, 3712, 2975, 3508, 2974, 3711, 3322, 4260, 
         4261, 3867, 3871, 3870, 2980, 3726, 3727, 3723, 3725, 3724, 3378, 
         4270, 4271, 3881, 3884, 3883, 2995, 3753, 3754, 3750, 3752, 3751, 
         3330, 3757, 3011, 3542, 3012, 3758, 2895, 4341, 3332, 3546}], 
        LineBox[{3072, 3352, 2923, 3824, 3070, 3591, 3976, 3977, 3350, 2764, 
         3585, 3584, 3809, 3808, 3044, 3801, 3802, 3578, 3970, 2762, 3425, 
         2758, 3570, 3569, 3894, 3893, 3029, 3781, 3782, 3564, 3955, 2755, 
         3342, 3555, 3554, 3553, 3026, 3774, 2904, 3338, 3556}]},
       "4000"],
      Annotation[#, 4000, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
        LineBox[{2732, 3661, 3662, 3598, 2879, 3865, 3866, 3509, 3510, 3511, 
         3370, 3371, 2991, 3524, 2990, 3722, 3375, 4269, 3168, 3879, 3169, 
         3880, 2993, 3749, 3007, 3747, 3006, 3748, 3386, 3886, 3175, 3540, 
         3176, 3397, 3396, 3940, 3939, 3543, 3761, 3760, 2896, 3600, 3764, 
         3983, 2785, 3982}], LineBox[CompressedData["
1:eJwVzjsvw2EUx/HDpFrqMtXW2WKwu05MLE1XC4t261JRCe+ASAwSCYNeJKXV
d9DX4PIOXBYWJEI//+Gb7/Oc8zsnJ79V3iwNRUQBvdGIuYmIdCbiazwiwwdj
ETWcYzUbcai2wke8rraGfjpi0tw0plDz3zVfRgn/9i7I3erdoY0uOri054mf
k569HfzJn8n3vO/RxaxcUabJG5znpnoLN5iXr6s3cI1WksWF3AM/oi7XwLf9
p/I/vO2+X70dftd7Q8X9L/yKJb3F5E7vKxybO8GMvcP+OV7W31erYg8ptQ/7
RviT+zwAoQo2PA==
         "]], LineBox[CompressedData["
1:eJwN0D0vQ2EYBuCna9FzQm2G1oAfwCIhYai9EgtDY6cJo6BFsJjtQvwMVFr6
wT/wNRskEgkLruHKfZ77fd5zmhZXq+X1TEQs0chGTKcRSX/ETy4ilQcDEft8
OkuTiDldIuflhf6cG/M1V7y5/0rJ8xMvPDPlfZMkfRFn7uTkrb7Bjv1tjnVF
OUqBd3PV7p2dFk1KvrvrrOJsTy6YO/ouPS7t5521Pd9Tt1PjRDcuJxjj27xm
d1jO+F2zrLDMCA92Humy5Rs9uWF/k0Vz3rvL8lT/5b851B8xpPt1f1D+yQ/5
D06FMiI=
         "]], 
        LineBox[{2773, 2793, 3616, 3614, 2922, 3818, 3819, 3590, 3063, 3817, 
         3431, 3432, 3061, 3583, 3971, 3972, 3428, 3574, 3573, 3572, 3188, 
         3896, 3031, 3787, 3040, 3568, 3956, 3957, 3417, 3560, 3559, 3558, 
         3184, 3411, 3410, 3771, 3025, 3552, 3773, 3772, 2903, 3606, 3671, 
         3670, 3775}]},
       "3000"],
      Annotation[#, 3000, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0LsuRFEUh/E1zjTOXHgAkRgUCoOGTlTKKc50RqWVuPQmoUW0LqHTGY0E
ZzwAD0FNlGIoUPhN8eVbe+3/WvvkjK1tZhuFiFjFVClifjhiAedDERfYq0QU
yxGHXOEOX+MA+8jTiFFOZUsYxIxcmevcsmuOV3iWE9mGd6bV73pF9aLeI/ec
n3gXW1Vv8zY/2DWgXpK7k7nHLbrIcWnXM7/072RzhPyZfIG7zuv2tNUf6h2e
MPMq/+P7j+V++c15Un/Z/R/XkOmNc5Ov9Kvc4cyeJm7MjZhP1D1vfOETqZlv
Trjt/tT9Sf/fmK/jSP8f7uIw4g==
         "]], LineBox[CompressedData["
1:eJwVzz8ohHEcx/GvAXV3z+PfYEJmZ6FEDJab/dkoKaM7d6sig5LYWUzX7RQz
lps5u4mkRIni8qe8DO/ez+fz+/6+v57Blcp8uSUilpDPRjQ6I25wja1cxHYS
0crNNCLlcf0E0o6IBEXfD5mISxTlVVTM1fUN+9Z4Si7xJJ/gGNN40WXNVL2R
4Wd5V1+w4xYLujfdiLdHkcg1szm+cH6OTecb//d0/TyAPjzJJbPdXDc35v67
flle9N2LT7mJD6x7t2y+x/mrXJBPcYZZHOjm+JBn+J73+Y73+NH/X+Hb3h98
oUv/y228Y3c7D5kfRh5H8h914TT0
         "]], 
        LineBox[{2972, 3660, 2877, 3597, 3599, 2779, 2731, 3326, 2739, 3924, 
         3521, 3720, 3719, 2976, 3878, 3167, 3525, 3526, 3527, 3381, 3382, 
         3004, 3745, 3003, 3746, 3384, 4286, 3173, 3885, 3174, 3394, 3393, 
         3938, 3937, 3541, 3016, 3759, 3008, 3762, 3763, 3544, 3545, 2743, 
         3334, 2745, 3663, 3664, 3601, 2899, 3665, 3942}], 
        LineBox[{3074, 3679, 2924, 3615, 3678, 3677, 3820, 3346, 3813, 3814, 
         3812, 3816, 3815, 3046, 3898, 3191, 3582, 3190, 3897, 3421, 3422, 
         3043, 3571, 3958, 3959, 3419, 3563, 3562, 3561, 3185, 3414, 3413, 
         3776, 3027, 3557, 3028, 3777, 3023, 3890, 3891, 3889, 4290, 4289, 
         3337, 3770, 2788, 3985, 3769, 3605, 2900, 3666, 3943}]},
       "2000"],
      Annotation[#, 2000, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVzTcvBlAYhuGXD4MeJhMWMVi032AiiEkvk4XBQGzqRKINgjAzKKPyHww2
okSiREKil5C4vuHOfd7nPO85pb2DzQMpETGIrcyI27yIoayIG77HHUrMx1zM
P/kRM86zONXfxJPzsLtHHuFUnXlO4Tn+y46o4xZzmfOu3h7+7C7nRPzytnkH
r3jBCip07+0k7K7qrWFcdi4b4wt7bXqtOJD1yfJ5X7+Ga1GJalThWb+DO9GO
bnQl7+xd8nTyTZ7iK91u73ahE/2yBv/XI937D8l3ZRvu1vGBdxTJG3UydI7M
h6jR65E3ydLdLXKaeSk58wS/6Y1zwrzA1/4fzY0oRAHO7JXLv/V+8IlJ8xef
eP8fuXNC2g==
         "]], 
        LineBox[{2746, 4195, 3125, 4194, 4197, 4196, 3020, 3768, 3019, 4122, 
         3335, 3767, 2787, 4345, 3766, 3604, 2898, 3765, 3018, 3548, 3941, 
         3407, 3017, 4288, 3179, 4287, 3178, 3395, 4117, 4118, 4116, 4120, 
         4119, 3005, 4284, 4285, 4283, 3172, 3383, 3742, 3743, 3741, 3002, 
         3744, 2838, 4337, 3164, 3523, 3522, 2989, 3721, 2888, 4053, 4054, 
         3710, 3709, 4108, 3316, 3708, 2970, 3707, 2971, 4165, 4166, 4163, 
         3099, 4164, 3270}], 
        LineBox[{2747, 3126, 4198, 4200, 4199, 3021, 3549, 3550, 3551, 3336, 
         2748, 3668, 3669, 3667, 2901, 3888, 3181, 3887, 3180, 3409, 3022, 
         4291, 3182, 3944, 3945, 2749, 3412, 2752, 3949, 3948, 4294, 4293, 
         3030, 4295, 4296, 3950, 3951, 2753, 3420, 2759, 3961, 3960, 3189, 
         4297, 3045, 3430, 3047, 3788, 3048, 3789, 2916, 3610, 3611, 2790, 
         2765, 3353, 3979, 3978, 3593, 3073, 4243, 4244, 4241, 3150, 4242, 
         3307}], LineBox[CompressedData["
1:eJwV0TkvhFEYhuFXYzbLqBVoqcWSoCD0CqVCxyRjzBh7S0Mh9gpRk/AH/AC1
MENjLUTCDyDhmuLOfc5znvd8yfk6pmbH83URkcNdOmKvOWIXO3jDK7ozEemm
iAwasIAy0lkZAps6f7pbnLI/4iQf8lVDxCVG8C1rkeUaI26sn8284AmT8mGd
L3nWelpnBh/WK85XsYZ22bzOoG6Jh7jMA7zMK1jAEhZxhlkUkEcRc6i4t5Wr
XHDvHIpoq31X3uu+ae7jU9kJUrr99hNc1X3EAxL2x86T/GmmR+ccF9iX1csO
OMEb/GNmnX/52rsXvWcJY+iUj3IX3zuvYLv2P8y+49ad/0U5Ozc=
         "]]},
       "1000"],
      Annotation[#, 1000, "Tooltip"]& ], {}, {}}}],
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{-10, 10}, {-10, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.656431137446885*^9, 3.6564311569064655`*^9}, 
   3.6564311928218307`*^9, 
   3.6564312794741645`*^9},ExpressionUUID->"7003582a-6f5e-4a1f-89e2-\
a1ab610ec729"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"g2", ",", "v2"}], "]"}]], "Input",
 CellChangeTimes->{{3.6564311988114243`*^9, 
  3.6564312094335938`*^9}},ExpressionUUID->"211a15d6-d612-4413-809a-\
ea4b189dd5dd"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJydnQe0lrWy9+lV2u59v7sIiqhIU46gUbAgWMBKEwV7QbCBvWJFj3pQKWID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    "], {{
      {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHm81lMex3/P73e7Pffe597nSSEZkkERFU1DG2ZKjOzSoCRahIRSUtb2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          "]], PolygonBox[CompressedData["
1:eJwtlmlsVlUQhi90+W57v++7V2QRmgj8EKVVJEAVTVwSKPhDMEUwUaBAy1aU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          "]]}]}, 
      {RGBColor[0.4092576492854195, 0.44753463712906116`, 0.578487516075025], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgvYllPWxx+97/M+h/t+nvsuKZRKGYcRJqnGkPkiHTAOlcyEMogKZfhU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          "]], PolygonBox[CompressedData["
1:eJwtmHeUVdUVxi/Me/PevPvevZeiiBAIYNQohNDRJWikWGOU4hKpIhLqIBqq
aMQElRKXAgELooIrJhGioJSZAaUJBlRgqQTEIIJUBQswEhiS/D4//zjr7n12
Ofucs88ut9HAUd1KqwdB0LlaEKT4rkuCYFBJEFyeDoIWcRB8Bf4SeAhTLgyC
55m7MRsENzDmAT/D6ATcsTgIHiwEwS/gf7UoCK5lrjlwf2S+Bl+OjhPg4+Fv
je760CcAL4LeiYXPMBcl5hHvOebaRkGwEfy34M2hj4C/DPxO8Mbgy4CvYO6n
rN0GfGw+CB5l3ATch7nPoPdAx/+Ai1lvVS4IuoMfLPJcT+BN2HwW/gaMjcCb
cratIfQ+4IfQMZv1BnA+Z6ENB68PvjgTBAXW/gIdc7H19+AHgfvnretrxsXQ
30fmYq2NvoPAJ5FfhfwE9G1k74fB54BH6GiK7IHIurYiX5P1WzC3F1pv5HvD
uwuZSeCNwOuBfwl9M/fWAR0zwRcjcz20JfAsAn4M+tEi36Hucjj4peiuAc8a
8DOMfdAWwdMQ3d1YfySyB8B7gJfC3xT+WvCvh7eP+KFHyPQDfps9FdjfWHgO
AI9l7lvol0OfCHxL3rZdxXgK/BhjIXA9eK6Bdhz8FfDjrNcJ/HZsrsNaH3MG
o8FHYEMVtJfh749tEXNLga+F5zT4N/I35Ovin7XgLeS9919Bn4GuhLnzq/+4
BrxrsDHB3vOh94A+IbGt/cE75O1j8jXxjAQeBH0Y+mrCcw/wtchk4H0P+wbD
H4Z+G9qT9tY38dlcjY5vWasD9Pexvw06bsbef0K/tNhvYAzy28FL4a+AZxvw
AsZN4JcxxgE/qD0hu5MxHPlS5o4DN4Z+L/AHrHEJto5H3yHgOcwNRX8e/Db0
38MeiqBPZ+5TbH9LbxLZFvhM+4LfhN7GO/BnwffDvx5bOjD3BfA0dNyats79
eovyIdY/Hx1DgFtiUyX4EvDvwDdhb42UfVy+/l1s3+6DvhPAwxjN0vaZ4cDz
WLMLeCnv4TngUYn3pjPQWYxG/66UdU5Gdxn2ppBdj0wx/Fdh3zFoF2DfSPiP
MJ5B9t/soVneNsk2vYFeyB8Ffw58EuulwcflHTt+jvyV2NMFvEnKPiXfOi2f
KXEM+x54LjLrWH8tIwveGxte4izrgo9DvqZ0AjdD3whoqdBvXTbJtj/B0wr6
e+ibAbyH/dyf9hlMZu0M/DcDz4Dnk9gxULFQOjeAF0MfCVwT/beivwKdF8Hf
D/2rgYsYTeGvxXgE3jzjXvgHwr8Q/pdZ4760Y+hKeCsUw1LWuQr4jbx9R2ew
FHgV8jdmHCPbIr8Xe8ekHWOnQB+Y+G3UYrQBHwAelzhGKFZ8hf1/QD7H6Auc
VcyD1hd75qOvveIT+GfoGwb/C8ydq+a5F4E7Qv8GeC/030GfhXw5tq4DT0Nv
Bb12ynequ61iD6PlD4wp8LZm7ij818FfBt4C/LWU59oAd2WcAm7NXBfg1cif
SvnM3gLeGzs2zQbfBzwz9tvoyJgFfIAxF/hpxv3o3wneDrgcmX/pPDmv79l7
Bev/F1svZmxDfzl4D9Zbyx46p8zTA/7LQsvWZe66yG9Wb/cO6Juh/Q19rVL2
oU+AmyOzFdp2xkh0H0bm4YxzknLTLaHfgnJIUeHHGJ12DlMuW4LMw2n79A++
rZjIehMV72Ub9KqUeV4Hng5PY/AWKhaQP5f3XpYh/2ToN6G3sV5noreguZRt
Po6t/8g79uvNvgZcDf434V3OeAreFHhZ1nesu3429N0sZY1J7Gd27LP/gOV3
KHbpznRXjD/D+xI812fss/LdRwrOFaPY70OsdwR8FvhsxtGCawjVEr2gr1Cu
R6YiaxtkSwX4DRnrlO75jK7AVci0Q/7uxL7fDXvKsecw/KOglzLek++HfovS
mYZ3v95vxjVLv4LvWHfdiLn7gZ9ndEt5jReAayteg29VzgIenDj2Psx6bfOO
IYolyuHK5ZWRa7HFyOSgD2K9k0W26X1oc8DfzvrMdHb3MZqUOKcotzwa+u2I
JyN6ZNv0pt7K+c519xugh8C5xPBF8IyBNw/+juIf+IO6C/TtYP224FPBqye+
a/nE+NB3prt7iPNcjL2vwZPD/gHQ34W2OLSsfFK+uUs1DfDdyol6//DvLHYO
Ui46x+gMvkw5A32HkP8465w7WLmbuf1Z80wB/3XBueAS1r8FOEb+9WLn7ILq
udg0xbwB8t/YuWwr+qs4j2bgWzLOqffItyPXejrzCyPXAKoFjiDTkr23Sgwr
BikWNdV56f50ZsC3FVxrbUPnCPQtT+ybaeaugfZlwb6rnKPcMz5xraCaS7XX
eYl9JQtPJ+j7WP/SjHPCTPkiNu0t8txE4PF5107KcZXy/8S12kL4ZwH/hDEd
eJdq4sRnrrO/Hfk3kG+QmPY5e3wM/SWJ375ixAzVqtpjiWOqYusF4Nuy9mn5
9kbWBw0qdSfgdRnbgf/COAV/vbxpitGdoI2NnWvnsb8T2LI0si3ymTWs9yr7
PZbxHe4GLoW/BbYNwYZ3E8dgxWLxiHcJ9P5Zx+TXgTcl5q2P/A70bVb9B94U
fHjBNYdqD/ngipxrdNXqynHKdasS5+Ji6KuR/xnrfVTkHkK9xMm8Y5neiN5K
CfIb0+651mr/4DvS7hnUO9yGzqHYth8d3dFXFLpWUs+g3mFD4tpHNdUodK9V
zAAfi8xH8B6KXdsrRx0Gfhr9PYu953M514CqBRXjFiBbBM8C4N3KEdAqY9+F
cux84H6Rc7lq8obAYxLXzsrRV+ddU6u2zinGoP9g7NyodPF38DPgr4C/ifx/
YucM5Q7lAOUC1SiqVfSmC9DaJe41lymGAC/KO1aohmiXt8/J9+RjDySO8Yr1
qqm3Jn4DegvqeYZBO8jczBLX1BeBn4gcK59gT6eAT0aGdQY6ixqRz/6s6i3g
mpFt1xvSW1INplpMPivfvStxbaKaqjX6XwzdC7ZB32Pw/yayLtWwqmXV46jX
UU5SbpLPyHf0RuokfvN6+8PAq4eOCYoNyvnK/epB1IsoBikWtWR8mLEPbA3d
w6uX11yr2Hequ60EX8r6DcD3gE+FfyV4Dp5XM54TbVnk2mMf++2GvpXQh+it
Ql8ROwcqF6oGHaRaILatqtlVu1cxtyXlN9AV+bGRc8UlzOWBqzE3FP47WP/Z
godgrRGEzqHKpYrhiuVPx/63oH8O+vegGKBYoJyq3Fo7sq29wJcDv8iok3ZO
LYd+X+xaUz30aOBRjFpZxwjFCvVQ6qXU80zF9g9DvyX1pGvQNS12bNQbna6z
TRy7lVN+yC05r30nY0XkM9XZqiefhq3DGI+n3JMOBZ5ccK+qfyr6t3KlclaR
a+CS0DlGuUZvVm/3rti5UT3oQOBy5aiMY4hiSffE/1J05k3Q9QXy/TLmEe95
kXt7zZXJHwv+F6AeUb3ipNi1tmx8QGdVcG+onm8P8C9j15r6h9IT+y5UDEq7
R94Ses/au+Yy8A+NHQv0D2GIeg3lkxLXyE/G7pHUKynHHA0dYxVrVXPWAN8d
uxfSmewCLpFNKftoCPx45LelGlq19MHQvZxq4EPQ/gj+16xjzvexe2j10vK5
MvDd2DOuxD2ReqOWef87Ug/TH9qH4J0D6zgdu2dR76IeTb2acoRyhf5RvZP4
n5H+Hcmn1ub8RvRWtManiWtq1dbyyT7oThL3Jk0YdytXMJ4IfEYHdJc5/3tS
zFLsuiLxvyf9A2kP3D32W9Y/tG7An8fuVZSzlLvO6v9Uxv8I9K9gZ+h/R6r5
Rkt/5FpJPFXAO2LXbqrZPgbOx/73pDNvnveb1dvVP4JQdx3bdvWwvYH/DwIT
uKE=
          "]]}]}, 
      {RGBColor[0.6037627488090325, 0.5158910618817686, 0.4641458601250416], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXn0VVUVxy/w+7377rujpqauQKksl+YEKdoKY0hbpqaAqUXlkEaFQqCR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          "]], PolygonBox[CompressedData["
1:eJwtmAlwVtUVxx8h+b4k733vPbYWOsMiLUrL2iprqxAQOy4oSdgpIhSKVSBW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          "]]}]}, 
      {RGBColor[0.7982678483326455, 0.584247486634476, 0.3498042041750582], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFWWt0VcUVPkBuzj33nDNnCsUK2Ai1ShBrxIIKS4taa4poQBSVolWEVV20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          "]], PolygonBox[CompressedData["
1:eJwtl3uUl+MWx99pfrfm9/u97yNONBjlcoaiDiZi0VE6pTpNFIlwilmy0A2x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          "]]}]}, 
      {RGBColor[0.914819959721447, 0.6570498993036176, 0.33594187513648577`], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl32Ql1UVxx9gn9+zu7/nzZCXavGdVraySFpdXRVfskVD1owXQaeyLEqj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          "]], PolygonBox[CompressedData["
1:eJwtl3mUT2UYx+9oFube3723RCqDQpZKWbLNWFssoVFZEn9o1XJUJNlKC5FC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          "]]}]}, 
      {RGBColor[0.9458910618817686, 0.7347276547044215, 0.43226229183348264`],
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVmtslUUQ3dJ7+8Hd/fajCsQfoBArogGBYGK1La/EgCTFSESNwYSgEMMP
n7wRDaj4THioYFSQYqCtGBDlpRRiCigIBVMiLVCC4gt+UF4JQbTiOZ5J/HHv
zjc7Ozs7c+bs9pn09LinOjnnSoucK8a4J+fcibxzN0A+FpyrgTzIO9eE8RP8
RhRJ12RyAfbLIP8E+wmwOwsnD6fwh9966PYVnHsOfo4kzt2ZOfcH5NFY1w3z
3fFrgE0zbJqD/PSFj2uQy6BfEp17BDZ7oQ8Ye+e0N/f9HONt+B4L+eYS2XDv
aqxvwzga9m9AVwSbw/C1AL6mw2479LtKNEd9MP8e40SMbXmd6TC+F8DuM6z7
LigfbYizJWj/S5D3Yn6pnf0WnG0e48C6Y9ANgw+Yuh34O4qxvSDdUNMfDFrn
YF/m5acJuqpUMnVnIS+Dz92IYbBX/k/AZit+r7BGXIe5F2HzPWzroJ8N/XDE
chVzK7HXx9AFzE/LKy+nEcccyPXQXw+7BZA3Qa7FbybkKuguBeWmEWNFXj6/
xffoTDL3GZXJnuvK85K/hk1LXrVhXVoKWncrYuvplfNvbJ/7zZ4xVpj/2kRn
r84JH8TJz0F4HJtTDTYH5e8ofK9IlAfGyvlqs1nf2bnJeeHlh4L2KUsV+wO2
19BM+74AZ0tyOgPtKjLJs6F/EjFfRc5OIceleeWKMT2KuTFdgMWuyCnkYuox
boOfr6y+/aPkGvi7I6qvaiG3W03PYTyM7/VYW4592r3iWI7Fn6aqNWt+PsiG
tn9Cvwprj8DfNp4jJ2zNz6Tn/ADMNUK/JtP8brNpg341bP5OpdtjuZqD7wro
r3nhgjLPPDPVyBw0IM/lJapVJfwOgfwM1+FXBDlDHrrkpecZ5nrVLA/bU5Dn
Q3ec++O7GjaLU9nTlvlcmUjP/NXBZhzk92AzLNO+0yEPwe8y1qTY675UeF6L
3HSzvG8JOi/X8nw3Bo17MfbK1PsNWPdSifqF/LI0CDNbEOMZ+NtgnEKMTOW5
MDZ69c8orK3HbwrkOoyvwWct5OKo3qPPd6NwTRti4sEgH6cxDk4UwyHk9Aq+
N3EvrDvpxV8TeaYozL7phWfmlvE1Gxe9j/nfzSd9j/Dy1xOxHMwU87pUvc1a
zkpVJ9alEmtHGo6bMvkoNTzzvJn1xdQo/psD35WJOK0K3zNKFH8Ppz7oYmuJ
J+KqA2MP7NuO3qtAjbYnwi15gJzXaDjcmAjbxcYBxdZ3rDFrPYP4LOju4B1C
PmUMfTLVv9E4lDy9zLj6Osx9Ab9jbH/yAjmhV5A9e2KtrSeOLuJsM2DTCv1N
Qb3AHiWXcC3xVJ+Ij5h/xkz/5P3VXrV8GfYfReGceKdtXSJOJ4fVmrzGK39l
mc690fwcCP/jlHj5MlEueEcwTp5xV9D99Sx83I71+2AziVztNb8Tcvcgnulv
9wBtuB/PsdLOsjwK77xXyROtiXrylHEfuWd8EB6Ikbsy2TxPHBm/kxfn2X1A
7uydCQt/QfcQ5CuwH5/pHBvtLLwHzlhPsefZ40tS9Tb7dDD2ulwQRs4G9RVz
cXfUXUt+2lBQn7PfTxaEb+J8BGy2Wp98yJit916H7aAoLhiIcUcq7O5M9Qbh
+YmtVtra+4C447nIb28H5ZY5Zv/VGwaINd73rOncRL3Ptwtzz/uenP9LlL4T
xoVR+unw0zkTNvrB6LL1PjmgwitHF4PeB+yP/ZD3F+Sb7yPilP3FerGPy403
ef9xz9qCcMs3DTF/r9fdkMOeCy1O8viwqD5/C4sqjbfJ34yPcTq7i1qsZ3+M
hhGv/DLP2yAfMA5tYr9azpn7Fr6vsN8Fnsm4Y3HU3Ua/01Kd+0JenNUv1UgO
Y48yZp6/I9P9/Q/71SvXJ+GnPQhHi7zeE+Sq35jDKC66B+OqznrDkRMa8T0F
a4/BflfU25DvU9691P/3NoV+KuQ201Om3atRfVjvdSf0TbQ368AzNhjuif/5
Ue8w1mAR4hpueWa+Z0etnRWF9z12H5NbGeMh+CjJdHbWje8wcmt36AakylWN
F/+xv7jfQMN276BcMK6ZUe+dX+3Nw7HGZPIw729im3XYbjLvk5GJ3oR8y1DP
un8Qpd/sZdORiDseyyRPIJa98sM8sRdL7f7gG4tcfhyxnctUj/OZ+It99jjs
O7xweQ7yuqj9+Wbnncd4W4NqyZpWB70ZW61P34niNnLqZMhd4eeJqD6mTBty
DHuSvPcvaHW8VQ==
          "]], PolygonBox[CompressedData["
1:eJwtllls1UUUxqe09164d/7/W1SQKERAbcBEA9FEsEXAB6kLGElQgxIRhUQe
JJEdRQMaxGiioAIxioABCiqisqmA2iJC2AworQVEcMOHli2pBFP19/Hdh5N8
Z5kzM2eb6TVu0sinOoQQlkAVUI8khKOZEMZCb8UQ7oY+zYXwCdS5GMLVhRDm
o2uCrsK2L7QBfKA8hD7g3tBv8OOhRawdwpqZ4GpoNnwV+r/A6yXDV0DfDP6c
zbugfwzZPvjlUDN8Bfot4Hr0PeC/QV/IhjAF2Ur47fibBt8VVzeBe2E/u8T3
BA+CpmM7AJqFfR+ojrushnLo+sKvAZexpob1P+O/N3gX9gn8MCjCH+V+96Kr
ghZlHCPF6mHWb2X9l1A3/D2IrKXc6x8C34b9xxnfWXf/D74af7Pg17L2SfiL
5SUZ+gPI8tz1F86/HxwSY525I/6XV5KTTiGMKAuhLR9Cv4JjpZgr9oXEe+sO
j4LfTEN4DjwIn2+A9yF7Hv46fA4EL0E2t8QvBn9Y4nXfD8CrCl67m/1vYP9x
0Vg+97A+g+wY+32LzTXoVhadqzZkq8Bjsbk265iMwdfr+KzJ2ad8n+cOQ8tc
Y5dhvwP9opJ9A/gFqH/O9TUE+9/ZY6fKBv9/gB9HX4avSmzGg49Dz4C3YjOe
vY/Az0G/QncC72a/deiWwc9hvypku7LO6UH8NcFPy3nNCdUiNp3RTcRmP3hG
4twpZ9MT51y5V05Gs35D3r2zrGMIp9HtyrsX1sG3w3eB5mbsc5T2g3pWOAaN
4KGp97of/RBwsdK1OQKbzZxnILIJ8PepplPnQLlQTveq/5A1gF9Ev1m1iWxq
1j2yLXEPq5c/g+5BfwT6gniUq6aj76y7N6G/FdsFqWtDeywEn0x999Xwv0pX
dC7Vc9eDp7DHOnwtRXYRX68lPssW+CvwPxzqlHEMLsf+LDZTc87PP9hWc99W
YnWIPc9j273o3OsOPcBzUve2+LngK7FZyvp31cPoPyLek7OeSW3o2hP7Vj3s
QTeDNVU59+TZ6BqRTmdoRDcd6lthm5ngM0XnUj05Ef4HfKwt9e8p8MG81yse
L2F7Gpt5OcdIvf1E6trUzPwqugdU2xOR7UZ3tGCsmm/lLM3wE0p8C/y/RdeO
amQK9rfAH865hkcnnknq1TuQvY1+Y8FYPXwQ/fG8Z6Vm5p3wpxP71vod6FYX
3bsjkdUp3+iHZx1TxXZ50bNZshXgU9G9V0u9/gnexH7D0S9ENoi1NZzh5qxz
XJ16xl2adcg6wtdG19r7kmFfnjp2ilk7vs5Fvw2N0CT4R9izvXSfQ9h3KNmr
x9sKnmGqT9mMwfZE9NkWcKaT4GnoB2Q9ozWrVfOqffXQmsRvmN6yl6HuBe+p
vVXDZ3R/+LMZ19Pf0TFX7JSj+tQzSfUpmxvR1SbOh2J+F3hx9FnUY9/n7UO+
VKNbNKvhd6Dvhv47cP/UudiJrF/qnlD9aiadY6/J0b2p+XUB3SvRs0JvbC33
fy+69zQjG/N+I3UWvWH1rN8U3Yt6WjZGv3F6LzSjjxfcQ+ol9WBX9POjZ43e
0GHo9sD/FHzmveCZ0W+rcl6Dfjv87RW22RZ9Rp1VNfu09qv02zAYmzr2ezb6
b6AcDS76DVd/X8D+Ac3W0vzSG7BCb2nesbpUc7pLwbNRb9A7mu+JZ5HemPXo
vo7OrWaiZmNL9NupHm8F74uuXb0BegvWFHw2/UnmwddHzyK9MQ3Rfwb9HfRn
0N/hWHQt68+iv0vP6Nzpz5KVbd6xVkxeBYwq+m46o856OC29Reh/BP8Pbf9U
IA==
          "]]}]}, 
      {RGBColor[0.9769621640420901, 0.8124054101052254, 0.5285827085304795], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlltol3UYx3+5/f+zvb/3/ScE5gna1FFGMCyQZoag0cFF1E3zIqldGNLB
LnZRXSi2YAXVmDmn3agTc3jhiaahtaYIc9phW3Z0KkVlCToxQTuIfb58fxcv
z/M+7/N7Dt/n8HvrWlc//cqkEMIATxXPoTyEhdUhLKuE0FIK4RrPTj6sgE4q
h7AX/nQWwhp0hooQFuWWH0C2I4awHPkR+HeQ70G3Dv7t3Damwf/FswGdxikh
vId8EPl9yM7xrEWeI9uBr/llfzua2aZsj/CtGf5r6AA67WV/G4O/Z3IIWxQ3
Mc2DbiX+r5DPRr6e93UV88O1ITwBP4NvU4hhF7ZewM6j2D+F/Dg+H8Bnb8ny
z3nvgn+q7HzeR/8IdBP6J5BvKjvupZwZRf4w/mdnxmkQ3XZ8Xkx2qgvH+C/f
Ozg7hLya9xFiWsl7DzbbobuRn0D/Rmb9Ks4F6HK+9VU5NtlsQNZRce5j2Hg1
s94+/B5Ep7HGtdyemaq2nyJfhPxx3lt5n4udObeBUWF5F3R72ZiqTg283wr9
kth6k53DnNuf2UYdGN5dOJa7oG8W9rsOuiAznsJ1I89N+G7oTmy/WDaOB6Nj
rke/s2QMhfNYtF/5vxx9djX2bodv5mwnMeyC34bOTeSHorFsg/+HZwE6behs
Rn6ds7Owcw2+CZ1tmbFXXXVmSWG8H8xcM9WuHv4D5A+Ry4bC9VGO6knVR7Oh
Mx3Jhvr7pZJ7Tzn3cGYxZzdB22qMs/qwu+S89qOzFf4KdKDKdZe9j3gmF85L
+S1N+L+eeTbUa2fhf4o++zz8tML8mopnUrN5Bvn66LndQ2+srdjfj8j25vaz
O3eM6onmNDOK/090PsmNlTAbiq7NcehoyfMpTL+vdc5bkI+l2ezPPJ/iP4Y/
Wet+uoHsRHR9NSv9qdcPQLuj8ZiFzg/ov6xZIJbPovEdgB5D3oOdCXT2lZ2X
bF3Kne84Njuje0e7R7UUnoeRXUX3WI1nXv2henVF+5PfBmT1uevQmLnW51O9
p+eeuRnIm4mpH/nfnJ1d8YwtyYyFMFFvXCi5v4Wj+lV9ewX9N7BzCvkqZBcL
81Nlu2RMr6daqo5n0G/g2zB8k/IovMta4YcL751n4edWnNcc6NnCM7sS+ebC
NV0G/2HhXdkM/3t0bL9Fv0v+SO4zOnsJ3YWZ/cr/r9EYaL6/TX38HfRO/B2F
r4NWcsczkx2yODM+7ZrZknn1kLDsTXiOVLwTRyvGThi+VbgX1ZNTkf0SjefP
0XnK/nO57wztpKuZ9472zzPYuSXdB6O5MRJW32CzpeLaN+auh3LXztHeVy+s
wP79mWXa62OF51R7cd4Uz+tE5l3Vl86qfqrdBLr35s5RefelGkpH2Cgv+ahP
u3swepcoHsUtP6/VOJ/5mXtH92Ffrfd8a+HZupB66Xy0jz+glzPHphjV4y3p
jtadIJx114ymO1u7rKnsmLVThIVieBJs3o3pLD7Ho8+eho4Xju104ZkTnpqx
jdEzollRb6nHutGZmXlGNCtfRO/Vk2kfi9dMan9obhXXf+le032oe7Uz6ehf
oyPlovt/ZZqp6Zll+o/QHhfO59I9oB2ivnmscN53FJ457RD18arCO3c0+k4Q
ptrP/wMvM0fn
          "]], PolygonBox[CompressedData["
1:eJwtlUtolWcQhj/NOTma/3IUFC8VMU3Uoi20WtAqFkGltiqlUjBupLiwiNa6
cKFdKDaCm0JIajR2Y1U00oU3GgW1VsViLirJ8VLaREXxWtAEW6hX0uft+y8G
5v1nvm/mm3ln/srlXy9eMzCEsBbJIcOSELryIRxAHsQhLCmG8AmGf8A16E/5
1l8WQhsyMwrhBvgp+q/Ie+ChnL+M747yEM5XhHAL+zNsZ5Ap2OvBOe47BK5D
f4LPBXy3cuYX8CNkEvaz2N/Hf34awmPstYNC6CT+c+wt+PYhbxNrPvhL7HvA
PegL8JmZs89C9Gbur0E/iM8f6J8W/ZY3kEXoI7jjKvoM7BvQO7ijPu+clFs/
+BR4doE3kUt37FgPkGrVCjmtWMTsRL+NfV/eNVQtq4eEMJ67tmH/m/eMAbdj
2wjuBt/Dvxn8FzIR/yOJG7Gf9x9Gf4nPrpxzfEz8XnBDzneWwG8hE3KukWq1
L/L7PiTf71PnqFxXIJ285yXxjqOfwz6O9x/i2zLwEc73VDgH5bIa+R08HFxC
34u9A3wldX+VQx+xGlPXRxw5qtiR36ozN7GNiPyWdmQOuJX4ddg+476x6CNT
c0ccGoW+G/8ZWf/eIfaNyLVSzHbsLZFrrZr/AB6Z3a+aHee+ysjc6lJM8Afg
1jJzagH+x/hWq34Rfxj6xqJj/8i3Tehv4n8YPBj/ufi/Cz6d5fcn/hPARzN7
CTwK3FxmTp8A74pdu2nc/wLbjti1nyI+gZtic1szsRO9mxjrC+7nHezTs3y3
wPcr5FONnC+4p+ptGz2oGuR6aNYai55H+ZfQy1LzZTJ4q+Ylca90ZjN4auRZ
FGfuEv9V4n4phx7OfpTxeSnfzuntsWfzX6QZ3I/szvj4Db6tiWdJOY7n/mWx
sThWBe7J+ifOt3H/w9i7ZRXv/Rz956yf4tBO7Jdi11Y9qMZ2nW/rCn6D3lJZ
NHcVQ7FPxuaWejBa9cb+Vd412Y6+nPNL8+bH2sg9UC80o3div0lv0474Dnwm
tu8Bzo/BNi81l5RPFXizOFHw+zRLJxPvG337Fls9Mqvg92h3bEntK5+9nD+G
DCz3zDVo/6WeFfXsFbYvEtdqE/gWuDd1rWV/DW5PPGuK0ZC6RspNd85KzCFx
STW7lnrGNGvaaRfR1yXmpjgmrtUlngXNkGZJnBOXVL8+/HsT73L18Al6U+pd
qJ6VwK8T7wZx6H8upd49ylG51qaeZb1/T2SO6n7FnwbeELnfjfisxPc3+N1U
7hoUE+9s7W7NbAv5dBX9L9DO+Dj1ztLu0k65EPsfJJv+CT8l5pi4ph17X/8O
/GvLzfEB2m0VnhX1QLvuP2eMDiY=
          "]]}]}, 
      {RGBColor[1., 0.8957064518477176, 0.6481995972144704], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlEtIVVEUhreK19s995zrxuymPfVq2RvUsnJgT0gthSbVoAZGSAQaFYiT
HqRNs4GVTRoUUYPoQUFq0CCiEourBQWhBQmZ5aOURGrQt1g7GmzWOv9Z699r
r/XvnVfXuLsh1RhzlpXGmmeNuRoyZto35pBnzAzgerDVrEn8g2CDgTHNGcZM
4d8ktgX/ObmlxNSmGBPBrmVV4udiy8PG5LG6iekiPj+sewi20eHiS5z8P8Ea
hxN6Mxoo/28+dsYUr8buZc3g78Geimn+Sew+h6eybz+5x/DHyb3LeRrhvYf9
w3cr+Bj/K8ibAO9jL09ysN8i8PHvXLoxj6N6HjnXNPgK8FvgI+CJTGMGyC/E
GmIm4Kxh/2L4rxPzkZij+AF4HXmlnuZ+Bb+GXwzeAp6kpjNSA/Y+eAV4O3gl
a0xwOBPgw/jbwSbwjxPzBr+HdQR/AKwN7l/EvKecKr7fMa/FVmcp/Q7wO33t
r4//gtzD5K7BTw90lmX4Kaz9cLVR52viT4MXgQ1G9VyfsGWe9q6f2i6yNuFf
wj4hvon4dVZ1I/qpJ/YzOTfIXc4+3yNa4xz+/yC2Jqz9rQp0Fouscre62byM
6tkKA91H/sm8Euz3lPoPRDVOuIRnCPszpLOsDhTfQA0L3RxFp/VO28VWNS3a
zsLfgp/ET+DneqqBbvj7nJaS2Ldh7dtto1oudxqWPm3O0L4fJi4bvxmOpVYx
mcmXkOJxoxwyO9m7I9DcB8Scj2r/L2CTnLGXnB2BWtGDzDLL3cdl2AVWzy/9
Ex1JHYXwD7mel3g6J+lbe+w/V1GgmmpymsmBpwH/jrsr4tMu0wlPKzyPHN+r
kN7tnEDv61xs3CqPzH9boOfMZ99mX9+GuK96F+0lnS6lJ5XuLor2ZB4rfb33
M+xVYhUXbc52d3ME7WRa5YhZ1Y7cKZlrr+uN1LbEah9EvzKffPe2SP+6XJzc
y0Z3xgKrtcn96HLnzaGQWe4dk/csarVPot9VVucnd6jH6TPPU92JZv7V2u/e
FemN9ETm3kF8PTGXo3pfh13/Re+iVZnlrpi+J7UxPaecV7QpMxly2p709P0p
4P2ZimidUu+ou19Sr8yq1/Uk5qtmn/F/a6A8cTiuuHrSiP/gqb7nw5niq44e
RlQTsnc2MX8BkujYYA==
          "]], PolygonBox[CompressedData["
1:eJwtlEtIVVEUhrfpVfHcc64HMt/F1SztCRpJEVjYAzMKmjcRKiTQICGclIFG
DSobaNmkoAgbJAYNSgODBpIkeVNICS1I6IX2pJAa9P2sM1iw/rP2Xmvtf/3r
JJtaD7csc84dwTKwqYRzXdnO1WG1nnPdcWIx5/ZlOpcZOpfynTuHX8HZNPx3
xO8Q38+3LOIrsGlip8H5+E+Inye+FxwDfwbfAzeCs8GTgXOnspz7me5cE/W2
htFdcgzmUId4d8xyLoCv0d9OekuBp8Ep8CLnX2ATCetRverOc2r54DYwqd0A
59PBx4mN8C0DfzPWHNXfhH+LHAfJ/514I7U7sWriE8TrSdIDrgO/BjeCm8AB
OI38/eRfB75L/gY+/AI/oocu8AxWDF8z4O3kT2JnE9G3mHGcRv08rIXar8i3
PDTOxJ1yPI4bx+JaNd7HjUNxqTfdAFeCOzKtv7X4BaH1ppyF+NfjdlZ3LlO7
jB6eRe/LJT5L/+3gJfBR3tdI/GuWcTjE+YAzN/HL6L+DWFVo3GmGU9wd8K1W
KzaI/9S3eX7EyslXFBo3ylGM/yXH3iqNJLm/FLdZqeYB8r+N9KV5lQbGud62
i3gf+JhnvarnOfAO8A/OzmP14N3g35Eexsh1JmHcD4kP4qvo4Rv+IXpaib8B
u+9MExvxq0PL38+ZGvwHvr1NMz9J7srAtDeOVeG/9I1/7cgE/tVofzTjNs6P
BpZ7ih7egD9F+yDNSXs9Cds9abwXvyQ0ravHUnEXvV8a7CVXRmC9dYH/eTYj
zUqavQ3eExj34kBcDEf7KI7ElXZA3IrjubjNVLMdpmaK2WzzbBf0T9C/oR2c
R+4PykfuS77pUferiV3wTa+qUeQZJ+ORXufJX+OZrzu6W5JrXIjzBDgfG8Xv
pMYCd//k2GzE0frANDAS6b2PfBd923dxfAVc6NmuqAf1shgYN5qhtFIemtbF
0Wr8itD+ZZrZmtB2Qruhels4XxCYVvSPaQjsH6D72plyceUZF9K4tK4Za9bq
YYh+kp5pTz2q13zPtKkd0a7UhjY/vXmSt/717O36ptnqn6j9OsG3MfBDz7Sv
fqW1VNz+lZpJM/FZz85KY9Laf/xzxQM=
          "]], 
         PolygonBox[{{4401, 4400, 3060, 1913, 3805}, {3796, 1907, 3056, 4394, 
          4395}, {4386, 4385, 3927, 2041, 3929}, {4370, 4369, 3166, 1987, 
          3874}, {3734, 1855, 2994, 4385, 4386}, {3427, 3426, 4132, 2269, 
          4131}, {4354, 2041, 3928, 3376, 3377}, {3918, 2032, 3917, 4369, 
          4370}, {4395, 4394, 3055, 1906, 3793}, {3792, 1906, 3794, 3426, 
          3427}, {3377, 3376, 3919, 2032, 4352}, {4133, 2269, 3059, 4400, 
          4401}}]}]}, 
      {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
       GraphicsGroupBox[{
         PolygonBox[{{3617, 1730, 2795}, {2680, 1742, 2681}, {2683, 1745, 
          2682}, {3627, 1745, 2807}, {2804, 1742, 3626}, {2678, 1734, 2679}, {
          2675, 1730, 2674}, {2797, 1734, 3621}}], PolygonBox[CompressedData["
1:eJwtlEdMUEEURUfsQ/32XkAsscXuyt7AjhW7KHZBE9xZsHfFhoq9LtWlJCZu
dWMkutWYuCPs3XpOhsXN3Pdn/pT77nvDq2oranJCCJWgE/hZEMKdGMJNMCYL
4RfxQ/gDMIn4dx5r4YtAJ+Jd+SFsh98C31nbCC7Dy0FZbggtxLfhDWAs6wOY
Dd/mfvz7lf02wleBLsyNAJfgF0EJfDS4Dt8HvrF+JPFV+BVQCm/i/7XwCtCN
eAp4BG8Ck+F/md8MXw26EvcHJ+DHQT94M/Pr4StBZ+KSohDexPQm3zaYb2fg
p8Eg+B/Wb4pJA7UoLgzhCbwG9MiSJmozH3SED2SPrfB14CPrZ/DtFfyg56FN
PvEeeDVoZm0B8QH4fvCPuIF/1sDngA7MTQT34TfAF/5fwfnPYtJUbX2jb/WO
3lWN1XoeyGGukvUv4BdAMfFQcA5eb84KkgZqsQF84v++xMfgdaBPlu7gXXyT
b1Nztd8CWvNSDs2ld/bu9Zz3MqY3+bZS9H0bk8Zq/Zk99sZ0hme1Mi4GR0Av
9QOn4CfBgCx5Qm+U+Sb8NZ34eUx7uNcHxrkxfXOuEByCHwZFWYLcnJm7SLwT
/hhMhVez5/KYPK/3y4mXwq+BUVnSUC3VUC3NobnUc3rvB+PCmHJsrseDe/C7
YBx8GDgf057u3ca4RK+BvCzlxNxYQ9ZST+Ja+DLXsL438VH4bvA+P3lcr69Q
g9z0Bt9yFgzJUk7NrR7Wy+8YZ8XkOb3XwrggphyZq2l8ewrfAbpnKQfmwjM9
Ww/rZWvG2vEO3sWasraseWvfN/pWPa23rWlrW8/qXTVRG3Nqbj3Ts+0R9gp7
kL3InmJvsYfYS+wB9gJ7gL3AHmWvUiO1Mkfmyp5h77Bn2bv0nN5TQ7VsBBOY
ywVV7Z5rbf/mnDVmrc0Er2PyhN6wJq1NPak39aBe1GN6zR5gL7AmrU17gL3A
HmWvsobq2nPe1p4zc+cZnmXOzJ01aW3+B5oym0o=
          "]], 
         PolygonBox[{{2807, 1745, 2683, 2657, 4362}, {3306, 2652, 2682, 1745, 
          3627}, {3621, 1734, 2678, 2648, 3273}, {3260, 2647, 2674, 1730, 
          3617}, {2795, 1730, 2675, 2658, 4363}, {4364, 2659, 2679, 1734, 
          2797}, {3626, 1742, 2680, 2651, 3299}, {4361, 2656, 2681, 1742, 
          2804}}]}]}}, {{}, 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2734, 4365, 3513, 4388, 4387, 2882, 4367, 4368, 3874, 4370, 
          3918, 4352, 3377, 4354, 3929, 4386, 3734, 2889, 4384, 2890, 4391, 
          4392, 3534, 4390, 4389}], 
         LineBox[{2736, 4406, 3519, 4375, 4374, 2796, 4364, 2797, 3621, 3273, 
          4358, 3216, 4353, 3355, 3256, 3257, 4357, 3260, 3617, 2795, 4363, 
          2794, 4372, 4373, 3503, 4377, 4376}], 
         LineBox[{2769, 3968, 4366, 3575, 4379, 4378, 4405, 4361, 2804, 3626, 
          3299, 4359, 3296, 3294, 4356, 4355, 3226, 4360, 3306, 3627, 2807, 
          4362, 4404, 4382, 4383, 3658, 4381, 4380}], 
         LineBox[{2771, 4407, 3589, 4403, 4402, 2919, 4408, 2917, 3805, 4401, 
          4133, 4131, 3427, 3792, 3793, 4395, 3796, 4393, 4371, 2915, 4398, 
          4399, 3784, 4397, 4396}]},
        "8000"],
       Annotation[#, 8000, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2728, 3682, 2928, 3505, 3504, 3502, 2839, 3651, 2876, 3259, 
          2842, 3464, 2841, 3258, 2932, 3217, 3215, 3465, 2849, 3274, 2884, 
          3653, 2851, 3520, 2850, 3652, 2937, 3689, 3281}], 
         LineBox[{2741, 3329, 3537, 3536, 3535, 2996, 3737, 2891, 3733, 2994, 
          4385, 3927, 3928, 3376, 3919, 3917, 4369, 3166, 3875, 2883, 3716, 
          2979, 3514, 3915, 3916, 3321, 3372}], 
         LineBox[{2757, 3343, 4124, 3035, 3783, 3037, 3786, 2914, 3795, 3056, 
          4394, 3055, 3794, 3426, 4132, 3059, 4400, 3060, 3806, 2918, 3822, 
          3068, 3588, 3067, 3821, 3351, 3449}], 
         LineBox[{2776, 3991, 3990, 3989, 4050, 2871, 4052, 2873, 3659, 4000, 
          3305, 2868, 3470, 3224, 3225, 3613, 3295, 2866, 3469, 2867, 3300, 
          3625, 3624, 3656, 4048, 4049, 3657, 3608, 3609, 3966, 3967, 3289}]},
        "7000"],
       Annotation[#, 7000, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2843, 3354, 2844, 3264, 3618, 3255, 2840, 3471, 3092, 3254, 
          3253, 2777, 2727, 3212, 2983, 3262, 3261, 2798, 3275, 3276, 3102, 
          3272, 3271, 2780, 2735, 3218, 2998, 3389, 2852, 3277, 3622, 3282, 
          2854, 3357, 3221}], 
         LineBox[{2874, 3366, 2875, 3314, 2927, 3312, 4051, 2872, 3444, 3066, 
          3231, 2775, 3367, 3301, 3302, 3156, 3304, 3303, 3348, 3297, 3298, 
          3054, 3223, 2768, 3364, 3291, 3292, 3144, 3498, 2865, 3293, 2913, 
          3290, 2864, 3362, 3222}], 
         LineBox[{3009, 3237, 3010, 3399, 2892, 3738, 2997, 3538, 3736, 3735, 
          3327, 3729, 3730, 3530, 3732, 3731, 2981, 3876, 3877, 3528, 3873, 
          3872, 3323, 3713, 3714, 3515, 2978, 3715, 2880, 3373, 2977, 3319, 
          3512}], LineBox[{3038, 3341, 3039, 3424, 2909, 3785, 3036, 3566, 
          3567, 2756, 3345, 2761, 3969, 3577, 3798, 3797, 3042, 3803, 3804, 
          3580, 3581, 2763, 3349, 2770, 3975, 3587, 3069, 3823, 2921, 3450, 
          3071, 3242, 3592}]},
        "6000"],
       Annotation[#, 6000, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2733, 3318, 3320, 3369, 3368, 2881, 3868, 3869, 3516, 3517, 
          3518, 3374, 3926, 3925, 3529, 2992, 3728, 2982, 3882, 3170, 3531, 
          3532, 3533, 3385, 3933, 3932, 3539, 3756, 3755, 2893, 3400, 3401, 
          3238, 2783, 3398}], 
         LineBox[{2740, 4079, 4080, 3690, 2938, 3279, 3278, 3328, 3848, 3112, 
          3847, 3113, 3388, 3387, 4111, 2999, 3739, 3000, 3740, 2939, 3845, 
          3103, 3630, 4007, 4008, 3477, 3633, 3632, 3631, 3104, 3846, 2885, 
          3844, 3101, 3629, 4005, 4006, 3379, 4109, 2984, 3717, 2985, 3718, 
          2933, 3840, 3093, 3628, 4001, 4002, 3472, 3473, 3095, 3841, 3094, 
          4155, 3315, 3266, 3267, 2929, 3683, 3685, 3684, 3263}], 
         LineBox[{2760, 4093, 4094, 3700, 2954, 3288, 3287, 2803, 3858, 3146, 
          3857, 3147, 3497, 3496, 3641, 3640, 3639, 3208, 3911, 3239, 3901, 
          3194, 3899, 3193, 3900, 3440, 3644, 3643, 3642, 3149, 3859, 3252, 
          3861, 3157, 3650, 4045, 4046, 3499, 3649, 3648, 3647, 3211, 3912, 
          3240, 3904, 3197, 3902, 3196, 3903, 3445, 3446, 3163, 3864, 3162, 
          4257, 2806, 3309, 3310, 2959, 3703, 3705, 3704, 3313}], 
         LineBox[{2772, 2792, 3241, 3448, 3447, 2920, 3810, 3811, 3586, 3062, 
          3807, 3429, 3799, 3057, 3579, 3058, 3800, 3041, 3895, 3187, 3576, 
          3186, 3892, 3418, 3778, 3034, 3565, 3780, 3779, 2908, 3415, 3416, 
          3340, 3339, 3423}]},
        "5000"],
       Annotation[#, 5000, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2855, 3692, 2942, 3623, 3995, 3280, 2853, 3404, 3219, 3220, 
          3233, 3234, 3199, 3905, 3200, 3906, 3111, 4184, 3114, 4181, 4183, 
          4182, 2800, 4173, 4174, 4172, 4176, 4175, 2986, 4262, 4263, 3920, 
          3921, 2737, 2781, 4307, 4308, 4306, 4310, 4309, 3100, 4170, 4171, 
          4167, 4169, 4168, 2799, 4157, 4158, 4156, 3096, 4159, 2969, 3913, 
          4347, 3165, 4259, 3914, 3507, 3506, 4350, 4351, 3265, 4349, 2845, 
          3474, 2846, 3268, 3620, 3619, 2930, 3686, 3213}], 
         LineBox[{2861, 3673, 2907, 3672, 2906, 3286, 2863, 3494, 2862, 3285, 
          2953, 3361, 3965, 3790, 3053, 3791, 3052, 4230, 3145, 4227, 4229, 
          4228, 3344, 4237, 4238, 4236, 4240, 4239, 3148, 4234, 4235, 4231, 
          4233, 4232, 3363, 2767, 3974, 3973, 4138, 4137, 3065, 4251, 4252, 
          4248, 4250, 4249, 3347, 4254, 4255, 4253, 3161, 4256, 3158, 3863, 
          3160, 3862, 3159, 3365, 2958, 3229, 3228, 3441, 2870, 3308, 2925, 
          3680, 2926, 3681, 3230}], 
         LineBox[{2973, 3317, 2878, 3712, 2975, 3508, 2974, 3711, 3322, 4260, 
          4261, 3867, 3871, 3870, 2980, 3726, 3727, 3723, 3725, 3724, 3378, 
          4270, 4271, 3881, 3884, 3883, 2995, 3753, 3754, 3750, 3752, 3751, 
          3330, 3757, 3011, 3542, 3012, 3758, 2895, 4341, 3332, 3546}], 
         LineBox[{3072, 3352, 2923, 3824, 3070, 3591, 3976, 3977, 3350, 2764, 
          3585, 3584, 3809, 3808, 3044, 3801, 3802, 3578, 3970, 2762, 3425, 
          2758, 3570, 3569, 3894, 3893, 3029, 3781, 3782, 3564, 3955, 2755, 
          3342, 3555, 3554, 3553, 3026, 3774, 2904, 3338, 3556}]},
        "4000"],
       Annotation[#, 4000, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2732, 3661, 3662, 3598, 2879, 3865, 3866, 3509, 3510, 3511, 
          3370, 3371, 2991, 3524, 2990, 3722, 3375, 4269, 3168, 3879, 3169, 
          3880, 2993, 3749, 3007, 3747, 3006, 3748, 3386, 3886, 3175, 3540, 
          3176, 3397, 3396, 3940, 3939, 3543, 3761, 3760, 2896, 3600, 3764, 
          3983, 2785, 3982}], LineBox[CompressedData["
1:eJwVzjsvw2EUx/HDpFrqMtXW2WKwu05MLE1XC4t261JRCe+ASAwSCYNeJKXV
d9DX4PIOXBYWJEI//+Gb7/Oc8zsnJ79V3iwNRUQBvdGIuYmIdCbiazwiwwdj
ETWcYzUbcai2wke8rraGfjpi0tw0plDz3zVfRgn/9i7I3erdoY0uOri054mf
k569HfzJn8n3vO/RxaxcUabJG5znpnoLN5iXr6s3cI1WksWF3AM/oi7XwLf9
p/I/vO2+X70dftd7Q8X9L/yKJb3F5E7vKxybO8GMvcP+OV7W31erYg8ptQ/7
RviT+zwAoQo2PA==
          "]], LineBox[CompressedData["
1:eJwN0D0vQ2EYBuCna9FzQm2G1oAfwCIhYai9EgtDY6cJo6BFsJjtQvwMVFr6
wT/wNRskEgkLruHKfZ77fd5zmhZXq+X1TEQs0chGTKcRSX/ETy4ilQcDEft8
OkuTiDldIuflhf6cG/M1V7y5/0rJ8xMvPDPlfZMkfRFn7uTkrb7Bjv1tjnVF
OUqBd3PV7p2dFk1KvrvrrOJsTy6YO/ouPS7t5521Pd9Tt1PjRDcuJxjj27xm
d1jO+F2zrLDMCA92Humy5Rs9uWF/k0Vz3rvL8lT/5b851B8xpPt1f1D+yQ/5
D06FMiI=
          "]], 
         LineBox[{2773, 2793, 3616, 3614, 2922, 3818, 3819, 3590, 3063, 3817, 
          3431, 3432, 3061, 3583, 3971, 3972, 3428, 3574, 3573, 3572, 3188, 
          3896, 3031, 3787, 3040, 3568, 3956, 3957, 3417, 3560, 3559, 3558, 
          3184, 3411, 3410, 3771, 3025, 3552, 3773, 3772, 2903, 3606, 3671, 
          3670, 3775}]},
        "3000"],
       Annotation[#, 3000, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwV0LsuRFEUh/E1zjTOXHgAkRgUCoOGTlTKKc50RqWVuPQmoUW0LqHTGY0E
ZzwAD0FNlGIoUPhN8eVbe+3/WvvkjK1tZhuFiFjFVClifjhiAedDERfYq0QU
yxGHXOEOX+MA+8jTiFFOZUsYxIxcmevcsmuOV3iWE9mGd6bV73pF9aLeI/ec
n3gXW1Vv8zY/2DWgXpK7k7nHLbrIcWnXM7/072RzhPyZfIG7zuv2tNUf6h2e
MPMq/+P7j+V++c15Un/Z/R/XkOmNc5Ov9Kvc4cyeJm7MjZhP1D1vfOETqZlv
Trjt/tT9Sf/fmK/jSP8f7uIw4g==
          "]], LineBox[CompressedData["
1:eJwVzz8ohHEcx/GvAXV3z+PfYEJmZ6FEDJab/dkoKaM7d6sig5LYWUzX7RQz
lps5u4mkRIni8qe8DO/ez+fz+/6+v57Blcp8uSUilpDPRjQ6I25wja1cxHYS
0crNNCLlcf0E0o6IBEXfD5mISxTlVVTM1fUN+9Z4Si7xJJ/gGNN40WXNVL2R
4Wd5V1+w4xYLujfdiLdHkcg1szm+cH6OTecb//d0/TyAPjzJJbPdXDc35v67
flle9N2LT7mJD6x7t2y+x/mrXJBPcYZZHOjm+JBn+J73+Y73+NH/X+Hb3h98
oUv/y228Y3c7D5kfRh5H8h914TT0
          "]], 
         LineBox[{2972, 3660, 2877, 3597, 3599, 2779, 2731, 3326, 2739, 3924, 
          3521, 3720, 3719, 2976, 3878, 3167, 3525, 3526, 3527, 3381, 3382, 
          3004, 3745, 3003, 3746, 3384, 4286, 3173, 3885, 3174, 3394, 3393, 
          3938, 3937, 3541, 3016, 3759, 3008, 3762, 3763, 3544, 3545, 2743, 
          3334, 2745, 3663, 3664, 3601, 2899, 3665, 3942}], 
         LineBox[{3074, 3679, 2924, 3615, 3678, 3677, 3820, 3346, 3813, 3814, 
          3812, 3816, 3815, 3046, 3898, 3191, 3582, 3190, 3897, 3421, 3422, 
          3043, 3571, 3958, 3959, 3419, 3563, 3562, 3561, 3185, 3414, 3413, 
          3776, 3027, 3557, 3028, 3777, 3023, 3890, 3891, 3889, 4290, 4289, 
          3337, 3770, 2788, 3985, 3769, 3605, 2900, 3666, 3943}]},
        "2000"],
       Annotation[#, 2000, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["
1:eJwVzTcvBlAYhuGXD4MeJhMWMVi032AiiEkvk4XBQGzqRKINgjAzKKPyHww2
okSiREKil5C4vuHOfd7nPO85pb2DzQMpETGIrcyI27yIoayIG77HHUrMx1zM
P/kRM86zONXfxJPzsLtHHuFUnXlO4Tn+y46o4xZzmfOu3h7+7C7nRPzytnkH
r3jBCip07+0k7K7qrWFcdi4b4wt7bXqtOJD1yfJ5X7+Ga1GJalThWb+DO9GO
bnQl7+xd8nTyTZ7iK91u73ahE/2yBv/XI937D8l3ZRvu1vGBdxTJG3UydI7M
h6jR65E3ydLdLXKaeSk58wS/6Y1zwrzA1/4fzY0oRAHO7JXLv/V+8IlJ8xef
eP8fuXNC2g==
          "]], 
         LineBox[{2746, 4195, 3125, 4194, 4197, 4196, 3020, 3768, 3019, 4122, 
          3335, 3767, 2787, 4345, 3766, 3604, 2898, 3765, 3018, 3548, 3941, 
          3407, 3017, 4288, 3179, 4287, 3178, 3395, 4117, 4118, 4116, 4120, 
          4119, 3005, 4284, 4285, 4283, 3172, 3383, 3742, 3743, 3741, 3002, 
          3744, 2838, 4337, 3164, 3523, 3522, 2989, 3721, 2888, 4053, 4054, 
          3710, 3709, 4108, 3316, 3708, 2970, 3707, 2971, 4165, 4166, 4163, 
          3099, 4164, 3270}], 
         LineBox[{2747, 3126, 4198, 4200, 4199, 3021, 3549, 3550, 3551, 3336, 
          2748, 3668, 3669, 3667, 2901, 3888, 3181, 3887, 3180, 3409, 3022, 
          4291, 3182, 3944, 3945, 2749, 3412, 2752, 3949, 3948, 4294, 4293, 
          3030, 4295, 4296, 3950, 3951, 2753, 3420, 2759, 3961, 3960, 3189, 
          4297, 3045, 3430, 3047, 3788, 3048, 3789, 2916, 3610, 3611, 2790, 
          2765, 3353, 3979, 3978, 3593, 3073, 4243, 4244, 4241, 3150, 4242, 
          3307}], LineBox[CompressedData["
1:eJwV0TkvhFEYhuFXYzbLqBVoqcWSoCD0CqVCxyRjzBh7S0Mh9gpRk/AH/AC1
MENjLUTCDyDhmuLOfc5znvd8yfk6pmbH83URkcNdOmKvOWIXO3jDK7ozEemm
iAwasIAy0lkZAps6f7pbnLI/4iQf8lVDxCVG8C1rkeUaI26sn8284AmT8mGd
L3nWelpnBh/WK85XsYZ22bzOoG6Jh7jMA7zMK1jAEhZxhlkUkEcRc6i4t5Wr
XHDvHIpoq31X3uu+ae7jU9kJUrr99hNc1X3EAxL2x86T/GmmR+ccF9iX1csO
OMEb/GNmnX/52rsXvWcJY+iUj3IX3zuvYLv2P8y+49ad/0U5Ozc=
          "]]},
        "1000"],
       Annotation[#, 1000, "Tooltip"]& ], {}, {}}}], {{}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.04587368524026638, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-9.285714285714285, -9.285714285714285}, \
{-10.714285714285715`, -10.714285714285715`}}]}}, 
     {Arrowheads[{{0.03661957214128819, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-9.475218658892128, -7.959183673469387}, \
{-10.524781341107872`, -9.183673469387756}}]}}, 
     {Arrowheads[{{0.028473340174100664`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-9.635568513119534, -6.632653061224489}, \
{-10.364431486880466`, -7.653061224489796}}]}}, 
     {Arrowheads[{{0.02134859125293253, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-9.7667638483965, -5.3061224489795915`}, \
{-10.233236151603498`, -6.122448979591836}}]}}, 
     {Arrowheads[{{0.015124736040578445`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-9.868804664723033, -3.9795918367346927`}, \
{-10.131195335276969`, -4.591836734693877}}]}}, 
     {Arrowheads[{{0.00963874482526197, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-9.941690962099125, -2.653061224489795}, \
{-10.058309037900875`, -3.0612244897959173`}}]}}, 
     {Arrowheads[{{0.004680988289823086, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-9.98542274052478, -1.3265306122448968`}, \
{-10.014577259475217`, -1.5306122448979578`}}]}}, 
     {Arrowheads[{{0.004680988289823097, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-9.98542274052478, 
        1.3265306122448992`}, {-10.014577259475217`, 1.5306122448979607`}}]}}, 
     {Arrowheads[{{0.009638744825261978, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-9.941690962099125, 
        2.653061224489797}, {-10.058309037900875`, 3.06122448979592}}]}}, 
     {Arrowheads[{{0.015124736040578424`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-9.868804664723031, 
        3.9795918367346954`}, {-10.131195335276967`, 4.591836734693879}}]}}, 
     {Arrowheads[{{0.02134859125293253, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-9.7667638483965, 5.306122448979593}, {-10.233236151603498`,
         6.122448979591838}}]}}, 
     {Arrowheads[{{0.028473340174100647`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-9.635568513119534, 
        6.632653061224492}, {-10.364431486880466`, 7.6530612244897975`}}]}}, 
     {Arrowheads[{{0.03661957214128819, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-9.475218658892128, 
        7.959183673469389}, {-10.524781341107872`, 9.183673469387758}}]}}, 
     {Arrowheads[{{0.03661957214128819, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-7.959183673469387, -9.475218658892128}, \
{-9.183673469387756, -10.524781341107872`}}]}}, 
     {Arrowheads[{{0.02888838487433681, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.12161599333611, -8.12161599333611}, {-9.021241149521034, \
-9.021241149521034}}]}}, 
     {Arrowheads[{{0.022158516676423726`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.259058725531029, -6.768013327780091}, \
{-8.883798417326114, -7.517700957934193}}]}}, 
     {Arrowheads[{{0.016366937576713543`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.371511870054144, -5.414410662224073}, \
{-8.771345272802998, -6.014160766347355}}]}}, 
     {Arrowheads[{{0.011419136765807681`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.458975426905456, -4.060807996668054}, \
{-8.683881715951687, -4.510620574760516}}]}}, 
     {Arrowheads[{{0.007177376926577087, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.521449396084964, -2.7072053311120357`}, \
{-8.621407746772178, -3.0070803831736765`}}]}}, 
     {Arrowheads[{{0.003451490043452218, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.558933777592669, -1.3536026655560172`}, \
{-8.583923365264473, -1.5035401915868376`}}]}}, 
     {Arrowheads[{{0.0034514900434522225`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.558933777592669, 
        1.3536026655560196`}, {-8.583923365264473, 1.5035401915868403`}}]}}, 
     {Arrowheads[{{0.007177376926577087, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.521449396084964, 2.707205331112038}, {-8.621407746772178,
         3.0070803831736788`}}]}}, 
     {Arrowheads[{{0.011419136765807662`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.458975426905456, 4.060807996668057}, {-8.683881715951687,
         4.510620574760518}}]}}, 
     {Arrowheads[{{0.016366937576713567`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.371511870054144, 5.414410662224075}, {-8.771345272803, 
        6.014160766347357}}]}}, 
     {Arrowheads[{{0.022158516676423743`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.259058725531029, 6.768013327780094}, {-8.883798417326114,
         7.5177009579341965`}}]}}, 
     {Arrowheads[{{0.028888384874336835`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-8.121615993336109, 8.12161599333611}, {-9.021241149521032, 
        9.021241149521035}}]}}, 
     {Arrowheads[{{0.028473340174100664`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-6.632653061224489, -9.635568513119534}, \
{-7.653061224489796, -10.364431486880466`}}]}}, 
     {Arrowheads[{{0.022158516676423726`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-6.768013327780091, -8.259058725531029}, \
{-7.517700957934193, -8.883798417326114}}]}}, 
     {Arrowheads[{{0.016717815320796758`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-6.8825489379425235`, -6.8825489379425235`}, \
{-7.403165347771761, -7.403165347771761}}]}}, 
     {Arrowheads[{{0.012110900511845513`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-6.976259891711786, -5.5060391503540185`}, \
{-7.309454394002498, -5.922532278217409}}]}}, 
     {Arrowheads[{{0.008271518207665708, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-7.04914618908788, -4.129529362765513}, \
{-7.236568096626406, -4.441899208663056}}]}}, 
     {Arrowheads[{{0.005092763532356943, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-7.101207830070804, -2.7530195751770083`}, \
{-7.184506455643482, -2.9612661391087034`}}]}}, 
     {Arrowheads[{{0.0024110776141148056`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-7.132444814660557, -1.3765097875885035`}, \
{-7.153269471053727, -1.480633069554351}}]}}, 
     {Arrowheads[{{0.002411077614114811, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-7.132444814660557, 
        1.3765097875885062`}, {-7.153269471053727, 1.480633069554354}}]}}, 
     {Arrowheads[{{0.005092763532356943, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-7.101207830070804, 2.753019575177011}, {-7.184506455643482,
         2.961266139108706}}]}}, 
     {Arrowheads[{{0.008271518207665708, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-7.049146189087879, 4.129529362765516}, {-7.236568096626405,
         4.441899208663059}}]}}, 
     {Arrowheads[{{0.012110900511845525`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-6.976259891711786, 5.506039150354021}, {-7.309454394002499,
         5.922532278217411}}]}}, 
     {Arrowheads[{{0.016717815320796768`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-6.8825489379425235`, 
        6.882548937942526}, {-7.403165347771762, 7.403165347771764}}]}}, 
     {Arrowheads[{{0.022158516676423743`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-6.768013327780091, 8.25905872553103}, {-7.517700957934194, 
        8.883798417326116}}]}}, 
     {Arrowheads[{{0.02134859125293253, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-5.3061224489795915`, -9.7667638483965}, \
{-6.122448979591836, -10.233236151603498`}}]}}, 
     {Arrowheads[{{0.016366937576713543`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-5.414410662224073, -8.371511870054144}, \
{-6.014160766347355, -8.771345272802998}}]}}, 
     {Arrowheads[{{0.012110900511845513`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-5.5060391503540185`, -6.976259891711786}, \
{-5.922532278217409, -7.309454394002498}}]}}, 
     {Arrowheads[{{0.008559521444247946, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-5.581007913369429, -5.581007913369429}, \
{-5.8475635152019985`, -5.8475635152019985`}}]}}, 
     {Arrowheads[{{0.005674214678380669, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-5.639316951270303, -4.185755935027071}, \
{-5.789254477301124, -4.385672636401498}}]}}, 
     {Arrowheads[{{0.0033834479306096782`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-5.680966264056642, -2.7905039566847134`}, \
{-5.747605164514784, -2.9237817576009983`}}]}}, 
     {Arrowheads[{{0.0015596924307595727`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-5.705955851728445, -1.395251978342356}, \
{-5.722615576842981, -1.4618908788004983`}}]}}, 
     {Arrowheads[{{0.0015596924307595776`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-5.705955851728445, 
        1.3952519783423587`}, {-5.722615576842981, 1.4618908788005012`}}]}}, 
     {Arrowheads[{{0.003383447930609687, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-5.680966264056642, 2.790503956684716}, {-5.747605164514785,
         2.923781757601001}}]}}, 
     {Arrowheads[{{0.005674214678380669, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-5.639316951270303, 4.185755935027074}, {-5.789254477301124,
         4.385672636401501}}]}}, 
     {Arrowheads[{{0.008559521444247946, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-5.581007913369429, 
        5.581007913369431}, {-5.8475635152019985`, 5.847563515202001}}]}}, 
     {Arrowheads[{{0.012110900511845513`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-5.5060391503540185`, 
        6.976259891711789}, {-5.922532278217409, 7.3094543940025005`}}]}}, 
     {Arrowheads[{{0.016366937576713543`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-5.414410662224072, 8.371511870054146}, {-6.014160766347354,
         8.771345272803}}]}}, 
     {Arrowheads[{{0.015124736040578445`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-3.9795918367346927`, -9.868804664723033}, \
{-4.591836734693877, -10.131195335276969`}}]}}, 
     {Arrowheads[{{0.011419136765807681`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-4.060807996668054, -8.458975426905456}, \
{-4.510620574760516, -8.683881715951687}}]}}, 
     {Arrowheads[{{0.008271518207665708, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-4.129529362765513, -7.04914618908788}, \
{-4.441899208663056, -7.236568096626406}}]}}, 
     {Arrowheads[{{0.005674214678380669, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-4.185755935027071, -5.639316951270303}, \
{-4.385672636401498, -5.789254477301124}}]}}, 
     {Arrowheads[{{0.0036110481092921083`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-4.229487713452727, -4.229487713452727}, \
{-4.3419408579758425`, -4.3419408579758425`}}]}}, 
     {Arrowheads[{{0.0020458671970891907`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-4.260724698042481, -2.819658475635151}, \
{-4.310703873386088, -2.894627238650561}}]}}, 
     {Arrowheads[{{0.0008971721158221315, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-4.279466888796334, -1.4098292378175747`}, \
{-4.291961682632235, -1.4473136193252798`}}]}}, 
     {Arrowheads[{{0.0008971721158221379, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-4.279466888796334, 
        1.4098292378175774`}, {-4.291961682632236, 1.4473136193252825`}}]}}, 
     {Arrowheads[{{0.0020458671970891907`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-4.260724698042481, 
        2.8196584756351535`}, {-4.310703873386088, 2.8946272386505636`}}]}}, 
     {Arrowheads[{{0.0036110481092921083`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-4.229487713452727, 
        4.22948771345273}, {-4.3419408579758425`, 4.341940857975845}}]}}, 
     {Arrowheads[{{0.005674214678380685, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-4.185755935027071, 5.639316951270306}, {-4.385672636401499,
         5.789254477301126}}]}}, 
     {Arrowheads[{{0.008271518207665708, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-4.129529362765513, 7.049146189087883}, {-4.441899208663056,
         7.236568096626408}}]}}, 
     {Arrowheads[{{0.011419136765807681`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-4.060807996668054, 8.458975426905457}, {-4.510620574760516,
         8.683881715951689}}]}}, 
     {Arrowheads[{{0.00963874482526197, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.653061224489795, -9.941690962099125}, \
{-3.0612244897959173`, -10.058309037900875`}}]}}, 
     {Arrowheads[{{0.007177376926577087, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.7072053311120357`, -8.521449396084964}, \
{-3.0070803831736765`, -8.621407746772178}}]}}, 
     {Arrowheads[{{0.005092763532356943, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.7530195751770083`, -7.101207830070804}, \
{-2.9612661391087034`, -7.184506455643482}}]}}, 
     {Arrowheads[{{0.0033834479306096782`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.7905039566847134`, -5.680966264056642}, \
{-2.9237817576009983`, -5.747605164514784}}]}}, 
     {Arrowheads[{{0.0020458671970891907`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.819658475635151, -4.260724698042481}, \
{-2.894627238650561, -4.310703873386088}}]}}, 
     {Arrowheads[{{0.0010699401805309861`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.84048313202832, -2.84048313202832}, {-2.873802582257391, \
-2.873802582257391}}]}}, 
     {Arrowheads[{{0.0004229309913262064, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.852977925864222, -1.4202415660141594`}, \
{-2.8613077884214895`, -1.436901291128695}}]}}, 
     {Arrowheads[{{0.0004229309913262064, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.852977925864222, 
        1.420241566014162}, {-2.8613077884214895`, 1.4369012911286976`}}]}}, 
     {Arrowheads[{{0.0010699401805309933`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.84048313202832, 
        2.840483132028323}, {-2.8738025822573916`, 2.873802582257394}}]}}, 
     {Arrowheads[{{0.0020458671970891907`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.819658475635151, 4.260724698042484}, {-2.894627238650561,
         4.310703873386091}}]}}, 
     {Arrowheads[{{0.0033834479306096782`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.7905039566847134`, 
        5.680966264056645}, {-2.9237817576009983`, 5.747605164514787}}]}}, 
     {Arrowheads[{{0.005092763532356943, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.7530195751770083`, 
        7.101207830070806}, {-2.9612661391087034`, 7.184506455643485}}]}}, 
     {Arrowheads[{{0.007177376926577078, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-2.7072053311120357`, 
        8.521449396084966}, {-3.007080383173676, 8.62140774677218}}]}}, 
     {Arrowheads[{{0.004680988289823086, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.3265306122448968`, -9.98542274052478}, \
{-1.5306122448979578`, -10.014577259475217`}}]}}, 
     {Arrowheads[{{0.003451490043452218, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.3536026655560172`, -8.558933777592669}, \
{-1.5035401915868376`, -8.583923365264473}}]}}, 
     {Arrowheads[{{0.0024110776141148056`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.3765097875885035`, -7.132444814660557}, \
{-1.480633069554351, -7.153269471053727}}]}}, 
     {Arrowheads[{{0.0015596924307595776`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.395251978342356, -5.705955851728445}, \
{-1.4618908788004985`, -5.722615576842981}}]}}, 
     {Arrowheads[{{0.0008971721158221379, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.4098292378175747`, -4.279466888796334}, \
{-1.4473136193252798`, -4.291961682632236}}]}}, 
     {Arrowheads[{{0.0004229309913262064, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.4202415660141594`, -2.852977925864222}, \
{-1.436901291128695, -2.8613077884214895`}}]}}, 
     {Arrowheads[{{0.00013374252256637148`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.4264889629321102`, -1.4264889629321102`}, \
{-1.430653894210744, -1.430653894210744}}]}}, 
     {Arrowheads[{{0.00013374252256637148`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.4264889629321102`, 
        1.426488962932113}, {-1.430653894210744, 1.4306538942107467`}}]}}, 
     {Arrowheads[{{0.0004229309913262064, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.4202415660141594`, 
        2.8529779258642245`}, {-1.436901291128695, 2.861307788421492}}]}}, 
     {Arrowheads[{{0.0008971721158221379, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.4098292378175747`, 
        4.279466888796336}, {-1.4473136193252798`, 4.291961682632238}}]}}, 
     {Arrowheads[{{0.0015596924307595776`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.395251978342356, 
        5.705955851728448}, {-1.4618908788004985`, 5.722615576842983}}]}}, 
     {Arrowheads[{{0.0024110776141148056`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.3765097875885035`, 
        7.13244481466056}, {-1.480633069554351, 7.153269471053729}}]}}, 
     {Arrowheads[{{0.003451490043452218, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{-1.3536026655560172`, 
        8.55893377759267}, {-1.5035401915868376`, 8.583923365264475}}]}}, 
     {Arrowheads[{{0.004680988289823097, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.3265306122448992`, -9.98542274052478}, {
        1.5306122448979607`, -10.014577259475217`}}]}}, 
     {Arrowheads[{{0.0034514900434522225`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.3536026655560196`, -8.558933777592669}, {
        1.5035401915868403`, -8.583923365264473}}]}}, 
     {Arrowheads[{{0.002411077614114811, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.3765097875885062`, -7.132444814660557}, {
        1.480633069554354, -7.153269471053727}}]}}, 
     {Arrowheads[{{0.0015596924307595776`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.3952519783423587`, -5.705955851728445}, {
        1.4618908788005012`, -5.722615576842981}}]}}, 
     {Arrowheads[{{0.0008971721158221379, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.4098292378175774`, -4.279466888796334}, {
        1.4473136193252825`, -4.291961682632236}}]}}, 
     {Arrowheads[{{0.0004229309913262064, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.420241566014162, -2.852977925864222}, {
        1.4369012911286976`, -2.8613077884214895`}}]}}, 
     {Arrowheads[{{0.00013374252256637148`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.426488962932113, -1.4264889629321102`}, {
        1.4306538942107467`, -1.430653894210744}}]}}, 
     {Arrowheads[{{0.00013374252256637148`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.426488962932113, 1.426488962932113}, {1.4306538942107467`,
         1.4306538942107467`}}]}}, 
     {Arrowheads[{{0.00042293099132621086`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.420241566014162, 2.8529779258642245`}, {
        1.4369012911286978`, 2.861307788421492}}]}}, 
     {Arrowheads[{{0.0008971721158221428, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.4098292378175774`, 4.279466888796336}, {
        1.4473136193252827`, 4.291961682632238}}]}}, 
     {Arrowheads[{{0.0015596924307595776`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.3952519783423587`, 5.705955851728448}, {
        1.4618908788005012`, 5.722615576842983}}]}}, 
     {Arrowheads[{{0.0024110776141148156`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.376509787588506, 7.13244481466056}, {1.480633069554354, 
        7.153269471053729}}]}}, 
     {Arrowheads[{{0.0034514900434522225`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.3536026655560196`, 8.55893377759267}, {
        1.5035401915868403`, 8.583923365264475}}]}}, 
     {Arrowheads[{{0.009638744825261978, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.653061224489797, -9.941690962099125}, {
        3.06122448979592, -10.058309037900875`}}]}}, 
     {Arrowheads[{{0.007177376926577096, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.707205331112038, -8.521449396084964}, {3.007080383173679, 
        -8.621407746772178}}]}}, 
     {Arrowheads[{{0.005092763532356943, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.753019575177011, -7.101207830070804}, {
        2.961266139108706, -7.184506455643482}}]}}, 
     {Arrowheads[{{0.003383447930609687, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.790503956684716, -5.680966264056642}, {
        2.923781757601001, -5.747605164514785}}]}}, 
     {Arrowheads[{{0.0020458671970891907`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.8196584756351535`, -4.260724698042481}, {
        2.8946272386505636`, -4.310703873386088}}]}}, 
     {Arrowheads[{{0.0010699401805309933`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.840483132028323, -2.84048313202832}, {
        2.873802582257394, -2.8738025822573916`}}]}}, 
     {Arrowheads[{{0.0004229309913262064, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.8529779258642245`, -1.4202415660141594`}, {
        2.861307788421492, -1.436901291128695}}]}}, 
     {Arrowheads[{{0.00042293099132621086`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.8529779258642245`, 1.420241566014162}, {2.861307788421492,
         1.4369012911286978`}}]}}, 
     {Arrowheads[{{0.0010699401805310002`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.840483132028323, 2.840483132028323}, {2.8738025822573943`,
         2.8738025822573943`}}]}}, 
     {Arrowheads[{{0.0020458671970891994`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.8196584756351535`, 4.260724698042484}, {2.894627238650564,
         4.310703873386091}}]}}, 
     {Arrowheads[{{0.003383447930609687, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.790503956684716, 5.680966264056645}, {2.923781757601001, 
        5.747605164514788}}]}}, 
     {Arrowheads[{{0.005092763532356952, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.753019575177011, 7.101207830070806}, {2.9612661391087065`,
         7.184506455643485}}]}}, 
     {Arrowheads[{{0.007177376926577096, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{2.707205331112038, 8.521449396084966}, {3.007080383173679, 
        8.62140774677218}}]}}, 
     {Arrowheads[{{0.015124736040578424`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{3.9795918367346954`, -9.868804664723031}, {
        4.591836734693879, -10.131195335276967`}}]}}, 
     {Arrowheads[{{0.011419136765807662`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{4.060807996668057, -8.458975426905456}, {
        4.510620574760518, -8.683881715951687}}]}}, 
     {Arrowheads[{{0.008271518207665708, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{4.129529362765516, -7.049146189087879}, {
        4.441899208663059, -7.236568096626405}}]}}, 
     {Arrowheads[{{0.005674214678380669, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{4.185755935027074, -5.639316951270303}, {
        4.385672636401501, -5.789254477301124}}]}}, 
     {Arrowheads[{{0.0036110481092921083`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{4.22948771345273, -4.229487713452727}, {
        4.341940857975845, -4.3419408579758425`}}]}}, 
     {Arrowheads[{{0.0020458671970891907`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{4.260724698042484, -2.819658475635151}, {
        4.310703873386091, -2.894627238650561}}]}}, 
     {Arrowheads[{{0.0008971721158221379, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{4.279466888796336, -1.4098292378175747`}, {
        4.291961682632238, -1.4473136193252798`}}]}}, 
     {Arrowheads[{{0.0008971721158221428, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{4.279466888796336, 1.4098292378175774`}, {4.291961682632238,
         1.4473136193252827`}}]}}, 
     {Arrowheads[{{0.0020458671970891907`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{4.260724698042484, 2.8196584756351535`}, {4.310703873386091,
         2.8946272386505636`}}]}}, 
     {Arrowheads[{{0.0036110481092921083`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{4.22948771345273, 4.22948771345273}, {4.341940857975845, 
        4.341940857975845}}]}}, 
     {Arrowheads[{{0.005674214678380685, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{4.185755935027074, 5.639316951270306}, {4.385672636401502, 
        5.789254477301126}}]}}, 
     {Arrowheads[{{0.008271518207665725, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{4.129529362765516, 7.049146189087882}, {4.4418992086630595`,
         7.236568096626407}}]}}, 
     {Arrowheads[{{0.011419136765807681`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{4.060807996668056, 8.458975426905457}, {4.510620574760518, 
        8.683881715951689}}]}}, 
     {Arrowheads[{{0.02134859125293253, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{5.306122448979593, -9.7667638483965}, {
        6.122448979591838, -10.233236151603498`}}]}}, 
     {Arrowheads[{{0.016366937576713567`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{5.414410662224075, -8.371511870054144}, {
        6.014160766347357, -8.771345272803}}]}}, 
     {Arrowheads[{{0.012110900511845525`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{5.506039150354021, -6.976259891711786}, {
        5.922532278217411, -7.309454394002499}}]}}, 
     {Arrowheads[{{0.008559521444247946, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{5.581007913369431, -5.581007913369429}, {
        5.847563515202001, -5.8475635152019985`}}]}}, 
     {Arrowheads[{{0.005674214678380685, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{5.639316951270306, -4.185755935027071}, {
        5.789254477301126, -4.385672636401499}}]}}, 
     {Arrowheads[{{0.0033834479306096782`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{5.680966264056645, -2.7905039566847134`}, {
        5.747605164514787, -2.9237817576009983`}}]}}, 
     {Arrowheads[{{0.0015596924307595776`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{5.705955851728448, -1.395251978342356}, {
        5.722615576842983, -1.4618908788004985`}}]}}, 
     {Arrowheads[{{0.0015596924307595776`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{5.705955851728448, 1.3952519783423587`}, {5.722615576842983,
         1.4618908788005012`}}]}}, 
     {Arrowheads[{{0.003383447930609687, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{5.680966264056645, 2.790503956684716}, {5.747605164514788, 
        2.923781757601001}}]}}, 
     {Arrowheads[{{0.0056742146783806974`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{5.639316951270306, 4.185755935027074}, {5.789254477301127, 
        4.385672636401502}}]}}, 
     {Arrowheads[{{0.008559521444247946, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{5.581007913369431, 5.581007913369431}, {5.847563515202001, 
        5.847563515202001}}]}}, 
     {Arrowheads[{{0.01211090051184554, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{5.506039150354021, 6.976259891711789}, {5.922532278217412, 
        7.309454394002501}}]}}, 
     {Arrowheads[{{0.01636693757671358, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{5.414410662224075, 8.371511870054146}, {6.0141607663473575`,
         8.771345272803002}}]}}, 
     {Arrowheads[{{0.028473340174100647`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{6.632653061224492, -9.635568513119534}, {
        7.6530612244897975`, -10.364431486880466`}}]}}, 
     {Arrowheads[{{0.022158516676423743`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{6.768013327780094, -8.259058725531029}, {
        7.5177009579341965`, -8.883798417326114}}]}}, 
     {Arrowheads[{{0.016717815320796768`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{6.882548937942526, -6.8825489379425235`}, {
        7.403165347771764, -7.403165347771762}}]}}, 
     {Arrowheads[{{0.012110900511845513`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{6.976259891711789, -5.5060391503540185`}, {
        7.3094543940025005`, -5.922532278217409}}]}}, 
     {Arrowheads[{{0.008271518207665708, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{7.049146189087883, -4.129529362765513}, {
        7.236568096626408, -4.441899208663056}}]}}, 
     {Arrowheads[{{0.005092763532356943, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{7.101207830070806, -2.7530195751770083`}, {
        7.184506455643485, -2.9612661391087034`}}]}}, 
     {Arrowheads[{{0.0024110776141148056`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{7.13244481466056, -1.3765097875885035`}, {
        7.153269471053729, -1.480633069554351}}]}}, 
     {Arrowheads[{{0.0024110776141148156`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{7.13244481466056, 1.376509787588506}, {7.153269471053729, 
        1.480633069554354}}]}}, 
     {Arrowheads[{{0.005092763532356952, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{7.101207830070806, 2.753019575177011}, {7.184506455643485, 
        2.9612661391087065`}}]}}, 
     {Arrowheads[{{0.008271518207665725, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{7.049146189087882, 4.129529362765516}, {7.236568096626407, 
        4.4418992086630595`}}]}}, 
     {Arrowheads[{{0.01211090051184554, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{6.976259891711789, 5.506039150354021}, {7.309454394002501, 
        5.922532278217412}}]}}, 
     {Arrowheads[{{0.016717815320796785`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{6.882548937942526, 6.882548937942526}, {7.403165347771765, 
        7.403165347771765}}]}}, 
     {Arrowheads[{{0.022158516676423743`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{6.768013327780094, 8.25905872553103}, {7.5177009579341965`, 
        8.883798417326116}}]}}, 
     {Arrowheads[{{0.03661957214128819, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{7.959183673469389, -9.475218658892128}, {
        9.183673469387758, -10.524781341107872`}}]}}, 
     {Arrowheads[{{0.02888838487433681, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{8.12161599333611, -8.121615993336109}, {
        9.021241149521034, -9.021241149521032}}]}}, 
     {Arrowheads[{{0.022158516676423743`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{8.25905872553103, -6.768013327780091}, {
        8.883798417326116, -7.517700957934194}}]}}, 
     {Arrowheads[{{0.016366937576713543`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{8.371511870054146, -5.414410662224072}, {
        8.771345272803, -6.014160766347354}}]}}, 
     {Arrowheads[{{0.011419136765807698`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{8.458975426905457, -4.0608079966680535`}, {
        8.683881715951689, -4.510620574760516}}]}}, 
     {Arrowheads[{{0.007177376926577087, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{8.521449396084966, -2.707205331112035}, {
        8.62140774677218, -3.007080383173676}}]}}, 
     {Arrowheads[{{0.003451490043452218, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{8.55893377759267, -1.3536026655560172`}, {
        8.583923365264475, -1.5035401915868376`}}]}}, 
     {Arrowheads[{{0.0034514900434522225`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{8.55893377759267, 1.3536026655560196`}, {8.583923365264475, 
        1.5035401915868403`}}]}}, 
     {Arrowheads[{{0.007177376926577096, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{8.521449396084966, 2.707205331112038}, {8.62140774677218, 
        3.007080383173679}}]}}, 
     {Arrowheads[{{0.011419136765807681`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{8.458975426905457, 4.060807996668056}, {8.683881715951689, 
        4.510620574760518}}]}}, 
     {Arrowheads[{{0.01636693757671358, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{8.371511870054146, 5.414410662224075}, {8.771345272803002, 
        6.0141607663473575`}}]}}, 
     {Arrowheads[{{0.022158516676423743`, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{8.25905872553103, 6.768013327780094}, {8.883798417326116, 
        7.5177009579341965`}}]}}, 
     {Arrowheads[{{0.02888838487433681, 1.}}], 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{8.12161599333611, 8.12161599333611}, {9.021241149521034, 
        9.021241149521034}}]}}}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{-10, 10}, {-10, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.656431204613843*^9, 3.656431209885933*^9}, {
  3.6564312645293765`*^9, 
  3.6564312830928774`*^9}},ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzsvQd4VcXXL3wkPfQOKkpVEERReu8tJCEJJaGHQICQRgs1gdA7hN5LQMGC
BRFBBRERBcUuICoqCkoVECQgsL71mz1rzpwQeIn33u/+770vz5OQ7Oyz98zq
fYKjhw/snxA9fFBMdNk2Q6OTBw6KGVa2ddJQvuT1gMv1wED+6lfWhZ/J5ZJv
6t8gfNO//Bc/P6r+8+JvN+nKlSv8nVwd9LUs/j3rprrbFaSv3cy6Qleci64Q
uXbFfS0sh+d5O696UP0XQJR1mFJjU+jLK85q6dJhmhUbS7HqaxZ9eYlc7dS9
Pvy3Y7Q0Uf4WS5n7Trjaq7950+Gts8z1yVsOO6v2xfPonaUp5k+pmfuI3xSk
3551bAvFJm4ieXlOb/eyFxyoFpxiFnyT9s3ip249rj59fPtkik3dTllEbfUC
jm3ily894Dz9/CFKjE3ER+XPdHoPv2gyHcvCw47TZH7x9hNZQfrPV45t4j+v
otPOxymT/7zqy0tBei1XDuPPsvy7riWPs4Mi+qFZx7fzDhIpJSXF+WKQztp6
LE+OG7xEmYkpdOCSwOcA357JV6m5uj0fvyeDQZhinoYNbj3Gn715k24KWPkD
q3jpW09kycavfJlJiQIX/neIkWR25qt2k+X+OP85kVK3HzcbP2Zv/K5rzLZx
yjpPJ44fpxMnTqiv4/j5/BWz8ZvHPDa+KcV66JVD/NBN9sazzp9ynmA97fyV
m3Rqz1JeWwpt2v4ObcpI5J+X0ik3QVw5nEkpSw+ZnX25KtXe+M1TexT1ZWza
Tts3Zaif95y+KRu/edxz43dZo954Kb1U/hNtnTyZMrdmqqU5O7xCm8BEh51n
ZWmQXpKl+jChbFXEuefAPtp34DD+pHnR2YZ7IVm0hYkoU7bho2CZyk/ftO8A
7dtzgE5dualZNZ8isFkpGbR102SL+e66Gr2X0oL6UwcUl8TGppK+mb7MZLpb
uo+XkUX7ViVSYuZhWadDzal04MRpOn/6FJ06dR5kafjv0iHFC/tO8WdP7WPq
VdBxkyEvCzs7dILOnz9Np06cwnLb67WcOrTJERUpW4wIyWEtHhIEIu8Y78AS
eVknKDNFC52UVXQiyw1m4HjrrEQjv2JT1ZucP3vTiX2rzJ9W7TsRrKF/zBKG
QCDDySUi78qxrQrqQjQ5vV0vWP05F+qjmPNAflInfHvAuVpU/cePLFxYvQSq
KY/6ztfy5MH9uO4qKFvWC1cPr1yZKDMTwiSvfoz6k/NPr5O/f/cd0QcfqN/8
crgvfw7XCtznffd77X/28/7/eIfAis6cIXr1VaLbt7V+9rwvUH1n1Hz6KVFE
hEKb+ntBRtovv+T0aPWYB3Iig3nzDBl4azJQv2dkEP3zj1kn/fXXneRSvjzR
ihVE16+Dj3J+Kb537UpUqRLR1KlEv/3m878JvP8nkoQDQh+AmOjll4lC2LAr
VIjoiy9cOcHRX1+j3buJWrXyQJe6b/36e78rRxq5cSMbjXi7RUK1amzcHPd4
3gMPCIE43x9+mGjBAqJr13IUB84e+S9XrxLVqOE8FpKoLauFF15gkZjlypPD
5/LJ8r7+2rnO7FLwPxyf/+Pv0KA/e5Zo+3awaL4cbnXAxRLio49YHQxSwl6B
Fah59VXfHD4i1MRQJHrtNaI6dXDNTTn3WNkdlGOkxs0s9jSy3DfJB7EWi0TU
Nbad6McfDQopIeGO+8ifCTw93QNsLPGISpTwlExF2MiMjyf65hu3ImMqptBQ
ouLFiSIjiVatwmdzAl/IfV4zgvjiRaKtW4mSk4mqVycqwIvbu9fs5O+/idje
o8ceMzKWpky5A6R0iO3Qp5/2kMVUsqSD7LsQyh2g99fYzO5LXTq81aXUBB4w
eSt7Lzap6IdmkxhUpYqjiPj3QrJIcCmEuX1f/fpEv/7qed/evUQ+Pp739e1L
dO6cusMAR9Bi3/fUU8RGvPU8X8eg6NGDaNw4xwb5+GMAdqb8+dtvHQE5fTpR
//5Eo0djqYXlz6NGEXl5CUE5GPrww8KyCLBS6dKei+jWzUDZLBbMsXw5UWCg
mybfeMPcVzxnbARkcw1PUQbcr+NgjCzanhoLZ0qbT/4OJlimmfXmYxr96iui
oiyQ9+wxW/rwQ0dM4haIzccfh3g33tWyZe7dtmjhEOCtW+bTADuUCf4MNPXs
yTRyqYimHoU9kB7+XLUqTDqtDnwcYHXv7gDo7beV3C1mU8cB9iNPnXJVFQL9
5x8wItHRo1hBMXnMhQtEw4c7vDhiBH53u4bsrdKYMaJKHBl2/bpZ3bvvOnyG
P8Ho+fhj90ePHHH+BhGAv9euDc1jMA1eqlePaPx4N6ZBLxqDJbJjkB95F586
j+DW9n6vfMkOzCrhLvZnllLKqi8d3Poo9vN2/rJnjydC/RwgYMXr1hH98ANR
2bJEY8cq+Dr3BNLJoAbOPXtnM9c9QVTrMYY3m2q/PUdZP66jl5cn0W+7xvrS
9c+n8Ut3LO9HH6/sTpfeSeT34rsfXXprMN2oV47OlCtKp2s/TDcL+dOl2Jp0
+vnODNrTm7vw554f2YjemBhCny6OYoLEdz96fnRbmtYjgk4/XJq+aFCLsvz9
6HiVSvRG30iG0YrJKfy5jHFJ1KpDDA0cuogBg+/+NLPrEPqyXFX6vXBJuhyQ
jz56ojbNiBxGHTolULn2YwrSY51m8osfi5hBsfX70JZHn6VzfnkpuGWy6wn1
N2/a+VA1+iF/cZpdtQ3V75BaSF32p3YdB1JM/0n0ev0O9EPpcnTNx5f289Pf
qNuOlcdcZwFeNCm5H43oF6WW6KO++9P6MQl0oHVj+qtgfvr9kYfozIMl6btu
tWha3/r0UUaXALVnL8oc0ZC+WNJBQcVbffelsxnt6Vrth+hm8UD6MLQ63czr
S38t6uqjwOtF5xi8m2Z1p9/3pLocNATSrs1j6JtdMxSW1NfUaLbimKvnxtKN
rk3oauH8dOHwYUMIYJRy5Rzk41+FCo6t/ddfDqP5eNLnXUIfQp8eQQqmz9RE
iz6/XOWmT5ePW7WATUCev/xiNIRFsloq+8M2I3r2WaLLl92fA3vB5M/KKqjJ
9sDuJbRybhLd6tbMAcCvG3l3UcykrPuWJtBzC+MAJCHbz15KooVjQunPnQm8
PYdsP1rSlbYGVaM/NnWm89Na0fXKxejGIwXpQmpT/oRDth/Mbksz+z1rkW0g
fbygKyV0fIrmjU2kVROG0YaRcbQ6bQh9ENKKLhQvQudLFKO9oW28NQUn9e5M
wUyZIJ1A9d2PBg5ZiJ9oTL+J9HyLrvRCo1Cq3SCYKoVPZaEIWvSixyOm4yf1
W2V9DSQt1wprMsezo9v3oXefaUbzIwbT4KT5bMg6hLp4wlAKZ6JcmJbMv2E9
gbQxZRAdefZJuu7nS0drVKMtcb3xF7UN3iDNGdCIlie3EIL9aF47mt73GUCJ
8Qao+NOZtWF0JfhxupWPCTXySTq9IYK+yuhMa7s8Qxd2xPtqwv34+XhamhpO
WZ9N5XUCEXnp4uGVNGNMJJ2HuGnJOubJco7oAQ5Z1BzfMIHmTx/MmM5y68j3
3nPssXXr3KQD9btvn/qtVHYJ61ijeXMORDG9Igh0OMshLxW/zRR69bZNIaJP
PhEbM0dSPX+ePP6BdKF76tYF2Yp1ffK7l2jmxAH057crQKZe2Ctk9luT6dqD
Rem7ZytS1r7xPppSL+xPp+lD2tOxF2JcvpYEmDKgIX25JFhTph9dTK6nBAYE
BwQIqHhadA16LT3YJbhbO7wVTY9pYMkpL9oW3ZV+rlyR1o+OZ2A615ZNHEER
bZpQdNxMBrpDOpHRaVSqVldFZOGa/HqwaGzSKkrdIffF9winlP7d1ZPkeZ81
qUsHWzZS75D37poZTokdnwb3aE7yx04oY2Atepe5j5WFUhq3CvrR303L0dll
wXk0EzIQaO3YtrR9ToQBCQOLMqd2pbdX9tdC0ZuOTupFV/MHEMUFE/203gE0
f7/8Hm1/eTpt3rzZbeLDa4XZvnu3ywSZYGlopX0HSflpuXNnRPCSCiAu3XeK
8X9KRcEzD1+SZ9qGtfhINikV0zSizEDYoRDSR49KLOzamZ2KG47smQUjhbfj
Q+e/Xk5zUzrT1aAadPuhInRjQxw/wCGejdMjlYYGjARSr88Io+fTgyyN46MY
FowLBv6019O0KK62IZoDC7tScngNmj1qMLOQgzwovN5h7TwQ3yEinh5uMtCD
QAYMWaDkWH+WQXLf1GEDqHtIay19nOdBzoAwmUD1e31A3DShe3UlgiGKWSQb
6+HEawNoQkx9+vW1AWZfYJSpye3ol3fGOPQAGXNwEt3s0ZBulypM2wd1oA9f
G6/h5kU3/3yXViwYxpbdx6682cEOw+jo0UezY90Y29liqlkn9qnot8o4rUIs
2B2rzDH+ZqG8uFyDUQYSfO897fZ50ea1qbTz1ZkiIfh7Prp1YgMtm9aXPt0+
WVH9jTk96HbhvPTPYFZZn01V1z5/OZkyRoXYwvf4y/0pvV8DOr4unJfhgPHk
oiBWNY/QzmkdDbo3jGxDk/vUU4gRdA+IDKWI7ike6Abfl2s3WiE6QqO7WZse
FBU9Xt1RQN8HVdK5bTOaw7wvz9sxtSMlhz1NBxdGat5XUozWxNehg52rmvWB
0bfNDqfMtPYwK3kfeenQi0m0YHQoXTs0RW31+pYhdKtSKbrVvCpdfz+NLh9d
RbNTu9Hx/fMMqi/9to1mTRpIJ0+e1GFEb0c4w4ZwhHPZ7KgulgP6/O+FPigl
oG/9enPfh28vpFWLhgNlZi1vPz+KNi2OVwSaR31ncbVzNN2qWZ5uPVuO/mQy
nsZkfHRTXz+NumUprVg5tNCC3gHNy+Oa0NphDSxDxIs+WRRJwzo9QzNGDDKg
Xjx+KIW1akz9EucZ1DE3OtZFxHRXJ426kM5JioNtFCf36UJDWT1k59RJvevR
c6PaGpL5blVHSu1WnX7OdJMWVNTUgY3o2+eiNYf62jKabrAtcLtQIP2TFu6l
hdVPH82nWeOigEEDrW8OrKEFMxPYvZLInrdjAQJrUK1ZWeXuB3MBd8Wct2MM
uz0hCVP98MVGmjNlEP313WqznB/2zaW5ad3p4kcTtYz1Vjz3z9D29NyMKMha
QdpHK7rTvKRmHkj7YU0YpTGg3p/TyQBv05i2NKFnHQ9+Gz2wJ7UO7ueBjMg+
qUb/drL0b+OWkR73sZimLu2bezwPjtbwzs+AQDz4bfPoxnDEHM0LA40dufnJ
zS114U3nP5ygxOqF4R3o+mtDZdewz/a9mkZr5sTS7V83eouIYt26e9tclmXr
2BG/5WODGKoMsvX27fL3g7LAe6HMdgJu3RJRe+6n15Rl9evBBQZlV46tVvLg
h7dGusT6P7g5QVn/LB6N+vhjWxxN6t9A2VQCjzVD6tOypOZ3MBlgyWqMhbED
36jgltSdTXcbD21CYqlM83gPfA1gM79uo44UPXiWuQ/yEZ+3mRZMNq57bXpx
XHtDJ79kRija+XZFiId8XA7hMDfCZejuuXhalhYuClDtF8jauCCO3ntxrIEL
MPX86nG0bds2EzhVBjRkGBvWFe8HR3nviiMvt/X70kvGSof9Anb+fN9KmD9q
IVjY7hfGeCz49N40RXQ/vtTPbGzj+CB6dXpHD4b6fHEHmtDjKWVECqA2j21H
qQw8mwFgcwDIAHkhDXggokLoRIWazhpBbUMHUFjUcA9EwpiN6x7m8byX04Jo
TFQt9UZ57/ZJLWjR4Noe6zu5dSBNZKLCPoTQ2PuhFRMi6P11Aw1Bgkgh+k5Y
hHv93Nu0eE4S+xyfuE1SROCgaPi3+0JQvrsiyNcxdhDjJPx4mzasGEM7Xpkh
eDnwxkRaObMfFK3BC5TuktQw2sc2puDls7W9aPqgxnTyuU6Gceaw4Q7BZsMn
pcuzNHlIfw849u8STOHdRnjAG4zUqEWkwkgXjRcIPxgX9n3swyrNtmTCMA/G
Gdm1pofT8zs7ElP71KCP57cz69uzOJIWDGlOF99OcDtV+yYoxfvdmykGL9+x
Jzp/Qk8EvgxeLvyyVRkTP/30k9v7/P57A/L7wkv+7HhhI7SkvgaDL3P5aIhV
81LoRkixP95PM4t7a1kMrZ/S1cO4P7vdUbufLAgym31vZmua3f9ZD2SwZKFx
3TyZBKE1BAf6J2UYJkEw4eHGAzyQEZssRn2GhxTrx8gcF9fbSEWl2XrV9Xgv
ogfwShkpHlJsyfCW9G5GZ0NUR7eNUF4vax9NfI7K2bFxJG3IGATYGNB8vUnh
488//3RVvh/YF7Bhj7C2hNX52pf7Vzn2xg9rDezhYIE5v9/u1iBMJEpAsdYw
a35pcghtntjBUwA814kmskP15uRQVmgODEZF1ryDEWBmBYUP9hBQTVp1Ywt7
lIJ6V9vC7jvegxHEGbOfx5a1MgXfmhJqYA+NDwG1Y0pLQxu/vDpACagTliMF
M+0dNtGWj48w+2V4qxDam+tHaLg4uh5ht6XzhtCNGzcevx/YmxCOljv4TZLA
gkiGt4E9Is4LJ/Wmz3ZMMWuBRQLa+DKzt4H9F5m9Fd2f2BBh9vbS2CZKg9v0
B+WQne6XTRzOdO9EOwT2MQlzqE6jUGUiR9omsg7cCeyXTxqhrK0ZKYMM3cOD
Ss9G998sD6Hx7MxifTbd75zXiVaOam32kZNyuH58PS2a3BsOnwfs33xpGm3a
tAl21mPZYW8S6xcvCvxdlfS1s9pK+vnj+QbOgt/tmSN4Lc57V6V3ondXxd4h
X6YxnA8uaG/gfGRlqLJM9lpWLehvONPfNMtKSh3cm2I6BXnQOIR/6bo9FYQF
zj1jJ1ODZp087oNFHNs1xANvYomxdetB43CLXhzbxKzvz50JNDuhKR1Y1d3A
WQyMX3eNddMV8/nMsZ5K+Pal3bRpTSq9+uqrrrsDOSzMALmivnb1j7coY0Y8
ffXRamPpIEi/bt4ApVHlpWC0NZM6S+ZELY7dXXp5aogOrjqbmMsaNTOltQdR
IZw3Odpx1QXIPUJbGxdcgNe8bS96tPUwDyAj2tygaScG9hRz35L0YSrsN29M
gnneS6ntaRRrVLgO8l7282g8W12HFrmVzJFNfWlybEMlSGQfn2xOVK7635+6
98tuuVJktpP3z4V3aeXC4bR7926HSO8EsrdKvSogIwN+7Vp5DWdYScvmD6H3
35pv4IxEyLzxPeBKm/ce3jqcZrCXxhaZWd++ZVGKME4977Zc3p7akuYNqOkB
5w/nd1GhSoQwBC7M8NQ1qIUHnNnHpjoNQ6hS+DRXNw3n4E6JFBThKdiHxURS
fM8ID2KG5QJluW5Ea6Mo9s9tR5N7P60sKz8dr4PQYEVJGeymWdEdyGzkhLbM
72XCn+KirZrVDxEIgbZQ5qFDh+60VUwG9tYtdxkFcvR8syH3N98kOnlS/SZO
GssgWr9sFG17capBw6lDixQ/2Tx29oPxysj65rlogwboIHheLCMNGo6vC1ch
hXemhxlwLIpvSvMGNvYgd0SmxGAX8HbuOZpK13EQIGjoPXAa1W8a4XHfovFD
lL3Ddo953rszwlUuZ9+8zh4yBXrkhTGNzfokBL1laqjZx9VPJqv0BstMD735
/KLB9MEraQYu539+Xem577//3u1AwRZ/8UXI6ztT/EqReunKCpVKnzQJCWyd
s/V2KiOQEJk2DUlsCXZs2ZhO726drePEzsuRb5mT1p2+eW2YWSTzp1o4lI5s
hi1jWji0Be1a0IUB4Wx6WWJdejWtqQdvvDcrQvEGMkr5PAzJJirqW1gDu2VQ
X3q0ZbIHUkQGMXLMfYg5JeTAG4sTmgH5hhh+Wh+uFOrXy9xEc+bNOKWcPlvX
y+wD4bRZw4Poiy1DzH7/+TlTxS3e2TTaIOXXIy8qpPz+++/uYBFqmxBoGjrU
wkFO1g3qz+zCjjp1iI4dU3cUEhyNH+9wU8WKqOSRSDAzjAqY8Jo0jnzp7+/X
KqPnkzcnOSHO98bRjReTJKj/4twe9OqC3h4qA47xytFtPFTGnlltaEbfZ1SU
VcCGIHtK/24ePARwi10jvIEQoYiyHhpd7cMGUWjXIR73LUxzeGhBqpuHIC7B
Q7tmhpv3IqMDFWav7+uNfVQWy7ahf3lnjNLLv7HM8JLo6EcT6ca6gQoUbJcr
0LBzaptC3x3KpNmTB9LZs2d9RYKhugf1IyjwAG9cunRn6YUHEufNE/Q53wNZ
uC1ZYpmtvk5KyEG289WmDcpBJH4Czw2KjC02t3JjYoMEfnfzaL0jP7rZoQbd
avg43Vgdq3b1QeYgFY8699Zgt1u9rpeyaBFUtaUiiH7H1I4GstsmhdCQ8Bqw
Yg0G4BqDAWMS5hrG6tJrDJWqHaVwKRiFJ9G0dXd1hwcD9urkQSGrhrRUlGMz
PqQiMMqY9ZCKLBFpfWo7vQ9/tb9PX0ikeSOD6a+DTNC7xtLNAS3odqmCdP2V
IXk0UUMuwS5wZ7YczH798RoVhT1//rxHXi4tjSggwM1xq1cbfyJn+SlYxoeL
FjWFh9ShgyT6tGPIInnDBjeGpXpp6FCQkHoD+BVOj+0kQtBvXhJPr6xM1pFh
Jty94+l26ULqGX9XfpBeCnmGTrwaKxhGcAgm02eLOhgIXmQ980ZYFXqZdU1e
DenRkbVoQkJfD4ygiKB9WJwH5lp16EuPaBHbw/LVwcf9LEpwqAM86xbZqGFA
RsZNWd4qATeX13Ku51N0ZnmIHdmfFd8EwWKNZCeyv3NcRzpWtyLd9lOVhfTP
mFCRWL9/ttixBIxl7aeQ+/m+lTR3ahwrvYuOBkTV3UMPuVmwZk3nOuVQNnWH
e5me7v4gCkbwMFanplwQD0KplhHUPk4Z10sv0b63F9Ci2Yl09fs1RiOwK6Ti
ku74ly/dYGv99gNuyrj5aBH6a1mUVObA04DSZK9OK01f2pPejE4XCaAb+RmA
TSrRkaEt6dNFkX4auRtHtTHRSn/13Y8yRw2m54cNUEEVfAnCYuLnGCQKYiuG
TXH10shu2b6PYnM3UfgqQkl02Fl9rUlNppfj+wRovK9nl0JiNM6SfOkrlign
WKLcqFhEbfatFuVRTSAk+sOL/VTIgC1+l2z80o54ut6+Kt/+gGHJW02qONrL
yZIoQvjxQ8f6Z9PQaDsQwsH3lqq89l/o6wA+/f0NZ0N+79+vkFgyZxrwd9MA
Kv5QzAj8QHMjXvrDD0X0beo5wtTNm6MYWL0a5jA7JIJ5NtZo6bRounxgkrYZ
fJDxoU9qlVcfvZ3Xl651q2WcYoi8VR7K14++X+PkxN4f3ZauFwpQn7v6UCH6
YlpH/pyDezYyKSnM8SschPjSiokj6NvaNejvwAD6tcKjNJadXsZfEYVOb+ra
Zxwl1m5NXZsOorodUktozD8RPs3UAVXT1ypb9ULF9LVuTVjktOpGnZqEu4po
CnFUeBPa36w+/VmsiCpYsygExhcIFI6JUMgvEay/vJ3C0L94kwvjatOW1KZi
Jx5a21Mp9t9eH6gphL+zsr9Zvqjzkbx+dGh5Pw9HBdns9GER4ECHMPwVYSCD
unBWIl0EYmfNcivfnj1L50wMAZ4VO8OGOSXdKOFGjQfyfGfPums5o6KInnxS
BdWv5fWnF/t3hCoSSji4bSItmNgLtQV6tX4qBr4yvRPtWMA7KleUrvWuQ7eK
56NrPevoCkj+3KoeyhJFuCdA08X8gbVo64RmCqDfjmlL/wT60rmaj9KlyqXo
y8mhPpoo5rKHs3BwU8sA9lG1Mz9Urkin/f1oTfMuFJecYRgcecL69XrT3pKP
0V9evrTt4aeAZqkaa95uFL1d+gl6o8zTrqq62LFji0S6wreOfSYcVWVF1GU/
qt5xMs1/ojUdLVCK3itVmTJbRlG9xmHUZ9B0/TYfSo1OowPlHqE/mEjOlSxO
z1lZq93aFdgzO8Llo3NmPzHl/MPscqZBBZZ+j6nNw3RH0uaTBUH+llf7jtur
9dK27V9re9HNhwrS30Ob0+18fnRhdnflxH/92lAP4nlj3TAaPyScbvy03lYv
+96cR0cqlqEbQUFOmwckw8mTrrtQjo8n5cDDHTXKHeJHdhgpx6wslylxho35
3HP01pYZtKZbG7pdiI2Hl8aJTfDZjikqDnFm73gnqJaHnp/ZjeGF7f61ohtd
zuxNl1mc/lOlFN1oVJEubYtTf4OIhUf89bJg43y9kd6cFgxyUk55dInMN2Pb
0acLu9JvwdUVlBnaDsdquxBlO0iP5Nd0NCqqI81t04SOlHmMzhUoQos6DtSR
TD8TvGCFosRGneDxNI4JZE2lRkZ8oNywUfsx6rcn9LUaoRPp2ZB09ZsQXWTT
OFpXsSH+57U61+BhSCCkgKbdhIS59FGVWvSXf17a36QeRTVvSMtHD85niR6Y
npN619Pb8gWnKI65Uqaw2v5X6cEMgsg8Endc0J7S2V6x48CA6Ia09ojN82pA
WQF0ZWYY3SoYwJTVQv39yqww9f9PO0fTlKS2+N+DwhZP6UNLpkbD5PMWvfUT
i5P29elsvSdp2awEugLrcN26B++LuPDv1i1NXLruCLls5Etv3xb6glkC3XTp
yErQlVPR+9I4KWT76p1pypdHIbAEbbcvjVHSCaltbwndsl98vWVlulmpBJ1h
kkO27qMV3YWyvloarLyKPbM7adXkp0ALEAPUX0wPU/FcJNbSk2I0Nfka369v
/GzlyqMMe1eNphIat0O7fTQR9Bk0g+o27oi6MEMEczonqfrqJH4MLBS4o+yE
5NcmEd6MACQi90p6aIkCmv90QVcfyx15bmQjBH+N6QVLdebgJvTh8m70d2JT
usV6+MqcCDFavn19mJImp/emeeAaFTpIfGb9uC6PSBPgutUz7O+xXXn+Hfpg
5wKVJrrETuVdEH6X3ickxWGYjBtnDFO4EzA+ERI1L3RjW62J3SKVgzq5e5xB
NbxGeFWn33T7z9f61qMrLCn3JDQ1kuO3jZ1UGPHl1CBdxeADyCkIXnyiNK1I
boEwMiPEYTvxAIGeIhqZqDIp23akBzKB86ZtelDX3uPMfexTGN9CpM72KaHK
zPliWCthW1NNIWvbP7edXq83/bi5Lx18ohRdZ3OJJaQUosCW3LchTkWU2TJz
MJZfQefN9SNUQOcG0GSjCj+jkJiVwUfvLqZ50warNOFdFMBdyjNRa4LalXXr
TOoQjj48QPgL3hJf0yg7yGgCqlCHKKhCPR5IDdFxf72fl6eE0IFebDvk96UL
45qItEL2QoJs4uN/yE4CNCuiLPmNj++Ybcx9Bvq9BkxVUU7gp6/GEqKhcAxs
TxFsph0D/TxvxVsL4prQmu61QB3yalbSSlkfXxemY9A+dPq5TvTP0w/TBSae
ef3r0+9vDNIE6GAJwSkQ5tVPJvtqxwlYeH3NUHqHnapbKPN2sONlefqfvr9M
efrnzp27o9o2J/yYWkrUFum6SSl3QFQNgRh46GLLHZnel676MzUt6mPwAhEg
dSb+2lLdtaALzU1sRr9ujKDzM1pTVs0HTcpux5SWqvz/wMKuxj1H8daoAT0U
GAU5g3uEKzayWQgK8KFG/T2QI5V4/RPnmfskeIOwtDwPngLcc6RzxT2HxHtz
UguaEfMM2MhXC70L45vR1aDH6BL7ojvmdaI5LPjOvBln4+f1hX1UuCnrs6ki
924fX0e/VS/HViabS8dW2xEYpMQRGT1z5sxd/K+7FElKQeTRo6boEmkCRKUh
8q4fX++rWUek2+9s390uGAg325ScHNOZdrib/lrKfb6+l3IwflgT5pKi8DOr
VGmQVdbsBftJabb3ZkUYdCFpNr5HHQ90sQOmKx/msw3joKF+kwgq3yFNISpG
o6sF8xH4yUbrkOiuJmAtz9uSFqSy7x9ldDE8jLWtH96AXklt6vLVTuJZp/FH
fcH6eGVaKC0d0Uopb0EYMsKo59q6qA9+NrGlg5OVhw1G2rluOK2dGwuI2og7
/Mk6mp7eHw07/3XwhKwaSctPkprL69evq/wO0gn//Jzpq9XU1+9OF1nn1CJv
SqBbdSvif5eUdf64Y5RC4Ncb+xgESgwBoS9RU+C3KX1q0AusHgRZko6ZPzbR
qCeUmYRFDvNAApoTUC4BNPWzBB8yn/Z9drg6v2VlIq00O7aRee+p5zvRLObz
bRObm/UhI7JmbFvUoRkZDl8QpQhs1gM5Xo6Rf7NXI5Dvp1OMc6LNCY/IJupL
kYb/9ttv7x2x1Ogx9ZCWIyJmBXJ6yIIi/eZneR+wDm2TAXhC+u3w1uEGF0i/
gZnYazd7RfMInPoXrDAk0u0onRg7qJfBxfThA1X5Qyw7pMI4zdv1NpkewQX6
AOBKsoIy9yEqJYFmwQXCkEjpo/BR3otIynjHXTTrYwZRgbZts8PNPpDFWju5
C700t6fer7tkCPXyf3+/VlTBHz9sUXHH/fv3O6C+P9jfYadLRBoVFbDTkYQW
8CN5A+fPNs7BChMGt6KvXh1qls3WmzJS31+CLI2zPQY7LY6vowAgYFgOK03X
5Qu4UH3SPaSVssAErNGDZ6nSRlSuxGrwI2uD0kabFdAKhrp8RqFBJ+ryYWeg
PjnvHQZAuAH/qa2DFPtizbIPZD8hp95YHO0BfhQ9wHsy4t4px18yN5m2b9/u
JJVzTnaa3CgrDQRpUSMn3jhqhcA8KK/ws8J2CNYYdxv3sT83bkAL+vnt0Wal
55l4Fg1ziEcgvm9OW5rU62mV95Wdb5scopQuUpsCIdSh9Alvr2AoEEdd0EMN
HJUuEFf1Q+xN2xolPTGGojq0RHeVh/CBizuhV13zXmiDLalNaVVyPbM+QHxU
z9rQfGYflz6eSHNTgpEPvIPgEQ05+9UyXy1vss7uVOJ78+bNdPPmzYIGxvdR
qgX9j9zaz99scsnzkO1AfBxR0gv70wXaJ951xAuSrbJKsCp0GtsiZjdoeEVw
FH0nsmvWlTQ0ogaq2Qy0kaFHQQoSxAJF1FA7ujnVNcDyRJBgjuieYu6TisQR
/aLM85QI07FMeS9E3dKEOrRmaH2zvk9W91DQZtHoIephwm9mG8UynMT9AMB/
/ni+AOjWxV20d0cGrVmzhq5evVrofoSM9AeiFhcOBhzM818vl0cikYgME3IS
7P/YMgUwh0wJ0DCHmpIWL+FZJUbZFnp1fAc2k93Z4Lm6okJgBFtGvD+BJZIK
zdo4rvxAyR1Gj1cq175vvq4ghfcnz0OfX3zIU/T29DAP9YoiG6ZyA3OUEaex
94qGEYE58oU7V/RTlS3ZYP7t7hkqpXR8/zxfS6nuemOO8vL++OOPgvcD83wa
5teuXVP1z6i7ZadBHolMPJK3r6xMBgH4ZbNJoUYF5pvSO9Abs8JUMZHAHNWf
cBfYTDcwR8IH8Yyl6cMNjGaOjGM6b6qadIoZjzuKyrYZ4QFz0D7UaO9B0z3o
HK5GXPcwZlnneYiVQI3C/hSYo2gLnjbytYYPM3srOX7U2NbeSo2iqhitg7xl
G+a/HMhQMP/y7Wk2zL89uJZmTIylw4cPF7gfmEuzHbo1QOM7XpkBgSLaAZlg
pPiRMPfP5qcx4A3An5sQpJofUB0lAEetN0pcN4xoaAD+zvQwFX6YOybBAKhn
xzbUqccoD+KVskOAOi6HoGVRS3FCKKEfskA2G5IZyrz36CqnLPJARnsT2oCR
j8Q+0r7HXoixZQuKAOGYMZ0LmbEAVybE3i2pLhvgv3+/RRH5e++9l/+eANcl
KGI5isWJ7gtRmijSgpXI5oqBNqIV4nIJtBFAhRgHtIV8WGSqmiDUBgqZwYID
eaMQXKCNws9eHdsq+Al5twnpT2WaxnlAm8lakXds8gJzHzzrvp2CPEQUOlJR
RL0+pbWBNnsSCtpuj8KBNtqwIMp/2hJrQxs2weqJnWG1CLT/+m41LZ8eQ9vW
DdfQ8aYrv2+n1YtHKL1548aNvDlDWzeJo5wc42Oysuz+P4Q0fj3yogE4ihPB
RMf2zjEARyQPugVhCAE4Fo36DxvgiAuh5gLhB9k45knMyybDEUIQvSmA7Mt2
oapoDp/qGmzpTQzTYPvQ3AebEuzBgDcIlMwOqgPyWuGHvbPb0PCIJ+jY6o42
zA+s6q5EOW/H3/Ji31zSV8H93L4JYq4gYLd+3kB6YWkC/CNbe27dPEWF2C5f
vhyYM9h9ZCaX460iqvrHHy5pOYNER/ss+i8Ztb46ag/LBSYp+OrXXWOlvkpK
wxA+R+gKgTrBBOr60Z+AngXBBAJBaCqBvSiYWDOslXKQUIkjkBsY1VFFCGzS
h0B5qKHjGsWbwPh0FRiHvSj3sdOrsIj0sDzv5VQnsrB/fhcPTCxiZw2YYCfa
xsTepZHZZY0q1WCdOnt4B1RZSWUDWmfRyXjzlw3gACWBz3y51BY7qPWHIXjk
yJGAnDHi65bzqalOnrZMGaLPP5dhChh9gDw/zJtbJzYY8/THdar6HMXRf+5P
l5qgG5sT6Wbos3T9wwm6VdZhXnjbyHGw6yS7gnOOFDy45reNnQRNu2e0Vukg
pDbyZTPrEV8TsKKFAtW88GMF/P2TMpQJXyE03ZVgMQwSrmCY4vo+lnSq6hpm
va0P5g9qAuNKv9dB08aUhsogOLHBA02frump9PDh56NtNIkc/u7NFCeY4k83
WEPc7FJXCiuUWkYaCBLl6PuzJKAGdAHW0BI7duxA3M0J5dxTN3//vS7e8HWK
37ZsUZeBd6iNI5+uF7mIUnlQCHwAxoi3To0j9HO7TFGMIFAFE0ASkIV4lmwM
3hewBPedMSWhurML2VxdH65/c76jWQiePwoJBXsiiqYOjTXYQ48zXNnu/SYa
rKAoGC4B8JZo6Re4xmhcKmaZT2hKGBYTaZ4HHQZGXpLQzAN7m0Y1Umartexz
s9uYqGOebBjVHoS/VQgnbUMYP3N9fzrd7FxHsQkDzMsytE5+6ijlPS+NE4ij
cxKNCIhqX7x40feemkj+1avn4NNbVdH81KsdLc8Yirkjooyk5drdXuNDN5ZE
O1UuXg/QBw0fp+2LxQpwkAcrAM4FO04yjuH0unC6UaEIXUyoY+KxB+a3VwoZ
Iet8lo83ovOztHFkG1chDezYyBCVi7AlJLOhMgTKB6e5kjx0VV/qGDnUIHlB
apKSkLNGxhnkofpUvWNUG/1efxN7RUgLNjl+B8Fdq1uGLvep4ZMD4g6u6hGg
EwIsJSmzWwP6u1RBBZhbtcqbfCEaN1fP7k8vLku0BRr4b/87ixTbsCLyuS9s
LVsmI/luxYfIJCdTYIh2TJROsRGu7QYfulauuKln+qfag3TZqqpHXAlRDvjd
/jo3cGlgLXXv9ceL0TcjGij8bJ8Sml8nfRFegtSSWjFMBvq8UR3aPKS/KfIY
nxBN3YJbKRvN8FrkMMNryVbBPRQaJKrclxbfR0lKNjHMPIFVbE3vCW9He0Na
m3ExcBlhsW+dGKxR6Kfc9NVD6tPy/s/SX6GV6bZPHvrn4QLIRZnszFcb+ijc
2Y0+qEy71rMOqNlUpl1fHG0q06S5EFM14OXB22MGEWcEiERp+KlTp1x3waK/
JxZRqOTn56ClYVWiD+YIUYBW0OyMYPAf76f5a80L429rm+ruyrLedd1pTyc8
i/ggolUBkoBjYNwo5wzc/L2QP+0a1tKVX/NYRlwT1SkBdeSlc3t7wtqpSr7f
yj+KuWT+HmZiU9UD5K8LzIbGzaSt9YNoCdvng5PmBxiOdAK45TukuYZ4RF2i
kejXg6y8aGLP0fRC00788Vj9SMei7MMohkUZoFf0QXBLuhYYQOdLFqPV44d6
WYMKIN3fnSES30dh/mCth+hmHmdS34WxTdw5g9cGqKEmuxd1NWO8Lm0fTFcn
B9M/Tz2k7j/3YCHVUodWUjtM9uFr48WbVeLwLiI1Wz0Z/nXqRBTNQjKlszMh
79eNLpl/gAER4FJdOOqn1TacapTtI+t24uV+dKtYProWVVPVjV1+sZ9UJCAt
glA84qp5tVA6xDx7LtCHrpTIT0eGtxJRumpoS1UYvCR9mBmp9H31KvRT5Qp0
oFVjl+A4OqK9Gk0HVARoHE/tNoJ+LlGGPq34NI2MnexvqUzk853Rd06pGGrC
VldqTPuLV6CRNbtIIVDV8Km08rHGFNVkoKk3fO2RGtSp2WCrEMib6nZIow0V
6tOOh6pRVNNBAabDb4qK4UGICOGtaduLfixdlj6sWhfj0AIsEd+pbVOl7/00
8Wwa0p/OFy+iRuq9kBTjbWWwMUIQkQ/WAnmtUoe/m5Sln8sUoB/LF1YBmkAN
XDAXapmRi2cT0keT0LWY+nSzYnH654lS9M+MKNq1OlaledAB7KfFBkjoj8+X
qNg2ZiKamv/7pyNMW/jzT2Jr0JmyODZK13844gh1KBg2cuLgAn895g/tU+jU
QYYd1S2qdClDdQ8qKYdCsktvxnlZeVLYlUjt5NU6QPTye0nN6WhyC1VLw/9L
mhL9figbQ4bMVxdwrB2XpGqSTz9Uio4/8RitSUs2NAfaAnMPGLKQX+GgMiF+
Dm2r05au+AfS4o4DfK2eEqgERG7zakqIbhBDu0tXQbGqqTJDhVlrHfmqKuoE
iXNn2J2pMpvxZHtaUKUlPdVxMoPG00oI7ZLs8tU1iyzG6PsHyyuST+81mgYN
WaCX6gWyUuSFiKWPpqPtbI38nTdQze9jaelrkRcEa//21RDxCNCK6RCT159P
PkR/Vn+Ifmc76DW2MRY5doYhM3TNIrcLD4XR5qWL0K6yFXWraF66vKkv/bWi
u0rZQy9J8/tHz8VrVe9Ef8UvO/3FEu97UFpOI/P9HXvi4AKiwvnUqDmY8EiL
YRYR2+oSikCfJMLJTgOyww4oTUT9GKgMX6iQgJhCqDavZatrc8IlxXgWeZmC
H0h46HaYbKIMMDTxyLPV6XyJoqwMhogyQHIR6gkVLjJNalzf8bSlUajGrHON
ca3CSaCA4UJXOguGvgcf67MbW0Qq/OfXpAozB+2YIGHWU/Lq91hqXs2Xl17v
381lF0JjFuLUvvX1bgI8kI+fcQ/0FYp4UO/L7rgmAn/losJuxtyJ398Y5BSB
Lu9Gt/L701+LI0UHoDN5/qgQ5PsN8oE7pNq1uvK6O/IV7hXKRZJg+CXGCmJE
3KfbJwdYfccIOTkiTdcJbotTNYIoIoNERBXMD2vC8lrONNwxWPTeOaBYytql
3gsTbfLplgbw0jZnlJRuaRhCnds1QxbBVcKWDxjKEjzeNcLiZwxh7RARb+6D
PQG1NjS6q0sQdvSZJ5W5usIaVQU3Dsy6NLGZXpt3doR5Wd4dqgcxJsOEDxT5
q5g+7K8/MnsrdX11XDspzbh8YJLKOCNcfmF/uljlZ75cqtgU7IrIhsbDf51x
kxGpMmoXIRFMg7wW0dCQAoYfoDEf4eKTWweKY4ayTtT9oaCMiS6vFaZC/AMe
tKDnyDA2vWBMsNEoaESdBVCG5JA4ZgbMfbu6SmrQYxxI21AnyZmiUYTyTwQW
YxLmGBQp9LJHPpk9h0IWOsZG1WIPo7FLqjbP1SpL52qXhY7W1xxcYEQInLUT
GyICLeds99wI+o2X/kfY07JxBBYRtIPM+vq1oQImzEzYunaY8qK/2zs7F5LS
qVWDRkeYMGvfeGeo4pwe9ugPSGe0+QZqFxGGG6pq9yQ0VfV852e09gjaIlSI
GJQY6eiaRdMepqgV1vBBmBDwhiYVOErQtmLHSa6RFkug9SsoPM7gZZoSlU2U
1hZ4w9kGvBcnNNPvdWC7KrkejexSDZ2zgdqfuNH8cbrAaJjMtsL2ORFqLI6U
w0Eh/fDWSBUvfCWjF105ONnDjP754/mUkd4TDXp3cZBygrKyuBWnSCQLMSOM
Mby+c5TLywr2YcoNQiasFAO1PkJ3BcrjEdvHji6Ma4IqPZSAmT55ZIKQn0C4
fN+8zgJ4uJYAPNuJBvDpSTGqiAW6QgCK6V0y92aUyenPVfIJbVglLP0xMra7
cmvZFBfY75/fRWUoIHps2GOKH0To54s7SKPQJSZzmKcYwYmOQIRXVoxsrap6
hciRB315Xk+lF37bNVZ0NWwC1TpHOUzpvyvsfbRPgnmRGDooMyOheDDbCdLs
j21x8m70tKHBCe0sx16IEbcEYRRk2pD/ObCwa34rPIfg6oaRbQx8MZEOxIni
H4GvhAeQjRhj+ovjzAwcYQDAF8O3+ncJNs/bO6eTkutrhrXyAO6BDMey/WB2
W1kldC4MLwjwn7b0lz1JTyoq/Q+9mKTgef8iwoTMGXCY2Ijhf5goByrdtyEu
UL8EJRsIcsLoYzkmS0IeHiHgDSMawowUwO2c1lFtCpVPhY1/PkQRJsp7SmmA
oF33keZOPHqMTZgMzJ6xkw2AMcIXRg2UZGGLKpGKR/lDAf1elEiivAeVbnkt
UYvZGHAdvtrQJ8CSBEiZoOYEksC0x90/6CRshq58zEuEP8wEHWj1PIOxEbPK
Z9WKoG4BOXRZNGJ8g4Kr07rhrczmzIZZXQmwUAKIyvVKETNc4zSwUMvQsHkX
5XsKsFBnAkCnxUeb50FEw5NcltTcvPfHtWGqo35jSkMNLGW1wRBWaRbMKsVE
cZtv4apBXXyxZYjPv6Ezb5UGgHrDIN8LO+Ll4aBttP0jSfjNc9ECL1QyobYG
484KWMQVH/oUKo1cRWRyRlSoir0CAiUtC6xekzAqHzTWlWqpG9S9IuUhcHXq
ZZuoqUcCL5QoYyReRlwT/V5vVdIJ9YfAHZtVQl+I2qwc1VqNmjRc6dY0GFwL
4kDTnVfuQCaKA7OAUcCAR/20c7SwJNx9xEQxKeHnzHBZDyx2lNyhAIxBJVBj
Y0ixJOYLCdSG9Y1U2VGENQUayOdBXwBeaeJ/xM1UipsVuLkPSSbH10zyYEkY
XiuSWxioKdXFEIMRdHhFqM2VmFsHrmQPTPYkOhIUwrIsT+4AJmk1JCRApZrG
hCEhBcCQGM2WT7DHSIVttiS+DpBeIJtjBxNSoJU6uI/iK8whECgg9oNIIhqX
x1s0FsJeXOsOMfo+R7NiUgXqG1mzFta+IqwaJEDRtGzEpyP/4Z+o6aqz2uSz
4juQwavHtIVCtSnt57dHq1YS5KccSXbfxoujQAAqyK9f3hkjuICfj+FNGCr0
40v9hCUhY1Vl85jGroJWnAXgwmA4AddENkRAIH0GzTDgQuVsoxZd6dFWQ13p
pmsgg9k0HONfPcCFitpeYW1tcEkqCx28/HN+HRMDuDCSDAVBGAKLYf62zhSF
//2L/Ww627YkWlHJlStXcmHreZlkJmSjPA+1R3gFBl2der5TPstjgbhnJBpY
IdYJow0xA4EVAjcwKhC7Li2FmExCEFWA0kSrClxG1NuwGtSto6orWTZxuMAK
1YEz+jVURvP7czoJO2LwKopx0XxphIYj91EnCPbASPXzO+JNxQD2i1LrM2fO
3C1rkAOg8lpUhJoDCPYvM3sLLaNVCnEFGA+snAQ4iPcjEAypYoAzbAB1aFaf
usWkG+CA72C9Vgyd6Jpk1ZPBoIBsL62BA7cPk9bwxT8LcBDZWM2eI2KDO6Z2
LGDxHWpVITpZVuWzJDwYYUZcY2xB4fz+GUxIBCWBAAKGKrIFJQ/HXAoQLjQL
m56yFEgGZLAQo2MOKGJZn4BFSv/uBhbIZsAGAFNNESMqfo4yomyYYTIgXDLU
1hWxAIHxr0hTvJwaZAMCA3dAu2+kN89nUQmisNgGKgRh1fvfAxq+nlFinNGE
s42IJH2OMcWYhAtvk22z/FZ3MGQfa3/NNt7KFkcmFCk9to5sgEDKoDD2QelN
iohXYVOAYqrMCoiZoAQ1/HoBCCbEQcJ0D2ntKmoVjYMqmEvNq4+t7qh0BLyv
o6sMWQhlw1Zi3vG7f0B88omTdvnnHwm+wPkD78EEYmckn2Ve4wgJfLHHLVyC
og9gDJlnWThmcIIyYPUJIDBRW7TTNFs7dU5CM4m5D5SBz0YFt9TP84bMUJwI
AmRZYlPGTpZqMMp2TW+VL5vdCNcElIEmOp+7A8QZ/+XtFMPjeMbISOQ2vTU0
MN0fY+Ixcfzopr4CDYyTeW9ic/VuJpFCVqUSvLTX04MNNEAWoS0aqomNskv0
hEPRlG2b4pphyQzY1J16jNT3eSuygGWEtjeWGUUs5TOxd11Vcr1ndkQB3cIN
gLCsUJY07Jxz7KafWRUqghU1BlAKyOth0h2UhoqY3yWGlv/OxIpz2JsKayCm
DlAjWwIxjafuWtjFlV9DCCOVtoVWpt+LBdKRWa2FgLF0VNZBd2aMS5LMtA4x
ehTbzdLFuxMS+7oe0oADL8GdBchm2hlxFsAIZ9uAQzsBjHFm0YI6WrqCZTCO
38GroJXQswbq3ZIWZFgMDvjB5uXpl5L50MFtkxXb1Mq+BmmxmnWa3u/CZzn0
pWdkmPk411tVpv1sAyLaj9g1mkDyy2AbLe22sOWMWRZZRfPS12lBYpGh7BaF
oKhNZG6RQO0XDWvTrs4dPNpY0FQBZkod3Js/6EAwnklvENs+dlkIKnZhC6G1
ZVY25mS9b4IGGCuA6/gtj4Y0GLYfvzeGv5amD5dXA8onKpUDYnX5gQpDwixT
JgfGzmF+mpQhfLowkv5o+pgir2MdqygAIHDMRoLLRgFU14zBjVUlvnNISY7Q
D7wT+hD5qATwzkNnyhejLR2fAkPn17X8x9eF0crkeuoEJuhBrPVsPWcszY0C
/vT1hA6mFBeV5jAxUQkjua0XE2PUvTjwaXXakLyW5QlrCs0Xki4B9Pc/UYdm
sXFQVEOxR//JSknWaDsSKbvZGgnDBkxRvQBsgJky6eTBs2hnzRa0sOMg/Uhv
5aOjIhJ+OiNB3v5Wzwg17+bY01XNQuFO4pwJGK4sWPPqSp4zDSs44HngATWX
AMYZiuoQVHtvZmvhagStEMgEt1++fPkuNlgOKVldTHq9xeN0tlEFZRfLMzEZ
FHIU5g6bHXlE1bH9hcE+GOXy6cKuAZY1gvYKsMDcMQl+eqs4CQ4p+syRg02e
Al4SFDJMWT8NvXmdEuhkkVI0LjrNTHrpx2SNrDm6Ap7qOJl2l6pMM6q1L66R
gKkuSx5vhpS9S66l1OxCVcOmeqRSYxrGYHSQx1ygfg360qxqbTFHSF/zpabt
RtO7pavQ0NpRqp0JiiAqerz0kOPIMhyDd/ThSnrVjmGNwabwkBePHyobfD+0
NV0sUggni7nsbCoan6CGXksPlvTz0SEt6C8m+4tVSpkpJ9AXmFGBRmeEHFnF
m+gQeO3nV2Ix+O/+LG0zceP77+nMmjB1NuH5aa3E+cEsYxgtKPP7dkWIt5U2
+oLtHIzD+C24ur++DKsCPUvooWF69td7Q678QKvGKl++asIwKcWAhoQ3DPdO
yhsWdhyopp/M6ZxkZkrD5UMdRnCnRDM9pXrHSfR1oYdoYZWWBrmMexpVs7MH
Ijs3G6wmstgIH1SvtxweZ+77oGQlahg01iOfXitkAp33DWRiiDbvVQzPSguV
5AU1luPY/fyi/JP0eYXqNGTQTH8L+RhjHhnUAhQvu97ZPUyNlNqcFKOLUhwJ
K3ML57Mhi+Mb/DRMP58ZriQZ5qQxyAUDiNFs00buu9NaKabMhcvudNXhPLHr
lYuZBgHoUEwJx0PZRJMcNWbMIKmJQRWSlYIaxlEgoNdXxneQETUoh0Dq2tmX
g35IOSh0cEFMwlwpNcCcE0G1pLOR2sRYTT1ex9TWpD/d0cMWj2iewF9OsXge
XVsDDQfvFgMfWDTkzwE7/HOghR0IGkh5NnzlOE3oA4jeVwb11CV+3iomhUQ3
op9vTQmVvOF5FnB/sEXlGHFu1mQ2UXlT+Mc4PCVvLlHjWMg47g0nfV1Mricp
HJxbgNn5sBH3zulkJr+yRsAYEeQMJX+LtA6sTFibC9OSRbuvSUtWRQUfhLRy
SZUQYr3QP4h9xiZn5NeYiEvOUCoLv8lpiahrhNTDENSFFtThLWEQPzOqujUP
JSbMsSsKULkAiT5qQA859RE1NBeLFkZlgRmMAjbAQQww7Vay4EMfjYxv+j62
EV0rno8OmUHETiXcO9NaqYwucls/rg1zSDk38T7dQM1KDKcFnt4Q4SAAnLe4
gzq4A8jkn6UqVMs8tVp8YWQgevIzU1qbXONqBqpO75sqTjmICBmIMhqi7Fwr
+6FCSLprseVQtGjXG3X1+j5v1UiIwB8cCmYneeQrg3opisVvjq3sr7wuBANT
HSdDLdGSIVJFiOgJNPe4qCcxggG/O7nC3ASXnUIOnLCoTrnUkxtwqhMi3Eij
7J6hXQhfZZ5gvA6Gt2BGCBY4b0xCccvkQgw9PTHGgEcaoMq2HelaagX7QGwN
m3c24IHbAEMWsYklE4YVU49UPKlcO9DTc6Pa0sn21eiXzs8UsJg121odbyy3
IPBTB0zirEAcIIeTyGAXAaoQ5IU0T2JwE0YLYTXrhrcqrvkP8SWkukEa7DqZ
rbN3hNRDZJ9U13JrOgoMHrT1ytbxccQ50UjNFFbMYiVkOQBk+GzoNi1k7Vto
G1+fLgxyaD63+3Y4EOcj4tA8xOLQKF9Y7xdxEFh7mMi/IDVJ9oskHvCEL9YG
sl/k7J5l8wnFsyutSgpcC4sabvYLcYK6aZDKuLjexa39AsVgxCXso7gB72NC
UYjJIUiPE6Py/Bsx4a2Ou0UaAgVtXy8Lka1CQ2BWEJTh5jHtSuitQuyhqGdo
367g6jKWPYPGSkQZV1v9ThCt7NK5HtFbZaNBHdKE0CxTuADwg7mdlSWNqP/W
icGF9S7RQ4wjl6C7UdsPYXjHBuWYnawrVyjrJontd09NhJOp1YyfjPZF9H5R
VQpPCrYK27UlrNpHeP6ocnnETqExCzMeXWutZBBou2ufcWazbC6qxHYk0/Gc
0fE2XpF3glUJzxl4Faif2BChrBUw28WLF+8wd52+Wr586RgtTXQOo8RX5r4T
99i0YxkxT6i3yLtgnSGWBX5iwi5hiDlZETIUKFOre9MZinDbdRzgWq83jVlU
sBzRlPPIHUaICpeU0JuGr4TNIoq4bkRr5XAXtlKuF1BTn1ONg7NjX+fM3qUH
nH2dP6SOT//yCuV0Aqe6JnhFjhekBTv0hbHtSupdoscBSwR+mY5t1KIru23o
ANcGYx9PUjsHHT+qd4nsKJrJQMfM/cUt6QwZgRg10IvjkVjjK669g3CdLsZ8
dzsYXh1ff1M2RZfUMbNbT2TddcciG5A5R3wSQhlpFfQqCnLRRgWrCO0dM0fG
PWohF9tux478RssKAoJB6V16jZWdozUavTywfSz8irmf1qOOIirkvArec9t3
OW+cTu1Zynen0Kbt79CmjET+eSmdItLp8ljngAT+p20V00MAXSRBNFAaRnoI
tpGWRa0aFh6bvEC2jdgnEkdB4YNdmzykVphSSI/qGlTQNPr3wcg4jYLtS5e9
cfTiQ07OZoMO3aLKrMpjFpyNd7OOb+Wrk2nPgX2078BhHDB7d96VUJtq92fp
CM3z7ozwkhazItoCWpw2fGBZvTFII4jj9mFxrhcsCQU/AiK6rCWhABPAhmFU
Uu8JkVFExQBKzKSBhMqbIzKFO3HqdkpsKh04cZrOnz5Fp06dB+3elValrxWm
MYqooM/fmBhSSm8L3eTwYmBEsAFf1radGDdQqC+JQkX5XMMQuEl6Wz7GPof9
ge2hgaKExaLImszq31DhDAEK1nUB994eI2nrrEQjbmNT1UnQd92ejGCER8nK
U52Lhy0icS57BEHBfUTXPFs55SzzGSwHRbJFs6IYDSx7Iaxkm2BFCCCw4ti4
Xqrnyt4mwrPYJspCYECwlvXLcZv3qOVx70O1XTAFgsNx9l4pS6QgIARpyngr
r/fRMXKozrVNcL2q9yHttvhi46hsNvaCxoFxAF1b0toHTH4kuLAPqGf+3Sd3
+/DW+8BUAZywpKoL2F5H2UcpTfSwOscM6qn2geEoGNRRTvMJ/BfE+mGpsl/z
uiUicfgPLrOoLGftB6Y/xAWELRoP5C2IeS5NdFhrJuMGRqzXfW/GiWz5E33w
gfHVwKyQeyBm6J3tU0JLW8YaXCykH5jEyuvd9GexhwleKGqpFD71DWs3mD0O
jd6l1xi5G6EOxHxgnTJ8SmvEQKFDu8BmglBCND132/BVk7mP8NJBWrByoafZ
wpfCGcTYMCvdDrxA8WLkD1ib3aoKepFQVDhmBrWFlSKmb7cMFMg8BK3LW9jB
U5wcZyvlnEnoVhIybufTk2YwVBDHFOcuDMk6/XrBANrM1jRLHknGocPp67rP
6N+cd8GRgD+MATuYioESJIleDGH5LRkPCcAjW4ISJFQP7tRohNeB5B3rcug6
SawglivBj7wWKKAae4a2URYBQCHBjBeYgL+qX1P9JmllEWd/yAyG+wbBihUq
pH+y3CO0cuJwBwQBKgeW5e9HH7H6WaE7BjDnBqSG/+0j5bfWa09TeoxUv8mk
cuhvdCdiuzXapKiw+NsaDCl9J6i/oQaAyUBGog1KXkD7qrF1NmiGjtCp3g+V
KEaBL06tB0hW6N7Yy4UK0L4OCMjylVwQN+951y4VmPqiYS3KHB0vDvypRx+i
H6pUpJEazRA17EpKyH15UF/6qeQjFJ8wVx/A46dOS4UjpYmbqoRPUw1VT1pZ
gOiGMaqRzw4AVwubQv0bRKvf5L4OrVRrp0fwuK4zAtPjs3hWt8YDPa4hwLz0
8Wb0dMdJ+nl+NLxmV5pcPdhEKiE8MIoOFe5ygFBmq270YylH2sueREaCA0F+
r7O2R/7glYE9/w2sL12iTYw1ENPqtCFFDTslUyoLC8zUn6ur8oR1kEBEc+S2
Om01IXirmhEE/jCuNarveInWzqzWTgXmq4ZPNbDo27AvXfANpO5NBhjYPleu
zh1w7Nsg5g54o9FNn+Zg7hv7TAS1bj3c49qIWl0p5VnP4H9cvV70W0BBqh80
1kSJYQJhdBcSCmwqSOB5GFtLCEbPiByqd+1wPFvt9GXRwrT2ySo0Kb5PLsAt
9g6ecrxKJRVzLazpGrCGrQWaRvDmHVZ+R8o8Jn3hI9ngRa/guL7jdezVW5Ur
NWzeWfWVV+w42UdvcWGVliY4bk+lR9A8OzkKaKP0NUy0z46C0BZJJjcieZD6
HVJp50PV0IPIC3HrP5AuSJj1oMjdD6rVp3efaWZlqX3VGHRIhknsRTpSQwnP
ov8Kkm/0jaQLxYtohROglBPCBgJJzNvG2hC+xkT/mdZgksVsEUqvnLT+IhaD
MjlHj4/dr7an0rMq1QM1iXwEWiGkpRttc3uqNwRT6Ef70+FHHleci89lVxRM
QoVzt1cJ754vUcxEkeXoC5yziFOiHX+8m7K8pEZgUceBGDivfnvUohvUCKAO
sGLoxAN6g/DdYSFj3+hzhggSTw8964cqPQ3x7/LSSDSbYiMcZif4go3AAv9u
Y3sZND9Xrqgj1g5PoCABsRCQCDw0dcJp8oLHxA7jBcMGczzsMZ9aiIKnAxMN
7AEL+jFrzVBVMF7wRBis7MTlu/ua3d2CUp6xnulLjBwf/R3H+cHIg9OFUSkw
wSvrZUKsw+tC/XPFsCmfW8vETF7YV6iFQQ2ZvUwYn/0srDIZq2Tx/bfJBejF
odRRnSLODAERg7NLZXGIKaO8ESZAz9jJX2texnSR4M6JwgOPW+sCe4mNhfWx
FvLPHcp9NXrh+QClIB58ARns4lTWshYJdRhh8IJwUAI6FL61gAfjFIegY+kM
SL0lXxX5V+PUGMdw7bBldo98crdIL0ODIxSVq1M0WzVW0YJpwwdW0YsEDQJQ
sCJhX6Ao7ju9SHg9bFkqEwphElaJepGO/mY8qIQ3CBG+zvCYKJo3NtHJDuVC
DDpPAwliq2qoWVg7zCBWksBeaagWayDF6MGzXD9a4GQ0K3YBNaDAs4qFc0gY
GFry7LT4PrnKXuIZACBYZP7YxCf0kmAviJ+L7mScovOLBTxwDsIwmM2Pk6ef
sBIcwAk47eTJk/dfPlzNvDjDyVyy5EDiCKn7k+bFelEMJxjAKDmpis/d/46f
MCDPUJIUr4GSxmtOG2mboagakgGpPVYtDsjv/zXCKLBfIAcRFpDXnNevAYid
14SrSd+oh388d695TL8Gwx+BJSF1ENAlC2id2LuAJ4/dAGiVcveaCpregHg0
ICGeCuQDF+xlX822IbwJBltkdKqrQu7eVM6CG+ri8CjYf3jUDV3Z415FpOJf
GDZ8f9ncvUkCoJDzUEegKdgOaPO7rT0Ax66YpOocAFrQI0AJ561M7l73sAYh
JCPGcmJjqDmDmwvHB2/01q8FHBGtAIkrwtFz+/HaB3P32tL6tXAngRrADFoN
rgD0C94YYO0W8RM5cgOvBlEhBVIqd6/l7wuc4x0tn97XbAwz6PD01h1i1CGe
WEBBaxUoFQNtQeY1aNZZ/Qx5Wfzuq3DbAvzug48/S9M8jlX2UzsD1UCf491J
tVpTbOgA/Vy3Zygm9qkcrhXJRhcz2XrDs8BWgC7apZQ3not+eS9lvH1Wsbpa
Z35t7gJfIA1ZLexB/A7IdGs8gHaVruKS0/NWPtYkR8cg+7Vq+mgs/CZTb2yn
Qnw4PajE4z77s/K8tq2HyXVzDVV8Q/Qxrc61AHWcFo53UxjoPVbRFLgNdi46
8iFeC+aavjLC4+j3wk7rX6DgmAU3qLeFpl5IXMVg7N2Kx1s/aJw6aI53bvCO
8UDReqSl7ATRAJSo2dcQcdhYri5cLnMNZWhpNcLwvztikYNn3KbN8Dsg2I+f
17XJII9rXRlarzzyjMc1lLZ9xV66veYPS7BordfL4771FRvQcocatAftp6Ql
fCMIHUhLCB78DE2UL9dQR6jtckA+GsMywc+K4QCPEGcIL4AbgAXUHfnpleFY
PxzHZq92ZM0uKtaTPTYjRYES6URRYKSetWvT2W+BhUCrHo70H/4FAGmWNbjm
b4xRyDvIPah7SJ2I7ilomfHPPQD4gR89UZueb9FVe1v+ynyL7JOqTDeHsCOV
4QnAsGyX4T44vXJNpUYeMSv7lMtfbedfDwuSvQW1GkpbHn1Wc5R7b9CToHCR
qLodCuaaTy73ppiIZrDp9QKrOqjFDgqpUQqpMFBgL+GFeH9NvRRYF2i1geoE
gGEvAsAQh1AwjuC/70U4shUvlpeGdBkigHSpN9e3hDDm5IDUMNQDzj+IGydk
5aq9T6Q5pIR6Q3MNdOWt8h4uX76ciyeqR7TBt/vf939/5n/NZ9xWgfvO+9fN
/ym7+H/hM/wdTQHZY/rN2o26Q2vqYKn67WQO1+wgapP2o93Py9VqMAtQJK48
EZHtd0o/obSOrBBzBOVQUbkvhTVYZz1LUK4hO6Ej5uYarC9tK5jnQUvIgaRi
OwS3HML3pnl8tjG/M0qPeJFrKJ0fq7WsPG9J5WbmeXLf7KptKNixEM21IbWi
KP3p0H8JrQZsVZ3zy+vx5jfKPH0HZKJ4dzIcz+AzbKop+hedD71Yk60e+3nJ
dbohP+PxWRz4K5Zb7lcNiglumazsOUW0Lf8zmeM/5TP/LU7/+zP/Sz+Tq4LX
ezzH1JJmK27acvj8/8DzfOn0vgyKTdlKWfxr1onthFq34zfvXix1H4/8MjOF
lh44rz92nlbFptChexR/3scjD2emWo+8RJmJqeaRdpmhKEz1Uyt8u0thHx6Z
SImZh50n3kRB3L1LVO9jlZe+zOSrq+gUA/PUvlUUm7gJ9YL//pFAdxbtW5Wq
0Z1Ke05c+Vfo/k9mkf/+zP+ln/lv5Wp/hr+jFgiFDLa1jbiP2IrqsWIIwoyr
ZRuMuXpV+1ZD6Yf8xT3MzStevncYzhgS3lsfgizX0JCMHlX7GsqOst+HkI4O
App3PGUFl8XYfyY0XcJC5rMwr7M7ALjWs3GspynNbtDqSo0AOvMOhNjCWiR6
3LeuYkOaVj3oX0KrJRvwc9nwtp+IFWd3PdQ49WyBLLRuS8WK3KcLhtRv03O4
Zj4blHpHJzDwXi1bcVgTdhoH1O/zL3eHFQO29grtehxFdjn9odh/Jif9v/aZ
/5aj/zd/xqVK6ehBZm984aTmCiETHKZ0Eh/eVIEVxKMth1Dpuj3ot99+y0Uw
OMBJP8ZOof4hsepsOUSUiz8VrE48K9d+jKp0US9T9ZAuf1T30SO8igdZBSAE
jQQAsnaIyt+6dSvXkejX63dATZ6e/OKnAtBIJiCpUOzJ9mrXZVmNIB6eT0sh
ZE0kQ6IWJ7WASE5Bt+E352Y/gEsdXYhUgSRhVbR+0HRnCbmSlljyD6XL0fyI
wXpOip+KyiNXgHR50WptqWTNLvRwkwFqLqecoYHADbRQdq2JUxHw22/6Wnjz
hGwJRSds9pe3H5KP+qQPRkPYVEUMD9bvrXCG2g2k7bv1nYC0s2+uN4aTZK75
+OL4BX3Ih5NfRL4a+QnUPxR/KoQeZhWMY2V89eKOFih1R7YKZ4jgqAf7GmaW
YIyFfQ14RLWsnedTUbBsSrSxE1XzMBu0yvK4rx4r2+ylpXhv9vXBVEEO1L6G
SNtlb388w8o5VqTBdXtqNnPIqRI//9HWw1SxAnI2oH1k11AwFJhrqL9VqxV9
VKUW8oy6ljZQ1USihgbpJUAch1WXbTtSlU1gx8iY7in1uKTD33roSXoq1DNM
iOEwMi9ErqEEvA0v3L7Wii2bduAXy+TUQVYPYGtbzOOzMEs7NfUM+sKKEYCZ
uSdM4U3ajfa4b1yNMErlL/e1vJTMVP96maflPQ6F89qQXlXJMf4fQqZ/4jyn
bCBXgAaQAWyAuKAlapA8hGQoVq0dlarTjSKf7YyVmWKDqKaD7ti5bau9pa+B
ZKtkKwTH752axVvX/OnJsCm0pUwNeoQtVKT7sDOQEko1+ifNL3SfFR87a7aU
uVn6iHhn4BAe06lJuJKcDzOVQ/jhzVLJARoCUPHqDgwO5FFRF4gz9ormupJj
qNXHUlyvAk2XoF4kRiEIH201RPEMFpBfrcKXBeM4VjAxqsYIK0G9HwutErnD
6oMajUjJYg+o4YH4LcWEBHWIfLx6rZ9+bUVm8YebDFSiDF8ouOobP7t07l5b
xiqwkeILUE/per00m2qN6VQk+FA5Ns+hdKB8UESKiquHc/fOshq4aAiCpkFB
WrEngxSKeVc3ZYNMXFB1UAjQn1BzTFSP/JvqNx8Hk+Fxat3Q9jjeL0vvqQKr
JMglqZnCnsrl7jWVpPOH94RiUJQqwILBeSJX9GvKtna0KrQbjALM8s9lhd3j
Vp2laglguizNIgqv+VPDDVyBKe2QuKjqABcNGLIwl1WDHtWtuvkAG4K2PKs3
hDeVYZGgyjCZcFALVDl3r6lqVXRKxWppllzl2o92/S6vYclThr1RwA3SBeh5
4l/ZOpHRqUriPmGBEWQF0690ne7quNVfrc1BruGtsCXx1qq6ah8lOXcdDHAv
6xf1uujsd7hngKoHlsWA86WOGHYiG8Kun8xiZvBinIpKyBgDApRzx89RoEOv
Byqec1fwkMdqk0np3131mWHLkHr8lioWXcNwUuzTIFpN8v1BmxKgaxT66TLY
KlqkoF4QtIdiYjTOoXVk2rAB+n33uz4ffT+q44fq0S2ohMKOYxLmuGva55pS
XbAyG/auo3p9bLkqRkD5JBuAUn8NQxeVRdJagMkLS9OdYZH3vz5pqZgxYpDa
IUrZwQsgNea6x3VlNWruUdsLOccq61u9NMi4tqEDFMTZHBBow+7tpxsL0G+I
4nXf3K0rUK9ryYRh6pRgVJdDIkDgMrPJulB7DHBCzVQISf9KrwuED1ZEbzFL
AGlTgDDAAzAAB+SG5m6ZPXf/S7MHmn7WpK7VmeK03GD6M5gAGg3NQI8Zbl2g
RBEULTQfVOJngmM2lqFHYP2wJfS4JfVR3ARAouN5+vCBTnfPf2WVyBoxq/Jg
y0bqt0C9RrQXoLEctIYuaxShyuBKmDEYtobfHrHKoaEyi1fv4Khy1qkH9boh
ZcBX2C/rX2kLGhszgdLZjnAeIGXiU1S3CVovMOUGTYP5c9e4ojsG1vMGrvv5
ouFGxoFh6FV8j3C1J6wHU/O99GJgbcKxHTjUPQ4V59qhOWug1d+FMixUnJWs
2Rl6/GPDfuOUeNC9ODJ9EF2AKbwl+6lJ8bNVZ2BqdJp+u4+qzUMDPraNphZz
wnmupD+2fYCJ4GiNanpwmL+zZ41HyA7IEH6zWgGvRFrZcHwfjm4baBqUvRQZ
gpXZGjK+IwLYEfp0lDX6WnOrAsZ260PY2YWb4mORgWoLaqxa/OQ1GER7Ln9h
TOQ07W+vNehAH8PJ0l3x0qgK8SUz03MFmpUTh6shiZiQWUSTA06+RF8KQPNu
mUr0Su02prUPh2XiOEP7KDsZDoFAAZO3lOtijCemOkY0jzd+BIKuaCANbZFk
vKqujkt7h0d2P24yXOLsTavzqraW4iNzbVfpKqaA00tIkz1BadhjNSqdlUtC
Y1V1cpw5q9tHkeZlvwAa2ryBapvDtNpiuewHZoj/9BN91rguRrG6ZOzSBy0b
0h8M/6jmDZVFDbNQusLHsyeAg0kn9hxtRmBClUDVlngmHNaYTMtEaVO/Bn08
9ozyoZHsA9olzyj6lhJlgb+O/XvAGtmJ7HBF6EE8YrkGEkeplX2KJkIhWx9+
CrEfM80TdpaWcqYBe/fTjen9JxtYjp+Pcn7QtLbhycr0fdkytGlo7L9pvH7z
TbrtctHZUsXp+WEDnCZ3PzrHv/5ZrAgtZzXjNPQ3Vl4BegRlUc+zOjxQuaZq
yZSGfvSNYPE4lqt2h3EgYONU24Qqg8pbtE1RzrEbUL4q7DCsdqSKOcpwgD6D
ZkiD/dTuKfRHoRKKraTtAfyNtlZ0gqK7EkdD8sbp3S7BuYYJE9/8+erT77Vv
7pAuX1udNoT+KpBPQTmPYf5k1d8LPSu6QHq3l4TEmtHYRTRBYgoMXG84yBXD
psqgA5hd6I6CjcW2rfS3T+oxSqk3d8OE0zgLGa+HHEhD6KFm9emLRrXVbzKd
Ai1qf//9t6D5fnfPBnFcnJpWjcnqMNTmjkkw8yNeio+mLYN761Ee7s7TBK0d
lBnEWr6C3gMsuRI1nFGSOzTKETYDiaAZUaZ/MHqVNYPBdKmDe8vg091sbUqj
ayH9UrTkwpzC4NPTp0/nYoqFH9Ho0XRofhc1cUWmHuK1M0fGuWTkikh0WJpd
eo+VnYAri1WHIhvtelOUEXM9PB5IRt6BzCeB8Qeegb2MY+fY8DPTY9Aairkg
MusF82tyQZsBRFevmsExMjxmHYbHhNdQQ9+mDhvgsqfHQEIglsa2lQz2QSE7
EMC2q0tGx8C+humPEnN29mR0DCJvsCdAB+z4yC4wtwjeGeCHkS87pnZ0BkHn
xl1xD/3CjEQMWAL3TkyKMcBC5yteA6cI/NXfGuiDYViAO+IvrEhf08QFGwrW
O9sILtkEOiMwowlfM1MGmU2MH6qaXzG3BnO/cJy5d+42IVOicE4QjtWCuY92
cRzrXtISEgAfLBZpapfpXTKSTwVAQie+ItqDXSLV99x7rNkvWqUS9JAmdlNk
Exi4ghlbmKyEccC7Z0U4M5fu2ESuis4C9cZeTw9Wc1vhTKKdFwOqZHIZRsfi
cB5YsowNGX8FA7FIlZbK8X1ZbwiRPuzfxIv44ypmyaQFw5JRIeDC5F8wjzUq
yjnI944N/atJivmsOaDpvDHMwU5PjCmlBQ5YE5DHuRmyIcir4k+HqjDDi3pD
mM4AkY1skiAT3gvcY9iZLFBkQ5jQBiIGmeEYIEwjDbznrLLcDkqUM0xwuBdm
m0IMzBkdL3hCQACGGCLprIFkFBtoEY4W8oqb9bYgvqFtYVnJtrB9SDIc88V0
LU8FmWMiI85iYqLLd+/pa7kchFjQmlqGWZOQMyAKphMztg/CAYdCa1PJY1gE
xBb2hkPMn9d7g/UCxxcxb5lDgYgQzpuAOrUghuALRiBiWPX2KaEF7rm33E47
lL1hjhimHEK4YbqCe8SdtzqtBCjT82BkW2AjsBa2tVFvC4YwHHfIxkcNa41V
KIN0YzDJU+GOT4mur2bAscQq9D9vxmFRa8I39IF2QeXFMEXAWXB8WPk8aumh
mvXaqxBmpt5OsOrf66xMqUcsKSlTWJmxSlhKaOHgpoqxMMfswEI9hfXuZJjL
GYcu5zxxHBzwijowzy07IBQx3mHe2ETZpZxSj2iMNZAUbjkMB0Se10kCjj18
8BkCIo9YWgrSCJMtWGbIU9PY4kpWE/ibgGRk4iqoB9Lk5MmTd8Yw/+3QQz2W
GId54ugSzErDMeKyb+FEUCuTVXFjMCWr+XRoYGf34BGLWEW+iJcPCwNEgGM9
5T7YclBq7JZ70D+mFOKQN16BTBOGrYPx/pitiwPxbt26lasArns89LvTWtGE
7tVpFptgUJkyUReDCnGgCXyJGSmD7HHYiCTBJuzeb+IjtmZ4KlhFw1dZ3huy
eyBgGQ+N6DnGPMIWY4IpblmymOqY5BzFW1iPJIfQ41/VaSkYII9p4P9iDrav
mdZ/sHNVBTIMgzYk5AwkxavhwbDWlZHnUzQZh3ZJNjiCfIXggRm/wuj0MUoF
ohu8jGWUQZZmGw4NeYozziAarAVghDLoDGcSfLU02OvfDXrXx0Uoyv05M1xN
htbTzGFcyqDzL4a1ojXda6mtsedU3LL2YRfCLWPfS6ZhQ6Jiwyg/WWZbZY2d
UzbsUfkg3jGDepowBQLJEOwYH7ynd136nOlLVoEj3HFMIQ6a/GheO59/dy7A
mbVhdKugH45EcXnpIeA4qwvnrgDOLKwK6HMBrHMYwElqBiLCl9A2xSw6RMwX
IeF+7uHncAXgqSIKu0RiHfp8Qhhych9ijYABPI/iOnyAgT941VxnOrbHQQn5
LQWIU5kwGxwzwn9/vnNuJ90LQK4EP05/Ny2nGdwByMfz26mp6Dht4u3pYXLe
kn1siJwOhEmY8AAgflnBFNScgCDC0WeetOY7eqnMCvwLEMHDGgDoPYfwe7hx
rDkvAf4U7oMJ/7DmDuStIN1hIM4fmyiP3BoTpeZOrRubqI8rc8b6QrzDwnpt
Qgc5b8I+3SPQspEwPRRgBO0zD7j8/9XpHnJewNllwX4alDjlVg77lNnIAXox
1pETLjkARg7KgIpgoSkHsGzv3Zmu5surDvDy0deg2Oo4LdjmLA8ETDawOzEj
cpiZmhkjByq1Hu6SAXP1nZOR1G9yNKQufLHCll7KQYfOgTcoz0Mwfnvt1h5z
7JDUV6P/nXPHZImHmtajU2UfppXswOezrGn4qhjL++H8Lt4aGNZhFi45XQoH
D+H4PIz3Z/YM/Fen4ehzLFyBmqwxX/7Fsc5U/y1pQX45nLfiq98vh25AvrHt
Jwc9YWzp33kD6fX+3czYVGSTlNDvOsQlh9FkO6NGAluwU1BnAiNU4IyZhqqG
3Qp3Isov3aE5zQF4Ql/LqadVF5V7ZAOQCUBoGiNCvYwdFaPEFFYm67NP8Am0
XDOodMR1mCwlvITppb88Vh5DXF1yzJkMIN80pq1LgGtLLwEuTleQM832zWmb
776RawKv06bRBUakPuBFDoM8tChInZuK0cLMbXJ2zhesOH5hgapFl/AgTDIk
UmE8yVlOe9gsPV+8iJrtGKCvQc1B7GCcuBwFlcTOz5Eyj9G+qnUxmVBCqdDr
MGoq6qL9obWi1LxKDFp0z0QZriZ1RDaN8+jAlV5WCY2jSB/l7DZuUYE3ExNH
WK0U1eVRKKNCygGh8Hqat2FcIcATK0vzUlMbThYpiUmyehfOkSSITrB/oXfr
bY7xOVzzKfzspy8jVgLjDpYlG3oBtlBtUol+DXvayDEEdHD6yoYRDcFx9zrI
Kofz6a5fJwoMVLbX3tYV6JNJzc35dDjMCqeY6yP/RAP9zN7mLRwm2KACjmcM
1JdZb6k4Z7w6YWe4jFBemT6MruTPS2dLlaANowYH6sty7isqc1gn+WoIvcXC
DnhOlrE9LEYRv0BapGG7UTTtySA1jFQQiXC8HphjrukOEQ/kos4te48DKv48
6+F8KLFONxXORwYdtgNOVpO0zXJm4Av5CtEItidkvciOwnvFUZ3Cle+HtqGb
Xkw87ZqZw+lgVcIzgkfAStCBWQD9xNj9u3RBddolToSDB7eXJeGyxLrKHvh8
cQeXHMj70/pwdSxJjl6Ug94cjt587z199KY33fJleRpanVYk1cOJd/m1Tfr1
shB1QB0CCLC6LlcqoRIK5+qUw5ryWnYHbGJwJvsFMrgZUe8LzMAvx/cxage4
RbANs37Ye5LhmsiiY4KonRuG7YoaHUBfzn4EM6ujAVnpyX0jmHNmd0nW0sC5
Bi9dTtuVV2OANzL7fzJH8c+ySnXOGsyT9GB9goM/fTu6rRqUjb0eY9cco6Zh
l+AQaDYl8lkeGKyKif0bqEPMb9++fTfw53Bu7Jgx6vm3/bzpyqwwurAjXp0i
OSGmvjkzSrgNbt6s8Cfo1gMunLMk5wzjcCxQWHpSjDHs9rLbghwPfstvG8Zd
Q1QSsX9Shhy4C3cOeXpYJAJg5KmQv8Edch9OBAIwkQGVg7C29ouiLezx6qyG
CmIgDwBf+4O5neUUqK8mhdDVkgXoSNUSyoRg90hvyoc+W9SB5iY2o6UjWuH8
enW28F1kk9+d0KtdW8kmhpzLSx9LLOeA48Sy92e1EeCd6/U07WxWTpkQrInk
SFtEP2DaIxj9/7V3nmFaFkm/f5ZhEsm0soY1rTmtrrvruqKiYCBnEEEFBAYQ
BiVLzuCQc87BQQTJIAiIiAkFRCUJC4qKCUVymIF6+9d3Vz89A+r4nnNdZz+c
D4qM99yhqrriv6qMr6RrhAmRSdIQRDR8bki4qpnsB1Mp1TfTCW3GH/a0YnQr
QcSAF5r6Vc1kAdB+JHnMAdcXMF6P9DUh7Vc3XCTfxA0nZ5nttyzxfm987YTf
2tJsnCyAaYUL2wOd5GjBsuchz5ewu5R2T6ms646/H1vBSi3LyRB6djKfF3gC
xDlun6bW32wN6YHKOb6S/OqlbpqVtoDpxmHGS+p1uhoeFI7eb07naJ35yyZw
0e1ldnNAq2LWYUAsjB/Bvkzdk7k641G7fXt+RiW2euf/lf3MuTZ5L1sGVfiv
aKW5sSKDqtqjvKLPw/54fTCsrBUaclPmVfR4kdMgV8eUV3378iWK2UYFsq+X
BueIXN9VD7fwa7zBd4BhZVVPKBsVjQJipK3ej018BEevv1g5FkomgTVumdEC
4bLxsW0fsWzdObtB0q/sWc6fkwpZWdZZS3WywWEb1qKE3Vr+2cRKhQKPHCa0
jlZfKRVY7ItEs6pb35q8CMBW8l9KBQYFEweBF9VNkiBcKNpxhV7XvXl9ez8T
gPg191iFPizANnbG2DgtBBAS6q75twaUUnYt61XS7tpdPria/Lwi/dcWu5+z
JAQVEvlNu/Eb5c1DCNt10es7g0pbt8k40TGlgyGJldvOTevGQmXB8k3gJOZ8
6CeSZqLSwoiqXmHG4YFKtiSh1zF2vpIRCKMg/C1x7kgXIhjvD39cSWFXKTW9
2+aYdk2qrDzbPqGijGhVUka2elj2zE1L/X2kiDSn3VYOTVQ+9ho9ykZvclof
jSqnz2IbNFtxKc8Fb0YqCO3GxFyFI2FWjbUlDGXRoh4AcvyXuU7PHsFBwQix
ZUbp0rd1Y2vX+nm6JNh4Fckc+3xJzxI2fbB3zsSR3hVS4Vg9gk1B0Zk/fvx4
zg/PK3VObuprLcqbo2r6m70/obb0SrtPlvQsGVPSsO8Rm03t1O+ej5iGSDeL
NtUraUiKAH4wesR/MnBbtCfZdSUNpWIy7FxxSRAmQJo+LdM8aQh68cMJ9ZQ0
i3uUsMmOdweXjsUZWEXGt39MhrcsibAUcB/0zaImktm/tuzbt+/3TGJLtNT5
Zk1nGd25ikww9923sEmsQCBDQ42iwqHcq8Ytei0ifnOYYuEpb1jmNuvyG0UQ
UglTVL5auqcStb5LjAsOfbo5KunqNxA9SiXiZDZJsUZEqYSbzfnFz9NHq91h
CWlwqjj+sHiRccuMmtBvendcben7fGlZNqY+rt7vydgbUpkbnNjYR1aMb2hV
zjvjaul98fxwH1k/++HwsoUCq4QScnFBEcdZ1mBhU6khKq2AAJD0w9ooDcjm
YZWuNvFuV3/YMqzHAiRLryNnRE6BwFNpxcFCokB1KK1YX9e/wd+tD7zvpWpq
m9mM+EqvCtY+fzqznmrXrxc2lul9a8qw9hVlz/L2lgB5V0z5HcG+eL2DvQPS
Ze6oBNs45Wnp3eg+WzsxR69gIN8Tnv+3XQLkFVSCrb6DlzQuqicY2x85Rgxx
VkJQxiNhAMq4S+DikRLlij95wg6zSTbjGHmCseUOGTbxdqxIoJ04gksDRbFj
QiUZ/NxDMqVTaTwZ/aC3x9aSPkaylo9rIMc39Lby8nsgKFArkd/04rVmZE1E
1+v0bxc/K1M7R5nkT8dW0PNIXYati+RD9b3Zt0Ykx7IopRdYNJxAJlUrvVBN
f3YjzToF6WKtLeh1aD9mvYO50PtR54ReAG70uWwRhV5G7r0h5md8zhtGmyux
0FeI1oiOlRCQ/L+PWEmOWKdeaiY/tS4nY7pUsdbzqwWNY6oRjdttfQ6jB/yb
4DFjf1b1q+LfmI1t5GwAZuuXEXmS7sFBVIkBwImKItWolKIJoEw0dNlfx9h+
jiJFjQsCd7lx2dtzcIjEC3aPXasq/GS4Z/cqLxlNH8A7DI/Kiy3KWJ1l5CPx
fyNZyXJybgs5c34BOTm/pdX6b05pbA/85ml1PNG2ZT5jD6VR8Z5oxK3o3MW9
KviXJ9WH/mIron4kARc9FCExqLuS2qFs08E7Ub1s7ZLR2n8KYgz8ySEdm/v7
8Yw0I14wS/cWAtBiuTce1OfTqijdjANsDdXkjqVwhFIDnbxwRF3p16qs7FrW
Lvn30S3SX8Z/WN9TTl9/iWR1qRJ5E6iAJW0tR5YMqMIJjR6YgvzZ9+AVcSfs
vueZ1eSnrg/JD6PKJTuKvj+0jBXN2Z3iioagDe3PMsjzA/cLH8PE8v4govmv
ci207YNKNigTrijqrqP6qYUwpSiL0SgEsiWucODeDDfxpcuKJLt1zT91M29M
EOc2VrPtFWFZNayGP8O75zS05/elfrXk4Hs9Un4feWP2EMtrYxvI92u72v/O
fvI+OV3i1kRH5B/f7iZju1a1J/uLeY1SXXIBrs7qUU76mOhqy5jycvLWonK0
7A2pjrhGMUrrqrcQ8njiYn2BsGA9lLgkOyA4ZlTFkAm8IEQh6wuKcq/byRI9
JC49LdyPSqsSF9wg0XgorqT6cMAhronYU1wt/IdhZeR0YUPkTsUhqHVTtqjZ
TZB1Y56wLsr7maj+SAg/fLk5iUFLuN/Ru2bY8dVM+XRVhvR+rpR82ra8nLm4
iJx8s0uyuy9KAN1snhkLDdn6Wy6R/TdcRNm+gCMsRV0I26/hfb4Y8aE5j5+Z
gPtj42No9YlSoXMDPbGB5xFX0qGuxAaqd5UblNA28G0IJEgN6nXoFUxPHHeb
QN7BEtv4M/65VJ02967oshHRz/B3yEdgvlVZ7O9cXI4XSJLJT/+LbJMqix+N
WM0Z/JQMeaGCfL26U4oTQiPYMntMcxnZu66cOnXq9/iLhvTcd+0AOVo4VRbV
eUD2r+um9/1yVUfrFRGZmEenuLc41vxBOXn5+TK44b2ysNtDBR3tMQx4liZs
iyU64SKffOD2y+XAXy/nvxPdJ2vtGPIXchVwahCvNokn+oC5uHKGl2mGLBS9
s5JV1coOAPTkG0PZpy0N7Aj3134rqsYKjdYsOQBAzMbyvpVi+m7bjdtL0cj8
6X/GDnY85Nf7PhLTDBfpMyLizSYkzb7sPDk4r1EsJdA68OiVQU/JkfW9lJ7b
FrWRjA415bUZ7ST7i+m/3SkGdww3H/6byLPl5e35Xa1CN4o9prc89mFvmTvk
aZtmMf5KlJVLliP9Ksvp81Pl0LQ61o0ZaFj2snFizQHPURgd3OgfNsw2bn++
c7NMTxEbPCl44lxpYXR28/q2bGT+jGlamFOgFUZdZOjauXIkzkl7XhVt5ou1
DkJ0Ktc4y9r2RjMXzUphxZI8J3aD5kV9LoAAys/jgvezO3Aq3WGji+RzsFdR
AlQccAjXDnjMsTcZl0cynn1AFhvrSe7iRJU7Jetvf5aDrzVzuc/IfUNnGcXn
GYJvvHxmOxnYpbbseXeI5eEvpBCLnJ1sPnUq+tMoROlTT+T2a8QImv377ncG
S/9OT8gbkxupwl05IU36Nr5fPnu5vhHzKB46uCLdvu/hyU/L6fNS5cjAqu7/
5Zfvlzxrk+Bjm99DOFXAFV/wAjCvIFOJkXNJgJb9yLgDfRrnmyrNwTB671iB
VJAfMa1zkGMjm0mMWDjgIlvl1vz1Pl+2Agpkk1fBxBrmuGmJ7HENjUqk+/m+
BYOWCD30Kim0/NHSNqpimn8uSEgUDeXe/C7xNaVjcwtSoJBtlI5+CmBPQlEy
1akODBQIiy2LaaS1fliZWMHAUXJxdpwJy9Ml6x9XyckKf7XMQGiUCaQDF42s
JwPblJO9Kzuo3JDfGNP3GZk1qpkc2zk5AZ7nvYA6YYLIokViwhiR8wuJkeRY
gtPth7ZPkEkD02RK7xry0zvdo+elyEfG0yYSxJBa+a5xlxycUVeyLz9PjrUs
mT9wT2d0LWuLcybsLeC8A6qyY4x/u+auK+Sn2y5TUSngRIV0B1FX24a1ffWR
nX9vGn+EhsBXmzylkALSbYQsdXQujCEfqJZJJhgGlcAeQnb0JTuO4r1f4VAS
qa4XA6QDey/c5gcFQACU6H9rKQZE+4UlTL2r4EZcX+R+nTlCjLRhXcfNVfrq
KCKwMJQAWYyU7HTX4Grptn+P9rKMmq0KBuYfoFKEZ4v+Pb57a7vsFgW5zojg
+B6tPZSHNAq4sxntHou2jJv/o7L26ZN3y9K7LkWuvIyREMKzNaFPLL+mUOc3
kuwrL7DW+Hjde+SwYSTB98Qe1WVq78dxCpxSSpCNrzxndceGZb2wJ78oWSln
S1axYiKXXy5y0xVihCDRCdWZL2fIG7M7Whfwk/ktU1za5SvjMAxuV14WtH1E
ziTmk+y//FGOtSiR7PQlkQjlD8JJtUKHHr9Nsv8Qk/V/u0I+GFKjkJMgoDg4
T3S36MGdZkQFUBRLU2en19ODS7WDMQsAuhWqwT6StbcXs92k/R5voZ3BJDVp
riXzkuK4T0dhSyMBz97zNMKjhXmERLWOFvAZl5h7qCDoC8b0VHuomR9ixQQB
2rJ5qL4R4KA37rjfSE9RlvrqG3VLf8YqS1qe9IO23H2nZOfLhznzSpUkJevU
R6U/5D33ra2Lyb4iyZKVYlS7g0uZS18bXM1aBeOEOEuVJIdeaSCn7rlGziQl
yKEHrpMBrcsR1ajyOfpBL1k0pZUM6/G0fLtpVNKviEiuis+OHVrZl/MKyqnq
D4gYR1S+nKGSsnf9MBnS7Smr8k5s7JPsJOWwCVi3FL/ZFqZtcdpI/tHu5VRS
0Er48SZojvmIZJSJDJITolp50YIy1fjSxlypxFDMItNGjSOfVuJ7tpHPb7xW
dt1+k8xvWFv9AqpKNNpF+J2IESyKxkrxNz3WYAeuKBENJno+8FHIDADo1OuQ
tg7GmoX3o1NCSwsKs6Fc/pZxS+kTNepQXRcKUuMiC+OAAYnW0sz715/lpKEL
H3z0kWtjGj2SBaU29/XCxp7BB5c2lVPFr/f0zM73BxNl1lcGE72O7ltP5ox9
Tk7unppsmZMghw8fzhkQ/Ca/27e3DCDJkJokX2TUt3dKcsw+8Z8pMn1oE6t/
DIc1BXbSPP1MwWT7YseTzdu0KOHyhQm2MgbW+r0hpWPJjtPH77tKsi4pJAfa
3GfTvtSWTchQ2IVNZKpIuoPRwqNnhfmMtk0UO0lhC08Vva2d5RTFwNbjaygn
yfGDQuAKvY7eFppA4kFCshWiuc/W8YEJBTOKLbRPFHKOgnqQOAPfT6okR8vc
YBXg/v6PRRBdMqOZ1W0kRapg/7KmKeorLGgs3xS7Ic65p++PaeS7fXEbq7c/
WNIzpjw7unOSzBjfgVbOX6qiBDzLzkZ9R2fUXH39FXJg9SgZ8mJTWTqtDUGI
5x0qfcnUNjZuMc5IojuoWemP2dc6ffe1snFEPZt52575jLJvz9yG9qBS5U50
8rl/QCk5ZALB72ZUiyngGIdhSON/Uvl2+ivKzQJ+J0o7L1TmJrgm6lOmUNi9
0o0/aB4ewweiY6jXETFyP5oJ9X7ICmXvtQOrxQoF0Zx6cQn6zgNLyWHzs4hV
cYbhLlOd8QxLtg4cIRdppUPdq8mZQilWuk++1TWqVWG+5nSyEcAX7w/1jEMT
DurzrLy+YEAeKhTLljnMlPn1MmVEfv5Z5NAbcuKH5TJrcmcZZ07ewW3j/c0/
XNrLunNGYmIJzsU7+V4POXPp+ZJllP3JjX1s+soYa1u13DjlaWWh4aZ1YDmB
akO+nFHV1qpGNHvQs4vSA4gqIkAlLxtCVZMqTIoRRnrWlF2UNzTvqtdRO0ND
Up/X+6HECchBKRQK8iME30Rn6jUQsnQ0Tg9nyfAjxeU2KTDj5/KPibvtF59c
1k5O//0ayXq+tGZG+V+ZI5vJ5EFpcnjHRKXhO6+PkP49G8uuj2ZA13MxKEB9
VK8eHdkXXhA5fVph4fDovVUj7an9dFVGdOtky/sBnWsRvNniHC92amoTOTnn
+ZjmcKleZbQsI6uG14iFvCHztqb/Y543X0yraiFO/Rve52lE2IZOoramtKQx
FDVJNK1HhJjpSuf+pis2/MGqlmchb2jLpH+ROxUJkpHU38HT6HNJHpK7IjES
yg7Fgdm9yvuq0L6FTWRkp8r23Jjv9xJqguWsntW9dKqZWji5FfpIVdPxXZOt
0I8f3lp+/nJRyq9qvR9/NCHQ+SKZmUkBT77e8YoM65cuq1/ukBwERhP6N5Bp
fR7HAVKd+93aLtKpUUlZMaSaZwNAFmBSqzMe9Z+JRkPzTTc+vJKDbijEN6NN
E88Gtt6S1MA9jR+RnlEF0ByRZkEOt3i0fNxfx+QVKmShRgP8BsCLJ2qPBgly
crikEAsE6TjeeVLHUrG4tk6zrt+qiWk+Nthlzgei+f6iHjElzQ8fj7HUMqpK
sg+sTP1VbbVggciGDTHLFWyMofbx75fLlNHt5KURTXE3vI05vXe6vPVqFxnX
rSrxSbI7j4fe72nNDmWJA8vTFUH1+atp8sJTdwOx818FDgWqx0GUCRbfxhwE
yhJKJUAitCiF1AztSFNHdcBFALi5QudI2CWbxoHAddP7kZ0nAWIOmqc6hR5X
lvDvZ3MpLUtSSPZU3zm7gc3brZ+V7qn+ycoXbSpw9zuDvQ7/bO1A6dejkXz0
9vioI/EXSX7mjP1bASfgp39eJYtn97H53wNbxun9Xs9sb6Mxc6piyUG+0GaQ
c5Ja9czbg0r5TwFYjzBTOlVSU7KtH82Y8HqBfI/6W38M/S0r4BmxZxW31yTy
nOk71uvARNLPHt6PFnqgG28Nqu6fS7HKFSi8G4xnOMYEmksHVvWkBo1ITPrx
vJae1Ajc4K5PyvebR3tSv7V8mAzs3US+2j7bPOO3bLH5W8FAl3ywZozV73ve
HaL3M4fHsviL1zv451I6Bk/w02vNYkrnz16uf5atfcu4S7goawZUyyFalMvb
NKjlRRD3hv7mUKT5u9Ynmvie9CYWDxeKNLUNbC1YjiLeT37e0nlBcJQo+FK3
BKOWGiDwcYNmdisbt7UJlGRt8hOPQ6UL07Z4Smurw498NlGPfdbn02TO9G4y
blgrOfT1ksJ5IXihgOB7Psm0htlQWQm+bU1/6+9sWxR/OqlX6nzj2j0aL1ck
yNaX6p1Fc+BBdP6/O7SGp7lNORh69G3d2NMI3B2FhJp1O3ua09ZY1K00aBzA
ERjnAuhOr6OLqFMUN/j70VuHKgmVN9ADiuz0oals43oiO7N6lPOy/en8Vpbg
O5e2859M4I6SJegyilYJbjxDGTu0pbw6s4dk/bSySF4IXjjQ3wf2LpLRg1vY
eMDYYae/E3BnpWuLKiQPc/CcOgdaL6A6JxFFvaxX3CSBMwVVZKTbf71R5FZ5
U/ZUKgECYfAsSGClJqMEr3Fb4xoFeRZ6N0JJB0MOmiukuu32y6W8N40sZ4OA
eC4qwUZnIOPBs3gxf7WF1SjGO/Of/PO7PaznMG9CC0yaUuebjSOtUnl7xfDY
+XkheZGA5Kd+fF0yJ3W2fqk5L57kmOIeravJvGF1vGbBk8Iw/rC0qX9PSk7E
0WRM9HsmGq1JW1QobYCUSFeG9KGXlXGDIR2ZQ3eZ27qo9MaNAQXHFdqQwuwe
tH9G2yb+fsZ7t5aDUSQFAy9eQTcFgkSGi4b9d+AFI+VoUnXJ9q/rZm3bqlkd
vAbfsXaA1Qk7NkyLXZB3DW789HXrRG68UWTnTt9ahgGd91JPGd+vAfG10t6c
KBlkorhlY+p72s8fVscaz5D26yc8aWV956RK/gTjCICBeql9KU8D0uJ40DTq
KK0YBsBEC/LfFwWRER2DuIdpjvYM7rzfzQrU65jwobwsHCQKabcEoxk+F0Rd
6B6SJeQ7Qtoj67i+u5e/EAvdYfJ37y3s7mn//upRMqBXY5xqIwfnor0lfQGl
+PbtIhdfbNsG8gdqffXiQTK0+1Py4ydjleLGaFjjsWTUM57ixAyLor4V/6av
9q1oqWtiDU9xav8WcG9iR/1y8jLYPYBTSnHar6k+hpTEDWTYLLRu6CiuCxBC
aR/s4HxgivR+YAn65zplYD0BcvFm+n4W1WkcctJ2KYFO75vDjBm/5o0odxAm
fVbM7y8jBz5H9BNJ+28N5UxV2v/wg8g114hMmRIL46ENa8daH+bL9cOU9kRZ
HAAj4bF8iisyyv3UzGY2txGCS4Hxjo98G/2UOb0r+BKzfrLx3C2WzcQnnjSk
z0A1hgqIGAdcS0hq6vrMa4YZDRxLSKpiZoFlKevoN2JoWHgIqOvjUoXPxeST
0jBuo3+/j4wPQ12FVLl3hRe3sQoIhZ/gYGmnRteXk2s6R/kE8w/ACGKmj5b3
yRHbzJ3RXSaMaE2W5o950UkpyqUTJ0TuuUekUyf3s4hLOzfNiJTc2gFJLpNA
ipVyHk78yfW95HTxm+X0g7fw37GEgEMzXqxpbYRx8jWpTuIKp2JKq2JeDYBs
pcUz3iAfJRNwPg1VPYdopmAYUG7VDzeuq9zHc4g+SdD34XUmjrImnhqHcoiZ
D8C85nUtd5ZJ3jWpsucQZfgervIVuhbqCOV3acpT4xvKmfMK2D8/X9Fe8y/K
nFN7psrkUe2shTUO0cV5YU6yMoJo6/HHRWrW5L9TA/58s3OuVYQmmktyYA2e
NNyc3u/vuFKyHV+S3Gl6dejT9tREecToY0hZAd4w2sInSw+aoNKB2lwyMvII
8cyN9xj3HF26gR4wZRSwzifqdc3BADJvjAeGRfUdo/CvcttycHyd3bBCZRSD
OcD9hQJCugGPFcx/ksvZWzDesDL2vYHGgJ14Z1ytlCAG7uvyk0lOTOHV6SKp
kvlUybiER0UEDtGqRQNBvxfNO68SOEDRQTpxIkfI9sOe+dY127S8txamwFWc
fvhvsvXaS2XxsDqqfQkisIHLBlWNaYoeBE2/psXlNfONx4tdKceKXx1TnCQT
VKDFrI6lPV+A2YEuC+kYHaCaOehN+84lTsU9E7TvwJvwuu7P1beJ7dwqjgNk
bHuOg0vvDm0qOpACgCQ4PhBlwJUWD6gS97XmptmolWhZfVuQ8JOq3y8nCxlF
9EqnRGccju2cbCOKZXMzYpfkhSNJypGpU0WuvhpD5EKMiCM/fr7AZsPXL+6R
oDUkkC6P3CXy2N8la+ckm541R0Y5Q6wDGs34Ah5o9a1R4F8VLSz7/3YJvXwp
gSsAlgPonQ6XYODE12Vus1VUI+Rx0/OonTgFpS84S7H19nwBQl3Bjd9WvhAZ
EqtwJ23+pQWW0j6DbHam3a+sWWhEh+MbIW6itwRaCchvc/W7PEtIlJKhI1ek
tVKsDfqMJINhSYTweKVTQuAz4RusXDggdmleWJOorKFhEb9s+/bYefZnhS1r
jJNhK0TgzSwSKeCLopFwjXEWFo2s5x2Xn97pbt/9vfG1XV0y0aISTl9cSL41
3EC3754S1+00w9ErG5XQotoekyMYC/KFcZNp5sc1Ns6WSj3JVECB0D+fNreZ
U6ToMsX9EBUqSqRuUDIC3/lMswEOSZZkx8Uyf9n9vi3Hm+gxEo4k25hJv/km
E7wwz4LJB0aOFEv28ejy1uOMG6xEi5UFtQkkEMzYweXpFPm8rid2I/0aenu4
EsZYxfI5Gx8w2RKbTDXp2DeXDYlddm4On6PrfseO+HxePPCiRpOuXh25jzzE
cPrQJ5kyvH9zWTurfcjhmIoWqhhQknE2/AuD8SDz8vH0ug7TlCoHo8Y+Odq9
rFE2KXK0U2n7d4JppD70CUESTWv7aI4pOJxNaAuNt7V8OF/QF0uFKa73Em2D
TY06HUF1yNYrb5QN19/pcYa1G/Sw8FD4rcOhmZRR1mXIagSTb3Rgg15HVuch
l11T6WBOPhgkBqMjJUwrNee9sIPAUaxCyzCXCXTYBvMnw4aQXyPHiUH0RZft
WwNKOSIUlk9m1LX5VjrJD85rZJGFAMYA9VjAmLE4/InLRjHLxEA5IjLiA5zP
/Ko6ncScymwvQzOaybsrR4p8+eUvCEsuANmmTSJ33BH5OUG4cKHq8ZUrReqU
lSN7F8q2666Q/XffiJCEloGckNHU7hVTbOsBXht1k2PpD8rRnuXleP175fRF
BeXwyJr5AoeUZJ0JG7x4kOAnj8Fw2XwODPHNwzfJdhM2QFgIzFiZhIC6dNfT
61zIHVuAQvOMw/nBBUVlf5ELZdojtZi5fb5jK/VlUklVSzSTqdcVk29TijBn
XGFj4A9ZsjXklkc98od1oqyle6hUOwcbS7YL9Fg3x/azFv+saZe2Ml+nau22
bsx2oh36z0j9oynJMu22G+2IGdVlZKQYW+dQ6vZLjfB7RfN5rX/KtlYPx/IF
MSUZtNCE0FRCAGNc4vhhfK2ZBR4CDrO4n39dbf8kjkaWTHTgPVIyK0T3xJpJ
TpYOT21t33dZiydE9u4VufVWOrt/wbTkgoxVqxZVRSdOFPn3v0U6drxQ9U1W
VnSrFONYPPR3OfnoPdK9zVOk532yi0QxsvTBrObe+oFdG1vjLgtdyrrzz5J9
3cVyKPOZ/E6GvlvyrPXNKM2lOuzuqhcfsdldZGNfqVvtGx3+yx/trClF3dNl
TUuVCUT8+o1ZxrocvPB8CzCbfPvNUqtORz8AhlxjupGAdYbb4254gJW9HgNW
vEx76XFHBal3XwMnMfntNCdW6abdWw+JioQmyc7IZ879vCvvkjnmH5aLNWg+
WJ/SssS9djQ9b7zp/n/lQDMzG4SG7UhSovkhVuUUvz6a31IwST7pWi5qKq1z
JxkoFRNqgRTX6IxJdIghcINAwuyYlTuvsnCGI+t7qWSQ4yTnRt5HY0/sENpl
fc9GIhddJFKxYsTtoUN/yfMIxGPrVpF8+aJfKFBApEsXVM6F7jIZNsxDYKwG
mt5NDhlHBLv37oJuKiHfbhplJWTTnOedECfZ5qcjV17kfz3r5kvk8OgnEr2X
G3UqbhxRzklIkq0nvX7/dRH0zEnH5l4V1LAT9DRzeE5dwwPK6ON//13eMULD
UJLeJlAyDr36ghQNWW9GMPx0gFJ+xOEAL1CbYnx52nJYUbO8ViW7pmZ11TI6
d4oiO7hHxoiqT/R5zX/4ITHH/lhIXqx+Kx8TwsFoKos84uibQYEff+bfHBoH
I0mQw+3KawLDYw7wqclkk1nVCBZ/0lIdG8L5b9LE30MuuCCqsJu//+k3fc0n
n8RARb/4l7+gDPhl52u63BQ3NFd4hFJ+8xs9G8vBrxbL4L5NwbXEQt736/iE
jfsVnpT91H2e7z9fUECOPfeQHFzyrCL0jZNiB47hoaVob02re2Vv0YKy0ViV
j3tWSA0MCZQnmC6cIy+VMzigiqzNbU85RgOrYLtEeB2/i7saDw4SbN2e2R/R
4XUHeXhNi/3dcvuf7ISW76ZV9eqdBgOUG8lmD+WcWU8OlL5VTuWPztKZVHMC
FrZWjpL7oSI0b0ILz1FMNBGC8R9F9u8XefDBOGPS031g8Ouh9q5dIgkJ8V8E
ZDF9ur0i4qgJuBs1ih9i/nnsMZEtW6Lbu7oSYfjmFX09V+lrwJ/8enUnl8BK
svk2juXpO66Uk/1rybiuVQjINUiiJ4OhoJG2j7j6/fiK1h/HIXt7SA2Nu2jQ
ZDpEyIUwl6XcItF7mRs086TjKg3rTKalw1avY5IGLmh4P4Y402ZC56wOInuj
36MWpPNNNGBGswW0ZWOvd85u4DJAyRa0Tdj08aRGkp1WQs4USY0+/MPejiAJ
tqhKje/03umxxMA5JyQn7vOddJmZIldcEWcAx2nr1l8/qg0aKEujf5cuLeLa
+M7TgBEfUZX3TTeJLF2aI5W/f898m6jc+kY/NRaGx9K/dVnbIWnVzptdJLvG
PXJqcmOfXub/kYCgvVcTYgeWp9vCBIhCVXFMPaVwFQ0si5fIcfwo1xYOkl+a
R9YZePFiSobnLIgPhX4qZykaIhkhZxn+DUoxfC6QJ4I+JkzpOQWKQLc93eNh
thUs/mtjG8TT6SZCzjI0yepR3f8MeAIlD3AyylqSiKTAyLYkKguOHhXp3Dny
n2BD6dK/pIIdSi0xMS4HTG0aP/5CZdn994tceGFkdLOywsLA97vnyYvdG8qu
dYM0Ibd2bmcbtlpE3cY+inE0atjGMF/Ma+Q/GlvbxVUhlTjg1dDB4Ej0WGZ2
iGfIlNhAP+m3DJlCrH+NW9Bb2zEPBayQHWUyvdlkY8L7kSGj+ABOV5/LTDtw
JKEPPadPBTuxIMzKglYHxBy3lYlxCOXKFy2exNhJzzCS/+SXVy0aGE/g79kj
UqVKRP9ly35BubrAXflUooTI55+72MucxTlzRJo3t2YzTDzv3fqyNYUK1ncq
Ank7ZtSGOnHvzmwm/ZsVp/HLfxoJCmJwYnIlAdrqBeNlUCBXUjFihnRISFJI
rMllJT0D6P8cjR+N1fKtM32c5hziWQlsSOEQej92BjA5MjxfwGEo7QFB0fez
wwXM+ccO6ncYD9D2UNHnot8LzBJUFVAfpQs1GdL+zMzzFUlCWgCcWVmxs2oB
F+mB++ab+CD4CHXl/p+5wYED3moWCPiyZf1kWzE+uG28Pv/l0ekU79VXte9J
wz+BL0AD/Z6J5khQjQlFk2TuxFY59Q9DcoF1xntno6OjJU3lC5BO7RNXvpA4
KeHGZOl10YSSB+32O70fTfjAScPnMrUNGC7jIPX9GISCCvh0Zj3/HQARqM7s
XdnBfy+4TpJcoN2ULpQ00XFZhgeFlKzEiEeO2L/ZI5BwFl/MRa1bR/zYuTN2
bUB74Luj+tTDLoYmkp6WDbOf8+kTjjXz3VzfhA8iKc2uG1jKfxtT0FBlQJH1
TFDmZXlM2EMMRIjlqMBsVdYBSvwlGssaeyIYeKgDEJT2jLxjTH54Pwr41C6X
mghAn0vYz2TVUDYoJFEWD7+D/nCAlDSkJgUuPvYFfKfSngI+DuGJH5bHrju3
/Bs6jx6trnx0kaPz0jkvytTBjdF5Smdz3qw6omaaFGSDqfhsCWSDKpBW+PQ7
GN1BWIvuUVkjo0ZhiwZflUlmliiEXOnH4KrLne6p6aFYTvc0H+yvs9tFH3nA
wgD0ftSh6XgNZZyRgJiqvdPjPviq4TUstik8qxRfwTyFZ5pzvmBSS+3ZjkAq
G6bZ+iBl++t/M1zydE6wdAbxbEyvZ9r2N/tbfLghrH8ocP7cinFBRmWL/AmF
hSTsDJdr0o8FiUUnVG7hQxmARlHi0TQHljMkMoKsE8P0OnAVIInC+4FBxzVe
7QsxUZUK1zg8bGT9aEvYMzfNf8cHs5pbYT4SVFBxRYhXaVxRIgO7wvcEjXJD
Xoh8vftZ9oGVMnFkGzDhnshrXulk53kc3xC3opRtM7uXO+ukUeJ8f0gZ/xGb
R5W3J5eSXI6o0oQkNDmo5DHrnak8IfHoZbk2WvfnG59poyeFEF5HryBT63IQ
udmDFoQSMndJz5J2jHoOa9KqJNPqcnwH2rqvi770e8EhY8RCBwdEIZEbcKsb
807kSGMc/XaZLSj5gnyCHVfx8sAn1bWyz8W/hOFvj63lhQCUKS2jAH30O0je
KIhSv5cJSbmFGWhVhBYZ6ukHqOfKh5/PQWe0dV3X+qelBJZ6EMGH96OxjC1b
LKQKNRVWYuu4ijk0BrC2kM70UZNhY16K0vlbExGhNb9cP8zTmQwoQd26FcNi
N+WFzjcEdP5211zJ6JHGiQgdUw7MmsmN/XOp4GChd/kgNMHKN1FWPKROsHtU
SMUDTA69ALtprFNck7JPWi2b0g+5vdTt89SyC+N+AICH8szvdozG+3o6U/bJ
He3xbi/lej8sdG6lgWcFBjiUKzDvWMAwlwQcGc8Q4uWJzjcGdN76wRSNAJTO
B7aMs7wMvR7jddhGmHj2JvI08JhIRqq8MNBRYZr6vQDt092wBaULuQf18pTO
IKJIOwIVVDqTqmZ0bHgdG4lZSQoGR+9HFzq8BKapz1UQnV+KgaFo+4gdgRrK
85YFrezIqtD7poOYBtPQAho5trBvvLyb80LnmwI6v7FksEwc0DD0NMgqDDU6
wng1OfQzE8nC9/tg4pN2+NLXM6t5eQGSiQeLZxVG89DFnG0vz8BZ2a8Z0g+6
X+P2/lZ3dOZnwDL9dflAZOpd0FAKnNGn4c+zuSWUYlqdyXfgX+jbAzghL7Jr
Wbu4qTdhJ75smCf4bON0618c+npJ7Ja8UPfmXP7Fwsmt4kfCsE4DFT06dObw
IqETh6rIfCHnUWRwMsCK8GPtSp9czi1tOdqboKQFaXx5sQhnUU2BfukR0I+5
v3odA63AXuIUehHu1tL6F28E/gV7bGA9AaS+H4iknHm3qD+DaXXh91KNJ4D8
7qNRnsggsGnLoVfk1rwQ+Rb3MyDdoOjxvPVm4CaG96xDVctzllEcA9IfJPOV
QwLQbdvGx+0K6EWGSsWzxxGsGqIQDSpRwNsxECEkMvZNnbhqgROnYwr0OjrO
tMGnYOApM7EpfC5OHB1nNFXo+zFMPHdkxUww7B7+lBIZiBWoAj+NIhaBTyk6
0Pt0W96JHOkJI/4RHvnDEXo/w0CbVTa2ztN5ZsYT1jkO34/285yp5AQ7R66V
SxypUBEptG1YOwdd8MW0cVLpx0zKayva3Q+xqo7Oj1VI80Bir7cNjaE1d9IC
H41UpK8pfetzV/R52OOG9P3AP9LZF9oVxqDyvcDm9XsZQ8Q4mVAfc+jp6oN4
eaLzrQGdt3041VaLDbNCfUyP2eH1PT1/NfLbMau+fz+yulQygAyqvOCfsnQs
lCt6s9G/ZCOUzq3rP2GbmkL6IbcKaVQ6I/N1nB+no6IUXh/aPdpBQPWEz8VP
J/Ijq6t0BnLJ3gDwTKHSYHhqqDT+8/ZgC8g4tnOypzPFM+xednZ27PbcdNbN
spJ9Qo4cOaEUPov2twXa+rVXM+gNiYXpPir64YvgcDDpK1QkQJx759KGgGoJ
r40z5wWNttKO0fg1L5BG09rZPHTsKeFtoeTeOpbkVRzhSbFzXcggINnam6D3
AxtHMMS4NX0uzg/DYXNYExOk0HEWHlRgAKD/QkXC3Du09Z53h3jCGy1ttfWB
vYtif81NeO1RPfHZXElrnilHHKUPbl0Yy+eWHKT1Wig/OgbkOwdTbnc/o2eE
huR3FnTLUZJBEj5b0tafQrxR2hXCj5nUsZTM7/pQjo9mrQqebyiV5PoAKdBy
r9Jbp3JpX5NUKY9C9Ao5mAK4VEN0D5AyEQ3jqUOmkBZgkHH4XKKazg7YFppQ
h+nJYaW0OUq/l8iOAXcOZeu1O9Xc7R9Ojd1xbqakypGtmeanypR9MpSdt7s5
HSdkaec06bx0d+xcmzhvDzQU0EW4b0Iqn4NZO8DmifEYc7s1DE7TbwGKhcXd
MaGS/+b/TK58VsRHFzCr2EIa0nSmeVWltc0Blo/mO1d2PIEfGikp7zLaNLEj
ysL7kVOkUYjBdfpcoh/ND+v74Yox0DuULVozcrs1Hy3vY1OjYdrkpYmdZPm8
fpZ4v8yTzwKeHNksbdMm6OGQgxtGS9sJm2Pxxb2hvqIFfN+GEV5f/fjJWJ2h
msNQxBeyRK/PeFqCkNyB3mrj6IQiCgadrtbQIDO1V5GgSl6CzutcYkXZgNFm
uHZ4HbrODZTxbOAYAEINvVqSPMBpwveje/rnaO6ex3qim2hECNFWxj+xpb3w
aOC7fPefV+P6PvEcbMjenZMNnZsHbNg8Ic6GXEfD/rtSbuZG5b6Cdrtv/7ZD
ZWFmr7g2NHdvntZWtp6IbmFXa0/7PXePoPgFDPMzo9JJ27nuSB+UzOZpMnrd
PvPkfXal9bStB39tl3D4s4rn+FmF/4OfnTWgNi7yCy01DrorT+xdJ51dCajz
hHVGGZ37Bf+fvPSv7ZQ4u9P0XA2//7uf/bff77/9nf8/I/+LnvF/n5HCD6oF
P4394X8Axg30TQ==\
\>"],ExpressionUUID->"558f3a92-261b-4d2e-a397-4996ca9e95ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.6564309184720573`*^9, 
  3.6564309590852246`*^9}},ExpressionUUID->"340de75e-0cf0-4e67-b07e-\
2480c95d9f20"],

Cell[BoxData[
 RowBox[{"6", " ", "x", " ", "y"}]], "Output",
 CellChangeTimes->{{3.6564309345762177`*^9, 
  3.656430951976321*^9}},ExpressionUUID->"922d2f17-0d67-4f98-aed6-\
3f92a8d154cd"]
}, Open  ]],

Cell[TextData[{
 StyleBox["3.)",
  FontColor->RGBColor[1, 0, 0]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["F", "\[RightVector]"], "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"3", "x", " ", 
      SuperscriptBox["y", "2"], " ", 
      OverscriptBox["i", "^"]}], " ", "-", 
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"], "y", " ", 
      OverscriptBox["j", "^"]}]}]}], TraditionalForm]],ExpressionUUID->
  "d06096f2-783c-4f4d-a3cd-3d994898df2e"]
}], "Text",
 CellChangeTimes->{{3.656370248623249*^9, 3.6563703431699963`*^9}, {
  3.656370379052232*^9, 3.656370383265421*^9}, {3.656370436613409*^9, 
  3.656370437116877*^9}, {3.656370627431078*^9, 
  3.6563706287172747`*^9}},ExpressionUUID->"afc888aa-2453-47ca-b0f4-\
59063e4ccc54"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v3", "=", 
  RowBox[{"VectorPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"3", "x", " ", 
       SuperscriptBox["y", "2"]}], ",", 
      RowBox[{
       RowBox[{"-", "3"}], 
       SuperscriptBox["x", "2"], "y"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"VectorColorFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"Red", "&"}], ")"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6564313026682415`*^9, 3.6564313043860106`*^9}, {
  3.656431391052332*^9, 
  3.65643141050928*^9}},ExpressionUUID->"06c7966d-d148-47b5-a355-\
c962d5dc2d52"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
    {Arrowheads[{{0.04587368524026638, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.285714285714285, -10.714285714285715`}, \
{-10.714285714285715`, -9.285714285714285}}]}}, 
    {Arrowheads[{{0.036619572141288165`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.475218658892128, -9.183673469387754}, \
{-10.524781341107872`, -7.959183673469387}}]}}, 
    {Arrowheads[{{0.028473340174100647`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.635568513119534, -7.653061224489796}, \
{-10.364431486880466`, -6.63265306122449}}]}}, 
    {Arrowheads[{{0.02134859125293253, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.7667638483965, -6.1224489795918355`}, \
{-10.233236151603498`, -5.306122448979591}}]}}, 
    {Arrowheads[{{0.015124736040578417`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.868804664723033, -4.591836734693876}, \
{-10.131195335276969`, -3.979591836734693}}]}}, 
    {Arrowheads[{{0.00963874482526197, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.941690962099125, -3.061224489795917}, \
{-10.058309037900875`, -2.6530612244897944`}}]}}, 
    {Arrowheads[{{0.004680988289823086, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.98542274052478, -1.5306122448979578`}, \
{-10.014577259475217`, -1.3265306122448968`}}]}}, 
    {Arrowheads[{{0.004680988289823097, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.98542274052478, 
       1.5306122448979607`}, {-10.014577259475217`, 1.3265306122448992`}}]}}, 
    {Arrowheads[{{0.009638744825261978, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.941690962099125, 3.06122448979592}, {-10.058309037900875`,
        2.653061224489797}}]}}, 
    {Arrowheads[{{0.015124736040578445`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.868804664723031, 4.59183673469388}, {-10.131195335276967`,
        3.9795918367346954`}}]}}, 
    {Arrowheads[{{0.02134859125293253, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.7667638483965, 6.122448979591839}, {-10.233236151603498`, 
       5.306122448979594}}]}}, 
    {Arrowheads[{{0.028473340174100664`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.635568513119534, 
       7.653061224489798}, {-10.364431486880466`, 6.632653061224492}}]}}, 
    {Arrowheads[{{0.036619572141288165`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.475218658892128, 
       9.183673469387756}, {-10.524781341107872`, 7.959183673469389}}]}}, 
    {Arrowheads[{{0.03661957214128819, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.959183673469387, -10.524781341107872`}, \
{-9.183673469387756, -9.475218658892128}}]}}, 
    {Arrowheads[{{0.02888838487433681, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.12161599333611, -9.021241149521032}, {-9.021241149521034, \
-8.121615993336109}}]}}, 
    {Arrowheads[{{0.022158516676423726`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.259058725531029, -7.517700957934194}, \
{-8.883798417326114, -6.768013327780092}}]}}, 
    {Arrowheads[{{0.016366937576713543`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.371511870054144, -6.014160766347354}, \
{-8.771345272802998, -5.414410662224072}}]}}, 
    {Arrowheads[{{0.011419136765807681`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.458975426905456, -4.510620574760515}, \
{-8.683881715951687, -4.0608079966680535`}}]}}, 
    {Arrowheads[{{0.007177376926577087, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.521449396084964, -3.007080383173676}, \
{-8.621407746772178, -2.707205331112035}}]}}, 
    {Arrowheads[{{0.003451490043452218, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.558933777592669, -1.5035401915868374`}, \
{-8.583923365264473, -1.353602665556017}}]}}, 
    {Arrowheads[{{0.0034514900434522225`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.558933777592669, 
       1.5035401915868403`}, {-8.583923365264473, 1.3536026655560196`}}]}}, 
    {Arrowheads[{{0.007177376926577087, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.521449396084964, 3.007080383173679}, {-8.621407746772178, 
       2.7072053311120383`}}]}}, 
    {Arrowheads[{{0.011419136765807662`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.458975426905456, 4.510620574760518}, {-8.683881715951687, 
       4.060807996668057}}]}}, 
    {Arrowheads[{{0.016366937576713567`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.371511870054144, 6.0141607663473575`}, {-8.771345272803, 
       5.414410662224076}}]}}, 
    {Arrowheads[{{0.022158516676423743`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.259058725531029, 
       7.5177009579341965`}, {-8.883798417326114, 6.768013327780094}}]}}, 
    {Arrowheads[{{0.028888384874336835`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.121615993336109, 9.021241149521035}, {-9.021241149521032, 
       8.12161599333611}}]}}, 
    {Arrowheads[{{0.028473340174100664`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.632653061224489, -10.364431486880466`}, \
{-7.653061224489796, -9.635568513119534}}]}}, 
    {Arrowheads[{{0.022158516676423726`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.768013327780091, -8.883798417326114}, \
{-7.517700957934193, -8.259058725531029}}]}}, 
    {Arrowheads[{{0.016717815320796758`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.8825489379425235`, -7.403165347771761}, \
{-7.403165347771761, -6.8825489379425235`}}]}}, 
    {Arrowheads[{{0.012110900511845513`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.976259891711786, -5.922532278217409}, \
{-7.309454394002498, -5.5060391503540185`}}]}}, 
    {Arrowheads[{{0.008271518207665708, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.04914618908788, -4.441899208663056}, {-7.236568096626406, \
-4.129529362765513}}]}}, 
    {Arrowheads[{{0.005092763532356943, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.101207830070804, -2.9612661391087034`}, \
{-7.184506455643482, -2.7530195751770083`}}]}}, 
    {Arrowheads[{{0.0024110776141148056`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.132444814660557, -1.480633069554351}, \
{-7.153269471053727, -1.3765097875885035`}}]}}, 
    {Arrowheads[{{0.002411077614114811, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.132444814660557, 
       1.4806330695543537`}, {-7.153269471053727, 1.376509787588506}}]}}, 
    {Arrowheads[{{0.005092763532356943, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.101207830070804, 2.961266139108706}, {-7.184506455643482, 
       2.753019575177011}}]}}, 
    {Arrowheads[{{0.008271518207665708, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.049146189087879, 4.441899208663059}, {-7.236568096626405, 
       4.129529362765516}}]}}, 
    {Arrowheads[{{0.012110900511845525`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.976259891711786, 5.922532278217411}, {-7.309454394002499, 
       5.506039150354021}}]}}, 
    {Arrowheads[{{0.016717815320796768`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.8825489379425235`, 
       7.403165347771764}, {-7.403165347771762, 6.882548937942526}}]}}, 
    {Arrowheads[{{0.022158516676423743`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.768013327780091, 8.883798417326116}, {-7.517700957934194, 
       8.25905872553103}}]}}, 
    {Arrowheads[{{0.02134859125293253, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.3061224489795915`, -10.2332361516035}, \
{-6.122448979591836, -9.766763848396502}}]}}, 
    {Arrowheads[{{0.016366937576713543`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.414410662224073, -8.771345272802998}, \
{-6.014160766347355, -8.371511870054144}}]}}, 
    {Arrowheads[{{0.012110900511845513`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.5060391503540185`, -7.309454394002499}, \
{-5.922532278217409, -6.976259891711787}}]}}, 
    {Arrowheads[{{0.008559521444247946, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.581007913369429, -5.8475635152019985`}, \
{-5.8475635152019985`, -5.581007913369429}}]}}, 
    {Arrowheads[{{0.005674214678380669, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.639316951270303, -4.385672636401498}, \
{-5.789254477301124, -4.185755935027071}}]}}, 
    {Arrowheads[{{0.0033834479306096782`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.680966264056642, -2.9237817576009983`}, \
{-5.747605164514784, -2.7905039566847134`}}]}}, 
    {Arrowheads[{{0.0015596924307595727`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.705955851728445, -1.4618908788004985`}, \
{-5.722615576842981, -1.3952519783423563`}}]}}, 
    {Arrowheads[{{0.0015596924307595776`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.705955851728445, 
       1.4618908788005012`}, {-5.722615576842981, 1.3952519783423587`}}]}}, 
    {Arrowheads[{{0.003383447930609687, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.680966264056642, 2.923781757601001}, {-5.747605164514785, 
       2.790503956684716}}]}}, 
    {Arrowheads[{{0.005674214678380669, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.639316951270303, 4.385672636401501}, {-5.789254477301124, 
       4.185755935027074}}]}}, 
    {Arrowheads[{{0.008559521444247946, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.581007913369429, 
       5.847563515202001}, {-5.8475635152019985`, 5.581007913369431}}]}}, 
    {Arrowheads[{{0.012110900511845513`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.5060391503540185`, 
       7.309454394002501}, {-5.922532278217409, 6.9762598917117895`}}]}}, 
    {Arrowheads[{{0.016366937576713543`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.414410662224072, 8.771345272803}, {-6.014160766347354, 
       8.371511870054146}}]}}, 
    {Arrowheads[{{0.015124736040578445`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.9795918367346927`, -10.131195335276967`}, \
{-4.591836734693877, -9.868804664723031}}]}}, 
    {Arrowheads[{{0.011419136765807681`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.060807996668054, -8.683881715951687}, \
{-4.510620574760516, -8.458975426905456}}]}}, 
    {Arrowheads[{{0.008271518207665708, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.129529362765513, -7.236568096626405}, \
{-4.441899208663056, -7.049146189087879}}]}}, 
    {Arrowheads[{{0.005674214678380669, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.185755935027071, -5.789254477301124}, \
{-4.385672636401498, -5.639316951270303}}]}}, 
    {Arrowheads[{{0.0036110481092921083`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.229487713452727, -4.3419408579758425`}, \
{-4.3419408579758425`, -4.229487713452727}}]}}, 
    {Arrowheads[{{0.0020458671970891907`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.260724698042481, -2.894627238650561}, \
{-4.310703873386088, -2.819658475635151}}]}}, 
    {Arrowheads[{{0.0008971721158221315, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.279466888796334, -1.4473136193252798`}, \
{-4.291961682632235, -1.4098292378175747`}}]}}, 
    {Arrowheads[{{0.0008971721158221379, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.279466888796334, 
       1.4473136193252825`}, {-4.291961682632236, 1.4098292378175774`}}]}}, 
    {Arrowheads[{{0.0020458671970891907`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.260724698042481, 
       2.8946272386505636`}, {-4.310703873386088, 2.8196584756351535`}}]}}, 
    {Arrowheads[{{0.0036110481092921083`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.229487713452727, 
       4.341940857975845}, {-4.3419408579758425`, 4.22948771345273}}]}}, 
    {Arrowheads[{{0.005674214678380685, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.185755935027071, 5.789254477301126}, {-4.385672636401499, 
       5.639316951270306}}]}}, 
    {Arrowheads[{{0.008271518207665708, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.129529362765513, 7.236568096626407}, {-4.441899208663056, 
       7.049146189087882}}]}}, 
    {Arrowheads[{{0.011419136765807681`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.060807996668054, 8.683881715951689}, {-4.510620574760516, 
       8.458975426905457}}]}}, 
    {Arrowheads[{{0.00963874482526197, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.653061224489795, -10.058309037900875`}, \
{-3.0612244897959173`, -9.941690962099125}}]}}, 
    {Arrowheads[{{0.007177376926577087, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.7072053311120357`, -8.621407746772178}, \
{-3.0070803831736765`, -8.521449396084964}}]}}, 
    {Arrowheads[{{0.005092763532356943, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.7530195751770083`, -7.184506455643481}, \
{-2.9612661391087034`, -7.101207830070803}}]}}, 
    {Arrowheads[{{0.0033834479306096782`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.7905039566847134`, -5.747605164514785}, \
{-2.9237817576009983`, -5.680966264056643}}]}}, 
    {Arrowheads[{{0.0020458671970891907`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.819658475635151, -4.310703873386088}, \
{-2.894627238650561, -4.260724698042481}}]}}, 
    {Arrowheads[{{0.0010699401805309861`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.84048313202832, -2.8738025822573916`}, \
{-2.873802582257391, -2.8404831320283206`}}]}}, 
    {Arrowheads[{{0.0004229309913262064, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.852977925864222, -1.4369012911286951`}, \
{-2.8613077884214895`, -1.4202415660141596`}}]}}, 
    {Arrowheads[{{0.0004229309913262064, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.852977925864222, 
       1.4369012911286978`}, {-2.8613077884214895`, 1.4202415660141623`}}]}}, 
    {Arrowheads[{{0.0010699401805309933`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.84048313202832, 
       2.8738025822573943`}, {-2.8738025822573916`, 2.8404831320283233`}}]}}, 
    {Arrowheads[{{0.0020458671970891907`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.819658475635151, 4.310703873386091}, {-2.894627238650561, 
       4.260724698042484}}]}}, 
    {Arrowheads[{{0.0033834479306096782`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.7905039566847134`, 
       5.747605164514788}, {-2.9237817576009983`, 5.680966264056646}}]}}, 
    {Arrowheads[{{0.005092763532356943, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.7530195751770083`, 
       7.184506455643484}, {-2.9612661391087034`, 7.1012078300708055`}}]}}, 
    {Arrowheads[{{0.007177376926577078, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.7072053311120357`, 8.62140774677218}, {-3.007080383173676,
        8.521449396084966}}]}}, 
    {Arrowheads[{{0.004680988289823086, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.3265306122448968`, -10.01457725947522}, \
{-1.5306122448979578`, -9.985422740524783}}]}}, 
    {Arrowheads[{{0.003451490043452218, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.3536026655560172`, -8.583923365264473}, \
{-1.5035401915868376`, -8.558933777592669}}]}}, 
    {Arrowheads[{{0.0024110776141148056`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.3765097875885035`, -7.1532694710537275`}, \
{-1.480633069554351, -7.132444814660558}}]}}, 
    {Arrowheads[{{0.0015596924307595776`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.395251978342356, -5.722615576842982}, \
{-1.4618908788004985`, -5.705955851728446}}]}}, 
    {Arrowheads[{{0.0008971721158221379, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.4098292378175747`, -4.291961682632236}, \
{-1.4473136193252798`, -4.279466888796334}}]}}, 
    {Arrowheads[{{0.0004229309913262064, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.4202415660141594`, -2.86130778842149}, \
{-1.436901291128695, -2.8529779258642223`}}]}}, 
    {Arrowheads[{{0.00013374252256637148`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.4264889629321102`, -1.4306538942107443`}, \
{-1.430653894210744, -1.4264889629321105`}}]}}, 
    {Arrowheads[{{0.00013374252256637148`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.4264889629321102`, 
       1.430653894210747}, {-1.430653894210744, 1.4264889629321131`}}]}}, 
    {Arrowheads[{{0.0004229309913262064, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.4202415660141594`, 
       2.8613077884214926`}, {-1.436901291128695, 2.852977925864225}}]}}, 
    {Arrowheads[{{0.0008971721158221379, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.4098292378175747`, 
       4.291961682632238}, {-1.4473136193252798`, 4.279466888796336}}]}}, 
    {Arrowheads[{{0.0015596924307595776`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.395251978342356, 
       5.722615576842984}, {-1.4618908788004985`, 5.705955851728449}}]}}, 
    {Arrowheads[{{0.0024110776141148056`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.3765097875885035`, 7.15326947105373}, {-1.480633069554351,
        7.132444814660561}}]}}, 
    {Arrowheads[{{0.003451490043452218, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.3536026655560172`, 
       8.583923365264475}, {-1.5035401915868376`, 8.55893377759267}}]}}, 
    {Arrowheads[{{0.004680988289823097, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3265306122448992`, -10.01457725947522}, {
       1.5306122448979607`, -9.985422740524783}}]}}, 
    {Arrowheads[{{0.0034514900434522225`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3536026655560196`, -8.583923365264473}, {
       1.5035401915868403`, -8.558933777592669}}]}}, 
    {Arrowheads[{{0.002411077614114811, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3765097875885062`, -7.1532694710537275`}, {
       1.480633069554354, -7.132444814660558}}]}}, 
    {Arrowheads[{{0.0015596924307595776`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3952519783423587`, -5.722615576842982}, {
       1.4618908788005012`, -5.705955851728446}}]}}, 
    {Arrowheads[{{0.0008971721158221379, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.4098292378175774`, -4.291961682632236}, {
       1.4473136193252825`, -4.279466888796334}}]}}, 
    {Arrowheads[{{0.0004229309913262064, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.420241566014162, -2.86130778842149}, {
       1.4369012911286976`, -2.8529779258642223`}}]}}, 
    {Arrowheads[{{0.00013374252256637148`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.426488962932113, -1.4306538942107443`}, {
       1.4306538942107467`, -1.4264889629321105`}}]}}, 
    {Arrowheads[{{0.00013374252256637148`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.426488962932113, 1.430653894210747}, {1.4306538942107467`, 
       1.4264889629321131`}}]}}, 
    {Arrowheads[{{0.00042293099132621086`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.420241566014162, 2.8613077884214926`}, {
       1.4369012911286978`, 2.852977925864225}}]}}, 
    {Arrowheads[{{0.0008971721158221428, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.4098292378175774`, 4.291961682632238}, {
       1.4473136193252827`, 4.279466888796336}}]}}, 
    {Arrowheads[{{0.0015596924307595776`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3952519783423587`, 5.722615576842984}, {
       1.4618908788005012`, 5.705955851728449}}]}}, 
    {Arrowheads[{{0.0024110776141148156`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.376509787588506, 7.15326947105373}, {1.480633069554354, 
       7.132444814660561}}]}}, 
    {Arrowheads[{{0.0034514900434522225`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3536026655560196`, 8.583923365264475}, {
       1.5035401915868403`, 8.55893377759267}}]}}, 
    {Arrowheads[{{0.009638744825261978, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.653061224489797, -10.058309037900875`}, {
       3.06122448979592, -9.941690962099125}}]}}, 
    {Arrowheads[{{0.007177376926577096, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.707205331112038, -8.621407746772178}, {
       3.007080383173679, -8.521449396084964}}]}}, 
    {Arrowheads[{{0.005092763532356943, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.753019575177011, -7.184506455643481}, {
       2.961266139108706, -7.101207830070803}}]}}, 
    {Arrowheads[{{0.003383447930609687, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.790503956684716, -5.747605164514785}, {
       2.923781757601001, -5.680966264056642}}]}}, 
    {Arrowheads[{{0.0020458671970891907`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.8196584756351535`, -4.310703873386088}, {
       2.8946272386505636`, -4.260724698042481}}]}}, 
    {Arrowheads[{{0.0010699401805309933`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.840483132028323, -2.8738025822573916`}, {
       2.873802582257394, -2.84048313202832}}]}}, 
    {Arrowheads[{{0.0004229309913262064, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.8529779258642245`, -1.4369012911286951`}, {
       2.861307788421492, -1.4202415660141596`}}]}}, 
    {Arrowheads[{{0.00042293099132621086`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.8529779258642245`, 1.4369012911286978`}, {
       2.861307788421492, 1.420241566014162}}]}}, 
    {Arrowheads[{{0.0010699401805310002`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.840483132028323, 2.8738025822573943`}, {
       2.8738025822573943`, 2.840483132028323}}]}}, 
    {Arrowheads[{{0.0020458671970891994`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.8196584756351535`, 4.310703873386091}, {2.894627238650564, 
       4.260724698042484}}]}}, 
    {Arrowheads[{{0.003383447930609687, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.790503956684716, 5.747605164514788}, {2.923781757601001, 
       5.680966264056645}}]}}, 
    {Arrowheads[{{0.005092763532356952, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.753019575177011, 7.184506455643484}, {2.9612661391087065`, 
       7.1012078300708055`}}]}}, 
    {Arrowheads[{{0.007177376926577096, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.707205331112038, 8.62140774677218}, {3.007080383173679, 
       8.521449396084966}}]}}, 
    {Arrowheads[{{0.015124736040578424`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.9795918367346954`, -10.131195335276969`}, {
       4.591836734693879, -9.868804664723033}}]}}, 
    {Arrowheads[{{0.011419136765807662`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.060807996668057, -8.683881715951687}, {
       4.510620574760518, -8.458975426905456}}]}}, 
    {Arrowheads[{{0.008271518207665708, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.129529362765516, -7.236568096626406}, {
       4.441899208663059, -7.04914618908788}}]}}, 
    {Arrowheads[{{0.005674214678380669, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.185755935027074, -5.789254477301124}, {
       4.385672636401501, -5.639316951270303}}]}}, 
    {Arrowheads[{{0.0036110481092921083`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.22948771345273, -4.3419408579758425`}, {
       4.341940857975845, -4.229487713452727}}]}}, 
    {Arrowheads[{{0.0020458671970891907`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.260724698042484, -2.894627238650561}, {
       4.310703873386091, -2.819658475635151}}]}}, 
    {Arrowheads[{{0.0008971721158221379, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.279466888796336, -1.4473136193252798`}, {
       4.291961682632238, -1.4098292378175747`}}]}}, 
    {Arrowheads[{{0.0008971721158221428, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.279466888796336, 1.4473136193252825`}, {4.291961682632238, 
       1.4098292378175772`}}]}}, 
    {Arrowheads[{{0.0020458671970891907`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.260724698042484, 2.8946272386505636`}, {4.310703873386091, 
       2.8196584756351535`}}]}}, 
    {Arrowheads[{{0.0036110481092921083`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.22948771345273, 4.341940857975845}, {4.341940857975845, 
       4.22948771345273}}]}}, 
    {Arrowheads[{{0.005674214678380685, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.185755935027074, 5.789254477301126}, {4.385672636401502, 
       5.639316951270306}}]}}, 
    {Arrowheads[{{0.008271518207665725, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.129529362765516, 7.236568096626408}, {4.4418992086630595`, 
       7.049146189087883}}]}}, 
    {Arrowheads[{{0.011419136765807681`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.060807996668056, 8.683881715951689}, {4.510620574760518, 
       8.458975426905457}}]}}, 
    {Arrowheads[{{0.02134859125293253, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.306122448979593, -10.2332361516035}, {
       6.122448979591838, -9.766763848396502}}]}}, 
    {Arrowheads[{{0.016366937576713567`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.414410662224075, -8.771345272802998}, {
       6.014160766347357, -8.371511870054142}}]}}, 
    {Arrowheads[{{0.012110900511845525`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.506039150354021, -7.309454394002499}, {
       5.922532278217411, -6.976259891711786}}]}}, 
    {Arrowheads[{{0.008559521444247946, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.581007913369431, -5.8475635152019985`}, {
       5.847563515202001, -5.581007913369429}}]}}, 
    {Arrowheads[{{0.005674214678380685, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.639316951270306, -4.385672636401498}, {
       5.789254477301126, -4.18575593502707}}]}}, 
    {Arrowheads[{{0.0033834479306096782`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.680966264056645, -2.9237817576009983`}, {
       5.747605164514787, -2.7905039566847134`}}]}}, 
    {Arrowheads[{{0.0015596924307595776`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.705955851728448, -1.4618908788004985`}, {
       5.722615576842983, -1.395251978342356}}]}}, 
    {Arrowheads[{{0.0015596924307595776`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.705955851728448, 1.4618908788005012`}, {5.722615576842983, 
       1.3952519783423587`}}]}}, 
    {Arrowheads[{{0.003383447930609687, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.680966264056645, 2.923781757601001}, {5.747605164514788, 
       2.790503956684716}}]}}, 
    {Arrowheads[{{0.0056742146783806974`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.639316951270306, 4.385672636401501}, {5.789254477301127, 
       4.185755935027073}}]}}, 
    {Arrowheads[{{0.008559521444247946, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.581007913369431, 5.847563515202001}, {5.847563515202001, 
       5.581007913369431}}]}}, 
    {Arrowheads[{{0.01211090051184554, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.506039150354021, 7.309454394002501}, {5.922532278217412, 
       6.976259891711789}}]}}, 
    {Arrowheads[{{0.01636693757671358, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.414410662224075, 8.771345272803}, {6.0141607663473575`, 
       8.371511870054144}}]}}, 
    {Arrowheads[{{0.028473340174100647`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.632653061224492, -10.364431486880466`}, {
       7.6530612244897975`, -9.635568513119534}}]}}, 
    {Arrowheads[{{0.022158516676423743`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.768013327780094, -8.883798417326114}, {
       7.5177009579341965`, -8.259058725531029}}]}}, 
    {Arrowheads[{{0.016717815320796768`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.882548937942526, -7.403165347771761}, {
       7.403165347771764, -6.882548937942523}}]}}, 
    {Arrowheads[{{0.012110900511845513`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.976259891711789, -5.922532278217409}, {
       7.3094543940025005`, -5.5060391503540185`}}]}}, 
    {Arrowheads[{{0.008271518207665708, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.049146189087883, -4.441899208663056}, {
       7.236568096626408, -4.129529362765513}}]}}, 
    {Arrowheads[{{0.005092763532356943, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.101207830070806, -2.9612661391087034`}, {
       7.184506455643485, -2.7530195751770083`}}]}}, 
    {Arrowheads[{{0.0024110776141148056`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.13244481466056, -1.480633069554351}, {
       7.153269471053729, -1.3765097875885035`}}]}}, 
    {Arrowheads[{{0.0024110776141148156`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.13244481466056, 1.480633069554354}, {7.153269471053729, 
       1.376509787588506}}]}}, 
    {Arrowheads[{{0.005092763532356952, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.101207830070806, 2.961266139108706}, {7.184506455643485, 
       2.7530195751770106`}}]}}, 
    {Arrowheads[{{0.008271518207665708, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.049146189087882, 4.441899208663059}, {7.236568096626407, 
       4.129529362765516}}]}}, 
    {Arrowheads[{{0.01211090051184554, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.976259891711789, 5.922532278217411}, {7.309454394002501, 
       5.50603915035402}}]}}, 
    {Arrowheads[{{0.016717815320796785`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.882548937942526, 7.403165347771764}, {7.403165347771765, 
       6.882548937942525}}]}}, 
    {Arrowheads[{{0.022158516676423743`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.768013327780094, 8.883798417326116}, {7.5177009579341965`, 
       8.25905872553103}}]}}, 
    {Arrowheads[{{0.03661957214128819, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.959183673469389, -10.524781341107872`}, {
       9.183673469387758, -9.475218658892128}}]}}, 
    {Arrowheads[{{0.02888838487433681, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.12161599333611, -9.021241149521034}, {
       9.021241149521034, -8.12161599333611}}]}}, 
    {Arrowheads[{{0.022158516676423743`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.25905872553103, -7.517700957934194}, {
       8.883798417326116, -6.768013327780091}}]}}, 
    {Arrowheads[{{0.016366937576713543`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.371511870054146, -6.014160766347355}, {
       8.771345272803, -5.414410662224073}}]}}, 
    {Arrowheads[{{0.011419136765807698`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.458975426905457, -4.510620574760516}, {
       8.683881715951689, -4.0608079966680535`}}]}}, 
    {Arrowheads[{{0.007177376926577087, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.521449396084966, -3.0070803831736765`}, {
       8.62140774677218, -2.7072053311120357`}}]}}, 
    {Arrowheads[{{0.003451490043452218, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.55893377759267, -1.5035401915868374`}, {
       8.583923365264475, -1.353602665556017}}]}}, 
    {Arrowheads[{{0.0034514900434522225`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.55893377759267, 1.5035401915868403`}, {8.583923365264475, 
       1.3536026655560196`}}]}}, 
    {Arrowheads[{{0.007177376926577096, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.521449396084966, 3.007080383173679}, {8.62140774677218, 
       2.707205331112038}}]}}, 
    {Arrowheads[{{0.011419136765807698`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.458975426905457, 4.510620574760519}, {8.683881715951689, 
       4.060807996668056}}]}}, 
    {Arrowheads[{{0.01636693757671358, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.371511870054146, 6.0141607663473575`}, {8.771345272803002, 
       5.414410662224075}}]}}, 
    {Arrowheads[{{0.022158516676423743`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.25905872553103, 7.5177009579341965`}, {8.883798417326116, 
       6.768013327780094}}]}}, 
    {Arrowheads[{{0.02888838487433681, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.12161599333611, 9.021241149521035}, {9.021241149521034, 
       8.121615993336112}}]}}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "TransparentPolygonMesh" -> True},
  PlotRange->{{-11.010152544552211`, 
   11.010152544552211`}, {-11.010152544552211`, 11.010152544552211`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.6564314006184998`*^9, 
  3.6564314114609165`*^9}},ExpressionUUID->"2feef5e9-37ac-4459-b446-\
8ef056e5118f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"3", "x", " ", 
     SuperscriptBox["y", "2"]}], ",", "y"}], "]"}], "\[Equal]", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], "x", " ", 
     SuperscriptBox["y", "2"]}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.656431419432823*^9, 
  3.656431445129361*^9}},ExpressionUUID->"3e212b24-8594-4b5c-ae7c-\
9b0456423186"],

Cell[BoxData[
 RowBox[{
  RowBox[{"6", " ", "x", " ", "y"}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", "3"}], " ", 
   SuperscriptBox["y", "2"]}]}]], "Output",
 CellChangeTimes->{{3.6564314621365604`*^9, 
  3.656431470061919*^9}},ExpressionUUID->"f6ac4757-d369-446d-9d29-\
4cb43ad94a85"]
}, Open  ]],

Cell["This is not conservative for all values of x and y.", "Text",
 CellChangeTimes->{{3.6564314970694237`*^9, 
  3.656431507568964*^9}},ExpressionUUID->"9d1cf004-e0b7-46fb-b8ca-\
815d8b6dba27"],

Cell[TextData[{
 StyleBox["4.)",
  FontColor->RGBColor[1, 0, 0]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["F", "\[RightVector]"], "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"sin", "(", 
       RowBox[{"x", " ", "y"}], ")"}], " ", 
      OverscriptBox["i", "^"]}], " ", "+", 
     RowBox[{"y", " ", 
      RowBox[{"sin", "(", 
       RowBox[{"x", " ", "y"}], ")"}], " ", 
      OverscriptBox["j", "^"]}]}]}], TraditionalForm]],ExpressionUUID->
  "2ede16ff-0d38-4d65-9f16-5e47184f5f0f"]
}], "Text",
 CellChangeTimes->{{3.656370248623249*^9, 3.6563703431699963`*^9}, {
  3.656370379052232*^9, 3.656370383265421*^9}, {3.6563706369353848`*^9, 
  3.65637070125063*^9}},ExpressionUUID->"b9522e1c-6f8d-4119-9efe-\
98fbcb2370d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v4", "=", 
  RowBox[{"VectorPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "y"}], "]"}]}], ",", 
      RowBox[{"y", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "y"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"VectorColorFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"Red", "&"}], ")"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.6564313938604393`*^9, {3.656431522532419*^9, 3.6564315410041213`*^9}, {
   3.656431677244129*^9, 
   3.6564316773377357`*^9}},ExpressionUUID->"0b5c0044-0a7a-4390-8743-\
796b8601d025"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
    {Arrowheads[{{0.028935244943948734`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-10.45054222250884, -10.45054222250884}, \
{-9.549457777491162, -9.549457777491162}}]}}, 
    {Arrowheads[{{0.04139725850278227, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-10.692123332573004`, -9.16467714220543}, \
{-9.307876667426997, -7.978180000651711}}]}}, 
    {Arrowheads[{{0.03657712201822965, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.34458701248366, -6.6747050089168996`}, \
{-10.65541298751634, -7.611009276797385}}]}}, 
    {Arrowheads[{{0.02605363772797266, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.501881050502977, -5.429646314573128}, \
{-10.498118949497025`, -5.998925113998299}}]}}, 
    {Arrowheads[{{0.03966717461296351, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-10.802857822050102`, -4.629796209450043}, \
{-9.197142177949898, -3.941632361978527}}]}}, 
    {Arrowheads[{{0.012301978501722828`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-10.260470414250873`, -2.9315629755002486`}, \
{-9.739529585749125, -2.7827227387854636`}}]}}, 
    {Arrowheads[{{0.04036691240116733, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.12004208535366, -1.3028631550505216`}, \
{-10.87995791464634, -1.554279702092333}}]}}, 
    {Arrowheads[{{5.243487503638045*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-10.000000000000012`, 
       1.3322676295501894`*^-15}, {-9.99999999999999, 
       1.3322676295501863`*^-15}}]}}, 
    {Arrowheads[{{0.040366912401167174`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-10.879957914646337`, 
       1.5542797020923353`}, {-9.120042085353663, 1.3028631550505247`}}]}}, 
    {Arrowheads[{{0.012301978501723796`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.739529585749105, 2.78272273878546}, {-10.260470414250895`,
        2.9315629755002575`}}]}}, 
    {Arrowheads[{{0.039667174612962944`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.197142177949909, 3.941632361978534}, {-10.80285782205009, 
       4.62979620945004}}]}}, 
    {Arrowheads[{{0.026053637727973453`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-10.498118949497039`, 5.99892511399831}, {-9.501881050502961,
        5.429646314573122}}]}}, 
    {Arrowheads[{{0.036577122018228686`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-10.655412987516323`, 
       7.611009276797376}, {-9.344587012483677, 6.674705008916914}}]}}, 
    {Arrowheads[{{0.04139725850278279, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.307876667426989, 
       7.978180000651705}, {-10.692123332573011`, 9.164677142205441}}]}}, 
    {Arrowheads[{{0.04139725850278227, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.16467714220543, -10.692123332573004`}, \
{-7.978180000651711, -9.307876667426997}}]}}, 
    {Arrowheads[{{0.04587368524026581, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.285714285714278, -9.285714285714278}, \
{-7.857142857142865, -7.857142857142865}}]}}, 
    {Arrowheads[{{0.04505307020967504, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.333567344747149, -7.777972787289291}, \
{-7.809289798109994, -6.507741498424994}}]}}, 
    {Arrowheads[{{0.03994677324930664, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.303333404063471, -6.202222269375647}, \
{-7.8395237387936705`, -5.22634915919578}}]}}, 
    {Arrowheads[{{0.031818420228594525`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.198110164239896, -4.599055082119947}, \
{-7.944746978617246, -3.972373489308622}}]}}, 
    {Arrowheads[{{0.021888152970071493`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-9.02867855833734, -3.0095595194457787`}, \
{-8.114178584519802, -2.7047261948399326`}}]}}, 
    {Arrowheads[{{0.011094009151545393`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.812398162098786, -1.468733027016463}, \
{-8.330458980758358, -1.3884098301263916`}}]}}, 
    {Arrowheads[{{4.0334519258754193`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.57142857142858, 
       1.3322676295501892`*^-15}, {-8.571428571428562, 
       1.3322676295501865`*^-15}}]}}, 
    {Arrowheads[{{0.011094009151544617`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.330458980758374, 1.388409830126397}, {-8.812398162098768, 
       1.4687330270164627`}}]}}, 
    {Arrowheads[{{0.02188815297007077, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-8.114178584519816, 
       2.7047261948399406`}, {-9.028678558337324, 3.009559519445777}}]}}, 
    {Arrowheads[{{0.03181842022859404, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.944746978617255, 
       3.9723734893086293`}, {-9.198110164239885, 4.599055082119945}}]}}, 
    {Arrowheads[{{0.039946773249306386`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.839523738793675, 5.226349159195785}, {-9.303333404063466, 
       6.202222269375647}}]}}, 
    {Arrowheads[{{0.04505307020967506, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.809289798109993, 6.507741498424996}, {-9.333567344747149, 
       7.777972787289293}}]}}, 
    {Arrowheads[{{0.045873685240266075`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.857142857142861, 7.857142857142862}, {-9.285714285714281, 
       9.285714285714285}}]}}, 
    {Arrowheads[{{0.03657712201822965, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.6747050089168996`, -9.34458701248366}, \
{-7.611009276797385, -10.65541298751634}}]}}, 
    {Arrowheads[{{0.04505307020967504, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.777972787289291, -9.333567344747149}, \
{-6.507741498424994, -7.809289798109994}}]}}, 
    {Arrowheads[{{0.027968820834687918`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.7073628270418855`, -6.7073628270418855`}, \
{-7.578351458672399, -7.578351458672399}}]}}, 
    {Arrowheads[{{0.0009009408429762096, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.127365492614288, -5.70189239409143}, {-7.158348793099997, \
-5.726679034479997}}]}}, 
    {Arrowheads[{{0.02423099947110284, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.600393074031008, -4.560235844418604}, \
{-6.685321211683276, -4.011192727009965}}]}}, 
    {Arrowheads[{{0.031082549371178457`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.507363852852615, -2.602945541141045}, {-7.77835043286167, \
-3.111340173144667}}]}}, 
    {Arrowheads[{{0.020685145072179605`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.589504977884585, -1.5179009955769156`}, \
{-6.6962093078297, -1.339241861565939}}]}}, 
    {Arrowheads[{{2.8234163481127935`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.142857142857149, 
       1.332267629550189*^-15}, {-7.142857142857136, 
       1.3322676295501869`*^-15}}]}}, 
    {Arrowheads[{{0.02068514507218002, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.696209307829691, 
       1.3392418615659396`}, {-7.5895049778845936`, 1.51790099557692}}]}}, 
    {Arrowheads[{{0.031082549371178457`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.77835043286167, 3.1113401731446695`}, {-6.507363852852615,
        2.6029455411410476`}}]}}, 
    {Arrowheads[{{0.024230999471102427`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.685321211683284, 4.0111927270099725`}, {-7.600393074031, 
       4.560235844418602}}]}}, 
    {Arrowheads[{{0.0009009408429754064, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.158348793099983, 
       5.726679034479989}, {-7.1273654926143015`, 5.701892394091444}}]}}, 
    {Arrowheads[{{0.027968820834688372`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-7.578351458672406, 7.578351458672409}, {-6.707362827041878, 
       6.707362827041881}}]}}, 
    {Arrowheads[{{0.045053070209675056`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.507741498424994, 7.809289798109995}, {-7.777972787289291, 
       9.33356734474715}}]}}, 
    {Arrowheads[{{0.02605363772797266, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.429646314573128, -9.501881050502977}, \
{-5.998925113998299, -10.498118949497025`}}]}}, 
    {Arrowheads[{{0.03994677324930664, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.202222269375647, -9.303333404063471}, {-5.22634915919578, \
-7.8395237387936705`}}]}}, 
    {Arrowheads[{{0.0009009408429762096, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.70189239409143, -7.127365492614288}, {-5.726679034479997, \
-7.158348793099997}}]}}, 
    {Arrowheads[{{0.030852297568893808`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.233893626950008, -5.233893626950008}, {-6.19467780162142, \
-6.19467780162142}}]}}, 
    {Arrowheads[{{0.017304104289901243`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.019119038891558, -4.514339279168668}, \
{-5.409452389679869, -4.057089292259901}}]}}, 
    {Arrowheads[{{0.014969057401014422`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.009109676869548, -3.004554838434773}, \
{-5.419461751701879, -2.709730875850939}}]}}, 
    {Arrowheads[{{0.022670598221244766`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.229977491588136, -1.307494372897033}, \
{-6.198593936983291, -1.5496484842458214`}}]}}, 
    {Arrowheads[{{1.8150533666439385`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.714285714285717, 
       1.3322676295501888`*^-15}, {-5.714285714285709, 
       1.332267629550187*^-15}}]}}, 
    {Arrowheads[{{0.022670598221244665`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.198593936983288, 
       1.5496484842458238`}, {-5.229977491588138, 1.307494372897036}}]}}, 
    {Arrowheads[{{0.014969057401014795`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.4194617517018715`, 
       2.7097308758509375`}, {-6.009109676869555, 3.0045548384347796`}}]}}, 
    {Arrowheads[{{0.017304104289900913`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.409452389679875, 4.057089292259908}, {-6.019119038891553, 
       4.5143392791686665`}}]}}, 
    {Arrowheads[{{0.030852297568893967`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-6.194677801621422, 6.194677801621425}, {-5.233893626950005, 
       5.233893626950007}}]}}, 
    {Arrowheads[{{0.0009009408429756804, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.72667903447999, 7.15834879309999}, {-5.701892394091438, 
       7.127365492614299}}]}}, 
    {Arrowheads[{{0.03994677324930652, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-5.226349159195782, 7.839523738793675}, {-6.202222269375645, 
       9.303333404063471}}]}}, 
    {Arrowheads[{{0.03966717461296351, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.629796209450043, -10.802857822050102`}, \
{-3.941632361978527, -9.197142177949898}}]}}, 
    {Arrowheads[{{0.031818420228594525`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.599055082119947, -9.198110164239896}, \
{-3.972373489308622, -7.944746978617246}}]}}, 
    {Arrowheads[{{0.02423099947110284, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.560235844418604, -7.600393074031008}, \
{-4.011192727009965, -6.685321211683276}}]}}, 
    {Arrowheads[{{0.017304104289901243`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.514339279168668, -6.019119038891558}, \
{-4.057089292259901, -5.409452389679869}}]}}, 
    {Arrowheads[{{0.011356860068018735`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.462548626867395, -4.462548626867395}, \
{-4.108879944561174, -4.108879944561174}}]}}, 
    {Arrowheads[{{0.00657596259053732, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.40619908104939, -2.9374660540329263`}, \
{-4.165229490379179, -2.7768196602527855`}}]}}, 
    {Arrowheads[{{0.0029214081744534694`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.346743366210502, -1.4489144554034998`}, \
{-4.224685205218067, -1.4082284017393547`}}]}}, 
    {Arrowheads[{{1.0083629814688548`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.2857142857142865`, 
       1.3322676295501884`*^-15}, {-4.285714285714282, 
       1.332267629550187*^-15}}]}}, 
    {Arrowheads[{{0.002921408174453257, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.224685205218071, 
       1.4082284017393587`}, {-4.3467433662104975`, 1.448914455403501}}]}}, 
    {Arrowheads[{{0.006575962590537106, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.165229490379183, 2.776819660252791}, {-4.406199081049386, 
       2.9374660540329267`}}]}}, 
    {Arrowheads[{{0.011356860068018535`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.108879944561178, 4.108879944561179}, {-4.462548626867393, 
       4.462548626867394}}]}}, 
    {Arrowheads[{{0.017304104289900986`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.057089292259905, 5.409452389679876}, {-4.514339279168665, 
       6.0191190388915565`}}]}}, 
    {Arrowheads[{{0.024230999471102587`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-4.011192727009968, 6.685321211683283}, {-4.560235844418601, 
       7.600393074031006}}]}}, 
    {Arrowheads[{{0.0318184202285944, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.972373489308624, 7.944746978617251}, {-4.599055082119945, 
       9.198110164239896}}]}}, 
    {Arrowheads[{{0.012301978501722828`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.9315629755002486`, -10.260470414250873`}, \
{-2.7827227387854636`, -9.739529585749125}}]}}, 
    {Arrowheads[{{0.021888152970071493`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.0095595194457787`, -9.02867855833734}, \
{-2.7047261948399326`, -8.114178584519802}}]}}, 
    {Arrowheads[{{0.031082549371178457`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.602945541141045, -6.507363852852615}, \
{-3.111340173144667, -7.77835043286167}}]}}, 
    {Arrowheads[{{0.014969057401014422`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.004554838434773, -6.009109676869548}, \
{-2.709730875850939, -5.419461751701879}}]}}, 
    {Arrowheads[{{0.00657596259053732, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.9374660540329263`, -4.40619908104939}, \
{-2.7768196602527855`, -4.165229490379179}}]}}, 
    {Arrowheads[{{0.015551902077111022`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.6149887457940673`, -2.6149887457940673`}, \
{-3.0992969684916445`, -3.0992969684916445`}}]}}, 
    {Arrowheads[{{0.010423687007559038`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.062443206121004, -1.531221603060501}, \
{-2.6518425081647083`, -1.3259212540823533`}}]}}, 
    {Arrowheads[{{4.033451925875419*^-17, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.8571428571428568`, 
       1.3322676295501882`*^-15}, {-2.857142857142855, 
       1.3322676295501873`*^-15}}]}}, 
    {Arrowheads[{{0.010423687007559097`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.651842508164707, 
       1.3259212540823553`}, {-3.0624432061210047`, 1.5312216030605044`}}]}}, 
    {Arrowheads[{{0.015551902077110987`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.099296968491644, 
       3.0992969684916467`}, {-2.614988745794068, 2.6149887457940704`}}]}}, 
    {Arrowheads[{{0.00657596259053719, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.7768196602527873`, 
       4.165229490379184}, {-2.9374660540329245`, 4.406199081049391}}]}}, 
    {Arrowheads[{{0.01496905740101458, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.709730875850937, 
       5.419461751701879}, {-3.0045548384347742`, 6.009109676869554}}]}}, 
    {Arrowheads[{{0.031082549371178478`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-3.111340173144667, 7.778350432861672}, {-2.602945541141045, 
       6.507363852852617}}]}}, 
    {Arrowheads[{{0.021888152970071278`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-2.7047261948399344`, 
       8.114178584519808}, {-3.0095595194457774`, 9.028678558337337}}]}}, 
    {Arrowheads[{{0.04036691240116733, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.3028631550505216`, -9.12004208535366}, \
{-1.554279702092333, -10.87995791464634}}]}}, 
    {Arrowheads[{{0.011094009151545393`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.468733027016463, -8.812398162098786}, \
{-1.3884098301263916`, -8.330458980758358}}]}}, 
    {Arrowheads[{{0.020685145072179605`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.5179009955769156`, -7.589504977884585}, \
{-1.339241861565939, -6.6962093078297}}]}}, 
    {Arrowheads[{{0.022670598221244766`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.307494372897033, -5.229977491588136}, \
{-1.5496484842458214`, -6.198593936983291}}]}}, 
    {Arrowheads[{{0.0029214081744534694`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.4489144554034998`, -4.346743366210502}, \
{-1.4082284017393547`, -4.224685205218067}}]}}, 
    {Arrowheads[{{0.010423687007559038`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.531221603060501, -3.062443206121004}, \
{-1.3259212540823533`, -2.6518425081647083`}}]}}, 
    {Arrowheads[{{0.00727805099702903, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.3152470285849711`, -1.3152470285849711`}, \
{-1.5418958285578837`, -1.5418958285578837`}}]}}, 
    {Arrowheads[{{1.0083629814688548`*^-17, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.4285714285714275`, 
       1.332267629550188*^-15}, {-1.428571428571427, 
       1.3322676295501877`*^-15}}]}}, 
    {Arrowheads[{{0.007278050997029022, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.5418958285578832`, 
       1.541895828557886}, {-1.3152470285849711`, 1.3152470285849736`}}]}}, 
    {Arrowheads[{{0.010423687007559072`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.325921254082353, 2.65184250816471}, {-1.5312216030605015`,
        3.062443206121007}}]}}, 
    {Arrowheads[{{0.002921408174453385, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.4082284017393554`, 
       4.224685205218071}, {-1.4489144554034994`, 4.346743366210503}}]}}, 
    {Arrowheads[{{0.022670598221244766`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.5496484842458214`, 
       6.198593936983293}, {-1.3074943728970332`, 5.229977491588139}}]}}, 
    {Arrowheads[{{0.02068514507217971, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.3392418615659385`, 
       6.6962093078297}, {-1.5179009955769163`, 7.589504977884589}}]}}, 
    {Arrowheads[{{0.011094009151545351`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{-1.3884098301263919`, 
       8.33045898075836}, {-1.4687330270164627`, 8.812398162098786}}]}}, 
    {Arrowheads[{{5.243487503638045*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3322676295501894`*^-15, -10.000000000000012`}, {
       1.3322676295501863`*^-15, -9.99999999999999}}]}}, 
    {Arrowheads[{{4.0334519258754193`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3322676295501892`*^-15, -8.57142857142858}, {
       1.3322676295501865`*^-15, -8.571428571428562}}]}}, 
    {Arrowheads[{{2.8234163481127935`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.332267629550189*^-15, -7.142857142857149}, {
       1.3322676295501869`*^-15, -7.142857142857136}}]}}, 
    {Arrowheads[{{1.8150533666439385`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3322676295501888`*^-15, -5.714285714285717}, {
       1.332267629550187*^-15, -5.714285714285709}}]}}, 
    {Arrowheads[{{1.0083629814688548`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3322676295501884`*^-15, -4.2857142857142865`}, {
       1.332267629550187*^-15, -4.285714285714282}}]}}, 
    {Arrowheads[{{4.033451925875419*^-17, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3322676295501882`*^-15, -2.8571428571428568`}, {
       1.3322676295501873`*^-15, -2.857142857142855}}]}}, 
    {Arrowheads[{{1.0083629814688548`*^-17, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.332267629550188*^-15, -1.4285714285714275`}, {
       1.3322676295501877`*^-15, -1.428571428571427}}]}}, 
    {Arrowheads[{{1.0083629814688548`*^-17, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3322676295501877`*^-15, 1.4285714285714297`}, {
       1.332267629550188*^-15, 1.4285714285714302`}}]}}, 
    {Arrowheads[{{4.033451925875419*^-17, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3322676295501875`*^-15, 2.8571428571428577`}, {
       1.3322676295501884`*^-15, 2.8571428571428594`}}]}}, 
    {Arrowheads[{{1.0083629814688548`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3322676295501873`*^-15, 4.285714285714286}, {
       1.3322676295501886`*^-15, 4.28571428571429}}]}}, 
    {Arrowheads[{{1.8150533666439385`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3322676295501869`*^-15, 5.714285714285713}, {
       1.3322676295501886`*^-15, 5.714285714285721}}]}}, 
    {Arrowheads[{{2.8234163481127935`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3322676295501867`*^-15, 7.142857142857139}, {
       1.3322676295501888`*^-15, 7.142857142857151}}]}}, 
    {Arrowheads[{{4.0334519258754193`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3322676295501865`*^-15, 8.571428571428564}, {
       1.3322676295501892`*^-15, 8.571428571428582}}]}}, 
    {Arrowheads[{{0.040366912401167174`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5542797020923353`, -10.879957914646337`}, {
       1.3028631550505247`, -9.120042085353663}}]}}, 
    {Arrowheads[{{0.011094009151544617`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.388409830126397, -8.330458980758374}, {
       1.4687330270164627`, -8.812398162098768}}]}}, 
    {Arrowheads[{{0.02068514507218002, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3392418615659396`, -6.696209307829691}, {
       1.51790099557692, -7.5895049778845936`}}]}}, 
    {Arrowheads[{{0.022670598221244665`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5496484842458238`, -6.198593936983288}, {
       1.307494372897036, -5.229977491588138}}]}}, 
    {Arrowheads[{{0.002921408174453257, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.4082284017393587`, -4.224685205218071}, {
       1.448914455403501, -4.3467433662104975`}}]}}, 
    {Arrowheads[{{0.010423687007559097`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3259212540823553`, -2.651842508164707}, {
       1.5312216030605044`, -3.0624432061210047`}}]}}, 
    {Arrowheads[{{0.007278050997029022, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.541895828557886, -1.5418958285578832`}, {
       1.3152470285849736`, -1.3152470285849711`}}]}}, 
    {Arrowheads[{{1.0083629814688548`*^-17, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.4285714285714297`, 1.3322676295501877`*^-15}, {
       1.4285714285714302`, 1.332267629550188*^-15}}]}}, 
    {Arrowheads[{{0.007278050997029014, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.315247028584974, 1.315247028584974}, {1.541895828557886, 
       1.541895828557886}}]}}, 
    {Arrowheads[{{0.010423687007559138`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5312216030605048`, 3.0624432061210083`}, {
       1.325921254082355, 2.651842508164709}}]}}, 
    {Arrowheads[{{0.0029214081744531723`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.4489144554035005`, 4.346743366210499}, {
       1.4082284017393594`, 4.224685205218076}}]}}, 
    {Arrowheads[{{0.022670598221244648`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3074943728970363`, 5.229977491588142}, {
       1.5496484842458238`, 6.198593936983291}}]}}, 
    {Arrowheads[{{0.020685145072180083`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5179009955769205`, 7.589504977884598}, {
       1.3392418615659392`, 6.696209307829693}}]}}, 
    {Arrowheads[{{0.011094009151544576`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.4687330270164627`, 8.812398162098768}, {
       1.3884098301263974`, 8.330458980758376}}]}}, 
    {Arrowheads[{{0.012301978501723796`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.78272273878546, -9.739529585749105}, {
       2.9315629755002575`, -10.260470414250895`}}]}}, 
    {Arrowheads[{{0.02188815297007077, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.7047261948399406`, -8.114178584519816}, {
       3.009559519445777, -9.028678558337324}}]}}, 
    {Arrowheads[{{0.031082549371178457`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.1113401731446695`, -7.77835043286167}, {
       2.6029455411410476`, -6.507363852852615}}]}}, 
    {Arrowheads[{{0.014969057401014795`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.7097308758509375`, -5.4194617517018715`}, {
       3.0045548384347796`, -6.009109676869555}}]}}, 
    {Arrowheads[{{0.006575962590537106, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.776819660252791, -4.165229490379183}, {
       2.9374660540329267`, -4.406199081049386}}]}}, 
    {Arrowheads[{{0.015551902077110987`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.0992969684916467`, -3.099296968491644}, {
       2.6149887457940704`, -2.614988745794068}}]}}, 
    {Arrowheads[{{0.010423687007559072`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.65184250816471, -1.325921254082353}, {
       3.062443206121007, -1.5312216030605015`}}]}}, 
    {Arrowheads[{{4.033451925875419*^-17, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.8571428571428577`, 1.3322676295501875`*^-15}, {
       2.8571428571428594`, 1.3322676295501884`*^-15}}]}}, 
    {Arrowheads[{{0.010423687007559138`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.0624432061210083`, 1.5312216030605048`}, {
       2.651842508164709, 1.325921254082355}}]}}, 
    {Arrowheads[{{0.015551902077110963`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.614988745794071, 2.614988745794071}, {3.0992969684916463`, 
       3.0992969684916463`}}]}}, 
    {Arrowheads[{{0.006575962590536978, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.937466054032925, 4.406199081049387}, {2.7768196602527926`, 
       4.165229490379188}}]}}, 
    {Arrowheads[{{0.014969057401014946`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.004554838434781, 6.009109676869561}, {2.709730875850936, 
       5.4194617517018715`}}]}}, 
    {Arrowheads[{{0.031082549371178478`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.6029455411410476`, 6.507363852852617}, {
       3.1113401731446695`, 7.778350432861672}}]}}, 
    {Arrowheads[{{0.021888152970070684`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.009559519445776, 9.028678558337324}, {2.704726194839941, 
       8.11417858451982}}]}}, 
    {Arrowheads[{{0.039667174612962944`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.941632361978534, -9.197142177949909}, {
       4.62979620945004, -10.80285782205009}}]}}, 
    {Arrowheads[{{0.03181842022859404, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{3.9723734893086293`, -7.944746978617255}, {
       4.599055082119945, -9.198110164239885}}]}}, 
    {Arrowheads[{{0.024230999471102427`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.0111927270099725`, -6.685321211683284}, {
       4.560235844418602, -7.600393074031}}]}}, 
    {Arrowheads[{{0.017304104289900913`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.057089292259908, -5.409452389679875}, {
       4.5143392791686665`, -6.019119038891553}}]}}, 
    {Arrowheads[{{0.011356860068018535`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.108879944561179, -4.108879944561178}, {
       4.462548626867394, -4.462548626867393}}]}}, 
    {Arrowheads[{{0.00657596259053719, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.165229490379184, -2.7768196602527873`}, {
       4.406199081049391, -2.9374660540329245`}}]}}, 
    {Arrowheads[{{0.002921408174453385, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.224685205218071, -1.4082284017393554`}, {
       4.346743366210503, -1.4489144554034994`}}]}}, 
    {Arrowheads[{{1.0083629814688548`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.285714285714286, 1.3322676295501873`*^-15}, {
       4.28571428571429, 1.3322676295501886`*^-15}}]}}, 
    {Arrowheads[{{0.0029214081744531723`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.346743366210499, 1.4489144554035005`}, {4.224685205218076, 
       1.4082284017393594`}}]}}, 
    {Arrowheads[{{0.006575962590536978, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.406199081049387, 2.937466054032925}, {4.165229490379188, 
       2.7768196602527926`}}]}}, 
    {Arrowheads[{{0.011356860068018308`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.462548626867392, 4.462548626867392}, {4.108879944561184, 
       4.108879944561184}}]}}, 
    {Arrowheads[{{0.017304104289900663`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.514339279168664, 6.019119038891551}, {4.057089292259912, 
       5.409452389679882}}]}}, 
    {Arrowheads[{{0.024230999471102195`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.5602358444185995`, 7.600393074030999}, {4.011192727009975, 
       6.685321211683291}}]}}, 
    {Arrowheads[{{0.031818420228593894`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{4.599055082119944, 9.198110164239885}, {3.9723734893086307`, 
       7.94474697861726}}]}}, 
    {Arrowheads[{{0.026053637727973453`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.99892511399831, -10.498118949497039`}, {
       5.429646314573122, -9.501881050502961}}]}}, 
    {Arrowheads[{{0.039946773249306386`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.226349159195785, -7.839523738793675}, {
       6.202222269375647, -9.303333404063466}}]}}, 
    {Arrowheads[{{0.0009009408429754064, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.726679034479989, -7.158348793099983}, {
       5.701892394091444, -7.1273654926143015`}}]}}, 
    {Arrowheads[{{0.030852297568893967`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.194677801621425, -6.194677801621422}, {
       5.233893626950007, -5.233893626950005}}]}}, 
    {Arrowheads[{{0.017304104289900986`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.409452389679876, -4.057089292259905}, {
       6.0191190388915565`, -4.514339279168665}}]}}, 
    {Arrowheads[{{0.01496905740101458, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.419461751701879, -2.709730875850937}, {
       6.009109676869554, -3.0045548384347742`}}]}}, 
    {Arrowheads[{{0.022670598221244766`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.198593936983293, -1.5496484842458214`}, {
       5.229977491588139, -1.3074943728970332`}}]}}, 
    {Arrowheads[{{1.8150533666439385`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.714285714285713, 1.3322676295501869`*^-15}, {
       5.714285714285721, 1.3322676295501886`*^-15}}]}}, 
    {Arrowheads[{{0.022670598221244648`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.229977491588142, 1.3074943728970363`}, {6.198593936983291, 
       1.5496484842458238`}}]}}, 
    {Arrowheads[{{0.014969057401014946`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.009109676869561, 3.004554838434781}, {5.4194617517018715`, 
       2.709730875850936}}]}}, 
    {Arrowheads[{{0.017304104289900663`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.019119038891551, 4.514339279168664}, {5.409452389679882, 
       4.057089292259912}}]}}, 
    {Arrowheads[{{0.030852297568894124`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.233893626950005, 5.233893626950005}, {6.1946778016214274`, 
       6.1946778016214274`}}]}}, 
    {Arrowheads[{{0.0009009408429748899, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{5.701892394091451, 7.127365492614313}, {5.726679034479982, 
       7.158348793099977}}]}}, 
    {Arrowheads[{{0.039946773249306226`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.202222269375645, 9.303333404063466}, {5.226349159195788, 
       7.83952373879368}}]}}, 
    {Arrowheads[{{0.036577122018228686`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.611009276797376, -10.655412987516323`}, {
       6.674705008916914, -9.344587012483677}}]}}, 
    {Arrowheads[{{0.04505307020967506, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.507741498424996, -7.809289798109993}, {
       7.777972787289293, -9.333567344747149}}]}}, 
    {Arrowheads[{{0.027968820834688372`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.578351458672409, -7.578351458672406}, {
       6.707362827041881, -6.707362827041878}}]}}, 
    {Arrowheads[{{0.0009009408429756804, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.15834879309999, -5.72667903447999}, {
       7.127365492614299, -5.701892394091438}}]}}, 
    {Arrowheads[{{0.024230999471102587`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.685321211683283, -4.011192727009968}, {
       7.600393074031006, -4.560235844418601}}]}}, 
    {Arrowheads[{{0.031082549371178478`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.778350432861672, -3.111340173144667}, {
       6.507363852852617, -2.602945541141045}}]}}, 
    {Arrowheads[{{0.02068514507217971, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.6962093078297, -1.3392418615659385`}, {
       7.589504977884589, -1.5179009955769163`}}]}}, 
    {Arrowheads[{{2.8234163481127935`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.142857142857139, 1.3322676295501867`*^-15}, {
       7.142857142857151, 1.3322676295501888`*^-15}}]}}, 
    {Arrowheads[{{0.020685145072180083`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.589504977884598, 1.5179009955769205`}, {6.696209307829693, 
       1.3392418615659392`}}]}}, 
    {Arrowheads[{{0.031082549371178478`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.507363852852617, 2.6029455411410476`}, {7.778350432861672, 
       3.1113401731446695`}}]}}, 
    {Arrowheads[{{0.024230999471102195`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.600393074030999, 4.5602358444185995`}, {6.685321211683291, 
       4.011192727009975}}]}}, 
    {Arrowheads[{{0.0009009408429748899, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.127365492614313, 5.701892394091451}, {7.158348793099977, 
       5.726679034479982}}]}}, 
    {Arrowheads[{{0.027968820834688973`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{6.707362827041871, 6.707362827041871}, {7.578351458672418, 
       7.578351458672418}}]}}, 
    {Arrowheads[{{0.045053070209675125`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.777972787289294, 9.333567344747152}, {6.507741498424996, 
       7.809289798109994}}]}}, 
    {Arrowheads[{{0.04139725850278279, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.978180000651705, -9.307876667426989}, {
       9.164677142205441, -10.692123332573011`}}]}}, 
    {Arrowheads[{{0.045873685240266075`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.857142857142862, -7.857142857142861}, {
       9.285714285714285, -9.285714285714281}}]}}, 
    {Arrowheads[{{0.045053070209675056`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.809289798109995, -6.507741498424994}, {
       9.33356734474715, -7.777972787289291}}]}}, 
    {Arrowheads[{{0.03994677324930652, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.839523738793675, -5.226349159195782}, {
       9.303333404063471, -6.202222269375645}}]}}, 
    {Arrowheads[{{0.0318184202285944, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{7.944746978617251, -3.972373489308624}, {
       9.198110164239896, -4.599055082119945}}]}}, 
    {Arrowheads[{{0.021888152970071278`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.114178584519808, -2.7047261948399344`}, {
       9.028678558337337, -3.0095595194457774`}}]}}, 
    {Arrowheads[{{0.011094009151545351`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.33045898075836, -1.3884098301263919`}, {
       8.812398162098786, -1.4687330270164627`}}]}}, 
    {Arrowheads[{{4.0334519258754193`*^-16, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.571428571428564, 1.3322676295501865`*^-15}, {
       8.571428571428582, 1.3322676295501892`*^-15}}]}}, 
    {Arrowheads[{{0.011094009151544576`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{8.812398162098768, 1.4687330270164627`}, {8.330458980758376, 
       1.3884098301263974`}}]}}, 
    {Arrowheads[{{0.021888152970070684`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.028678558337324, 3.009559519445776}, {8.11417858451982, 
       2.704726194839941}}]}}, 
    {Arrowheads[{{0.031818420228593894`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.198110164239885, 4.599055082119944}, {7.94474697861726, 
       3.9723734893086307`}}]}}, 
    {Arrowheads[{{0.039946773249306226`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.303333404063466, 6.202222269375645}, {7.83952373879368, 
       5.226349159195788}}]}}, 
    {Arrowheads[{{0.045053070209675125`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.333567344747152, 7.777972787289294}, {7.809289798109994, 
       6.507741498424996}}]}}, 
    {Arrowheads[{{0.04587368524026627, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{9.285714285714286, 9.285714285714286}, {7.857142857142859, 
       7.857142857142859}}]}}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "TransparentPolygonMesh" -> True},
  PlotRange->{{-11.010152544552211`, 
   11.010152544552211`}, {-11.010152544552211`, 11.010152544552211`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.656431515977957*^9, 3.656431543578303*^9}, 
   3.6564316780709877`*^9},ExpressionUUID->"758b6cf4-8d1b-45a6-86ab-\
5bada802a897"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "y"}], "]"}]}], ",", "y"}], "]"}], "\[Equal]", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"y", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "y"}], "]"}]}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6564315707418184`*^9, 
  3.6564316058446937`*^9}},ExpressionUUID->"807342c7-4d7e-4397-b51f-\
7d2ba617f71e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"x", " ", "y"}], "]"}]}], "\[Equal]", 
  RowBox[{
   SuperscriptBox["y", "2"], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"x", " ", "y"}], "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.656431610072592*^9},ExpressionUUID->"9ccc1507-6c3e-44e0-a25c-\
4ed42436d168"]
}, Open  ]],

Cell["\<\
This fails the derivative test, and is also not conservative.\
\>", "Text",
 CellChangeTimes->{{3.6564316214607954`*^9, 3.6564316282316723`*^9}, {
  3.6564316585576115`*^9, 
  3.6564316665141726`*^9}},ExpressionUUID->"cfb3dd2d-59c8-401a-99cd-\
670c1c1a4d13"],

Cell[TextData[{
 StyleBox["5.)",
  FontColor->RGBColor[1, 0, 0]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["F", "\[RightVector]"], "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"y", " ", 
      RowBox[{"sin", "(", 
       RowBox[{"x", " ", "y"}], ")"}], " ", 
      OverscriptBox["i", "^"]}], " ", "+", 
     RowBox[{"x", " ", 
      RowBox[{"sin", "(", 
       RowBox[{"x", " ", "y"}], ")"}], " ", 
      OverscriptBox["j", "^"]}]}]}], TraditionalForm]],ExpressionUUID->
  "a4680c6e-a62c-4ab0-8503-7d826286bfc6"]
}], "Text",
 CellChangeTimes->{{3.656370248623249*^9, 3.6563703431699963`*^9}, {
  3.656370379052232*^9, 3.656370383265421*^9}, {3.6563706369353848`*^9, 
  3.65637070125063*^9}, {3.656370741617792*^9, 
  3.656370755930867*^9}},ExpressionUUID->"df2f7a1a-7e5c-499c-b80f-\
fe4f73786eca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v5", "=", 
  RowBox[{"VectorPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"y", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "y"}], "]"}]}], ",", 
      RowBox[{"x", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "y"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"VectorColorFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"Red", "&"}], ")"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.6564313955629053`*^9, {3.6564316853410997`*^9, 3.656431702892338*^9}, {
   3.6564320839849806`*^9, 
   3.656432102941532*^9}},ExpressionUUID->"5d21f220-c846-4c4d-92c7-\
cce16ca90f1c"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
    {Arrowheads[{{0.0004594414817435647, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.35535439996288093`, 0.35535439996288093`}, {
       0.3589313143228333, 0.3589313143228333}}]}}, 
    {Arrowheads[{{0.0014410788928354843`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.3500471433280232, 0.7107378573782973}, {
       0.36423857095769113`, 0.7178335711931313}}]}}, 
    {Arrowheads[{{0.0030155325241787508`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.34139401564525507`, 1.0661789575960374`}, {
       0.3728916986404593, 1.0766781852611056`}}]}}, 
    {Arrowheads[{{0.005142448193394185, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.3296785405801472, 1.421705349430751}, {
       0.38460717370556713`, 1.435437507712106}}]}}, 
    {Arrowheads[{{0.007753542015997957, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.3152879082996716, 1.7773432959456488`}, {
       0.39899780598604273`, 1.794085275482923}}]}}, 
    {Arrowheads[{{0.010761970601612821`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.29870348650482526`, 2.1331172477508042`}, {
       0.4155822277808891, 2.1525970379634813`}}]}}, 
    {Arrowheads[{{0.014065583809954412`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.2804889773843146, 2.4890494457487797`}, {
       0.43379673690139975`, 2.5109505542512203`}}]}}, 
    {Arrowheads[{{0.017549699081468223`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.2612764782547692, 2.8451595597818464`}, {
       0.4530092360309451, 2.8691261545038684`}}]}}, 
    {Arrowheads[{{0.021090029154905664`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.2417507500374636, 3.2014643690517817`}, {
       0.47253496424825076`, 3.2271070595196467`}}]}}, 
    {Arrowheads[{{0.02455582695318532, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.22263203790246805`, 3.5579774895045326`}, {
       0.4916536763832463, 3.5848796533526106`}}]}}, 
    {Arrowheads[{{0.027813210017854126`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.20465782155592355`, 3.9147091526089803`}, {
       0.5096278927297908, 3.9424337045338773`}}]}}, 
    {Arrowheads[{{0.03072860058897517, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.1885638980599319, 4.2716660391240415`}, {
       0.5257218162257824, 4.299762532304529}}]}}, 
    {Arrowheads[{{0.03317220826880103, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.17506521721408774`, 4.628851170554929}, {
       0.5392204970716266, 4.656863115159355}}]}}, 
    {Arrowheads[{{0.03502147870028147, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.16483689801222196`, 4.986263860062096}, {
       0.5494488162734924, 5.013736139937901}}]}}, 
    {Arrowheads[{{0.0014410788928354843`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.7107378573782973, 0.3500471433280232}, {0.7178335711931313,
        0.36423857095769113`}}]}}, 
    {Arrowheads[{{0.003527690357343014, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.7005535560043593, 0.7005535560043593}, {0.7280178725670693,
        0.7280178725670693}}]}}, 
    {Arrowheads[{{0.00637914707928746, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.6850660289666983, 1.051948781215894}, {0.7435053996047303, 
       1.0909083616412487`}}]}}, 
    {Arrowheads[{{0.009734821524184152, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.6663525248416703, 1.4046048338494066`}, {
       0.7622189037297583, 1.4525380232934506`}}]}}, 
    {Arrowheads[{{0.013158090717109765`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.6470303046655198, 1.758812121866208}, {0.7815411239059089, 
       1.8126164495623638`}}]}}, 
    {Arrowheads[{{0.016139451720437997`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.6299962347442517, 2.114760649676655}, {0.798575193827177, 
       2.17095363603763}}]}}, 
    {Arrowheads[{{0.01816516307068702, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.6181327347203966, 2.472527720124195}, {0.810438693851032, 
       2.527472279875805}}]}}, 
    {Arrowheads[{{0.01877647976627565, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.6140060099813048, 2.832072931066755}, {0.8145654185901237, 
       2.8822127832189595`}}]}}, 
    {Arrowheads[{{0.017622336345306286`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.6195835568055931, 3.193240790401243}, {0.8089878717658355, 
       3.235330638170186}}]}}, 
    {Arrowheads[{{0.014502865843876195`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.635996758512655, 3.5557707802739595`}, {0.7925746700587737,
        3.5870863625831833`}}]}}, 
    {Arrowheads[{{0.009400301058073572, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.6633710620385078, 3.9193142190719366`}, {
       0.7652003665329208, 3.9378286380709207`}}]}}, 
    {Arrowheads[{{0.0024943465889333666`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.7007409788272712, 4.283456829804545}, {0.7278304497441574, 
       4.287971741624026}}]}}, 
    {Arrowheads[{{0.005839793000083791, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.7460603876190288, 4.647745554139191}, {0.6825110409523997, 
       4.637968731575095}}]}}, 
    {Arrowheads[{{0.01505118106201064, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{0.7963108501734195, 5.011717876555386}, {0.6322605783980092, 
       4.988282123444613}}]}}, 
    {Arrowheads[{{0.0030155325241787508`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0661789575960374`, 0.34139401564525507`}, {
       1.0766781852611056`, 0.3728916986404593}}]}}, 
    {Arrowheads[{{0.00637914707928746, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.051948781215894, 0.6850660289666983}, {1.0909083616412487`,
        0.7435053996047303}}]}}, 
    {Arrowheads[{{0.009881127574386002, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0329645357267736`, 1.0329645357267736`}, {
       1.1098926071303694`, 1.1098926071303694`}}]}}, 
    {Arrowheads[{{0.012759356905726788`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0152355850675963`, 1.3864266888006973`}, {
       1.1276215577895463`, 1.47071616834216}}]}}, 
    {Arrowheads[{{0.01402706714435994, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0052129038166469`, 1.7459848851471311`}, {
       1.137644239040496, 1.8254436862814407`}}]}}, 
    {Arrowheads[{{0.012822133080328054`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0082937997751573`, 2.111289757030436}, {
       1.1345633430819857`, 2.17442452868385}}]}}, 
    {Arrowheads[{{0.008687483937374597, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0274702198374275`, 2.4811607064609382`}, {
       1.1153869230197155`, 2.5188392935390618`}}]}}, 
    {Arrowheads[{{0.0017518114912273145`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.0623987477896093`, 2.8537566732782462`}, {
       1.0804583950675335`, 2.8605290410074677`}}]}}, 
    {Arrowheads[{{0.007212950153773301, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.1090987367446683`, 3.226842436057747}, {
       1.0337584061124745`, 3.201728992513682}}]}}, 
    {Arrowheads[{{0.016868213582704985`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.1603730887859691`, 3.598111926635791}, {0.9824840540711737,
        3.544745216221352}}]}}, 
    {Arrowheads[{{0.025509726282591672`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.2069132383991625`, 3.965521792290681}, {0.9359439044579803,
        3.8916210648521767`}}]}}, 
    {Arrowheads[{{0.03136113641326492, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.2389192579320643`, 4.327586957340158}, {0.9039378849250785,
        4.243841614088412}}]}}, 
    {Arrowheads[{{0.03291002391427363, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.2479611599944507`, 4.683595432526191}, {0.8948959828626921,
        4.602118853188093}}]}}, 
    {Arrowheads[{{0.029225896946956285`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.2287479760716984`, 5.033711300994955}, {0.9141091667854444,
        4.966288699005043}}]}}, 
    {Arrowheads[{{0.005142448193394185, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.421705349430751, 0.3296785405801472}, {1.435437507712106, 
       0.38460717370556713`}}]}}, 
    {Arrowheads[{{0.009734821524184152, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.4046048338494066`, 0.6663525248416703}, {
       1.4525380232934506`, 0.7622189037297583}}]}}, 
    {Arrowheads[{{0.012759356905726788`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3864266888006973`, 1.0152355850675963`}, {1.47071616834216,
        1.1276215577895463`}}]}}, 
    {Arrowheads[{{0.012880558855492887`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3784315764192239`, 1.3784315764192239`}, {
       1.4787112807236333`, 1.4787112807236333`}}]}}, 
    {Arrowheads[{{0.009106030242638608, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.3894269506848989`, 1.754398703405062}, {
       1.4677159064579581`, 1.8170298680235095`}}]}}, 
    {Arrowheads[{{0.0014785213922755137`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.421799060842207, 2.1383422310376616`}, {
       1.4353437963006501`, 2.1473720546766235`}}]}}, 
    {Arrowheads[{{0.008580493382811055, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.4695839965152813`, 2.523435753110773}, {1.387558860627576, 
       2.476564246889227}}]}}, 
    {Arrowheads[{{0.018447646773416235`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5194056103168485`, 2.902559948015567}, {1.337737246826009, 
       2.8117257662701474`}}]}}, 
    {Arrowheads[{{0.02497077050511778, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5541894434490482`, 3.270115943120212}, {
       1.3029534136938088`, 3.158455485451217}}]}}, 
    {Arrowheads[{{0.02544483668995594, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.558628512923089, 3.6234514051692357`}, {
       1.2985143442197684`, 3.5194057376879075`}}]}}, 
    {Arrowheads[{{0.01858517317484449, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.5247243212602914`, 3.9635361168219245`}, {
       1.3324185358825658`, 3.8936067403209336`}}]}}, 
    {Arrowheads[{{0.00517025367743713, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.4555734605559874`, 4.2947149630424715`}, {
       1.4015693965868699`, 4.276713608386099}}]}}, 
    {Arrowheads[{{0.011893955874214325`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.365989758088109, 4.62360124424689}, {1.4911530990547484`, 
       4.662113041467395}}]}}, 
    {Arrowheads[{{0.028173039349956717`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.2794441310972515`, 4.957392200721663}, {
       1.5776987260456057`, 5.042607799278335}}]}}, 
    {Arrowheads[{{0.007753542015997957, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.7773432959456488`, 0.3152879082996716}, {1.794085275482923,
        0.39899780598604273`}}]}}, 
    {Arrowheads[{{0.013158090717109765`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.758812121866208, 0.6470303046655198}, {1.8126164495623638`,
        0.7815411239059089}}]}}, 
    {Arrowheads[{{0.01402706714435994, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.7459848851471311`, 1.0052129038166469`}, {
       1.8254436862814407`, 1.137644239040496}}]}}, 
    {Arrowheads[{{0.009106030242638608, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.754398703405062, 1.3894269506848989`}, {
       1.8170298680235095`, 1.4677159064579581`}}]}}, 
    {Arrowheads[{{0.0008517607010357153, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.7890299148029085`, 1.7890299148029085`}, {
       1.782398656625663, 1.782398656625663}}]}}, 
    {Arrowheads[{{0.012618878531488015`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.8390809961287244`, 2.1873294015358415`}, {
       1.7323475752998472`, 2.0983848841784436`}}]}}, 
    {Arrowheads[{{0.021297047714261268`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.8811179212212383`, 2.5681454539335373`}, {
       1.6903106502073335`, 2.4318545460664622`}}]}}, 
    {Arrowheads[{{0.022287721716824922`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.8897599531956142`, 2.9221713993186875`}, {
       1.6816686182329577`, 2.7921143149670273`}}]}}, 
    {Arrowheads[{{0.01359523473931918, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.8511386675530912`, 3.250632593085051}, {
       1.7202899038754802`, 3.177938835486378}}]}}, 
    {Arrowheads[{{0.002690506224176052, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.7724665292738184`, 3.564804693208338}, {1.798962042154753, 
       3.5780524496488053`}}]}}, 
    {Arrowheads[{{0.020627847160173494`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.6823350058393705`, 3.881580846810104}, {1.889093565589201, 
       3.975562010332754}}]}}, 
    {Arrowheads[{{0.03253323329207859, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.620393118954306, 4.21683046623096}, {1.951035452474266, 
       4.35459810519761}}]}}, 
    {Arrowheads[{{0.032231779768716676`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.6201029290857194`, 4.57916046723077}, {1.9513256423428524`,
        4.706553818483514}}]}}, 
    {Arrowheads[{{0.018075797357771747`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{1.6920028259064834`, 4.966531621497213}, {
       1.8794257455220882`, 5.033468378502786}}]}}, 
    {Arrowheads[{{0.010761970601612821`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.1331172477508042`, 0.29870348650482526`}, {
       2.1525970379634813`, 0.4155822277808891}}]}}, 
    {Arrowheads[{{0.016139451720437997`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.114760649676655, 0.6299962347442517}, {2.17095363603763, 
       0.798575193827177}}]}}, 
    {Arrowheads[{{0.012822133080328054`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.111289757030436, 1.0082937997751573`}, {2.17442452868385, 
       1.1345633430819857`}}]}}, 
    {Arrowheads[{{0.0014785213922755137`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.1383422310376616`, 1.421799060842207}, {
       2.1473720546766235`, 1.4353437963006501`}}]}}, 
    {Arrowheads[{{0.012618878531488015`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.1873294015358415`, 1.8390809961287244`}, {
       2.0983848841784436`, 1.7323475752998472`}}]}}, 
    {Arrowheads[{{0.02151356209334462, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.2266024861088893`, 2.2266024861088893`}, {
       2.0591117996053963`, 2.0591117996053963`}}]}}, 
    {Arrowheads[{{0.018819166339341435`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.2215168451787064`, 2.5674226019899113`}, {
       2.064197440535579, 2.432577398010088}}]}}, 
    {Arrowheads[{{0.00408744442539071, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.1608584975135154`, 2.8706438731351365`}, {
       2.1248557882007706`, 2.8436418411505775`}}]}}, 
    {Arrowheads[{{0.01570228175708732, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.070932836044661, 3.1663361764107267`}, {2.214781449669624, 
       3.262235252160702}}]}}, 
    {Arrowheads[{{0.02918457204767537, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.005089503890493, 3.488767988048582}, {2.280624781823793, 
       3.6540891548085614`}}]}}, 
    {Arrowheads[{{0.027037937879320833`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.0121859771840622`, 3.857296247295203}, {
       2.2735283085302234`, 3.999846609847655}}]}}, 
    {Arrowheads[{{0.008181542617559408, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.1025721277433336`, 4.265571778157381}, {2.183142157970952, 
       4.30585679327119}}]}}, 
    {Arrowheads[{{0.018302466304829283`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.2343399280474543`, 4.6850799667911325`}, {
       2.051374357666831, 4.600634318923152}}]}}, 
    {Arrowheads[{{0.03737150931069159, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.3319556157422108`, 5.081042202665028}, {
       1.9537586699720748`, 4.918957797334969}}]}}, 
    {Arrowheads[{{0.014065583809954412`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.4890494457487797`, 0.2804889773843146}, {
       2.5109505542512203`, 0.43379673690139975`}}]}}, 
    {Arrowheads[{{0.01816516307068702, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.472527720124195, 0.6181327347203966}, {2.527472279875805, 
       0.810438693851032}}]}}, 
    {Arrowheads[{{0.008687483937374597, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.4811607064609382`, 1.0274702198374275`}, {
       2.5188392935390618`, 1.1153869230197155`}}]}}, 
    {Arrowheads[{{0.008580493382811055, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.523435753110773, 1.4695839965152813`}, {2.476564246889227, 
       1.387558860627576}}]}}, 
    {Arrowheads[{{0.021297047714261268`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.5681454539335373`, 1.8811179212212383`}, {
       2.4318545460664622`, 1.6903106502073335`}}]}}, 
    {Arrowheads[{{0.018819166339341435`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.5674226019899113`, 2.2215168451787064`}, {
       2.432577398010088, 2.064197440535579}}]}}, 
    {Arrowheads[{{0.0008388584455742234, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.5032654047785963`, 2.5032654047785963`}, {
       2.4967345952214033`, 2.4967345952214033`}}]}}, 
    {Arrowheads[{{0.020568612344637922`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.414784401443327, 2.7825792084057683`}, {2.585215598556673, 
       2.9317065058799456`}}]}}, 
    {Arrowheads[{{0.028639781233544166`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.375547429827802, 3.1174892708184494`}, {2.624452570172198, 
       3.3110821577529794`}}]}}, 
    {Arrowheads[{{0.014842069513917155`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.433063242994427, 3.5245728415246704`}, {2.566936757005573, 
       3.6182843013324724`}}]}}, 
    {Arrowheads[{{0.012864524212746658`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.5597482643239564`, 3.9665930513230374`}, {
       2.440251735676043, 3.89054980581982}}]}}, 
    {Arrowheads[{{0.03408594194463539, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.6620844053300585`, 4.380263522156819}, {
       2.3379155946699415`, 4.191165049271751}}]}}, 
    {Arrowheads[{{0.030873668892102562`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.649646542848131, 4.723436050544597}, {2.3503534571518685`, 
       4.5622782351696864`}}]}}, 
    {Arrowheads[{{0.002651242792377776, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.5130544276249434`, 5.006527213812471}, {2.486945572375057, 
       4.993472786187528}}]}}, 
    {Arrowheads[{{0.017549699081468223`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.8451595597818464`, 0.2612764782547692}, {
       2.8691261545038684`, 0.4530092360309451}}]}}, 
    {Arrowheads[{{0.01877647976627565, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.832072931066755, 0.6140060099813048}, {2.8822127832189595`,
        0.8145654185901237}}]}}, 
    {Arrowheads[{{0.0017518114912273145`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.8537566732782462`, 1.0623987477896093`}, {
       2.8605290410074677`, 1.0804583950675335`}}]}}, 
    {Arrowheads[{{0.018447646773416235`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.902559948015567, 1.5194056103168485`}, {
       2.8117257662701474`, 1.337737246826009}}]}}, 
    {Arrowheads[{{0.022287721716824922`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.9221713993186875`, 1.8897599531956142`}, {
       2.7921143149670273`, 1.6816686182329577`}}]}}, 
    {Arrowheads[{{0.00408744442539071, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.8706438731351365`, 2.1608584975135154`}, {
       2.8436418411505775`, 2.1248557882007706`}}]}}, 
    {Arrowheads[{{0.020568612344637922`, 1.}}], 
     {RGBColor[1, 0, 0], 
      ArrowBox[{{2.7825792084057683`, 2.414784401443327}, {
       2.9317065058799456`, 2.585215598556673}}]}}, 
    {Arrowheads[{{0.