(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     52215,       1244]
NotebookOptionsPosition[     49761,       1156]
NotebookOutlinePosition[     50115,       1172]
CellTagsIndexPosition[     50072,       1169]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["VOLUME of TETRAHEDRON", "Text",
 CellChangeTimes->{{3.6587533622964554`*^9, 3.6587533687860556`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "3"], 
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", 
    RowBox[{"2", "-", 
     RowBox[{"2", " ", 
      RowBox[{"x", "/", "3"}]}]}]], 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", 
     RowBox[{"5", "-", 
      RowBox[{"5", " ", 
       RowBox[{"x", "/", "3"}]}], "-", 
      RowBox[{"5", " ", 
       RowBox[{"y", "/", "2"}]}]}]], 
    RowBox[{"1", 
     RowBox[{"\[DifferentialD]", "z"}], 
     RowBox[{"\[DifferentialD]", "y"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.6587548656325197`*^9, 3.658754948280289*^9}}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{3.6587549529886503`*^9}]
}, Open  ]],

Cell["\[LineSeparator]\[LineSeparator]PAC-MAN", "Text",
 CellChangeTimes->{{3.6587103880455093`*^9, 3.6587103925445004`*^9}, {
  3.6587523882831593`*^9, 3.658752388427174*^9}, {3.6587533880208554`*^9, 
  3.6587534859108553`*^9}, {3.6587540290726557`*^9, 3.6587540654362555`*^9}, {
  3.6587545337939367`*^9, 3.6587545615071297`*^9}, {3.6587547727427254`*^9, 
  3.658754792901372*^9}, {3.6587556115199966`*^9, 3.6587556130797167`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"\[Pi]", "/", "4"}], 
   RowBox[{"7", 
    RowBox[{"\[Pi]", "/", "4"}]}]], 
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", "1"], 
   RowBox[{"r", " ", 
    RowBox[{"Cos", "[", "\[Theta]", "]"}], "r", " ", 
    RowBox[{"\[DifferentialD]", "r"}], 
    RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.658710452300565*^9, 3.658710578983532*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   SqrtBox["2"], "3"]}]], "Output",
 CellChangeTimes->{3.658710582920917*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.658710596870707*^9, 3.658710598811006*^9}}],

Cell[BoxData[
 RowBox[{"-", "0.4714045207910317`"}]], "Output",
 CellChangeTimes->{3.6587105997774563`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"7", 
        RowBox[{"\[Pi]", "/", "4"}]}], ")"}], " ", "Degree"}], "]"}], "-", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Pi]", "/", "4"}], ")"}], " ", "Degree"}], "]"}]}], ")"}], 
  "/", "3"}]], "Input",
 CellChangeTimes->{{3.658951521767705*^9, 3.6589515997564096`*^9}, {
  3.658951667893042*^9, 3.658951695435459*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{"\[Degree]", " ", "\[Pi]"}], "4"], "]"}]}], "+", 
    RowBox[{"Sin", "[", 
     FractionBox[
      RowBox[{"7", " ", "\[Degree]", " ", "\[Pi]"}], "4"], "]"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.6589516959111967`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.65895164538102*^9, 3.658951648718239*^9}, 
   3.6589517114658422`*^9}],

Cell[BoxData["0.027366651341158933`"], "Output",
 CellChangeTimes->{3.658951649136011*^9, 3.658951712283267*^9}]
}, Open  ]],

Cell["\[LineSeparator]\[LineSeparator]VECTOR PLOT", "Text",
 CellChangeTimes->{{3.6587556275695157`*^9, 3.658755629082444*^9}, {
  3.6587565996851025`*^9, 3.6587566025707145`*^9}, {3.658951506226631*^9, 
  3.658951515409586*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorPlot", "[", 
  RowBox[{"{", 
   RowBox[{"y", ",", "1"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.658756608201556*^9, 3.6587566457145057`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"VectorPlot", "::", "argtu"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(VectorPlot\\)\[NoBreak] called with 1 \
argument; \[NoBreak]\\!\\(2\\)\[NoBreak] or \[NoBreak]\\!\\(3\\)\[NoBreak] \
arguments are expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argtu\\\", ButtonNote -> \
\\\"VectorPlot::argtu\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.658756646634782*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.658756690574066*^9, 3.658756708230889*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
    {Arrowheads[{{0.045873685240266325`, 1.}}], 
     ArrowBox[{{-1.8192984194189497`, -2.090350790290525}, \
{-2.1807015805810503`, -1.9096492097094748`}}]}, 
    {Arrowheads[{{0.04071545033532036, 1.}}], 
     ArrowBox[{{-1.8451129309305283`, -1.8046365045762396`}, \
{-2.154887069069472, -1.6239349239951892`}}]}, 
    {Arrowheads[{{0.035774512340316734`, 1.}}], 
     ArrowBox[{{-1.870927442442107, -1.518922218861954}, {-2.129072557557893, \
-1.3382206382809037`}}]}, 
    {Arrowheads[{{0.031154430007009275`, 1.}}], 
     ArrowBox[{{-1.8967419539536856`, -1.2332079331476684`}, \
{-2.103258046046314, -1.052506352566618}}]}, 
    {Arrowheads[{{0.02702029281170796, 1.}}], 
     ArrowBox[{{-1.9225564654652643`, -0.9474936474333826}, \
{-2.0774435345347357`, -0.7667920668523325}}]}, 
    {Arrowheads[{{0.023628560618325127`, 1.}}], 
     ArrowBox[{{-1.9483709769768427`, -0.661779361719097}, \
{-2.0516290230231573`, -0.4810777811380467}}]}, 
    {Arrowheads[{{0.021336271203092644`, 1.}}], 
     ArrowBox[{{-1.9741854884884213`, -0.37606507600481126`}, \
{-2.025814511511579, -0.19536349542376102`}}]}, 
    {Arrowheads[{{0.02051533571513285, 1.}}], 
     ArrowBox[{{-2., -0.09035079029052558}, {-2., 0.09035079029052469}}]}, 
    {Arrowheads[{{0.021336271203092626`, 1.}}], 
     ArrowBox[{{-2.0258145115115784`, 
      0.19536349542376014`}, {-1.9741854884884216`, 0.3760650760048104}}]}, 
    {Arrowheads[{{0.023628560618325127`, 1.}}], 
     ArrowBox[{{-2.0516290230231573`, 
      0.48107778113804583`}, {-1.9483709769768427`, 0.6617793617190961}}]}, 
    {Arrowheads[{{0.027020292811707966`, 1.}}], 
     ArrowBox[{{-2.0774435345347357`, 
      0.7667920668523315}, {-1.9225564654652643`, 0.9474936474333817}}]}, 
    {Arrowheads[{{0.031154430007009275`, 1.}}], 
     ArrowBox[{{-2.103258046046314, 
      1.0525063525666172`}, {-1.8967419539536856`, 1.2332079331476675`}}]}, 
    {Arrowheads[{{0.03577451234031671, 1.}}], 
     ArrowBox[{{-2.129072557557893, 
      1.3382206382809028`}, {-1.8709274424421072`, 1.518922218861953}}]}, 
    {Arrowheads[{{0.0407154503353203, 1.}}], 
     ArrowBox[{{-2.1548870690694715`, 
      1.6239349239951884`}, {-1.8451129309305285`, 1.8046365045762387`}}]}, 
    {Arrowheads[{{0.045873685240266325`, 1.}}], 
     ArrowBox[{{-2.1807015805810503`, 
      1.909649209709474}, {-1.8192984194189499`, 2.0903507902905245`}}]}, 
    {Arrowheads[{{0.045873685240266325`, 1.}}], 
     ArrowBox[{{-1.533584133704664, -2.090350790290525}, \
{-1.8949872948667648`, -1.9096492097094748`}}]}, 
    {Arrowheads[{{0.04071545033532034, 1.}}], 
     ArrowBox[{{-1.5593986452162427`, -1.8046365045762396`}, \
{-1.869172783355186, -1.6239349239951892`}}]}, 
    {Arrowheads[{{0.035774512340316734`, 1.}}], 
     ArrowBox[{{-1.5852131567278214`, -1.518922218861954}, \
{-1.8433582718436075`, -1.3382206382809037`}}]}, 
    {Arrowheads[{{0.031154430007009314`, 1.}}], 
     ArrowBox[{{-1.6110276682394, -1.2332079331476684`}, {-1.817543760332029, \
-1.052506352566618}}]}, 
    {Arrowheads[{{0.02702029281170796, 1.}}], 
     ArrowBox[{{-1.6368421797509787`, -0.9474936474333826}, \
{-1.7917292488204501`, -0.7667920668523325}}]}, 
    {Arrowheads[{{0.023628560618325127`, 1.}}], 
     ArrowBox[{{-1.662656691262557, -0.661779361719097}, \
{-1.7659147373088717`, -0.4810777811380467}}]}, 
    {Arrowheads[{{0.02133627120309264, 1.}}], 
     ArrowBox[{{-1.6884712027741358`, -0.37606507600481126`}, \
{-1.740100225797293, -0.19536349542376102`}}]}, 
    {Arrowheads[{{0.02051533571513285, 1.}}], 
     ArrowBox[{{-1.7142857142857144`, -0.09035079029052558}, \
{-1.7142857142857144`, 0.09035079029052469}}]}, 
    {Arrowheads[{{0.021336271203092633`, 1.}}], 
     ArrowBox[{{-1.740100225797293, 
      0.19536349542376014`}, {-1.688471202774136, 0.3760650760048104}}]}, 
    {Arrowheads[{{0.023628560618325113`, 1.}}], 
     ArrowBox[{{-1.7659147373088715`, 
      0.48107778113804583`}, {-1.662656691262557, 0.6617793617190961}}]}, 
    {Arrowheads[{{0.027020292811707966`, 1.}}], 
     ArrowBox[{{-1.7917292488204501`, 
      0.7667920668523315}, {-1.6368421797509787`, 0.9474936474333817}}]}, 
    {Arrowheads[{{0.031154430007009296`, 1.}}], 
     ArrowBox[{{-1.8175437603320288`, 1.0525063525666172`}, {-1.6110276682394,
       1.2332079331476675`}}]}, 
    {Arrowheads[{{0.03577451234031671, 1.}}], 
     ArrowBox[{{-1.8433582718436075`, 
      1.3382206382809028`}, {-1.5852131567278216`, 1.518922218861953}}]}, 
    {Arrowheads[{{0.0407154503353203, 1.}}], 
     ArrowBox[{{-1.8691727833551859`, 
      1.6239349239951884`}, {-1.559398645216243, 1.8046365045762387`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{-1.8949872948667645`, 
      1.909649209709474}, {-1.5335841337046643`, 2.0903507902905245`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{-1.2478698479903785`, -2.090350790290525}, \
{-1.609273009152479, -1.9096492097094748`}}]}, 
    {Arrowheads[{{0.04071545033532034, 1.}}], 
     ArrowBox[{{-1.2736843595019571`, -1.8046365045762396`}, \
{-1.5834584976409005`, -1.6239349239951892`}}]}, 
    {Arrowheads[{{0.035774512340316734`, 1.}}], 
     ArrowBox[{{-1.2994988710135358`, -1.518922218861954}, \
{-1.5576439861293219`, -1.3382206382809037`}}]}, 
    {Arrowheads[{{0.031154430007009314`, 1.}}], 
     ArrowBox[{{-1.3253133825251144`, -1.2332079331476684`}, \
{-1.5318294746177434`, -1.052506352566618}}]}, 
    {Arrowheads[{{0.02702029281170796, 1.}}], 
     ArrowBox[{{-1.351127894036693, -0.9474936474333826}, \
{-1.5060149631061646`, -0.7667920668523325}}]}, 
    {Arrowheads[{{0.023628560618325127`, 1.}}], 
     ArrowBox[{{-1.3769424055482715`, -0.661779361719097}, \
{-1.4802004515945861`, -0.4810777811380467}}]}, 
    {Arrowheads[{{0.02133627120309264, 1.}}], 
     ArrowBox[{{-1.4027569170598502`, -0.37606507600481126`}, \
{-1.4543859400830075`, -0.19536349542376102`}}]}, 
    {Arrowheads[{{0.02051533571513285, 1.}}], 
     ArrowBox[{{-1.4285714285714288`, -0.09035079029052558}, \
{-1.4285714285714288`, 0.09035079029052469}}]}, 
    {Arrowheads[{{0.021336271203092633`, 1.}}], 
     ArrowBox[{{-1.4543859400830075`, 
      0.19536349542376014`}, {-1.4027569170598504`, 0.3760650760048104}}]}, 
    {Arrowheads[{{0.023628560618325113`, 1.}}], 
     ArrowBox[{{-1.480200451594586, 
      0.48107778113804583`}, {-1.3769424055482715`, 0.6617793617190961}}]}, 
    {Arrowheads[{{0.027020292811707966`, 1.}}], 
     ArrowBox[{{-1.5060149631061646`, 
      0.7667920668523315}, {-1.351127894036693, 0.9474936474333817}}]}, 
    {Arrowheads[{{0.031154430007009296`, 1.}}], 
     ArrowBox[{{-1.5318294746177432`, 
      1.0525063525666172`}, {-1.3253133825251144`, 1.2332079331476675`}}]}, 
    {Arrowheads[{{0.03577451234031671, 1.}}], 
     ArrowBox[{{-1.5576439861293219`, 
      1.3382206382809028`}, {-1.299498871013536, 1.518922218861953}}]}, 
    {Arrowheads[{{0.0407154503353203, 1.}}], 
     ArrowBox[{{-1.5834584976409003`, 
      1.6239349239951884`}, {-1.2736843595019574`, 1.8046365045762387`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{-1.609273009152479, 1.909649209709474}, {-1.2478698479903787`,
       2.0903507902905245`}}]}, 
    {Arrowheads[{{0.04587368524026629, 1.}}], 
     ArrowBox[{{-0.962155562276093, -2.090350790290525}, \
{-1.3235587234381934`, -1.9096492097094748`}}]}, 
    {Arrowheads[{{0.04071545033532034, 1.}}], 
     ArrowBox[{{-0.9879700737876715, -1.8046365045762396`}, \
{-1.297744211926615, -1.6239349239951892`}}]}, 
    {Arrowheads[{{0.035774512340316734`, 1.}}], 
     ArrowBox[{{-1.0137845852992502`, -1.518922218861954}, \
{-1.2719297004150363`, -1.3382206382809037`}}]}, 
    {Arrowheads[{{0.031154430007009314`, 1.}}], 
     ArrowBox[{{-1.0395990968108288`, -1.2332079331476684`}, \
{-1.2461151889034578`, -1.052506352566618}}]}, 
    {Arrowheads[{{0.02702029281170796, 1.}}], 
     ArrowBox[{{-1.0654136083224075`, -0.9474936474333826}, \
{-1.220300677391879, -0.7667920668523325}}]}, 
    {Arrowheads[{{0.023628560618325127`, 1.}}], 
     ArrowBox[{{-1.091228119833986, -0.661779361719097}, \
{-1.1944861658803005`, -0.4810777811380467}}]}, 
    {Arrowheads[{{0.02133627120309264, 1.}}], 
     ArrowBox[{{-1.1170426313455646`, -0.37606507600481126`}, \
{-1.168671654368722, -0.19536349542376102`}}]}, 
    {Arrowheads[{{0.02051533571513285, 1.}}], 
     ArrowBox[{{-1.1428571428571432`, -0.09035079029052558}, \
{-1.1428571428571432`, 0.09035079029052469}}]}, 
    {Arrowheads[{{0.021336271203092633`, 1.}}], 
     ArrowBox[{{-1.168671654368722, 
      0.19536349542376014`}, {-1.1170426313455648`, 0.3760650760048104}}]}, 
    {Arrowheads[{{0.023628560618325113`, 1.}}], 
     ArrowBox[{{-1.1944861658803003`, 
      0.48107778113804583`}, {-1.091228119833986, 0.6617793617190961}}]}, 
    {Arrowheads[{{0.027020292811707966`, 1.}}], 
     ArrowBox[{{-1.220300677391879, 
      0.7667920668523315}, {-1.0654136083224075`, 0.9474936474333817}}]}, 
    {Arrowheads[{{0.031154430007009296`, 1.}}], 
     ArrowBox[{{-1.2461151889034576`, 
      1.0525063525666172`}, {-1.0395990968108288`, 1.2332079331476675`}}]}, 
    {Arrowheads[{{0.03577451234031671, 1.}}], 
     ArrowBox[{{-1.2719297004150363`, 
      1.3382206382809028`}, {-1.0137845852992504`, 1.518922218861953}}]}, 
    {Arrowheads[{{0.040715450335320306`, 1.}}], 
     ArrowBox[{{-1.2977442119266147`, 
      1.6239349239951884`}, {-0.9879700737876717, 1.8046365045762387`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{-1.3235587234381934`, 
      1.909649209709474}, {-0.9621555622760931, 2.0903507902905245`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{-0.6764412765618073, -2.090350790290525}, \
{-1.0378444377239078`, -1.9096492097094748`}}]}, 
    {Arrowheads[{{0.04071545033532032, 1.}}], 
     ArrowBox[{{-0.702255788073386, -1.8046365045762396`}, \
{-1.0120299262123291`, -1.6239349239951892`}}]}, 
    {Arrowheads[{{0.03577451234031675, 1.}}], 
     ArrowBox[{{-0.7280702995849645, -1.518922218861954}, \
{-0.9862154147007507, -1.3382206382809037`}}]}, 
    {Arrowheads[{{0.031154430007009307`, 1.}}], 
     ArrowBox[{{-0.753884811096543, -1.2332079331476684`}, \
{-0.9604009031891719, -1.052506352566618}}]}, 
    {Arrowheads[{{0.027020292811707966`, 1.}}], 
     ArrowBox[{{-0.7796993226081217, -0.9474936474333826}, \
{-0.9345863916775933, -0.7667920668523325}}]}, 
    {Arrowheads[{{0.02362856061832512, 1.}}], 
     ArrowBox[{{-0.8055138341197002, -0.661779361719097}, \
{-0.9087718801660147, -0.4810777811380467}}]}, 
    {Arrowheads[{{0.02133627120309264, 1.}}], 
     ArrowBox[{{-0.8313283456312789, -0.37606507600481126`}, \
{-0.8829573686544362, -0.19536349542376102`}}]}, 
    {Arrowheads[{{0.02051533571513285, 1.}}], 
     ArrowBox[{{-0.8571428571428575, -0.09035079029052558}, \
{-0.8571428571428577, 0.09035079029052469}}]}, 
    {Arrowheads[{{0.021336271203092637`, 1.}}], 
     ArrowBox[{{-0.8829573686544361, 
      0.19536349542376014`}, {-0.8313283456312789, 0.3760650760048104}}]}, 
    {Arrowheads[{{0.023628560618325106`, 1.}}], 
     ArrowBox[{{-0.9087718801660147, 
      0.48107778113804583`}, {-0.8055138341197005, 0.6617793617190961}}]}, 
    {Arrowheads[{{0.027020292811707983`, 1.}}], 
     ArrowBox[{{-0.9345863916775934, 
      0.7667920668523315}, {-0.7796993226081217, 0.9474936474333817}}]}, 
    {Arrowheads[{{0.031154430007009296`, 1.}}], 
     ArrowBox[{{-0.9604009031891719, 
      1.0525063525666172`}, {-0.7538848110965432, 1.2332079331476675`}}]}, 
    {Arrowheads[{{0.03577451234031672, 1.}}], 
     ArrowBox[{{-0.9862154147007505, 
      1.3382206382809028`}, {-0.7280702995849645, 1.518922218861953}}]}, 
    {Arrowheads[{{0.04071545033532032, 1.}}], 
     ArrowBox[{{-1.0120299262123291`, 
      1.6239349239951884`}, {-0.702255788073386, 1.8046365045762387`}}]}, 
    {Arrowheads[{{0.045873685240266325`, 1.}}], 
     ArrowBox[{{-1.0378444377239078`, 
      1.909649209709474}, {-0.6764412765618073, 2.0903507902905245`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{-0.3907269908475216, -2.090350790290525}, \
{-0.7521301520096221, -1.9096492097094748`}}]}, 
    {Arrowheads[{{0.04071545033532033, 1.}}], 
     ArrowBox[{{-0.4165415023591002, -1.8046365045762396`}, \
{-0.7263156404980435, -1.6239349239951892`}}]}, 
    {Arrowheads[{{0.035774512340316734`, 1.}}], 
     ArrowBox[{{-0.4423560138706788, -1.518922218861954}, \
{-0.7005011289864649, -1.3382206382809037`}}]}, 
    {Arrowheads[{{0.031154430007009314`, 1.}}], 
     ArrowBox[{{-0.46817052538225734`, -1.2332079331476684`}, \
{-0.6746866174748863, -1.052506352566618}}]}, 
    {Arrowheads[{{0.027020292811707973`, 1.}}], 
     ArrowBox[{{-0.493985036893836, -0.9474936474333826}, \
{-0.6488721059633077, -0.7667920668523325}}]}, 
    {Arrowheads[{{0.02362856061832512, 1.}}], 
     ArrowBox[{{-0.5197995484054145, -0.661779361719097}, \
{-0.623057594451729, -0.4810777811380467}}]}, 
    {Arrowheads[{{0.02133627120309264, 1.}}], 
     ArrowBox[{{-0.5456140599169932, -0.37606507600481126`}, \
{-0.5972430829401505, -0.19536349542376102`}}]}, 
    {Arrowheads[{{0.02051533571513285, 1.}}], 
     ArrowBox[{{-0.5714285714285718, -0.09035079029052558}, \
{-0.571428571428572, 0.09035079029052469}}]}, 
    {Arrowheads[{{0.021336271203092633`, 1.}}], 
     ArrowBox[{{-0.5972430829401504, 
      0.19536349542376014`}, {-0.5456140599169933, 0.3760650760048104}}]}, 
    {Arrowheads[{{0.023628560618325113`, 1.}}], 
     ArrowBox[{{-0.623057594451729, 
      0.48107778113804583`}, {-0.5197995484054146, 0.6617793617190961}}]}, 
    {Arrowheads[{{0.027020292811707973`, 1.}}], 
     ArrowBox[{{-0.6488721059633076, 
      0.7667920668523315}, {-0.49398503689383605`, 0.9474936474333817}}]}, 
    {Arrowheads[{{0.031154430007009296`, 1.}}], 
     ArrowBox[{{-0.6746866174748862, 
      1.0525063525666172`}, {-0.46817052538225745`, 1.2332079331476675`}}]}, 
    {Arrowheads[{{0.03577451234031671, 1.}}], 
     ArrowBox[{{-0.7005011289864648, 
      1.3382206382809028`}, {-0.4423560138706789, 1.518922218861953}}]}, 
    {Arrowheads[{{0.04071545033532032, 1.}}], 
     ArrowBox[{{-0.7263156404980434, 
      1.6239349239951884`}, {-0.41654150235910026`, 1.8046365045762387`}}]}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     ArrowBox[{{-0.752130152009622, 
      1.909649209709474}, {-0.39072699084752166`, 2.0903507902905245`}}]}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     ArrowBox[{{-0.10501270513323588`, -2.090350790290525}, \
{-0.4664158662953365, -1.9096492097094748`}}]}, 
    {Arrowheads[{{0.04071545033532033, 1.}}], 
     ArrowBox[{{-0.1308272166448145, -1.8046365045762396`}, \
{-0.4406013547837578, -1.6239349239951892`}}]}, 
    {Arrowheads[{{0.03577451234031675, 1.}}], 
     ArrowBox[{{-0.15664172815639307`, -1.518922218861954}, \
{-0.4147868432721793, -1.3382206382809037`}}]}, 
    {Arrowheads[{{0.031154430007009314`, 1.}}], 
     ArrowBox[{{-0.18245623966797167`, -1.2332079331476684`}, \
{-0.38897233176060064`, -1.052506352566618}}]}, 
    {Arrowheads[{{0.027020292811707973`, 1.}}], 
     ArrowBox[{{-0.2082707511795503, -0.9474936474333826}, \
{-0.363157820249022, -0.7667920668523325}}]}, 
    {Arrowheads[{{0.02362856061832512, 1.}}], 
     ArrowBox[{{-0.2340852626911289, -0.661779361719097}, \
{-0.3373433087374434, -0.4810777811380467}}]}, 
    {Arrowheads[{{0.02133627120309264, 1.}}], 
     ArrowBox[{{-0.2598997742027075, -0.37606507600481126`}, \
{-0.3115287972258648, -0.19536349542376102`}}]}, 
    {Arrowheads[{{0.02051533571513285, 1.}}], 
     ArrowBox[{{-0.2857142857142861, -0.09035079029052558}, \
{-0.28571428571428614`, 0.09035079029052469}}]}, 
    {Arrowheads[{{0.021336271203092633`, 1.}}], 
     ArrowBox[{{-0.3115287972258647, 
      0.19536349542376014`}, {-0.2598997742027076, 0.3760650760048104}}]}, 
    {Arrowheads[{{0.023628560618325113`, 1.}}], 
     ArrowBox[{{-0.33734330873744334`, 
      0.48107778113804583`}, {-0.23408526269112898`, 0.6617793617190961}}]}, 
    {Arrowheads[{{0.027020292811707976`, 1.}}], 
     ArrowBox[{{-0.36315782024902193`, 
      0.7667920668523315}, {-0.20827075117955035`, 0.9474936474333817}}]}, 
    {Arrowheads[{{0.031154430007009296`, 1.}}], 
     ArrowBox[{{-0.38897233176060053`, 
      1.0525063525666172`}, {-0.18245623966797175`, 1.2332079331476675`}}]}, 
    {Arrowheads[{{0.03577451234031671, 1.}}], 
     ArrowBox[{{-0.4147868432721791, 
      1.3382206382809028`}, {-0.15664172815639318`, 1.518922218861953}}]}, 
    {Arrowheads[{{0.04071545033532032, 1.}}], 
     ArrowBox[{{-0.4406013547837577, 
      1.6239349239951884`}, {-0.13082721664481456`, 1.8046365045762387`}}]}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     ArrowBox[{{-0.4664158662953363, 
      1.909649209709474}, {-0.10501270513323596`, 2.0903507902905245`}}]}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     ArrowBox[{{
      0.18070158058104982`, -2.090350790290525}, {-0.1807015805810507, \
-1.9096492097094748`}}]}, 
    {Arrowheads[{{0.04071545033532033, 1.}}], 
     ArrowBox[{{
      0.1548870690694712, -1.8046365045762396`}, {-0.15488706906947208`, \
-1.6239349239951892`}}]}, 
    {Arrowheads[{{0.03577451234031674, 1.}}], 
     ArrowBox[{{
      0.12907255755789263`, -1.518922218861954}, {-0.1290725575578935, \
-1.3382206382809037`}}]}, 
    {Arrowheads[{{0.031154430007009307`, 1.}}], 
     ArrowBox[{{
      0.10325804604631403`, -1.2332079331476684`}, {-0.10325804604631492`, \
-1.052506352566618}}]}, 
    {Arrowheads[{{0.027020292811707973`, 1.}}], 
     ArrowBox[{{
      0.0774435345347354, -0.9474936474333826}, {-0.07744353453473629, \
-0.7667920668523325}}]}, 
    {Arrowheads[{{0.02362856061832512, 1.}}], 
     ArrowBox[{{
      0.05162902302315681, -0.661779361719097}, {-0.0516290230231577, \
-0.4810777811380467}}]}, 
    {Arrowheads[{{0.02133627120309264, 1.}}], 
     ArrowBox[{{
      0.0258145115115782, -0.37606507600481126`}, {-0.02581451151157909, \
-0.19536349542376102`}}]}, 
    {Arrowheads[{{0.02051533571513285, 1.}}], 
     ArrowBox[{{-4.039653987806146*^-16, -0.09035079029052558}, \
{-4.8421302091951065`*^-16, 0.09035079029052469}}]}, 
    {Arrowheads[{{0.021336271203092633`, 1.}}], 
     ArrowBox[{{-0.025814511511579014`, 0.19536349542376014`}, {
      0.025814511511578125`, 0.3760650760048104}}]}, 
    {Arrowheads[{{0.02362856061832511, 1.}}], 
     ArrowBox[{{-0.05162902302315761, 0.48107778113804583`}, {
      0.05162902302315672, 0.6617793617190961}}]}, 
    {Arrowheads[{{0.027020292811707976`, 1.}}], 
     ArrowBox[{{-0.07744353453473624, 0.7667920668523315}, {
      0.07744353453473535, 0.9474936474333817}}]}, 
    {Arrowheads[{{0.031154430007009296`, 1.}}], 
     ArrowBox[{{-0.10325804604631482`, 1.0525063525666172`}, {
      0.10325804604631393`, 1.2332079331476675`}}]}, 
    {Arrowheads[{{0.035774512340316714`, 1.}}], 
     ArrowBox[{{-0.1290725575578934, 1.3382206382809028`}, {
      0.12907255755789251`, 1.518922218861953}}]}, 
    {Arrowheads[{{0.04071545033532032, 1.}}], 
     ArrowBox[{{-0.15488706906947203`, 1.6239349239951884`}, {
      0.15488706906947114`, 1.8046365045762387`}}]}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     ArrowBox[{{-0.18070158058105062`, 1.909649209709474}, {
      0.18070158058104974`, 2.0903507902905245`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{0.4664158662953355, -2.090350790290525}, {
      0.10501270513323499`, -1.9096492097094748`}}]}, 
    {Arrowheads[{{0.04071545033532033, 1.}}], 
     ArrowBox[{{0.4406013547837569, -1.8046365045762396`}, {
      0.13082721664481362`, -1.6239349239951892`}}]}, 
    {Arrowheads[{{0.035774512340316734`, 1.}}], 
     ArrowBox[{{0.4147868432721783, -1.518922218861954}, {
      0.15664172815639218`, -1.3382206382809037`}}]}, 
    {Arrowheads[{{0.031154430007009314`, 1.}}], 
     ArrowBox[{{0.38897233176059975`, -1.2332079331476684`}, {
      0.18245623966797078`, -1.052506352566618}}]}, 
    {Arrowheads[{{0.027020292811707973`, 1.}}], 
     ArrowBox[{{0.3631578202490211, -0.9474936474333826}, {
      0.2082707511795494, -0.7667920668523325}}]}, 
    {Arrowheads[{{0.02362856061832512, 1.}}], 
     ArrowBox[{{0.3373433087374425, -0.661779361719097}, {
      0.234085262691128, -0.4810777811380467}}]}, 
    {Arrowheads[{{0.02133627120309264, 1.}}], 
     ArrowBox[{{0.3115287972258639, -0.37606507600481126`}, {
      0.2598997742027066, -0.19536349542376102`}}]}, 
    {Arrowheads[{{0.02051533571513285, 1.}}], 
     ArrowBox[{{0.2857142857142853, -0.09035079029052558}, {
      0.28571428571428525`, 0.09035079029052469}}]}, 
    {Arrowheads[{{0.021336271203092633`, 1.}}], 
     ArrowBox[{{0.2598997742027067, 0.19536349542376014`}, {
      0.3115287972258638, 0.3760650760048104}}]}, 
    {Arrowheads[{{0.023628560618325113`, 1.}}], 
     ArrowBox[{{0.2340852626911281, 0.48107778113804583`}, {
      0.33734330873744245`, 0.6617793617190961}}]}, 
    {Arrowheads[{{0.027020292811707976`, 1.}}], 
     ArrowBox[{{0.20827075117954946`, 0.7667920668523315}, {
      0.36315782024902105`, 0.9474936474333817}}]}, 
    {Arrowheads[{{0.031154430007009296`, 1.}}], 
     ArrowBox[{{0.18245623966797087`, 1.0525063525666172`}, {
      0.38897233176059964`, 1.2332079331476675`}}]}, 
    {Arrowheads[{{0.03577451234031672, 1.}}], 
     ArrowBox[{{0.1566417281563923, 1.3382206382809028`}, {0.4147868432721783,
       1.518922218861953}}]}, 
    {Arrowheads[{{0.04071545033532032, 1.}}], 
     ArrowBox[{{0.13082721664481367`, 1.6239349239951884`}, {
      0.44060135478375684`, 1.8046365045762387`}}]}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     ArrowBox[{{0.10501270513323507`, 1.909649209709474}, {
      0.46641586629533544`, 2.0903507902905245`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{0.7521301520096212, -2.090350790290525}, {
      0.3907269908475207, -1.9096492097094748`}}]}, 
    {Arrowheads[{{0.04071545033532033, 1.}}], 
     ArrowBox[{{0.7263156404980426, -1.8046365045762396`}, {
      0.4165415023590993, -1.6239349239951892`}}]}, 
    {Arrowheads[{{0.035774512340316734`, 1.}}], 
     ArrowBox[{{0.700501128986464, -1.518922218861954}, {
      0.4423560138706779, -1.3382206382809037`}}]}, 
    {Arrowheads[{{0.031154430007009314`, 1.}}], 
     ArrowBox[{{0.6746866174748855, -1.2332079331476684`}, {
      0.46817052538225645`, -1.052506352566618}}]}, 
    {Arrowheads[{{0.027020292811707973`, 1.}}], 
     ArrowBox[{{0.6488721059633068, -0.9474936474333826}, {
      0.4939850368938351, -0.7667920668523325}}]}, 
    {Arrowheads[{{0.02362856061832512, 1.}}], 
     ArrowBox[{{0.6230575944517283, -0.661779361719097}, {
      0.5197995484054138, -0.4810777811380467}}]}, 
    {Arrowheads[{{0.02133627120309264, 1.}}], 
     ArrowBox[{{0.5972430829401496, -0.37606507600481126`}, {
      0.5456140599169923, -0.19536349542376102`}}]}, 
    {Arrowheads[{{0.02051533571513285, 1.}}], 
     ArrowBox[{{0.571428571428571, -0.09035079029052558}, {0.5714285714285708,
       0.09035079029052469}}]}, 
    {Arrowheads[{{0.021336271203092633`, 1.}}], 
     ArrowBox[{{0.5456140599169924, 0.19536349542376014`}, {
      0.5972430829401495, 0.3760650760048104}}]}, 
    {Arrowheads[{{0.023628560618325113`, 1.}}], 
     ArrowBox[{{0.5197995484054138, 0.48107778113804583`}, {
      0.6230575944517281, 0.6617793617190961}}]}, 
    {Arrowheads[{{0.027020292811707973`, 1.}}], 
     ArrowBox[{{0.49398503689383516`, 0.7667920668523315}, {
      0.6488721059633067, 0.9474936474333817}}]}, 
    {Arrowheads[{{0.031154430007009296`, 1.}}], 
     ArrowBox[{{0.46817052538225656`, 1.0525063525666172`}, {
      0.6746866174748853, 1.2332079331476675`}}]}, 
    {Arrowheads[{{0.03577451234031671, 1.}}], 
     ArrowBox[{{0.442356013870678, 1.3382206382809028`}, {0.7005011289864639, 
      1.518922218861953}}]}, 
    {Arrowheads[{{0.04071545033532032, 1.}}], 
     ArrowBox[{{0.41654150235909937`, 1.6239349239951884`}, {
      0.7263156404980425, 1.8046365045762387`}}]}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     ArrowBox[{{0.39072699084752077`, 1.909649209709474}, {0.7521301520096211,
       2.0903507902905245`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{1.0378444377239069`, -2.090350790290525}, {
      0.6764412765618064, -1.9096492097094748`}}]}, 
    {Arrowheads[{{0.04071545033532032, 1.}}], 
     ArrowBox[{{1.0120299262123282`, -1.8046365045762396`}, {
      0.7022557880733851, -1.6239349239951892`}}]}, 
    {Arrowheads[{{0.03577451234031675, 1.}}], 
     ArrowBox[{{0.9862154147007497, -1.518922218861954}, {
      0.7280702995849635, -1.3382206382809037`}}]}, 
    {Arrowheads[{{0.031154430007009307`, 1.}}], 
     ArrowBox[{{0.9604009031891712, -1.2332079331476684`}, {
      0.7538848110965423, -1.052506352566618}}]}, 
    {Arrowheads[{{0.027020292811707973`, 1.}}], 
     ArrowBox[{{0.9345863916775925, -0.9474936474333826}, {
      0.7796993226081208, -0.7667920668523325}}]}, 
    {Arrowheads[{{0.02362856061832512, 1.}}], 
     ArrowBox[{{0.908771880166014, -0.661779361719097}, {
      0.8055138341196995, -0.4810777811380467}}]}, 
    {Arrowheads[{{0.02133627120309264, 1.}}], 
     ArrowBox[{{0.8829573686544353, -0.37606507600481126`}, {
      0.831328345631278, -0.19536349542376102`}}]}, 
    {Arrowheads[{{0.02051533571513285, 1.}}], 
     ArrowBox[{{0.8571428571428567, -0.09035079029052558}, {
      0.8571428571428565, 0.09035079029052469}}]}, 
    {Arrowheads[{{0.021336271203092637`, 1.}}], 
     ArrowBox[{{0.8313283456312781, 0.19536349542376014`}, {
      0.8829573686544353, 0.3760650760048104}}]}, 
    {Arrowheads[{{0.023628560618325106`, 1.}}], 
     ArrowBox[{{0.8055138341196995, 0.48107778113804583`}, {
      0.9087718801660137, 0.6617793617190961}}]}, 
    {Arrowheads[{{0.027020292811707983`, 1.}}], 
     ArrowBox[{{0.7796993226081208, 0.7667920668523315}, {0.9345863916775925, 
      0.9474936474333817}}]}, 
    {Arrowheads[{{0.031154430007009282`, 1.}}], 
     ArrowBox[{{0.7538848110965423, 1.0525063525666172`}, {0.9604009031891709,
       1.2332079331476675`}}]}, 
    {Arrowheads[{{0.03577451234031672, 1.}}], 
     ArrowBox[{{0.7280702995849637, 1.3382206382809028`}, {0.9862154147007497,
       1.518922218861953}}]}, 
    {Arrowheads[{{0.04071545033532032, 1.}}], 
     ArrowBox[{{0.7022557880733851, 1.6239349239951884`}, {
      1.0120299262123282`, 1.8046365045762387`}}]}, 
    {Arrowheads[{{0.045873685240266325`, 1.}}], 
     ArrowBox[{{0.6764412765618064, 1.909649209709474}, {1.0378444377239069`, 
      2.0903507902905245`}}]}, 
    {Arrowheads[{{0.04587368524026631, 1.}}], 
     ArrowBox[{{1.3235587234381927`, -2.090350790290525}, {
      0.9621555622760921, -1.9096492097094748`}}]}, 
    {Arrowheads[{{0.04071545033532034, 1.}}], 
     ArrowBox[{{1.297744211926614, -1.8046365045762396`}, {
      0.9879700737876707, -1.6239349239951892`}}]}, 
    {Arrowheads[{{0.035774512340316734`, 1.}}], 
     ArrowBox[{{1.2719297004150354`, -1.518922218861954}, {
      1.0137845852992493`, -1.3382206382809037`}}]}, 
    {Arrowheads[{{0.031154430007009314`, 1.}}], 
     ArrowBox[{{1.2461151889034567`, -1.2332079331476684`}, {
      1.0395990968108277`, -1.052506352566618}}]}, 
    {Arrowheads[{{0.02702029281170796, 1.}}], 
     ArrowBox[{{1.220300677391878, -0.9474936474333826}, {
      1.0654136083224066`, -0.7667920668523325}}]}, 
    {Arrowheads[{{0.023628560618325127`, 1.}}], 
     ArrowBox[{{1.1944861658802997`, -0.661779361719097}, {
      1.091228119833985, -0.4810777811380467}}]}, 
    {Arrowheads[{{0.02133627120309264, 1.}}], 
     ArrowBox[{{1.168671654368721, -0.37606507600481126`}, {
      1.1170426313455637`, -0.19536349542376102`}}]}, 
    {Arrowheads[{{0.02051533571513285, 1.}}], 
     ArrowBox[{{1.1428571428571423`, -0.09035079029052558}, {
      1.1428571428571423`, 0.09035079029052469}}]}, 
    {Arrowheads[{{0.021336271203092633`, 1.}}], 
     ArrowBox[{{1.1170426313455637`, 0.19536349542376014`}, {
      1.1686716543687208`, 0.3760650760048104}}]}, 
    {Arrowheads[{{0.023628560618325113`, 1.}}], 
     ArrowBox[{{1.0912281198339853`, 0.48107778113804583`}, {
      1.1944861658802997`, 0.6617793617190961}}]}, 
    {Arrowheads[{{0.027020292811707966`, 1.}}], 
     ArrowBox[{{1.0654136083224066`, 0.7667920668523315}, {1.220300677391878, 
      0.9474936474333817}}]}, 
    {Arrowheads[{{0.031154430007009296`, 1.}}], 
     ArrowBox[{{1.039599096810828, 1.0525063525666172`}, {1.2461151889034567`,
       1.2332079331476675`}}]}, 
    {Arrowheads[{{0.03577451234031671, 1.}}], 
     ArrowBox[{{1.0137845852992493`, 1.3382206382809028`}, {
      1.2719297004150352`, 1.518922218861953}}]}, 
    {Arrowheads[{{0.040715450335320306`, 1.}}], 
     ArrowBox[{{0.9879700737876708, 1.6239349239951884`}, {
      1.2977442119266138`, 1.8046365045762387`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{0.9621555622760922, 1.909649209709474}, {1.3235587234381925`, 
      2.0903507902905245`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{1.6092730091524783`, -2.090350790290525}, {
      1.2478698479903778`, -1.9096492097094748`}}]}, 
    {Arrowheads[{{0.04071545033532034, 1.}}], 
     ArrowBox[{{1.5834584976408996`, -1.8046365045762396`}, {
      1.2736843595019562`, -1.6239349239951892`}}]}, 
    {Arrowheads[{{0.035774512340316734`, 1.}}], 
     ArrowBox[{{1.557643986129321, -1.518922218861954}, {
      1.299498871013535, -1.3382206382809037`}}]}, 
    {Arrowheads[{{0.031154430007009314`, 1.}}], 
     ArrowBox[{{1.5318294746177423`, -1.2332079331476684`}, {
      1.3253133825251133`, -1.052506352566618}}]}, 
    {Arrowheads[{{0.02702029281170796, 1.}}], 
     ArrowBox[{{1.5060149631061637`, -0.9474936474333826}, {
      1.3511278940366922`, -0.7667920668523325}}]}, 
    {Arrowheads[{{0.023628560618325127`, 1.}}], 
     ArrowBox[{{1.4802004515945852`, -0.661779361719097}, {
      1.3769424055482706`, -0.4810777811380467}}]}, 
    {Arrowheads[{{0.02133627120309264, 1.}}], 
     ArrowBox[{{1.4543859400830066`, -0.37606507600481126`}, {
      1.4027569170598493`, -0.19536349542376102`}}]}, 
    {Arrowheads[{{0.02051533571513285, 1.}}], 
     ArrowBox[{{1.428571428571428, -0.09035079029052558}, {1.428571428571428, 
      0.09035079029052469}}]}, 
    {Arrowheads[{{0.021336271203092633`, 1.}}], 
     ArrowBox[{{1.4027569170598493`, 0.19536349542376014`}, {
      1.4543859400830064`, 0.3760650760048104}}]}, 
    {Arrowheads[{{0.023628560618325113`, 1.}}], 
     ArrowBox[{{1.3769424055482709`, 0.48107778113804583`}, {
      1.4802004515945852`, 0.6617793617190961}}]}, 
    {Arrowheads[{{0.027020292811707966`, 1.}}], 
     ArrowBox[{{1.3511278940366922`, 0.7667920668523315}, {
      1.5060149631061637`, 0.9474936474333817}}]}, 
    {Arrowheads[{{0.031154430007009296`, 1.}}], 
     ArrowBox[{{1.3253133825251135`, 1.0525063525666172`}, {
      1.5318294746177423`, 1.2332079331476675`}}]}, 
    {Arrowheads[{{0.03577451234031671, 1.}}], 
     ArrowBox[{{1.299498871013535, 1.3382206382809028`}, {1.5576439861293208`,
       1.518922218861953}}]}, 
    {Arrowheads[{{0.0407154503353203, 1.}}], 
     ArrowBox[{{1.2736843595019565`, 1.6239349239951884`}, {
      1.5834584976408994`, 1.8046365045762387`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{1.2478698479903778`, 1.909649209709474}, {1.609273009152478, 
      2.0903507902905245`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{1.8949872948667639`, -2.090350790290525}, {
      1.5335841337046634`, -1.9096492097094748`}}]}, 
    {Arrowheads[{{0.04071545033532034, 1.}}], 
     ArrowBox[{{1.8691727833551852`, -1.8046365045762396`}, {
      1.5593986452162418`, -1.6239349239951892`}}]}, 
    {Arrowheads[{{0.035774512340316734`, 1.}}], 
     ArrowBox[{{1.8433582718436066`, -1.518922218861954}, {
      1.5852131567278205`, -1.3382206382809037`}}]}, 
    {Arrowheads[{{0.031154430007009314`, 1.}}], 
     ArrowBox[{{1.817543760332028, -1.2332079331476684`}, {
      1.611027668239399, -1.052506352566618}}]}, 
    {Arrowheads[{{0.02702029281170796, 1.}}], 
     ArrowBox[{{1.7917292488204493`, -0.9474936474333826}, {
      1.6368421797509778`, -0.7667920668523325}}]}, 
    {Arrowheads[{{0.023628560618325127`, 1.}}], 
     ArrowBox[{{1.7659147373088708`, -0.661779361719097}, {
      1.6626566912625562`, -0.4810777811380467}}]}, 
    {Arrowheads[{{0.02133627120309264, 1.}}], 
     ArrowBox[{{1.7401002257972922`, -0.37606507600481126`}, {
      1.6884712027741349`, -0.19536349542376102`}}]}, 
    {Arrowheads[{{0.02051533571513285, 1.}}], 
     ArrowBox[{{1.7142857142857135`, -0.09035079029052558}, {
      1.7142857142857135`, 0.09035079029052469}}]}, 
    {Arrowheads[{{0.021336271203092633`, 1.}}], 
     ArrowBox[{{1.6884712027741349`, 0.19536349542376014`}, {
      1.740100225797292, 0.3760650760048104}}]}, 
    {Arrowheads[{{0.023628560618325113`, 1.}}], 
     ArrowBox[{{1.6626566912625564`, 0.48107778113804583`}, {
      1.7659147373088708`, 0.6617793617190961}}]}, 
    {Arrowheads[{{0.027020292811707966`, 1.}}], 
     ArrowBox[{{1.6368421797509778`, 0.7667920668523315}, {
      1.7917292488204493`, 0.9474936474333817}}]}, 
    {Arrowheads[{{0.031154430007009296`, 1.}}], 
     ArrowBox[{{1.6110276682393991`, 1.0525063525666172`}, {1.817543760332028,
       1.2332079331476675`}}]}, 
    {Arrowheads[{{0.03577451234031671, 1.}}], 
     ArrowBox[{{1.5852131567278205`, 1.3382206382809028`}, {
      1.8433582718436063`, 1.518922218861953}}]}, 
    {Arrowheads[{{0.0407154503353203, 1.}}], 
     ArrowBox[{{1.559398645216242, 1.6239349239951884`}, {1.869172783355185, 
      1.8046365045762387`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{1.5335841337046634`, 1.909649209709474}, {1.8949872948667636`,
       2.0903507902905245`}}]}, 
    {Arrowheads[{{0.045873685240266304`, 1.}}], 
     ArrowBox[{{2.1807015805810495`, -2.090350790290525}, {
      1.819298419418949, -1.9096492097094748`}}]}, 
    {Arrowheads[{{0.04071545033532032, 1.}}], 
     ArrowBox[{{2.1548870690694706`, -1.8046365045762396`}, {
      1.8451129309305274`, -1.6239349239951892`}}]}, 
    {Arrowheads[{{0.035774512340316734`, 1.}}], 
     ArrowBox[{{2.129072557557892, -1.518922218861954}, {
      1.870927442442106, -1.3382206382809037`}}]}, 
    {Arrowheads[{{0.031154430007009334`, 1.}}], 
     ArrowBox[{{2.1032580460463137`, -1.2332079331476684`}, {
      1.8967419539536845`, -1.052506352566618}}]}, 
    {Arrowheads[{{0.02702029281170796, 1.}}], 
     ArrowBox[{{2.077443534534735, -0.9474936474333826}, {
      1.9225564654652634`, -0.7667920668523325}}]}, 
    {Arrowheads[{{0.023628560618325127`, 1.}}], 
     ArrowBox[{{2.0516290230231564`, -0.661779361719097}, {
      1.9483709769768418`, -0.4810777811380467}}]}, 
    {Arrowheads[{{0.021336271203092633`, 1.}}], 
     ArrowBox[{{2.0258145115115775`, -0.37606507600481126`}, {
      1.9741854884884205`, -0.19536349542376102`}}]}, 
    {Arrowheads[{{0.02051533571513285, 1.}}], 
     ArrowBox[{{1.9999999999999991`, -0.09035079029052558}, {
      1.9999999999999991`, 0.09035079029052469}}]}, 
    {Arrowheads[{{0.021336271203092644`, 1.}}], 
     ArrowBox[{{1.9741854884884205`, 0.19536349542376014`}, {
      2.025814511511578, 0.3760650760048104}}]}, 
    {Arrowheads[{{0.02362856061832509, 1.}}], 
     ArrowBox[{{1.948370976976842, 0.48107778113804583`}, {2.051629023023156, 
      0.6617793617190961}}]}, 
    {Arrowheads[{{0.027020292811707966`, 1.}}], 
     ArrowBox[{{1.9225564654652634`, 0.7667920668523315}, {2.077443534534735, 
      0.9474936474333817}}]}, 
    {Arrowheads[{{0.031154430007009314`, 1.}}], 
     ArrowBox[{{1.8967419539536847`, 1.0525063525666172`}, {
      2.1032580460463137`, 1.2332079331476675`}}]}, 
    {Arrowheads[{{0.035774512340316734`, 1.}}], 
     ArrowBox[{{1.870927442442106, 1.3382206382809028`}, {2.129072557557892, 
      1.518922218861953}}]}, 
    {Arrowheads[{{0.0407154503353203, 1.}}], 
     ArrowBox[{{1.8451129309305276`, 1.6239349239951884`}, {
      2.1548870690694706`, 1.8046365045762387`}}]}, 
    {Arrowheads[{{0.045873685240266276`, 1.}}], 
     ArrowBox[{{1.819298419418949, 1.909649209709474}, {2.180701580581049, 
      2.0903507902905245`}}]}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "TransparentPolygonMesh" -> True},
  PlotRange->{{-2.2020305089104424`, 
   2.2020305089104424`}, {-2.2020305089104424`, 2.2020305089104424`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.6587567112412834`*^9}]
}, Open  ]],

Cell["\[LineSeparator]\[LineSeparator]#6 DIV and CURL of F", "Text",
 CellChangeTimes->{{3.658710796170186*^9, 3.658710800034481*^9}, {
  3.658710870063919*^9, 3.65871087273279*^9}, {3.6587523926505966`*^9, 
  3.6587523927866096`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Div", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "^", "2"}], "-", 
      RowBox[{"2", "z"}]}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"y", " ", "z"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.658710894046124*^9, 3.658710899228548*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", "y"}], "+", 
  RowBox[{"y", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"y", " ", "z"}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.658710900781077*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Curl", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "^", "2"}], "-", 
      RowBox[{"2", "z"}]}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"y", " ", "z"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6587108079945793`*^9, 3.6587108416676292`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"z", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"y", " ", "z"}], "]"}]}]}], ",", "0", ",", 
   RowBox[{"-", "x"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.658710837482623*^9, 3.658710842535186*^9}}]
}, Open  ]],

Cell["\<\


LINE INTEGRAL\
\>", "Text",
 CellChangeTimes->{{3.658758548363016*^9, 3.6587585543692465`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{
    RowBox[{"2", " ", "t"}], "+", "1"}]}], ";", 
  RowBox[{"y", "=", 
   RowBox[{"4", " ", "t"}]}], ";", " ", 
  RowBox[{"z", "=", 
   RowBox[{
    RowBox[{"-", "t"}], "+", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"myr", "=", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"rprime", "=", 
  RowBox[{"D", "[", 
   RowBox[{"myr", ",", "t"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myF", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2", " ", "x"}], ",", 
    RowBox[{
     RowBox[{"y", "^", "2"}], "+", "z"}], ",", 
    RowBox[{"x", "+", "y"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.658758559891859*^9, 3.65875861173023*^9}, {
  3.6587586435060043`*^9, 3.65875869306498*^9}, {3.6589575630865803`*^9, 
  3.6589576039271584`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "t"}]}], ",", 
   RowBox[{"4", " ", "t"}], ",", 
   RowBox[{"2", "-", "t"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6587586445355577`*^9, {3.6587586839549885`*^9, 3.658758694468917*^9}, 
   3.658957609286203*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6587586445355577`*^9, {3.6587586839549885`*^9, 3.658758694468917*^9}, 
   3.658957609297538*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "t"}]}], ")"}]}], ",", 
   RowBox[{"2", "-", "t", "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["t", "2"]}]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"6", " ", "t"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6587586445355577`*^9, {3.6587586839549885`*^9, 3.658758694468917*^9}, 
   3.65895760930604*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   RowBox[{"myF", ".", "rprime"}], 
   RowBox[{"\[DifferentialD]", "t"}]}]}]], "Input",
 CellChangeTimes->{{3.65895764344676*^9, 3.658957667967957*^9}}],

Cell[BoxData[
 FractionBox["94", "3"]], "Output",
 CellChangeTimes->{3.658957669220694*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellChangeTimes->{{3.658957672848173*^9, 3.658957675225535*^9}}],

Cell[BoxData["31.333333333333332`"], "Output",
 CellChangeTimes->{3.658957679167782*^9}]
}, Open  ]],

Cell["\[LineSeparator]\[LineSeparator]GREEN\[CloseCurlyQuote]s theorem \
problem", "Text",
 CellChangeTimes->{{3.658707277156745*^9, 3.658707284656414*^9}, {
  3.658752396939025*^9, 3.658752397059037*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myF", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "+", 
     RowBox[{"x", " ", 
      RowBox[{"y", "^", "2"}]}]}], ",", 
    RowBox[{
     RowBox[{"Exp", "[", "y", "]"}], "+", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "/", "2"}]}], ",", "0"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.658706838299753*^9, 3.658706879627418*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "y"], "+", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.658706880652198*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Curl", "[", 
  RowBox[{"myF", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.658706890095503*^9, 3.658706895450811*^9}, {
  3.658706935671352*^9, 3.658706943689159*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", 
   RowBox[{"x", "-", 
    RowBox[{"2", " ", "x", " ", "y"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.6587069445872803`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "2"], 
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", "1"], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", 
      RowBox[{"2", "x", " ", "y"}]}], ")"}], 
    RowBox[{"\[DifferentialD]", "x"}], 
    RowBox[{"\[DifferentialD]", "y"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6587070903865633`*^9, 3.6587071477812777`*^9}}],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellChangeTimes->{{3.658707142240567*^9, 3.658707148726918*^9}}]
}, Open  ]],

Cell["\[LineSeparator]\[LineSeparator]DIVERGENCE theorem problem", "Text",
 CellChangeTimes->{{3.658708420890914*^9, 3.6587084293720503`*^9}, {
  3.658752403142108*^9, 3.6587524032669096`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Div", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", " ", "y"}], " ", "+", 
      RowBox[{"3", " ", "z"}]}], ",", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"x", "+", "8"}], "]"}], "-", "y"}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"x", " ", 
        RowBox[{"y", "^", "2"}]}], "]"}], " ", "-", 
      RowBox[{"3", " ", "z"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.658708443062189*^9, 3.658708551597643*^9}, {
  3.658708582407724*^9, 3.658708733861198*^9}}],

Cell[BoxData[
 RowBox[{"-", "3"}]], "Output",
 CellChangeTimes->{{3.658708493753986*^9, 3.65870850355832*^9}, 
   3.6587085523126297`*^9, {3.658708638700392*^9, 3.658708656708231*^9}, 
   3.658708734509489*^9}]
}, Open  ]],

Cell[TextData[{
 "Answer is Volume * div = 8*-3=",
 StyleBox["-24",
  FontColor->RGBColor[1, 0, 0]],
 "."
}], "Text",
 CellChangeTimes->{{3.658752419912323*^9, 3.6587524497397213`*^9}}],

Cell["", "WolframAlphaShort"]
},
WindowSize->{808, 742},
WindowMargins->{{68, Automatic}, {Automatic, 10}},
FrontEndVersion->"10.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (June 27, \
2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 107, 1, 30, "Text"],
Cell[CellGroupData[{
Cell[690, 25, 640, 19, 47, "Input"],
Cell[1333, 46, 72, 1, 28, "Output"]
}, Open  ]],
Cell[1420, 50, 433, 5, 68, "Text"],
Cell[CellGroupData[{
Cell[1878, 59, 449, 12, 48, "Input"],
Cell[2330, 73, 121, 4, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2488, 82, 120, 2, 28, "Input"],
Cell[2611, 86, 107, 2, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2755, 93, 484, 15, 28, "Input"],
Cell[3242, 110, 389, 13, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3668, 128, 147, 3, 28, InheritFromParent],
Cell[3818, 133, 112, 1, 28, "Output"]
}, Open  ]],
Cell[3945, 137, 229, 3, 68, "Text"],
Cell[CellGroupData[{
Cell[4199, 144, 178, 4, 28, "Input"],
Cell[4380, 150, 545, 11, 24, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4962, 166, 371, 11, 28, "Input"],
Cell[5336, 179, 36852, 701, 376, "Output"]
}, Open  ]],
Cell[42203, 883, 235, 3, 68, "Text"],
Cell[CellGroupData[{
Cell[42463, 890, 424, 13, 28, "Input"],
Cell[42890, 905, 194, 6, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43121, 916, 429, 13, 28, "Input"],
Cell[43553, 931, 277, 8, 28, "Output"]
}, Open  ]],
Cell[43845, 942, 107, 5, 68, "Text"],
Cell[CellGroupData[{
Cell[43977, 951, 853, 25, 80, "Input"],
Cell[44833, 978, 301, 9, 28, "Output"],
Cell[45137, 989, 223, 6, 28, "Output"],
Cell[45363, 997, 441, 14, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45841, 1016, 234, 6, 47, "Input"],
Cell[46078, 1024, 91, 2, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46206, 1031, 120, 2, 28, "Input"],
Cell[46329, 1035, 88, 1, 62, "Output"]
}, Open  ]],
Cell[46432, 1039, 205, 3, 68, "Text"],
Cell[CellGroupData[{
Cell[46662, 1046, 396, 12, 28, "Input"],
Cell[47061, 1060, 347, 11, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47445, 1076, 256, 6, 28, "Input"],
Cell[47704, 1084, 186, 5, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47927, 1094, 394, 11, 47, "Input"],
Cell[48324, 1107, 111, 2, 28, "Output"]
}, Open  ]],
Cell[48450, 1112, 193, 2, 68, "Text"],
Cell[CellGroupData[{
Cell[48668, 1118, 644, 19, 28, "Input"],
Cell[49315, 1139, 210, 4, 28, "Output"]
}, Open  ]],
Cell[49540, 1146, 185, 6, 30, "Text"],
Cell[49728, 1154, 29, 0, 33, "WolframAlphaShort"]
}
]
*)

(* End of internal cache information *)
