<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>Video homework problems</title>
<meta name="week" content="1">
<meta name="description" content="
">
<?php include "../../classes/2.h" ?>

<h1>Video homework problems</h1>

<p class="screencast show">Example: <a href="https://drive.google.com/drive/folders/1-72v58Mfkcr_4iVnSgdOxa6bgJGO0FM9?usp=sharing">GDrive folder with video explanations</a> of solution to Schlicker, 9-1, problem #17.
<p class="show">For the video homework problems you will:
<ul>
  <li><b>Write up your solution</b> -- you can write it up directly in Notability.  OR you can write a solution out on paper and take pictures of each page of your solution.
  <li><b>Record a video</b> in which you show your already written up solution and then verbally narrate your solution, "walking through" your solution and saying what you did and why. Options to record include...
  <ul>
    <li><a href="#ipad">on your iPad</a></li>
    <li><a href="#zoom">using zoom</a></li>
  </ul>
  <li><a href="#gd">Upload to your Google Drive folder</a>
</ul>

<h4><a href="#VHW">Video HW problems</a></h4>
<ul>
<li>Rubric and 4-point scale.
<li><a href="#vhw1">VHW #1</a> - parametric description of a line segment.
</ul>

<h3 id="ipad">Recording...on your iPad</h3>
<h4>Write up your calculations</h4>
<p>You can write up your problem calculations directly in Notability.  Or, write up your problem calculations on sheets of paper.  From Notability, you can snap pictures of each paper sheet in your calculations.  Either way, you'll be ready to use your finger or stylus to highlight and draw attention to each stop along the way to your solution.

<h4>Recording your narration</h4>
<ol>
<li>With your write up in Notability, you can scroll through your solution and point out the highlights of your calculations.  Adding to what you've already written.

<li>Here are instructions for how to <a href="https://support.apple.com/en-us/HT207935">set up Control Center and make a screen recording on your iPad</a>.
  <ul><li>Once you've got Control Center set up, access it by <b>swiping down from the top-right</b> of your screen.
  <li>Make sure you see how to turn on the microphone before you start recording).
  </ul>

<li>Open up your writeup in notability. And start talking, and pointing and drawing as you scroll through your work.

<li>You can <a href="https://discussions.apple.com/thread/252860431">pause screen recording</a> if you need to stop in the middle.

<li><img src="0g/Photos.jpg" class="rightalign">Once you've stopped recording, you'll find your video in your <i>Photos</i>.  You can <a href="https://support.apple.com/en-us/HT207587">edit it from within Photos</a>:  It's fairly easily to 
trim off extraneous stuff at the beginning and end</a>

<li><img src="0g/Share.jpg" class="rightalign">From <i>Photos</i> you can tap the share icon to send your video to Google drive.  See "<a href="gd">Upload to your Google Drive folder</a>".
</ol>


<h3 id="ipad">Recording...using Zoom</h3>

<p>If you don't already have one, sign up for a free Zoom account.  Once you have such an account...
<ol><li>You can open a picture of your solution in, for example, a browser window. Or in Notability.
<li>Sign in at zoom.com, and start up your "personal meeting room".
<li>In zoom, click to start recording your meeting.  (You are the only participant!)
<li>Click the green <span style="background-color:#6f6"> &nbsp; You are screen sharing &nbsp; </span> &nbsp;bar and click "Annotate".  Now you can write on the screen that you're sharing.
<br><img src="0g/Annotate.jpg">
</ol>

<p>When you're finished find the video and get ready to upload to your Google Drive folder. [Still to find out: Where does the video go on an iPad? Maybe "Photos"?  On a desktop, look in <tt>Documents/Zoom</tt>.]


<h3 id="gd">Upload to your Google Drive folder</h3>
<p><b>Get started</b> by creating a folder somewhere on your Google Drive for the videos that you create.  Please give it this name:
<ul><tt>213-<i>your username</i></tt>, e.g. "213-janegc"</ul>
...and then share the folder with me.
<ul><li>the <tt>213-</tt> is for you to find this folder among all your other folders.
<li>the <tt><i>username</i></tt> is for me, so when I see a bunch of 213-* folders I can tell which one is yours.
</ul>

<h2 id="VHW">Video Homework problems</h2>

<p>The goal of the video homeworks are to develop and master core skills in multivariable calculus. In the Edfinity homework the goal is to practice and confirm that you got the correct answer. But for these assignments, my goal is probe deeper and  evaluate your <i>understanding</i> of some core concepts along with the skills.  I'm looking for more than just the right answer!

<p>For each one,  you'll submit a video of the work with your voice and pointer explaining every part.



<h3>4-point scale and rubric</h3> 

<p>You can submit each assessment as often as you like.  The grade in Moodle will only represent your most recent try. 

<p>For this rubric and approach, I've been inspired and copied from <a href="https://canvas.hamline.edu/courses/10615/assignments/syllabus">work by Andy Rundquist</a>.  Andy was inspired by and copied from <a href="https://drive.google.com/drive/folders/0B4h2KfPMJ6ONMDQzYTQ4OTYtYTIzMi00YmM4LWFmYTgtMGZmYjE0ODcwMGM2?hl=en&resourcekey=0-wWnxj_bFVF_i26cLWobTLg">Frank Noschese's work</a> on Standards-Based Grading (SBG).


<h4>4 point  scale</h4>




<p><b>Not completed at all, or not assessed: 0</b>

<p><b>Doesn't meet expectations: 1</b>
<ul><li>I need lots of help from my instructor (one-on-one).
<li>I have low confidence on how to do the skills and need more instruction.
<li>I need my textbook/notes at all times.
<li>I do not understand the concept/skills.
<li>I cannot correctly identify concepts and/or define vocabulary.
<li>I
 cannot make connections among ideas or extend the information.
<li>My responses lack detail necessary to demonstrate basic understanding.
<li>Cannot articulate most of the main ideas involved in the standard
</ul>

<p><b>Approaches expectations: 2</b>
<ul>
<li>I have a general understanding of the content/skills, but I'm also confused about some important parts.
<li>I need some help from my instructor (one-on-one or small group) to do the skills correctly
<li>I do not feel confident enough to do the skills on my own
<li>I need my textbook/notes most of the time.
<li>I can correctly identify concepts and/or define vocabulary; however I cannot make connections among ideas and/or independently extend my own learning.
<li>My responses demonstrate basic understanding of some main ideas, but significant information is missing.
</ul>

<p><b>Meets expectations: 3</b>
<ul>
<li>I understand the important things about the content/skills.
<li>I
 have confidence on how to do the skills on my own most of the time, but I need to continue practicing some parts that still give me problems.
<li>I need my handouts and notes once in a while.
<li>I am proficient at describing terms and independently connecting them with concepts.
<li>I understand not just the "what," but can correctly explain the "how" and "why" of technical and problem-solving processes.
<li>My responses demonstrate in-depth understanding of main ideas.
</ul>

<p><b>Exceeds expectations: 4</b>
<ul>
<li>I understand the content/skills completely and can explain them in detail.
<li>I can explain/teach the skills to another student.
<li>I have high confidence on how to do the skills.
<li>I can have a conversation about the skills.
<li>I can independently demonstrate extensions of my knowledge.
<li>I can create analogies and/or find connections between different areas within the field of study or between the math and other areas of study.
<li>My responses demonstrate in-depth understanding of main ideas and of related details.
</ul>



<h3>The problems</h3>
<h4 id="vhw1">VHW #1</h4>
<p>(This problem is very similar to Edfinity, 9.5, problem #7).
<p>Find a parametric vector equation of the form $\myv r(t)=\myv r_0 +t\myv v$, along with limits on the parameter $t$, which describes  the straight line segment connecting the two points $P=(1,5,-2)$ and $Q=(3,3,3)$.
<div class="justme result">
$$\myv r(t)=(1,5,-2)+t(2,-2,5); \ \text{and}\ \ 0\lt t \lt 1.$$
</div>

<h4 id="vhw2">VHW #2</h4>
<p>Choose one of these 2 problems to do:
<ul><li>

(This is problem 51 in Strang's textbook, section 6.2).
<p>Find the work done by force field $\myv F(x,y,z)=-\frac 12 x\,\uv i
-\frac 12 y\,\uv j+\frac14\,\uv k$
on a particle as it moves along the helix $\myv r(t)=\cos t\,\uv i+\sin t\,\uv j+t\,\uv k$
from point (1,0,0) to point (−1,0,3𝜋).
<p>Make a sketch of the helix and narrate how you set up and carry out the integration.  You may use CoCalc or WolframAlpha to carry out any non-trivial integral. If so, show how you coded your integral (for example, you might include a screenshot).
<p>You will find  that there is also a potential function here.  Carry out both the line integral of $\myv F\cdot d\myv r$ and calculate the integral using the potential.  (Both methods should agree!)
<li>Find the work done by the force field in Lab 06 on a particle along both of the paths in that lab. Make a sketch, and narrate how you set up the line integrals for those two paths.
<p>You will find  that there is also a potential function here.  Carry out the 2 line integral of $\myv F\cdot d\myv r$ and calculate the integral using the potential function and the fundamental theorem for gradient fields.  All 3 calculations should agree!
</ul>

<?php include "../../classes/3.h" ?>