<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Vectors [9.2]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>


<h1>Vectors [9.2]</h1>
<img src="0g/9.2.kayak.jpg"  class="big">
<p class="show">Many physical quantities--displacement, velocity, force to name a few--have both a magnitude and a <b>direction</b>.
<ul>
<li>vector terminology (2-d)
<li>vectors and scalars
<li>scalar multiplication of a vector
<li>vector addition and subtraction
<li>vector components
<li>using vectors to define lines
</ul>






<h2>Vectors</h2>

<p class="show incremental">
A <b>vector</b> is a quantity that has both a magnitude and a direction.
<p><img src="0g/9.2.vectoralt.jpg" class="rightalign">A vector is visually represented by an arrow or a directed line segment which connects two points: the <b>tail</b> (initial point / base) and the <b>head</b> (terminal point / tip).
<ul>
<li>The <b>length</b> of the arrow represents the <b>magnitude</b> of the vector (same as the distance between tail and head) and
<li>the arrow <b>points</b> in the <b>direction</b> of the vector.
</ul>
<p>Examples: wind velocity $\myv v$, force $\myv F$, magnetic field $\myv B$, acceleration $\myv a$.
<p>Two vectors are <b>equal</b> if they have the <b>same direction</b> and the <b>same magnitude</b>.  (Their positions don't matter.)<br>
<img src="0g/9.2.equalvectors.jpg"><br>







<h3>Scalar</h3>

<p class="show">A <b>scalar number</b> is, for our purposes, usually the same as a <b>real number</b>.

<p>A scalar number can be used to represent a quantity that does *not* have a direction.<br><br>
For example:  time $t$, temperature $T$, the probability that a fish in the ocean is a shark, $p_\text{shark}$.

<h4 >Notation</h4>
<p>Scalar quantities are typically typeset in italics:
$$\nonumber t, T, p_{\text shark}$$
<p>Vector quantities are typeset either in bold: yeehaw
$$\nonumber
\bf u, \bf v, \bf F
$$
and/or with an arrow on the top:
\left[\nonumber
 \myv u, \myv v, \myv F
\]

<p><span class="tip"><b>I encourage you</b>

to write an arrow over a letter to distinguish a vector from a scalar, when you're writing mathematics out by hand.
</span>
<p>In physics
<ul><li>"Speed", $v$, is a scalar.  It can have a value like 30 mph or 6 ft / sec and is always a positive number. 
<li>"Velocity", $\myv v$, is a vector quantity.  The magnitude of velocity,  $|\myv v|=v$, is speed. The velocity might have a magnitude like 4 meters / sec <i>and</i> a direction, such as north-east.
</ul>

<p>There is a general convention of using the scalar letter to indicate the magnitude (length) of the corresponding vector quantity.  For example, acceleration, $\myv a$ has a direction. And its magnitude is $a$:
$$a=|\myv a|=\text{the "norm" of }\myv a.$$
<p>Some interchangeable terms for the "length" of a vector:
<ul><li>magnitude<li>norm<li>measure</ul>

<h3>Scalar multiplication</h3>
<p class="show"><img src="0g/9.2.scalarmult.jpg">
<p class="show">If $c$ is a scalar, and $\myv v$ is a vector, then the <b>scalar multiple</b> $c\myv v$ is the vector with:
<ul>
<li> a length of $|c|$ times the length of $\myv v$, and
<li> a direction which is:
  <ul>
  <li>the <b>same</b> as $\myv v$ if $c \gt 0$, or
  <li><b>opposite</b> $\myv v$ if $c \lt 0$, or
  </ul>
</ul>




<p class="todo">
<img src="0g/9.2.parallel.jpg"><br>
What relationship (involving scalar multiplication) must exist between two vectors $\myv a$ and $\myv b$ iff [if and only if] they are <b>parallel</b>?




<h3>Adding vectors</h3>
<p class="show"><img src="0g/9.2.vectoraddition.jpg">
<ol>
<li>If $\myv u$ and $\myv v$ are vectors,
<li>positioned such that the initial point of $\myv v$ is at the terminal point of $\myv u$,
<li>then the <i>sum</i> $\myv u + \myv v$ is the vector from the initial point of $\myv u$ to the terminal point of $\myv v$.
</ol>

<h3>Vector subtraction</h3>
<p class="show">The idea is...
$$\nonumber
\myv u - \myv v \equiv \myv u + (-1)\myv v
$$
<p class="show"><img src="0g/9.2.vectorminus.jpg">

<p class="justme">How would you describe $\myv v - \myv u$?

<h3></h3>

<p class="show"><img src="0g/9.2.ab.jpg">
<p class="show">Sketch $\myv a - 2\myv b$
<p><img src="0g/9.2.a-2b.jpg">

<p class="todo">
<img src="0g/9.2.triangle.jpg" class="rightalign">
Use vector addition/subtraction to come up with an expression for $\myv c$ in terms of $\myv a$ and $\myv b$.



<h3>Components</h3>

<p class="show"><img src="0g/9.2.compy.jpg" class='rightalign'>The vector, $\myv a$, is drawn in a 2-d Cartesian coordinate system.  The difference between the $x$-coordinate of its tip and of its base is $\Delta x = a_1$.  The difference between the $y$-coordinate of its tip and of its base is $a_2$. We write:
  $$\myv a=\langle a_1,a_2\rangle$$
where
<ul>
<li>$a_1$ is the "$x$-component" of the vector $\myv a$, 
<li>$a_2$ is the " $y$-component" of $\myv a$.
</ul>



<p>All of these vectors have the same <b>components</b>: $\langle 3,2\rangle$.
<p class="show"><img src="0g/9.2.vector32.jpg">
<p class="todo">Are all of these vectors equal to each other, or not?

<p>Vector components in 3-d:
$$\myv a = \langle a_1,a_2,a_3\rangle \nonumber$$

<h3>Length</h3>
<p class="show">...of a vector in terms of its components.
<p class="show">Length $|\myv a|$ (a scalar number) of the 2-d vector $\myv a=\langle a_1,a_2 \rangle$:
$$|\myv a|=\sqrt{a_1^2+a_2^2}.$$

<p class="show">Length  of the 3-d vector $\myv a=\langle a_1,a_2,a_3 \rangle$:
$$|\myv a|=\sqrt{a_1^2+a_2^2+a_3^2}.$$






<h3>

Scalar multiplication (components)</h3>
<p><img src="0g/9.2.vectorcomponents.jpg" >  
<p>
$$c\myv a = \langle ca_1,ca_2 \rangle.$$

<h4>Vector addition (and subtraction)</h4>
<p class="show"><img src="0g/9.2.addem.jpg"><br>
$$ \myv a + \myv b = \langle a_1+b_1, a_2+b_2 \rangle $$
<p>Subtraction:
$$ \myv a - \myv b = \langle a_1-b_1, a_2-b_2 \rangle $$
<p>All these results generalize to 3-d.




<!--
<h3>To Do</h3>
<ul class="todo">
<li><i>9.2 Vectors in the plane</i> handout
<li>Figure out how to specify a line using points, vectors, and any/all of the operations above (scalar multiplication / vector addition / vector subtraction).
<li>Can you figure out a way of specifying a <i>plane</i> with those same elements?
</ul>
-->

<h3>More properties</h3>
<p class="show"><img src="0g/9.2.properties.jpg" class="big">

<h3>Standard basis vectors</h3>
<p class="show">The 3 standard "basis vectors" in a Cartesian coordinate system are:
$$\myv i \equiv \langle 1,0,0 \rangle; \ \ 
\myv j \equiv \langle 0,1,0 \rangle; \ \ 
\myv k \equiv \langle 0,0,1 \rangle$$
<p class="show"><img src="0g/9.2.basis.jpg">

<p>Notice that each of these vectors has a <b>length of 1</b>. That
is, they are <b>unit vectors</b>.

<p>A convention that I like, is to indicate unit
vectors with the caret symbol up top (instead of an arrow):

$$\uv i \equiv \langle 1,0,0 \rangle \equiv \uv x; \ \ 
\uv j \equiv \langle 0,1,0 \rangle \equiv \uv y; \ \ 
\uv k \equiv \langle 0,0,1 \rangle\equiv \uv z$$

<h3>Find the unit vectors</h3>
<p>Find the unit vector...
<ul><li> that  points in the direction $\langle 8, 0, 0 \rangle$.
<li> that points in the direction $\langle 5,5,0 \rangle$.
<li> that is <i>opposite</i> to the direction $\langle 1,-1,3 \rangle$.
</ul>

<h4>In general...</h4>
<p class="def">If $\myv a$ is a vector, then a unit vector, pointing in the same direction as $\myv a$, but with a length of 1 unit is:
$$\uv a = \frac {\myv a}{a}.$$
<p>For example, if $\myv a=\langle 5,5,0\rangle$, then $a=\sqrt{5^2+5^2+0^2}=\sqrt{50}$, so
$$\uv a= \frac {\myv a}{a}== \frac {\langle 5,5,0\rangle}{\sqrt{50}}=
\langle \frac{5}{\sqrt{50}},\frac{5}{\sqrt{50}},0\rangle.$$
<p class="justme">Using the vectors (not necessarily unit vectors) 
$\myv b = \langle 1,0\rangle$ and $\myv c = \langle 1,2\rangle$, try to express and $\myv a$ as $r\myv b + s\myv c$.
<div class="justme">
<h3>To do</h3>
<ul class="todo"><li>Component Vectors
<li>Lines in the Plane</li>
<li>Where do they point? Group Work 3
</ul>
</div>







<h4>Image credits</h4>
<p class="handout">
<a href="http://www.flickr.com/photos/question_everything/2874730255/in/photolist-5o2K9K-34fgaA-43fwd6-2gvoSs-8UN7KW-6GAby4-5csdcw-akXFZP-94xiiR-6MMZ2Q-kHViR-fCYuND-f8TQh9-bcghk6-9HLBWi-9k2uhq-8dNA4V-7xFup7-eZ7oY-9FHGhL-9bujkh-6C2dRy-6wXBFA-hSzuA-2bjUcV-cuiUiL-9BMK99-9AW63a-7i1Wd9-6v77Hk-kuxDd-bz9HS5-3bHURp-eXC7UV-9dodrj-6vSucr-DMWnQ-e64zg2-bE3qCK-7WPASq-5FWmPD-5EGt56-5xgANi-eRpvnm-2gYNdJ-fe3WvH-fnk4q2-a2BJa8-9tkpYp-4jxrX4-5jRaUU/">Flickr user 'Let ideas compete'</a>
<?php include "../../classes/3.h" ?>