<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Lines and planes [9.5]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>


<h1>Lines and planes [9.5]</h1>
<p class="show center"><img src="0g/9.5.gaudi.jpg" class="big"><br>
<i>Casa Batll&oacute;</i> by Antoni "enemy of the straight line" Gaud&iacute;
and Josep Maria Jujol.



<h2>Line segment</h2>
<p class="show">You know that "two points determine a line".
<p>In 3-d we should be able to construct a line given:<br>
&nbsp; &nbsp;  2 points $\times$ 3 coordinates / pt = 6 numbers.  


<!--
XX
Here's a different set of 6 numbers...
<ul><li>One point that the line passes through, say $(x_0,y_0,z_0)$, and
<li>some information about the direction of the line, say that it's parallel to the vector $\myv v = \langle a,b,c \rangle$.
</ul>
<p>Ah, 6 numbers!  But how to write out a specification of such a line?<br>
-->

<p>In yesterday's class, you *may* have figured out (in two dimensions) that this equation specifies <i>all</i> the points on the <b>line segment</b> between $P$ and $Q$, where the vector from $P$ to $Q$ is $\myv{PQ}\equiv \myv a$...<br>
$$(\,x(t), y(t)\ )= (P_x,P_y) +t( a_x,  a_y )\ :\ 0\lt t \lt 1.$$
You *may* have figured out that if we lifted the restriction $0\lt t \lt 1$, and allowed $t$ to be <i>any</i> real number, positive or negative, that we'd have the <b>equation of the line</b> that runs through both $P$ and $Q$!


<p><img src="0g/9.5.bline.jpg"><br>
Translating this into the terms of the diagram above (and generalizing to 3 dimensions...)
<ul>
<li>$\myv r_0$ is the <b>position vector</b> with tail at the origin, and head at point $P$.
<li>$\myv{PQ}\equiv \myv a$ is the difference vector, which runs from $P$ to some other point $Q$
<li>Let's say that $\myv v$ is some other vector, that is parallel to $\myv a$.   <i>Any</i> vector parallel to $\myv v$ can be expressed as some scalar multiple $t\myv v$ of $v$.
</ul>
<p>So, using vector addition, we can express the set of points on the line in parametric form as:
$$\myv r(t)=\myv r_0 + t\myv v.$$

<ul style="background-color: #acf"><b>Tip: WebAssign problem 9.5.002</b> In part 1 of this question, they ask you for the "vector equation of a line".  They're expecting
$$r_0+tv$$
with no special vector formatting.  
To get the subscript, type '<tt>r_0</tt>`.  When you type the underscore character, '_', you won't see it appear, but when you type the 0, it should show up as a subscript.
</ul>
<p>...And since $\myv r_0$ and $\myv v$ each have three components, once again, we have the 6 scalars needed to uniquely specify a line, only packaged up this time as the coordinates of a point and the components of a vector.


<h4>In component form</h4>
<p><img src="0g/9.5.linet.jpg">
$$\begineq \myv r(t) &= \myv r_0 + t\myv v = \langle x_0,y_0,z_0\rangle+t\langle a,b,c\rangle \\
&= \langle x_0+ta, y_0+tb, z_0+tc \rangle
.\endeq
$$
or
$$x(t)=x_0 +at;\ \  y(t)=y_0 +bt;\ \  z(t)=z_0 +ct$$
<p>Each of these can be solved for $t$, and then setting each form of $t$ to the others:
$$\frac{x-x_0}{a}=\frac{y-y_0}{b}=\frac{z-z_0}{c}.$$
<p>These are the <b>symmetric equations</b>.  Notice that $a$, $b$, $c$ are the components of $\myv v$, a vector parallel to the line $L$.


<h3>Example</h3>
<p class="show">Consider two lines:
$$\nonumber x=1+t;\ \ y=-2+3t;\ \ z=4-t$$
and 
$$\nonumber x=2s;\ \ y=3+s;\ \ z=-3+4s$$
<p><i>Do they intersect?</i>
<p><i>Solution:</i>
If they intersect at some common point (x,y,z), then that point should be a simultaneous solution in $s$ and $t$ to these three equations:
$$1+t=2s;\ \ -2+3t=3+s;\ \ 4-t=-3+4s$$

<h3></h3>
<p class="show">Those same two lines:
$$\nonumber x=1+t;\ \ y=-2+3t;\ \ z=4-t$$
and 
$$\nonumber x=2s;\ \ y=3+s;\ \ z=-3+4s$$
<p><i>Are the lines parallel?</i>
<p><i>Solution:</i>
Re-arrange the equations into the form of the symmetric equations (solve each equation for $t$...or for $s$...) to find the components (denominators) of a vector parallel to each line.

<p>Lines which are not parallel to each other, and do not intersect are called <b>skew lines</b>.

<div class="justme">
<h3>Line segment</h3>

<p class="show">How to specify a line <b>segment</b> that connects two points, specified by 2 vectors (from the origin) $\myv r_0$ and $\myv r_1$?
<p>Using a parameter $0 \leq t\leq 1$, we can certainly arrange to have the point be $\myv r_0$ when $t=0$, and $\myv r_1$ when $t=1$ by doing this:
$$\myv r(t) = (1-t)\myv r_0 + t\myv r_1.$$
You can re-arrange this as:
$$\myv r(t)=\myv r_0 +t(\myv r_1-\myv r_0)=\myv r_0+t\myv v$$
where $\myv v \equiv \myv r_1-\myv r_0$ is the difference vector between the two points.


<p>But does this produce a <i>line</i> connecting the two points?  Or something else?
<p>  Trying it in two dimensions...<br>
<img src="0g/9.5.linesegment.jpg">
</div>

<h3>To do</h3>
<ul class="todo"><li>Lines in the plane</li>
</ul>


<h2>Planes</h2>
<p class="show">
A plane can be determined by
<ul>
<li>a point $P_0$ in the plane and
<li>
 a <b>normal vector</b>, $\myv n$, which is <b>orthogonal</b> (normal) to the plane.
</ul>


<p>In pictures...<br>
<img src="0g/9.5.plane.jpg" class="rightalign">
<ul>
<li>$\myv r_0=\langle x_0, y_0, z_0 \rangle$ is a vector pointing at $P_0$.
<li>$\myv n = \langle a, b, c \rangle$ is the normal vector.
<li>$\myv r=\langle x,y,z\rangle$: Some point in the plane, which must satisfy the condition that $\myv r -\myv r_0$ is perpendicular to $\myv n$:

<p>
$$\begineq 0&=\myv n \cdot (\myv r-\myv r_0)\\
&=\langle a,b,c \rangle \cdot \langle x-x_0,y-y_0,z-z_0\rangle\\
0&=a(x-x_0)+b(y-y_0)+c(z-z_0)\rangle\\
\endeq
$$
</ul>

<p>Pushing the equation above one step further, let's expand the products and add up all the constant terms calling their sum $k$:

$$\begineq
ax_0+by_0+cz_0&=ax+by+cz\\
k&=ax+by+cz
\endeq
$$

<p>So that if you see an equation for a plane such as:
$$56=7x-3y+2z,$$
You can just read off the components of a normal vector to the plane as:
$$\myv n=\langle 7,-3,2 \rangle.$$

<h4>Example</h4>
<p class="show">Example four from book, but using a cross product to find the surface normal...
<p class="show"><img src="0g/9.5.ex4.jpg" class="rightalign">
<p>First find the normal to the plane.<br>
[Find two vectors that are in the plane, and then take their cross product.]

<p>Then find the equation for the plane.
[Take as $\myv r_0$ any of the three points shown.]
<br clear="both">
<p>Find the surface normal:<br>
<img src="0g/9.5.ex4b.jpg" class="rightalign">
$\myv a=\langle 0,-4,3 \rangle$<br>
$\myv b=\langle 6,-4,0 \rangle$<br>
$\myv a \times \myv b=12\uv i+18\uv j+24\uv k$
<p>Let's take for the normal vector...
$$\myv n=2\uv i+3\uv j+4\uv k =a \uv i + b \uv j +c \uv k$$
<p>Picking $(0,4,0)$ as the point in the plane, then the prescription above is...
$$\begineq 0 &=a(x-x_0)+b(y-y_0)+c(z-z_0)\\
&=2(x)+3(y-4)+4(z) = 2x+3y-12+4z\\
\endeq$$
So, the equation for the plane can be written as:
$$2x+3y+4z = 12.$$
where a normal vector to the plane was $\myv n=\myc{2,3,4}$.
<p>Notice that when the equation for a plane is written in this form that
 you can <b>read off</b> the components of the normal vector from the coefficients of $x$, $y$, and $z$!
<!--
<h3 id="todo">To do for next class</h3>
<ul class="todo">
<li>Assignment 9.5 on WebAssign.  This is not a short one.  Please keep track of the time you spend.
<li>Read 9.6
<li>Reading questions on 9.6
</ul>
-->
<div class="todo">
<p>Using algebra, find the intersection of the planes $x+2y+z=4$ and $4x+2y+3z=12$ in parametric form: For example, you could...

<ol><li>
solve the first equation for $z$ (which depends on $x$ and $y$), 
<li> substitute $z$ into the second equation and solve it for $y$ in terms of $x$, that is $y(x)$.
<li> go back to your equation for $z(x,y)$.  Substitute in your equation $y(x)$ to find z(x).  
</ol>

Now you can express the coordinates of your line as $(x, y(x), z(x))$.  This is a parametric expression for the line, in terms of a single parameter $x$.

<p>Confirm by graphing the two planes and the line...
</div>
<h4 class="handout">Image credits</h4>
<p class="handout"><a href="http://www.flickr.com/photos/vgm8383/2789863560">vgm8383</a>
<?php include "../../classes/3.h" ?>