(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     16899,        424]
NotebookOptionsPosition[     16570,        407]
NotebookOutlinePosition[     16922,        423]
CellTagsIndexPosition[     16879,        420]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"See", ":", " ", "http", ":"}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{"demonstrations", ".", "wolfram", ".", "com"}], "/", 
      "CylindricalCoordinates"}], "/"}]}], " ", "*)"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", ".3", "]"}], ",", 
         RowBox[{"PointSize", "[", ".02", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
         RowBox[{"RGBColor", "[", 
          RowBox[{".5", ",", "0", ",", "0"}], "]"}], ",", 
         RowBox[{"PointSize", "[", ".02", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"r", " ", 
             RowBox[{"Cos", "[", "theta", "]"}]}], ",", 
            RowBox[{"r", " ", 
             RowBox[{"Sin", "[", "theta", "]"}]}], ",", "z"}], "}"}], "]"}], 
         ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "Small", "]"}], ",", 
           RowBox[{"RGBColor", "[", 
            RowBox[{".5", ",", ".7", ",", "1"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"top", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"r", " ", 
                RowBox[{"Cos", "[", "theta", "]"}]}], ",", 
               RowBox[{"r", " ", 
                RowBox[{"Sin", "[", "theta", "]"}]}], ",", "z"}], "}"}]}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{"Line", "[", 
             RowBox[{"1.1", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"9", "+", 
                RowBox[{"r", "^", "2"}]}], "]"}], 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", " ", 
                 RowBox[{"Normalize", "[", "top", "]"}]}], ",", 
                RowBox[{"Normalize", "[", "top", "]"}]}], "}"}]}], "]"}]}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"r", " ", 
                 RowBox[{"Cos", "[", "theta", "]"}]}], ",", 
                RowBox[{"r", " ", 
                 RowBox[{"Sin", "[", "theta", "]"}]}], ",", 
                RowBox[{"-", "3.6"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"r", " ", 
                 RowBox[{"Cos", "[", "theta", "]"}]}], ",", 
                RowBox[{"r", " ", 
                 RowBox[{"Sin", "[", "theta", "]"}]}], ",", "3.6"}], "}"}]}], 
             "}"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"ax", ",", 
           RowBox[{"{", 
            RowBox[{"Gray", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "5"}], ",", "0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"5", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], 
             ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"-", "5"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "5", ",", "0"}], "}"}]}], "}"}], "]"}], 
             ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", 
                  RowBox[{"-", "5"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "5"}], "}"}]}], "}"}], "]"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", 
                  RowBox[{"-", "5"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "5"}], "}"}]}], "}"}], "]"}]}], 
            "}"}], ",", 
           RowBox[{"{", "}"}]}], "]"}], ",", "Yellow", ",", 
         RowBox[{"Opacity", "[", ".5", "]"}], ",", 
         RowBox[{"Cylinder", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", 
               RowBox[{"-", "3"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], ",", "r"}], 
          "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"ParametricPlot3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"r", " ", 
           RowBox[{"Cos", "[", "t", "]"}]}], ",", 
          RowBox[{"r", " ", 
           RowBox[{"Sin", "[", "t", "]"}]}], ",", "z"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"2", " ", "Pi"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", 
       RowBox[{"Column", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{"\"\<(r, \[Theta], z) = (\>\"", "<>", 
              RowBox[{"ToString", "[", 
               RowBox[{"NumberForm", "[", 
                RowBox[{"r", ",", 
                 RowBox[{"{", 
                  RowBox[{"3", ",", "2"}], "}"}], ",", 
                 RowBox[{"NumberPadding", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<\>\"", ",", "\"\<0\>\""}], "}"}]}]}], "]"}], 
               "]"}], "<>", "\"\<, \>\"", "<>", 
              RowBox[{"ToString", "[", 
               RowBox[{"NumberForm", "[", 
                RowBox[{
                 RowBox[{"theta", "/", "Pi"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"2", ",", "1"}], "}"}], ",", 
                 RowBox[{"NumberPadding", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<\>\"", ",", "\"\<0\>\""}], "}"}]}], ",", 
                 RowBox[{"ExponentFunction", "\[Rule]", 
                  RowBox[{"(", 
                   RowBox[{"Null", "&"}], ")"}]}]}], "]"}], "]"}], "<>", 
              "\"\< \[Pi], \>\"", "<>", 
              RowBox[{"ToString", "[", 
               RowBox[{"NumberForm", "[", 
                RowBox[{"z", ",", 
                 RowBox[{"{", 
                  RowBox[{"2", ",", "1"}], "}"}], ",", 
                 RowBox[{"NumberPadding", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<\>\"", ",", "\"\<0\>\""}], "}"}]}]}], "]"}], 
               "]"}], "<>", "\"\<)\>\""}], "}"}], "]"}], ",", 
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{"\"\<(x, y, z) = (\>\"", "<>", 
              RowBox[{"ToString", "[", 
               RowBox[{"NumberForm", "[", 
                RowBox[{
                 RowBox[{"r", " ", 
                  RowBox[{"Cos", "[", "theta", "]"}]}], ",", 
                 RowBox[{"{", 
                  RowBox[{"3", ",", "2"}], "}"}], ",", 
                 RowBox[{"NumberPadding", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<\>\"", ",", "\"\<0\>\""}], "}"}]}]}], "]"}], 
               "]"}], "<>", "\"\<, \>\"", "<>", 
              RowBox[{"ToString", "[", 
               RowBox[{"NumberForm", "[", 
                RowBox[{
                 RowBox[{"r", " ", 
                  RowBox[{"Sin", "[", "theta", "]"}]}], ",", 
                 RowBox[{"{", 
                  RowBox[{"2", ",", "1"}], "}"}], ",", 
                 RowBox[{"NumberPadding", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<\>\"", ",", "\"\<0\>\""}], "}"}]}], ",", 
                 RowBox[{"ExponentFunction", "\[Rule]", 
                  RowBox[{"(", 
                   RowBox[{"Null", "&"}], ")"}]}]}], "]"}], "]"}], "<>", 
              "\"\<, \>\"", "<>", 
              RowBox[{"ToString", "[", 
               RowBox[{"NumberForm", "[", 
                RowBox[{"z", ",", 
                 RowBox[{"{", 
                  RowBox[{"2", ",", "1"}], "}"}], ",", 
                 RowBox[{"NumberPadding", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<\>\"", ",", "\"\<0\>\""}], "}"}]}]}], "]"}], 
               "]"}], "<>", "\"\<)\>\""}], "}"}], "]"}]}], "}"}], ",", 
         "Center"}], "]"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{
        RowBox[{"4", "/", "3"}], 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "}"}]}]}], ",", 
      RowBox[{"ViewAngle", "\[Rule]", 
       RowBox[{"Pi", "/", "10"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"500", ",", "400"}], "}"}]}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"SphericalRegion", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "2.", ",", "\"\<r\>\""}], "}"}], ",", ".5", ",", 
      "2."}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"theta", ",", "0", ",", "\"\<\[Theta]\>\""}], "}"}], ",", "0", 
      ",", 
      RowBox[{"2.", " ", "Pi"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"z", ",", "2", ",", "\"\<z\>\""}], "}"}], ",", 
      RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ax", ",", "False", ",", "\"\<show axes\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", " ", 
    RowBox[{"TrackedSymbols", "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"r", ",", "theta", ",", "z", ",", "ax"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7345137669468927`*^9, 3.734513771977417*^9}, {
  3.734514256942338*^9, 3.734514285431533*^9}, {3.734514339854567*^9, 
  3.734514344726591*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`ax$$ = False, $CellContext`r$$ = 
    1.108, $CellContext`theta$$ = 0., $CellContext`z$$ = 0.5800000000000001, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`r$$], 2., "r"}, 0.5, 2.}, {{
       Hold[$CellContext`theta$$], 0, "\[Theta]"}, 0, 6.283185307179586}, {{
       Hold[$CellContext`z$$], 2, "z"}, -2.5, 2.5}, {{
       Hold[$CellContext`ax$$], False, "show axes"}, {True, False}}}, 
    Typeset`size$$ = {500., {198., 202.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`r$10419$$ = 0, $CellContext`theta$10420$$ = 
    0, $CellContext`z$10421$$ = 0, $CellContext`ax$10422$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`ax$$ = False, $CellContext`r$$ = 
        2., $CellContext`theta$$ = 0, $CellContext`z$$ = 2}, 
      "ControllerVariables" :> {
        Hold[$CellContext`r$$, $CellContext`r$10419$$, 0], 
        Hold[$CellContext`theta$$, $CellContext`theta$10420$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$10421$$, 0], 
        Hold[$CellContext`ax$$, $CellContext`ax$10422$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Graphics3D[{
          GrayLevel[0.3], 
          PointSize[0.02], 
          Point[{0, 0, 0}], 
          RGBColor[0.5, 0, 0], 
          PointSize[0.02], 
          
          Point[{$CellContext`r$$ Cos[$CellContext`theta$$], $CellContext`r$$ 
            Sin[$CellContext`theta$$], $CellContext`z$$}], {
           Thickness[Small], 
           RGBColor[
           0.5, 0.7, 
            1], $CellContext`top = {$CellContext`r$$ 
              Cos[$CellContext`theta$$], $CellContext`r$$ 
              Sin[$CellContext`theta$$], $CellContext`z$$}; 
           Line[1.1 
             Sqrt[9 + $CellContext`r$$^2] {-Normalize[$CellContext`top], 
               Normalize[$CellContext`top]}], 
           
           Line[{{$CellContext`r$$ 
              Cos[$CellContext`theta$$], $CellContext`r$$ 
              Sin[$CellContext`theta$$], -3.6}, {$CellContext`r$$ 
              Cos[$CellContext`theta$$], $CellContext`r$$ 
              Sin[$CellContext`theta$$], 3.6}}]}, 
          If[$CellContext`ax$$, {Gray, 
            Line[{{-5, 0, 0}, {5, 0, 0}}], 
            Line[{{0, -5, 0}, {0, 5, 0}}], 
            Line[{{0, 0, -5}, {0, 0, 5}}], 
            Line[{{0, 0, -5}, {0, 0, 5}}]}, {}], Yellow, 
          Opacity[0.5], 
          Cylinder[{{0, 0, -3}, {0, 0, 3}}, $CellContext`r$$]}], 
        ParametricPlot3D[{$CellContext`r$$ 
          Cos[$CellContext`t], $CellContext`r$$ 
          Sin[$CellContext`t], $CellContext`z$$}, {$CellContext`t, 0, 2 Pi}], 
        PlotLabel -> Column[{
           Row[{
             StringJoin["(r, \[Theta], z) = (", 
              ToString[
               
               NumberForm[$CellContext`r$$, {3, 2}, 
                NumberPadding -> {"", "0"}]], ", ", 
              ToString[
               
               NumberForm[$CellContext`theta$$/Pi, {2, 1}, 
                NumberPadding -> {"", "0"}, ExponentFunction -> (Null& )]], 
              " \[Pi], ", 
              ToString[
               
               NumberForm[$CellContext`z$$, {2, 1}, 
                NumberPadding -> {"", "0"}]], ")"]}], 
           Row[{
             StringJoin["(x, y, z) = (", 
              ToString[
               
               NumberForm[$CellContext`r$$ Cos[$CellContext`theta$$], {3, 2}, 
                NumberPadding -> {"", "0"}]], ", ", 
              ToString[
               
               NumberForm[$CellContext`r$$ Sin[$CellContext`theta$$], {2, 1}, 
                NumberPadding -> {"", "0"}, ExponentFunction -> (Null& )]], 
              ", ", 
              ToString[
               NumberForm[$CellContext`z$$, {2, 1}, 
                NumberPadding -> {"", "0"}]], ")"]}]}, Center], 
        PlotRange -> (4/3) {{-3, 3}, {-3, 3}, {-3, 3}}, ViewAngle -> Pi/10, 
        ImageSize -> {500, 400}, Boxed -> False, SphericalRegion -> True], 
      "Specifications" :> {{{$CellContext`r$$, 2., "r"}, 0.5, 
         2.}, {{$CellContext`theta$$, 0, "\[Theta]"}, 0, 
         6.283185307179586}, {{$CellContext`z$$, 2, "z"}, -2.5, 
         2.5}, {{$CellContext`ax$$, False, "show axes"}, {True, False}}}, 
      "Options" :> {
       TrackedSymbols :> {$CellContext`r$$, $CellContext`theta$$, \
$CellContext`z$$, $CellContext`ax$$}}, "DefaultOptions" :> {}],
     ImageSizeCache->{545., {282., 288.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.734514394855751*^9}]
}, Open  ]]
},
WindowSize->{808, 755},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 28, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 10601, 266, 684, "Input"],
Cell[11184, 290, 5370, 114, 621, "Output"]
}, Open  ]]
}
]
*)

