(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     11854,        309]
NotebookOptionsPosition[     11600,        295]
NotebookOutlinePosition[     11954,        311]
CellTagsIndexPosition[     11911,        308]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"http", ":"}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{"demonstrations", ".", "wolfram", ".", "com"}], "/", 
      "SphericalCoordinates"}], "/"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", ".3", "]"}], ",", 
         RowBox[{"PointSize", "[", ".02", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
         RowBox[{"RGBColor", "[", 
          RowBox[{".5", ",", "0", ",", "0"}], "]"}], ",", 
         RowBox[{"PointSize", "[", ".02", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"r", " ", 
             RowBox[{"Cos", "[", "theta", "]"}], " ", 
             RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
            RowBox[{"r", " ", 
             RowBox[{"Sin", "[", "theta", "]"}], " ", 
             RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
            RowBox[{"r", " ", 
             RowBox[{"Cos", "[", "phi", "]"}]}]}], "}"}], "]"}], ",", 
         RowBox[{"Thickness", "[", ".005", "]"}], ",", 
         RowBox[{"RGBColor", "[", 
          RowBox[{".5", ",", ".7", ",", "1"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1.5"}], " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"r", " ", 
                RowBox[{"Cos", "[", "theta", "]"}], " ", 
                RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
               RowBox[{"r", " ", 
                RowBox[{"Sin", "[", "theta", "]"}], " ", 
                RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
               RowBox[{"r", " ", 
                RowBox[{"Cos", "[", "phi", "]"}]}]}], "}"}]}], ",", 
            RowBox[{"1.5", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"r", " ", 
                RowBox[{"Cos", "[", "theta", "]"}], " ", 
                RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
               RowBox[{"r", " ", 
                RowBox[{"Sin", "[", "theta", "]"}], " ", 
                RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
               RowBox[{"r", " ", 
                RowBox[{"Cos", "[", "phi", "]"}]}]}], "}"}]}]}], "}"}], "]"}],
          ",", 
         RowBox[{"If", "[", 
          RowBox[{"ax", ",", 
           RowBox[{"{", 
            RowBox[{"Gray", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "6"}], ",", "0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"6", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], 
             ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"-", "6"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "6", ",", "0"}], "}"}]}], "}"}], "]"}], 
             ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", 
                  RowBox[{"-", "6"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "6"}], "}"}]}], "}"}], "]"}]}], 
            "}"}], ",", 
           RowBox[{"{", "}"}]}], "]"}], ",", "Yellow", ",", 
         RowBox[{"Opacity", "[", ".5", "]"}], ",", 
         RowBox[{"Sphere", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "r"}], "]"}]}], 
        "}"}], "]"}], ",", 
      RowBox[{"ParametricPlot3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"r", " ", 
           RowBox[{"Cos", "[", "t", "]"}], " ", 
           RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
          RowBox[{"r", " ", 
           RowBox[{"Sin", "[", "t", "]"}], " ", 
           RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
          RowBox[{"r", " ", 
           RowBox[{"Cos", "[", "phi", "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"2", " ", "Pi"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"ParametricPlot3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"r", " ", 
           RowBox[{"Cos", "[", "theta", "]"}], " ", 
           RowBox[{"Sin", "[", "t", "]"}]}], ",", 
          RowBox[{"r", " ", 
           RowBox[{"Sin", "[", "theta", "]"}], " ", 
           RowBox[{"Sin", "[", "t", "]"}]}], ",", 
          RowBox[{"r", " ", 
           RowBox[{"Cos", "[", "t", "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"2", " ", "Pi"}]}], "}"}]}], "]"}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", 
       RowBox[{"Column", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{"\"\<(r, \[Theta], \[Phi]) = (\>\"", "<>", 
              RowBox[{"ToString", "[", 
               RowBox[{"NumberForm", "[", 
                RowBox[{
                 RowBox[{"Chop", "@", "r"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"2", ",", "1"}], "}"}], ",", 
                 RowBox[{"NumberPadding", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<\>\"", ",", "\"\<0\>\""}], "}"}]}]}], "]"}], 
               "]"}], "<>", "\"\<, \>\"", "<>", 
              RowBox[{"ToString", "[", 
               RowBox[{"NumberForm", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Chop", "@", "theta"}], "/", "Pi"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"2", ",", "1"}], "}"}], ",", 
                 RowBox[{"NumberPadding", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<\>\"", ",", "\"\<0\>\""}], "}"}]}], ",", 
                 RowBox[{"ExponentFunction", "\[Rule]", 
                  RowBox[{"(", 
                   RowBox[{"Null", "&"}], ")"}]}]}], "]"}], "]"}], "<>", 
              "\"\< \[Pi], \>\"", "<>", 
              RowBox[{"ToString", "[", 
               RowBox[{"NumberForm", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Chop", "@", "phi"}], "/", "Pi"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"2", ",", "1"}], "}"}], ",", 
                 RowBox[{"NumberPadding", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<\>\"", ",", "\"\<0\>\""}], "}"}]}], ",", 
                 RowBox[{"ExponentFunction", "\[Rule]", 
                  RowBox[{"(", 
                   RowBox[{"Null", "&"}], ")"}]}]}], "]"}], "]"}], "<>", 
              "\"\< \[Pi])\>\""}], "}"}], "]"}], ",", 
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{"\"\<(x, y, z) = (\>\"", "<>", 
              RowBox[{"ToString", "[", 
               RowBox[{"NumberForm", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Chop", "@", "r"}], " ", 
                  RowBox[{"Cos", "[", "theta", "]"}], " ", 
                  RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
                 RowBox[{"{", 
                  RowBox[{"2", ",", "1"}], "}"}], ",", 
                 RowBox[{"NumberPadding", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<\>\"", ",", "\"\<0\>\""}], "}"}]}], ",", 
                 RowBox[{"ExponentFunction", "\[Rule]", 
                  RowBox[{"(", 
                   RowBox[{"Null", "&"}], ")"}]}]}], "]"}], "]"}], "<>", 
              "\"\<, \>\"", "<>", 
              RowBox[{"ToString", "[", 
               RowBox[{"NumberForm", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Chop", "@", "r"}], " ", 
                  RowBox[{"Sin", "[", "theta", "]"}], " ", 
                  RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
                 RowBox[{"{", 
                  RowBox[{"2", ",", "1"}], "}"}], ",", 
                 RowBox[{"NumberPadding", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<\>\"", ",", "\"\<0\>\""}], "}"}]}], ",", 
                 RowBox[{"ExponentFunction", "\[Rule]", 
                  RowBox[{"(", 
                   RowBox[{"Null", "&"}], ")"}]}]}], "]"}], "]"}], "<>", 
              "\"\<, \>\"", "<>", 
              RowBox[{"ToString", "[", 
               RowBox[{"NumberForm", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Chop", "@", "r"}], " ", 
                  RowBox[{"Cos", "[", "phi", "]"}]}], ",", 
                 RowBox[{"{", 
                  RowBox[{"2", ",", "1"}], "}"}], ",", 
                 RowBox[{"NumberPadding", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<\>\"", ",", "\"\<0\>\""}], "}"}]}], ",", 
                 RowBox[{"ExponentFunction", "\[Rule]", 
                  RowBox[{"(", 
                   RowBox[{"Null", "&"}], ")"}]}]}], "]"}], "]"}], "<>", 
              "\"\<)\>\""}], "}"}], "]"}]}], "}"}], ",", "Center"}], "]"}]}], 
      ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"500", ",", "400"}], "}"}]}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"SphericalRegion", "\[Rule]", "True"}], ",", 
      RowBox[{"ViewAngle", "\[Rule]", 
       RowBox[{"\[Pi]", "/", "12"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "5.", ",", "\"\<r\>\""}], "}"}], ",", "2.", ",", 
      "5."}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"theta", ",", "0", ",", "\"\<\[Theta]\>\""}], "}"}], ",", "0", 
      ",", 
      RowBox[{"2.", " ", "Pi"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"phi", ",", 
        RowBox[{"\[Pi]", "/", "4."}], ",", "\"\<\[Phi]\>\""}], "}"}], ",", 
      "0", ",", 
      RowBox[{"1.", " ", "Pi"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ax", ",", "False", ",", "\"\<show axes\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.73451453122775*^9, 3.734514553433013*^9}}]
},
WindowSize->{808, 755},
WindowMargins->{{12, Automatic}, {Automatic, 24}},
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 28, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 11038, 273, 642, "Input"]
}
]
*)

(* End of internal cache information *)

