(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     17737,        418]
NotebookOptionsPosition[     17206,        395]
NotebookOutlinePosition[     17560,        411]
CellTagsIndexPosition[     17517,        408]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.588541928102738*^9, 3.588541928152231*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"r0", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";", 
  RowBox[{"p", "=", 
   RowBox[{"Point", "[", 
    RowBox[{"{", "r0", "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptest", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"t", "^", "2"}], ",", 
       RowBox[{"t", "^", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "1.3"}], ",", "2"}], "\[IndentingNewLine]", "}"}], 
     "\[IndentingNewLine]", ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Blue", ",", 
        RowBox[{"Thickness", "[", "0.02", "]"}]}], "]"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.588548167835803*^9, 3.5885482699916897`*^9}, {
   3.5885483180168123`*^9, 3.5885483457721148`*^9}, {3.588548470952203*^9, 
   3.588548491375152*^9}, {3.5885487821109657`*^9, 3.58854887135455*^9}, {
   3.588549303419938*^9, 3.5885493043553658`*^9}, {3.588549372882867*^9, 
   3.5885493746828747`*^9}, {3.588549414665967*^9, 3.588549424647643*^9}, {
   3.5885505242579947`*^9, 3.588550544431409*^9}, {3.588550584598352*^9, 
   3.588550595517703*^9}, {3.5885515191650877`*^9, 3.588551536235917*^9}, {
   3.588553219212254*^9, 3.58855322174332*^9}, {3.588563477144165*^9, 
   3.588563505587682*^9}, 3.588563554651986*^9, {3.588563673135084*^9, 
   3.5885637254387703`*^9}}],

Cell[BoxData[
 Graphics3DBox[{{}, {}, 
   {RGBColor[0, 0, 1], Thickness[0.02], Line3DBox[CompressedData["
1:eJwN0vc/1X0fwHGjyDwqWZ0c2TK6qChx3l+VHSFJCJmRLrJHKGRlr6xk76sk
e5yP7IwUMqKMFDrJOsk+9/3D8x94PV4nrZwNbOloaGje/B/9/y211DX09VGQ
KzlXRZl5B0TtUmLcE2lbrNRrPYu6KYjjsyKzF3Ubsp+33qSE07aM9VfLBbVT
kO+d9s1KyjYEUB/qeQfQtrR/rixVaKKgUsVyddmpbag1UO2PcqBtyaSUp+eW
UZA310C5etU2JJe0Tc4DbYuWeI6vdyQF9bvdSZow34ayctdU2yWalsLYCEVh
DQq631E39qJ6CwoLPEt9tGlazM1NGvza1lFwu6x8usMmKGZsLJeK7aPeVs2k
8bw1NC5g5atQ+wdWPGiUH13dQrq9Hszqz1YRSJleYbu5DjYFHSG3Lv9BU2Mx
sluxK0gxN3OBVmQVPlW9eamOVtG4Cdm2au43ossm9Z8dWoKFPKGHp3p/IYGr
cjnJA7+QiniJe/jKIpB2nfKaTOaRZS9n/HD0T5RrFML8+9APuF/mI0DWmEVN
hh9nM40WEJ1uQOunoFnIJb618hCfRKqijPdDVH+gDg4NeROaKVAd/XnkWeIn
1PVkrOwd4xxqyqbd9Ds6DsO+N2NibQaQh7SQkMzKDLryU8fNCz8MoypqC0JR
nSiAFLup0DmFZm9lqo1FDYD87bfS09cROkDk4BwwmEDB6uZNiYZdoJZJNG0i
v0FzOsHZ+ZKjCDvsJ7XZ2QKrGUV83drFqMZHOuVc2SAyGKHPtOyuhu+ySlLB
jmko0I37RWVgH4IZvJTnnRJYjFiYik0PRXTbDhX15n2oxn7C9ItoCfQ/2+j3
uBqKQh81vW1R7kPUVI+A8F/F0HZjxZ2D+gRFRd+Ze7/Ti6g7Spml3sVwO92/
wNLuCUotKpMge/UiUhu3In9SEUzrf312QzkEVUxAlZBLD7pssrffOloAMSMV
m+MsQWj28t13SZbdyCov/D+6hFxIOdPQjtd+iFQ569c9VdrRpDZcrM5PA5HL
Q2L2F11Q8fUb029OtCM5Uvewt1YaZM00GzP3OSPmxNW+la029K70g/bkSiqY
FbSZ5Ag5ow+HTxU6VrahjjXTwSBIheGBzoiB8fvIBJdhbC7UhmaVLVV051JA
JmnWsPbOPeTC7N+serAVNbcQir5qJ0HEX9ES5kk7dJY2iF0iAaGhVYpgr0gs
yAmcPz3TYI62Axvmc7UQum5fWK2ZFgN/dBiLv5BvI7S/1oKnR8jooyH9IfYY
ODHvcyxE4DbS2rV243AnIUpQ8cDlnSjYl8nV/S/JFFn8VR37e6MZPTSTlKqb
iwSJSaem0CJjFLnElNvJ24h6F7IoieuhgPthnEbrch1Njcefs8mpQWZ2ym3c
tI/Akm1nfjlXDZU+Hv+TY16DWg1Cee+rBUIAfb7UwqQqcpc4WTN1vAZNv+dt
H40KgPhQaHE5roqYfSrkTVOqkWPJmMVZAX84YNF2a7fgMpLnGVAweFqF0uar
XzPf8QWzcLndwGUMxRixKmIelcg+/DdJUtsD0pyzLTPjzqNb+9e3/eUqEdnZ
p0ex0h3uCjXgBiMUkHBhRkPj8msUphO15HncHWa0rcLdI+VRw59TFxUcX6OD
ZE1fT4orBOhrzCTknEXfkzSVZCwqEP6V8MuEFhcQiRnyVxSWRd6FbP7nE8qR
b23FfkCQA+iFXo9EnaKIfSNz7w1rOfLS7GDAUu7C1JBKiWK0CMpXlQo4HVaG
8rsWlU1f2sPplheVYhbCaGBOK1D0YSmKDLe6kE22BQfBwHR/YUEkKhT+mNOu
GMXhj9rapFtBcfKFV2rmePTpBV3oyoV8tMk3w18Wfwv6Zd5kGElwIMfleAan
qjw00c542O2KMdSF1kX+nmVDNHAybF4mDxHUde8sU40ghobzu3EiC5L6CuFf
hXJR+7Ai/mC8IXRlXGBQ0WdEIXj/yD62bOTHmbCTf1wPTOyCbkdI0KCzYzxc
cRwvUDmdczNBXBfOcbWn+qrtkSy8FLjDDmYhfPQWmJ+6Cu9HpmeSnbZJNdXu
vB7LGUihqt/nmLUGyIqP2XBr/SHZyi2f0G97hnS1XVucClRAbjls4dy5n6SY
VNOtjZwU9FPJ33SeFoM4uUSz4vwfpJr9ruHMR8loqOnz44LvSvBkkDw45viN
xNCb/XRBORGdtdr+9FdIAVTb3VpheIIkI8tmH4NPQCntFyzcHp0Fn9tH2XjP
jZKMnvlcOrsTh9pCL/t/OCgHhUK18Z0CQyTdrvw1qks0or/htGzOJQmONxZ3
f5G7SVmJ/iXaMk/RSR5isRWXGJC1Qum0MttIyxZGls/I4Wg8PT9S4q4QfKLf
66deIJHiNhnfy9iFIE6SRSotHR+QFIr+1UmqIE23T4f4CgUhJpUSI8E4TrDp
sbdC14pIVoJuXlFvA5FJ6PkPCcE4eJPghj+i9oJE1yj8XUjJD22HP0hbkmaE
xiKZZ3oNiaS86yMGjTWe6G/E3qEbBBr4rapzTP5bKOnKr7AWA1lXlHWkXjnh
FYXYq3NQTvOJF6mHyc1s+OY9xIRXdBK7PU+cVxFOrN+wJrFeHFGg17FCYTyZ
v+p/DxMDWVuJBqvqpIwxV1GbEAOk/cq5X/zfamLARsME1s9Dyu7S1fWq2CFl
CIJnyh9GIl3befqbjZzN5lY0TtOF+vC9LNrKwecNUcf+agf+4THiEjXTROXr
HRjkklQwoQwRrzGytgxoqBHL3l8IPLLoCK0mIvkWOT+IymWPelYZrYnVuuSP
q1sPoCOextpKjkIMdlOcY3rtSeSsuWBjEugJU65JmEwulSh9TWrARjmU6HYi
fKP1gB/cFLevZvrAAL4/sNNLlxKJgyEj4ZKRgZB+bHTlEBcOApgdtuPzsog8
nglsPYxBkEGj4xCpzwnqVlVbL74XErtL6o0CtEIg7c/N/1IaecExXjReRL+C
KHb40OKPgXCIlvHgPqksBOJjRNGXn5qJI1dOy2UceQoD8+drXOZFIYp83DzV
so0Y6m3kd+1GNJRYxgcEfzsF5k3aml8LuonrzoMMZktxEK9Bo+azIAtXztX3
CK0NEg1GBdLaXZMhYYN81a9FCdgWVdWcVb8RTz2oauZPSoHYj9mtryYBXFN8
+c/6/SDSsWjMelc/AymGuB+zcSrgkG+w+JjxJ/E10VlSejMN8j8Q9bSPqgIn
J54/lG+VyFHY3JzsnwWm+SbZtmw6sDS5Hp34coe4APqzy1kvgDHeXIYBrsF1
SSF7mN4nTju50otYZkPfiHXb01Y94KjzGlARo4U6BgbxwMc5oNBoo60mdh1o
saAYRDkA9orSD86054FTXgev5T1jIHAPb6+fYofOHD/6TM1ieL1Ja3zU2Qro
zK48vbdzHCR/6TYXjhbDBUayvZimNawzRfOUrZ6AOHlBr9e2JTBVruwpLm4D
D0UfaU3uE8Ckt/tn5+NSiGgmxKxSbEFY7bc0xz+C8JtybHC1vhx0KSOlL945
wAuem+eviIoBi7DxB6HkCvgwcaiv+vQD4H8iHb8wIAtnvNayfA5WwyutSYE7
WX4wc7HPvUT4EtjhJ3cCrlbDzGVH3EWTh2BZ+jFu7+slSH3bYRySWA3Zh6T9
n/L4Q6b6t2ylrMuwx5J2JPZkDQxQ9EZiMwPA4yfvuWZJVejKhtB85VpYk4yA
ozOP4N8RsxuJIRpg2hN1f8CjHnzzlT91qIQATW2T8cYJPQg+IaYk8qMZ9Mmu
VenLT6HJnvELO58JVKTRVtqJk2Ao5V3s+r0osN129ed6ZwKTxybFih1J0Hn7
fLf5YhR4r04PiviZgjx7/FHJZRKwEM31nOaj4TI+UdlzwQx+7m///GcTAb1G
b7P1SizUDmx5pS5YgITL/FX+g29hCEtmmOVLgCcH2EdNLllDnH7jjgR3G4x3
7BNFulIgXJdR1VP6HphzWt9SudgFpIC9kowv2cDdOj180N8bktMYLkhZdIGM
7Lvsn4dz4OvWzRGtZW/o4y/l4Q7ughLxF+cj1XL+/xdeetXKBxQlVkd/9XRB
6w8H7caKHHC1jTJy1PWFY8RAo1STbgh84bs3F54L1ua7u5ryD6HPPuP6ss87
kKKPSDTSyAe5ou8TfSKPQLFxSOd5XS+oJd4Kq6QvhvEIzdWS/hBgkRXM2eX7
ACrkuU5R+QrosWMnBejHQYx6tjDf1WFYMOM2LEP18JS/1JDxRjZMaDrOCd8d
g42SFLXI560gHD1n7GtbDmf/2VN0/zIJz5n0NsKYeoBDHXc77GEt8LXpxl0K
noYYv//W65k/QtcRfHl4yls4aRmse799FpR/JjvcoR8B3t+C1myD74Bt/Usp
+84cOKs6MB4KnoBFsxH7ZqZB6FNG7+NY5kHFSO9mfuo0nFFosLo3PwoJ2weI
1RqLsGv92Abb/ga2w/Is/fFTIOn80b3Bggw9nh4HShznIaxku5Ll0ByUjLdp
yjstAWH/kWEcGxkkpda8O6cWQLqGz9GwYBk+5242lWgvAym+RGBv7TdcEtkt
lphcgchxlj7x9lV49lIHsuvW4IH480vbO6sQYdrKQ5GngOEpq6zmug2ICKPF
Gg+tQzzrkN/b/A14jVsXol3ZhqQZ7ygFDgqo0hy6liG+BfJacVyXoqiQ6567
f0DmD/wrJuyjz7QLLLemlZxj6LB069jh1vMbQCzLEpmZ3IfTAX8upv17EEt+
KvPh462/cCG1rpaXmRZ7fKIvVerrISzo5TRfpscmzHEN3OWrpMM+BRDtkpJY
sVvSRu+MArYgN2rdzuTaAcyh0VlCRoYDO/vd/7nV823wnurQ6xRkwASOs28Q
HI5gm5t3P5mX7ABmuOCrt8iIEXbi/jiWcWIvGe3NuCp24YtJE/dKLRN2hZWm
xoudG7t7jZuJ0L8H8sNKXOQWFky2f32scYwXY12P5OUZ3Qflxf6dtTo2TCyf
dUCqAI9xeE3WNU7sQ+p3sw9zb9kwVvwlZnwlHuPckTa2mN6HgwNX9kZ72LBM
pSIJHMJjJ+g/phQu7sNRB4Jl6yQb1vDkJjftOB6TOcrNeW53H/bqqZpFNOxY
V9pr0lG2E5j+mTx2g5NUODLg9PK1BjtmNmbUQvE4gaW4NdJH3aPCP52b9d3j
7Ji1OKmoRIsfS//LmnfahQpVNgVp32fZsUq/o0+5jPmxLD/zS0PuVNBaKf1I
/4sdi57Xsw2z5ceKgmkf8wVQoex9i9aVfXZslmuCxuMRP1aXqL5fHEcFxWLu
O58EcdjMuZi5wBp+bOLN0GZHNRVS3z/gP++Ew6xDfGcMhQjYtIJIqkMDFc4Q
/wt29MBhv+mf+NDKErC5Rk8FNkSFL+kqKlkBOGx1aOhwJZGA/Wrj9TTspoLt
cY8OpngcZuuWrEowIWD7Qxbrs5+poHmBcW2lGoctHWbukYgnYHTGrxNCp6jg
dJiZTwbhMDmvVPeNLALGMEknd2qOCjkjtulO3TiMrMEr3FVOwHBzBS4PlqgA
4uL5S59xWBVoJrl3EzDOu39xx9aoUFoVI/3PHA5rIwsZ6Y8QMJ5fGq/qNqgg
JKOLc1/CYcQjGgS5OQKGd0nXNduhwsskO836DRxW7Km9wrVGwAQo5CUq9f89
F0YnqFQcFjDZ9o5KJWD/A/v3RG0=
     "]]}},
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["z", TraditionalForm]},
  Method->{},
  PlotRange->{{-1.2999999326530614`, 1.9999999326530613`}, {0., 
   3.9999997306122497`}, {-2.1969996585510385`, 7.999999191836762}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.588563726298869*^9, 3.588563774594657*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Green", ",", " ", 
        RowBox[{"PointSize", "[", "0.08", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "h"}], ")"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "h"}], ")"}], "^", "2"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "h"}], ")"}], "^", "3"}]}], "}"}]}], 
          "}"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "\[IndentingNewLine]", 
        RowBox[{"Thickness", "[", "0.015", "]"}], ",", "\[IndentingNewLine]", 
        
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"r0", "+", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "/", "h"}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "h"}], ")"}], ",", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "h"}], ")"}], "^", "2"}], ",", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "h"}], ")"}], "^", "3"}]}], 
                "}"}], "-", "r0"}], ")"}]}]}]}], "}"}], "\[IndentingNewLine]",
          "]"}]}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"Purple", ",", 
        RowBox[{"Thickness", "[", "0.001", "]"}], ",", "\[IndentingNewLine]", 
        
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "h"}], ")"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "h"}], ")"}], "^", "2"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "h"}], ")"}], "^", "3"}]}], "}"}]}], 
          "}"}], "\[IndentingNewLine]", "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"ptest", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", "}"}], "]"}], 
   ",", "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"h", ",", "3", ",", "0.03"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.588548496267815*^9, 3.588548642611884*^9}, {
   3.58854887541193*^9, 3.588548955887018*^9}, {3.588549223774169*^9, 
   3.588549241268779*^9}, 3.5885493231306477`*^9, {3.5885494413819*^9, 
   3.5885494526628227`*^9}, {3.588549487500271*^9, 3.588549488438936*^9}, {
   3.5885495420776033`*^9, 3.588549547661934*^9}, {3.5885496110962887`*^9, 
   3.588549652127329*^9}, {3.588549702261742*^9, 3.588549715509034*^9}, {
   3.588549752956815*^9, 3.588549826713584*^9}, {3.588550192932988*^9, 
   3.5885501936762247`*^9}, {3.58855024441057*^9, 3.588550263690257*^9}, {
   3.588550309514832*^9, 3.588550312424343*^9}, {3.588550727739406*^9, 
   3.5885507291531553`*^9}, {3.588550783251061*^9, 3.58855097021819*^9}, {
   3.588551017226762*^9, 3.588551030151578*^9}, {3.588551491106798*^9, 
   3.588551503190783*^9}, {3.58855156897507*^9, 3.5885516504830217`*^9}, {
   3.5885516978030577`*^9, 3.588551726143794*^9}, {3.588551768912361*^9, 
   3.5885518493071547`*^9}, 3.588551945241271*^9, 3.5885520147115088`*^9, {
   3.588552245693883*^9, 3.588552253428439*^9}, {3.588552329786824*^9, 
   3.588552335697864*^9}, {3.588552442430088*^9, 3.588552612401535*^9}, {
   3.588552645386854*^9, 3.5885526790475473`*^9}, {3.588552713823874*^9, 
   3.588552747731099*^9}, {3.588552793508101*^9, 3.5885528145872803`*^9}, {
   3.588553081388438*^9, 3.588553095887128*^9}, {3.58855324198346*^9, 
   3.588553279617804*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`h$$ = 3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`h$$], 3, 0.03}}, Typeset`size$$ = {
    203., {214., 218.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`h$42773$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`h$$ = 3}, 
      "ControllerVariables" :> {
        Hold[$CellContext`h$$, $CellContext`h$42773$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{{Green, 
          PointSize[0.08], 
          
          Point[{{-1, 
            1, -1}, {-1 + $CellContext`h$$, (-1 + $CellContext`h$$)^2, (-1 + \
$CellContext`h$$)^3}}]}, {Red, 
          Thickness[0.015], 
          
          Arrow[{{-1, 
            1, -1}, $CellContext`r0 + (
              1/$CellContext`h$$) ({-1 + $CellContext`h$$, (-1 + \
$CellContext`h$$)^2, (-1 + $CellContext`h$$)^3} - $CellContext`r0)}]}, {
         Purple, 
          Thickness[0.001], 
          
          Arrow[{{-1, 
            1, -1}, {-1 + $CellContext`h$$, (-1 + $CellContext`h$$)^2, (-1 + \
$CellContext`h$$)^3}}]}, 
         Part[$CellContext`ptest, 1]}], 
      "Specifications" :> {{$CellContext`h$$, 3, 0.03}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{248., {258., 263.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.58856330872735*^9, 3.5885634930992403`*^9, {3.588563539942849*^9, 
   3.588563560662059*^9}, {3.588563710039619*^9, 3.5885637183854523`*^9}}]
}, Open  ]],

Cell[TextData[{
 "In ",
 StyleBox["purple",
  FontColor->RGBColor[0.5, 0, 0.5]],
 ": ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["r", "\[RightVector]"], "(", 
     RowBox[{"t", "+", "h"}], ")"}], "-", 
    SubscriptBox[
     OverscriptBox["r", "\[RightVector]"], "0"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", as ",
 Cell[BoxData[
  FormBox[Cell[TextData[Cell[BoxData[
    FormBox["h", TraditionalForm]],
    FormatType->"TraditionalForm"]]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " runs from 3 to 0.03.\[LineSeparator]In ",
 StyleBox["red",
  FontColor->RGBColor[1, 0, 0]],
 ": ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       OverscriptBox["r", "\[RightVector]"], "(", 
       RowBox[{"t", "+", "h"}], ")"}], "-", 
      SubscriptBox[
       OverscriptBox["r", "\[RightVector]"], "0"]}], ")"}], "/", "h"}], 
   TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Text",
 CellChangeTimes->{{3.588562420077675*^9, 3.588562526359371*^9}, {
  3.588562559702964*^9, 3.588562610505766*^9}, {3.588562649674601*^9, 
  3.588562676257305*^9}, {3.5885627264113073`*^9, 3.58856281896376*^9}, {
  3.58856385442889*^9, 3.588563885796466*^9}}]
},
WindowSize->{848, 721},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 92, 1, 28, InheritFromParent],
Cell[CellGroupData[{
Cell[674, 25, 1728, 40, 114, "Input"],
Cell[2405, 67, 6261, 110, 447, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8703, 182, 4987, 115, 403, "Input"],
Cell[13693, 299, 2250, 51, 538, "Output"]
}, Open  ]],
Cell[15958, 353, 1244, 40, 57, "Text"]
}
]
*)

(* End of internal cache information *)
