(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     43907,       1115]
NotebookOptionsPosition[     42545,       1064]
NotebookOutlinePosition[     42899,       1080]
CellTagsIndexPosition[     42856,       1077]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", " ", 
     RowBox[{"3", " ", "t"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.590443926333768*^9, 3.590443996366146*^9}, {
  3.590444028285528*^9, 3.5904440327170887`*^9}, {3.5904440882086773`*^9, 
  3.5904441666097803`*^9}, {3.59044435422171*^9, 3.590444356258869*^9}}],

Cell[BoxData[
 Graphics3DBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Line3DBox[CompressedData["
1:eJwdmXk8VO/bgFuUpCxDRBuDFGNpTBJyPyiJki0UKe2StAjRhpQliaL4Ctn3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     "]]}},
  Axes->True,
  Method->{},
  PlotRange->{{-1.9999990508313947`, 
   1.9999999999999796`}, {-1.9999999742242967`, 1.9999999669916937`}, {0., 
   20.99999957142857}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.590444384814452*^9, 3.608300538757248*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", "t", "]"}]}], ",", 
    RowBox[{"2", " ", 
     RowBox[{"Sin", "[", "t", "]"}]}], ",", " ", 
    RowBox[{"3", " ", "t"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.590444421656332*^9, 3.590444424897799*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", "t", "]"}]}], ",", 
   RowBox[{"2", " ", 
    RowBox[{"Sin", "[", "t", "]"}]}], ",", 
   RowBox[{"3", " ", "t"}]}], "}"}]], "Output",
 CellChangeTimes->{3.59044443056945*^9, 3.608300538874482*^9}]
}, Open  ]],

Cell[TextData[{
 "\[LineSeparator]\[LineSeparator]\[LineSeparator]Now the tangent vector. ",
 StyleBox[" Note that I use ",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox["Norm", "Code",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox[" to get the length (a ",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox["scalar",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox[") of the vector. ",
  FontColor->RGBColor[1, 0, 0]],
 " (",
 StyleBox["Abs", "Code"],
 " would give you a ",
 StyleBox["vector",
  FontWeight->"Bold"],
 " consisting of the absolute values of each component.)"
}], "Text",
 CellChangeTimes->{{3.5904449883357677`*^9, 3.590445052275495*^9}, {
  3.608300641341634*^9, 3.608300650962515*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"r", ",", "t"}], "]"}], "/", 
   RowBox[{"Norm", "[", 
    RowBox[{"D", "[", 
     RowBox[{"r", ",", "t"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5904444353219547`*^9, 3.590444477806735*^9}, {
  3.590444705488203*^9, 3.5904447107037363`*^9}, {3.590444826734363*^9, 
  3.590444828973637*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}], 
     SqrtBox[
      RowBox[{"9", "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}]]]}], ",", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", "t", "]"}]}], 
    SqrtBox[
     RowBox[{"9", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}]]], ",", 
   FractionBox["3", 
    SqrtBox[
     RowBox[{"9", "+", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}]]]}], "}"}]], "Output",\

 CellChangeTimes->{{3.590444453600678*^9, 3.59044448009583*^9}, 
   3.590444534812182*^9, 3.590444568102178*^9, {3.590444830246262*^9, 
   3.590444851058374*^9}, 3.59044556647278*^9, 3.6083005389104757`*^9}]
}, Open  ]],

Cell["", "Text",
 CellChangeTimes->{{3.590444880347816*^9, 3.5904449450308647`*^9}, 
   3.590445006094221*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myT", "=", 
  RowBox[{"%", "/.", 
   RowBox[{"t", "\[Rule]", 
    RowBox[{"3", " ", 
     RowBox[{"\[Pi]", "/", "2"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.590444496758803*^9, 3.590444560540477*^9}, {
  3.590444841869652*^9, 3.5904448429870358`*^9}, {3.590445571910877*^9, 
  3.590445574164298*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["2", 
    SqrtBox["13"]], ",", "0", ",", 
   FractionBox["3", 
    SqrtBox["13"]]}], "}"}]], "Output",
 CellChangeTimes->{{3.590444526725699*^9, 3.590444570937057*^9}, {
   3.590444835502383*^9, 3.590444853982524*^9}, 3.590445575884962*^9, 
   3.608300538939686*^9}]
}, Open  ]],

Cell["\<\


The normal unit vector....\
\>", "Text",
 CellChangeTimes->{{3.590445083700308*^9, 3.590445108665731*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"T", ",", "t"}], "]"}], "/", 
   RowBox[{"Norm", "[", 
    RowBox[{"D", "[", 
     RowBox[{"T", ",", "t"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5904451189485207`*^9, 3.590445146466217*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Set", "::", "wrsym"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Symbol \[NoBreak]\\!\\(N\\)\[NoBreak] is Protected. \\!\\(\
\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/wrsym\\\", \
ButtonNote -> \\\"Set::wrsym\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.590445148630529*^9, 3.5904455838618383`*^9, 
  3.608300539160309*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"Cos", "[", "t", "]"}]}], 
        SqrtBox[
         RowBox[{"9", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}]]]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"Sin", "[", "t", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "8"}], " ", 
           RowBox[{"Abs", "[", 
            RowBox[{"Cos", "[", "t", "]"}], "]"}], " ", 
           RowBox[{"Sin", "[", "t", "]"}], " ", 
           RowBox[{
            SuperscriptBox["Abs", "\[Prime]",
             MultilineFunction->None], "[", 
            RowBox[{"Cos", "[", "t", "]"}], "]"}]}], "+", 
          RowBox[{"8", " ", 
           RowBox[{"Abs", "[", 
            RowBox[{"Sin", "[", "t", "]"}], "]"}], " ", 
           RowBox[{"Cos", "[", "t", "]"}], " ", 
           RowBox[{
            SuperscriptBox["Abs", "\[Prime]",
             MultilineFunction->None], "[", 
            RowBox[{"Sin", "[", "t", "]"}], "]"}]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"9", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]]]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"\[Sqrt]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["9", "4"], " ", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           FractionBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "8"}], " ", 
              RowBox[{"Abs", "[", 
               RowBox[{"Cos", "[", "t", "]"}], "]"}], " ", 
              RowBox[{"Sin", "[", "t", "]"}], " ", 
              RowBox[{
               SuperscriptBox["Abs", "\[Prime]",
                MultilineFunction->None], "[", 
               RowBox[{"Cos", "[", "t", "]"}], "]"}]}], "+", 
             RowBox[{"8", " ", 
              RowBox[{"Abs", "[", 
               RowBox[{"Sin", "[", "t", "]"}], "]"}], " ", 
              RowBox[{"Cos", "[", "t", "]"}], " ", 
              RowBox[{
               SuperscriptBox["Abs", "\[Prime]",
                MultilineFunction->None], "[", 
               RowBox[{"Sin", "[", "t", "]"}], "]"}]}]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}], ")"}], 
             RowBox[{"3", "/", "2"}]]], "]"}], "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{"2", " ", 
              RowBox[{"Sin", "[", "t", "]"}]}], 
             SqrtBox[
              RowBox[{"9", "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}]]]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Cos", "[", "t", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "8"}], " ", 
                 RowBox[{"Abs", "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}], " ", 
                 RowBox[{"Sin", "[", "t", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["Abs", "\[Prime]",
                   MultilineFunction->None], "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}]}], "+", 
                RowBox[{"8", " ", 
                 RowBox[{"Abs", "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}], " ", 
                 RowBox[{"Cos", "[", "t", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["Abs", "\[Prime]",
                   MultilineFunction->None], "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}]}]}], ")"}]}], ")"}], 
            "/", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}], ")"}], 
             RowBox[{"3", "/", "2"}]]}]}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{"2", " ", 
              RowBox[{"Cos", "[", "t", "]"}]}], 
             SqrtBox[
              RowBox[{"9", "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}]]]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Sin", "[", "t", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "8"}], " ", 
                 RowBox[{"Abs", "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}], " ", 
                 RowBox[{"Sin", "[", "t", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["Abs", "\[Prime]",
                   MultilineFunction->None], "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}]}], "+", 
                RowBox[{"8", " ", 
                 RowBox[{"Abs", "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}], " ", 
                 RowBox[{"Cos", "[", "t", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["Abs", "\[Prime]",
                   MultilineFunction->None], "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}]}]}], ")"}]}], ")"}], 
            "/", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}], ")"}], 
             RowBox[{"3", "/", "2"}]]}]}], "]"}], "2"]}], ")"}]}], ")"}]}], 
   ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"Sin", "[", "t", "]"}]}], 
        SqrtBox[
         RowBox[{"9", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}]]]}], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"Cos", "[", "t", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "8"}], " ", 
           RowBox[{"Abs", "[", 
            RowBox[{"Cos", "[", "t", "]"}], "]"}], " ", 
           RowBox[{"Sin", "[", "t", "]"}], " ", 
           RowBox[{
            SuperscriptBox["Abs", "\[Prime]",
             MultilineFunction->None], "[", 
            RowBox[{"Cos", "[", "t", "]"}], "]"}]}], "+", 
          RowBox[{"8", " ", 
           RowBox[{"Abs", "[", 
            RowBox[{"Sin", "[", "t", "]"}], "]"}], " ", 
           RowBox[{"Cos", "[", "t", "]"}], " ", 
           RowBox[{
            SuperscriptBox["Abs", "\[Prime]",
             MultilineFunction->None], "[", 
            RowBox[{"Sin", "[", "t", "]"}], "]"}]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"9", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]]]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"\[Sqrt]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["9", "4"], " ", 
         SuperscriptBox[
          RowBox[{"Abs", "[", 
           FractionBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "8"}], " ", 
              RowBox[{"Abs", "[", 
               RowBox[{"Cos", "[", "t", "]"}], "]"}], " ", 
              RowBox[{"Sin", "[", "t", "]"}], " ", 
              RowBox[{
               SuperscriptBox["Abs", "\[Prime]",
                MultilineFunction->None], "[", 
               RowBox[{"Cos", "[", "t", "]"}], "]"}]}], "+", 
             RowBox[{"8", " ", 
              RowBox[{"Abs", "[", 
               RowBox[{"Sin", "[", "t", "]"}], "]"}], " ", 
              RowBox[{"Cos", "[", "t", "]"}], " ", 
              RowBox[{
               SuperscriptBox["Abs", "\[Prime]",
                MultilineFunction->None], "[", 
               RowBox[{"Sin", "[", "t", "]"}], "]"}]}]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}], ")"}], 
             RowBox[{"3", "/", "2"}]]], "]"}], "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{"2", " ", 
              RowBox[{"Sin", "[", "t", "]"}]}], 
             SqrtBox[
              RowBox[{"9", "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}]]]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Cos", "[", "t", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "8"}], " ", 
                 RowBox[{"Abs", "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}], " ", 
                 RowBox[{"Sin", "[", "t", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["Abs", "\[Prime]",
                   MultilineFunction->None], "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}]}], "+", 
                RowBox[{"8", " ", 
                 RowBox[{"Abs", "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}], " ", 
                 RowBox[{"Cos", "[", "t", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["Abs", "\[Prime]",
                   MultilineFunction->None], "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}]}]}], ")"}]}], ")"}], 
            "/", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}], ")"}], 
             RowBox[{"3", "/", "2"}]]}]}], "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{"2", " ", 
              RowBox[{"Cos", "[", "t", "]"}]}], 
             SqrtBox[
              RowBox[{"9", "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}]]]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Sin", "[", "t", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "8"}], " ", 
                 RowBox[{"Abs", "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}], " ", 
                 RowBox[{"Sin", "[", "t", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["Abs", "\[Prime]",
                   MultilineFunction->None], "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}]}], "+", 
                RowBox[{"8", " ", 
                 RowBox[{"Abs", "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}], " ", 
                 RowBox[{"Cos", "[", "t", "]"}], " ", 
                 RowBox[{
                  SuperscriptBox["Abs", "\[Prime]",
                   MultilineFunction->None], "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}]}]}], ")"}]}], ")"}], 
            "/", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"9", "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox[
                 RowBox[{"Abs", "[", 
                  RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}], ")"}], 
             RowBox[{"3", "/", "2"}]]}]}], "]"}], "2"]}], ")"}]}], ")"}]}], 
   ",", 
   RowBox[{"-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          RowBox[{"Abs", "[", 
           RowBox[{"Cos", "[", "t", "]"}], "]"}], " ", 
          RowBox[{"Sin", "[", "t", "]"}], " ", 
          RowBox[{
           SuperscriptBox["Abs", "\[Prime]",
            MultilineFunction->None], "[", 
           RowBox[{"Cos", "[", "t", "]"}], "]"}]}], "+", 
         RowBox[{"8", " ", 
          RowBox[{"Abs", "[", 
           RowBox[{"Sin", "[", "t", "]"}], "]"}], " ", 
          RowBox[{"Cos", "[", "t", "]"}], " ", 
          RowBox[{
           SuperscriptBox["Abs", "\[Prime]",
            MultilineFunction->None], "[", 
           RowBox[{"Sin", "[", "t", "]"}], "]"}]}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"9", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]], " ", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           FractionBox["9", "4"], " ", 
           SuperscriptBox[
            RowBox[{"Abs", "[", 
             FractionBox[
              RowBox[{
               RowBox[{
                RowBox[{"-", "8"}], " ", 
                RowBox[{"Abs", "[", 
                 RowBox[{"Cos", "[", "t", "]"}], "]"}], " ", 
                RowBox[{"Sin", "[", "t", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["Abs", "\[Prime]",
                  MultilineFunction->None], "[", 
                 RowBox[{"Cos", "[", "t", "]"}], "]"}]}], "+", 
               RowBox[{"8", " ", 
                RowBox[{"Abs", "[", 
                 RowBox[{"Sin", "[", "t", "]"}], "]"}], " ", 
                RowBox[{"Cos", "[", "t", "]"}], " ", 
                RowBox[{
                 SuperscriptBox["Abs", "\[Prime]",
                  MultilineFunction->None], "[", 
                 RowBox[{"Sin", "[", "t", "]"}], "]"}]}]}], 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"9", "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox[
                   RowBox[{"Abs", "[", 
                    RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox[
                   RowBox[{"Abs", "[", 
                    RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}], ")"}], 
               RowBox[{"3", "/", "2"}]]], "]"}], "2"]}], "+", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"-", 
              FractionBox[
               RowBox[{"2", " ", 
                RowBox[{"Sin", "[", "t", "]"}]}], 
               SqrtBox[
                RowBox[{"9", "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox[
                   RowBox[{"Abs", "[", 
                    RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox[
                   RowBox[{"Abs", "[", 
                    RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}]]]}], "-", 
             
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Cos", "[", "t", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "8"}], " ", 
                   RowBox[{"Abs", "[", 
                    RowBox[{"Cos", "[", "t", "]"}], "]"}], " ", 
                   RowBox[{"Sin", "[", "t", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["Abs", "\[Prime]",
                    MultilineFunction->None], "[", 
                    RowBox[{"Cos", "[", "t", "]"}], "]"}]}], "+", 
                  RowBox[{"8", " ", 
                   RowBox[{"Abs", "[", 
                    RowBox[{"Sin", "[", "t", "]"}], "]"}], " ", 
                   RowBox[{"Cos", "[", "t", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["Abs", "\[Prime]",
                    MultilineFunction->None], "[", 
                    RowBox[{"Sin", "[", "t", "]"}], "]"}]}]}], ")"}]}], ")"}],
               "/", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"9", "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox[
                   RowBox[{"Abs", "[", 
                    RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox[
                   RowBox[{"Abs", "[", 
                    RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}], ")"}], 
               RowBox[{"3", "/", "2"}]]}]}], "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{"-", 
              FractionBox[
               RowBox[{"2", " ", 
                RowBox[{"Cos", "[", "t", "]"}]}], 
               SqrtBox[
                RowBox[{"9", "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox[
                   RowBox[{"Abs", "[", 
                    RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox[
                   RowBox[{"Abs", "[", 
                    RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}]]]}], "+", 
             
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Sin", "[", "t", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "8"}], " ", 
                   RowBox[{"Abs", "[", 
                    RowBox[{"Cos", "[", "t", "]"}], "]"}], " ", 
                   RowBox[{"Sin", "[", "t", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["Abs", "\[Prime]",
                    MultilineFunction->None], "[", 
                    RowBox[{"Cos", "[", "t", "]"}], "]"}]}], "+", 
                  RowBox[{"8", " ", 
                   RowBox[{"Abs", "[", 
                    RowBox[{"Sin", "[", "t", "]"}], "]"}], " ", 
                   RowBox[{"Cos", "[", "t", "]"}], " ", 
                   RowBox[{
                    SuperscriptBox["Abs", "\[Prime]",
                    MultilineFunction->None], "[", 
                    RowBox[{"Sin", "[", "t", "]"}], "]"}]}]}], ")"}]}], ")"}],
               "/", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"9", "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox[
                   RowBox[{"Abs", "[", 
                    RowBox[{"Cos", "[", "t", "]"}], "]"}], "2"]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox[
                   RowBox[{"Abs", "[", 
                    RowBox[{"Sin", "[", "t", "]"}], "]"}], "2"]}]}], ")"}], 
               RowBox[{"3", "/", "2"}]]}]}], "]"}], "2"]}], ")"}]}]}], 
      ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.5904451486371727`*^9, 3.590445583872284*^9, 
  3.608300539164443*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myN", "=", 
  RowBox[{"%", "/.", 
   RowBox[{"t", "\[Rule]", 
    RowBox[{"3", " ", 
     RowBox[{"\[Pi]", "/", "2"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.5904451635168133`*^9, 3.590445182248258*^9}, {
  3.590445597781577*^9, 3.590445604052827*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5904451831644583`*^9, {3.5904455946808023`*^9, 3.590445604791148*^9}, 
   3.608300539258819*^9}]
}, Open  ]],

Cell[TextData[{
 "\[LineSeparator]\n\[LineSeparator]The binormal vector.  To get the cross \
product operator, enter ",
 StyleBox["esc", "Code"],
 " cross ",
 StyleBox["esc", "Code"],
 "."
}], "Text",
 CellChangeTimes->{{3.590445247063789*^9, 3.5904452740926456`*^9}, 
   3.5904456369962482`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myB", " ", "=", 
  RowBox[{"myT", " ", "\[Cross]", " ", "myN"}]}]], "Input",
 CellChangeTimes->{{3.590445300253571*^9, 3.5904453146278677`*^9}, {
  3.5904453716684227`*^9, 3.590445376746313*^9}, {3.590445612627631*^9, 
  3.590445618529482*^9}, {3.590445682601686*^9, 3.5904456859127893`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["3", 
     SqrtBox["13"]]}], ",", "0", ",", 
   FractionBox["2", 
    SqrtBox["13"]]}], "}"}]], "Output",
 CellChangeTimes->{3.590445315720623*^9, 3.5904453774332523`*^9, 
  3.590445619020056*^9, 3.59044568759438*^9, 3.608300539364499*^9}]
}, Open  ]],

Cell["\<\

Is this a unit vector??\
\>", "Text",
 CellChangeTimes->{{3.590445662578967*^9, 3.590445666920195*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", "myB", "]"}]], "Input",
 CellChangeTimes->{{3.590445644383288*^9, 3.590445654691493*^9}, {
  3.590445690738565*^9, 3.590445692824018*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.5904456554978228`*^9, 3.5904456932776327`*^9, 
  3.608300539393374*^9}]
}, Open  ]]
},
WindowSize->{740, 652},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 576, 14, 28, "Input"],
Cell[1158, 38, 11930, 202, 447, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13125, 245, 318, 9, 28, "Input"],
Cell[13446, 256, 282, 8, 28, "Output"]
}, Open  ]],
Cell[13743, 267, 709, 21, 106, "Text"],
Cell[CellGroupData[{
Cell[14477, 292, 382, 10, 28, "Input"],
Cell[14862, 304, 1431, 44, 111, "Output"]
}, Open  ]],
Cell[16308, 351, 110, 2, 30, "Text"],
Cell[CellGroupData[{
Cell[16443, 357, 326, 8, 28, "Input"],
Cell[16772, 367, 321, 9, 52, "Output"]
}, Open  ]],
Cell[17108, 379, 118, 5, 68, "Text"],
Cell[CellGroupData[{
Cell[17251, 388, 282, 8, 28, "Input"],
Cell[17536, 398, 475, 10, 24, "Message"],
Cell[18014, 410, 22575, 582, 1546, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40626, 997, 277, 7, 28, "Input"],
Cell[40906, 1006, 204, 5, 28, "Output"]
}, Open  ]],
Cell[41125, 1014, 296, 9, 87, "Text"],
Cell[CellGroupData[{
Cell[41446, 1027, 316, 5, 28, "Input"],
Cell[41765, 1034, 312, 9, 52, "Output"]
}, Open  ]],
Cell[42092, 1046, 114, 4, 49, "Text"],
Cell[CellGroupData[{
Cell[42231, 1054, 174, 3, 28, "Input"],
Cell[42408, 1059, 121, 2, 28, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
