(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     20261,        541]
NotebookOptionsPosition[     19579,        514]
NotebookOutlinePosition[     19933,        530]
CellTagsIndexPosition[     19890,        527]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Imagine that the origin is a point on a continuous surface.\[LineSeparator]\
\[LineSeparator]We\[CloseCurlyQuote]d like to ",
 StyleBox["estimate",
  FontSlant->"Italic"],
 " the position of another point on the surface, at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "y", ",", " ", 
     RowBox[{"z", "(", 
      RowBox[{"x", ",", "y"}], ")"}]}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " using the values of the first couple of directional derivatives ",
 StyleBox["calculated at the origin",
  FontWeight->"Bold"],
 ".\n\nIf the surface is continuous, we should get the same value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " no matter what path we take.\n\nThough there are an infinite number of \
ways to move from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "0"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", two that are particularly easy to calculate are these paths, consisting \
of two straight segments:\n\n1.) Moving from ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0", ",", "0"}], ")"}], " ", "\[Rule]", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", ",", "0"}], ")"}], "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"x", ",", "y"}], ")"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "\n2.) Moving from ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0", ",", "0"}], ")"}], "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"0", ",", "y"}], ")"}], "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"x", ",", "y"}], ")"}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "\n\nUsing only the values for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "x"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "y"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " calculated at the origin, the result along both paths is the same, that"
}], "Text",
 CellChangeTimes->{{3.735131064127647*^9, 3.735131071269144*^9}, {
  3.735131168974304*^9, 3.735131438871715*^9}, {3.735131470612514*^9, 
  3.7351316875546207`*^9}, {3.735131718445669*^9, 3.7351318365985603`*^9}, {
  3.7351319182841263`*^9, 3.735131962701928*^9}, {3.7351336528092003`*^9, 
  3.735133678427314*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"z", "(", 
          RowBox[{"x", ",", "y"}], ")"}], "=", 
         RowBox[{
          RowBox[{"x", " ", 
           SubscriptBox["f", "x"]}], "+", 
          RowBox[{"y", " ", 
           SubscriptBox["f", "y"]}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.735132001829565*^9, 3.735132033081376*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Graphics3D", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"Thick", ",", "Red", ",", "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", "  ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "0", ",", 
            RowBox[{"fx", "*", " ", "3"}]}], "}"}]}], "  ", "}"}], "]"}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", "  ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "2", ",", 
            RowBox[{"fy", "*", "2"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "2", ",", 
            RowBox[{
             RowBox[{"fx", "*", "3"}], "+", 
             RowBox[{"fy", "*", "2"}]}]}], "}"}]}], "  ", "}"}], "]"}], ",", 
       "\[IndentingNewLine]", "Blue", ",", "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", "  ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "2", ",", 
            RowBox[{"fy", "*", "2"}]}], "}"}]}], "  ", "}"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", "  ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"3", ",", "0", ",", " ", 
            RowBox[{"fx", "*", "3"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"3", ",", "2", ",", 
            RowBox[{
             RowBox[{"fx", "*", "3"}], "+", 
             RowBox[{"fy", "*", "2"}]}]}], "}"}]}], "  ", "}"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PointSize", "[", "Large", "]"}], ",", "Black", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], "]"}]}], "  ", 
      RowBox[{"(*", " ", 
       RowBox[{"the", " ", "origin"}], " ", "*)"}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "3.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "3.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", 
          RowBox[{"+", "5"}]}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
     
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"fx", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "0.5"}], ",", 
     RowBox[{"+", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"fy", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "0.5"}], ",", 
     RowBox[{"+", "1"}]}], "}"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQvdRH3cPwymvHfdV/PUG0haN1NIiucjgGpvNYOHNA
9Ilbz8F0yG+1QhAteYKxHER7e62rAdE3WiXaQDSv+fduEB3wQLgXRKtcy5gI
oo277k8C0ecVUpaD6EM/rXaA6GfMU4+A6IkPFE+D6HXWlhfA7pjCcRlEzzpz
+hqILrgceQdEO3GFPgTREr8aH4Fo9e9mL0D0hVSztyBauqjlI4h+nNf6BURv
ef6E2QhIf6r8IQCiK6bJioLoBP1waRB96FCAEYj+FnrLBET3Xbd2AtFFea99
wepsXoeC6AWzK8JAtERUcTqI3iXPnQGiLxgxHzYG0hvMfcA0ADO0sLE=
  "]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`fx$$ = 
    0.43600000000000005`, $CellContext`fy$$ = 0.494, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`fx$$], 0}, -0.5, 1}, {{
       Hold[$CellContext`fy$$], 0}, -0.5, 1}}, Typeset`size$$ = {
    294., {214., 218.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`fx$90934$$ = 
    0, $CellContext`fy$90935$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`fx$$ = 0, $CellContext`fy$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`fx$$, $CellContext`fx$90934$$, 0], 
        Hold[$CellContext`fy$$, $CellContext`fy$90935$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{Thick, Red, 
         Line[{{0, 0, 0}, {3, 0, $CellContext`fx$$ 3}}], 
         Line[{{0, 2, $CellContext`fy$$ 2}, {
           3, 2, $CellContext`fx$$ 3 + $CellContext`fy$$ 2}}], Blue, 
         Line[{{0, 0, 0}, {0, 2, $CellContext`fy$$ 2}}], 
         Line[{{3, 0, $CellContext`fx$$ 3}, {
           3, 2, $CellContext`fx$$ 3 + $CellContext`fy$$ 2}}], 
         PointSize[Large], Black, 
         Point[{{0, 0, 0}}]}, PlotRange -> {{-0.5, 3.5}, {-0.5, 3.5}, {-2, 
           Plus[5]}}, Axes -> True, 
        AxesLabel -> {$CellContext`x, $CellContext`y, $CellContext`z}], 
      "Specifications" :> {{{$CellContext`fx$$, 0}, -0.5, 
         1}, {{$CellContext`fy$$, 0}, -0.5, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{339., {273., 279.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.735130740139675*^9, 3.7351308093290977`*^9, 
  3.7351309491041327`*^9, 3.735132332213313*^9, 3.735133724603092*^9}]
}, {2}]],

Cell[TextData[{
 "Now, if we take into account the next higher order of \
\[OpenCurlyDoubleQuote]twist\[CloseCurlyDoubleQuote] derivatives, the value \
for ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " reached for the first segment of the path is the same. But for the second \
segment, the slope has changed a bit. For the first path, we get\n"
}], "Text",
 CellChangeTimes->{{3.7351324522465563`*^9, 3.735132485750327*^9}, {
  3.7351325182298937`*^9, 3.735132556455482*^9}, {3.7351329817632627`*^9, 
  3.73513306034061*^9}, {3.73513358673524*^9, 3.735133593561036*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"z", "(", 
          RowBox[{"x", ",", "y"}], ")"}], "=", 
         RowBox[{
          RowBox[{"x", " ", 
           SubscriptBox["f", "x"]}], "+", 
          RowBox[{
           RowBox[{"y", "(", 
            RowBox[{
             SubscriptBox["f", "y"], "+", 
             RowBox[{"x", " ", 
              SubscriptBox["f", "yx"]}]}], ")"}], Cell["="], "x", " ", 
           SubscriptBox["f", "x"]}], "+", 
          RowBox[{"y", " ", 
           SubscriptBox["f", "y"]}], "+", 
          RowBox[{"y", " ", "x", " ", 
           SubscriptBox["f", "yx"]}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.735132001829565*^9, 3.735132033081376*^9}, {
  3.735132633280645*^9, 3.735132710255292*^9}, {3.7351327460500317`*^9, 
  3.735132798226472*^9}}],

Cell["and for the second path", "Text",
 CellChangeTimes->{{3.735132834789999*^9, 3.7351328389860773`*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"z", "(", 
          RowBox[{"x", ",", "y"}], ")"}], "=", 
         RowBox[{
          RowBox[{"y", " ", 
           SubscriptBox["f", "y"]}], "+", 
          RowBox[{
           RowBox[{"x", "(", 
            RowBox[{
             SubscriptBox["f", "x"], "+", 
             RowBox[{"y", " ", 
              SubscriptBox["f", "xy"]}]}], ")"}], Cell["="], "x", " ", 
           SubscriptBox["f", "x"]}], "+", 
          RowBox[{"y", " ", 
           SubscriptBox["f", "y"]}], "+", 
          RowBox[{"y", " ", "x", " ", 
           SubscriptBox["f", "xy"]}]}]}]}
      },
      GridBoxAlignment->{"Columns" -> {{"Center"}}}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], TraditionalForm]]]], "Text",
 CellChangeTimes->{{3.735132001829565*^9, 3.735132033081376*^9}, {
  3.735132633280645*^9, 3.735132710255292*^9}, {3.7351327460500317`*^9, 
  3.735132798226472*^9}, {3.7351329055660257`*^9, 3.735132954838387*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Graphics3D", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"Thick", ",", "Red", ",", "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", "  ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "0", ",", 
            RowBox[{"fx", "*", " ", "3"}]}], "}"}]}], "  ", "}"}], "]"}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", "  ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "2", ",", 
            RowBox[{"fy", "*", "2"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "2", ",", 
            RowBox[{
             RowBox[{"fx", "*", "3"}], "+", 
             RowBox[{"fy", "*", "2"}], "+", 
             RowBox[{"3", "*", "fxy", "*", "2"}]}]}], "}"}]}], "  ", "}"}], 
        "]"}], ",", "\[IndentingNewLine]", "Blue", ",", "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", "  ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "2", ",", 
            RowBox[{"fy", "*", "2"}]}], "}"}]}], "  ", "}"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", "  ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"3", ",", "0", ",", " ", 
            RowBox[{"fx", "*", "3"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"3", ",", "2", ",", 
            RowBox[{
             RowBox[{"fx", "*", "3"}], "+", 
             RowBox[{"fy", "*", "2"}], "+", 
             RowBox[{"2", "*", "fyx", "*", "3"}]}]}], "}"}]}], "  ", "}"}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PointSize", "[", "Large", "]"}], ",", "Black", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], "]"}]}], "  ", 
      RowBox[{"(*", " ", 
       RowBox[{"the", " ", "origin"}], " ", "*)"}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "3.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "3.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", 
          RowBox[{"+", "5"}]}], "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
     
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"fx", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "0.5"}], ",", 
     RowBox[{"+", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"fy", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "0.5"}], ",", 
     RowBox[{"+", "1"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"fxy", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "0.25"}], ",", ".5"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"fyx", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "0.25"}], ",", ".5"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.735133151327649*^9, 3.735133273791369*^9}, {
  3.735133921798991*^9, 3.73513392470271*^9}, {3.7351341692325068`*^9, 
  3.7351341808057957`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`fx$$ = 0.748, $CellContext`fxy$$ = 
    0.247, $CellContext`fy$$ = 0.272, $CellContext`fyx$$ = 0.239, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`fx$$], 0}, -0.5, 1}, {{
       Hold[$CellContext`fy$$], 0}, -0.5, 1}, {{
       Hold[$CellContext`fxy$$], 0}, -0.25, 0.5}, {{
       Hold[$CellContext`fyx$$], 0}, -0.25, 0.5}}, Typeset`size$$ = {
    294., {214., 218.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`fx$94172$$ = 
    0, $CellContext`fy$94173$$ = 0, $CellContext`fxy$94174$$ = 
    0, $CellContext`fyx$94175$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`fx$$ = 0, $CellContext`fxy$$ = 
        0, $CellContext`fy$$ = 0, $CellContext`fyx$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`fx$$, $CellContext`fx$94172$$, 0], 
        Hold[$CellContext`fy$$, $CellContext`fy$94173$$, 0], 
        Hold[$CellContext`fxy$$, $CellContext`fxy$94174$$, 0], 
        Hold[$CellContext`fyx$$, $CellContext`fyx$94175$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{Thick, Red, 
         Line[{{0, 0, 0}, {3, 0, $CellContext`fx$$ 3}}], 
         Line[{{0, 2, $CellContext`fy$$ 2}, {
           3, 2, $CellContext`fx$$ 3 + $CellContext`fy$$ 2 + 
            3 $CellContext`fxy$$ 2}}], Blue, 
         Line[{{0, 0, 0}, {0, 2, $CellContext`fy$$ 2}}], 
         Line[{{3, 0, $CellContext`fx$$ 3}, {
           3, 2, $CellContext`fx$$ 3 + $CellContext`fy$$ 2 + 
            2 $CellContext`fyx$$ 3}}], 
         PointSize[Large], Black, 
         Point[{{0, 0, 0}}]}, PlotRange -> {{-0.5, 3.5}, {-0.5, 3.5}, {-2, 
           Plus[5]}}, Axes -> True, 
        AxesLabel -> {$CellContext`x, $CellContext`y, $CellContext`z}], 
      "Specifications" :> {{{$CellContext`fx$$, 0}, -0.5, 
         1}, {{$CellContext`fy$$, 0}, -0.5, 
         1}, {{$CellContext`fxy$$, 0}, -0.25, 
         0.5}, {{$CellContext`fyx$$, 0}, -0.25, 0.5}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{339., {301., 307.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.735133121731576*^9, 3.735133277813345*^9, 
  3.735133928230528*^9, 3.735134185093309*^9}]
}, {2}]]
},
WindowSize->{808, 755},
WindowMargins->{{28, Automatic}, {36, Automatic}},
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 28, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 2581, 76, 291, "Text"],
Cell[3142, 98, 550, 17, 34, "Text"],
Cell[CellGroupData[{
Cell[3717, 119, 3635, 95, 369, InheritFromParent],
Cell[7355, 216, 2502, 49, 569, "Output"]
}, {2}]],
Cell[9869, 268, 614, 12, 88, "Text"],
Cell[10486, 282, 993, 28, 36, "Text"],
Cell[11482, 312, 107, 1, 30, "Text"],
Cell[11592, 315, 1041, 28, 36, "Text"],
Cell[CellGroupData[{
Cell[12658, 347, 3858, 103, 411, "Input"],
Cell[16519, 452, 3047, 59, 625, "Output"]
}, {2}]]
}
]
*)

