(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   1243314,      21582]
NotebookOptionsPosition[   1240686,      21494]
NotebookOutlinePosition[   1241060,      21511]
CellTagsIndexPosition[   1241017,      21508]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.52509949349772*^9, 3.525099543444665*^9}, {
  3.525099689919263*^9, 3.5250997175474453`*^9}}],

Cell[CellGroupData[{

Cell["\[LineSeparator]Kitten problem, revisited\[LineSeparator]\
\[LineSeparator]", "Subsubsection",
 CellChangeTimes->{{3.608660667538516*^9, 3.6086606872742777`*^9}, {
  3.608660738468471*^9, 3.608660738996827*^9}, {3.608661176168344*^9, 
  3.608661178760086*^9}}],

Cell["\<\
You estimated the location of the highest temperature (on the boundary) \
visually.\
\>", "Text",
 CellChangeTimes->{{3.608660695299752*^9, 3.608660734346999*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myT", "=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"2", "x", " ", "y"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myCP", "=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{"myT", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "40"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myPoint", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Black", ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", 
         RowBox[{"1", "/", "3"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myBound", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Thickness", "[", "0.05", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myQuad", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"t", "^", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"myCP", ",", "myPoint", ",", "myBound", ",", "myQuad"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.608659329102354*^9, 3.608659448368451*^9}, {
  3.6086595068865643`*^9, 3.608659531308419*^9}, {3.608659562641988*^9, 
  3.608659617171582*^9}, {3.6086596495258636`*^9, 3.608659670882723*^9}, {
  3.60865982423487*^9, 3.608659836634533*^9}, {3.6086598963771467`*^9, 
  3.608660023053296*^9}, {3.60866011016992*^9, 3.608660167948677*^9}, {
  3.608660432850375*^9, 3.608660443168181*^9}, {3.608733551545124*^9, 
  3.608733560445125*^9}, {3.608733603665*^9, 3.6087336721768913`*^9}}],

Cell[BoxData[
 RowBox[{"Thickness", "[", "0.05`", "]"}]], "Output",
 CellChangeTimes->{{3.608659922092493*^9, 3.608659958387548*^9}, 
   3.6086600242709923`*^9, 3.6086601183105164`*^9, {3.6086601621427107`*^9, 
   3.608660168706111*^9}, {3.60866043639686*^9, 3.608660443917066*^9}, 
   3.608660565171238*^9, 3.6087335619258003`*^9, {3.608733615593721*^9, 
   3.608733643310297*^9}, 3.608733673912527*^9, 3.608753726149931*^9, 
   3.608753866415155*^9, 3.653242793528283*^9, 3.6532436123780603`*^9, 
   3.653243705720566*^9, 3.6534842792606583`*^9}],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJyEfQVYlM/zOGAndmB3dweOLQa2Ynd3t9jdmIgFBiImIiIlndLdF9wdHMcd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    "], {{
      {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1ULtOAgEQnByaeHJyELgPMOETfHTS0dH4CRJa/RA7+AXvG0xAaqKtJso1
YKKFpYkUNIaZzFJsZrM7Ozu7pzd317cJgC6jxqinwJb4w5gcA7/EQQ68ZEBF
Yq0FLBP31zC3wZlPYp4618wXeSviYxvIUutqftkxryKeFa5Ju0xd34SedKUz
PAEW5DyR896x1nlhzkPsLSNXTV41N6b3JLz+N61dBqdHzuwAuMo9V8bey8I8
efyIXdqpeek808Or7jkC5plR9f0f6nG7MItc/Sr+pRt0y6jhmniq77Vmbf9L
f7un/ynzt0Pgr+lQ/s2b+oX9XhB3UYhFdQ==
          "]], 
         PolygonBox[{{3685, 711, 1211, 3903}, {2700, 224, 2311, 5330}, {4355, 
          730, 729, 4354}, {5429, 2316, 730, 5428}, {5051, 2060, 224, 2700}, {
          2706, 241, 2316, 5336}, {4581, 1492, 223, 4580}, {5338, 2319, 241, 
          2707}, {5330, 2311, 1492, 5050}, {3273, 729, 2060, 5075}, {2699, 
          223, 711, 3427}, {5430, 245, 2319, 5431}}]}]}, 
      {RGBColor[0.18832000000000004`, 0.35240000000000005`, 0.57776], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUbtKA1EQnUSN+8hr2d1OUL/BF1bptcsHWPgotEhs/QELtVL8D0EUH71E
CAhGJYrZZEVBBCt/wHM4t7jMzJ0zZ87MzK63m62imS3jjeEVI7NsAj7sGj4C
z+wOgOtY/hVsB3EI/7RglsPvjJsNYfdLZr7DPybCHAVme77ZDp4Hvp+66tqh
csTcgnMb+Rn4I9TexPonB7W8431D2yT+SsD1EDdrZr/4W4HtAT+N3H1Z9eQh
/iyRlgFm6cOvoPYYPfuIB8ifo26jojkPA8X8PwjUM/DFc4K4Dv8t0Yzk5AzU
Qk0ZMJex/ItYtdTDPc2nmm0BtoWZPexqsyqs52q7bqcfkXZJnZzDqBNchUia
qK0B+5JI2zNsBzNPgWcu1Q1YR828A+eiVuapiT2eYnGSO4+U5544H3vzntRF
ndS2WhNvt6wcfe79r647vEbqzR4PsW7MWxO7G2pPvDlvkrk7LqXCLKbC546T
uoZO/2ekXX/BNmrSs1WVxpHT8Q98RWV0
          "]], PolygonBox[CompressedData["
1:eJwtUUsvQ2EQPb1tua/Sm9u7k2DhH3jssJIgNn6ARbFg0dr6AzZ2xE/xbG2l
pIlFPVpxS4XExoo1zuR08SXzzZw558zMeLm6WnEATPDl+LIR0M0DYy5wEwJL
w8AX8y8ELTP+YH1vADjKAD9F4KkEFD2gx3qH8QoxjZxyhz7wS8xzXpwOe++J
8T3l/lhbJP4Tyj2UxGFc2/zPJMABOQqeOI27GcpLyv67GHgk/tURps24xlxA
7w3mLol9ixSb351AmqY9YhjWywVgLQvUyT9P/s0hwM3pX2e9w/4W8Sk9thlv
9Osu+2usVwNxX1GjF2kn9jcPF/QyxRm2PHk0r/u+9DzWT1k/4/Nd5czLLD10
IY05xrdx3yv7m7FmsniUuVYsD+ZlkO8k1s3sdqY5Se3pRLvc5VtIpGnadsP3
SDPbrKZX4SzHsbhs5m/Okom0a7uR3eo6lLbt0G5rO7J+879O/2mkXdhM5+T6
BwU/Wao=
          "]]}]}, 
      {RGBColor[0.21856, 0.36920000000000003`, 0.6060800000000001], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFUssuQ1EU3aWVtrd63ZxrokmTfoakpFMkJOYGGloDWlNDr4EYEp9BaAk1
9IhBi4pHUa96/IA51s46icHJ2nfftdfee52TyhZHC20iksZpx8lFRD7CIndI
toALHSIniKeQ/8R3A/Eq4h7Ey/j36oksAV+AbzYuOqzR2vWASLaTuG9Ebn38
C4oMuCJ56JwGqak9c1a3gtwYhjlGfs9Q6zCGWugfId6ERiJMHZ3zCpwkvuvA
jPvfsxdxEzutRFmvOhNxkbMY6367RL5w1sCfdthzI8S++k85N+g1jz1CYfb+
tvxdw5knI+TNOMyrnuYS1sNHjz48AIe76d0IMBOlv1vQH3LpwyDwGrop5Ksx
5tSjH+hcgrcInWeP++ssc+iVjXNH3fXAkPMETsPj3PceecqvQLNsuOc4/Kn7
vMN3jx6pTj9wx+du2z77673rDCWfcdneYdK+B0V9HxrXgpxb+Yopy9G6vOWo
lzqDzjTrcIaWnVdz6mPa5TvoA1YN38UFsOlxR/VD35DOEUCu4PDe9f5rhv6f
A/8AQLB3gg==
          "]], PolygonBox[CompressedData["
1:eJwtUUsvg1EUnFbbfP1U68vXbkgkXfkBtsRrR0LSvYV6xIL6DV4blsTf8GgJ
3VIkWlRo6x1FYm8v5mQsbjL3zpwzc85NZxczuSCAbp4QTzEGnPBhogUo+MB9
EqjzXiJZI55vBTYD0tQ84JKamSjw6QD75A988SXyh8RTceCU+Jm9s8Q3fJuj
vov6W+KAp94NC0HckwJmo/K8YJZrajocvRl3xXunI0/zno7La4ueOWar+upt
Pc9jOoatpkJu0AU+iFcizES/vaSym8eQqwyWJc37HfU75JuOPOrkyjFxZ+w5
mgBGEsIVngxxnjVh8kvs3/BUY7W2kwXme+N9NaIMlqXA/l+OdmK7eSS/HJHn
gKtMlm2D/Bjnf/GU3ep3Wbvu6q/M07z7mKEY0s5t9/3kt8PSmLbJ+rWIepap
n2wTZzW9rB2m5jeoTHn2f/33s/1+twNHvrC9HfvKYFlspndqHzzNbvP+UD+e
UnbzrCbVw+ptxidq/wALtGRd
          "]], 
         PolygonBox[{{4331, 4330, 2927, 1668, 4576}, {4579, 1669, 2928, 4330, 
          4331}}]}]}, 
      {RGBColor[0.24879999999999997`, 0.386, 0.6344], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUztPVGEQHXFf3F129+a7FBQU/AljeCQILdFAsYVgYHdbhIpAaBQrEzoi
b62NFeFRLFZCMJqwuwIFJEAAQ0yMhkdv4zk5X3EzszNn5jtnZratND4w1mBm
ffge4vuVN6vGzXZDs8EmswKCz2HvkmbxRrM6cjfwY/Br8F8nUAf/B2q3nFki
ZfY5I8wtvgPEZ+OKzz0w24jMWuDvO/W48ZiewOwQdh35D07vvYdtTYnDEXLD
WbMz2Mc5YCPxedZs9g/5vZjZMYS8DYTpgv0CDXX479DnT1I8yGEGGneAncwr
R8wM8Bvwh9BrBHorMfnEfYpUOw18MasYe5TgJ4ErZ6V1KiEtnN+rhPqeh4o9
Qf9yWlz7gT8OhRlF7GmztHMGP1N6i7UHXv+W18qZEEd77/12zGIbHDpy0sC6
R7A1p3l8y0gnOW/DP/I92Zt7IB/iVp12sQK75LTPN4H2RFzdaQ+sJb7stXfh
3bNQt/A7r37Ek9vLtO7jJNQs53lXDeLL3/SpgzXEc368L86LvPnOId79ivoJ
5Jad5sj8JWIfM9rrAuIv0sIQ2x2I/yn8zUi30xsoT57MkTtnwnvgPfFmeDtX
oTj8hZbOnPJF3MNIWvy+h6qt+HreXcHPkPrZ/8LvlrvkPhadboL/Lc6CM1mL
9L+hX/Xv8d3rUP02Y+L9H79hlIo=
          "]], PolygonBox[CompressedData["
1:eJwtkjksRHEQxsfagz14L7sKhUKvljijVBEKhSPsKl2VBA3RiU7ipnYUhN3C
qhCFwq5dhQJxREJIHL3Gb8wWk/fNf76Zb45XnRjrHPWISA3mxVIxkaoSkWtw
EtwcFFn0ifQWi8yBXx2RS/wZv8hISKSWtyzced524O/HLHbFWwux2aDh4lK+
xDrKRH6p9ROAHxa5cEUm4H/hb+M/4Geo5YWfg/+Cn8X34efx3xyLj5PTh/6t
a/X17Q78iOXEcp7A745h1RiAP+VYrx/obYVtJp3tiOHrykUasDT4jKUM0Otq
1LRUYwV85tr8OvOJazmaG8AS8DfgfAdMU7Xz+Deewk7Bu2gm4Xah2RNBI2L6
qllPrVbs3Gs7GqTf7ohx9U1jk4X+n6m3F7Metdc7+ukHp6l/6rGah+gNU2Pa
bz3r7XTnunvtcTNqO/7fNfn3zLMUtd0sFIkMhUxDtbTGjWs31FtqvWW4Wayy
xGbMgOMRy/XzlsI/gJ8X4xzG7MZ6609snfhx2Lg6k87WXlG4NTlt4KZy263W
bASvRS1X763/gvaoMZ05zvx/iXFyZA==
          "]]}]}, 
      {RGBColor[0.28026, 0.4022, 0.65432], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUssrxFEY/TAemd/85jf95h+Q7EVZsFZShFIYzGCpKFmxIAuP2cn7tTXj
kbzyWBHCRtZSymoSf4RzOndx+7577/edc75zb9XweNdYsZk1Y5VgFcrNsqVm
y0VmP4HZIuJuaNYbM+tGQQ/iH2p+sc7QmML+EvHQM8v4ZqURs6a4WV/UbB69
1chT6FsB5j3qdoB1jpj3VHuNdYf9RBn4ytXz7XgHgXGYFE8bsIexX8J5DTAn
A/VdAWczlKYtxMeE6tm3FgpzHzUH2H9WmDVUQkdCfA+IaaeZ2keBX4Z8HX0D
2EeQzwbiI+9QVPNQYy/yPDA/gJlLqm8VM77Bw9NQM6djwqCn9HM6kFcdwK4D
zjnu6uPyldpOi4WRdTiMxGfe4jT0AbM2rrNZzHIM7gv0vWCWo6S8fUKeicpD
vuGgm4Uz0W9qo3fkJzd5bzy9z0koP3hPzdzz/Br3OU+1U8D8wlrAfQo8M+4t
+CYj7o2odyCqmkKgPnpE3UO+cvrNGSMV4jrwNEunLzxq5jl9pOYzaGn3VcO5
G+O6z8T0nzj7K2Zv9cVDn54TOqc3Bad5m38wFO8t+vqdTs7Ev/Pr/uF7Uvkc
fN4LxUuNG6HOeZ92PvPP/gPOlHpt
          "]], PolygonBox[CompressedData["
1:eJwtkskuRGEQhQvdiNvdunO9gL0ViQjxAoQgkdBttiexITaGhWkn5mmHZkcT
w8o8bDyAWAvCQ/hOqhd/UueeqnPOX/+tHBrtGCk0sypOhHOfMhsrNpsrMPtM
mtWWmX2UmnUWmc1QP8GfMjAP3xuYZSvM3uGXomYT9E9yTgp95hiuOeH4De0m
6ppys1zEv4lr55xRL6I3jN4r+jnwAngAPF3ms/I4Qi8TuLcyPNA7g98q3sVo
DqK1HzP7KuEu4D7wbuha8tij7or7XZShmix9gfPyfEZvO3R94R3qdNyznYMz
1C8p19JMP7NtCefUM6S8Sfe+4dsUdUvCs2qfafiLmHMZMpyg/5i/rzx74BvI
FGV+GVxf7jtX3m/utEp/I3gl6vML1Acx59TTTb7BwLMoYyve40l/G+1Iu7qm
P5J/L3F3+feWhrTq8LyMeIb+hL+perVT7Vae8laPetdD373eMws/C/9L7x9n
E+409P5b+Cv4rdA57UT/ku4kb2W4Tfk/p11JYwOuO3D8A14DH8a8Vr+yD8R9
V7pTDv4f0Pxo2g==
          "]]}]}, 
      {RGBColor[0.31782, 0.4154, 0.63224], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1U01PU1EQnZa2FN7j9d08+AH8AF3UhfEnIBWIIdECwdCFxmgUoimwQNiY
uIQSQly4kgIbKCRA2CACxo+EvQnhY6X/AL82ek7OdfEyc+fOnDlz5r7OytPb
T9JmVsbXhO+jM6vmzIYDs9O82S8E3yO+kJj9hF9GvLMgvxSZrbab9cOfaTU7
ySveAGC5TbYeml0itg7/GDirGbPfOL/BeSOj2jX4e052GXgTsfJX4D8Hl1SL
2YGphrWH8Icj5SwB/1lOXMmT9+d55RCLmFXgjeXEj5x6IuWNYJYi/NeI1UL1
Yb/PWWGM54Rz3K76fXBMtyj+JSttWMu+1OwsL56cdzMjfj/8fC9Twmh4fxf9
mpC/CV3HEvWZhIbfms1eAXs2pVpqxPpaVnFquIXaCngUO8weJuo/jtp5+N9R
X4O9H0uvEvbwNhTuXCK9yIsaU3vmE59c/jarb7EgjndR+wJ5c+g7BXvgxH85
1F7pM3alIF7TrcJIA+sE5wb6Gfxtz5d3jNMyzl6cKeX9jUT+DvJ7sZc/4PcA
fR8n0nUC+NcjaUXNRhPt4QI5p7HnHEj7fv/mpmNpNwPbFWk3VwvaIXdJrKFA
e/+AWerY9VdwWILtjrSDa8h/lOhdnMWyfHPUnTtnLfmRB/lsO9mqj79z2j3f
0XyoN1P08/F/4J4qgc59iHe1KYe5R069BnF/JxB/zjEQ6P3dgn/T8yTfekb/
IOv/c10Hxr1AM39y0pwzcmfEYA3zt5z4Uu/FULxuAHPNaVa+Nb4nxnn/D+21
qtg=
          "]], PolygonBox[CompressedData["
1:eJwtk0lrVFEQhatfosb3Ot3v0e0PCOJS0YgE/QeKEyKYOCTYCwUFB4yJIphs
RBcuTMSFC1caDWp3EojDxlkcQN0KIQZc6D9w3Oh3OFk8uHVP3TrnVNXrahzf
dSyJiE187XyjecT4kogPnA9UIrby/WqLmOuI2JBGbCP+TTxPfLce8bqIGFwa
8YX4HvF9vgXOf8jZXvGdsCFy3pDbrEX8WxbRWB4xW444Q80XcJWIP5I7kpr7
M28miAc6I66UwImneTvOm+uJNXVVibn7Tr3dxHvIfQSedJijBbYTDX/BLuPp
HN6OZK4X5EyBPyy79iXwwdye5O0Uel+h91bdWoSfzt0D9eIk+FPwIe6aiTVc
rbmGctXDEc698F0oOedJ4RrCv5F/s+wey28LvJ/zaGov0wxjLf5ukzO16Pda
zR6Fz4CvA39WWIs45qm9irvJdntuwN2fuffv4fyau6Zq/wTfAl9f5toT3K0E
e1A4VzOZLTwTzeYdd0fhP5h5tuIQV2txnm305HHZmqTth+ZBbqvw2+fUa3Lu
XuHZzxFfxOtwakwz3Yy39VVrk59uzhvReAPsJTk9FXuQvmE8DVB/IXd97eD+
zDVVe4y782BnU79N4PyEl5matWoHtFu9neZSj/s4r6lau2ayWv0oe1fkUbt7
p+5ZaQaTnA/n7rU0HsrNIS5pPEH+vsy7JI3Sqh6r1/qH9oK9LexF/4z+nbGa
d0P6tKs9qXdXHDvw/x9nw48s
          "]]}]}, 
      {RGBColor[0.35538000000000003`, 0.42860000000000004`, 0.61016], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVM9LVFEY/dJJ613fNI87/QGuy2jK0KC9P2ZCMMhoJWKaE6kRaS6yTSUu
0rSIaJMxKdbkRKDLp4t+KVbrgpYF7XXVqnM4d/H87tzv1/nO+a7NA2O9o3Vm
NoivHt9l/NnExfwBsz84VzJmW7h/mZgNNJhd8WZPmsyeI+Y97pqPKGYRd6vw
/Ws0Kxw1O4b7XeRNR2at+GYOmt3MmV1DzDZivuXNzkSqXcqiH/KfomY//B/h
t8NmX5BzNfwehh1H/x+HgA/u78jfxf0Uaox5nUdhK6jzFnVuoVcZv4uYoTNG
PnI/I+ZZnc60U5hxJtLMp4B5CPH7jAeePdh3GdVaRq8L+H03EgfERQzLieos
NGlOznsadgi97yBmONgScj/A1xULzyRiOkKP4+BpPODnTL9yqr+F2jdwvo/z
nJcm5Ja6dMTiipydBO6fqP0ANQuodQ/+PvjX4UsRs+bF2WzAXAb+nUbpRw2o
xW3kfs2Jj6JTbcazFrGvZIT/oVf/ESeM1IM1l/KqVwXmMnz1iF/w4o+8kUP6
2Ys9yDF7sH4LMNcQdwL2ohMn5IZ5vxFfRdwjr/O8115wH7g3aSIMl5zuPoX7
zUSW+9XlpBn390VeelG3vYCLmnFXeH4FfzHWzN2xOCW352CrYbe54+SU3G4E
jrk/5KXPaSbqwLfBmckNcfEtERO53w78T+eUyx3kbnI3iK8WeOPs1D8N75H9
uQfEdN5Jy+vk2Ytzcr+WaL9rsI+9dJxAn/VE8Ruwg166TUTKSwMP1JV93sBf
ctKKe9GTlf5tiG/D+S+wnYXtcTq3Z7VznH0Rud1O8xayes/Uei68S/Zjr9fh
7VCTSl5zct85M/eDtdIwP+M5B+sQN/+X7Ad+/gPcD7Qd
          "]], 
         PolygonBox[CompressedData["
1:eJwtk8tvjGEUxo8ZNXTG95l87R9QsXNtSRB/gE5nkiYkJZYNHepSl6R0UTZE
LOiNEtuhwtBuatnpwj36BxDsSOxZWfk9eWbx5jvnPbfnec739gyPHbmQi4hD
nPWca50RHwsRnzjnsogfWyIm1vnuLP4Zznvs+oaIV+WI48WIi9gfOiK+k1sn
/rZg/xv+Kfxh4i16n8S+wt1tYk2GXsbenUYsMfhPPmKIXhPM/0z9GucS+XVy
Jsl/Q/1gErFXcexb3DW6IqZLEe8Knnma/Hv48/T+S78R/EnqW/gn8K9j36D+
KPYiM3cy+yp+NW9O4ta/2f4T4ltTYxCW39ztT8xJ3MSpAt4mGjzOWaMa/gKY
vmy0JivEXoNnhXiefkvClxn7FPl3sXu7I/7R/yuc9mD3MuNX3pzEbSZz7Ut6
NEreiXYzSv9l+u9IrZ002Y7dn5i7NN4Ht/FOay9NDsPtIT2e0a9GTg3/fOZe
4nCf2BT+z4I1GiLe18YjPeaIb0tdLz0G4bsG39gUscqnBZ55chba/avUv8jM
VRyb2DPEH+Ws8Sj+rtS70P9QSay5ZmnmQNEz5Su/Qr9a4lkN7npS/0OqFebp
zJw0W//MCLEDibFqhw/Uq8tait9T7HFy7nR4Z9rdQLteHMW1r9v/jna4TH21
6F2Lw3P4Lpb9FnSntzJbMjbhl3biJHw3iR+j9mAbj/prF7OZY8IwlxmjsOoN
jGXegbDqjeitrJb9/0lzaf8fHimJfQ==
          "]], 
         PolygonBox[{{4320, 4319, 4533, 1642, 2893}, {4974, 1995, 4976, 4319, 
          4320}}]}]}, 
      {RGBColor[0.39294, 0.4418, 0.58808], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVM1LVHEUvc0486Z5M808fq9NUFBEm4I0JYL2Oo19gAshhEqdMQvUKKio
doVRak6gtSgtUqoZjUqX5SJd2MciaNGmRV/QH9C6RedwfovHvXPfvffce859
s71vpGs4YWYVPEk80zmzBwgc2GTWnjebgj+B2N6C2fUNZt2ILTizf4FZA/Z8
0Ww0ZXYBdhl5b5E/j/g3/L6E/NPwe9Nm9xP6PQ17Ki0/0aQ+bxCbjRSfgd0G
rD8Ypg0z/ML7LvgN5JxJa7YrqK2g7zu8qzr17se7y4gfCtWb+DWn2ThjFc9D
5O1HzynM+RG1Q3g/F6n2CezfpPblnj+KwhlGzhjyezaa7dqMXWCPJzXzZEo7
0N+CmS8ivwP4N1LqVUf8Q2w2gP6L6H8ir9pF9Bwqqu41eh/Mqtc1xF40aV/W
MreWEqevUD+IPi8jcVhOCm8Ne6wE8vdlhX0OfXYUxEcJmM9RU0XtM9hPsXhc
ht+R931QtxP5V5FfRmw9lmaPkVP3tZ3Y63egfakF+SDuCm6mMy9u72GXMSfN
xp1uhVxOwp9wqr8D+yUjfanliJPl3TV7fltgP2ekC7WlhtSFWNSNPFCbHqf4
OGoH/R3U4B8J9Z4a8ka4IzmroG49EC+8UfK6lNN9sw/7LUXihzxRh++BtGjL
Cr+E+3kUiR/ydBs1P5FzC3Y+EsZ7xBuRdKf+uwvSdU9B9807n0X8cKicBcSO
huJ/K3JuOuGO+v24P3kkT+SNed2hYvwuOefXjHSZi+W3Yt4B1K+S85x045wN
zxG5asEuZ504uZuTnqteU+7MGyYG+VvzN1Z3ukve8jE/M2+HO3P3p54/asx5
yRO1JN5MLB2agVsOpQPvtN8Jqx3xPqc5Tjp9S8TshV/yPr8z/i+Qh1bY/xIk
qYg=
          "]], PolygonBox[CompressedData["
1:eJwtk89vjGEQx6er7fLu7mvfvPZI4iKhPbQqIuGqXStImpAICdtqtZJ2iShB
XMj60WorqTigLUXtllA90gMOml6Kg6uoxB/g7ODzzezhSeZ5ZuY73+/MPJu7
Sp2DCTPby6nntIVmf9aYfV9r1hyY5bkv8v4padYbm53kLGJ/5oylzUa4r2JX
AbmFPcr5Xbufy5rd5v6LewLw42BtXG92pc5rbMJeiMz6G80u87ZC/AiYE+T+
xd9NbpXzr5bfnzKb3AAH4u8T8xj7Jf73CY+Zi72GYscazHbDv43zAy2d4F3D
Hk27FmmQFmmQlgL+jozZMhwuwaWbGjNwKxPzM+n5hzPOQfjSeBffC2JONXqO
cu+B9yXpb8/x5TPu09sZ4rfCYQU+RfxT+C8E3l9pbie2BEYl4TVvEt8eei9u
oGc7sXPk9JL7DYxp9L8i5ij+D+QsUHuA+3LS+3kArlez3gv1aEA2/uv4yryN
xz4zzUozuhP7zDV7zeQdtYYC781HacJ/mnOR/Afk9GF3hM5XmEeoNxh77Ye8
lbB34n+U8JkfTPmM5e8D/y3457PORT3YQa1mduJ1vWMKez7yWGmaSPtOia9m
OoP+cuD6i+vMWnJmraFzU88L1JtPu3bFVOBzora/x4gfxrcrdK7idyjlM9Ps
voI/BX4h4z5p2I+9LXCfYp4RWwRvqM4xu7CnI5+terSUdQzF9/BWwbeH/PEG
5yPuTYHPUjOtRj5T3aVZ2nti7732/Qn3s1nfBfVHu9ISuk8c8imP0V3193F/
U+ufMFVLf0C7rB430estOe+F+q9dFGfl6o9NkjsbOXdpkHb9AeXrzw/DrTXn
vVeP9RefRv53tOPa9f+WDpyT
          "]], 
         PolygonBox[{{4301, 4300, 2891, 1637, 4520}, {4524, 1638, 2892, 4300, 
          4301}}]}]}, 
      {RGBColor[
       0.43049999999999994`, 0.45499999999999996`, 0.5660000000000001], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVEtIVVEU3X2e93Xfe/UuR4cFDQrSqOgLVpalZgSCVgRhSr5hH51IUA1K
M781sGFp+fw8DcHfSCl1FCFoo6BRBAmNm9SglNZyHWhw2Pueu79rr312NzTW
3N1sZg9wtuCMBWY1eWbT0Ecjs4WY2XLaLAejnzBo2WS2EjdbhT4Bm4uQi/Bp
xv0s5ALOO9x/C+RD+4zTfU/S7IZTnPLtZt8h53H/Ana1+F6CXyf+D+FuGGfS
lKdvq9lj2DQ42d+EfIRY7bgrgl9lQnaHoFdB/wH9OPQZ2KzDfhz2ZTgj0M87
9cO+xtFfWQr+sK/DfRX6no8p7yXo72PqkXgsxoTJh3yzeny/gu+BArMvuGsL
lecXznP024W8vajtGmIupRVzBPaXkasaua5ANofCbi9ifEor/gxsauEzhzgd
iJHF+Qq9zQnbOY/z9W36Js4f06rzDXwLEXMKd7lItfz29bDvXKB/u3aYDQDP
nZDVecKB94XEC7ISuYoT6vkZ4pSmhDPxLklpDvehX3CqeQX5B53yHSyQP+M0
oZajCeHYijjHEsK3A3pRKCwnoJ9IqI4e6PtD+R5BLR1OHOqB3BdqJtlI2C/H
xZmToThD7qzF1Sd7GQ3EY+a4g/paUOfDtPiWDf73QFmC+H/j4hxznHWyOQN5
ymn+jaE4RdyIRYVTjnLIRsRtRfwmyHOeu6WQ63HZbHAmrblVJMT9Xr8XL30/
5BQ5zvpY02AkzpA7/ZHmyzlPRsKcfOlOCoN6p/2b9dxgbNbD+Ks+Hnsg77iP
xOtwKO5UALe+fO1zf774Sv/OpGJQ37BLiavk7C3/FmQgu/yMOKt7MWFEfLgP
3ItiyM9x5WbeYSdOTnhecy7kJ3ed3CD+5Cn5wDnuCRW3DrmmI3GDHOGcOW9i
RLw5P2L0xCkX94ycI/dO4+51pNjkEXed+8O+hiLP/VCz4sy4D3ybOKfbyPs2
0gzJ2asp4frUqXb2xr6o//G71u6EHXnR7WRPv4zHbSApSdzoy/lzjpwdd2gt
EHbkOPnAf2NO8af8u8IeWD//bcwFvuX+HeN79g+Mgd9x
          "]], 
         PolygonBox[CompressedData["
1:eJwtlEtIlWEQhsdLHvOc7Px8tQkKWhRRlFFa0MWy8mgEgtLKSskIgsrcRIts
kV28t6hlaXm8h+BtVZS6ylRyF7SKoKB1m1qU1vM2Z/HBzD8z79ze+bc23Khp
zDazKl4ub3eBWfMas+85ZiWFZk3o03z/m2+2uMFsf6HrrQQVIzcmzVrw/xwz
SyfMuoLZF+SWLLNO5Iq42VewegDftN6sjm+V6I+J78C/OzKryTMbJeYO+sPg
sffAbEWu5z3BdwZ7A/LZdWbVxH+knjT1dBFfTfww9mbiy/EZQZ4lfonaxrFP
Ue8c+gTydOSy+lki/gb9jWO/S45SsOeJeYv9DJjF1L59o9npHK+hE/wh4mew
rxD/nvgi7D/J9wmMPci9fFvOd8wefOfR/6BPoD9Hr6W+V/jXrqU/8F5Enk8+
8t3LTL/lOEYPenvCZ/WDbxeCz0izUo+p4D2qV83gIPUuJ70/zfQQ+rlMvjle
N7ELSa+/CnsJ9hTvJvN+jf188JpUm3ZUzjwGgve3ypvGNhZ5vlXqW6C+toTH
/u8J39Lgs0yjH0d+hn99nud4R+4p/FdijinsFP2+YTaz6JfQJ7H/jjmnruPf
lXCb8NXLseDY4lQRsc0Z/i2CcZhdXgzOFdnFvTp6eJTlmKPBOS1u3yJmW4HP
RLPRjlP4Xom7/y++DeI/nnBZ9fajPwjOdfnIdwcYH/K9x6f02of/cLZz9D6+
m+F8X67nrIp7zapNMYrdVei3pJvaiTwMxqT5jEcivzHZhbEFrDIwB2LOGXF1
LPhuVI961U60G3H+ZeQ3p9sTpyrjzllxVzkGsLdFzoVBMG5Tezpyrooj/ZFz
WFxWvt7Ib0a3o3qn0NuDz1433xH8BnWLQ7xTwW9Ut6od6V+xmIkXRyuC51Ru
9XQCvSnpty9O7GM+R4Pfomo4gnwgsz/9oy7jezJ4LtUrbl9L+q1oB1eR65K+
a82wjPn8AxKHwXM=
          "]]}]}, 
      {RGBColor[0.46806, 0.4682, 0.5439200000000001], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVElPlEEQLdYZZoaZ+fLNePGgaIgGosQFEEQWWYwGYmI8ACIxnlAIeOCg
AWSRYXNJPLgkEAGJSzAuB4MiXDQKQY13SfR/KBff8/XhS1fX9/pV1avqzrvY
c6Y73cxG8GXg6wibpWWapXyzJ75s+tqzze4C+BKYIawnsb+UZjYfMPsbNBuE
rwL4OeyPYS3FmU78/xY3O4H9IvxfE2YDEbNRYG97ZvW54hyH73BYfOtxcZKv
A/viqNlbxNwXQlzwbOLfLPDP8f8n7GFgUuBqRD6jnvzMecP0f9NhysHfhfUH
+FezVA9rqUEOdSi8Hf7HCZ0/C99KXPEP4twG7MuwaxH/N7AvwJkCbltMnEeA
6UNOI/BNeKqBtdQAX+J0+BiXFrTr4b8K/CPwlMMe9JVrYdKsH/4b4LkFnjZf
eTaAYxr7V8h3L3Q4D/8K8JPAPoX9B/YzX/pS5ysh5Ueb+S0EpCnrqQirhu0x
9W3Wac34rJ26DSPWKcT9BL4ypxtrvYd9L7Q7hzr6sP5y2haHpQ91KoiKvxBr
q6/+TiDP7rj4qTHrO50tLQ6FlRf1nvLkn8Q6hq8J9mfg+zz1qsyXbz0ojiFP
cziI9X5CdTSyj24+GJO9WnT92gldvuDsA2CP++oX+0Y+xiVng6/55JzW+fKx
Jwuwl2G/hl0UVS+q4FsLavbINepLk/mI4jA33pUBT7kxxwMhadwKjj1R5dWG
PPOiivswIS5yUtNqX72rxNoMXe9A9w8OR/xNT3euNkOxdiXV06PAD7hYjDmc
pZ6tmO4b+8L+LAH7Dl9vmvJgPruj4iIne9PsC5PCucpc+XvAuRrQeZ6dimjf
7iv+VlD3jDG/BxWXWM4t7ZYctzfVtZQpfUtjsktiypHzxt4XJFULa+Jccj5H
UPuFHJ1fdvd+2c0w/7M31PJ9QHlwVqvdfa/C2h0S946Q5oyzNQ7OmYRynnbz
/j+PNM0f8Ty35t6RGU93kvPAuZh17yH3c7569Ybz4PD9nv6zp8TsT6qGIqzX
I9Kfc5Ef0rvH94/3mzWSazQi7fKTqmM2U7jOuHrcFXfapOsNYq8W3N3fcved
ccci0qXF153hfF5zbxJrZr1N7k5wDv8BasrT+Q==
          "]], 
         PolygonBox[CompressedData["
1:eJwtk8tL1FEUx89kNuXMODP8dFVQGm4UCnpomflIxx4UQg/TTIlqUSnZwkVl
OaPOmNoDWkQLJTXpQVFtwh4a0UIjiPYF9X9Emz5fziwunHse3/s933Nu2dn+
o5dXmVkbZzUnFzV7FzZb4LQHZtmk2eE1ZitrzcqKzMo5X7GP4BsjtrXU7Mw6
sw+AzJOfoX4WoJYCs6aY16j2EPnD5HcVe+4COTVxs4clZsvEM/iGiOfI7yhw
zC1gHwNjOGT2Gz5Z8D8nzC6FnFOO/Bne+0XsJydNPI3v4BrH3ATWF/J7yW/D
N0lshff+EXtNr1Pc56KOPVhodo7cExF/T5gZ8DbEvZ8/cKoj9ibq/EP4nhBv
xdcD9hL1K9T34FuidgCMFrh3x7yfv/ieEruVdO3Ug3qpjrsWylHuZvTJgd9H
fHfENZE2F7hv595HzTBvLcI/RW4q4m9pZh3gfyJ+MeQaZKitxfcoz0e5ndzf
h71H9SqOit3njRT2roi/neVeBn5z4FxHubdgpwLXU/FW7OvoMQ9eM/zrqb/G
PU1sBl8589sWce7y3YRPU+D8Rrjvw65lRvcKvX/NPk39TH5/GsE7n/DZiPMY
sfGoc5Xmp6k/GfiuSvNJYlfAeIH9knOA2I+E9yPf/sB9immelfS3l/ts2DUe
hd900mepHdGunCLnm/nMtbv15M+FvWf1vpH3XhEfoOZBie+Q+GpGvdi5wHfl
OfWPya8q9re1U/orDYHvojAbse8kXWtpXIN240nXSjPYGXGO4ioNd3A/HnNs
zVN/ZSLpu64/qr86UOS78p37NPyqSv2vqKdK7IaYay0+2vX+Ip+lNKmDT0/C
42/JryA2VeJY6lGzGUn63xYf7V57fh6d/N8s/XUlXBvt4FXuzwL/Cx/hPIt9
I6+3NBzErij1WnEWd+247EVquslfH3f99EeGwLub9F3UjGvRYyLqueKg3dgT
+C7qjWW43M7nS99q8v8DQQil3Q==
          "]]}]}, 
      {RGBColor[0.50562, 0.4814, 0.5218400000000001], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVclOVFEQvTLYzevH6355dEQZm0EDauLIoCQYRXEHmkgYggsjQiI4gcaJ
ZsaoUVg4JKKCGnDDxo0oiVPUxD8wKiu/wGjisNJzPHfRqXp169ZwTtXtxKHj
+4+lGGOu45eKX2HcmHnIHseYwXQoacbMwWFDxJgjy4zZGhgzge9T6fIbDBnT
Ab0TZ+/C0qdhn4TPE5z1wv4+pvPtuDsC2yh+D+CzEwmTKYo75hvzDHdfxRSb
OXiXuVnDNeiD8FnA2Qv4FCLWIxx1OcrZlKEcKwLl74A9x+ZbBbkFvzvQE3Hl
pM68g7B/Qx0H0F8j5Dxyzaaof/aX56gX+iziuz1TtVREjRl3dXYY9dwLqZ9+
fH9NVf28z2/amWsUsT7CVg25OyK/bchfDf0L9GLPmBbbfxXsRZ7sJZDtsI8j
Vhn0Nk+YtEKucVTXLk91sJ6pLGFPnWcHM9Qb+/qbKkzZwwXguWe5MRchb+LO
W/BX4Khe6sQpNxAvLxG7CHXWwr8P/glHHI5C3wz7XtiT0CuII/Sr0Ivg8xA+
l6H3IsYni08BfGrgcxL2fYFqbYCsX64ZIn87MtXvADAuRJwZ2AZ88Za02P4I
qR/28hnyQ1gzUZ+q3jk/7I85ORvZyPEUdSyilwo7D5yLdXHxQn7OB8JnxhXn
sxbDSeCziPgTkF04G8bdlfAtwO85Yr4mPnHN4TmcV0bFEbli39wT1jDqajaa
cO+Kr7tvYprhRdt7cVw5e1FPXiAMO6EPBeq3GTFvZGlOOC/Enfjfhi0a1axx
X9krMWXMfl/6pohmnb21IN64r/jkqgb2HtzNRYylkGaGWCxBTqXpLDsq/YTF
gDySG9cT9tzL7yFxQ16m7fd69DQXyMYdIgesr9vW/jOsOEm7P+S3OZDOXZmx
cR4H6p84tHjilvgS21tpmgPWcT9NdbPmjfbtIjYJTz5VEXFALsZc8UcuzqCe
8qjegTLIAstfPmRdRDPViHvDgTAagVztKVcp5JCvveB+NNjZLkHvA4FmadpV
H79DmrnTFn/yTNxZby3wOeqLN75nd7M0032OcCJexI7Y8z0kbuVx7fnauPbv
j90F3uHdUr57rnDJieqcfuy5MlBfdXa/ue//dzukb+pnXXHTBpx+hfWu0s4Z
4f8E56TbFQdZUb3RrG3Y114yF+vJd/QWtMa0m3w3ySHffea95Cs2cyzY/wHW
z/p67VvHN+8f+3veLQ==
          "]], PolygonBox[CompressedData["
1:eJwtlElL1WEUxl/T1O693nv//L1hmVNqodXCIocUjIpsUWAuQi1aBA6R2mBG
k3odoyJ0USZZaUW2cVGbBovAVOgbRMOqTxAFZav6PZy7eOGc9zxnfM77Fpw4
3dC1yjnXyEnhbIs59zPNuU/IW5FPhpwbRh/iZPvOfch07k+6c4+wD3jOtWGP
Y/uc7FxeGD3g3GNsK2AWwS5z/iK/WY3dtzvZXqNvQF9K6PIZJV4e/ovoe4jX
hVzGiYOtR+9FXofPIPlmwLei16N3Jzn3grvDyNc9i6V8N5CHPatV+UaQC/Hp
Qf5KvI3Ueyxq+jf0zej9nsV+xV0ceb1vvUt/B7YavY18R9bgz3ye0/9Kms1s
BtulkNlawB8E/8w32y18ZpGveVaLelbv6kH5fqMvoLejP3E2M80uB30O/Rw+
tzMNI+xL9CzizZHvVyL/tGbjWa3iSFy9j1q+2lTqDTo3wd0Stjr0XrCd+E9C
/Bf6z6f/hajNrh57OfiisM1KGGHXRkzWXRX25rAtjjgSV2fATKXYPDdha8gw
7r5R3yD1XfAsvjjqQX4btV4OkG9H0DgW/jgzLI3ZDmgXHuBf5RsH6q8GfB74
KfoZZ4HrwNxHzqS+iRSbYYj8+zhPsc9xV4rtpme9fWQGk+Cvou9PNU6XiV2Y
6Fc7od0YoZ8x/L9z10j+u5lWqzjLD9jOqNeHxO8DO8OZBf+PuwHw1dTYmWQz
ySJ/dsSwuqvBVhKx2tSzZlWbYbZRYuxG7vBsPtPkO4V8KGq7pTent5cbtrfX
zV1uwHpSb+KzAFtRzN7GPP6FyDnc9RK7lRxl5N8etF1QDnGx0zfbPXzKkceI
N59uOZV7l2+z6CPGRfIP+cater6MvCVm3Gnm/egtAatdMcaJ1cTdj2TjbDRk
nIpbcXCF/o5GLbb+gDvgi2PGrTgYBt8ctV7Vg3qZDlkuxYz79uZUq3Zcu14Z
tFloZ7W72nHp2pEOfM979jb0x+mvO+vZbumPaUcvj9jb1Y5XIDeFjVu9Ob29
krBxJc7EdaVvb1V/UgVycWI/tE/6e/aGjQvVrN0siNms9cbzkf8Da7C9qQ==

          "]]}]}, 
      {RGBColor[0.54318, 0.49460000000000004`, 0.49976], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVVtLVFEUXjnq6MyZM3M6Z6IyHU0LjOxuab50w7dALemmBIGO10y6PKhR
FhU9aFfooaiQ3rpRIAVJURH00ltaED34B/IfRN/Xt6OHzdpn77XX+ta3Lqfq
2FDb8QIzu48Vw7oXN5vHZgyHK5NmHYvM3mbM1mbNjpaa1UHuKDa7DL0B6FyF
vILVCb0HodkrnD3xzBqg86bErA/fnyLp9CTMsli9RWYtsLkC+pdw/hH37bC9
E35Hob85ZdaI/SbIKodhGvpB2qwJ5/Up2d5eLPtlsNMP2evJFm3m4afIF8ab
kfBecpgnsRZg5zzsTuKuB9/5wGyPr/PdkMPA+M3hIa4PJeKEi/w8BldN8D9T
It83Iu2DhO5fwtcEOYStR9CtTggH/Z8MxBG5OoT7HGI8AiwziDF0+hnE2u+J
3yrENwv5y2HeF2q/E7r7sZ/GXXsovsjbEuxHsL7i/CLketjvwrs6947x0w7z
8BPfw/juLJX+Z/jOF8gOa2KoQJwT03Sh2e+YcDc47g/DzlhC7zZAzsXEHXmb
RZyvIZ8ijoOw3xwTJwMJ8VeW+M8v8fF+pEj4+jLydQAx3o6Ld75h7olni4u1
tVQ4K7K6p23mczvuDsHm9Uj7roRywDhW+arlAy6WpWnx0ASe2lLiphZna9Kq
B9bFOLj7ARwPEcuaUJhyWdmYKFKc5I954nvufzg+51wdMca9iKsX+2usu0BY
WYNljpM6+LoQygaxnIsLP/XIzYLLXzn0vmN/GPbaQp1dBLZnnrCQ+3nH979a
ZZ2yzviOOSZvI3Hh4f5dJL0TeHs7Us2XA1d5Ulw+z6gn7sYVT6Wv+hj0NBNY
25wD1Vnluyar3I652BtSqrUhT7XLWtwFeatQdvOuv8htl/NHvyvgv7FYHLDe
WkP1VwtkTVI+i5Grt5GrS+DP+YorD1+rffk9gf3WUPjrIYcCxcu4WXtTheKr
N5Ad2rvnqTdqEUtlWjo5yBcZYamA/wFPPJAP4vjLAc5zoeYe5x97tNnlrjKr
eVcFmYXOWdxFkKcD8XgGcluoWdwAmUqLD/Yxa4FxkRfyyLgi+L1TqL4gjv5A
fA0Eqm/2Eetw0OGs8TVrWAvLQ81WztjKpGqD+WAuvsRkl286Uqr1qVCSs4C2
F+N7lPnylEPGwrfrXI+wVyoSrkd94WJNM5cbnb9ylyvWIuNizxNzPqkZwzlP
rN2wMw6dZbB5PND5YKB3o+4t9anD3HR7whJC3/MVTwQuezzpDQf6Z7AvTmG/
OimdlK9ZwJlQi32Zrx7206px/kfI1/tIvohrudOhLmuO8bDXl4bSoS5nFbGS
iz+Uy+HN
          "]], PolygonBox[CompressedData["
1:eJwtlMlvjHEcxn9qGZ3OvDOvt2NtZ1qKVlSIrfRii6u1oWiIqK5UbYki9u1Q
S0gcrGncJBKkIYiIk4ubLREH/wD/gfg8eebwS7779/luv/q9A5sPVoQQ9vDG
8ZqiEH6NDeH4+BA68iEUq0LYMSaEboy64xDakhBGUyFch98M3YusZYJtnmNf
h/0u6D70h9H181aU9W/QH4Jvhd8J/xJ+emJa9jOgC7kQ7gLkMxjmEGs7eD6B
6yc5z6E/jv8q/Dvw+YD/rCrT/fiPxzYb2fcq9r2ZEI7Gji1MM7Hdh2xTJZiw
WZwN4QQxv2Dbgew+uoa0a1cPGon1ANnXlG1k+zhjLOKH4FdgP4z9NuwvQi/A
Z5h8I9RQRy1HYmNT/nrybwRzD/aDyFrIXyTGFWJd4/UR+0IZz1nsz0PniHGb
WD+Ivwj/ueQYwn89/BHoZvI9Dc6p3DXIBtF/Qz8d/kLGs/oDv4V4g+DprXDP
S8TbkNj3BTk3QTcU6HmlZdIdyhir+jEVLAvx+T7WmIStGpvTKctqIs9Ysz6H
bCq6KbwzKe9AH7lr8G9HfxLZpMQ+8hVmYW8s7596VEh7hpqleqRercP/N/r7
8MsT74DmL30JvpZ3OeUdOUa+7rR1ilGHbkfevXxIz4rouniXUvaRb8LrqnBN
BeimnGfxF5950Gsj05qBZjE58S7JZz9YNybupTAKa0tirKfQt5P7fd67oJw1
iW9As1gJ3oPg7cLnH76j9Hdpzjul3drNTOYzmwOxbd9ODCGPrjPjXg7xYuKV
sLmT8k4UoRemfT+K2UuukcTxXoPnGb5L4e+V56fZLoE/WWHZMuhi5F71ICtF
xiRsirGL/Z2N7EnwjsyBro5MS5ZAr4m8e7oh3VID/EBZPxP6RrVjr8TmJnQt
eD9S22r4A9BNBd+majiVdo2qVTesW24uuDeviPEocY/Va8W4Q7x69G2Vrkm1
HS7/B+/Q30LfFftv007WUn91zv+HMPZnvDPaHcky4F2b9e3pD9yKLp9zLa3I
YuhmZJ1jPIMF0FHOtyhZFnpJ1rb64/TX1Se+fe1wQ5VrVu3CXAf2OG2s+jMH
Ys9cs9ef2wM/LfGt6aa7M/4ThE83PAv/zrR7qxvULbZH7pX6qb+1lPNfJR/V
9h/7Tau2
          "]]}]}, 
      {RGBColor[0.58074, 0.5078, 0.47768000000000005`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VU1sVFUUPs7fm7438+a9uR0XpJY2FiOhNGiFskDTwEpN1JRpbGgp0sCg
NbRNTYyDWBPdgDWRAjWSWBdVVybEMmy6cI+wAYSEnewFLKXd8318l8XknDn3
u9859/y97onpoamMmS3jl8VvLjA7jd/IC2YHymazkFsrZl86s98A/KVk9ivk
Q4BXgb+Vmn1VMLsNOZ03uwt7E+dbYrMlnHeE4IV+DfYMZD84Gzg/Bp69sB3L
CJcAtwB5MpWNeMbQ4Xna4f9v2P4qml3A/8uJ2Z/wdxD4D8H1Xc4sV9H5WwVh
ToHnflZv6Iul74Sch/1fb38V/38Htgf+Z/LCnPLxMc4UfscQ8/fA7gb/LPy9
Cf6uyKw7kq/PYNtdEP4HUz6YK95ZRzx7Cor1U3CehL0TnPeQ4/ezwu0F/z7o
HySKi/4Z26THlxHjBM6a4DgKuQN8K9DPwdfr4LoErn6nHDBHfHtvLK6PgF9o
V8yM/RXEPA7uGt5SbzMb9PXKx7r7Ms4T6GyK9xL5v5HVnW3+bhvu1pz6xEG2
xcIUIRt56c/fScl3HEmU92HIVl7xnDflb9PX9DD4xgP1wZZQ/TQC/P9VnT2C
fFKUTsxj/D8CfQ1yoyidnJuQcwXlnz32eaCeipz0EPJOKsw/kCne1Qd9DPqA
r8UeyOMZ3Wf//ez7vom7D+FvFDwPIP+rquZHQ/lgTohn/x7yc8SZ+CIQ32ZV
b50IxTEWqI6xE6bMvDr1EGeL56w3MQOQq0XpVdRgEfV2kFWn/uuI1BcDHr/q
e4/6dKrcpPBbicQ5Atthb1+vKvfMA3PrUMubiLs9Vu+Sn+/8JNU553Uw1h6o
g+/jVH47I9WHdWIs9L/uYy4j1vOIOYa86vtgPFUeiKGfoVR+mNchvKuFs2HI
J77WrPlaWTlkLl+K5ONEqnP2wRXwdFU0y5x7co/6PP+RU8ys5eWSemXZqeaX
ctoFK4lin0xVb2KXgA0r6m32O+eHs/BGWTVn7Vnrs5i1Ffg7A1nB3SbOEv+O
q4F2JueecZC3F2eLrDFkPa+7fP9BJ/y3Jdkbnv96VjPGufqmpJnajxg2qson
88p++zHQXHO+F73O/cWZOIGcNUra9S86zeS858v4Xf1uov6lb/rtieS7G/hC
LD2A7HPytdNpX3BvRL4vuK/4Xu5Qxn8c/FOp6tNK1L/sMd6hvJiTzjNiZjib
FdmTinI473cj88rZ5EzR1vK5XfJzuj/WXhz0+5R9d9fj2ePkX/Dfp2ffqVh1
+TqvnVwL1Qv8PryTqL5vJ3oHc8IanQ51Z3sN8+p3+pzTPuNeYz24g38KFMNk
Iv5doeLi94b2utOb+L3trGkvb4V8zenuLsin51PvNg==
          "]], 
         PolygonBox[CompressedData["
1:eJwtlMtvVHUUxw9tZ+4wtzP33rkdjeCDBjUobyrgQgyyUxdKO6aNliKNlJdt
CSbGasGFGx9EQxUjRk0UXRmBAi5Y+Fj62BiRxJ3+AaKNlD2fL18Wv+Sc3znn
e96nf3x6cKorIiZ5PbyHGhFjSyL0uRk6aUb80h1xHOFIb8S3ecSFSsSj1Yj+
NGKav4+RPYLOw+ivRf9v6MPoLK9HnEf/PPQ69Av062XEywm66GxE/3HkL3T5
L0XWQecqsq/BXJVF3AHeFfhpMJaBd3tmf7/xtwrd9anlc/w1kA0Sz7Ng/cRf
N7Y5mDPwe/HRCz0Oxvvkeb0W8WNfxN3YbyW2efDnieVO+M3w5+DP5q6BavEB
+AX4Q+CPgvcc72or4uncuX8FZhvsEh+zyI7xJtAdyR37DBjD0BvQeR3+KWxm
oQ8Xrs8i8fxAPFfgj+H/OvZnsG+hM1FxD6rk01+angTvEPIaf792W0e6OxvG
/hP7o+h+URrrOD0dbTgn5bYFH3eRa545N9WzBGuY92WXYzyI7iTxnAjHOAXd
B96n4Rzb0FPEcOpW/7eCfw94R5Z4BlZA/47N0ar9L4DXwOaVxD1TbzdhM4Js
Ap8D0P9S012J+3EO/T28mYpnYjv6R8jxUvhvHNneXtuqZ63SM6fZ247+i9B9
TeemmdGsNpqunWb8fvL/nppfqznHA8Q6VLg+78EPQveg/zP2b2M/jP2DpXv5
ITGug17PexX+I/iN0HPgfVezTQXb1fydTBzPNvLbUFr3L/g1yAfgTyXGENba
0tiqj2b7s173QzWcLT3zyuck8bSo7wA16FQ885r90cK7NgbfgR8rvK9z5LNL
s1V6NoT5GvSWhnun+mi30qbnXfW5L/WOale1Q1npHJSLYt5UusbiO0vZpXbE
N/hcTDzDmuUR3uqqd0a7s6fu2s5To7eo1bu8SzXv4H503+yzTDkpt5cK3xrV
VLXdV3h2ZSNb7ZT6oRqvIZ6i7ly3oXMC+YrUtGqg2/Vk7tugm/NE7hugWyD5
IrNXzXzrtGP3pt5J7aYwpwvfQMnVX81GM/Pt0X1ZDl9m7o1qmMPfVvoWaMY1
6ytT2wpDvhbwuTvxfulW3uxZ4h34D9nSzL3Qjtcz3zD50g41of9vOTZhXIP+
p+XbpBk+k3uHtEvqQYbv53PP3jtg7IZ+BowLiXe2A3351v1RDz8vnZP8aeeX
Qb9BfBcT2wwif6zpfdTfUOmbrdutG6RbpJ3X7gvzD7B3oH+6yzay3dFwLOK1
2w+0bSudT/DVk3n3dLMXdF/anjX1XLu4LzW+5lm362DhfLXT2u0b9aLSNw==

          "]]}]}, 
      {RGBColor[0.6183000000000001, 0.521, 0.4556], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VU2MFFUQLnZmp4fp6e7X/cYYvHlQZnUSYElYEyUYiIkC+z/sDCDCjnvQ
BFfdqGuCwA1FDJhoYkIIySaeOMAGPGlM5MRFSYANePRiUAPuioQTB79vv+fh
5VW/rqpX9dVX9Z7uvTsx22dm32GVsAYSs0EITez3sH+Bn8fXmD1XMbtSNZvA
97rU7Bx0E2/2StB5Hzrz2JfwPQP5+4bZetiM52Y/NGTfgTxRNxuD3mZn1oKf
C/CzEX7e6Te7WtV3D/+vwU8Hfpqw2xuZjeKsAv2v8b+omWWQr0Mnxf5EbPYj
5EeF2Z9YXej/VcjPfKRYb8L/DazbkJvQPwjfT2ZmK4lsy5CriOND6K/FfgTr
NuRj2DcghkOQJ+GvjTUNeQT2v1Xllz4nkdc4/nWRY7sunF6H/G8h2weFMOD5
bthWkMMi7D8FNqlXnHUfMIPOLugsePm+BT8nobcJcU7DbiIXLpPYL0WqAfFf
6FPM12BTg14Hsb0AnH/H3Ruhsz7R/S3YDkN/qCSMiE+vX5ivYob4v4KfAdz/
B2w7kO8WoSbMvU93kR/kxovwuw3yS9jnaopnO+QDubB7A/ss/L8Z7loHncP4
biO2QaxhnI/jzqk+cY813h4rp1+das/cd+I78+LFpkRc+yCS3xa+u9j3wc+p
svzQ39m6Yh1LxM9vInGsmSn2diwefVkWJ36GfKYsX6zDQEX1Ilf4fwv81DLp
rMUeZ7I9gHtKqbhNjpODxJxYnXeKPcFdi07+/i6U17MV1fqyU01WcH7R6exe
obzpk/bkxuWq4vKxOPgYd+axbOmDmBCPmfCPOkWs/iJXiGkayx/jGs0Vwwj2
PbnybWMvA+c56JfI/5o49QvOt6Wq+9tO/KEOObPBC9vN2COvulSwn2qoZ5ZD
n/Uife+ph16Cz58a6qke7vm8oT7bj/Nu4ESEOwe9ctqaqEeHQp77cvF5by5+
Em/ygzxgDR8m6iv2lyN3gs8yfJZQu5Oo3VRdsZE3///jzvuficWJGGdZrNqx
huQXbVfnUeAG58oMeY51Gucu1OVb6B/14ts44pnKNQs4Fz/uV23ISfYQOUp5
CHrvQZ5FDEu5ZteKUx69kGNWU9++6oQFMWF/vZxqJk/j/H4iPInrU7XQf6n6
hz5qXjWZDnVpefVqB7ZbU/UOe4i4E//nw1xcCO9C7JXva058Zy8z97FcfOU7
sDvX+YmG6kO9VXzCDPeZOLUYKe6DTrgccrKhLecE5yW5yr7hbGNdWOOmF3ac
QzudarDL6Z1gfarMN/CTPB11wrbA+VtOuTBX5jES4uebw97jXT2nmTYX5tZS
qNM/TvP/gRNexK3rxGliSe4fCb3DHmL9WMebud4/9vVnDc1I1oi9OuKFw7DX
DCY32LOMfT70Nd/hVnhLrgduLMPfcqEzvj/DYWYwF+bE3FjvSSc/H0HnE9xx
B37P1zVnec8OcPZ+oRmz+qYlqjPnZTNgz9nEt5qYk6sPC/GHfcw7xwKG5Mmd
8B5xbg2Et41cJVbM5T+1lvNL
          "]], PolygonBox[CompressedData["
1:eJwtlEto1FcUxm9mJjPJzPz/839Y0O66sCY1YFTQLgSLUqyPxLwnvk0UW0Gt
im0EtYKbKhUrKAiliBVXgq2oWxeu3FghKnbrpmrrI77X/j6+LC6cc88533l9
9342/v3AnkIIYQenxIlqIaxqCaGHyzVpCHOiELqLIYxWQvgvC+FSgg17VzmE
9djfcLcV2zz0Teg3sPdiH+PuHbY54G1BPw14rRHCe+7Gsd0E8xXYc/MQtmPf
0wom8nPsq9H7yf8C+TVnsOAcbxVbNbYwhPVjPYQJ7EvB6yC+SQ1fUMsaMC6q
Fs63YN/FnsQh5FXrd9Cr6OeJ/wesh5xDxPer57JruEBsqeFaR8jRxHeMu5PI
X3M3jvzzjBCutoWwlrseYkdT1678DXr/kDl+iLth4oeJ2U3+g5wtyBvxHyh4
pin+b5nJWfZwgnkVyT2IvWO6nj/x7697N9rJv2AvpOZzFc9wAfJI3bELsHeC
NUn87eAeD2NvBfOXkmv6hHzLOfta3NNv+C6L3Ntf+B+r+0hWzap9c+pda8fa
9ZecJrZR4ruIbQf/15LnOxvsVnJuw3YAjApyVnOsdvoC/4wd7C2YI+JKH3d/
FFzzIXa1NfGsLqN34bsT/XnRPt8h12Ln0k61a/WgXq6Sr5d83eAtxv4Depvm
Mz3/M+gT9HYf/4dgT3L3ALknd6xyLAW7I/IsNTPNboya5qOvw+dZ5p1r93oz
MfW/izwL7VC7nIq8e/WcY/8pN9eOoh9B7iX+87I5VAZ7SWQu30I/A7eGsHdi
v4ZeqZrT4pbuhlNzVNwQxtrUPvIVh/vQV2PfTm+nqKdAP1OJe73HeY08mvjt
/Y79U2JXom9rdcwq5A2pdyV+JtTfhs/1Nr+xEWz/Z/4bevF5jFzOvesH9DCT
fOtS/xWKUeybxLkfoV+hvwT/Cfybei+536T2KU5Vq8YQ1i70WejV3L6qsYYc
x37b2r/e9qLIXBKnFiO/zDwvvbGpzDvT7vSmBqitCMb+ijkirrSAd1tvG7wG
eCuod7xgnxK+7bm5JE6L25vq/ttUQ4PYV5lnpZnp72qPzQe9iSr8uZd6/uK3
3mZ3bm7rDc/PvXPtXhwVVztzc1VvdJnmH5tbwhT2UM1cEue/Qj9OfF/BHD0h
/iSenf7IwcQcEBfkU0SuxP7bhFmOvUPtsknOp8hPMsuaiWaTN9yrZpwh/z39
v6inu8hRbi5ppzHyN4lnqRlqlh8B+gK7DA==
          "]]}]}, 
      {RGBColor[0.6558599999999999, 0.5342, 0.43352], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lUtoXVUUhndzm9ybe++5OY9cm0IdqIlpfdCCKKXkoVa0mjRtTRNpbDBN
RJRCHVRsIaLWIg40DhQV7ESqqBHUiYio4Kgd2EeqLYh1bH2maVV8FdHv598O
Dnudddb+1+Nfa50rph++e09LCOEjnhLPc50hjKGYzkJYTEL4BGVeC6HcEcLc
8hB21ENoRd6yLITVfL8jDWFXawibOK8qsCmHcHkzhFHed6PfztnVCOEQ2G18
r3F3AcxeMJehn0P/XR7CDSXjv8T749z7qeSYPuU8iP5mYhrD9wz4v2P/YGq7
hzjr1RAmkPuRr02MdQ3nK+RwBP1X6BvYTCHfjnyc+x9j8zM2TWIdag/hsqZ9
KN+D+B1qsc2d5PkH9vfj90/OYfRrS457oOE4R8llCv1R5HHs+7Dt53kSm6UK
uMhPyZ5zkOdAsO6WqD+T2+ckMZ7KbbfAuYqY5tHvRr81870y8mLFPoR/vmJ7
fas2XL8Cmy9z+/iC81fy/IzYfuMsdViWrlkzj+JzLe83oW+Bo1vR72wLYQ3y
YMM8bEbup/7rwfw8N3/iMed7UTNPS2DM4nsEeSvy+cT6Xmo+yN0N1OgYd8d5
34/8Ir32F/Yr8NVPfh1gTaCfxHa8bA5Uf/EvXsTPBHbvwOMbqTlXDLpzY+q+
Vf+qH8WTOPo+N9Y5zjWJbcbB70t9byfyexVzLX97y+ZSPF6ZOGbFrh4R78I9
nTuG18HYTDw9xP8Mfrcgv43+NfQ9qeO9jbv7qN1pcPdzjmEzj83h1P0yHH3J
/4aYr3pNHClWzZNqpT4QP4pNs7Qu8b0SmGeIf5YYDvPta+GCf5bzH2q7Cv1G
fO4t/P0Q8YwgT6J/Ff1F8B9D/pBvywvXTjP9N3e70A9gcwl5JfIg8nVxvtan
nqejMaZGzXVQPUZbncsTxLlMmNonde+DXTH+cuFatxbub+XXVXWNhyJ3slXO
sj+beEY0K61Vc/Z0p/tJvgbAT4nhemK4lxhO5p6RE7lrr55U/tJpft4ilo6q
/WgPjWeexQq6mbp9K3bxo5qo1qqRavUs8sXU51Lccy+AO8P7qcw2C5l5m4v6
1YVtHq273+Vf9Xm307i/gHN17Bn1TmeczTdVZ7DWcee+uM/EnWbyg4rzVV00
H3qXvK9u35qzqdjTqmG16v2gPaE6b2p3rY9V3DPC1E5Sz6gW2m36Jr32gXzP
xx2kfbOdeC7EGDQP2g3KTXlpBjQL2zJjH4n4D9Rct8XU3O6J8zYda76C2LrB
eL9inHNxfn/MHZf8/M+Tzh2Ze1rcHs+8U5R7X+Jdq749EHtLsb8ceVE+es+a
rkPK2Vb1Th3JvL/V/3rXDIuXbxItV8f8L/FUCveFZlGzJF421nxPueuuanMh
8qK5GCt7xpXfaOwB/dPEr/gWH8pXfXky81yfyNyzPbFvfsiN0Rv3k3D0rm/d
sf7aa9pvlxLvGu2ce8BZWXUv6J+seqt31Z9F7I0G+uHMOEnN86n+aS/8P9H/
TFjf5s5lW93/H/2HlHMndbyLehZN9/7zsf+7C8uP1D2L2lniTPwITxzpfTbO
l3JVzqqhdowwNYv/AfzgBMs=
          "]], PolygonBox[CompressedData["
1:eJwtlFuIlHUYxt92dvbbnZlvdr5vZjTBLipztdNGUUjt7K5GYWm72robbi65
GmEEdqGkYHSyAyTbRVCBkdGBSi/qpiJU6CovSl3LoLLr6KibER20qN/DMxd/
eN//e3re48WbHrxza0dEbOd18t6qRYxeEHFNV8TGLKIP/nAhYhilxdCb+Bvv
sE6jHDGXWv5Bd8SeRkR3b8RzOPqYv3nIb8VmY5GHzS3Q59B/gTgz6CToTlTs
T/oF+L/yiHsT/12P/t3Euwos7+P/WfwPYL8T2Wbi3wR9LTpj+H8P+dPIW/CT
8JPoDED/U43Y3WmMdfCsrzj2dfBXYD8f+XTb39XIbybeQuItB8MKdCcrzkf6
V6L/Bj4PFK3zbyliaT1iQ5cx7UD3nsy1Uz16kG/gPUq+NyK/BPvXsN+P/QJ0
ziP7g3w3J65nk/iD2F+IrMXfMP7Op85FNVPtWsjnI1+GvIV8DX8jYDsAxr3w
Q5l9DyFfXvGfZD+j0yLXvl7zshnF9ilq9i5YVxHjSejBirEeRH40d01V20X4
XI3vleCfBv8MeHrB/xX8J/BHeN9AT1WMdxb7MrG+bstVoxXk923qWdqN/Sno
Huq3DawT5N8N3cG7odDuCb5exf6domtyjnivwL9ddA3+hj8Mvl+73ZOT4D0I
fwb+cfyvAe+LvP1hDC9B34H/j+CnsB+BPsbfLugvsenH32n87wHLw/ydQDab
mT4Lxn1110i1WtkTkTWZl7J9yb9yrTUt6yeHxeQ3VnbtVXPV/iLkM4kxLYTu
wufL4Rok0KdqruVn4NlLrGPkNJA4Z+Uun/K9ihhN7C9PPZuaUe3eUfC+3uEc
7iu754r/CPZbau65en8SnzuI90vqXmsGiuT/ae7Z0sxqduc1HWs1PnPo+2v2
pRoO4fsQGOewfQJ+gtj72v25jJpUib8O/oGic1yAv5/wP4H/28D3I/Sb7X3S
jtfQX5J6F7T/S6Fz/g4VvMPa5azq2dKOV/AX8EcKvjHVkm+OboluyJ/4n27v
o3ZsnHn6PbVc9dJup2XPtjAL+3/YbE08g/2pb5Zul/6Cei2rud7ax1LJO65d
1305k7pn6p1qPgi2BvItRWMW9kLds64d6qz7pum2KcfTqWdQs6ge7Sr5psq/
clAu6zPXWjWbhH6m4Vo/xl8X+usyz75uzDj0VMm7ph3RrtyVWaaeqXdrM++X
dka7M5LZl/5Gobfr/iWe2UvBu1b3OvHN1e39PvctUE9/gH4I+fOJez5W843W
bdXfEuyrVddON6IX+jd0PmzP61novN1f1Wy05psse2FYhH1f6tkRhu9y3zjd
ukHeCfg6M3p7j2dCs7Gz7lnXTmyr+6brtg/zvkD/89y0aqLbrJur26udO557
5jX78tmAns0dS/XRbZpr3wvdkOPU63+wNONT
          "]]}]}, 
      {RGBColor[0.69342, 0.5474, 0.41144000000000003`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lktsFlUYhk+LdOj8/7Qz0/8HY2QhIjVcqiRegF4opaLCQhQREQXFqDu5
KGhIRBNhQ5TEBYgUMIqoicW4UHRhiNFoIkGKBUTAlbpSJMGF3MX3yXtcTM6Z
M9/1/b7vPXPD8hUPPNsYQvhTzwg9h8sQunQwqxpCjw52XBPCGr0fLkIYGhnC
X3kI47IQJuvbo2kIo1tCGNZ+SiWEF9pCWN8Qwn36vqDZ+ugeiet22Z+gb/dI
Jq+HUEh3q85qsnNjm2Wel9/ntD+UhPCi1pv0rNX5Gp1365mufbdiWR1lbpad
W2RzoWxeVexPSmaVzhvj92E938nHe6NCuFcxvab9z5L7SLnsUS4t0r9buhXF
v0KySxttK9X5S5JdotgGpdsv3RkNxgV8ZiqG8dKfKzs/yd446fZq3ymZr5Xv
Isnc3+B4wYrzLZJ/VzKTpfuVbD7S5Nze0vsS7bdp7c0dwxPyE5TDMsnfpbNp
OpsuH+t13Kn3xTq/KL+dwvAP2e/S+q3WuTH+PaOcM7ntluxmxd/d4HWXntXY
kezr2q/S/nbZXCi587K5S36P6WxI8eyVzW7J9TRYdmeUZ49+l84/Thz/Jmot
/T69f1lzbuS4EtwqXo/Kz5uFz7cW1lkSZegb+qe91bEPNLtXOhPnDoZ7db6j
2TXh+44o8/87NaOP6En6jVptjvluzY3FVPkNLe6FNupcM16t2h9T/L30kure
UXHvjpHsndLdr/3ZzDWfk1jupN4/0fkprUcz43Uscy0eTFwPHuqAP3T7db4h
9iR+iZk8BmJe19c9P2O1nmmxn39T12efvm8Mrv8ziXuMfqF3yZe+4b0j83zS
eweUU3Nqn8uUe0+jazRTuhdK27i24v4dkP2VwTOETXoJX08lntUTuWt1XOvY
Js8RdpFdGWPAP/mj21d1/8wujNPsxP7nJcZzfoN7in5iNsiRb5xT8xmx5+ES
ZoaeGsyNZ1UxH4i8dDr3fIMp/XCiNE5LlXdjq3McUzGPYGNL4dkG+8vSOxXl
f81cY2L7O7MfbFK7s1qnxpzXNdkv3DIQ/WKruW6uqGi9GvugL/c8gPlj8vlq
6vmalnoW6U/68vHCtt+X/MXMPHJJ67nSeIxW/GtrrtEarb+X7rHfSmMHhszj
/sg/6FBTOIjZOZO5VvTCG4kxBYtzqbmtqpivyMYHsv+y7PfDRdKfrXVW5CX4
6Z3cfPCj/D5dMRYHFfvF1Bzzdu45pZep3Su12HOF80QGDrmQOt6dkj8fY+iU
zPaaeeFk7vmdmNgfM0089NgXpWf6YentK21vkfa3Ft5zBi/CTZsiB2AL3/Tp
kcgPl1LbJqcJbcalXeunpefgodR8BC8tUK6DI8z14DmpsAyyZd39N7oe+T7K
9MeZpjfonbNxfqkXuaM/XHpGmBVyJU5yO1i6/3t0/qH0rmuyHDnAveR5PDO2
YHyo9Hlv1fNAf57JPXN9ce7Gtzl3uG1S5j5ZLPnPYg9xR8Fh+MNXLeZFfuRB
jajpUGJ8wYU7Co5jRqgfMvTUBNmap2/tWv+Jvu7Q/vPSfQAfEysx9xTmwL1x
fke1un8nSm9kap+nte9rNkbgwzop9saswvj0as3iDDKLjRXzVH9hvmSm4IL2
umd3XeqHfUfqeOdGTptStb+muv8P4AK4pyV1rtwhtYrrurwwN7Onvtwf8Db8
vaHmvDbWzLP4h5P4PwFHMOyKd3p3bizBFP68Ld7Lv5SeY+aZngF7+hrdpNV5
wRlwxPyIX0+LZZgn/uOG438YPEwv9EaOnRb5oV439vyj8d/EXIMLGNMT4My9
hz6632SuA7PInQbO4Eb9sUnNjmSemWGtRd04gMf6eOdy9zL/zMIPslNNfc/w
b8h/DzjMyc1J2MFuR6zX98L8cup7bFtu7gb7E3Ge6Ae+dcX/MHCDm5ifIclc
ibq74//VYPxP+w+B7FTH
          "]], PolygonBox[CompressedData["
1:eJwtlUtsVGUUx09bhsHpTLlzO5eHgYW8SiggJIDQdoY+JoAtCxEqLymkgC5I
aEEoxoS6UDaEDQt5iLKAoCSAcSNs0BiMJjyL0xYQ2MGKAAku5FEe/v45d/Hl
nvOdc/7fed93Ors+3FpuZl2cYZxVKbPtfI++ZdYemT0KzPoSZl8MN/uk0mx1
2mwlBhcqzJIjze6FZiuSZn/Cv8mYFbNm49EtcteC7ktwdoN3YoRZb85sMnit
4LVxpkB3otONbhenrNqsBMZpsH5E/xW2A+C3IPuZu9vIFmGzHtt9YFbh60ec
bugj6PeA/zF4n6K/Gp0GdG9z9uJvd5nZP9Cjq8z6K/xNvf1lzt+aj04Dvtdy
NyHpPvTz3kz4WvhpnPP4UoRflPQYFMtxzkKwm7nrRz4v8Pz8hv17geegGOtP
gr+S9VyWuDuiXOL/Nvz/nlhXkO8G/HuAbR/yw8jXpRxbOVAuCtzVQS/gXIY/
BN5a8H6CX0r+FiKvh54OxgT8/5y7a/C9+LgLejQ1XFbmPv6HvA/7QfMaX4ee
Grn+X9zVQDdy9zb4J8nRa3wcynjtlWPl+lAcv3Sa0L2YdVvhXcp6TpXbOnSe
Ect6+K+Rn0K+AbqDuz3wT8D/lVpMA/+D2L9a6PH4sJx3d8JPVHzChC6gM4Rt
Ab4ePg//IuU9pF7axtmIfy3I8+Xu4yvkefgFqjX885T3uHr9OP6cI5+XQs+d
dPLYB8iXoHsG/7LQM/GpA9m3+LwJ+3TksRXByEReA9VCNaynlntybtuLfgL9
F6H3pmrwPPSYFbvycQu+E/9mk8uz3O1DlqZei9Ft5c02ZDvSngv18CTeeoZN
e8Jz9hR6IPBeV08cRv8AZw307+CN4f2bsVx3B7NeU9X2DHgDxJYP3L8D+JtW
7wU+24q5Cfpu/J5qdgd6LDvgOxZHAZ067Ksjn833wc1F3tPq7WPY/BJ6z6p3
1aPq1RDMxoTPnGZvMOO+aOY0eyMj3x3KQVXkOVAutHPug9WKTlvSfZoD1vJK
73XNfIH8P473l3r8K+L5N+OzKRvZ/hB47pXzHLYzOKUKj0mxaeY1+83EMAP9
hxmvpWbwCrItKY9dPToO/77Bv5543zSBVV7tvdgO/y62NfD7k64zGXpnzneX
cqBcKIfCk84U5M3gFeL+fclbs7Peq9oZs6BbsOlIuM+jiPdEHI92cDnv3wh9
9zRiPwhdGXmvaienoO9kfLdqp2m3aedo92gHbK/2HVWK+c/gawLf3Zrhx9i+
Tjm2fLwJPyry2mtmIujhkedO/5Q/kL8JPRfa4QZeX+izq5m+Dn019NnUTF8L
fcY0a4qxGPhMaDZU77nw07PeW/oH1EL/Hfpu0MyXQu959b5yqlqtJZ7N8f+h
Hvv/AbqB2L4=
          "]]}]}, 
      {RGBColor[0.7309800000000001, 0.5606, 0.38936], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVltsVFUUPTPTmTu9M3d6z50ZiCFR2pnpFEofJraE0oBteWSKCDQVrVab
kOKHUYgt1JgQ/TDxQ00wGmM1JsZEjcYIKiGND4wEDYg/KhRBSYwUjU2IHyQ+
UKCuxTofk7PvPvu59uNM447dQ7vixpjz+CXwuxIZ86BnzL84L+eM6YuBmTHm
QNKYxpQx+/B5MKnvZ0E/VjCmGQY6rDHHodMF3XTRmEtpY5ZA/k3IxTOy81Zo
TM7xJqG7APuH4TSJ+/nAmKfBuwbeOfw6If+rb8y7zs4e3MWcHcbVC3+LwH+y
IB3qjkHeh+/19QgZ52++7NDe64hxHr5mIDcJ+jvQO2LyzRjm4L8nJ5kh8BYC
5TeHnJpSype5d2aNmapDfpAdg53bcDcMO18FivFzyLeA/0ZCvv8E/wvQsQbg
aiW/E+eSjPRmgMmBhPKk/qAVzj7uV8blm343U6ZOeRxBzhuB8wPIrwz9teAN
IK6L8F2C/CbYaE1IfxV8DOJuAPRlxFLzpEscBz3lzrtR5FeLK+cCbKzA/W7Q
zbgvg9+G71OB6FbY64Dfo7i7At4vkXS3gL8cv6Wwewi81ZAZAf8+8KqecCEm
RyL1wMuhsGT+zP2mBtWkDbl/gxweRxxTeWP6wX8G/J3gnw7UO9dR4x8C6V4H
Dn85nBdDporaj+K+pSgsiEkW/Dvyqv806xAqb2KzNav4mccWR49D5pWs8O5F
rU2Deox92uNy/xv06pxs0jZjYmy3Q/eki/9rnO+HmpkLsP8UYv0W9B/kwUYt
qfp9HAmjT3HO4FcBfRfiP8yagh4GvRI62yHfjbMOtkuuLn34vh/8fpzdcdWe
db/XV+/8h7jWJnVHfimU3wXwZ0F/CfpMKPxon3mejdQn7DXqUX8X+M+DNwLf
7xjF8GpacfQEqh1ruAy49cF2EjE/DPmuhHq95vqM9EO+bCzGuS6UzDjoCfib
hs1HcW4LNatrQvUUY2D8PCnDeCYh1wSZpcB5vSdMiWeTw4Y97CHOCr7bY4qV
Pc27Y4HmNIU4zwbSPYezxdOeYi0rqOt+fFdx5iC3EXk1FJXLQbcDiffbac3b
EwXRVyF3rV7+v4fNYk47ZyhU37B/OEMXfM3ah8B7PKM+Z79vDjTzdwbChfi0
B5rNYkq5c//xmz5akH8KdBVnO371oNus8iWfuROH19LCYqogHLb7qv+xpPqY
fTTq8ppzsd1iVXPKsGY3e/LLGC5CpgMyz4WyS7/8LkEnAbrJqhakifnJtPzR
F3PiDmU/cL9yTuk3AL4bgF0WZ3tWe2M2cDvEU1345nBG6Iv3VcfnzJB/j6/e
YrwvWPVpys0Ma97sycYa12MT7NmM8nzJao9zJ434yoHx7ynofWOdOVfMl7NJ
bDO4L3vi8Q1hnsyReNe7/qMP+lqFXD6JtAv5Rp0A3Q3d3qzwJl6saZ/Vnpzm
3POtBP89yHzm3hhiw37kG8GYjgbKiW8ye5azyvw3ZLX3f4z0NrJfOdP7Cnpr
+ObcwMTtZ2JTcfhc9fX+9nMfWvXAacTT6Kl/iKdXFB7cN+VAe7UGnz9FemPO
40w77IlV2Wp3VKx24c9p5caeYm8RA+4P0uwx7j7ifDfs/+5rNrusdjxnhDua
uO53+S5yb/MA4nzE05s75vZB2WH7osvlFGRmI+2OMzjbXL8R44yrG3uMtumD
O26Z1Swtt5pF9irx/MfXTPK/CWeIu2/YzQ9z4qy3WmGxwmofjDmb/M/FncD3
kpgQD+4C9lTJ9dXevHjcE+xD9gz3YadVrLc626zNjT2Xl23uZtbwkvuPwV7p
crp8y4lJFOo/BHfnOpcXcyL+vKPMXvTLRF54823k/5F5h/9Hker1QaS8iDtz
+x9a+BpO
          "]], PolygonBox[CompressedData["
1:eJwtlX1o1WUUx5/dO3d3X37b797dWSCEc9vdfJlOcLM5QedrCxY1ajWyJCn/
iFJyblTYCwQRFRSFNSMIoSKptLe1LILEorJ/qrmpJQTOoGAIBc0sc32+fO8f
D5zznHO+5/U5T8OO3f27EiGEJzmVnCuZEA4nQ3gQ5kJNCG35ENJVIbxaHcLF
dAjPxiGsqPDdcmS5+hC2cF8PfxHbLPxm+E5A09BL0ElJF5sS9JVCCPenQvgB
H/XgL+OuuizfD/btYCxNGiOD/Z3wW9G/jnMG2zfQ6anw3Wn4TDaEBuwPzwvh
bWTN4FXCt6HTAL2Sk61yzC/FxhDWGD7ORehhvwPZduKdTzzX4u8Xcv0evCeg
Q9b+1iE/i/4gd3u5nkHnaDGEVmLcRqyvId9TF8LL+Hgd2xp8/obucs4Eun34
e1g8GB3Q9xHDXbkQbuFuF3ij6OwB72DR+g9h/13eOSm3I5x3oR8oWncdfB6+
F4yNCeczV+OclXsS+0boYeTP4+s5TnOde6ReFTndyN8p4y+Cz5LrPPLpSTsm
xaaclXsvOo3ojmIzjuw4/AHoFzhvlfkXoVdwSgnX+zz2LfBVYL9CzLPgbs65
/urfKXqxKW981TiB/7U1rqV8dEP/i82+4B7vI/eROtfmafSHoRdivwj9ZfDT
+DsZO5ZBdHrAmyjzX3ImoVvqXAv1vAS9Hvuh4J715B2TYuvlbMm5R+rVNuTr
Y8+wZlU5tUJv4O4OZM+AMUetfiWG9grX4Bj8P+DtxH4QvhvdvUX3RjEPFV1z
1X4redZQ+z8iv8UBMFfH9inf8tEDXY1OR8o1SUE/AsZqsN6kvo9CH+CcgP6d
eVij90X8rei3cI4SyxRnc8o1b4r9pvW29UYXk8+HyBci7yKHWXK5nDa23qTe
5oXYb0P1n4Hen3etNWOatRsiz7pmWLP8WcG+VZNPoR/jbj76u4n/P7BniHGk
0m/qK2ynYvdKOSiXjrzfknJQLpohzZLeeBOytdx1plyTr8Hvj71bhsjvJugc
9W0s7wfN+p+R34tqrFp/hE1DyjtoKXhdkW010/eS793c9cLfTPwLwJouuNfC
PA/9CaeE/UF8Ho9cM9VOMX2D7KeCZ0nzXYH9+wXP6jXcfVDwTtJbaYYfh78V
+0boJs7HBR/R2mHtee9IzZ90xpDdlrGtYlAsZznXp5zjqtg7R/3QjmphXqYi
73fVvJ3aJWpDeAr6GHdXZ91T9VZv7ETeO1y7XDs+gr4UWVc2fdhXYP9F0vUM
0OcK3lWq2Y3IH6eHh6rt8xS2/VnP5iHsS7XewdpdivlnbL/N27fmR7tTMcmf
3tAl5LX1fiuaec3+HDpHkp7pSeRXZR2P4lNu2pHalZrpJcRzJrK+/reV8KPl
fb0An5cz3onajZrRvzPOUVjC/Avbe7Kuzxj+B5jdAXRKSc+QZmlD3ljKWbm/
V3CvtVMXgzVdzlc7ULtwGJ2mhDFGoH+M/DZ0NxG5RqqVetgX+c/R36OYPwe7
qt6z14p+W85/tnJTjqrNeOzZXUVMO4ltLu1dLvlp8LZn3DvNSxN8V+xdpZqv
iV0j4al/mp3JyL60M0+qHnlj60/X374x9l+qP24TdGfsXab6zaL/P4xZAdI=

          "]]}]}, 
      {RGBColor[0.76854, 0.5738, 0.36728000000000005`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VltsVFUUPdPO9E7v3BnvvZ0aLdhpQ98PoEADbTCKhvqAEhjEFx9QEKM1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          "]], PolygonBox[CompressedData["
1:eJwtlXto1WUYx99zzs4529k5Z+d3dlak5GbbcpvOeZmow7KMtIuVzjKqP5q3
CANXNhO6/NOVWgWpZYMyQQhqWGlWzmpWEBpRaVJkEJLr5qo/CgZJrfX59j1/
vPA873P/vs/zvFPX9nZviocQ+jkVnEmFEPYnQmjn8jzok7kQpkNvQfYNdDEb
QjKNLmdbMYSeTAhPIBusDOGhEnZRCGvhX0iGMBO6v2D6LOcEus3cxVMhrEGn
CfpozrHk/wj0s/isxHdDLIQv0b+kOoRe6MfR2YF+Bn4p/Dz4q+Df5fTi7xg2
fbUhjBDvgZjv3pMcf63IpqE/BP0ZPqfEXMN2+DZ0kinn3Ao9A/9rkPehfy/8
JPg5yA+Q/9v4frJcT4a7H/B1ouD8boTfjn49ZwJ5DH4E+W/5EPYkjOEssNsW
WfcweJ2L/FVhimwd8V+BXk+8f9A/Tn5bqOck9rfzMLu5+wn9JPHmJ21TAf0a
NdRDv1wVwuq6EC7m7hbkGzkroe/kTXYSawo6vdDriT+X+N34v458NnP607aR
7RDnLeiD2DyF/mjebzON+L9C/02cPcja4G8mnzeI34DvenzsL/pN9DbSuR/7
W9FpR/dhahjHfiE1XpRwTMWO1YTwGLLLsRlD9iY+BpFPhW9DvipvPIbRGYYf
Redg2d+yrHtQvdhFXhH8tch3x90D10B/XXDv6I2+gn4m8tuKXwzWHZHf8kXy
3Uq+DZHfbgD+bvh9RdcWuDtNLXeVnFszOWyGPidyb6fRKRG/u2DsBzCpI/e+
kn31wF+A7nP4q0q7hzQbE1XGdx/+GuFfR96U8Ju2ZO1TvlOcHUX3gHpBPX0I
/qOcefXEH1XuUfXq/28I/XzRvaWYA9A7uZtN7TPg34cf5rSn3aMf5zxDmiVh
3k3+cXqqATpLPrXkclPGtrKR7QfY7Eq4x8aI/yPylxLuWfXuJ+jMR3dI/YPu
COdSfC3RDIL/PbXudb3Zp+CziBidcffAUWzPlN9bPRLoldPcrUp7B+wt2Kd8
d1NvBbEbc+63R9C/Al+h2tjeB/8n+VyY9SwI4wpqS1Q7F+V0KuceUC+ohg/h
/6KmXZXGWFgHbBZVuWbV/m/eseSjAl/HM95defzVUc8cTjZlH/L1dBl/3c1F
FnFyce+kz7FdCF+bMmbCboy7BcjOx/ZMyTtDu0MztDHjGdWsan4X47uZnJbF
vZO1mzVzmhVhKCw1M+KFkbASJsJGOz9G/gsix1IOXdClyLXUk8Mx/HXCt8Zd
w8/wleBxWZXf7Aj5bojc++rB27QLS+4dYRZD9xB3m1KeT+1qzaxmVz1WIp8N
5DBenvclNd5p2m3CQFhohjRL+kMaoa/E/tFyPU3Yf1t0LXrPpcimRf5rtONb
Is+wZlk7Wrt6JjmsSHr/tBeMobC8A/x7sL8+73wOEKOzxjtTu3Ml53vtO/p3
b9o1DUX+o7RvdHc1snmR/x7h9Qux3ynPp3bwZGo9XPTsCdMOfE/OedduJd7v
ec+8Zl9/Yh3y8aJz0x81vdo7WLtYb5AGqy8yfiv1VG1kH/KlGKPIZhc8K+qR
WdBnc65dGHQUXJNq04ytyHpG1dvCeAJfD5b81+tPXBd5J+uthNENyLur/bbC
oAt+MGvsJF+d95tKX/tFf93yrOOrP08VPYN6u+Xk00I+IWNab/odsmSdd6/+
nFZs/wMA+ggU
          "]], 
         PolygonBox[{{2571, 1368, 4154, 3575, 3576}, {3576, 3575, 4143, 1360, 
          2563}}]}]}, 
      {RGBColor[0.8060999999999999, 0.587, 0.34520000000000006`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV1tsVUUUnT5ue++597TnnN4WLRRFA0HEoi1QkCggICgoLyX6AUHQBBIV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          "]], 
         PolygonBox[CompressedData["
1:eJwtlltsVlUQhXdpS/vfyn9OTwu2VMQErYpFqdwkCkqJSMtdjTEB8ZaIiaAx
XILGGC8BE4UIiIBR8AFRE/VBg5RLgAgq9QpifAIx0SgUg7WFFtui38r6H3Yy
66zZs2dmz8w+wx9cMnfxgBDCZlYJKxuF0F0UQsTamw7hWD6Eg6Uh7IR7EtxW
GUJ1Od/ZdDgbQgP8LPhV8MXwW+MQbgM/An4b+VAuhGvRHY290/A3oj8H/mmd
B96CTrYshCvhfwKfQf929KeAyzMhXKoI4dNif5vGeSn8uwCXZ+1Gf8qgEPbh
eBv8fvjl2GsfGEIMvwx5N/ptBf9bkUs5fyz4YXBHilj4Noi9w9H/EXs18E3w
y+BP4Msh8G7wDvAi+FbwfPTnob8L+XXO6Cm1jSrO7wc3DbTOQnBLVQirU87Z
EXLXTTzPltj+19j/EP1a4q9j1aM/OrJvb2GzEXkHOnlsjQEP4LwifJhR6pyc
gjuXMrcWvB38eyF/0rkG/TpszMfeNvDlyN+y/x/kDlYevDNybpSjz5C/hz+P
3MWKwWsix64aWIs8nXhWpRyTYlvOt03BOVqB/BXnb8eXlcTYSDxd2BtHrhrx
aRz8uQrHXo/O38gj0G9AnkX8M9EfmPHdKwbFUly4L9XIYPjanGtJNTUUeTw2
Y/I9FP50EsLxtGtJOVPuNsa+W+E3kJ9hdaI/Fv97Oevzwv3qzq4DV7KnDv0M
+glynLWsnK1n79FCP9yD/iT0Kzj/L/BZcA/4IjE9V+L7KQEnefdDA/6NwtbY
rPlP4E8qvoxlfdPePPwEfBvH6iOeOWn3Ujv1swv8DXhokXUuga9Gf3LKNaRa
qlG/wU/iWwn3c1XW8kb2L0H/t7zvWneou1zBt63l9lG+FvPtVrj1fBvB3j3E
dzhYvxnu8cSc7rQTX+bh8xHy8zL8DPgnEp+1gD3n+RaqLE9ELkLuSdy7jeCL
yC2yAf8ne3aCOypcO6qhs5oH4KUF/CWx/ZpzbpUv5bIm416chg8PRd4j3VHk
40DsGpQ91dsw9t7PGS9y1hjO7864hlRLOqO9wjWv2r/A+gFbq8nJllL3+DHw
uzn3Whf33cf+NXn3ag78R9o9pd7qZH0HDmnXu+64Ht074IehOxWf3wOvy7s3
31F95X3nuvvxrEFZz0D1w0zi+YV4FsGvKXePVmKrJWtOM/h69teC4zLfZyW4
WTOowI8EDwHnytxTJeDHsLcWe93gKuwtBL9U7hwpV0+h/wr6U/F5JXwz8cwK
1nkAfgH8IvhHWb2xe1i9rBl/A/ZP8W02+BDx9+f8Bqh/5eM2uP7EsWpGzYZb
Vci3emo/eEiVbWvGDEaeEPntaGXPfeCPY89O1bxq/2Dsu9edVmNrf+ze05ln
0q5h1bJ6YG/kO9BdXEF8d4IHwN+S8gzQLPgvce3qWyWxfcC3dcXOoXIpH+SL
ZtDNkXtAvaCemUs9TYtsWzlQLqo1Twr512y7lHNulEPlchM66TKf8T5cb+JZ
pR5ZB74Lm8eDe+5u5L6832K9gf3IE7OetaqxL7C1Ie/a2sB9LcZWDf70ldoH
+fJR7NmpGaJZsiftt19vbAbd5xP3lmb0C8hR5NpWDaoWD2T99vazmniLk8i9
o5pSbb0WeVaqhlRL+9J+m/WPkYs8A9UbehPHZN2j6lW9wZfh+02Re0szSrNK
M1yzXDnaHHvmavbqzV8ae4ZolqiGVoD/TdzrmpmanZqhmqXq2Tdj97B6WW+C
3obplX4P7wU3I0/OWNbM1+yvK/inmaJZpZwqt5qZmp1H0+4lna/Z8WphPijn
P8ONzLiX9Obo7elOPAvVUxfgTsbuVfX8CeT/AUqKNcg=
          "]]}]}, 
      {RGBColor[0.84366, 0.6002, 0.32312], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV2lsFVUUni6vrzNv3nsz03m0UHbjjyIJoogmxg0wgiCyaWIkgsaYGBSD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          "]], PolygonBox[CompressedData["
1:eJwtlllslFUYhk9Lp+1MZ9qZ6V9K2USMJkWMGy7RaCKgSMTIZqKRCwRjYkSM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          "]]}]}, 
      {RGBColor[0.88122, 0.6134, 0.30104000000000003`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH1s1lcVx2/f+3te+rz0eda1nRtlLEKJszBC1AQi0vmSCJNiwZdEjcEs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          "]], PolygonBox[CompressedData["
1:eJwtlUts1GUUxT/svF/MTKeWabEyqAnURKEhBhcStUVhgdCprdGFGENi1Ihh
qUDjI74aEqkbJGi04obauDAx1p0vMNGYUjVGhUpbSqnBtlgoJqU+fsfTxc3c
+7/3nu++p/Lo09Xd14QQ9kMR6GIphJuSIRTg96RDuBX54UQIj0CzmRC21oXw
Ivpt6P/gdwtyN7/rkH/jtxX5QWw3I98NP4l/I983SQ/eC/kQDkVDOAMdToXQ
js0b6CPL+Ia+E/u9+CeQB9D35UK4i8B+jIUwjn4C/bXYt4B3Fv4l8A6DNQF9
iH0SmzZ8W0hqM0m0F411FqrCf4LP7+Afwf455DPIRfDWKz74HcRzIOkY16Bf
X3LuP4B3gvyfRO5F3og+ztsR3hiFH4c+4P1NyoFYK2BMYztWMrZiHod/tWjf
Lr69Aj+3PIS1yJ3Ik9gMI69AbkPuzYbwDvlPEPsQdBzsvfjMol9AXkAeRL8I
PwWdQz5dci+U0wj8Beh6+CfivJN2TIqtB/kO5AHeKJHbjfj/TPzz8k+6B6Po
v0F/C/oN6KfR35tyb8+j/xjbbSnnopqqtl3QvoQxhDUL3QA/wHs7wIsXXCvZ
yHYnNd2O/j6oTO2bsWmNOWbFfr7kWWtAnoIfoj71UdfopGpFD1rh14HfAtYC
9eivoebEvBH5WXz6EraR7aqsc1FOFfgy8VyNuqfqbWfRs6SajxFLBZ8tUeOt
gr+a9ywMQwvw+7G/GHUP/sb+BJjv1/hNva0ZUb/zxFcmng7q9Rj51ONfj+2n
OfdS/ZvEfw821aRr8Ayx5ZAblnnntHtt+G8InlHN6vxSvv/3CNvnoQeSnsGD
+C8W3XvVWLVeXeve6w29tbXWvZGPfF8n3jXKhZhX4n8K/EM1npEG9NPYHSC3
Jr5tT3mntdvaYe3yVxnX5jswvwa7sWAs+ch3JO1d7166Hf1F90Y1OQb/D/or
Me/En/T3rbx3+TZ8jsC/mTH2U9gMgl1f8O5on1fAn855livENwL/LfbL4U9y
QzrAu4KcQd5FPJfhowXfEu1wDH5K9UfXDl1H/9rTfkszrFn+jJxnor45LxNP
NeW3Hgf/V92qOvuqR3fCf1H0bGrmZrA9V/Is6yYOIs8hN8PfDB1NG1PY2vHP
0b+Hf23c81KH7u2iZ0k5/iK8pG+FYtoF1lzKtVqpmhW8o9pVYXbh21jnXati
0wB/e8azrRk6jr6ctu4evi0yn00Zv62ZPlp0zVS7ndpxsGcy5vUfof8K3Sjd
KtWwqeSbrdutndXudoDxfcw3/d2cb7Jus77dD/9R1vOmnPuQi1nPmnZAu6Ad
0a5oRrrR9+cdq27+sbxvmGrzL/oe9JGMee1gDH1v3rXRjB+E78l7dnQDfsL3
tSVZO/1lyjdCu7WPeC/n3GP1WjEq1gvgP5Twf97akm+w4tO35pJnTrOnmZvH
dirreuumrOatS3wbinhG/4IfBX/3Ev4p3r+U89vqz3DWN0P9kM0Yugo+5bh3
qD7vG61Z07cB8v8PtEQKDw==
          "]], 
         PolygonBox[{{3559, 3558, 4130, 1352, 2554}, {2562, 1358, 4139, 3558, 
          3559}}]}]}, 
      {RGBColor[0.903, 0.6275, 0.2993], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVVtoVFcUPc6MY+bOvXemNzcNiq9YSxKNFlHBRym2ttWfUmvRCi0KIoFq
oiYfaisBCYhG8EPEVlvaQkVjVdSPJJNKUaiJpXFSaCUiBrQSfCM+UIMlAddy
7eLH4ey7zz77sfY6+1as3rB0fcI514WVxHqOj1IIsyFXZpxrzUhfjb0Kq9T0
lCPIP2d1NpiQrtJsuqB/C3JxhHNTYPhr2rmp2I+YT97l4p1HsXOflemMOp5T
/gZ3UxaPOUzjORSTIf8HeQv2W4Fz3bg0c5Rzc33n1kE/qcS5Zzgbm3fug5Go
CbqvLTf6WwX7Kugf5BSLcej/Gb4d6kjCzwTcXQSbLtiew5oNm4eeczex96GW
DPbh15TPV6i1PZZ+kSc72t8JnXsdPs6a/axI8h+wb8T6Frq/fGFErFhXOer4
DsmMRh5rsPfibMgpF9ZIvzvgZxh+dmI/hVhbYLcC8hXIb+K8iLhXE8LgLlZD
VjU+jJVPU4n6uz7Q/gPs3wP+m5HDQuxzsOohv439TFp3aHfNU26dgfKZMUo9
OJ+V3Uzk8Aa+OyBXQv4TdodhHwLLi+aHONRk1EvWOz2j7++hv+/Jvgf3DsJn
AbrHyLkB5x1YG41n1caxp2n1sQx2tagBpm4ucp4O3d6kerkJtrVJ8boN8m8Z
2fXju4i121PdxHAooZiMQf8OvXmOGM2oZUFKPoiDn1d/JuJ8ICGs98DPdeQw
CX7KA3GC3KiD7npW9S+Dn3ReeaV85cC77BH7T9yIyQXLje9yCeopQP++Jy5Q
Jh8OeNqb8+oV66rLiNPE5ItIPvrN/2VPmBxHbu0Wi71i3ZfS4nXRbBmXmHWm
FXNFrPNm3O1FPftwdjIQTsSLvWJv2gzbOpN5Rj3jMdaCMvXjXeyBYUgse1Ka
OcSXvN5uvWuzntMP8203nvTaOyf2p+19ELd24wltOiwu7x/KimdPkNzfvnIk
X+YZz8n3VpsPnD9LU+LCh9YLvh2+IfZqwN4V5wnfL3lyPBJvyd9jkd4I30qY
1H3i2e2prv3A7YSnd7AdtQ9nxeOmSBy6aj1jvTX2RhqsDub9P6bEc3mkmcPZ
UxWJG+QLOc1eMvb8MuXJebMNNoOwKcD+Hegb4ecfX1g1GG7cG03+3dPbWol7
O3PCuhV+sL2csX0o/kZWeHUCz602Zzlj2RPONeZPHhWMS4zNHD6C7x9D9X3Y
F2cKhuc5i9uS13znjElAVwjVk8WQx8d6k92I/2WgWbkrp2/qfwr1dhmLvogF
+8FesofkD/tI7vcZ/y/mtJPvfEMtJYpXY++FmBy2HJhLuXG4wlcNrGXI19zn
nH6APHdFend8fy2GIbGsjsWxe7BvicQNcmQWvpuQ/9NQ8+O0Ycge1tnc+zxS
Dsxlov2nKvKaAW02B36J9C85Gklfb/wpjng1P8Yg1lrE6A+FS5DUf5A7sSJv
+d+utf9QvflmLgPZV5jxf0LMORvHwWc95Guhds5D/pMqjRulNnMu2Buj7x6b
rTzfav7Zz00livtxLPkSzu5kNN8Hc8oxsJ7yP0H+8F1MicVJcrPf/on/hsKS
fln/uFgxbxsG+yxPzm7m/CnufZJTnktymne0ORGIF/TPHrwAUyM6Bg==
          "]], 
         PolygonBox[CompressedData["
1:eJwtlGtoz2EUxw+bXf63zW+3XMamZJtbYmluuc8bucUUIaEwEy9mpYVFzFu5
NKHkPsYrGy/IPeO/QrywckmJvDCXjWmLz9f5v/j1O+c55znf77k9hWu3Lq7q
a2Zr+JL5puSYbUk3O9rHbDJyRWD2KsWsJslsb9SsM2ZWi2Mp9m8hszrOPiKn
811BnxgxG5dqVt7PbGimWYzvHHcHABJFvkS8vFTX89D/hs1+E/8X3y5sewLX
93HnKLHfgTec2MPQ3yMvCblcCYc36D+yzUbBdwzfWWLND3ksxVCsejBy+vjZ
bvQWYjYk7g+G62X0Q+hl8E3D92vIc1OOXcSfQQ2qid0N33ywCiLOXTEaibc8
8NqoBh/AP4DeC5bhk0K8Cu7UppnlEr8tAxzuj0/UpwD7KTCmJ7uPfMVJ3JRj
btRzlC68ZvR29E3JXpN2uM7jmwtcj/Cwn4fDTWwBPr39vSfqzW04TYBbD/Gz
iNWKfQF89mW6/SX2ZdgPcrYuyWPUI5eT/850n407/L9EHGsxByXwPRb1Xqne
6mVjop5jyO8z/o/Cjq3848RLjnht5HNQs4VPdZpjbuTuSM5u4B8H/yr+J8i3
1JzzSeTykHPVTGo2vyX6pZo+QP8U8V6ppkOyfabU+271BFsHZ0fwvwBuBbl1
85/Tz2f0MfgdYBahd+LfG/aeifsL9Pdhr7Hyf0L8RRk+M5qdw9y/hq0p6rLO
vhO7AX4bkjynEvEFv4jzYr7TxKuMea9Go59BX5jhsTVT17jbGnVu4jgIrKWB
c1HPmkK+k/Ldwf2ZOV4z1U41XQDWqsDnXzmtDpyj+GmGBkZ8xjRrW9Dz0Qsz
fTZrKNcfYt4PXFeN7yEXa4dSPKfN3F0PRn2ax1ftkhL91UzU4zsrx7mpZsXa
hcBrK0734P80sd/iFEdui/jbo5nT7FVTk+Po29GnobfEfPaEKeznEbdt45uK
/W3Mc1HM1yGfOfXvFpgPw/6miJt2dH/gNVft9YboLfmZ7W+JMIVdmNh39eAy
/mVg4PL/jZyEXBf4bCmfuyHnIC7yeaZdDxxbM1wF9srAa6WdXRH4jGhWtA/a
nRGcXcd/rGof9h3VrqremqXmxPulN/Ri4D2QTW/UdLBnyyfFe6Re1dHPHvOz
Iu1Chu+metSF/DKL/lPLzdyPw/cfuzPMNw==
          "]], 
         PolygonBox[{{3830, 1149, 3124, 3533, 3534}, {3534, 3533, 4123, 1349, 
          4124}}]}]}, 
      {RGBColor[0.909, 0.6425000000000001, 0.3179], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VVlsTVEU3e17fe279917X6+2KjGGStQYhKjpA+GP+kGMkUgUqRjSLyFp
JQ0JX4bG9GOqiOmvhkQMIURblVBjJGiFn4pKRSnWso6Pl7PfOXuvvffawx22
dvPi6lwzO4lfAr/hBWYfcdGQY3YpMkvlmY2OzT6lzZbg/Xxg9tXJFyH/gE4u
9CPIu6D3G3Z/fLMxkK+lzCbgfJox2wab2cXAAl5dQnotsGmE3BOaDcJ9LeTP
uN8M3XTSrAO4Q7LAwDkVGFOBdRuYD4F/D7826DbD/yHYVcC+BHrrILfgvs+E
R3/0dRq2MyD7Wf0oN+JuPGOG7jEPPrPC6Yb/mXnSWY+3j7AvBZaH8z38tiOG
pbCbmG92LqH4ymP5PAIcH7FXpxU/YyQPU0w5fcAdYO0BcG7xHnavcM5LKvcw
Kf5BlQ3IU770W1EszGk4K5OKh3FVuXyZQy44+gn93cAchTo25QjnKs4u2JzA
eSNHNS0zcZWfJ/vLkeR2+HgaCXtZkdmXpGypT+yx5BlvJYH4Hgifp3z52hTq
P++b8P4urbq+AF6QFachzrueMK6x7k6feM3Q74av/ZF4JJ8LId9xXN+NFQvz
YTwLi5QL+5T9xz5MAa8q0Psz4B0M1G8HAvUB5RLHA/Onj391SqrnyfnOAtVr
Nfy9Qc6rYvUSZdZoYFZ9y/4lR+SqDvIHXzL5a8uojjNRgOeR7D7hPRWodgs8
+alJyFdnoVk98LdDZ0ugu7HwW+jyZe3YL4yPb+1OZm9ML9bMzMB52tWiG3Ht
iVS/vZHyIz5zrI+EOQc6t9LqyfmwHedmlrPLuNi79NU/Kb7K3Jyw1/aHqhU5
5Fub60W+XfYU1yL4meywLri56HC7hXUl978yiq3DzcVw/N+K/52h+OM++t/D
/V0fMsY21/NngD8S8htPM8TZYA3O+LJhruzZ3pR21mPglwHzeT/sqUJh7oDu
rGLNXg3kuUXifQNiGJzVjLcGyoG51EJ+EGg3/EiLO3LYAuyXnvbRW9i2hort
Ne4qI9Wd9V8ZK9YW+GqGzhrIj0LF+Tul/twXiddzvjgY4XhocjuCMu2Jswx4
e2LZJjLav+z1Bvha7vbLili50fYb8quLxUkO9KsD1W5SLC7IyS9wYxnhcK+T
C3KyMdTM3XA7lvFw17A/WUPuONbxtqeZqYVteYFsqdPeT7m0ZjSrnNljgb4P
o1yOjGV2UnuJfcY6H/VUY/JJXk+E0jkeak+X5uuN++FwSr44e+yhJ/DTV6j7
s76+Geyf+5B7XH98x7muQL3I+Nkj5L3BzRLz5J4jnu92BeMtd7nzu8j+4reR
3zPuhy7EeyVQP/RG6iH20uNAPU4d9tD1UHvpoNNlP5CXm67HToHD87FyHIpc
/gLiwAlf
          "]], PolygonBox[CompressedData["
1:eJwtlVlIlWEQhkezU+ec/5yjf2oF2UIZZFTSYntdVNBdC0FFK4WVFUoZQTdd
aFAGdVOUYHmVlgQtELRCtFPYYtFuCGWJ3Si0kaX1vIwXH8z3z/bOvDPfP2JD
2dLSdDPbyMngtMTMRqeZDepndjY0+xY1m9HX7Fgfs4sJs4a42Q30AzH+l2V2
iW+56W4TzTR7mzLLQ/6KzRvkDuKdwXcX9u1Js2ucXHSVfLuO3Eb8sdhXcD9C
rK2cYuRv2D9GNzxwLLOwCYi/mJgx4cNmCfIrbPLBHUG/KNtsO/5P0PfjfgH9
E/xbwRcl3k6wfyHnTuQt+NxM+DfpyogzM8fsddR9hUFYNmPPZxvVH90As1Oh
+wpPHfJdzkTwFZJjWKbXqFob8O+k9knoS5CbwHSfXCvAuJdYg/F/Ab5N2Mex
b8O/CaxXevspDsRFNfeeNO/ZPe7NYBiDfzk4X2L/PHDfJDHmAPQ0OY5H6Dv3
A8R/Gjj2kZxX+G4jXxa6At3RtcedqwV8WwPWZfg0IRejnwLWE+RPJ/5yaq5B
PpxybjQDh5APcjoznIMS9LNyvJef8ZmW4z7y7QJTJfHn5jh29VS9TQtcN45+
/Eg5JmFTjap1YayXa3Jcxn475wq5azl7wL4ydOxt3Fu5jw19FrqJX4C8mvM+
4jV2EP9B3LnYTczJofdIvVINVcjPU87NLXweYluRcFtxJu7EgbjoQV8VekzF
/sB9HfdnCedeMzCKWs711q8enkdeG7qt5v12zGdaszSbk0Begf51xGf8Qsx3
QrbaqY/0rSXpu6gZySP++Zjb3sZnKr7dgc//XPLXYvso7jrVpNoKsbnGvQdM
E5DzMn12hXkocp/AaxMfP7H/m+W7fpWY9cSal+2yZmg+8j5i/Il4T+7GnCNx
JU7qkd/AYT69q0ZfHvcZ1Czq2zNyVSacO9WgWopC730R+HagGxe6LMzjQ++h
erle70PScyiXOF6F/nu274JmpI580xm00qjvmHZNM6nZ1LcZyI1Jj6WeviP/
r5TXLs7aselKuU45f6d8Z9VLcfSJ+DUx76V6rrdHnIt7vXmN3P8GPovSi5tk
pnOtN+ShuA2dX+24oT8T+jxo/+uRjyb8rdQbqbdSb4q40ptzB/3vqMdSviHE
3gWm/RHfYe2ydkS7ojehO8t3TPWJs/TAORE38vmC/mTSZ0dvVim5m3v/B5o3
vfWqSbn0ho7E/z9IAtrS
          "]]}]}, 
      {RGBColor[0.915, 0.6575, 0.3365], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VEtsjGEUvX1NZ+aff6b9ZzRSpai0NrQk1aWF11akCyQWmqhH6xWSLixE
vAXxinguSjUkEoRYmGJjoeLRtNpOq4iqPkIsiAVpcE7P18Xk3u/O/c4999z7
/bPqtq/alm1mh/HLwe98yOx7rllzltnphNkT2Nue2VPf7CoShuNmn6LyB+H3
J80qwmZdMbMe+MMAexOT7QTOJdwfQHwM5x7EzzhMYjcDczVqPgfOM2AeAOaB
wKwBdgnudiHvvK/4R+Sncf7huLV64jpeaFYfVi0c7S1qzMX5HWqOIqcfwbXA
XJbS/R2oNR/nNOLzYB8A/wLwB1B/Hc4DiI954lsOnCJgluFucR6wwaHdE69O
+I9D4tqBcxv8Tc5fEOi/hYF4UQtyG8LdDJw1iIfBcz3+ew0+74H1Dfe+4v/K
QFhVsE05qlVj6ol8qOcr5HXDzgYv3+EzPhIxW4Hcc+jpWlz3lqGvO1Fh7Ud8
BHodAX6Tp37Y10zgDLq7Z33NvyosnalfSZ7qfXA8yZd9FLs451Obq//ScfmP
YE8kNK+TsB0418GPoO/SlLidimsnqHUD/FL4U+G3+dKNPNlXPfKPgc8oOG71
pfPZhOoy/g85O33NYhF06wVOJeJD2IGWuHbpOmwmoV76YGcUmC2HPx32PvTZ
g7tHgfEZeZvBrRaxaIH4PHS7vws403CeE5PtQHw0rvgIbJmLv0S8GrGNOdp1
zq3C7VKjr/jlqLS5GJLO99xb+BmRHr57Ozc97e1xcO5NKr4xrhltd5h7w5ov
NeVOcZ+Jxb2IunfBWTGvxs2Ys+a+HHfvavJ9lCC/nHcLdXcX6te4XeQetcIv
ygcv2OyYtP8FjMvAPIycK7605C6wxoZAZ2r8KiLsLcjpCynOnKUp9bIENjsQ
h32e7IR+pnmyZ/bLGDVkfH+guqzfDl1K4MfhRwqkA983+ZFnFvkWSvNbnvRP
O3zuHGfNmd9NCL/R7RS/FXzXX5J6F5mYZjy5C/wW8J2+AGaH+/bxWzgeEjfW
nuznb6H2nnPgGz0YKO9QIL0vZmle3PFq139VnvriTLm//Ebx3XW7t8Pva21C
d3d7utsUFueJfQ9JZ86SNTJJzYB990a0T9yrxVO051PypcWNQH4L7O+EePxJ
SF/y8X3t9pj7/lSnxIFcVqbEIQP8/w4z5XY=
          "]], PolygonBox[CompressedData["
1:eJwtlElI1XEQx8eX2tv+vXw9JUuyEqpDpQXpsYMt1wiDFCISskXKosKDQQdN
K8hDi7TYIbIy6NACHbLlEpRFKZn4NCkKc6HoUF2KsD5f5h3+MPObme9s3/kv
qm3YvD9kZjV82XyjUbMLM8xqUfpmme3lK+C9IWy2LmX2MmY2kGXWiE9F0uwz
9ivIcwEpjpu9QN+KfxFvvchB4PJ28F6hv59jtgysS2AcAWsYfUnY394R/yth
9g/bKfQ68j2nnjbi/+aaHSdfGv8oWOPk68f/NhhP8C/iLYT9ADl60K/yNWEb
w7807D3swdYG/nd8O8C7gX0IvSjHbAR9En0QfR56Gn0MvYr8e4idT75CevkZ
8f40o8hss5O8NSEP4z+B/2TEa2/hrQPbeuIrzGc2Tb3Ngc/uGD7V9FeZ8tmq
JtU2nee9qIdu8LLiPg/NoJn+Fqa8PmEWI3fzVjDT5x+jnmv0WEl8Pf5XyN0X
eP0biFmAvTXpsxSmZt2O/xr8d+PfGfUaVaswurC90UzQR4nZRmwZ3yPkft6W
I0fizhXN4z65VvP2OGO/B/4K9J5cr+cg9vKky8rRG3MM+cpnJfKDwHtRTzfR
u/jyZzrHnmKrp6apkO9T3LwFxkVif1DD6YRzStw6oX0wy795vmvx4Si2CWIO
ZTvep6i/ySaMf/ieTfgsxKkzyB8Tvstv6B+QG2OO/RaMLeg1SeeOZvQa29p8
OJ/tNQ7GfSfqRz1cx3dxyn21wxLk/sC5pR1pV+KQuCROipvKoVx1cKQc/6mY
70L2NLbqpHNVmNqVOCVuCV9cHqCGpWG/Md3aYc0rK3ND9Ps15r2JwzuTfiOa
rWJG8E8TX5bhZyt4nYFzUfeci+0c+kZzjPPIb4jfke03cjXwG9R8hfEFvPaE
72oJ9tfcynDm/oTxGb0l6fMWP0PgD0XcdxdvdxLOUe1HHCxNOsfEn0bwN6W8
BtVSpRuilvHM/0kzLgHv4Sy3KcezqP+T1It60r9GPUnXPysB1uWo59aN6FYK
M/sShybR0xHPrZr2BX5z4rduYBX1/aG+shyfx13sfXH/d4kjQ3N8ppqt/lFD
cb8h3ZJmGI57DapFGL/x/Q+OVcz2
          "]], 
         PolygonBox[{{2782, 2781, 3791, 1122, 3792}, {4775, 1814, 4774, 2781, 
          2782}}]}]}, 
      {RGBColor[0.921, 0.6725, 0.35509999999999997`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVE1LVFEYfscZp5m5d67OnUsmLUZz4aI2fbqPgpZl2SIIyihIsJlNFETL
hGrTB0T5QVhC0RdYEdkfSIsiStKs1AllRgaKoCJaaM/DcxaX8973POc578fz
ntbuYueJOjM7iy+Ob3dklqo3e9xgdtIz8xNmn/Nm3aGZF4M/Y9YJTA/AxaxZ
FYc/ADOEPR/ndsD+B9/zBq1LvtkT8HTAvxUcw0nxt5vWW/hfgd2YEBd5irAH
wN8Oe29KZ8k1lBH2dmA2GQgzhhiOIZ4N4PqFO//iiwHbD/9T2O/BsQf7H2Gv
BaacFo74vlDx0r8E3M2szpLjC74C/EeAmYXdAnsO60xaeY7BnnYxvMiqFqxJ
CeunvKsLcq8Bvxn4FeCrnu6Zgn3aU67VnNk53NEE+yXyq+BsE3Isgns7Yovi
yqEG/xbUYgack774ec8Z8KwGrgT88UB1XIC/C3cM4twp10Paq0zn+E+7kpPN
Ps9nVO8pcMzCvoF77yCuxaRqtcuUB/0JcJQdvgJ8a6Qesc9rkH8bMIvw14Bb
n1I+SznpZH+DfDXX64v4/8neI+YpX/4++C7j7jiCvIR1Pi8sazYSqCbL1FVW
saRZj0D3NsN3Ia6z3GNcrCNrOOz23gL7xlPvD4TSOrW4CXZvVtqcRt8mMsK/
Av4+8AOoRQyYiuvjeWCP4r8Mfw2+a1nVqYqzBn8//Pfgfx2ov1nsX08q35GY
uA8mpLm7nvaWc7rnt8OMBuI8BL6HgWZwNKN98jNW8pVcnQ+H0i31uzHUvHBu
3gXqHXvL+rLO067ejW5+C5HmrSUSH3VFzh6nQXJRE+R5hlwmAsU/jnXcE4Yz
x7p2pTSzM3nxU5vNThv7EMNiXvzUL98U5sX8OBusLWtc8PUWfAuU72BSNaGG
qKWOSHNZcPrkyl6Qi5qtJFX33lD2D3DWheJ54OaG+TPHR57epjT2v+al0TLW
755moAf+hUCa56zMOQyxVxDPH3BddXFxxjhffBf4PvCt2hZpBruc3jnLzCXl
S6fUMjmYJ3vaFqmG6yK9kewB61/vSy98q/hGMPbZvOaBc7Ezo3eEeVN37Enk
zv4Hc2DUrg==
          "]], PolygonBox[CompressedData["
1:eJwtlEtI1FEUxs+MM9OMM/P/6zhk0MLXwkVtetGiXSS0LKtNEJSRC8Gcndta
JPRYjAVRagvNICoKiSKhVYvQoIiUFCPNUhwZKKLHooX2+zj/xYVzz+O73/nu
ubelq6/zfNzMjrISrItZs/GY2UjKLF4wy+fNGtnHSAqwHxAfIvaH5HJoNlFr
liW+zhog/oT4GPF0khjxcmC2n9xjabOmolk3Oe3mGAb+coPZDmJ3qP+CfRLf
oYTjVcBaxNdonrOEvQRmM9iH8d0E6yVruMasj5qmnNlZ6puSzqkLe4C1M+k9
XMLepH4P+wT9bGBPwe8UtVfAGAVrMsI7QM7vDLrA+QO1Pfg6sZ8Rv13jGFXi
g6Fr8Zd1PfSe1fso/T2Gf3PRe//HebPEYnAYTrnGF4jfCL1WmvSCfTnvvYv/
U7QtwW8r8RIYHWBVMt67eupmP0/P1bjnrKLPCqsu4b45YqcLni9NzmB/DVyr
dvCXwZ/P+NnifAS8Sfjkks73BfZGvdmtiK9m4zg1bfRfAuMbWG8C107zkeS8
u+w3wSviG8euwOdnwu9wrcE1EPYJ+mnjvH0Fnw9pPAX+WuDcdEYFu0y8Zouf
Mc3Z10LHE6f75LcWHUsz8zbrd6q7Vc0gtauBYwlzBbs159zl24bWHbXO9SC+
MeJz0fmagXnsTM7xdOfv2fcIM+WaTrB/Hs2D5qW2Dk3Rc3vS+dxT//U+2zOa
6XrPUa7wNbuaMe2Fodma4bxK3O9wAb2G8q6t5vc1XD/hyyU8Z5bcd5H+4phm
v8Dam3aNroY+Y7o7+aoN3qN6leZ6m+IorrrzBbj0kz8S8zPW4Ftlv5zy+fkM
3u6Cz4rueBf2r9BnUZp8z/qMlqLzdVfl6H1o5h8S/6E7TnmNatWTepOvF7xS
3t+a/hD9JZmCvyXNqP6Ogeh9SOOPob8RvRVxPKdZKrrWXL+9yvifJf30xqcD
70G96A9ZxF7P+TxKjxZqH2X97xNnve3/jY+yCw==
          "]]}]}, 
      {RGBColor[0.927, 0.6875, 0.3737], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlM1LVWEQxse8Xr0d7zl27hEs21ibFtXCiOw/aNMiaVNCpGVK3636oEUr
MywyqE1krdokFBZBLgy7StgHQUQZBppp5fWSLXIV9PEbnrN4eefOmXnmmeed
uU0dJ1qPrzCzTk4l50vBbHON2Rz3ImcLdom7PzIbqTC7F5hVxWYDWeK56zOK
+QFIOWe2B4zHebNN+CK+LeIvrTK7RPwC94uVZg3g9JMbVJntJq5YISzHrObu
i4Q3VWt2n3qjfB/Ct4hdxv6EPUWtFmrdDc3Gs8JynGZuqxaPB2nuSfh8p4dm
ai1wjxKfS+PnwFmPPQ9mX6zcaur+jYT1LxKGc9vA50eRclcn1Od0gzkGRl2d
2S0EHKGWgdOOfQj7LRx2oMMgPAsZaXIHvPf4d2IfJHYi1eQZMUWwusDcBnYD
+WvQYR18hkLFHyZ+HvsU9tdQfY9lpUVDIo7n8bfE8r+izgz3uUppVwXWPnJf
htLO82Zz8vVWiodjey9euynRG5XImwik3Vawj3F6iHkO98FAs+EzksX/G8wb
+F8Hepvtsfr2GfDe2xLxuUh/t/OqO8DdwzmLPUTuR7h1kTMZSj/3O1d/C9fW
a9TCqZNv70LVc99p7CXqLhH3K9Jx+2eg9/d59dlyjVyrDNzKzEQj/gvEtPN7
Gp77Y+n9Lav8a7HmwediMqN4xymG4u99eG3ncB0uTyK9zXCkPr3f3rzyljPS
qyPW2xxI92hjjfZlpiB7mvtoLA5HuK9Gyn2Tk+6u/828eDtuRayZc31ysfa4
Pt1B30nfiWVyx3PqoQ28tYnm2efa98Axvd+HgfajMZEOrkk53QN/A+/zcqx5
8fn1ufeZeZrWH0ljWsk/A49difbWMfZify7oP2K2oN12TN/XD5He2mfBeXmu
v9OfdB+vxOrBexnOa666U93+AzZtrfQ=
          "]], PolygonBox[CompressedData["
1:eJwtlMtLVVEUxtete69er+ccO+cElk2kiYMeYET2H0QQkURRQpQZSmkWTsx5
YVhU0KRIHDRLCrSgHBRmDnoR9BSkfKQ9VLJJgwiifh/rDjZnrb3W/tb3rb32
qW3ubDy5wsx2s7KszsCsjm93uVljalaIzY6sNBvNmN0pms1HZutzZsv4c9jX
yT9HfDN7v/Ef4d/AbwUsqDT7lJgtUmADeNPYc6xN5b63n/wFcvbiFzn/AP8u
NcYyvldL/anEz64GrzM0e8s6hn0AjjepdYv8hxnnaHDdkzr3Anj3wBskfwf5
DYS7yP+Cfxp/LfWr8Z/jH8KvBuNZhVkGjJqsYw6CfSpw7XWl3lwkXp/z/AvY
B6nxA6wt0gTXj/hLxKbycFI8db8Hfk3Yh2OP7aLGELUXEj8rfT3U+xc5vvQt
Fcy+rzI7T35EvLvomqRtlL2n+BOh91o9n4H/UfCn815TXLSnmDTPk3s89tq6
v2XON5EzkXUN0pKNXWs/GDnsbXBuhd8A+fsiX7LFaQFuUZX3UjWqsHsD17oT
zDfg16R+n+K8LnWN0qoZ+Jy4JmnbiD+DP1npXHQHS/htoccTVgf2bOK5mh/N
VktJj/QugtUV+llpGqd/P4uuVTPaQe5V+vHH/H5b4Dpb8Nk4Q/xD5DMmfvXU
+JZ4jnJ/sXeJ+KuC26qhWsMVrlc9bwZ/O2s875qHqT0S+WyrxiRnr5Xei97Q
HH5Z7L0Wpzz27dB7J0xh642J/1dy2om/APNJ3jHvRz7TwtZeQ+xvSr1pg38D
/d4a+6yIj97W2cC16k28FlbBc9Vj9fpx6LPdS85Y6DVUS5peFv1OxU8Ywhqq
cFt74j4Q+Fm9qRx32V/y9X9Y1Dwn3lvdcR/YI4HPut70O86XccbK/A38JX45
dj7yr2CvSX2WNKPVqf8DdF5n+mL/B6mWaoqLaspXz9X7E7H3UjPzHi3/ASFM
r3s=
          "]], 
         PolygonBox[{{3085, 1127, 3800, 3514, 3515}, {3515, 3514, 3796, 1125, 
          3084}}]}]}, 
      {RGBColor[0.933, 0.7025, 0.3923], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVE1LVGEUPjNe58M7995pvIFZhElSv0Acg5aFG4laVOMiE1PBNMJNtamN
0IflphYG1VALw2jTpkVQ9LUqIms0plU4kThMEK0iinqenjdcvJxzz3s+nvOc
895tQyf2TybNbBynCedTymxrs1k1YbbSalaGPOObTYZmsWd2EnIMJwPf51mz
O4HZDALfw1aGfgH6WmTWAd8j0OcRfxbx7fj+gnwTLvZfDvh/w/133PfhfiP8
P+C7kZR/G/zaY7Mu6Bfh09gg+/98zE2fj5Ewd8H3GvQnsO+BPhYLD3HN4fTB
tw7MlwrCTOxt8OkHoE2Qj/CdQu0gZ3bfVx7mK+Eso94AZA9iJxA7FQjXzZT8
mgvSPcjZSL0Pw2cAec8hfwlyDvYfyL+aE6fkdg2cTAfq+x1svbF4Jt+3E9Lp
9yKrXqdgP44anei3FokD1uIdeVt2/nuRZxD2Y8h9APppYKgix85YXJGzoy5+
EPJuKP4t0D0xF009MP/VFrNkWrw1JYWt4mmW1ZxqH450P+KJxxHgXAEnDfT1
FrV/wn4dPou++mXf5JKz53e9VfjJN2fAHI8D1WG9ssNKzNO+doIzyBQ0D+a6
hz66PfVbgd/DSPKVL+7I05useCE/Q7h/4Cum6HglZu7Kkq93MA77qUB8zIea
E/Geh217LDvvf0fiJp3TbJjrM+QvZx+Fby2r3NxH7h3xcydSqHELddNOEhv3
ajXSG+Fb6cXdS9ztgqw4bDuQM5HWnrNGTyy+DkY61Gvgte7rbQ9z9wuKuezy
kTdyxNlzBxZCzYEzJV+v/XUuv0KvIWYUsfm82W70GOW1p/TnjMjlvoz64k7Q
XgSuLbHsm2Pl6HT/GXLJukX3PsnPDTefDvfOF9x+/gG3i9BL8OlvUd+HvPX/
COUMYp+Fsj9lL6F2cinUDnY7znNux/jurxS037OQfwGyj6s/
          "]], 
         PolygonBox[CompressedData["
1:eJwtk81LlGEUxa8z44wzYzP6zhuYRVQk9ReEGQRtCjcStYlcVBIa9EWrCAra
RIWWm1oUpNHGoNoUtKvoCwIjitSQNjETiWLQMqKo3+nM4oX7cZ5zz7nP864f
OrnnRCYidvDl+EaSiEY+Yr4lYqYccTRxvKE14hjx2IqIH+T9YEeJt1LbwsEZ
am/Bj1ec/+J7X4y4KAzY820Rg2nEBTBTYLvpL3fSo7aMgJS8j/gS+E8tPqOz
m1LPX8v8zcSPq551Br695Kv4Boh/wvGIXqNGH67bYOrEs+gZJh/LRkyXIu6R
H896xge0dDIjnzFmjt4T8v3M3s68jg7i1No1/zP8h/H7pbmfWc7PF61FnuVd
GqRlN7U1nF2dOlb/IfjFmrXNkS/VvEPtsg7nMNyDVfe6qL2Cexu113l7lvfl
srG6jzp5T2pt2tdG4ndFnz2Ax3H6AyX7kUd5nSzZvzj7EnOIS3f+He6dcDxj
1kEwu4gX6V/O+s4XiG819SqfIH7a3J9maHcL7fbfg4duzk9VrG0lHHeJvzbn
iaOB1jcl87cUuCP0PAezL+eaet9qzbcC5zzcbYm5pfFB2Xequ81w/iq9Aphs
xrVR8o8Vx9LYTu9m1W9TGm8QT5e9W+2kF3yObyLvGWc5e63kXa4jP01+veTd
TILJgx1PPFszf8N3JbEX5X/Ih6rG680fIn6JZ57D/zfam/pN6f70ppbK3ql2
qx28YN6piv+NO9TO0f/b7l32U7tPr5BYi/aRTaxRWjVTWkdSa9E+j6TGCCuP
rYk5xCX/ehvyLO/6p7rA/wOmRY0T
          "]]}]}, 
      {RGBColor[0.9390000000000001, 0.7175, 0.4109], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1k09IVVEQxiczed2r7/LOvUEGLgStXLrM9koRCQXpwohE/LMpzQha2K5F
GLppU5uCF5RWYBvbSLqujUgG2qoIJXsvdz7MoH7Dd1scZs7cb7755szc1sGb
l27UmVkv5zDnTWz2rMGsEMyqqdlmvdm1xGyR+BzxQHz1qFkH2Nmi2XST2RSJ
D7GdR7gXzM7z7UNk1nzIbBL8aKb4CLYKT5X4Nzg/5pj1oupMw1/m/hy7z30e
fwr8cfwJMF/qhWuGv0zuOHXvUrdSUu59sDNBnM79NhZXTCzilPEXiHWhYww9
Z7Al8lvguRippmO8t4NE/dwK6tNjG/T9iHgNXI23GQ7q3d/A38i17RK/nkjr
ILafs44/gI3gewW/oW+bezv3H9gV+PvALGPjRrMh/DX8riDs00hv7/mu41gQ
zzt6GcX/jj+GvZwJswjnBTj66fGA4Z7O5J/CPk7U5xPsTJNmtUSt8SDfY23g
roBvx57g9OJvNyrP/flck2t7Te7JTLPwmWyA6wSzlUqH6zkbVMP5z4F5id8N
1wvsn/ydZ8FczaR7oag3niho1j2Z/O5M3xyzQt4q/ffgzxH7FCs+EqTd9Xjv
v1Nx+dxcq2v+m2v0ufi+/SzJ/z8r3w1GbcuJON4n2lff2wp19lLpugPf7SD9
vi8+N98l3z//5pgK2Hux6uyU9G/V8t3+XBTed9Bn6LvkNb7mtQbo91eqXOd4
ECtvP5Um17ZDL/8AgQ+JeA==
          "]], PolygonBox[CompressedData["
1:eJwtkjtoFWEQhSeahHt3c/fG3RVUsBB8limN2CYooqDgAyJofCRpYmIstBCx
sNCIVoJaiKAgiQhaRMvY2Nj4wAiJlSA+4o2ChcEH6Hc4t/iXmZ0zM2fOzJr+
E7uHl0TEVl4r72Eacac94hfO9XrEId4c9jveYez5ZcRbImbwv2J/6ojYVTH+
BvGBMmIcv6st4i9+X93YKrWf8fmCv47YdvzbtYh/5Af1esFMZhHTvH3YZ5dG
TCURlRwcfCbBXEr9ZKvnKnrdA98DfgT86ZprqrY4DBK/Rr/FVtd4QO4Y9Va2
mN8p7C28pM0curG3Jc4Xx8/kXq6Zizj9IP9WYux96i0H/yS1rRpT4M/DZ1NY
w4R4o6BfWMOFwppKq7vEH5Gbg5lod45yE/Q4Qnw1PTvp/ZGcroo1Pwd+APwO
1cJfwN/MjEMVa3yA2sOZtda/7tIaiv8HegzmxgirmrP0msP/wwHsx98Ifmfi
3uLwKjMH+UfxU/CLhfXUTD+x++u+DfnHwN5szqd5XlbNWdzH6d/gXr4X1kL/
vhXemXa3l/5r6X8y9260gxHsUTisaN6PZttQmqs0eEPtNLeWuomL+BdS91IP
3e5Q7tml13vdXulemlmzz3fYFof1xGar5q597sFvpM6VhsepdabJVzf3IvXO
hdUOH+P3lcaL30Hsicy3rZvR7UgjaTUKh17irzNrq5t8Tnwmsy3N32I/rbuW
OE5L28Kzage/sXtK15KvW7/a1E81rmD/BxNWh0g=
          "]], 
         PolygonBox[{{3337, 3336, 3058, 1111, 3776}, {3023, 1094, 3752, 3328, 
          3329}, {3329, 3328, 3754, 1095, 3024}, {4072, 1317, 4071, 3336, 
          3337}}]}]}, 
      {RGBColor[0.945, 0.7324999999999999, 0.4294999999999999], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkjtolFEQhWfzYvM/suv/r4WVBMTCXguTiKURsRDUJlrYJAFRWdOIIARs
ok1IZeULUmilRRSEmAjaCBKxECUI2uka1yj4BMHvcP7iMnPnnjkzc+YOnzp7
5ExPRBzm9HLaQxHb+iJmsGtpxOtaxIU84mXl1/Cb/RENzl7wn7dEXBmI6GCf
JxFXIXlF7scGPPjjifmEWST/dm5Ml/djfcZkxMcL813ifYH8GrGb5N6n7hP8
a+AHc+PF/Z4zTA8HydsFz134n4JrFfZL7O8yYjtvl+FIKtws3D+4fwc7n/tN
mE2wj+DM4VwfZAbOP+I3iI22PIO0+QJudz1iA3u613jpcj3x/Q6YJrz9iJpk
Ed9Sz/mY+HLDuu0v3If6KfCfUesN/kQ104sBa3KSexeekZZ1Vx3t5FBhzFv8
NHMt1ZR20nCU96XEHCvSsmnNpf1F7juoNQ33FGeT3EnsSsN7XcVuLTyLZnqQ
Wtcl4qtD1l97mEvNk4L9UPU9jX8r8e60w2XOUWkLdqNhzVNy9xXGCDtSr/Tv
sZW2mlk44bUr7V5/4B7+DLkdZj+P3VP3XoTfiUbHuXcy96qeH6bua7ZuXTJy
FsnNsX/Z3xjxP9huaa6v2BMt4yewP0v396v0rMKrz7HCe9Q+JysN32WOqQfN
NlVYf+1B/0h6qiftQf1rtgPUaINfY//nwH8i3i5cS3HNvJ55Pv0F9a4/o/h/
QpN8oQ==
          "]], PolygonBox[CompressedData["
1:eJwtkjtoFWEQhefqJiZ37+4mu5silQTEwl5Bk4ilESvBRxERrBIQxWsURBC0
U5sUgp0KIYVWEURBJFGwCoiSQpQgaGmM8WrhE8HvcG4xMOefxzkz84+cPHPo
9KaI2I0l2IEyYqQnYg/+BH4b+9Qb8b0R8beI2MBubDZex/9ZRYz2RXRochO8
lEe0iA2T8wx/mrdtieNT+Glp/JycB2nElsy5R3j7Br4IfkOsgc01IzLy53ud
f4v6RaxA3wC2VPhNsTYa9tdwFo5J/0Juk3+F+HHir/qdKw2XiN1tmkuc5+Fe
zK1FMzwkNt3dh/AU/iwadyTW1AJ/Zf5d9NtgvhNwTzQ9z2FyntJrsja3enws
nKPcnbx9ofYYeJ7e1+n3eTBiX+n5pGkvfid1L/XUri6Dh5MuZ2WN0vaS+oPk
v0vti+8DvddaEUf73FO7m+vOq7ftaLvN2wvwfWpq6kdr6xPHWO2b6nbj5P+B
bzbz7fUnzpb+E8Jr4BnwudK+/sgyXCu5/R56pGhZSH0v7bCp3EHPLj7N1oFj
a2INq+Q/Tq3vFD2GSt9It8qY5wnc71vWp5pf1I6VvrfmHce/kDumP/qD+Exu
Lu38Kr1jwNqksYG/Xvk2qlFtVXo30qvbr/abW3ramU3+P+IrxO7lxtL4mvxJ
NL7t8unWvyvvUv/vGvE7hWs1o25RluYSfkT8P9d+ek4=
          "]], 
         PolygonBox[{{3471, 3470, 3772, 1109, 3773}, {4721, 1769, 4720, 3470, 
          3471}}]}]}, 
      {RGBColor[0.951, 0.7474999999999999, 0.44809999999999994`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1kj1MVFEQhQ8s4sLuvqdvtzKhsCKxNlHiaiQ0Ala2RgtJjFAs8S8kYEIC
HY0YCzqwgkoqaPixMS6FhYk2kI2iiYWFIAgFhYXfySzFzZw7d+bcOefeiw9G
79RaJfWxcqxGUbqSlw7KUrUijYCvEedS6aRNKmXSPPgfeIF4j7UDHiL2c/ax
XRogXmfVwVXiDdYW+Cbxc4d0iXuelKSH9Hyj95i76ol0F/whCY6nDNNokV6z
7yG/UeAsjdw2eJz8BXgO6Z2Aa5v8OucTzfwn7nkPHgQPdEqz9LylpswM35s8
O+R+g7vPSPvEVnT2ofcHHpyF8w81B9T05kO7ee2N9S5yVoPrF7OOEv+WQ4s1
3Wb/gvlXOiNO5YPLtZO5wOawt5TocRb5We68X4n6n8x/4jcAfy0Gt7HvPSpH
nGa2lnPSZeYXcZX9EnekWXhhT8bgrDf12j+f++3shTVZr/HprO+S8N5v5/7d
trjb2r8UIme/i1n02dfBLHqW4Ng/H9r8LzaT0PWS+t1i+Cjro6eLmmdJzLLY
Hn+iksXe/yvJIr9C7aM05hgmrrO/Cn5F72EhvPRb+T+Zo9ERvtifPWa5VQmd
/r/uq+Wi7nkp8BtmnimF9q00NFjLMvxradS41hqsxW/1H19uez0=
          "]], 
         PolygonBox[CompressedData["
1:eJwtkj1IlXEUxo92e7nX9973rffeSWhoCloLKryR0lLm5Co41FA5XKGEoKJA
gqAlbXALxcGmmpKg1M3r4BDUYkhZINGiaR/g0NDv4bnDH87Hc55zznP+x6+O
D7e6I+IUr8SbqEW0DkWcxXmXRmxWIk6GY2/ziFdZxG3sja6Ij+RrRcQB2Jf4
Veynqe2L5YjuRsRNarbI98Jxj9ogNlC2fxd/kJr1hD7UfAU71+Ne56h5Rn4j
dU49r4D9DuYn/iQco3DdAkNJjOE38fsatj9RPwr2EfUL4JvEDuoRM7nn1Qxb
1Yjtirnuw/+E3XN6vEi8g3a5Dv5LyTvcwP5cNZdiyv2p21aP39jXcvfWTG24
p+B8CPcIsb/wfataG82gWXZ5Jw6zG/h5sGu5Z9HObex+5llLrPcy/mpmLnG+
oclzYv9KnnkR/r3U+ii/DHYlM59i++SmM99WN32MPcE71plXWo7T70divLSu
F9ZCPRqFe4pbmBb++4pvqX0uof1sZx7xfyDXBNNOfL8H7LdfN16a/cLe450p
Wz/dain17fUH9BdVo1r9kcuFZxb3An6G/zq1rZ7SQhpJK/U8X1hTaXsajbuO
8N967EvzHd2q87+k0VDhP6P7aaZNbrVz1LMptot9p2Z+3eQC+P8GR3x+
          "]], 
         PolygonBox[{{4077, 1319, 4076, 3339, 3340}, {3340, 3339, 3061, 1115, 
          3782}, {4671, 1735, 4670, 2721, 2722}, {2722, 2721, 3730, 1081, 
          3731}}]}]}, 
      {RGBColor[0.957, 0.7625, 0.46669999999999995`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkjtoVGEUhCcbI9ls9l7z321MIYg2VraK+MZCgw8sLSwU26ygoljZKSKI
iHY2EiGVNj4K00VXCxtJY7Gg4qOLYoy93zBb/Pznnn9mzpxz7tZz/dPzLUkH
OOOcz9PSGomHtTTdlWZJrhJXRdq5QbpZSft60hbiK8Q/eNs+IZ3g/TL4wZi0
1JFOleT9/oizTP45+TG42+DeIn7flr4RX+T9bC/4n8SvO9Gx3iZ0FjdKM9zH
OXvweIO8wPbHg2vB3YHOXXgvOqnlmtZ23v38baTdk9J6E9/2f61Kb+7x2FQ8
2du/Jj7sp0/No+hfgvsRvw25MhEfS54L8bAdj56Paz9Bq8X9YFTnDm+LfF+v
oq9evNpbjf7+kl6udsMxdwGNlXb6XKDOoZK6y8QD8kO45+vsw3Xvcd/uxtd3
3u9X0XyMzpCd/mYGF+p8O++ac5wPePuEl18z8bnKPUv+GfHmEo/u3X2tgJvj
++mopjGev3Wtv7eX3djDQbjr4M+AewP+JXW7YE+WzGDXZDjeiWfkeL4E82oq
vdpba/Tt/Fv3VGefX+hpUGcf77gPl2A9e9f0Ts3xvKx1pOSfNveruVUw/sfX
mvj5w/0fyP9kYQ==
          "]], PolygonBox[CompressedData["
1:eJwtUj1IW2EUPYlJifl5r3kvSzMIYpcudrVICyoOGrTSrQU7VHA0hYIWJ0Fw
EBcRnLoZMJMutkvc0kaHLsXFIWCLXVVM4u45nAwf3P9z7rnf8Kfqu5UkgFG+
FN9hFkgmgN9PgEoEvOUr0H+eBhZo/x8ExmH/Ywl4xtgxa1+yeT8HtJkPmKsO
AKsFYDEE6uzfYc1tEbjMeXbEml/M7QbubbGmwdxBaFszy5wNYoww3yHJqzww
ERlf/ZO0b4qePcSaTfb/zbtWPYmSY8q9ygDdmJiB9ymTX4t2l/n3KftZ8p3N
2lasyXwvdu8dZy6T2xlfnDaHbdZ/o9/kvC+smSFejT7S3kG7SBPtVyfHp+Rb
6+tbYeyY80PGXqQ84ztrq5G1FccV2vN9X3hztP8MGks9G+y/J7+xjPddD7yD
+H+g3+O8r4H31w226C+RU7vv6zZHgbmIk24/HVlb+VORMYR1zXdO7IfYWNKj
nbcmssWhw9y/vv7qSVKPz6F7FauGvrnmS8MW7bWC/4r+TCP0n5EvDS+Id5qz
lortkcvrkvG00xvaJzlrJ40D8v0ZeHfp94P7FCNrrxrd6hEjz1xx
          "]], 
         PolygonBox[{{3759, 1099, 3027, 3451, 3452}, {3452, 3451, 4027, 1294, 
          4028}}]}]}, 
      {RGBColor[0.963, 0.7775, 0.48529999999999995`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFkr0vQ2EUxk9Vmra37tXbG4LJ7B8QQqKIGHzEnyAmkpaBGERZmGx0YdOl
CWFqSITFgAgRg6VNxGpAMPn8HaeJ4c157/M+53mf87y3dTw7lqkRkXZWmNXg
i+xERA4ckbU6kUXAS09km/VTK1KgluKGn7oinymRB/AMeBF8FnwAjbOYSAt6
S3DS+o1mD/UN3ZeQSBztO/bn4H3guxHT3+esQp2KinD8p6Way/Bv0WwDm2Nf
cg3XO8sJkQ7473g5pqmD/nXOL/BUQS8M/9CxOxrR+4JXBF8FW2G1wp93zZN6
ewVbYD+D/p5rs15HTGswEPmAv4W2V91vsm/2zb/mpD3aW4ibV/Vcxvuobzoj
1OekzTnhmV/lK6/Xt0z6qd2B5dBFffTMh76JZq2Zf6dsNvVVdiwD1dTZ1J96
S6Kz4ViubmB96ej//Fqf8DIE74p7h6mhwDj3CcM0Z70jz1yd9J849q76vjcx
m1v/GfWfrXqb9iwX9ZBAL1/10OTbzOpzkuoEppNDr943jnJzVf0PZjzyLB99
k1+4LmUY
          "]], PolygonBox[CompressedData["
1:eJwtUk0rRGEYPcN0M5/X3JkIq1lY+Qcjip2Fj/wEZUMZFlOyEDsLS/MHZKMo
q4kSG2WSSMpqpqRsWKBYja9zOrN467zPPR/P87y3OFeeXeoAMMgT5zlPAcME
K53AWgaYD4Em76UuoJEG3nLAfsy1d+LVLFAkpgwV4lYeGCB+Yu2beJf6P+LD
ADghaaHtJ/5lgp4ETfpVmFej/pj3g8AaabdZG4JrPRGww3sp7pq+TbF2E9jj
mfy7hPNb5EwUgBGexS5napYLataZ9UH+J7OuQ9+lvyJOF6yVR4r4K+/ZNfNW
yhni3jJzhtm5yPwj1rojc8QdpyZG/V57fvV7z95+896NOD/EvZF3I32V2unI
3uqplqQ+6bfQm1TZ+2Pa3vIo03sj491pB5PUjvHUA9f0rZFwtjxOyX8JPbv8
X0O/md5COxplv9mCe9FMIfFy6Czto57wPyEvvcEZhX2R+Zqxn3iz3Y96eOD3
fyZSW3E=
          "]], 
         PolygonBox[{{3030, 1736, 4674, 4035, 4036}, {2726, 2725, 3733, 1083, 
          3734}, {4036, 4035, 4677, 1737, 3031}, {4676, 1737, 4675, 2725, 
          2726}}]}]}, 
      {RGBColor[0.969, 0.7925, 0.5039], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUjsvBGEUPeySnZ3dmZgZj9ZKRCUSrViFrFcj4hcoJUg07CYKjQoV2yko
FHReQUFDyEaLRBCFigKJzvPcnCm+nO+799xzz70zzWNTI5PVADp4EjwNAdCZ
BBY94MwH7qqAGxd4zAAfJE4wduEAT+SM++IZf4XoRkBfCsgQN9PANAV7qZfl
u42cZeokahS/pG6e3FxSuq/UamXuhThEfjvjC9T8CcX7DdVnt1a1lh9g/JO1
RU86c8RZX7EZ4ih1SuQ8OHpb/Jlz+JFqPeIRPZ1Tb4P5Ck89PVz58mqe/9i3
7MmzzdQTqZf1vHY0z5avvPWyfRU4c4U++wPty+bLs64lkP8ccYf1Xdx3Ia2d
WS/zZ9idUs17HbBE/hvxgPxh5u7pq5TVDk5d+Tb/h7yfuIpbfs3VvprY6zie
cZ3c71D6X6HmMP3t+Bub93nW7se99oi3cdz+Bfsetvci76uu7o2BdE1/kDP+
AxH8U2c=
          "]], PolygonBox[CompressedData["
1:eJwtkD0rhnEUxs/zQrjfct+3lxUlk8UqDPJ42eQTyGR4lAn1JJNBz4ZFPgBG
CwZKKWGVUmSwGVA2r7/TZfj3P+dc1znXdU7X7MJ0tWhm3bwy77XVrN5ITrIe
mO0lZpcFs0NqPanZOfk9+UqT2UwOLxU2AH8X/ij5Ykmcu0AzfNYw/O+Mn573
omojxD+ZMK9VmT3HOyjIwxtefsH7ysIfQ7Md8A/iCXoS+h+a5cU1a5HZJLUL
+vvpmSLuSBV77Rgva5G8XTG/AjaeKvaa73YUiOv7tIM9h9JzDxHzlhPN89pS
Is/ubQgPX3jdJy816GZ+uzp6g9y1l9pLIo/u1Tm3eK/FuoXvvIH2aiytCvMC
9MJcsev57vO8p3++32ozllfXO6V/rEV6bcy/Bj8LhLnmNtzOVHzf8QTsJhHX
e9xrnOu2vuMW+Gem3dyTe/sDnN9L3w==
          "]], 
         PolygonBox[{{3332, 3331, 3036, 1104, 3765}, {4043, 1301, 4042, 3331, 
          3332}, {2730, 2729, 4679, 1738, 4678}, {3764, 1104, 3766, 2729, 
          2730}}]}]}, 
      {RGBColor[0.975, 0.8075, 0.5225], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUT8vQ3EUPdrXKq/t856nkSiJf53EV9BJGgaJ+AQmCSEREoZuNj4CiZFG
LNXFpkazSUgkwswHwDk5b/jl/jv33Hvub3pzb303B2CRL88XVIAanacIOKkC
deVT4JLxbwDE9F9CYI1+l/UK41YJ+CgDcwmwQPwWOR6IjwvAfOK+g5K5Zhnn
mL+OjBN+grnPwDw3A8Bh5HiQ3Nv03+nv055zbpf1MeaX2ZOn3xkGNlLP6hNz
FZl/ivWz0Hzfsecp36G9yHhmiDml3yB/m1oKqfHqq6XeW7rr2c7iHkmtQ7fR
DXQr7fFG/U3u/zcKPA9ZV5v6bovm0bzJxFY6+tl9Wok1iOOOnD+x9Uq3/kD8
y6z3qvb1P6up77lC+xX4VtpJ89UrDU3Wdhgv0R5Fxh1nM3tFz7sPvd84dwhS
8+j2jcSYx9B84ilneqTrlfr+AfhlREI=
          "]], PolygonBox[CompressedData["
1:eJwtUb1KA2EQnOQuMT/mzjvPIBiFaEzlO5gqBAUF8Qms/QERNIWtpW9gYSci
FsY0dmLlA9goCoJorQ+gzjApPpjdnZ3Z3a+5tbexmwfQ5Av5nqvAGkE9API1
YDEFkgKwxFqL+DJmfhQ/lYFzxr/kXxeBO/YGGdBg7ZO5kPg7Aa5ywDvjH+Lj
CGgTj5PTJ96PXVP8SL251PoD9swS74zqnRLwRtIte4Kc5xtG1lDvNusd+i1n
xupR7wrjg5Jn1Kx9vq/QM55E3lFa68y9cP5uxbFucMP6Yexd1HNEPIjM1QwX
FWtISx6r9Eoyeyk3QfzB4Xola0jrgR7Dom96z3g+9a7aeYF4OvUtlTsj97Xs
W4u/mdlT3tJok9sb/Y9yXeLTqu8tzxr5Y5m9lSsQ/036lorFnUmtL/8G8VRm
b+1QJ/4HEvE+aw==
          "]]}]}, 
      {RGBColor[0.981, 0.8225, 0.5411], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkD8vRFEUxMfueqy39tmXR+NPSJZO4zPQyGp8BHoSUSMSjUIiCo1aNITQ
KlBs1kdAhw+AqDR+k/OKmzn3nJm5c8/M2ubqRkVSm1PlzOXSNsXFkNRfSEuD
0gC4k0m/ED8b0gj3Zfot8Jx+t0/qFKGx9rYpvTdCm9A/475O/5T57nBwrtDV
mc3XpAPml9yf8flD95pKb9QVuGNwOviMgiucBfiHzXjfWmfaK7M5o/X2eUyD
Z/5+Fmgf8+6SyGOeM7me5t/fLemI2Rd4k4SmW+Zwnhc8J/OYTYE/Jf+Y/kka
efynCWbX9MfBdh7vzYI1ZotkqIK9LPbgfdyn8Y53+VDu4YleUe7H3r269EG9
lUVe+1vzD+quO0o=
          "]], PolygonBox[CompressedData["
1:eJwtULuuQVEUHI/cSA42J4fGIyToNL5BJTQ+gUZF4wNE+AuFUkMI7S3uVXj8
ApXEJ+jNZJ1iJbNnzZo1a1cHk/44CiDHirOOaWAaA54R4OGRD4BuAmixufKs
hA8/QMkH3kngQ4MmuUBa1iVimh5xltVJmGbtgGXatG1yL85ene3Szhvxmf73
8N2g/yLUyyNDrwK5PXcP2R+lrIRP5Grs/Yfz4lac3TnzErcl3jjLJ48i9XNn
WZVvRlz3zUv6P74rvnlp5pfeZd9u11teukmz+qM888UCu02Zlf0LFswuhQ==

          "]], 
         PolygonBox[{{3958, 3957, 5127, 2117, 3299}, {3948, 3947, 3954, 1252, 
          3953}, {2957, 2956, 4593, 1678, 4595}, {2961, 1678, 4594, 3947, 
          3948}, {5126, 2117, 5125, 2956, 2957}, {3298, 2116, 5124, 3957, 
          3958}}]}]}, 
      {RGBColor[0.987, 0.8374999999999999, 0.5596999999999999], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtjr0OAVEUhAe7smvFxrqVhq0U4hUkGo2fwiOo/URBjUSp0Il4BVvoNSo/
rScgKuU2dObm3GIyJ3O/e+aE/XFvlARQpFLU1QeUDVzoNj1gWGNesYChA8SE
Tx5wTAPlADgYLqKvPeHSCnCoJvkMfZeTPd8sMCf3IbOklwLZE9KrlvyNEsDM
l54n+a35++Mc54XRPXvmdc5nTzjNr5h12Ddlb5uuqBbnN98bSu6/uUDB5AH9
Zf7qTt2hu/S9d1fuXDDvmp0PZhNfbhz4Ij1veMMfzVcquQ==
          "]], 
         PolygonBox[{{2506, 2157, 1063, 3710}, {3717, 755, 2118, 5129}, {3010,
           1086, 786, 3323}, {5130, 2118, 755, 3956}, {3320, 786, 1086, 
          3739}, {3455, 45, 1300, 4041}, {3323, 786, 1285, 4013}, {3735, 45, 
          786, 3736}, {3956, 755, 2157, 5185}, {5126, 1063, 755, 3299}, {4014,
           1285, 45, 3455}, {2961, 430, 1063, 4595}, {3710, 1063, 1067, 
          3714}}], 
         PolygonBox[{{3739, 1086, 3740, 2711, 2712}, {4007, 4006, 5196, 2165, 
          5198}, {3967, 3966, 3301, 2123, 5139}, {4641, 1714, 3005, 4006, 
          4007}, {3723, 3722, 3970, 1259, 2507}, {5138, 2123, 5140, 2963, 
          2964}, {2964, 2963, 5129, 2118, 5128}, {2516, 2165, 5197, 3722, 
          3723}, {3969, 1259, 3968, 3966, 3967}, {2712, 2711, 4640, 1714, 
          4639}}]}]}, 
      {RGBColor[0.993, 0.8525, 0.5782999999999999], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUDFOAlEUHHAlu3zcZdffCtl7aOEFKDyCB4CGGgItBWuCcYGCUFlyBltt
vYIJsVZC3MZ5mS1+/n/zZubN+/nj6GHYBNDjueD5CoBlCzg0gG4IrPi+If7m
gDv21jHwROw7EGecSNP2wG8KFOytyd2SV1F37gAbJ82J/ZL4LfkvvKeJfGa8
d06z/shZxJr5GQEfkd6G9TN5lm2gcQk8t1S/Jqpz9o+B8lwRr1Jx9vS+98It
r2W03cx35bRH5jXffAwPvXDrX3vltLyTWN7vkbCi/h/LZFls759Uf1hSO6/5
pht4+Vvef5qYNKU=
          "]], PolygonBox[CompressedData["
1:eJwlUDsOAQEUnBU27C7L7rYiexCFCygcwQEodBKFE/gEsduIQu0OSlpXkIga
ERozecVL5r03b2by0v6wNygAiFlFVhoBTgn4EbeI3w1g4QJHB1j6wCgEbiTe
WWPiL/cr7utl4BQAG89u15z9uNv7hqV5IH/LfuaahrQy9nP2D/aT0DjiSnPn
m6e8dfOk3rUCNGGcbgJ4iWmJUyb+BObf5iyvWSZlk8eL99PQvKRxoVZWM65u
lP3MWRWm2Uksk/j6Qc4sUWJemsXEfwTOL1Y=
          "]], 
         PolygonBox[{{3008, 1084, 3736, 3321, 3322}, {3322, 3321, 3738, 1085, 
          3009}}]}]}, 
      {RGBColor[0.999, 0.8674999999999999, 0.5969], EdgeForm[None], 
       GraphicsGroupBox[{
         PolygonBox[{{3009, 457, 3322}, {3964, 1068, 3715}, {3965, 434, 
          2969}, {4601, 434, 3963}, {4005, 437, 2977}, {2710, 866, 3737}, {
          3431, 866, 3973}, {3972, 437, 5057}, {5057, 437, 2976}, {3962, 433, 
          3955}, {3266, 718, 4602}, {3955, 433, 2968}, {4341, 718, 3721}, {
          4596, 1068, 2962}, {4597, 718, 3266}, {2971, 434, 4601}, {4012, 866,
           3431}, {2962, 1068, 4598}, {3322, 457, 3008}, {2970, 434, 3965}, {
          3715, 1068, 3720}, {2975, 437, 4005}, {4603, 866, 2710}, {3725, 718,
           4341}}], 
         PolygonBox[{{3973, 866, 437, 3972}, {2977, 437, 866, 4603}, {3721, 
          718, 434, 2971}, {4011, 457, 866, 4012}, {2968, 433, 1068, 4596}, {
          4598, 1068, 434, 2970}, {2969, 434, 718, 4597}, {4602, 718, 437, 
          2975}, {3720, 1068, 433, 2967}, {3963, 434, 1068, 3964}, {2976, 437,
           718, 3725}, {3737, 866, 457, 3009}}]}]}, 
      {RGBColor[1., 0.886, 0.63], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFUDFOAlEUHGUxBHQ3y35aE6yVSMIJTLyANRUHgANopyRaSGNBQWLstaRU
MRptLcQb0JhgDaUzmZ9Y/My8tzPvzdtmb3DS3wSwx1fiey6AnQrwSBzXgMME
uEyBhwxIysA98Zb96QawyoFz1ktqjgJwRv5Dfhp74rRiVlgv382W+6qFy8i7
3PlL/skwHeI3dy3obSf2SPMV3BtVrZVnl/Vxw3w/WK/80gnbcf4HM9RZvxIv
MvuHme+U7qXwXPmeCmeQXnneto3v7OcVf1OtGXnUXKfu3/HGde679G8mNWe4
Sn2TuHYoqzK3gjNp1zwYO1FzEP73/wH2Yj3+
          "]], 
         PolygonBox[{{3963, 1257, 1683, 4601}, {5166, 2140, 719, 5165}, {5061,
           719, 2066, 5062}, {3715, 14, 1257, 3964}, {2976, 1076, 2065, 
          5057}, {4341, 1493, 1076, 3725}, {3973, 1261, 30, 3431}, {4599, 436,
           1260, 4600}, {5053, 228, 2061, 5054}, {5332, 2066, 228, 5331}, {
          3721, 1073, 1493, 4341}, {4601, 1683, 1073, 2971}, {5056, 2061, 436,
           5055}, {5444, 30, 2140, 5445}, {5057, 2065, 1261, 3972}, {3720, 
          1072, 14, 3715}, {5186, 1260, 14, 2508}, {3431, 30, 1284, 
          4012}}]}]}, 
      {RGBColor[1., 0.9051999999999999, 0.6659999999999999], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNUbtOQkEUPBEv2WsIj+z6ATQmxmijX0CgUwp7Ch41NpD4Gcb/8QVipYkJ
xPgTJGghdDiTOQXFzZmdnTNnzt567+Z6uGdmx/gK+Cb7Zl+ZDiE36+P7hOC3
BBzMLpI0KYg/x7kH/IP7aTSLwCfgWodmt+hton5n6qH+Cvdj8H/AK/RkmNOu
mL0Af4C7BO4E6Znhvqge6rqolR3Mueyh38g931GH4BtJHDF55h34LszIvbbA
dwfKt65KTy/O5H1wzZFznMt75uH5EfuWgR9QlyVpW8j/FJXzGfUtavbMOXrR
Z1OTx7qmvrLvwrnR33aelGGR1Nt1TZ5Lz76+8/R89ffnfxh4fvqcJr3pmfvl
vtc/qCNAdw==
          "]], PolygonBox[CompressedData["
1:eJwlkLtKQ2EQhAfjkXM0eJTzi2BnY+OlUJ9ASCpjkT6F0To2Fvb2Kj6AT+I1
XjpBUMQnsAuoRWKn37DFwP7/zszO7mL3oN0bk7QAxsHFlLRUSGUu3VTScEZ6
gVDxfuD9CBJ1H/J9XTqZlAr4OXhN0hro0FdNWqFulNIf+mdwB3+dv136e+CH
9yn69yz8mmVorD3CrzEnjZj/kUUGZxnNSucTkdFZncFaz1xFe4zHYRGcX7h9
8u4Xkfmpihnm2/OM2fNoWvSG+H/idQVnOo+dvNsO/KwWHHO3QC+PGZ61XcZu
Xf426C2nuJV3HuD3luI2zuAsmyl2t+cX/dsqbm2PS+rvenj5Rr6V/9xzpmvq
f3OlOg8=
          "]]}]}, 
      {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
       GraphicsGroupBox[{
         PolygonBox[{{732, 243, 239}, {3302, 1225, 5143}, {243, 732, 235}, {
          1223, 774, 732}, {3312, 1230, 5172}, {732, 774, 235}, {5170, 774, 
          3313}, {247, 1495, 239}, {3265, 1217, 3909}, {1217, 732, 239}, {
          5060, 1495, 4342}, {3309, 2139, 5163}, {5143, 1225, 3918}, {2704, 
          229, 3910}, {3314, 774, 5170}, {5171, 1223, 3916}, {774, 1230, 
          235}, {1217, 1223, 732}, {239, 243, 15}, {247, 239, 15}, {1495, 247,
           229}, {3910, 229, 2703}, {1230, 1225, 235}, {2139, 1217, 239}, {
          4342, 1495, 4343}}], 
         PolygonBox[{{3313, 774, 1223, 5171}, {5172, 1230, 774, 3314}, {3918, 
          1225, 1230, 3312}, {3909, 1217, 2139, 3309}, {5059, 239, 1495, 
          5060}, {3916, 1223, 1217, 3265}, {5163, 2139, 239, 5059}, {4343, 
          1495, 229, 2704}}]}]}}, {{}, 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2703, 3910, 2704, 4343, 4342, 5060, 5059, 5163, 3309, 3909, 
          3265, 3916, 5171, 3313, 5170, 3314, 5172, 3312, 3918, 5143, 3302}]},
        
        "0.912`"],
       Annotation[#, 0.912, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2508, 5186, 3971, 4600, 4599, 2974, 5055, 5056, 5052, 5054, 
          5053, 2702, 5331, 5332, 5058, 5062, 5061, 3267, 5165, 5166, 5164, 
          5445, 5444}]},
        "0.864`"],
       Annotation[#, 0.864, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2967, 3720, 3715, 3964, 3963, 4601, 2971, 3721, 4341, 3725, 
          2976, 5057, 3972, 3973, 3431, 4012, 4011}]},
        "0.8160000000000001`"],
       Annotation[#, 0.8160000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3008, 3322, 3009, 3737, 2710, 4603, 2977, 4005, 2975, 4602, 
          3266, 4597, 2969, 3965, 2970, 4598, 2962, 4596, 2968, 3955, 3962}]},
        
        "0.768`"],
       Annotation[#, 0.768, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3714, 3710, 2506, 5185, 3956, 5130, 5128, 2964, 5138, 5139, 
          3967, 3969, 2507, 3723, 2516, 5198, 4007, 4641, 4639, 2712, 3739, 
          3320, 3738, 3321, 3736, 3735}]},
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3953, 3948, 2961, 4595, 2957, 5126, 3299, 3958, 3298, 3717, 
          5129, 2963, 5140, 3301, 3966, 3968, 3970, 3722, 5197, 5196, 4006, 
          3005, 4640, 2711, 3740, 3010, 3323, 4013, 4014, 3455, 4041, 4040}]},
        
        "0.672`"],
       Annotation[#, 0.672, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2505, 3954, 3947, 4594, 4593, 2956, 5125, 5127, 3957, 5124, 
          5123, 3716, 5136, 5137, 4000, 5142, 5141, 2972, 4637, 4638, 4008, 
          4636, 4635, 3432, 4644, 4645, 4033, 3011, 4646, 2728, 3763, 3035, 
          3330, 3034}]},
        "0.624`"],
       Annotation[#, 0.624, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2955, 3709, 3705, 5184, 5183, 3949, 3294, 5119, 2958, 5133, 
          3300, 3959, 3960, 3961, 3718, 5195, 5194, 4001, 3002, 4632, 2973, 
          4642, 4643, 4009, 4010, 2517, 3453, 2525, 5204, 4034, 4680, 4678, 
          2730, 3764, 3765, 3332, 4043, 2630, 3762}]},
        "0.5760000000000001`"],
       Annotation[#, 0.5760000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2503, 3946, 3940, 4592, 4591, 2951, 5117, 5118, 3950, 5116, 
          5115, 3711, 5131, 5132, 3995, 5135, 5134, 2965, 4631, 3001, 4002, 
          3000, 4630, 3724, 3732, 3006, 3450, 3007, 3734, 2726, 4676, 3031, 
          4036, 3030, 3457, 4679, 2729, 3766, 3036, 3331, 4042, 4044, 3469, 
          4075, 4074}]},
        "0.528`"],
       Annotation[#, 0.528, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2950, 3704, 3701, 5182, 5181, 3941, 3292, 5109, 2952, 5121, 
          3296, 3951, 3952, 2504, 3712, 2513, 5193, 3996, 4625, 4624, 2966, 
          4633, 4634, 4003, 4004, 2515, 3446, 2524, 4028, 3452, 3759, 2724, 
          3733, 2725, 4675, 4677, 4035, 4674, 4673, 3456, 4685, 4686, 4069, 
          4688, 4687, 2742, 3780, 3060, 3338, 3059}]},
        "0.48`"],
       Annotation[#, 0.48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2502, 3939, 3933, 4590, 4589, 2947, 5107, 5108, 3942, 5106, 
          5105, 3706, 5120, 3295, 3990, 3297, 5122, 2959, 4623, 2997, 3997, 
          2996, 4622, 3719, 3729, 3003, 3444, 3004, 3731, 2722, 4671, 3447, 
          4027, 3451, 3027, 3758, 2727, 4683, 3032, 4037, 4038, 4039, 3466, 
          2532, 5214, 4070, 4719, 4718, 2743, 3781, 3782, 3340, 4077, 2634, 
          3779}]},
        "0.432`"],
       Annotation[#, 0.432, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2946, 3700, 3698, 5180, 5179, 3934, 3291, 5104, 2948, 5112, 
          3293, 3943, 3944, 3945, 3707, 2511, 5192, 3991, 4621, 4620, 2960, 
          4627, 4628, 3998, 3999, 2514, 3442, 2523, 4026, 3445, 2720, 3730, 
          2721, 4670, 4672, 4029, 4669, 4668, 3454, 4681, 4682, 4064, 3033, 
          4684, 2740, 3774, 3057, 3335, 3056, 3773, 3471, 4721, 3472, 3061, 
          3339, 4076, 4078, 3490, 4097, 4096}]},
        "0.384`"],
       Annotation[#, 0.384, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2501, 3932, 3928, 4587, 4586, 2942, 5102, 5103, 3935, 5101, 
          5100, 3702, 5110, 5111, 3988, 5114, 5113, 2953, 4619, 2993, 3992, 
          2992, 4618, 3713, 4626, 2998, 4021, 2999, 4629, 2718, 3753, 3024, 
          3329, 3023, 3449, 2723, 5158, 3306, 4030, 4031, 4032, 3760, 5213, 
          5212, 4065, 4713, 4712, 2741, 3775, 3776, 3337, 4072, 2633, 3772, 
          3470, 4720, 4722, 4091, 4724, 4723, 2762, 3794, 3083, 3344, 3082}]},
        
        "0.336`"],
       Annotation[#, 0.336, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2941, 3697, 3694, 5178, 5177, 3929, 3289, 5094, 2943, 4588, 
          2949, 3936, 3937, 3938, 3429, 5191, 5190, 3989, 2989, 4616, 2954, 
          5146, 3303, 3993, 3994, 2512, 3727, 2521, 5203, 4022, 4667, 4666, 
          2719, 3756, 3327, 3754, 3328, 3752, 3751, 3448, 5156, 5157, 4058, 
          5160, 5159, 3028, 4711, 3053, 4066, 3052, 4710, 3467, 3468, 3058, 
          3336, 4071, 4073, 3488, 5224, 5223, 4092, 4751, 4750, 2763, 3797, 
          3798, 3345, 2638, 3793}]},
        "0.28800000000000003`"],
       Annotation[#, 0.28800000000000003`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVz7suhFEUhuFPHCaYMRMUhMZdjHtQaSQznUwhcSqmkIhWSBANhYJGqaNQ
CIlDISESRKUzGv89SDyKN+9ea39rZe+p+dXZla4kM1geShZw35/UR5O5atIZ
Sb6wPpj8cIGGfhMPcm35F95XtyrJwUCypnfIfcNJCd3oRQ823I3ZPY4LM5M8
gXP7p90/86X+E9fVbTvPzLyqN53feJu30DTXwKd8od+S/+BFXkJH//v/D953
JF/wMZ/gzs5bPHrnruwefmVL5WTH+VTm3X1ZfeVc4Ru+Rq2WVPEHVpwuHg==

          "]]},
        "0.24`"],
       Annotation[#, 0.24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzjkvhGEUhuFHoRhrLIV2/AfxO4xEbUkUEkapVGk0o9WoNAQZS2KUCkEt
iFhmEmImEgoKFS7Fnfs7zznnPV9xulxaaEsyjtNCMjqYTPQmrb6kiaXOpD6Q
NPCAJzyi3JO8chOr5u+6kjffy+bb+pNtrsi3OOrZ7qTAu+qqfI8XZWWU3BzD
ofxcPmLugIuylneP5bX/G/5v090GX6tX7FY7kh3ZPk/bm8G93hRPoqo3x+/e
+5R/8Lz6zPy6/W/ZBre7c2n2Ql7RX8OP3i/e3Dsy88U1vjJ3wrd8g7qdZ37B
kHzYW38BKTwc
          "]]},
        "0.192`"],
       Annotation[#, 0.192, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNzjlLg1EQheHRykQT18YqLr9AC/9BehEttBQULNQ0wcLKwoBg4QJ2Fi6g
RSoDVvYqoggG4oIRN76AbergUxzeOTNn5t7h+dWplbaImKXvbMR0OmIwE9FQ
J/TJf2GuK+JKP90TcYlnfRF1s0ezlFlFrwMf+CP1Dd5SVp2hO/W1/Ka9EjW7
IxYHvJOKODD/4Ov0Tn+dEQsyFfkts4Sv6TdwTv8eR+yOUlV/CHO0441jyttr
+cup+oQO+TF743QhPyn77N1lt/f5PdqlsrvtMhvY6o04x239vHzBnXX+t9+u
2yX9Gv7wS2av+MS/YBXfsCifuLOGM/IT7vwDTPw7wA==
          "]]},
        "0.14400000000000002`"],
       Annotation[#, 0.14400000000000002`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNz70vg2EUhvFTg8RnfY4kwuhrwWjgLxBLBwOLpIQIo43EpAumdkSYkJgY
LBaCNhJtJbWIVMxiIBJ+w5XrOec5537et2dueWopERGz6GqJ6Ea+KaKAvsaI
O+7lanPElfN+W8QBGswd8SFe6u24r/C5mTp3n3URZ84/yYhvJJ1r5eQ4iw17
CfWXuxreVF/bv5BziT0zu3iXs8Ov/Gy2jI+GiBnzD5ziN37ST3XINXsiZ0z/
Vv9R/4ZH1SvuBngQ/RjGEHLmM97M8qKZUzsl76Wd7zmj3saxnL/WiHX+5UPe
0p/w7iTSMhZQ9D+Vdt/E450R83oldV5d5AKXedV+Vc4aT8sZkfEP0rs/fA==

          "]]},
        "0.096`"],
       Annotation[#, 0.096, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzrsrxXEcxvGPlHI5bmEirIyUu5XNZVJEGUSJMiiTMjn+Aikml0EuG6t7
ylEog+UMpjMdIVLEy/Du+X6e5/N5fr/68dnBmZyImMRJfkRPZcRtUcRcYUSH
dyda0Y42TBRH3Mm7vO9pN523+14RsUXf6CadtrdAf8oiduhySUQSK5hKRDz6
Vp/dA3NjeUQD1gp45m+9P9jQsY4Z+03ySz0p+RVtNu/ZX5IN6XngP/OH+If8
fvMA8uS95iM92xiWjyArG6OjOP3voeGbi/RXz6q7C37SnMv/sP+JjP/elb3S
fXqAlN4bPNlP0xr7VfxqekzT/F09deai0ogEinEt+9JT7X3r/eE2azdDX+iZ
m3PUylvc/gFA70Fm
          "]]},
        "0.048`"],
       Annotation[#, 0.048, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzbsrBQAUBvBDkjd5pIjcDFyzxeZVJiXi7sqkyB+gEHmUwSSTYqKbLGLn
Lrg2pW7JTaKkUFJK+RlO3+uc7yQmZ0dnCiJiyvzjbV1EtiLisTBiqywiBzfh
FZwrj3ivj0g1RNTa/cD3eN+yffhJt/M7hBf0tcIdt0s1EZ28EXeDdBKfrozo
pftMi7sXP1thxt1ulR/4TXVEnh63f+RuRc8EfiIbolP4sp5+HQMmyX/V0wWf
3J3pmcLf9fzS8/bP3a3rWcBPZcP0Ir6tZxWumWJ5kZ4N/E6elpXwjmETP6c3
x3+AedPIH6Pv8VP8wN2haXSTsJ/G3+SXsmZeFnbzv+x/8DPyHrrtf9/8lEY8
2ymU/QG/1j1h
          "]]},
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0D1I1XEUxvETZGKZlnXRmyHplhK9DBFCbUFOda8VboG0FUVjCoEEDS3p
VmiQGdjb1HTbKsKGhnIJKq+WLzdJvZVv2U2iz3/48pzzPOec/49/Y+fl7KUN
EZHDUmXEb2RTEW9pe3XESqL6VbqMAzsjinQ//UEP0hH6d1tECWt4rX+zI+I2
zW2PyGwxa+4ULdI2WY+sV3aMt8A7Sudpk+yK7KqsmTfH20u/0/WaiHOytPfU
Yxf2bY2o9M60mXV1j7nH3vAIw6jgH3ermz+g78cdLG6OOMy/yO/T9+IWdvPq
sVARcdJMjZtVvtnmW/O8B/pVO98wixnkzBXouG9lzE3QMnN5ekI/bm9Mnsdn
TCSzifK/0kl8wTSmkppf5g2bsBFP3C+nZ2UrSe5uh7tn1E9l1707499kcRrt
uFcVMYhJs+/8n/cYRZ93zbh/3m61my/s37D/knbbK5nvon/oc/sFek3/j/6y
v4iC/Yfu/KS1btThphsf3EirL7hdrk/7b3ftfuSPuZVHyl5W/0n9TD0ov4+U
+QbzQ+o5+Yisy506/iH+K36Rv2Zvj6wRy+oljKpL9Ii5aXUrnaVNdgu0hTbj
PyIcd+s=
          "]]},
        RowBox[{"-", "0.048`"}]],
       Annotation[#, -0.048, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0DtI1XEYxvHXDmTeNUujUGgwCFqrwUmMzMtQbS1ZOjWoNJgKjUJTCdZ0
lGrRWlrTrl6wmzVEGE6Kig6CZFJ46Zwjfc7w5Xnf53l/7+//+59s67ramRMR
I2gujDhTGrF4OGIBuQURqeKIg3StKOK0LCc/Ykm9jHPmF+lZumPuq3qT/ka1
ugpb6g1nJu2bQoUdfUciZmTr/Ke8E86X85+oH+OFbJhekY+bHVLfl8/rj5fZ
YT6hr6RJ2U/+J/fM0WfOHpBt5nmTehRp33/XXCr7HvsGeX36FvMv9b3qe85M
6Ivt3zXXzevBHbzn98vf0SJ5uzOF9K0+n76hBbSNn0df6w/RV3SXt4cdbNvb
zLupvoHWrM/7R7/x92mpN6VpCc3Qy/xf3lJlXzUGfcdDPEKnPHE0osbsNdqh
/2M+KftLz5uvlX30hovqBjyXNdJLWOJn/It9XDeX0h+zpxLt2beix1wvpp2b
wS1eBR7wBvCd9wO3eaey/5M3hhXeKprsasGX8ojPmMUHd+3J0sigriSiHhP8
BjpJL9AN+h+kp2aS
          "]]},
        RowBox[{"-", "0.096`"}]],
       Annotation[#, -0.096, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0btLFmAUx/GjvoFpF99b6JsQEZqQmaaDuuiW2GWwy+AkNtWgQg7RWIsQ
CqWp/QkK6iaaUaKDNZi3ORwaolcaHAQbND8OP77n/M75Pc8Dz9Xe/q6+gogY
p9KSiMPzEUVYVxZxk+6di9hNRRSXRuTN7uivYQceX4hI8P9hEe7ya2RC/qc6
p66gK+pG+99wjfL296hSfZn+qvMyX91zy15G5mUmoikZ8Zs/om9U36bDsxEr
Mvt4hp+gcplp3hRNOuMjTdA4vTXfccYl2Yy9MV4WP+A2f8h8C7Pmz92ZwU19
Cjcwjc/4SfyhL8N1HJVPOec9Jk/f7O40FWZR/1+mQB20zD/w3gFeP1WbJ/g5
/px8jX4Gr+MsPjE7cMcfu83ua6VuXgt+N9+TS5g3eHs9PZCr4vXw3si8pqd2
c/5k3nyBFmmY34Y99o+cc8N8VV+Lr+y/4L/DNv0Wvx3H9HfTEZ20qP5Ev8w+
n/retISDZl3+8L7+IX5xzmN8RE0XI04AkhFMXA==
          "]]},
        RowBox[{"-", "0.14400000000000002`"}]],
       Annotation[#, -0.14400000000000002`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0T1I1AEYx/HnhkO77MVMHBry8rq8o9IGhzukQUhIqOygoJYgrgYHpbOX
xd3FqYZwdD4CtSEyFBpCoTGyTlq6q0hwCjqJSPvc8OX3vPye5/m/pO9OlSYT
ETGLakfEzcMR9w5GjByJKNNHXRGP8b4zYuF4xNVDEVeQ1S/pF/nn1TePRnzE
BzzjfYqeVMQECvwVuy/qXUcJ3eb2jrnFdx+v1E7YVxZf4/2qN07r9IVeFSn9
Mf0Z9/4eiLhtd1t3RDvW+Yb5N2hT/SXNyzvNPeCv4IZ6kjenvqi/jCXU1U/a
26C9dJr3IU6J+5DGaWTQdPcM7UcWeeSwq36Onsecm9/sGhA/seet9/8ur3nn
H3TFzTd4jbOeZYjvp/pzc6utuplb8jXxO7M75gb5NsUXaI1+xr6bfWa+iMO3
+cWXoFvmRvk+0Uu0oZ9U39e/LM/I79j/T77dmvUvE/jd+rf6f+iAvbu0SAv4
D5CxSyc=
          "]]},
        RowBox[{"-", "0.192`"}]],
       Annotation[#, -0.192, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVkTsvQ3EYxh8dJO05bSmKUYJKqieVCOJ06G3CJG5JEwkxk0hqkJQmPkOl
/QC2jmgHJhMjrUuYMIqEwS2lfmf45b08z/P+e+lb3Zhdb5GUhwmPtAevbdIL
XLRL52Cx24ZQlzQEmx1SyZRiPsmGGeYivhLUyCUMqUCfxTOAFoJBmPRKvX4p
gh4kl8KbhjVuW2gr+ONOHpLQZPcUkJ5hmnsmuTJ7g+rjc/gh1yntQMMtZbjj
YWeAG7xgwid7m/wXNUbdxf+L/5L7VxDm3QB3s+y3YAHfIW+G8Q5DAe2IeY5b
i2jH9FH2I7CPVmGeR1tCq9KfcbOVOcLdE2aLWmdXgz/ejZNLQJFsg0ySPs+7
N47u/P78Nk1qnew19ONLcSONz8V3P2C+ZX9KZhnfHf0j2XvqA4yiT+F/Z/cG
48xj8EHfTd7Ff9BD/cb7AzZaBv8/CvVFrg==
          "]]},
        RowBox[{"-", "0.24`"}]],
       Annotation[#, -0.24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0MsqhWEUgOFFyfmwt20zYOBcFCMztrOpYqSItjJRDCgugJkxRUjKVbgC
p+1Uwi1g6pR4DN7WWu+31vq//2vMLk8s5UXEKlIlEYmKiDKxryqiF9NlEd/l
EV8orIyYUnfKO1CkTpdGvCcjPtCjfysVkU3YxZ+o5+SzKLbzzUw714ZWjNj1
zD3h3vyMnlPzd/Jj5z/qYbND+m65Gxzx33w/P8hfczkc8l98hh/gr7hL7POf
///D9/Fn3LS6yTf71efqjHghvnAFzjbdYQOJmogqtPE1YhpJpFCN8FYV+sd8
YxRRHfFrT7f+fPm8vXliVqzV2+VNWtSr6maxwY56LNpRh2133MGDXY94wq57
ZMxOmm333uN2r5ldxwr2/u9uZsH5q/5reQ4Hzv4AjAw63w==
          "]]},
        RowBox[{"-", "0.28800000000000003`"}]],
       Annotation[#, -0.28800000000000003`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0Lsvw2EYxfGncWmVXrQkjCYkEmKSIBIGBrdSFRUDE4tuDHYSRptBRKz+
Af4GZv+AayLiEpPBp8M3533OOb/nfduerdrSbiIialjIRxSyEb2tEa25iI22
iJw5i2I6Ik3TdERvIBNRlf/QbzToV8z9zn1oMnfa81uIWOFvtkecdER8yIr8
P7sK9N18zF+X581Xdled15ByV4XeylfppWyFlpGULdIbWYleyBboPJplR/w5
56yd57IMnTUf8ofNJW969LZe97/SNzzhBc9IeF/OnhndaTQW/UYM6adoC5qQ
RDO69Lv1y7rL2LO/jz+qP4ZT91b4+/X/iD/pPQ/mKXpWfzdvDhP27PC3Me58
pr/o+wO7B3Gne48P+Se+cG33P00fMaY=
          "]]},
        RowBox[{"-", "0.336`"}]],
       Annotation[#, -0.336, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0DlKg1EUxfHrgJrBjIJoZyEIBhwCWglip4JgEkkKp6SyimDrUFjpJgQ3
ICIuwC047MIpTr2/FH/Od8877953v4nWYaXdExEHaKcjFocjFjCajZhKRRRo
EblMxEYuIkUn+QleEgn1EArJiAE6iIY+/bTeVZmOfn+FiJbMw0jEr+97vXbz
ETv4Vv/gCx3cOcubse2spscn7wO3/Cy/wa/y33lvuOFXeRW8qpvmXJpzgbKz
imyf9/RiXb2G1e4uRTtgzvuyNIc0MhjGmPy4Xg3ZOkq8aSzJz9MyZrr3MYuS
/L7cHrZwbu6K7JEeLXUTyzI1O0z5L5vOTt07wzGu5E/ooz2e0JF/oc+45v8D
xrYuwA==
          "]]},
        RowBox[{"-", "0.384`"}]],
       Annotation[#, -0.384, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNzz8vQ3EUxvFjYECrV3sNWv0TjSBpCZpY8QakiMUkqhSt1CSx2SXMLHZE
xMqr8H58hm+e3znPuc85t3Y8aPdHIqKD+njEYjYipbu5iM1MxGAyoqCXR24q
IkFLfwOp98JERIbXM1fOR1zQGq3rj/Hn6Sj/qRBxk/DU37KrdKh+1E/sG3j/
el/TL36fXiHHO6c/vB795JV9e+b9oNelc+oP/RKdtrvjhoSe0HV3rmFGfarO
0xQFlNxVkj9Li8i6N4MVOQ1+E8uopHbi0mwRDbNNVM1WsCN/39wB2ri3Z49u
mdnGi/pW/UyX5NzJWEXPzYf8rn0tOUdyXs29m/vzX2/0H+3oJPE=
          "]]},
        RowBox[{"-", "0.432`"}]],
       Annotation[#, -0.432, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzskuA2AUxfFrSylRUUPnIm1ISIyx1K2gK5WwkNCK1hDDws6wZ2HPA3gC
ESHivfws/rn3nnPu/b7C/mn9pCsi9rDSHfGA6aGIGbwMRrwlIhp9Edu4Nb+a
b9R73KHeG1FJRlRRk1nDlBsXKLlRxobcFjZR64lYUpfR6I94TkVkZDvIyxYw
z1vEAmblk27PqRm3d+xkZbP6HJr+s057dOcJB7xhe8cDEW2889Lmb94hb0Tf
snPOy7n5wR+ljeGIfkkv0j/p47Qfe017Gf0V7xpfvJz5l9f6/7c+4S8p/2y7
kdd31LJaRElmQp3EGT0tt+qNinnXrT/qsCUv
          "]]},
        RowBox[{"-", "0.48`"}]],
       Annotation[#, -0.48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwN0MsrxGEYxfFj6y6XDcWMpFihMCg2dlaKXDeyHhsLYgyaIaxdimLF1l4S
8X/5LE7f9zznvE+/31vY2VsuNyRZoWpzstCSzFNfWzLXlPTiiflwa7LVngxi
ybzHfBoL/ENXctORTPLfOtfOV1RsTC7wV36JX7I61qggO8Mf2Tl+yk6xSgOy
e/MT5wk7P2TjWOHvzJf4Q99U7E5mO5M//lh2RCW+7H4/3epuyg50Z8wX7VjD
Or+KNRyyY1/3SfeRdvUvzNflK/qn+MxXcVR3hCr6Y7Th3zdpyltM0rZ3e9V7
oxd6d+8fhjUpvw==
          "]]},
        RowBox[{"-", "0.528`"}]],
       Annotation[#, -0.528, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzk0rBFAUxvHH1luED2ChRNiY1MQwzAw7hVJiFmwUzVh7KcVkiE/Axsja
tyCUz+Q3i3/PPf97zr1n/LC51ehJsomZ3qQwmEzI+lBSHkiu+5NpbgobI8mZ
u5/RZN35T0+xL3kaTq701bgqfvkF/pG/5CvcGr75At/mL/hVrowvfp6/4ZfU
i2j6p+T/c30l9QqWMWePSXfPej/t8dJN8zXz++7b+vfknayar6CuflDvynt5
0N3TO6fmTnCEV/6W39a/g463G3yHb/HH3n+XH+q37h5jySxadiniH6TfJt4=

          "]]},
        RowBox[{"-", "0.5760000000000001`"}]],
       Annotation[#, -0.5760000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3250, 5028, 3251, 5036, 3422, 5033, 3249, 4205, 4220, 2619, 
          3676, 5001, 5002, 5000, 5004, 5003, 3413, 4998, 4999, 4207, 4208, 
          2610, 3654, 4963, 3212, 4955, 3213, 3398, 2677, 5414, 3211, 4959, 
          4962, 4961, 2887, 3866, 2888, 3632, 5277, 5278, 4509, 4510, 4296, 
          4512, 5319, 4511, 2601, 4514, 4515, 4298, 4518, 5320, 4516, 2602, 
          4519, 4520, 4301, 4524, 5321, 4522, 2603, 4527, 4528, 4303, 4531, 
          5323, 4530, 2604, 3635, 3636, 3870, 3869, 2894, 3638, 4197}]},
        RowBox[{"-", "0.624`"}]],
       Annotation[#, -0.624, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2620, 2694, 5424, 5425, 5032, 5035, 5034, 2921, 5005, 5006, 
          4209, 5283, 2611, 2686, 3883, 3884, 3655, 2902, 3887, 3414, 5007, 
          5008, 4210, 4211, 2612, 3656, 4966, 3214, 4960, 3215, 3399, 2678, 
          4964, 4965, 4513, 2889, 4315, 4967, 4968, 3216, 3633, 2890, 3874, 
          3400, 4970, 3217, 4517, 5279, 4521, 2891, 4300, 2892, 4523, 5280, 
          4529, 3220, 4973, 2893, 4320, 4974, 4975, 3221, 3640, 2895, 3876, 
          3402, 3403, 3222}]},
        RowBox[{"-", "0.672`"}]],
       Annotation[#, -0.672, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2615, 3663, 4199, 4198, 3404, 3223, 3641, 3639, 4977, 2681, 
          5326, 4976, 4319, 4533, 4532, 4972, 2680, 5325, 4971, 4317, 4526, 
          4525, 4969, 2679, 3401, 3219, 3634, 3218, 3873, 3660, 2613, 4542, 
          5324, 4543, 4316, 2904, 4541, 5286, 4214, 5011, 5010, 3415, 3889, 
          2903, 3657, 3886, 3885, 2687, 5285, 5284, 4213, 3235, 5009, 2922, 
          5039, 3253, 5037, 3252, 5426, 2695, 4222, 4221}]},
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3255, 5038, 3256, 5041, 3423, 5040, 3254, 4212, 4223, 4224, 
          3677, 3678, 3236, 4216, 5287, 5288, 2688, 3888, 3658, 3659, 3891, 
          3890, 3416, 3417, 3237, 4545, 3238, 5013, 2905, 3875, 2906, 3661, 
          5290, 4547, 2907, 4318, 2908, 4548, 5291, 4550, 2910, 4321, 2911, 
          4551, 5292, 3662, 2913, 3877, 2914, 3664, 4219}]},
        RowBox[{"-", "0.768`"}]],
       Annotation[#, -0.768, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2621, 2696, 3896, 3679, 3680, 3899, 3898, 3424, 5042, 3257, 
          4215, 4225, 3681, 2923, 5014, 3239, 4218, 5289, 2614, 2689, 5012, 
          4544, 4546, 4325, 5015, 5327, 2690, 5016, 5017, 4549, 2909, 4327, 
          5018, 5019, 3240, 4552, 2912, 4329, 5020, 5021, 3241, 3665, 2915, 
          3912, 3418, 3419, 3242}]},
        RowBox[{"-", "0.8160000000000001`"}]],
       Annotation[#, -0.8160000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2622, 2697, 3897, 3682, 3683, 3901, 3900, 3425, 5044, 3258, 
          4217, 5294, 4566, 2924, 4326, 2925, 4567, 5295, 2624, 4570, 4571, 
          4328, 4574, 5328, 4572, 2625, 4575, 4576, 4331, 4579, 5329, 5455, 
          5454, 2626, 5297, 5298, 5067, 5070, 5069, 3271, 5073, 5074, 5072, 
          5300, 5299, 2627}]},
        RowBox[{"-", "0.864`"}]],
       Annotation[#, -0.864, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2623, 2698, 5043, 4568, 4569, 4339, 5045, 5046, 3259, 3684, 
          2926, 3904, 3426, 5048, 5049, 4573, 5296, 4577, 2927, 4330, 2928, 
          4578, 5068, 5071, 5427, 3272, 4351, 5333, 5334, 3913, 4353, 4352, 
          5076, 3276, 3915, 3914, 3922}]},
        RowBox[{"-", "0.912`"}]],
       Annotation[#, -0.912, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3902, 3903, 3685, 3260, 3427, 2699, 5047, 4580, 4581, 4340, 
          5050, 5330, 2700, 5051, 3261, 5075, 3273, 4350, 4354, 4355, 3274, 
          5428, 5429, 5335, 5336, 2706, 3917, 2707, 5338, 5337, 5431, 5430, 
          5446}]},
        RowBox[{"-", "0.96`"}]],
       Annotation[#, -0.96, "Tooltip"]& ], {}, {}}}], 
   {GrayLevel[0], PointSize[Large], 
    PointBox[NCache[{Rational[1, 2], Rational[1, 3]}, {0.5, 
      0.3333333333333333}]]}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxFxXss1AEcAPDDVnlOltPPjOiyYWKcNhWpRNJV7oiaZF7LKFq0rtqadJY8
IlbRaXROJXMnKpXH4eZUdJw7brrunM77cjHHZh7VH77fPz77OMal0RMNSSQS
7Z//n0icGhBMR/hvPll/Nk5FUA9tTjaVFTYSgfBe3x3cCiIc3t/vzX9EJMCC
Z10+BUQGnJ2Vd+MBcQ9OyNARuUQpvK00pOrPfDX8od8rONieB0dlK0a68prg
tIZr7k8XP8ILRUM9BgbtcE9Hd7v4YCeczAwxP6cVwh3GXht1l0VwDUe4brvn
KxxAbn3BqO+F3UWK5m5XMSwNYMy9nuuHU01SJDJPCfxNHtlqUTgIM4Ki1BqN
FN5XmRdZSRmCR9dLpJfuDMPjIWIOuUsO88tUzAHHEZh73yjX5eYPWB9/fibp
swI2DcyhN9go4duW42bqaBVs1uZGGqaNwn7XT691reDs6nzObrYajomg9hmH
jsHvZIklbUu4by/fcOLxL3jXsSR9SaAG9qH6FDdN4KqFgi8c1jis9Q5jEV4T
sPOs+4zBIC6kZErSsybhh1JZPJ0yBesYgmJDIf42wvqo79VpmNOXXTFmNQMv
i6JvWXXio8Xtessrs/DSwAHiroUWTi91EjBbcJs+J0tNzG+YIatbtVvHFy5W
pSpq5+D2WB7L4qQO/iRODVWewt/7u26vD8Pr7LhsWiReLi9vzI/DM8/kqE2Y
uFvABb+tNbgzz9Zo+BXuZC/vqXmD71ylhwc14Fuaj6ewWnC1B7XMaBBXPJ+P
GZThcnMehSPHv8+68I8o8ZaXDqKsabyZ/DM/TIs3ssrpjjq8Nt5aKVjEuRIJ
p2gZrzxclBy7grP5NA/PNfyJg6l+YwP/CxUIhds=
      "]]}}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJxdlnk0lG8fxkkyUgqlLC2WhFJKpRRXZKlkTRtGIUneJFlqqFCS5SfiR6KS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      "]]}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.608659922092493*^9, 3.608659958387548*^9}, 
   3.6086600242709923`*^9, 3.6086601183105164`*^9, {3.6086601621427107`*^9, 
   3.608660168706111*^9}, {3.60866043639686*^9, 3.608660443917066*^9}, 
   3.608660565171238*^9, 3.6087335619258003`*^9, {3.608733615593721*^9, 
   3.608733643310297*^9}, 3.608733673912527*^9, 3.608753726149931*^9, 
   3.608753866415155*^9, 3.653242793528283*^9, 3.6532436123780603`*^9, 
   3.653243705720566*^9, 
   3.6534842794918623`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "\n\n\nLet\[CloseCurlyQuote]s set about doing that problem quantitatively:  \
Define the bottom boundary by means of the parametric equations:\n\n",
 Cell[BoxData[{
  FormBox[
   RowBox[{
    RowBox[{"x", "(", "t", ")"}], "=", "t"}], 
   TraditionalForm], "\[IndentingNewLine]", 
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"y", "(", "t", ")"}], "=", 
     RowBox[{"t", "^", "2"}]}], "\[IndentingNewLine]"}], 
   TraditionalForm], "\[IndentingNewLine]", 
  FormBox[
   RowBox[{"Then", ",", " ", 
    RowBox[{
    "the", " ", "height", " ", "of", " ", "the", " ", "surface", " ", "above",
      " ", "some", " ", "position", " ", "on", " ", "this", " ", "line", " ", 
     "is", " ", "a", " ", "function", " ", "of", " ", "the", " ", "parameter",
      " ", Cell[TextData[{
      Cell[BoxData[
       FormBox["t", TraditionalForm]]],
      " given by ",
      Cell[BoxData[
       FormBox[
        RowBox[{"\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"f", "(", 
           RowBox[{
            RowBox[{"x", "(", "t", ")"}], ",", 
            RowBox[{"y", "(", "t", ")"}]}], ")"}], "=", 
          RowBox[{
           RowBox[{
            SuperscriptBox["x", "2"], "-", 
            RowBox[{"2", "xy"}]}], "=", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", "t", ")"}], "2"], "-", 
             RowBox[{"2", 
              RowBox[{"(", "t", ")"}], 
              RowBox[{"(", 
               SuperscriptBox["t", "2"], ")"}]}]}], "=", 
            RowBox[{
             SuperscriptBox["t", "2"], "-", 
             RowBox[{"2", 
              SuperscriptBox["t", "3"]}]}]}]}]}]}], TraditionalForm]]]
     }]], " "}]}], TraditionalForm]}]]
}], "Text",
 CellChangeTimes->{{3.6086607552945147`*^9, 3.608661040704835*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myHeight", "=", 
  RowBox[{"myT", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "t"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"t", "^", "2"}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.608660221035777*^9, 3.608660259790311*^9}}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["t", "2"], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["t", "3"]}]}]], "Output",
 CellChangeTimes->{3.608660260385378*^9, 3.608660565416794*^9, 
  3.6087537264945583`*^9, 3.6087538666644287`*^9, 3.653243617499312*^9, 
  3.653243705909086*^9, 3.653484288057685*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "2"}], "-", 
    RowBox[{"2", 
     RowBox[{"t", "^", "3"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.608660271984429*^9, 3.60866029056781*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
    1.], LineBox[CompressedData["
1:eJwdl3k8VOsfx9GmtJCuiGyhQpLoSpmP1ptulCxRqGyVStqIihRuSUoku5lj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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->{{0, 1}, {-0.9999999183673491, 0.03703701440342458}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.6086602914651003`*^9, 3.608660565467836*^9, 
  3.608753726545908*^9, 3.608753866715364*^9, 3.653243621304091*^9, 
  3.653243706071566*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"t", "^", "2"}], "-", 
       RowBox[{"2", 
        RowBox[{"t", "^", "3"}]}]}], ",", "t"}], "]"}], "\[Equal]", "0"}], 
   ",", "t"}], "]"}]], "Input",
 CellChangeTimes->{{3.608660316543076*^9, 3.608660341314159*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     FractionBox["1", "3"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.60866034216335*^9, 3.608660565495216*^9, 
  3.608753726593877*^9, 3.608753866763896*^9, 3.6532436245369377`*^9, 
  3.653243706120537*^9}]
}, Open  ]],

Cell[TextData[{
 "\[LineSeparator]\[LineSeparator]\[LineSeparator]So, the highest point along \
this line occurs when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", 
    RowBox[{"1", "/", "3"}]}], TraditionalForm]]],
 ".  Find ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "(", 
    RowBox[{"1", "/", "3"}], ")"}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "(", 
    RowBox[{"1", "/", "3"}], ")"}], TraditionalForm]]],
 "..."
}], "Text",
 CellChangeTimes->{{3.608661078317647*^9, 3.608661152561672*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myPeak", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"t", "^", "2"}]}], "}"}], "/.", 
   RowBox[{"t", "\[Rule]", 
    RowBox[{"1", "/", "3"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6086603612751904`*^9, 3.608660393876622*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "3"], ",", 
   FractionBox["1", "9"]}], "}"}]], "Output",
 CellChangeTimes->{3.608660396402508*^9, 3.608660565533351*^9, 
  3.608753726644991*^9, 3.608753866813854*^9, 3.6532436283215313`*^9, 
  3.653243706251347*^9, 3.6534860577082243`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"myPeakpoint", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
      RowBox[{"Point", "[", "myPeak", "]"}]}], "}"}], "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.653486003607263*^9, 3.653486031867518*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"Show", "[", "\[IndentingNewLine]", 
   RowBox[{"myCP", ",", "myPoint", ",", "myBound", ",", "myQuad"}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.6086604696947727`*^9, 3.608660539595953*^9}, {
   3.653486027966539*^9, 3.6534860413539352`*^9}, 3.653486114319201*^9}],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJyEfQVYlM/zOGAndmB3dweOLQa2Ynd3t9jdmIgFBiImIiIlndLdF9wdHMcd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    "], {{
      {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1ULtOAgEQnByaeHJyELgPMOETfHTS0dH4CRJa/RA7+AXvG0xAaqKtJso1
YKKFpYkUNIaZzFJsZrM7Ozu7pzd317cJgC6jxqinwJb4w5gcA7/EQQ68ZEBF
Yq0FLBP31zC3wZlPYp4618wXeSviYxvIUutqftkxryKeFa5Ju0xd34SedKUz
PAEW5DyR896x1nlhzkPsLSNXTV41N6b3JLz+N61dBqdHzuwAuMo9V8bey8I8
efyIXdqpeek808Or7jkC5plR9f0f6nG7MItc/Sr+pRt0y6jhmniq77Vmbf9L
f7un/ynzt0Pgr+lQ/s2b+oX9XhB3UYhFdQ==
          "]], 
         PolygonBox[{{3685, 711, 1211, 3903}, {2700, 224, 2311, 5330}, {4355, 
          730, 729, 4354}, {5429, 2316, 730, 5428}, {5051, 2060, 224, 2700}, {
          2706, 241, 2316, 5336}, {4581, 1492, 223, 4580}, {5338, 2319, 241, 
          2707}, {5330, 2311, 1492, 5050}, {3273, 729, 2060, 5075}, {2699, 
          223, 711, 3427}, {5430, 245, 2319, 5431}}]}]}, 
      {RGBColor[0.18832000000000004`, 0.35240000000000005`, 0.57776], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUbtKA1EQnUSN+8hr2d1OUL/BF1bptcsHWPgotEhs/QELtVL8D0EUH71E
CAhGJYrZZEVBBCt/wHM4t7jMzJ0zZ87MzK63m62imS3jjeEVI7NsAj7sGj4C
z+wOgOtY/hVsB3EI/7RglsPvjJsNYfdLZr7DPybCHAVme77ZDp4Hvp+66tqh
csTcgnMb+Rn4I9TexPonB7W8431D2yT+SsD1EDdrZr/4W4HtAT+N3H1Z9eQh
/iyRlgFm6cOvoPYYPfuIB8ifo26jojkPA8X8PwjUM/DFc4K4Dv8t0Yzk5AzU
Qk0ZMJex/ItYtdTDPc2nmm0BtoWZPexqsyqs52q7bqcfkXZJnZzDqBNchUia
qK0B+5JI2zNsBzNPgWcu1Q1YR828A+eiVuapiT2eYnGSO4+U5544H3vzntRF
ndS2WhNvt6wcfe79r647vEbqzR4PsW7MWxO7G2pPvDlvkrk7LqXCLKbC546T
uoZO/2ekXX/BNmrSs1WVxpHT8Q98RWV0
          "]], PolygonBox[CompressedData["
1:eJwtUUsvQ2EQPb1tua/Sm9u7k2DhH3jssJIgNn6ARbFg0dr6AzZ2xE/xbG2l
pIlFPVpxS4XExoo1zuR08SXzzZw558zMeLm6WnEATPDl+LIR0M0DYy5wEwJL
w8AX8y8ELTP+YH1vADjKAD9F4KkEFD2gx3qH8QoxjZxyhz7wS8xzXpwOe++J
8T3l/lhbJP4Tyj2UxGFc2/zPJMABOQqeOI27GcpLyv67GHgk/tURps24xlxA
7w3mLol9ixSb351AmqY9YhjWywVgLQvUyT9P/s0hwM3pX2e9w/4W8Sk9thlv
9Osu+2usVwNxX1GjF2kn9jcPF/QyxRm2PHk0r/u+9DzWT1k/4/Nd5czLLD10
IY05xrdx3yv7m7FmsniUuVYsD+ZlkO8k1s3sdqY5Se3pRLvc5VtIpGnadsP3
SDPbrKZX4SzHsbhs5m/Okom0a7uR3eo6lLbt0G5rO7J+879O/2mkXdhM5+T6
BwU/Wao=
          "]]}]}, 
      {RGBColor[0.21856, 0.36920000000000003`, 0.6060800000000001], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFUssuQ1EU3aWVtrd63ZxrokmTfoakpFMkJOYGGloDWlNDr4EYEp9BaAk1
9IhBi4pHUa96/IA51s46icHJ2nfftdfee52TyhZHC20iksZpx8lFRD7CIndI
toALHSIniKeQ/8R3A/Eq4h7Ey/j36oksAV+AbzYuOqzR2vWASLaTuG9Ebn38
C4oMuCJ56JwGqak9c1a3gtwYhjlGfs9Q6zCGWugfId6ERiJMHZ3zCpwkvuvA
jPvfsxdxEzutRFmvOhNxkbMY6367RL5w1sCfdthzI8S++k85N+g1jz1CYfb+
tvxdw5knI+TNOMyrnuYS1sNHjz48AIe76d0IMBOlv1vQH3LpwyDwGrop5Ksx
5tSjH+hcgrcInWeP++ssc+iVjXNH3fXAkPMETsPj3PceecqvQLNsuOc4/Kn7
vMN3jx6pTj9wx+du2z77673rDCWfcdneYdK+B0V9HxrXgpxb+Yopy9G6vOWo
lzqDzjTrcIaWnVdz6mPa5TvoA1YN38UFsOlxR/VD35DOEUCu4PDe9f5rhv6f
A/8AQLB3gg==
          "]], PolygonBox[CompressedData["
1:eJwtUUsvg1EUnFbbfP1U68vXbkgkXfkBtsRrR0LSvYV6xIL6DV4blsTf8GgJ
3VIkWlRo6x1FYm8v5mQsbjL3zpwzc85NZxczuSCAbp4QTzEGnPBhogUo+MB9
EqjzXiJZI55vBTYD0tQ84JKamSjw6QD75A988SXyh8RTceCU+Jm9s8Q3fJuj
vov6W+KAp94NC0HckwJmo/K8YJZrajocvRl3xXunI0/zno7La4ueOWar+upt
Pc9jOoatpkJu0AU+iFcizES/vaSym8eQqwyWJc37HfU75JuOPOrkyjFxZ+w5
mgBGEsIVngxxnjVh8kvs3/BUY7W2kwXme+N9NaIMlqXA/l+OdmK7eSS/HJHn
gKtMlm2D/Bjnf/GU3ep3Wbvu6q/M07z7mKEY0s5t9/3kt8PSmLbJ+rWIepap
n2wTZzW9rB2m5jeoTHn2f/33s/1+twNHvrC9HfvKYFlspndqHzzNbvP+UD+e
UnbzrCbVw+ptxidq/wALtGRd
          "]], 
         PolygonBox[{{4331, 4330, 2927, 1668, 4576}, {4579, 1669, 2928, 4330, 
          4331}}]}]}, 
      {RGBColor[0.24879999999999997`, 0.386, 0.6344], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUztPVGEQHXFf3F129+a7FBQU/AljeCQILdFAsYVgYHdbhIpAaBQrEzoi
b62NFeFRLFZCMJqwuwIFJEAAQ0yMhkdv4zk5X3EzszNn5jtnZratND4w1mBm
ffge4vuVN6vGzXZDs8EmswKCz2HvkmbxRrM6cjfwY/Br8F8nUAf/B2q3nFki
ZfY5I8wtvgPEZ+OKzz0w24jMWuDvO/W48ZiewOwQdh35D07vvYdtTYnDEXLD
WbMz2Mc5YCPxedZs9g/5vZjZMYS8DYTpgv0CDXX479DnT1I8yGEGGneAncwr
R8wM8Bvwh9BrBHorMfnEfYpUOw18MasYe5TgJ4ErZ6V1KiEtnN+rhPqeh4o9
Qf9yWlz7gT8OhRlF7GmztHMGP1N6i7UHXv+W18qZEEd77/12zGIbHDpy0sC6
R7A1p3l8y0gnOW/DP/I92Zt7IB/iVp12sQK75LTPN4H2RFzdaQ+sJb7stXfh
3bNQt/A7r37Ek9vLtO7jJNQs53lXDeLL3/SpgzXEc368L86LvPnOId79ivoJ
5Jad5sj8JWIfM9rrAuIv0sIQ2x2I/yn8zUi30xsoT57MkTtnwnvgPfFmeDtX
oTj8hZbOnPJF3MNIWvy+h6qt+HreXcHPkPrZ/8LvlrvkPhadboL/Lc6CM1mL
9L+hX/Xv8d3rUP02Y+L9H79hlIo=
          "]], PolygonBox[CompressedData["
1:eJwtkjksRHEQxsfagz14L7sKhUKvljijVBEKhSPsKl2VBA3RiU7ipnYUhN3C
qhCFwq5dhQJxREJIHL3Gb8wWk/fNf76Zb45XnRjrHPWISA3mxVIxkaoSkWtw
EtwcFFn0ifQWi8yBXx2RS/wZv8hISKSWtyzced524O/HLHbFWwux2aDh4lK+
xDrKRH6p9ROAHxa5cEUm4H/hb+M/4Geo5YWfg/+Cn8X34efx3xyLj5PTh/6t
a/X17Q78iOXEcp7A745h1RiAP+VYrx/obYVtJp3tiOHrykUasDT4jKUM0Otq
1LRUYwV85tr8OvOJazmaG8AS8DfgfAdMU7Xz+Deewk7Bu2gm4Xah2RNBI2L6
qllPrVbs3Gs7GqTf7ohx9U1jk4X+n6m3F7Metdc7+ukHp6l/6rGah+gNU2Pa
bz3r7XTnunvtcTNqO/7fNfn3zLMUtd0sFIkMhUxDtbTGjWs31FtqvWW4Wayy
xGbMgOMRy/XzlsI/gJ8X4xzG7MZ6609snfhx2Lg6k87WXlG4NTlt4KZy263W
bASvRS1X763/gvaoMZ05zvx/iXFyZA==
          "]]}]}, 
      {RGBColor[0.28026, 0.4022, 0.65432], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUssrxFEY/TAemd/85jf95h+Q7EVZsFZShFIYzGCpKFmxIAuP2cn7tTXj
kbzyWBHCRtZSymoSf4RzOndx+7577/edc75zb9XweNdYsZk1Y5VgFcrNsqVm
y0VmP4HZIuJuaNYbM+tGQQ/iH2p+sc7QmML+EvHQM8v4ZqURs6a4WV/UbB69
1chT6FsB5j3qdoB1jpj3VHuNdYf9RBn4ytXz7XgHgXGYFE8bsIexX8J5DTAn
A/VdAWczlKYtxMeE6tm3FgpzHzUH2H9WmDVUQkdCfA+IaaeZ2keBX4Z8HX0D
2EeQzwbiI+9QVPNQYy/yPDA/gJlLqm8VM77Bw9NQM6djwqCn9HM6kFcdwK4D
zjnu6uPyldpOi4WRdTiMxGfe4jT0AbM2rrNZzHIM7gv0vWCWo6S8fUKeicpD
vuGgm4Uz0W9qo3fkJzd5bzy9z0koP3hPzdzz/Br3OU+1U8D8wlrAfQo8M+4t
+CYj7o2odyCqmkKgPnpE3UO+cvrNGSMV4jrwNEunLzxq5jl9pOYzaGn3VcO5
G+O6z8T0nzj7K2Zv9cVDn54TOqc3Bad5m38wFO8t+vqdTs7Ev/Pr/uF7Uvkc
fN4LxUuNG6HOeZ92PvPP/gPOlHpt
          "]], PolygonBox[CompressedData["
1:eJwtkskuRGEQhQvdiNvdunO9gL0ViQjxAoQgkdBttiexITaGhWkn5mmHZkcT
w8o8bDyAWAvCQ/hOqhd/UueeqnPOX/+tHBrtGCk0sypOhHOfMhsrNpsrMPtM
mtWWmX2UmnUWmc1QP8GfMjAP3xuYZSvM3uGXomYT9E9yTgp95hiuOeH4De0m
6ppys1zEv4lr55xRL6I3jN4r+jnwAngAPF3ms/I4Qi8TuLcyPNA7g98q3sVo
DqK1HzP7KuEu4D7wbuha8tij7or7XZShmix9gfPyfEZvO3R94R3qdNyznYMz
1C8p19JMP7NtCefUM6S8Sfe+4dsUdUvCs2qfafiLmHMZMpyg/5i/rzx74BvI
FGV+GVxf7jtX3m/utEp/I3gl6vML1Acx59TTTb7BwLMoYyve40l/G+1Iu7qm
P5J/L3F3+feWhrTq8LyMeIb+hL+perVT7Vae8laPetdD373eMws/C/9L7x9n
E+409P5b+Cv4rdA57UT/ku4kb2W4Tfk/p11JYwOuO3D8A14DH8a8Vr+yD8R9
V7pTDv4f0Pxo2g==
          "]]}]}, 
      {RGBColor[0.31782, 0.4154, 0.63224], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1U01PU1EQnZa2FN7j9d08+AH8AF3UhfEnIBWIIdECwdCFxmgUoimwQNiY
uIQSQly4kgIbKCRA2CACxo+EvQnhY6X/AL82ek7OdfEyc+fOnDlz5r7OytPb
T9JmVsbXhO+jM6vmzIYDs9O82S8E3yO+kJj9hF9GvLMgvxSZrbab9cOfaTU7
ySveAGC5TbYeml0itg7/GDirGbPfOL/BeSOj2jX4e052GXgTsfJX4D8Hl1SL
2YGphrWH8Icj5SwB/1lOXMmT9+d55RCLmFXgjeXEj5x6IuWNYJYi/NeI1UL1
Yb/PWWGM54Rz3K76fXBMtyj+JSttWMu+1OwsL56cdzMjfj/8fC9Twmh4fxf9
mpC/CV3HEvWZhIbfms1eAXs2pVpqxPpaVnFquIXaCngUO8weJuo/jtp5+N9R
X4O9H0uvEvbwNhTuXCK9yIsaU3vmE59c/jarb7EgjndR+wJ5c+g7BXvgxH85
1F7pM3alIF7TrcJIA+sE5wb6Gfxtz5d3jNMyzl6cKeX9jUT+DvJ7sZc/4PcA
fR8n0nUC+NcjaUXNRhPt4QI5p7HnHEj7fv/mpmNpNwPbFWk3VwvaIXdJrKFA
e/+AWerY9VdwWILtjrSDa8h/lOhdnMWyfHPUnTtnLfmRB/lsO9mqj79z2j3f
0XyoN1P08/F/4J4qgc59iHe1KYe5R069BnF/JxB/zjEQ6P3dgn/T8yTfekb/
IOv/c10Hxr1AM39y0pwzcmfEYA3zt5z4Uu/FULxuAHPNaVa+Nb4nxnn/D+21
qtg=
          "]], PolygonBox[CompressedData["
1:eJwtk0lrVFEQhatfosb3Ot3v0e0PCOJS0YgE/QeKEyKYOCTYCwUFB4yJIphs
RBcuTMSFC1caDWp3EojDxlkcQN0KIQZc6D9w3Oh3OFk8uHVP3TrnVNXrahzf
dSyJiE187XyjecT4kogPnA9UIrby/WqLmOuI2JBGbCP+TTxPfLce8bqIGFwa
8YX4HvF9vgXOf8jZXvGdsCFy3pDbrEX8WxbRWB4xW444Q80XcJWIP5I7kpr7
M28miAc6I66UwImneTvOm+uJNXVVibn7Tr3dxHvIfQSedJijBbYTDX/BLuPp
HN6OZK4X5EyBPyy79iXwwdye5O0Uel+h91bdWoSfzt0D9eIk+FPwIe6aiTVc
rbmGctXDEc698F0oOedJ4RrCv5F/s+wey28LvJ/zaGov0wxjLf5ukzO16Pda
zR6Fz4CvA39WWIs45qm9irvJdntuwN2fuffv4fyau6Zq/wTfAl9f5toT3K0E
e1A4VzOZLTwTzeYdd0fhP5h5tuIQV2txnm305HHZmqTth+ZBbqvw2+fUa3Lu
XuHZzxFfxOtwakwz3Yy39VVrk59uzhvReAPsJTk9FXuQvmE8DVB/IXd97eD+
zDVVe4y782BnU79N4PyEl5matWoHtFu9neZSj/s4r6lau2ayWv0oe1fkUbt7
p+5ZaQaTnA/n7rU0HsrNIS5pPEH+vsy7JI3Sqh6r1/qH9oK9LexF/4z+nbGa
d0P6tKs9qXdXHDvw/x9nw48s
          "]]}]}, 
      {RGBColor[0.35538000000000003`, 0.42860000000000004`, 0.61016], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVM9LVFEY/dJJ613fNI87/QGuy2jK0KC9P2ZCMMhoJWKaE6kRaS6yTSUu
0rSIaJMxKdbkRKDLp4t+KVbrgpYF7XXVqnM4d/H87tzv1/nO+a7NA2O9o3Vm
NoivHt9l/NnExfwBsz84VzJmW7h/mZgNNJhd8WZPmsyeI+Y97pqPKGYRd6vw
/Ws0Kxw1O4b7XeRNR2at+GYOmt3MmV1DzDZivuXNzkSqXcqiH/KfomY//B/h
t8NmX5BzNfwehh1H/x+HgA/u78jfxf0Uaox5nUdhK6jzFnVuoVcZv4uYoTNG
PnI/I+ZZnc60U5hxJtLMp4B5CPH7jAeePdh3GdVaRq8L+H03EgfERQzLieos
NGlOznsadgi97yBmONgScj/A1xULzyRiOkKP4+BpPODnTL9yqr+F2jdwvo/z
nJcm5Ja6dMTiipydBO6fqP0ANQuodQ/+PvjX4UsRs+bF2WzAXAb+nUbpRw2o
xW3kfs2Jj6JTbcazFrGvZIT/oVf/ESeM1IM1l/KqVwXmMnz1iF/w4o+8kUP6
2Ys9yDF7sH4LMNcQdwL2ohMn5IZ5vxFfRdwjr/O8115wH7g3aSIMl5zuPoX7
zUSW+9XlpBn390VeelG3vYCLmnFXeH4FfzHWzN2xOCW352CrYbe54+SU3G4E
jrk/5KXPaSbqwLfBmckNcfEtERO53w78T+eUyx3kbnI3iK8WeOPs1D8N75H9
uQfEdN5Jy+vk2Ytzcr+WaL9rsI+9dJxAn/VE8Ruwg166TUTKSwMP1JV93sBf
ctKKe9GTlf5tiG/D+S+wnYXtcTq3Z7VznH0Rud1O8xayes/Uei68S/Zjr9fh
7VCTSl5zct85M/eDtdIwP+M5B+sQN/+X7Ad+/gPcD7Qd
          "]], 
         PolygonBox[CompressedData["
1:eJwtk8tvjGEUxo8ZNXTG95l87R9QsXNtSRB/gE5nkiYkJZYNHepSl6R0UTZE
LOiNEtuhwtBuatnpwj36BxDsSOxZWfk9eWbx5jvnPbfnec739gyPHbmQi4hD
nPWca50RHwsRnzjnsogfWyIm1vnuLP4Zznvs+oaIV+WI48WIi9gfOiK+k1sn
/rZg/xv+Kfxh4i16n8S+wt1tYk2GXsbenUYsMfhPPmKIXhPM/0z9GucS+XVy
Jsl/Q/1gErFXcexb3DW6IqZLEe8Knnma/Hv48/T+S78R/EnqW/gn8K9j36D+
KPYiM3cy+yp+NW9O4ta/2f4T4ltTYxCW39ztT8xJ3MSpAt4mGjzOWaMa/gKY
vmy0JivEXoNnhXiefkvClxn7FPl3sXu7I/7R/yuc9mD3MuNX3pzEbSZz7Ut6
NEreiXYzSv9l+u9IrZ002Y7dn5i7NN4Ht/FOay9NDsPtIT2e0a9GTg3/fOZe
4nCf2BT+z4I1GiLe18YjPeaIb0tdLz0G4bsG39gUscqnBZ55chba/avUv8jM
VRyb2DPEH+Ws8Sj+rtS70P9QSay5ZmnmQNEz5Su/Qr9a4lkN7npS/0OqFebp
zJw0W//MCLEDibFqhw/Uq8tait9T7HFy7nR4Z9rdQLteHMW1r9v/jna4TH21
6F2Lw3P4Lpb9FnSntzJbMjbhl3biJHw3iR+j9mAbj/prF7OZY8IwlxmjsOoN
jGXegbDqjeitrJb9/0lzaf8fHimJfQ==
          "]], 
         PolygonBox[{{4320, 4319, 4533, 1642, 2893}, {4974, 1995, 4976, 4319, 
          4320}}]}]}, 
      {RGBColor[0.39294, 0.4418, 0.58808], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVM1LVHEUvc0486Z5M808fq9NUFBEm4I0JYL2Oo19gAshhEqdMQvUKKio
doVRak6gtSgtUqoZjUqX5SJd2MciaNGmRV/QH9C6RedwfovHvXPfvffce859
s71vpGs4YWYVPEk80zmzBwgc2GTWnjebgj+B2N6C2fUNZt2ILTizf4FZA/Z8
0Ww0ZXYBdhl5b5E/j/g3/L6E/NPwe9Nm9xP6PQ17Ki0/0aQ+bxCbjRSfgd0G
rD8Ypg0z/ML7LvgN5JxJa7YrqK2g7zu8qzr17se7y4gfCtWb+DWn2ThjFc9D
5O1HzynM+RG1Q3g/F6n2CezfpPblnj+KwhlGzhjyezaa7dqMXWCPJzXzZEo7
0N+CmS8ivwP4N1LqVUf8Q2w2gP6L6H8ir9pF9Bwqqu41eh/Mqtc1xF40aV/W
MreWEqevUD+IPi8jcVhOCm8Ne6wE8vdlhX0OfXYUxEcJmM9RU0XtM9hPsXhc
ht+R931QtxP5V5FfRmw9lmaPkVP3tZ3Y63egfakF+SDuCm6mMy9u72GXMSfN
xp1uhVxOwp9wqr8D+yUjfanliJPl3TV7fltgP2ekC7WlhtSFWNSNPFCbHqf4
OGoH/R3U4B8J9Z4a8ka4IzmroG49EC+8UfK6lNN9sw/7LUXihzxRh++BtGjL
Cr+E+3kUiR/ydBs1P5FzC3Y+EsZ7xBuRdKf+uwvSdU9B9807n0X8cKicBcSO
huJ/K3JuOuGO+v24P3kkT+SNed2hYvwuOefXjHSZi+W3Yt4B1K+S85x045wN
zxG5asEuZ504uZuTnqteU+7MGyYG+VvzN1Z3ukve8jE/M2+HO3P3p54/asx5
yRO1JN5MLB2agVsOpQPvtN8Jqx3xPqc5Tjp9S8TshV/yPr8z/i+Qh1bY/xIk
qYg=
          "]], PolygonBox[CompressedData["
1:eJwtk89vjGEQx6er7fLu7mvfvPZI4iKhPbQqIuGqXStImpAICdtqtZJ2iShB
XMj60WorqTigLUXtllA90gMOml6Kg6uoxB/g7ODzzezhSeZ5ZuY73+/MPJu7
Sp2DCTPby6nntIVmf9aYfV9r1hyY5bkv8v4padYbm53kLGJ/5oylzUa4r2JX
AbmFPcr5Xbufy5rd5v6LewLw42BtXG92pc5rbMJeiMz6G80u87ZC/AiYE+T+
xd9NbpXzr5bfnzKb3AAH4u8T8xj7Jf73CY+Zi72GYscazHbDv43zAy2d4F3D
Hk27FmmQFmmQlgL+jozZMhwuwaWbGjNwKxPzM+n5hzPOQfjSeBffC2JONXqO
cu+B9yXpb8/x5TPu09sZ4rfCYQU+RfxT+C8E3l9pbie2BEYl4TVvEt8eei9u
oGc7sXPk9JL7DYxp9L8i5ij+D+QsUHuA+3LS+3kArlez3gv1aEA2/uv4yryN
xz4zzUozuhP7zDV7zeQdtYYC781HacJ/mnOR/Afk9GF3hM5XmEeoNxh77Ye8
lbB34n+U8JkfTPmM5e8D/y3457PORT3YQa1mduJ1vWMKez7yWGmaSPtOia9m
OoP+cuD6i+vMWnJmraFzU88L1JtPu3bFVOBzora/x4gfxrcrdK7idyjlM9Ps
voI/BX4h4z5p2I+9LXCfYp4RWwRvqM4xu7CnI5+terSUdQzF9/BWwbeH/PEG
5yPuTYHPUjOtRj5T3aVZ2nti7732/Qn3s1nfBfVHu9ISuk8c8imP0V3193F/
U+ufMFVLf0C7rB430estOe+F+q9dFGfl6o9NkjsbOXdpkHb9AeXrzw/DrTXn
vVeP9RefRv53tOPa9f+WDpyT
          "]], 
         PolygonBox[{{4301, 4300, 2891, 1637, 4520}, {4524, 1638, 2892, 4300, 
          4301}}]}]}, 
      {RGBColor[
       0.43049999999999994`, 0.45499999999999996`, 0.5660000000000001], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVEtIVVEU3X2e93Xfe/UuR4cFDQrSqOgLVpalZgSCVgRhSr5hH51IUA1K
M781sGFp+fw8DcHfSCl1FCFoo6BRBAmNm9SglNZyHWhw2Pueu79rr312NzTW
3N1sZg9wtuCMBWY1eWbT0Ecjs4WY2XLaLAejnzBo2WS2EjdbhT4Bm4uQi/Bp
xv0s5ALOO9x/C+RD+4zTfU/S7IZTnPLtZt8h53H/Ana1+F6CXyf+D+FuGGfS
lKdvq9lj2DQ42d+EfIRY7bgrgl9lQnaHoFdB/wH9OPQZ2KzDfhz2ZTgj0M87
9cO+xtFfWQr+sK/DfRX6no8p7yXo72PqkXgsxoTJh3yzeny/gu+BArMvuGsL
lecXznP024W8vajtGmIupRVzBPaXkasaua5ANofCbi9ifEor/gxsauEzhzgd
iJHF+Qq9zQnbOY/z9W36Js4f06rzDXwLEXMKd7lItfz29bDvXKB/u3aYDQDP
nZDVecKB94XEC7ISuYoT6vkZ4pSmhDPxLklpDvehX3CqeQX5B53yHSyQP+M0
oZajCeHYijjHEsK3A3pRKCwnoJ9IqI4e6PtD+R5BLR1OHOqB3BdqJtlI2C/H
xZmToThD7qzF1Sd7GQ3EY+a4g/paUOfDtPiWDf73QFmC+H/j4hxznHWyOQN5
ymn+jaE4RdyIRYVTjnLIRsRtRfwmyHOeu6WQ63HZbHAmrblVJMT9Xr8XL30/
5BQ5zvpY02AkzpA7/ZHmyzlPRsKcfOlOCoN6p/2b9dxgbNbD+Ks+Hnsg77iP
xOtwKO5UALe+fO1zf774Sv/OpGJQ37BLiavk7C3/FmQgu/yMOKt7MWFEfLgP
3ItiyM9x5WbeYSdOTnhecy7kJ3ed3CD+5Cn5wDnuCRW3DrmmI3GDHOGcOW9i
RLw5P2L0xCkX94ycI/dO4+51pNjkEXed+8O+hiLP/VCz4sy4D3ybOKfbyPs2
0gzJ2asp4frUqXb2xr6o//G71u6EHXnR7WRPv4zHbSApSdzoy/lzjpwdd2gt
EHbkOPnAf2NO8af8u8IeWD//bcwFvuX+HeN79g+Mgd9x
          "]], 
         PolygonBox[CompressedData["
1:eJwtlEtIlWEQhsdLHvOc7Px8tQkKWhRRlFFa0MWy8mgEgtLKSskIgsrcRIts
kV28t6hlaXm8h+BtVZS6ylRyF7SKoKB1m1qU1vM2Z/HBzD8z79ze+bc23Khp
zDazKl4ub3eBWfMas+85ZiWFZk3o03z/m2+2uMFsf6HrrQQVIzcmzVrw/xwz
SyfMuoLZF+SWLLNO5Iq42VewegDftN6sjm+V6I+J78C/OzKryTMbJeYO+sPg
sffAbEWu5z3BdwZ7A/LZdWbVxH+knjT1dBFfTfww9mbiy/EZQZ4lfonaxrFP
Ue8c+gTydOSy+lki/gb9jWO/S45SsOeJeYv9DJjF1L59o9npHK+hE/wh4mew
rxD/nvgi7D/J9wmMPci9fFvOd8wefOfR/6BPoD9Hr6W+V/jXrqU/8F5Enk8+
8t3LTL/lOEYPenvCZ/WDbxeCz0izUo+p4D2qV83gIPUuJ70/zfQQ+rlMvjle
N7ELSa+/CnsJ9hTvJvN+jf188JpUm3ZUzjwGgve3ypvGNhZ5vlXqW6C+toTH
/u8J39Lgs0yjH0d+hn99nud4R+4p/FdijinsFP2+YTaz6JfQJ7H/jjmnruPf
lXCb8NXLseDY4lQRsc0Z/i2CcZhdXgzOFdnFvTp6eJTlmKPBOS1u3yJmW4HP
RLPRjlP4Xom7/y++DeI/nnBZ9fajPwjOdfnIdwcYH/K9x6f02of/cLZz9D6+
m+F8X67nrIp7zapNMYrdVei3pJvaiTwMxqT5jEcivzHZhbEFrDIwB2LOGXF1
LPhuVI961U60G3H+ZeQ3p9sTpyrjzllxVzkGsLdFzoVBMG5Tezpyrooj/ZFz
WFxWvt7Ib0a3o3qn0NuDz1433xH8BnWLQ7xTwW9Ut6od6V+xmIkXRyuC51Ru
9XQCvSnpty9O7GM+R4Pfomo4gnwgsz/9oy7jezJ4LtUrbl9L+q1oB1eR65K+
a82wjPn8AxKHwXM=
          "]]}]}, 
      {RGBColor[0.46806, 0.4682, 0.5439200000000001], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVElPlEEQLdYZZoaZ+fLNePGgaIgGosQFEEQWWYwGYmI8ACIxnlAIeOCg
AWSRYXNJPLgkEAGJSzAuB4MiXDQKQY13SfR/KBff8/XhS1fX9/pV1avqzrvY
c6Y73cxG8GXg6wibpWWapXyzJ75s+tqzze4C+BKYIawnsb+UZjYfMPsbNBuE
rwL4OeyPYS3FmU78/xY3O4H9IvxfE2YDEbNRYG97ZvW54hyH73BYfOtxcZKv
A/viqNlbxNwXQlzwbOLfLPDP8f8n7GFgUuBqRD6jnvzMecP0f9NhysHfhfUH
+FezVA9rqUEOdSi8Hf7HCZ0/C99KXPEP4twG7MuwaxH/N7AvwJkCbltMnEeA
6UNOI/BNeKqBtdQAX+J0+BiXFrTr4b8K/CPwlMMe9JVrYdKsH/4b4LkFnjZf
eTaAYxr7V8h3L3Q4D/8K8JPAPoX9B/YzX/pS5ysh5Ueb+S0EpCnrqQirhu0x
9W3Wac34rJ26DSPWKcT9BL4ypxtrvYd9L7Q7hzr6sP5y2haHpQ91KoiKvxBr
q6/+TiDP7rj4qTHrO50tLQ6FlRf1nvLkn8Q6hq8J9mfg+zz1qsyXbz0ojiFP
cziI9X5CdTSyj24+GJO9WnT92gldvuDsA2CP++oX+0Y+xiVng6/55JzW+fKx
Jwuwl2G/hl0UVS+q4FsLavbINepLk/mI4jA33pUBT7kxxwMhadwKjj1R5dWG
PPOiivswIS5yUtNqX72rxNoMXe9A9w8OR/xNT3euNkOxdiXV06PAD7hYjDmc
pZ6tmO4b+8L+LAH7Dl9vmvJgPruj4iIne9PsC5PCucpc+XvAuRrQeZ6dimjf
7iv+VlD3jDG/BxWXWM4t7ZYctzfVtZQpfUtjsktiypHzxt4XJFULa+Jccj5H
UPuFHJ1fdvd+2c0w/7M31PJ9QHlwVqvdfa/C2h0S946Q5oyzNQ7OmYRynnbz
/j+PNM0f8Ty35t6RGU93kvPAuZh17yH3c7569Ybz4PD9nv6zp8TsT6qGIqzX
I9Kfc5Ef0rvH94/3mzWSazQi7fKTqmM2U7jOuHrcFXfapOsNYq8W3N3fcved
ccci0qXF153hfF5zbxJrZr1N7k5wDv8BasrT+Q==
          "]], 
         PolygonBox[CompressedData["
1:eJwtk8tL1FEUx89kNuXMODP8dFVQGm4UCnpomflIxx4UQg/TTIlqUSnZwkVl
OaPOmNoDWkQLJTXpQVFtwh4a0UIjiPYF9X9Emz5fziwunHse3/s933Nu2dn+
o5dXmVkbZzUnFzV7FzZb4LQHZtmk2eE1ZitrzcqKzMo5X7GP4BsjtrXU7Mw6
sw+AzJOfoX4WoJYCs6aY16j2EPnD5HcVe+4COTVxs4clZsvEM/iGiOfI7yhw
zC1gHwNjOGT2Gz5Z8D8nzC6FnFOO/Bne+0XsJydNPI3v4BrH3ATWF/J7yW/D
N0lshff+EXtNr1Pc56KOPVhodo7cExF/T5gZ8DbEvZ8/cKoj9ibq/EP4nhBv
xdcD9hL1K9T34FuidgCMFrh3x7yfv/ieEruVdO3Ug3qpjrsWylHuZvTJgd9H
fHfENZE2F7hv595HzTBvLcI/RW4q4m9pZh3gfyJ+MeQaZKitxfcoz0e5ndzf
h71H9SqOit3njRT2roi/neVeBn5z4FxHubdgpwLXU/FW7OvoMQ9eM/zrqb/G
PU1sBl8589sWce7y3YRPU+D8Rrjvw65lRvcKvX/NPk39TH5/GsE7n/DZiPMY
sfGoc5Xmp6k/GfiuSvNJYlfAeIH9knOA2I+E9yPf/sB9immelfS3l/ts2DUe
hd900mepHdGunCLnm/nMtbv15M+FvWf1vpH3XhEfoOZBie+Q+GpGvdi5wHfl
OfWPya8q9re1U/orDYHvojAbse8kXWtpXIN240nXSjPYGXGO4ioNd3A/HnNs
zVN/ZSLpu64/qr86UOS78p37NPyqSv2vqKdK7IaYay0+2vX+Ip+lNKmDT0/C
42/JryA2VeJY6lGzGUn63xYf7V57fh6d/N8s/XUlXBvt4FXuzwL/Cx/hPIt9
I6+3NBzErij1WnEWd+247EVquslfH3f99EeGwLub9F3UjGvRYyLqueKg3dgT
+C7qjWW43M7nS99q8v8DQQil3Q==
          "]]}]}, 
      {RGBColor[0.50562, 0.4814, 0.5218400000000001], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVclOVFEQvTLYzevH6355dEQZm0EDauLIoCQYRXEHmkgYggsjQiI4gcaJ
ZsaoUVg4JKKCGnDDxo0oiVPUxD8wKiu/wGjisNJzPHfRqXp169ZwTtXtxKHj
+4+lGGOu45eKX2HcmHnIHseYwXQoacbMwWFDxJgjy4zZGhgzge9T6fIbDBnT
Ab0TZ+/C0qdhn4TPE5z1wv4+pvPtuDsC2yh+D+CzEwmTKYo75hvzDHdfxRSb
OXiXuVnDNeiD8FnA2Qv4FCLWIxx1OcrZlKEcKwLl74A9x+ZbBbkFvzvQE3Hl
pM68g7B/Qx0H0F8j5Dxyzaaof/aX56gX+iziuz1TtVREjRl3dXYY9dwLqZ9+
fH9NVf28z2/amWsUsT7CVg25OyK/bchfDf0L9GLPmBbbfxXsRZ7sJZDtsI8j
Vhn0Nk+YtEKucVTXLk91sJ6pLGFPnWcHM9Qb+/qbKkzZwwXguWe5MRchb+LO
W/BX4Khe6sQpNxAvLxG7CHXWwr8P/glHHI5C3wz7XtiT0CuII/Sr0Ivg8xA+
l6H3IsYni08BfGrgcxL2fYFqbYCsX64ZIn87MtXvADAuRJwZ2AZ88Za02P4I
qR/28hnyQ1gzUZ+q3jk/7I85ORvZyPEUdSyilwo7D5yLdXHxQn7OB8JnxhXn
sxbDSeCziPgTkF04G8bdlfAtwO85Yr4mPnHN4TmcV0bFEbli39wT1jDqajaa
cO+Kr7tvYprhRdt7cVw5e1FPXiAMO6EPBeq3GTFvZGlOOC/Enfjfhi0a1axx
X9krMWXMfl/6pohmnb21IN64r/jkqgb2HtzNRYylkGaGWCxBTqXpLDsq/YTF
gDySG9cT9tzL7yFxQ16m7fd69DQXyMYdIgesr9vW/jOsOEm7P+S3OZDOXZmx
cR4H6p84tHjilvgS21tpmgPWcT9NdbPmjfbtIjYJTz5VEXFALsZc8UcuzqCe
8qjegTLIAstfPmRdRDPViHvDgTAagVztKVcp5JCvveB+NNjZLkHvA4FmadpV
H79DmrnTFn/yTNxZby3wOeqLN75nd7M0032OcCJexI7Y8z0kbuVx7fnauPbv
j90F3uHdUr57rnDJieqcfuy5MlBfdXa/ue//dzukb+pnXXHTBpx+hfWu0s4Z
4f8E56TbFQdZUb3RrG3Y114yF+vJd/QWtMa0m3w3ySHffea95Cs2cyzY/wHW
z/p67VvHN+8f+3veLQ==
          "]], PolygonBox[CompressedData["
1:eJwtlElL1WEUxl/T1O693nv//L1hmVNqodXCIocUjIpsUWAuQi1aBA6R2mBG
k3odoyJ0USZZaUW2cVGbBovAVOgbRMOqTxAFZav6PZy7eOGc9zxnfM77Fpw4
3dC1yjnXyEnhbIs59zPNuU/IW5FPhpwbRh/iZPvOfch07k+6c4+wD3jOtWGP
Y/uc7FxeGD3g3GNsK2AWwS5z/iK/WY3dtzvZXqNvQF9K6PIZJV4e/ovoe4jX
hVzGiYOtR+9FXofPIPlmwLei16N3Jzn3grvDyNc9i6V8N5CHPatV+UaQC/Hp
Qf5KvI3Ueyxq+jf0zej9nsV+xV0ceb1vvUt/B7YavY18R9bgz3ye0/9Kms1s
BtulkNlawB8E/8w32y18ZpGveVaLelbv6kH5fqMvoLejP3E2M80uB30O/Rw+
tzMNI+xL9CzizZHvVyL/tGbjWa3iSFy9j1q+2lTqDTo3wd0Stjr0XrCd+E9C
/Bf6z6f/hajNrh57OfiisM1KGGHXRkzWXRX25rAtjjgSV2fATKXYPDdha8gw
7r5R3yD1XfAsvjjqQX4btV4OkG9H0DgW/jgzLI3ZDmgXHuBf5RsH6q8GfB74
KfoZZ4HrwNxHzqS+iRSbYYj8+zhPsc9xV4rtpme9fWQGk+Cvou9PNU6XiV2Y
6Fc7od0YoZ8x/L9z10j+u5lWqzjLD9jOqNeHxO8DO8OZBf+PuwHw1dTYmWQz
ySJ/dsSwuqvBVhKx2tSzZlWbYbZRYuxG7vBsPtPkO4V8KGq7pTent5cbtrfX
zV1uwHpSb+KzAFtRzN7GPP6FyDnc9RK7lRxl5N8etF1QDnGx0zfbPXzKkceI
N59uOZV7l2+z6CPGRfIP+cater6MvCVm3Gnm/egtAatdMcaJ1cTdj2TjbDRk
nIpbcXCF/o5GLbb+gDvgi2PGrTgYBt8ctV7Vg3qZDlkuxYz79uZUq3Zcu14Z
tFloZ7W72nHp2pEOfM979jb0x+mvO+vZbumPaUcvj9jb1Y5XIDeFjVu9Ob29
krBxJc7EdaVvb1V/UgVycWI/tE/6e/aGjQvVrN0siNms9cbzkf8Da7C9qQ==

          "]]}]}, 
      {RGBColor[0.54318, 0.49460000000000004`, 0.49976], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVVtLVFEUXjnq6MyZM3M6Z6IyHU0LjOxuab50w7dALemmBIGO10y6PKhR
FhU9aFfooaiQ3rpRIAVJURH00ltaED34B/IfRN/Xt6OHzdpn77XX+ta3Lqfq
2FDb8QIzu48Vw7oXN5vHZgyHK5NmHYvM3mbM1mbNjpaa1UHuKDa7DL0B6FyF
vILVCb0HodkrnD3xzBqg86bErA/fnyLp9CTMsli9RWYtsLkC+pdw/hH37bC9
E35Hob85ZdaI/SbIKodhGvpB2qwJ5/Up2d5eLPtlsNMP2evJFm3m4afIF8ab
kfBecpgnsRZg5zzsTuKuB9/5wGyPr/PdkMPA+M3hIa4PJeKEi/w8BldN8D9T
It83Iu2DhO5fwtcEOYStR9CtTggH/Z8MxBG5OoT7HGI8AiwziDF0+hnE2u+J
3yrENwv5y2HeF2q/E7r7sZ/GXXsovsjbEuxHsL7i/CLketjvwrs6947x0w7z
8BPfw/juLJX+Z/jOF8gOa2KoQJwT03Sh2e+YcDc47g/DzlhC7zZAzsXEHXmb
RZyvIZ8ijoOw3xwTJwMJ8VeW+M8v8fF+pEj4+jLydQAx3o6Ld75h7olni4u1
tVQ4K7K6p23mczvuDsHm9Uj7roRywDhW+arlAy6WpWnx0ASe2lLiphZna9Kq
B9bFOLj7ARwPEcuaUJhyWdmYKFKc5I954nvufzg+51wdMca9iKsX+2usu0BY
WYNljpM6+LoQygaxnIsLP/XIzYLLXzn0vmN/GPbaQp1dBLZnnrCQ+3nH979a
ZZ2yzviOOSZvI3Hh4f5dJL0TeHs7Us2XA1d5Ulw+z6gn7sYVT6Wv+hj0NBNY
25wD1Vnluyar3I652BtSqrUhT7XLWtwFeatQdvOuv8htl/NHvyvgv7FYHLDe
WkP1VwtkTVI+i5Grt5GrS+DP+YorD1+rffk9gf3WUPjrIYcCxcu4WXtTheKr
N5Ad2rvnqTdqEUtlWjo5yBcZYamA/wFPPJAP4vjLAc5zoeYe5x97tNnlrjKr
eVcFmYXOWdxFkKcD8XgGcluoWdwAmUqLD/Yxa4FxkRfyyLgi+L1TqL4gjv5A
fA0Eqm/2Eetw0OGs8TVrWAvLQ81WztjKpGqD+WAuvsRkl286Uqr1qVCSs4C2
F+N7lPnylEPGwrfrXI+wVyoSrkd94WJNM5cbnb9ylyvWIuNizxNzPqkZwzlP
rN2wMw6dZbB5PND5YKB3o+4t9anD3HR7whJC3/MVTwQuezzpDQf6Z7AvTmG/
OimdlK9ZwJlQi32Zrx7206px/kfI1/tIvohrudOhLmuO8bDXl4bSoS5nFbGS
iz+Uy+HN
          "]], PolygonBox[CompressedData["
1:eJwtlMlvjHEcxn9qGZ3OvDOvt2NtZ1qKVlSIrfRii6u1oWiIqK5UbYki9u1Q
S0gcrGncJBKkIYiIk4ubLREH/wD/gfg8eebwS7779/luv/q9A5sPVoQQ9vDG
8ZqiEH6NDeH4+BA68iEUq0LYMSaEboy64xDakhBGUyFch98M3YusZYJtnmNf
h/0u6D70h9H181aU9W/QH4Jvhd8J/xJ+emJa9jOgC7kQ7gLkMxjmEGs7eD6B
6yc5z6E/jv8q/Dvw+YD/rCrT/fiPxzYb2fcq9r2ZEI7Gji1MM7Hdh2xTJZiw
WZwN4QQxv2Dbgew+uoa0a1cPGon1ANnXlG1k+zhjLOKH4FdgP4z9NuwvQi/A
Z5h8I9RQRy1HYmNT/nrybwRzD/aDyFrIXyTGFWJd4/UR+0IZz1nsz0PniHGb
WD+Ivwj/ueQYwn89/BHoZvI9Dc6p3DXIBtF/Qz8d/kLGs/oDv4V4g+DprXDP
S8TbkNj3BTk3QTcU6HmlZdIdyhir+jEVLAvx+T7WmIStGpvTKctqIs9Ysz6H
bCq6KbwzKe9AH7lr8G9HfxLZpMQ+8hVmYW8s7596VEh7hpqleqRercP/N/r7
8MsT74DmL30JvpZ3OeUdOUa+7rR1ilGHbkfevXxIz4rouniXUvaRb8LrqnBN
BeimnGfxF5950Gsj05qBZjE58S7JZz9YNybupTAKa0tirKfQt5P7fd67oJw1
iW9As1gJ3oPg7cLnH76j9Hdpzjul3drNTOYzmwOxbd9ODCGPrjPjXg7xYuKV
sLmT8k4UoRemfT+K2UuukcTxXoPnGb5L4e+V56fZLoE/WWHZMuhi5F71ICtF
xiRsirGL/Z2N7EnwjsyBro5MS5ZAr4m8e7oh3VID/EBZPxP6RrVjr8TmJnQt
eD9S22r4A9BNBd+majiVdo2qVTesW24uuDeviPEocY/Va8W4Q7x69G2Vrkm1
HS7/B+/Q30LfFftv007WUn91zv+HMPZnvDPaHcky4F2b9e3pD9yKLp9zLa3I
YuhmZJ1jPIMF0FHOtyhZFnpJ1rb64/TX1Se+fe1wQ5VrVu3CXAf2OG2s+jMH
Ys9cs9ef2wM/LfGt6aa7M/4ThE83PAv/zrR7qxvULbZH7pX6qb+1lPNfJR/V
9h/7Tau2
          "]]}]}, 
      {RGBColor[0.58074, 0.5078, 0.47768000000000005`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VU1sVFUUPs7fm7438+a9uR0XpJY2FiOhNGiFskDTwEpN1JRpbGgp0sCg
NbRNTYyDWBPdgDWRAjWSWBdVVybEMmy6cI+wAYSEnewFLKXd8318l8XknDn3
u9859/y97onpoamMmS3jl8VvLjA7jd/IC2YHymazkFsrZl86s98A/KVk9ivk
Q4BXgb+Vmn1VMLsNOZ03uwt7E+dbYrMlnHeE4IV+DfYMZD84Gzg/Bp69sB3L
CJcAtwB5MpWNeMbQ4Xna4f9v2P4qml3A/8uJ2Z/wdxD4D8H1Xc4sV9H5WwVh
ToHnflZv6Iul74Sch/1fb38V/38Htgf+Z/LCnPLxMc4UfscQ8/fA7gb/LPy9
Cf6uyKw7kq/PYNtdEP4HUz6YK95ZRzx7Cor1U3CehL0TnPeQ4/ezwu0F/z7o
HySKi/4Z26THlxHjBM6a4DgKuQN8K9DPwdfr4LoErn6nHDBHfHtvLK6PgF9o
V8yM/RXEPA7uGt5SbzMb9PXKx7r7Ms4T6GyK9xL5v5HVnW3+bhvu1pz6xEG2
xcIUIRt56c/fScl3HEmU92HIVl7xnDflb9PX9DD4xgP1wZZQ/TQC/P9VnT2C
fFKUTsxj/D8CfQ1yoyidnJuQcwXlnz32eaCeipz0EPJOKsw/kCne1Qd9DPqA
r8UeyOMZ3Wf//ez7vom7D+FvFDwPIP+rquZHQ/lgTohn/x7yc8SZ+CIQ32ZV
b50IxTEWqI6xE6bMvDr1EGeL56w3MQOQq0XpVdRgEfV2kFWn/uuI1BcDHr/q
e4/6dKrcpPBbicQ5Atthb1+vKvfMA3PrUMubiLs9Vu+Sn+/8JNU553Uw1h6o
g+/jVH47I9WHdWIs9L/uYy4j1vOIOYa86vtgPFUeiKGfoVR+mNchvKuFs2HI
J77WrPlaWTlkLl+K5ONEqnP2wRXwdFU0y5x7co/6PP+RU8ys5eWSemXZqeaX
ctoFK4lin0xVb2KXgA0r6m32O+eHs/BGWTVn7Vnrs5i1Ffg7A1nB3SbOEv+O
q4F2JueecZC3F2eLrDFkPa+7fP9BJ/y3Jdkbnv96VjPGufqmpJnajxg2qson
88p++zHQXHO+F73O/cWZOIGcNUra9S86zeS858v4Xf1uov6lb/rtieS7G/hC
LD2A7HPytdNpX3BvRL4vuK/4Xu5Qxn8c/FOp6tNK1L/sMd6hvJiTzjNiZjib
FdmTinI473cj88rZ5EzR1vK5XfJzuj/WXhz0+5R9d9fj2ePkX/Dfp2ffqVh1
+TqvnVwL1Qv8PryTqL5vJ3oHc8IanQ51Z3sN8+p3+pzTPuNeYz24g38KFMNk
Iv5doeLi94b2utOb+L3trGkvb4V8zenuLsin51PvNg==
          "]], 
         PolygonBox[CompressedData["
1:eJwtlMtvVHUUxw9tZ+4wtzP33rkdjeCDBjUobyrgQgyyUxdKO6aNliKNlJdt
CSbGasGFGx9EQxUjRk0UXRmBAi5Y+Fj62BiRxJ3+AaKNlD2fL18Wv+Sc3znn
e96nf3x6cKorIiZ5PbyHGhFjSyL0uRk6aUb80h1xHOFIb8S3ecSFSsSj1Yj+
NGKav4+RPYLOw+ivRf9v6MPoLK9HnEf/PPQ69Av062XEywm66GxE/3HkL3T5
L0XWQecqsq/BXJVF3AHeFfhpMJaBd3tmf7/xtwrd9anlc/w1kA0Sz7Ng/cRf
N7Y5mDPwe/HRCz0Oxvvkeb0W8WNfxN3YbyW2efDnieVO+M3w5+DP5q6BavEB
+AX4Q+CPgvcc72or4uncuX8FZhvsEh+zyI7xJtAdyR37DBjD0BvQeR3+KWxm
oQ8Xrs8i8fxAPFfgj+H/OvZnsG+hM1FxD6rk01+angTvEPIaf792W0e6OxvG
/hP7o+h+URrrOD0dbTgn5bYFH3eRa545N9WzBGuY92WXYzyI7iTxnAjHOAXd
B96n4Rzb0FPEcOpW/7eCfw94R5Z4BlZA/47N0ar9L4DXwOaVxD1TbzdhM4Js
Ap8D0P9S012J+3EO/T28mYpnYjv6R8jxUvhvHNneXtuqZ63SM6fZ247+i9B9
TeemmdGsNpqunWb8fvL/nppfqznHA8Q6VLg+78EPQveg/zP2b2M/jP2DpXv5
ITGug17PexX+I/iN0HPgfVezTQXb1fydTBzPNvLbUFr3L/g1yAfgTyXGENba
0tiqj2b7s173QzWcLT3zyuck8bSo7wA16FQ885r90cK7NgbfgR8rvK9z5LNL
s1V6NoT5GvSWhnun+mi30qbnXfW5L/WOale1Q1npHJSLYt5UusbiO0vZpXbE
N/hcTDzDmuUR3uqqd0a7s6fu2s5To7eo1bu8SzXv4H503+yzTDkpt5cK3xrV
VLXdV3h2ZSNb7ZT6oRqvIZ6i7ly3oXMC+YrUtGqg2/Vk7tugm/NE7hugWyD5
IrNXzXzrtGP3pt5J7aYwpwvfQMnVX81GM/Pt0X1ZDl9m7o1qmMPfVvoWaMY1
6ytT2wpDvhbwuTvxfulW3uxZ4h34D9nSzL3Qjtcz3zD50g41of9vOTZhXIP+
p+XbpBk+k3uHtEvqQYbv53PP3jtg7IZ+BowLiXe2A3351v1RDz8vnZP8aeeX
Qb9BfBcT2wwif6zpfdTfUOmbrdutG6RbpJ3X7gvzD7B3oH+6yzay3dFwLOK1
2w+0bSudT/DVk3n3dLMXdF/anjX1XLu4LzW+5lm362DhfLXT2u0b9aLSNw==

          "]]}]}, 
      {RGBColor[0.6183000000000001, 0.521, 0.4556], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VU2MFFUQLnZmp4fp6e7X/cYYvHlQZnUSYElYEyUYiIkC+z/sDCDCjnvQ
BFfdqGuCwA1FDJhoYkIIySaeOMAGPGlM5MRFSYANePRiUAPuioQTB79vv+fh
5VW/rqpX9dVX9Z7uvTsx22dm32GVsAYSs0EITez3sH+Bn8fXmD1XMbtSNZvA
97rU7Bx0E2/2StB5Hzrz2JfwPQP5+4bZetiM52Y/NGTfgTxRNxuD3mZn1oKf
C/CzEX7e6Te7WtV3D/+vwU8Hfpqw2xuZjeKsAv2v8b+omWWQr0Mnxf5EbPYj
5EeF2Z9YXej/VcjPfKRYb8L/DazbkJvQPwjfT2ZmK4lsy5CriOND6K/FfgTr
NuRj2DcghkOQJ+GvjTUNeQT2v1Xllz4nkdc4/nWRY7sunF6H/G8h2weFMOD5
bthWkMMi7D8FNqlXnHUfMIPOLugsePm+BT8nobcJcU7DbiIXLpPYL0WqAfFf
6FPM12BTg14Hsb0AnH/H3Ruhsz7R/S3YDkN/qCSMiE+vX5ivYob4v4KfAdz/
B2w7kO8WoSbMvU93kR/kxovwuw3yS9jnaopnO+QDubB7A/ss/L8Z7loHncP4
biO2QaxhnI/jzqk+cY813h4rp1+das/cd+I78+LFpkRc+yCS3xa+u9j3wc+p
svzQ39m6Yh1LxM9vInGsmSn2diwefVkWJ36GfKYsX6zDQEX1Ilf4fwv81DLp
rMUeZ7I9gHtKqbhNjpODxJxYnXeKPcFdi07+/i6U17MV1fqyU01WcH7R6exe
obzpk/bkxuWq4vKxOPgYd+axbOmDmBCPmfCPOkWs/iJXiGkayx/jGs0Vwwj2
PbnybWMvA+c56JfI/5o49QvOt6Wq+9tO/KEOObPBC9vN2COvulSwn2qoZ5ZD
n/Uife+ph16Cz58a6qke7vm8oT7bj/Nu4ESEOwe9ctqaqEeHQp77cvF5by5+
Em/ygzxgDR8m6iv2lyN3gs8yfJZQu5Oo3VRdsZE3///jzvuficWJGGdZrNqx
huQXbVfnUeAG58oMeY51Gucu1OVb6B/14ts44pnKNQs4Fz/uV23ISfYQOUp5
CHrvQZ5FDEu5ZteKUx69kGNWU9++6oQFMWF/vZxqJk/j/H4iPInrU7XQf6n6
hz5qXjWZDnVpefVqB7ZbU/UOe4i4E//nw1xcCO9C7JXva058Zy8z97FcfOU7
sDvX+YmG6kO9VXzCDPeZOLUYKe6DTrgccrKhLecE5yW5yr7hbGNdWOOmF3ac
QzudarDL6Z1gfarMN/CTPB11wrbA+VtOuTBX5jES4uebw97jXT2nmTYX5tZS
qNM/TvP/gRNexK3rxGliSe4fCb3DHmL9WMebud4/9vVnDc1I1oi9OuKFw7DX
DCY32LOMfT70Nd/hVnhLrgduLMPfcqEzvj/DYWYwF+bE3FjvSSc/H0HnE9xx
B37P1zVnec8OcPZ+oRmz+qYlqjPnZTNgz9nEt5qYk6sPC/GHfcw7xwKG5Mmd
8B5xbg2Et41cJVbM5T+1lvNL
          "]], PolygonBox[CompressedData["
1:eJwtlEto1FcUxm9mJjPJzPz/839Y0O66sCY1YFTQLgSLUqyPxLwnvk0UW0Gt
im0EtYKbKhUrKAiliBVXgq2oWxeu3FghKnbrpmrrI77X/j6+LC6cc88533l9
9342/v3AnkIIYQenxIlqIaxqCaGHyzVpCHOiELqLIYxWQvgvC+FSgg17VzmE
9djfcLcV2zz0Teg3sPdiH+PuHbY54G1BPw14rRHCe+7Gsd0E8xXYc/MQtmPf
0wom8nPsq9H7yf8C+TVnsOAcbxVbNbYwhPVjPYQJ7EvB6yC+SQ1fUMsaMC6q
Fs63YN/FnsQh5FXrd9Cr6OeJ/wesh5xDxPer57JruEBsqeFaR8jRxHeMu5PI
X3M3jvzzjBCutoWwlrseYkdT1678DXr/kDl+iLth4oeJ2U3+g5wtyBvxHyh4
pin+b5nJWfZwgnkVyT2IvWO6nj/x7697N9rJv2AvpOZzFc9wAfJI3bELsHeC
NUn87eAeD2NvBfOXkmv6hHzLOfta3NNv+C6L3Ntf+B+r+0hWzap9c+pda8fa
9ZecJrZR4ruIbQf/15LnOxvsVnJuw3YAjApyVnOsdvoC/4wd7C2YI+JKH3d/
FFzzIXa1NfGsLqN34bsT/XnRPt8h12Ln0k61a/WgXq6Sr5d83eAtxv4Depvm
Mz3/M+gT9HYf/4dgT3L3ALknd6xyLAW7I/IsNTPNboya5qOvw+dZ5p1r93oz
MfW/izwL7VC7nIq8e/WcY/8pN9eOoh9B7iX+87I5VAZ7SWQu30I/A7eGsHdi
v4ZeqZrT4pbuhlNzVNwQxtrUPvIVh/vQV2PfTm+nqKdAP1OJe73HeY08mvjt
/Y79U2JXom9rdcwq5A2pdyV+JtTfhs/1Nr+xEWz/Z/4bevF5jFzOvesH9DCT
fOtS/xWKUeybxLkfoV+hvwT/Cfybei+536T2KU5Vq8YQ1i70WejV3L6qsYYc
x37b2r/e9qLIXBKnFiO/zDwvvbGpzDvT7vSmBqitCMb+ijkirrSAd1tvG7wG
eCuod7xgnxK+7bm5JE6L25vq/ttUQ4PYV5lnpZnp72qPzQe9iSr8uZd6/uK3
3mZ3bm7rDc/PvXPtXhwVVztzc1VvdJnmH5tbwhT2UM1cEue/Qj9OfF/BHD0h
/iSenf7IwcQcEBfkU0SuxP7bhFmOvUPtsknOp8hPMsuaiWaTN9yrZpwh/z39
v6inu8hRbi5ppzHyN4lnqRlqlh8B+gK7DA==
          "]]}]}, 
      {RGBColor[0.6558599999999999, 0.5342, 0.43352], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lUtoXVUUhndzm9ybe++5OY9cm0IdqIlpfdCCKKXkoVa0mjRtTRNpbDBN
RJRCHVRsIaLWIg40DhQV7ESqqBHUiYio4Kgd2EeqLYh1bH2maVV8FdHv598O
Dnudddb+1+Nfa50rph++e09LCOEjnhLPc50hjKGYzkJYTEL4BGVeC6HcEcLc
8hB21ENoRd6yLITVfL8jDWFXawibOK8qsCmHcHkzhFHed6PfztnVCOEQ2G18
r3F3AcxeMJehn0P/XR7CDSXjv8T749z7qeSYPuU8iP5mYhrD9wz4v2P/YGq7
hzjr1RAmkPuRr02MdQ3nK+RwBP1X6BvYTCHfjnyc+x9j8zM2TWIdag/hsqZ9
KN+D+B1qsc2d5PkH9vfj90/OYfRrS457oOE4R8llCv1R5HHs+7Dt53kSm6UK
uMhPyZ5zkOdAsO6WqD+T2+ckMZ7KbbfAuYqY5tHvRr81870y8mLFPoR/vmJ7
fas2XL8Cmy9z+/iC81fy/IzYfuMsdViWrlkzj+JzLe83oW+Bo1vR72wLYQ3y
YMM8bEbup/7rwfw8N3/iMed7UTNPS2DM4nsEeSvy+cT6Xmo+yN0N1OgYd8d5
34/8Ir32F/Yr8NVPfh1gTaCfxHa8bA5Uf/EvXsTPBHbvwOMbqTlXDLpzY+q+
Vf+qH8WTOPo+N9Y5zjWJbcbB70t9byfyexVzLX97y+ZSPF6ZOGbFrh4R78I9
nTuG18HYTDw9xP8Mfrcgv43+NfQ9qeO9jbv7qN1pcPdzjmEzj83h1P0yHH3J
/4aYr3pNHClWzZNqpT4QP4pNs7Qu8b0SmGeIf5YYDvPta+GCf5bzH2q7Cv1G
fO4t/P0Q8YwgT6J/Ff1F8B9D/pBvywvXTjP9N3e70A9gcwl5JfIg8nVxvtan
nqejMaZGzXVQPUZbncsTxLlMmNonde+DXTH+cuFatxbub+XXVXWNhyJ3slXO
sj+beEY0K61Vc/Z0p/tJvgbAT4nhemK4lxhO5p6RE7lrr55U/tJpft4ilo6q
/WgPjWeexQq6mbp9K3bxo5qo1qqRavUs8sXU51Lccy+AO8P7qcw2C5l5m4v6
1YVtHq273+Vf9Xm307i/gHN17Bn1TmeczTdVZ7DWcee+uM/EnWbyg4rzVV00
H3qXvK9u35qzqdjTqmG16v2gPaE6b2p3rY9V3DPC1E5Sz6gW2m36Jr32gXzP
xx2kfbOdeC7EGDQP2g3KTXlpBjQL2zJjH4n4D9Rct8XU3O6J8zYda76C2LrB
eL9inHNxfn/MHZf8/M+Tzh2Ze1rcHs+8U5R7X+Jdq749EHtLsb8ceVE+es+a
rkPK2Vb1Th3JvL/V/3rXDIuXbxItV8f8L/FUCveFZlGzJF421nxPueuuanMh
8qK5GCt7xpXfaOwB/dPEr/gWH8pXfXky81yfyNyzPbFvfsiN0Rv3k3D0rm/d
sf7aa9pvlxLvGu2ce8BZWXUv6J+seqt31Z9F7I0G+uHMOEnN86n+aS/8P9H/
TFjf5s5lW93/H/2HlHMndbyLehZN9/7zsf+7C8uP1D2L2lniTPwITxzpfTbO
l3JVzqqhdowwNYv/AfzgBMs=
          "]], PolygonBox[CompressedData["
1:eJwtlFuIlHUYxt92dvbbnZlvdr5vZjTBLipztdNGUUjt7K5GYWm72robbi65
GmEEdqGkYHSyAyTbRVCBkdGBSi/qpiJU6CovSl3LoLLr6KibER20qN/DMxd/
eN//e3re48WbHrxza0dEbOd18t6qRYxeEHFNV8TGLKIP/nAhYhilxdCb+Bvv
sE6jHDGXWv5Bd8SeRkR3b8RzOPqYv3nIb8VmY5GHzS3Q59B/gTgz6CToTlTs
T/oF+L/yiHsT/12P/t3Euwos7+P/WfwPYL8T2Wbi3wR9LTpj+H8P+dPIW/CT
8JPoDED/U43Y3WmMdfCsrzj2dfBXYD8f+XTb39XIbybeQuItB8MKdCcrzkf6
V6L/Bj4PFK3zbyliaT1iQ5cx7UD3nsy1Uz16kG/gPUq+NyK/BPvXsN+P/QJ0
ziP7g3w3J65nk/iD2F+IrMXfMP7Op85FNVPtWsjnI1+GvIV8DX8jYDsAxr3w
Q5l9DyFfXvGfZD+j0yLXvl7zshnF9ilq9i5YVxHjSejBirEeRH40d01V20X4
XI3vleCfBv8MeHrB/xX8J/BHeN9AT1WMdxb7MrG+bstVoxXk923qWdqN/Sno
Huq3DawT5N8N3cG7odDuCb5exf6domtyjnivwL9ddA3+hj8Mvl+73ZOT4D0I
fwb+cfyvAe+LvP1hDC9B34H/j+CnsB+BPsbfLugvsenH32n87wHLw/ydQDab
mT4Lxn1110i1WtkTkTWZl7J9yb9yrTUt6yeHxeQ3VnbtVXPV/iLkM4kxLYTu
wufL4Rok0KdqruVn4NlLrGPkNJA4Z+Uun/K9ihhN7C9PPZuaUe3eUfC+3uEc
7iu754r/CPZbau65en8SnzuI90vqXmsGiuT/ae7Z0sxqduc1HWs1PnPo+2v2
pRoO4fsQGOewfQJ+gtj72v25jJpUib8O/oGic1yAv5/wP4H/28D3I/Sb7X3S
jtfQX5J6F7T/S6Fz/g4VvMPa5azq2dKOV/AX8EcKvjHVkm+OboluyJ/4n27v
o3ZsnHn6PbVc9dJup2XPtjAL+3/YbE08g/2pb5Zul/6Cei2rud7ax1LJO65d
1305k7pn6p1qPgi2BvItRWMW9kLds64d6qz7pum2KcfTqWdQs6ge7Sr5psq/
clAu6zPXWjWbhH6m4Vo/xl8X+usyz75uzDj0VMm7ph3RrtyVWaaeqXdrM++X
dka7M5LZl/5Gobfr/iWe2UvBu1b3OvHN1e39PvctUE9/gH4I+fOJez5W843W
bdXfEuyrVddON6IX+jd0PmzP61novN1f1Wy05psse2FYhH1f6tkRhu9y3zjd
ukHeCfg6M3p7j2dCs7Gz7lnXTmyr+6brtg/zvkD/89y0aqLbrJur26udO557
5jX78tmAns0dS/XRbZpr3wvdkOPU63+wNONT
          "]]}]}, 
      {RGBColor[0.69342, 0.5474, 0.41144000000000003`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lktsFlUYhk+LdOj8/7Qz0/8HY2QhIjVcqiRegF4opaLCQhQREQXFqDu5
KGhIRBNhQ5TEBYgUMIqoicW4UHRhiNFoIkGKBUTAlbpSJMGF3MX3yXtcTM6Z
M9/1/b7vPXPD8hUPPNsYQvhTzwg9h8sQunQwqxpCjw52XBPCGr0fLkIYGhnC
X3kI47IQJuvbo2kIo1tCGNZ+SiWEF9pCWN8Qwn36vqDZ+ugeiet22Z+gb/dI
Jq+HUEh3q85qsnNjm2Wel9/ntD+UhPCi1pv0rNX5Gp1365mufbdiWR1lbpad
W2RzoWxeVexPSmaVzhvj92E938nHe6NCuFcxvab9z5L7SLnsUS4t0r9buhXF
v0KySxttK9X5S5JdotgGpdsv3RkNxgV8ZiqG8dKfKzs/yd446fZq3ymZr5Xv
Isnc3+B4wYrzLZJ/VzKTpfuVbD7S5Nze0vsS7bdp7c0dwxPyE5TDMsnfpbNp
OpsuH+t13Kn3xTq/KL+dwvAP2e/S+q3WuTH+PaOcM7ntluxmxd/d4HWXntXY
kezr2q/S/nbZXCi587K5S36P6WxI8eyVzW7J9TRYdmeUZ49+l84/Thz/Jmot
/T69f1lzbuS4EtwqXo/Kz5uFz7cW1lkSZegb+qe91bEPNLtXOhPnDoZ7db6j
2TXh+44o8/87NaOP6En6jVptjvluzY3FVPkNLe6FNupcM16t2h9T/L30kure
UXHvjpHsndLdr/3ZzDWfk1jupN4/0fkprUcz43Uscy0eTFwPHuqAP3T7db4h
9iR+iZk8BmJe19c9P2O1nmmxn39T12efvm8Mrv8ziXuMfqF3yZe+4b0j83zS
eweUU3Nqn8uUe0+jazRTuhdK27i24v4dkP2VwTOETXoJX08lntUTuWt1XOvY
Js8RdpFdGWPAP/mj21d1/8wujNPsxP7nJcZzfoN7in5iNsiRb5xT8xmx5+ES
ZoaeGsyNZ1UxH4i8dDr3fIMp/XCiNE5LlXdjq3McUzGPYGNL4dkG+8vSOxXl
f81cY2L7O7MfbFK7s1qnxpzXNdkv3DIQ/WKruW6uqGi9GvugL/c8gPlj8vlq
6vmalnoW6U/68vHCtt+X/MXMPHJJ67nSeIxW/GtrrtEarb+X7rHfSmMHhszj
/sg/6FBTOIjZOZO5VvTCG4kxBYtzqbmtqpivyMYHsv+y7PfDRdKfrXVW5CX4
6Z3cfPCj/D5dMRYHFfvF1Bzzdu45pZep3Su12HOF80QGDrmQOt6dkj8fY+iU
zPaaeeFk7vmdmNgfM0089NgXpWf6YentK21vkfa3Ft5zBi/CTZsiB2AL3/Tp
kcgPl1LbJqcJbcalXeunpefgodR8BC8tUK6DI8z14DmpsAyyZd39N7oe+T7K
9MeZpjfonbNxfqkXuaM/XHpGmBVyJU5yO1i6/3t0/qH0rmuyHDnAveR5PDO2
YHyo9Hlv1fNAf57JPXN9ce7Gtzl3uG1S5j5ZLPnPYg9xR8Fh+MNXLeZFfuRB
jajpUGJ8wYU7Co5jRqgfMvTUBNmap2/tWv+Jvu7Q/vPSfQAfEysx9xTmwL1x
fke1un8nSm9kap+nte9rNkbgwzop9saswvj0as3iDDKLjRXzVH9hvmSm4IL2
umd3XeqHfUfqeOdGTptStb+muv8P4AK4pyV1rtwhtYrrurwwN7Onvtwf8Db8
vaHmvDbWzLP4h5P4PwFHMOyKd3p3bizBFP68Ld7Lv5SeY+aZngF7+hrdpNV5
wRlwxPyIX0+LZZgn/uOG438YPEwv9EaOnRb5oV439vyj8d/EXIMLGNMT4My9
hz6632SuA7PInQbO4Eb9sUnNjmSemWGtRd04gMf6eOdy9zL/zMIPslNNfc/w
b8h/DzjMyc1J2MFuR6zX98L8cup7bFtu7gb7E3Ge6Ae+dcX/MHCDm5ifIclc
ibq74//VYPxP+w+B7FTH
          "]], PolygonBox[CompressedData["
1:eJwtlUtsVGUUx09bhsHpTLlzO5eHgYW8SiggJIDQdoY+JoAtCxEqLymkgC5I
aEEoxoS6UDaEDQt5iLKAoCSAcSNs0BiMJjyL0xYQ2MGKAAku5FEe/v45d/Hl
nvOdc/7fed93Ors+3FpuZl2cYZxVKbPtfI++ZdYemT0KzPoSZl8MN/uk0mx1
2mwlBhcqzJIjze6FZiuSZn/Cv8mYFbNm49EtcteC7ktwdoN3YoRZb85sMnit
4LVxpkB3otONbhenrNqsBMZpsH5E/xW2A+C3IPuZu9vIFmGzHtt9YFbh60ec
bugj6PeA/zF4n6K/Gp0GdG9z9uJvd5nZP9Cjq8z6K/xNvf1lzt+aj04Dvtdy
NyHpPvTz3kz4WvhpnPP4UoRflPQYFMtxzkKwm7nrRz4v8Pz8hv17geegGOtP
gr+S9VyWuDuiXOL/Nvz/nlhXkO8G/HuAbR/yw8jXpRxbOVAuCtzVQS/gXIY/
BN5a8H6CX0r+FiKvh54OxgT8/5y7a/C9+LgLejQ1XFbmPv6HvA/7QfMaX4ee
Grn+X9zVQDdy9zb4J8nRa3wcynjtlWPl+lAcv3Sa0L2YdVvhXcp6TpXbOnSe
Ect6+K+Rn0K+AbqDuz3wT8D/lVpMA/+D2L9a6PH4sJx3d8JPVHzChC6gM4Rt
Ab4ePg//IuU9pF7axtmIfy3I8+Xu4yvkefgFqjX885T3uHr9OP6cI5+XQs+d
dPLYB8iXoHsG/7LQM/GpA9m3+LwJ+3TksRXByEReA9VCNaynlntybtuLfgL9
F6H3pmrwPPSYFbvycQu+E/9mk8uz3O1DlqZei9Ft5c02ZDvSngv18CTeeoZN
e8Jz9hR6IPBeV08cRv8AZw307+CN4f2bsVx3B7NeU9X2DHgDxJYP3L8D+JtW
7wU+24q5Cfpu/J5qdgd6LDvgOxZHAZ067Ksjn833wc1F3tPq7WPY/BJ6z6p3
1aPq1RDMxoTPnGZvMOO+aOY0eyMj3x3KQVXkOVAutHPug9WKTlvSfZoD1vJK
73XNfIH8P473l3r8K+L5N+OzKRvZ/hB47pXzHLYzOKUKj0mxaeY1+83EMAP9
hxmvpWbwCrItKY9dPToO/77Bv5543zSBVV7tvdgO/y62NfD7k64zGXpnzneX
cqBcKIfCk84U5M3gFeL+fclbs7Peq9oZs6BbsOlIuM+jiPdEHI92cDnv3wh9
9zRiPwhdGXmvaienoO9kfLdqp2m3aedo92gHbK/2HVWK+c/gawLf3Zrhx9i+
Tjm2fLwJPyry2mtmIujhkedO/5Q/kL8JPRfa4QZeX+izq5m+Dn019NnUTF8L
fcY0a4qxGPhMaDZU77nw07PeW/oH1EL/Hfpu0MyXQu959b5yqlqtJZ7N8f+h
Hvv/AbqB2L4=
          "]]}]}, 
      {RGBColor[0.7309800000000001, 0.5606, 0.38936], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVltsVFUUPTPTmTu9M3d6z50ZiCFR2pnpFEofJraE0oBteWSKCDQVrVab
kOKHUYgt1JgQ/TDxQ00wGmM1JsZEjcYIKiGND4wEDYg/KhRBSYwUjU2IHyQ+
UKCuxTofk7PvPvu59uNM447dQ7vixpjz+CXwuxIZ86BnzL84L+eM6YuBmTHm
QNKYxpQx+/B5MKnvZ0E/VjCmGQY6rDHHodMF3XTRmEtpY5ZA/k3IxTOy81Zo
TM7xJqG7APuH4TSJ+/nAmKfBuwbeOfw6If+rb8y7zs4e3MWcHcbVC3+LwH+y
IB3qjkHeh+/19QgZ52++7NDe64hxHr5mIDcJ+jvQO2LyzRjm4L8nJ5kh8BYC
5TeHnJpSype5d2aNmapDfpAdg53bcDcMO18FivFzyLeA/0ZCvv8E/wvQsQbg
aiW/E+eSjPRmgMmBhPKk/qAVzj7uV8blm343U6ZOeRxBzhuB8wPIrwz9teAN
IK6L8F2C/CbYaE1IfxV8DOJuAPRlxFLzpEscBz3lzrtR5FeLK+cCbKzA/W7Q
zbgvg9+G71OB6FbY64Dfo7i7At4vkXS3gL8cv6Wwewi81ZAZAf8+8KqecCEm
RyL1wMuhsGT+zP2mBtWkDbl/gxweRxxTeWP6wX8G/J3gnw7UO9dR4x8C6V4H
Dn85nBdDporaj+K+pSgsiEkW/Dvyqv806xAqb2KzNav4mccWR49D5pWs8O5F
rU2Deox92uNy/xv06pxs0jZjYmy3Q/eki/9rnO+HmpkLsP8UYv0W9B/kwUYt
qfp9HAmjT3HO4FcBfRfiP8yagh4GvRI62yHfjbMOtkuuLn34vh/8fpzdcdWe
db/XV+/8h7jWJnVHfimU3wXwZ0F/CfpMKPxon3mejdQn7DXqUX8X+M+DNwLf
7xjF8GpacfQEqh1ruAy49cF2EjE/DPmuhHq95vqM9EO+bCzGuS6UzDjoCfib
hs1HcW4LNatrQvUUY2D8PCnDeCYh1wSZpcB5vSdMiWeTw4Y97CHOCr7bY4qV
Pc27Y4HmNIU4zwbSPYezxdOeYi0rqOt+fFdx5iC3EXk1FJXLQbcDiffbac3b
EwXRVyF3rV7+v4fNYk47ZyhU37B/OEMXfM3ah8B7PKM+Z79vDjTzdwbChfi0
B5rNYkq5c//xmz5akH8KdBVnO371oNus8iWfuROH19LCYqogHLb7qv+xpPqY
fTTq8ppzsd1iVXPKsGY3e/LLGC5CpgMyz4WyS7/8LkEnAbrJqhakifnJtPzR
F3PiDmU/cL9yTuk3AL4bgF0WZ3tWe2M2cDvEU1345nBG6Iv3VcfnzJB/j6/e
YrwvWPVpys0Ma97sycYa12MT7NmM8nzJao9zJ434yoHx7ynofWOdOVfMl7NJ
bDO4L3vi8Q1hnsyReNe7/qMP+lqFXD6JtAv5Rp0A3Q3d3qzwJl6saZ/Vnpzm
3POtBP89yHzm3hhiw37kG8GYjgbKiW8ye5azyvw3ZLX3f4z0NrJfOdP7Cnpr
+ObcwMTtZ2JTcfhc9fX+9nMfWvXAacTT6Kl/iKdXFB7cN+VAe7UGnz9FemPO
40w77IlV2Wp3VKx24c9p5caeYm8RA+4P0uwx7j7ifDfs/+5rNrusdjxnhDua
uO53+S5yb/MA4nzE05s75vZB2WH7osvlFGRmI+2OMzjbXL8R44yrG3uMtumD
O26Z1Swtt5pF9irx/MfXTPK/CWeIu2/YzQ9z4qy3WmGxwmofjDmb/M/FncD3
kpgQD+4C9lTJ9dXevHjcE+xD9gz3YadVrLc626zNjT2Xl23uZtbwkvuPwV7p
crp8y4lJFOo/BHfnOpcXcyL+vKPMXvTLRF54823k/5F5h/9Hker1QaS8iDtz
+x9a+BpO
          "]], PolygonBox[CompressedData["
1:eJwtlX1o1WUUx5/dO3d3X37b797dWSCEc9vdfJlOcLM5QedrCxY1ajWyJCn/
iFJyblTYCwQRFRSFNSMIoSKptLe1LILEorJ/qrmpJQTOoGAIBc0sc32+fO8f
D5zznHO+5/U5T8OO3f27EiGEJzmVnCuZEA4nQ3gQ5kJNCG35ENJVIbxaHcLF
dAjPxiGsqPDdcmS5+hC2cF8PfxHbLPxm+E5A09BL0ElJF5sS9JVCCPenQvgB
H/XgL+OuuizfD/btYCxNGiOD/Z3wW9G/jnMG2zfQ6anw3Wn4TDaEBuwPzwvh
bWTN4FXCt6HTAL2Sk61yzC/FxhDWGD7ORehhvwPZduKdTzzX4u8Xcv0evCeg
Q9b+1iE/i/4gd3u5nkHnaDGEVmLcRqyvId9TF8LL+Hgd2xp8/obucs4Eun34
e1g8GB3Q9xHDXbkQbuFuF3ij6OwB72DR+g9h/13eOSm3I5x3oR8oWncdfB6+
F4yNCeczV+OclXsS+0boYeTP4+s5TnOde6ReFTndyN8p4y+Cz5LrPPLpSTsm
xaaclXsvOo3ojmIzjuw4/AHoFzhvlfkXoVdwSgnX+zz2LfBVYL9CzLPgbs65
/urfKXqxKW981TiB/7U1rqV8dEP/i82+4B7vI/eROtfmafSHoRdivwj9ZfDT
+DsZO5ZBdHrAmyjzX3ImoVvqXAv1vAS9Hvuh4J715B2TYuvlbMm5R+rVNuTr
Y8+wZlU5tUJv4O4OZM+AMUetfiWG9grX4Bj8P+DtxH4QvhvdvUX3RjEPFV1z
1X4redZQ+z8iv8UBMFfH9inf8tEDXY1OR8o1SUE/AsZqsN6kvo9CH+CcgP6d
eVij90X8rei3cI4SyxRnc8o1b4r9pvW29UYXk8+HyBci7yKHWXK5nDa23qTe
5oXYb0P1n4Hen3etNWOatRsiz7pmWLP8WcG+VZNPoR/jbj76u4n/P7BniHGk
0m/qK2ynYvdKOSiXjrzfknJQLpohzZLeeBOytdx1plyTr8Hvj71bhsjvJugc
9W0s7wfN+p+R34tqrFp/hE1DyjtoKXhdkW010/eS793c9cLfTPwLwJouuNfC
PA/9CaeE/UF8Ho9cM9VOMX2D7KeCZ0nzXYH9+wXP6jXcfVDwTtJbaYYfh78V
+0boJs7HBR/R2mHtee9IzZ90xpDdlrGtYlAsZznXp5zjqtg7R/3QjmphXqYi
73fVvJ3aJWpDeAr6GHdXZ91T9VZv7ETeO1y7XDs+gr4UWVc2fdhXYP9F0vUM
0OcK3lWq2Y3IH6eHh6rt8xS2/VnP5iHsS7XewdpdivlnbL/N27fmR7tTMcmf
3tAl5LX1fiuaec3+HDpHkp7pSeRXZR2P4lNu2pHalZrpJcRzJrK+/reV8KPl
fb0An5cz3onajZrRvzPOUVjC/Avbe7Kuzxj+B5jdAXRKSc+QZmlD3ljKWbm/
V3CvtVMXgzVdzlc7ULtwGJ2mhDFGoH+M/DZ0NxG5RqqVetgX+c/R36OYPwe7
qt6z14p+W85/tnJTjqrNeOzZXUVMO4ltLu1dLvlp8LZn3DvNSxN8V+xdpZqv
iV0j4al/mp3JyL60M0+qHnlj60/X374x9l+qP24TdGfsXab6zaL/P4xZAdI=

          "]]}]}, 
      {RGBColor[0.76854, 0.5738, 0.36728000000000005`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VltsVFUUPdPO9E7v3BnvvZ0aLdhpQ98PoEADbTCKhvqAEhjEFx9QEKM1
UhVQ4+NH49tolGhtArWGhESbqkWMLWiIMUYSo1KJ+IjGRDRq9ccPMI3SuhZr
+3Fz9j1n7332c+1Tu22guLPEOfc3vlJ81fhpTTh3J+jLMs4NgJ4KnevNOvcw
6IYLnPs979wl5c6tiMBU5lzBc64GcsvwtUDJCvBVlBkPafBlcXY75IbSziVw
thWiSd+5Ysq5Duj/C7zLQadC8RYS4iHvXEp0Dvs12O8D3QCdKZy1YH0G91+K
e/twths8N5TJ7sOQWwL6afD/GDs3AZ40fNoeab8KdBGyS42Hvg+Xyv/Hks61
g74C9KFYPo5jbc3ono9g595Id73IOCAuT0AmgfWBSHbsCpyry0rPFvh6LC1+
nsX4XsX+dsYdZ+th60Lo7IHMKpx9jbtuS4qHvCOl+ie9psK5MdhzLdZa3FUC
nfVYZ3KytxQ2bgJ9DjLX5eRTYHntxv9ToIeQiwnY8y7uHXKKH+2jbQuhax/2
n4U9SU/x3+LEe9j4vUrnrkTO0ljXw+aN4PsJNvf70tUFvw9gvQ82t0JnR6D1
W+wvBd0O+jjoSdy1E/YfwboY912F/XWB6qizRPVTyIqfctebXzsykmMc6M8h
7D2YFN9qi+HprO5vLNXdi82GU9j3ITudVvyL0PkveHrhyyLwNIMnD1seRYxG
wfMI1jbsN2K/E3aewJ0DkB/BfyP2C1jfhO8VgeI8B/7mQD3xdqyaZa2ybt+P
JLsGdzWD3sbeQxyfx3ewXLoO2j9957rM4nASsZ1B/C+E3GlfvVEDOglddbC/
KqtcryyXHROhcjYZylbeyx7Og68GfBVYP4B9bfBnEjZ/GonvNdCf4GwPbJtG
bDZAvh96ilgTldLvKmUr7yVW0B/qPxpJd3e5aoYxqLeeuicvepMvn+gbZesi
xeYs/ps91TpjfXWgPpzNqbfYv6tLVCOToHsS6mPm6Hz/JoQdxArexxjQBmIM
+Sm3AD6Mg/4e/pV7qgHWepPlcQzx+DCrvvsFdv6GrwO6BiH3q9HPgX49q9p5
JVavrrK6o91BmfiIYSWGdawt1tjGnPqi3VOd/eyrFhdF+mcuKMt8kL4J5wN5
YVOD1RR9o1+sZdY28zQ/K3oe+yuSDUuwdkfC4ptx//607qLdnqdaYv0R/9jX
jOFsrP7eEakued4Ougk+rwWP8xXHDZ74H4JtB6D3H/B+YzUzB3peRnpvidRL
9O3+vHqb8vXgPQO+Qcjehf2LQ/Uue50YzVxPg74oEOa9ATqZEb4R5zanhF+0
lbZQJ+uBOMT/HptbnAOXZ4RVxBTW3S6bQ7tZ57H2VgaSK5pfo8bL+jwe6/8s
fF/uKZ6dNuvoO+lERhj0Xawar7U8/ZDVflWovVHrF84PzpE2yP2RU+7mGy/j
zHr6yuw/GaouC4Y3/XnNwnykHiqYnU+GwpopXzbRTuIG7ea978Sa1zXWF7Sv
1mQ5m9k7EXQeidWHR7GGkfrqM+iIzIe7wbsHs2cKPPdWCAOqTc9QrL4ajDVj
iM2nQtU+cZP4kgyVU+aW+R82+TJPOEkfKnGWxv9LsWqXvnTZrCvYG+BjmzF/
5oRZ1L0Oe3Ekni98vSlGbIZO++I/FmumVdsbg73YZv14a6ReeC8URhArnM0a
+kL8bAkUB8aD9zAXtIcYw/rotNnPWfpCpLqn7mWRfKKf9JF4R7nGSHM25ckm
Ys9+m02VkfQz52eywr/eQDPs/7lKrKU8c/q5Lx3MG/0eTguTTviylbGpMPwv
QVy/9GULa4e4zNpNYb/J3ld8ZzFWrBvq54xhvt9CDBdYPvgGmUMOHgdGXwN7
RkP1n5/R24f77Nsx2+d5ZU69O2u5SJrve2PFIQ4Uz07ra9rCuJ3Ho1BxWBsI
w/YZjvHdwZizr7rBcyP2u0JhPHGPfJOx4sF5vhXfHdB5Lta7lrktZvSOYN6J
R4NWzy/HijvvnclKJ/eZI2IR36C8lzLjhsm01zObeQ/5+mwuMf6MJ+fqZntT
MVfEbdrH3mLPsKb/A1hqMTE=
          "]], PolygonBox[CompressedData["
1:eJwtlXto1WUYx99zzs4529k5Z+d3dlak5GbbcpvOeZmow7KMtIuVzjKqP5q3
CANXNhO6/NOVWgWpZYMyQQhqWGlWzmpWEBpRaVJkEJLr5qo/CgZJrfX59j1/
vPA873P/vs/zvFPX9nZviocQ+jkVnEmFEPYnQmjn8jzok7kQpkNvQfYNdDEb
QjKNLmdbMYSeTAhPIBusDOGhEnZRCGvhX0iGMBO6v2D6LOcEus3cxVMhrEGn
CfpozrHk/wj0s/isxHdDLIQv0b+kOoRe6MfR2YF+Bn4p/Dz4q+Df5fTi7xg2
fbUhjBDvgZjv3pMcf63IpqE/BP0ZPqfEXMN2+DZ0kinn3Ao9A/9rkPehfy/8
JPg5yA+Q/9v4frJcT4a7H/B1ouD8boTfjn49ZwJ5DH4E+W/5EPYkjOEssNsW
WfcweJ2L/FVhimwd8V+BXk+8f9A/Tn5bqOck9rfzMLu5+wn9JPHmJ21TAf0a
NdRDv1wVwuq6EC7m7hbkGzkroe/kTXYSawo6vdDriT+X+N34v458NnP607aR
7RDnLeiD2DyF/mjebzON+L9C/02cPcja4G8mnzeI34DvenzsL/pN9DbSuR/7
W9FpR/dhahjHfiE1XpRwTMWO1YTwGLLLsRlD9iY+BpFPhW9DvipvPIbRGYYf
Redg2d+yrHtQvdhFXhH8tch3x90D10B/XXDv6I2+gn4m8tuKXwzWHZHf8kXy
3Uq+DZHfbgD+bvh9RdcWuDtNLXeVnFszOWyGPidyb6fRKRG/u2DsBzCpI/e+
kn31wF+A7nP4q0q7hzQbE1XGdx/+GuFfR96U8Ju2ZO1TvlOcHUX3gHpBPX0I
/qOcefXEH1XuUfXq/28I/XzRvaWYA9A7uZtN7TPg34cf5rSn3aMf5zxDmiVh
3k3+cXqqATpLPrXkclPGtrKR7QfY7Eq4x8aI/yPylxLuWfXuJ+jMR3dI/YPu
COdSfC3RDIL/PbXudb3Zp+CziBidcffAUWzPlN9bPRLoldPcrUp7B+wt2Kd8
d1NvBbEbc+63R9C/Al+h2tjeB/8n+VyY9SwI4wpqS1Q7F+V0KuceUC+ohg/h
/6KmXZXGWFgHbBZVuWbV/m/eseSjAl/HM95defzVUc8cTjZlH/L1dBl/3c1F
FnFyce+kz7FdCF+bMmbCboy7BcjOx/ZMyTtDu0MztDHjGdWsan4X47uZnJbF
vZO1mzVzmhVhKCw1M+KFkbASJsJGOz9G/gsix1IOXdClyLXUk8Mx/HXCt8Zd
w8/wleBxWZXf7Aj5bojc++rB27QLS+4dYRZD9xB3m1KeT+1qzaxmVz1WIp8N
5DBenvclNd5p2m3CQFhohjRL+kMaoa/E/tFyPU3Yf1t0LXrPpcimRf5rtONb
Is+wZlk7Wrt6JjmsSHr/tBeMobC8A/x7sL8+73wOEKOzxjtTu3Ml53vtO/p3
b9o1DUX+o7RvdHc1snmR/x7h9Qux3ynPp3bwZGo9XPTsCdMOfE/OedduJd7v
ec+8Zl9/Yh3y8aJz0x81vdo7WLtYb5AGqy8yfiv1VG1kH/KlGKPIZhc8K+qR
WdBnc65dGHQUXJNq04ytyHpG1dvCeAJfD5b81+tPXBd5J+uthNENyLur/bbC
oAt+MGvsJF+d95tKX/tFf93yrOOrP08VPYN6u+Xk00I+IWNab/odsmSdd6/+
nFZs/wMA+ggU
          "]], 
         PolygonBox[{{2571, 1368, 4154, 3575, 3576}, {3576, 3575, 4143, 1360, 
          2563}}]}]}, 
      {RGBColor[0.8060999999999999, 0.587, 0.34520000000000006`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV1tsVUUUnT5ue++597TnnN4WLRRFA0HEoi1QkCggICgoLyX6AUHQBBIV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          "]], 
         PolygonBox[CompressedData["
1:eJwtlltsVlUQhXdpS/vfyn9OTwu2VMQErYpFqdwkCkqJSMtdjTEB8ZaIiaAx
XILGGC8BE4UIiIBR8AFRE/VBg5RLgAgq9QpifAIx0SgUg7WFFtui38r6H3Yy
66zZs2dmz8w+wx9cMnfxgBDCZlYJKxuF0F0UQsTamw7hWD6Eg6Uh7IR7EtxW
GUJ1Od/ZdDgbQgP8LPhV8MXwW+MQbgM/An4b+VAuhGvRHY290/A3oj8H/mmd
B96CTrYshCvhfwKfQf929KeAyzMhXKoI4dNif5vGeSn8uwCXZ+1Gf8qgEPbh
eBv8fvjl2GsfGEIMvwx5N/ptBf9bkUs5fyz4YXBHilj4Noi9w9H/EXs18E3w
y+BP4Msh8G7wDvAi+FbwfPTnob8L+XXO6Cm1jSrO7wc3DbTOQnBLVQirU87Z
EXLXTTzPltj+19j/EP1a4q9j1aM/OrJvb2GzEXkHOnlsjQEP4LwifJhR6pyc
gjuXMrcWvB38eyF/0rkG/TpszMfeNvDlyN+y/x/kDlYevDNybpSjz5C/hz+P
3MWKwWsix64aWIs8nXhWpRyTYlvOt03BOVqB/BXnb8eXlcTYSDxd2BtHrhrx
aRz8uQrHXo/O38gj0G9AnkX8M9EfmPHdKwbFUly4L9XIYPjanGtJNTUUeTw2
Y/I9FP50EsLxtGtJOVPuNsa+W+E3kJ9hdaI/Fv97Oevzwv3qzq4DV7KnDv0M
+glynLWsnK1n79FCP9yD/iT0Kzj/L/BZcA/4IjE9V+L7KQEnefdDA/6NwtbY
rPlP4E8qvoxlfdPePPwEfBvH6iOeOWn3Ujv1swv8DXhokXUuga9Gf3LKNaRa
qlG/wU/iWwn3c1XW8kb2L0H/t7zvWneou1zBt63l9lG+FvPtVrj1fBvB3j3E
dzhYvxnu8cSc7rQTX+bh8xHy8zL8DPgnEp+1gD3n+RaqLE9ELkLuSdy7jeCL
yC2yAf8ne3aCOypcO6qhs5oH4KUF/CWx/ZpzbpUv5bIm416chg8PRd4j3VHk
40DsGpQ91dsw9t7PGS9y1hjO7864hlRLOqO9wjWv2r/A+gFbq8nJllL3+DHw
uzn3Whf33cf+NXn3ag78R9o9pd7qZH0HDmnXu+64Ht074IehOxWf3wOvy7s3
31F95X3nuvvxrEFZz0D1w0zi+YV4FsGvKXePVmKrJWtOM/h69teC4zLfZyW4
WTOowI8EDwHnytxTJeDHsLcWe93gKuwtBL9U7hwpV0+h/wr6U/F5JXwz8cwK
1nkAfgH8IvhHWb2xe1i9rBl/A/ZP8W02+BDx9+f8Bqh/5eM2uP7EsWpGzYZb
Vci3emo/eEiVbWvGDEaeEPntaGXPfeCPY89O1bxq/2Dsu9edVmNrf+ze05ln
0q5h1bJ6YG/kO9BdXEF8d4IHwN+S8gzQLPgvce3qWyWxfcC3dcXOoXIpH+SL
ZtDNkXtAvaCemUs9TYtsWzlQLqo1Twr512y7lHNulEPlchM66TKf8T5cb+JZ
pR5ZB74Lm8eDe+5u5L6832K9gf3IE7OetaqxL7C1Ie/a2sB9LcZWDf70ldoH
+fJR7NmpGaJZsiftt19vbAbd5xP3lmb0C8hR5NpWDaoWD2T99vazmniLk8i9
o5pSbb0WeVaqhlRL+9J+m/WPkYs8A9UbehPHZN2j6lW9wZfh+02Re0szSrNK
M1yzXDnaHHvmavbqzV8ae4ZolqiGVoD/TdzrmpmanZqhmqXq2Tdj97B6WW+C
3obplX4P7wU3I0/OWNbM1+yvK/inmaJZpZwqt5qZmp1H0+4lna/Z8WphPijn
P8ONzLiX9Obo7elOPAvVUxfgTsbuVfX8CeT/AUqKNcg=
          "]]}]}, 
      {RGBColor[0.84366, 0.6002, 0.32312], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV2lsFVUUni6vrzNv3nsz03m0UHbjjyIJoogmxg0wgiCyaWIkgsaYGBSD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          "]], PolygonBox[CompressedData["
1:eJwtlllslFUYhk9Lp+1MZ9qZ6V9K2USMJkWMGy7RaCKgSMTIZqKRCwRjYkSM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          "]]}]}, 
      {RGBColor[0.88122, 0.6134, 0.30104000000000003`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH1s1lcVx2/f+3te+rz0eda1nRtlLEKJszBC1AQi0vmSCJNiwZdEjcEs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          "]], PolygonBox[CompressedData["
1:eJwtlUts1GUUxT/svF/MTKeWabEyqAnURKEhBhcStUVhgdCprdGFGENi1Ihh
qUDjI74aEqkbJGi04obauDAx1p0vMNGYUjVGhUpbSqnBtlgoJqU+fsfTxc3c
+7/3nu++p/Lo09Xd14QQ9kMR6GIphJuSIRTg96RDuBX54UQIj0CzmRC21oXw
Ivpt6P/gdwtyN7/rkH/jtxX5QWw3I98NP4l/I983SQ/eC/kQDkVDOAMdToXQ
js0b6CPL+Ia+E/u9+CeQB9D35UK4i8B+jIUwjn4C/bXYt4B3Fv4l8A6DNQF9
iH0SmzZ8W0hqM0m0F411FqrCf4LP7+Afwf455DPIRfDWKz74HcRzIOkY16Bf
X3LuP4B3gvyfRO5F3og+ztsR3hiFH4c+4P1NyoFYK2BMYztWMrZiHod/tWjf
Lr69Aj+3PIS1yJ3Ik9gMI69AbkPuzYbwDvlPEPsQdBzsvfjMol9AXkAeRL8I
PwWdQz5dci+U0wj8Beh6+CfivJN2TIqtB/kO5AHeKJHbjfj/TPzz8k+6B6Po
v0F/C/oN6KfR35tyb8+j/xjbbSnnopqqtl3QvoQxhDUL3QA/wHs7wIsXXCvZ
yHYnNd2O/j6oTO2bsWmNOWbFfr7kWWtAnoIfoj71UdfopGpFD1rh14HfAtYC
9eivoebEvBH5WXz6EraR7aqsc1FOFfgy8VyNuqfqbWfRs6SajxFLBZ8tUeOt
gr+a9ywMQwvw+7G/GHUP/sb+BJjv1/hNva0ZUb/zxFcmng7q9Rj51ONfj+2n
OfdS/ZvEfw821aRr8Ayx5ZAblnnntHtt+G8InlHN6vxSvv/3CNvnoQeSnsGD
+C8W3XvVWLVeXeve6w29tbXWvZGPfF8n3jXKhZhX4n8K/EM1npEG9NPYHSC3
Jr5tT3mntdvaYe3yVxnX5jswvwa7sWAs+ch3JO1d7166Hf1F90Y1OQb/D/or
Me/En/T3rbx3+TZ8jsC/mTH2U9gMgl1f8O5on1fAn855livENwL/LfbL4U9y
QzrAu4KcQd5FPJfhowXfEu1wDH5K9UfXDl1H/9rTfkszrFn+jJxnor45LxNP
NeW3Hgf/V92qOvuqR3fCf1H0bGrmZrA9V/Is6yYOIs8hN8PfDB1NG1PY2vHP
0b+Hf23c81KH7u2iZ0k5/iK8pG+FYtoF1lzKtVqpmhW8o9pVYXbh21jnXati
0wB/e8azrRk6jr6ctu4evi0yn00Zv62ZPlp0zVS7ndpxsGcy5vUfof8K3Sjd
KtWwqeSbrdutndXudoDxfcw3/d2cb7Jus77dD/9R1vOmnPuQi1nPmnZAu6Ad
0a5oRrrR9+cdq27+sbxvmGrzL/oe9JGMee1gDH1v3rXRjB+E78l7dnQDfsL3
tSVZO/1lyjdCu7WPeC/n3GP1WjEq1gvgP5Twf97akm+w4tO35pJnTrOnmZvH
dirreuumrOatS3wbinhG/4IfBX/3Ev4p3r+U89vqz3DWN0P9kM0Yugo+5bh3
qD7vG61Z07cB8v8PtEQKDw==
          "]], 
         PolygonBox[{{3559, 3558, 4130, 1352, 2554}, {2562, 1358, 4139, 3558, 
          3559}}]}]}, 
      {RGBColor[0.903, 0.6275, 0.2993], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVVtoVFcUPc6MY+bOvXemNzcNiq9YSxKNFlHBRym2ttWfUmvRCi0KIoFq
oiYfaisBCYhG8EPEVlvaQkVjVdSPJJNKUaiJpXFSaCUiBrQSfCM+UIMlAddy
7eLH4ey7zz77sfY6+1as3rB0fcI514WVxHqOj1IIsyFXZpxrzUhfjb0Kq9T0
lCPIP2d1NpiQrtJsuqB/C3JxhHNTYPhr2rmp2I+YT97l4p1HsXOflemMOp5T
/gZ3UxaPOUzjORSTIf8HeQv2W4Fz3bg0c5Rzc33n1kE/qcS5Zzgbm3fug5Go
CbqvLTf6WwX7Kugf5BSLcej/Gb4d6kjCzwTcXQSbLtiew5oNm4eeczex96GW
DPbh15TPV6i1PZZ+kSc72t8JnXsdPs6a/axI8h+wb8T6Frq/fGFErFhXOer4
DsmMRh5rsPfibMgpF9ZIvzvgZxh+dmI/hVhbYLcC8hXIb+K8iLhXE8LgLlZD
VjU+jJVPU4n6uz7Q/gPs3wP+m5HDQuxzsOohv439TFp3aHfNU26dgfKZMUo9
OJ+V3Uzk8Aa+OyBXQv4TdodhHwLLi+aHONRk1EvWOz2j7++hv+/Jvgf3DsJn
AbrHyLkB5x1YG41n1caxp2n1sQx2tagBpm4ucp4O3d6kerkJtrVJ8boN8m8Z
2fXju4i121PdxHAooZiMQf8OvXmOGM2oZUFKPoiDn1d/JuJ8ICGs98DPdeQw
CX7KA3GC3KiD7npW9S+Dn3ReeaV85cC77BH7T9yIyQXLje9yCeopQP++Jy5Q
Jh8OeNqb8+oV66rLiNPE5ItIPvrN/2VPmBxHbu0Wi71i3ZfS4nXRbBmXmHWm
FXNFrPNm3O1FPftwdjIQTsSLvWJv2gzbOpN5Rj3jMdaCMvXjXeyBYUgse1Ka
OcSXvN5uvWuzntMP8203nvTaOyf2p+19ELd24wltOiwu7x/KimdPkNzfvnIk
X+YZz8n3VpsPnD9LU+LCh9YLvh2+IfZqwN4V5wnfL3lyPBJvyd9jkd4I30qY
1H3i2e2prv3A7YSnd7AdtQ9nxeOmSBy6aj1jvTX2RhqsDub9P6bEc3mkmcPZ
UxWJG+QLOc1eMvb8MuXJebMNNoOwKcD+Hegb4ecfX1g1GG7cG03+3dPbWol7
O3PCuhV+sL2csX0o/kZWeHUCz602Zzlj2RPONeZPHhWMS4zNHD6C7x9D9X3Y
F2cKhuc5i9uS13znjElAVwjVk8WQx8d6k92I/2WgWbkrp2/qfwr1dhmLvogF
+8FesofkD/tI7vcZ/y/mtJPvfEMtJYpXY++FmBy2HJhLuXG4wlcNrGXI19zn
nH6APHdFend8fy2GIbGsjsWxe7BvicQNcmQWvpuQ/9NQ8+O0Ycge1tnc+zxS
Dsxlov2nKvKaAW02B36J9C85Gklfb/wpjng1P8Yg1lrE6A+FS5DUf5A7sSJv
+d+utf9QvflmLgPZV5jxf0LMORvHwWc95Guhds5D/pMqjRulNnMu2Buj7x6b
rTzfav7Zz00livtxLPkSzu5kNN8Hc8oxsJ7yP0H+8F1MicVJcrPf/on/hsKS
fln/uFgxbxsG+yxPzm7m/CnufZJTnktymne0ORGIF/TPHrwAUyM6Bg==
          "]], 
         PolygonBox[CompressedData["
1:eJwtlGtoz2EUxw+bXf63zW+3XMamZJtbYmluuc8bucUUIaEwEy9mpYVFzFu5
NKHkPsYrGy/IPeO/QrywckmJvDCXjWmLz9f5v/j1O+c55znf77k9hWu3Lq7q
a2Zr+JL5puSYbUk3O9rHbDJyRWD2KsWsJslsb9SsM2ZWi2Mp9m8hszrOPiKn
811BnxgxG5dqVt7PbGimWYzvHHcHABJFvkS8vFTX89D/hs1+E/8X3y5sewLX
93HnKLHfgTec2MPQ3yMvCblcCYc36D+yzUbBdwzfWWLND3ksxVCsejBy+vjZ
bvQWYjYk7g+G62X0Q+hl8E3D92vIc1OOXcSfQQ2qid0N33ywCiLOXTEaibc8
8NqoBh/AP4DeC5bhk0K8Cu7UppnlEr8tAxzuj0/UpwD7KTCmJ7uPfMVJ3JRj
btRzlC68ZvR29E3JXpN2uM7jmwtcj/Cwn4fDTWwBPr39vSfqzW04TYBbD/Gz
iNWKfQF89mW6/SX2ZdgPcrYuyWPUI5eT/850n407/L9EHGsxByXwPRb1Xqne
6mVjop5jyO8z/o/Cjq3848RLjnht5HNQs4VPdZpjbuTuSM5u4B8H/yr+J8i3
1JzzSeTykHPVTGo2vyX6pZo+QP8U8V6ppkOyfabU+271BFsHZ0fwvwBuBbl1
85/Tz2f0MfgdYBahd+LfG/aeifsL9Pdhr7Hyf0L8RRk+M5qdw9y/hq0p6rLO
vhO7AX4bkjynEvEFv4jzYr7TxKuMea9Go59BX5jhsTVT17jbGnVu4jgIrKWB
c1HPmkK+k/Ldwf2ZOV4z1U41XQDWqsDnXzmtDpyj+GmGBkZ8xjRrW9Dz0Qsz
fTZrKNcfYt4PXFeN7yEXa4dSPKfN3F0PRn2ax1ftkhL91UzU4zsrx7mpZsXa
hcBrK0734P80sd/iFEdui/jbo5nT7FVTk+Po29GnobfEfPaEKeznEbdt45uK
/W3Mc1HM1yGfOfXvFpgPw/6miJt2dH/gNVft9YboLfmZ7W+JMIVdmNh39eAy
/mVg4PL/jZyEXBf4bCmfuyHnIC7yeaZdDxxbM1wF9srAa6WdXRH4jGhWtA/a
nRGcXcd/rGof9h3VrqremqXmxPulN/Ri4D2QTW/UdLBnyyfFe6Re1dHPHvOz
Iu1Chu+metSF/DKL/lPLzdyPw/cfuzPMNw==
          "]], 
         PolygonBox[{{3830, 1149, 3124, 3533, 3534}, {3534, 3533, 4123, 1349, 
          4124}}]}]}, 
      {RGBColor[0.909, 0.6425000000000001, 0.3179], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VVlsTVEU3e17fe279917X6+2KjGGStQYhKjpA+GP+kGMkUgUqRjSLyFp
JQ0JX4bG9GOqiOmvhkQMIURblVBjJGiFn4pKRSnWso6Pl7PfOXuvvffawx22
dvPi6lwzO4lfAr/hBWYfcdGQY3YpMkvlmY2OzT6lzZbg/Xxg9tXJFyH/gE4u
9CPIu6D3G3Z/fLMxkK+lzCbgfJox2wab2cXAAl5dQnotsGmE3BOaDcJ9LeTP
uN8M3XTSrAO4Q7LAwDkVGFOBdRuYD4F/D7826DbD/yHYVcC+BHrrILfgvs+E
R3/0dRq2MyD7Wf0oN+JuPGOG7jEPPrPC6Yb/mXnSWY+3j7AvBZaH8z38tiOG
pbCbmG92LqH4ymP5PAIcH7FXpxU/YyQPU0w5fcAdYO0BcG7xHnavcM5LKvcw
Kf5BlQ3IU770W1EszGk4K5OKh3FVuXyZQy44+gn93cAchTo25QjnKs4u2JzA
eSNHNS0zcZWfJ/vLkeR2+HgaCXtZkdmXpGypT+yx5BlvJYH4Hgifp3z52hTq
P++b8P4urbq+AF6QFachzrueMK6x7k6feM3Q74av/ZF4JJ8LId9xXN+NFQvz
YTwLi5QL+5T9xz5MAa8q0Psz4B0M1G8HAvUB5RLHA/Onj391SqrnyfnOAtVr
Nfy9Qc6rYvUSZdZoYFZ9y/4lR+SqDvIHXzL5a8uojjNRgOeR7D7hPRWodgs8
+alJyFdnoVk98LdDZ0ugu7HwW+jyZe3YL4yPb+1OZm9ML9bMzMB52tWiG3Ht
iVS/vZHyIz5zrI+EOQc6t9LqyfmwHedmlrPLuNi79NU/Kb7K3Jyw1/aHqhU5
5Fub60W+XfYU1yL4meywLri56HC7hXUl978yiq3DzcVw/N+K/52h+OM++t/D
/V0fMsY21/NngD8S8htPM8TZYA3O+LJhruzZ3pR21mPglwHzeT/sqUJh7oDu
rGLNXg3kuUXifQNiGJzVjLcGyoG51EJ+EGg3/EiLO3LYAuyXnvbRW9i2hort
Ne4qI9Wd9V8ZK9YW+GqGzhrIj0LF+Tul/twXiddzvjgY4XhocjuCMu2Jswx4
e2LZJjLav+z1Bvha7vbLili50fYb8quLxUkO9KsD1W5SLC7IyS9wYxnhcK+T
C3KyMdTM3XA7lvFw17A/WUPuONbxtqeZqYVteYFsqdPeT7m0ZjSrnNljgb4P
o1yOjGV2UnuJfcY6H/VUY/JJXk+E0jkeak+X5uuN++FwSr44e+yhJ/DTV6j7
s76+Geyf+5B7XH98x7muQL3I+Nkj5L3BzRLz5J4jnu92BeMtd7nzu8j+4reR
3zPuhy7EeyVQP/RG6iH20uNAPU4d9tD1UHvpoNNlP5CXm67HToHD87FyHIpc
/gLiwAlf
          "]], PolygonBox[CompressedData["
1:eJwtlVlIlWEQhkezU+ec/5yjf2oF2UIZZFTSYntdVNBdC0FFK4WVFUoZQTdd
aFAGdVOUYHmVlgQtELRCtFPYYtFuCGWJ3Si0kaX1vIwXH8z3z/bOvDPfP2JD
2dLSdDPbyMngtMTMRqeZDepndjY0+xY1m9HX7Fgfs4sJs4a42Q30AzH+l2V2
iW+56W4TzTR7mzLLQ/6KzRvkDuKdwXcX9u1Js2ucXHSVfLuO3Eb8sdhXcD9C
rK2cYuRv2D9GNzxwLLOwCYi/mJgx4cNmCfIrbPLBHUG/KNtsO/5P0PfjfgH9
E/xbwRcl3k6wfyHnTuQt+NxM+DfpyogzM8fsddR9hUFYNmPPZxvVH90As1Oh
+wpPHfJdzkTwFZJjWKbXqFob8O+k9knoS5CbwHSfXCvAuJdYg/F/Ab5N2Mex
b8O/CaxXevspDsRFNfeeNO/ZPe7NYBiDfzk4X2L/PHDfJDHmAPQ0OY5H6Dv3
A8R/Gjj2kZxX+G4jXxa6At3RtcedqwV8WwPWZfg0IRejnwLWE+RPJ/5yaq5B
PpxybjQDh5APcjoznIMS9LNyvJef8ZmW4z7y7QJTJfHn5jh29VS9TQtcN45+
/Eg5JmFTjap1YayXa3Jcxn475wq5azl7wL4ydOxt3Fu5jw19FrqJX4C8mvM+
4jV2EP9B3LnYTczJofdIvVINVcjPU87NLXweYluRcFtxJu7EgbjoQV8VekzF
/sB9HfdnCedeMzCKWs711q8enkdeG7qt5v12zGdaszSbk0Begf51xGf8Qsx3
QrbaqY/0rSXpu6gZySP++Zjb3sZnKr7dgc//XPLXYvso7jrVpNoKsbnGvQdM
E5DzMn12hXkocp/AaxMfP7H/m+W7fpWY9cSal+2yZmg+8j5i/Il4T+7GnCNx
JU7qkd/AYT69q0ZfHvcZ1Czq2zNyVSacO9WgWopC730R+HagGxe6LMzjQ++h
erle70PScyiXOF6F/nu274JmpI580xm00qjvmHZNM6nZ1LcZyI1Jj6WeviP/
r5TXLs7aselKuU45f6d8Z9VLcfSJ+DUx76V6rrdHnIt7vXmN3P8GPovSi5tk
pnOtN+ShuA2dX+24oT8T+jxo/+uRjyb8rdQbqbdSb4q40ptzB/3vqMdSviHE
3gWm/RHfYe2ydkS7ojehO8t3TPWJs/TAORE38vmC/mTSZ0dvVim5m3v/B5o3
vfWqSbn0ho7E/z9IAtrS
          "]]}]}, 
      {RGBColor[0.915, 0.6575, 0.3365], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VEtsjGEUvX1NZ+aff6b9ZzRSpai0NrQk1aWF11akCyQWmqhH6xWSLixE
vAXxinguSjUkEoRYmGJjoeLRtNpOq4iqPkIsiAVpcE7P18Xk3u/O/c4999z7
/bPqtq/alm1mh/HLwe98yOx7rllzltnphNkT2Nue2VPf7CoShuNmn6LyB+H3
J80qwmZdMbMe+MMAexOT7QTOJdwfQHwM5x7EzzhMYjcDczVqPgfOM2AeAOaB
wKwBdgnudiHvvK/4R+Sncf7huLV64jpeaFYfVi0c7S1qzMX5HWqOIqcfwbXA
XJbS/R2oNR/nNOLzYB8A/wLwB1B/Hc4DiI954lsOnCJgluFucR6wwaHdE69O
+I9D4tqBcxv8Tc5fEOi/hYF4UQtyG8LdDJw1iIfBcz3+ew0+74H1Dfe+4v/K
QFhVsE05qlVj6ol8qOcr5HXDzgYv3+EzPhIxW4Hcc+jpWlz3lqGvO1Fh7Ud8
BHodAX6Tp37Y10zgDLq7Z33NvyosnalfSZ7qfXA8yZd9FLs451Obq//ScfmP
YE8kNK+TsB0418GPoO/SlLidimsnqHUD/FL4U+G3+dKNPNlXPfKPgc8oOG71
pfPZhOoy/g85O33NYhF06wVOJeJD2IGWuHbpOmwmoV76YGcUmC2HPx32PvTZ
g7tHgfEZeZvBrRaxaIH4PHS7vws403CeE5PtQHw0rvgIbJmLv0S8GrGNOdp1
zq3C7VKjr/jlqLS5GJLO99xb+BmRHr57Ozc97e1xcO5NKr4xrhltd5h7w5ov
NeVOcZ+Jxb2IunfBWTGvxs2Ys+a+HHfvavJ9lCC/nHcLdXcX6te4XeQetcIv
ygcv2OyYtP8FjMvAPIycK7605C6wxoZAZ2r8KiLsLcjpCynOnKUp9bIENjsQ
h32e7IR+pnmyZ/bLGDVkfH+guqzfDl1K4MfhRwqkA983+ZFnFvkWSvNbnvRP
O3zuHGfNmd9NCL/R7RS/FXzXX5J6F5mYZjy5C/wW8J2+AGaH+/bxWzgeEjfW
nuznb6H2nnPgGz0YKO9QIL0vZmle3PFq139VnvriTLm//Ebx3XW7t8Pva21C
d3d7utsUFueJfQ9JZ86SNTJJzYB990a0T9yrxVO051PypcWNQH4L7O+EePxJ
SF/y8X3t9pj7/lSnxIFcVqbEIQP8/w4z5XY=
          "]], PolygonBox[CompressedData["
1:eJwtlElI1XEQx8eX2tv+vXw9JUuyEqpDpQXpsYMt1wiDFCISskXKosKDQQdN
K8hDi7TYIbIy6NACHbLlEpRFKZn4NCkKc6HoUF2KsD5f5h3+MPObme9s3/kv
qm3YvD9kZjV82XyjUbMLM8xqUfpmme3lK+C9IWy2LmX2MmY2kGXWiE9F0uwz
9ivIcwEpjpu9QN+KfxFvvchB4PJ28F6hv59jtgysS2AcAWsYfUnY394R/yth
9g/bKfQ68j2nnjbi/+aaHSdfGv8oWOPk68f/NhhP8C/iLYT9ADl60K/yNWEb
w7807D3swdYG/nd8O8C7gX0IvSjHbAR9En0QfR56Gn0MvYr8e4idT75CevkZ
8f40o8hss5O8NSEP4z+B/2TEa2/hrQPbeuIrzGc2Tb3Ngc/uGD7V9FeZ8tmq
JtU2nee9qIdu8LLiPg/NoJn+Fqa8PmEWI3fzVjDT5x+jnmv0WEl8Pf5XyN0X
eP0biFmAvTXpsxSmZt2O/xr8d+PfGfUaVaswurC90UzQR4nZRmwZ3yPkft6W
I0fizhXN4z65VvP2OGO/B/4K9J5cr+cg9vKky8rRG3MM+cpnJfKDwHtRTzfR
u/jyZzrHnmKrp6apkO9T3LwFxkVif1DD6YRzStw6oX0wy795vmvx4Si2CWIO
ZTvep6i/ySaMf/ieTfgsxKkzyB8Tvstv6B+QG2OO/RaMLeg1SeeOZvQa29p8
OJ/tNQ7GfSfqRz1cx3dxyn21wxLk/sC5pR1pV+KQuCROipvKoVx1cKQc/6mY
70L2NLbqpHNVmNqVOCVuCV9cHqCGpWG/Md3aYc0rK3ND9Ps15r2JwzuTfiOa
rWJG8E8TX5bhZyt4nYFzUfeci+0c+kZzjPPIb4jfke03cjXwG9R8hfEFvPaE
72oJ9tfcynDm/oTxGb0l6fMWP0PgD0XcdxdvdxLOUe1HHCxNOsfEn0bwN6W8
BtVSpRuilvHM/0kzLgHv4Sy3KcezqP+T1It60r9GPUnXPysB1uWo59aN6FYK
M/sShybR0xHPrZr2BX5z4rduYBX1/aG+shyfx13sfXH/d4kjQ3N8ppqt/lFD
cb8h3ZJmGI57DapFGL/x/Q+OVcz2
          "]], 
         PolygonBox[{{2782, 2781, 3791, 1122, 3792}, {4775, 1814, 4774, 2781, 
          2782}}]}]}, 
      {RGBColor[0.921, 0.6725, 0.35509999999999997`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVE1LVFEYfscZp5m5d67OnUsmLUZz4aI2fbqPgpZl2SIIyihIsJlNFETL
hGrTB0T5QVhC0RdYEdkfSIsiStKs1AllRgaKoCJaaM/DcxaX8973POc578fz
ntbuYueJOjM7iy+Ob3dklqo3e9xgdtIz8xNmn/Nm3aGZF4M/Y9YJTA/AxaxZ
FYc/ADOEPR/ndsD+B9/zBq1LvtkT8HTAvxUcw0nxt5vWW/hfgd2YEBd5irAH
wN8Oe29KZ8k1lBH2dmA2GQgzhhiOIZ4N4PqFO//iiwHbD/9T2O/BsQf7H2Gv
BaacFo74vlDx0r8E3M2szpLjC74C/EeAmYXdAnsO60xaeY7BnnYxvMiqFqxJ
CeunvKsLcq8Bvxn4FeCrnu6Zgn3aU67VnNk53NEE+yXyq+BsE3Isgns7Yovi
yqEG/xbUYgack774ec8Z8KwGrgT88UB1XIC/C3cM4twp10Paq0zn+E+7kpPN
Ps9nVO8pcMzCvoF77yCuxaRqtcuUB/0JcJQdvgJ8a6Qesc9rkH8bMIvw14Bb
n1I+SznpZH+DfDXX64v4/8neI+YpX/4++C7j7jiCvIR1Pi8sazYSqCbL1FVW
saRZj0D3NsN3Ia6z3GNcrCNrOOz23gL7xlPvD4TSOrW4CXZvVtqcRt8mMsK/
Av4+8AOoRQyYiuvjeWCP4r8Mfw2+a1nVqYqzBn8//Pfgfx2ov1nsX08q35GY
uA8mpLm7nvaWc7rnt8OMBuI8BL6HgWZwNKN98jNW8pVcnQ+H0i31uzHUvHBu
3gXqHXvL+rLO067ejW5+C5HmrSUSH3VFzh6nQXJRE+R5hlwmAsU/jnXcE4Yz
x7p2pTSzM3nxU5vNThv7EMNiXvzUL98U5sX8OBusLWtc8PUWfAuU72BSNaGG
qKWOSHNZcPrkyl6Qi5qtJFX33lD2D3DWheJ54OaG+TPHR57epjT2v+al0TLW
755moAf+hUCa56zMOQyxVxDPH3BddXFxxjhffBf4PvCt2hZpBruc3jnLzCXl
S6fUMjmYJ3vaFqmG6yK9kewB61/vSy98q/hGMPbZvOaBc7Ezo3eEeVN37Enk
zv4Hc2DUrg==
          "]], PolygonBox[CompressedData["
1:eJwtlEtI1FEUxs+MM9OMM/P/6zhk0MLXwkVtetGiXSS0LKtNEJSRC8Gcndta
JPRYjAVRagvNICoKiSKhVYvQoIiUFCPNUhwZKKLHooX2+zj/xYVzz+O73/nu
ubelq6/zfNzMjrISrItZs/GY2UjKLF4wy+fNGtnHSAqwHxAfIvaH5HJoNlFr
liW+zhog/oT4GPF0khjxcmC2n9xjabOmolk3Oe3mGAb+coPZDmJ3qP+CfRLf
oYTjVcBaxNdonrOEvQRmM9iH8d0E6yVruMasj5qmnNlZ6puSzqkLe4C1M+k9
XMLepH4P+wT9bGBPwe8UtVfAGAVrMsI7QM7vDLrA+QO1Pfg6sZ8Rv13jGFXi
g6Fr8Zd1PfSe1fso/T2Gf3PRe//HebPEYnAYTrnGF4jfCL1WmvSCfTnvvYv/
U7QtwW8r8RIYHWBVMt67eupmP0/P1bjnrKLPCqsu4b45YqcLni9NzmB/DVyr
dvCXwZ/P+NnifAS8Sfjkks73BfZGvdmtiK9m4zg1bfRfAuMbWG8C107zkeS8
u+w3wSviG8euwOdnwu9wrcE1EPYJ+mnjvH0Fnw9pPAX+WuDcdEYFu0y8Zouf
Mc3Z10LHE6f75LcWHUsz8zbrd6q7Vc0gtauBYwlzBbs159zl24bWHbXO9SC+
MeJz0fmagXnsTM7xdOfv2fcIM+WaTrB/Hs2D5qW2Dk3Rc3vS+dxT//U+2zOa
6XrPUa7wNbuaMe2Fodma4bxK3O9wAb2G8q6t5vc1XD/hyyU8Z5bcd5H+4phm
v8Dam3aNroY+Y7o7+aoN3qN6leZ6m+IorrrzBbj0kz8S8zPW4Ftlv5zy+fkM
3u6Cz4rueBf2r9BnUZp8z/qMlqLzdVfl6H1o5h8S/6E7TnmNatWTepOvF7xS
3t+a/hD9JZmCvyXNqP6Ogeh9SOOPob8RvRVxPKdZKrrWXL+9yvifJf30xqcD
70G96A9ZxF7P+TxKjxZqH2X97xNnve3/jY+yCw==
          "]]}]}, 
      {RGBColor[0.927, 0.6875, 0.3737], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlM1LVWEQxse8Xr0d7zl27hEs21ibFtXCiOw/aNMiaVNCpGVK3636oEUr
MywyqE1krdokFBZBLgy7StgHQUQZBppp5fWSLXIV9PEbnrN4eefOmXnmmeed
uU0dJ1qPrzCzTk4l50vBbHON2Rz3ImcLdom7PzIbqTC7F5hVxWYDWeK56zOK
+QFIOWe2B4zHebNN+CK+LeIvrTK7RPwC94uVZg3g9JMbVJntJq5YISzHrObu
i4Q3VWt2n3qjfB/Ct4hdxv6EPUWtFmrdDc3Gs8JynGZuqxaPB2nuSfh8p4dm
ai1wjxKfS+PnwFmPPQ9mX6zcaur+jYT1LxKGc9vA50eRclcn1Od0gzkGRl2d
2S0EHKGWgdOOfQj7LRx2oMMgPAsZaXIHvPf4d2IfJHYi1eQZMUWwusDcBnYD
+WvQYR18hkLFHyZ+HvsU9tdQfY9lpUVDIo7n8bfE8r+izgz3uUppVwXWPnJf
htLO82Zz8vVWiodjey9euynRG5XImwik3Vawj3F6iHkO98FAs+EzksX/G8wb
+F8Hepvtsfr2GfDe2xLxuUh/t/OqO8DdwzmLPUTuR7h1kTMZSj/3O1d/C9fW
a9TCqZNv70LVc99p7CXqLhH3K9Jx+2eg9/d59dlyjVyrDNzKzEQj/gvEtPN7
Gp77Y+n9Lav8a7HmwediMqN4xymG4u99eG3ncB0uTyK9zXCkPr3f3rzyljPS
qyPW2xxI92hjjfZlpiB7mvtoLA5HuK9Gyn2Tk+6u/828eDtuRayZc31ysfa4
Pt1B30nfiWVyx3PqoQ28tYnm2efa98Axvd+HgfajMZEOrkk53QN/A+/zcqx5
8fn1ufeZeZrWH0ljWsk/A49difbWMfZify7oP2K2oN12TN/XD5He2mfBeXmu
v9OfdB+vxOrBexnOa666U93+AzZtrfQ=
          "]], PolygonBox[CompressedData["
1:eJwtlMtLVVEUxtete69er+ccO+cElk2kiYMeYET2H0QQkURRQpQZSmkWTsx5
YVhU0KRIHDRLCrSgHBRmDnoR9BSkfKQ9VLJJgwiifh/rDjZnrb3W/tb3rb32
qW3ubDy5wsx2s7KszsCsjm93uVljalaIzY6sNBvNmN0pms1HZutzZsv4c9jX
yT9HfDN7v/Ef4d/AbwUsqDT7lJgtUmADeNPYc6xN5b63n/wFcvbiFzn/AP8u
NcYyvldL/anEz64GrzM0e8s6hn0AjjepdYv8hxnnaHDdkzr3Anj3wBskfwf5
DYS7yP+Cfxp/LfWr8Z/jH8KvBuNZhVkGjJqsYw6CfSpw7XWl3lwkXp/z/AvY
B6nxA6wt0gTXj/hLxKbycFI8db8Hfk3Yh2OP7aLGELUXEj8rfT3U+xc5vvQt
Fcy+rzI7T35EvLvomqRtlL2n+BOh91o9n4H/UfCn815TXLSnmDTPk3s89tq6
v2XON5EzkXUN0pKNXWs/GDnsbXBuhd8A+fsiX7LFaQFuUZX3UjWqsHsD17oT
zDfg16R+n+K8LnWN0qoZ+Jy4JmnbiD+DP1npXHQHS/htoccTVgf2bOK5mh/N
VktJj/QugtUV+llpGqd/P4uuVTPaQe5V+vHH/H5b4Dpb8Nk4Q/xD5DMmfvXU
+JZ4jnJ/sXeJ+KuC26qhWsMVrlc9bwZ/O2s875qHqT0S+WyrxiRnr5Xei97Q
HH5Z7L0Wpzz27dB7J0xh642J/1dy2om/APNJ3jHvRz7TwtZeQ+xvSr1pg38D
/d4a+6yIj97W2cC16k28FlbBc9Vj9fpx6LPdS85Y6DVUS5peFv1OxU8Ywhqq
cFt74j4Q+Fm9qRx32V/y9X9Y1Dwn3lvdcR/YI4HPut70O86XccbK/A38JX45
dj7yr2CvSX2WNKPVqf8DdF5n+mL/B6mWaoqLaspXz9X7E7H3UjPzHi3/ASFM
r3s=
          "]], 
         PolygonBox[{{3085, 1127, 3800, 3514, 3515}, {3515, 3514, 3796, 1125, 
          3084}}]}]}, 
      {RGBColor[0.933, 0.7025, 0.3923], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVE1LVGEUPjNe58M7995pvIFZhElSv0Acg5aFG4laVOMiE1PBNMJNtamN
0IflphYG1VALw2jTpkVQ9LUqIms0plU4kThMEK0iinqenjdcvJxzz3s+nvOc
895tQyf2TybNbBynCedTymxrs1k1YbbSalaGPOObTYZmsWd2EnIMJwPf51mz
O4HZDALfw1aGfgH6WmTWAd8j0OcRfxbx7fj+gnwTLvZfDvh/w/133PfhfiP8
P+C7kZR/G/zaY7Mu6Bfh09gg+/98zE2fj5Ewd8H3GvQnsO+BPhYLD3HN4fTB
tw7MlwrCTOxt8OkHoE2Qj/CdQu0gZ3bfVx7mK+Eso94AZA9iJxA7FQjXzZT8
mgvSPcjZSL0Pw2cAec8hfwlyDvYfyL+aE6fkdg2cTAfq+x1svbF4Jt+3E9Lp
9yKrXqdgP44anei3FokD1uIdeVt2/nuRZxD2Y8h9APppYKgix85YXJGzoy5+
EPJuKP4t0D0xF009MP/VFrNkWrw1JYWt4mmW1ZxqH450P+KJxxHgXAEnDfT1
FrV/wn4dPou++mXf5JKz53e9VfjJN2fAHI8D1WG9ssNKzNO+doIzyBQ0D+a6
hz66PfVbgd/DSPKVL+7I05useCE/Q7h/4Cum6HglZu7Kkq93MA77qUB8zIea
E/Geh217LDvvf0fiJp3TbJjrM+QvZx+Fby2r3NxH7h3xcydSqHELddNOEhv3
ajXSG+Fb6cXdS9ztgqw4bDuQM5HWnrNGTyy+DkY61Gvgte7rbQ9z9wuKuezy
kTdyxNlzBxZCzYEzJV+v/XUuv0KvIWYUsfm82W70GOW1p/TnjMjlvoz64k7Q
XgSuLbHsm2Pl6HT/GXLJukX3PsnPDTefDvfOF9x+/gG3i9BL8OlvUd+HvPX/
COUMYp+Fsj9lL6F2cinUDnY7znNux/jurxS037OQfwGyj6s/
          "]], 
         PolygonBox[CompressedData["
1:eJwtk81LlGEUxa8z44wzYzP6zhuYRVQk9ReEGQRtCjcStYlcVBIa9EWrCAra
RIWWm1oUpNHGoNoUtKvoCwIjitSQNjETiWLQMqKo3+nM4oX7cZ5zz7nP864f
OrnnRCYidvDl+EaSiEY+Yr4lYqYccTRxvKE14hjx2IqIH+T9YEeJt1LbwsEZ
am/Bj1ec/+J7X4y4KAzY820Rg2nEBTBTYLvpL3fSo7aMgJS8j/gS+E8tPqOz
m1LPX8v8zcSPq551Br695Kv4Boh/wvGIXqNGH67bYOrEs+gZJh/LRkyXIu6R
H896xge0dDIjnzFmjt4T8v3M3s68jg7i1No1/zP8h/H7pbmfWc7PF61FnuVd
GqRlN7U1nF2dOlb/IfjFmrXNkS/VvEPtsg7nMNyDVfe6qL2Cexu113l7lvfl
srG6jzp5T2pt2tdG4ndFnz2Ax3H6AyX7kUd5nSzZvzj7EnOIS3f+He6dcDxj
1kEwu4gX6V/O+s4XiG819SqfIH7a3J9maHcL7fbfg4duzk9VrG0lHHeJvzbn
iaOB1jcl87cUuCP0PAezL+eaet9qzbcC5zzcbYm5pfFB2Xequ81w/iq9Aphs
xrVR8o8Vx9LYTu9m1W9TGm8QT5e9W+2kF3yObyLvGWc5e63kXa4jP01+veTd
TILJgx1PPFszf8N3JbEX5X/Ih6rG680fIn6JZ57D/zfam/pN6f70ppbK3ql2
qx28YN6piv+NO9TO0f/b7l32U7tPr5BYi/aRTaxRWjVTWkdSa9E+j6TGCCuP
rYk5xCX/ehvyLO/6p7rA/wOmRY0T
          "]]}]}, 
      {RGBColor[0.9390000000000001, 0.7175, 0.4109], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1k09IVVEQxiczed2r7/LOvUEGLgStXLrM9koRCQXpwohE/LMpzQha2K5F
GLppU5uCF5RWYBvbSLqujUgG2qoIJXsvdz7MoH7Dd1scZs7cb7755szc1sGb
l27UmVkv5zDnTWz2rMGsEMyqqdlmvdm1xGyR+BzxQHz1qFkH2Nmi2XST2RSJ
D7GdR7gXzM7z7UNk1nzIbBL8aKb4CLYKT5X4Nzg/5pj1oupMw1/m/hy7z30e
fwr8cfwJMF/qhWuGv0zuOHXvUrdSUu59sDNBnM79NhZXTCzilPEXiHWhYww9
Z7Al8lvguRippmO8t4NE/dwK6tNjG/T9iHgNXI23GQ7q3d/A38i17RK/nkjr
ILafs44/gI3gewW/oW+bezv3H9gV+PvALGPjRrMh/DX8riDs00hv7/mu41gQ
zzt6GcX/jj+GvZwJswjnBTj66fGA4Z7O5J/CPk7U5xPsTJNmtUSt8SDfY23g
roBvx57g9OJvNyrP/flck2t7Te7JTLPwmWyA6wSzlUqH6zkbVMP5z4F5id8N
1wvsn/ydZ8FczaR7oag3niho1j2Z/O5M3xyzQt4q/ffgzxH7FCs+EqTd9Xjv
v1Nx+dxcq2v+m2v0ufi+/SzJ/z8r3w1GbcuJON4n2lff2wp19lLpugPf7SD9
vi8+N98l3z//5pgK2Hux6uyU9G/V8t3+XBTed9Bn6LvkNb7mtQbo91eqXOd4
ECtvP5Um17ZDL/8AgQ+JeA==
          "]], PolygonBox[CompressedData["
1:eJwtkjtoFWEQhSeahHt3c/fG3RVUsBB8limN2CYooqDgAyJofCRpYmIstBCx
sNCIVoJaiKAgiQhaRMvY2Nj4wAiJlSA+4o2ChcEH6Hc4t/iXmZ0zM2fOzJr+
E7uHl0TEVl4r72Eacac94hfO9XrEId4c9jveYez5ZcRbImbwv2J/6ojYVTH+
BvGBMmIcv6st4i9+X93YKrWf8fmCv47YdvzbtYh/5Af1esFMZhHTvH3YZ5dG
TCURlRwcfCbBXEr9ZKvnKnrdA98DfgT86ZprqrY4DBK/Rr/FVtd4QO4Y9Va2
mN8p7C28pM0curG3Jc4Xx8/kXq6Zizj9IP9WYux96i0H/yS1rRpT4M/DZ1NY
w4R4o6BfWMOFwppKq7vEH5Gbg5lod45yE/Q4Qnw1PTvp/ZGcroo1Pwd+APwO
1cJfwN/MjEMVa3yA2sOZtda/7tIaiv8HegzmxgirmrP0msP/wwHsx98Ifmfi
3uLwKjMH+UfxU/CLhfXUTD+x++u+DfnHwN5szqd5XlbNWdzH6d/gXr4X1kL/
vhXemXa3l/5r6X8y9260gxHsUTisaN6PZttQmqs0eEPtNLeWuomL+BdS91IP
3e5Q7tml13vdXulemlmzz3fYFof1xGar5q597sFvpM6VhsepdabJVzf3IvXO
hdUOH+P3lcaL30Hsicy3rZvR7UgjaTUKh17irzNrq5t8Tnwmsy3N32I/rbuW
OE5L28Kzage/sXtK15KvW7/a1E81rmD/BxNWh0g=
          "]], 
         PolygonBox[{{3337, 3336, 3058, 1111, 3776}, {3023, 1094, 3752, 3328, 
          3329}, {3329, 3328, 3754, 1095, 3024}, {4072, 1317, 4071, 3336, 
          3337}}]}]}, 
      {RGBColor[0.945, 0.7324999999999999, 0.4294999999999999], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkjtolFEQhWfzYvM/suv/r4WVBMTCXguTiKURsRDUJlrYJAFRWdOIIARs
ok1IZeULUmilRRSEmAjaCBKxECUI2uka1yj4BMHvcP7iMnPnnjkzc+YOnzp7
5ExPRBzm9HLaQxHb+iJmsGtpxOtaxIU84mXl1/Cb/RENzl7wn7dEXBmI6GCf
JxFXIXlF7scGPPjjifmEWST/dm5Ml/djfcZkxMcL813ifYH8GrGb5N6n7hP8
a+AHc+PF/Z4zTA8HydsFz134n4JrFfZL7O8yYjtvl+FIKtws3D+4fwc7n/tN
mE2wj+DM4VwfZAbOP+I3iI22PIO0+QJudz1iA3u613jpcj3x/Q6YJrz9iJpk
Ed9Sz/mY+HLDuu0v3If6KfCfUesN/kQ104sBa3KSexeekZZ1Vx3t5FBhzFv8
NHMt1ZR20nCU96XEHCvSsmnNpf1F7juoNQ33FGeT3EnsSsN7XcVuLTyLZnqQ
Wtcl4qtD1l97mEvNk4L9UPU9jX8r8e60w2XOUWkLdqNhzVNy9xXGCDtSr/Tv
sZW2mlk44bUr7V5/4B7+DLkdZj+P3VP3XoTfiUbHuXcy96qeH6bua7ZuXTJy
FsnNsX/Z3xjxP9huaa6v2BMt4yewP0v396v0rMKrz7HCe9Q+JysN32WOqQfN
NlVYf+1B/0h6qiftQf1rtgPUaINfY//nwH8i3i5cS3HNvJ55Pv0F9a4/o/h/
QpN8oQ==
          "]], PolygonBox[CompressedData["
1:eJwtkjtoFWEQhefqJiZ37+4mu5silQTEwl5Bk4ilESvBRxERrBIQxWsURBC0
U5sUgp0KIYVWEURBJFGwCoiSQpQgaGmM8WrhE8HvcG4xMOefxzkz84+cPHPo
9KaI2I0l2IEyYqQnYg/+BH4b+9Qb8b0R8beI2MBubDZex/9ZRYz2RXRochO8
lEe0iA2T8wx/mrdtieNT+Glp/JycB2nElsy5R3j7Br4IfkOsgc01IzLy53ud
f4v6RaxA3wC2VPhNsTYa9tdwFo5J/0Juk3+F+HHir/qdKw2XiN1tmkuc5+Fe
zK1FMzwkNt3dh/AU/iwadyTW1AJ/Zf5d9NtgvhNwTzQ9z2FyntJrsja3enws
nKPcnbx9ofYYeJ7e1+n3eTBiX+n5pGkvfid1L/XUri6Dh5MuZ2WN0vaS+oPk
v0vti+8DvddaEUf73FO7m+vOq7ftaLvN2wvwfWpq6kdr6xPHWO2b6nbj5P+B
bzbz7fUnzpb+E8Jr4BnwudK+/sgyXCu5/R56pGhZSH0v7bCp3EHPLj7N1oFj
a2INq+Q/Tq3vFD2GSt9It8qY5wnc71vWp5pf1I6VvrfmHce/kDumP/qD+Exu
Lu38Kr1jwNqksYG/Xvk2qlFtVXo30qvbr/abW3ramU3+P+IrxO7lxtL4mvxJ
NL7t8unWvyvvUv/vGvE7hWs1o25RluYSfkT8P9d+ek4=
          "]], 
         PolygonBox[{{3471, 3470, 3772, 1109, 3773}, {4721, 1769, 4720, 3470, 
          3471}}]}]}, 
      {RGBColor[0.951, 0.7474999999999999, 0.44809999999999994`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1kj1MVFEQhQ8s4sLuvqdvtzKhsCKxNlHiaiQ0Ala2RgtJjFAs8S8kYEIC
HY0YCzqwgkoqaPixMS6FhYk2kI2iiYWFIAgFhYXfySzFzZw7d+bcOefeiw9G
79RaJfWxcqxGUbqSlw7KUrUijYCvEedS6aRNKmXSPPgfeIF4j7UDHiL2c/ax
XRogXmfVwVXiDdYW+Cbxc4d0iXuelKSH9Hyj95i76ol0F/whCY6nDNNokV6z
7yG/UeAsjdw2eJz8BXgO6Z2Aa5v8OucTzfwn7nkPHgQPdEqz9LylpswM35s8
O+R+g7vPSPvEVnT2ofcHHpyF8w81B9T05kO7ee2N9S5yVoPrF7OOEv+WQ4s1
3Wb/gvlXOiNO5YPLtZO5wOawt5TocRb5We68X4n6n8x/4jcAfy0Gt7HvPSpH
nGa2lnPSZeYXcZX9EnekWXhhT8bgrDf12j+f++3shTVZr/HprO+S8N5v5/7d
trjb2r8UIme/i1n02dfBLHqW4Ng/H9r8LzaT0PWS+t1i+Cjro6eLmmdJzLLY
Hn+iksXe/yvJIr9C7aM05hgmrrO/Cn5F72EhvPRb+T+Zo9ERvtifPWa5VQmd
/r/uq+Wi7nkp8BtmnimF9q00NFjLMvxradS41hqsxW/1H19uez0=
          "]], 
         PolygonBox[CompressedData["
1:eJwtkj1IlXEUxo92e7nX9973rffeSWhoCloLKryR0lLm5Co41FA5XKGEoKJA
gqAlbXALxcGmmpKg1M3r4BDUYkhZINGiaR/g0NDv4bnDH87Hc55zznP+x6+O
D7e6I+IUr8SbqEW0DkWcxXmXRmxWIk6GY2/ziFdZxG3sja6Ij+RrRcQB2Jf4
Veynqe2L5YjuRsRNarbI98Jxj9ogNlC2fxd/kJr1hD7UfAU71+Ne56h5Rn4j
dU49r4D9DuYn/iQco3DdAkNJjOE38fsatj9RPwr2EfUL4JvEDuoRM7nn1Qxb
1Yjtirnuw/+E3XN6vEi8g3a5Dv5LyTvcwP5cNZdiyv2p21aP39jXcvfWTG24
p+B8CPcIsb/wfataG82gWXZ5Jw6zG/h5sGu5Z9HObex+5llLrPcy/mpmLnG+
oclzYv9KnnkR/r3U+ii/DHYlM59i++SmM99WN32MPcE71plXWo7T70divLSu
F9ZCPRqFe4pbmBb++4pvqX0uof1sZx7xfyDXBNNOfL8H7LdfN16a/cLe450p
Wz/dain17fUH9BdVo1r9kcuFZxb3An6G/zq1rZ7SQhpJK/U8X1hTaXsajbuO
8N967EvzHd2q87+k0VDhP6P7aaZNbrVz1LMptot9p2Z+3eQC+P8GR3x+
          "]], 
         PolygonBox[{{4077, 1319, 4076, 3339, 3340}, {3340, 3339, 3061, 1115, 
          3782}, {4671, 1735, 4670, 2721, 2722}, {2722, 2721, 3730, 1081, 
          3731}}]}]}, 
      {RGBColor[0.957, 0.7625, 0.46669999999999995`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkjtoVGEUhCcbI9ls9l7z321MIYg2VraK+MZCgw8sLSwU26ygoljZKSKI
iHY2EiGVNj4K00VXCxtJY7Gg4qOLYoy93zBb/Pznnn9mzpxz7tZz/dPzLUkH
OOOcz9PSGomHtTTdlWZJrhJXRdq5QbpZSft60hbiK8Q/eNs+IZ3g/TL4wZi0
1JFOleT9/oizTP45+TG42+DeIn7flr4RX+T9bC/4n8SvO9Gx3iZ0FjdKM9zH
OXvweIO8wPbHg2vB3YHOXXgvOqnlmtZ23v38baTdk9J6E9/2f61Kb+7x2FQ8
2du/Jj7sp0/No+hfgvsRvw25MhEfS54L8bAdj56Paz9Bq8X9YFTnDm+LfF+v
oq9evNpbjf7+kl6udsMxdwGNlXb6XKDOoZK6y8QD8kO45+vsw3Xvcd/uxtd3
3u9X0XyMzpCd/mYGF+p8O++ac5wPePuEl18z8bnKPUv+GfHmEo/u3X2tgJvj
++mopjGev3Wtv7eX3djDQbjr4M+AewP+JXW7YE+WzGDXZDjeiWfkeL4E82oq
vdpba/Tt/Fv3VGefX+hpUGcf77gPl2A9e9f0Ts3xvKx1pOSfNveruVUw/sfX
mvj5w/0fyP9kYQ==
          "]], PolygonBox[CompressedData["
1:eJwtUj1IW2EUPYlJifl5r3kvSzMIYpcudrVICyoOGrTSrQU7VHA0hYIWJ0Fw
EBcRnLoZMJMutkvc0kaHLsXFIWCLXVVM4u45nAwf3P9z7rnf8Kfqu5UkgFG+
FN9hFkgmgN9PgEoEvOUr0H+eBhZo/x8ExmH/Ywl4xtgxa1+yeT8HtJkPmKsO
AKsFYDEE6uzfYc1tEbjMeXbEml/M7QbubbGmwdxBaFszy5wNYoww3yHJqzww
ERlf/ZO0b4qePcSaTfb/zbtWPYmSY8q9ygDdmJiB9ymTX4t2l/n3KftZ8p3N
2lasyXwvdu8dZy6T2xlfnDaHbdZ/o9/kvC+smSFejT7S3kG7SBPtVyfHp+Rb
6+tbYeyY80PGXqQ84ztrq5G1FccV2vN9X3hztP8MGks9G+y/J7+xjPddD7yD
+H+g3+O8r4H31w226C+RU7vv6zZHgbmIk24/HVlb+VORMYR1zXdO7IfYWNKj
nbcmssWhw9y/vv7qSVKPz6F7FauGvrnmS8MW7bWC/4r+TCP0n5EvDS+Id5qz
lortkcvrkvG00xvaJzlrJ40D8v0ZeHfp94P7FCNrrxrd6hEjz1xx
          "]], 
         PolygonBox[{{3759, 1099, 3027, 3451, 3452}, {3452, 3451, 4027, 1294, 
          4028}}]}]}, 
      {RGBColor[0.963, 0.7775, 0.48529999999999995`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFkr0vQ2EUxk9Vmra37tXbG4LJ7B8QQqKIGHzEnyAmkpaBGERZmGx0YdOl
CWFqSITFgAgRg6VNxGpAMPn8HaeJ4c157/M+53mf87y3dTw7lqkRkXZWmNXg
i+xERA4ckbU6kUXAS09km/VTK1KgluKGn7oinymRB/AMeBF8FnwAjbOYSAt6
S3DS+o1mD/UN3ZeQSBztO/bn4H3guxHT3+esQp2KinD8p6Way/Bv0WwDm2Nf
cg3XO8sJkQ7473g5pqmD/nXOL/BUQS8M/9CxOxrR+4JXBF8FW2G1wp93zZN6
ewVbYD+D/p5rs15HTGswEPmAv4W2V91vsm/2zb/mpD3aW4ibV/Vcxvuobzoj
1OekzTnhmV/lK6/Xt0z6qd2B5dBFffTMh76JZq2Zf6dsNvVVdiwD1dTZ1J96
S6Kz4ViubmB96ej//Fqf8DIE74p7h6mhwDj3CcM0Z70jz1yd9J849q76vjcx
m1v/GfWfrXqb9iwX9ZBAL1/10OTbzOpzkuoEppNDr943jnJzVf0PZjzyLB99
k1+4LmUY
          "]], PolygonBox[CompressedData["
1:eJwtUk0rRGEYPcN0M5/X3JkIq1lY+Qcjip2Fj/wEZUMZFlOyEDsLS/MHZKMo
q4kSG2WSSMpqpqRsWKBYja9zOrN467zPPR/P87y3OFeeXeoAMMgT5zlPAcME
K53AWgaYD4Em76UuoJEG3nLAfsy1d+LVLFAkpgwV4lYeGCB+Yu2beJf6P+LD
ADghaaHtJ/5lgp4ETfpVmFej/pj3g8AaabdZG4JrPRGww3sp7pq+TbF2E9jj
mfy7hPNb5EwUgBGexS5napYLataZ9UH+J7OuQ9+lvyJOF6yVR4r4K+/ZNfNW
yhni3jJzhtm5yPwj1rojc8QdpyZG/V57fvV7z95+896NOD/EvZF3I32V2unI
3uqplqQ+6bfQm1TZ+2Pa3vIo03sj491pB5PUjvHUA9f0rZFwtjxOyX8JPbv8
X0O/md5COxplv9mCe9FMIfFy6Czto57wPyEvvcEZhX2R+Zqxn3iz3Y96eOD3
fyZSW3E=
          "]], 
         PolygonBox[{{3030, 1736, 4674, 4035, 4036}, {2726, 2725, 3733, 1083, 
          3734}, {4036, 4035, 4677, 1737, 3031}, {4676, 1737, 4675, 2725, 
          2726}}]}]}, 
      {RGBColor[0.969, 0.7925, 0.5039], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUjsvBGEUPeySnZ3dmZgZj9ZKRCUSrViFrFcj4hcoJUg07CYKjQoV2yko
FHReQUFDyEaLRBCFigKJzvPcnCm+nO+799xzz70zzWNTI5PVADp4EjwNAdCZ
BBY94MwH7qqAGxd4zAAfJE4wduEAT+SM++IZf4XoRkBfCsgQN9PANAV7qZfl
u42cZeokahS/pG6e3FxSuq/UamXuhThEfjvjC9T8CcX7DdVnt1a1lh9g/JO1
RU86c8RZX7EZ4ih1SuQ8OHpb/Jlz+JFqPeIRPZ1Tb4P5Ck89PVz58mqe/9i3
7MmzzdQTqZf1vHY0z5avvPWyfRU4c4U++wPty+bLs64lkP8ccYf1Xdx3Ia2d
WS/zZ9idUs17HbBE/hvxgPxh5u7pq5TVDk5d+Tb/h7yfuIpbfs3VvprY6zie
cZ3c71D6X6HmMP3t+Bub93nW7se99oi3cdz+Bfsetvci76uu7o2BdE1/kDP+
AxH8U2c=
          "]], PolygonBox[CompressedData["
1:eJwtkD0rhnEUxs/zQrjfct+3lxUlk8UqDPJ42eQTyGR4lAn1JJNBz4ZFPgBG
CwZKKWGVUmSwGVA2r7/TZfj3P+dc1znXdU7X7MJ0tWhm3bwy77XVrN5ITrIe
mO0lZpcFs0NqPanZOfk9+UqT2UwOLxU2AH8X/ij5Ykmcu0AzfNYw/O+Mn573
omojxD+ZMK9VmT3HOyjIwxtefsH7ysIfQ7Md8A/iCXoS+h+a5cU1a5HZJLUL
+vvpmSLuSBV77Rgva5G8XTG/AjaeKvaa73YUiOv7tIM9h9JzDxHzlhPN89pS
Is/ubQgPX3jdJy816GZ+uzp6g9y1l9pLIo/u1Tm3eK/FuoXvvIH2aiytCvMC
9MJcsev57vO8p3++32ozllfXO6V/rEV6bcy/Bj8LhLnmNtzOVHzf8QTsJhHX
e9xrnOu2vuMW+Gem3dyTe/sDnN9L3w==
          "]], 
         PolygonBox[{{3332, 3331, 3036, 1104, 3765}, {4043, 1301, 4042, 3331, 
          3332}, {2730, 2729, 4679, 1738, 4678}, {3764, 1104, 3766, 2729, 
          2730}}]}]}, 
      {RGBColor[0.975, 0.8075, 0.5225], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUT8vQ3EUPdrXKq/t856nkSiJf53EV9BJGgaJ+AQmCSEREoZuNj4CiZFG
LNXFpkazSUgkwswHwDk5b/jl/jv33Hvub3pzb303B2CRL88XVIAanacIOKkC
deVT4JLxbwDE9F9CYI1+l/UK41YJ+CgDcwmwQPwWOR6IjwvAfOK+g5K5Zhnn
mL+OjBN+grnPwDw3A8Bh5HiQ3Nv03+nv055zbpf1MeaX2ZOn3xkGNlLP6hNz
FZl/ivWz0Hzfsecp36G9yHhmiDml3yB/m1oKqfHqq6XeW7rr2c7iHkmtQ7fR
DXQr7fFG/U3u/zcKPA9ZV5v6bovm0bzJxFY6+tl9Wok1iOOOnD+x9Uq3/kD8
y6z3qvb1P6up77lC+xX4VtpJ89UrDU3Wdhgv0R5Fxh1nM3tFz7sPvd84dwhS
8+j2jcSYx9B84ilneqTrlfr+AfhlREI=
          "]], PolygonBox[CompressedData["
1:eJwtUb1KA2EQnOQuMT/mzjvPIBiFaEzlO5gqBAUF8Qms/QERNIWtpW9gYSci
FsY0dmLlA9goCoJorQ+gzjApPpjdnZ3Z3a+5tbexmwfQ5Av5nqvAGkE9API1
YDEFkgKwxFqL+DJmfhQ/lYFzxr/kXxeBO/YGGdBg7ZO5kPg7Aa5ywDvjH+Lj
CGgTj5PTJ96PXVP8SL251PoD9swS74zqnRLwRtIte4Kc5xtG1lDvNusd+i1n
xupR7wrjg5Jn1Kx9vq/QM55E3lFa68y9cP5uxbFucMP6Yexd1HNEPIjM1QwX
FWtISx6r9Eoyeyk3QfzB4Xola0jrgR7Dom96z3g+9a7aeYF4OvUtlTsj97Xs
W4u/mdlT3tJok9sb/Y9yXeLTqu8tzxr5Y5m9lSsQ/036lorFnUmtL/8G8VRm
b+1QJ/4HEvE+aw==
          "]]}]}, 
      {RGBColor[0.981, 0.8225, 0.5411], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkD8vRFEUxMfueqy39tmXR+NPSJZO4zPQyGp8BHoSUSMSjUIiCo1aNITQ
KlBs1kdAhw+AqDR+k/OKmzn3nJm5c8/M2ubqRkVSm1PlzOXSNsXFkNRfSEuD
0gC4k0m/ED8b0gj3Zfot8Jx+t0/qFKGx9rYpvTdCm9A/475O/5T57nBwrtDV
mc3XpAPml9yf8flD95pKb9QVuGNwOviMgiucBfiHzXjfWmfaK7M5o/X2eUyD
Z/5+Fmgf8+6SyGOeM7me5t/fLemI2Rd4k4SmW+Zwnhc8J/OYTYE/Jf+Y/kka
efynCWbX9MfBdh7vzYI1ZotkqIK9LPbgfdyn8Y53+VDu4YleUe7H3r269EG9
lUVe+1vzD+quO0o=
          "]], PolygonBox[CompressedData["
1:eJwtULuuQVEUHI/cSA42J4fGIyToNL5BJTQ+gUZF4wNE+AuFUkMI7S3uVXj8
ApXEJ+jNZJ1iJbNnzZo1a1cHk/44CiDHirOOaWAaA54R4OGRD4BuAmixufKs
hA8/QMkH3kngQ4MmuUBa1iVimh5xltVJmGbtgGXatG1yL85ene3Szhvxmf73
8N2g/yLUyyNDrwK5PXcP2R+lrIRP5Grs/Yfz4lac3TnzErcl3jjLJ48i9XNn
WZVvRlz3zUv6P74rvnlp5pfeZd9u11teukmz+qM888UCu02Zlf0LFswuhQ==

          "]], 
         PolygonBox[{{3958, 3957, 5127, 2117, 3299}, {3948, 3947, 3954, 1252, 
          3953}, {2957, 2956, 4593, 1678, 4595}, {2961, 1678, 4594, 3947, 
          3948}, {5126, 2117, 5125, 2956, 2957}, {3298, 2116, 5124, 3957, 
          3958}}]}]}, 
      {RGBColor[0.987, 0.8374999999999999, 0.5596999999999999], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtjr0OAVEUhAe7smvFxrqVhq0U4hUkGo2fwiOo/URBjUSp0Il4BVvoNSo/
rScgKuU2dObm3GIyJ3O/e+aE/XFvlARQpFLU1QeUDVzoNj1gWGNesYChA8SE
Tx5wTAPlADgYLqKvPeHSCnCoJvkMfZeTPd8sMCf3IbOklwLZE9KrlvyNEsDM
l54n+a35++Mc54XRPXvmdc5nTzjNr5h12Ddlb5uuqBbnN98bSu6/uUDB5AH9
Zf7qTt2hu/S9d1fuXDDvmp0PZhNfbhz4Ij1veMMfzVcquQ==
          "]], 
         PolygonBox[{{2506, 2157, 1063, 3710}, {3717, 755, 2118, 5129}, {3010,
           1086, 786, 3323}, {5130, 2118, 755, 3956}, {3320, 786, 1086, 
          3739}, {3455, 45, 1300, 4041}, {3323, 786, 1285, 4013}, {3735, 45, 
          786, 3736}, {3956, 755, 2157, 5185}, {5126, 1063, 755, 3299}, {4014,
           1285, 45, 3455}, {2961, 430, 1063, 4595}, {3710, 1063, 1067, 
          3714}}], 
         PolygonBox[{{3739, 1086, 3740, 2711, 2712}, {4007, 4006, 5196, 2165, 
          5198}, {3967, 3966, 3301, 2123, 5139}, {4641, 1714, 3005, 4006, 
          4007}, {3723, 3722, 3970, 1259, 2507}, {5138, 2123, 5140, 2963, 
          2964}, {2964, 2963, 5129, 2118, 5128}, {2516, 2165, 5197, 3722, 
          3723}, {3969, 1259, 3968, 3966, 3967}, {2712, 2711, 4640, 1714, 
          4639}}]}]}, 
      {RGBColor[0.993, 0.8525, 0.5782999999999999], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUDFOAlEUHHAlu3zcZdffCtl7aOEFKDyCB4CGGgItBWuCcYGCUFlyBltt
vYIJsVZC3MZ5mS1+/n/zZubN+/nj6GHYBNDjueD5CoBlCzg0gG4IrPi+If7m
gDv21jHwROw7EGecSNP2wG8KFOytyd2SV1F37gAbJ82J/ZL4LfkvvKeJfGa8
d06z/shZxJr5GQEfkd6G9TN5lm2gcQk8t1S/Jqpz9o+B8lwRr1Jx9vS+98It
r2W03cx35bRH5jXffAwPvXDrX3vltLyTWN7vkbCi/h/LZFls759Uf1hSO6/5
pht4+Vvef5qYNKU=
          "]], PolygonBox[CompressedData["
1:eJwlUDsOAQEUnBU27C7L7rYiexCFCygcwQEodBKFE/gEsduIQu0OSlpXkIga
ERozecVL5r03b2by0v6wNygAiFlFVhoBTgn4EbeI3w1g4QJHB1j6wCgEbiTe
WWPiL/cr7utl4BQAG89u15z9uNv7hqV5IH/LfuaahrQy9nP2D/aT0DjiSnPn
m6e8dfOk3rUCNGGcbgJ4iWmJUyb+BObf5iyvWSZlk8eL99PQvKRxoVZWM65u
lP3MWRWm2Uksk/j6Qc4sUWJemsXEfwTOL1Y=
          "]], 
         PolygonBox[{{3008, 1084, 3736, 3321, 3322}, {3322, 3321, 3738, 1085, 
          3009}}]}]}, 
      {RGBColor[0.999, 0.8674999999999999, 0.5969], EdgeForm[None], 
       GraphicsGroupBox[{
         PolygonBox[{{3009, 457, 3322}, {3964, 1068, 3715}, {3965, 434, 
          2969}, {4601, 434, 3963}, {4005, 437, 2977}, {2710, 866, 3737}, {
          3431, 866, 3973}, {3972, 437, 5057}, {5057, 437, 2976}, {3962, 433, 
          3955}, {3266, 718, 4602}, {3955, 433, 2968}, {4341, 718, 3721}, {
          4596, 1068, 2962}, {4597, 718, 3266}, {2971, 434, 4601}, {4012, 866,
           3431}, {2962, 1068, 4598}, {3322, 457, 3008}, {2970, 434, 3965}, {
          3715, 1068, 3720}, {2975, 437, 4005}, {4603, 866, 2710}, {3725, 718,
           4341}}], 
         PolygonBox[{{3973, 866, 437, 3972}, {2977, 437, 866, 4603}, {3721, 
          718, 434, 2971}, {4011, 457, 866, 4012}, {2968, 433, 1068, 4596}, {
          4598, 1068, 434, 2970}, {2969, 434, 718, 4597}, {4602, 718, 437, 
          2975}, {3720, 1068, 433, 2967}, {3963, 434, 1068, 3964}, {2976, 437,
           718, 3725}, {3737, 866, 457, 3009}}]}]}, 
      {RGBColor[1., 0.886, 0.63], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFUDFOAlEUHGUxBHQ3y35aE6yVSMIJTLyANRUHgANopyRaSGNBQWLstaRU
MRptLcQb0JhgDaUzmZ9Y/My8tzPvzdtmb3DS3wSwx1fiey6AnQrwSBzXgMME
uEyBhwxIysA98Zb96QawyoFz1ktqjgJwRv5Dfhp74rRiVlgv382W+6qFy8i7
3PlL/skwHeI3dy3obSf2SPMV3BtVrZVnl/Vxw3w/WK/80gnbcf4HM9RZvxIv
MvuHme+U7qXwXPmeCmeQXnneto3v7OcVf1OtGXnUXKfu3/HGde679G8mNWe4
Sn2TuHYoqzK3gjNp1zwYO1FzEP73/wH2Yj3+
          "]], 
         PolygonBox[{{3963, 1257, 1683, 4601}, {5166, 2140, 719, 5165}, {5061,
           719, 2066, 5062}, {3715, 14, 1257, 3964}, {2976, 1076, 2065, 
          5057}, {4341, 1493, 1076, 3725}, {3973, 1261, 30, 3431}, {4599, 436,
           1260, 4600}, {5053, 228, 2061, 5054}, {5332, 2066, 228, 5331}, {
          3721, 1073, 1493, 4341}, {4601, 1683, 1073, 2971}, {5056, 2061, 436,
           5055}, {5444, 30, 2140, 5445}, {5057, 2065, 1261, 3972}, {3720, 
          1072, 14, 3715}, {5186, 1260, 14, 2508}, {3431, 30, 1284, 
          4012}}]}]}, 
      {RGBColor[1., 0.9051999999999999, 0.6659999999999999], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNUbtOQkEUPBEv2WsIj+z6ATQmxmijX0CgUwp7Ch41NpD4Gcb/8QVipYkJ
xPgTJGghdDiTOQXFzZmdnTNnzt567+Z6uGdmx/gK+Cb7Zl+ZDiE36+P7hOC3
BBzMLpI0KYg/x7kH/IP7aTSLwCfgWodmt+hton5n6qH+Cvdj8H/AK/RkmNOu
mL0Af4C7BO4E6Znhvqge6rqolR3Mueyh38g931GH4BtJHDF55h34LszIvbbA
dwfKt65KTy/O5H1wzZFznMt75uH5EfuWgR9QlyVpW8j/FJXzGfUtavbMOXrR
Z1OTx7qmvrLvwrnR33aelGGR1Nt1TZ5Lz76+8/R89ffnfxh4fvqcJr3pmfvl
vtc/qCNAdw==
          "]], PolygonBox[CompressedData["
1:eJwlkLtKQ2EQhAfjkXM0eJTzi2BnY+OlUJ9ASCpjkT6F0To2Fvb2Kj6AT+I1
XjpBUMQnsAuoRWKn37DFwP7/zszO7mL3oN0bk7QAxsHFlLRUSGUu3VTScEZ6
gVDxfuD9CBJ1H/J9XTqZlAr4OXhN0hro0FdNWqFulNIf+mdwB3+dv136e+CH
9yn69yz8mmVorD3CrzEnjZj/kUUGZxnNSucTkdFZncFaz1xFe4zHYRGcX7h9
8u4Xkfmpihnm2/OM2fNoWvSG+H/idQVnOo+dvNsO/KwWHHO3QC+PGZ61XcZu
Xf426C2nuJV3HuD3luI2zuAsmyl2t+cX/dsqbm2PS+rvenj5Rr6V/9xzpmvq
f3OlOg8=
          "]]}]}, 
      {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
       GraphicsGroupBox[{
         PolygonBox[{{732, 243, 239}, {3302, 1225, 5143}, {243, 732, 235}, {
          1223, 774, 732}, {3312, 1230, 5172}, {732, 774, 235}, {5170, 774, 
          3313}, {247, 1495, 239}, {3265, 1217, 3909}, {1217, 732, 239}, {
          5060, 1495, 4342}, {3309, 2139, 5163}, {5143, 1225, 3918}, {2704, 
          229, 3910}, {3314, 774, 5170}, {5171, 1223, 3916}, {774, 1230, 
          235}, {1217, 1223, 732}, {239, 243, 15}, {247, 239, 15}, {1495, 247,
           229}, {3910, 229, 2703}, {1230, 1225, 235}, {2139, 1217, 239}, {
          4342, 1495, 4343}}], 
         PolygonBox[{{3313, 774, 1223, 5171}, {5172, 1230, 774, 3314}, {3918, 
          1225, 1230, 3312}, {3909, 1217, 2139, 3309}, {5059, 239, 1495, 
          5060}, {3916, 1223, 1217, 3265}, {5163, 2139, 239, 5059}, {4343, 
          1495, 229, 2704}}]}]}}, {{}, 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2703, 3910, 2704, 4343, 4342, 5060, 5059, 5163, 3309, 3909, 
          3265, 3916, 5171, 3313, 5170, 3314, 5172, 3312, 3918, 5143, 3302}]},
        
        "0.912`"],
       Annotation[#, 0.912, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2508, 5186, 3971, 4600, 4599, 2974, 5055, 5056, 5052, 5054, 
          5053, 2702, 5331, 5332, 5058, 5062, 5061, 3267, 5165, 5166, 5164, 
          5445, 5444}]},
        "0.864`"],
       Annotation[#, 0.864, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2967, 3720, 3715, 3964, 3963, 4601, 2971, 3721, 4341, 3725, 
          2976, 5057, 3972, 3973, 3431, 4012, 4011}]},
        "0.8160000000000001`"],
       Annotation[#, 0.8160000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3008, 3322, 3009, 3737, 2710, 4603, 2977, 4005, 2975, 4602, 
          3266, 4597, 2969, 3965, 2970, 4598, 2962, 4596, 2968, 3955, 3962}]},
        
        "0.768`"],
       Annotation[#, 0.768, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3714, 3710, 2506, 5185, 3956, 5130, 5128, 2964, 5138, 5139, 
          3967, 3969, 2507, 3723, 2516, 5198, 4007, 4641, 4639, 2712, 3739, 
          3320, 3738, 3321, 3736, 3735}]},
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3953, 3948, 2961, 4595, 2957, 5126, 3299, 3958, 3298, 3717, 
          5129, 2963, 5140, 3301, 3966, 3968, 3970, 3722, 5197, 5196, 4006, 
          3005, 4640, 2711, 3740, 3010, 3323, 4013, 4014, 3455, 4041, 4040}]},
        
        "0.672`"],
       Annotation[#, 0.672, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2505, 3954, 3947, 4594, 4593, 2956, 5125, 5127, 3957, 5124, 
          5123, 3716, 5136, 5137, 4000, 5142, 5141, 2972, 4637, 4638, 4008, 
          4636, 4635, 3432, 4644, 4645, 4033, 3011, 4646, 2728, 3763, 3035, 
          3330, 3034}]},
        "0.624`"],
       Annotation[#, 0.624, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2955, 3709, 3705, 5184, 5183, 3949, 3294, 5119, 2958, 5133, 
          3300, 3959, 3960, 3961, 3718, 5195, 5194, 4001, 3002, 4632, 2973, 
          4642, 4643, 4009, 4010, 2517, 3453, 2525, 5204, 4034, 4680, 4678, 
          2730, 3764, 3765, 3332, 4043, 2630, 3762}]},
        "0.5760000000000001`"],
       Annotation[#, 0.5760000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2503, 3946, 3940, 4592, 4591, 2951, 5117, 5118, 3950, 5116, 
          5115, 3711, 5131, 5132, 3995, 5135, 5134, 2965, 4631, 3001, 4002, 
          3000, 4630, 3724, 3732, 3006, 3450, 3007, 3734, 2726, 4676, 3031, 
          4036, 3030, 3457, 4679, 2729, 3766, 3036, 3331, 4042, 4044, 3469, 
          4075, 4074}]},
        "0.528`"],
       Annotation[#, 0.528, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2950, 3704, 3701, 5182, 5181, 3941, 3292, 5109, 2952, 5121, 
          3296, 3951, 3952, 2504, 3712, 2513, 5193, 3996, 4625, 4624, 2966, 
          4633, 4634, 4003, 4004, 2515, 3446, 2524, 4028, 3452, 3759, 2724, 
          3733, 2725, 4675, 4677, 4035, 4674, 4673, 3456, 4685, 4686, 4069, 
          4688, 4687, 2742, 3780, 3060, 3338, 3059}]},
        "0.48`"],
       Annotation[#, 0.48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2502, 3939, 3933, 4590, 4589, 2947, 5107, 5108, 3942, 5106, 
          5105, 3706, 5120, 3295, 3990, 3297, 5122, 2959, 4623, 2997, 3997, 
          2996, 4622, 3719, 3729, 3003, 3444, 3004, 3731, 2722, 4671, 3447, 
          4027, 3451, 3027, 3758, 2727, 4683, 3032, 4037, 4038, 4039, 3466, 
          2532, 5214, 4070, 4719, 4718, 2743, 3781, 3782, 3340, 4077, 2634, 
          3779}]},
        "0.432`"],
       Annotation[#, 0.432, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2946, 3700, 3698, 5180, 5179, 3934, 3291, 5104, 2948, 5112, 
          3293, 3943, 3944, 3945, 3707, 2511, 5192, 3991, 4621, 4620, 2960, 
          4627, 4628, 3998, 3999, 2514, 3442, 2523, 4026, 3445, 2720, 3730, 
          2721, 4670, 4672, 4029, 4669, 4668, 3454, 4681, 4682, 4064, 3033, 
          4684, 2740, 3774, 3057, 3335, 3056, 3773, 3471, 4721, 3472, 3061, 
          3339, 4076, 4078, 3490, 4097, 4096}]},
        "0.384`"],
       Annotation[#, 0.384, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2501, 3932, 3928, 4587, 4586, 2942, 5102, 5103, 3935, 5101, 
          5100, 3702, 5110, 5111, 3988, 5114, 5113, 2953, 4619, 2993, 3992, 
          2992, 4618, 3713, 4626, 2998, 4021, 2999, 4629, 2718, 3753, 3024, 
          3329, 3023, 3449, 2723, 5158, 3306, 4030, 4031, 4032, 3760, 5213, 
          5212, 4065, 4713, 4712, 2741, 3775, 3776, 3337, 4072, 2633, 3772, 
          3470, 4720, 4722, 4091, 4724, 4723, 2762, 3794, 3083, 3344, 3082}]},
        
        "0.336`"],
       Annotation[#, 0.336, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2941, 3697, 3694, 5178, 5177, 3929, 3289, 5094, 2943, 4588, 
          2949, 3936, 3937, 3938, 3429, 5191, 5190, 3989, 2989, 4616, 2954, 
          5146, 3303, 3993, 3994, 2512, 3727, 2521, 5203, 4022, 4667, 4666, 
          2719, 3756, 3327, 3754, 3328, 3752, 3751, 3448, 5156, 5157, 4058, 
          5160, 5159, 3028, 4711, 3053, 4066, 3052, 4710, 3467, 3468, 3058, 
          3336, 4071, 4073, 3488, 5224, 5223, 4092, 4751, 4750, 2763, 3797, 
          3798, 3345, 2638, 3793}]},
        "0.28800000000000003`"],
       Annotation[#, 0.28800000000000003`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVz7suhFEUhuFPHCaYMRMUhMZdjHtQaSQznUwhcSqmkIhWSBANhYJGqaNQ
CIlDISESRKUzGv89SDyKN+9ea39rZe+p+dXZla4kM1geShZw35/UR5O5atIZ
Sb6wPpj8cIGGfhMPcm35F95XtyrJwUCypnfIfcNJCd3oRQ823I3ZPY4LM5M8
gXP7p90/86X+E9fVbTvPzLyqN53feJu30DTXwKd8od+S/+BFXkJH//v/D953
JF/wMZ/gzs5bPHrnruwefmVL5WTH+VTm3X1ZfeVc4Ru+Rq2WVPEHVpwuHg==

          "]]},
        "0.24`"],
       Annotation[#, 0.24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzjkvhGEUhuFHoRhrLIV2/AfxO4xEbUkUEkapVGk0o9WoNAQZS2KUCkEt
iFhmEmImEgoKFS7Fnfs7zznnPV9xulxaaEsyjtNCMjqYTPQmrb6kiaXOpD6Q
NPCAJzyi3JO8chOr5u+6kjffy+bb+pNtrsi3OOrZ7qTAu+qqfI8XZWWU3BzD
ofxcPmLugIuylneP5bX/G/5v090GX6tX7FY7kh3ZPk/bm8G93hRPoqo3x+/e
+5R/8Lz6zPy6/W/ZBre7c2n2Ql7RX8OP3i/e3Dsy88U1vjJ3wrd8g7qdZ37B
kHzYW38BKTwc
          "]]},
        "0.192`"],
       Annotation[#, 0.192, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNzjlLg1EQheHRykQT18YqLr9AC/9BehEttBQULNQ0wcLKwoBg4QJ2Fi6g
RSoDVvYqoggG4oIRN76AbergUxzeOTNn5t7h+dWplbaImKXvbMR0OmIwE9FQ
J/TJf2GuK+JKP90TcYlnfRF1s0ezlFlFrwMf+CP1Dd5SVp2hO/W1/Ka9EjW7
IxYHvJOKODD/4Ov0Tn+dEQsyFfkts4Sv6TdwTv8eR+yOUlV/CHO0441jyttr
+cup+oQO+TF743QhPyn77N1lt/f5PdqlsrvtMhvY6o04x239vHzBnXX+t9+u
2yX9Gv7wS2av+MS/YBXfsCifuLOGM/IT7vwDTPw7wA==
          "]]},
        "0.14400000000000002`"],
       Annotation[#, 0.14400000000000002`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNz70vg2EUhvFTg8RnfY4kwuhrwWjgLxBLBwOLpIQIo43EpAumdkSYkJgY
LBaCNhJtJbWIVMxiIBJ+w5XrOec5537et2dueWopERGz6GqJ6Ea+KaKAvsaI
O+7lanPElfN+W8QBGswd8SFe6u24r/C5mTp3n3URZ84/yYhvJJ1r5eQ4iw17
CfWXuxreVF/bv5BziT0zu3iXs8Ov/Gy2jI+GiBnzD5ziN37ST3XINXsiZ0z/
Vv9R/4ZH1SvuBngQ/RjGEHLmM97M8qKZUzsl76Wd7zmj3saxnL/WiHX+5UPe
0p/w7iTSMhZQ9D+Vdt/E450R83oldV5d5AKXedV+Vc4aT8sZkfEP0rs/fA==

          "]]},
        "0.096`"],
       Annotation[#, 0.096, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzrsrxXEcxvGPlHI5bmEirIyUu5XNZVJEGUSJMiiTMjn+Aikml0EuG6t7
ylEog+UMpjMdIVLEy/Du+X6e5/N5fr/68dnBmZyImMRJfkRPZcRtUcRcYUSH
dyda0Y42TBRH3Mm7vO9pN523+14RsUXf6CadtrdAf8oiduhySUQSK5hKRDz6
Vp/dA3NjeUQD1gp45m+9P9jQsY4Z+03ySz0p+RVtNu/ZX5IN6XngP/OH+If8
fvMA8uS95iM92xiWjyArG6OjOP3voeGbi/RXz6q7C37SnMv/sP+JjP/elb3S
fXqAlN4bPNlP0xr7VfxqekzT/F09deai0ogEinEt+9JT7X3r/eE2azdDX+iZ
m3PUylvc/gFA70Fm
          "]]},
        "0.048`"],
       Annotation[#, 0.048, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzbsrBQAUBvBDkjd5pIjcDFyzxeZVJiXi7sqkyB+gEHmUwSSTYqKbLGLn
Lrg2pW7JTaKkUFJK+RlO3+uc7yQmZ0dnCiJiyvzjbV1EtiLisTBiqywiBzfh
FZwrj3ivj0g1RNTa/cD3eN+yffhJt/M7hBf0tcIdt0s1EZ28EXeDdBKfrozo
pftMi7sXP1thxt1ulR/4TXVEnh63f+RuRc8EfiIbolP4sp5+HQMmyX/V0wWf
3J3pmcLf9fzS8/bP3a3rWcBPZcP0Ir6tZxWumWJ5kZ4N/E6elpXwjmETP6c3
x3+AedPIH6Pv8VP8wN2haXSTsJ/G3+SXsmZeFnbzv+x/8DPyHrrtf9/8lEY8
2ymU/QG/1j1h
          "]]},
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0D1I1XEUxvETZGKZlnXRmyHplhK9DBFCbUFOda8VboG0FUVjCoEEDS3p
VmiQGdjb1HTbKsKGhnIJKq+WLzdJvZVv2U2iz3/48pzzPOec/49/Y+fl7KUN
EZHDUmXEb2RTEW9pe3XESqL6VbqMAzsjinQ//UEP0hH6d1tECWt4rX+zI+I2
zW2PyGwxa+4ULdI2WY+sV3aMt8A7Sudpk+yK7KqsmTfH20u/0/WaiHOytPfU
Yxf2bY2o9M60mXV1j7nH3vAIw6jgH3ermz+g78cdLG6OOMy/yO/T9+IWdvPq
sVARcdJMjZtVvtnmW/O8B/pVO98wixnkzBXouG9lzE3QMnN5ekI/bm9Mnsdn
TCSzifK/0kl8wTSmkppf5g2bsBFP3C+nZ2UrSe5uh7tn1E9l1707499kcRrt
uFcVMYhJs+/8n/cYRZ93zbh/3m61my/s37D/knbbK5nvon/oc/sFek3/j/6y
v4iC/Yfu/KS1btThphsf3EirL7hdrk/7b3ftfuSPuZVHyl5W/0n9TD0ov4+U
+QbzQ+o5+Yisy506/iH+K36Rv2Zvj6wRy+oljKpL9Ii5aXUrnaVNdgu0hTbj
PyIcd+s=
          "]]},
        RowBox[{"-", "0.048`"}]],
       Annotation[#, -0.048, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0DtI1XEYxvHXDmTeNUujUGgwCFqrwUmMzMtQbS1ZOjWoNJgKjUJTCdZ0
lGrRWlrTrl6wmzVEGE6Kig6CZFJ46Zwjfc7w5Xnf53l/7+//+59s67ramRMR
I2gujDhTGrF4OGIBuQURqeKIg3StKOK0LCc/Ykm9jHPmF+lZumPuq3qT/ka1
ugpb6g1nJu2bQoUdfUciZmTr/Ke8E86X85+oH+OFbJhekY+bHVLfl8/rj5fZ
YT6hr6RJ2U/+J/fM0WfOHpBt5nmTehRp33/XXCr7HvsGeX36FvMv9b3qe85M
6Ivt3zXXzevBHbzn98vf0SJ5uzOF9K0+n76hBbSNn0df6w/RV3SXt4cdbNvb
zLupvoHWrM/7R7/x92mpN6VpCc3Qy/xf3lJlXzUGfcdDPEKnPHE0osbsNdqh
/2M+KftLz5uvlX30hovqBjyXNdJLWOJn/It9XDeX0h+zpxLt2beix1wvpp2b
wS1eBR7wBvCd9wO3eaey/5M3hhXeKprsasGX8ojPmMUHd+3J0sigriSiHhP8
BjpJL9AN+h+kp2aS
          "]]},
        RowBox[{"-", "0.096`"}]],
       Annotation[#, -0.096, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0btLFmAUx/GjvoFpF99b6JsQEZqQmaaDuuiW2GWwy+AkNtWgQg7RWIsQ
CqWp/QkK6iaaUaKDNZi3ORwaolcaHAQbND8OP77n/M75Pc8Dz9Xe/q6+gogY
p9KSiMPzEUVYVxZxk+6di9hNRRSXRuTN7uivYQceX4hI8P9hEe7ya2RC/qc6
p66gK+pG+99wjfL296hSfZn+qvMyX91zy15G5mUmoikZ8Zs/om9U36bDsxEr
Mvt4hp+gcplp3hRNOuMjTdA4vTXfccYl2Yy9MV4WP+A2f8h8C7Pmz92ZwU19
Cjcwjc/4SfyhL8N1HJVPOec9Jk/f7O40FWZR/1+mQB20zD/w3gFeP1WbJ/g5
/px8jX4Gr+MsPjE7cMcfu83ua6VuXgt+N9+TS5g3eHs9PZCr4vXw3si8pqd2
c/5k3nyBFmmY34Y99o+cc8N8VV+Lr+y/4L/DNv0Wvx3H9HfTEZ20qP5Ev8w+
n/retISDZl3+8L7+IX5xzmN8RE0XI04AkhFMXA==
          "]]},
        RowBox[{"-", "0.14400000000000002`"}]],
       Annotation[#, -0.14400000000000002`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0T1I1AEYx/HnhkO77MVMHBry8rq8o9IGhzukQUhIqOygoJYgrgYHpbOX
xd3FqYZwdD4CtSEyFBpCoTGyTlq6q0hwCjqJSPvc8OX3vPye5/m/pO9OlSYT
ETGLakfEzcMR9w5GjByJKNNHXRGP8b4zYuF4xNVDEVeQ1S/pF/nn1TePRnzE
BzzjfYqeVMQECvwVuy/qXUcJ3eb2jrnFdx+v1E7YVxZf4/2qN07r9IVeFSn9
Mf0Z9/4eiLhtd1t3RDvW+Yb5N2hT/SXNyzvNPeCv4IZ6kjenvqi/jCXU1U/a
26C9dJr3IU6J+5DGaWTQdPcM7UcWeeSwq36Onsecm9/sGhA/seet9/8ur3nn
H3TFzTd4jbOeZYjvp/pzc6utuplb8jXxO7M75gb5NsUXaI1+xr6bfWa+iMO3
+cWXoFvmRvk+0Uu0oZ9U39e/LM/I79j/T77dmvUvE/jd+rf6f+iAvbu0SAv4
D5CxSyc=
          "]]},
        RowBox[{"-", "0.192`"}]],
       Annotation[#, -0.192, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVkTsvQ3EYxh8dJO05bSmKUYJKqieVCOJ06G3CJG5JEwkxk0hqkJQmPkOl
/QC2jmgHJhMjrUuYMIqEwS2lfmf45b08z/P+e+lb3Zhdb5GUhwmPtAevbdIL
XLRL52Cx24ZQlzQEmx1SyZRiPsmGGeYivhLUyCUMqUCfxTOAFoJBmPRKvX4p
gh4kl8KbhjVuW2gr+ONOHpLQZPcUkJ5hmnsmuTJ7g+rjc/gh1yntQMMtZbjj
YWeAG7xgwid7m/wXNUbdxf+L/5L7VxDm3QB3s+y3YAHfIW+G8Q5DAe2IeY5b
i2jH9FH2I7CPVmGeR1tCq9KfcbOVOcLdE2aLWmdXgz/ejZNLQJFsg0ySPs+7
N47u/P78Nk1qnew19ONLcSONz8V3P2C+ZX9KZhnfHf0j2XvqA4yiT+F/Z/cG
48xj8EHfTd7Ff9BD/cb7AzZaBv8/CvVFrg==
          "]]},
        RowBox[{"-", "0.24`"}]],
       Annotation[#, -0.24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0MsqhWEUgOFFyfmwt20zYOBcFCMztrOpYqSItjJRDCgugJkxRUjKVbgC
p+1Uwi1g6pR4DN7WWu+31vq//2vMLk8s5UXEKlIlEYmKiDKxryqiF9NlEd/l
EV8orIyYUnfKO1CkTpdGvCcjPtCjfysVkU3YxZ+o5+SzKLbzzUw714ZWjNj1
zD3h3vyMnlPzd/Jj5z/qYbND+m65Gxzx33w/P8hfczkc8l98hh/gr7hL7POf
///D9/Fn3LS6yTf71efqjHghvnAFzjbdYQOJmogqtPE1YhpJpFCN8FYV+sd8
YxRRHfFrT7f+fPm8vXliVqzV2+VNWtSr6maxwY56LNpRh2133MGDXY94wq57
ZMxOmm333uN2r5ldxwr2/u9uZsH5q/5reQ4Hzv4AjAw63w==
          "]]},
        RowBox[{"-", "0.28800000000000003`"}]],
       Annotation[#, -0.28800000000000003`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0Lsvw2EYxfGncWmVXrQkjCYkEmKSIBIGBrdSFRUDE4tuDHYSRptBRKz+
Af4GZv+AayLiEpPBp8M3533OOb/nfduerdrSbiIialjIRxSyEb2tEa25iI22
iJw5i2I6Ik3TdERvIBNRlf/QbzToV8z9zn1oMnfa81uIWOFvtkecdER8yIr8
P7sK9N18zF+X581Xdled15ByV4XeylfppWyFlpGULdIbWYleyBboPJplR/w5
56yd57IMnTUf8ofNJW969LZe97/SNzzhBc9IeF/OnhndaTQW/UYM6adoC5qQ
RDO69Lv1y7rL2LO/jz+qP4ZT91b4+/X/iD/pPQ/mKXpWfzdvDhP27PC3Me58
pr/o+wO7B3Gne48P+Se+cG33P00fMaY=
          "]]},
        RowBox[{"-", "0.336`"}]],
       Annotation[#, -0.336, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0DlKg1EUxfHrgJrBjIJoZyEIBhwCWglip4JgEkkKp6SyimDrUFjpJgQ3
ICIuwC047MIpTr2/FH/Od8877953v4nWYaXdExEHaKcjFocjFjCajZhKRRRo
EblMxEYuIkUn+QleEgn1EArJiAE6iIY+/bTeVZmOfn+FiJbMw0jEr+97vXbz
ETv4Vv/gCx3cOcubse2spscn7wO3/Cy/wa/y33lvuOFXeRW8qpvmXJpzgbKz
imyf9/RiXb2G1e4uRTtgzvuyNIc0MhjGmPy4Xg3ZOkq8aSzJz9MyZrr3MYuS
/L7cHrZwbu6K7JEeLXUTyzI1O0z5L5vOTt07wzGu5E/ooz2e0JF/oc+45v8D
xrYuwA==
          "]]},
        RowBox[{"-", "0.384`"}]],
       Annotation[#, -0.384, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNzz8vQ3EUxvFjYECrV3sNWv0TjSBpCZpY8QakiMUkqhSt1CSx2SXMLHZE
xMqr8H58hm+e3znPuc85t3Y8aPdHIqKD+njEYjYipbu5iM1MxGAyoqCXR24q
IkFLfwOp98JERIbXM1fOR1zQGq3rj/Hn6Sj/qRBxk/DU37KrdKh+1E/sG3j/
el/TL36fXiHHO6c/vB795JV9e+b9oNelc+oP/RKdtrvjhoSe0HV3rmFGfarO
0xQFlNxVkj9Li8i6N4MVOQ1+E8uopHbi0mwRDbNNVM1WsCN/39wB2ri3Z49u
mdnGi/pW/UyX5NzJWEXPzYf8rn0tOUdyXs29m/vzX2/0H+3oJPE=
          "]]},
        RowBox[{"-", "0.432`"}]],
       Annotation[#, -0.432, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzskuA2AUxfFrSylRUUPnIm1ISIyx1K2gK5WwkNCK1hDDws6wZ2HPA3gC
ESHivfws/rn3nnPu/b7C/mn9pCsi9rDSHfGA6aGIGbwMRrwlIhp9Edu4Nb+a
b9R73KHeG1FJRlRRk1nDlBsXKLlRxobcFjZR64lYUpfR6I94TkVkZDvIyxYw
z1vEAmblk27PqRm3d+xkZbP6HJr+s057dOcJB7xhe8cDEW2889Lmb94hb0Tf
snPOy7n5wR+ljeGIfkkv0j/p47Qfe017Gf0V7xpfvJz5l9f6/7c+4S8p/2y7
kdd31LJaRElmQp3EGT0tt+qNinnXrT/qsCUv
          "]]},
        RowBox[{"-", "0.48`"}]],
       Annotation[#, -0.48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwN0MsrxGEYxfFj6y6XDcWMpFihMCg2dlaKXDeyHhsLYgyaIaxdimLF1l4S
8X/5LE7f9zznvE+/31vY2VsuNyRZoWpzstCSzFNfWzLXlPTiiflwa7LVngxi
ybzHfBoL/ENXctORTPLfOtfOV1RsTC7wV36JX7I61qggO8Mf2Tl+yk6xSgOy
e/MT5wk7P2TjWOHvzJf4Q99U7E5mO5M//lh2RCW+7H4/3epuyg50Z8wX7VjD
Or+KNRyyY1/3SfeRdvUvzNflK/qn+MxXcVR3hCr6Y7Th3zdpyltM0rZ3e9V7
oxd6d+8fhjUpvw==
          "]]},
        RowBox[{"-", "0.528`"}]],
       Annotation[#, -0.528, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzk0rBFAUxvHH1luED2ChRNiY1MQwzAw7hVJiFmwUzVh7KcVkiE/Axsja
tyCUz+Q3i3/PPf97zr1n/LC51ehJsomZ3qQwmEzI+lBSHkiu+5NpbgobI8mZ
u5/RZN35T0+xL3kaTq701bgqfvkF/pG/5CvcGr75At/mL/hVrowvfp6/4ZfU
i2j6p+T/c30l9QqWMWePSXfPej/t8dJN8zXz++7b+vfknayar6CuflDvynt5
0N3TO6fmTnCEV/6W39a/g463G3yHb/HH3n+XH+q37h5jySxadiniH6TfJt4=

          "]]},
        RowBox[{"-", "0.5760000000000001`"}]],
       Annotation[#, -0.5760000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3250, 5028, 3251, 5036, 3422, 5033, 3249, 4205, 4220, 2619, 
          3676, 5001, 5002, 5000, 5004, 5003, 3413, 4998, 4999, 4207, 4208, 
          2610, 3654, 4963, 3212, 4955, 3213, 3398, 2677, 5414, 3211, 4959, 
          4962, 4961, 2887, 3866, 2888, 3632, 5277, 5278, 4509, 4510, 4296, 
          4512, 5319, 4511, 2601, 4514, 4515, 4298, 4518, 5320, 4516, 2602, 
          4519, 4520, 4301, 4524, 5321, 4522, 2603, 4527, 4528, 4303, 4531, 
          5323, 4530, 2604, 3635, 3636, 3870, 3869, 2894, 3638, 4197}]},
        RowBox[{"-", "0.624`"}]],
       Annotation[#, -0.624, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2620, 2694, 5424, 5425, 5032, 5035, 5034, 2921, 5005, 5006, 
          4209, 5283, 2611, 2686, 3883, 3884, 3655, 2902, 3887, 3414, 5007, 
          5008, 4210, 4211, 2612, 3656, 4966, 3214, 4960, 3215, 3399, 2678, 
          4964, 4965, 4513, 2889, 4315, 4967, 4968, 3216, 3633, 2890, 3874, 
          3400, 4970, 3217, 4517, 5279, 4521, 2891, 4300, 2892, 4523, 5280, 
          4529, 3220, 4973, 2893, 4320, 4974, 4975, 3221, 3640, 2895, 3876, 
          3402, 3403, 3222}]},
        RowBox[{"-", "0.672`"}]],
       Annotation[#, -0.672, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2615, 3663, 4199, 4198, 3404, 3223, 3641, 3639, 4977, 2681, 
          5326, 4976, 4319, 4533, 4532, 4972, 2680, 5325, 4971, 4317, 4526, 
          4525, 4969, 2679, 3401, 3219, 3634, 3218, 3873, 3660, 2613, 4542, 
          5324, 4543, 4316, 2904, 4541, 5286, 4214, 5011, 5010, 3415, 3889, 
          2903, 3657, 3886, 3885, 2687, 5285, 5284, 4213, 3235, 5009, 2922, 
          5039, 3253, 5037, 3252, 5426, 2695, 4222, 4221}]},
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3255, 5038, 3256, 5041, 3423, 5040, 3254, 4212, 4223, 4224, 
          3677, 3678, 3236, 4216, 5287, 5288, 2688, 3888, 3658, 3659, 3891, 
          3890, 3416, 3417, 3237, 4545, 3238, 5013, 2905, 3875, 2906, 3661, 
          5290, 4547, 2907, 4318, 2908, 4548, 5291, 4550, 2910, 4321, 2911, 
          4551, 5292, 3662, 2913, 3877, 2914, 3664, 4219}]},
        RowBox[{"-", "0.768`"}]],
       Annotation[#, -0.768, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2621, 2696, 3896, 3679, 3680, 3899, 3898, 3424, 5042, 3257, 
          4215, 4225, 3681, 2923, 5014, 3239, 4218, 5289, 2614, 2689, 5012, 
          4544, 4546, 4325, 5015, 5327, 2690, 5016, 5017, 4549, 2909, 4327, 
          5018, 5019, 3240, 4552, 2912, 4329, 5020, 5021, 3241, 3665, 2915, 
          3912, 3418, 3419, 3242}]},
        RowBox[{"-", "0.8160000000000001`"}]],
       Annotation[#, -0.8160000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2622, 2697, 3897, 3682, 3683, 3901, 3900, 3425, 5044, 3258, 
          4217, 5294, 4566, 2924, 4326, 2925, 4567, 5295, 2624, 4570, 4571, 
          4328, 4574, 5328, 4572, 2625, 4575, 4576, 4331, 4579, 5329, 5455, 
          5454, 2626, 5297, 5298, 5067, 5070, 5069, 3271, 5073, 5074, 5072, 
          5300, 5299, 2627}]},
        RowBox[{"-", "0.864`"}]],
       Annotation[#, -0.864, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2623, 2698, 5043, 4568, 4569, 4339, 5045, 5046, 3259, 3684, 
          2926, 3904, 3426, 5048, 5049, 4573, 5296, 4577, 2927, 4330, 2928, 
          4578, 5068, 5071, 5427, 3272, 4351, 5333, 5334, 3913, 4353, 4352, 
          5076, 3276, 3915, 3914, 3922}]},
        RowBox[{"-", "0.912`"}]],
       Annotation[#, -0.912, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3902, 3903, 3685, 3260, 3427, 2699, 5047, 4580, 4581, 4340, 
          5050, 5330, 2700, 5051, 3261, 5075, 3273, 4350, 4354, 4355, 3274, 
          5428, 5429, 5335, 5336, 2706, 3917, 2707, 5338, 5337, 5431, 5430, 
          5446}]},
        RowBox[{"-", "0.96`"}]],
       Annotation[#, -0.96, "Tooltip"]& ], {}, {}}}], 
   {GrayLevel[0], PointSize[Large], 
    PointBox[NCache[{Rational[1, 2], Rational[1, 3]}, {0.5, 
      0.3333333333333333}]]}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxFxXss1AEcAPDDVnlOltPPjOiyYWKcNhWpRNJV7oiaZF7LKFq0rtqadJY8
IlbRaXROJXMnKpXH4eZUdJw7brrunM77cjHHZh7VH77fPz77OMal0RMNSSQS
7Z//n0icGhBMR/hvPll/Nk5FUA9tTjaVFTYSgfBe3x3cCiIc3t/vzX9EJMCC
Z10+BUQGnJ2Vd+MBcQ9OyNARuUQpvK00pOrPfDX8od8rONieB0dlK0a68prg
tIZr7k8XP8ILRUM9BgbtcE9Hd7v4YCeczAwxP6cVwh3GXht1l0VwDUe4brvn
KxxAbn3BqO+F3UWK5m5XMSwNYMy9nuuHU01SJDJPCfxNHtlqUTgIM4Ki1BqN
FN5XmRdZSRmCR9dLpJfuDMPjIWIOuUsO88tUzAHHEZh73yjX5eYPWB9/fibp
swI2DcyhN9go4duW42bqaBVs1uZGGqaNwn7XT691reDs6nzObrYajomg9hmH
jsHvZIklbUu4by/fcOLxL3jXsSR9SaAG9qH6FDdN4KqFgi8c1jis9Q5jEV4T
sPOs+4zBIC6kZErSsybhh1JZPJ0yBesYgmJDIf42wvqo79VpmNOXXTFmNQMv
i6JvWXXio8Xtessrs/DSwAHiroUWTi91EjBbcJs+J0tNzG+YIatbtVvHFy5W
pSpq5+D2WB7L4qQO/iRODVWewt/7u26vD8Pr7LhsWiReLi9vzI/DM8/kqE2Y
uFvABb+tNbgzz9Zo+BXuZC/vqXmD71ylhwc14Fuaj6ewWnC1B7XMaBBXPJ+P
GZThcnMehSPHv8+68I8o8ZaXDqKsabyZ/DM/TIs3ssrpjjq8Nt5aKVjEuRIJ
p2gZrzxclBy7grP5NA/PNfyJg6l+YwP/CxUIhds=
      "]]}}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJxdlnk0lG8fxkkyUgqlLC2WhFJKpRRXZKlkTRtGIUneJFlqqFCS5SfiR6KS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      "]]}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{283.6927083333333, Automatic},
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.608660543138433*^9, 3.60866056561298*^9}, 
   3.608753726764673*^9, 3.6087538669236403`*^9, 3.653243600189528*^9, 
   3.65324363242181*^9, 3.653243706341669*^9, {3.653486042851577*^9, 
   3.653486063530459*^9}, 
   3.653486116039974*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[StyleBox["Gradient / contour at the kitten\[CloseCurlyQuote]s \
position", "Subsubsection"]], "Text",
 CellChangeTimes->{{3.653484200196115*^9, 3.653484216760668*^9}}],

Cell[TextData[{
 "We\[CloseCurlyQuote]ll plot the contour line running through (1/2,1/3) by \
solving ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{"k", "=", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", 
      RowBox[{"2", "x", " ", "y"}]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "(", "x", ")"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " and finding ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "=", 
    RowBox[{"f", "(", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"1", "/", "3"}]}], ")"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Text",
 CellChangeTimes->{{3.6534846109428663`*^9, 3.653484634650642*^9}, {
  3.6534850261425467`*^9, 3.653485108695242*^9}, {3.653485287793776*^9, 
  3.6534853221927023`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"k", "\[Equal]", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"2", " ", "x", " ", "y"}]}]}], ",", "y"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"myk", " ", "=", " ", 
  RowBox[{"myT", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1", "/", "2."}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "/", "3"}]}]}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.653484330670596*^9, 3.653484368341823*^9}, {
  3.6534852552704363`*^9, 3.653485260431546*^9}, {3.653485331333138*^9, 
  3.6534854130851517`*^9}, {3.6534854731480837`*^9, 3.6534854772485113`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "k"}], "+", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{"2", " ", "x"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.653484368746625*^9, {3.653485257163113*^9, 3.653485261847118*^9}, {
   3.653485384356024*^9, 3.653485406594018*^9}, 3.65348547842725*^9}],

Cell[BoxData[
 RowBox[{"-", "0.08333333333333331`"}]], "Output",
 CellChangeTimes->{
  3.653484368746625*^9, {3.653485257163113*^9, 3.653485261847118*^9}, {
   3.653485384356024*^9, 3.653485406594018*^9}, 3.653485478430647*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myCatcontour", " ", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "myk"}], "+", 
        RowBox[{"x", "^", "2"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "x"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.05", ",", "1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"catpos", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "3"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myGradarrow", " ", "=", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{"catpos", ",", 
        RowBox[{"catpos", "+", 
         RowBox[{"0.1", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "3"}], ",", 
            RowBox[{"-", "1"}]}], "}"}]}]}]}], "}"}], "]"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{
  "myCP", ",", "myPoint", ",", "myBound", ",", "myQuad", ",", "myGradarrow", 
   ",", "myCatcontour"}], "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.653485496171797*^9, 3.653485508328038*^9}, {
  3.653485576640676*^9, 3.653485689760189*^9}, {3.653485730793983*^9, 
  3.653485873312693*^9}, {3.6534859308042927`*^9, 3.653485939223762*^9}}],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJyEfQVYlM/zOGAndmB3dweOLQa2Ynd3t9jdmIgFBiImIiIlndLdF9wdHMcd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    "], {{
      {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1ULtOAgEQnByaeHJyELgPMOETfHTS0dH4CRJa/RA7+AXvG0xAaqKtJso1
YKKFpYkUNIaZzFJsZrM7Ozu7pzd317cJgC6jxqinwJb4w5gcA7/EQQ68ZEBF
Yq0FLBP31zC3wZlPYp4618wXeSviYxvIUutqftkxryKeFa5Ju0xd34SedKUz
PAEW5DyR896x1nlhzkPsLSNXTV41N6b3JLz+N61dBqdHzuwAuMo9V8bey8I8
efyIXdqpeek808Or7jkC5plR9f0f6nG7MItc/Sr+pRt0y6jhmniq77Vmbf9L
f7un/ynzt0Pgr+lQ/s2b+oX9XhB3UYhFdQ==
          "]], 
         PolygonBox[{{3685, 711, 1211, 3903}, {2700, 224, 2311, 5330}, {4355, 
          730, 729, 4354}, {5429, 2316, 730, 5428}, {5051, 2060, 224, 2700}, {
          2706, 241, 2316, 5336}, {4581, 1492, 223, 4580}, {5338, 2319, 241, 
          2707}, {5330, 2311, 1492, 5050}, {3273, 729, 2060, 5075}, {2699, 
          223, 711, 3427}, {5430, 245, 2319, 5431}}]}]}, 
      {RGBColor[0.18832000000000004`, 0.35240000000000005`, 0.57776], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUbtKA1EQnUSN+8hr2d1OUL/BF1bptcsHWPgotEhs/QELtVL8D0EUH71E
CAhGJYrZZEVBBCt/wHM4t7jMzJ0zZ87MzK63m62imS3jjeEVI7NsAj7sGj4C
z+wOgOtY/hVsB3EI/7RglsPvjJsNYfdLZr7DPybCHAVme77ZDp4Hvp+66tqh
csTcgnMb+Rn4I9TexPonB7W8431D2yT+SsD1EDdrZr/4W4HtAT+N3H1Z9eQh
/iyRlgFm6cOvoPYYPfuIB8ifo26jojkPA8X8PwjUM/DFc4K4Dv8t0Yzk5AzU
Qk0ZMJex/ItYtdTDPc2nmm0BtoWZPexqsyqs52q7bqcfkXZJnZzDqBNchUia
qK0B+5JI2zNsBzNPgWcu1Q1YR828A+eiVuapiT2eYnGSO4+U5544H3vzntRF
ndS2WhNvt6wcfe79r647vEbqzR4PsW7MWxO7G2pPvDlvkrk7LqXCLKbC546T
uoZO/2ekXX/BNmrSs1WVxpHT8Q98RWV0
          "]], PolygonBox[CompressedData["
1:eJwtUUsvQ2EQPb1tua/Sm9u7k2DhH3jssJIgNn6ARbFg0dr6AzZ2xE/xbG2l
pIlFPVpxS4XExoo1zuR08SXzzZw558zMeLm6WnEATPDl+LIR0M0DYy5wEwJL
w8AX8y8ELTP+YH1vADjKAD9F4KkEFD2gx3qH8QoxjZxyhz7wS8xzXpwOe++J
8T3l/lhbJP4Tyj2UxGFc2/zPJMABOQqeOI27GcpLyv67GHgk/tURps24xlxA
7w3mLol9ixSb351AmqY9YhjWywVgLQvUyT9P/s0hwM3pX2e9w/4W8Sk9thlv
9Osu+2usVwNxX1GjF2kn9jcPF/QyxRm2PHk0r/u+9DzWT1k/4/Nd5czLLD10
IY05xrdx3yv7m7FmsniUuVYsD+ZlkO8k1s3sdqY5Se3pRLvc5VtIpGnadsP3
SDPbrKZX4SzHsbhs5m/Okom0a7uR3eo6lLbt0G5rO7J+879O/2mkXdhM5+T6
BwU/Wao=
          "]]}]}, 
      {RGBColor[0.21856, 0.36920000000000003`, 0.6060800000000001], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFUssuQ1EU3aWVtrd63ZxrokmTfoakpFMkJOYGGloDWlNDr4EYEp9BaAk1
9IhBi4pHUa96/IA51s46icHJ2nfftdfee52TyhZHC20iksZpx8lFRD7CIndI
toALHSIniKeQ/8R3A/Eq4h7Ey/j36oksAV+AbzYuOqzR2vWASLaTuG9Ebn38
C4oMuCJ56JwGqak9c1a3gtwYhjlGfs9Q6zCGWugfId6ERiJMHZ3zCpwkvuvA
jPvfsxdxEzutRFmvOhNxkbMY6367RL5w1sCfdthzI8S++k85N+g1jz1CYfb+
tvxdw5knI+TNOMyrnuYS1sNHjz48AIe76d0IMBOlv1vQH3LpwyDwGrop5Ksx
5tSjH+hcgrcInWeP++ssc+iVjXNH3fXAkPMETsPj3PceecqvQLNsuOc4/Kn7
vMN3jx6pTj9wx+du2z77673rDCWfcdneYdK+B0V9HxrXgpxb+Yopy9G6vOWo
lzqDzjTrcIaWnVdz6mPa5TvoA1YN38UFsOlxR/VD35DOEUCu4PDe9f5rhv6f
A/8AQLB3gg==
          "]], PolygonBox[CompressedData["
1:eJwtUUsvg1EUnFbbfP1U68vXbkgkXfkBtsRrR0LSvYV6xIL6DV4blsTf8GgJ
3VIkWlRo6x1FYm8v5mQsbjL3zpwzc85NZxczuSCAbp4QTzEGnPBhogUo+MB9
EqjzXiJZI55vBTYD0tQ84JKamSjw6QD75A988SXyh8RTceCU+Jm9s8Q3fJuj
vov6W+KAp94NC0HckwJmo/K8YJZrajocvRl3xXunI0/zno7La4ueOWar+upt
Pc9jOoatpkJu0AU+iFcizES/vaSym8eQqwyWJc37HfU75JuOPOrkyjFxZ+w5
mgBGEsIVngxxnjVh8kvs3/BUY7W2kwXme+N9NaIMlqXA/l+OdmK7eSS/HJHn
gKtMlm2D/Bjnf/GU3ep3Wbvu6q/M07z7mKEY0s5t9/3kt8PSmLbJ+rWIepap
n2wTZzW9rB2m5jeoTHn2f/33s/1+twNHvrC9HfvKYFlspndqHzzNbvP+UD+e
UnbzrCbVw+ptxidq/wALtGRd
          "]], 
         PolygonBox[{{4331, 4330, 2927, 1668, 4576}, {4579, 1669, 2928, 4330, 
          4331}}]}]}, 
      {RGBColor[0.24879999999999997`, 0.386, 0.6344], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUztPVGEQHXFf3F129+a7FBQU/AljeCQILdFAsYVgYHdbhIpAaBQrEzoi
b62NFeFRLFZCMJqwuwIFJEAAQ0yMhkdv4zk5X3EzszNn5jtnZratND4w1mBm
ffge4vuVN6vGzXZDs8EmswKCz2HvkmbxRrM6cjfwY/Br8F8nUAf/B2q3nFki
ZfY5I8wtvgPEZ+OKzz0w24jMWuDvO/W48ZiewOwQdh35D07vvYdtTYnDEXLD
WbMz2Mc5YCPxedZs9g/5vZjZMYS8DYTpgv0CDXX479DnT1I8yGEGGneAncwr
R8wM8Bvwh9BrBHorMfnEfYpUOw18MasYe5TgJ4ErZ6V1KiEtnN+rhPqeh4o9
Qf9yWlz7gT8OhRlF7GmztHMGP1N6i7UHXv+W18qZEEd77/12zGIbHDpy0sC6
R7A1p3l8y0gnOW/DP/I92Zt7IB/iVp12sQK75LTPN4H2RFzdaQ+sJb7stXfh
3bNQt/A7r37Ek9vLtO7jJNQs53lXDeLL3/SpgzXEc368L86LvPnOId79ivoJ
5Jad5sj8JWIfM9rrAuIv0sIQ2x2I/yn8zUi30xsoT57MkTtnwnvgPfFmeDtX
oTj8hZbOnPJF3MNIWvy+h6qt+HreXcHPkPrZ/8LvlrvkPhadboL/Lc6CM1mL
9L+hX/Xv8d3rUP02Y+L9H79hlIo=
          "]], PolygonBox[CompressedData["
1:eJwtkjksRHEQxsfagz14L7sKhUKvljijVBEKhSPsKl2VBA3RiU7ipnYUhN3C
qhCFwq5dhQJxREJIHL3Gb8wWk/fNf76Zb45XnRjrHPWISA3mxVIxkaoSkWtw
EtwcFFn0ifQWi8yBXx2RS/wZv8hISKSWtyzced524O/HLHbFWwux2aDh4lK+
xDrKRH6p9ROAHxa5cEUm4H/hb+M/4Geo5YWfg/+Cn8X34efx3xyLj5PTh/6t
a/X17Q78iOXEcp7A745h1RiAP+VYrx/obYVtJp3tiOHrykUasDT4jKUM0Otq
1LRUYwV85tr8OvOJazmaG8AS8DfgfAdMU7Xz+Deewk7Bu2gm4Xah2RNBI2L6
qllPrVbs3Gs7GqTf7ohx9U1jk4X+n6m3F7Metdc7+ukHp6l/6rGah+gNU2Pa
bz3r7XTnunvtcTNqO/7fNfn3zLMUtd0sFIkMhUxDtbTGjWs31FtqvWW4Wayy
xGbMgOMRy/XzlsI/gJ8X4xzG7MZ6609snfhx2Lg6k87WXlG4NTlt4KZy263W
bASvRS1X763/gvaoMZ05zvx/iXFyZA==
          "]]}]}, 
      {RGBColor[0.28026, 0.4022, 0.65432], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUssrxFEY/TAemd/85jf95h+Q7EVZsFZShFIYzGCpKFmxIAuP2cn7tTXj
kbzyWBHCRtZSymoSf4RzOndx+7577/edc75zb9XweNdYsZk1Y5VgFcrNsqVm
y0VmP4HZIuJuaNYbM+tGQQ/iH2p+sc7QmML+EvHQM8v4ZqURs6a4WV/UbB69
1chT6FsB5j3qdoB1jpj3VHuNdYf9RBn4ytXz7XgHgXGYFE8bsIexX8J5DTAn
A/VdAWczlKYtxMeE6tm3FgpzHzUH2H9WmDVUQkdCfA+IaaeZ2keBX4Z8HX0D
2EeQzwbiI+9QVPNQYy/yPDA/gJlLqm8VM77Bw9NQM6djwqCn9HM6kFcdwK4D
zjnu6uPyldpOi4WRdTiMxGfe4jT0AbM2rrNZzHIM7gv0vWCWo6S8fUKeicpD
vuGgm4Uz0W9qo3fkJzd5bzy9z0koP3hPzdzz/Br3OU+1U8D8wlrAfQo8M+4t
+CYj7o2odyCqmkKgPnpE3UO+cvrNGSMV4jrwNEunLzxq5jl9pOYzaGn3VcO5
G+O6z8T0nzj7K2Zv9cVDn54TOqc3Bad5m38wFO8t+vqdTs7Ev/Pr/uF7Uvkc
fN4LxUuNG6HOeZ92PvPP/gPOlHpt
          "]], PolygonBox[CompressedData["
1:eJwtkskuRGEQhQvdiNvdunO9gL0ViQjxAoQgkdBttiexITaGhWkn5mmHZkcT
w8o8bDyAWAvCQ/hOqhd/UueeqnPOX/+tHBrtGCk0sypOhHOfMhsrNpsrMPtM
mtWWmX2UmnUWmc1QP8GfMjAP3xuYZSvM3uGXomYT9E9yTgp95hiuOeH4De0m
6ppys1zEv4lr55xRL6I3jN4r+jnwAngAPF3ms/I4Qi8TuLcyPNA7g98q3sVo
DqK1HzP7KuEu4D7wbuha8tij7or7XZShmix9gfPyfEZvO3R94R3qdNyznYMz
1C8p19JMP7NtCefUM6S8Sfe+4dsUdUvCs2qfafiLmHMZMpyg/5i/rzx74BvI
FGV+GVxf7jtX3m/utEp/I3gl6vML1Acx59TTTb7BwLMoYyve40l/G+1Iu7qm
P5J/L3F3+feWhrTq8LyMeIb+hL+perVT7Vae8laPetdD373eMws/C/9L7x9n
E+409P5b+Cv4rdA57UT/ku4kb2W4Tfk/p11JYwOuO3D8A14DH8a8Vr+yD8R9
V7pTDv4f0Pxo2g==
          "]]}]}, 
      {RGBColor[0.31782, 0.4154, 0.63224], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1U01PU1EQnZa2FN7j9d08+AH8AF3UhfEnIBWIIdECwdCFxmgUoimwQNiY
uIQSQly4kgIbKCRA2CACxo+EvQnhY6X/AL82ek7OdfEyc+fOnDlz5r7OytPb
T9JmVsbXhO+jM6vmzIYDs9O82S8E3yO+kJj9hF9GvLMgvxSZrbab9cOfaTU7
ySveAGC5TbYeml0itg7/GDirGbPfOL/BeSOj2jX4e052GXgTsfJX4D8Hl1SL
2YGphrWH8Icj5SwB/1lOXMmT9+d55RCLmFXgjeXEj5x6IuWNYJYi/NeI1UL1
Yb/PWWGM54Rz3K76fXBMtyj+JSttWMu+1OwsL56cdzMjfj/8fC9Twmh4fxf9
mpC/CV3HEvWZhIbfms1eAXs2pVpqxPpaVnFquIXaCngUO8weJuo/jtp5+N9R
X4O9H0uvEvbwNhTuXCK9yIsaU3vmE59c/jarb7EgjndR+wJ5c+g7BXvgxH85
1F7pM3alIF7TrcJIA+sE5wb6Gfxtz5d3jNMyzl6cKeX9jUT+DvJ7sZc/4PcA
fR8n0nUC+NcjaUXNRhPt4QI5p7HnHEj7fv/mpmNpNwPbFWk3VwvaIXdJrKFA
e/+AWerY9VdwWILtjrSDa8h/lOhdnMWyfHPUnTtnLfmRB/lsO9mqj79z2j3f
0XyoN1P08/F/4J4qgc59iHe1KYe5R069BnF/JxB/zjEQ6P3dgn/T8yTfekb/
IOv/c10Hxr1AM39y0pwzcmfEYA3zt5z4Uu/FULxuAHPNaVa+Nb4nxnn/D+21
qtg=
          "]], PolygonBox[CompressedData["
1:eJwtk0lrVFEQhatfosb3Ot3v0e0PCOJS0YgE/QeKEyKYOCTYCwUFB4yJIphs
RBcuTMSFC1caDWp3EojDxlkcQN0KIQZc6D9w3Oh3OFk8uHVP3TrnVNXrahzf
dSyJiE187XyjecT4kogPnA9UIrby/WqLmOuI2JBGbCP+TTxPfLce8bqIGFwa
8YX4HvF9vgXOf8jZXvGdsCFy3pDbrEX8WxbRWB4xW444Q80XcJWIP5I7kpr7
M28miAc6I66UwImneTvOm+uJNXVVibn7Tr3dxHvIfQSedJijBbYTDX/BLuPp
HN6OZK4X5EyBPyy79iXwwdye5O0Uel+h91bdWoSfzt0D9eIk+FPwIe6aiTVc
rbmGctXDEc698F0oOedJ4RrCv5F/s+wey28LvJ/zaGov0wxjLf5ukzO16Pda
zR6Fz4CvA39WWIs45qm9irvJdntuwN2fuffv4fyau6Zq/wTfAl9f5toT3K0E
e1A4VzOZLTwTzeYdd0fhP5h5tuIQV2txnm305HHZmqTth+ZBbqvw2+fUa3Lu
XuHZzxFfxOtwakwz3Yy39VVrk59uzhvReAPsJTk9FXuQvmE8DVB/IXd97eD+
zDVVe4y782BnU79N4PyEl5matWoHtFu9neZSj/s4r6lau2ayWv0oe1fkUbt7
p+5ZaQaTnA/n7rU0HsrNIS5pPEH+vsy7JI3Sqh6r1/qH9oK9LexF/4z+nbGa
d0P6tKs9qXdXHDvw/x9nw48s
          "]]}]}, 
      {RGBColor[0.35538000000000003`, 0.42860000000000004`, 0.61016], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVM9LVFEY/dJJ613fNI87/QGuy2jK0KC9P2ZCMMhoJWKaE6kRaS6yTSUu
0rSIaJMxKdbkRKDLp4t+KVbrgpYF7XXVqnM4d/H87tzv1/nO+a7NA2O9o3Vm
NoivHt9l/NnExfwBsz84VzJmW7h/mZgNNJhd8WZPmsyeI+Y97pqPKGYRd6vw
/Ws0Kxw1O4b7XeRNR2at+GYOmt3MmV1DzDZivuXNzkSqXcqiH/KfomY//B/h
t8NmX5BzNfwehh1H/x+HgA/u78jfxf0Uaox5nUdhK6jzFnVuoVcZv4uYoTNG
PnI/I+ZZnc60U5hxJtLMp4B5CPH7jAeePdh3GdVaRq8L+H03EgfERQzLieos
NGlOznsadgi97yBmONgScj/A1xULzyRiOkKP4+BpPODnTL9yqr+F2jdwvo/z
nJcm5Ja6dMTiipydBO6fqP0ANQuodQ/+PvjX4UsRs+bF2WzAXAb+nUbpRw2o
xW3kfs2Jj6JTbcazFrGvZIT/oVf/ESeM1IM1l/KqVwXmMnz1iF/w4o+8kUP6
2Ys9yDF7sH4LMNcQdwL2ohMn5IZ5vxFfRdwjr/O8115wH7g3aSIMl5zuPoX7
zUSW+9XlpBn390VeelG3vYCLmnFXeH4FfzHWzN2xOCW352CrYbe54+SU3G4E
jrk/5KXPaSbqwLfBmckNcfEtERO53w78T+eUyx3kbnI3iK8WeOPs1D8N75H9
uQfEdN5Jy+vk2Ytzcr+WaL9rsI+9dJxAn/VE8Ruwg166TUTKSwMP1JV93sBf
ctKKe9GTlf5tiG/D+S+wnYXtcTq3Z7VznH0Rud1O8xayes/Uei68S/Zjr9fh
7VCTSl5zct85M/eDtdIwP+M5B+sQN/+X7Ad+/gPcD7Qd
          "]], 
         PolygonBox[CompressedData["
1:eJwtk8tvjGEUxo8ZNXTG95l87R9QsXNtSRB/gE5nkiYkJZYNHepSl6R0UTZE
LOiNEtuhwtBuatnpwj36BxDsSOxZWfk9eWbx5jvnPbfnec739gyPHbmQi4hD
nPWca50RHwsRnzjnsogfWyIm1vnuLP4Zznvs+oaIV+WI48WIi9gfOiK+k1sn
/rZg/xv+Kfxh4i16n8S+wt1tYk2GXsbenUYsMfhPPmKIXhPM/0z9GucS+XVy
Jsl/Q/1gErFXcexb3DW6IqZLEe8Knnma/Hv48/T+S78R/EnqW/gn8K9j36D+
KPYiM3cy+yp+NW9O4ta/2f4T4ltTYxCW39ztT8xJ3MSpAt4mGjzOWaMa/gKY
vmy0JivEXoNnhXiefkvClxn7FPl3sXu7I/7R/yuc9mD3MuNX3pzEbSZz7Ut6
NEreiXYzSv9l+u9IrZ002Y7dn5i7NN4Ht/FOay9NDsPtIT2e0a9GTg3/fOZe
4nCf2BT+z4I1GiLe18YjPeaIb0tdLz0G4bsG39gUscqnBZ55chba/avUv8jM
VRyb2DPEH+Ws8Sj+rtS70P9QSay5ZmnmQNEz5Su/Qr9a4lkN7npS/0OqFebp
zJw0W//MCLEDibFqhw/Uq8tait9T7HFy7nR4Z9rdQLteHMW1r9v/jna4TH21
6F2Lw3P4Lpb9FnSntzJbMjbhl3biJHw3iR+j9mAbj/prF7OZY8IwlxmjsOoN
jGXegbDqjeitrJb9/0lzaf8fHimJfQ==
          "]], 
         PolygonBox[{{4320, 4319, 4533, 1642, 2893}, {4974, 1995, 4976, 4319, 
          4320}}]}]}, 
      {RGBColor[0.39294, 0.4418, 0.58808], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVM1LVHEUvc0486Z5M808fq9NUFBEm4I0JYL2Oo19gAshhEqdMQvUKKio
doVRak6gtSgtUqoZjUqX5SJd2MciaNGmRV/QH9C6RedwfovHvXPfvffce859
s71vpGs4YWYVPEk80zmzBwgc2GTWnjebgj+B2N6C2fUNZt2ILTizf4FZA/Z8
0Ww0ZXYBdhl5b5E/j/g3/L6E/NPwe9Nm9xP6PQ17Ki0/0aQ+bxCbjRSfgd0G
rD8Ypg0z/ML7LvgN5JxJa7YrqK2g7zu8qzr17se7y4gfCtWb+DWn2ThjFc9D
5O1HzynM+RG1Q3g/F6n2CezfpPblnj+KwhlGzhjyezaa7dqMXWCPJzXzZEo7
0N+CmS8ivwP4N1LqVUf8Q2w2gP6L6H8ir9pF9Bwqqu41eh/Mqtc1xF40aV/W
MreWEqevUD+IPi8jcVhOCm8Ne6wE8vdlhX0OfXYUxEcJmM9RU0XtM9hPsXhc
ht+R931QtxP5V5FfRmw9lmaPkVP3tZ3Y63egfakF+SDuCm6mMy9u72GXMSfN
xp1uhVxOwp9wqr8D+yUjfanliJPl3TV7fltgP2ekC7WlhtSFWNSNPFCbHqf4
OGoH/R3U4B8J9Z4a8ka4IzmroG49EC+8UfK6lNN9sw/7LUXihzxRh++BtGjL
Cr+E+3kUiR/ydBs1P5FzC3Y+EsZ7xBuRdKf+uwvSdU9B9807n0X8cKicBcSO
huJ/K3JuOuGO+v24P3kkT+SNed2hYvwuOefXjHSZi+W3Yt4B1K+S85x045wN
zxG5asEuZ504uZuTnqteU+7MGyYG+VvzN1Z3ukve8jE/M2+HO3P3p54/asx5
yRO1JN5MLB2agVsOpQPvtN8Jqx3xPqc5Tjp9S8TshV/yPr8z/i+Qh1bY/xIk
qYg=
          "]], PolygonBox[CompressedData["
1:eJwtk89vjGEQx6er7fLu7mvfvPZI4iKhPbQqIuGqXStImpAICdtqtZJ2iShB
XMj60WorqTigLUXtllA90gMOml6Kg6uoxB/g7ODzzezhSeZ5ZuY73+/MPJu7
Sp2DCTPby6nntIVmf9aYfV9r1hyY5bkv8v4padYbm53kLGJ/5oylzUa4r2JX
AbmFPcr5Xbufy5rd5v6LewLw42BtXG92pc5rbMJeiMz6G80u87ZC/AiYE+T+
xd9NbpXzr5bfnzKb3AAH4u8T8xj7Jf73CY+Zi72GYscazHbDv43zAy2d4F3D
Hk27FmmQFmmQlgL+jozZMhwuwaWbGjNwKxPzM+n5hzPOQfjSeBffC2JONXqO
cu+B9yXpb8/x5TPu09sZ4rfCYQU+RfxT+C8E3l9pbie2BEYl4TVvEt8eei9u
oGc7sXPk9JL7DYxp9L8i5ij+D+QsUHuA+3LS+3kArlez3gv1aEA2/uv4yryN
xz4zzUozuhP7zDV7zeQdtYYC781HacJ/mnOR/Afk9GF3hM5XmEeoNxh77Ye8
lbB34n+U8JkfTPmM5e8D/y3457PORT3YQa1mduJ1vWMKez7yWGmaSPtOia9m
OoP+cuD6i+vMWnJmraFzU88L1JtPu3bFVOBzora/x4gfxrcrdK7idyjlM9Ps
voI/BX4h4z5p2I+9LXCfYp4RWwRvqM4xu7CnI5+terSUdQzF9/BWwbeH/PEG
5yPuTYHPUjOtRj5T3aVZ2nti7732/Qn3s1nfBfVHu9ISuk8c8imP0V3193F/
U+ufMFVLf0C7rB430estOe+F+q9dFGfl6o9NkjsbOXdpkHb9AeXrzw/DrTXn
vVeP9RefRv53tOPa9f+WDpyT
          "]], 
         PolygonBox[{{4301, 4300, 2891, 1637, 4520}, {4524, 1638, 2892, 4300, 
          4301}}]}]}, 
      {RGBColor[
       0.43049999999999994`, 0.45499999999999996`, 0.5660000000000001], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVEtIVVEU3X2e93Xfe/UuR4cFDQrSqOgLVpalZgSCVgRhSr5hH51IUA1K
M781sGFp+fw8DcHfSCl1FCFoo6BRBAmNm9SglNZyHWhw2Pueu79rr312NzTW
3N1sZg9wtuCMBWY1eWbT0Ecjs4WY2XLaLAejnzBo2WS2EjdbhT4Bm4uQi/Bp
xv0s5ALOO9x/C+RD+4zTfU/S7IZTnPLtZt8h53H/Ana1+F6CXyf+D+FuGGfS
lKdvq9lj2DQ42d+EfIRY7bgrgl9lQnaHoFdB/wH9OPQZ2KzDfhz2ZTgj0M87
9cO+xtFfWQr+sK/DfRX6no8p7yXo72PqkXgsxoTJh3yzeny/gu+BArMvuGsL
lecXznP024W8vajtGmIupRVzBPaXkasaua5ANofCbi9ifEor/gxsauEzhzgd
iJHF+Qq9zQnbOY/z9W36Js4f06rzDXwLEXMKd7lItfz29bDvXKB/u3aYDQDP
nZDVecKB94XEC7ISuYoT6vkZ4pSmhDPxLklpDvehX3CqeQX5B53yHSyQP+M0
oZajCeHYijjHEsK3A3pRKCwnoJ9IqI4e6PtD+R5BLR1OHOqB3BdqJtlI2C/H
xZmToThD7qzF1Sd7GQ3EY+a4g/paUOfDtPiWDf73QFmC+H/j4hxznHWyOQN5
ymn+jaE4RdyIRYVTjnLIRsRtRfwmyHOeu6WQ63HZbHAmrblVJMT9Xr8XL30/
5BQ5zvpY02AkzpA7/ZHmyzlPRsKcfOlOCoN6p/2b9dxgbNbD+Ks+Hnsg77iP
xOtwKO5UALe+fO1zf774Sv/OpGJQ37BLiavk7C3/FmQgu/yMOKt7MWFEfLgP
3ItiyM9x5WbeYSdOTnhecy7kJ3ed3CD+5Cn5wDnuCRW3DrmmI3GDHOGcOW9i
RLw5P2L0xCkX94ycI/dO4+51pNjkEXed+8O+hiLP/VCz4sy4D3ybOKfbyPs2
0gzJ2asp4frUqXb2xr6o//G71u6EHXnR7WRPv4zHbSApSdzoy/lzjpwdd2gt
EHbkOPnAf2NO8af8u8IeWD//bcwFvuX+HeN79g+Mgd9x
          "]], 
         PolygonBox[CompressedData["
1:eJwtlEtIlWEQhsdLHvOc7Px8tQkKWhRRlFFa0MWy8mgEgtLKSskIgsrcRIts
kV28t6hlaXm8h+BtVZS6ylRyF7SKoKB1m1qU1vM2Z/HBzD8z79ze+bc23Khp
zDazKl4ub3eBWfMas+85ZiWFZk3o03z/m2+2uMFsf6HrrQQVIzcmzVrw/xwz
SyfMuoLZF+SWLLNO5Iq42VewegDftN6sjm+V6I+J78C/OzKryTMbJeYO+sPg
sffAbEWu5z3BdwZ7A/LZdWbVxH+knjT1dBFfTfww9mbiy/EZQZ4lfonaxrFP
Ue8c+gTydOSy+lki/gb9jWO/S45SsOeJeYv9DJjF1L59o9npHK+hE/wh4mew
rxD/nvgi7D/J9wmMPci9fFvOd8wefOfR/6BPoD9Hr6W+V/jXrqU/8F5Enk8+
8t3LTL/lOEYPenvCZ/WDbxeCz0izUo+p4D2qV83gIPUuJ70/zfQQ+rlMvjle
N7ELSa+/CnsJ9hTvJvN+jf188JpUm3ZUzjwGgve3ypvGNhZ5vlXqW6C+toTH
/u8J39Lgs0yjH0d+hn99nud4R+4p/FdijinsFP2+YTaz6JfQJ7H/jjmnruPf
lXCb8NXLseDY4lQRsc0Z/i2CcZhdXgzOFdnFvTp6eJTlmKPBOS1u3yJmW4HP
RLPRjlP4Xom7/y++DeI/nnBZ9fajPwjOdfnIdwcYH/K9x6f02of/cLZz9D6+
m+F8X67nrIp7zapNMYrdVei3pJvaiTwMxqT5jEcivzHZhbEFrDIwB2LOGXF1
LPhuVI961U60G3H+ZeQ3p9sTpyrjzllxVzkGsLdFzoVBMG5Tezpyrooj/ZFz
WFxWvt7Ib0a3o3qn0NuDz1433xH8BnWLQ7xTwW9Ut6od6V+xmIkXRyuC51Ru
9XQCvSnpty9O7GM+R4Pfomo4gnwgsz/9oy7jezJ4LtUrbl9L+q1oB1eR65K+
a82wjPn8AxKHwXM=
          "]]}]}, 
      {RGBColor[0.46806, 0.4682, 0.5439200000000001], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVElPlEEQLdYZZoaZ+fLNePGgaIgGosQFEEQWWYwGYmI8ACIxnlAIeOCg
AWSRYXNJPLgkEAGJSzAuB4MiXDQKQY13SfR/KBff8/XhS1fX9/pV1avqzrvY
c6Y73cxG8GXg6wibpWWapXyzJ75s+tqzze4C+BKYIawnsb+UZjYfMPsbNBuE
rwL4OeyPYS3FmU78/xY3O4H9IvxfE2YDEbNRYG97ZvW54hyH73BYfOtxcZKv
A/viqNlbxNwXQlzwbOLfLPDP8f8n7GFgUuBqRD6jnvzMecP0f9NhysHfhfUH
+FezVA9rqUEOdSi8Hf7HCZ0/C99KXPEP4twG7MuwaxH/N7AvwJkCbltMnEeA
6UNOI/BNeKqBtdQAX+J0+BiXFrTr4b8K/CPwlMMe9JVrYdKsH/4b4LkFnjZf
eTaAYxr7V8h3L3Q4D/8K8JPAPoX9B/YzX/pS5ysh5Ueb+S0EpCnrqQirhu0x
9W3Wac34rJ26DSPWKcT9BL4ypxtrvYd9L7Q7hzr6sP5y2haHpQ91KoiKvxBr
q6/+TiDP7rj4qTHrO50tLQ6FlRf1nvLkn8Q6hq8J9mfg+zz1qsyXbz0ojiFP
cziI9X5CdTSyj24+GJO9WnT92gldvuDsA2CP++oX+0Y+xiVng6/55JzW+fKx
Jwuwl2G/hl0UVS+q4FsLavbINepLk/mI4jA33pUBT7kxxwMhadwKjj1R5dWG
PPOiivswIS5yUtNqX72rxNoMXe9A9w8OR/xNT3euNkOxdiXV06PAD7hYjDmc
pZ6tmO4b+8L+LAH7Dl9vmvJgPruj4iIne9PsC5PCucpc+XvAuRrQeZ6dimjf
7iv+VlD3jDG/BxWXWM4t7ZYctzfVtZQpfUtjsktiypHzxt4XJFULa+Jccj5H
UPuFHJ1fdvd+2c0w/7M31PJ9QHlwVqvdfa/C2h0S946Q5oyzNQ7OmYRynnbz
/j+PNM0f8Ty35t6RGU93kvPAuZh17yH3c7569Ybz4PD9nv6zp8TsT6qGIqzX
I9Kfc5Ef0rvH94/3mzWSazQi7fKTqmM2U7jOuHrcFXfapOsNYq8W3N3fcved
ccci0qXF153hfF5zbxJrZr1N7k5wDv8BasrT+Q==
          "]], 
         PolygonBox[CompressedData["
1:eJwtk8tL1FEUx89kNuXMODP8dFVQGm4UCnpomflIxx4UQg/TTIlqUSnZwkVl
OaPOmNoDWkQLJTXpQVFtwh4a0UIjiPYF9X9Emz5fziwunHse3/s933Nu2dn+
o5dXmVkbZzUnFzV7FzZb4LQHZtmk2eE1ZitrzcqKzMo5X7GP4BsjtrXU7Mw6
sw+AzJOfoX4WoJYCs6aY16j2EPnD5HcVe+4COTVxs4clZsvEM/iGiOfI7yhw
zC1gHwNjOGT2Gz5Z8D8nzC6FnFOO/Bne+0XsJydNPI3v4BrH3ATWF/J7yW/D
N0lshff+EXtNr1Pc56KOPVhodo7cExF/T5gZ8DbEvZ8/cKoj9ibq/EP4nhBv
xdcD9hL1K9T34FuidgCMFrh3x7yfv/ieEruVdO3Ug3qpjrsWylHuZvTJgd9H
fHfENZE2F7hv595HzTBvLcI/RW4q4m9pZh3gfyJ+MeQaZKitxfcoz0e5ndzf
h71H9SqOit3njRT2roi/neVeBn5z4FxHubdgpwLXU/FW7OvoMQ9eM/zrqb/G
PU1sBl8589sWce7y3YRPU+D8Rrjvw65lRvcKvX/NPk39TH5/GsE7n/DZiPMY
sfGoc5Xmp6k/GfiuSvNJYlfAeIH9knOA2I+E9yPf/sB9immelfS3l/ts2DUe
hd900mepHdGunCLnm/nMtbv15M+FvWf1vpH3XhEfoOZBie+Q+GpGvdi5wHfl
OfWPya8q9re1U/orDYHvojAbse8kXWtpXIN240nXSjPYGXGO4ioNd3A/HnNs
zVN/ZSLpu64/qr86UOS78p37NPyqSv2vqKdK7IaYay0+2vX+Ip+lNKmDT0/C
42/JryA2VeJY6lGzGUn63xYf7V57fh6d/N8s/XUlXBvt4FXuzwL/Cx/hPIt9
I6+3NBzErij1WnEWd+247EVquslfH3f99EeGwLub9F3UjGvRYyLqueKg3dgT
+C7qjWW43M7nS99q8v8DQQil3Q==
          "]]}]}, 
      {RGBColor[0.50562, 0.4814, 0.5218400000000001], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVclOVFEQvTLYzevH6355dEQZm0EDauLIoCQYRXEHmkgYggsjQiI4gcaJ
ZsaoUVg4JKKCGnDDxo0oiVPUxD8wKiu/wGjisNJzPHfRqXp169ZwTtXtxKHj
+4+lGGOu45eKX2HcmHnIHseYwXQoacbMwWFDxJgjy4zZGhgzge9T6fIbDBnT
Ab0TZ+/C0qdhn4TPE5z1wv4+pvPtuDsC2yh+D+CzEwmTKYo75hvzDHdfxRSb
OXiXuVnDNeiD8FnA2Qv4FCLWIxx1OcrZlKEcKwLl74A9x+ZbBbkFvzvQE3Hl
pM68g7B/Qx0H0F8j5Dxyzaaof/aX56gX+iziuz1TtVREjRl3dXYY9dwLqZ9+
fH9NVf28z2/amWsUsT7CVg25OyK/bchfDf0L9GLPmBbbfxXsRZ7sJZDtsI8j
Vhn0Nk+YtEKucVTXLk91sJ6pLGFPnWcHM9Qb+/qbKkzZwwXguWe5MRchb+LO
W/BX4Khe6sQpNxAvLxG7CHXWwr8P/glHHI5C3wz7XtiT0CuII/Sr0Ivg8xA+
l6H3IsYni08BfGrgcxL2fYFqbYCsX64ZIn87MtXvADAuRJwZ2AZ88Za02P4I
qR/28hnyQ1gzUZ+q3jk/7I85ORvZyPEUdSyilwo7D5yLdXHxQn7OB8JnxhXn
sxbDSeCziPgTkF04G8bdlfAtwO85Yr4mPnHN4TmcV0bFEbli39wT1jDqajaa
cO+Kr7tvYprhRdt7cVw5e1FPXiAMO6EPBeq3GTFvZGlOOC/Enfjfhi0a1axx
X9krMWXMfl/6pohmnb21IN64r/jkqgb2HtzNRYylkGaGWCxBTqXpLDsq/YTF
gDySG9cT9tzL7yFxQ16m7fd69DQXyMYdIgesr9vW/jOsOEm7P+S3OZDOXZmx
cR4H6p84tHjilvgS21tpmgPWcT9NdbPmjfbtIjYJTz5VEXFALsZc8UcuzqCe
8qjegTLIAstfPmRdRDPViHvDgTAagVztKVcp5JCvveB+NNjZLkHvA4FmadpV
H79DmrnTFn/yTNxZby3wOeqLN75nd7M0032OcCJexI7Y8z0kbuVx7fnauPbv
j90F3uHdUr57rnDJieqcfuy5MlBfdXa/ue//dzukb+pnXXHTBpx+hfWu0s4Z
4f8E56TbFQdZUb3RrG3Y114yF+vJd/QWtMa0m3w3ySHffea95Cs2cyzY/wHW
z/p67VvHN+8f+3veLQ==
          "]], PolygonBox[CompressedData["
1:eJwtlElL1WEUxl/T1O693nv//L1hmVNqodXCIocUjIpsUWAuQi1aBA6R2mBG
k3odoyJ0USZZaUW2cVGbBovAVOgbRMOqTxAFZav6PZy7eOGc9zxnfM77Fpw4
3dC1yjnXyEnhbIs59zPNuU/IW5FPhpwbRh/iZPvOfch07k+6c4+wD3jOtWGP
Y/uc7FxeGD3g3GNsK2AWwS5z/iK/WY3dtzvZXqNvQF9K6PIZJV4e/ovoe4jX
hVzGiYOtR+9FXofPIPlmwLei16N3Jzn3grvDyNc9i6V8N5CHPatV+UaQC/Hp
Qf5KvI3Ueyxq+jf0zej9nsV+xV0ceb1vvUt/B7YavY18R9bgz3ye0/9Kms1s
BtulkNlawB8E/8w32y18ZpGveVaLelbv6kH5fqMvoLejP3E2M80uB30O/Rw+
tzMNI+xL9CzizZHvVyL/tGbjWa3iSFy9j1q+2lTqDTo3wd0Stjr0XrCd+E9C
/Bf6z6f/hajNrh57OfiisM1KGGHXRkzWXRX25rAtjjgSV2fATKXYPDdha8gw
7r5R3yD1XfAsvjjqQX4btV4OkG9H0DgW/jgzLI3ZDmgXHuBf5RsH6q8GfB74
KfoZZ4HrwNxHzqS+iRSbYYj8+zhPsc9xV4rtpme9fWQGk+Cvou9PNU6XiV2Y
6Fc7od0YoZ8x/L9z10j+u5lWqzjLD9jOqNeHxO8DO8OZBf+PuwHw1dTYmWQz
ySJ/dsSwuqvBVhKx2tSzZlWbYbZRYuxG7vBsPtPkO4V8KGq7pTent5cbtrfX
zV1uwHpSb+KzAFtRzN7GPP6FyDnc9RK7lRxl5N8etF1QDnGx0zfbPXzKkceI
N59uOZV7l2+z6CPGRfIP+cater6MvCVm3Gnm/egtAatdMcaJ1cTdj2TjbDRk
nIpbcXCF/o5GLbb+gDvgi2PGrTgYBt8ctV7Vg3qZDlkuxYz79uZUq3Zcu14Z
tFloZ7W72nHp2pEOfM979jb0x+mvO+vZbumPaUcvj9jb1Y5XIDeFjVu9Ob29
krBxJc7EdaVvb1V/UgVycWI/tE/6e/aGjQvVrN0siNms9cbzkf8Da7C9qQ==

          "]]}]}, 
      {RGBColor[0.54318, 0.49460000000000004`, 0.49976], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVVtLVFEUXjnq6MyZM3M6Z6IyHU0LjOxuab50w7dALemmBIGO10y6PKhR
FhU9aFfooaiQ3rpRIAVJURH00ltaED34B/IfRN/Xt6OHzdpn77XX+ta3Lqfq
2FDb8QIzu48Vw7oXN5vHZgyHK5NmHYvM3mbM1mbNjpaa1UHuKDa7DL0B6FyF
vILVCb0HodkrnD3xzBqg86bErA/fnyLp9CTMsli9RWYtsLkC+pdw/hH37bC9
E35Hob85ZdaI/SbIKodhGvpB2qwJ5/Up2d5eLPtlsNMP2evJFm3m4afIF8ab
kfBecpgnsRZg5zzsTuKuB9/5wGyPr/PdkMPA+M3hIa4PJeKEi/w8BldN8D9T
It83Iu2DhO5fwtcEOYStR9CtTggH/Z8MxBG5OoT7HGI8AiwziDF0+hnE2u+J
3yrENwv5y2HeF2q/E7r7sZ/GXXsovsjbEuxHsL7i/CLketjvwrs6947x0w7z
8BPfw/juLJX+Z/jOF8gOa2KoQJwT03Sh2e+YcDc47g/DzlhC7zZAzsXEHXmb
RZyvIZ8ijoOw3xwTJwMJ8VeW+M8v8fF+pEj4+jLydQAx3o6Ld75h7olni4u1
tVQ4K7K6p23mczvuDsHm9Uj7roRywDhW+arlAy6WpWnx0ASe2lLiphZna9Kq
B9bFOLj7ARwPEcuaUJhyWdmYKFKc5I954nvufzg+51wdMca9iKsX+2usu0BY
WYNljpM6+LoQygaxnIsLP/XIzYLLXzn0vmN/GPbaQp1dBLZnnrCQ+3nH979a
ZZ2yzviOOSZvI3Hh4f5dJL0TeHs7Us2XA1d5Ulw+z6gn7sYVT6Wv+hj0NBNY
25wD1Vnluyar3I652BtSqrUhT7XLWtwFeatQdvOuv8htl/NHvyvgv7FYHLDe
WkP1VwtkTVI+i5Grt5GrS+DP+YorD1+rffk9gf3WUPjrIYcCxcu4WXtTheKr
N5Ad2rvnqTdqEUtlWjo5yBcZYamA/wFPPJAP4vjLAc5zoeYe5x97tNnlrjKr
eVcFmYXOWdxFkKcD8XgGcluoWdwAmUqLD/Yxa4FxkRfyyLgi+L1TqL4gjv5A
fA0Eqm/2Eetw0OGs8TVrWAvLQ81WztjKpGqD+WAuvsRkl286Uqr1qVCSs4C2
F+N7lPnylEPGwrfrXI+wVyoSrkd94WJNM5cbnb9ylyvWIuNizxNzPqkZwzlP
rN2wMw6dZbB5PND5YKB3o+4t9anD3HR7whJC3/MVTwQuezzpDQf6Z7AvTmG/
OimdlK9ZwJlQi32Zrx7206px/kfI1/tIvohrudOhLmuO8bDXl4bSoS5nFbGS
iz+Uy+HN
          "]], PolygonBox[CompressedData["
1:eJwtlMlvjHEcxn9qGZ3OvDOvt2NtZ1qKVlSIrfRii6u1oWiIqK5UbYki9u1Q
S0gcrGncJBKkIYiIk4ubLREH/wD/gfg8eebwS7779/luv/q9A5sPVoQQ9vDG
8ZqiEH6NDeH4+BA68iEUq0LYMSaEboy64xDakhBGUyFch98M3YusZYJtnmNf
h/0u6D70h9H181aU9W/QH4Jvhd8J/xJ+emJa9jOgC7kQ7gLkMxjmEGs7eD6B
6yc5z6E/jv8q/Dvw+YD/rCrT/fiPxzYb2fcq9r2ZEI7Gji1MM7Hdh2xTJZiw
WZwN4QQxv2Dbgew+uoa0a1cPGon1ANnXlG1k+zhjLOKH4FdgP4z9NuwvQi/A
Z5h8I9RQRy1HYmNT/nrybwRzD/aDyFrIXyTGFWJd4/UR+0IZz1nsz0PniHGb
WD+Ivwj/ueQYwn89/BHoZvI9Dc6p3DXIBtF/Qz8d/kLGs/oDv4V4g+DprXDP
S8TbkNj3BTk3QTcU6HmlZdIdyhir+jEVLAvx+T7WmIStGpvTKctqIs9Ysz6H
bCq6KbwzKe9AH7lr8G9HfxLZpMQ+8hVmYW8s7596VEh7hpqleqRercP/N/r7
8MsT74DmL30JvpZ3OeUdOUa+7rR1ilGHbkfevXxIz4rouniXUvaRb8LrqnBN
BeimnGfxF5950Gsj05qBZjE58S7JZz9YNybupTAKa0tirKfQt5P7fd67oJw1
iW9As1gJ3oPg7cLnH76j9Hdpzjul3drNTOYzmwOxbd9ODCGPrjPjXg7xYuKV
sLmT8k4UoRemfT+K2UuukcTxXoPnGb5L4e+V56fZLoE/WWHZMuhi5F71ICtF
xiRsirGL/Z2N7EnwjsyBro5MS5ZAr4m8e7oh3VID/EBZPxP6RrVjr8TmJnQt
eD9S22r4A9BNBd+majiVdo2qVTesW24uuDeviPEocY/Va8W4Q7x69G2Vrkm1
HS7/B+/Q30LfFftv007WUn91zv+HMPZnvDPaHcky4F2b9e3pD9yKLp9zLa3I
YuhmZJ1jPIMF0FHOtyhZFnpJ1rb64/TX1Se+fe1wQ5VrVu3CXAf2OG2s+jMH
Ys9cs9ef2wM/LfGt6aa7M/4ThE83PAv/zrR7qxvULbZH7pX6qb+1lPNfJR/V
9h/7Tau2
          "]]}]}, 
      {RGBColor[0.58074, 0.5078, 0.47768000000000005`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VU1sVFUUPs7fm7438+a9uR0XpJY2FiOhNGiFskDTwEpN1JRpbGgp0sCg
NbRNTYyDWBPdgDWRAjWSWBdVVybEMmy6cI+wAYSEnewFLKXd8318l8XknDn3
u9859/y97onpoamMmS3jl8VvLjA7jd/IC2YHymazkFsrZl86s98A/KVk9ivk
Q4BXgb+Vmn1VMLsNOZ03uwt7E+dbYrMlnHeE4IV+DfYMZD84Gzg/Bp69sB3L
CJcAtwB5MpWNeMbQ4Xna4f9v2P4qml3A/8uJ2Z/wdxD4D8H1Xc4sV9H5WwVh
ToHnflZv6Iul74Sch/1fb38V/38Htgf+Z/LCnPLxMc4UfscQ8/fA7gb/LPy9
Cf6uyKw7kq/PYNtdEP4HUz6YK95ZRzx7Cor1U3CehL0TnPeQ4/ezwu0F/z7o
HySKi/4Z26THlxHjBM6a4DgKuQN8K9DPwdfr4LoErn6nHDBHfHtvLK6PgF9o
V8yM/RXEPA7uGt5SbzMb9PXKx7r7Ms4T6GyK9xL5v5HVnW3+bhvu1pz6xEG2
xcIUIRt56c/fScl3HEmU92HIVl7xnDflb9PX9DD4xgP1wZZQ/TQC/P9VnT2C
fFKUTsxj/D8CfQ1yoyidnJuQcwXlnz32eaCeipz0EPJOKsw/kCne1Qd9DPqA
r8UeyOMZ3Wf//ez7vom7D+FvFDwPIP+rquZHQ/lgTohn/x7yc8SZ+CIQ32ZV
b50IxTEWqI6xE6bMvDr1EGeL56w3MQOQq0XpVdRgEfV2kFWn/uuI1BcDHr/q
e4/6dKrcpPBbicQ5Atthb1+vKvfMA3PrUMubiLs9Vu+Sn+/8JNU553Uw1h6o
g+/jVH47I9WHdWIs9L/uYy4j1vOIOYa86vtgPFUeiKGfoVR+mNchvKuFs2HI
J77WrPlaWTlkLl+K5ONEqnP2wRXwdFU0y5x7co/6PP+RU8ys5eWSemXZqeaX
ctoFK4lin0xVb2KXgA0r6m32O+eHs/BGWTVn7Vnrs5i1Ffg7A1nB3SbOEv+O
q4F2JueecZC3F2eLrDFkPa+7fP9BJ/y3Jdkbnv96VjPGufqmpJnajxg2qson
88p++zHQXHO+F73O/cWZOIGcNUra9S86zeS858v4Xf1uov6lb/rtieS7G/hC
LD2A7HPytdNpX3BvRL4vuK/4Xu5Qxn8c/FOp6tNK1L/sMd6hvJiTzjNiZjib
FdmTinI473cj88rZ5EzR1vK5XfJzuj/WXhz0+5R9d9fj2ePkX/Dfp2ffqVh1
+TqvnVwL1Qv8PryTqL5vJ3oHc8IanQ51Z3sN8+p3+pzTPuNeYz24g38KFMNk
Iv5doeLi94b2utOb+L3trGkvb4V8zenuLsin51PvNg==
          "]], 
         PolygonBox[CompressedData["
1:eJwtlMtvVHUUxw9tZ+4wtzP33rkdjeCDBjUobyrgQgyyUxdKO6aNliKNlJdt
CSbGasGFGx9EQxUjRk0UXRmBAi5Y+Fj62BiRxJ3+AaKNlD2fL18Wv+Sc3znn
e96nf3x6cKorIiZ5PbyHGhFjSyL0uRk6aUb80h1xHOFIb8S3ecSFSsSj1Yj+
NGKav4+RPYLOw+ivRf9v6MPoLK9HnEf/PPQ69Av062XEywm66GxE/3HkL3T5
L0XWQecqsq/BXJVF3AHeFfhpMJaBd3tmf7/xtwrd9anlc/w1kA0Sz7Ng/cRf
N7Y5mDPwe/HRCz0Oxvvkeb0W8WNfxN3YbyW2efDnieVO+M3w5+DP5q6BavEB
+AX4Q+CPgvcc72or4uncuX8FZhvsEh+zyI7xJtAdyR37DBjD0BvQeR3+KWxm
oQ8Xrs8i8fxAPFfgj+H/OvZnsG+hM1FxD6rk01+angTvEPIaf792W0e6OxvG
/hP7o+h+URrrOD0dbTgn5bYFH3eRa545N9WzBGuY92WXYzyI7iTxnAjHOAXd
B96n4Rzb0FPEcOpW/7eCfw94R5Z4BlZA/47N0ar9L4DXwOaVxD1TbzdhM4Js
Ap8D0P9S012J+3EO/T28mYpnYjv6R8jxUvhvHNneXtuqZ63SM6fZ247+i9B9
TeemmdGsNpqunWb8fvL/nppfqznHA8Q6VLg+78EPQveg/zP2b2M/jP2DpXv5
ITGug17PexX+I/iN0HPgfVezTQXb1fydTBzPNvLbUFr3L/g1yAfgTyXGENba
0tiqj2b7s173QzWcLT3zyuck8bSo7wA16FQ885r90cK7NgbfgR8rvK9z5LNL
s1V6NoT5GvSWhnun+mi30qbnXfW5L/WOale1Q1npHJSLYt5UusbiO0vZpXbE
N/hcTDzDmuUR3uqqd0a7s6fu2s5To7eo1bu8SzXv4H503+yzTDkpt5cK3xrV
VLXdV3h2ZSNb7ZT6oRqvIZ6i7ly3oXMC+YrUtGqg2/Vk7tugm/NE7hugWyD5
IrNXzXzrtGP3pt5J7aYwpwvfQMnVX81GM/Pt0X1ZDl9m7o1qmMPfVvoWaMY1
6ytT2wpDvhbwuTvxfulW3uxZ4h34D9nSzL3Qjtcz3zD50g41of9vOTZhXIP+
p+XbpBk+k3uHtEvqQYbv53PP3jtg7IZ+BowLiXe2A3351v1RDz8vnZP8aeeX
Qb9BfBcT2wwif6zpfdTfUOmbrdutG6RbpJ3X7gvzD7B3oH+6yzay3dFwLOK1
2w+0bSudT/DVk3n3dLMXdF/anjX1XLu4LzW+5lm362DhfLXT2u0b9aLSNw==

          "]]}]}, 
      {RGBColor[0.6183000000000001, 0.521, 0.4556], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VU2MFFUQLnZmp4fp6e7X/cYYvHlQZnUSYElYEyUYiIkC+z/sDCDCjnvQ
BFfdqGuCwA1FDJhoYkIIySaeOMAGPGlM5MRFSYANePRiUAPuioQTB79vv+fh
5VW/rqpX9dVX9Z7uvTsx22dm32GVsAYSs0EITez3sH+Bn8fXmD1XMbtSNZvA
97rU7Bx0E2/2StB5Hzrz2JfwPQP5+4bZetiM52Y/NGTfgTxRNxuD3mZn1oKf
C/CzEX7e6Te7WtV3D/+vwU8Hfpqw2xuZjeKsAv2v8b+omWWQr0Mnxf5EbPYj
5EeF2Z9YXej/VcjPfKRYb8L/DazbkJvQPwjfT2ZmK4lsy5CriOND6K/FfgTr
NuRj2DcghkOQJ+GvjTUNeQT2v1Xllz4nkdc4/nWRY7sunF6H/G8h2weFMOD5
bthWkMMi7D8FNqlXnHUfMIPOLugsePm+BT8nobcJcU7DbiIXLpPYL0WqAfFf
6FPM12BTg14Hsb0AnH/H3Ruhsz7R/S3YDkN/qCSMiE+vX5ivYob4v4KfAdz/
B2w7kO8WoSbMvU93kR/kxovwuw3yS9jnaopnO+QDubB7A/ss/L8Z7loHncP4
biO2QaxhnI/jzqk+cY813h4rp1+das/cd+I78+LFpkRc+yCS3xa+u9j3wc+p
svzQ39m6Yh1LxM9vInGsmSn2diwefVkWJ36GfKYsX6zDQEX1Ilf4fwv81DLp
rMUeZ7I9gHtKqbhNjpODxJxYnXeKPcFdi07+/i6U17MV1fqyU01WcH7R6exe
obzpk/bkxuWq4vKxOPgYd+axbOmDmBCPmfCPOkWs/iJXiGkayx/jGs0Vwwj2
PbnybWMvA+c56JfI/5o49QvOt6Wq+9tO/KEOObPBC9vN2COvulSwn2qoZ5ZD
n/Uife+ph16Cz58a6qke7vm8oT7bj/Nu4ESEOwe9ctqaqEeHQp77cvF5by5+
Em/ygzxgDR8m6iv2lyN3gs8yfJZQu5Oo3VRdsZE3///jzvuficWJGGdZrNqx
huQXbVfnUeAG58oMeY51Gucu1OVb6B/14ts44pnKNQs4Fz/uV23ISfYQOUp5
CHrvQZ5FDEu5ZteKUx69kGNWU9++6oQFMWF/vZxqJk/j/H4iPInrU7XQf6n6
hz5qXjWZDnVpefVqB7ZbU/UOe4i4E//nw1xcCO9C7JXva058Zy8z97FcfOU7
sDvX+YmG6kO9VXzCDPeZOLUYKe6DTrgccrKhLecE5yW5yr7hbGNdWOOmF3ac
QzudarDL6Z1gfarMN/CTPB11wrbA+VtOuTBX5jES4uebw97jXT2nmTYX5tZS
qNM/TvP/gRNexK3rxGliSe4fCb3DHmL9WMebud4/9vVnDc1I1oi9OuKFw7DX
DCY32LOMfT70Nd/hVnhLrgduLMPfcqEzvj/DYWYwF+bE3FjvSSc/H0HnE9xx
B37P1zVnec8OcPZ+oRmz+qYlqjPnZTNgz9nEt5qYk6sPC/GHfcw7xwKG5Mmd
8B5xbg2Et41cJVbM5T+1lvNL
          "]], PolygonBox[CompressedData["
1:eJwtlEto1FcUxm9mJjPJzPz/839Y0O66sCY1YFTQLgSLUqyPxLwnvk0UW0Gt
im0EtYKbKhUrKAiliBVXgq2oWxeu3FghKnbrpmrrI77X/j6+LC6cc88533l9
9342/v3AnkIIYQenxIlqIaxqCaGHyzVpCHOiELqLIYxWQvgvC+FSgg17VzmE
9djfcLcV2zz0Teg3sPdiH+PuHbY54G1BPw14rRHCe+7Gsd0E8xXYc/MQtmPf
0wom8nPsq9H7yf8C+TVnsOAcbxVbNbYwhPVjPYQJ7EvB6yC+SQ1fUMsaMC6q
Fs63YN/FnsQh5FXrd9Cr6OeJ/wesh5xDxPer57JruEBsqeFaR8jRxHeMu5PI
X3M3jvzzjBCutoWwlrseYkdT1678DXr/kDl+iLth4oeJ2U3+g5wtyBvxHyh4
pin+b5nJWfZwgnkVyT2IvWO6nj/x7697N9rJv2AvpOZzFc9wAfJI3bELsHeC
NUn87eAeD2NvBfOXkmv6hHzLOfta3NNv+C6L3Ntf+B+r+0hWzap9c+pda8fa
9ZecJrZR4ruIbQf/15LnOxvsVnJuw3YAjApyVnOsdvoC/4wd7C2YI+JKH3d/
FFzzIXa1NfGsLqN34bsT/XnRPt8h12Ln0k61a/WgXq6Sr5d83eAtxv4Depvm
Mz3/M+gT9HYf/4dgT3L3ALknd6xyLAW7I/IsNTPNboya5qOvw+dZ5p1r93oz
MfW/izwL7VC7nIq8e/WcY/8pN9eOoh9B7iX+87I5VAZ7SWQu30I/A7eGsHdi
v4ZeqZrT4pbuhlNzVNwQxtrUPvIVh/vQV2PfTm+nqKdAP1OJe73HeY08mvjt
/Y79U2JXom9rdcwq5A2pdyV+JtTfhs/1Nr+xEWz/Z/4bevF5jFzOvesH9DCT
fOtS/xWKUeybxLkfoV+hvwT/Cfybei+536T2KU5Vq8YQ1i70WejV3L6qsYYc
x37b2r/e9qLIXBKnFiO/zDwvvbGpzDvT7vSmBqitCMb+ijkirrSAd1tvG7wG
eCuod7xgnxK+7bm5JE6L25vq/ttUQ4PYV5lnpZnp72qPzQe9iSr8uZd6/uK3
3mZ3bm7rDc/PvXPtXhwVVztzc1VvdJnmH5tbwhT2UM1cEue/Qj9OfF/BHD0h
/iSenf7IwcQcEBfkU0SuxP7bhFmOvUPtsknOp8hPMsuaiWaTN9yrZpwh/z39
v6inu8hRbi5ppzHyN4lnqRlqlh8B+gK7DA==
          "]]}]}, 
      {RGBColor[0.6558599999999999, 0.5342, 0.43352], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lUtoXVUUhndzm9ybe++5OY9cm0IdqIlpfdCCKKXkoVa0mjRtTRNpbDBN
RJRCHVRsIaLWIg40DhQV7ESqqBHUiYio4Kgd2EeqLYh1bH2maVV8FdHv598O
Dnudddb+1+Nfa50rph++e09LCOEjnhLPc50hjKGYzkJYTEL4BGVeC6HcEcLc
8hB21ENoRd6yLITVfL8jDWFXawibOK8qsCmHcHkzhFHed6PfztnVCOEQ2G18
r3F3AcxeMJehn0P/XR7CDSXjv8T749z7qeSYPuU8iP5mYhrD9wz4v2P/YGq7
hzjr1RAmkPuRr02MdQ3nK+RwBP1X6BvYTCHfjnyc+x9j8zM2TWIdag/hsqZ9
KN+D+B1qsc2d5PkH9vfj90/OYfRrS457oOE4R8llCv1R5HHs+7Dt53kSm6UK
uMhPyZ5zkOdAsO6WqD+T2+ckMZ7KbbfAuYqY5tHvRr81870y8mLFPoR/vmJ7
fas2XL8Cmy9z+/iC81fy/IzYfuMsdViWrlkzj+JzLe83oW+Bo1vR72wLYQ3y
YMM8bEbup/7rwfw8N3/iMed7UTNPS2DM4nsEeSvy+cT6Xmo+yN0N1OgYd8d5
34/8Ir32F/Yr8NVPfh1gTaCfxHa8bA5Uf/EvXsTPBHbvwOMbqTlXDLpzY+q+
Vf+qH8WTOPo+N9Y5zjWJbcbB70t9byfyexVzLX97y+ZSPF6ZOGbFrh4R78I9
nTuG18HYTDw9xP8Mfrcgv43+NfQ9qeO9jbv7qN1pcPdzjmEzj83h1P0yHH3J
/4aYr3pNHClWzZNqpT4QP4pNs7Qu8b0SmGeIf5YYDvPta+GCf5bzH2q7Cv1G
fO4t/P0Q8YwgT6J/Ff1F8B9D/pBvywvXTjP9N3e70A9gcwl5JfIg8nVxvtan
nqejMaZGzXVQPUZbncsTxLlMmNonde+DXTH+cuFatxbub+XXVXWNhyJ3slXO
sj+beEY0K61Vc/Z0p/tJvgbAT4nhemK4lxhO5p6RE7lrr55U/tJpft4ilo6q
/WgPjWeexQq6mbp9K3bxo5qo1qqRavUs8sXU51Lccy+AO8P7qcw2C5l5m4v6
1YVtHq273+Vf9Xm307i/gHN17Bn1TmeczTdVZ7DWcee+uM/EnWbyg4rzVV00
H3qXvK9u35qzqdjTqmG16v2gPaE6b2p3rY9V3DPC1E5Sz6gW2m36Jr32gXzP
xx2kfbOdeC7EGDQP2g3KTXlpBjQL2zJjH4n4D9Rct8XU3O6J8zYda76C2LrB
eL9inHNxfn/MHZf8/M+Tzh2Ze1rcHs+8U5R7X+Jdq749EHtLsb8ceVE+es+a
rkPK2Vb1Th3JvL/V/3rXDIuXbxItV8f8L/FUCveFZlGzJF421nxPueuuanMh
8qK5GCt7xpXfaOwB/dPEr/gWH8pXfXky81yfyNyzPbFvfsiN0Rv3k3D0rm/d
sf7aa9pvlxLvGu2ce8BZWXUv6J+seqt31Z9F7I0G+uHMOEnN86n+aS/8P9H/
TFjf5s5lW93/H/2HlHMndbyLehZN9/7zsf+7C8uP1D2L2lniTPwITxzpfTbO
l3JVzqqhdowwNYv/AfzgBMs=
          "]], PolygonBox[CompressedData["
1:eJwtlFuIlHUYxt92dvbbnZlvdr5vZjTBLipztdNGUUjt7K5GYWm72robbi65
GmEEdqGkYHSyAyTbRVCBkdGBSi/qpiJU6CovSl3LoLLr6KibER20qN/DMxd/
eN//e3re48WbHrxza0dEbOd18t6qRYxeEHFNV8TGLKIP/nAhYhilxdCb+Bvv
sE6jHDGXWv5Bd8SeRkR3b8RzOPqYv3nIb8VmY5GHzS3Q59B/gTgz6CToTlTs
T/oF+L/yiHsT/12P/t3Euwos7+P/WfwPYL8T2Wbi3wR9LTpj+H8P+dPIW/CT
8JPoDED/U43Y3WmMdfCsrzj2dfBXYD8f+XTb39XIbybeQuItB8MKdCcrzkf6
V6L/Bj4PFK3zbyliaT1iQ5cx7UD3nsy1Uz16kG/gPUq+NyK/BPvXsN+P/QJ0
ziP7g3w3J65nk/iD2F+IrMXfMP7Op85FNVPtWsjnI1+GvIV8DX8jYDsAxr3w
Q5l9DyFfXvGfZD+j0yLXvl7zshnF9ilq9i5YVxHjSejBirEeRH40d01V20X4
XI3vleCfBv8MeHrB/xX8J/BHeN9AT1WMdxb7MrG+bstVoxXk923qWdqN/Sno
Huq3DawT5N8N3cG7odDuCb5exf6domtyjnivwL9ddA3+hj8Mvl+73ZOT4D0I
fwb+cfyvAe+LvP1hDC9B34H/j+CnsB+BPsbfLugvsenH32n87wHLw/ydQDab
mT4Lxn1110i1WtkTkTWZl7J9yb9yrTUt6yeHxeQ3VnbtVXPV/iLkM4kxLYTu
wufL4Rok0KdqruVn4NlLrGPkNJA4Z+Uun/K9ihhN7C9PPZuaUe3eUfC+3uEc
7iu754r/CPZbau65en8SnzuI90vqXmsGiuT/ae7Z0sxqduc1HWs1PnPo+2v2
pRoO4fsQGOewfQJ+gtj72v25jJpUib8O/oGic1yAv5/wP4H/28D3I/Sb7X3S
jtfQX5J6F7T/S6Fz/g4VvMPa5azq2dKOV/AX8EcKvjHVkm+OboluyJ/4n27v
o3ZsnHn6PbVc9dJup2XPtjAL+3/YbE08g/2pb5Zul/6Cei2rud7ax1LJO65d
1305k7pn6p1qPgi2BvItRWMW9kLds64d6qz7pum2KcfTqWdQs6ge7Sr5psq/
clAu6zPXWjWbhH6m4Vo/xl8X+usyz75uzDj0VMm7ph3RrtyVWaaeqXdrM++X
dka7M5LZl/5Gobfr/iWe2UvBu1b3OvHN1e39PvctUE9/gH4I+fOJez5W843W
bdXfEuyrVddON6IX+jd0PmzP61novN1f1Wy05psse2FYhH1f6tkRhu9y3zjd
ukHeCfg6M3p7j2dCs7Gz7lnXTmyr+6brtg/zvkD/89y0aqLbrJur26udO557
5jX78tmAns0dS/XRbZpr3wvdkOPU63+wNONT
          "]]}]}, 
      {RGBColor[0.69342, 0.5474, 0.41144000000000003`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lktsFlUYhk+LdOj8/7Qz0/8HY2QhIjVcqiRegF4opaLCQhQREQXFqDu5
KGhIRBNhQ5TEBYgUMIqoicW4UHRhiNFoIkGKBUTAlbpSJMGF3MX3yXtcTM6Z
M9/1/b7vPXPD8hUPPNsYQvhTzwg9h8sQunQwqxpCjw52XBPCGr0fLkIYGhnC
X3kI47IQJuvbo2kIo1tCGNZ+SiWEF9pCWN8Qwn36vqDZ+ugeiet22Z+gb/dI
Jq+HUEh3q85qsnNjm2Wel9/ntD+UhPCi1pv0rNX5Gp1365mufbdiWR1lbpad
W2RzoWxeVexPSmaVzhvj92E938nHe6NCuFcxvab9z5L7SLnsUS4t0r9buhXF
v0KySxttK9X5S5JdotgGpdsv3RkNxgV8ZiqG8dKfKzs/yd446fZq3ymZr5Xv
Isnc3+B4wYrzLZJ/VzKTpfuVbD7S5Nze0vsS7bdp7c0dwxPyE5TDMsnfpbNp
OpsuH+t13Kn3xTq/KL+dwvAP2e/S+q3WuTH+PaOcM7ntluxmxd/d4HWXntXY
kezr2q/S/nbZXCi587K5S36P6WxI8eyVzW7J9TRYdmeUZ49+l84/Thz/Jmot
/T69f1lzbuS4EtwqXo/Kz5uFz7cW1lkSZegb+qe91bEPNLtXOhPnDoZ7db6j
2TXh+44o8/87NaOP6En6jVptjvluzY3FVPkNLe6FNupcM16t2h9T/L30kure
UXHvjpHsndLdr/3ZzDWfk1jupN4/0fkprUcz43Uscy0eTFwPHuqAP3T7db4h
9iR+iZk8BmJe19c9P2O1nmmxn39T12efvm8Mrv8ziXuMfqF3yZe+4b0j83zS
eweUU3Nqn8uUe0+jazRTuhdK27i24v4dkP2VwTOETXoJX08lntUTuWt1XOvY
Js8RdpFdGWPAP/mj21d1/8wujNPsxP7nJcZzfoN7in5iNsiRb5xT8xmx5+ES
ZoaeGsyNZ1UxH4i8dDr3fIMp/XCiNE5LlXdjq3McUzGPYGNL4dkG+8vSOxXl
f81cY2L7O7MfbFK7s1qnxpzXNdkv3DIQ/WKruW6uqGi9GvugL/c8gPlj8vlq
6vmalnoW6U/68vHCtt+X/MXMPHJJ67nSeIxW/GtrrtEarb+X7rHfSmMHhszj
/sg/6FBTOIjZOZO5VvTCG4kxBYtzqbmtqpivyMYHsv+y7PfDRdKfrXVW5CX4
6Z3cfPCj/D5dMRYHFfvF1Bzzdu45pZep3Su12HOF80QGDrmQOt6dkj8fY+iU
zPaaeeFk7vmdmNgfM0089NgXpWf6YentK21vkfa3Ft5zBi/CTZsiB2AL3/Tp
kcgPl1LbJqcJbcalXeunpefgodR8BC8tUK6DI8z14DmpsAyyZd39N7oe+T7K
9MeZpjfonbNxfqkXuaM/XHpGmBVyJU5yO1i6/3t0/qH0rmuyHDnAveR5PDO2
YHyo9Hlv1fNAf57JPXN9ce7Gtzl3uG1S5j5ZLPnPYg9xR8Fh+MNXLeZFfuRB
jajpUGJ8wYU7Co5jRqgfMvTUBNmap2/tWv+Jvu7Q/vPSfQAfEysx9xTmwL1x
fke1un8nSm9kap+nte9rNkbgwzop9saswvj0as3iDDKLjRXzVH9hvmSm4IL2
umd3XeqHfUfqeOdGTptStb+muv8P4AK4pyV1rtwhtYrrurwwN7Onvtwf8Db8
vaHmvDbWzLP4h5P4PwFHMOyKd3p3bizBFP68Ld7Lv5SeY+aZngF7+hrdpNV5
wRlwxPyIX0+LZZgn/uOG438YPEwv9EaOnRb5oV439vyj8d/EXIMLGNMT4My9
hz6632SuA7PInQbO4Eb9sUnNjmSemWGtRd04gMf6eOdy9zL/zMIPslNNfc/w
b8h/DzjMyc1J2MFuR6zX98L8cup7bFtu7gb7E3Ge6Ae+dcX/MHCDm5ifIclc
ibq74//VYPxP+w+B7FTH
          "]], PolygonBox[CompressedData["
1:eJwtlUtsVGUUx09bhsHpTLlzO5eHgYW8SiggJIDQdoY+JoAtCxEqLymkgC5I
aEEoxoS6UDaEDQt5iLKAoCSAcSNs0BiMJjyL0xYQ2MGKAAku5FEe/v45d/Hl
nvOdc/7fed93Ors+3FpuZl2cYZxVKbPtfI++ZdYemT0KzPoSZl8MN/uk0mx1
2mwlBhcqzJIjze6FZiuSZn/Cv8mYFbNm49EtcteC7ktwdoN3YoRZb85sMnit
4LVxpkB3otONbhenrNqsBMZpsH5E/xW2A+C3IPuZu9vIFmGzHtt9YFbh60ec
bugj6PeA/zF4n6K/Gp0GdG9z9uJvd5nZP9Cjq8z6K/xNvf1lzt+aj04Dvtdy
NyHpPvTz3kz4WvhpnPP4UoRflPQYFMtxzkKwm7nrRz4v8Pz8hv17geegGOtP
gr+S9VyWuDuiXOL/Nvz/nlhXkO8G/HuAbR/yw8jXpRxbOVAuCtzVQS/gXIY/
BN5a8H6CX0r+FiKvh54OxgT8/5y7a/C9+LgLejQ1XFbmPv6HvA/7QfMaX4ee
Grn+X9zVQDdy9zb4J8nRa3wcynjtlWPl+lAcv3Sa0L2YdVvhXcp6TpXbOnSe
Ect6+K+Rn0K+AbqDuz3wT8D/lVpMA/+D2L9a6PH4sJx3d8JPVHzChC6gM4Rt
Ab4ePg//IuU9pF7axtmIfy3I8+Xu4yvkefgFqjX885T3uHr9OP6cI5+XQs+d
dPLYB8iXoHsG/7LQM/GpA9m3+LwJ+3TksRXByEReA9VCNaynlntybtuLfgL9
F6H3pmrwPPSYFbvycQu+E/9mk8uz3O1DlqZei9Ft5c02ZDvSngv18CTeeoZN
e8Jz9hR6IPBeV08cRv8AZw307+CN4f2bsVx3B7NeU9X2DHgDxJYP3L8D+JtW
7wU+24q5Cfpu/J5qdgd6LDvgOxZHAZ067Ksjn833wc1F3tPq7WPY/BJ6z6p3
1aPq1RDMxoTPnGZvMOO+aOY0eyMj3x3KQVXkOVAutHPug9WKTlvSfZoD1vJK
73XNfIH8P473l3r8K+L5N+OzKRvZ/hB47pXzHLYzOKUKj0mxaeY1+83EMAP9
hxmvpWbwCrItKY9dPToO/77Bv5543zSBVV7tvdgO/y62NfD7k64zGXpnzneX
cqBcKIfCk84U5M3gFeL+fclbs7Peq9oZs6BbsOlIuM+jiPdEHI92cDnv3wh9
9zRiPwhdGXmvaienoO9kfLdqp2m3aedo92gHbK/2HVWK+c/gawLf3Zrhx9i+
Tjm2fLwJPyry2mtmIujhkedO/5Q/kL8JPRfa4QZeX+izq5m+Dn019NnUTF8L
fcY0a4qxGPhMaDZU77nw07PeW/oH1EL/Hfpu0MyXQu959b5yqlqtJZ7N8f+h
Hvv/AbqB2L4=
          "]]}]}, 
      {RGBColor[0.7309800000000001, 0.5606, 0.38936], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVltsVFUUPTPTmTu9M3d6z50ZiCFR2pnpFEofJraE0oBteWSKCDQVrVab
kOKHUYgt1JgQ/TDxQ00wGmM1JsZEjcYIKiGND4wEDYg/KhRBSYwUjU2IHyQ+
UKCuxTofk7PvPvu59uNM447dQ7vixpjz+CXwuxIZ86BnzL84L+eM6YuBmTHm
QNKYxpQx+/B5MKnvZ0E/VjCmGQY6rDHHodMF3XTRmEtpY5ZA/k3IxTOy81Zo
TM7xJqG7APuH4TSJ+/nAmKfBuwbeOfw6If+rb8y7zs4e3MWcHcbVC3+LwH+y
IB3qjkHeh+/19QgZ52++7NDe64hxHr5mIDcJ+jvQO2LyzRjm4L8nJ5kh8BYC
5TeHnJpSype5d2aNmapDfpAdg53bcDcMO18FivFzyLeA/0ZCvv8E/wvQsQbg
aiW/E+eSjPRmgMmBhPKk/qAVzj7uV8blm343U6ZOeRxBzhuB8wPIrwz9teAN
IK6L8F2C/CbYaE1IfxV8DOJuAPRlxFLzpEscBz3lzrtR5FeLK+cCbKzA/W7Q
zbgvg9+G71OB6FbY64Dfo7i7At4vkXS3gL8cv6Wwewi81ZAZAf8+8KqecCEm
RyL1wMuhsGT+zP2mBtWkDbl/gxweRxxTeWP6wX8G/J3gnw7UO9dR4x8C6V4H
Dn85nBdDporaj+K+pSgsiEkW/Dvyqv806xAqb2KzNav4mccWR49D5pWs8O5F
rU2Deox92uNy/xv06pxs0jZjYmy3Q/eki/9rnO+HmpkLsP8UYv0W9B/kwUYt
qfp9HAmjT3HO4FcBfRfiP8yagh4GvRI62yHfjbMOtkuuLn34vh/8fpzdcdWe
db/XV+/8h7jWJnVHfimU3wXwZ0F/CfpMKPxon3mejdQn7DXqUX8X+M+DNwLf
7xjF8GpacfQEqh1ruAy49cF2EjE/DPmuhHq95vqM9EO+bCzGuS6UzDjoCfib
hs1HcW4LNatrQvUUY2D8PCnDeCYh1wSZpcB5vSdMiWeTw4Y97CHOCr7bY4qV
Pc27Y4HmNIU4zwbSPYezxdOeYi0rqOt+fFdx5iC3EXk1FJXLQbcDiffbac3b
EwXRVyF3rV7+v4fNYk47ZyhU37B/OEMXfM3ah8B7PKM+Z79vDjTzdwbChfi0
B5rNYkq5c//xmz5akH8KdBVnO371oNus8iWfuROH19LCYqogHLb7qv+xpPqY
fTTq8ppzsd1iVXPKsGY3e/LLGC5CpgMyz4WyS7/8LkEnAbrJqhakifnJtPzR
F3PiDmU/cL9yTuk3AL4bgF0WZ3tWe2M2cDvEU1345nBG6Iv3VcfnzJB/j6/e
YrwvWPVpys0Ma97sycYa12MT7NmM8nzJao9zJ434yoHx7ynofWOdOVfMl7NJ
bDO4L3vi8Q1hnsyReNe7/qMP+lqFXD6JtAv5Rp0A3Q3d3qzwJl6saZ/Vnpzm
3POtBP89yHzm3hhiw37kG8GYjgbKiW8ye5azyvw3ZLX3f4z0NrJfOdP7Cnpr
+ObcwMTtZ2JTcfhc9fX+9nMfWvXAacTT6Kl/iKdXFB7cN+VAe7UGnz9FemPO
40w77IlV2Wp3VKx24c9p5caeYm8RA+4P0uwx7j7ifDfs/+5rNrusdjxnhDua
uO53+S5yb/MA4nzE05s75vZB2WH7osvlFGRmI+2OMzjbXL8R44yrG3uMtumD
O26Z1Swtt5pF9irx/MfXTPK/CWeIu2/YzQ9z4qy3WmGxwmofjDmb/M/FncD3
kpgQD+4C9lTJ9dXevHjcE+xD9gz3YadVrLc626zNjT2Xl23uZtbwkvuPwV7p
crp8y4lJFOo/BHfnOpcXcyL+vKPMXvTLRF54823k/5F5h/9Hker1QaS8iDtz
+x9a+BpO
          "]], PolygonBox[CompressedData["
1:eJwtlX1o1WUUx5/dO3d3X37b797dWSCEc9vdfJlOcLM5QedrCxY1ajWyJCn/
iFJyblTYCwQRFRSFNSMIoSKptLe1LILEorJ/qrmpJQTOoGAIBc0sc32+fO8f
D5zznHO+5/U5T8OO3f27EiGEJzmVnCuZEA4nQ3gQ5kJNCG35ENJVIbxaHcLF
dAjPxiGsqPDdcmS5+hC2cF8PfxHbLPxm+E5A09BL0ElJF5sS9JVCCPenQvgB
H/XgL+OuuizfD/btYCxNGiOD/Z3wW9G/jnMG2zfQ6anw3Wn4TDaEBuwPzwvh
bWTN4FXCt6HTAL2Sk61yzC/FxhDWGD7ORehhvwPZduKdTzzX4u8Xcv0evCeg
Q9b+1iE/i/4gd3u5nkHnaDGEVmLcRqyvId9TF8LL+Hgd2xp8/obucs4Eun34
e1g8GB3Q9xHDXbkQbuFuF3ij6OwB72DR+g9h/13eOSm3I5x3oR8oWncdfB6+
F4yNCeczV+OclXsS+0boYeTP4+s5TnOde6ReFTndyN8p4y+Cz5LrPPLpSTsm
xaaclXsvOo3ojmIzjuw4/AHoFzhvlfkXoVdwSgnX+zz2LfBVYL9CzLPgbs65
/urfKXqxKW981TiB/7U1rqV8dEP/i82+4B7vI/eROtfmafSHoRdivwj9ZfDT
+DsZO5ZBdHrAmyjzX3ImoVvqXAv1vAS9Hvuh4J715B2TYuvlbMm5R+rVNuTr
Y8+wZlU5tUJv4O4OZM+AMUetfiWG9grX4Bj8P+DtxH4QvhvdvUX3RjEPFV1z
1X4redZQ+z8iv8UBMFfH9inf8tEDXY1OR8o1SUE/AsZqsN6kvo9CH+CcgP6d
eVij90X8rei3cI4SyxRnc8o1b4r9pvW29UYXk8+HyBci7yKHWXK5nDa23qTe
5oXYb0P1n4Hen3etNWOatRsiz7pmWLP8WcG+VZNPoR/jbj76u4n/P7BniHGk
0m/qK2ynYvdKOSiXjrzfknJQLpohzZLeeBOytdx1plyTr8Hvj71bhsjvJugc
9W0s7wfN+p+R34tqrFp/hE1DyjtoKXhdkW010/eS793c9cLfTPwLwJouuNfC
PA/9CaeE/UF8Ho9cM9VOMX2D7KeCZ0nzXYH9+wXP6jXcfVDwTtJbaYYfh78V
+0boJs7HBR/R2mHtee9IzZ90xpDdlrGtYlAsZznXp5zjqtg7R/3QjmphXqYi
73fVvJ3aJWpDeAr6GHdXZ91T9VZv7ETeO1y7XDs+gr4UWVc2fdhXYP9F0vUM
0OcK3lWq2Y3IH6eHh6rt8xS2/VnP5iHsS7XewdpdivlnbL/N27fmR7tTMcmf
3tAl5LX1fiuaec3+HDpHkp7pSeRXZR2P4lNu2pHalZrpJcRzJrK+/reV8KPl
fb0An5cz3onajZrRvzPOUVjC/Avbe7Kuzxj+B5jdAXRKSc+QZmlD3ljKWbm/
V3CvtVMXgzVdzlc7ULtwGJ2mhDFGoH+M/DZ0NxG5RqqVetgX+c/R36OYPwe7
qt6z14p+W85/tnJTjqrNeOzZXUVMO4ltLu1dLvlp8LZn3DvNSxN8V+xdpZqv
iV0j4al/mp3JyL60M0+qHnlj60/X374x9l+qP24TdGfsXab6zaL/P4xZAdI=

          "]]}]}, 
      {RGBColor[0.76854, 0.5738, 0.36728000000000005`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VltsVFUUPdPO9E7v3BnvvZ0aLdhpQ98PoEADbTCKhvqAEhjEFx9QEKM1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          "]], PolygonBox[CompressedData["
1:eJwtlXto1WUYx99zzs4529k5Z+d3dlak5GbbcpvOeZmow7KMtIuVzjKqP5q3
CANXNhO6/NOVWgWpZYMyQQhqWGlWzmpWEBpRaVJkEJLr5qo/CgZJrfX59j1/
vPA873P/vs/zvFPX9nZviocQ+jkVnEmFEPYnQmjn8jzok7kQpkNvQfYNdDEb
QjKNLmdbMYSeTAhPIBusDOGhEnZRCGvhX0iGMBO6v2D6LOcEus3cxVMhrEGn
CfpozrHk/wj0s/isxHdDLIQv0b+kOoRe6MfR2YF+Bn4p/Dz4q+Df5fTi7xg2
fbUhjBDvgZjv3pMcf63IpqE/BP0ZPqfEXMN2+DZ0kinn3Ao9A/9rkPehfy/8
JPg5yA+Q/9v4frJcT4a7H/B1ouD8boTfjn49ZwJ5DH4E+W/5EPYkjOEssNsW
WfcweJ2L/FVhimwd8V+BXk+8f9A/Tn5bqOck9rfzMLu5+wn9JPHmJ21TAf0a
NdRDv1wVwuq6EC7m7hbkGzkroe/kTXYSawo6vdDriT+X+N34v458NnP607aR
7RDnLeiD2DyF/mjebzON+L9C/02cPcja4G8mnzeI34DvenzsL/pN9DbSuR/7
W9FpR/dhahjHfiE1XpRwTMWO1YTwGLLLsRlD9iY+BpFPhW9DvipvPIbRGYYf
Redg2d+yrHtQvdhFXhH8tch3x90D10B/XXDv6I2+gn4m8tuKXwzWHZHf8kXy
3Uq+DZHfbgD+bvh9RdcWuDtNLXeVnFszOWyGPidyb6fRKRG/u2DsBzCpI/e+
kn31wF+A7nP4q0q7hzQbE1XGdx/+GuFfR96U8Ju2ZO1TvlOcHUX3gHpBPX0I
/qOcefXEH1XuUfXq/28I/XzRvaWYA9A7uZtN7TPg34cf5rSn3aMf5zxDmiVh
3k3+cXqqATpLPrXkclPGtrKR7QfY7Eq4x8aI/yPylxLuWfXuJ+jMR3dI/YPu
COdSfC3RDIL/PbXudb3Zp+CziBidcffAUWzPlN9bPRLoldPcrUp7B+wt2Kd8
d1NvBbEbc+63R9C/Al+h2tjeB/8n+VyY9SwI4wpqS1Q7F+V0KuceUC+ohg/h
/6KmXZXGWFgHbBZVuWbV/m/eseSjAl/HM95defzVUc8cTjZlH/L1dBl/3c1F
FnFyce+kz7FdCF+bMmbCboy7BcjOx/ZMyTtDu0MztDHjGdWsan4X47uZnJbF
vZO1mzVzmhVhKCw1M+KFkbASJsJGOz9G/gsix1IOXdClyLXUk8Mx/HXCt8Zd
w8/wleBxWZXf7Aj5bojc++rB27QLS+4dYRZD9xB3m1KeT+1qzaxmVz1WIp8N
5DBenvclNd5p2m3CQFhohjRL+kMaoa/E/tFyPU3Yf1t0LXrPpcimRf5rtONb
Is+wZlk7Wrt6JjmsSHr/tBeMobC8A/x7sL8+73wOEKOzxjtTu3Ml53vtO/p3
b9o1DUX+o7RvdHc1snmR/x7h9Qux3ynPp3bwZGo9XPTsCdMOfE/OedduJd7v
ec+8Zl9/Yh3y8aJz0x81vdo7WLtYb5AGqy8yfiv1VG1kH/KlGKPIZhc8K+qR
WdBnc65dGHQUXJNq04ytyHpG1dvCeAJfD5b81+tPXBd5J+uthNENyLur/bbC
oAt+MGvsJF+d95tKX/tFf93yrOOrP08VPYN6u+Xk00I+IWNab/odsmSdd6/+
nFZs/wMA+ggU
          "]], 
         PolygonBox[{{2571, 1368, 4154, 3575, 3576}, {3576, 3575, 4143, 1360, 
          2563}}]}]}, 
      {RGBColor[0.8060999999999999, 0.587, 0.34520000000000006`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV1tsVUUUnT5ue++597TnnN4WLRRFA0HEoi1QkCggICgoLyX6AUHQBBIV
TeQliR/SC6ICsS0EKih8oNEE+MDUlkd5BARqVKwYvxBfiUp5CBRaLEXXcm0i
Hyezz5w9e/asvWbNnD5zFkx7Ods5V5nlXA7aTMK5ajxVeH8YbV3cudJ858KU
c0k41kTOPYT+EXjK4LM8LnsWxj4aOndHnnPj0f7uOefDHgy7Ck8lxo5AjLfg
uxLPEfjXxjUH4/fEMwr2i+hvQrsbT4Txq9C+bf5TY4qzDLYP/xokfBdyWI84
I+EzAHZusex+mKs1W+OPox0ZODcT7eq0c/1h78LY075yWGHrnYeY8/FMh10C
nwHwXwr/2SmNZYwp+H4n8pqA93Fo38X7x8jntSLluAdrPZwjP/qUxLVmfrsb
8z2CvvGI18uwm2WYrzAcuO6MrZ35cN4N8LkHcz+B9Wd58s1YzlVohycUj9iw
dsssZrPFyRie/NZo/Zwrq1i1+wdr7IGcUuirR33r8BQiVhp9aV91Z/374ymD
z0589z3ltRjrvQK7F/pnIN4BfBsE+yDaSzGNnQK/7YjzAtpNkfJgrsz/WJEw
aikSLsTnDHyfLVZtXkJu0wqEHzFuR8w2rGmaU62INes1CGPL8b4f8dfFhQsx
aUVunRizLtI85BJ50WxYEJ8t+L7R+MPcmgzDy3nCYbrT+hqNny3Z4tRJp7k4
dqYTD+sT//fVW8yJyPsZxKoDVjfSqleAfK/i2w7aaCsSsokV253WvwR51yO/
laj/D1jLddil3E/mw3HEg7hE8G8DVgtzgSHaeKgYTZ7mZg6jks69j5ib4b86
EB7EhfjujonT5PNlT/WpD8SdJuMPOU3+j8sSN8fmiQdHbL9dg//roeIMxFy1
xoOvEG8v+ltg/wqfgzHl04CxTxcIz+aU8lllNeLemmH5fBiXnpBDrAPrwdrN
NR6Sj4+FtjfR9gaH+oMbZWjHxmQvgt8UT7U6jxjfe9KPowXKm3NeR1vjq+ZL
kXs74q3F2D7wu4r1TEb/RIwbW+hcN/zPImcf83Xg+1zU9otIGkgtZP03Gh8q
Q2G+BvG3wCei5qVUa/KAdWf9WMepsMMsxaSdDOUzJ609xrXvQIw1iHvZ/JP5
4sbzTvpQa7rdaHudvCXPe5r9TqA1rUecP9OKyX08N1SN30xLj3uZ/yn4jYF/
flIawDjk9mn0Pwl7Ukr6PDlf3NhpfCY/iS9xPon4F2NaG3P2Qtl70L8tR7yl
5lYHwmIf+ifDfxJirnSyORfzOB5pjw5HjLVY69WYNKGIegT7G4ztKpBvXlK4
XrkFW+ZBzInfRetnjHaL850nfIgTNYAaQk4Us9awv/W0Np6B5AS50HKLJlB7
qO3nkEMF7J7gVFMovj9epDkvWQ7c3x0273HTQ+rictSgHLjM9qTFzKMEMTZi
7R5w2IC2d6i61iDPXKzzM/jfwJxbY+pn7W6e08zzJ18+P6P9xNcZ+qkvjgfZ
WvNRX/U4hrbbl8be8KXr7GeNasyfdR2C3N5A7ToKdD+g5kfoy0ZOQ5DDhYT6
yozn1XHlQ4zII+ZJLjEH+jMu7x1bLf/R2Gv7EH8M2tsD7edStMWGCc8rahy1
rhOYdfriSxJ98z3pR4knLaHu8P1VT7Xo50nDqH3UEWLDc5bnUG2gHOoC7WPm
Se3gOTk0prU3Bjp/GtB+7YlPIWqyH/Y52AWwtxm+H/nSOGrddGDVN6V9yrNu
rydeck/wHFlnd4OilO5b2fDpDoQD8aAWUBMS8H8Odgb+s9EOSQjfm/eLaqv7
4EJx8ynMO75QXD2A2DmesCJmXeDPUIzvQpwHQ+nrMO4nu98d8MVT7jdydXRM
ukxN3p9STMYuhD0MY7oRp9nTXuaezvW0Z9t8nf/UC2oF71jk1GFfmsn1kw89
ilUTanyV6Sjxp56RH+QGNZc6mQo1P/EhvmfzhD/z7EgKl7/T0gDqJvc7zzae
ce2ecMoYVuftPC9DzM6ENLUC9glPGpGGfdH6D/m6dxAL7nOexWftfrIo0tqJ
Ac8S6sckTxjzbsF38pc2993IpDj6XiisibkrFkfJ1YZQ83Fe5vWlrzPtAmp6
fyA8HwikF9SNvvi+IC08X0lLu6mH1MXcQByOBaoH60JNLQqsrrDPeFoTNYw5
tlueJban1oTa0xV2b+E4nmsVpv+Vdofhud1mPKFuULsCu4vzDtEUyJdxiP+9
Se3J7ki6+0dcWH0QKcZ20ySeU9x75WaTS+RdldWP6+N/AvfpJhs71dP5XGn+
9OHZSUypYbvsnnBfoPOmPND8zOM/nc5STcmfc9bHWg80/x8jcbDV7ogNpg+l
Sd17eP/ZHeqs3mznNe/g3KvE8hfz+Q3ttbRw6UB7KJBGHWZrWhe3e0FounrC
7lWtge63GTv7l4Qayxg8n4kX194V6R/jNnBsgt29+Y+yNlQcxmuzexdz/atA
9yjerT63uxzz5X8UcctJqp7z7B9qYaT9sBjtKeOqQ+7/Am7KyPg=
          "]], 
         PolygonBox[CompressedData["
1:eJwtlltsVlUQhXdpS/vfyn9OTwu2VMQErYpFqdwkCkqJSMtdjTEB8ZaIiaAx
XILGGC8BE4UIiIBR8AFRE/VBg5RLgAgq9QpifAIx0SgUg7WFFtui38r6H3Yy
66zZs2dmz8w+wx9cMnfxgBDCZlYJKxuF0F0UQsTamw7hWD6Eg6Uh7IR7EtxW
GUJ1Od/ZdDgbQgP8LPhV8MXwW+MQbgM/An4b+VAuhGvRHY290/A3oj8H/mmd
B96CTrYshCvhfwKfQf929KeAyzMhXKoI4dNif5vGeSn8uwCXZ+1Gf8qgEPbh
eBv8fvjl2GsfGEIMvwx5N/ptBf9bkUs5fyz4YXBHilj4Noi9w9H/EXs18E3w
y+BP4Msh8G7wDvAi+FbwfPTnob8L+XXO6Cm1jSrO7wc3DbTOQnBLVQirU87Z
EXLXTTzPltj+19j/EP1a4q9j1aM/OrJvb2GzEXkHOnlsjQEP4LwifJhR6pyc
gjuXMrcWvB38eyF/0rkG/TpszMfeNvDlyN+y/x/kDlYevDNybpSjz5C/hz+P
3MWKwWsix64aWIs8nXhWpRyTYlvOt03BOVqB/BXnb8eXlcTYSDxd2BtHrhrx
aRz8uQrHXo/O38gj0G9AnkX8M9EfmPHdKwbFUly4L9XIYPjanGtJNTUUeTw2
Y/I9FP50EsLxtGtJOVPuNsa+W+E3kJ9hdaI/Fv97Oevzwv3qzq4DV7KnDv0M
+glynLWsnK1n79FCP9yD/iT0Kzj/L/BZcA/4IjE9V+L7KQEnefdDA/6NwtbY
rPlP4E8qvoxlfdPePPwEfBvH6iOeOWn3Ujv1swv8DXhokXUuga9Gf3LKNaRa
qlG/wU/iWwn3c1XW8kb2L0H/t7zvWneou1zBt63l9lG+FvPtVrj1fBvB3j3E
dzhYvxnu8cSc7rQTX+bh8xHy8zL8DPgnEp+1gD3n+RaqLE9ELkLuSdy7jeCL
yC2yAf8ne3aCOypcO6qhs5oH4KUF/CWx/ZpzbpUv5bIm416chg8PRd4j3VHk
40DsGpQ91dsw9t7PGS9y1hjO7864hlRLOqO9wjWv2r/A+gFbq8nJllL3+DHw
uzn3Whf33cf+NXn3ag78R9o9pd7qZH0HDmnXu+64Ht074IehOxWf3wOvy7s3
31F95X3nuvvxrEFZz0D1w0zi+YV4FsGvKXePVmKrJWtOM/h69teC4zLfZyW4
WTOowI8EDwHnytxTJeDHsLcWe93gKuwtBL9U7hwpV0+h/wr6U/F5JXwz8cwK
1nkAfgH8IvhHWb2xe1i9rBl/A/ZP8W02+BDx9+f8Bqh/5eM2uP7EsWpGzYZb
Vci3emo/eEiVbWvGDEaeEPntaGXPfeCPY89O1bxq/2Dsu9edVmNrf+ze05ln
0q5h1bJ6YG/kO9BdXEF8d4IHwN+S8gzQLPgvce3qWyWxfcC3dcXOoXIpH+SL
ZtDNkXtAvaCemUs9TYtsWzlQLqo1Twr512y7lHNulEPlchM66TKf8T5cb+JZ
pR5ZB74Lm8eDe+5u5L6832K9gf3IE7OetaqxL7C1Ie/a2sB9LcZWDf70ldoH
+fJR7NmpGaJZsiftt19vbAbd5xP3lmb0C8hR5NpWDaoWD2T99vazmniLk8i9
o5pSbb0WeVaqhlRL+9J+m/WPkYs8A9UbehPHZN2j6lW9wZfh+02Re0szSrNK
M1yzXDnaHHvmavbqzV8ae4ZolqiGVoD/TdzrmpmanZqhmqXq2Tdj97B6WW+C
3obplX4P7wU3I0/OWNbM1+yvK/inmaJZpZwqt5qZmp1H0+4lna/Z8WphPijn
P8ONzLiX9Obo7elOPAvVUxfgTsbuVfX8CeT/AUqKNcg=
          "]]}]}, 
      {RGBColor[0.84366, 0.6002, 0.32312], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV2lsFVUUni6vrzNv3nsz03m0UHbjjyIJoogmxg0wgiCyaWIkgsaYGBSD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          "]], PolygonBox[CompressedData["
1:eJwtlllslFUYhk9Lp+1MZ9qZ6V9K2USMJkWMGy7RaCKgSMTIZqKRCwRjYkSM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          "]]}]}, 
      {RGBColor[0.88122, 0.6134, 0.30104000000000003`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH1s1lcVx2/f+3te+rz0eda1nRtlLEKJszBC1AQi0vmSCJNiwZdEjcEs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          "]], PolygonBox[CompressedData["
1:eJwtlUts1GUUxT/svF/MTKeWabEyqAnURKEhBhcStUVhgdCprdGFGENi1Ihh
qUDjI74aEqkbJGi04obauDAx1p0vMNGYUjVGhUpbSqnBtlgoJqU+fsfTxc3c
+7/3nu++p/Lo09Xd14QQ9kMR6GIphJuSIRTg96RDuBX54UQIj0CzmRC21oXw
Ivpt6P/gdwtyN7/rkH/jtxX5QWw3I98NP4l/I983SQ/eC/kQDkVDOAMdToXQ
js0b6CPL+Ia+E/u9+CeQB9D35UK4i8B+jIUwjn4C/bXYt4B3Fv4l8A6DNQF9
iH0SmzZ8W0hqM0m0F411FqrCf4LP7+Afwf455DPIRfDWKz74HcRzIOkY16Bf
X3LuP4B3gvyfRO5F3og+ztsR3hiFH4c+4P1NyoFYK2BMYztWMrZiHod/tWjf
Lr69Aj+3PIS1yJ3Ik9gMI69AbkPuzYbwDvlPEPsQdBzsvfjMol9AXkAeRL8I
PwWdQz5dci+U0wj8Beh6+CfivJN2TIqtB/kO5AHeKJHbjfj/TPzz8k+6B6Po
v0F/C/oN6KfR35tyb8+j/xjbbSnnopqqtl3QvoQxhDUL3QA/wHs7wIsXXCvZ
yHYnNd2O/j6oTO2bsWmNOWbFfr7kWWtAnoIfoj71UdfopGpFD1rh14HfAtYC
9eivoebEvBH5WXz6EraR7aqsc1FOFfgy8VyNuqfqbWfRs6SajxFLBZ8tUeOt
gr+a9ywMQwvw+7G/GHUP/sb+BJjv1/hNva0ZUb/zxFcmng7q9Rj51ONfj+2n
OfdS/ZvEfw821aRr8Ayx5ZAblnnntHtt+G8InlHN6vxSvv/3CNvnoQeSnsGD
+C8W3XvVWLVeXeve6w29tbXWvZGPfF8n3jXKhZhX4n8K/EM1npEG9NPYHSC3
Jr5tT3mntdvaYe3yVxnX5jswvwa7sWAs+ch3JO1d7166Hf1F90Y1OQb/D/or
Me/En/T3rbx3+TZ8jsC/mTH2U9gMgl1f8O5on1fAn855livENwL/LfbL4U9y
QzrAu4KcQd5FPJfhowXfEu1wDH5K9UfXDl1H/9rTfkszrFn+jJxnor45LxNP
NeW3Hgf/V92qOvuqR3fCf1H0bGrmZrA9V/Is6yYOIs8hN8PfDB1NG1PY2vHP
0b+Hf23c81KH7u2iZ0k5/iK8pG+FYtoF1lzKtVqpmhW8o9pVYXbh21jnXati
0wB/e8azrRk6jr6ctu4evi0yn00Zv62ZPlp0zVS7ndpxsGcy5vUfof8K3Sjd
KtWwqeSbrdutndXudoDxfcw3/d2cb7Jus77dD/9R1vOmnPuQi1nPmnZAu6Ad
0a5oRrrR9+cdq27+sbxvmGrzL/oe9JGMee1gDH1v3rXRjB+E78l7dnQDfsL3
tSVZO/1lyjdCu7WPeC/n3GP1WjEq1gvgP5Twf97akm+w4tO35pJnTrOnmZvH
dirreuumrOatS3wbinhG/4IfBX/3Ev4p3r+U89vqz3DWN0P9kM0Yugo+5bh3
qD7vG61Z07cB8v8PtEQKDw==
          "]], 
         PolygonBox[{{3559, 3558, 4130, 1352, 2554}, {2562, 1358, 4139, 3558, 
          3559}}]}]}, 
      {RGBColor[0.903, 0.6275, 0.2993], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVVtoVFcUPc6MY+bOvXemNzcNiq9YSxKNFlHBRym2ttWfUmvRCi0KIoFq
oiYfaisBCYhG8EPEVlvaQkVjVdSPJJNKUaiJpXFSaCUiBrQSfCM+UIMlAddy
7eLH4ey7zz77sfY6+1as3rB0fcI514WVxHqOj1IIsyFXZpxrzUhfjb0Kq9T0
lCPIP2d1NpiQrtJsuqB/C3JxhHNTYPhr2rmp2I+YT97l4p1HsXOflemMOp5T
/gZ3UxaPOUzjORSTIf8HeQv2W4Fz3bg0c5Rzc33n1kE/qcS5Zzgbm3fug5Go
CbqvLTf6WwX7Kugf5BSLcej/Gb4d6kjCzwTcXQSbLtiew5oNm4eeczex96GW
DPbh15TPV6i1PZZ+kSc72t8JnXsdPs6a/axI8h+wb8T6Frq/fGFErFhXOer4
DsmMRh5rsPfibMgpF9ZIvzvgZxh+dmI/hVhbYLcC8hXIb+K8iLhXE8LgLlZD
VjU+jJVPU4n6uz7Q/gPs3wP+m5HDQuxzsOohv439TFp3aHfNU26dgfKZMUo9
OJ+V3Uzk8Aa+OyBXQv4TdodhHwLLi+aHONRk1EvWOz2j7++hv+/Jvgf3DsJn
AbrHyLkB5x1YG41n1caxp2n1sQx2tagBpm4ucp4O3d6kerkJtrVJ8boN8m8Z
2fXju4i121PdxHAooZiMQf8OvXmOGM2oZUFKPoiDn1d/JuJ8ICGs98DPdeQw
CX7KA3GC3KiD7npW9S+Dn3ReeaV85cC77BH7T9yIyQXLje9yCeopQP++Jy5Q
Jh8OeNqb8+oV66rLiNPE5ItIPvrN/2VPmBxHbu0Wi71i3ZfS4nXRbBmXmHWm
FXNFrPNm3O1FPftwdjIQTsSLvWJv2gzbOpN5Rj3jMdaCMvXjXeyBYUgse1Ka
OcSXvN5uvWuzntMP8203nvTaOyf2p+19ELd24wltOiwu7x/KimdPkNzfvnIk
X+YZz8n3VpsPnD9LU+LCh9YLvh2+IfZqwN4V5wnfL3lyPBJvyd9jkd4I30qY
1H3i2e2prv3A7YSnd7AdtQ9nxeOmSBy6aj1jvTX2RhqsDub9P6bEc3mkmcPZ
UxWJG+QLOc1eMvb8MuXJebMNNoOwKcD+Hegb4ecfX1g1GG7cG03+3dPbWol7
O3PCuhV+sL2csX0o/kZWeHUCz602Zzlj2RPONeZPHhWMS4zNHD6C7x9D9X3Y
F2cKhuc5i9uS13znjElAVwjVk8WQx8d6k92I/2WgWbkrp2/qfwr1dhmLvogF
+8FesofkD/tI7vcZ/y/mtJPvfEMtJYpXY++FmBy2HJhLuXG4wlcNrGXI19zn
nH6APHdFend8fy2GIbGsjsWxe7BvicQNcmQWvpuQ/9NQ8+O0Ycge1tnc+zxS
Dsxlov2nKvKaAW02B36J9C85Gklfb/wpjng1P8Yg1lrE6A+FS5DUf5A7sSJv
+d+utf9QvflmLgPZV5jxf0LMORvHwWc95Guhds5D/pMqjRulNnMu2Buj7x6b
rTzfav7Zz00livtxLPkSzu5kNN8Hc8oxsJ7yP0H+8F1MicVJcrPf/on/hsKS
fln/uFgxbxsG+yxPzm7m/CnufZJTnktymne0ORGIF/TPHrwAUyM6Bg==
          "]], 
         PolygonBox[CompressedData["
1:eJwtlGtoz2EUxw+bXf63zW+3XMamZJtbYmluuc8bucUUIaEwEy9mpYVFzFu5
NKHkPsYrGy/IPeO/QrywckmJvDCXjWmLz9f5v/j1O+c55znf77k9hWu3Lq7q
a2Zr+JL5puSYbUk3O9rHbDJyRWD2KsWsJslsb9SsM2ZWi2Mp9m8hszrOPiKn
811BnxgxG5dqVt7PbGimWYzvHHcHABJFvkS8vFTX89D/hs1+E/8X3y5sewLX
93HnKLHfgTec2MPQ3yMvCblcCYc36D+yzUbBdwzfWWLND3ksxVCsejBy+vjZ
bvQWYjYk7g+G62X0Q+hl8E3D92vIc1OOXcSfQQ2qid0N33ywCiLOXTEaibc8
8NqoBh/AP4DeC5bhk0K8Cu7UppnlEr8tAxzuj0/UpwD7KTCmJ7uPfMVJ3JRj
btRzlC68ZvR29E3JXpN2uM7jmwtcj/Cwn4fDTWwBPr39vSfqzW04TYBbD/Gz
iNWKfQF89mW6/SX2ZdgPcrYuyWPUI5eT/850n407/L9EHGsxByXwPRb1Xqne
6mVjop5jyO8z/o/Cjq3848RLjnht5HNQs4VPdZpjbuTuSM5u4B8H/yr+J8i3
1JzzSeTykHPVTGo2vyX6pZo+QP8U8V6ppkOyfabU+271BFsHZ0fwvwBuBbl1
85/Tz2f0MfgdYBahd+LfG/aeifsL9Pdhr7Hyf0L8RRk+M5qdw9y/hq0p6rLO
vhO7AX4bkjynEvEFv4jzYr7TxKuMea9Go59BX5jhsTVT17jbGnVu4jgIrKWB
c1HPmkK+k/Ldwf2ZOV4z1U41XQDWqsDnXzmtDpyj+GmGBkZ8xjRrW9Dz0Qsz
fTZrKNcfYt4PXFeN7yEXa4dSPKfN3F0PRn2ax1ftkhL91UzU4zsrx7mpZsXa
hcBrK0734P80sd/iFEdui/jbo5nT7FVTk+Po29GnobfEfPaEKeznEbdt45uK
/W3Mc1HM1yGfOfXvFpgPw/6miJt2dH/gNVft9YboLfmZ7W+JMIVdmNh39eAy
/mVg4PL/jZyEXBf4bCmfuyHnIC7yeaZdDxxbM1wF9srAa6WdXRH4jGhWtA/a
nRGcXcd/rGof9h3VrqremqXmxPulN/Ri4D2QTW/UdLBnyyfFe6Re1dHPHvOz
Iu1Chu+metSF/DKL/lPLzdyPw/cfuzPMNw==
          "]], 
         PolygonBox[{{3830, 1149, 3124, 3533, 3534}, {3534, 3533, 4123, 1349, 
          4124}}]}]}, 
      {RGBColor[0.909, 0.6425000000000001, 0.3179], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VVlsTVEU3e17fe279917X6+2KjGGStQYhKjpA+GP+kGMkUgUqRjSLyFp
JQ0JX4bG9GOqiOmvhkQMIURblVBjJGiFn4pKRSnWso6Pl7PfOXuvvffawx22
dvPi6lwzO4lfAr/hBWYfcdGQY3YpMkvlmY2OzT6lzZbg/Xxg9tXJFyH/gE4u
9CPIu6D3G3Z/fLMxkK+lzCbgfJox2wab2cXAAl5dQnotsGmE3BOaDcJ9LeTP
uN8M3XTSrAO4Q7LAwDkVGFOBdRuYD4F/D7826DbD/yHYVcC+BHrrILfgvs+E
R3/0dRq2MyD7Wf0oN+JuPGOG7jEPPrPC6Yb/mXnSWY+3j7AvBZaH8z38tiOG
pbCbmG92LqH4ymP5PAIcH7FXpxU/YyQPU0w5fcAdYO0BcG7xHnavcM5LKvcw
Kf5BlQ3IU770W1EszGk4K5OKh3FVuXyZQy44+gn93cAchTo25QjnKs4u2JzA
eSNHNS0zcZWfJ/vLkeR2+HgaCXtZkdmXpGypT+yx5BlvJYH4Hgifp3z52hTq
P++b8P4urbq+AF6QFachzrueMK6x7k6feM3Q74av/ZF4JJ8LId9xXN+NFQvz
YTwLi5QL+5T9xz5MAa8q0Psz4B0M1G8HAvUB5RLHA/Onj391SqrnyfnOAtVr
Nfy9Qc6rYvUSZdZoYFZ9y/4lR+SqDvIHXzL5a8uojjNRgOeR7D7hPRWodgs8
+alJyFdnoVk98LdDZ0ugu7HwW+jyZe3YL4yPb+1OZm9ML9bMzMB52tWiG3Ht
iVS/vZHyIz5zrI+EOQc6t9LqyfmwHedmlrPLuNi79NU/Kb7K3Jyw1/aHqhU5
5Fub60W+XfYU1yL4meywLri56HC7hXUl978yiq3DzcVw/N+K/52h+OM++t/D
/V0fMsY21/NngD8S8htPM8TZYA3O+LJhruzZ3pR21mPglwHzeT/sqUJh7oDu
rGLNXg3kuUXifQNiGJzVjLcGyoG51EJ+EGg3/EiLO3LYAuyXnvbRW9i2hort
Ne4qI9Wd9V8ZK9YW+GqGzhrIj0LF+Tul/twXiddzvjgY4XhocjuCMu2Jswx4
e2LZJjLav+z1Bvha7vbLili50fYb8quLxUkO9KsD1W5SLC7IyS9wYxnhcK+T
C3KyMdTM3XA7lvFw17A/WUPuONbxtqeZqYVteYFsqdPeT7m0ZjSrnNljgb4P
o1yOjGV2UnuJfcY6H/VUY/JJXk+E0jkeak+X5uuN++FwSr44e+yhJ/DTV6j7
s76+Geyf+5B7XH98x7muQL3I+Nkj5L3BzRLz5J4jnu92BeMtd7nzu8j+4reR
3zPuhy7EeyVQP/RG6iH20uNAPU4d9tD1UHvpoNNlP5CXm67HToHD87FyHIpc
/gLiwAlf
          "]], PolygonBox[CompressedData["
1:eJwtlVlIlWEQhkezU+ec/5yjf2oF2UIZZFTSYntdVNBdC0FFK4WVFUoZQTdd
aFAGdVOUYHmVlgQtELRCtFPYYtFuCGWJ3Si0kaX1vIwXH8z3z/bOvDPfP2JD
2dLSdDPbyMngtMTMRqeZDepndjY0+xY1m9HX7Fgfs4sJs4a42Q30AzH+l2V2
iW+56W4TzTR7mzLLQ/6KzRvkDuKdwXcX9u1Js2ucXHSVfLuO3Eb8sdhXcD9C
rK2cYuRv2D9GNzxwLLOwCYi/mJgx4cNmCfIrbPLBHUG/KNtsO/5P0PfjfgH9
E/xbwRcl3k6wfyHnTuQt+NxM+DfpyogzM8fsddR9hUFYNmPPZxvVH90As1Oh
+wpPHfJdzkTwFZJjWKbXqFob8O+k9knoS5CbwHSfXCvAuJdYg/F/Ab5N2Mex
b8O/CaxXevspDsRFNfeeNO/ZPe7NYBiDfzk4X2L/PHDfJDHmAPQ0OY5H6Dv3
A8R/Gjj2kZxX+G4jXxa6At3RtcedqwV8WwPWZfg0IRejnwLWE+RPJ/5yaq5B
PpxybjQDh5APcjoznIMS9LNyvJef8ZmW4z7y7QJTJfHn5jh29VS9TQtcN45+
/Eg5JmFTjap1YayXa3Jcxn475wq5azl7wL4ydOxt3Fu5jw19FrqJX4C8mvM+
4jV2EP9B3LnYTczJofdIvVINVcjPU87NLXweYluRcFtxJu7EgbjoQV8VekzF
/sB9HfdnCedeMzCKWs711q8enkdeG7qt5v12zGdaszSbk0Begf51xGf8Qsx3
QrbaqY/0rSXpu6gZySP++Zjb3sZnKr7dgc//XPLXYvso7jrVpNoKsbnGvQdM
E5DzMn12hXkocp/AaxMfP7H/m+W7fpWY9cSal+2yZmg+8j5i/Il4T+7GnCNx
JU7qkd/AYT69q0ZfHvcZ1Czq2zNyVSacO9WgWopC730R+HagGxe6LMzjQ++h
erle70PScyiXOF6F/nu274JmpI580xm00qjvmHZNM6nZ1LcZyI1Jj6WeviP/
r5TXLs7aselKuU45f6d8Z9VLcfSJ+DUx76V6rrdHnIt7vXmN3P8GPovSi5tk
pnOtN+ShuA2dX+24oT8T+jxo/+uRjyb8rdQbqbdSb4q40ptzB/3vqMdSviHE
3gWm/RHfYe2ydkS7ojehO8t3TPWJs/TAORE38vmC/mTSZ0dvVim5m3v/B5o3
vfWqSbn0ho7E/z9IAtrS
          "]]}]}, 
      {RGBColor[0.915, 0.6575, 0.3365], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VEtsjGEUvX1NZ+aff6b9ZzRSpai0NrQk1aWF11akCyQWmqhH6xWSLixE
vAXxinguSjUkEoRYmGJjoeLRtNpOq4iqPkIsiAVpcE7P18Xk3u/O/c4999z7
/bPqtq/alm1mh/HLwe98yOx7rllzltnphNkT2Nue2VPf7CoShuNmn6LyB+H3
J80qwmZdMbMe+MMAexOT7QTOJdwfQHwM5x7EzzhMYjcDczVqPgfOM2AeAOaB
wKwBdgnudiHvvK/4R+Sncf7huLV64jpeaFYfVi0c7S1qzMX5HWqOIqcfwbXA
XJbS/R2oNR/nNOLzYB8A/wLwB1B/Hc4DiI954lsOnCJgluFucR6wwaHdE69O
+I9D4tqBcxv8Tc5fEOi/hYF4UQtyG8LdDJw1iIfBcz3+ew0+74H1Dfe+4v/K
QFhVsE05qlVj6ol8qOcr5HXDzgYv3+EzPhIxW4Hcc+jpWlz3lqGvO1Fh7Ud8
BHodAX6Tp37Y10zgDLq7Z33NvyosnalfSZ7qfXA8yZd9FLs451Obq//ScfmP
YE8kNK+TsB0418GPoO/SlLidimsnqHUD/FL4U+G3+dKNPNlXPfKPgc8oOG71
pfPZhOoy/g85O33NYhF06wVOJeJD2IGWuHbpOmwmoV76YGcUmC2HPx32PvTZ
g7tHgfEZeZvBrRaxaIH4PHS7vws403CeE5PtQHw0rvgIbJmLv0S8GrGNOdp1
zq3C7VKjr/jlqLS5GJLO99xb+BmRHr57Ozc97e1xcO5NKr4xrhltd5h7w5ov
NeVOcZ+Jxb2IunfBWTGvxs2Ys+a+HHfvavJ9lCC/nHcLdXcX6te4XeQetcIv
ygcv2OyYtP8FjMvAPIycK7605C6wxoZAZ2r8KiLsLcjpCynOnKUp9bIENjsQ
h32e7IR+pnmyZ/bLGDVkfH+guqzfDl1K4MfhRwqkA983+ZFnFvkWSvNbnvRP
O3zuHGfNmd9NCL/R7RS/FXzXX5J6F5mYZjy5C/wW8J2+AGaH+/bxWzgeEjfW
nuznb6H2nnPgGz0YKO9QIL0vZmle3PFq139VnvriTLm//Ebx3XW7t8Pva21C
d3d7utsUFueJfQ9JZ86SNTJJzYB990a0T9yrxVO051PypcWNQH4L7O+EePxJ
SF/y8X3t9pj7/lSnxIFcVqbEIQP8/w4z5XY=
          "]], PolygonBox[CompressedData["
1:eJwtlElI1XEQx8eX2tv+vXw9JUuyEqpDpQXpsYMt1wiDFCISskXKosKDQQdN
K8hDi7TYIbIy6NACHbLlEpRFKZn4NCkKc6HoUF2KsD5f5h3+MPObme9s3/kv
qm3YvD9kZjV82XyjUbMLM8xqUfpmme3lK+C9IWy2LmX2MmY2kGXWiE9F0uwz
9ivIcwEpjpu9QN+KfxFvvchB4PJ28F6hv59jtgysS2AcAWsYfUnY394R/yth
9g/bKfQ68j2nnjbi/+aaHSdfGv8oWOPk68f/NhhP8C/iLYT9ADl60K/yNWEb
w7807D3swdYG/nd8O8C7gX0IvSjHbAR9En0QfR56Gn0MvYr8e4idT75CevkZ
8f40o8hss5O8NSEP4z+B/2TEa2/hrQPbeuIrzGc2Tb3Ngc/uGD7V9FeZ8tmq
JtU2nee9qIdu8LLiPg/NoJn+Fqa8PmEWI3fzVjDT5x+jnmv0WEl8Pf5XyN0X
eP0biFmAvTXpsxSmZt2O/xr8d+PfGfUaVaswurC90UzQR4nZRmwZ3yPkft6W
I0fizhXN4z65VvP2OGO/B/4K9J5cr+cg9vKky8rRG3MM+cpnJfKDwHtRTzfR
u/jyZzrHnmKrp6apkO9T3LwFxkVif1DD6YRzStw6oX0wy795vmvx4Si2CWIO
ZTvep6i/ySaMf/ieTfgsxKkzyB8Tvstv6B+QG2OO/RaMLeg1SeeOZvQa29p8
OJ/tNQ7GfSfqRz1cx3dxyn21wxLk/sC5pR1pV+KQuCROipvKoVx1cKQc/6mY
70L2NLbqpHNVmNqVOCVuCV9cHqCGpWG/Md3aYc0rK3ND9Ps15r2JwzuTfiOa
rWJG8E8TX5bhZyt4nYFzUfeci+0c+kZzjPPIb4jfke03cjXwG9R8hfEFvPaE
72oJ9tfcynDm/oTxGb0l6fMWP0PgD0XcdxdvdxLOUe1HHCxNOsfEn0bwN6W8
BtVSpRuilvHM/0kzLgHv4Sy3KcezqP+T1It60r9GPUnXPysB1uWo59aN6FYK
M/sShybR0xHPrZr2BX5z4rduYBX1/aG+shyfx13sfXH/d4kjQ3N8ppqt/lFD
cb8h3ZJmGI57DapFGL/x/Q+OVcz2
          "]], 
         PolygonBox[{{2782, 2781, 3791, 1122, 3792}, {4775, 1814, 4774, 2781, 
          2782}}]}]}, 
      {RGBColor[0.921, 0.6725, 0.35509999999999997`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVE1LVFEYfscZp5m5d67OnUsmLUZz4aI2fbqPgpZl2SIIyihIsJlNFETL
hGrTB0T5QVhC0RdYEdkfSIsiStKs1AllRgaKoCJaaM/DcxaX8973POc578fz
ntbuYueJOjM7iy+Ob3dklqo3e9xgdtIz8xNmn/Nm3aGZF4M/Y9YJTA/AxaxZ
FYc/ADOEPR/ndsD+B9/zBq1LvtkT8HTAvxUcw0nxt5vWW/hfgd2YEBd5irAH
wN8Oe29KZ8k1lBH2dmA2GQgzhhiOIZ4N4PqFO//iiwHbD/9T2O/BsQf7H2Gv
BaacFo74vlDx0r8E3M2szpLjC74C/EeAmYXdAnsO60xaeY7BnnYxvMiqFqxJ
CeunvKsLcq8Bvxn4FeCrnu6Zgn3aU67VnNk53NEE+yXyq+BsE3Isgns7Yovi
yqEG/xbUYgack774ec8Z8KwGrgT88UB1XIC/C3cM4twp10Paq0zn+E+7kpPN
Ps9nVO8pcMzCvoF77yCuxaRqtcuUB/0JcJQdvgJ8a6Qesc9rkH8bMIvw14Bb
n1I+SznpZH+DfDXX64v4/8neI+YpX/4++C7j7jiCvIR1Pi8sazYSqCbL1FVW
saRZj0D3NsN3Ia6z3GNcrCNrOOz23gL7xlPvD4TSOrW4CXZvVtqcRt8mMsK/
Av4+8AOoRQyYiuvjeWCP4r8Mfw2+a1nVqYqzBn8//Pfgfx2ov1nsX08q35GY
uA8mpLm7nvaWc7rnt8OMBuI8BL6HgWZwNKN98jNW8pVcnQ+H0i31uzHUvHBu
3gXqHXvL+rLO067ejW5+C5HmrSUSH3VFzh6nQXJRE+R5hlwmAsU/jnXcE4Yz
x7p2pTSzM3nxU5vNThv7EMNiXvzUL98U5sX8OBusLWtc8PUWfAuU72BSNaGG
qKWOSHNZcPrkyl6Qi5qtJFX33lD2D3DWheJ54OaG+TPHR57epjT2v+al0TLW
755moAf+hUCa56zMOQyxVxDPH3BddXFxxjhffBf4PvCt2hZpBruc3jnLzCXl
S6fUMjmYJ3vaFqmG6yK9kewB61/vSy98q/hGMPbZvOaBc7Ezo3eEeVN37Enk
zv4Hc2DUrg==
          "]], PolygonBox[CompressedData["
1:eJwtlEtI1FEUxs+MM9OMM/P/6zhk0MLXwkVtetGiXSS0LKtNEJSRC8Gcndta
JPRYjAVRagvNICoKiSKhVYvQoIiUFCPNUhwZKKLHooX2+zj/xYVzz+O73/nu
ubelq6/zfNzMjrISrItZs/GY2UjKLF4wy+fNGtnHSAqwHxAfIvaH5HJoNlFr
liW+zhog/oT4GPF0khjxcmC2n9xjabOmolk3Oe3mGAb+coPZDmJ3qP+CfRLf
oYTjVcBaxNdonrOEvQRmM9iH8d0E6yVruMasj5qmnNlZ6puSzqkLe4C1M+k9
XMLepH4P+wT9bGBPwe8UtVfAGAVrMsI7QM7vDLrA+QO1Pfg6sZ8Rv13jGFXi
g6Fr8Zd1PfSe1fso/T2Gf3PRe//HebPEYnAYTrnGF4jfCL1WmvSCfTnvvYv/
U7QtwW8r8RIYHWBVMt67eupmP0/P1bjnrKLPCqsu4b45YqcLni9NzmB/DVyr
dvCXwZ/P+NnifAS8Sfjkks73BfZGvdmtiK9m4zg1bfRfAuMbWG8C107zkeS8
u+w3wSviG8euwOdnwu9wrcE1EPYJ+mnjvH0Fnw9pPAX+WuDcdEYFu0y8Zouf
Mc3Z10LHE6f75LcWHUsz8zbrd6q7Vc0gtauBYwlzBbs159zl24bWHbXO9SC+
MeJz0fmagXnsTM7xdOfv2fcIM+WaTrB/Hs2D5qW2Dk3Rc3vS+dxT//U+2zOa
6XrPUa7wNbuaMe2Fodma4bxK3O9wAb2G8q6t5vc1XD/hyyU8Z5bcd5H+4phm
v8Dam3aNroY+Y7o7+aoN3qN6leZ6m+IorrrzBbj0kz8S8zPW4Ftlv5zy+fkM
3u6Cz4rueBf2r9BnUZp8z/qMlqLzdVfl6H1o5h8S/6E7TnmNatWTepOvF7xS
3t+a/hD9JZmCvyXNqP6Ogeh9SOOPob8RvRVxPKdZKrrWXL+9yvifJf30xqcD
70G96A9ZxF7P+TxKjxZqH2X97xNnve3/jY+yCw==
          "]]}]}, 
      {RGBColor[0.927, 0.6875, 0.3737], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlM1LVWEQxse8Xr0d7zl27hEs21ibFtXCiOw/aNMiaVNCpGVK3636oEUr
MywyqE1krdokFBZBLgy7StgHQUQZBppp5fWSLXIV9PEbnrN4eefOmXnmmeed
uU0dJ1qPrzCzTk4l50vBbHON2Rz3ImcLdom7PzIbqTC7F5hVxWYDWeK56zOK
+QFIOWe2B4zHebNN+CK+LeIvrTK7RPwC94uVZg3g9JMbVJntJq5YISzHrObu
i4Q3VWt2n3qjfB/Ct4hdxv6EPUWtFmrdDc3Gs8JynGZuqxaPB2nuSfh8p4dm
ai1wjxKfS+PnwFmPPQ9mX6zcaur+jYT1LxKGc9vA50eRclcn1Od0gzkGRl2d
2S0EHKGWgdOOfQj7LRx2oMMgPAsZaXIHvPf4d2IfJHYi1eQZMUWwusDcBnYD
+WvQYR18hkLFHyZ+HvsU9tdQfY9lpUVDIo7n8bfE8r+izgz3uUppVwXWPnJf
htLO82Zz8vVWiodjey9euynRG5XImwik3Vawj3F6iHkO98FAs+EzksX/G8wb
+F8Hepvtsfr2GfDe2xLxuUh/t/OqO8DdwzmLPUTuR7h1kTMZSj/3O1d/C9fW
a9TCqZNv70LVc99p7CXqLhH3K9Jx+2eg9/d59dlyjVyrDNzKzEQj/gvEtPN7
Gp77Y+n9Lav8a7HmwediMqN4xymG4u99eG3ncB0uTyK9zXCkPr3f3rzyljPS
qyPW2xxI92hjjfZlpiB7mvtoLA5HuK9Gyn2Tk+6u/828eDtuRayZc31ysfa4
Pt1B30nfiWVyx3PqoQ28tYnm2efa98Axvd+HgfajMZEOrkk53QN/A+/zcqx5
8fn1ufeZeZrWH0ljWsk/A49difbWMfZify7oP2K2oN12TN/XD5He2mfBeXmu
v9OfdB+vxOrBexnOa666U93+AzZtrfQ=
          "]], PolygonBox[CompressedData["
1:eJwtlMtLVVEUxtete69er+ccO+cElk2kiYMeYET2H0QQkURRQpQZSmkWTsx5
YVhU0KRIHDRLCrSgHBRmDnoR9BSkfKQ9VLJJgwiifh/rDjZnrb3W/tb3rb32
qW3ubDy5wsx2s7KszsCsjm93uVljalaIzY6sNBvNmN0pms1HZutzZsv4c9jX
yT9HfDN7v/Ef4d/AbwUsqDT7lJgtUmADeNPYc6xN5b63n/wFcvbiFzn/AP8u
NcYyvldL/anEz64GrzM0e8s6hn0AjjepdYv8hxnnaHDdkzr3Anj3wBskfwf5
DYS7yP+Cfxp/LfWr8Z/jH8KvBuNZhVkGjJqsYw6CfSpw7XWl3lwkXp/z/AvY
B6nxA6wt0gTXj/hLxKbycFI8db8Hfk3Yh2OP7aLGELUXEj8rfT3U+xc5vvQt
Fcy+rzI7T35EvLvomqRtlL2n+BOh91o9n4H/UfCn815TXLSnmDTPk3s89tq6
v2XON5EzkXUN0pKNXWs/GDnsbXBuhd8A+fsiX7LFaQFuUZX3UjWqsHsD17oT
zDfg16R+n+K8LnWN0qoZ+Jy4JmnbiD+DP1npXHQHS/htoccTVgf2bOK5mh/N
VktJj/QugtUV+llpGqd/P4uuVTPaQe5V+vHH/H5b4Dpb8Nk4Q/xD5DMmfvXU
+JZ4jnJ/sXeJ+KuC26qhWsMVrlc9bwZ/O2s875qHqT0S+WyrxiRnr5Xei97Q
HH5Z7L0Wpzz27dB7J0xh642J/1dy2om/APNJ3jHvRz7TwtZeQ+xvSr1pg38D
/d4a+6yIj97W2cC16k28FlbBc9Vj9fpx6LPdS85Y6DVUS5peFv1OxU8Ywhqq
cFt74j4Q+Fm9qRx32V/y9X9Y1Dwn3lvdcR/YI4HPut70O86XccbK/A38JX45
dj7yr2CvSX2WNKPVqf8DdF5n+mL/B6mWaoqLaspXz9X7E7H3UjPzHi3/ASFM
r3s=
          "]], 
         PolygonBox[{{3085, 1127, 3800, 3514, 3515}, {3515, 3514, 3796, 1125, 
          3084}}]}]}, 
      {RGBColor[0.933, 0.7025, 0.3923], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVE1LVGEUPjNe58M7995pvIFZhElSv0Acg5aFG4laVOMiE1PBNMJNtamN
0IflphYG1VALw2jTpkVQ9LUqIms0plU4kThMEK0iinqenjdcvJxzz3s+nvOc
895tQyf2TybNbBynCedTymxrs1k1YbbSalaGPOObTYZmsWd2EnIMJwPf51mz
O4HZDALfw1aGfgH6WmTWAd8j0OcRfxbx7fj+gnwTLvZfDvh/w/133PfhfiP8
P+C7kZR/G/zaY7Mu6Bfh09gg+/98zE2fj5Ewd8H3GvQnsO+BPhYLD3HN4fTB
tw7MlwrCTOxt8OkHoE2Qj/CdQu0gZ3bfVx7mK+Eso94AZA9iJxA7FQjXzZT8
mgvSPcjZSL0Pw2cAec8hfwlyDvYfyL+aE6fkdg2cTAfq+x1svbF4Jt+3E9Lp
9yKrXqdgP44anei3FokD1uIdeVt2/nuRZxD2Y8h9APppYKgix85YXJGzoy5+
EPJuKP4t0D0xF009MP/VFrNkWrw1JYWt4mmW1ZxqH450P+KJxxHgXAEnDfT1
FrV/wn4dPou++mXf5JKz53e9VfjJN2fAHI8D1WG9ssNKzNO+doIzyBQ0D+a6
hz66PfVbgd/DSPKVL+7I05useCE/Q7h/4Cum6HglZu7Kkq93MA77qUB8zIea
E/Geh217LDvvf0fiJp3TbJjrM+QvZx+Fby2r3NxH7h3xcydSqHELddNOEhv3
ajXSG+Fb6cXdS9ztgqw4bDuQM5HWnrNGTyy+DkY61Gvgte7rbQ9z9wuKuezy
kTdyxNlzBxZCzYEzJV+v/XUuv0KvIWYUsfm82W70GOW1p/TnjMjlvoz64k7Q
XgSuLbHsm2Pl6HT/GXLJukX3PsnPDTefDvfOF9x+/gG3i9BL8OlvUd+HvPX/
COUMYp+Fsj9lL6F2cinUDnY7znNux/jurxS037OQfwGyj6s/
          "]], 
         PolygonBox[CompressedData["
1:eJwtk81LlGEUxa8z44wzYzP6zhuYRVQk9ReEGQRtCjcStYlcVBIa9EWrCAra
RIWWm1oUpNHGoNoUtKvoCwIjitSQNjETiWLQMqKo3+nM4oX7cZ5zz7nP864f
OrnnRCYidvDl+EaSiEY+Yr4lYqYccTRxvKE14hjx2IqIH+T9YEeJt1LbwsEZ
am/Bj1ec/+J7X4y4KAzY820Rg2nEBTBTYLvpL3fSo7aMgJS8j/gS+E8tPqOz
m1LPX8v8zcSPq551Br695Kv4Boh/wvGIXqNGH67bYOrEs+gZJh/LRkyXIu6R
H896xge0dDIjnzFmjt4T8v3M3s68jg7i1No1/zP8h/H7pbmfWc7PF61FnuVd
GqRlN7U1nF2dOlb/IfjFmrXNkS/VvEPtsg7nMNyDVfe6qL2Cexu113l7lvfl
srG6jzp5T2pt2tdG4ndFnz2Ax3H6AyX7kUd5nSzZvzj7EnOIS3f+He6dcDxj
1kEwu4gX6V/O+s4XiG819SqfIH7a3J9maHcL7fbfg4duzk9VrG0lHHeJvzbn
iaOB1jcl87cUuCP0PAezL+eaet9qzbcC5zzcbYm5pfFB2Xequ81w/iq9Aphs
xrVR8o8Vx9LYTu9m1W9TGm8QT5e9W+2kF3yObyLvGWc5e63kXa4jP01+veTd
TILJgx1PPFszf8N3JbEX5X/Ih6rG680fIn6JZ57D/zfam/pN6f70ppbK3ql2
qx28YN6piv+NO9TO0f/b7l32U7tPr5BYi/aRTaxRWjVTWkdSa9E+j6TGCCuP
rYk5xCX/ehvyLO/6p7rA/wOmRY0T
          "]]}]}, 
      {RGBColor[0.9390000000000001, 0.7175, 0.4109], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1k09IVVEQxiczed2r7/LOvUEGLgStXLrM9koRCQXpwohE/LMpzQha2K5F
GLppU5uCF5RWYBvbSLqujUgG2qoIJXsvdz7MoH7Dd1scZs7cb7755szc1sGb
l27UmVkv5zDnTWz2rMGsEMyqqdlmvdm1xGyR+BzxQHz1qFkH2Nmi2XST2RSJ
D7GdR7gXzM7z7UNk1nzIbBL8aKb4CLYKT5X4Nzg/5pj1oupMw1/m/hy7z30e
fwr8cfwJMF/qhWuGv0zuOHXvUrdSUu59sDNBnM79NhZXTCzilPEXiHWhYww9
Z7Al8lvguRippmO8t4NE/dwK6tNjG/T9iHgNXI23GQ7q3d/A38i17RK/nkjr
ILafs44/gI3gewW/oW+bezv3H9gV+PvALGPjRrMh/DX8riDs00hv7/mu41gQ
zzt6GcX/jj+GvZwJswjnBTj66fGA4Z7O5J/CPk7U5xPsTJNmtUSt8SDfY23g
roBvx57g9OJvNyrP/flck2t7Te7JTLPwmWyA6wSzlUqH6zkbVMP5z4F5id8N
1wvsn/ydZ8FczaR7oag3niho1j2Z/O5M3xyzQt4q/ffgzxH7FCs+EqTd9Xjv
v1Nx+dxcq2v+m2v0ufi+/SzJ/z8r3w1GbcuJON4n2lff2wp19lLpugPf7SD9
vi8+N98l3z//5pgK2Hux6uyU9G/V8t3+XBTed9Bn6LvkNb7mtQbo91eqXOd4
ECtvP5Um17ZDL/8AgQ+JeA==
          "]], PolygonBox[CompressedData["
1:eJwtkjtoFWEQhSeahHt3c/fG3RVUsBB8limN2CYooqDgAyJofCRpYmIstBCx
sNCIVoJaiKAgiQhaRMvY2Nj4wAiJlSA+4o2ChcEH6Hc4t/iXmZ0zM2fOzJr+
E7uHl0TEVl4r72Eacac94hfO9XrEId4c9jveYez5ZcRbImbwv2J/6ojYVTH+
BvGBMmIcv6st4i9+X93YKrWf8fmCv47YdvzbtYh/5Af1esFMZhHTvH3YZ5dG
TCURlRwcfCbBXEr9ZKvnKnrdA98DfgT86ZprqrY4DBK/Rr/FVtd4QO4Y9Va2
mN8p7C28pM0curG3Jc4Xx8/kXq6Zizj9IP9WYux96i0H/yS1rRpT4M/DZ1NY
w4R4o6BfWMOFwppKq7vEH5Gbg5lod45yE/Q4Qnw1PTvp/ZGcroo1Pwd+APwO
1cJfwN/MjEMVa3yA2sOZtda/7tIaiv8HegzmxgirmrP0msP/wwHsx98Ifmfi
3uLwKjMH+UfxU/CLhfXUTD+x++u+DfnHwN5szqd5XlbNWdzH6d/gXr4X1kL/
vhXemXa3l/5r6X8y9260gxHsUTisaN6PZttQmqs0eEPtNLeWuomL+BdS91IP
3e5Q7tml13vdXulemlmzz3fYFof1xGar5q597sFvpM6VhsepdabJVzf3IvXO
hdUOH+P3lcaL30Hsicy3rZvR7UgjaTUKh17irzNrq5t8Tnwmsy3N32I/rbuW
OE5L28Kzage/sXtK15KvW7/a1E81rmD/BxNWh0g=
          "]], 
         PolygonBox[{{3337, 3336, 3058, 1111, 3776}, {3023, 1094, 3752, 3328, 
          3329}, {3329, 3328, 3754, 1095, 3024}, {4072, 1317, 4071, 3336, 
          3337}}]}]}, 
      {RGBColor[0.945, 0.7324999999999999, 0.4294999999999999], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkjtolFEQhWfzYvM/suv/r4WVBMTCXguTiKURsRDUJlrYJAFRWdOIIARs
ok1IZeULUmilRRSEmAjaCBKxECUI2uka1yj4BMHvcP7iMnPnnjkzc+YOnzp7
5ExPRBzm9HLaQxHb+iJmsGtpxOtaxIU84mXl1/Cb/RENzl7wn7dEXBmI6GCf
JxFXIXlF7scGPPjjifmEWST/dm5Ml/djfcZkxMcL813ifYH8GrGb5N6n7hP8
a+AHc+PF/Z4zTA8HydsFz134n4JrFfZL7O8yYjtvl+FIKtws3D+4fwc7n/tN
mE2wj+DM4VwfZAbOP+I3iI22PIO0+QJudz1iA3u613jpcj3x/Q6YJrz9iJpk
Ed9Sz/mY+HLDuu0v3If6KfCfUesN/kQ104sBa3KSexeekZZ1Vx3t5FBhzFv8
NHMt1ZR20nCU96XEHCvSsmnNpf1F7juoNQ33FGeT3EnsSsN7XcVuLTyLZnqQ
Wtcl4qtD1l97mEvNk4L9UPU9jX8r8e60w2XOUWkLdqNhzVNy9xXGCDtSr/Tv
sZW2mlk44bUr7V5/4B7+DLkdZj+P3VP3XoTfiUbHuXcy96qeH6bua7ZuXTJy
FsnNsX/Z3xjxP9huaa6v2BMt4yewP0v396v0rMKrz7HCe9Q+JysN32WOqQfN
NlVYf+1B/0h6qiftQf1rtgPUaINfY//nwH8i3i5cS3HNvJ55Pv0F9a4/o/h/
QpN8oQ==
          "]], PolygonBox[CompressedData["
1:eJwtkjtoFWEQhefqJiZ37+4mu5silQTEwl5Bk4ilESvBRxERrBIQxWsURBC0
U5sUgp0KIYVWEURBJFGwCoiSQpQgaGmM8WrhE8HvcG4xMOefxzkz84+cPHPo
9KaI2I0l2IEyYqQnYg/+BH4b+9Qb8b0R8beI2MBubDZex/9ZRYz2RXRochO8
lEe0iA2T8wx/mrdtieNT+Glp/JycB2nElsy5R3j7Br4IfkOsgc01IzLy53ud
f4v6RaxA3wC2VPhNsTYa9tdwFo5J/0Juk3+F+HHir/qdKw2XiN1tmkuc5+Fe
zK1FMzwkNt3dh/AU/iwadyTW1AJ/Zf5d9NtgvhNwTzQ9z2FyntJrsja3enws
nKPcnbx9ofYYeJ7e1+n3eTBiX+n5pGkvfid1L/XUri6Dh5MuZ2WN0vaS+oPk
v0vti+8DvddaEUf73FO7m+vOq7ftaLvN2wvwfWpq6kdr6xPHWO2b6nbj5P+B
bzbz7fUnzpb+E8Jr4BnwudK+/sgyXCu5/R56pGhZSH0v7bCp3EHPLj7N1oFj
a2INq+Q/Tq3vFD2GSt9It8qY5wnc71vWp5pf1I6VvrfmHce/kDumP/qD+Exu
Lu38Kr1jwNqksYG/Xvk2qlFtVXo30qvbr/abW3ramU3+P+IrxO7lxtL4mvxJ
NL7t8unWvyvvUv/vGvE7hWs1o25RluYSfkT8P9d+ek4=
          "]], 
         PolygonBox[{{3471, 3470, 3772, 1109, 3773}, {4721, 1769, 4720, 3470, 
          3471}}]}]}, 
      {RGBColor[0.951, 0.7474999999999999, 0.44809999999999994`], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1kj1MVFEQhQ8s4sLuvqdvtzKhsCKxNlHiaiQ0Ala2RgtJjFAs8S8kYEIC
HY0YCzqwgkoqaPixMS6FhYk2kI2iiYWFIAgFhYXfySzFzZw7d+bcOefeiw9G
79RaJfWxcqxGUbqSlw7KUrUijYCvEedS6aRNKmXSPPgfeIF4j7UDHiL2c/ax
XRogXmfVwVXiDdYW+Cbxc4d0iXuelKSH9Hyj95i76ol0F/whCY6nDNNokV6z
7yG/UeAsjdw2eJz8BXgO6Z2Aa5v8OucTzfwn7nkPHgQPdEqz9LylpswM35s8
O+R+g7vPSPvEVnT2ofcHHpyF8w81B9T05kO7ee2N9S5yVoPrF7OOEv+WQ4s1
3Wb/gvlXOiNO5YPLtZO5wOawt5TocRb5We68X4n6n8x/4jcAfy0Gt7HvPSpH
nGa2lnPSZeYXcZX9EnekWXhhT8bgrDf12j+f++3shTVZr/HprO+S8N5v5/7d
trjb2r8UIme/i1n02dfBLHqW4Ng/H9r8LzaT0PWS+t1i+Cjro6eLmmdJzLLY
Hn+iksXe/yvJIr9C7aM05hgmrrO/Cn5F72EhvPRb+T+Zo9ERvtifPWa5VQmd
/r/uq+Wi7nkp8BtmnimF9q00NFjLMvxradS41hqsxW/1H19uez0=
          "]], 
         PolygonBox[CompressedData["
1:eJwtkj1IlXEUxo92e7nX9973rffeSWhoCloLKryR0lLm5Co41FA5XKGEoKJA
gqAlbXALxcGmmpKg1M3r4BDUYkhZINGiaR/g0NDv4bnDH87Hc55zznP+x6+O
D7e6I+IUr8SbqEW0DkWcxXmXRmxWIk6GY2/ziFdZxG3sja6Ij+RrRcQB2Jf4
Veynqe2L5YjuRsRNarbI98Jxj9ogNlC2fxd/kJr1hD7UfAU71+Ne56h5Rn4j
dU49r4D9DuYn/iQco3DdAkNJjOE38fsatj9RPwr2EfUL4JvEDuoRM7nn1Qxb
1Yjtirnuw/+E3XN6vEi8g3a5Dv5LyTvcwP5cNZdiyv2p21aP39jXcvfWTG24
p+B8CPcIsb/wfataG82gWXZ5Jw6zG/h5sGu5Z9HObex+5llLrPcy/mpmLnG+
oclzYv9KnnkR/r3U+ii/DHYlM59i++SmM99WN32MPcE71plXWo7T70divLSu
F9ZCPRqFe4pbmBb++4pvqX0uof1sZx7xfyDXBNNOfL8H7LdfN16a/cLe450p
Wz/dain17fUH9BdVo1r9kcuFZxb3An6G/zq1rZ7SQhpJK/U8X1hTaXsajbuO
8N967EvzHd2q87+k0VDhP6P7aaZNbrVz1LMptot9p2Z+3eQC+P8GR3x+
          "]], 
         PolygonBox[{{4077, 1319, 4076, 3339, 3340}, {3340, 3339, 3061, 1115, 
          3782}, {4671, 1735, 4670, 2721, 2722}, {2722, 2721, 3730, 1081, 
          3731}}]}]}, 
      {RGBColor[0.957, 0.7625, 0.46669999999999995`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkjtoVGEUhCcbI9ls9l7z321MIYg2VraK+MZCgw8sLSwU26ygoljZKSKI
iHY2EiGVNj4K00VXCxtJY7Gg4qOLYoy93zBb/Pznnn9mzpxz7tZz/dPzLUkH
OOOcz9PSGomHtTTdlWZJrhJXRdq5QbpZSft60hbiK8Q/eNs+IZ3g/TL4wZi0
1JFOleT9/oizTP45+TG42+DeIn7flr4RX+T9bC/4n8SvO9Gx3iZ0FjdKM9zH
OXvweIO8wPbHg2vB3YHOXXgvOqnlmtZ23v38baTdk9J6E9/2f61Kb+7x2FQ8
2du/Jj7sp0/No+hfgvsRvw25MhEfS54L8bAdj56Paz9Bq8X9YFTnDm+LfF+v
oq9evNpbjf7+kl6udsMxdwGNlXb6XKDOoZK6y8QD8kO45+vsw3Xvcd/uxtd3
3u9X0XyMzpCd/mYGF+p8O++ac5wPePuEl18z8bnKPUv+GfHmEo/u3X2tgJvj
++mopjGev3Wtv7eX3djDQbjr4M+AewP+JXW7YE+WzGDXZDjeiWfkeL4E82oq
vdpba/Tt/Fv3VGefX+hpUGcf77gPl2A9e9f0Ts3xvKx1pOSfNveruVUw/sfX
mvj5w/0fyP9kYQ==
          "]], PolygonBox[CompressedData["
1:eJwtUj1IW2EUPYlJifl5r3kvSzMIYpcudrVICyoOGrTSrQU7VHA0hYIWJ0Fw
EBcRnLoZMJMutkvc0kaHLsXFIWCLXVVM4u45nAwf3P9z7rnf8Kfqu5UkgFG+
FN9hFkgmgN9PgEoEvOUr0H+eBhZo/x8ExmH/Ywl4xtgxa1+yeT8HtJkPmKsO
AKsFYDEE6uzfYc1tEbjMeXbEml/M7QbubbGmwdxBaFszy5wNYoww3yHJqzww
ERlf/ZO0b4qePcSaTfb/zbtWPYmSY8q9ygDdmJiB9ymTX4t2l/n3KftZ8p3N
2lasyXwvdu8dZy6T2xlfnDaHbdZ/o9/kvC+smSFejT7S3kG7SBPtVyfHp+Rb
6+tbYeyY80PGXqQ84ztrq5G1FccV2vN9X3hztP8MGks9G+y/J7+xjPddD7yD
+H+g3+O8r4H31w226C+RU7vv6zZHgbmIk24/HVlb+VORMYR1zXdO7IfYWNKj
nbcmssWhw9y/vv7qSVKPz6F7FauGvrnmS8MW7bWC/4r+TCP0n5EvDS+Id5qz
lortkcvrkvG00xvaJzlrJ40D8v0ZeHfp94P7FCNrrxrd6hEjz1xx
          "]], 
         PolygonBox[{{3759, 1099, 3027, 3451, 3452}, {3452, 3451, 4027, 1294, 
          4028}}]}]}, 
      {RGBColor[0.963, 0.7775, 0.48529999999999995`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFkr0vQ2EUxk9Vmra37tXbG4LJ7B8QQqKIGHzEnyAmkpaBGERZmGx0YdOl
CWFqSITFgAgRg6VNxGpAMPn8HaeJ4c157/M+53mf87y3dTw7lqkRkXZWmNXg
i+xERA4ckbU6kUXAS09km/VTK1KgluKGn7oinymRB/AMeBF8FnwAjbOYSAt6
S3DS+o1mD/UN3ZeQSBztO/bn4H3guxHT3+esQp2KinD8p6Way/Bv0WwDm2Nf
cg3XO8sJkQ7473g5pqmD/nXOL/BUQS8M/9CxOxrR+4JXBF8FW2G1wp93zZN6
ewVbYD+D/p5rs15HTGswEPmAv4W2V91vsm/2zb/mpD3aW4ibV/Vcxvuobzoj
1OekzTnhmV/lK6/Xt0z6qd2B5dBFffTMh76JZq2Zf6dsNvVVdiwD1dTZ1J96
S6Kz4ViubmB96ej//Fqf8DIE74p7h6mhwDj3CcM0Z70jz1yd9J849q76vjcx
m1v/GfWfrXqb9iwX9ZBAL1/10OTbzOpzkuoEppNDr943jnJzVf0PZjzyLB99
k1+4LmUY
          "]], PolygonBox[CompressedData["
1:eJwtUk0rRGEYPcN0M5/X3JkIq1lY+Qcjip2Fj/wEZUMZFlOyEDsLS/MHZKMo
q4kSG2WSSMpqpqRsWKBYja9zOrN467zPPR/P87y3OFeeXeoAMMgT5zlPAcME
K53AWgaYD4Em76UuoJEG3nLAfsy1d+LVLFAkpgwV4lYeGCB+Yu2beJf6P+LD
ADghaaHtJ/5lgp4ETfpVmFej/pj3g8AaabdZG4JrPRGww3sp7pq+TbF2E9jj
mfy7hPNb5EwUgBGexS5napYLataZ9UH+J7OuQ9+lvyJOF6yVR4r4K+/ZNfNW
yhni3jJzhtm5yPwj1rojc8QdpyZG/V57fvV7z95+896NOD/EvZF3I32V2unI
3uqplqQ+6bfQm1TZ+2Pa3vIo03sj491pB5PUjvHUA9f0rZFwtjxOyX8JPbv8
X0O/md5COxplv9mCe9FMIfFy6Czto57wPyEvvcEZhX2R+Zqxn3iz3Y96eOD3
fyZSW3E=
          "]], 
         PolygonBox[{{3030, 1736, 4674, 4035, 4036}, {2726, 2725, 3733, 1083, 
          3734}, {4036, 4035, 4677, 1737, 3031}, {4676, 1737, 4675, 2725, 
          2726}}]}]}, 
      {RGBColor[0.969, 0.7925, 0.5039], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUjsvBGEUPeySnZ3dmZgZj9ZKRCUSrViFrFcj4hcoJUg07CYKjQoV2yko
FHReQUFDyEaLRBCFigKJzvPcnCm+nO+799xzz70zzWNTI5PVADp4EjwNAdCZ
BBY94MwH7qqAGxd4zAAfJE4wduEAT+SM++IZf4XoRkBfCsgQN9PANAV7qZfl
u42cZeokahS/pG6e3FxSuq/UamXuhThEfjvjC9T8CcX7DdVnt1a1lh9g/JO1
RU86c8RZX7EZ4ih1SuQ8OHpb/Jlz+JFqPeIRPZ1Tb4P5Ck89PVz58mqe/9i3
7MmzzdQTqZf1vHY0z5avvPWyfRU4c4U++wPty+bLs64lkP8ccYf1Xdx3Ia2d
WS/zZ9idUs17HbBE/hvxgPxh5u7pq5TVDk5d+Tb/h7yfuIpbfs3VvprY6zie
cZ3c71D6X6HmMP3t+Bub93nW7se99oi3cdz+Bfsetvci76uu7o2BdE1/kDP+
AxH8U2c=
          "]], PolygonBox[CompressedData["
1:eJwtkD0rhnEUxs/zQrjfct+3lxUlk8UqDPJ42eQTyGR4lAn1JJNBz4ZFPgBG
CwZKKWGVUmSwGVA2r7/TZfj3P+dc1znXdU7X7MJ0tWhm3bwy77XVrN5ITrIe
mO0lZpcFs0NqPanZOfk9+UqT2UwOLxU2AH8X/ij5Ykmcu0AzfNYw/O+Mn573
omojxD+ZMK9VmT3HOyjIwxtefsH7ysIfQ7Md8A/iCXoS+h+a5cU1a5HZJLUL
+vvpmSLuSBV77Rgva5G8XTG/AjaeKvaa73YUiOv7tIM9h9JzDxHzlhPN89pS
Is/ubQgPX3jdJy816GZ+uzp6g9y1l9pLIo/u1Tm3eK/FuoXvvIH2aiytCvMC
9MJcsev57vO8p3++32ozllfXO6V/rEV6bcy/Bj8LhLnmNtzOVHzf8QTsJhHX
e9xrnOu2vuMW+Gem3dyTe/sDnN9L3w==
          "]], 
         PolygonBox[{{3332, 3331, 3036, 1104, 3765}, {4043, 1301, 4042, 3331, 
          3332}, {2730, 2729, 4679, 1738, 4678}, {3764, 1104, 3766, 2729, 
          2730}}]}]}, 
      {RGBColor[0.975, 0.8075, 0.5225], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUT8vQ3EUPdrXKq/t856nkSiJf53EV9BJGgaJ+AQmCSEREoZuNj4CiZFG
LNXFpkazSUgkwswHwDk5b/jl/jv33Hvub3pzb303B2CRL88XVIAanacIOKkC
deVT4JLxbwDE9F9CYI1+l/UK41YJ+CgDcwmwQPwWOR6IjwvAfOK+g5K5Zhnn
mL+OjBN+grnPwDw3A8Bh5HiQ3Nv03+nv055zbpf1MeaX2ZOn3xkGNlLP6hNz
FZl/ivWz0Hzfsecp36G9yHhmiDml3yB/m1oKqfHqq6XeW7rr2c7iHkmtQ7fR
DXQr7fFG/U3u/zcKPA9ZV5v6bovm0bzJxFY6+tl9Wok1iOOOnD+x9Uq3/kD8
y6z3qvb1P6up77lC+xX4VtpJ89UrDU3Wdhgv0R5Fxh1nM3tFz7sPvd84dwhS
8+j2jcSYx9B84ilneqTrlfr+AfhlREI=
          "]], PolygonBox[CompressedData["
1:eJwtUb1KA2EQnOQuMT/mzjvPIBiFaEzlO5gqBAUF8Qms/QERNIWtpW9gYSci
FsY0dmLlA9goCoJorQ+gzjApPpjdnZ3Z3a+5tbexmwfQ5Av5nqvAGkE9API1
YDEFkgKwxFqL+DJmfhQ/lYFzxr/kXxeBO/YGGdBg7ZO5kPg7Aa5ywDvjH+Lj
CGgTj5PTJ96PXVP8SL251PoD9swS74zqnRLwRtIte4Kc5xtG1lDvNusd+i1n
xupR7wrjg5Jn1Kx9vq/QM55E3lFa68y9cP5uxbFucMP6Yexd1HNEPIjM1QwX
FWtISx6r9Eoyeyk3QfzB4Xola0jrgR7Dom96z3g+9a7aeYF4OvUtlTsj97Xs
W4u/mdlT3tJok9sb/Y9yXeLTqu8tzxr5Y5m9lSsQ/036lorFnUmtL/8G8VRm
b+1QJ/4HEvE+aw==
          "]]}]}, 
      {RGBColor[0.981, 0.8225, 0.5411], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkD8vRFEUxMfueqy39tmXR+NPSJZO4zPQyGp8BHoSUSMSjUIiCo1aNITQ
KlBs1kdAhw+AqDR+k/OKmzn3nJm5c8/M2ubqRkVSm1PlzOXSNsXFkNRfSEuD
0gC4k0m/ED8b0gj3Zfot8Jx+t0/qFKGx9rYpvTdCm9A/475O/5T57nBwrtDV
mc3XpAPml9yf8flD95pKb9QVuGNwOviMgiucBfiHzXjfWmfaK7M5o/X2eUyD
Z/5+Fmgf8+6SyGOeM7me5t/fLemI2Rd4k4SmW+Zwnhc8J/OYTYE/Jf+Y/kka
efynCWbX9MfBdh7vzYI1ZotkqIK9LPbgfdyn8Y53+VDu4YleUe7H3r269EG9
lUVe+1vzD+quO0o=
          "]], PolygonBox[CompressedData["
1:eJwtULuuQVEUHI/cSA42J4fGIyToNL5BJTQ+gUZF4wNE+AuFUkMI7S3uVXj8
ApXEJ+jNZJ1iJbNnzZo1a1cHk/44CiDHirOOaWAaA54R4OGRD4BuAmixufKs
hA8/QMkH3kngQ4MmuUBa1iVimh5xltVJmGbtgGXatG1yL85ene3Szhvxmf73
8N2g/yLUyyNDrwK5PXcP2R+lrIRP5Grs/Yfz4lac3TnzErcl3jjLJ48i9XNn
WZVvRlz3zUv6P74rvnlp5pfeZd9u11teukmz+qM888UCu02Zlf0LFswuhQ==

          "]], 
         PolygonBox[{{3958, 3957, 5127, 2117, 3299}, {3948, 3947, 3954, 1252, 
          3953}, {2957, 2956, 4593, 1678, 4595}, {2961, 1678, 4594, 3947, 
          3948}, {5126, 2117, 5125, 2956, 2957}, {3298, 2116, 5124, 3957, 
          3958}}]}]}, 
      {RGBColor[0.987, 0.8374999999999999, 0.5596999999999999], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtjr0OAVEUhAe7smvFxrqVhq0U4hUkGo2fwiOo/URBjUSp0Il4BVvoNSo/
rScgKuU2dObm3GIyJ3O/e+aE/XFvlARQpFLU1QeUDVzoNj1gWGNesYChA8SE
Tx5wTAPlADgYLqKvPeHSCnCoJvkMfZeTPd8sMCf3IbOklwLZE9KrlvyNEsDM
l54n+a35++Mc54XRPXvmdc5nTzjNr5h12Ddlb5uuqBbnN98bSu6/uUDB5AH9
Zf7qTt2hu/S9d1fuXDDvmp0PZhNfbhz4Ij1veMMfzVcquQ==
          "]], 
         PolygonBox[{{2506, 2157, 1063, 3710}, {3717, 755, 2118, 5129}, {3010,
           1086, 786, 3323}, {5130, 2118, 755, 3956}, {3320, 786, 1086, 
          3739}, {3455, 45, 1300, 4041}, {3323, 786, 1285, 4013}, {3735, 45, 
          786, 3736}, {3956, 755, 2157, 5185}, {5126, 1063, 755, 3299}, {4014,
           1285, 45, 3455}, {2961, 430, 1063, 4595}, {3710, 1063, 1067, 
          3714}}], 
         PolygonBox[{{3739, 1086, 3740, 2711, 2712}, {4007, 4006, 5196, 2165, 
          5198}, {3967, 3966, 3301, 2123, 5139}, {4641, 1714, 3005, 4006, 
          4007}, {3723, 3722, 3970, 1259, 2507}, {5138, 2123, 5140, 2963, 
          2964}, {2964, 2963, 5129, 2118, 5128}, {2516, 2165, 5197, 3722, 
          3723}, {3969, 1259, 3968, 3966, 3967}, {2712, 2711, 4640, 1714, 
          4639}}]}]}, 
      {RGBColor[0.993, 0.8525, 0.5782999999999999], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUDFOAlEUHHAlu3zcZdffCtl7aOEFKDyCB4CGGgItBWuCcYGCUFlyBltt
vYIJsVZC3MZ5mS1+/n/zZubN+/nj6GHYBNDjueD5CoBlCzg0gG4IrPi+If7m
gDv21jHwROw7EGecSNP2wG8KFOytyd2SV1F37gAbJ82J/ZL4LfkvvKeJfGa8
d06z/shZxJr5GQEfkd6G9TN5lm2gcQk8t1S/Jqpz9o+B8lwRr1Jx9vS+98It
r2W03cx35bRH5jXffAwPvXDrX3vltLyTWN7vkbCi/h/LZFls759Uf1hSO6/5
pht4+Vvef5qYNKU=
          "]], PolygonBox[CompressedData["
1:eJwlUDsOAQEUnBU27C7L7rYiexCFCygcwQEodBKFE/gEsduIQu0OSlpXkIga
ERozecVL5r03b2by0v6wNygAiFlFVhoBTgn4EbeI3w1g4QJHB1j6wCgEbiTe
WWPiL/cr7utl4BQAG89u15z9uNv7hqV5IH/LfuaahrQy9nP2D/aT0DjiSnPn
m6e8dfOk3rUCNGGcbgJ4iWmJUyb+BObf5iyvWSZlk8eL99PQvKRxoVZWM65u
lP3MWRWm2Uksk/j6Qc4sUWJemsXEfwTOL1Y=
          "]], 
         PolygonBox[{{3008, 1084, 3736, 3321, 3322}, {3322, 3321, 3738, 1085, 
          3009}}]}]}, 
      {RGBColor[0.999, 0.8674999999999999, 0.5969], EdgeForm[None], 
       GraphicsGroupBox[{
         PolygonBox[{{3009, 457, 3322}, {3964, 1068, 3715}, {3965, 434, 
          2969}, {4601, 434, 3963}, {4005, 437, 2977}, {2710, 866, 3737}, {
          3431, 866, 3973}, {3972, 437, 5057}, {5057, 437, 2976}, {3962, 433, 
          3955}, {3266, 718, 4602}, {3955, 433, 2968}, {4341, 718, 3721}, {
          4596, 1068, 2962}, {4597, 718, 3266}, {2971, 434, 4601}, {4012, 866,
           3431}, {2962, 1068, 4598}, {3322, 457, 3008}, {2970, 434, 3965}, {
          3715, 1068, 3720}, {2975, 437, 4005}, {4603, 866, 2710}, {3725, 718,
           4341}}], 
         PolygonBox[{{3973, 866, 437, 3972}, {2977, 437, 866, 4603}, {3721, 
          718, 434, 2971}, {4011, 457, 866, 4012}, {2968, 433, 1068, 4596}, {
          4598, 1068, 434, 2970}, {2969, 434, 718, 4597}, {4602, 718, 437, 
          2975}, {3720, 1068, 433, 2967}, {3963, 434, 1068, 3964}, {2976, 437,
           718, 3725}, {3737, 866, 457, 3009}}]}]}, 
      {RGBColor[1., 0.886, 0.63], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFUDFOAlEUHGUxBHQ3y35aE6yVSMIJTLyANRUHgANopyRaSGNBQWLstaRU
MRptLcQb0JhgDaUzmZ9Y/My8tzPvzdtmb3DS3wSwx1fiey6AnQrwSBzXgMME
uEyBhwxIysA98Zb96QawyoFz1ktqjgJwRv5Dfhp74rRiVlgv382W+6qFy8i7
3PlL/skwHeI3dy3obSf2SPMV3BtVrZVnl/Vxw3w/WK/80gnbcf4HM9RZvxIv
MvuHme+U7qXwXPmeCmeQXnneto3v7OcVf1OtGXnUXKfu3/HGde679G8mNWe4
Sn2TuHYoqzK3gjNp1zwYO1FzEP73/wH2Yj3+
          "]], 
         PolygonBox[{{3963, 1257, 1683, 4601}, {5166, 2140, 719, 5165}, {5061,
           719, 2066, 5062}, {3715, 14, 1257, 3964}, {2976, 1076, 2065, 
          5057}, {4341, 1493, 1076, 3725}, {3973, 1261, 30, 3431}, {4599, 436,
           1260, 4600}, {5053, 228, 2061, 5054}, {5332, 2066, 228, 5331}, {
          3721, 1073, 1493, 4341}, {4601, 1683, 1073, 2971}, {5056, 2061, 436,
           5055}, {5444, 30, 2140, 5445}, {5057, 2065, 1261, 3972}, {3720, 
          1072, 14, 3715}, {5186, 1260, 14, 2508}, {3431, 30, 1284, 
          4012}}]}]}, 
      {RGBColor[1., 0.9051999999999999, 0.6659999999999999], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNUbtOQkEUPBEv2WsIj+z6ATQmxmijX0CgUwp7Ch41NpD4Gcb/8QVipYkJ
xPgTJGghdDiTOQXFzZmdnTNnzt567+Z6uGdmx/gK+Cb7Zl+ZDiE36+P7hOC3
BBzMLpI0KYg/x7kH/IP7aTSLwCfgWodmt+hton5n6qH+Cvdj8H/AK/RkmNOu
mL0Af4C7BO4E6Znhvqge6rqolR3Mueyh38g931GH4BtJHDF55h34LszIvbbA
dwfKt65KTy/O5H1wzZFznMt75uH5EfuWgR9QlyVpW8j/FJXzGfUtavbMOXrR
Z1OTx7qmvrLvwrnR33aelGGR1Nt1TZ5Lz76+8/R89ffnfxh4fvqcJr3pmfvl
vtc/qCNAdw==
          "]], PolygonBox[CompressedData["
1:eJwlkLtKQ2EQhAfjkXM0eJTzi2BnY+OlUJ9ASCpjkT6F0To2Fvb2Kj6AT+I1
XjpBUMQnsAuoRWKn37DFwP7/zszO7mL3oN0bk7QAxsHFlLRUSGUu3VTScEZ6
gVDxfuD9CBJ1H/J9XTqZlAr4OXhN0hro0FdNWqFulNIf+mdwB3+dv136e+CH
9yn69yz8mmVorD3CrzEnjZj/kUUGZxnNSucTkdFZncFaz1xFe4zHYRGcX7h9
8u4Xkfmpihnm2/OM2fNoWvSG+H/idQVnOo+dvNsO/KwWHHO3QC+PGZ61XcZu
Xf426C2nuJV3HuD3luI2zuAsmyl2t+cX/dsqbm2PS+rvenj5Rr6V/9xzpmvq
f3OlOg8=
          "]]}]}, 
      {RGBColor[1., 0.95, 0.75], EdgeForm[None], 
       GraphicsGroupBox[{
         PolygonBox[{{732, 243, 239}, {3302, 1225, 5143}, {243, 732, 235}, {
          1223, 774, 732}, {3312, 1230, 5172}, {732, 774, 235}, {5170, 774, 
          3313}, {247, 1495, 239}, {3265, 1217, 3909}, {1217, 732, 239}, {
          5060, 1495, 4342}, {3309, 2139, 5163}, {5143, 1225, 3918}, {2704, 
          229, 3910}, {3314, 774, 5170}, {5171, 1223, 3916}, {774, 1230, 
          235}, {1217, 1223, 732}, {239, 243, 15}, {247, 239, 15}, {1495, 247,
           229}, {3910, 229, 2703}, {1230, 1225, 235}, {2139, 1217, 239}, {
          4342, 1495, 4343}}], 
         PolygonBox[{{3313, 774, 1223, 5171}, {5172, 1230, 774, 3314}, {3918, 
          1225, 1230, 3312}, {3909, 1217, 2139, 3309}, {5059, 239, 1495, 
          5060}, {3916, 1223, 1217, 3265}, {5163, 2139, 239, 5059}, {4343, 
          1495, 229, 2704}}]}]}}, {{}, 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2703, 3910, 2704, 4343, 4342, 5060, 5059, 5163, 3309, 3909, 
          3265, 3916, 5171, 3313, 5170, 3314, 5172, 3312, 3918, 5143, 3302}]},
        
        "0.912`"],
       Annotation[#, 0.912, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2508, 5186, 3971, 4600, 4599, 2974, 5055, 5056, 5052, 5054, 
          5053, 2702, 5331, 5332, 5058, 5062, 5061, 3267, 5165, 5166, 5164, 
          5445, 5444}]},
        "0.864`"],
       Annotation[#, 0.864, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2967, 3720, 3715, 3964, 3963, 4601, 2971, 3721, 4341, 3725, 
          2976, 5057, 3972, 3973, 3431, 4012, 4011}]},
        "0.8160000000000001`"],
       Annotation[#, 0.8160000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3008, 3322, 3009, 3737, 2710, 4603, 2977, 4005, 2975, 4602, 
          3266, 4597, 2969, 3965, 2970, 4598, 2962, 4596, 2968, 3955, 3962}]},
        
        "0.768`"],
       Annotation[#, 0.768, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3714, 3710, 2506, 5185, 3956, 5130, 5128, 2964, 5138, 5139, 
          3967, 3969, 2507, 3723, 2516, 5198, 4007, 4641, 4639, 2712, 3739, 
          3320, 3738, 3321, 3736, 3735}]},
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3953, 3948, 2961, 4595, 2957, 5126, 3299, 3958, 3298, 3717, 
          5129, 2963, 5140, 3301, 3966, 3968, 3970, 3722, 5197, 5196, 4006, 
          3005, 4640, 2711, 3740, 3010, 3323, 4013, 4014, 3455, 4041, 4040}]},
        
        "0.672`"],
       Annotation[#, 0.672, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2505, 3954, 3947, 4594, 4593, 2956, 5125, 5127, 3957, 5124, 
          5123, 3716, 5136, 5137, 4000, 5142, 5141, 2972, 4637, 4638, 4008, 
          4636, 4635, 3432, 4644, 4645, 4033, 3011, 4646, 2728, 3763, 3035, 
          3330, 3034}]},
        "0.624`"],
       Annotation[#, 0.624, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2955, 3709, 3705, 5184, 5183, 3949, 3294, 5119, 2958, 5133, 
          3300, 3959, 3960, 3961, 3718, 5195, 5194, 4001, 3002, 4632, 2973, 
          4642, 4643, 4009, 4010, 2517, 3453, 2525, 5204, 4034, 4680, 4678, 
          2730, 3764, 3765, 3332, 4043, 2630, 3762}]},
        "0.5760000000000001`"],
       Annotation[#, 0.5760000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2503, 3946, 3940, 4592, 4591, 2951, 5117, 5118, 3950, 5116, 
          5115, 3711, 5131, 5132, 3995, 5135, 5134, 2965, 4631, 3001, 4002, 
          3000, 4630, 3724, 3732, 3006, 3450, 3007, 3734, 2726, 4676, 3031, 
          4036, 3030, 3457, 4679, 2729, 3766, 3036, 3331, 4042, 4044, 3469, 
          4075, 4074}]},
        "0.528`"],
       Annotation[#, 0.528, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2950, 3704, 3701, 5182, 5181, 3941, 3292, 5109, 2952, 5121, 
          3296, 3951, 3952, 2504, 3712, 2513, 5193, 3996, 4625, 4624, 2966, 
          4633, 4634, 4003, 4004, 2515, 3446, 2524, 4028, 3452, 3759, 2724, 
          3733, 2725, 4675, 4677, 4035, 4674, 4673, 3456, 4685, 4686, 4069, 
          4688, 4687, 2742, 3780, 3060, 3338, 3059}]},
        "0.48`"],
       Annotation[#, 0.48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2502, 3939, 3933, 4590, 4589, 2947, 5107, 5108, 3942, 5106, 
          5105, 3706, 5120, 3295, 3990, 3297, 5122, 2959, 4623, 2997, 3997, 
          2996, 4622, 3719, 3729, 3003, 3444, 3004, 3731, 2722, 4671, 3447, 
          4027, 3451, 3027, 3758, 2727, 4683, 3032, 4037, 4038, 4039, 3466, 
          2532, 5214, 4070, 4719, 4718, 2743, 3781, 3782, 3340, 4077, 2634, 
          3779}]},
        "0.432`"],
       Annotation[#, 0.432, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2946, 3700, 3698, 5180, 5179, 3934, 3291, 5104, 2948, 5112, 
          3293, 3943, 3944, 3945, 3707, 2511, 5192, 3991, 4621, 4620, 2960, 
          4627, 4628, 3998, 3999, 2514, 3442, 2523, 4026, 3445, 2720, 3730, 
          2721, 4670, 4672, 4029, 4669, 4668, 3454, 4681, 4682, 4064, 3033, 
          4684, 2740, 3774, 3057, 3335, 3056, 3773, 3471, 4721, 3472, 3061, 
          3339, 4076, 4078, 3490, 4097, 4096}]},
        "0.384`"],
       Annotation[#, 0.384, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2501, 3932, 3928, 4587, 4586, 2942, 5102, 5103, 3935, 5101, 
          5100, 3702, 5110, 5111, 3988, 5114, 5113, 2953, 4619, 2993, 3992, 
          2992, 4618, 3713, 4626, 2998, 4021, 2999, 4629, 2718, 3753, 3024, 
          3329, 3023, 3449, 2723, 5158, 3306, 4030, 4031, 4032, 3760, 5213, 
          5212, 4065, 4713, 4712, 2741, 3775, 3776, 3337, 4072, 2633, 3772, 
          3470, 4720, 4722, 4091, 4724, 4723, 2762, 3794, 3083, 3344, 3082}]},
        
        "0.336`"],
       Annotation[#, 0.336, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2941, 3697, 3694, 5178, 5177, 3929, 3289, 5094, 2943, 4588, 
          2949, 3936, 3937, 3938, 3429, 5191, 5190, 3989, 2989, 4616, 2954, 
          5146, 3303, 3993, 3994, 2512, 3727, 2521, 5203, 4022, 4667, 4666, 
          2719, 3756, 3327, 3754, 3328, 3752, 3751, 3448, 5156, 5157, 4058, 
          5160, 5159, 3028, 4711, 3053, 4066, 3052, 4710, 3467, 3468, 3058, 
          3336, 4071, 4073, 3488, 5224, 5223, 4092, 4751, 4750, 2763, 3797, 
          3798, 3345, 2638, 3793}]},
        "0.28800000000000003`"],
       Annotation[#, 0.28800000000000003`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVz7suhFEUhuFPHCaYMRMUhMZdjHtQaSQznUwhcSqmkIhWSBANhYJGqaNQ
CIlDISESRKUzGv89SDyKN+9ea39rZe+p+dXZla4kM1geShZw35/UR5O5atIZ
Sb6wPpj8cIGGfhMPcm35F95XtyrJwUCypnfIfcNJCd3oRQ823I3ZPY4LM5M8
gXP7p90/86X+E9fVbTvPzLyqN53feJu30DTXwKd8od+S/+BFXkJH//v/D953
JF/wMZ/gzs5bPHrnruwefmVL5WTH+VTm3X1ZfeVc4Ru+Rq2WVPEHVpwuHg==

          "]]},
        "0.24`"],
       Annotation[#, 0.24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzjkvhGEUhuFHoRhrLIV2/AfxO4xEbUkUEkapVGk0o9WoNAQZS2KUCkEt
iFhmEmImEgoKFS7Fnfs7zznnPV9xulxaaEsyjtNCMjqYTPQmrb6kiaXOpD6Q
NPCAJzyi3JO8chOr5u+6kjffy+bb+pNtrsi3OOrZ7qTAu+qqfI8XZWWU3BzD
ofxcPmLugIuylneP5bX/G/5v090GX6tX7FY7kh3ZPk/bm8G93hRPoqo3x+/e
+5R/8Lz6zPy6/W/ZBre7c2n2Ql7RX8OP3i/e3Dsy88U1vjJ3wrd8g7qdZ37B
kHzYW38BKTwc
          "]]},
        "0.192`"],
       Annotation[#, 0.192, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNzjlLg1EQheHRykQT18YqLr9AC/9BehEttBQULNQ0wcLKwoBg4QJ2Fi6g
RSoDVvYqoggG4oIRN76AbergUxzeOTNn5t7h+dWplbaImKXvbMR0OmIwE9FQ
J/TJf2GuK+JKP90TcYlnfRF1s0ezlFlFrwMf+CP1Dd5SVp2hO/W1/Ka9EjW7
IxYHvJOKODD/4Ov0Tn+dEQsyFfkts4Sv6TdwTv8eR+yOUlV/CHO0441jyttr
+cup+oQO+TF743QhPyn77N1lt/f5PdqlsrvtMhvY6o04x239vHzBnXX+t9+u
2yX9Gv7wS2av+MS/YBXfsCifuLOGM/IT7vwDTPw7wA==
          "]]},
        "0.14400000000000002`"],
       Annotation[#, 0.14400000000000002`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNz70vg2EUhvFTg8RnfY4kwuhrwWjgLxBLBwOLpIQIo43EpAumdkSYkJgY
LBaCNhJtJbWIVMxiIBJ+w5XrOec5537et2dueWopERGz6GqJ6Ea+KaKAvsaI
O+7lanPElfN+W8QBGswd8SFe6u24r/C5mTp3n3URZ84/yYhvJJ1r5eQ4iw17
CfWXuxreVF/bv5BziT0zu3iXs8Ov/Gy2jI+GiBnzD5ziN37ST3XINXsiZ0z/
Vv9R/4ZH1SvuBngQ/RjGEHLmM97M8qKZUzsl76Wd7zmj3saxnL/WiHX+5UPe
0p/w7iTSMhZQ9D+Vdt/E450R83oldV5d5AKXedV+Vc4aT8sZkfEP0rs/fA==

          "]]},
        "0.096`"],
       Annotation[#, 0.096, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzrsrxXEcxvGPlHI5bmEirIyUu5XNZVJEGUSJMiiTMjn+Aikml0EuG6t7
ylEog+UMpjMdIVLEy/Du+X6e5/N5fr/68dnBmZyImMRJfkRPZcRtUcRcYUSH
dyda0Y42TBRH3Mm7vO9pN523+14RsUXf6CadtrdAf8oiduhySUQSK5hKRDz6
Vp/dA3NjeUQD1gp45m+9P9jQsY4Z+03ySz0p+RVtNu/ZX5IN6XngP/OH+If8
fvMA8uS95iM92xiWjyArG6OjOP3voeGbi/RXz6q7C37SnMv/sP+JjP/elb3S
fXqAlN4bPNlP0xr7VfxqekzT/F09deai0ogEinEt+9JT7X3r/eE2azdDX+iZ
m3PUylvc/gFA70Fm
          "]]},
        "0.048`"],
       Annotation[#, 0.048, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzbsrBQAUBvBDkjd5pIjcDFyzxeZVJiXi7sqkyB+gEHmUwSSTYqKbLGLn
Lrg2pW7JTaKkUFJK+RlO3+uc7yQmZ0dnCiJiyvzjbV1EtiLisTBiqywiBzfh
FZwrj3ivj0g1RNTa/cD3eN+yffhJt/M7hBf0tcIdt0s1EZ28EXeDdBKfrozo
pftMi7sXP1thxt1ulR/4TXVEnh63f+RuRc8EfiIbolP4sp5+HQMmyX/V0wWf
3J3pmcLf9fzS8/bP3a3rWcBPZcP0Ir6tZxWumWJ5kZ4N/E6elpXwjmETP6c3
x3+AedPIH6Pv8VP8wN2haXSTsJ/G3+SXsmZeFnbzv+x/8DPyHrrtf9/8lEY8
2ymU/QG/1j1h
          "]]},
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0D1I1XEUxvETZGKZlnXRmyHplhK9DBFCbUFOda8VboG0FUVjCoEEDS3p
VmiQGdjb1HTbKsKGhnIJKq+WLzdJvZVv2U2iz3/48pzzPOec/49/Y+fl7KUN
EZHDUmXEb2RTEW9pe3XESqL6VbqMAzsjinQ//UEP0hH6d1tECWt4rX+zI+I2
zW2PyGwxa+4ULdI2WY+sV3aMt8A7Sudpk+yK7KqsmTfH20u/0/WaiHOytPfU
Yxf2bY2o9M60mXV1j7nH3vAIw6jgH3ermz+g78cdLG6OOMy/yO/T9+IWdvPq
sVARcdJMjZtVvtnmW/O8B/pVO98wixnkzBXouG9lzE3QMnN5ekI/bm9Mnsdn
TCSzifK/0kl8wTSmkppf5g2bsBFP3C+nZ2UrSe5uh7tn1E9l1707499kcRrt
uFcVMYhJs+/8n/cYRZ93zbh/3m61my/s37D/knbbK5nvon/oc/sFek3/j/6y
v4iC/Yfu/KS1btThphsf3EirL7hdrk/7b3ftfuSPuZVHyl5W/0n9TD0ov4+U
+QbzQ+o5+Yisy506/iH+K36Rv2Zvj6wRy+oljKpL9Ii5aXUrnaVNdgu0hTbj
PyIcd+s=
          "]]},
        RowBox[{"-", "0.048`"}]],
       Annotation[#, -0.048, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0DtI1XEYxvHXDmTeNUujUGgwCFqrwUmMzMtQbS1ZOjWoNJgKjUJTCdZ0
lGrRWlrTrl6wmzVEGE6Kig6CZFJ46Zwjfc7w5Xnf53l/7+//+59s67ramRMR
I2gujDhTGrF4OGIBuQURqeKIg3StKOK0LCc/Ykm9jHPmF+lZumPuq3qT/ka1
ugpb6g1nJu2bQoUdfUciZmTr/Ke8E86X85+oH+OFbJhekY+bHVLfl8/rj5fZ
YT6hr6RJ2U/+J/fM0WfOHpBt5nmTehRp33/XXCr7HvsGeX36FvMv9b3qe85M
6Ivt3zXXzevBHbzn98vf0SJ5uzOF9K0+n76hBbSNn0df6w/RV3SXt4cdbNvb
zLupvoHWrM/7R7/x92mpN6VpCc3Qy/xf3lJlXzUGfcdDPEKnPHE0osbsNdqh
/2M+KftLz5uvlX30hovqBjyXNdJLWOJn/It9XDeX0h+zpxLt2beix1wvpp2b
wS1eBR7wBvCd9wO3eaey/5M3hhXeKprsasGX8ojPmMUHd+3J0sigriSiHhP8
BjpJL9AN+h+kp2aS
          "]]},
        RowBox[{"-", "0.096`"}]],
       Annotation[#, -0.096, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0btLFmAUx/GjvoFpF99b6JsQEZqQmaaDuuiW2GWwy+AkNtWgQg7RWIsQ
CqWp/QkK6iaaUaKDNZi3ORwaolcaHAQbND8OP77n/M75Pc8Dz9Xe/q6+gogY
p9KSiMPzEUVYVxZxk+6di9hNRRSXRuTN7uivYQceX4hI8P9hEe7ya2RC/qc6
p66gK+pG+99wjfL296hSfZn+qvMyX91zy15G5mUmoikZ8Zs/om9U36bDsxEr
Mvt4hp+gcplp3hRNOuMjTdA4vTXfccYl2Yy9MV4WP+A2f8h8C7Pmz92ZwU19
Cjcwjc/4SfyhL8N1HJVPOec9Jk/f7O40FWZR/1+mQB20zD/w3gFeP1WbJ/g5
/px8jX4Gr+MsPjE7cMcfu83ua6VuXgt+N9+TS5g3eHs9PZCr4vXw3si8pqd2
c/5k3nyBFmmY34Y99o+cc8N8VV+Lr+y/4L/DNv0Wvx3H9HfTEZ20qP5Ev8w+
n/retISDZl3+8L7+IX5xzmN8RE0XI04AkhFMXA==
          "]]},
        RowBox[{"-", "0.14400000000000002`"}]],
       Annotation[#, -0.14400000000000002`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0T1I1AEYx/HnhkO77MVMHBry8rq8o9IGhzukQUhIqOygoJYgrgYHpbOX
xd3FqYZwdD4CtSEyFBpCoTGyTlq6q0hwCjqJSPvc8OX3vPye5/m/pO9OlSYT
ETGLakfEzcMR9w5GjByJKNNHXRGP8b4zYuF4xNVDEVeQ1S/pF/nn1TePRnzE
BzzjfYqeVMQECvwVuy/qXUcJ3eb2jrnFdx+v1E7YVxZf4/2qN07r9IVeFSn9
Mf0Z9/4eiLhtd1t3RDvW+Yb5N2hT/SXNyzvNPeCv4IZ6kjenvqi/jCXU1U/a
26C9dJr3IU6J+5DGaWTQdPcM7UcWeeSwq36Onsecm9/sGhA/seet9/8ur3nn
H3TFzTd4jbOeZYjvp/pzc6utuplb8jXxO7M75gb5NsUXaI1+xr6bfWa+iMO3
+cWXoFvmRvk+0Uu0oZ9U39e/LM/I79j/T77dmvUvE/jd+rf6f+iAvbu0SAv4
D5CxSyc=
          "]]},
        RowBox[{"-", "0.192`"}]],
       Annotation[#, -0.192, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVkTsvQ3EYxh8dJO05bSmKUYJKqieVCOJ06G3CJG5JEwkxk0hqkJQmPkOl
/QC2jmgHJhMjrUuYMIqEwS2lfmf45b08z/P+e+lb3Zhdb5GUhwmPtAevbdIL
XLRL52Cx24ZQlzQEmx1SyZRiPsmGGeYivhLUyCUMqUCfxTOAFoJBmPRKvX4p
gh4kl8KbhjVuW2gr+ONOHpLQZPcUkJ5hmnsmuTJ7g+rjc/gh1yntQMMtZbjj
YWeAG7xgwid7m/wXNUbdxf+L/5L7VxDm3QB3s+y3YAHfIW+G8Q5DAe2IeY5b
i2jH9FH2I7CPVmGeR1tCq9KfcbOVOcLdE2aLWmdXgz/ejZNLQJFsg0ySPs+7
N47u/P78Nk1qnew19ONLcSONz8V3P2C+ZX9KZhnfHf0j2XvqA4yiT+F/Z/cG
48xj8EHfTd7Ff9BD/cb7AzZaBv8/CvVFrg==
          "]]},
        RowBox[{"-", "0.24`"}]],
       Annotation[#, -0.24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0MsqhWEUgOFFyfmwt20zYOBcFCMztrOpYqSItjJRDCgugJkxRUjKVbgC
p+1Uwi1g6pR4DN7WWu+31vq//2vMLk8s5UXEKlIlEYmKiDKxryqiF9NlEd/l
EV8orIyYUnfKO1CkTpdGvCcjPtCjfysVkU3YxZ+o5+SzKLbzzUw714ZWjNj1
zD3h3vyMnlPzd/Jj5z/qYbND+m65Gxzx33w/P8hfczkc8l98hh/gr7hL7POf
///D9/Fn3LS6yTf71efqjHghvnAFzjbdYQOJmogqtPE1YhpJpFCN8FYV+sd8
YxRRHfFrT7f+fPm8vXliVqzV2+VNWtSr6maxwY56LNpRh2133MGDXY94wq57
ZMxOmm333uN2r5ldxwr2/u9uZsH5q/5reQ4Hzv4AjAw63w==
          "]]},
        RowBox[{"-", "0.28800000000000003`"}]],
       Annotation[#, -0.28800000000000003`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0Lsvw2EYxfGncWmVXrQkjCYkEmKSIBIGBrdSFRUDE4tuDHYSRptBRKz+
Af4GZv+AayLiEpPBp8M3533OOb/nfduerdrSbiIialjIRxSyEb2tEa25iI22
iJw5i2I6Ik3TdERvIBNRlf/QbzToV8z9zn1oMnfa81uIWOFvtkecdER8yIr8
P7sK9N18zF+X581Xdled15ByV4XeylfppWyFlpGULdIbWYleyBboPJplR/w5
56yd57IMnTUf8ofNJW969LZe97/SNzzhBc9IeF/OnhndaTQW/UYM6adoC5qQ
RDO69Lv1y7rL2LO/jz+qP4ZT91b4+/X/iD/pPQ/mKXpWfzdvDhP27PC3Me58
pr/o+wO7B3Gne48P+Se+cG33P00fMaY=
          "]]},
        RowBox[{"-", "0.336`"}]],
       Annotation[#, -0.336, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwV0DlKg1EUxfHrgJrBjIJoZyEIBhwCWglip4JgEkkKp6SyimDrUFjpJgQ3
ICIuwC047MIpTr2/FH/Od8877953v4nWYaXdExEHaKcjFocjFjCajZhKRRRo
EblMxEYuIkUn+QleEgn1EArJiAE6iIY+/bTeVZmOfn+FiJbMw0jEr+97vXbz
ETv4Vv/gCx3cOcubse2spscn7wO3/Cy/wa/y33lvuOFXeRW8qpvmXJpzgbKz
imyf9/RiXb2G1e4uRTtgzvuyNIc0MhjGmPy4Xg3ZOkq8aSzJz9MyZrr3MYuS
/L7cHrZwbu6K7JEeLXUTyzI1O0z5L5vOTt07wzGu5E/ooz2e0JF/oc+45v8D
xrYuwA==
          "]]},
        RowBox[{"-", "0.384`"}]],
       Annotation[#, -0.384, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwNzz8vQ3EUxvFjYECrV3sNWv0TjSBpCZpY8QakiMUkqhSt1CSx2SXMLHZE
xMqr8H58hm+e3znPuc85t3Y8aPdHIqKD+njEYjYipbu5iM1MxGAyoqCXR24q
IkFLfwOp98JERIbXM1fOR1zQGq3rj/Hn6Sj/qRBxk/DU37KrdKh+1E/sG3j/
el/TL36fXiHHO6c/vB795JV9e+b9oNelc+oP/RKdtrvjhoSe0HV3rmFGfarO
0xQFlNxVkj9Li8i6N4MVOQ1+E8uopHbi0mwRDbNNVM1WsCN/39wB2ri3Z49u
mdnGi/pW/UyX5NzJWEXPzYf8rn0tOUdyXs29m/vzX2/0H+3oJPE=
          "]]},
        RowBox[{"-", "0.432`"}]],
       Annotation[#, -0.432, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzskuA2AUxfFrSylRUUPnIm1ISIyx1K2gK5WwkNCK1hDDws6wZ2HPA3gC
ESHivfws/rn3nnPu/b7C/mn9pCsi9rDSHfGA6aGIGbwMRrwlIhp9Edu4Nb+a
b9R73KHeG1FJRlRRk1nDlBsXKLlRxobcFjZR64lYUpfR6I94TkVkZDvIyxYw
z1vEAmblk27PqRm3d+xkZbP6HJr+s057dOcJB7xhe8cDEW2889Lmb94hb0Tf
snPOy7n5wR+ljeGIfkkv0j/p47Qfe017Gf0V7xpfvJz5l9f6/7c+4S8p/2y7
kdd31LJaRElmQp3EGT0tt+qNinnXrT/qsCUv
          "]]},
        RowBox[{"-", "0.48`"}]],
       Annotation[#, -0.48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwN0MsrxGEYxfFj6y6XDcWMpFihMCg2dlaKXDeyHhsLYgyaIaxdimLF1l4S
8X/5LE7f9zznvE+/31vY2VsuNyRZoWpzstCSzFNfWzLXlPTiiflwa7LVngxi
ybzHfBoL/ENXctORTPLfOtfOV1RsTC7wV36JX7I61qggO8Mf2Tl+yk6xSgOy
e/MT5wk7P2TjWOHvzJf4Q99U7E5mO5M//lh2RCW+7H4/3epuyg50Z8wX7VjD
Or+KNRyyY1/3SfeRdvUvzNflK/qn+MxXcVR3hCr6Y7Th3zdpyltM0rZ3e9V7
oxd6d+8fhjUpvw==
          "]]},
        RowBox[{"-", "0.528`"}]],
       Annotation[#, -0.528, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], LineBox[CompressedData["

1:eJwVzk0rBFAUxvHH1luED2ChRNiY1MQwzAw7hVJiFmwUzVh7KcVkiE/Axsja
tyCUz+Q3i3/PPf97zr1n/LC51ehJsomZ3qQwmEzI+lBSHkiu+5NpbgobI8mZ
u5/RZN35T0+xL3kaTq701bgqfvkF/pG/5CvcGr75At/mL/hVrowvfp6/4ZfU
i2j6p+T/c30l9QqWMWePSXfPej/t8dJN8zXz++7b+vfknayar6CuflDvynt5
0N3TO6fmTnCEV/6W39a/g463G3yHb/HH3n+XH+q37h5jySxadiniH6TfJt4=

          "]]},
        RowBox[{"-", "0.5760000000000001`"}]],
       Annotation[#, -0.5760000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3250, 5028, 3251, 5036, 3422, 5033, 3249, 4205, 4220, 2619, 
          3676, 5001, 5002, 5000, 5004, 5003, 3413, 4998, 4999, 4207, 4208, 
          2610, 3654, 4963, 3212, 4955, 3213, 3398, 2677, 5414, 3211, 4959, 
          4962, 4961, 2887, 3866, 2888, 3632, 5277, 5278, 4509, 4510, 4296, 
          4512, 5319, 4511, 2601, 4514, 4515, 4298, 4518, 5320, 4516, 2602, 
          4519, 4520, 4301, 4524, 5321, 4522, 2603, 4527, 4528, 4303, 4531, 
          5323, 4530, 2604, 3635, 3636, 3870, 3869, 2894, 3638, 4197}]},
        RowBox[{"-", "0.624`"}]],
       Annotation[#, -0.624, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2620, 2694, 5424, 5425, 5032, 5035, 5034, 2921, 5005, 5006, 
          4209, 5283, 2611, 2686, 3883, 3884, 3655, 2902, 3887, 3414, 5007, 
          5008, 4210, 4211, 2612, 3656, 4966, 3214, 4960, 3215, 3399, 2678, 
          4964, 4965, 4513, 2889, 4315, 4967, 4968, 3216, 3633, 2890, 3874, 
          3400, 4970, 3217, 4517, 5279, 4521, 2891, 4300, 2892, 4523, 5280, 
          4529, 3220, 4973, 2893, 4320, 4974, 4975, 3221, 3640, 2895, 3876, 
          3402, 3403, 3222}]},
        RowBox[{"-", "0.672`"}]],
       Annotation[#, -0.672, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2615, 3663, 4199, 4198, 3404, 3223, 3641, 3639, 4977, 2681, 
          5326, 4976, 4319, 4533, 4532, 4972, 2680, 5325, 4971, 4317, 4526, 
          4525, 4969, 2679, 3401, 3219, 3634, 3218, 3873, 3660, 2613, 4542, 
          5324, 4543, 4316, 2904, 4541, 5286, 4214, 5011, 5010, 3415, 3889, 
          2903, 3657, 3886, 3885, 2687, 5285, 5284, 4213, 3235, 5009, 2922, 
          5039, 3253, 5037, 3252, 5426, 2695, 4222, 4221}]},
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3255, 5038, 3256, 5041, 3423, 5040, 3254, 4212, 4223, 4224, 
          3677, 3678, 3236, 4216, 5287, 5288, 2688, 3888, 3658, 3659, 3891, 
          3890, 3416, 3417, 3237, 4545, 3238, 5013, 2905, 3875, 2906, 3661, 
          5290, 4547, 2907, 4318, 2908, 4548, 5291, 4550, 2910, 4321, 2911, 
          4551, 5292, 3662, 2913, 3877, 2914, 3664, 4219}]},
        RowBox[{"-", "0.768`"}]],
       Annotation[#, -0.768, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2621, 2696, 3896, 3679, 3680, 3899, 3898, 3424, 5042, 3257, 
          4215, 4225, 3681, 2923, 5014, 3239, 4218, 5289, 2614, 2689, 5012, 
          4544, 4546, 4325, 5015, 5327, 2690, 5016, 5017, 4549, 2909, 4327, 
          5018, 5019, 3240, 4552, 2912, 4329, 5020, 5021, 3241, 3665, 2915, 
          3912, 3418, 3419, 3242}]},
        RowBox[{"-", "0.8160000000000001`"}]],
       Annotation[#, -0.8160000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2622, 2697, 3897, 3682, 3683, 3901, 3900, 3425, 5044, 3258, 
          4217, 5294, 4566, 2924, 4326, 2925, 4567, 5295, 2624, 4570, 4571, 
          4328, 4574, 5328, 4572, 2625, 4575, 4576, 4331, 4579, 5329, 5455, 
          5454, 2626, 5297, 5298, 5067, 5070, 5069, 3271, 5073, 5074, 5072, 
          5300, 5299, 2627}]},
        RowBox[{"-", "0.864`"}]],
       Annotation[#, -0.864, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{2623, 2698, 5043, 4568, 4569, 4339, 5045, 5046, 3259, 3684, 
          2926, 3904, 3426, 5048, 5049, 4573, 5296, 4577, 2927, 4330, 2928, 
          4578, 5068, 5071, 5427, 3272, 4351, 5333, 5334, 3913, 4353, 4352, 
          5076, 3276, 3915, 3914, 3922}]},
        RowBox[{"-", "0.912`"}]],
       Annotation[#, -0.912, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        {GrayLevel[0], Opacity[0.5], CapForm["Butt"], 
         LineBox[{3902, 3903, 3685, 3260, 3427, 2699, 5047, 4580, 4581, 4340, 
          5050, 5330, 2700, 5051, 3261, 5075, 3273, 4350, 4354, 4355, 3274, 
          5428, 5429, 5335, 5336, 2706, 3917, 2707, 5338, 5337, 5431, 5430, 
          5446}]},
        RowBox[{"-", "0.96`"}]],
       Annotation[#, -0.96, "Tooltip"]& ], {}, {}}}], 
   {GrayLevel[0], PointSize[Large], 
    PointBox[NCache[{Rational[1, 2], Rational[1, 3]}, {0.5, 
      0.3333333333333333}]]}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], LineBox[CompressedData["
1:eJxFxXss1AEcAPDDVnlOltPPjOiyYWKcNhWpRNJV7oiaZF7LKFq0rtqadJY8
IlbRaXROJXMnKpXH4eZUdJw7brrunM77cjHHZh7VH77fPz77OMal0RMNSSQS
7Z//n0icGhBMR/hvPll/Nk5FUA9tTjaVFTYSgfBe3x3cCiIc3t/vzX9EJMCC
Z10+BUQGnJ2Vd+MBcQ9OyNARuUQpvK00pOrPfDX8od8rONieB0dlK0a68prg
tIZr7k8XP8ILRUM9BgbtcE9Hd7v4YCeczAwxP6cVwh3GXht1l0VwDUe4brvn
KxxAbn3BqO+F3UWK5m5XMSwNYMy9nuuHU01SJDJPCfxNHtlqUTgIM4Ki1BqN
FN5XmRdZSRmCR9dLpJfuDMPjIWIOuUsO88tUzAHHEZh73yjX5eYPWB9/fibp
swI2DcyhN9go4duW42bqaBVs1uZGGqaNwn7XT691reDs6nzObrYajomg9hmH
jsHvZIklbUu4by/fcOLxL3jXsSR9SaAG9qH6FDdN4KqFgi8c1jis9Q5jEV4T
sPOs+4zBIC6kZErSsybhh1JZPJ0yBesYgmJDIf42wvqo79VpmNOXXTFmNQMv
i6JvWXXio8Xtessrs/DSwAHiroUWTi91EjBbcJs+J0tNzG+YIatbtVvHFy5W
pSpq5+D2WB7L4qQO/iRODVWewt/7u26vD8Pr7LhsWiReLi9vzI/DM8/kqE2Y
uFvABb+tNbgzz9Zo+BXuZC/vqXmD71ylhwc14Fuaj6ewWnC1B7XMaBBXPJ+P
GZThcnMehSPHv8+68I8o8ZaXDqKsabyZ/DM/TIs3ssrpjjq8Nt5aKVjEuRIJ
p2gZrzxclBy7grP5NA/PNfyJg6l+YwP/CxUIhds=
      "]]}}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
     1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJxdlnk0lG8fxkkyUgqlLC2WhFJKpRRXZKlkTRtGIUneJFlqqFCS5SfiR6KS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      "]]}}, 
   ArrowBox[NCache[{{Rational[1, 2], Rational[1, 3]}, {0.5333333333333333, 
      0.2333333333333333}}, {{0.5, 0.3333333333333333}, {0.5333333333333333, 
     0.2333333333333333}}]], {{}, {}, 
    {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
     LineBox[CompressedData["
1:eJwV1nk81N0XB3BZ0iMqS6V4bGmRJZFI8ZGkRYrwiF8JD0+JkEoLspQIlcqu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      "]]}}},
  AspectRatio->1,
  DisplayFunction->Identity,
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic},
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.653485734128807*^9, {3.6534857886017017`*^9, 3.653485839721409*^9}, 
   3.653485874638632*^9, 
   3.653485940304145*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"k", "\[Equal]", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"2", " ", "x", " ", "y"}]}]}], ",", "y"}], "]"}]], "Input",
 CellChangeTimes->{{3.6534851159709*^9, 3.6534851697418528`*^9}, {
  3.653485237886578*^9, 3.653485238107044*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "k"}], "+", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{"2", " ", "x"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.65348514818215*^9, 3.65348523955121*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lagrangian multiplier approach", "Subsubsection",
 CellChangeTimes->{{3.6087519743151693`*^9, 3.608751983096745*^9}}],

Cell[TextData[{
 "See  class notes: the solution is the same.  But, here\[CloseCurlyQuote]s \
an example of solving a system of equations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.608752010844163*^9, 3.608752043651273*^9}, {
   3.608753236781708*^9, 3.60875329377427*^9}, 3.608768702622737*^9, {
   3.608768740370783*^9, 3.608768767906827*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "-", 
      RowBox[{"2", "y"}]}], "\[Equal]", 
     RowBox[{"\[Lambda]", " ", "2", "x"}]}], " ", "&&", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], "x"}], "==", 
     RowBox[{"-", "\[Lambda]"}]}], " ", "&&", "\[IndentingNewLine]", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"x", "^", "2"}]}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "\[Lambda]"}], "}"}]}], "\[IndentingNewLine]",
   "]"}]], "Input",
 CellChangeTimes->{{3.608768788014978*^9, 3.608768790692397*^9}, {
  3.608768869089465*^9, 3.608769038025395*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["1", "3"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", "9"]}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", 
      FractionBox["2", "3"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.608768979438236*^9, {3.608769032223048*^9, 3.6087690401534147`*^9}, {
   3.653243697493577*^9, 3.653243706436304*^9}}]
}, Open  ]],

Cell["\<\
  Let\[CloseCurlyQuote]s plot the boundary and the particular temperature \
contour to see if they\[CloseCurlyQuote]re tangent.\
\>", "Text",
 CellChangeTimes->{3.608768777333613*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"peakC", "=", 
  RowBox[{"myT", " ", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1", "/", "3."}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1", "/", "9."}]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.6086604069897623`*^9, 3.608660410078549*^9}, {
  3.608752080184223*^9, 3.608752082460306*^9}, {3.608752170532362*^9, 
  3.608752191854424*^9}, {3.6087522441829987`*^9, 3.6087523293229303`*^9}, {
  3.608752362382616*^9, 3.60875236462043*^9}, {3.608752483348316*^9, 
  3.608752484042136*^9}, {3.6087525187022247`*^9, 3.6087525198117037`*^9}, {
  3.608753310435689*^9, 3.60875335474092*^9}, {3.6087536551794147`*^9, 
  3.608753657688941*^9}}],

Cell[BoxData["0.037037037037037035`"], "Output",
 CellChangeTimes->{3.608753437966165*^9, 3.608753582255144*^9, 
  3.608753660702558*^9, 3.608753727026984*^9, 3.608753867010222*^9, 
  3.6532436619524603`*^9, 3.653243706539961*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"myT", "\[Equal]", "peakC"}], ",", "y"}], "]"}]], "Input",
 CellChangeTimes->{{3.6087535473109617`*^9, 3.608753579901182*^9}, 
   3.608753620473072*^9, {3.608753665426375*^9, 3.608753667936195*^9}, {
   3.6087542449195967`*^9, 3.6087542478767757`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"0.5`", " ", 
       RowBox[{"(", 
        RowBox[{"0.037037037037037035`", "\[VeryThinSpace]", "-", 
         SuperscriptBox["x", "2"]}], ")"}]}], "x"]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.608753584929853*^9, 3.608753628093335*^9, 
  3.6087536687898912`*^9, 3.608753727212843*^9, 3.6087538670765343`*^9, 
  3.608754249194599*^9, 3.653243664439681*^9, 3.653243706617791*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myMaxContour", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"0.5", 
          RowBox[{"(", 
           RowBox[{"0.037037037037037035", "-", 
            SuperscriptBox["x", "2"]}], ")"}]}], "x"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Red", "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{
  "myCP", ",", "myPoint", ",", "myBound", ",", "myQuad", ",", 
   "\[IndentingNewLine]", "myMaxContour", ",", "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
      RowBox[{"Point", "[", "myPeak", "]"}]}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.608753446230645*^9, 3.6087534555589027`*^9}, 
   3.608753491076269*^9, {3.608753915337932*^9, 3.6087539656247463`*^9}, {
   3.608754089345265*^9, 3.608754187461939*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Power", "::", "infy"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Infinite expression \[NoBreak]\\!\\(1\\/0.`\\)\[NoBreak] \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/infy\\\", ButtonNote -> \
\\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.608753949014145*^9, 3.60875396691037*^9}, 
   3.608754100160103*^9, 3.608754132875679*^9, {3.608754174589177*^9, 
   3.6087541885427847`*^9}, 3.653243667767549*^9, 3.65324370687498*^9}],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJyEfQVYlM/zOGAndmB3dweOLQa2Ynd3t9jdmIgFBiImIiIlndLdF9wdHMcd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    "], {{
      {RGBColor[0.148, 0.33, 0.54], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1ULtOAgEQnByaeHJyELgPMOETfHTS0dH4CRJa/RA7+AXvG0xAaqKtJso1
YKKFpYkUNIaZzFJsZrM7Ozu7pzd317cJgC6jxqinwJb4w5gcA7/EQQ68ZEBF
Yq0FLBP31zC3wZlPYp4618wXeSviYxvIUutqftkxryKeFa5Ju0xd34SedKUz
PAEW5DyR896x1nlhzkPsLSNXTV41N6b3JLz+N61dBqdHzuwAuMo9V8bey8I8
efyIXdqpeek808Or7jkC5plR9f0f6nG7MItc/Sr+pRt0y6jhmniq77Vmbf9L
f7un/ynzt0Pgr+lQ/s2b+oX9XhB3UYhFdQ==
          "]], 
         PolygonBox[{{3685, 711, 1211, 3903}, {2700, 224, 2311, 5330}, {4355, 
          730, 729, 4354}, {5429, 2316, 730, 5428}, {5051, 2060, 224, 2700}, {
          2706, 241, 2316, 5336}, {4581, 1492, 223, 4580}, {5338, 2319, 241, 
          2707}, {5330, 2311, 1492, 5050}, {3273, 729, 2060, 5075}, {2699, 
          223, 711, 3427}, {5430, 245, 2319, 5431}}]}]}, 
      {RGBColor[0.18832000000000004`, 0.35240000000000005`, 0.57776], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUbtKA1EQnUSN+8hr2d1OUL/BF1bptcsHWPgotEhs/QELtVL8D0EUH71E
CAhGJYrZZEVBBCt/wHM4t7jMzJ0zZ87MzK63m62imS3jjeEVI7NsAj7sGj4C
z+wOgOtY/hVsB3EI/7RglsPvjJsNYfdLZr7DPybCHAVme77ZDp4Hvp+66tqh
csTcgnMb+Rn4I9TexPonB7W8431D2yT+SsD1EDdrZr/4W4HtAT+N3H1Z9eQh
/iyRlgFm6cOvoPYYPfuIB8ifo26jojkPA8X8PwjUM/DFc4K4Dv8t0Yzk5AzU
Qk0ZMJex/ItYtdTDPc2nmm0BtoWZPexqsyqs52q7bqcfkXZJnZzDqBNchUia
qK0B+5JI2zNsBzNPgWcu1Q1YR828A+eiVuapiT2eYnGSO4+U5544H3vzntRF
ndS2WhNvt6wcfe79r647vEbqzR4PsW7MWxO7G2pPvDlvkrk7LqXCLKbC546T
uoZO/2ekXX/BNmrSs1WVxpHT8Q98RWV0
          "]], PolygonBox[CompressedData["
1:eJwtUUsvQ2EQPb1tua/Sm9u7k2DhH3jssJIgNn6ARbFg0dr6AzZ2xE/xbG2l
pIlFPVpxS4XExoo1zuR08SXzzZw558zMeLm6WnEATPDl+LIR0M0DYy5wEwJL
w8AX8y8ELTP+YH1vADjKAD9F4KkEFD2gx3qH8QoxjZxyhz7wS8xzXpwOe++J
8T3l/lhbJP4Tyj2UxGFc2/zPJMABOQqeOI27GcpLyv67GHgk/tURps24xlxA
7w3mLol9ixSb351AmqY9YhjWywVgLQvUyT9P/s0hwM3pX2e9w/4W8Sk9thlv
9Osu+2usVwNxX1GjF2kn9jcPF/QyxRm2PHk0r/u+9DzWT1k/4/Nd5czLLD10
IY05xrdx3yv7m7FmsniUuVYsD+ZlkO8k1s3sdqY5Se3pRLvc5VtIpGnadsP3
SDPbrKZX4SzHsbhs5m/Okom0a7uR3eo6lLbt0G5rO7J+879O/2mkXdhM5+T6
BwU/Wao=
          "]]}]}, 
      {RGBColor[0.21856, 0.36920000000000003`, 0.6060800000000001], EdgeForm[
       None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFUssuQ1EU3aWVtrd63ZxrokmTfoakpFMkJOYGGloDWlNDr4EYEp9BaAk1
9IhBi4pHUa96/IA51s46icHJ2nfftdfee52TyhZHC20iksZpx8lFRD7CIndI
toALHSIniKeQ/8R3A/Eq4h7Ey/j36oksAV+AbzYuOqzR2vWASLaTuG9Ebn38
C4oMuCJ56JwGqak9c1a3gtwYhjlGfs9Q6zCGWugfId6ERiJMHZ3zCpwkvuvA
jPvfsxdxEzutRFmvOhNxkbMY6367RL5w1sCfdthzI8S++k85N+g1jz1CYfb+
tvxdw5knI+TNOMyrnuYS1sNHjz48AIe76d0IMBOlv1vQH3LpwyDwGrop5Ksx
5tSjH+hcgrcInWeP++ssc+iVjXNH3fXAkPMETsPj3PceecqvQLNsuOc4/Kn7
vMN3jx6pTj9wx+du2z77673rDCWfcdneYdK+B0V9HxrXgpxb+Yopy9G6vOWo
lzqDzjTrcIaWnVdz6mPa5TvoA1YN38UFsOlxR/VD35DOEUCu4PDe9f5rhv6f
A/8AQLB3gg==
          "]], PolygonBox[CompressedData["
1:eJwtUUsvg1EUnFbbfP1U68vXbkgkXfkBtsRrR0LSvYV6xIL6DV4blsTf8GgJ
3VIkWlRo6x1FYm8v5mQsbjL3zpwzc85NZxczuSCAbp4QTzEGnPBhogUo+MB9
EqjzXiJZI55vBTYD0tQ84JKamSjw6QD75A988SXyh8RTceCU+Jm9s8Q3fJuj
vov6W+KAp94NC0HckwJmo/K8YJZrajocvRl3xXunI0/zno7La4ueOWar+upt
Pc9jOoatpkJu0AU+iFcizES/vaSym8eQqwyWJc37HfU75JuOPOrkyjFxZ+w5
mgBGEsIVngxxnjVh8kvs3/BUY7W2kwXme+N9NaIMlqXA/l+OdmK7eSS/HJHn
gKtMlm2D/Bjnf/GU3ep3Wbvu6q/M07z7mKEY0s5t9/3kt8PSmLbJ+rWIepap
n2wTZzW9rB2m5jeoTHn2f/33s/1+twNHvrC9HfvKYFlspndqHzzNbvP+UD+e
UnbzrCbVw+ptxidq/wALtGRd
          "]], 
         PolygonBox[{{4331, 4330, 2927, 1668, 4576}, {4579, 1669, 2928, 4330, 
          4331}}]}]}, 
      {RGBColor[0.24879999999999997`, 0.386, 0.6344], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUztPVGEQHXFf3F129+a7FBQU/AljeCQILdFAsYVgYHdbhIpAaBQrEzoi
b62NFeFRLFZCMJqwuwIFJEAAQ0yMhkdv4zk5X3EzszNn5jtnZratND4w1mBm
ffge4vuVN6vGzXZDs8EmswKCz2HvkmbxRrM6cjfwY/Br8F8nUAf/B2q3nFki
ZfY5I8wtvgPEZ+OKzz0w24jMWuDvO/W48ZiewOwQdh35D07vvYdtTYnDEXLD
WbMz2Mc5YCPxedZs9g/5vZjZMYS8DYTpgv0CDXX479DnT1I8yGEGGneAncwr
R8wM8Bvwh9BrBHorMfnEfYpUOw18MasYe5TgJ4ErZ6V1KiEtnN+rhPqeh4o9
Qf9yWlz7gT8OhRlF7GmztHMGP1N6i7UHXv+W18qZEEd77/12zGIbHDpy0sC6
R7A1p3l8y0gnOW/DP/I92Zt7IB/iVp12sQK75LTPN4H2RFzdaQ+sJb7stXfh
3bNQt/A7r37Ek9vLtO7jJNQs53lXDeLL3/SpgzXEc368L86LvPnOId79ivoJ
5Jad5sj8JWIfM9rrAuIv0sIQ2x2I/yn8zUi30xsoT57MkTtnwnvgPfFmeDtX
oTj8hZbOnPJF3MNIWvy+h6qt+HreXcHPkPrZ/8LvlrvkPhadboL/Lc6CM1mL
9L+hX/Xv8d3rUP02Y+L9H79hlIo=
          "]], PolygonBox[CompressedData["
1:eJwtkjksRHEQxsfagz14L7sKhUKvljijVBEKhSPsKl2VBA3RiU7ipnYUhN3C
qhCFwq5dhQJxREJIHL3Gb8wWk/fNf76Zb45XnRjrHPWISA3mxVIxkaoSkWtw
EtwcFFn0ifQWi8yBXx2RS/wZv8hISKSWtyzced524O/HLHbFWwux2aDh4lK+
xDrKRH6p9ROAHxa5cEUm4H/hb+M/4Geo5YWfg/+Cn8X34efx3xyLj5PTh/6t
a/X17Q78iOXEcp7A745h1RiAP+VYrx/obYVtJp3tiOHrykUasDT4jKUM0Otq
1LRUYwV85tr8OvOJazmaG8AS8DfgfAdMU7Xz+Deewk7Bu2gm4Xah2RNBI2L6
qllPrVbs3Gs7GqTf7ohx9U1jk4X+n6m3F7Metdc7+ukHp6l/6rGah+gNU2Pa
bz3r7XTnunvtcTNqO/7fNfn3zLMUtd0sFIkMhUxDtbTGjWs31FtqvWW4Wayy
xGbMgOMRy/XzlsI/gJ8X4xzG7MZ6609snfhx2Lg6k87WXlG4NTlt4KZy263W
bASvRS1X763/gvaoMZ05zvx/iXFyZA==
          "]]}]}, 
      {RGBColor[0.28026, 0.4022, 0.65432], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUssrxFEY/TAemd/85jf95h+Q7EVZsFZShFIYzGCpKFmxIAuP2cn7tTXj
kbzyWBHCRtZSymoSf4RzOndx+7577/edc75zb9XweNdYsZk1Y5VgFcrNsqVm
y0VmP4HZIuJuaNYbM+tGQQ/iH2p+sc7QmML+EvHQM8v4ZqURs6a4WV/UbB69
1chT6FsB5j3qdoB1jpj3VHuNdYf9RBn4ytXz7XgHgXGYFE8bsIexX8J5DTAn
A/VdAWczlKYtxMeE6tm3FgpzHzUH2H9WmDVUQkdCfA+IaaeZ2keBX4Z8HX0D
2EeQzwbiI+9QVPNQYy/yPDA/gJlLqm8VM77Bw9NQM6djwqCn9HM6kFcdwK4D
zjnu6uPyldpOi4WRdTiMxGfe4jT0AbM2rrNZzHIM7gv0vWCWo6S8fUKeicpD
vuGgm4Uz0W9qo3fkJzd5bzy9z0koP3hPzdzz/Br3OU+1U8D8wlrAfQo8M+4t
+CYj7o2odyCqmkKgPnpE3UO+cvrNGSMV4jrwNEunLzxq5jl9pOYzaGn3VcO5
G+O6z8T0nzj7K2Zv9cVDn54TOqc3Bad5m38wFO8t+vqdTs7Ev/Pr/uF7Uvkc
fN4LxUuNG6HOeZ92PvPP/gPOlHpt
          "]], PolygonBox[CompressedData["
1:eJwtkskuRGEQhQvdiNvdunO9gL0ViQjxAoQgkdBttiexITaGhWkn5mmHZkcT
w8o8bDyAWAvCQ/hOqhd/UueeqnPOX/+tHBrtGCk0sypOhHOfMhsrNpsrMPtM
mtWWmX2UmnUWmc1QP8GfMjAP3xuYZSvM3uGXomYT9E9yTgp95hiuOeH4De0m
6ppys1zEv4lr55xRL6I3jN4r+jnwAngAPF3ms/I4Qi8TuLcyPNA7g98q3sVo
DqK1HzP7KuEu4D7wbuha8tij7or7XZShmix9gfPyfEZvO3R94R3qdNyznYMz
1C8p19JMP7NtCefUM6S8Sfe+4dsUdUvCs2qfafiLmHMZMpyg/5i/rzx74BvI
FGV+GVxf7jtX3m/utEp/I3gl6vML1Acx59TTTb7BwLMoYyve40l/G+1Iu7qm
P5J/L3F3+feWhrTq8LyMeIb+hL+perVT7Vae8laPetdD373eMws/C/9L7x9n
E+409P5b+Cv4rdA57UT/ku4kb2W4Tfk/p11JYwOuO3D8A14DH8a8Vr+yD8R9
V7pTDv4f0Pxo2g==
          "]]}]}, 
      {RGBColor[0.31782, 0.4154, 0.63224], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1U01PU1EQnZa2FN7j9d08+AH8AF3UhfEnIBWIIdECwdCFxmgUoimwQNiY
uIQSQly4kgIbKCRA2CACxo+EvQnhY6X/AL82ek7OdfEyc+fOnDlz5r7OytPb
T9JmVsbXhO+jM6vmzIYDs9O82S8E3yO+kJj9hF9GvLMgvxSZrbab9cOfaTU7
ySveAGC5TbYeml0itg7/GDirGbPfOL/BeSOj2jX4e052GXgTsfJX4D8Hl1SL
2YGphrWH8Icj5SwB/1lOXMmT9+d55RCLmFXgjeXEj5x6IuWNYJYi/NeI1UL1
Yb/PWWGM54Rz3K76fXBMtyj+JSttWMu+1OwsL56cdzMjfj/8fC9Twmh4fxf9
mpC/CV3HEvWZhIbfms1eAXs2pVpqxPpaVnFquIXaCngUO8weJuo/jtp5+N9R
X4O9H0uvEvbwNhTuXCK9yIsaU3vmE59c/jarb7EgjndR+wJ5c+g7BXvgxH85
1F7pM3alIF7TrcJIA+sE5wb6Gfxtz5d3jNMyzl6cKeX9jUT+DvJ7sZc/4PcA
fR8n0nUC+NcjaUXNRhPt4QI5p7HnHEj7fv/mpmNpNwPbFWk3VwvaIXdJrKFA
e/+AWerY9VdwWILtjrSDa8h/lOhdnMWyfHPUnTtnLfmRB/lsO9mqj79z2j3f
0XyoN1P08/F/4J4qgc59iHe1KYe5R069BnF/JxB/zjEQ6P3dgn/T8yTfekb/
IOv/c10Hxr1AM39y0pwzcmfEYA3zt5z4Uu/FULxuAHPNaVa+Nb4nxnn/D+21
qtg=
          "]], PolygonBox[CompressedData["
1:eJwtk0lrVFEQhatfosb3Ot3v0e0PCOJS0YgE/QeKEyKYOCTYCwUFB4yJIphs
RBcuTMSFC1caDWp3EojDxlkcQN0KIQZc6D9w3Oh3OFk8uHVP3TrnVNXrahzf
dSyJiE187XyjecT4kogPnA9UIrby/WqLmOuI2JBGbCP+TTxPfLce8bqIGFwa
8YX4HvF9vgXOf8jZXvGdsCFy3pDbrEX8WxbRWB4xW444Q80XcJWIP5I7kpr7
M28miAc6I66UwImneTvOm+uJNXVVibn7Tr3dxHvIfQSedJijBbYTDX/BLuPp
HN6OZK4X5EyBPyy79iXwwdye5O0Uel+h91bdWoSfzt0D9eIk+FPwIe6aiTVc
rbmGctXDEc698F0oOedJ4RrCv5F/s+wey28LvJ/zaGov0wxjLf5ukzO16Pda
zR6Fz4CvA39WWIs45qm9irvJdntuwN2fuffv4fyau6Zq/wTfAl9f5toT3K0E
e1A4VzOZLTwTzeYdd0fhP5h5tuIQV2txnm305HHZmqTth+ZBbqvw2+fUa3Lu
XuHZzxFfxOtwakwz3Yy39VVrk59uzhvReAPsJTk9FXuQvmE8DVB/IXd97eD+
zDVVe4y782BnU79N4PyEl5matWoHtFu9neZSj/s4r6lau2ayWv0oe1fkUbt7
p+5ZaQaTnA/n7rU0HsrNIS5pPEH+vsy7JI3Sqh6r1/qH9oK9LexF/4z+nbGa
d0P6tKs9qXdXHDvw/x9nw48s
          "]]}]}, 
      {RGBColor[0.35538000000000003`, 0.42860000000000004`, 0.61016], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVM9LVFEY/dJJ613fNI87/QGuy2jK0KC9P2ZCMMhoJWKaE6kRaS6yTSUu
0rSIaJMxKdbkRKDLp4t+KVbrgpYF7XXVqnM4d/H87tzv1/nO+a7NA2O9o3Vm
NoivHt9l/NnExfwBsz84VzJmW7h/mZgNNJhd8WZPmsyeI+Y97pqPKGYRd6vw
/Ws0Kxw1O4b7XeRNR2at+GYOmt3MmV1DzDZivuXNzkSqXcqiH/KfomY//B/h
t8NmX5BzNfwehh1H/x+HgA/u78jfxf0Uaox5nUdhK6jzFnVuoVcZv4uYoTNG
PnI/I+ZZnc60U5hxJtLMp4B5CPH7jAeePdh3GdVaRq8L+H03EgfERQzLieos
NGlOznsadgi97yBmONgScj/A1xULzyRiOkKP4+BpPODnTL9yqr+F2jdwvo/z
nJcm5Ja6dMTiipydBO6fqP0ANQuodQ/+PvjX4UsRs+bF2WzAXAb+nUbpRw2o
xW3kfs2Jj6JTbcazFrGvZIT/oVf/ESeM1IM1l/KqVwXmMnz1iF/w4o+8kUP6
2Ys9yDF7sH4LMNcQdwL2ohMn5IZ5vxFfRdwjr/O8115wH7g3aSIMl5zuPoX7
zUSW+9XlpBn390VeelG3vYCLmnFXeH4FfzHWzN2xOCW352CrYbe54+SU3G4E
jrk/5KXPaSbqwLfBmckNcfEtERO53w78T+eUyx3kbnI3iK8WeOPs1D8N75H9
uQfEdN5Jy+vk2Ytzcr+WaL9rsI+9dJxAn/VE8Ruwg166TUTKSwMP1JV93sBf
ctKKe9GTlf5tiG/D+S+wnYXtcTq3Z7VznH0Rud1O8xayes/Uei68S/Zjr9fh
7VCTSl5zct85M/eDtdIwP+M5B+sQN/+X7Ad+/gPcD7Qd
          "]], 
         PolygonBox[CompressedData["
1:eJwtk8tvjGEUxo8ZNXTG95l87R9QsXNtSRB/gE5nkiYkJZYNHepSl6R0UTZE
LOiNEtuhwtBuatnpwj36BxDsSOxZWfk9eWbx5jvnPbfnec739gyPHbmQi4hD
nPWca50RHwsRnzjnsogfWyIm1vnuLP4Zznvs+oaIV+WI48WIi9gfOiK+k1sn
/rZg/xv+Kfxh4i16n8S+wt1tYk2GXsbenUYsMfhPPmKIXhPM/0z9GucS+XVy
Jsl/Q/1gErFXcexb3DW6IqZLEe8Knnma/Hv48/T+S78R/EnqW/gn8K9j36D+
KPYiM3cy+yp+NW9O4ta/2f4T4ltTYxCW39ztT8xJ3MSpAt4mGjzOWaMa/gKY
vmy0JivEXoNnhXiefkvClxn7FPl3sXu7I/7R/yuc9mD3MuNX3pzEbSZz7Ut6
NEreiXYzSv9l+u9IrZ002Y7dn5i7NN4Ht/FOay9NDsPtIT2e0a9GTg3/fOZe
4nCf2BT+z4I1GiLe18YjPeaIb0tdLz0G4bsG39gUscqnBZ55chba/avUv8jM
VRyb2DPEH+Ws8Sj+rtS70P9QSay5ZmnmQNEz5Su/Qr9a4lkN7npS/0OqFebp
zJw0W//MCLEDibFqhw/Uq8tait9T7HFy7nR4Z9rdQLteHMW1r9v/jna4TH21
6F2Lw3P4Lpb9FnSntzJbMjbhl3biJHw3iR+j9mAbj/prF7OZY8IwlxmjsOoN
jGXegbDqjeitrJb9/0lzaf8fHimJfQ==
          "]], 
         PolygonBox[{{4320, 4319, 4533, 1642, 2893}, {4974, 1995, 4976, 4319, 
          4320}}]}]}, 
      {RGBColor[0.39294, 0.4418, 0.58808], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVM1LVHEUvc0486Z5M808fq9NUFBEm4I0JYL2Oo19gAshhEqdMQvUKKio
doVRak6gtSgtUqoZjUqX5SJd2MciaNGmRV/QH9C6RedwfovHvXPfvffce859
s71vpGs4YWYVPEk80zmzBwgc2GTWnjebgj+B2N6C2fUNZt2ILTizf4FZA/Z8
0Ww0ZXYBdhl5b5E/j/g3/L6E/NPwe9Nm9xP6PQ17Ki0/0aQ+bxCbjRSfgd0G
rD8Ypg0z/ML7LvgN5JxJa7YrqK2g7zu8qzr17se7y4gfCtWb+DWn2ThjFc9D
5O1HzynM+RG1Q3g/F6n2CezfpPblnj+KwhlGzhjyezaa7dqMXWCPJzXzZEo7
0N+CmS8ivwP4N1LqVUf8Q2w2gP6L6H8ir9pF9Bwqqu41eh/Mqtc1xF40aV/W
MreWEqevUD+IPi8jcVhOCm8Ne6wE8vdlhX0OfXYUxEcJmM9RU0XtM9hPsXhc
ht+R931QtxP5V5FfRmw9lmaPkVP3tZ3Y63egfakF+SDuCm6mMy9u72GXMSfN
xp1uhVxOwp9wqr8D+yUjfanliJPl3TV7fltgP2ekC7WlhtSFWNSNPFCbHqf4
OGoH/R3U4B8J9Z4a8ka4IzmroG49EC+8UfK6lNN9sw/7LUXihzxRh++BtGjL
Cr+E+3kUiR/ydBs1P5FzC3Y+EsZ7xBuRdKf+uwvSdU9B9807n0X8cKicBcSO
huJ/K3JuOuGO+v24P3kkT+SNed2hYvwuOefXjHSZi+W3Yt4B1K+S85x045wN
zxG5asEuZ504uZuTnqteU+7MGyYG+VvzN1Z3ukve8jE/M2+HO3P3p54/asx5
yRO1JN5MLB2agVsOpQPvtN8Jqx3xPqc5Tjp9S8TshV/yPr8z/i+Qh1bY/xIk
qYg=
          "]], PolygonBox[CompressedData["
1:eJwtk89vjGEQx6er7fLu7mvfvPZI4iKhPbQqIuGqXStImpAICdtqtZJ2iShB
XMj60WorqTigLUXtllA90gMOml6Kg6uoxB/g7ODzzezhSeZ5ZuY73+/MPJu7
Sp2DCTPby6nntIVmf9aYfV9r1hyY5bkv8v4padYbm53kLGJ/5oylzUa4r2JX
AbmFPcr5Xbufy5rd5v6LewLw42BtXG92pc5rbMJeiMz6G80u87ZC/AiYE+T+
xd9NbpXzr5bfnzKb3AAH4u8T8xj7Jf73CY+Zi72GYscazHbDv43zAy2d4F3D
Hk27FmmQFmmQlgL+jozZMhwuwaWbGjNwKxPzM+n5hzPOQfjSeBffC2JONXqO
cu+B9yXpb8/x5TPu09sZ4rfCYQU+RfxT+C8E3l9pbie2BEYl4TVvEt8eei9u
oGc7sXPk9JL7DYxp9L8i5ij+D+QsUHuA+3LS+3kArlez3gv1aEA2/uv4yryN
xz4zzUozuhP7zDV7zeQdtYYC781HacJ/mnOR/Afk9GF3hM5XmEeoNxh77Ye8
lbB34n+U8JkfTPmM5e8D/y3457PORT3YQa1mduJ1vWMKez7yWGmaSPtOia9m
OoP+cuD6i+vMWnJmraFzU88L1JtPu3bFVOBzora/x4gfxrcrdK7idyjlM9Ps
voI/BX4h4z5p2I+9LXCfYp4RWwRvqM4xu7CnI5+terSUdQzF9/BWwbeH/PEG
5yPuTYHPUjOtRj5T3aVZ2nti7732/Qn3s1nfBfVHu9ISuk8c8imP0V3193F/
U+ufMFVLf0C7rB430estOe+F+q9dFGfl6o9NkjsbOXdpkHb9AeXrzw/DrTXn
vVeP9RefRv53tOPa9f+WDpyT
          "]], 
         PolygonBox[{{4301, 4300, 2891, 1637, 4520}, {4524, 1638, 2892, 4300, 
          4301}}]}]}, 
      {RGBColor[
       0.43049999999999994`, 0.45499999999999996`, 0.5660000000000001], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVEtIVVEU3X2e93Xfe/UuR4cFDQrSqOgLVpalZgSCVgRhSr5hH51IUA1K
M781sGFp+fw8DcHfSCl1FCFoo6BRBAmNm9SglNZyHWhw2Pueu79rr312NzTW
3N1sZg9wtuCMBWY1eWbT0Ecjs4WY2XLaLAejnzBo2WS2EjdbhT4Bm4uQi/Bp
xv0s5ALOO9x/C+RD+4zTfU/S7IZTnPLtZt8h53H/Ana1+F6CXyf+D+FuGGfS
lKdvq9lj2DQ42d+EfIRY7bgrgl9lQnaHoFdB/wH9OPQZ2KzDfhz2ZTgj0M87
9cO+xtFfWQr+sK/DfRX6no8p7yXo72PqkXgsxoTJh3yzeny/gu+BArMvuGsL
lecXznP024W8vajtGmIupRVzBPaXkasaua5ANofCbi9ifEor/gxsauEzhzgd
iJHF+Qq9zQnbOY/z9W36Js4f06rzDXwLEXMKd7lItfz29bDvXKB/u3aYDQDP
nZDVecKB94XEC7ISuYoT6vkZ4pSmhDPxLklpDvehX3CqeQX5B53yHSyQP+M0
oZajCeHYijjHEsK3A3pRKCwnoJ9IqI4e6PtD+R5BLR1OHOqB3BdqJtlI2C/H
xZmToThD7qzF1Sd7GQ3EY+a4g/paUOfDtPiWDf73QFmC+H/j4hxznHWyOQN5
ymn+jaE4RdyIRYVTjnLIRsRtRfwmyHOeu6WQ63HZbHAmrblVJMT9Xr8XL30/
5BQ5zvpY02AkzpA7/ZHmyzlPRsKcfOlOCoN6p/2b9dxgbNbD+Ks+Hnsg77iP
xOtwKO5UALe+fO1zf774Sv/OpGJQ37BLiavk7C3/FmQgu/yMOKt7MWFEfLgP
3ItiyM9x5WbeYSdOTnhecy7kJ3ed3CD+5Cn5wDnuCRW3DrmmI3GDHOGcOW9i
RLw5P2L0xCkX94ycI/dO4+51pNjkEXed+8O+hiLP/VCz4sy4D3ybOKfbyPs2
0gzJ2asp4frUqXb2xr6o//G71u6EHXnR7WRPv4zHbSApSdzoy/lzjpwdd2gt
EHbkOPnAf2NO8af8u8IeWD//bcwFvuX+HeN79g+Mgd9x
          "]], 
         PolygonBox[CompressedData["
1:eJwtlEtIlWEQhsdLHvOc7Px8tQkKWhRRlFFa0MWy8mgEgtLKSskIgsrcRIts
kV28t6hlaXm8h+BtVZS6ylRyF7SKoKB1m1qU1vM2Z/HBzD8z79ze+bc23Khp
zDazKl4ub3eBWfMas+85ZiWFZk3o03z/m2+2uMFsf6HrrQQVIzcmzVrw/xwz
SyfMuoLZF+SWLLNO5Iq42VewegDftN6sjm+V6I+J78C/OzKryTMbJeYO+sPg
sffAbEWu5z3BdwZ7A/LZdWbVxH+knjT1dBFfTfww9mbiy/EZQZ4lfonaxrFP
Ue8c+gTydOSy+lki/gb9jWO/S45SsOeJeYv9DJjF1L59o9npHK+hE/wh4mew
rxD/nvgi7D/J9wmMPci9fFvOd8wefOfR/6BPoD9Hr6W+V/jXrqU/8F5Enk8+
8t3LTL/lOEYPenvCZ/WDbxeCz0izUo+p4D2qV83gIPUuJ70/zfQQ+rlMvjle
N7ELSa+/CnsJ9hTvJvN+jf188JpUm3ZUzjwGgve3ypvGNhZ5vlXqW6C+toTH
/u8J39Lgs0yjH0d+hn99nud4R+4p/FdijinsFP2+YTaz6JfQJ7H/jjmnruPf
lXCb8NXLseDY4lQRsc0Z/i2CcZhdXgzOFdnFvTp6eJTlmKPBOS1u3yJmW4HP
RLPRjlP4Xom7/y++DeI/nnBZ9fajPwjOdfnIdwcYH/K9x6f02of/cLZz9D6+
m+F8X67nrIp7zapNMYrdVei3pJvaiTwMxqT5jEcivzHZhbEFrDIwB2LOGXF1
LPhuVI961U60G3H+ZeQ3p9sTpyrjzllxVzkGsLdFzoVBMG5Tezpyrooj/ZFz
WFxWvt7Ib0a3o3qn0NuDz1433xH8BnWLQ7xTwW9Ut6od6V+xmIkXRyuC51Ru
9XQCvSnpty9O7GM+R4Pfomo4gnwgsz/9oy7jezJ4LtUrbl9L+q1oB1eR65K+
a82wjPn8AxKHwXM=
          "]]}]}, 
      {RGBColor[0.46806, 0.4682, 0.5439200000000001], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVElPlEEQLdYZZoaZ+fLNePGgaIgGosQFEEQWWYwGYmI8ACIxnlAIeOCg
AWSRYXNJPLgkEAGJSzAuB4MiXDQKQY13SfR/KBff8/XhS1fX9/pV1avqzrvY
c6Y73cxG8GXg6wibpWWapXyzJ75s+tqzze4C+BKYIawnsb+UZjYfMPsbNBuE
rwL4OeyPYS3FmU78/xY3O4H9IvxfE2YDEbNRYG97ZvW54hyH73BYfOtxcZKv
A/viqNlbxNwXQlzwbOLfLPDP8f8n7GFgUuBqRD6jnvzMecP0f9NhysHfhfUH
+FezVA9rqUEOdSi8Hf7HCZ0/C99KXPEP4twG7MuwaxH/N7AvwJkCbltMnEeA
6UNOI/BNeKqBtdQAX+J0+BiXFrTr4b8K/CPwlMMe9JVrYdKsH/4b4LkFnjZf
eTaAYxr7V8h3L3Q4D/8K8JPAPoX9B/YzX/pS5ysh5Ueb+S0EpCnrqQirhu0x
9W3Wac34rJ26DSPWKcT9BL4ypxtrvYd9L7Q7hzr6sP5y2haHpQ91KoiKvxBr
q6/+TiDP7rj4qTHrO50tLQ6FlRf1nvLkn8Q6hq8J9mfg+zz1qsyXbz0ojiFP
cziI9X5CdTSyj24+GJO9WnT92gldvuDsA2CP++oX+0Y+xiVng6/55JzW+fKx
Jwuwl2G/hl0UVS+q4FsLavbINepLk/mI4jA33pUBT7kxxwMhadwKjj1R5dWG
PPOiivswIS5yUtNqX72rxNoMXe9A9w8OR/xNT3euNkOxdiXV06PAD7hYjDmc
pZ6tmO4b+8L+LAH7Dl9vmvJgPruj4iIne9PsC5PCucpc+XvAuRrQeZ6dimjf
7iv+VlD3jDG/BxWXWM4t7ZYctzfVtZQpfUtjsktiypHzxt4XJFULa+Jccj5H
UPuFHJ1fdvd+2c0w/7M31PJ9QHlwVqvdfa/C2h0S946Q5oyzNQ7OmYRynnbz
/j+PNM0f8Ty35t6RGU93kvPAuZh17yH3c7569Ybz4PD9nv6zp8TsT6qGIqzX
I9Kfc5Ef0rvH94/3mzWSazQi7fKTqmM2U7jOuHrcFXfapOsNYq8W3N3fcved
ccci0qXF153hfF5zbxJrZr1N7k5wDv8BasrT+Q==
          "]], 
         PolygonBox[CompressedData["
1:eJwtk8tL1FEUx89kNuXMODP8dFVQGm4UCnpomflIxx4UQg/TTIlqUSnZwkVl
OaPOmNoDWkQLJTXpQVFtwh4a0UIjiPYF9X9Emz5fziwunHse3/s933Nu2dn+
o5dXmVkbZzUnFzV7FzZb4LQHZtmk2eE1ZitrzcqKzMo5X7GP4BsjtrXU7Mw6
sw+AzJOfoX4WoJYCs6aY16j2EPnD5HcVe+4COTVxs4clZsvEM/iGiOfI7yhw
zC1gHwNjOGT2Gz5Z8D8nzC6FnFOO/Bne+0XsJydNPI3v4BrH3ATWF/J7yW/D
N0lshff+EXtNr1Pc56KOPVhodo7cExF/T5gZ8DbEvZ8/cKoj9ibq/EP4nhBv
xdcD9hL1K9T34FuidgCMFrh3x7yfv/ieEruVdO3Ug3qpjrsWylHuZvTJgd9H
fHfENZE2F7hv595HzTBvLcI/RW4q4m9pZh3gfyJ+MeQaZKitxfcoz0e5ndzf
h71H9SqOit3njRT2roi/neVeBn5z4FxHubdgpwLXU/FW7OvoMQ9eM/zrqb/G
PU1sBl8589sWce7y3YRPU+D8Rrjvw65lRvcKvX/NPk39TH5/GsE7n/DZiPMY
sfGoc5Xmp6k/GfiuSvNJYlfAeIH9knOA2I+E9yPf/sB9immelfS3l/ts2DUe
hd900mepHdGunCLnm/nMtbv15M+FvWf1vpH3XhEfoOZBie+Q+GpGvdi5wHfl
OfWPya8q9re1U/orDYHvojAbse8kXWtpXIN240nXSjPYGXGO4ioNd3A/HnNs
zVN/ZSLpu64/qr86UOS78p37NPyqSv2vqKdK7IaYay0+2vX+Ip+lNKmDT0/C
42/JryA2VeJY6lGzGUn63xYf7V57fh6d/N8s/XUlXBvt4FXuzwL/Cx/hPIt9
I6+3NBzErij1WnEWd+247EVquslfH3f99EeGwLub9F3UjGvRYyLqueKg3dgT
+C7qjWW43M7nS99q8v8DQQil3Q==
          "]]}]}, 
      {RGBColor[0.50562, 0.4814, 0.5218400000000001], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVclOVFEQvTLYzevH6355dEQZm0EDauLIoCQYRXEHmkgYggsjQiI4gcaJ
ZsaoUVg4JKKCGnDDxo0oiVPUxD8wKiu/wGjisNJzPHfRqXp169ZwTtXtxKHj
+4+lGGOu45eKX2HcmHnIHseYwXQoacbMwWFDxJgjy4zZGhgzge9T6fIbDBnT
Ab0TZ+/C0qdhn4TPE5z1wv4+pvPtuDsC2yh+D+CzEwmTKYo75hvzDHdfxRSb
OXiXuVnDNeiD8FnA2Qv4FCLWIxx1OcrZlKEcKwLl74A9x+ZbBbkFvzvQE3Hl
pM68g7B/Qx0H0F8j5Dxyzaaof/aX56gX+iziuz1TtVREjRl3dXYY9dwLqZ9+
fH9NVf28z2/amWsUsT7CVg25OyK/bchfDf0L9GLPmBbbfxXsRZ7sJZDtsI8j
Vhn0Nk+YtEKucVTXLk91sJ6pLGFPnWcHM9Qb+/qbKkzZwwXguWe5MRchb+LO
W/BX4Khe6sQpNxAvLxG7CHXWwr8P/glHHI5C3wz7XtiT0CuII/Sr0Ivg8xA+
l6H3IsYni08BfGrgcxL2fYFqbYCsX64ZIn87MtXvADAuRJwZ2AZ88Za02P4I
qR/28hnyQ1gzUZ+q3jk/7I85ORvZyPEUdSyilwo7D5yLdXHxQn7OB8JnxhXn
sxbDSeCziPgTkF04G8bdlfAtwO85Yr4mPnHN4TmcV0bFEbli39wT1jDqajaa
cO+Kr7tvYprhRdt7cVw5e1FPXiAMO6EPBeq3GTFvZGlOOC/Enfjfhi0a1axx
X9krMWXMfl/6pohmnb21IN64r/jkqgb2HtzNRYylkGaGWCxBTqXpLDsq/YTF
gDySG9cT9tzL7yFxQ16m7fd69DQXyMYdIgesr9vW/jOsOEm7P+S3OZDOXZmx
cR4H6p84tHjilvgS21tpmgPWcT9NdbPmjfbtIjYJTz5VEXFALsZc8UcuzqCe
8qjegTLIAstfPmRdRDPViHvDgTAagVztKVcp5JCvveB+NNjZLkHvA4FmadpV
H79DmrnTFn/yTNxZby3wOeqLN75nd7M0032OcCJexI7Y8z0kbuVx7fnauPbv
j90F3uHdUr57rnDJieqcfuy5MlBfdXa/ue//dzukb+pnXXHTBpx+hfWu0s4Z
4f8E56TbFQdZUb3RrG3Y114yF+vJd/QWtMa0m3w3ySHffea95Cs2cyzY/wHW
z/p67VvHN+8f+3veLQ==
          "]], PolygonBox[CompressedData["
1:eJwtlElL1WEUxl/T1O693nv//L1hmVNqodXCIocUjIpsUWAuQi1aBA6R2mBG
k3odoyJ0USZZaUW2cVGbBovAVOgbRMOqTxAFZav6PZy7eOGc9zxnfM77Fpw4
3dC1yjnXyEnhbIs59zPNuU/IW5FPhpwbRh/iZPvOfch07k+6c4+wD3jOtWGP
Y/uc7FxeGD3g3GNsK2AWwS5z/iK/WY3dtzvZXqNvQF9K6PIZJV4e/ovoe4jX
hVzGiYOtR+9FXofPIPlmwLei16N3Jzn3grvDyNc9i6V8N5CHPatV+UaQC/Hp
Qf5KvI3Ueyxq+jf0zej9nsV+xV0ceb1vvUt/B7YavY18R9bgz3ye0/9Kms1s
BtulkNlawB8E/8w32y18ZpGveVaLelbv6kH5fqMvoLejP3E2M80uB30O/Rw+
tzMNI+xL9CzizZHvVyL/tGbjWa3iSFy9j1q+2lTqDTo3wd0Stjr0XrCd+E9C
/Bf6z6f/hajNrh57OfiisM1KGGHXRkzWXRX25rAtjjgSV2fATKXYPDdha8gw
7r5R3yD1XfAsvjjqQX4btV4OkG9H0DgW/jgzLI3ZDmgXHuBf5RsH6q8GfB74
KfoZZ4HrwNxHzqS+iRSbYYj8+zhPsc9xV4rtpme9fWQGk+Cvou9PNU6XiV2Y
6Fc7od0YoZ8x/L9z10j+u5lWqzjLD9jOqNeHxO8DO8OZBf+PuwHw1dTYmWQz
ySJ/dsSwuqvBVhKx2tSzZlWbYbZRYuxG7vBsPtPkO4V8KGq7pTent5cbtrfX
zV1uwHpSb+KzAFtRzN7GPP6FyDnc9RK7lRxl5N8etF1QDnGx0zfbPXzKkceI
N59uOZV7l2+z6CPGRfIP+cater6MvCVm3Gnm/egtAatdMcaJ1cTdj2TjbDRk
nIpbcXCF/o5GLbb+gDvgi2PGrTgYBt8ctV7Vg3qZDlkuxYz79uZUq3Zcu14Z
tFloZ7W72nHp2pEOfM979jb0x+mvO+vZbumPaUcvj9jb1Y5XIDeFjVu9Ob29
krBxJc7EdaVvb1V/UgVycWI/tE/6e/aGjQvVrN0siNms9cbzkf8Da7C9qQ==

          "]]}]}, 
      {RGBColor[0.54318, 0.49460000000000004`, 0.49976], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVVtLVFEUXjnq6MyZM3M6Z6IyHU0LjOxuab50w7dALemmBIGO10y6PKhR
FhU9aFfooaiQ3rpRIAVJURH00ltaED34B/IfRN/Xt6OHzdpn77XX+ta3Lqfq
2FDb8QIzu48Vw7oXN5vHZgyHK5NmHYvM3mbM1mbNjpaa1UHuKDa7DL0B6FyF
vILVCb0HodkrnD3xzBqg86bErA/fnyLp9CTMsli9RWYtsLkC+pdw/hH37bC9
E35Hob85ZdaI/SbIKodhGvpB2qwJ5/Up2d5eLPtlsNMP2evJFm3m4afIF8ab
kfBecpgnsRZg5zzsTuKuB9/5wGyPr/PdkMPA+M3hIa4PJeKEi/w8BldN8D9T
It83Iu2DhO5fwtcEOYStR9CtTggH/Z8MxBG5OoT7HGI8AiwziDF0+hnE2u+J
3yrENwv5y2HeF2q/E7r7sZ/GXXsovsjbEuxHsL7i/CLketjvwrs6947x0w7z
8BPfw/juLJX+Z/jOF8gOa2KoQJwT03Sh2e+YcDc47g/DzlhC7zZAzsXEHXmb
RZyvIZ8ijoOw3xwTJwMJ8VeW+M8v8fF+pEj4+jLydQAx3o6Ld75h7olni4u1
tVQ4K7K6p23mczvuDsHm9Uj7roRywDhW+arlAy6WpWnx0ASe2lLiphZna9Kq
B9bFOLj7ARwPEcuaUJhyWdmYKFKc5I954nvufzg+51wdMca9iKsX+2usu0BY
WYNljpM6+LoQygaxnIsLP/XIzYLLXzn0vmN/GPbaQp1dBLZnnrCQ+3nH979a
ZZ2yzviOOSZvI3Hh4f5dJL0TeHs7Us2XA1d5Ulw+z6gn7sYVT6Wv+hj0NBNY
25wD1Vnluyar3I652BtSqrUhT7XLWtwFeatQdvOuv8htl/NHvyvgv7FYHLDe
WkP1VwtkTVI+i5Grt5GrS+DP+YorD1+rffk9gf3WUPjrIYcCxcu4WXtTheKr
N5Ad2rvnqTdqEUtlWjo5yBcZYamA/wFPPJAP4vjLAc5zoeYe5x97tNnlrjKr
eVcFmYXOWdxFkKcD8XgGcluoWdwAmUqLD/Yxa4FxkRfyyLgi+L1TqL4gjv5A
fA0Eqm/2Eetw0OGs8TVrWAvLQ81WztjKpGqD+WAuvsRkl286Uqr1qVCSs4C2
F+N7lPnylEPGwrfrXI+wVyoSrkd94WJNM5cbnb9ylyvWIuNizxNzPqkZwzlP
rN2wMw6dZbB5PND5YKB3o+4t9anD3HR7whJC3/MVTwQuezzpDQf6Z7AvTmG/
OimdlK9ZwJlQi32Zrx7206px/kfI1/tIvohrudOhLmuO8bDXl4bSoS5nFbGS
iz+Uy+HN
          "]], PolygonBox[CompressedData["
1:eJwtlMlvjHEcxn9qGZ3OvDOvt2NtZ1qKVlSIrfRii6u1oWiIqK5UbYki9u1Q
S0gcrGncJBKkIYiIk4ubLREH/wD/gfg8eebwS7779/luv/q9A5sPVoQQ9vDG
8ZqiEH6NDeH4+BA68iEUq0LYMSaEboy64xDakhBGUyFch98M3YusZYJtnmNf
h/0u6D70h9H181aU9W/QH4Jvhd8J/xJ+emJa9jOgC7kQ7gLkMxjmEGs7eD6B
6yc5z6E/jv8q/Dvw+YD/rCrT/fiPxzYb2fcq9r2ZEI7Gji1MM7Hdh2xTJZiw
WZwN4QQxv2Dbgew+uoa0a1cPGon1ANnXlG1k+zhjLOKH4FdgP4z9NuwvQi/A
Z5h8I9RQRy1HYmNT/nrybwRzD/aDyFrIXyTGFWJd4/UR+0IZz1nsz0PniHGb
WD+Ivwj/ueQYwn89/BHoZvI9Dc6p3DXIBtF/Qz8d/kLGs/oDv4V4g+DprXDP
S8TbkNj3BTk3QTcU6HmlZdIdyhir+jEVLAvx+T7WmIStGpvTKctqIs9Ysz6H
bCq6KbwzKe9AH7lr8G9HfxLZpMQ+8hVmYW8s7596VEh7hpqleqRercP/N/r7
8MsT74DmL30JvpZ3OeUdOUa+7rR1ilGHbkfevXxIz4rouniXUvaRb8LrqnBN
BeimnGfxF5950Gsj05qBZjE58S7JZz9YNybupTAKa0tirKfQt5P7fd67oJw1
iW9As1gJ3oPg7cLnH76j9Hdpzjul3drNTOYzmwOxbd9ODCGPrjPjXg7xYuKV
sLmT8k4UoRemfT+K2UuukcTxXoPnGb5L4e+V56fZLoE/WWHZMuhi5F71ICtF
xiRsirGL/Z2N7EnwjsyBro5MS5ZAr4m8e7oh3VID/EBZPxP6RrVjr8TmJnQt
eD9S22r4A9BNBd+majiVdo2qVTesW24uuDeviPEocY/Va8W4Q7x69G2Vrkm1
HS7/B+/Q30LfFftv007WUn91zv+HMPZnvDPaHcky4F2b9e3pD9yKLp9zLa3I
YuhmZJ1jPIMF0FHOtyhZFnpJ1rb64/TX1Se+fe1wQ5VrVu3CXAf2OG2s+jMH
Ys9cs9ef2wM/LfGt6aa7M/4ThE83PAv/zrR7qxvULbZH7pX6qb+1lPNfJR/V
9h/7Tau2
          "]]}]}, 
      {RGBColor[0.58074, 0.5078, 0.47768000000000005`], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VU1sVFUUPs7fm7438+a9uR0XpJY2FiOhNGiFskDTwEpN1JRpbGgp0sCg
NbRNTYyDWBPdgDWRAjWSWBdVVybEMmy6cI+wAYSEnewFLKXd8318l8XknDn3
u9859/y97onpoamMmS3jl8VvLjA7jd/IC2YHymazkFsrZl86s98A/KVk9ivk
Q4BXgb+Vmn1VMLsNOZ03uwt7E+dbYrMlnHeE4IV+DfYMZD84Gzg/Bp69sB3L
CJcAtwB5MpWNeMbQ4Xna4f9v2P4qml3A/8uJ2Z/wdxD4D8H1Xc4sV9H5WwVh
ToHnflZv6Iul74Sch/1fb38V/38Htgf+Z/LCnPLxMc4UfscQ8/fA7gb/LPy9
Cf6uyKw7kq/PYNtdEP4HUz6YK95ZRzx7Cor1U3CehL0TnPeQ4/ezwu0F/z7o
HySKi/4Z26THlxHjBM6a4DgKuQN8K9DPwdfr4LoErn6nHDBHfHtvLK6PgF9o
V8yM/RXEPA7uGt5SbzMb9PXKx7r7Ms4T6GyK9xL5v5HVnW3+bhvu1pz6xEG2
xcIUIRt56c/fScl3HEmU92HIVl7xnDflb9PX9DD4xgP1wZZQ/TQC/P9VnT2C
fFKUTsxj/D8CfQ1yoyidnJuQcwXlnz32eaCeipz0EPJOKsw/kCne1Qd9DPqA
r8UeyOMZ3Wf//ez7vom7D+FvFDwPIP+rquZHQ/lgTohn/x7yc8SZ+CIQ32ZV
b50IxTEWqI6xE6bMvDr1EGeL56w3MQOQq0XpVdRgEfV2kFWn/uuI1BcDHr/q
e4/6dKrcpPBbicQ5Atthb1+vKvfMA3PrUMubiLs9Vu+Sn+/8JNU553Uw1h6o
g+/jVH47I9WHdWIs9L/uYy4j1vOIOYa86vtgPFUeiKGfoVR+mNchvKuFs2HI
J77WrPlaWTlkLl+K5ONEqnP2wRXwdFU0y5x7co/6PP+RU8ys5eWSemXZqeaX
ctoFK4lin0xVb2KXgA0r6m32O+eHs/BGWTVn7Vnrs5i1Ffg7A1nB3SbOEv+O
q4F2JueecZC3F2eLrDFkPa+7fP9BJ/y3Jdkbnv96VjPGufqmpJnajxg2qson
88p++zHQXHO+F73O/cWZOIGcNUra9S86zeS858v4Xf1uov6lb/rtieS7G/hC
LD2A7HPytdNpX3BvRL4vuK/4Xu5Qxn8c/FOp6tNK1L/sMd6hvJiTzjNiZjib
FdmTinI473cj88rZ5EzR1vK5XfJzuj/WXhz0+5R9d9fj2ePkX/Dfp2ffqVh1
+TqvnVwL1Qv8PryTqL5vJ3oHc8IanQ51Z3sN8+p3+pzTPuNeYz24g38KFMNk
Iv5doeLi94b2utOb+L3trGkvb4V8zenuLsin51PvNg==
          "]], 
         PolygonBox[CompressedData["
1:eJwtlMtvVHUUxw9tZ+4wtzP33rkdjeCDBjUobyrgQgyyUxdKO6aNliKNlJdt
CSbGasGFGx9EQxUjRk0UXRmBAi5Y+Fj62BiRxJ3+AaKNlD2fL18Wv+Sc3znn
e96nf3x6cKorIiZ5PbyHGhFjSyL0uRk6aUb80h1xHOFIb8S3ecSFSsSj1Yj+
NGKav4+RPYLOw+ivRf9v6MPoLK9HnEf/PPQ69Av062XEywm66GxE/3HkL3T5
L0XWQecqsq/BXJVF3AHeFfhpMJaBd3tmf7/xtwrd9anlc/w1kA0Sz7Ng/cRf
N7Y5mDPwe/HRCz0Oxvvkeb0W8WNfxN3YbyW2efDnieVO+M3w5+DP5q6BavEB
+AX4Q+CPgvcc72or4uncuX8FZhvsEh+zyI7xJtAdyR37DBjD0BvQeR3+KWxm
oQ8Xrs8i8fxAPFfgj+H/OvZnsG+hM1FxD6rk01+angTvEPIaf792W0e6OxvG
/hP7o+h+URrrOD0dbTgn5bYFH3eRa545N9WzBGuY92WXYzyI7iTxnAjHOAXd
B96n4Rzb0FPEcOpW/7eCfw94R5Z4BlZA/47N0ar9L4DXwOaVxD1TbzdhM4Js
Ap8D0P9S012J+3EO/T28mYpnYjv6R8jxUvhvHNneXtuqZ63SM6fZ247+i9B9
TeemmdGsNpqunWb8fvL/nppfqznHA8Q6VLg+78EPQveg/zP2b2M/jP2DpXv5
ITGug17PexX+I/iN0HPgfVezTQXb1fydTBzPNvLbUFr3L/g1yAfgTyXGENba
0tiqj2b7s173QzWcLT3zyuck8bSo7wA16FQ885r90cK7NgbfgR8rvK9z5LNL
s1V6NoT5GvSWhnun+mi30qbnXfW5L/WOale1Q1npHJSLYt5UusbiO0vZpXbE
N/hcTDzDmuUR3uqqd0a7s6fu2s5To7eo1bu8SzXv4H503+yzTDkpt5cK3xrV
VLXdV3h2ZSNb7ZT6oRqvIZ6i7ly3oXMC+YrUtGqg2/Vk7tugm/NE7hugWyD5
IrNXzXzrtGP3pt5J7aYwpwvfQMnVX81GM/Pt0X1ZDl9m7o1qmMPfVvoWaMY1
6ytT2wpDvhbwuTvxfulW3uxZ4h34D9nSzL3Qjtcz3zD50g41of9vOTZhXIP+
p+XbpBk+k3uHtEvqQYbv53PP3jtg7IZ+BowLiXe2A3351v1RDz8vnZP8aeeX
Qb9BfBcT2wwif6zpfdTfUOmbrdutG6RbpJ3X7gvzD7B3oH+6yzay3dFwLOK1
2w+0bSudT/DVk3n3dLMXdF/anjX1XLu4LzW+5lm362DhfLXT2u0b9aLSNw==

          "]]}]}, 
      {RGBColor[0.6183000000000001, 0.521, 0.4556], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VU2MFFUQLnZmp4fp6e7X/cYYvHlQZnUSYElYEyUYiIkC+z/sDCDCjnvQ
BFfdqGuCwA1FDJhoYkIIySaeOMAGPGlM5MRFSYANePRiUAPuioQTB79vv+fh
5VW/rqpX9dVX9Z7uvTsx22dm32GVsAYSs0EITez3sH+Bn8fXmD1XMbtSNZvA
97rU7Bx0E2/2StB5Hzrz2JfwPQP5+4bZetiM52Y/NGTfgTxRNxuD3mZn1oKf
C/CzEX7e6Te7WtV3D/+vwU8Hfpqw2xuZjeKsAv2v8b+omWWQr0Mnxf5EbPYj
5EeF2Z9YXej/VcjPfKRYb8L/DazbkJvQPwjfT2ZmK4lsy5CriOND6K/FfgTr
NuRj2DcghkOQJ+GvjTUNeQT2v1Xllz4nkdc4/nWRY7sunF6H/G8h2weFMOD5
bthWkMMi7D8FNqlXnHUfMIPOLugsePm+BT8nobcJcU7DbiIXLpPYL0WqAfFf
6FPM12BTg14Hsb0AnH/H3Ruhsz7R/S3YDkN/qCSMiE+vX5ivYob4v4KfAdz/
B2w7kO8WoSbMvU93kR/kxovwuw3yS9jnaopnO+QDubB7A/ss/L8Z7loHncP4
biO2QaxhnI/jzqk+cY813h4rp1+das/cd+I78+LFpkRc+yCS3xa+u9j3wc+p
svzQ39m6Yh1LxM9vInGsmSn2diwefVkWJ36GfKYsX6zDQEX1Ilf4fwv81DLp
rMUeZ7I9gHtKqbhNjpODxJxYnXeKPcFdi07+/i6U17MV1fqyU01WcH7R6exe
obzpk/bkxuWq4vKxOPgYd+axbOmDmBCPmfCPOkWs/iJXiGkayx/jGs0Vwwj2
PbnybWMvA+c56JfI/5o49QvOt6Wq+9tO/KEOObPBC9vN2COvulSwn2qoZ5ZD
n/Uife+ph16Cz58a6qke7vm8oT7bj/Nu4ESEOwe9ctqaqEeHQp77cvF5by5+
Em/ygzxgDR8m6iv2lyN3gs8yfJZQu5Oo3VRdsZE3///jzvuficWJGGdZrNqx
huQXbVfnUeAG58oMeY51Gucu1OVb6B/14ts44pnKNQs4Fz/uV23ISfYQOUp5
CHrvQZ5FDEu5ZteKUx69kGNWU9++6oQFMWF/vZxqJk/j/H4iPInrU7XQf6n6
hz5qXjWZDnVpefVqB7ZbU/UOe4i4E//nw1xcCO9C7JXva058Zy8z97FcfOU7
sDvX+YmG6kO9VXzCDPeZOLUYKe6DTrgccrKhLecE5yW5yr7hbGNdWOOmF3ac
QzudarDL6Z1gfarMN/CTPB11wrbA+VtOuTBX5jES4uebw97jXT2nmTYX5tZS
qNM/TvP/gRNexK3rxGliSe4fCb3DHmL9WMebud4/9vVnDc1I1oi9OuKFw7DX
DCY32LOMfT70Nd/hVnhLrgduLMPfcqEzvj/DYWYwF+bE3FjvSSc/H0HnE9xx
B37P1zVnec8O