(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    193829,       3472]
NotebookOptionsPosition[    192212,       3429]
NotebookOutlinePosition[    192565,       3445]
CellTagsIndexPosition[    192522,       3442]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",ExpressionUUID->"77d7df06-738a-424a-b636-bcd560bd29f5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"myAxis", "[", 
    RowBox[{
    "label_", ",", "color_", ",", "component_", ",", "lo_", ",", "hi_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", "g", ",", "o"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"o", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
      RowBox[{"e", "=", "o"}], ";", 
      RowBox[{
       RowBox[{
       "e", "\[LeftDoubleBracket]", "component", "\[RightDoubleBracket]"}], 
       "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"g", "=", 
       RowBox[{"{", 
        RowBox[{"color", ",", 
         RowBox[{"Text", "[", 
          RowBox[{"label", ",", 
           RowBox[{"1.05", " ", "hi", " ", "e"}]}], "]"}], ",", 
         RowBox[{"Arrowheads", "[", "0.02", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{"o", ",", 
            RowBox[{"hi", " ", "e"}]}], "}"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"lo", "<", "0"}], ",", 
        RowBox[{"g", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"g", ",", 
           RowBox[{"{", 
            RowBox[{"Dashed", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"lo", " ", "e"}], ",", "o"}], "}"}], "]"}], ",", 
             RowBox[{"Dashing", "[", 
              RowBox[{"{", "}"}], "]"}]}], "}"}]}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "g"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"myPoint", "[", 
    RowBox[{"p_", ",", "color_", ",", "label_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"color", ",", 
     RowBox[{"Text", "[", 
      RowBox[{"label", ",", 
       RowBox[{"1.1", " ", "p"}]}], "]"}], ",", "Dashed", ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", 
          RowBox[{"p", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
     RowBox[{"Point", "[", "p", "]"}], ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", "}"}], "]"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544260709698449*^9, 3.5442607186279593`*^9}, {
  3.54428111716831*^9, 3.5442811280423098`*^9}, {3.5442856744219174`*^9, 
  3.5442856853789177`*^9}, {3.5442900062835426`*^9, 3.544290041155543*^9}, {
  3.5443927636957445`*^9, 3.544392786886071*^9}, {3.544392851243752*^9, 
  3.5443928515137672`*^9}},ExpressionUUID->"91325280-9794-4f7d-9a2b-\
476686031cf6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xy", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"Darker", "[", "Yellow", "]"}], ",", 
        RowBox[{"Opacity", "[", "0.05", "]"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yz", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "y", ",", "z"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "y", ",", "z"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Orange", ",", 
        RowBox[{"Opacity", "[", "0.4", "]"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zx", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "z"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "z"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "1"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Green", ",", 
        RowBox[{"Opacity", "[", "0.05", "]"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"xy", ",", "yz", ",", "zx", ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"100", ",", "50", ",", "20"}], "}"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.735926962096408*^9, 3.735926996071197*^9}, {
  3.7359270287109756`*^9, 3.735927049279592*^9}, {3.735927086442066*^9, 
  3.7359270986938*^9}, {3.735927166704101*^9, 3.73592718359722*^9}, {
  3.735927220535163*^9, 3.735927225188738*^9}, {3.735927265423203*^9, 
  3.7359274356334667`*^9}, {3.7359276272121153`*^9, 3.7359277668068533`*^9}, {
  3.735927814009354*^9, 3.735927883710301*^9}, {3.735928517321278*^9, 
  3.735928542990584*^9}, {3.7359287473025637`*^9, 3.735928757276473*^9}, {
  3.735928898718506*^9, 3.7359289051076527`*^9}, {3.7359297183656197`*^9, 
  3.7359297426823063`*^9}, {3.735930032257698*^9, 
  3.735930034070867*^9}},ExpressionUUID->"368b260b-265d-491f-9939-\
d749bcfe3322"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ax", "=", 
    RowBox[{"Graphics3D", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Join", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"myAxis", "[", 
         RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
          RowBox[{"-", ".2"}], ",", "1.5"}], "]"}], ",", 
        RowBox[{"myAxis", "[", 
         RowBox[{"\"\<y\>\"", ",", 
          RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
          RowBox[{"-", "0.2"}], ",", "1.5"}], "]"}], ",", 
        RowBox[{"myAxis", "[", 
         RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
          RowBox[{"-", ".2"}], ",", "1.5"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"Orange", ",", 
          RowBox[{"Arrow", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0.5", ",", "0.5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1.3", ",", "0.5", ",", "0.5"}], "}"}]}], "}"}], "]"}], 
          ",", 
          RowBox[{"Arrow", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0.5", ",", "0.5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", ".3"}], ",", "0.5", ",", "0.5"}], "}"}]}], "}"}], 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Darker", "[", "Yellow", "]"}], ",", 
          RowBox[{"Arrow", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.5", ",", "1", ",", "0.5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.5", ",", "1.3", ",", "0.5"}], "}"}]}], "}"}], "]"}], 
          ",", 
          RowBox[{"Arrow", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.5", ",", "0", ",", "0.5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.5", ",", 
               RowBox[{"-", ".3"}], ",", "0.5"}], "}"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", "Green", ",", 
          RowBox[{"Arrow", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.5", ",", "0.5", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.5", ",", "0.5", ",", "1.3"}], "}"}]}], "}"}], "]"}], 
          ",", 
          RowBox[{"Arrow", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.5", ",", "0.5", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.5", ",", "0.5", ",", 
               RowBox[{"-", "0.3"}]}], "}"}]}], "}"}], "]"}]}], 
         "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
      RowBox[{"Axes", "\[Rule]", "True"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"100", ",", "50", ",", "20"}], "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.544188998883645*^9, 3.544189003768761*^9}, {
   3.5441897207364597`*^9, 3.5441897323461676`*^9}, {3.544190060055626*^9, 
   3.54419009446349*^9}, {3.5441901254087315`*^9, 3.5441901463092475`*^9}, {
   3.544190177415721*^9, 3.5441902335381937`*^9}, 3.5441902947152634`*^9, {
   3.5441904213970203`*^9, 3.5441904708429275`*^9}, {3.544191432467061*^9, 
   3.5441914326231127`*^9}, {3.544191466267708*^9, 3.544191473633315*^9}, 
   3.5441915498818345`*^9, {3.5441915858838005`*^9, 3.544191637041529*^9}, {
   3.5441952332194257`*^9, 3.5441952922172594`*^9}, {3.544227068842256*^9, 
   3.5442270705913563`*^9}, {3.544227108415519*^9, 3.544227136351117*^9}, {
   3.54422717940758*^9, 3.544227211334406*^9}, {3.544227258272091*^9, 
   3.5442272583830967`*^9}, {3.544264576475616*^9, 3.544264578367724*^9}, {
   3.544264611410614*^9, 3.5442647285733156`*^9}, {3.5442655755097575`*^9, 
   3.5442656265276756`*^9}, {3.544265668290064*^9, 3.5442656717772636`*^9}, {
   3.5442657178929014`*^9, 3.5442657435013657`*^9}, {3.5442683095971384`*^9, 
   3.544268333300494*^9}, {3.544268372027709*^9, 3.5442684125960293`*^9}, {
   3.544271170958799*^9, 3.5442711717258425`*^9}, {3.5442792389278936`*^9, 
   3.544279242872288*^9}, {3.544279277134714*^9, 3.5442792808680873`*^9}, {
   3.5442793221212125`*^9, 3.54427934140314*^9}, 3.54428111298731*^9, {
   3.544284734286769*^9, 3.544284743923805*^9}, 3.5442855942729177`*^9, {
   3.544392168068677*^9, 3.5443921821414814`*^9}, {3.544392216013419*^9, 
   3.5443922258699827`*^9}, {3.5443922779179597`*^9, 
   3.5443922786930037`*^9}, {3.5443923417416105`*^9, 3.544392424318333*^9}, {
   3.544392455639125*^9, 3.5443925750439544`*^9}, {3.5443926174083776`*^9, 
   3.5443926738816075`*^9}, {3.5443928006498585`*^9, 3.5443928242022057`*^9}, 
   3.5443935385290623`*^9, {3.650202957850041*^9, 3.650203061749638*^9}, {
   3.735928366090047*^9, 3.735928463759996*^9}, {3.735928948948073*^9, 
   3.7359289694264097`*^9}, {3.7359291841307592`*^9, 3.735929242688169*^9}, {
   3.735929325457233*^9, 3.735929433243599*^9}, {3.735929474589576*^9, 
   3.735929615347802*^9}, {3.735929676822507*^9, 3.735929691138472*^9}, 
   3.735930052458623*^9},ExpressionUUID->"9aabe485-82ac-4bd5-84c6-\
601010594cb8"],

Cell[TextData[{
 "\[LineSeparator]\[LineSeparator]\[LineSeparator]Here\[CloseCurlyQuote]s a \
picture of the box, with surface normals.  Orange face normals point in the \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", 
    OverscriptBox[
     StyleBox["i",
      FontWeight->"Bold"], "^"]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "6e29f309-08b2-4fbc-a778-07d6d5dfda76"],
 "and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    OverscriptBox[
     StyleBox["i",
      FontWeight->"Bold"], "^"]}], TraditionalForm]],ExpressionUUID->
  "8c17c950-250a-4a3c-8fa0-7404d350a60a"],
 " "
}], "Text",
 CellChangeTimes->{{3.735930106636548*^9, 3.7359301204450083`*^9}, {
  3.735940471346829*^9, 3.735940496288867*^9}, {3.735940530240963*^9, 
  3.735940572412266*^9}},ExpressionUUID->"dfffbec2-2845-4890-bffb-\
068f5fb7ef9b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"ax", ",", "xy", ",", "yz", ",", "zx", ",", " ", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "50", ",", "20"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.735930144079183*^9, 
  3.735930144520845*^9}},ExpressionUUID->"d091d9c8-33ef-43ea-8fdf-\
ab5850ab10a9"],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 0.5, 0], 
    Text3DBox["\<\"x\"\>", {1.5750000000000002`, 0., 0.}], 
    {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {1.5, 0., 0.}}], 
     {Dashing[{Small, Small}], Line3DBox[{{-0.2, 0., 0.}, {0, 0, 0}}]}, 
     {RGBColor[
       NCache[
        Rational[2, 3], 0.6666666666666666], 
       NCache[
        Rational[2, 3], 0.6666666666666666], 0], Dashing[{}], 
      Text3DBox["\<\"y\"\>", {0., 1.5750000000000002`, 0.}], 
      {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0., 1.5, 0.}}], 
       {Dashing[{Small, Small}], Line3DBox[{{0., -0.2, 0.}, {0, 0, 0}}]}, 
       {RGBColor[0, 1, 0], Dashing[{}], 
        Text3DBox["\<\"z\"\>", {0., 0., 1.5750000000000002`}], 
        {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0., 0., 1.5}}], 
         {Dashing[{Small, Small}], Line3DBox[{{0., 0., -0.2}, {0, 0, 0}}]}, 
         {RGBColor[1, 0.5, 0], Dashing[{}], 
          Arrow3DBox[{{1, 0.5, 0.5}, {1.3, 0.5, 0.5}}], 
          Arrow3DBox[{{0, 0.5, 0.5}, {-0.3, 0.5, 0.5}}], 
          {RGBColor[
            NCache[
             Rational[2, 3], 0.6666666666666666], 
            NCache[
             Rational[2, 3], 0.6666666666666666], 0], 
           Arrow3DBox[{{0.5, 1, 0.5}, {0.5, 1.3, 0.5}}], 
           Arrow3DBox[{{0.5, 0, 0.5}, {0.5, -0.3, 0.5}}]}, 
          {RGBColor[0, 1, 0], Arrow3DBox[{{0.5, 0.5, 1}, {0.5, 0.5, 1.3}}], 
           Arrow3DBox[{{0.5, 0.5, 0}, {0.5, 0.5, -0.3}}]}}}}}}}}, 
   GraphicsComplex3DBox[CompressedData["
1:eJyN2sGrVOUfgPHJIGjfJiMwmooghNA2El4CKQdatWplcCuIcmjhxtoHEi10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    "], {{
      {RGBColor[
        NCache[
         Rational[2, 3], 0.6666666666666666], 
        NCache[
         Rational[2, 3], 0.6666666666666666], 0], Opacity[0.05], EdgeForm[
       None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxNmHe812MUx7++QolEGaFIKUl7l3K7mqjMZJbskb2JKCtCFK6Sq2FEbjIj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            "]], Polygon3DBox[CompressedData["
1:eJwtk0lWVFEQRPN9UEqxmeHYAc5QVAoERIHCZgxDGxBFpStABJzpCmAFsAJY
AawAV6DbsAFbuHEyBnHq5muyiffr6vTSeLOKiF7Uim4RjKBleAm1w/9KxDa8
iS4RnxAfwJ9RN/F91IQX0Xn4b8mzH71/Dz2Dn6Mb8BB6Grl2Hb6L5uE51OX9
hci1m/Bwlb00fV/5VGvB+6qv3JPuX+fFU86n/E8ia16A/9PfbuRMA8SP0Qd4
A932/Lr7AtXhUTQNv0QV/I37NfiK/Qh0yM8+uuxY3nxFg87/Fp51vUfoTeRa
u/3agnfcn/wW76GL7ld8YH//EH+KvNNC/L1kL9dcv6AvkT31ww/R68iarfCP
kmfr6Azxz5I8hs4R/yZeiaxxlvio5N4E6iGuoV8lPemFG1V68wrdgR+gmcia
de+vwu98X36KVaPP59fg976vftcj1/rtl95m3fXGqjy76n7lh761Zb9fzTMo
bnOvestxz695e+BOz6/5GpFrfc6vWWbsr/zS2Q6/v/wWt9mf45K5G34v/T/0
Ley6vvblnfw6BSlOVZU=
            "]]},
          Annotation[#, "Charting`Private`Tag$32529#1"]& ]],
        Lighting->Automatic]}, 
      {RGBColor[
        NCache[
         Rational[2, 3], 0.6666666666666666], 
        NCache[
         Rational[2, 3], 0.6666666666666666], 0], Opacity[0.05], EdgeForm[
       None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxNmHm41kUVx++8WVmBsu8Q+25laqipgFuCKYIIXGS9KGoWlLlUZpYpaZua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            "]], Polygon3DBox[CompressedData["
1:eJwtk0dSQ0EMBf9McQByDibHgh072JPB5AwmR5NzWsIJ4ARwAjgBnAAORL+S
Fl1uW/9rNJJcm8mmD2OSJN2QA2N8aYIS2AtJUsNnHuTiAQbwOTjHz6ADr4Zf
/Bva8apo/gm1eAF0Khe04ZXRYu9QhxdCT7BnWvGKaLFXaMSLYSFYPSk8P1ou
1dSCl8EL/ub1zcI6vgF9+AysBfut3s/rxYegAS+K5jpjBF+EbXzH76N6v/Af
r1/1fQT7TfWWRzv7w/uh++vZPxjFl6Ll2oVp1QZH+DEMej9V66b3Q/3qClbj
iL9/jV8Fm88y3OI3MOX5nvBHSOMrcBfsGc0vFyKe5+fNw0WwGQ77fZX70vul
/mm2p+qReh8tpnf6vZ+Knfh8NY9UsJpTvi86K+X59f5WsJ5OahbRan2ACTwT
ze9h3Ovfxw+g2ef7HKwHab+/dmHf69N91Lst3wfNQ7vz7PlWo+W+837p/Gyw
GUx4XGcd+r5p9zWrea9X9SmW9X3RPio26PPV/6XUZ1Tv+6RYj9evmGalHf0H
rSZJkg==
            "]]},
          Annotation[#, "Charting`Private`Tag$32529#2"]& ]],
        Lighting->
         Automatic]}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{499, 514, 500, 515, 501, 516, 502, 517, 503, 518, 504, 519, 
        505, 520, 506, 521, 507, 522, 508, 523, 509, 524, 510, 525, 511, 526, 
        512, 527, 513}], 
       Line3DBox[{528, 543, 529, 544, 530, 545, 531, 546, 532, 547, 533, 548, 
        534, 549, 535, 550, 536, 551, 537, 552, 538, 553, 539, 554, 540, 555, 
        541, 556, 542}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{558, 572, 557, 573, 559, 574, 560, 575, 561, 576, 562, 577, 
        563, 520, 564, 578, 565, 579, 566, 580, 567, 581, 568, 582, 569, 583, 
        570, 584, 571}], 
       Line3DBox[{586, 600, 585, 601, 587, 602, 588, 603, 589, 604, 590, 605, 
        591, 606, 592, 550, 593, 607, 594, 608, 595, 609, 596, 610, 597, 611, 
        598, 612, 599}]}}},
    VertexNormals->CompressedData["
1:eJztyEERABAUQME/JJFEBxEMZ9VFoIACZt/hHbb01WaKiHGX49WunHPOOeec
c84555xzzjnnnHPOOeecc84555xzzjnnnHPOOee/+gGE49aP
     "]], 
   GraphicsComplex3DBox[CompressedData["
1:eJyF2sHLFGUcwPHNIOjeJSMw2ooghNAuEr4EUi506tTJ4K0gyqWDF+seSHTQ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    "], {{
      {RGBColor[1, 0.5, 0], Opacity[0.4], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxNmHe812MUx7++QolEGaFIKUl7l3K7mqjMZJbskb2JKCtCFK6Sq2FEbjIj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            "]], Polygon3DBox[CompressedData["
1:eJwtk0lWVFEQRPN9UEqxmeHYAc5QVAoERIHCZgxDGxBFpStABJzpCmAFsAJY
AawAV6DbsAFbuHEyBnHq5muyiffr6vTSeLOKiF7Uim4RjKBleAm1w/9KxDa8
iS4RnxAfwJ9RN/F91IQX0Xn4b8mzH71/Dz2Dn6Mb8BB6Grl2Hb6L5uE51OX9
hci1m/Bwlb00fV/5VGvB+6qv3JPuX+fFU86n/E8ia16A/9PfbuRMA8SP0Qd4
A932/Lr7AtXhUTQNv0QV/I37NfiK/Qh0yM8+uuxY3nxFg87/Fp51vUfoTeRa
u/3agnfcn/wW76GL7ld8YH//EH+KvNNC/L1kL9dcv6AvkT31ww/R68iarfCP
kmfr6Azxz5I8hs4R/yZeiaxxlvio5N4E6iGuoV8lPemFG1V68wrdgR+gmcia
de+vwu98X36KVaPP59fg976vftcj1/rtl95m3fXGqjy76n7lh761Zb9fzTMo
bnOvestxz695e+BOz6/5GpFrfc6vWWbsr/zS2Q6/v/wWt9mf45K5G34v/T/0
Ley6vvblnfw6BSlOVZU=
            "]]},
          Annotation[#, "Charting`Private`Tag$32550#1"]& ]],
        Lighting->Automatic]}, 
      {RGBColor[1, 0.5, 0], Opacity[0.4], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxNmHm41kUVx++8WVmBsu8Q+25laqipgFuCKYIIXGS9KGoWlLlUZpYpaZua
VNolKEGDzA0r08zArJRKs0w0XCBtQUutP9vs+3nm83tuf3yf+Z05M2fOmTnb
+47oWD1nVautre3bpa3tdRmHhJgYfD/0jOCw4PBgpuO7gxMdjwhOCA513Xud
OzLoHRkjg7dJH1Dq94HBiGBk8I5guDTyJgWTg5ODo4KpwXuCKZ5xfPAu6RWR
fVqwOt8TgoHBoKBX0MIWdHDcJ5gof7DnMA7xPMahwdHBO4ODgmnqh769cs6I
4K3q9HZ5x7j24GC6a9nfxzNfr93IHiYPu0cFA4Lxwbigp3cwXJ1HuW6Qek/Q
rpGuG+ZdNrIP0A70HN6qchrbGlsnKWug8sar52jP6xeMDcYEfR1H++YT3X+w
c2O0e5T0Ycqc6DuNl56ifdCHuI8zBkbH8cGV2oE93O1Xg8+UOn+E+mPbV4I1
8vp6r29QZ8Y3Bj14n6Dke21weXBF8MXgE8GlwReCS6SvCz7tus8HH5f3peAy
eVe775PKuiC4MDhF/5iuXsxdFFwbfMr92PCR4KPqfZH0gOg4rlXnl5Tq67OC
9lLjjThbUGpcQS8OTnLdc8H9wa+C00uNQ2JuofugPxdcrD3Y8OHg/OCzwcfk
fTBYFiwPPuTYEfSPXmOD92nDee6/XBnYj/+8KXhzqf7J+JbS5Te8yV+CZ4Nn
gu7Bf5JX/hvsV+r4WtAt3/9uq7we+W4r9e3wpz7K2r/UtfB2Bf9q6zqPb/bv
r+/gQ2M9v3+pPjdAffvEplGtmoe466m+35d91zXKQBa69DSOeih3P3nEVDdt
wvd7qytx2Uua+OwpPdS17B+s3uyfX2peO0HeMNfuozzkbCrVj9HxJkfi4GZH
YmVjqX7Mum+W6n/4742O8I4LTgvmBr8NfhI8GNwXfCe4Nbi31Px/S7A5uD64
IfhGcI1y15caS8TE10r1J3ztu+qKjt9zRMfB1pGblc2ezuCeYItzWzwH3qCs
ndCqdjF3lWcMzdzkVtW50zOJ13WOxPTXHdHv7uBb2vGb4AFtfizY/n/0Xer+
4+D24I5SY+s26QflY9M2+XeWWh8nter8w9rD/f2s1JrJ+T93/EHwkCPrdrj2
h+qxVT22Kxv6F/J5n53KQsYTngH9u+Cn0sQBfkVcPF1qnBCffwr2KO8pdeX8
R7QTu3+tbds98xZ94knPZM+jrt2mHZt9N/Te6Nuj943S5H/8Gv9u+oamj5gh
jxpOLcc3iR3qIrVzivvgkf/JbeQ08uzsUvMuNXqOdF/jmvzY9CWcN0J5TX/B
SM3ubR3nu6f1glglvxDrxDi9A7HLPHWGPERMNvUG+hm/qTvEN7E7xHsn35B3
pqnvrNKVK+F1c22TDwbLm+rapvdhxC5q7rGl9hpNDu3unR3t3Uz2vrgD8mn3
0pVfu3kOPr2h1Ji+w5Gccacj70etPVJZ+AExRmzd6rheH+mU1/RY3Fcf+72j
vO9p2nSgOkIfpB3o/Zq5G3vG+fb4BXn7UGlqyiHewSj3Y/ckbT3cd53qnU10
Dl8b7T72THAOuXM8Hz3wn9Gt6menOnesd09tpvb2c82iUnPoGcGKUv2PurnM
d2Zc6hsudT81n9pPfaH2Xyl9krKRic9Sy6nhF7qWmkSc0AdQK2bKb/cc6vdq
ZXwgeH+ptXtMcK7nw1+lHqtct8i153oPHdpAfThT25qegDNmeCZ6DLRvIS9f
oI70BfQU5GnmF3KXrcpvz3hiq/YNCzLOaNVeYnHGk4Oz0YfYDc7iDty7Ev0z
ztYW+pFT7EmWZJwVnOP9T/ctmzxLbiTfkffIdeRjciS5kp6P+kCdoKe7Wpo+
iTpCXRlqbmf9vFJ14V4ulo+d2EBfdZmgzlIfB9g7cR/nyaMXPN97Yk9H+HNb
9T14T2w6x/vlPrgH4pR8S44mTrdJE6fbpYlB8jW1hDi9T/o29/3I865TvyaG
WUvuvsc7o75R56iHncqlLt/lHDVqgzohu8kX6LXJ/axtaj80eWSr6zbKh27y
zu2eca96bFaXpm7f7btt9XxsbnqgpifaVLp6n42e2fQEnaWrJ1jnm9Ff3OAb
dkqv8z6wmZik76CvavdNzvb9eFt6oEuUyzlXKY8+aZC/Za73ndeq1xXqvdZ1
m7Wv6eFuKl29Gvc62P6HNfP1hZXq2vRK17qWu1yjLM7Aj9dr8zXyN6jjFs9e
HtmntmoeOCPjvFaN8YXGKX5O3/5qqb37n4NXgued/2uwb7A3+Huwu9Raja7E
yovBP4I/uPel4J9tdR/7X3Dv34JfBn+Ufs597P99qX0L33scX3b+RWXvcS/7
+B20LLrPadW8dr/z+D++Rf9CXiA2yAtN/7VD3i7to4di7yPKxPfplekfm36O
PELs0TM1PdGj7nnAtU2P+Zjrhtm7Pq7e6P+UOu5WT3IAuYAaQM4md5Pj+5nP
mW/yODzsJI83uX+xPPI2OXGO73G874Mvt3sGef44eU3dml266hZ0hzKoh2e6
B3nUhrnSL/im9EGv+r2vfrHX933ZN+M9n9Yndvn+e33DV5zHT6i71Gvq/UrP
nK+u8zyXmFygPceoI7qe5Vp45G7648c9Z7f3fbq1hhq7xJrCb/BlxgV1YJG1
ibq92FpD3R5rPSK3d/i/E/VkhXFEPVmqH1IrlpvnyRnE2vxW/Q9hj++/Q396
Ql37eZf9vVu+6S3xu52ue9i9T8p/1vUveYfc8UPydzr3fOn6PcBIH0otntmq
PUy7dZm3/R83tT6M
            "]], Polygon3DBox[CompressedData["
1:eJwtk0dSQ0EMBf9McQByDibHgh072JPB5AwmR5NzWsIJ4ARwAjgBnAAORL+S
Fl1uW/9rNJJcm8mmD2OSJN2QA2N8aYIS2AtJUsNnHuTiAQbwOTjHz6ADr4Zf
/Bva8apo/gm1eAF0Khe04ZXRYu9QhxdCT7BnWvGKaLFXaMSLYSFYPSk8P1ou
1dSCl8EL/ub1zcI6vgF9+AysBfut3s/rxYegAS+K5jpjBF+EbXzH76N6v/Af
r1/1fQT7TfWWRzv7w/uh++vZPxjFl6Ll2oVp1QZH+DEMej9V66b3Q/3qClbj
iL9/jV8Fm88y3OI3MOX5nvBHSOMrcBfsGc0vFyKe5+fNw0WwGQ77fZX70vul
/mm2p+qReh8tpnf6vZ+Knfh8NY9UsJpTvi86K+X59f5WsJ5OahbRan2ACTwT
ze9h3Ovfxw+g2ef7HKwHab+/dmHf69N91Lst3wfNQ7vz7PlWo+W+837p/Gyw
GUx4XGcd+r5p9zWrea9X9SmW9X3RPio26PPV/6XUZ1Tv+6RYj9evmGalHf0H
rSZJkg==
            "]]},
          Annotation[#, "Charting`Private`Tag$32550#2"]& ]],
        Lighting->
         Automatic]}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{499, 514, 500, 515, 501, 516, 502, 517, 503, 518, 504, 519, 
        505, 520, 506, 521, 507, 522, 508, 523, 509, 524, 510, 525, 511, 526, 
        512, 527, 513}], 
       Line3DBox[{528, 543, 529, 544, 530, 545, 531, 546, 532, 547, 533, 548, 
        534, 549, 535, 550, 536, 551, 537, 552, 538, 553, 539, 554, 540, 555, 
        541, 556, 542}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{558, 572, 557, 573, 559, 574, 560, 575, 561, 576, 562, 577, 
        563, 520, 564, 578, 565, 579, 566, 580, 567, 581, 568, 582, 569, 583, 
        570, 584, 571}], 
       Line3DBox[{586, 600, 585, 601, 587, 602, 588, 603, 589, 604, 590, 605, 
        591, 606, 592, 550, 593, 607, 594, 608, 595, 609, 596, 610, 597, 611, 
        598, 612, 599}]}}},
    VertexNormals->CompressedData["
1:eJztyDERwCAABMGfoAQl8YAEBmqsIyFp6KIgs1dcsbWvNq8k413Jad/5jHPO
Oeecc84555xzzjnnnHPOOeecc84555xzzjnnnHPOOef8f/4AzUbWjw==
     "]], 
   GraphicsComplex3DBox[CompressedData["
1:eJyF2sGLFnUYwPHNIOjeJSMweiuCEEK7SCiBmC906tTJYCuI8qWDF+seLNFB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    "], {{
      {RGBColor[0, 1, 0], Opacity[0.05], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxNmHe812MUx7++QolEGaFIKUl7l3K7mqjMZJbskb2JKCtCFK6Sq2FEbjIj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            "]], Polygon3DBox[CompressedData["
1:eJwtk0lWVFEQRPN9UEqxmeHYAc5QVAoERIHCZgxDGxBFpStABJzpCmAFsAJY
AawAV6DbsAFbuHEyBnHq5muyiffr6vTSeLOKiF7Uim4RjKBleAm1w/9KxDa8
iS4RnxAfwJ9RN/F91IQX0Xn4b8mzH71/Dz2Dn6Mb8BB6Grl2Hb6L5uE51OX9
hci1m/Bwlb00fV/5VGvB+6qv3JPuX+fFU86n/E8ia16A/9PfbuRMA8SP0Qd4
A932/Lr7AtXhUTQNv0QV/I37NfiK/Qh0yM8+uuxY3nxFg87/Fp51vUfoTeRa
u/3agnfcn/wW76GL7ld8YH//EH+KvNNC/L1kL9dcv6AvkT31ww/R68iarfCP
kmfr6Azxz5I8hs4R/yZeiaxxlvio5N4E6iGuoV8lPemFG1V68wrdgR+gmcia
de+vwu98X36KVaPP59fg976vftcj1/rtl95m3fXGqjy76n7lh761Zb9fzTMo
bnOvestxz695e+BOz6/5GpFrfc6vWWbsr/zS2Q6/v/wWt9mf45K5G34v/T/0
Ley6vvblnfw6BSlOVZU=
            "]]},
          Annotation[#, "Charting`Private`Tag$32571#1"]& ]],
        Lighting->Automatic]}, 
      {RGBColor[0, 1, 0], Opacity[0.05], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxNmHm41kUVx++8WVmBsu8Q+25laqipgFuCKYIIXGS9KGoWlLlUZpYpaZua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            "]], Polygon3DBox[CompressedData["
1:eJwtk0dSQ0EMBf9McQByDibHgh072JPB5AwmR5NzWsIJ4ARwAjgBnAAORL+S
Fl1uW/9rNJJcm8mmD2OSJN2QA2N8aYIS2AtJUsNnHuTiAQbwOTjHz6ADr4Zf
/Bva8apo/gm1eAF0Khe04ZXRYu9QhxdCT7BnWvGKaLFXaMSLYSFYPSk8P1ou
1dSCl8EL/ub1zcI6vgF9+AysBfut3s/rxYegAS+K5jpjBF+EbXzH76N6v/Af
r1/1fQT7TfWWRzv7w/uh++vZPxjFl6Ll2oVp1QZH+DEMej9V66b3Q/3qClbj
iL9/jV8Fm88y3OI3MOX5nvBHSOMrcBfsGc0vFyKe5+fNw0WwGQ77fZX70vul
/mm2p+qReh8tpnf6vZ+Knfh8NY9UsJpTvi86K+X59f5WsJ5OahbRan2ACTwT
ze9h3Ovfxw+g2ef7HKwHab+/dmHf69N91Lst3wfNQ7vz7PlWo+W+837p/Gyw
GUx4XGcd+r5p9zWrea9X9SmW9X3RPio26PPV/6XUZ1Tv+6RYj9evmGalHf0H
rSZJkg==
            "]]},
          Annotation[#, "Charting`Private`Tag$32571#2"]& ]],
        Lighting->
         Automatic]}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{499, 514, 500, 515, 501, 516, 502, 517, 503, 518, 504, 519, 
        505, 520, 506, 521, 507, 522, 508, 523, 509, 524, 510, 525, 511, 526, 
        512, 527, 513}], 
       Line3DBox[{528, 543, 529, 544, 530, 545, 531, 546, 532, 547, 533, 548, 
        534, 549, 535, 550, 536, 551, 537, 552, 538, 553, 539, 554, 540, 555, 
        541, 556, 542}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{558, 572, 557, 573, 559, 574, 560, 575, 561, 576, 562, 577, 
        563, 520, 564, 578, 565, 579, 566, 580, 567, 581, 568, 582, 569, 583, 
        570, 584, 571}], 
       Line3DBox[{586, 600, 585, 601, 587, 602, 588, 603, 589, 604, 590, 605, 
        591, 606, 592, 550, 593, 607, 594, 608, 595, 609, 596, 610, 597, 611, 
        598, 612, 599}]}}},
    VertexNormals->CompressedData["
1:eJztyDENACEQAMELKMESEgjUSMQSEqDmHXxmiy2mtFlHioh+l+Ntrw9xzjnn
nHPOOeecc84555xzzjnnnHPOOeecc84555xzzjnnnP/MD/VUCK0=
     "]]},
  Axes->True,
  ViewPoint->{100, 50, 20}]], "Output",
 CellChangeTimes->{
  3.73593014633633*^9},ExpressionUUID->"d896d964-778f-4b5d-9ccc-0a854a42334b"]
}, Open  ]],

Cell[TextData[{
 "\[LineSeparator]\[LineSeparator]\[LineSeparator]...and with a vector plot \
of the vector field ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox[
     StyleBox["F",
      FontWeight->"Bold"], "\[RightVector]"], "=", 
    RowBox[{
     SuperscriptBox["x", "2"], 
     OverscriptBox[
      StyleBox["i",
       FontWeight->"Bold"], "^"]}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "68cb5c24-c2f5-45e0-8c6f-dc776ce5d5b6"],
 ".  The only face contributing to the surface is the one at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "47f532f6-4896-4e89-98b7-12ca07f15bf5"],
 ".  On this face ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["F",
     FontWeight->"Bold"], "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "51d6791f-19ca-4f41-9083-c7c222534cee"],
 "is non-zero, and points parallel to the surface normal."
}], "Text",
 CellChangeTimes->{{3.735930159846404*^9, 3.735930182988373*^9}, {
  3.735940591457178*^9, 3.735940653473984*^9}, {3.735940695223797*^9, 
  3.735940818527218*^9}},ExpressionUUID->"3253c62d-a431-4631-b018-\
8717f89d8f7a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vp", "=", 
   RowBox[{"VectorPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "^", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.735929846710009*^9, 3.7359298477552643`*^9}, {
   3.7359298876430273`*^9, 3.735929927439481*^9}, 
   3.735930062456719*^9},ExpressionUUID->"157a6fd7-304d-46d0-943b-\
15a35e48e2f7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"ax", ",", "xy", ",", "yz", ",", "zx", ",", "vp", ",", " ", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"100", ",", "50", ",", "20"}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.73592847477379*^9, 3.735928481776774*^9}, {
   3.735928774359105*^9, 3.735928868812037*^9}, {3.735929948273334*^9, 
   3.735929950457266*^9}, 
   3.735930075144637*^9},ExpressionUUID->"d13dc5e0-7900-4a97-92cb-\
1a5930d744d2"],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 0.5, 0], 
    Text3DBox["\<\"x\"\>", {1.5750000000000002`, 0., 0.}], 
    {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {1.5, 0., 0.}}], 
     {Dashing[{Small, Small}], Line3DBox[{{-0.2, 0., 0.}, {0, 0, 0}}]}, 
     {RGBColor[
       NCache[
        Rational[2, 3], 0.6666666666666666], 
       NCache[
        Rational[2, 3], 0.6666666666666666], 0], Dashing[{}], 
      Text3DBox["\<\"y\"\>", {0., 1.5750000000000002`, 0.}], 
      {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0., 1.5, 0.}}], 
       {Dashing[{Small, Small}], Line3DBox[{{0., -0.2, 0.}, {0, 0, 0}}]}, 
       {RGBColor[0, 1, 0], Dashing[{}], 
        Text3DBox["\<\"z\"\>", {0., 0., 1.5750000000000002`}], 
        {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0., 0., 1.5}}], 
         {Dashing[{Small, Small}], Line3DBox[{{0., 0., -0.2}, {0, 0, 0}}]}, 
         {RGBColor[1, 0.5, 0], Dashing[{}], 
          Arrow3DBox[{{1, 0.5, 0.5}, {1.3, 0.5, 0.5}}], 
          Arrow3DBox[{{0, 0.5, 0.5}, {-0.3, 0.5, 0.5}}], 
          {RGBColor[
            NCache[
             Rational[2, 3], 0.6666666666666666], 
            NCache[
             Rational[2, 3], 0.6666666666666666], 0], 
           Arrow3DBox[{{0.5, 1, 0.5}, {0.5, 1.3, 0.5}}], 
           Arrow3DBox[{{0.5, 0, 0.5}, {0.5, -0.3, 0.5}}]}, 
          {RGBColor[0, 1, 0], Arrow3DBox[{{0.5, 0.5, 1}, {0.5, 0.5, 1.3}}], 
           Arrow3DBox[{{0.5, 0.5, 0}, {0.5, 0.5, -0.3}}]}}}}}}}}, 
   GraphicsComplex3DBox[CompressedData["
1:eJyN2sGrVOUfgPHJIGjfJiMwmooghNA2El4CKQdatWplcCuIcmjhxtoHEi10
EiUhKBci1MpqtDCIA666SJ2F5b2CBylJRD1/QbfrXJ57eJ/v+62GH7/p/cw7
M2ceju+cOfc8sfz+a29vG41Gb23834Mb91++/tX5I88d2sv9aHHrl97dufez
pybnluxf/3V1fTxpgo9/eGTX+enPwS9feuab8aQN/vHOSyvTtSvBXz65fHM+
XQv+wOK+C/7Gt5c/GU9uBP/xnc8fncz+CP7Y4wfPTNduBv/g1z27ZuNbwX/7
6OGf5tPbwV/Y8/ura/M7wY/dPXN1ff1ecMZ0dWc7ne10ttPZTmc7ne10ttPZ
Tmc7ne10ttPZTmc7ne10pp872xnb6Wyns53Odjrb6Wyns53Odjrb6Wyns53O
djrb6Uwnd7bzfDtjO53tdLbT2U5nO53tdLbT2U5nO53tdLbT2U5neriznc52
XtfO2E5nO53tdLbT2U5nO53tdLbT2U5nO53tdOZzu7OdznY623k/O2M7ne10
ttPZTmc7ne10ttPZTmc7ne105vO5s53Odjrb6WxnO+yM7XS209lOZzud7XS2
09lOZzud7XTmc7iznc52OtvpbKezne2zM7bT2U5nO53tdLbT2U5nO53tdGZ7
3dlOZzud7XS209lOZzvbbWdsp7OdznY62+lsp7OdznY6s13ubKeznc52Otvp
bKeznc52Po+dsZ3Odjrb6Wyns53Odjrz/u5sp7OdznY62+lsp7OdznY62/mc
dsZ2OtvpbKeznc52OvM+7myns53Odjrb6Wyns53Odjrb6Wzn89sZ2+lsp7Od
znY683rubKeznc52OtvpbKeznc52OtvpbKeznS52xnY62+lspzPPc2c7ne10
ttPZTmc7ne10ttPZTmc7ne10ttPLzthOZzudedyd7XS209lOZzud7XS209lO
Zzud7XS209lOZzsd7Yztf37/0MrTk9Nb9+5vf/P40qfTtbthPq9rZ8zz/Pp2
xpln2+/zkMy3Mz/r4/dd/eXk889OZlv3+IcvHZrPp/eCM+Zxz7ezfdnre/uZ
l22/X5/52flbvy/zsu33+46S22w82fjfufD4pjfB1zb+cc23zgd5fht8MX3r
9/ZwW918IPjf6/dv14MfW7z+jeBP3uet48Xh9t3i5W8Gf2WxobeCX11sz+3g
7y0+8J2k3//vyrjuTXA61+e3welsp7OdznY62+lsp7OdznY62+lc3x/7xON+
Wna2N8HLzp7fBi87N0nnJuncJJ2bpHOTdG6Szk3SuUk6+993n3j8d0/nujfB
Gdfnt8HpbKeznc52OtvpbKeznc52OtvpXF8v+8TjOlruz/YmeLk/e34bvNyf
22R/bpP9uU325zbZn9tkf26T/blN9uc22Z/9/dMnHr+X6Fz3Jjid6/Pb4Izt
dLbT2U5nO53tdLbT2U5nO53r3+d94vF7ns51b4LTuT6/Dc522Bnb6Wyns53O
djrb6Wyns53O9eOjPvF43ETnujfB6Vyf3wans53tszO209lOZzud7XS209lO
5/rxZp94PA6lc92b4HSuz2+D09lOZzvbbWdsp7OdznY62+lsp3P9+L1PPB7X
07nuTXA61+e3welsp7OdznY+j52xnc52OtvpbKdz/fdQn3j8nUTnujfB6Vyf
3wans53Odjrb6Wznc9oZ2+lsp7OdzvXfl33i8XcnneveBKdzfX4bnM52Otvp
bKeznc52Pr+dsZ3OdjrXf6/3icff8XSuexOczvX5bXA62+lsp7OdznY62+ls
p4udsZ3O9fMffeLxvAid694Ep3N9fhucznY62+lsp7OdznY62+lsp5edcf18
Up/48Lg7170JTuf6/DY4ne3lcWcfOtvL7/U+dLaX62YfOtvL/bIPne3l2B1O
L3E/0s2+meFuMr8Pzpjn+fXtjDPPtv+/Xrc+P/bx8zbnz5a4xzf3q3vBGfO4
59v9PM//93lx+/08v67nZ49n219/33gdOO7rgXFfv4r7ekvc1wfivp4N9/VX
uK8Xwn19C+7rMXBfP4D77924/z6L+++JeP3vF93SctLzbNJzR9JzJel5JOm5
L+lZ3g9+IOl5Mem5Pel5OOl5Jem5O+l5NOk5qt665Hx7l5wf7pLzmV1y/q1L
zhd1yfmNLvk93iW/H7vk906XHJ93yfFklxz/dMn3tfeDwbct7r940X4q6Xwi
6Xw96Xw86Xwh6Xwt6VzeDz5LOo+TzvOk8/6k82rS+aA6l+tpvO7RXq6z8TpS
e7nOxutI7eU6G68jtZfrbLyO1F6us/E6Unu5zsbrSO3lOjv4ctL5bNJzR9Jz
Jel5JOm5L+l5IOl2Mem2Pel2OOl2Jem2O+l2NOlWrpv5+sp/levp4OV66vnu
6eP2wcv1dPByPR28XE8HL9fTwcv1dPByPR28XE8HL9dTd4vfV+V6OvippP+J
pPP1pPPxpPOFpPO1pPMs6TlOes6TnvuTnqtJz4NJz38AsPKZpQ==
    "], {{
      {RGBColor[
        NCache[
         Rational[2, 3], 0.6666666666666666], 
        NCache[
         Rational[2, 3], 0.6666666666666666], 0], Opacity[0.05], EdgeForm[
       None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxNmHe812MUx7++QolEGaFIKUl7l3K7mqjMZJbskb2JKCtCFK6Sq2FEbjIj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            "]], Polygon3DBox[CompressedData["
1:eJwtk0lWVFEQRPN9UEqxmeHYAc5QVAoERIHCZgxDGxBFpStABJzpCmAFsAJY
AawAV6DbsAFbuHEyBnHq5muyiffr6vTSeLOKiF7Uim4RjKBleAm1w/9KxDa8
iS4RnxAfwJ9RN/F91IQX0Xn4b8mzH71/Dz2Dn6Mb8BB6Grl2Hb6L5uE51OX9
hci1m/Bwlb00fV/5VGvB+6qv3JPuX+fFU86n/E8ia16A/9PfbuRMA8SP0Qd4
A932/Lr7AtXhUTQNv0QV/I37NfiK/Qh0yM8+uuxY3nxFg87/Fp51vUfoTeRa
u/3agnfcn/wW76GL7ld8YH//EH+KvNNC/L1kL9dcv6AvkT31ww/R68iarfCP
kmfr6Azxz5I8hs4R/yZeiaxxlvio5N4E6iGuoV8lPemFG1V68wrdgR+gmcia
de+vwu98X36KVaPP59fg976vftcj1/rtl95m3fXGqjy76n7lh761Zb9fzTMo
bnOvestxz695e+BOz6/5GpFrfc6vWWbsr/zS2Q6/v/wWt9mf45K5G34v/T/0
Ley6vvblnfw6BSlOVZU=
            "]]},
          Annotation[#, "Charting`Private`Tag$32529#1"]& ]],
        Lighting->Automatic]}, 
      {RGBColor[
        NCache[
         Rational[2, 3], 0.6666666666666666], 
        NCache[
         Rational[2, 3], 0.6666666666666666], 0], Opacity[0.05], EdgeForm[
       None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxNmHm41kUVx++8WVmBsu8Q+25laqipgFuCKYIIXGS9KGoWlLlUZpYpaZua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            "]], Polygon3DBox[CompressedData["
1:eJwtk0dSQ0EMBf9McQByDibHgh072JPB5AwmR5NzWsIJ4ARwAjgBnAAORL+S
Fl1uW/9rNJJcm8mmD2OSJN2QA2N8aYIS2AtJUsNnHuTiAQbwOTjHz6ADr4Zf
/Bva8apo/gm1eAF0Khe04ZXRYu9QhxdCT7BnWvGKaLFXaMSLYSFYPSk8P1ou
1dSCl8EL/ub1zcI6vgF9+AysBfut3s/rxYegAS+K5jpjBF+EbXzH76N6v/Af
r1/1fQT7TfWWRzv7w/uh++vZPxjFl6Ll2oVp1QZH+DEMej9V66b3Q/3qClbj
iL9/jV8Fm88y3OI3MOX5nvBHSOMrcBfsGc0vFyKe5+fNw0WwGQ77fZX70vul
/mm2p+qReh8tpnf6vZ+Knfh8NY9UsJpTvi86K+X59f5WsJ5OahbRan2ACTwT
ze9h3Ovfxw+g2ef7HKwHab+/dmHf69N91Lst3wfNQ7vz7PlWo+W+837p/Gyw
GUx4XGcd+r5p9zWrea9X9SmW9X3RPio26PPV/6XUZ1Tv+6RYj9evmGalHf0H
rSZJkg==
            "]]},
          Annotation[#, "Charting`Private`Tag$32529#2"]& ]],
        Lighting->
         Automatic]}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{499, 514, 500, 515, 501, 516, 502, 517, 503, 518, 504, 519, 
        505, 520, 506, 521, 507, 522, 508, 523, 509, 524, 510, 525, 511, 526, 
        512, 527, 513}], 
       Line3DBox[{528, 543, 529, 544, 530, 545, 531, 546, 532, 547, 533, 548, 
        534, 549, 535, 550, 536, 551, 537, 552, 538, 553, 539, 554, 540, 555, 
        541, 556, 542}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{558, 572, 557, 573, 559, 574, 560, 575, 561, 576, 562, 577, 
        563, 520, 564, 578, 565, 579, 566, 580, 567, 581, 568, 582, 569, 583, 
        570, 584, 571}], 
       Line3DBox[{586, 600, 585, 601, 587, 602, 588, 603, 589, 604, 590, 605, 
        591, 606, 592, 550, 593, 607, 594, 608, 595, 609, 596, 610, 597, 611, 
        598, 612, 599}]}}},
    VertexNormals->CompressedData["
1:eJztyEERABAUQME/JJFEBxEMZ9VFoIACZt/hHbb01WaKiHGX49WunHPOOeec
c84555xzzjnnnHPOOeecc84555xzzjnnnHPOOee/+gGE49aP
     "]], 
   GraphicsComplex3DBox[CompressedData["
1:eJyF2sHLFGUcwPHNIOjeJSMw2ooghNAuEr4EUi506tTJ4K0gyqWDF+seSHTQ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    "], {{
      {RGBColor[1, 0.5, 0], Opacity[0.4], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxNmHe812MUx7++QolEGaFIKUl7l3K7mqjMZJbskb2JKCtCFK6Sq2FEbjIj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            "]], Polygon3DBox[CompressedData["
1:eJwtk0lWVFEQRPN9UEqxmeHYAc5QVAoERIHCZgxDGxBFpStABJzpCmAFsAJY
AawAV6DbsAFbuHEyBnHq5muyiffr6vTSeLOKiF7Uim4RjKBleAm1w/9KxDa8
iS4RnxAfwJ9RN/F91IQX0Xn4b8mzH71/Dz2Dn6Mb8BB6Grl2Hb6L5uE51OX9
hci1m/Bwlb00fV/5VGvB+6qv3JPuX+fFU86n/E8ia16A/9PfbuRMA8SP0Qd4
A932/Lr7AtXhUTQNv0QV/I37NfiK/Qh0yM8+uuxY3nxFg87/Fp51vUfoTeRa
u/3agnfcn/wW76GL7ld8YH//EH+KvNNC/L1kL9dcv6AvkT31ww/R68iarfCP
kmfr6Azxz5I8hs4R/yZeiaxxlvio5N4E6iGuoV8lPemFG1V68wrdgR+gmcia
de+vwu98X36KVaPP59fg976vftcj1/rtl95m3fXGqjy76n7lh761Zb9fzTMo
bnOvestxz695e+BOz6/5GpFrfc6vWWbsr/zS2Q6/v/wWt9mf45K5G34v/T/0
Ley6vvblnfw6BSlOVZU=
            "]]},
          Annotation[#, "Charting`Private`Tag$32550#1"]& ]],
        Lighting->Automatic]}, 
      {RGBColor[1, 0.5, 0], Opacity[0.4], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxNmHm41kUVx++8WVmBsu8Q+25laqipgFuCKYIIXGS9KGoWlLlUZpYpaZua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            "]], Polygon3DBox[CompressedData["
1:eJwtk0dSQ0EMBf9McQByDibHgh072JPB5AwmR5NzWsIJ4ARwAjgBnAAORL+S
Fl1uW/9rNJJcm8mmD2OSJN2QA2N8aYIS2AtJUsNnHuTiAQbwOTjHz6ADr4Zf
/Bva8apo/gm1eAF0Khe04ZXRYu9QhxdCT7BnWvGKaLFXaMSLYSFYPSk8P1ou
1dSCl8EL/ub1zcI6vgF9+AysBfut3s/rxYegAS+K5jpjBF+EbXzH76N6v/Af
r1/1fQT7TfWWRzv7w/uh++vZPxjFl6Ll2oVp1QZH+DEMej9V66b3Q/3qClbj
iL9/jV8Fm88y3OI3MOX5nvBHSOMrcBfsGc0vFyKe5+fNw0WwGQ77fZX70vul
/mm2p+qReh8tpnf6vZ+Knfh8NY9UsJpTvi86K+X59f5WsJ5OahbRan2ACTwT
ze9h3Ovfxw+g2ef7HKwHab+/dmHf69N91Lst3wfNQ7vz7PlWo+W+837p/Gyw
GUx4XGcd+r5p9zWrea9X9SmW9X3RPio26PPV/6XUZ1Tv+6RYj9evmGalHf0H
rSZJkg==
            "]]},
          Annotation[#, "Charting`Private`Tag$32550#2"]& ]],
        Lighting->
         Automatic]}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{499, 514, 500, 515, 501, 516, 502, 517, 503, 518, 504, 519, 
        505, 520, 506, 521, 507, 522, 508, 523, 509, 524, 510, 525, 511, 526, 
        512, 527, 513}], 
       Line3DBox[{528, 543, 529, 544, 530, 545, 531, 546, 532, 547, 533, 548, 
        534, 549, 535, 550, 536, 551, 537, 552, 538, 553, 539, 554, 540, 555, 
        541, 556, 542}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{558, 572, 557, 573, 559, 574, 560, 575, 561, 576, 562, 577, 
        563, 520, 564, 578, 565, 579, 566, 580, 567, 581, 568, 582, 569, 583, 
        570, 584, 571}], 
       Line3DBox[{586, 600, 585, 601, 587, 602, 588, 603, 589, 604, 590, 605, 
        591, 606, 592, 550, 593, 607, 594, 608, 595, 609, 596, 610, 597, 611, 
        598, 612, 599}]}}},
    VertexNormals->CompressedData["
1:eJztyDERwCAABMGfoAQl8YAEBmqsIyFp6KIgs1dcsbWvNq8k413Jad/5jHPO
Oeecc84555xzzjnnnHPOOeecc84555xzzjnnnHPOOef8f/4AzUbWjw==
     "]], 
   GraphicsComplex3DBox[CompressedData["
1:eJyF2sGLFnUYwPHNIOjeJSMweiuCEEK7SCiBmC906tTJYCuI8qWDF+seLNFB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    "], {{
      {RGBColor[0, 1, 0], Opacity[0.05], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxNmHe812MUx7++QolEGaFIKUl7l3K7mqjMZJbskb2JKCtCFK6Sq2FEbjIj
GsqeUZKVlS2hJeu8Pe/vS398Xs/vPOt8znme73M+99YdfNbBZ+ZZlk3dKMs2
jvaLAPbWgZ0DWwS2DOwQqByoEvgt5uYxabP4vSLwdeCrwHaBTbPUv1Ogqut3
DGyu3SJQN7BboHlgV+1mgV20a+mHNdsGNnHfbeQGzxq2lQJ7ybV2YA+5skfD
wPbadY2JPRrLjzWNnAvHPW0Zq+ne+O4eaBNoqw/yUS3QRLuOvKvr43dymad8
rI7fm8Tv1vG7h3u0Ew3luz7mbB5zrozfrQL1AvUDHeQHr5bmjLEugabmDOxj
362BYYGrAp2Mk9x0dA/s9vpk39b62V1eDeS0KvhUylN/b3mwRy/XY/c0Buy+
+odHqVyJo0+gs2P7uUcn5zXz/Pd1LlxK7OOO7O/cvQNd7WspV+7EduZjG+9C
PVvO7TDPjHwPDPQLHBg4LnBQ4ODAoYFuzlsb8W6Wp/418XvTPPE63DiJ+1jj
ZK8jzAsxDXAcu78+WXOq844MnOI87JPdF3th4NvAu7bfBZYFfgwsD7wfWGk/
4y8Hng48EygPTA9UZOkudDHXJ8kDH4OMm5iPDxxi3CeaI+adYB/2MZ5ZX3nv
5zkcHTjAsSsCZwbOClwaOC1wepbuLn1nB/6IHFbJ0++hgSGuucy5ZwQut2Ws
vufGuXJ3zwmca665KyXGwD0oNaYSbe4Hd5xvcV34rZync75Rf/gZETg/cEHg
GtsLvQfsx1kPD5znvGsdvyhwne3FgRsClxj3KGMjHzfpB/tqubPXSOfC42bn
kife2O+z9Jbd5hr8F+8ad/qFwKOeL+f9YOAhz/8B7TI54eeuwPXarJsQuDdw
t+Pk48/IT9U8cSnP0nsxOjBRHrcH7rMPe6Y+pwaetX048JztI64Zbo5nuNek
LN3Ncvcba97J6x225HWM6xgbbx7J69/Bc8s87X+PfXB+PjDN+J4ITA5MCTwV
uN+8PKbPicZ/i3FO1h9c/on9q+UpjrfM9ezAHHmzx2vGzJx3HJsbGGcu4fqq
OWLei4HH5TXPXGAvCDwpx1c8S9a8aTz4fiMwS3uu/meY3/Hm4K/gvEWefk8x
jjs8h3HOm+p5j/PcyrQrzEW5nCaZj0me3xjjrzB+8nhnlu7Ug7bs9fYGeVpt
jaAuvitv4l5inOTmgyy9WdjLzQVv2oeOk+NF9r8U4IPYKk/9y8w7e39sjsjZ
R4HXtT+xjzP81BaOi90P35/Zx14/Zekd5d1FT1BDCn1BWzNR+O/7K+o4OgcN
gfZBR/AbTYN2QCd8maXvmdqPLqjt2ELzwb1Ax6Ar0BlVXYddxT72/cq11fSN
Xtk1S28jtbGVHHe3D467Oa+of9ir1B4N5Eo9b6CPPbThx5vZOPtf9zQy/vru
Vcs+1qDLqNdN5d7YNZVcU0PuTdy3utxZx1vCm361/KjhLfTRSht+6I828mun
je/22uzLW99J32iJDvppLr9G9rU3Ly0ca+w61nAPvwnMd6wkSzWGuV214UVN
oDasUb+hFaix1MY+8i7dYA01qZ8xoCm6yRst0EMf/Vzf2T0OkGsv57V1bnfn
oTmoydRh6nGhO2jRD2vVKofojzrOb2ottWaoHKlzB7nvYc7DT39tfB+uDSfq
/VHmbH/9d3WPA+U7wDV95Mia9db9YZ5Db+eiC66UE28bb8WcLL01tLONCc2E
VuLtm+e8Afahm7rH3u3ypF96RtshT/2l6OvAYM6NNylPeqdbtG3zpHEWePbz
5c26QivRFpqIlvlDzN/lxo2mGOQZDvRs/lBvoFcKTUOtRxNR99EKp9uHvU6d
Cc+O5rW3ZwbfweZ3kD4OlQtjFeaJesH7zrtfvPe0vPfoDr4zvjf0x3BtNM0I
7UIDjfA8qKvUV/TOtY7BGx1xvTFR6wr9wN8pt5ibUY4VOon1nD31ljl/qTcm
uH6cfOGEvhgtp9u14TRGGx5jtQvdMFZO1KM75VimPdK9y8z1SMfhN17f8L1H
+yr93+r53OiacxwbZgzUzQlyol5OlFNRPxlDj0wzBsYLzTPFeXClpt6f/V9T
H5DHI54la/g2puuzwn3LPFvW/K0GwBf3rpValxjKXVfos2f1jR55XN9okCeN
+z7XTHJ8hpyedh7+ntHG/0xtfKNT0Cv/qNNmGfcMYyj04kxjeME1XWJuszy9
Fz2ibZ+nb2+faJvn6ZvCN7Wb75X7Tu2mrvMWoAXeMQbG58udGjtPri+7Hv/o
iEKj0Rb66xXnsTf6AO2AnkBnFPqCdmmW9MUnjuETvYKG6RV8O+bpbfo5sDpL
mv6XLNWX5cb9lnvgDz20WC5ooCXyXmhshY7B30ZqoaXyXeL6OebgbXP6ptwR
LmhauK/K0t+N6B3+P/NbYCt5/sregd/l+qMt9nvOZc0PWdIk/G+njutYj96h
vqN5tt5gHrqltr/ruMca1692LX7Xye3zLGmxZRuc6zLPY5Yxve667/W30tg+
1+8K/X3pvC+MeaV7F7FxFmv9/Z68VpiTXxzjzF7yfBb5m7vIndo78to0TzVx
pTHwN/m+1hfe2q5+j/zNW9l6xFvS2TtPfeCet8hTfS61TvFmd7Ou8U6XRNsy
TzWzu9/IBfazlrrQxe9liPs3yVP97WFNvFA+7DMoS3e1U57+hu3pvb3IuFhL
jfoX0TNXfQ==
            "]], Polygon3DBox[CompressedData["
1:eJwtk0lWVFEQRPN9UEqxmeHYAc5QVAoERIHCZgxDGxBFpStABJzpCmAFsAJY
AawAV6DbsAFbuHEyBnHq5muyiffr6vTSeLOKiF7Uim4RjKBleAm1w/9KxDa8
iS4RnxAfwJ9RN/F91IQX0Xn4b8mzH71/Dz2Dn6Mb8BB6Grl2Hb6L5uE51OX9
hci1m/Bwlb00fV/5VGvB+6qv3JPuX+fFU86n/E8ia16A/9PfbuRMA8SP0Qd4
A932/Lr7AtXhUTQNv0QV/I37NfiK/Qh0yM8+uuxY3nxFg87/Fp51vUfoTeRa
u/3agnfcn/wW76GL7ld8YH//EH+KvNNC/L1kL9dcv6AvkT31ww/R68iarfCP
kmfr6Azxz5I8hs4R/yZeiaxxlvio5N4E6iGuoV8lPemFG1V68wrdgR+gmcia
de+vwu98X36KVaPP59fg976vftcj1/rtl95m3fXGqjy76n7lh761Zb9fzTMo
bnOvestxz695e+BOz6/5GpFrfc6vWWbsr/zS2Q6/v/wWt9mf45K5G34v/T/0
Ley6vvblnfw6BSlOVZU=
            "]]},
          Annotation[#, "Charting`Private`Tag$32571#1"]& ]],
        Lighting->Automatic]}, 
      {RGBColor[0, 1, 0], Opacity[0.05], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxNmHm41kUVx++8WVmBsu8Q+25laqipgFuCKYIIXGS9KGoWlLlUZpYpaZua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            "]], Polygon3DBox[CompressedData["
1:eJwtk0dSQ0EMBf9McQByDibHgh072JPB5AwmR5NzWsIJ4ARwAjgBnAAORL+S
Fl1uW/9rNJJcm8mmD2OSJN2QA2N8aYIS2AtJUsNnHuTiAQbwOTjHz6ADr4Zf
/Bva8apo/gm1eAF0Khe04ZXRYu9QhxdCT7BnWvGKaLFXaMSLYSFYPSk8P1ou
1dSCl8EL/ub1zcI6vgF9+AysBfut3s/rxYegAS+K5jpjBF+EbXzH76N6v/Af
r1/1fQT7TfWWRzv7w/uh++vZPxjFl6Ll2oVp1QZH+DEMej9V66b3Q/3qClbj
iL9/jV8Fm88y3OI3MOX5nvBHSOMrcBfsGc0vFyKe5+fNw0WwGQ77fZX70vul
/mm2p+qReh8tpnf6vZ+Knfh8NY9UsJpTvi86K+X59f5WsJ5OahbRan2ACTwT
ze9h3Ovfxw+g2ef7HKwHab+/dmHf69N91Lst3wfNQ7vz7PlWo+W+837p/Gyw
GUx4XGcd+r5p9zWrea9X9SmW9X3RPio26PPV/6XUZ1Tv+6RYj9evmGalHf0H
rSZJkg==
            "]]},
          Annotation[#, "Charting`Private`Tag$32571#2"]& ]],
        Lighting->
         Automatic]}, {}, {}, {}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{499, 514, 500, 515, 501, 516, 502, 517, 503, 518, 504, 519, 
        505, 520, 506, 521, 507, 522, 508, 523, 509, 524, 510, 525, 511, 526, 
        512, 527, 513}], 
       Line3DBox[{528, 543, 529, 544, 530, 545, 531, 546, 532, 547, 533, 548, 
        534, 549, 535, 550, 536, 551, 537, 552, 538, 553, 539, 554, 540, 555, 
        541, 556, 542}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{558, 572, 557, 573, 559, 574, 560, 575, 561, 576, 562, 577, 
        563, 520, 564, 578, 565, 579, 566, 580, 567, 581, 568, 582, 569, 583, 
        570, 584, 571}], 
       Line3DBox[{586, 600, 585, 601, 587, 602, 588, 603, 589, 604, 590, 605, 
        591, 606, 592, 550, 593, 607, 594, 608, 595, 609, 596, 610, 597, 611, 
        598, 612, 599}]}}},
    VertexNormals->CompressedData["
1:eJztyDENACEQAMELKMESEgjUSMQSEqDmHXxmiy2mtFlHioh+l+Ntrw9xzjnn
nHPOOeecc84555xzzjnnnHPOOeecc84555xzzjnnnP/MD/VUCK0=
     "]], {{}, 
    {RGBColor[0.2947336, 0.4054232, 0.5678384000000001], 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0., 0.}, {0.1453819982617622, 0., 
       0.}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0., 0.14285714285714285`}, {
       0.1453819982617622, 0., 0.14285714285714285`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0., 0.2857142857142857}, {
       0.1453819982617622, 0., 0.2857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0., 0.42857142857142855`}, {
       0.1453819982617622, 0., 0.42857142857142855`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0., 0.5714285714285714}, {
       0.1453819982617622, 0., 0.5714285714285714}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0., 0.7142857142857142}, {
       0.1453819982617622, 0., 0.7142857142857142}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0., 0.857142857142857}, {
       0.1453819982617622, 0., 0.857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0., 0.9999999999999998}, {
       0.1453819982617622, 0., 0.9999999999999998}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.14285714285714285`, 0.}, {
       0.1453819982617622, 0.14285714285714285`, 0.}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.14285714285714285`, 
       0.14285714285714285`}, {0.1453819982617622, 0.14285714285714285`, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.14285714285714285`, 
       0.2857142857142857}, {0.1453819982617622, 0.14285714285714285`, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.14285714285714285`, 
       0.42857142857142855`}, {0.1453819982617622, 0.14285714285714285`, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.14285714285714285`, 
       0.5714285714285714}, {0.1453819982617622, 0.14285714285714285`, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.14285714285714285`, 
       0.7142857142857142}, {0.1453819982617622, 0.14285714285714285`, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.14285714285714285`, 
       0.857142857142857}, {0.1453819982617622, 0.14285714285714285`, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.14285714285714285`, 
       0.9999999999999998}, {0.1453819982617622, 0.14285714285714285`, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.2857142857142857, 0.}, {
       0.1453819982617622, 0.2857142857142857, 0.}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.2857142857142857, 
       0.14285714285714285`}, {0.1453819982617622, 0.2857142857142857, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.2857142857142857, 
       0.2857142857142857}, {0.1453819982617622, 0.2857142857142857, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.2857142857142857, 
       0.42857142857142855`}, {0.1453819982617622, 0.2857142857142857, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.2857142857142857, 
       0.5714285714285714}, {0.1453819982617622, 0.2857142857142857, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.2857142857142857, 
       0.7142857142857142}, {0.1453819982617622, 0.2857142857142857, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.2857142857142857, 
       0.857142857142857}, {0.1453819982617622, 0.2857142857142857, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.2857142857142857, 
       0.9999999999999998}, {0.1453819982617622, 0.2857142857142857, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.42857142857142855`, 0.}, {
       0.1453819982617622, 0.42857142857142855`, 0.}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.42857142857142855`, 
       0.14285714285714285`}, {0.1453819982617622, 0.42857142857142855`, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.42857142857142855`, 
       0.2857142857142857}, {0.1453819982617622, 0.42857142857142855`, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.42857142857142855`, 
       0.42857142857142855`}, {0.1453819982617622, 0.42857142857142855`, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.42857142857142855`, 
       0.5714285714285714}, {0.1453819982617622, 0.42857142857142855`, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.42857142857142855`, 
       0.7142857142857142}, {0.1453819982617622, 0.42857142857142855`, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.42857142857142855`, 
       0.857142857142857}, {0.1453819982617622, 0.42857142857142855`, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.42857142857142855`, 
       0.9999999999999998}, {0.1453819982617622, 0.42857142857142855`, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.5714285714285714, 0.}, {
       0.1453819982617622, 0.5714285714285714, 0.}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.5714285714285714, 
       0.14285714285714285`}, {0.1453819982617622, 0.5714285714285714, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.5714285714285714, 
       0.2857142857142857}, {0.1453819982617622, 0.5714285714285714, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.5714285714285714, 
       0.42857142857142855`}, {0.1453819982617622, 0.5714285714285714, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.5714285714285714, 
       0.5714285714285714}, {0.1453819982617622, 0.5714285714285714, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.5714285714285714, 
       0.7142857142857142}, {0.1453819982617622, 0.5714285714285714, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.5714285714285714, 
       0.857142857142857}, {0.1453819982617622, 0.5714285714285714, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.5714285714285714, 
       0.9999999999999998}, {0.1453819982617622, 0.5714285714285714, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.7142857142857142, 0.}, {
       0.1453819982617622, 0.7142857142857142, 0.}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.7142857142857142, 
       0.14285714285714285`}, {0.1453819982617622, 0.7142857142857142, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.7142857142857142, 
       0.2857142857142857}, {0.1453819982617622, 0.7142857142857142, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.7142857142857142, 
       0.42857142857142855`}, {0.1453819982617622, 0.7142857142857142, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.7142857142857142, 
       0.5714285714285714}, {0.1453819982617622, 0.7142857142857142, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.7142857142857142, 
       0.7142857142857142}, {0.1453819982617622, 0.7142857142857142, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.7142857142857142, 
       0.857142857142857}, {0.1453819982617622, 0.7142857142857142, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.7142857142857142, 
       0.9999999999999998}, {0.1453819982617622, 0.7142857142857142, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.857142857142857, 0.}, {
       0.1453819982617622, 0.857142857142857, 0.}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.857142857142857, 
       0.14285714285714285`}, {0.1453819982617622, 0.857142857142857, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.857142857142857, 
       0.2857142857142857}, {0.1453819982617622, 0.857142857142857, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.857142857142857, 
       0.42857142857142855`}, {0.1453819982617622, 0.857142857142857, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.857142857142857, 
       0.5714285714285714}, {0.1453819982617622, 0.857142857142857, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.857142857142857, 
       0.7142857142857142}, {0.1453819982617622, 0.857142857142857, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.857142857142857, 
       0.857142857142857}, {0.1453819982617622, 0.857142857142857, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.857142857142857, 
       0.9999999999999998}, {0.1453819982617622, 0.857142857142857, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.9999999999999998, 0.}, {
       0.1453819982617622, 0.9999999999999998, 0.}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.9999999999999998, 
       0.14285714285714285`}, {0.1453819982617622, 0.9999999999999998, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.9999999999999998, 
       0.2857142857142857}, {0.1453819982617622, 0.9999999999999998, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.9999999999999998, 
       0.42857142857142855`}, {0.1453819982617622, 0.9999999999999998, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.9999999999999998, 
       0.5714285714285714}, {0.1453819982617622, 0.9999999999999998, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.9999999999999998, 
       0.7142857142857142}, {0.1453819982617622, 0.9999999999999998, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.9999999999999998, 
       0.857142857142857}, {0.1453819982617622, 0.9999999999999998, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.0012144217816746437`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.1403322874525235, 0.9999999999999998, 
       0.9999999999999998}, {0.1453819982617622, 0.9999999999999998, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0., 0.}, {0.29581370733276313`, 0., 
       0.}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0., 0.14285714285714285`}, {
       0.29581370733276313`, 0., 0.14285714285714285`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0., 0.2857142857142857}, {
       0.29581370733276313`, 0., 0.2857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0., 0.42857142857142855`}, {
       0.29581370733276313`, 0., 0.42857142857142855`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0., 0.5714285714285714}, {
       0.29581370733276313`, 0., 0.5714285714285714}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0., 0.7142857142857142}, {
       0.29581370733276313`, 0., 0.7142857142857142}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0., 0.857142857142857}, {
       0.29581370733276313`, 0., 0.857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0., 0.9999999999999998}, {
       0.29581370733276313`, 0., 0.9999999999999998}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.14285714285714285`, 0.}, {
       0.29581370733276313`, 0.14285714285714285`, 0.}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.14285714285714285`, 
       0.14285714285714285`}, {0.29581370733276313`, 0.14285714285714285`, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.14285714285714285`, 
       0.2857142857142857}, {0.29581370733276313`, 0.14285714285714285`, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.14285714285714285`, 
       0.42857142857142855`}, {0.29581370733276313`, 0.14285714285714285`, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.14285714285714285`, 
       0.5714285714285714}, {0.29581370733276313`, 0.14285714285714285`, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.14285714285714285`, 
       0.7142857142857142}, {0.29581370733276313`, 0.14285714285714285`, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.14285714285714285`, 
       0.857142857142857}, {0.29581370733276313`, 0.14285714285714285`, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.14285714285714285`, 
       0.9999999999999998}, {0.29581370733276313`, 0.14285714285714285`, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.2857142857142857, 0.}, {
       0.29581370733276313`, 0.2857142857142857, 0.}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.2857142857142857, 
       0.14285714285714285`}, {0.29581370733276313`, 0.2857142857142857, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.2857142857142857, 
       0.2857142857142857}, {0.29581370733276313`, 0.2857142857142857, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.2857142857142857, 
       0.42857142857142855`}, {0.29581370733276313`, 0.2857142857142857, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.2857142857142857, 
       0.5714285714285714}, {0.29581370733276313`, 0.2857142857142857, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.2857142857142857, 
       0.7142857142857142}, {0.29581370733276313`, 0.2857142857142857, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.2857142857142857, 
       0.857142857142857}, {0.29581370733276313`, 0.2857142857142857, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.2857142857142857, 
       0.9999999999999998}, {0.29581370733276313`, 0.2857142857142857, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.42857142857142855`, 0.}, {
       0.29581370733276313`, 0.42857142857142855`, 0.}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.42857142857142855`, 
       0.14285714285714285`}, {0.29581370733276313`, 0.42857142857142855`, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.42857142857142855`, 
       0.2857142857142857}, {0.29581370733276313`, 0.42857142857142855`, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.42857142857142855`, 
       0.42857142857142855`}, {0.29581370733276313`, 0.42857142857142855`, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.42857142857142855`, 
       0.5714285714285714}, {0.29581370733276313`, 0.42857142857142855`, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.42857142857142855`, 
       0.7142857142857142}, {0.29581370733276313`, 0.42857142857142855`, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.42857142857142855`, 
       0.857142857142857}, {0.29581370733276313`, 0.42857142857142855`, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.42857142857142855`, 
       0.9999999999999998}, {0.29581370733276313`, 0.42857142857142855`, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.5714285714285714, 0.}, {
       0.29581370733276313`, 0.5714285714285714, 0.}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.5714285714285714, 
       0.14285714285714285`}, {0.29581370733276313`, 0.5714285714285714, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.5714285714285714, 
       0.2857142857142857}, {0.29581370733276313`, 0.5714285714285714, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.5714285714285714, 
       0.42857142857142855`}, {0.29581370733276313`, 0.5714285714285714, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.5714285714285714, 
       0.5714285714285714}, {0.29581370733276313`, 0.5714285714285714, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.5714285714285714, 
       0.7142857142857142}, {0.29581370733276313`, 0.5714285714285714, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.5714285714285714, 
       0.857142857142857}, {0.29581370733276313`, 0.5714285714285714, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.5714285714285714, 
       0.9999999999999998}, {0.29581370733276313`, 0.5714285714285714, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.7142857142857142, 0.}, {
       0.29581370733276313`, 0.7142857142857142, 0.}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.7142857142857142, 
       0.14285714285714285`}, {0.29581370733276313`, 0.7142857142857142, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.7142857142857142, 
       0.2857142857142857}, {0.29581370733276313`, 0.7142857142857142, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.7142857142857142, 
       0.42857142857142855`}, {0.29581370733276313`, 0.7142857142857142, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.7142857142857142, 
       0.5714285714285714}, {0.29581370733276313`, 0.7142857142857142, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.7142857142857142, 
       0.7142857142857142}, {0.29581370733276313`, 0.7142857142857142, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.7142857142857142, 
       0.857142857142857}, {0.29581370733276313`, 0.7142857142857142, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.7142857142857142, 
       0.9999999999999998}, {0.29581370733276313`, 0.7142857142857142, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.857142857142857, 0.}, {
       0.29581370733276313`, 0.857142857142857, 0.}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.857142857142857, 
       0.14285714285714285`}, {0.29581370733276313`, 0.857142857142857, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.857142857142857, 
       0.2857142857142857}, {0.29581370733276313`, 0.857142857142857, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.857142857142857, 
       0.42857142857142855`}, {0.29581370733276313`, 0.857142857142857, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.857142857142857, 
       0.5714285714285714}, {0.29581370733276313`, 0.857142857142857, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.857142857142857, 
       0.7142857142857142}, {0.29581370733276313`, 0.857142857142857, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.857142857142857, 
       0.857142857142857}, {0.29581370733276313`, 0.857142857142857, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.857142857142857, 
       0.9999999999999998}, {0.29581370733276313`, 0.857142857142857, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.9999999999999998, 0.}, {
       0.29581370733276313`, 0.9999999999999998, 0.}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.9999999999999998, 
       0.14285714285714285`}, {0.29581370733276313`, 0.9999999999999998, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.9999999999999998, 
       0.2857142857142857}, {0.29581370733276313`, 0.9999999999999998, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.9999999999999998, 
       0.42857142857142855`}, {0.29581370733276313`, 0.9999999999999998, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.9999999999999998, 
       0.5714285714285714}, {0.29581370733276313`, 0.9999999999999998, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.9999999999999998, 
       0.7142857142857142}, {0.29581370733276313`, 0.9999999999999998, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.9999999999999998, 
       0.857142857142857}, {0.29581370733276313`, 0.9999999999999998, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.004857687126698575, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.27561486409580827`, 0.9999999999999998, 
       0.9999999999999998}, {0.29581370733276313`, 0.9999999999999998, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0., 0.}, {0.45129512721300274`, 0., 
       0.}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0., 0.14285714285714285`}, {
       0.45129512721300274`, 0., 0.14285714285714285`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0., 0.2857142857142857}, {
       0.45129512721300274`, 0., 0.2857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0., 0.42857142857142855`}, {
       0.45129512721300274`, 0., 0.42857142857142855`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0., 0.5714285714285714}, {
       0.45129512721300274`, 0., 0.5714285714285714}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0., 0.7142857142857142}, {
       0.45129512721300274`, 0., 0.7142857142857142}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0., 0.857142857142857}, {
       0.45129512721300274`, 0., 0.857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0., 0.9999999999999998}, {
       0.45129512721300274`, 0., 0.9999999999999998}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.14285714285714285`, 0.}, {
       0.45129512721300274`, 0.14285714285714285`, 0.}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.14285714285714285`, 
       0.14285714285714285`}, {0.45129512721300274`, 0.14285714285714285`, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.14285714285714285`, 
       0.2857142857142857}, {0.45129512721300274`, 0.14285714285714285`, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.14285714285714285`, 
       0.42857142857142855`}, {0.45129512721300274`, 0.14285714285714285`, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.14285714285714285`, 
       0.5714285714285714}, {0.45129512721300274`, 0.14285714285714285`, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.14285714285714285`, 
       0.7142857142857142}, {0.45129512721300274`, 0.14285714285714285`, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.14285714285714285`, 
       0.857142857142857}, {0.45129512721300274`, 0.14285714285714285`, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.14285714285714285`, 
       0.9999999999999998}, {0.45129512721300274`, 0.14285714285714285`, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.2857142857142857, 0.}, {
       0.45129512721300274`, 0.2857142857142857, 0.}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.2857142857142857, 
       0.14285714285714285`}, {0.45129512721300274`, 0.2857142857142857, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.2857142857142857, 
       0.2857142857142857}, {0.45129512721300274`, 0.2857142857142857, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.2857142857142857, 
       0.42857142857142855`}, {0.45129512721300274`, 0.2857142857142857, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.2857142857142857, 
       0.5714285714285714}, {0.45129512721300274`, 0.2857142857142857, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.2857142857142857, 
       0.7142857142857142}, {0.45129512721300274`, 0.2857142857142857, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.2857142857142857, 
       0.857142857142857}, {0.45129512721300274`, 0.2857142857142857, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.2857142857142857, 
       0.9999999999999998}, {0.45129512721300274`, 0.2857142857142857, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.42857142857142855`, 0.}, {
       0.45129512721300274`, 0.42857142857142855`, 0.}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.42857142857142855`, 
       0.14285714285714285`}, {0.45129512721300274`, 0.42857142857142855`, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.42857142857142855`, 
       0.2857142857142857}, {0.45129512721300274`, 0.42857142857142855`, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.42857142857142855`, 
       0.42857142857142855`}, {0.45129512721300274`, 0.42857142857142855`, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.42857142857142855`, 
       0.5714285714285714}, {0.45129512721300274`, 0.42857142857142855`, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.42857142857142855`, 
       0.7142857142857142}, {0.45129512721300274`, 0.42857142857142855`, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.42857142857142855`, 
       0.857142857142857}, {0.45129512721300274`, 0.42857142857142855`, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.42857142857142855`, 
       0.9999999999999998}, {0.45129512721300274`, 0.42857142857142855`, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.5714285714285714, 0.}, {
       0.45129512721300274`, 0.5714285714285714, 0.}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.5714285714285714, 
       0.14285714285714285`}, {0.45129512721300274`, 0.5714285714285714, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.5714285714285714, 
       0.2857142857142857}, {0.45129512721300274`, 0.5714285714285714, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.5714285714285714, 
       0.42857142857142855`}, {0.45129512721300274`, 0.5714285714285714, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.5714285714285714, 
       0.5714285714285714}, {0.45129512721300274`, 0.5714285714285714, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.5714285714285714, 
       0.7142857142857142}, {0.45129512721300274`, 0.5714285714285714, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.5714285714285714, 
       0.857142857142857}, {0.45129512721300274`, 0.5714285714285714, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.5714285714285714, 
       0.9999999999999998}, {0.45129512721300274`, 0.5714285714285714, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.7142857142857142, 0.}, {
       0.45129512721300274`, 0.7142857142857142, 0.}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.7142857142857142, 
       0.14285714285714285`}, {0.45129512721300274`, 0.7142857142857142, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.7142857142857142, 
       0.2857142857142857}, {0.45129512721300274`, 0.7142857142857142, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.7142857142857142, 
       0.42857142857142855`}, {0.45129512721300274`, 0.7142857142857142, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.7142857142857142, 
       0.5714285714285714}, {0.45129512721300274`, 0.7142857142857142, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.7142857142857142, 
       0.7142857142857142}, {0.45129512721300274`, 0.7142857142857142, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.7142857142857142, 
       0.857142857142857}, {0.45129512721300274`, 0.7142857142857142, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.7142857142857142, 
       0.9999999999999998}, {0.45129512721300274`, 0.7142857142857142, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.857142857142857, 0.}, {
       0.45129512721300274`, 0.857142857142857, 0.}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.857142857142857, 
       0.14285714285714285`}, {0.45129512721300274`, 0.857142857142857, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.857142857142857, 
       0.2857142857142857}, {0.45129512721300274`, 0.857142857142857, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.857142857142857, 
       0.42857142857142855`}, {0.45129512721300274`, 0.857142857142857, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.857142857142857, 
       0.5714285714285714}, {0.45129512721300274`, 0.857142857142857, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.857142857142857, 
       0.7142857142857142}, {0.45129512721300274`, 0.857142857142857, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.857142857142857, 
       0.857142857142857}, {0.45129512721300274`, 0.857142857142857, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.857142857142857, 
       0.9999999999999998}, {0.45129512721300274`, 0.857142857142857, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.9999999999999998, 0.}, {
       0.45129512721300274`, 0.9999999999999998, 0.}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.9999999999999998, 
       0.14285714285714285`}, {0.45129512721300274`, 0.9999999999999998, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.9999999999999998, 
       0.2857142857142857}, {0.45129512721300274`, 0.9999999999999998, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.9999999999999998, 
       0.42857142857142855`}, {0.45129512721300274`, 0.9999999999999998, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.9999999999999998, 
       0.5714285714285714}, {0.45129512721300274`, 0.9999999999999998, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.9999999999999998, 
       0.7142857142857142}, {0.45129512721300274`, 0.9999999999999998, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.9999999999999998, 
       0.857142857142857}, {0.45129512721300274`, 0.9999999999999998, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.010929796035071777`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.40584772992985435`, 0.9999999999999998, 
       0.9999999999999998}, {0.45129512721300274`, 0.9999999999999998, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0., 0.}, {0.611826257902481, 0., 
       0.}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0., 0.14285714285714285`}, {
       0.611826257902481, 0., 0.14285714285714285`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0., 0.2857142857142857}, {
       0.611826257902481, 0., 0.2857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0., 0.42857142857142855`}, {
       0.611826257902481, 0., 0.42857142857142855`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0., 0.5714285714285714}, {
       0.611826257902481, 0., 0.5714285714285714}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0., 0.7142857142857142}, {
       0.611826257902481, 0., 0.7142857142857142}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0., 0.857142857142857}, {
       0.611826257902481, 0., 0.857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0., 0.9999999999999998}, {
       0.611826257902481, 0., 0.9999999999999998}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.14285714285714285`, 0.}, {
       0.611826257902481, 0.14285714285714285`, 0.}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.14285714285714285`, 
       0.14285714285714285`}, {0.611826257902481, 0.14285714285714285`, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.14285714285714285`, 
       0.2857142857142857}, {0.611826257902481, 0.14285714285714285`, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.14285714285714285`, 
       0.42857142857142855`}, {0.611826257902481, 0.14285714285714285`, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.14285714285714285`, 
       0.5714285714285714}, {0.611826257902481, 0.14285714285714285`, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.14285714285714285`, 
       0.7142857142857142}, {0.611826257902481, 0.14285714285714285`, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.14285714285714285`, 
       0.857142857142857}, {0.611826257902481, 0.14285714285714285`, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.14285714285714285`, 
       0.9999999999999998}, {0.611826257902481, 0.14285714285714285`, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.2857142857142857, 0.}, {
       0.611826257902481, 0.2857142857142857, 0.}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.2857142857142857, 
       0.14285714285714285`}, {0.611826257902481, 0.2857142857142857, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.2857142857142857, 
       0.2857142857142857}, {0.611826257902481, 0.2857142857142857, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.2857142857142857, 
       0.42857142857142855`}, {0.611826257902481, 0.2857142857142857, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.2857142857142857, 
       0.5714285714285714}, {0.611826257902481, 0.2857142857142857, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.2857142857142857, 
       0.7142857142857142}, {0.611826257902481, 0.2857142857142857, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.2857142857142857, 
       0.857142857142857}, {0.611826257902481, 0.2857142857142857, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.2857142857142857, 
       0.9999999999999998}, {0.611826257902481, 0.2857142857142857, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.42857142857142855`, 0.}, {
       0.611826257902481, 0.42857142857142855`, 0.}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.42857142857142855`, 
       0.14285714285714285`}, {0.611826257902481, 0.42857142857142855`, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.42857142857142855`, 
       0.2857142857142857}, {0.611826257902481, 0.42857142857142855`, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.42857142857142855`, 
       0.42857142857142855`}, {0.611826257902481, 0.42857142857142855`, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.42857142857142855`, 
       0.5714285714285714}, {0.611826257902481, 0.42857142857142855`, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.42857142857142855`, 
       0.7142857142857142}, {0.611826257902481, 0.42857142857142855`, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.42857142857142855`, 
       0.857142857142857}, {0.611826257902481, 0.42857142857142855`, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.42857142857142855`, 
       0.9999999999999998}, {0.611826257902481, 0.42857142857142855`, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.5714285714285714, 0.}, {
       0.611826257902481, 0.5714285714285714, 0.}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.5714285714285714, 
       0.14285714285714285`}, {0.611826257902481, 0.5714285714285714, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.5714285714285714, 
       0.2857142857142857}, {0.611826257902481, 0.5714285714285714, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.5714285714285714, 
       0.42857142857142855`}, {0.611826257902481, 0.5714285714285714, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.5714285714285714, 
       0.5714285714285714}, {0.611826257902481, 0.5714285714285714, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.5714285714285714, 
       0.7142857142857142}, {0.611826257902481, 0.5714285714285714, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.5714285714285714, 
       0.857142857142857}, {0.611826257902481, 0.5714285714285714, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.5714285714285714, 
       0.9999999999999998}, {0.611826257902481, 0.5714285714285714, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.7142857142857142, 0.}, {
       0.611826257902481, 0.7142857142857142, 0.}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.7142857142857142, 
       0.14285714285714285`}, {0.611826257902481, 0.7142857142857142, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.7142857142857142, 
       0.2857142857142857}, {0.611826257902481, 0.7142857142857142, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.7142857142857142, 
       0.42857142857142855`}, {0.611826257902481, 0.7142857142857142, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.7142857142857142, 
       0.5714285714285714}, {0.611826257902481, 0.7142857142857142, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.7142857142857142, 
       0.7142857142857142}, {0.611826257902481, 0.7142857142857142, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.7142857142857142, 
       0.857142857142857}, {0.611826257902481, 0.7142857142857142, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.7142857142857142, 
       0.9999999999999998}, {0.611826257902481, 0.7142857142857142, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.857142857142857, 0.}, {
       0.611826257902481, 0.857142857142857, 0.}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.857142857142857, 
       0.14285714285714285`}, {0.611826257902481, 0.857142857142857, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.857142857142857, 
       0.2857142857142857}, {0.611826257902481, 0.857142857142857, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.857142857142857, 
       0.42857142857142855`}, {0.611826257902481, 0.857142857142857, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.857142857142857, 
       0.5714285714285714}, {0.611826257902481, 0.857142857142857, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.857142857142857, 
       0.7142857142857142}, {0.611826257902481, 0.857142857142857, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.857142857142857, 
       0.857142857142857}, {0.611826257902481, 0.857142857142857, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.857142857142857, 
       0.9999999999999998}, {0.611826257902481, 0.857142857142857, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.9999999999999998, 0.}, {
       0.611826257902481, 0.9999999999999998, 0.}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.9999999999999998, 
       0.14285714285714285`}, {0.611826257902481, 0.9999999999999998, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.9999999999999998, 
       0.2857142857142857}, {0.611826257902481, 0.9999999999999998, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.9999999999999998, 
       0.42857142857142855`}, {0.611826257902481, 0.9999999999999998, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.9999999999999998, 
       0.5714285714285714}, {0.611826257902481, 0.9999999999999998, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.9999999999999998, 
       0.7142857142857142}, {0.611826257902481, 0.9999999999999998, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.9999999999999998, 
       0.857142857142857}, {0.611826257902481, 0.9999999999999998, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.01943074850679427, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.5310308849546617, 0.9999999999999998, 
       0.9999999999999998}, {0.611826257902481, 0.9999999999999998, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0., 0.}, {0.7774070994011981, 0., 
       0.}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0., 0.14285714285714285`}, {
       0.7774070994011981, 0., 0.14285714285714285`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0., 0.2857142857142857}, {
       0.7774070994011981, 0., 0.2857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0., 0.42857142857142855`}, {
       0.7774070994011981, 0., 0.42857142857142855`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0., 0.5714285714285714}, {
       0.7774070994011981, 0., 0.5714285714285714}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0., 0.7142857142857142}, {
       0.7774070994011981, 0., 0.7142857142857142}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0., 0.857142857142857}, {
       0.7774070994011981, 0., 0.857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0., 0.9999999999999998}, {
       0.7774070994011981, 0., 0.9999999999999998}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.14285714285714285`, 0.}, {
       0.7774070994011981, 0.14285714285714285`, 0.}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.14285714285714285`, 
       0.14285714285714285`}, {0.7774070994011981, 0.14285714285714285`, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.14285714285714285`, 
       0.2857142857142857}, {0.7774070994011981, 0.14285714285714285`, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.14285714285714285`, 
       0.42857142857142855`}, {0.7774070994011981, 0.14285714285714285`, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.14285714285714285`, 
       0.5714285714285714}, {0.7774070994011981, 0.14285714285714285`, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.14285714285714285`, 
       0.7142857142857142}, {0.7774070994011981, 0.14285714285714285`, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.14285714285714285`, 
       0.857142857142857}, {0.7774070994011981, 0.14285714285714285`, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.14285714285714285`, 
       0.9999999999999998}, {0.7774070994011981, 0.14285714285714285`, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.2857142857142857, 0.}, {
       0.7774070994011981, 0.2857142857142857, 0.}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.2857142857142857, 
       0.14285714285714285`}, {0.7774070994011981, 0.2857142857142857, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.2857142857142857, 
       0.2857142857142857}, {0.7774070994011981, 0.2857142857142857, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.2857142857142857, 
       0.42857142857142855`}, {0.7774070994011981, 0.2857142857142857, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.2857142857142857, 
       0.5714285714285714}, {0.7774070994011981, 0.2857142857142857, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.2857142857142857, 
       0.7142857142857142}, {0.7774070994011981, 0.2857142857142857, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.2857142857142857, 
       0.857142857142857}, {0.7774070994011981, 0.2857142857142857, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.2857142857142857, 
       0.9999999999999998}, {0.7774070994011981, 0.2857142857142857, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.42857142857142855`, 0.}, {
       0.7774070994011981, 0.42857142857142855`, 0.}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.42857142857142855`, 
       0.14285714285714285`}, {0.7774070994011981, 0.42857142857142855`, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.42857142857142855`, 
       0.2857142857142857}, {0.7774070994011981, 0.42857142857142855`, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.42857142857142855`, 
       0.42857142857142855`}, {0.7774070994011981, 0.42857142857142855`, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.42857142857142855`, 
       0.5714285714285714}, {0.7774070994011981, 0.42857142857142855`, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.42857142857142855`, 
       0.7142857142857142}, {0.7774070994011981, 0.42857142857142855`, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.42857142857142855`, 
       0.857142857142857}, {0.7774070994011981, 0.42857142857142855`, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.42857142857142855`, 
       0.9999999999999998}, {0.7774070994011981, 0.42857142857142855`, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.5714285714285714, 0.}, {
       0.7774070994011981, 0.5714285714285714, 0.}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.5714285714285714, 
       0.14285714285714285`}, {0.7774070994011981, 0.5714285714285714, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.5714285714285714, 
       0.2857142857142857}, {0.7774070994011981, 0.5714285714285714, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.5714285714285714, 
       0.42857142857142855`}, {0.7774070994011981, 0.5714285714285714, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.5714285714285714, 
       0.5714285714285714}, {0.7774070994011981, 0.5714285714285714, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.5714285714285714, 
       0.7142857142857142}, {0.7774070994011981, 0.5714285714285714, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.5714285714285714, 
       0.857142857142857}, {0.7774070994011981, 0.5714285714285714, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.5714285714285714, 
       0.9999999999999998}, {0.7774070994011981, 0.5714285714285714, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.7142857142857142, 0.}, {
       0.7774070994011981, 0.7142857142857142, 0.}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.7142857142857142, 
       0.14285714285714285`}, {0.7774070994011981, 0.7142857142857142, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.7142857142857142, 
       0.2857142857142857}, {0.7774070994011981, 0.7142857142857142, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.7142857142857142, 
       0.42857142857142855`}, {0.7774070994011981, 0.7142857142857142, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.7142857142857142, 
       0.5714285714285714}, {0.7774070994011981, 0.7142857142857142, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.7142857142857142, 
       0.7142857142857142}, {0.7774070994011981, 0.7142857142857142, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.7142857142857142, 
       0.857142857142857}, {0.7774070994011981, 0.7142857142857142, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.7142857142857142, 
       0.9999999999999998}, {0.7774070994011981, 0.7142857142857142, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.857142857142857, 0.}, {
       0.7774070994011981, 0.857142857142857, 0.}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.857142857142857, 
       0.14285714285714285`}, {0.7774070994011981, 0.857142857142857, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.857142857142857, 
       0.2857142857142857}, {0.7774070994011981, 0.857142857142857, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.857142857142857, 
       0.42857142857142855`}, {0.7774070994011981, 0.857142857142857, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.857142857142857, 
       0.5714285714285714}, {0.7774070994011981, 0.857142857142857, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.857142857142857, 
       0.7142857142857142}, {0.7774070994011981, 0.857142857142857, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.857142857142857, 
       0.857142857142857}, {0.7774070994011981, 0.857142857142857, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.857142857142857, 
       0.9999999999999998}, {0.7774070994011981, 0.857142857142857, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.9999999999999998, 0.}, {
       0.7774070994011981, 0.9999999999999998, 0.}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.9999999999999998, 
       0.14285714285714285`}, {0.7774070994011981, 0.9999999999999998, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.9999999999999998, 
       0.2857142857142857}, {0.7774070994011981, 0.9999999999999998, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.9999999999999998, 
       0.42857142857142855`}, {0.7774070994011981, 0.9999999999999998, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.9999999999999998, 
       0.5714285714285714}, {0.7774070994011981, 0.9999999999999998, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.9999999999999998, 
       0.7142857142857142}, {0.7774070994011981, 0.9999999999999998, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.9999999999999998, 
       0.857142857142857}, {0.7774070994011981, 0.9999999999999998, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.030360544541866073`, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.6511643291702303, 0.9999999999999998, 
       0.9999999999999998}, {0.7774070994011981, 0.9999999999999998, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0., 0.}, {0.9480376517091538, 0., 
       0.}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0., 0.14285714285714285`}, {
       0.9480376517091538, 0., 0.14285714285714285`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0., 0.2857142857142857}, {
       0.9480376517091538, 0., 0.2857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0., 0.42857142857142855`}, {
       0.9480376517091538, 0., 0.42857142857142855`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0., 0.5714285714285714}, {
       0.9480376517091538, 0., 0.5714285714285714}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0., 0.7142857142857142}, {
       0.9480376517091538, 0., 0.7142857142857142}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0., 0.857142857142857}, {
       0.9480376517091538, 0., 0.857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0., 0.9999999999999998}, {
       0.9480376517091538, 0., 0.9999999999999998}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.14285714285714285`, 0.}, {
       0.9480376517091538, 0.14285714285714285`, 0.}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.14285714285714285`, 
       0.14285714285714285`}, {0.9480376517091538, 0.14285714285714285`, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.14285714285714285`, 
       0.2857142857142857}, {0.9480376517091538, 0.14285714285714285`, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.14285714285714285`, 
       0.42857142857142855`}, {0.9480376517091538, 0.14285714285714285`, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.14285714285714285`, 
       0.5714285714285714}, {0.9480376517091538, 0.14285714285714285`, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.14285714285714285`, 
       0.7142857142857142}, {0.9480376517091538, 0.14285714285714285`, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.14285714285714285`, 
       0.857142857142857}, {0.9480376517091538, 0.14285714285714285`, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.14285714285714285`, 
       0.9999999999999998}, {0.9480376517091538, 0.14285714285714285`, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.2857142857142857, 0.}, {
       0.9480376517091538, 0.2857142857142857, 0.}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.2857142857142857, 
       0.14285714285714285`}, {0.9480376517091538, 0.2857142857142857, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.2857142857142857, 
       0.2857142857142857}, {0.9480376517091538, 0.2857142857142857, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.2857142857142857, 
       0.42857142857142855`}, {0.9480376517091538, 0.2857142857142857, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.2857142857142857, 
       0.5714285714285714}, {0.9480376517091538, 0.2857142857142857, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.2857142857142857, 
       0.7142857142857142}, {0.9480376517091538, 0.2857142857142857, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.2857142857142857, 
       0.857142857142857}, {0.9480376517091538, 0.2857142857142857, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.2857142857142857, 
       0.9999999999999998}, {0.9480376517091538, 0.2857142857142857, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.42857142857142855`, 0.}, {
       0.9480376517091538, 0.42857142857142855`, 0.}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.42857142857142855`, 
       0.14285714285714285`}, {0.9480376517091538, 0.42857142857142855`, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.42857142857142855`, 
       0.2857142857142857}, {0.9480376517091538, 0.42857142857142855`, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.42857142857142855`, 
       0.42857142857142855`}, {0.9480376517091538, 0.42857142857142855`, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.42857142857142855`, 
       0.5714285714285714}, {0.9480376517091538, 0.42857142857142855`, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.42857142857142855`, 
       0.7142857142857142}, {0.9480376517091538, 0.42857142857142855`, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.42857142857142855`, 
       0.857142857142857}, {0.9480376517091538, 0.42857142857142855`, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.42857142857142855`, 
       0.9999999999999998}, {0.9480376517091538, 0.42857142857142855`, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.5714285714285714, 0.}, {
       0.9480376517091538, 0.5714285714285714, 0.}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.5714285714285714, 
       0.14285714285714285`}, {0.9480376517091538, 0.5714285714285714, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.5714285714285714, 
       0.2857142857142857}, {0.9480376517091538, 0.5714285714285714, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.5714285714285714, 
       0.42857142857142855`}, {0.9480376517091538, 0.5714285714285714, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.5714285714285714, 
       0.5714285714285714}, {0.9480376517091538, 0.5714285714285714, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.5714285714285714, 
       0.7142857142857142}, {0.9480376517091538, 0.5714285714285714, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.5714285714285714, 
       0.857142857142857}, {0.9480376517091538, 0.5714285714285714, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.5714285714285714, 
       0.9999999999999998}, {0.9480376517091538, 0.5714285714285714, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.7142857142857142, 0.}, {
       0.9480376517091538, 0.7142857142857142, 0.}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.7142857142857142, 
       0.14285714285714285`}, {0.9480376517091538, 0.7142857142857142, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.7142857142857142, 
       0.2857142857142857}, {0.9480376517091538, 0.7142857142857142, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.7142857142857142, 
       0.42857142857142855`}, {0.9480376517091538, 0.7142857142857142, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.7142857142857142, 
       0.5714285714285714}, {0.9480376517091538, 0.7142857142857142, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.7142857142857142, 
       0.7142857142857142}, {0.9480376517091538, 0.7142857142857142, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.7142857142857142, 
       0.857142857142857}, {0.9480376517091538, 0.7142857142857142, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.7142857142857142, 
       0.9999999999999998}, {0.9480376517091538, 0.7142857142857142, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.857142857142857, 0.}, {
       0.9480376517091538, 0.857142857142857, 0.}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.857142857142857, 
       0.14285714285714285`}, {0.9480376517091538, 0.857142857142857, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.857142857142857, 
       0.2857142857142857}, {0.9480376517091538, 0.857142857142857, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.857142857142857, 
       0.42857142857142855`}, {0.9480376517091538, 0.857142857142857, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.857142857142857, 
       0.5714285714285714}, {0.9480376517091538, 0.857142857142857, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.857142857142857, 
       0.7142857142857142}, {0.9480376517091538, 0.857142857142857, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.857142857142857, 
       0.857142857142857}, {0.9480376517091538, 0.857142857142857, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.857142857142857, 
       0.9999999999999998}, {0.9480376517091538, 0.857142857142857, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.9999999999999998, 0.}, {
       0.9480376517091538, 0.9999999999999998, 0.}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.9999999999999998, 
       0.14285714285714285`}, {0.9480376517091538, 0.9999999999999998, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.9999999999999998, 
       0.2857142857142857}, {0.9480376517091538, 0.9999999999999998, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.9999999999999998, 
       0.42857142857142855`}, {0.9480376517091538, 0.9999999999999998, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.9999999999999998, 
       0.5714285714285714}, {0.9480376517091538, 0.9999999999999998, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.9999999999999998, 
       0.7142857142857142}, {0.9480376517091538, 0.9999999999999998, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.9999999999999998, 
       0.857142857142857}, {0.9480376517091538, 0.9999999999999998, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.04371918414028711, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.7662480625765602, 0.9999999999999998, 
       0.9999999999999998}, {0.9480376517091538, 0.9999999999999998, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0., 0.}, {1.1237179148263483`, 0., 
       0.}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0., 0.14285714285714285`}, {
       1.1237179148263483`, 0., 0.14285714285714285`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0., 0.2857142857142857}, {
       1.1237179148263483`, 0., 0.2857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0., 0.42857142857142855`}, {
       1.1237179148263483`, 0., 0.42857142857142855`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0., 0.5714285714285714}, {
       1.1237179148263483`, 0., 0.5714285714285714}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0., 0.7142857142857142}, {
       1.1237179148263483`, 0., 0.7142857142857142}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0., 0.857142857142857}, {
       1.1237179148263483`, 0., 0.857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0., 0.9999999999999998}, {
       1.1237179148263483`, 0., 0.9999999999999998}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.14285714285714285`, 0.}, {
       1.1237179148263483`, 0.14285714285714285`, 0.}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.14285714285714285`, 
       0.14285714285714285`}, {1.1237179148263483`, 0.14285714285714285`, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.14285714285714285`, 
       0.2857142857142857}, {1.1237179148263483`, 0.14285714285714285`, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.14285714285714285`, 
       0.42857142857142855`}, {1.1237179148263483`, 0.14285714285714285`, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.14285714285714285`, 
       0.5714285714285714}, {1.1237179148263483`, 0.14285714285714285`, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.14285714285714285`, 
       0.7142857142857142}, {1.1237179148263483`, 0.14285714285714285`, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.14285714285714285`, 
       0.857142857142857}, {1.1237179148263483`, 0.14285714285714285`, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.14285714285714285`, 
       0.9999999999999998}, {1.1237179148263483`, 0.14285714285714285`, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.2857142857142857, 0.}, {
       1.1237179148263483`, 0.2857142857142857, 0.}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.2857142857142857, 
       0.14285714285714285`}, {1.1237179148263483`, 0.2857142857142857, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.2857142857142857, 
       0.2857142857142857}, {1.1237179148263483`, 0.2857142857142857, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.2857142857142857, 
       0.42857142857142855`}, {1.1237179148263483`, 0.2857142857142857, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.2857142857142857, 
       0.5714285714285714}, {1.1237179148263483`, 0.2857142857142857, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.2857142857142857, 
       0.7142857142857142}, {1.1237179148263483`, 0.2857142857142857, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.2857142857142857, 
       0.857142857142857}, {1.1237179148263483`, 0.2857142857142857, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.2857142857142857, 
       0.9999999999999998}, {1.1237179148263483`, 0.2857142857142857, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.42857142857142855`, 0.}, {
       1.1237179148263483`, 0.42857142857142855`, 0.}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.42857142857142855`, 
       0.14285714285714285`}, {1.1237179148263483`, 0.42857142857142855`, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.42857142857142855`, 
       0.2857142857142857}, {1.1237179148263483`, 0.42857142857142855`, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.42857142857142855`, 
       0.42857142857142855`}, {1.1237179148263483`, 0.42857142857142855`, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.42857142857142855`, 
       0.5714285714285714}, {1.1237179148263483`, 0.42857142857142855`, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.42857142857142855`, 
       0.7142857142857142}, {1.1237179148263483`, 0.42857142857142855`, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.42857142857142855`, 
       0.857142857142857}, {1.1237179148263483`, 0.42857142857142855`, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.42857142857142855`, 
       0.9999999999999998}, {1.1237179148263483`, 0.42857142857142855`, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.5714285714285714, 0.}, {
       1.1237179148263483`, 0.5714285714285714, 0.}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.5714285714285714, 
       0.14285714285714285`}, {1.1237179148263483`, 0.5714285714285714, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.5714285714285714, 
       0.2857142857142857}, {1.1237179148263483`, 0.5714285714285714, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.5714285714285714, 
       0.42857142857142855`}, {1.1237179148263483`, 0.5714285714285714, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.5714285714285714, 
       0.5714285714285714}, {1.1237179148263483`, 0.5714285714285714, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.5714285714285714, 
       0.7142857142857142}, {1.1237179148263483`, 0.5714285714285714, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.5714285714285714, 
       0.857142857142857}, {1.1237179148263483`, 0.5714285714285714, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.5714285714285714, 
       0.9999999999999998}, {1.1237179148263483`, 0.5714285714285714, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.7142857142857142, 0.}, {
       1.1237179148263483`, 0.7142857142857142, 0.}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.7142857142857142, 
       0.14285714285714285`}, {1.1237179148263483`, 0.7142857142857142, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.7142857142857142, 
       0.2857142857142857}, {1.1237179148263483`, 0.7142857142857142, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.7142857142857142, 
       0.42857142857142855`}, {1.1237179148263483`, 0.7142857142857142, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.7142857142857142, 
       0.5714285714285714}, {1.1237179148263483`, 0.7142857142857142, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.7142857142857142, 
       0.7142857142857142}, {1.1237179148263483`, 0.7142857142857142, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.7142857142857142, 
       0.857142857142857}, {1.1237179148263483`, 0.7142857142857142, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.7142857142857142, 
       0.9999999999999998}, {1.1237179148263483`, 0.7142857142857142, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.857142857142857, 0.}, {
       1.1237179148263483`, 0.857142857142857, 0.}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.857142857142857, 
       0.14285714285714285`}, {1.1237179148263483`, 0.857142857142857, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.857142857142857, 
       0.2857142857142857}, {1.1237179148263483`, 0.857142857142857, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.857142857142857, 
       0.42857142857142855`}, {1.1237179148263483`, 0.857142857142857, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.857142857142857, 
       0.5714285714285714}, {1.1237179148263483`, 0.857142857142857, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.857142857142857, 
       0.7142857142857142}, {1.1237179148263483`, 0.857142857142857, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.857142857142857, 
       0.857142857142857}, {1.1237179148263483`, 0.857142857142857, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.857142857142857, 
       0.9999999999999998}, {1.1237179148263483`, 0.857142857142857, 
       0.9999999999999998}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.9999999999999998, 0.}, {
       1.1237179148263483`, 0.9999999999999998, 0.}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.9999999999999998, 
       0.14285714285714285`}, {1.1237179148263483`, 0.9999999999999998, 
       0.14285714285714285`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.9999999999999998, 
       0.2857142857142857}, {1.1237179148263483`, 0.9999999999999998, 
       0.2857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.9999999999999998, 
       0.42857142857142855`}, {1.1237179148263483`, 0.9999999999999998, 
       0.42857142857142855`}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.9999999999999998, 
       0.5714285714285714}, {1.1237179148263483`, 0.9999999999999998, 
       0.5714285714285714}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.9999999999999998, 
       0.7142857142857142}, {1.1237179148263483`, 0.9999999999999998, 
       0.7142857142857142}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.9999999999999998, 
       0.857142857142857}, {1.1237179148263483`, 0.9999999999999998, 
       0.857142857142857}}]}, 
     {Arrowheads[{{0.05950666730205749, 1.}}, Appearance -> "Projected"], 
      Arrow3DBox[{{0.8762820851736514, 0.9999999999999998, 
       0.9999999999999998}, {1.1237179148263483`, 0.9999999999999998, 
       0.9999999999999998}}]}}}},
  Axes->True,
  ImageSize->{355.9504461232707, 386.1298730607444},
  ViewPoint->{72.3757437608831, 84.34352341733519, 23.4077289075302},
  ViewVertical->{-0.34231349416848833`, -0.211630826877809, 
   0.9154418959306895}]], "Output",
 CellChangeTimes->{3.7359299513936234`*^9, 
  3.73593008595507*^9},ExpressionUUID->"7481b15f-eced-4355-af20-f506ef8ab6bc"]
}, Open  ]],

Cell["\<\

The surface integral is\
\>", "Text",
 CellChangeTimes->{{3.735940828079948*^9, 
  3.735940836049754*^9}},ExpressionUUID->"343a5562-f121-42c0-a07c-\
b38046456d5a"],

Cell[TextData[Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{GridBox[{
        {
         RowBox[{
          RowBox[{"\[Integral]", 
           RowBox[{
            StyleBox[
             OverscriptBox[
              StyleBox["F",
               FontWeight->"Bold"], "\[RightVector]"],
             FontWeight->"Bold"], "\[CenterDot]", 
            RowBox[{"\[DifferentialD]", 
             OverscriptBox["S", "\[RightVector]"]}]}]}], "=", 
          RowBox[{
           SubsuperscriptBox["\[Integral]", "0", "1"], 
           RowBox[{
            SubsuperscriptBox["\[Integral]", "0", "1"], 
            RowBox[{
             RowBox[{
              RowBox[{
               StyleBox[
                OverscriptBox[
                 StyleBox["F",
                  FontWeight->"Bold"], "\[RightVector]"],
                FontWeight->"Bold"], 
               StyleBox["(",
                FontWeight->"Plain"], 
               StyleBox[
                RowBox[{"1", ",", "y", ",", "z"}],
                FontWeight->"Plain"], 
               StyleBox[")",
                FontWeight->"Plain"]}], "\[CenterDot]", 
              StyleBox[
               OverscriptBox[
                StyleBox["i",
                 FontWeight->"Bold"], "\[RightVector]"],
               FontWeight->"Bold"]}], 
             RowBox[{"\[DifferentialD]", "y"}], 
             RowBox[{"\[DifferentialD]", "z"}]}]}]}]}]}
       },
       GridBoxAlignment->{"Columns" -> {{"Center"}}}], "=", " ", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[Integral]", "0", "1"], 
        RowBox[{
         SubsuperscriptBox["\[Integral]", "0", "1"], 
         RowBox[{
          SuperscriptBox["1", "2"], 
          RowBox[{
           StyleBox[
            OverscriptBox[
             StyleBox["i",
              FontWeight->"Bold"], "\[RightVector]"],
            FontWeight->"Bold"], "\[CenterDot]", 
           StyleBox[
            OverscriptBox[
             StyleBox["i",
              FontWeight->"Bold"], "\[RightVector]"],
            FontWeight->"Bold"]}], 
          RowBox[{"\[DifferentialD]", "y"}], 
          RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", 
       RowBox[{
        RowBox[{
         SubsuperscriptBox["\[Integral]", "0", "1"], 
         RowBox[{
          SubsuperscriptBox["\[Integral]", "0", "1"], 
          RowBox[{"1", 
           RowBox[{"\[DifferentialD]", "y"}], 
           RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", 
        RowBox[{
         RowBox[{
          SubsuperscriptBox["\[Integral]", "0", "1"], 
          RowBox[{
           SuperscriptBox[
            SubscriptBox[
             RowBox[{"(", "y", ")"}], "0"], "1"], 
           RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
         RowBox[{
          RowBox[{
           SubsuperscriptBox["\[Integral]", "0", "1"], 
           RowBox[{"1", 
            RowBox[{"\[DifferentialD]", "z"}]}]}], "=", "1"}]}]}]}]}]}
   },
   GridBoxItemSize->{"Columns" -> {{
        Scaled[0.96]}}}], 
  TraditionalForm]],ExpressionUUID->"b988d204-0650-4927-9323-557ca3d2b3b7"]], \
"Text",
 CellChangeTimes->{{3.7359408671415367`*^9, 
  3.735941352200427*^9}},ExpressionUUID->"4d61d76a-6c4c-4ec5-b97a-\
59f96cb4b7f2"]
},
WindowSize->{808, 911},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 27, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 131, 1, 32, "Input", "ExpressionUUID" -> \
"77d7df06-738a-424a-b636-bcd560bd29f5"],
Cell[692, 23, 2999, 78, 180, "Input", "ExpressionUUID" -> \
"91325280-9794-4f7d-9a2b-476686031cf6"],
Cell[3694, 103, 3108, 79, 243, "Input", "ExpressionUUID" -> \
"368b260b-265d-491f-9939-d749bcfe3322"],
Cell[6805, 184, 5322, 108, 306, "Input", "ExpressionUUID" -> \
"9aabe485-82ac-4bd5-84c6-601010594cb8"],
Cell[12130, 294, 844, 25, 91, "Text", "ExpressionUUID" -> \
"dfffbec2-2845-4890-bffb-068f5fb7ef9b"],
Cell[CellGroupData[{
Cell[12999, 323, 348, 8, 32, "Input", "ExpressionUUID" -> \
"d091d9c8-33ef-43ea-8fdf-ab5850ab10a9"],
Cell[13350, 333, 34660, 613, 352, "Output", "ExpressionUUID" -> \
"d896d964-778f-4b5d-9ccc-0a854a42334b"]
}, Open  ]],
Cell[48025, 949, 1238, 35, 115, "Text", "ExpressionUUID" -> \
"3253c62d-a431-4631-b018-8717f89d8f7a"],
Cell[49266, 986, 636, 17, 32, "Input", "ExpressionUUID" -> \
"157a6fd7-304d-46d0-943b-15a35e48e2f7"],
Cell[CellGroupData[{
Cell[49927, 1007, 524, 12, 54, "Input", "ExpressionUUID" -> \
"d13dc5e0-7900-4a97-92cb-1a5930d744d2"],
Cell[50454, 1021, 138377, 2304, 401, "Output", "ExpressionUUID" -> \
"7481b15f-eced-4355-af20-f506ef8ab6bc"]
}, Open  ]],
Cell[188846, 3328, 174, 6, 49, "Text", "ExpressionUUID" -> \
"343a5562-f121-42c0-a07c-b38046456d5a"],
Cell[189023, 3336, 3185, 91, 42, "Text", "ExpressionUUID" -> \
"4d61d76a-6c4c-4ec5-b97a-59f96cb4b7f2"]
}
]
*)

