<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Vector functions [10.1]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h2>Vector functions [10.1]</h2>
<p class="show">Curves in space.
<p class="show center"><img src="0g/10.1.bless-soyuz.jpg"><br>
<i>Blessing of the media, Soyuz launch 2013 [<a href="http://www.flickr.com/photos/nasahqphoto/8851892423">NASA</a>]</i></p>
<p class="show">The <b>position</b> of an object in 
3-d, as a function of time, 
$\myv r(t)$ is an example of a <b>vector function</b>.<br>
<img src="0g/10.1.roft.jpg">
<br>


<h3>Vector functions and parametric equations</h3>
<p class="show">Consider the 2-d vector function:
$$\myv r(t)=\langle t,t^2\rangle$$
<ul>

<li>
$\myv r(t)=\langle t,t^2 \rangle$
<li>$x(t)=t;\ \ \ y(t)=t^2$
<li><img src="0g/10.1.quadratic.jpg" class="rightalign">In this case we can write $y$ as a function of $x=t$:
$$\nonumber y=x^2$$
and we know what that looks like...
</ul>


<p><b>In GeoGebra</b>: we can make parametric plots, by specifying functions for the $x,\ y$ and $z$ coordinates of a position vector in terms of a common parameter, for example, the parameter $t$, like this
<p align="center"><tt>( [x(t)], [y(t)], [z(t)] )</tt>
<p>For example
<ul><li><tt>(t,t^2,0)</tt> is a parametric plot, where $x(t)=t;\ y(t)=t^2;\ z(t)=0$, where $t$ runs over all possible values.
<li><tt>Curve(t,t^2,0,  t,0,10)</tt> is a portion of the parametric plot above, limited to a restricted domain of parameter values: $0 \lt t \lt 10$.
></ul>
<p>Try it out!


<h3>Parametric plotting of expressions in polar coordinates</h3>
<p>What if we'd like to plot a function in polar coordinates?  For example:
$$r(t)=2;\ \theta(t)=t.$$

<p>GeoGebra only allows you to specify functions for the Cartesian coordinates, $x(t)$, $y(t)$, and $z(t)$.
<p>But, you know how to convert polar coordinates to Cartesian coordinates:
$$x=r\cos\theta;\ y=r\sin\theta$$
So, to plot $r(t)=2;\ \theta(t)=t$, we tell GeoGebra:
<p align="center"><tt>( 2*cos(t),2*sin(t) )</tt>
<p>Try it!

<h3>Plotting paths from discrete segments</h3>
<p>Using <tt>Curve(...)</tt> you can plot a segment of a curve.
Plotting multiple <tt>Curve</tt>s, you can put together the segments to form more complex paths in space.




<h3>Plot these paths</h3>
<p class="show todo">Use parametric curve plotting to draw these closed paths in the $xy$ plane ($z=0$):

<img src="0g/10.1.segline.jpg">
<img src="0g/10.1.segcirc.jpg">

<p>The curved segment above is supposed to be a portion of a circle, with a fixed radius.
<!--
<p>Graph a portion of the line in 3-d as well as...
<ul>
  <li>A point that the line goes through: $(1,2,-1)$, 
  <li>A direction vector $\langle 1,5,6 \rangle$ from the origin that should look parallel to your line 
</ul>
[See topic <a href="9.1.php">9.1</a> of examples for dots, arrows.]
-->
<h3>Plotting and visualizing curves in 3 dimensions</h3>
<p>Consider this curve:
$$\myv r(t)=\langle \cos t, \sin t, t\rangle\nonumber$$

<ul>
<li>$\cos^2 t + \sin^2 t = x^2+y^2=1$. 
<li>In 2-d this is the equation of points on a circle of radius 1.
<li>So in 3-d, the path traced out by $\myv r(t)$ must lie on the surface of the <i>cylinder</i> $x^2+y^2=1$<br>
<img src="0g/10.1.helix.jpg">
</ul>

<p>This process of ignoring one coordinate, and seeing how 2 of the coordinates relate to each other without regard to the other one is "<b>projection</b>". Doing this with the other coordinate pairs, we see the familiar-looking relations:
$$\nonumber x=\cos z;\ \ \ y=\sin z$$

<p>
<img src="0g/10.1.helixprojection.jpg">


<h3>Intersections and projections</h3>
<p>Consider
$$\myv r(t)=\langle t,t^2,t^3 \rangle \nonumber$$
<p>
Since $y(t)=t^2$ and $x(t)=t$ we can combine these equations to get $$\nonumber y=x^2.$$

<p>And similarly 
$$\nonumber z=x^3,$$
 so we could plot the 3-d surfaces
<ul><li>$y=x^2$ (for any $z$), and
<li>$z=x^3$ (for any $y$)
</ul>
 
<p><img src="0g/10.1.intersect.jpg" class="rightalign">The points in $\myv r$ need to be on *both* of those surfaces, so we could look for $\myv r$ as the intersection of the surfaces.<br><br>
<!--See: <a href="0g/10.1.tt2t3.nb">tt2t3.nb</a><br>-->

<h4>Projections of $\langle t,t^2,t^3 \rangle$
<p><img src="0g/10.1.traces.jpg" class="big">


<h3>To Do</h3>
<ul class="todo"><li>Handout: Projections
</ul>

<?php include "../../classes/3.h" ?>