<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Derivatives and integrals of vector functions [10.2]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h2>Derivatives and integrals of vector functions [10.2]
</h2>
<img src="0g/10.2.rollercoaster.jpg">

<h3>Derivatives</h3>
<p class="show">In Calc I, we defined the derivative as the limit of a  "Difference Quotient":
$$f'(x)=\lim_{h\to 0} \frac{f(x+h)-f(x)}{h}.$$

<p class="show def">For a vector function, $\myv r(t)$, there's a similar difference quotient:
$$\frac{d\myv r}{dt} \equiv 
\myv r'(t) = \lim_{h\to 0} \frac{\myv r(t+h)-\myv r(t)}{h}.$$

<p class="show">
<img src="0g/10.2.dr.jpg" class="center">

<p>
In the limit $h \to 0$, $\myv r'(t)$ is a <b>vector</b> which is <b>tangent</b> to the curve at $\myv r(t)$.<br>
<img src="0g/10.2.rprime.jpg" class="center"><br>
<img src="0g/10.2.tangentv.jpg" class="big">
<p>Mess around with this<a href="https://www.geogebra.org/3d/tx5qthn6">Difference Quotient (DQ) visualization</a> (GeoGebra)
to see these relationships.


<h3>Differentiation - components</h3>
<p class="show def">A theorem: if $\myv r(t)=\langle f(t),g(t),h(t)\rangle = 
f(t)\uv i+g(t)\uv j+h(t) \uv k$, where $f$, $g$, and $h$ are differentiable functions, then
$$\myv r'(t)=\langle f'(t),g'(t),h'(t)\rangle = f'(t)\uv i+g'(t)\uv j+
h'(t)\uv k.$$

<h3>Differentiation rules</h3>
<p class="show">
<img src="0g/10.2.rules.jpg" class="big">

<h3>Cusp?</h3>
<p class="show">
A vector function $\myv r(t)=\myc{f(t),g(t),h(t)}$ might have a 
<b>cusp</b> if $\myv r'(t)=0$.
<p><img src="0g/10.2.cusp.jpg" class="rightalign" style='border: 1px solid #666'>At right: $\myv r(t)=\myc{t^2-4t,e^{t-2}-t}$, so
$\myv r'(t)=\myc{2t-4,e^{t-2}-1}$.
<p>And... $\myv r'(2)=\myc{0,0}$.


<h3>More on tangent vectors</h3>
<p class="show"><img src="0g/10.2.rprime.jpg" class="center">

<p>
The line tangent to the curve at $\myv r(t_0)$ is:
$$\myv L(t) = \myv r(t_0) + t \myv r'(t_0).$$

<p>The <b>unit tangent vector</b> is given by:
$$\uv T(t) = \frac{\myv r'(t)}{|\myv r'(t)|}.$$

<p class="show incremental def"><b>Theorem</b>: If a vector function, $\myv r(t)$, has constant length, then its derivative, $\myv r'(t)$, is perpendicular to $\myv r(t)$.

<p><b>Proof:</b><br>
<ol>
<li>We're assuming that the length of $|\myv r(t)|$ is not changing.  That is,
$$\frac{d}{dt}|\myv r(t)|=0.$$
<li>Then,  (length)${}^2$ is also unchanging:
$$\begineq 0&=\frac{d}{dt}|\myv r(t)|^2\\
 &=\frac{d}{dt}(\myv r\cdot\myv r)=\myv r'\cdot \myv r+\myv r\cdot\myv r'\\
0  &=2\myv r'\cdot \myv r\\
\endeq
$$
<li>Since the dot product of $\myv r'$ and $\myv r$ is zero, <span class="answer">$\myv r' \perp \myv r$</span>.
</ol>

<p>Example: $\myv r(t)=\langle cos(t),sin(t)\rangle$.  Taking the derivative of its component functions...
$$\nonumber \myv r'(t)=\langle -\sin(t),\cos(t)\rangle.$$
The magnitude of this derivative vector is
$$|\myv r'(t)|=\sqrt{(-\sin t)^2+\cos t)^2}=\sqrt{\sin^2 t+\cos^2 t} = 1.$$
We see that the magnitude of the derivative is a constant (not changing with $t$).

<p>See <a href="https://www.geogebra.org/3d/ue23pquz">Circular motion</a> (GeoGebra)


<h4>The unit tangent</h4> 
<ul>
<li>The Unit Tangent $\uv T(t)=\frac{\myv r'(t)}{|\myv r'(t)|}$
 has constant length 1.
<li>The only characteristic of $\uv T(t)$ that changes as $t$ changes is its direction.
<li>$|d\uv T/dt|$ measures the <b>rate of change of the <i>direction</i></b> of the unit tangent vector. ["units" are radians per $t$-unit].
</ul>

<p>Example: $\myv r(t)=\langle t^3,t^6\rangle$


<h2>Integrals</h2>


<p class="show">
$$\begineq \int_a^b \myv r(t)\,dt
 &= \int_a^b \langle f(t),g(t),h(t)\rangle\,dt\\
&= \left(\int_a^b f(t)\,dt\right)\uv i +
\left(\int_a^b g(t)\,dt\right)\uv j +
\left(\int_a^b h(t)\,dt\right)\uv k\\&\equiv& \myv R(t).
\endeq
$$
<p>These are the components of $\myv R(t)$, the anti-derivative of $\myv r(t)$:
$$\int_a^b \myv r(t)\,dt = \left.
\myv R(t)\right|_a^b = \myv R(b)-\myv R(a). $$
And $\myv R'(t)=\myv r(t)$.

<!--
<h3>To do</h3>
<p class="todo show">10.2 - the grim reaper
-->

<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/dirkjankraan/5207612942">Dirk-Jan Kraan</a>

<?php include "../../classes/3.h" ?>