<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Arc length and curvature [10.3]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Arc length and curvature [10.3]
</h1>
<p class="show center"><img src="0g/10.3.Nowitna.jpg" class="big"><br><i>The Nowitna river (Alaska) - How long is it?</i>

<ul class="else">
<li>Calculating arclength and curvature
<li>Arclength is independent of  the choice of parameter used to describe a curve.
<li>Re-parameterizing a curve - using the <b>arclength as the parameter</b>.
<li>Geometric definition of curvature.
<li>The TNB frame (Tangent - Normal - Binormal unit vectors).
</ul>

<h2>Arclength</h2>

<p class="show">$\myv r(t)$ is a vector function.
$$\myv r(t)=\langle f(t),g(t),h(t)\rangle\nonumber;
\ \  t_i\leq t\leq t_f.$$
where $\myv r(t_i)=\myv a$ and $\myv r(t_f)=\myv b$
The tip of the <b>position vector</b> $\myv r(t)$ traces  a curve (trajectory) in space which
looks schematically like:<br>
<img src="0g/10.3.arclength.jpg">
<ul><li>The <b>arclength</b> is the distance <i>along the curve</i> from $\myv a$ to $\myv b$.
<li>Arclength is a <b>scalar</b>.
<li>It is <b>not the distance</b> "as the crow flows" of a vector starting at $\myv a$ and terminating at $\myv b$.
</ul>

<p>The arclength from $\bf{a}$ to $\bf{b}$ is approximately equal to the sum of the <style="color:pink">pink</a> segments:
$$\text{arclength}\equiv L \approx \sum \Delta L\nonumber.$$

<p>The derivative $\myv r'(t)$ is a vector tangent to the curve.  Its magnitude is the "speed" of a particle moving in time, $t$,  according to $\myv r(t)$.  <br><br>

Since distance = speed (times) time, we can approximate the distance $\Delta L$ moved in a time interval $\Delta t$ as
$$ \Delta L \approx \left| \myv r'\right| \Delta t\nonumber$$
<p>So, the arclength is approximately
$$L\approx \sum |\myv r'(t)|\Delta t\nonumber.$$

In the limit of ever smaller $\Delta t\to dt$, the sum approaches the integral...
$$\begineq L&=\int_a^b |\myv r'(t)|\,dt\\
 &=\int_a^b \sqrt{\left(\frac{df}{dt}\right)^2 
   + \left(\frac{dg}{dt}\right)^2
   + \left(\frac{dh}{dt}\right)^2
}\,dt
\\
 &=\int_a^b \sqrt{\left(f'(t)\right)^2 
   + \left(g'(t)\right)^2
   + \left(h'(t)\right)^2
}\,dt  
\endeq
$$

<h3>Example</h3>
<p class="show"><img src="0g/10.3.helix.jpg" class="rightalign">
Find the length of the arc of the helix that obeys the equation
$$\nonumber \myv r(t)=\langle \cos t, \sin t, t \rangle$$
from the point $(1,0,0)$ to $(1,0,2\pi)$.
<p>It looks like
$$ 0 \leq t \leq 2\pi,$$
the derivative is
$$ \myv r'(t) = \langle -\sin t, \cos t,1\rangle,\nonumber$$
and so...
$$|\myv r'(t)| = \sqrt{(-\sin t)^2 + (\cos t)^2 +1}=\sqrt 2.\nonumber$$
 
<p>Substituting into the arclength expression
$$L =\int_0^{2\pi} \sqrt 2 \,dt=2   \sqrt 2 \pi.\nonumber$$



<h3>Arclength distance function</h3>

<p class="show">

<p><img src="0g/10.3.soft.jpg" class="rightalign">
The arclength distance function $s(t)$, where $s(0)=0$,

<p class="show incremental def">$$s(t) = \int_0^t |\myv r'(t)|\, dt
=\int_0^t\sqrt{\left(\frac{dx}{dt}\right)^2 +
\left(\frac{dy}{dt}\right)^2+
\left(\frac{dz}{dt}\right)^2
}
\,dt$$.
<p>Taking the derivative w.r.t. $t$ of both sides, this means that 
$$\frac{ds}{dt}=|\myv r'(t)|.$$


<h3>Parameterizations</h3>
<p>[Sorry, I can't bear to write "<a href="http://www.google.com/#q=parametrization">parametrization</a>" as Stewart does.]

<ul>
  <li>The same curve can be represented in more than one way.
  <li>E.g.
$$\myv r_1(t)=\langle t,t^2,t^3\rangle \nonumber;\ \ 1\leq t\leq 2$$
and
$$\myv r_2(u)=\langle e^u,e^{2u},e^{3u} \rangle;\ \ 0\leq u \leq \ln 2$$
</ul>

<div class="todo">
<p>The two parametric curves aboves are <a href="https://www.geogebra.org/3d/av9bfzaa">plotted here (GeoGebra)</a> (one as a point, and one as the tip of a position vector).  Discuss with a partner:
<ol>
<li>Moving the $t$ and $u$ sliders back and forth... does it seem like the two functions trace out the same trajectory?  Change the perspective a few times to make sure...
<li>Next, animate the two functions (press the little play button besided each slider) and watch the two functions.  Describe how the motions of the two functions differ.
</ol>
</div>

<h3>Re-parameterization</h3>

<p class="show">It may be useful (and is certainly beautiful) to re-parameterize a curve in terms of
the <b>arclength</b> along a curve
<ul><li> is characteristic of the curve itself,
<li>does not depend on the choice of parameter used to describe the curve,
<li> and does not depend on the coordinate system.
</ul>
<p>We could use the arclength ("distance along the curve") as the parameter to describe a curve (instead of the time, or angle, or some other parameter).


<p><b>Example</b> -- $\myv r(t)=\langle \cos t,\sin t,t\rangle$: Reparametrize with respect to arc length, beginning at (1,0,0) in direction of increasing $t$.

<ul>
<li>$$|\myv r'(t)| = \sqrt{f'^2+g'^2+h'^2}=\sqrt{(-\sin t)^2+(\cos t)^2+1}=\sqrt 2.$$
<li>$$s(t)=\int_0^t|\myv r'(u)|\,du=\int_0^t\sqrt 2\,du=\sqrt 2 t.$$
<li>Solve for $t$:  $t=s/\sqrt 2$,
<li>and substitute back into original expression:
$$
\myv r(t(s))=\cos(s/\sqrt 2)\uv i+\sin(s/\sqrt 2)\uv j+s/\sqrt 2\uv k.
$$


</ul>
<p>This depends on being able (easily or otherwise) to take $s(t)$ and invert it to $t(s)$.


<p><img src="0g/10.3.arclengthP.jpg"><br>

<p>This is a technique used in General Relativity:   We talk about the "proper time" measured along the the space-time trajectory of a particle as a quantity that all observers agree on.


<h3>Curvature</h3>
<p class="show">The question: How to describe "curvature" in a useful way?
<p>The curvature should be... 
<ul>
<li>a scalar number which should be
<li>large when the path is changing direction "quickly",
<li>small when the path is more nearly straight.
</ul>

<p>
<img src="0g/10.3.acceleration.jpg" class="big">
The velocity vector $\myv r'(t)$ is tangent to the curve at each position on the curve.  So, as the direction of a curve changes,the velocity vector will also change.  So our first attempt to quantify the idea of "curvature" might be to look at at the <i>change of the velocity vector</i>, that is,  the <b>acceleration</b>:
$$\myv a (t)= \frac{d\myv r'(t)}{dt}$$

<p>Can you think of a situation in which the acceleration is not zero, even though the curvature of the path is zero?
<p class="justme">Acceleration in a straight line.

<p>The unit tangent 
$$\uv T(t)=\frac{\myv r'}{|\myv r'|}$$ is a vector quantity that is always the same length, no matter what the velocity $\myv r'$ is. So, what about 
$$\frac{d\uv T(t)}{dt}?$$ 
What's the problem with that?

<p>In this picture, the unit tangent vectors are evenly spaced along the curve:<br>
<img src="0g/10.3.unittangent.jpg">
Does this suggest a useful way to think about curvature?


<p>...We should look at how $\uv T$ changes with respect to changes in the <i>arclength</i>, $s$, (instead of w.r.t time $t$):
<p class="show incremental def">The <b>curvature</b>, $\kappa$, is
$$\kappa = \frac{d\uv T}{ds},$$
the rate of change of unit tanget vector direction with respect to arclength.

<p>By the chain rule, this is
$$\kappa = \left|\frac{d\uv T}{dt}\right| \frac{dt}{ds} =\frac{\left|\frac{d\uv T}{dt}\right|}{ \frac{ds}{dt} }=
= \frac{|d\uv T(t)/dt|}{|\myv r'(t)|} .$$

<h4>Curvature of a circle</h4>
<p class="show">It seems like a circle ought to have a <b>constant</b> curvature.  Let's see...
<p>Circle of radius $a$:
$$\myv r(t)=a \cos t\uv i + a \sin t\uv j.$$
<p>$$\myv r'(t)=-a\sin t \uv i + a \cos t\uv j.$$
<p>$$|\myv r'(t)| = \sqrt{(-a\sin t)^2+(a\cos t)^2}=a.$$
<p>$$\uv T(t) = \myv r'(t)/|\myv r'(t)|=\myv r'(t)/a=- \sin t \uv i+\cos t\uv j.$$
<p>$$\uv T'(t) =- \cos t \uv i - \sin t\uv j.$$
<p>$$|\uv T'| = \sqrt{(-\cos t)^2 +(-\sin t)^2}=\sqrt{\cos^2 t+\sin^2 t} = 1.$$

<p>$$\kappa = \frac{|\uv T'(t)|}{|\myv r'(t)|}=\frac{1}{a}.$$

<ul>
<li>The curvature $1/a$ is constant, independent of $t$.
<li><b>Small circles</b> have a <b>large curvature</b>, and
<li><b>large circles</b> have a <b>small curvature</b>.
<li>A <b>straight line</b> has a curvature of 0, because there is no change of the unit tangent vector.
</ul>
<p>This suggests a <b>geometric definition</b> of curvature...

<h3>Osculating circle</h3>
<p class="show">
<img src="0g/10.3.osc.jpg" class="big"><br>
The circle with the same curvature (that is, radius=$1/\kappa$) as $\myv r(t)$ at a point $P$ on the curve.




<h3>Another way to calculate curvature</h3>
<p class="show">
We had:
$$\kappa = \left|\frac{d\uv T}{dt}\right| \frac{dt}{ds} = \frac{|d\uv T(t)/dt|}{|\myv r'(t)|} = 
\frac{\left|\frac{d}{dt}\left[ \frac{\myv r'(t)}{|\myv r'(t)|}\right]\right|}{|\myv r'(t)|}.$$

<p class="show def"><b>Theorem</b>: The curvature of the curve given by $\myv r(t)$ is given by:
$$ \kappa(t)=\frac{|\myv r'(t)\times \myv r''(t)|}{|\myv r'(t)|^3}.$$

<h4>Example 4 - group work</h4>
<p>...uses the formula above to calculate the curvature of the 'twisted cubic' $\myv r(t)=\langle t,t^2,t^3 \rangle$:
$$\kappa(t)=\frac{2\sqrt{1+9t^2+9t^4}}{(1+4t^2+9t^4)^{3/2}}$$
The twisted cubic...[plot the twisted cubic.]
<ul><li>Would you expect the curvature function to be symmetric or not about $t=0$ which corresponds to $(0,0,0)$?
<li>Would you expect there to be a maximum, minimum, or neither at $t=0$?
</ul>
<p>[Graph $\kappa(t)$ to see...]


<h3>Unit tangent, unit normal, binormal</h3>
<p class="show">Several quantities, defined in terms of derivatives of $\myv r(t)$:
<p class="def show incremental">The unit tangent vector is
$$\uv T(t) \equiv \frac {\myv r'(t)}{|\myv r'(t)|}.$$

<p>Under what circumstances is $\uv T'(t)=0$?
<p>(That is to say, $\uv T'\equiv \frac{d}{dt}\uv T$ is not necessarily a <i>unit</i> vector.)

<p>But when $|\uv T'(t)|\neq 0$...
<ul><li>$\uv T(t)$ is a vector whose <i>length</i> (=1) is not changing with time.
<li>Therefore $\uv T'(t)$ must be at right angles to ("normal to") $\uv T$.
</ul>

<p class="def show incremental">The unit <b>normal</b> vector is
$$\uv N(t) \equiv \frac {\uv T'(t)}{|\uv T'(t)|}.$$
<p>$\uv N$ points towards the center of the osculating circle for $\myv r(t)$.

<p>What's the magnitude of the cross product of two unit vectors, which are at right angles?

<p class="def show incremental">The <b>binormal</b> vector is
$$\myv B(t)=\uv T(t)\times\uv N(t).$$
<p>We may as well write it as $\uv B(t)$ because it <i>must</i> have unit length by this definition.

<p><img src="0g/10.3.binormal.jpg">


<h3>Example</h3>
<p class="show">For $\myv r(t)=2\cos t \uv i + 2\sin t \uv j + 3t \uv k$: Find $\uv T$, $\uv N$, and $\uv B$ at $t=3\pi/2$.  Sketch these on a plot of $\myv r(t)$.<br>
<img src="0g/10.3.coil.jpg" class="big"><br>

<p class="justme">See <a href="10.3.TBN.nb">10.3.TBN.nb</a> for calculations




<h4 class="handout">Image credits</h4>
<p class="handout"><a href="http://en.wikipedia.org/wiki/File:Nowitna_river.jpg">Oliver Kurmis</a>

<?php include "../../classes/3.h" ?>