<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Motion in space [10.4]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Motion in space [10.4]
</h1>
<p class="show"><img src="0g/10.4.velocity.jpg" class="rightalign">
If $\myv r(t)$ represents the vector position of a point particle in space, as a function of time $t$, then the velocity vector is...
<p class="def incremental show">$$\myv v(t)\equiv\lim_{h\to 0}\frac{\myv r(t+h)-\myv r(t)}{h}=\myv r'(t) \equiv \dot{\myv r}(t).$$

<h3>Speed</h3>
<p class="def show">$$|\myv v(t)|\equiv |\myv r'(t)| = \frac{ds}{dt}\equiv v(t).$$
<p>So the scalar speed $v(t)$ only conveys the <i>magnitude</i> of the velocity vector, nothing about its direction.

<h3>Acceleration</h3>
<p class="def show">
$$\myv a(t)\equiv \myv v'(t)=\myv r''(t)\equiv \ddot{\myv r}(t).$$
<p>And we can also write acceleration as the limit of the change in velocity per unit time
$$\myv a(t)=\lim_{\Delta t\to 0}\frac{\myv v(t+\Delta t) - \myv v(t)}{\Delta t}.$$
<h4>Integrating...</h4>
<p>$$\myv v(t)=\myv v(t_0)+\int_{t_0}^t \myv a(u)\,du.$$
<p>$$\myv r(t)=\myv r(t_0)+\int_{t_0}^t \myv v(u)\,du.$$


<h3>Projectile motion</h3>
<p class="show"><img src="0g/10.4.projectile.jpg" class="rightalign"><br>
Acceleration due to gravity is constant, and always *down*.

<p>Newton's law, $\myv F=m\myv a$:  The only force acting on the projectile is gravity.  The gravitational force is the object's weight, $mg$ (where $g=9.8$ m/s${}^2$). 
$$\myv F=-mg \uv j = m(a_x(t) \uv i+a_y(t) \uv j.$$
<p>In the vertical direction ($\uv j$ component) this becomes:
$$-g=a_y(t)=v_y'(t)$$
Integrating as above and saying that $t=0$ is the time of launch (so that $v_y(0)=v_0\sin\alpha$
and $v_x(0)=v_0\cos\alpha$) we get:

$$v_y(t)=v_0\sin\alpha-gt.$$
Integrating once more, as above, gives:
$$y(t)=(v_0\sin\alpha) t-\frac12gt^2.$$


<p>Going through a similar process, the horizontal position is found to be:
$$x(t)=(v_0\cos\alpha) t.$$

<!--
<p class="show">See the <a href="10.4.catapult.nb">Catapult worksheet</a>
-->


<h3>Acceleration- components</h3>
<p class="show">Interesting things happen when we resolve acceleration into components parallel (tangential) and perpendicular (normal) to the velocity...

<p>Since the unit tangent vector $\uv T=\frac{\myv r'(t)}{|\myv r'(t)|}=\frac{\myv v}{v}$,
$$\myv v= v\uv T.$$
<p>Differentiating both sides of this equation, using the product rule on the right, gives us
$$\myv v' = \myv a = v' \uv T + v \uv T'.\label{accel}$$
<p>Now re-writing 2 relations from 10.3 in terms of velocity/speed:  The curvature, $\kappa$,
$$\nonumber \kappa = \frac{|\uv T'|}{|\myv r'|}= \frac{|\uv T'|}{v},$$
and the unit normal vector $\uv N=\uv T'/|\uv T'|$,
$$\nonumber \uv T' = |\uv T'| \uv N=\kappa v \uv N.$$
<p>Substituting into \ref{accel},
<p class="def show incremental">$$\myv a = v' \uv T +\kappa v^2 \uv N.$$

<ul>
<li>No $\uv B$ component (binormal) to the acceleration??!!
<li>This means that acceleration is always in the $\uv T$-, $\uv N$-plane.
<li><img src="0g/10.4.acomponents.jpg" class="rightalign">A change in speed, $v'$ only affects the tangential component, $a_T$.

<li>A very important difference from motion in one dimension is the acceleration of the velocity vector due to a <b>change in direction</b>:
<p class="def show">If a particle is moving around a curve, <b>even at constant speed</b>,  it <b>must have a normal component of acceleration</b> towards the "inside" of the curve (towards the center of the osculating circle).

<li>The normal component of acceleration, $a_N$, is only sensitive to speed^2 and curvature, not the <i>change</i> in speed.
<li>Newton's law is: $\myv F = m \myv a$. 
<li>So, the "sideways force" (the normal force) that the rails/road exerts on a train/car in order to keep it on the track/road is the normal component of the force (also called  the centripetal force):
$$F_N=ma_N=m\kappa v^2.$$
There is a maximum sideways force that rails can exert before a train "hops the rails"...
<iframe width="420" height="315" src="//www.youtube.com/embed/vt4G0RD77Ws" frameborder="0" allowfullscreen></iframe>
<p>"Twice the speed limit"...
<p>If you double the speed, the sideways force needed to stay on the rails <b>quadruples</b>.
</ul>


<h4>Components in terms of $\myv a$</h4> 
<p>$$\myv a(t)=a_T(t) \uv T(t)+a_N(t)\uv N(t).$$
<img src="0g/10.4.acomponents.jpg" class="rightalign">
<p>[In what follows, I'll stop writing the explicit time dependence, but just remember that all the quantities we're dealing with are time dependent.]

<p>The tangential component, $a_T$ is the dot product of $\myv a$ with a unit vector in the tangential direction, namely $\uv T$:
$$\begineq a_T&=\myv a\cdot\uv T\\
&=\myv a \cdot \frac{\myv v}{|\myv v|}=\frac{\myv a\cdot \myv v}{v}.\\
\endeq$$

<p>We can write the dot product as
 $\myv a \cdot \uv T=a \cos \theta$, where $\theta$ is the angle between $\myv a$ and $\uv T$.  

<p>Since  $\uv T \perp \uv N$,   We could write 
$$\nonumber a_N=\myv a \cdot \uv N = a \sin \theta.$$
<p>But  $|\myv a \times \uv T| = a \sin \theta$ too, so

<p>$$\begineq a_N &= |\myv a \times \uv T| \\
&= \left|\myv a \times \frac{\myv v}{v} \right| = \frac{|\myv a \times \myv v|}{v}
.\endeq$$


<div class="todo">
[Test 1 question, 2015] A particle is moving counterclockwise around a circle. Which of the
vectors in the figure below is <b>not</b> a possible acceleration
vector? Explain. For the remaining two possible acceleration vectors,
state whether the particle is speeding up or slowing down.<br>

<img src="0g/T1.circularacceleration.jpg"><br> 
</div>


<h3>Summary</h3>
<p class="show">Unit tangent vector
$$\uv T = \frac{\myv v}{v}$$
Unit Normal vector
$$\uv N = \frac{\uv T'}{|\uv T'|}$$
Decomposition of acceleration
$$\uv a(t)=a_T(t) \uv T(t) + a_N \uv N(t)$$
Tangential component
$$a_T=v'=\frac{\myv a \cdot \myv v}{v}$$
Normal component
$$a_N=\kappa v^2 =\frac{|\myv a \times \myv v |}{v}$$
<br><br>
$$a_N \uv N=\myv a -a_T\uv T = \myv a - \frac{\myv a \cdot \myv v}{\myv v\cdot\myv v}\myv v$$ 

<h3>For example</h3>
<p class="show">With this vector function for position:
$$\myv r(t)=t^2\uv i + t^2\uv j+t^3\uv k,$$
<p>the velocity is
$$\myv v(t)=\myv r'(t)=2t\uv i + 2t\uv j+3t^2\uv k.$$
<p>The speed is
$$|\myv v|=\sqrt{4t^2+4t^2+9t^4}=\sqrt{8t^2+9t^4}.$$
<p>the acceleration is
$$\myv a(t)=\myv r''(t)=2\uv i + 2\uv j+6t\uv k.$$
<p>Tangential component of acceleration
$$a_T=\frac{\myv a \cdot \myv v}{v}=\frac{8t+18t^3}{\sqrt{8t^2+9t^4}}.$$
<p>Normal component of acceleration
$$
a_N=\frac{|\myv a \times \myv v |}{v}=\frac{6\sqrt 2 t^2}{\sqrt{8t^2+9t^4}},
$$
using...
$$\begineq
\myv a \times \myv v&=\left|\begincv
\uv i&\uv j&\uv k \\
2&2&6t\\
2t&2t&3t^2
\endcv\right| \\
&=(6t^2-12t^2)\uv i + (12t^2-6t^2)\uv j + (4t-4t)\uv k\\
&=-6t^2\uv i +6t^2 \uv j
\endeq
$$






<h4 class="handout">Image credits</h4>


<?php include "../../classes/3.h" ?>