<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Partial derivatives [11.3]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h2>Which way to go?</h2>
<p><img src="0g/11.3.upwego.jpg" class="big">

<h2>The hiking question(s)</h2>
<p class="show"><img src="0g/11.3.upwego.jpg">

<p class="show">Which direction should I go...
<ul>
<li>to go up most steeply?
<li>to go down most steeply?
<li>to keep moving around the mountain while staying at the same altitude?
<li>Also, how steep is the path I'm on right now? 
</ul>
<p>Ummmmm... Actually our brains working with our eyes are pretty good at answering such questions <i>unconsciously</i> with little or not calculus training!
<p>We will instead be trying to answer questions about <b>surfaces</b> for which we have a <b>mathematical description</b> (often a function). The surfaces will mostly be continuous and well behaved.

<h3>The slope...in any direction</h3>
<p class="show"><img src="0g/11.3.upwego.jpg"><br>
For a function, $f(x)$, of one variable, $\frac{df}{dx}$ is <b>*the* slope</b> of the graph at $x$.  
<br><br>
But on a mountain (=<i>surface</i>),  <b>slope depends on the direction</b> of motion.  Or we could say, it depends on the <i>path</i> taken.

<h1>
Partial derivatives [11.3]
</h1>

<p class="def show">If $f$ is a function of two variables, then its <b>partial derivatives</b> are the functions $f_x$ and $f_y$ defined by
$$f_x(x,y)=\lim_{h\to 0}\frac{f(x+h,y)-f(x,y)}{h}$$
$$f_y(x,y)=\lim_{h\to 0}\frac{f(x,y+h)-f(x,y)}{h}$$
In the first definition, $y$ is constant and $x$ varies.  In the second one $x$ is constant and $y$ varies.

<p><b>Notation...</b>
$$f_x(x,y)\equiv f_x\equiv \frac{\del f}{\del x}\equiv \frac{\del}{\del x}f(x,y)\equiv \frac{\del z}{\del x}\equiv D_x f.$$
$$f_y(x,y)\equiv f_y\equiv \frac{\del f}{\del y}\equiv \frac{\del}{\del y}f(x,y)\equiv \frac{\del z}{\del y}\equiv D_y f.$$
with $z=f(x,y)$.

<p>[I have seen $f_1$ or $D_1$ very rarely].

<h3>Rules for calculating partial derivatives</h3>
<ol class="show def incremental">
<li>To find $f_x$, regard $y$ as constant, and differentiate $f(x,y)$ with respect to $x$.
<li>To find $f_y$, regard $x$ as constant, and differentiate $f(x,y)$ with respect to $y$.
</ol>
<p>For example:
$$f(x,y)=3xy^2$$
<p>$$f_x=\frac{\del
}{\del x} (3y^2)x=3y^2$$
<p>$$f_y=\frac{\del 
}{\del y}(3x)y^2=(3x)*2y=6xy$$

<p><img src="0g/11.3.CCdiff.jpg" class="rightalign">In CoCalc (at right):
<p><p><i>Mathematica</i>: <tt>D[f,x]</tt>, <tt>D[f,y]</tt>

<br clear="both">
<h3>Visualizing</h3>
<p class="show"><img src="0g/11.3.tangents.jpg"  class="big">

<p class="show"><img src="0g/11.3.StewartCalculus.gif" class="big">

<h3>To do</h3>
<ul class="todo">
<li>Tabular data - Just 1-3.
<li>Graphical data - Just 1-3.
</ul>

<h3>Higher order derivatives</h3>

<p class="show">
$$(f_x)_x=f_{xx}=\frac{\del}{\del x}\left( \frac{\del f}{\del x}\right)=\frac{\del^2 f}{\del x^2} =\frac{\del^2 z}{\del x^2}.$$ 

$$(f_x)_y=f_{xy}=\frac{\del}{\del y}\left( \frac{\del f}{\del x}\right)=\frac{\del^2 f}{\del y \del x} =\frac{\del^2 z}{\del y \del x}.$$ 

$$(f_y)_x=f_{yx}=\frac{\del}{\del x}\left( \frac{\del f}{\del y}\right)=\frac{\del^2 f}{\del x \del y} =\frac{\del^2 z}{\del x \del y}.$$ 


$$f_{yy}=(f_y)_y=\frac{\del}{\del y}\left( \frac{\del f}{\del y}\right)=\frac{\del^2 f}{\del y^2} =\frac{\del^2 z}{\del y^2}.$$ 

<p><b>Interpretation</b>
<p>$f_x$ means...what?
<p>$f_{yy}$ means...what? <span class="justme answer">It is the curvature or concavity of the curve of a path in the $y$ direction--along the lines of the second derivative of a function of one variable.</span>
<p>$f_{yx}$ is the rate of change of the slope in the $y$ direction, as you increase $x$.  But is there a word like "concavity" or "slope" to describe what that means graphically?  See this <a href="https://www.geogebra.org/3d/subwve7m">visualization of $f_{yx}$</a>


<h3>Example</h3>

<p class="show">Consider...
$$f (x, y) = x^3 + x^2y^3 – 2y^2$$
<p>$$f_x=3x^2+2xy^3;\ \ \ f_y=3y^2x^2-4y$$

<p>$$f_{xy}=\frac{\del f_x}{\del y}=6xy^2;\ \ \ f_{yx}=\frac{\del f_y}{\del x}=6xy^2$$

<p>$$f_{xx}=\frac{\del f_x}{\del x}=6x+2y^3;\ \ \ f_{yy}=\frac{\del f_y}{\del y}=6yx^2-4$$


<h3>Clairaut's theorem</h3>

<p class="show def">Suppose $f$ is defined on a disk $D$ that contains the point $(a,b)$.  If the functions $f_{xy}$ and $f_{yx}$ are both continuous on $D$, then
$$f_{xy}(a,b)=f_{yx}(a,b).$$
<p>Another way of saying this is
$$\frac{\del}{\del y}\left(\frac{\del f}{\del x}\right)
=\frac{\del}{\del x}\left(\frac{\del f}{\del y}\right).$$


<p>See <a href="11.3c.php">Clairaut's theorem and the meaning of $f_{xy}$</a>.

<h3>Differentiability</h3>
<p class="show def">If $z=f(x,y)$, then $f$ is <b>differentiable</b> at $(a,b)$ if $\Delta z$ can be expressed in the form
$$\Delta z = f_x(a,b) \Delta x + f_y(a,b) \Delta y + \epsilon_1 \Delta x
+\epsilon_2 \Delta y$$
where $\epsilon_1\to 0$ and $\epsilon_2 \to 0$ as $(\Delta x, \Delta y)\to 0$.

<h4>In hiking terms</h4>
<p><img src="0g/11.3.hiking.jpg" class="rightalign">How does your altitude change ($\Delta z$)?  

<br><br>Well, it depends on how far east ($\Delta x$) and north ($\Delta y$) you move, 

<br><br>...and also  on the the east-west slope ($f_x$) and the north-south slope.  It's a pretty good approximation to say that your height will change by...
$$\label{hikeit} \Delta z \approx f_x \Delta x + f_y \Delta y.$$

<p>This is, in principle, the resolution to at least one of the hiking questions:
<ul><li>If you choose to step in an arbitrary direction, as specified by $\Delta x$ and $\Delta y$,
<li>Then, knowing only two <b>local</b> characteristics of the surface, $f_x$ and $f_y$,
<li>You can approximate your change in height.
</ul>

<p class="show incremental def"><b>Theorem:</b> If the partial derivatives $f_x$ and $f_y$ exist near $(a,b)$, and if they are continuous at $(a,b)$, then $f$ is differentiable at $(a,b)$.

<p>In hiking terms:  The approach of using Eq (\ref{hikeit}) to calculate your change in height won't work on top of a sharp ridge, or at the edge of a cliff.


<h3>To Do</h3>
<ul class="todo">
<li>Mixed partials
</ul>


<h4 class="handout">Image credits</h4>
<p class="handout"><a href="http://www.flickr.com/photos/24738080@N00/8015267844">Matthiew Lienhart</a>


<?php include "../../classes/3.h" ?><