<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Linear approximations [11.4]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Linear approximations
</h1>

<p><img src="0g/11.4.balance.jpg"  class="big"><br>
The board is <b>tangent</b> to the bowling ball at the point of contact.

<h3>Tangent planes</h3>
<p class="show"><img src="0g/11.4.tangentplane.jpg"  class="big">
<p>Suppose $f$ has continuous partial derivaties.  An equation of the tangent plane to the surface $z=f(x,y)$ at the point $P(x_0,y_0, z_0)$ is
$$z-z_0=f_x(x_0,y_0)(x-x_0)+f_y(x_0,y_0)(y-y_0)$$

<h3>Linear approximation</h3>

<p class="show">$$z = f(a, b) + f_x(a, b)(x – a) + f_y(a, b)(y – b)$$
is called the <b>linear approximation</b> or the <b>tangent plane
approximation</b> of $f$ at $(a, b)$.

<p class="show incremental def">The <b>differential</b> of $f$ is
$$dz \equiv f_x(x,y)\,dx+f_y(x,y)\,dy =  \frac{\del f}{\del x}dx+
\frac{\del f}{\del y}dy.$$

<p>In the limit of very small 'steps', $dx$ and $dy$, the linear approximation can be written as
$$f(x,y)=f(a,b)+dz.$$

<h3>Geometric view</h3>
<p class="show"><img src="0g/11.4.lineardetail.jpg" class="big">
<h4>Hiking view</h4>
<p>The hiking approximation
$$\label{hikeit} \Delta z \approx f_x \Delta x + f_y \Delta y$$
<ul>
<li>becomes <i>exact</i> as your stepsize becomes small, and

<li>is apparently equivalent to the linear approximation, and
<li>only works if there's a unique plane tangent to the surface.
</ul>

<h3>To Do</h3>
<ul class="todo">
<li>Finish Tabular data
<li>Finish Graphical data
</ul>

<h4 class="handout">Image credits</h4>
<p class="handout"><a href="http://www.flickr.com/photos/lcwilder/3958141171">Larry Wilder</a>


<?php include "../../classes/3.h" ?>