(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     26768,        825]
NotebookOptionsPosition[     24058,        733]
NotebookOutlinePosition[     24412,        749]
CellTagsIndexPosition[     24369,        746]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Lagrange Multiplier Problems", "Section",
 CellChangeTimes->{{3.609016025548888*^9, 3.609016032830267*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "#1: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     SuperscriptBox["x", "2"], "-", 
     RowBox[{"8", "x"}], "+", 
     SuperscriptBox["y", "2"], "-", 
     RowBox[{"12", "y"}], "+", "48"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \nand constraint ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "+", "y"}], "=", "8"}], TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Subsubsection",
 CellChangeTimes->{{3.609016067202097*^9, 3.6090160676816387`*^9}, {
   3.609016131384479*^9, 3.609016214225398*^9}, 3.609017183717375*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myf", "=", 
   FormBox[
    RowBox[{
     SuperscriptBox["x", "2"], "-", 
     RowBox[{"8", "x"}], "+", 
     SuperscriptBox["y", "2"], "-", 
     RowBox[{"12", "y"}], "+", "48"}],
    TraditionalForm]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myg", " ", "=", " ", 
   RowBox[{"x", "+", "y"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"constraint", "=", " ", 
   RowBox[{"myg", "\[Equal]", "8"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Grad", "[", 
  RowBox[{"myf", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Grad", "[", 
  RowBox[{"myg", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6090162236122637`*^9, 3.6090163203054943`*^9}, {
  3.609016389797717*^9, 3.609016405490127*^9}, {3.609016444822967*^9, 
  3.609016452080495*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "8"}], "+", 
    RowBox[{"2", " ", "x"}]}], ",", 
   RowBox[{
    RowBox[{"-", "12"}], "+", 
    RowBox[{"2", " ", "y"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.609016398554838*^9, 3.609016406197083*^9}, 
   3.609016453060848*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.609016398554838*^9, 3.609016406197083*^9}, 
   3.609016453062112*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "8"}], "+", 
      RowBox[{"2", " ", "x"}]}], "\[Equal]", " ", 
     RowBox[{"\[Lambda]", "*", "1"}]}], "&&", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12"}], "+", 
      RowBox[{"2", " ", "y"}]}], "\[Equal]", 
     RowBox[{"\[Lambda]", "*", "1"}]}], " ", "&&", "\[IndentingNewLine]", 
    "constraint"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "\[Lambda]"}], "}"}]}], "\[IndentingNewLine]",
   "]"}]], "Input",
 CellChangeTimes->{{3.609016492929819*^9, 3.6090166416324167`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "3"}], ",", 
    RowBox[{"y", "\[Rule]", "5"}], ",", 
    RowBox[{"\[Lambda]", "\[Rule]", 
     RowBox[{"-", "2"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.609016642267663*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["One critical point at (3,5).",
  Background->RGBColor[1, 1, 0]],
 " \nTo check for a min/max, we look at the second derivatives..."
}], "Text",
 CellChangeTimes->{{3.609016714117524*^9, 3.609016783781295*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"D", "[", 
  RowBox[{"myf", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"D", "[", 
  RowBox[{"myf", ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.609016753260045*^9, {3.60901680239441*^9, 3.609016846390654*^9}}],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{{3.60901682957024*^9, 3.609016847389846*^9}}],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{{3.60901682957024*^9, 3.609016847390862*^9}}]
}, Open  ]],

Cell[TextData[{
 "Both 2nd derivatives are positive, so this is a ",
 StyleBox["minimum",
  Background->RGBColor[1, 1, 0]],
 ", with value..."
}], "Text",
 CellChangeTimes->{{3.609016875677857*^9, 3.609016890338236*^9}, {
  3.609016926446766*^9, 3.6090169312230873`*^9}, {3.609016964545734*^9, 
  3.60901696481631*^9}}],

Cell[BoxData[
 RowBox[{"myf", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "3"}], ",", 
    RowBox[{"y", "\[Rule]", "5"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.6090168654009027`*^9, 3.609016869625724*^9}, {
  3.609016969179027*^9, 3.609016985572151*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"-", "2"}],
  Background->RGBColor[1, 1, 0]]], "Input",
 CellChangeTimes->{3.609016997774396*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "\[LineSeparator]\[LineSeparator]\[LineSeparator]#2: Minimum value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"x", ",", "y", ",", "z"}], ")"}], "=", 
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["x", "2"]}], "+", 
     SuperscriptBox["y", "2"], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["z", "2"]}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \nand constraints ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", "x"}], "-", 
     RowBox[{"3", " ", "y"}], "-", 
     RowBox[{"4", " ", "z"}]}], "=", "49"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Subsubsection",
 CellChangeTimes->{{3.60901707396813*^9, 3.609017229132769*^9}, 
   3.609017330655727*^9, {3.609017651146607*^9, 3.6090176514325666`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myf", "=", 
   FormBox[
    FormBox[
     RowBox[{
      RowBox[{"2", 
       SuperscriptBox["x", "2"]}], "+", 
      SuperscriptBox["y", "2"], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["z", "2"]}]}],
     TraditionalForm],
    TraditionalForm]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myg", " ", "=", " ", 
   FormBox[
    RowBox[{
     RowBox[{"2", " ", "x"}], "-", 
     RowBox[{"3", " ", "y"}], "-", 
     RowBox[{"4", " ", "z"}]}],
    TraditionalForm]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"constraint", "=", " ", 
   RowBox[{"myg", "\[Equal]", "49"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Grad", "[", 
  RowBox[{"myf", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Grad", "[", 
  RowBox[{"myg", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6090162236122637`*^9, 3.6090163203054943`*^9}, {
  3.609016389797717*^9, 3.609016405490127*^9}, {3.609016444822967*^9, 
  3.609016452080495*^9}, {3.609017281075653*^9, 3.6090173025689487`*^9}, {
  3.609017337797303*^9, 3.609017354284968*^9}, {3.609019033212335*^9, 
  3.609019064348268*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4", " ", "x"}], ",", 
   RowBox[{"2", " ", "y"}], ",", 
   RowBox[{"6", " ", "z"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.609016398554838*^9, 3.609016406197083*^9}, 
   3.609016453060848*^9, {3.6090173442261143`*^9, 3.609017354796567*^9}, 
   3.609019066102417*^9, 3.609019142088704*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "4"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.609016398554838*^9, 3.609016406197083*^9}, 
   3.609016453060848*^9, {3.6090173442261143`*^9, 3.609017354796567*^9}, 
   3.609019066102417*^9, 3.609019142090394*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"4", "x"}], "\[Equal]", " ", 
     RowBox[{"\[Lambda]", "*", "2"}]}], "&&", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"2", " ", "y"}], "\[Equal]", 
     RowBox[{"\[Lambda]", "*", 
      RowBox[{"(", 
       RowBox[{"-", "3"}], ")"}]}]}], " ", "&&", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"6", " ", "z"}], " ", "\[Equal]", " ", 
     RowBox[{"\[Lambda]", " ", 
      RowBox[{"(", 
       RowBox[{"-", "4"}], ")"}]}]}], "&&", "\[IndentingNewLine]", 
    "constraint"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "\[Lambda]"}], "}"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.609016492929819*^9, 3.6090166416324167`*^9}, {
  3.609017365593378*^9, 3.6090174315547647`*^9}, {3.6090190884233027`*^9, 
  3.609019104728354*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "3"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "9"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", "4"}]}], ",", 
    RowBox[{"\[Lambda]", "\[Rule]", "6"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.609016642267663*^9, 3.609017432259863*^9, 
  3.609019105855626*^9, 3.6090191449749393`*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["One critical point at (3, -9, -4).",
  Background->RGBColor[1, 1, 0]],
 " \nTo check for a min/max, we look at the second derivatives..."
}], "Text",
 CellChangeTimes->{{3.609016714117524*^9, 3.609016783781295*^9}, {
  3.6090174460264397`*^9, 3.609017460847815*^9}, {3.609019110618197*^9, 
  3.609019131186161*^9}}],

Cell["\<\
The value of the function at this point is...\
\>", "Text",
 CellChangeTimes->{{3.609016875677857*^9, 3.609016890338236*^9}, {
  3.609016926446766*^9, 3.6090169312230873`*^9}, {3.609016964545734*^9, 
  3.60901696481631*^9}, {3.609017558817586*^9, 3.609017578282625*^9}, {
  3.6090186966932373`*^9, 3.609018709672254*^9}}],

Cell[BoxData[
 RowBox[{"myf", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "3"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "9"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", "4"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.6090168654009027`*^9, 3.609016869625724*^9}, {
  3.609016969179027*^9, 3.609016985572151*^9}, {3.609017585439592*^9, 
  3.60901760142327*^9}, {3.6090191269149027`*^9, 3.609019161805744*^9}}],

Cell[BoxData[
 StyleBox["147",
  Background->RGBColor[1, 1, 0]]], "Input",
 CellChangeTimes->{3.609019170987116*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "\[LineSeparator]\[LineSeparator]\[LineSeparator]#3: Maximum value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"x", ",", "y", ",", "z"}], ")"}], "=", 
    RowBox[{
     RowBox[{"x", " ", "y"}], "+", 
     RowBox[{"y", " ", "z", " "}]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \nand 2 constraints, ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", " ", "y"}]}], "=", "6"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "-", 
     RowBox[{"3", " ", "z"}]}], "=", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Subsubsection",
 CellChangeTimes->{{3.60901707396813*^9, 3.609017229132769*^9}, 
   3.609017330655727*^9, {3.609017651146607*^9, 3.60901778706868*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myf", "=", 
   FormBox[
    RowBox[{
     RowBox[{"x", " ", "y"}], "+", 
     RowBox[{"y", " ", "z"}]}],
    TraditionalForm]}], ";", " ", 
  RowBox[{"myg", " ", "=", " ", 
   FormBox[
    RowBox[{"x", "+", 
     RowBox[{"2", " ", "y", " "}]}],
    TraditionalForm]}], ";", " ", 
  RowBox[{"myh", "=", 
   RowBox[{"x", "-", 
    RowBox[{"3", " ", "z"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Grad", "[", 
  RowBox[{"myf", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Grad", "[", 
  RowBox[{"myg", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Grad", "[", 
  RowBox[{"myh", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6090162236122637`*^9, 3.6090163203054943`*^9}, {
  3.609016389797717*^9, 3.609016405490127*^9}, {3.609016444822967*^9, 
  3.609016452080495*^9}, {3.609017281075653*^9, 3.6090173025689487`*^9}, {
  3.609017337797303*^9, 3.609017354284968*^9}, {3.609017805855237*^9, 
  3.6090179008121758`*^9}, {3.609018034329336*^9, 3.6090180352653217`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y", ",", 
   RowBox[{"x", "+", "z"}], ",", "y"}], "}"}]], "Output",
 CellChangeTimes->{{3.609016398554838*^9, 3.609016406197083*^9}, 
   3.609016453060848*^9, {3.6090173442261143`*^9, 3.609017354796567*^9}, 
   3.609017901252904*^9, 3.609018038335144*^9, 3.60901924290663*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.609016398554838*^9, 3.609016406197083*^9}, 
   3.609016453060848*^9, {3.6090173442261143`*^9, 3.609017354796567*^9}, 
   3.609017901252904*^9, 3.609018038335144*^9, 3.609019242909115*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.609016398554838*^9, 3.609016406197083*^9}, 
   3.609016453060848*^9, {3.6090173442261143`*^9, 3.609017354796567*^9}, 
   3.609017901252904*^9, 3.609018038335144*^9, 3.6090192429107656`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "\[Equal]", " ", 
     RowBox[{
      RowBox[{"\[Lambda]", "*", "1"}], "+", 
      RowBox[{"\[Mu]", "*", "1"}]}]}], "&&", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"x", "+", "z"}], "\[Equal]", 
     RowBox[{"\[Lambda]", "*", "2"}]}], " ", "&&", "\[IndentingNewLine]", 
    RowBox[{"y", " ", "\[Equal]", " ", 
     RowBox[{"\[Mu]", "*", 
      RowBox[{"(", 
       RowBox[{"-", "3"}], ")"}]}]}], "&&", "\[IndentingNewLine]", 
    RowBox[{"myg", "\[Equal]", "6"}], " ", "&&", 
    RowBox[{"myh", "\[Equal]", "0"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "\[Lambda]", ",", "\[Mu]"}], 
    "}"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.609016492929819*^9, 3.6090166416324167`*^9}, {
  3.609017365593378*^9, 3.6090174315547647`*^9}, {3.609017910715848*^9, 
  3.609017990803437*^9}, {3.609018043574074*^9, 3.609018071051176*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "3"}], ",", 
    RowBox[{"y", "\[Rule]", 
     FractionBox["3", "2"]}], ",", 
    RowBox[{"z", "\[Rule]", "1"}], ",", 
    RowBox[{"\[Lambda]", "\[Rule]", "2"}], ",", 
    RowBox[{"\[Mu]", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.609016642267663*^9, 3.609017432259863*^9, 
  3.609017991791666*^9, 3.6090180726544456`*^9, 3.6090193018859577`*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["One critical point at (3, 3/2, 1).",
  Background->RGBColor[1, 1, 0]],
 " \nLooking at the the second derivatives..."
}], "Text",
 CellChangeTimes->{{3.609016714117524*^9, 3.609016783781295*^9}, {
  3.6090174460264397`*^9, 3.609017460847815*^9}, {3.6090180839666367`*^9, 
  3.6090180950685377`*^9}, {3.609018648282117*^9, 3.609018657461953*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"D", "[", 
  RowBox[{"myf", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"D", "[", 
  RowBox[{"myf", ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"D", "[", 
  RowBox[{"myf", ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.609016753260045*^9, {3.60901680239441*^9, 3.609016846390654*^9}, {
   3.609017508435175*^9, 3.609017514709125*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.60901682957024*^9, 3.609016847389846*^9}, {
   3.609017480141837*^9, 3.6090174835265102`*^9}, 3.6090175157604437`*^9, 
   3.609018101385594*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.60901682957024*^9, 3.609016847389846*^9}, {
   3.609017480141837*^9, 3.6090174835265102`*^9}, 3.6090175157604437`*^9, 
   3.609018101387957*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.60901682957024*^9, 3.609016847389846*^9}, {
   3.609017480141837*^9, 3.6090174835265102`*^9}, 3.6090175157604437`*^9, 
   3.609018101389711*^9}]
}, Open  ]],

Cell["\<\
Interesting!  at any rate, the value of the function at the critical point \
is...\
\>", "Text",
 CellChangeTimes->{{3.609016875677857*^9, 3.609016890338236*^9}, {
  3.609016926446766*^9, 3.6090169312230873`*^9}, {3.609016964545734*^9, 
  3.60901696481631*^9}, {3.609017558817586*^9, 3.609017578282625*^9}, {
  3.609018142765757*^9, 3.609018168097724*^9}, {3.6090186646821203`*^9, 
  3.609018666699853*^9}}],

Cell[BoxData[
 RowBox[{"myf", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "3"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"3", "/", "2"}]}], ",", 
    RowBox[{"z", "\[Rule]", "1"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.6090168654009027`*^9, 3.609016869625724*^9}, {
  3.609016969179027*^9, 3.609016985572151*^9}, {3.609017585439592*^9, 
  3.60901760142327*^9}, {3.609018188509119*^9, 3.609018195888341*^9}}],

Cell[BoxData[
 StyleBox["6",
  Background->RGBColor[1, 1, 0]]], "Input",
 CellChangeTimes->{3.609018205600952*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "\[LineSeparator]\[LineSeparator]\[LineSeparator]#4: Maximum value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"x", ",", "y", ",", "z"}], ")"}], "=", 
    RowBox[{"x", " ", "y", " ", "z", " "}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \nand constraint, ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     RowBox[{"x", "+", "y", "+", "z", "-", "6"}], "=", "0"}]}], 
   TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Subsubsection",
 CellChangeTimes->{{3.60901707396813*^9, 3.609017229132769*^9}, 
   3.609017330655727*^9, {3.609017651146607*^9, 3.60901778706868*^9}, {
   3.6090182610492764`*^9, 3.6090183261838417`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myf", "=", 
   FormBox[
    RowBox[{"x", " ", "y", " ", "z"}],
    TraditionalForm]}], ";", " ", 
  RowBox[{"myg", " ", "=", " ", 
   FormBox[
    RowBox[{"x", "+", " ", "y", "+", "z", " ", "-", "6"}],
    TraditionalForm]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Grad", "[", 
  RowBox[{"myf", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Grad", "[", 
  RowBox[{"myg", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6090162236122637`*^9, 3.6090163203054943`*^9}, {
  3.609016389797717*^9, 3.609016405490127*^9}, {3.609016444822967*^9, 
  3.609016452080495*^9}, {3.609017281075653*^9, 3.6090173025689487`*^9}, {
  3.609017337797303*^9, 3.609017354284968*^9}, {3.609017805855237*^9, 
  3.6090179008121758`*^9}, {3.609018034329336*^9, 3.6090180352653217`*^9}, {
  3.6090183312541237`*^9, 3.609018349501564*^9}, {3.609018471627822*^9, 
  3.609018472924191*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"y", " ", "z"}], ",", 
   RowBox[{"x", " ", "z"}], ",", 
   RowBox[{"x", " ", "y"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.609016398554838*^9, 3.609016406197083*^9}, 
   3.609016453060848*^9, {3.6090173442261143`*^9, 3.609017354796567*^9}, 
   3.609017901252904*^9, 3.609018038335144*^9, 3.609018350493786*^9, 
   3.609018474438323*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.609016398554838*^9, 3.609016406197083*^9}, 
   3.609016453060848*^9, {3.6090173442261143`*^9, 3.609017354796567*^9}, 
   3.609017901252904*^9, 3.609018038335144*^9, 3.609018350493786*^9, 
   3.609018474440226*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", " ", "z"}], "\[Equal]", " ", 
     RowBox[{"\[Lambda]", "*", "1"}]}], " ", "&&", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"x", " ", "z"}], "\[Equal]", 
     RowBox[{"\[Lambda]", "*", "1"}]}], " ", "&&", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"x", " ", "y"}], " ", "\[Equal]", " ", 
     RowBox[{"\[Lambda]", "*", "1"}]}], " ", "&&", "\[IndentingNewLine]", 
    RowBox[{"myg", "\[Equal]", "0"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "\[Lambda]"}], "}"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.609016492929819*^9, 3.6090166416324167`*^9}, {
  3.609017365593378*^9, 3.6090174315547647`*^9}, {3.609017910715848*^9, 
  3.609017990803437*^9}, {3.609018043574074*^9, 3.609018071051176*^9}, {
  3.609018356604227*^9, 3.609018411589055*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", "6"}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "6"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", "2"}], ",", 
     RowBox[{"z", "\[Rule]", "2"}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}], ",", 
     RowBox[{"\[Lambda]", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.609016642267663*^9, 3.609017432259863*^9, 
  3.609017991791666*^9, 3.6090180726544456`*^9, 3.609018412415567*^9, 
  3.6090184783595057`*^9}]
}, Open  ]],

Cell[TextData[{
 "The point (0,0,0) is a minimum, The critical point that might be a maximum \
is\nat ",
 StyleBox["(2,2,2)",
  Background->RGBColor[1, 1, 0]],
 ". \nTo check for a min/max, we look at the second derivatives..."
}], "Text",
 CellChangeTimes->{{3.609016714117524*^9, 3.609016783781295*^9}, {
  3.6090174460264397`*^9, 3.609017460847815*^9}, {3.6090180839666367`*^9, 
  3.6090180950685377`*^9}, {3.6090184219764833`*^9, 3.609018423736828*^9}, {
  3.609018490348629*^9, 3.6090185372898903`*^9}}],

Cell["\<\
The value of the function at the critical point is...\
\>", "Text",
 CellChangeTimes->{{3.609016875677857*^9, 3.609016890338236*^9}, {
  3.609016926446766*^9, 3.6090169312230873`*^9}, {3.609016964545734*^9, 
  3.60901696481631*^9}, {3.609017558817586*^9, 3.609017578282625*^9}, {
  3.609018142765757*^9, 3.609018168097724*^9}, {3.609018603509973*^9, 
  3.6090186054438066`*^9}}],

Cell[BoxData[
 RowBox[{"myf", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "2"}], ",", 
    RowBox[{"y", "\[Rule]", "2"}], ",", 
    RowBox[{"z", "\[Rule]", "2"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.6090168654009027`*^9, 3.609016869625724*^9}, {
  3.609016969179027*^9, 3.609016985572151*^9}, {3.609017585439592*^9, 
  3.60901760142327*^9}, {3.609018188509119*^9, 3.609018195888341*^9}, {
  3.609018609695609*^9, 3.609018614121176*^9}}],

Cell[BoxData[
 StyleBox["8",
  Background->RGBColor[1, 1, 0]]], "Input",
 CellChangeTimes->{3.60901862379557*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 867},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 113, 1, 80, "Section"],
Cell[CellGroupData[{
Cell[717, 27, 656, 21, 63, "Subsubsection"],
Cell[CellGroupData[{
Cell[1398, 52, 909, 26, 101, "Input"],
Cell[2310, 80, 304, 10, 28, "Output"],
Cell[2617, 92, 165, 4, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2819, 101, 677, 18, 114, "Input"],
Cell[3499, 121, 271, 8, 28, "Output"]
}, Open  ]],
Cell[3785, 132, 236, 5, 49, "Text"],
Cell[CellGroupData[{
Cell[4046, 141, 349, 10, 46, "Input"],
Cell[4398, 153, 93, 1, 28, "Output"],
Cell[4494, 156, 93, 1, 28, "Output"]
}, Open  ]],
Cell[4602, 160, 319, 8, 30, "Text"],
Cell[4924, 170, 278, 7, 28, "Input"],
Cell[5205, 179, 132, 4, 28, InheritFromParent]
}, Open  ]],
Cell[CellGroupData[{
Cell[5374, 188, 838, 26, 135, "Subsubsection"],
Cell[CellGroupData[{
Cell[6237, 218, 1256, 37, 101, "Input"],
Cell[7496, 257, 343, 8, 28, "Output"],
Cell[7842, 267, 309, 7, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8188, 279, 921, 23, 131, "Input"],
Cell[9112, 304, 404, 11, 28, "Output"]
}, Open  ]],
Cell[9531, 318, 342, 7, 49, "Text"],
Cell[9876, 327, 331, 6, 30, "Text"],
Cell[10210, 335, 457, 11, 28, "Input"],
Cell[10670, 348, 116, 3, 28, InheritFromParent]
}, Open  ]],
Cell[CellGroupData[{
Cell[10823, 356, 882, 29, 135, "Subsubsection"],
Cell[CellGroupData[{
Cell[11730, 389, 1207, 34, 80, "Input"],
Cell[12940, 425, 316, 6, 28, "Output"],
Cell[13259, 433, 293, 5, 28, "Output"],
Cell[13555, 440, 314, 6, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13906, 451, 1008, 22, 131, "Input"],
Cell[14917, 475, 501, 13, 105, "Output"]
}, Open  ]],
Cell[15433, 491, 372, 7, 49, "Text"],
Cell[CellGroupData[{
Cell[15830, 502, 528, 15, 63, "Input"],
Cell[16361, 519, 195, 3, 28, "Output"],
Cell[16559, 524, 195, 3, 28, "Output"],
Cell[16757, 529, 195, 3, 28, "Output"]
}, Open  ]],
Cell[16967, 535, 417, 8, 30, "Text"],
Cell[17387, 545, 439, 10, 28, "Input"],
Cell[17829, 557, 114, 3, 28, InheritFromParent]
}, Open  ]],
Cell[CellGroupData[{
Cell[17980, 565, 720, 21, 135, "Subsubsection"],
Cell[CellGroupData[{
Cell[18725, 590, 1030, 25, 63, "Input"],
Cell[19758, 617, 391, 9, 28, "Output"],
Cell[20152, 628, 319, 6, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20508, 639, 949, 20, 131, "Input"],
Cell[21460, 661, 1075, 29, 46, "Output"]
}, Open  ]],
Cell[22550, 693, 508, 10, 68, "Text"],
Cell[23061, 705, 388, 7, 30, "Text"],
Cell[23452, 714, 462, 10, 28, "Input"],
Cell[23917, 726, 113, 3, 28, InheritFromParent]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
