<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Lagrange multipliers [11.8]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Lagrange multipliers
</h1>


<p class="show">
<img src="0g/11.8.profile.jpg" class="big"><br>
How to find peaks, or valleys, along a particular path?

<h3>1st approach</h3>
<p class="show"><img src="0g/11.8.kittencontours.jpg"><br>
In the kitten problem, $T(x,y)=x^2-2xy$, you guessed that the highest temperature occurred on the bottom blue boundary, as close to the next-highest contour line outside as possible.

<p>Now try another approach:

<div class="todo">
<ul><li>Parameterize the blue path, $y=x^2$, coming up with $x(t)$ and $y(t)$,
<li>Find $z(t)=T(x,y)=T(x(t),y(t))$
<li>Find critical points: $t$ such that  $dz/dt=0$.  If more than one, figure out the maxima.
<li>Use that $t$ to find coordinates $x(t)$ and $y(t)$.
</ul>
<p>What are the coordinates of the point along the boundary with the highest temperature?
</div>


<p>Now we'll consider another way...
<h3>The gradient and contour lines</h3>
<p class="show">
$z=f(x,y)$ is the equation for a surface in three dimensions.
<p>
What we mean by a "contour line":<br>
<img src="0g/11.8.kittencontours.jpg"><br>
<ul class="incremental"><li>$f(x,y)=k$ is a level curve or contour line.
<li>A contour line is a curve graphed in the $xy$ plane. (Not in 3-dimensions.)
</ul>

<p>
The gradient at a point $(x_0,y_0)$ in the $xy$ plane:
<br>
<img src="0g/11.8.kittengrad.jpg">
<br>
<ul> 
<li>$$\begineq \myv \grad f(x_0,y_0)&=f_x(x_0,y_0)\uv i +f_y(x_0,y_0)\uv j\\
&\equiv&\left.\frac{\del f(x,y)}{\del x}\right|^{(x_0,y_0)}
\uv i 
+\left.\frac{\del f(x,y)}{\del y}\right|^{(x_0,y_0)}
\uv j
\endeq$$
<li>It points in the direction of maximum slope of the surface $z=f(x,y)$.
<li>But the gradient is a vector in the $xy$ plane. (Not in 3-dimensions).
<li>The gradient at $(x_0,y_0)$ is always perpendicular to the contour line $f(x,y)=k=f(x_0,y_0)$.  
</ul>

<p class="show incremental def">At every point along the 2-d
curve $f(x,y)=k$, the gradient $\myv \grad f$ is a 
<b>normal vector</b> of the curve.


<h3>Using gradients to find extreme points</h3>

<p class="show">Imagine that you are hiking along a path specified by the equation $g(x,y)=k$ through a landscape where the height is specified by $f(x,y)$.  How do you find the highest point of your hike?<br>

<img src="0g/11.8.lm.jpg">
<br>
In mathematical terms:
<ul>
<li>Try to find the <b>extreme values</b> of $f(x,y)$...
<li>Subject to the <b>constraint</b> $g(x,y)=k$.
</ul>

<p>We seek the the extreme values of $f(x,y)$ when the point $(x,y)$ is restricted to lie on the level curve $g(x,y)=k$.
<p>E.g. maximizing $f(x,y)$ means finding the contour $f(x,y)=c$ that $g(x,y)$ touches, where $c$ has the largest possible value.

<p>It looks like this happens  when the desired contour of $f$ is <i>tangent</i> to $g(x,y)=k$.  

<p>[If $g$ is not tangent to a particular contour of $f$, then there exists a point on $g$ which is higher, and one which is lower on either side of their intersection.]

<p>Tangent means that <b>the normal vectors</b> to the 2-d curves $g=k$ and $f=c$ <b>are parallel</b> (one is the scalar multiple of the other).
<p>We know $\myv \grad f$ is always normal to any 2-d contour line of $f$.  Ditto for $\myv \grad g$ along the particular contour line $g=k$.  Therefore...


<p class="show incremental def">
At the location $(x_0,y_0)$ where the two contours are tangent, it will also be the case that the normals are parallel, $\myv \grad f \parallel \myv \grad g$, which means:
$$\myv \grad f(x_0,y_0) = \lambda \myv \grad g(x_0,y_0)$$
where $\lambda$ is some scalar.



<h3>The method of Lagrange multipliers</h3>
<p class="show"><img src="0g/11.8.method.jpg" class="big">

<h3>Kitten, re-re-visited</h3>
<p>$$T(x,y)=x^2-2xy$$
The gradient of this function..
$$\myv\grad T=
T_x\uv i + T_y\uv j= (2x-2y)\uv i -2x\uv j.$$

<p>We're interested in the the highest contour of $T$ along the path $y=x^2$.<br>
<img src="0g/11.8.kittenborderpoint.jpg"><br>
We need to express the path $y=x^2$ in the form of $g(x,y)=k$... How about
$$g(x,y)=x^2-y=0?$$
<p>We can calculate the gradient of this function...
$$\myv\grad g=2x \uv i -1\uv j.$$

<p>The condition that the gradients are parallel,
$$\begineq \myv \grad T &= \lambda \myv \grad g \\
(2x-2y)\uv i -2x\uv j&= \lambda( 2x \uv i -1\uv j) \\
(2x-2y)\uv i -2x\uv j&= \lambda2x \uv i -\lambda\uv j \\
\endeq$$

<p>Two vectors are only equal if, separately, their $x$ components are equal and their $y$ components are equal.

<p><b>The  $x$-component</b> are equal:
$$2x-2y=\lambda 2x$$
and <b>the $y$-components</b> are equal:
$$-2x = -\lambda.$$

<p>Using the two to eliminate the scalar $\lambda$:
$$2x-2y=(2x)2x=4x^2$$
Taking into account our constraint equation, that $y=x^2$, leads to one equation for $x$:
$$\begineq 2x-2(x^2)&=4x^2\\
1-x&=2x
\endeq$$
The solution is $x=1/3$, $\Rightarrow y=1/9$.  Hopefully the same location we found by parametric means?!


<h4><tt>Solve</tt> ing simultaneous equations in Cocalc</h4>
<p><img src="0g/11.z.CoCalc.jpg" class="big"><br>
[or <a href="0g/11.8.solve.jpg">in <i>Mathematica</i></a>
<h3>Two constraints?</h3>
<p class="show">
Suppose that we want to find...
<ul class="else"><li>the maximum or minimum values of a function $f(x,y,z)$,
<li>subject to <b>two</b> constraints: $h(x,y,z)=c$ and $g(x,y,z)=k$.
</ul>
<p><img src="0g/11.8.two.jpg" class="rightalign">
Geometrically, we are looking for the extreme values of $f$ when $(x,y,z)$ lies on the curve of intersection, $C$, of the level surfaces
$h(x,y,z)=c$ and $g(x,y,z)=k$.  Which can be expressed as...
$$\myv\grad f(x_0,y_0,z_0) = \lambda\myv\grad g(x_0,y_0,z_0) + \mu\myv\grad h(x_0,y_0,z_0)$$
where $\lambda$ and $\mu$ are scalars.
<p>This amounts to solving these five equations...
$$f_x=\lambda g_x +\mu h_x$$
$$f_y=\lambda g_y +\mu h_y$$
$$f_z=\lambda g_z +\mu h_z$$
$$g(x,y,z)=k$$
$$h(x,y,z)=c$$
for the five unknown quantities $\lambda$, $\mu$, $x$, $y$, and $z$.

<h3>ToDo</h3>
<ul class="todo incremental"><li>Lagrange Multiplier Problems: *Do* use CoCalc to solve the systems of equations.
<li class="justme answer"><a href="11.8.LMP.pdf">ANSWERS (*.pdf file)</a> to the Lagrange Multipliers Problems.

</ul>

<h4 class="handout">Image credits</h4>
<p class="handout"><a href="http://alicehikes.com/2014/04/ohlone-wilderness-trail-28-mile-point-to-point-hike/">Alice Hikes</a>


<?php include "../../classes/3.h" ?>