<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Iterated integrals [12.2]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Iterated integrals &amp; partial integration
</h1>
<p class="show"><img src="0g/12.1.underneath.jpg"><br>
We saw that the double integral:
$$\iint_R f(x,y)\,dA$$
represents the volume between the rectangle $R\equiv[a,b]\times[c,d]$ (in the $x,y$ plane)  and the surface $z=f(x,y)$ above $R$.
<p class="show">Now we'll see how to <b>evaluate</b> such an integral.

<h2>Partial Integration</h2>
<p class="show">How to evaluate a double integral like
$$\iint_R f(x,y)\,dA=\iint_R f(x,y)\,dx\,dy?$$
<p>We define <b>partial integration</b> of a function $f(x,y)$ with respect to $y$ with this notation:
$$\int_{y=c}^d f(x,y)\,dy=A(x).$$
A(x) is the result of 
<ul><li>Treating $x$ as a constant,
<li>carrying out the integration with respect to $y$.
</ul>

<p><b>example</b>:
$$\begineq\int_0^1 (2-x-y)\,dy&=\int_0^1 (2-x)\,dy-\int_0^1 y\,dy\\
&=(2-x)\int_0^1 dy-\int_0^1 y\,dy\\
&=(2-x)\,\left. y \right|_0^1-\left.\frac12 y^2\right|_0^1\\
&=(2-x)(1-0)-\frac12(1^2-0^2)\\
A(x)&=2-x-\frac12=\frac32-x.
\endeq

$$
<p>We write it as $A(x)$ because it is the <b>area</b> resulting from the partial integration w.r.t. $y$, but typically the result is <i>a function of $x$</i>.  (See picture below for a visual interpretation of $A(x$.)
<h4>Double integral</h4>
<p>The double integral is the result, next, of  carrying out the integration of $A(x)$ with respect to $x$:
$$\begineq
\iint f(x,y) dA&=\int_{x=a}^b A(x)\,dx\\
&=\int_{x=a}^b \left(\int_{y=c}^d f(x,y)\,dy
\right)\,dx\\
&=\int_{x=a}^b \int_{y=c}^d f(x,y)\,dy
\,dx\\
\endeq
$$

<p>This rather sloppy way of writing the double integral leaves it unclear whether you should evaluate the partial integral of $y$ first, and then integrate over $x$, or vice versa. Perhaps it doesn't matter?

<h4>Fubini's Theorem</h4>
<p>...says that for a rectangular region $R$ and some pretty general assumptions, <b>the order of partial integration does not matter</b>.


<h3>Example 1</h3>
<p class="show">Find the volume underneath $f(x,y)=2-x-y$ and above the rectangle defined by points in the $x$-$y$-plane: $0\lt x \lt 1$, and $0\lt y\lt 1$.  (Alternately, $R=[0,1]\times[0,1]$.)<br>
<img src="0g/12.1.int1.jpg"><br>
$$ \begineq V= \iint (2-x-y)\,dA &= \int_{x=0}^1\int_{y=0}^1(2-x-y) dy dx

\\&= \int_{x=0}^1\left(\int_{y=0}^1 (2-x-y)\,dy\right) dx
\endeq$$


<p>We already carried out the partial integral in $(...)$.  Substituting the result back into the expression for $V$,
$$
\begineq V&=\int_{x=0}^1\left(\frac 32 - x\right)\,dx = \frac 32\int_0^1 dx -\int_0^1x\,dx\\
&=\frac32-\frac12=1
\endeq
$$

<h3>Example 2</h3>
<p class="show"><img src="0g/12.1.int2.jpg"><br>
The function for the surface is
$f(x,y)=4-x-y$.
<ul>
<li class="todo">Estimate the volume under this surface, for example, by estimating the <i>average height</i> of the surface, then multiplying by the area of the rectangle $R$ underneath.
<li>Evaluate the double integral to find the exact volume.
</ul>
  
<p>How to do this in CoCalc:<br>
<img src="0g/12.2.doubleCC.jpg"><br>
<p>How to <a href="0g/12.2.how2.jpg">do this in <i>Mathematica</i></a>.


<h3>To Do</h3>

<ul class="todo"><li>
Double integrals -  practice: #1-4
</li>
<li>The shape of the solid
</ul>
<?php include "../../classes/3.h" ?>