<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Gradient Fields [13.1]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Characterizing vector fields
</h1>

<p class="show">*Some* vector fields, $\myv F$, represent the gradient of a function, $\myv F=\myv \grad f$.
<p class="show">In the next few class sessions we'll be trying to figure out:
<ul class='else'>
<li>How to tell if a vector field is the gradient of a function,
<li>How to find the function $f$, given $\myv F$.
<li>How this makes some line integrals *a lot* easier to evaluate.
</ul>



<h3>Gradients</h3>

<p class="show">
The gradient of a scalar field is a vector field.


$$
\myv \grad f(x,y)=f_x(x,y)\uv i+f_y(x,y)\uv j=\myv v(x,y)$$

<p class="show">$$\myv \grad f(x,y,z)=f_x(x,y,z)\uv i+f_y(x,y,z)\uv j+f_z(x,y,z)\uv k=\myv v(x,y,z)$$


<h2>Gradient Fields</h2>

<p class="show">Some (but not all) vector fields are <b>gradient fields</b>.


Consider $f(x,y)=x^2+xy+y^2$.  The gradient is
$$\myv \grad f=\langle f_x,f_y \rangle = (2x+y)\uv i+ (2y+x)\uv j.$$

<p>Graphing the function $f$ below in contour plot.  What can you say about
<ul class="todo"><li>The direction of the vectors in the vector field $\myv v=\myv \grad f$?
<li>Where are the vectors representing $\myv v$ longer or shorter?
</ul>

<img src="0g/13.1.grad.jpg">


<!--
<h3>Velocity fields</h3>
<p class="show">A velocity field could represent fluid flow at points in space.
$$\myv v(x,y)=\langle v_x(x,y), v_y(x,y)\langle.$$
Follow the arrows to see where a small particle place in the flow would go:

<p>You can find the distance travelled:
$\Delta \myv r=\langle r_x,r_y\rangle=\langle\int_{t_0}^tv_x\,dt, \int_{t_0}^tv_y\,dt\rangle 
-->

<div class="justme">
<h3>Grad / Contour example</h3>
<p class="show"><img src="0g/13.1.f49.jpg">



<h3>Grad / Contour example</h3>
<p class="show"><img src="0g/13.1.gradcont2label.jpg">
<p><img src="0g/13.1.gradcont2.jpg">

<h3>Grad / Contour example</h3>
<p class="show"><img src="0g/13.1.cxy.jpg">
</div>

<!--
<h3>In Mathematica</h3>
<p class="show">Plotting contours and gradient vector fields together...
$$f(x,y)=\frac{x^2}{4}+\frac{y^2}{9}$$
Contours for $f=1,2,9$.<br>
<img src="0g/13.1.MticaConGrad.jpg">

<h4> You'll try a couple of these in the lab...</h4>
<ul class="else">
<li>$f(x,y)=xy-2x$
<li>$f(x,y)=\sin(x)+\sin(y)$
<li>$f(x,y)=\sin(x+y)$

</ul>


-->

<h3>In CoCalc</h3>
<p>You'll see how to plot vector fields on top of contour plots in <b>Lab08</b>.

<h3>Conservative fields</h3>
<p class="show">Consider the vector field...
$$\myv F(x,y)=2x\uv i+y\uv j$$

<p>Can you guess a function $f(x,y)$ such that 
$$\myv F(x,y) = \myv \grad f(x,y)?$$

In other words, what function, $f(x,y)$ has partial derivatives $f_x=2x$ and $f_y=y$?


<p>If such a function $f$ exists:
<ul><li>$f(x,y)$  is called a <b>potential function</b> for the vector field $\myv F$.
<li>$\myv F(x,y)$ is a <b>conservative vector field</b>. 
</ul>





<?php include "../../classes/3.h" ?>