<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Landscapes and gradient fields [13.1]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>
<h1>Landscapes, surfaces, and gradient fields</h1>
<img src="0g/13.1.hills.jpg" class="big">
<p>The function, $z=f(x,y)$, can be graphed as a surface.  We can imagine ourselves on such a surface: $z$ corresponds to the altitude of Earth's surface above sea level, and varies as we move East or West (in the $+x$ or $-x$ direction) or North-South ($\pm y$).
<h3>What you already know about the gradient</h3>
<p>For a smoothly varying, continuous surface, $z=f(x,y)$, we can <b>calculate the gradient</b> everywhere, $$\myv F(x,y)=\myv \grad f(x,y)=f_x \uv i+f_y\uv j.$$  
The gradient is a <b>vector function</b> and it has these characteristics:  
<ul><li>At any location $(x,y)$, the gradient always points in the direction to go, if you want to go up as steeply as possible at that point.
<li>The gradient is always perpendicular to contour lines of the surface $f$,
<li>The magnitude of the gradient is the slope of the surface $f$ in that direction of steepest increase.
</ul>

<ul>
<p>The question is... <b>Is every vector field the gradient of some surface?</b> of some <i>continuous</i> surface?  To answer this,  you'll try to imagine the surfaces that correspond to different vector fields.
</ul>
<p>Read the following stories, written as hiking journal entries, with  corresponding diagrams of 2-d vector fields, where we're interpreting those vector fields as gradients of the surface:

<h3>June 14 entry</h3>
<p class="show"><img src="0g/13.grad.path1.jpg" class="leftalign">
Here's what I wrote in my hiking journal about the hike I took on the surface with these gradient vectors (above):

<div class="handout">
<i>
I awoke early on the side of what appeared to be a mighty mountain peak. I left my camp (the big green dot) headed East.  The path, though initially quite steep, gradually flattened out until I found myself at the top, in the middle of a fairly flat meadow, after hiking about 4 miles.
<p>I decided to go back a different way and started hiked south.  At first the path was flat, then a mild down hill, but it kept getting steeper and I descended ever faster.  After I had gone about 4 miles, pretty much all downhill,  my altimeter told me I had reached the altitude of my camp. 
<p>I turned West, and "contoured" at a constant height, clockwise around the peak, until I reached my camp again.
<p>I was famished and had a delicious meal of sardines with crackers and cheese.
</i></div>

<h3>June 18 entry</h3>
<p>Another entry, corresponding to a different diagram of gradient vectors.
<p><img src="0g/13.grad.path2.jpg" class="rightalign">
Here is a different entry from my hiking journal
<div class="handout">
<i>
<p>June 18, 2014 - This being new country to me, I didn't know exactly what to expect.  Being in possession of a GPS unit, I figured I could hike for a while and eventually find my way back to camp.  So, marking the location of my camp, I left camp in a southerly direction, going uphill at first, so as to have an easier time of it later in the day on the way back to camp.
<p>Just a few steps away from my campsite, behind a grove of trees, I found another tent!  I met "Ted" who was just getting up, and looked like he was preparing a big breakfast.  His plan was to hike North.  I waved goodbye and continued on my way.

<p>I went uphill at a steady climb.

I kept turning left, little by little (at first towards the East) to keep going  up hill at a steady pace.  If I had gone straight, I would have found myself going uphill *very* steeply.  I continued to climb steadily. 
<p>After about 2 hours, I was surprised to see Ted bounding downhill towards me through the woods.  He was moving so fast, that we barely had to time to wave at each other before he was gone.

<p>By lunchtime, my GPS told me that I had followed an arc, and was about half-way around a roughly circular path that would eventually take me back to camp.  
<p>After lunch, I climbed steadily once more, always as nearly uphill as I could.  The flora and fauna were new to me, and looked like something that I vaguely recalled from a painting.  I continued for several more hours uphill, until I finally stumbled into camp, after sunset, exhausted.  I never did get to go downhill all day!  

<p>I heard loud snoring from Ted's tent.  I ate a supper of dried ramen noodles without bothering to cook them and fell into a deep sleep.  
</i></div>


<h3>Respond to these questions</h3>
<p>...on Moodle.
<ol class="todo">
<li>Do both of both of these stories tell equally plausible tales about a hike, or not?  Which one is more (or which one is less) plausible?

<li>Based on the diagrams and accounts... did either hiker go over a sharp ridge or cliff, or encounter some other discontinuity in the landscape?

<li>When the hiker ended up back at camp (at least, at the same latitude and longitude, according to his GPS) was he at the same altitude as when he started?  Answer this for both hikes.


<li>What do you conclude about the question of whether all vector fields represent gradient fields of a real surface?

<li>Questions or things you wondered about?
</ol>


<p class="justme result">Here is a real surface which allows you to walk in a circle and always go downhill:<br>
<img src="0g/13.spiral.jpg"><br>
<br>The part that we're walking on is continuous
<br>Such a surface can be continuous, however...you cannot return to the same altitude, and the surface does not represet a <i>function</i>.
<p class="handout"><b>Photo credits: <a href="https://www.flickr.com/photos/jganderson/3391620394">Joshua Ganderson</a>



<?php include "../../classes/3.h" ?>