<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Landscapes and 'swirliness' [13.1]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>
<h1>Clairaut's theorem and 'swirliness'</h1>
<h3></h3>
<p class="show">Characteristics of the gradient, $\myv v = \myv \grad f$, in relation to the underlying surface $f(x,y)$:
<ul><li>The gradient always points in the direction of steepest upwards slope,
<li>The gradient is always perpendicular to contour lines of the surface $f$,
<li>The magnitude of the gradient is the slope of the surface in that direction of steepest increase.
</ul>
<p>Try to decide, for the following tales/diagrams of $myv v$, whether there is a continuous surface for which this is possible...or not.

<p class="show"><img src="0g/13.grad.path1.jpg" class="leftalign">
Here's what I wrote in my hiking journal:

<div class="handout">
<i>
<p>June 16, 2014 - 
I awoke early on the side of what appeared to be a mighty mountain peak. I left my camp headed East.  The path, though initially quite steep, gradually flattened out until I found myself on the peak, after hiking about 4 miles.
<p>I decided to go back a different way and hiked south.  At first the path was a mild down hill, but it kept getting steeper.  After I had gone downhill for about 4 miles,  my altimeter told me I had reached the altitude of my camp. 
<p>I turned West, and "contoured" at a constant height, clockwise around the peak, until I reached my camp again.
</i></div>


<p><img src="0g/13.grad.path2.jpg" class="rightalign">
Here is a different entry from my hiking journal
<div class="handout">
<i>
<p>June 18, 2014 - This being new country to me, I didn't know exactly what to expect.  Being in possession of a GPS unit, I figured I could hike for a while and eventually find my way back to camp.  So, marking the location of my camp, I left camp in a southerly direction, going uphill at first, so as to have an easier time of it later in the day on the way back to camp.
<p>Just a few steps away from my campsite, behind a grove of trees, I found another tent!  I met "Ted" who was just getting up, and looked like he was preparing a big breakfast.  His plan was to hike North, so I continued on my way.

<p>I went uphill at a steady climb.

I kept turning (at first towards the East) to keep going as directly up hill as possible.  I continued to climb steadily. After about 2 hours, I was surprised to see Ted bounding downhill towards me through the woods.  He was moving so fast, that we barely had to time to wave at each other before he was gone.

<p>By lunchtime, my GPS told me that I had followed an arc, and was about half-way around a roughly circular path that would eventually take me back to camp.  
<p>After lunch, I climbed steadily once more, always as nearly uphill as I could.  The flora and fauna were new to me, and looked like something that I vaguely recalled from a painting.  I continued for several more hours uphill, until I finally stumbled into camp, after sunset, exhausted.  I never did get to go downhill all day!  I heard loud snoring from Ted's tent.  I ate a supper of dried ramen noodles without bothering to cook them and fell into a deep sleep.  Gee, I wish I had payed more attention to Clairaut's theorem!
</i></div>

<p>Do both of both of these stories tell equally plausible tales about a hike, or not?

<p>Here is a painting of something like the second landscape.<br>
<img src="0g/1.2.ascendingdescending.jpg">
!!

<h3>Gee, what about Clairaut?!</h3>
<p>According to Clairaut's theorem, if $f(x)$ is a smoothly varying, continuous surface, then the order of differentiation of $f$ doesn't matter.  That is for any $(x,y)$ in the domain of the function, we should find that:

$$\frac{\del}{\del y}\frac{\del f}{\del x}=\frac{\del}{\del x}\frac{\del f}{\del y}$$

Now, if we calculate the <b>gradient</b> of this function, we'll get:
$$\myv v=\myv \grad f=f_x\uv i+f_y\uv j=P(x,y)\uv i+Q(x,y)\uv j$$
where $P$ and $Q$ are just the $x$ and $y$ components of our vector field.

<p>So *if* this $\myv v$ is actually the gradient of a continuous surface we'll have
$$\begineq \frac{\del}{\del y}\frac{\del f}{\del x}
     &=\frac{\del}{\del x}\frac{\del f}{\del y}\\
\frac{\del}{\del y}P
     &=\frac{\del}{\del x}Q\\
\endeq$$
<p>Let's examine those plots a little more carefully to see if we can tell this by eye:<br>
<img src="0g/13.grad.just1.jpg"><img src="0g/13.grad.just2.jpg"><br>
We're trying to estimate if these are the same:
$$\frac{\del}{\del y}P
     \stackrel{?}{=}\frac{\del}{\del x}Q\\$$
<ol><li>Draw a cross at some point in the vector plot.
<li>Move in the positive $x$ direction.  Is the overall change in the $y$-component of the vector field positive or negative?
<li>Move in the positive $y$ direction.  Is the overall change in the $x$-component of the vector field positive or negative?
</ol>

<p>If we think of those vectors as water flow, it looks like we could say that:
<ul><li>If $\frac{\del}{\del x}Q > 0$ then the "water" is trying to twist that horizontal bar in the counterclockwise direction.
<li>If $\frac{\del}{\del y}P > 0$ then the "water" is trying to twist that vertical bar in the clockwise direction.
<li>Only when the two torques "balance" each other (or are both zero) does the vector field obey Clairaut's criterium.
</ul>

<p><img src="0g/1.2.paddle.gif">So, the quick way to estimate this is to imagine the vector field as water flow, and place a <i>paddle wheel</i> (axis in the $z$ direction), and decide...or are the torques on either side imbalance? The the paddle wheel turns one way or another (no surface!).  Or do the torques balance each other out?  In which case the paddle wheel does *not* turn
 (and we have the gradient of a surface!).

<p>Can you *guess* what the equation of the surface is for the possible field??



<?php include "../../classes/3.h" ?>