<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Vectors [9.2]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>


<h1>Vectors [9.2]</h1>
<img src="0g/9.2.kayak.jpg"  class="big">
<p class="show">Many physical quantities--displacement, velocity, force to name a few--have both a magnitude and a <b>direction</b>.
<h3>Vectors</h3>
<ul>
<li><img src="0g/9.2.vectors.jpg" class="rightalign">A <b>vector</b> is a quantity that has both a magnitude and a direction.
<li>A vector is visually represented by an arrow or a directed line segment.
<ul>
<li>The <b>length</b> of the arrow represents the <b>magnitude</b> of the vector and
<li>the arrow <b>points</b> in the <b>direction</b> of the vector.
</ul>
</ul>

<h4>Some motivating questions...</h4>

<p>How could you verify that two vectors are <b>parallel</b> to each other?<br>
<img src="0g/9.2.parallel.jpg">


<p>How could you describe $\myv c$ in terms of $\myv a$ and $\myv b$?<br>
<img src="0g/9.2.triangle.jpg">


<h3>Adding vectors</h3>
<p class="show"><img src="0g/9.2.vectoraddition.jpg">
<ol>
<li>If $\myv u$ and $\myv v$ are vectors,
<li>positioned such that the initial point of $\myv v$ is at the terminal point of $\myv u$,
<li>then the <b>sum</b> $\myv u + \myv v$ is the vector from the initial point of $\myv u$ to the terminal point of $\myv v$.
</ol>

<h3>Scalar</h3>

<p class="show">A <b>scalar number</b> is, for our purposes, usually the same as a <b>real number</b>.

<p>A scalar number can be used to represent a quantity that does *not* have a direction.<br><br>
For example:  time, $t$; temperature, $T$; the probability that a fish in the ocean is a shark, $p_{\text shark}$.

<h4 >Notation</h4>
<p>Scalar quantities are typeset in italics:
$$\nonumber t, T, p_{\text shark}$$
<p>Vector quantities are typeset either in bold:
\left[\nonumber
\bf u, \bf v, \bf g
\]
or with an arrow on the top:
\left[\nonumber
 \myv u, \myv v, \myv g
\]

<p>What to do when writing by hand?

<p>The difference between speed and velocity...


<h3>Scalar multiplication</h3>
<p class="show"><img src="0g/9.2.scalarmult.jpg">
<p class="show">If $c$ is a scalar, and $\myv v$ is a vector, then the <b>scalar multiple</b> $c\myv v$ is the vector with:
<ul>
<li> a length of $|c|$ times the length of $\myv v$, and
<li> a direction which is:
  <ul>
  <li>the <b>same</b> as $\myv v$ if $c \gt 0$, or
  <li><b>opposite</b> $\myv v$ if $c \lt 0$, or
  <li><b>zero</b> if either $c=0$ or $\myv v$ is a zero length vector.
  </ul>
</ul>



<h3>Vector subtraction</h3>
<p class="show">The idea is...
\left[\nonumber
\myv u - \myv v \equiv \myv u + (-1)\myv v
\]
<p class="show"><img src="0g/9.2.vectorminus.jpg">

<p class="justme">How would you describe $\myv v - \myv u$?

<h3></h3>

<p class="show"><img src="0g/9.2.ab.jpg">
<p class="show">Sketch $\myv a - 2\myv b$
<p ><img src="0g/9.2.a-2b.jpg">

<h3>Components</h3>
<p class="show">All of these vectors have the same <b>components</b>: $\langle 3,2\rangle$.
<p class="show"><img src="0g/9.2.vector32.jpg">

<p>Vector components in 2-d:
$$\myv a = \langle a_1,a_2\rangle \nonumber$$
<p>Vector components in 3-d:
$$\myv a = \langle a_1,a_2,a_3\rangle \nonumber$$

<h3>Length</h3>
<p class="show">...of a vector in terms of its components.
<p class="show">Length $|\myv a|$ (a scalar number) of the 2-d vector $\myv a=\langle a_1,a_2 \rangle$:
$$|\myv a|=\sqrt{a_1^2+a_2^2}.$$

<p class="show">Length  of the 3-d vector $\myv a=\langle a_1,a_2,a_3 \rangle$:
$$|\myv a|=\sqrt{a_1^2+a_2^2+a_3^2}.$$



<h3>Using components</h3>
<p class="show">For the vector $\myv a=\langle a_1,a_2\rangle$:
<ul>
<li>$a_1$ is the $x$-component of the vector $\myv a$, 
<li>$a_2$ is the  $y$-component.
</ul>



<h4>
<img src="0g/9.2.vectorcomponents.jpg" class="rightalign">  Scalar multiplication </h4>
<p>
$$c\myv a = \langle ca_1,ca_2 \rangle.$$

<h4>Vector addition (and subtraction)</h4>
<p><img src="0g/9.2.addem.jpg"><br>
$$ \myv a + \myv b = \langle a_1+b_1, a_2+b_2 \rangle $$
<p>Subtraction:
$$ \myv a - \myv b = \langle a_1-b_1, a_2-b_2 \rangle $$
<p>All these results generalize to 3-d.

<h3>To Do</h3>
<ul><li>Lines in the Plane</li>
</ul>

<h3>More properties</h3>
<p class="show"><img src="0g/9.2.properties.jpg" class="big">

<h3>Standard basis vectors</h3>
<p class="show">The 3 standard basis vectors are:
$$\myv i \equiv \langle 1,0,0 \rangle; \ \ 
\myv j \equiv \langle 0,1,0 \rangle; \ \ 
\myv k \equiv \langle 0,0,1 \rangle$$
<p class="show"><img src="0g/9.2.basis.jpg">

<p>Notice that each of these vectors has a <b>length of 1</b>. That
is, they are <b>unit vectors</b>.

<p>Another convention (that I prefer to use) is to indicate unit
vectors with the caret symbol up top (instead of an arrow):

$$\uv i \equiv \langle 1,0,0 \rangle \equiv \uv x; \ \ 
\uv j \equiv \langle 0,1,0 \rangle \equiv \uv y; \ \ 
\uv k \equiv \langle 0,0,1 \rangle\equiv \uv z$$


<h3>To do</h3>
<ul><li>Component Vectors
<!--<li>Where do they point? Group Work 3-->
</ul>







<h4>Image credits</h4>
<p class="handout">
<a href="http://www.flickr.com/photos/question_everything/2874730255/in/photolist-5o2K9K-34fgaA-43fwd6-2gvoSs-8UN7KW-6GAby4-5csdcw-akXFZP-94xiiR-6MMZ2Q-kHViR-fCYuND-f8TQh9-bcghk6-9HLBWi-9k2uhq-8dNA4V-7xFup7-eZ7oY-9FHGhL-9bujkh-6C2dRy-6wXBFA-hSzuA-2bjUcV-cuiUiL-9BMK99-9AW63a-7i1Wd9-6v77Hk-kuxDd-bz9HS5-3bHURp-eXC7UV-9dodrj-6vSucr-DMWnQ-e64zg2-bE3qCK-7WPASq-5FWmPD-5EGt56-5xgANi-eRpvnm-2gYNdJ-fe3WvH-fnk4q2-a2BJa8-9tkpYp-4jxrX4-5jRaUU/">Flickr user 'Let ideas compete'</a>
<?php include "../../classes/3.h" ?>