<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Dot product [9.3]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>Dot product [9.3]</h1>
<p class="show"><img src="0g/9.3.dots.jpg">
<p class="show"><b>No, no</b>, not that kind of dot product...
<h3></h3>
<p class="show">There are two ways to form a <b>product of vectors</b>:
<ul>
<li>The "dot product" of two vectors, $\myv a \cdot \myv b$ is a <i>scalar</i>.
<li>The "cross product" of two vectors, $\myv a \times \myv b$ is a <i>vector</i>.
</ul>

<h3>How much energy?</h3>
<p class="show"><img src="0g/9.3.worker.jpg" class="big">
<p class="show">"Work" in physics is the energy expended when a constant force $\myv F$ acts to displace an object by a distance $\myv d$.

<p>Using the convention that $d\equiv |\myv d|$, $F\equiv |\myv F|$, etc...
<p><img src="0g/9.3.work.jpg"><br>
Work is the product of the displacement and the component of the force along the direction of the displacement.
$$\nonumber \text{Work}=F_d d = (F \cos \theta) d$$
<p>We shall see shortly that this can be written as
$$\text{Work}=\myv F \cdot \myv d.$$
[Units: Newton-meter = Joule]

<h3>The dot product</h3>
<p class="show">...of two non-zero vectors $\myv a$ and $\myv b$ is defined as
$$\myv a \cdot \myv b \equiv |\myv a| |\myv b| \cos \theta$$
where $\theta$ is the smallest possible angle between the vectors when they're drawn with the same initial point.  That is, $0 \leq \theta \leq \pi$.


<p class="center">
<img src="0g/9.3.thetasigns.jpg">

<p>Two vectors are <b>orthogonal</b> (which is a general way of saying "perpendicular") if and only if their dot product is zero.
$$\myv a \cdot \myv b=0 \ \ \Leftrightarrow \ \ \myv a \perp \myv b.$$

<h3>Component form</h3>
<p class="show">The dot product of $\myv a=\langle a_1,a_2,a_3\rangle$ and
$\myv b=\langle b_1,b_2,b_3\rangle$ can be written in terms of their components:
$$\myv a \cdot \myv b = a_1b_1+a_2b_2+a_3b_3.$$

Examples:
<p>
$$\nonumber 
  \langle 2,4 \rangle \cdot \langle 3,-1\rangle = 2(3)+4(-1)=2$$
<p>
$$\nonumber 
  \langle -1, 7, 4\rangle \cdot \langle 6,2,\frac 12\rangle =
-1(6)+7(2)+4(\frac 12)=10$$
<p>
$$\nonumber (\myv i + 2\myv j -3\myv k)\cdot(2\myv j -\myv k)=1(0)+2(2)-3(-1)=7$$
<p class="justme">Could also multiply out the product in that last one, and show how orthogonality is used.


<h3>Properties of the dot product</h3>
<p class="show"><img src="0g/9.3.properties.jpg" class="big">

<h3>To Do</h3>
<ul>
<li>Triangles: The Right Stuff
</ul>

<h3>Component</h3>
<p class="show"><img src="0g/9.3.component.jpg">
<p class="show">The <b>component</b> of $\myv b$ along $\myv a$ is a scalar:
$$\text{comp}_{\myv a}\myv b = b \cos \theta = \frac{|\myv a|}{|\myv a|}
 |\myv b| \cos \theta = \frac{\myv a \cdot \myv b}{|\myv a|}.$$
...also called the <i>scalar projection</i>.

<h3>Projection</h3>
<p class="show"><img src="0g/9.3.projection.jpg">
<p class="show">The <b>vector projection</b> of $\myv b$ along  $\myv a$ is a <b>vector</b> which points along $\myv a$ and has a length of $b\cos\theta=\text{comp}_{\myv a}\myv b$.

<p>We can construct a vector, $\uv{a}$ of unit length pointing in the $\myv a$ direction like this:
$$\uv{a}=\frac{\myv a}{|\myv a|}$$
[I will frequently write $\uv i, \uv j, \uv k$ for the rectangular coordinate unit vectors.]


<p>The vector projection is:
$$\text{proj}_{\myv a}\myv b = b\cos\theta \uv a = \frac{\myv a \cdot \myv b}{|\myv a|^2}\myv a.$$

<h3>To do</h3>
<ul>
<li>Play around with the <a href="http://www.goshen.edu/physix/213/handouts/Class02/DotProduct.nb">Dot product demo</a> [Right-click and download this <i>Mathematica</i> notebook.]
<li>The Regular Hexagon
</ul>





<h4 class="handout">Image credits</h4>
<p class="handout"><a 
href="http://www.flickr.com/photos/johnragai/8584968505/">John Ragai</a>,
<a href="https://www.flickr.com/photos/wallyg/3977179310">Wally Gobetz</a>
<?php include "../../classes/3.h" ?>