<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Functions and surfaces [9.6]
</title>
<meta name="week" content="">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h2>Functions and surfaces [9.6]</h2>
<p class="show center"><img src="0g/9.6.reichskuppel.jpg"><br>
<i>Dome atop the German Reichstag in Berlin</i>

<h3>Examples</h3>
<ul>
  <li>Surface temperature, $T(x,y)$, varies with latitude ($y$) and longitude ($x$).
  <li>Height, $h(x,y)$, above sea level on Earth's surface varies with latitude and longitude.
</ul>

<h3>$f(x,y)$</h3>

<p class="show">A <b>function $f$ of two variables</b> is a
<b>rule</b> that assigns to each ordered pair of real numbers $(x,y)$
in a set $D$ a <i>unique</i> real number denoted by $f(x,y)$.

<ul>
  <li>The set $D$ is the <b>domain</b> of the function $f$.
  <li>The <b>range</b> of $f$ is the set of values that $f$ takes on, that is, the set:  $\{f(x,y)|(x,y)\in D\}$.
</ul>
<p>Often we write such a relation in terms of a dependent variable $z=f(x,y)$ which is a function of the two independent variables $x$ and $y$.

<h3>Tabular form</h3>

<p class="show">$h(v,t)$: A table of <span style="color: #0ce;">wave
height, <i>h</i></span> (in feet)  which depends, in the open ocean, on the speed, $v$, (in knots) of the wind and how long, $t$, (in hours) it's been blowing.<br>
<img src="0g/9.6.waveheight.jpg"><br>
[October, 2013 -- <a href="http://www.theguardian.com/world/2013/oct/12/indians-flee-coast-cyclone-phailin-landfall">Cyclone Phailin hits east India</a>]

<h3>Graph</h3>
<p class="show"><img src="0g/9.6.graphoff.jpg"><br>
If $f$ is a function of two variables with domain $D$, then the <b>graph</b> of $f$ is the set of all points $(x,y,z)$ in $\mathbb{R}^3$ such that $z=f(x,y)$ and $(x,y)$ is in $D$.

<h3>Examples</h3>
<p class="show"><img src="0g/9.6.ex4.jpg" class="rightalign">
$$\nonumber z=f(x,y)=6-3x-2y$$
[Verify the intersections with the $x-$, $y-$, and $z-$axes.]

<h3>&nbsp;</h3>
<p class="show center"><img src="0g/9.6.x2.jpg" class="rightalign">
<p class="show">
$$\nonumber z=f(x,y)=x^2$$

<h3>Traces</h3>
<p class="show"><img src="0g/9.6.saddle.jpg" class="rightalign">
<p class="show">
$$\nonumber z=f(x,y)=x^2+y^2$$
<p>It is helpful to visualize surfaces by considering intersections of the surface with various planes:<br>
<img src="0g/9.6.traces1.jpg">
<p><img src="0g/9.6.traces2.jpg">
<ul>
  <li><b>Vertical traces</b> are intersections with a plane like $x=k$ or $y=k$.
  <li><b>Horizontal traces</b> are intersections with a plane like $z=k$.
</ul>


<h3>To do</h3>
<ul>
<li>Staying Cool
</ul>
<h3>Quadric surfaces</h3>
<p class="show"><img src="0g/9.6.quadric1.jpg">

<h3>&nbsp;</h3>
<p class="show"><img src="0g/9.6.quadric2.jpg">

<h3>To do</h3>
<ul>
<li>Matching Game - general functions
<li>Matching Game - quadric functions
</ul>

<h4 class="handout">Image credits</h4>
<p class="handout"><a href="http://www.flickr.com/photos/29487767@N02/2904087529">Daniela
Hartmann</a>
<?php include "../_i/3.h"; ?>