(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     14543,        465]
NotebookOptionsPosition[     12968,        414]
NotebookOutlinePosition[     13454,        433]
CellTagsIndexPosition[     13411,        430]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["9.1 Vectors in the Plane", "Section",
 CellChangeTimes->{{3.544177973642514*^9, 3.5441779790258217`*^9}, 
   3.5763508212679863`*^9}],

Cell[CellGroupData[{

Cell["Vectors in the Plane", "Subsection",
 CellChangeTimes->{{3.544198386547574*^9, 3.544198389714862*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "=", 
    RowBox[{"(", 
     RowBox[{"1", ",", "3"}], ")"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", "=", 
    RowBox[{"(", 
     RowBox[{"2", ",", "1"}], ")"}]}], TraditionalForm]]],
 " be points in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "2"], TraditionalForm]]],
 ". \[LineSeparator]",
 Cell[BoxData[
  GraphicsBox[PointBox[{0, 0}],
   Axes->True,
   GridLines->{{-4, -3, -2, -1, 0, 1, 2, 3, 4}, {-4, -3, -2, -1, 0, 1, 2, 3, 
    4}},
   ImageSize->{216.79999999999688`, Automatic},
   PlotRange->{{-4, 4}, {-4, 4}}]],
  CellChangeTimes->{{3.5441978892388363`*^9, 3.544197939945011*^9}, 
    3.544197973490328*^9}],
 " "
}], "ItemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
  3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
  3.544178473060079*^9}, {3.5441796907817287`*^9, 3.5441796907957296`*^9}, {
  3.544198005942904*^9, 3.5441980066294007`*^9}, {3.5441981499054036`*^9, 
  3.54419815137201*^9}, {3.544198306225419*^9, 3.5441983067402983`*^9}}],

Cell[CellGroupData[{

Cell["Graph these points.  ", "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
  3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
  3.544178473060079*^9}, {3.5441796907817287`*^9, 3.544179711743928*^9}}],

Cell[TextData[{
 "Graph the vector ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["PQ",
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]]],
 ".  What are the components?  "
}], "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
  3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
  3.544178473060079*^9}, {3.5441796907817287`*^9, 3.544179722060518*^9}}],

Cell["Graph the equivalent vector with base at the origin.  ", \
"SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
  3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
  3.544178473060079*^9}, {3.5441796907817287`*^9, 3.5441797255637183`*^9}}],

Cell["\<\
Graph an equivalent vector that does not have its base at the origin.  \
\>", "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
  3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
  3.544178473060079*^9}, {3.5441796907817287`*^9, 3.544179729634951*^9}}],

Cell["Graph a parallel vector that is not equivalent.  ", "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
  3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
  3.544178473060079*^9}, {3.5441796907817287`*^9, 3.5441797407315855`*^9}}],

Cell[TextData[{
 "Determine the length of the vector ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["PQ",
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]]],
 ".  Explain why this is the length.  "
}], "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
  3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
  3.544178473060079*^9}, {3.5441796907817287`*^9, 3.5441797709413137`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "2"}], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "-", "1"}], ")"}], "2"]}]], "=", 
    RowBox[{
     SqrtBox["5"], "=", "2.23607"}]}], TraditionalForm]],
  CellChangeTimes->{{3.5441832381375933`*^9, 3.544183291532791*^9}}]
}], "Text",
 CellChangeTimes->{{3.5441837084176893`*^9, 3.5441837502862105`*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "Draw the line that passes through the points ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]]],
 ".  "
}], "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
  3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
  3.544178473060079*^9}, {3.5441796907817287`*^9, 3.544179776863652*^9}}],

Cell["Find a standard equation describing the line.  ", "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
  3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
  3.544178473060079*^9}, {3.5441796907817287`*^9, 3.544179780011832*^9}, {
  3.544183523926747*^9, 3.5441835239423447`*^9}}]
}, Open  ]],

Cell[TextData[{
 "\tBecause it is a line, the equation must be of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", 
     RowBox[{"b", " ", "y"}]}], "=", "c"}], TraditionalForm]]],
 ".  \[LineSeparator]\tPlug in the coordinates of the two points and solve:  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "+", 
     RowBox[{"2", "y"}]}], "=", "7"}], TraditionalForm]]],
 ".\n\tIn set notation: ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", ",", "y"}], ")"}], ":", 
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}]}]}], "=", "7"}], "}"}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.5441833553594427`*^9, 3.544183356684941*^9}, {
  3.544183397215396*^9, 3.544183479191683*^9}, {3.5441835711828856`*^9, 
  3.5441836547569695`*^9}, {3.5441838612460318`*^9, 3.544183875004614*^9}, {
  3.5441972072838783`*^9, 3.544197338030505*^9}}],

Cell["Find a parametric equation describing the line.", "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
  3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
  3.544178473060079*^9}, {3.5441796907817287`*^9, 3.5441797800048323`*^9}, {
  3.544197352474716*^9, 3.544197352474716*^9}}],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", ",", "3"}], ")"}], "+", 
     RowBox[{"t", "(", 
      RowBox[{"1", ",", 
       RowBox[{"-", "2"}]}], ")"}]}]}], TraditionalForm]]],
 "\n\t",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", ",", "3"}], ")"}], "+", 
      RowBox[{"t", "(", 
       RowBox[{"1", ",", 
        RowBox[{"-", "2"}]}], ")"}]}], ":", 
     RowBox[{
      RowBox[{"-", "\[Infinity]"}], "<", "t", "<", "\[Infinity]"}]}], "}"}], 
   TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.5441838009537373`*^9, 3.5441838302492228`*^9}, {
  3.5441838783584633`*^9, 3.54418393660625*^9}}],

Cell[TextData[{
 "Find a symbolic representation of the line segment between ",
 "the points ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]]],
 "."
}], "SubitemNumbered",
 CellChangeTimes->{{3.5441973559219847`*^9, 3.544197377902919*^9}}],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", ",", "3"}], ")"}], "+", 
       RowBox[{"t", "(", 
        RowBox[{"1", ",", 
         RowBox[{"-", "2"}]}], ")"}]}], ":", 
      RowBox[{"0", "\[LessEqual]", "t", "\[LessEqual]", "1"}]}], "}"}], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", ",", "y"}], ")"}], ":", 
       RowBox[{"x", "+", 
        RowBox[{"2", "y"}]}]}], "=", 
      RowBox[{
       RowBox[{"7", " ", "and", " ", "1"}], "\[LessEqual]", "x", 
       "\[LessEqual]", "2"}]}], "}"}]}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.544197400196748*^9, 3.5441974957684736`*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "Consider the graphed vectors.",
 "\n",
 Cell[BoxData[
  GraphicsBox[{ArrowBox[{{0, 0}, {4, 2}}], ArrowBox[{{0, 0}, {-1, 3}}], 
    InsetBox["P", {4, 2}, {-1, -1}], InsetBox["Q", {-1, 3}, {1, -1}], 
    InsetBox["O", {0, 0}, {1, 1}]},
   Axes->True,
   GridLines->{{-2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, {0, 1, 2, 
     3, 4, 5, 6, 7, 8}},
   PlotRange->{{-2, 12}, {0, 8}}]],
  CellChangeTimes->{
   3.544178729232731*^9, {3.544178761747591*^9, 3.544178782856798*^9}, 
    3.544178949901353*^9, 3.544179025796694*^9, 3.544179064110885*^9, 
    3.54417910353514*^9, 3.54417922067484*^9}]
}], "ItemNumbered",
 CellChangeTimes->{{3.544178812108472*^9, 3.544178871686879*^9}, {
   3.5441791529139643`*^9, 3.5441791569321947`*^9}, {3.544179241242017*^9, 
   3.5441793591367598`*^9}, {3.5441795351598277`*^9, 3.544179597560397*^9}, {
   3.544179819171072*^9, 3.544179830801738*^9}, 3.544179898590615*^9, {
   3.5441843657415423`*^9, 3.544184369079921*^9}}],

Cell[TextData[{
 "Find the components ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]],
  FontWeight->"Bold"],
 " of the vectors ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["OP", "\[RightVector]"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["OQ", "\[RightVector]"], TraditionalForm]]],
 ".  "
}], "SubitemNumbered",
 CellChangeTimes->{{3.544178812108472*^9, 3.544178871686879*^9}, {
  3.5441791529139643`*^9, 3.5441791569321947`*^9}, {3.544179241242017*^9, 
  3.5441793591367598`*^9}, {3.5441795351598277`*^9, 3.544179597560397*^9}, {
  3.544179819171072*^9, 3.5441798661197577`*^9}}]
}, Open  ]],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["u",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"4", ",", "2"}], "\[RightAngleBracket]"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["v",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "3"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.544184013184366*^9, 3.5441840760671606`*^9}}],

Cell[TextData[{
 "Determine ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", 
    StyleBox["u",
     FontWeight->"Bold"]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["u",
     FontWeight->"Bold"], "+", 
    StyleBox["v",
     FontWeight->"Bold"]}], TraditionalForm]]],
 " numerically and graphically.  "
}], "SubitemNumbered",
 CellChangeTimes->{{3.544178812108472*^9, 3.544178871686879*^9}, {
  3.5441791529139643`*^9, 3.5441791569321947`*^9}, {3.544179241242017*^9, 
  3.5441793591367598`*^9}, {3.5441795351598277`*^9, 3.544179597560397*^9}, {
  3.544179819171072*^9, 3.5441798709980364`*^9}}],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"3", 
     StyleBox["u",
      FontWeight->"Bold"]}], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"12", ",", "6"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["u",
      FontWeight->"Bold"], "+", 
     StyleBox["v",
      FontWeight->"Bold"]}], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"3", ",", "5"}], "\[RightAngleBracket]"}]}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.5441840857390366`*^9, 3.5441841369534087`*^9}}],

Cell[TextData[{
 "Write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["w",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"2", ",", "8"}], "\[RightAngleBracket]"}]}], TraditionalForm]]],
 " as a linear combination of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]],
  FontWeight->"Bold"],
 "."
}], "SubitemNumbered",
 CellChangeTimes->{{3.544178812108472*^9, 3.544178871686879*^9}, {
  3.5441791529139643`*^9, 3.5441791569321947`*^9}, {3.544179241242017*^9, 
  3.5441793591367598`*^9}, {3.5441795351598277`*^9, 3.544179597560397*^9}, {
  3.544179819171072*^9, 3.5441798709650345`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 867},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 139, 2, 80, "Section"],
Cell[CellGroupData[{
Cell[743, 28, 108, 1, 44, "Subsection"],
Cell[CellGroupData[{
Cell[876, 33, 1149, 33, 252, "ItemNumbered"],
Cell[CellGroupData[{
Cell[2050, 70, 268, 3, 24, "SubitemNumbered"],
Cell[2321, 75, 442, 11, 27, "SubitemNumbered"],
Cell[2766, 88, 305, 4, 24, "SubitemNumbered"],
Cell[3074, 94, 326, 5, 24, "SubitemNumbered"],
Cell[3403, 101, 298, 3, 24, "SubitemNumbered"],
Cell[3704, 106, 469, 11, 27, "SubitemNumbered"]
}, Open  ]]
}, Open  ]],
Cell[4200, 121, 502, 17, 40, "Text"],
Cell[CellGroupData[{
Cell[4727, 142, 425, 11, 25, "SubitemNumbered"],
Cell[5155, 155, 345, 4, 24, "SubitemNumbered"]
}, Open  ]],
Cell[5515, 162, 965, 28, 74, "Text"],
Cell[6483, 192, 345, 4, 24, "SubitemNumbered"],
Cell[6831, 198, 792, 29, 52, "Text"],
Cell[7626, 229, 301, 10, 25, "SubitemNumbered"],
Cell[7930, 241, 750, 25, 32, "Text"],
Cell[CellGroupData[{
Cell[8705, 270, 980, 20, 248, "ItemNumbered"],
Cell[9688, 292, 716, 23, 28, "SubitemNumbered"]
}, Open  ]],
Cell[10419, 318, 541, 20, 31, "Text"],
Cell[10963, 340, 630, 20, 25, "SubitemNumbered"],
Cell[11596, 362, 613, 23, 31, "Text"],
Cell[12212, 387, 728, 23, 25, "SubitemNumbered"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
