<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Homework / Assignments
</title>
<style type='text/css'>
<!--
.thisWeek h3, .thisWeek p, .thisWeek ol li, .thisWeek ul li
 {
  color: #773;
  font-size: 140%;
  line-height: 140%;
}
-->
</style>
<?php include "../../classes/2.h" ?>
<h2>Homework / Assignments</h2>
<p>You will always write up the homework problems yourself. But please do work
  together with others in the class on the assignments. </p>
<p>You can "hand in" <i>Mathematica</i> or other computer files by putting the file in your personal folder under our CLASSES folder (gcfile:\Classes\PHYS313).</p>
<p>Here are my notes on <a href="http://www.goshen.edu/physix/mathphys/gco/Mathematica.php">getting started with <i>Mathematica</i></a>.

<br><br>


<p>Homework <a href='#hw1'>#1</a> | <a href='#hw2'>#2</a>
|
<a href='#hw3'>#3</a>
 | <a href='#hw4'>#4</a>
 | <a href='#hw5'>#5</a>
 | <a href='#hw6'>#6</a>
 | <a href='#hw7'>#7</a>
 | <a href='#hw8'>#8</a>
 | <a href='#hw9'>#9</a>
 | <a href='#hw10'>#10</a>

</p> 

<h3 id="hw1">Assignment #1 - due Fri, 18 Jan</h3>
<p><b>Reimer</b><br>
QM foundations writeup - See moodle, <br>
<br>What is the ionization energy of singly ionized helium according to the Bohr model?<br><br>
<p><b>Griffiths</b><br>
Chapter 1: problems 1.1, 4, 5</p>

<p><b>Mathematica</b> - [only for those of you who did <b>not</b> take Thermodynamics last semester]<br>
Do the first two topics on <i>Getting started</i> and <i>Functions and symbols</i> in these <a href="http://www.goshen.edu/physix/mathphys/gco/Mathematica.php">notes on Mathematica</a>.  If this is too much to do with this week's other homework, you may hand this in next week.



<h3 id="hw2">Assignment #2 - due Fri, Jan 25</h3>
<p><b>Griffiths</b><br>
Chapter 1: problems 1.7*, 9, 11, 12</p>

<p><b>Notes/hints</b>
<p><b>*Problem 1.7</b> - One way involves using equations 1.23, 1.24, and the property of functions that the order of taking derivatives doesn't matter, that is $\frac{\partial^2 \Psi}{\partial x \partial t} =
\frac{\partial^2 \Psi}{\partial t \partial x}$. 

<h4>Selected answers</h4>
<p><b>1.9</b> <i>Mathematica</i> was very helpful on this one.
<p><b>a.)</b> Assuming we can pick $A$ real, $|\Psi|^2=\Psi^*\Psi= A^2e^{-a\left[mx^2/\hbar -it\]}e^{-a\left[mx^2/\hbar +it\]}$.
  The factors with $-it$ and $+it$ cancel, leaving $\Psi^*\Psi=A^2e^{-2amx^2/\hbar}$.
  Integrating this and setting the result equal to 1 yields
$$A=\left(\frac{2am}{\pi\hbar}\right)^{1/4}.$$
<p><b>b.)</b> $V(x)=2ma^2x^2$:  a parabola, like a mass-on-a-spring potential.
<p><b>c.)</b>
To calculate $\langle x \rangle$, the quick way to do it is to recognize that $|\Psi^*\Psi|^2=A^2e^{-2amx^2/\hbar}=g(x)$ 
is an <i>even</i> function, that is $g(-x)=g(x)$.  But  $f(x)=x$ is an odd function:  $f(-x)=-f(x)$.  The expectation value:
$$\langle x \rangle =\int \Psi^*x\Psi, dx= \int_{-\infty}^{+\infty} x A^2e^{-2amx^2/\hbar}\,dx=0$$

because an odd function times an even function is odd, and the integral of an odd function over an even interval vanishes.

<p>Since $\langle x \rangle=0$, the quick way to evaluate $\langle p \rangle$ is
$$\langle p \rangle = \frac d{dt}\langle x \rangle = 0.$$
<p><b>d.)</b>The other expectation values *do* require some calculation!  Because $\langle x \rangle = 0 = \langle p \rangle$, the variances are just $\sigma_x = \sqrt{\langle x^2 \rangle}=\sqrt{\frac{\hbar}{4am}}$, and $\sigma_x = \sqrt{\langle p^2 \rangle}=\sqrt{am\hbar}$.  Their product is $\hbar/2$ which <i>just barely</i> fulfills the Heisenberg uncertainty relation.



<h3 id="hw3">Assignment #3 - due Friday, Feb 1</h3>
<p><b>Griffiths</b><br>
Chapter 1: problems 1.15, 17<br>
Chapter 2: problems 2.1, 2, 4, 7</p>

<p><b>2.2</b>
<p>The vast majority of you got the major point, that if $E\lt V_\text{min}$, the the curvature $\psi''$ always has the same sign as the wave function $\psi$.  Now, some minor points: 
<ul><li>This does *not* mean that $\psi$ can never approach 0 as $x\to\infty$:  A counterexample is the function $f(x)=e^{-x}$ which is always positive, and always concave upwards, but $f(x\to\infty)=0$.
<li>This does *not* mean that $\psi$ can never cross the $x-$axis:  Consider $f(x)=\tan(-x)$:  $f(x)$ and $f''(x)$ always have the same sign, but it crosses the $x-$axis at 0.
</ul>
If you sketch a couple of these pathological situations, you will see that the important thing is that $\psi$ has got to blow up as $x\to$ either $+\infty$ or $-\infty$, and that's enough to make it impossible to normalize.
<p><b>2.4</b>
<p>*Why* can you get away with $\langle p \rangle$=m\frac{d\langle x\rangle}{dt}=0$ when $\Psi(x,t)$ is time-dependent??
<br><br><br><br>
<h3 id="hw4">Assignment #4 - due Friday, Feb 8</h3>
<p><b>Griffiths</b><br>
Chapter 2: problems 2.10, 12, 13, 18, 21*</p>
<p><b>Notes/hints</b>
<p><b>21c</b> - Note that you do not have to <i>solve</i> the integral, just set it up!
<p><b>21d</b> - You might do the sort of double <tt>Plot</tt> thing in Mathematica that I did in class, where one slider (for $a$) controls simultaneously the graphs of $\Psi(x,0)$ and $\phi(k)$
<h4>Selected answers</h4>
<p><b>2.12</b> - 
Once you have $\langle p^2 \rangle=\left(n+\frac 12 \right)\hbar m\omega$,
 the quickest way to get the kinetic energy is:
$$\langle T \rangle=\langle\frac{p^2}{2m}\rangle=\frac{\langle p^2\rangle}{2m}
=\frac 12\left(n+\frac 12 \right)\hbar\omega,$$
Which is exactly half of the total energy.
<p><b>2.13</b> -
<p><b>b)</b>  $\Psi(x,t)=\frac 15\left(3\psi_0e^{-i\omega t/2} +4\psi_1e^{-i3\omega t/2}\right)$. 
To figure 
$|\Psi(x,t)|^2$ 
we're going to use the fact that $\psi_0(x)$ and $\psi_1(x)$ are both real functions...
$$\begineq|\Psi(x,t)|^2 &=\Psi^*\Psi \\
&=\frac 15\left(3\psi_0e^{+i\omega t/2} +4\psi_1e^{+i3\omega t/2}\right)\frac 15\left(3\psi_0e^{-i\omega t/2} +4\psi_1e^{-i3\omega t/2}\right)\\
&=\frac 1{25}\left(9\psi_0^2+12\psi_0\psi_1(e^{+i(3-1)\omega t/2}+e^{-i(3-1)\omega t/2})+16\psi_1^2\right)\\
&=\frac 1{25}\left(9\psi_0^2+24\psi_0\psi_1\cos(\omega t)+16\psi_1^2\right)

\endeq
$$

<p><b>c)</b> A bunch of you used the ladder operator form of $\hat x=\sqrt{\frac{\hbar}{2m\omega}}(\hat a_+ +\hat a_-)$ to figure $\langle x\rangle$  Good!  You can also use some of the results from problem 12, such as, that $\langle x \rangle = 0$ for any of the stationary states.  <br><br>

(1 pt) I was looking for an answer to the question about the frequency of oscillation if this had been a superposition of $\psi_0$ and $\psi_2$ instead:

The time dependent term $\cos{\omega t}$ arises from the different in energies $(E_1-E_0)t/\hbar=(\frac 32-\frac 12)\hbar\omega t/\hbar=\omega t$.
  If we had a superposition
of $\psi_0$ and $\psi_2$ instead, we would have had terms with time dependence
$(E_2-E_0)t/\hbar=(\frac 52-\frac 12)\hbar\omega t/\hbar=2\omega t$, and 
we would have had a time dependence of $\cos(2\omega t)$ instead.

<p><b>d)</b> Mostly you figured the probabilities of the different energies correctly.  The problem also asks that you list the possible energies that you might measure, which are $E_0=\frac 12 \hbar\omega$ and $E_1=\frac 32 \hbar\omega$. 

<h3 id="hw5">Assignment #5 - due Friday, Feb 15</h3>
<p><b>Griffiths</b><br>
Chapter 2: problems 2.22, 23, 26, 27</p>
<p><b>Notes/hints</b>

<p><b>2.27</b> - Look separately for <i>even</i> and <i>odd</i> solutions.  You will get to an equation for $\kappa$ which cannot be solved by algebraic techniques.  You'll have to solve that numerically.  Griffiths suggests re-writing the equation in terms of 2 new quantities $z\equiv 2\kappa a$ and $c\equiv\frac{\hbar^2}{2am\alpha}$ and then looking for a numerical solution for the (now simpler-looking) equation.

<h4>Selected answers</h4>
<p><b>2.22</b> - One appealing aspect of the Gaussian wave packet is that we can actually calculate its time behavior: 
<p><b>a)</b> $A=\left( \frac{2a}\pi\right)^{1/4}$
<p><b>b)</b> With $y\equiv \sqrt a[x+(b/2a)]$ confirm that...
$$\begineq y^2-(b^2/4a)&= a[x^2+2(b/2a)x+b^2/4a]-(b^2/4a)\\
&= ax^2+bx+(b^2/4a)-(b^2/4a)\\
&= ax^2+bx.\\
\endeq
$$
Differentiating $y = \sqrt a[x+(b/2a)]$ implies that $dy=\sqrt a\,dx$ or
$dx=dy/\sqrt a$, so we can do variable substitution to re-write:
$$\begineq\int_{-\infty}^{+\infty} e^{-(ax^2+bx)}dx 
&=\int_{-\infty}^{+\infty} e^{-[y^2-(b^2/4a)]}(dy/\sqrt a)\\
&=\frac 1{\sqrt a}
e^{b^2/4a}
\int_{-\infty}^{+\infty} e^{-y^2}dy
=\frac{\sqrt \pi}{\sqrt a}
e^{b^2/4a}\label{squared}
\endeq
$$ 
<b>Getting back to the problem at hand...</b> We need to calculate the fourier transform (See equation [2.103]):
$$\begineq\phi(k)&=\frac 1{\sqrt{2\pi}}\int_{-\infty}^{+\infty}\Psi(x,0)e^{-ikx}\,dx\\
&=\frac 1{\sqrt{2\pi}}A\int_{-\infty}^{+\infty}e^{-ax^2}e^{-ikx}\,dx\\
\endeq
$$
This is an integral of the form of Eq (\ref{squared}) with $a\equiv a$ and $ik\equiv b$, and so using that result...
$$\phi(k)
=\frac 1{\sqrt{2\pi}}\left(\frac{2a}{\pi}\right)^{1/4}\frac{\sqrt \pi}{\sqrt a}
e^{-k^2/4a}
=\left(\frac{1}{2\pi a}\right)^{1/4}
e^{-k^2/4a}.
$$
Now, at last, we're ready to calculate $\Psi(x,t)$
 using equation [2.100]:
$$\begineq
\Psi(x,t)
&=\frac 1{\sqrt{2\pi}}\int_{-\infty}^{+\infty}\phi(k)e^{i(kx-\frac{\hbar k^2}{2m}t)}\,dk\\
&=\frac 1{\sqrt{2\pi}}\left(\frac{1}{2\pi a}\right)^{1/4}\int_{-\infty}^{+\infty}e^{-k^2/4a}e^{i(kx-\frac{\hbar k^2}{2m}t)}\,dk\\
\label{Psi}
\endeq
$$
The exponent of $e$ in the integral above can be written in the form $-[ak^2+bk]$:
$$
-k^2/4a+i(kx-\frac{\hbar k^2}{2m}t)
=-\left[\left(\frac 1{4a}
+\frac{i\hbar t}{2m}
\right)k^2+
(-ix)k\].

$$
Once again we have an integral of the form of (\ref{squared}), this time in terms of the variable $k$ instead of $x$, and with 
$\frac 1{4a}
+\frac{i\hbar t}{2m}
\equiv a$ and
$-ix\equiv b$.  So, we can use (\ref{squared}) to write out the integral in (\ref{Psi}), leaving us with
$$\begineq \Psi(x,t)
&=\frac 1{\sqrt{2\pi}}\left(\frac{1}{2\pi a}\right)^{1/4}
\frac{\sqrt \pi}{\sqrt{\frac 1{4a}
+\frac{i\hbar t}{2m}}}
e^{-\frac{x^2}{4(\frac 1{4a}
+\frac{i\hbar t}{2m})}}\\
&=\left(\frac{2a}{\pi}\right)^{1/4}\frac{e^{-ax^2/(1+2i\hbar at/m)}}{\sqrt{1+2i\hbar at/m}}
\endeq
$$
<p><b>c)</b> - We can write $|\Psi(x,t)|^2=\sqrt{\frac{2}{\pi}}we^{-2w^2x^2}$ where $w=\sqrt{\frac{a}{1+(2\hbar a t/m)^2}}$.
  Setting $a=1$ and with $t$ in units of $m/\hbar$, we can plot the expression above in terms of $w(t)=\sqrt{\frac{1}{1+(2t)^2}}$.  See this <a href="0g/P2.22.nb">Mathematica animation</a>/

<br><br>
<h3 id="2.27">2.27 - the double delta function potential</h3>
<h4>a)</h4>
<p>The potential looks like this (the delta functions are displayed in cartoon fashion!):<br>
<img src="homework/2.27.V.jpg"><br>
Keeping the solutions normalizable in the three regions, we have these general solutions in the three regions:
<table cellpadding="10">
<tr><th>Region I</th><th>II</th><th>III</th></tr>
<tr>
<td>$\psi_I(x)=Ae^{\kappa x}$</td>
<td>$\psi_{II}(x)=Be^{\kappa x}+Ce^{-\kappa x}$</td>
<td>$\psi_{III}(x)=De^{-\kappa x}$</td>
</tr>
</table>
<br>where $E=-\hbar^2 \kappa^2/2m$.

<h4>Even solutions: $\psi(-x)=\psi(x)$</h4>
<p>To make sure our solution is even, it turns out that we need to set $A=D$ and $B=C$, so the solutions are now...
<table cellpadding="10">
<td>$\psi_I(x)=Ae^{\kappa x}$</td>
<td>$\psi_{II}(x)=B(e^{\kappa x}+e^{-\kappa x})$</td>
<td>$\psi_{III}(x)=Ae^{-\kappa x}$</td>
</tr>
</table>
<br>Now, we look at two boundary conditions at $x=a$:

<h4>Continuity of $\psi$ at $x=a$</h4>
$$\begineq\psi_{II}(a)&=\psi_{III}(a)\\
B(e^{\kappa a}+e^{-\kappa a})
 &= Ae^{-\kappa a}\\
\endeq
$$
Multiplying by $e^{\kappa a}$, we can get $A=B(e^{2\kappa a}+1)$.<br><br>
(You might think we should also look at continuity at $x=-a$, but that just gives the same relation between $A$ and $B$...no new information.)

<p><b>Discontinuity $\Delta$ in $\psi'$ at $x=a$</b>:
$$\begineq
\Delta &=\psi'_{III}(a)-\psi'_{II}(a)\\
-\frac{2m\alpha}{\hbar^2} \psi(a)&=\\
-\frac{2m\alpha}{\hbar^2} Ae^{-\kappa a}&= -\kappa Ae^{-\kappa a}-B(\kappa e^{\kappa a}-\kappa e^{-\kappa a})\\
\frac{2m\alpha}{\kappa\hbar^2} A&= A+B( e^{2\kappa a}- 1)\\
A\left(\frac{2m\alpha}{\kappa\hbar^2} -1\right)&= B( e^{2\kappa a}- 1)\\
\endeq$$
Subbing in the expression we found from continuity for $A$ above, we get:
$$\begineq
B\left(e^{2\kappa a}+1\right)\left(\frac{2m\alpha}{\kappa\hbar^2} -1\right)&= B( e^{2\kappa a}- 1)\\
\left(e^{2\kappa a}+1\right)\left(
\frac{2m\alpha}{\kappa\hbar^2}
 -1\right)&= ( e^{2\kappa a}- 1)\\

\endeq$$
With the suggested substitions of $z\equiv 2\kappa a$ and $c\equiv \frac{\hbar^2}{2am\alpha}$, we can re-write 
$$\frac{2m\alpha}{\kappa\hbar^2}=\frac{2am\alpha }{\hbar^2}\frac{1}{2 \kappa a}*2=\frac{2}{cz}$$
 and the last equation above becomes:

$$
\begineq

\left(e^z+1\right)\left(\frac{2}{cz} -1\right)&= ( e^z - 1)\\
e^z\frac{2}{cz} -e^z+\frac{2}{cz}-1&=  e^z - 1\\
e^z\frac{2}{cz} -e^z+\frac{2}{cz}&=  e^z\\
\frac{2}{cz} -1+\frac{2}{cz}e^{-cz}&=  1\\
\frac{2}{cz} -1+\frac{2}{cz}e^{-cz}&=  1\\
\frac{2}{cz}\left(1+e^{-cz}\right)&=  2\\
1+e^{-cz}&=  cz\\
e^{-cz}&=  cz-1\\
\endeq$$

<a href="0g/2.27.cdf">Graphing</a>,  it looks like there will always be a solution (for this even function).

<h4>Energies for the even states</h4>
<p>We're asked to calculate energies for $\alpha_1=\frac{\hbar^2}{ma}$ and 
$\alpha_2=\frac{\hbar^2}{4ma}$. For the first one:
<ul>
<li>$c_1=1/2=0.5$.
<li>Solving $e^{-z}=0.5 z-1$ gives $z_1=2.21772$.
<li>Now $z=2\kappa a$ and $E=-\hbar^2 \kappa^2/2m$, so,
$$E_1=-\frac{\hbar^2z_1^2}{8m^2a^2}
=-0.615\frac{\hbar^2}{m^2a^2}.$$
</ul>

<p>The second (lower) energy works out to $E_2=-0.068\frac{\hbar^2}{m^2a^2}.$

<h4>Odd solutions: $\psi(-x)=-\psi(x)$</h4>
<p>Requiring the solutions to be odd, results in the three solutions:

<table cellpadding="10">
<td>$\psi_I(x)=Ae^{\kappa x}$</td>
<td>$\psi_{II}(x)=B(e^{\kappa x}-e^{-\kappa x})$</td>
<td>$\psi_{III}(x)=-Ae^{-\kappa x}$</td>
</tr>
</table>
<p>As before, we have two boundary conditions:  continuity at $x=a$, and the same amount of <i>dis</i>continuity in the slope at $x=a$.  Cranking through the algebra leaves us with this equation to solve:
$$e^{-z}=1-cz$$
The graphs always meet at $z=0$, but that implies that $\kappa=0$ and there's no normalizable bound state, so we only have solutions when $z\gt 0$, and this happens when the slope of the line is shallower than the slope of the exponential at $z=0$.

This time, only $\alpha_2$ leads to a bound state with energy $E=-.317\frac{\hbar^2}{m^2a^2}$. 

<p>
<br><br><br><br>

<h3 id="hw6">Assignment #6 - Friday, Feb 22</h3>
<p><b><a href="2.3n.php#problems">Spreadsheet problems</a></b><br>
Square well problems: 2, 3, 4</p>
<p><b>Griffiths</b><br>
Chapter 2: problems 2.34, 38, 40*, 42*, 45* </p>
<p><b>Notes/hints</b>
<p>* If you're  short of time, you may hand in one or more of these 3 problems by Tuesday, March 5.

<p>&nbsp;</p>
<p>&nbsp;</p>
<p>*nyf $\equiv$ not yet finalized

<h4>Selected answers</h4>

<p><b>Spreadsheet #2</b> - According to the Schr&ouml;dinger equation:
$$\frac{d^2\psi}{dx^2}=-\frac{2m}{\hbar^2}(E-V_0)\psi,$$
the curvature (second derivative) of the wavefunction  $\propto -(E-V)\psi$. <img src="homework/spreadsheet2.gif" class='rightalign'> Consider the ground state wave function that "just fits"  in the infinite square well (top sketch at right).<br><br>
In comparison, the ground state wave function in the finite well (bottom sketch) does not go to zero at the edges of the well.  The slope of the wave function at either side of the well is shallower, so the average curvature ( related to energy!) in the well region does not have to be as great.
<br><br>
So, this would seem to imply that energy (curvature) of the finite well solution is <b>lower in the finite well</b> compared to the infinite well.

<p><b>Spreadsheet #3</b> -
 I used the spreadsheet and got the following values for the <b>energy</b> of the four lowest ($n=1,2,3,4$) states

<table cellpadding="15">
<tr><td>&nbsp;</td><th colspan="2">ENERGY above well bottom</th>  
</tr>
<tr>
<tr><td>&nbsp;</td><th>width=4<br>
depth=20</th>  
<th>width=4<br>
depth=80</th>  </tr>
<tr>
<td>lowest state (even)<br>
n=1</td>
<td>0.5</td><td>0.555</td>
</tr>



<tr>
<td>
n=2 (odd)</td>
<td>1.99</td><td>2.22</td>
</tr>

<tr>
<td>
n=3 (even)</td>
<td>4.47</td><td>5</td>
</tr>

<tr>
<td>
n=4 (odd)</td>
<td>7.89</td><td>8.88</td>
</tr>
</table>
...which seems to vindicate the guess in #2.

<p><b>Spreadsheet #4</b> - This again uses the connection between curvature and $-(E-V)\psi$:

<ol><li><b>energy above the post</b>: The factor $(E-V)$ is greater than zero in both the post and the well region, and so the wave function curvature is concave *<b>T</b>owards* the $x$-axis both in the post region and in the well region. In the prohibited region, the wave function curvature is concave *<b>A</b>way* from the $x$-axis:
<br>
<img src="homework/spreadsheet4-above.gif"><br><br> 
<li><b>energy below the post</b> (but above the bottom of the well): The wave function curvature is concave *<b>T</b>owards* the $x$-axis only in the well region.
In the post region, and in the  prohibited region, the energy is less than $V$, and the wave function curvature is concave *<b>A</b>way* from the $x$-axis:
<br>
<img src="homework/spreadsheet4-below.gif"><br><br> 
</ol>


<h3 id="hw7">Assignment #7 - Friday, March 15</h3>
<p><b>Griffiths</b><br>
Chapter 3: problems 3.4a-c (not d), 6, 7, 14, 27</p>
<h4>Selected answers</h4>
<p id="3.4"><b>3.4c</b> - <i>Under what circumstances is $\hat Q \hat R$ hermitian?  (Assuming $\hat Q$ and $\hat R$ are hermitian.  That is $\innerp{f}{\hat Q g}=
\innerp{\hat Q f}{g}$).</i><br><br>
$$\begineq
\innerp{f}{\hat Q \hat R g} 
&=\innerp{f}{\hat Q (\hat R g)} 
=\innerp{\hat Q f}{\hat R g} \\

&=\innerp{(\hat Q f)}{\hat R g} 
=\innerp{\hat R(\hat Q f)}{ g} \\
&=\innerp{\hat R\hat Q f}{g} 
\endeq
$$
This tells us that 
$(\hat Q\hat R)^\dagger = \hat R \hat Q$.
  In order for an operator to be hermitian, it must be its own hermitian conjugate.  For this product of two hermitian operators that is true if $\hat Q\hat R = (\hat Q\hat R)^\dagger = \hat R \hat Q$.  This implies that $\hat Q\hat R-\hat R\hat Q=0=[\hat Q,\hat R]$.  So, <b>if $\hat Q$ and $\hat R$ <i>commute</i>, then their product will be hermitian.</b>

<p id="3.6"><b>3.6</b> - You can show $\hat Q=\d^2/d\phi^2$ is hermitian by showing $\innerp{f}{\hat Q g}=\innerp{\hat Q}{g}$.  To do this, you have to integrate by parts (two times) to move the derivative to the left side.  You need to argue that terms like $\left.f^*(dg/dx)\right|_0^{2\pi}$.  
In order for this to vanish, I was looking for you to acknowledge that it is not enough that $f(x+2\pi)=f(x)$, but that we also need $g'(x+2\pi)=g'(x)$.  Fortunately, if you think about it, this is the case also, as long as $g(x+2\pi)=g(x)$.<br><br>
The eigenvalues are $q=0, -1, -4, -9,.... -n^2.  There are two eigenfunctions for each eigenvalue (doubly degenerate) except for $q=0$, for which there is only one eigenfunction.

<p id="3.27"><b>Problem 3.27, Sequential measurements</b>
<p>See the material on <a href='3.1.php#discrete'>wavefunctions with discrete spectra</a>:
<blockquote>
<p>Any function in the Hilbert
space can be expressed as a linear combination of the eigenfunctions
of $\hat{Q}$.  That is, if an observable operator $\hat{Q}$ has a set
of eigenfunctions $\{f_n\}$, then that set is <b>complete</b>.  That
is to say, any vector in the space can be written as<br> $$\ket{\Psi}
= \sum_n c_n\ket{f_n}.$$ </ul> 
<p>...an individual
measurement of any observable corresponding to an operator
$\hat{Q}(x,\frac{h}{i}\frac{d}{dx})$ will result in one of the
eigenvalues $q_n$ corresponding to $\ket{f_n}$ with probability: 

<p
align=center>$|c_n|^2$ where $c_n=\innerp{f_n}{\Psi}$ 
</blockquote>
<p>We have an operator $\hat{A}$ that has two eigenstates $\ket{\psi_1}$ and $\ket{\psi_2}$, with eigenvalues $a_1$ and $a_2$, and an operator 
$\hat{B}$ that has two eigenstates $\ket{\phi_1}$ and $\ket{\phi_2}$, with eigenvalues $b_1$, $b_2$.

<p>$\psi_1 = (3\phi_1+4\phi_2)/5$
 and $\psi_2 = (4\phi_1-3\phi_2)/5$
<p>Check that $\psi_1$ is normalized, assuming that the $\phi$'s are orthonormal, that is, that $\innerp{\phi_i}{\phi_j}=\delta_{ij}$:
<p>$$\innerp{\psi_1}{\psi_1} =(3/5)^*(3/5)\innerp{\phi_1}{\phi_1} + (4/5)^*(4/5)\innerp{\phi_2}{\phi_2} = 9/25 + 16/25 = 1.$$

<p><b>a.) What state is the system in if measuring with $\hat{A}$ returned a value of $a_1$?.</b></p>
<p> After measurement with $\hat{A}$ where $a_1$ is found, the system is in state $\psi_1$.
<p><b>b.) What are the possible outcomes if $\hat{B}$ is now measured?</b>
<p> Since the state is $\psi_1 = (3\phi_1+4\phi_2)/5$ the amplitudes $c_n$ are:
$c_1=3/5$ for state $\phi_1$, and $c_2=4/5$ for state $\phi_2$.
<p>The probability to get eigenvalue $b_1$ is $|c_1|^2 = 9/25$.
<p>....
<p><b>c.) Now, measure $\hat{A}$ once more.  What's the probability of getting the value $a_1$ now?</b>
<p>You already know the probabilities of the two $\phi$ states.  For each of these cases, there is, in turn, a different probability to measure $a_1$.  
<p>To find these latter probabilities,  you've got to figure out how to express $\phi_1$ and $\phi_2$ as superpositions of $\psi_1$ and $\psi_2$.
<ul><li>Solve the definition of $\psi_1$ for $\phi_2$.
   <li>Substitute that equation for $\phi_2$ into the definition of $\psi_2$.
<li>Now, you have an equation that connects $\psi_1$, $\psi_2$, and $\phi_1$.  Solve it for $\phi_1$ to find that
$$\phi_1=(3/5)\psi_1 + (4/5)\psi_2$$
<li>Now you know $\phi_1$ in terms of $\psi_1$ and $\psi_2$.   Use one of the $\psi$ definitions to find $\phi_2$ in terms of $\psi_1$ and $\psi_2$.
</ul>


<img src="homework/3-27-1.gif" /><br>
<img src="homework/3-27-2.gif" /><br>



<h3 id="hw8">Assignment #8 - </h3>
<p><b>Griffiths</b><br>
Chapter 3: problem  37<br>
Chapter 4: problems 2, 3, 4, 5


<h4>Notes/hints</h4>
<p><b>3.37</b> - 
You'll need to find the eigenfunctions and eigenvalues of the hamiltonian matrix $\mym H$.  Then you can express any other state as superposition of those eigenfunctions--which is necessary to figure out the time dependence.
<p><b>4.2</b> - Separation of variables in Cartesian coordinates means 
$$\psi(x,y,z)=X(x)Y(y)Z(z).$$

<h4>Answers</h4>
<p id="3.37"><b>Problem 3.37
, Time dependence of 3-level system states</b>
<p>Consider a system in which the Hamiltonian matrix is given by
<p>$$\mym{H} = \left(
\begin{array}{ccc}
a & 0 & b \\
0 & c & 0 \\
a & 0 & b
\end{array} 
\right)$$</p>
<p>and $a$, $b$, and $c$ are real.  Find the time dependence of various states.
<p><b>a. If the system starts in</b>
<p>$$\ket{\mathcal{S}(0)} = \begincv 0 \\ 1 \\ 0 \endcv$$
<p><b>what is $\ket{\mathcal{S}(t)}$?</b>
<p>Refer to example 3.8.
<p>If $\ket{\psi}$ is a solution to the time independent Schr&ouml;dinger equation:
<p>$$\mym{H}\ket{\psi} = E\ket{\psi}$$
<p>Then 
<p>$$\ket{\Psi}=e^{-iEt/\hbar}\ket{\psi}$$
<p>is a solution to the time <b>dependent</b> Schr&ouml;dinger equation:
<p>$$i\hbar\frac{d}{dt}\ket{\Psi}=\mym{H}\ket{\Psi}.$$

<p>So, the strategy for this problem is to find the eigenvalues and eigenvectors of $\mym{H}$, and then to express $\ket{\mathcal{S}}$ as a linear superposition of these.<br><br>
Using Mathematica, <a href="homework/3.37.nb">we find</a> that the eigenvalues are $E_1=a-b$, $E_2=a+b$, and $E_3=c$ and the corresponding normalized eigenvectors are:
$$\ket 1=\frac{1}{\sqrt 2}\begincv -1\\0\\1\endcv;\ \ 
\ket 2=\frac{1}{\sqrt 2}\begincv 1\\0\\1\endcv;\ \ 
\ket 3=\begincv 0\\1\\0\endcv;
$$

At $t=0$ the state is
$$\ket{\mathcal{S}(0)} = \begincv 0 \\ 1 \\ 0 \endcv=\ket 3$$
So, the state at a later time is
$$\ket{\mathcal{S}(t)} 
= \ket 3e^{-iE_3t/\hbar}=\begincv 0 \\ e^{-ict/\hbar} \\ 0 \endcv$$

<p><b>b. If the system starts out as:</b>
$$\ket{\mathcal{S}(0)} = \begincv 0 \\ 0 \\ 1 \endcv$$
<p>The first step is to express as a sum of eigenvectors.  It looks like this combination will do the trick:
$$\begineq \begincv 0 \\ 0 \\ 1 \endcv &= \frac 12\left[ \begincv -1\\0\\1\endcv +\begincv 1\\0\\1\endcv\]\\
&=\frac 1{\sqrt 2}\left[ \frac{1}{\sqrt 2}
\begincv -1\\0\\1\endcv +\frac{1}{\sqrt 2}\begincv 1\\0\\1\endcv\]\\
&= \frac{1}{\sqrt 2}\ket 1+\frac{1}{\sqrt 2}\ket 2\\
\endeq
$$
<p>So the state at a later time is...
$$\begineq
\ket{\mathcal{S}(t)}&= \frac{1}{\sqrt 2}\ket 1e^{-i(a-b)t/\hbar}+\frac{1}{\sqrt 2}\ket 2e^{-i(a+b)t/\hbar}\\
&= \frac 12 e^{-iat/\hbar}\begincv -e^{ibt/\hbar}+e^{-ibt/\hbar}\\+e^{ibt/\hbar}+e^{-ibt/\hbar}\endcv\\
&= e^{-iat/\hbar}\begincv -i\sin(bt/\hbar)\\ \cos(bt/\hbar)\endcv
\endeq
$$


<p id="4.2"><b>Problem 4.2</b><br><br>
part c:    The energy of the 14th level is $E_{14}=\frac{27\pi^2\hbar^2}{2ma^2}$.  The combinations that give rise to this energy are $\{n_x,n_y,n_z\}=\{1,1,5\},\{1,5,1\},\{5,1,1\},\{3,3,3\}$.  What's unique?: All the other energy levels consist of permutations of just one triplet of integers $\{n_x,n_y,n_z\}$.  But here, two different triplets of integers have the same energy.<br><br>



<h3 id="hw9">Assignment #9 - Friday, April 5</h3>
<p><b>Read</b> these 4 pages from <a href="0g/Dirac.pdf">The Principles of Quantum Mechanics</a> by P.A.M. Dirac.  <b>Write</b>: Summarize, with full sentences, but in outline form, the reasons that Dirac gives for a theory beyond classical mechanics.  Write a paragraph about the one reason you find most compelling, and why.
<p><b>Griffiths</b><br>

Chapter 4: problems 10, 11a, 12b, 13ab, 16, 25, 27


<h4>Notes/hints</h4>
<p><b>Problem 4.27</b> -
 To figure the expectation value of $S_z$, for example, you can write it this way:
$$\langle S_z \rangle = \innerp{\chi}{\hat S_z\chi}$$
In matrix terms:  if $\chi=\begincv a\\b\endcv$ and $
\hat S_z=\begincv c&d\\e&f\endcv
$, then the expectation value becomes:
$$ \innerp{\chi}{\hat S_z\chi}=\chi^\dagger\hat S_z\chi=\begincv a^*&b^*\endcv
\begincv c&d\\e&f\endcv \begincv a\\b\endcv.$$
If you multiply the 2x2 matrix by the column vector to its right, you'll get a 1x2 column vector.  So, next, you take the dot product of $\chi^\dagger$ with that. 

<!--
<h4>Selected answers</h4>
<p id="4.10"><b>Problem 4.10, Radial functions from the recursion relation</b></p>
<p><img src="homework/4-10-1.gif"><br><br>

<p id="4.13"><b>Problem 4.13, expectation values</b>
<p><b>b.)</b><br>
$\langle x \rangle=?$ 
The idea here is that the ground state is spherically symmetric.  This means it is also symmetric about the $x$-axis:  the electron spends just as much time above the $x$-axis as below, and so 
$\langle x \rangle=0$<br><br>
$\langle x^2 \rangle=?$  We know that 
$$\langle r^2 \rangle=\langle x^2+y^2+z^2 \rangle  =\langle x^2  \rangle+ \langle y^2  \rangle + \langle z^2 \rangle$$
Again, spherical symmetry is our friend.  Exchanging the 'x'- and 'y'-axes should not change the probabilities,  so$
\langle x^2 \rangle = 
\langle y^2 \rangle = 
\langle z^2 \rangle$
 
and that means $\langle r^2 \rangle = 3\langle x^2 \rangle$.

<p id="4.16"><b>Problem 4.16, Hydrogenic atoms</b>
<p><img src="homework/4-16-1.gif">
<p><img src="homework/4-16-2.gif">
-->



<div myclass='thisWeek'>
<h3 id="hw10">Assignment #10 - </h3>
<p><b>Griffiths</b><br>

Chapter 4: 34b, 35, 38, 49 

"Bell problems"--Chapter 4: 50*; Chapter 12: 1; Paul's <a href="12.2.php#last">Last problem</a>
</div>
<h4>Notes/hints</h4>
<p><b>Problem 4.50</b> - Here's <a href="12.2.php#4.50">how to figure out the $\hat S_\alpha^{(2)}$ operator</a>.

<h4>Selected answers</h4>
<p id="4.34"><b>Problem 4.34b</b> - Show that $\hat S_\pm\ket{00}=0$.<p>
I'll show this for the raising operator.  The proof for the lowering operator proceeds along the same lines.

Using  $\hat S_+=
\hat S^{(1)}_+ 
+ \hat S^{(2)}_+$ where $\hat S_+^{(1)}\downarrow^{(1)}=\hbar\uparrow^{(1)}$ 
and $\hat S_+^{(1)}\uparrow^{(1)}=0$.  You get the same thing for the second spin with (1)$\to$(2).

$$\begineq
\hat S_+\ket{00}&=(\hat S^{(1)}_+ + \hat S^{(2)}_+)\frac{1}{\sqrt 2}
[\uparrow\downarrow - \downarrow\uparrow]\\
&=\frac{1}{\sqrt 2}
\left[(\hat S^{(1)}_+ \uparrow)\downarrow - (\hat S^{(1)}_+ \downarrow)\uparrow + \uparrow(\hat S^{(2)}_+\downarrow) - \downarrow(\hat S^{(2)}_+\uparrow)\]\\

&=\frac{1}{\sqrt 2}
\left[0 - \hbar \uparrow\uparrow + \hbar\uparrow\uparrow - 0\]\\
&= 0
\endeq$$

<p id="4.49"><b>Problem 4.49d</b> - If you measure the $y$-component of spin on the state 
  $\chi=1/3\begincv 1-2i\\2 \endcv$
 (in the $S_z$ basis), what is the chance of measuring $+\hbar/2$?

<p><a href="4.6.php">We already found</a> the eigenstates of $\hat S_y\equiv\frac{\hbar}{2}
\begincv 0 & -i\\i&0\endcv$.
They are:
$$
\chi_+^{(y)}=\frac{1}{\sqrt{2}}\begincv -i\\1 \endcv; \ 
\chi_-^{(y)}=\frac{1}{\sqrt{2}}\begincv i\\1 \endcv\ .
$$
with eigenvalues $+\hbar/2$ and $-\hbar/2$.

<p>The state $\chi$ can be written as a superposition of the two $\hat S_y$ eigenstates:
$$\chi = c_+\chi_+^{(y)} + c_-\chi_-^{(y)}.$$
The probability of measuring $S_y=+\hbar/2$ is equal to $|c_+|^2$, where
$$\begineq c_+&=\innerp{\chi_+^{(y)}}{\chi}=\chi_+^{(y)\dagger}\chi\\
&=\frac{1}{\sqrt 2}\begincv +i & 1\endcv 1/3\begincv 1-2i\\2 \endcv\\
&=\frac{1}{\sqrt {18}}\begincv +i & 1\endcv \begincv 1-2i\\2 \endcv\\
c_+&=\frac{1}{\sqrt {18}}(+i +2+2)=\frac{4+i}{\sqrt {18}}.
\endeq
$$
So, the probability of measuring $+\hbar/2$ is $|c_+|^2$:
$$|c_+|^2=c_+^*c_+=\frac{4-i}{\sqrt {18}}\frac{4+i}{\sqrt {18}}=\frac{16+1}{18}=\frac{17}{18}.$$
We could use the same method to calculate $c_-$.  But since there are only two states, and the probabilities must sum to 1, this means  $|c_+|^2+
|c_-|^2=1$.  So, $|c_-|^2=1-17/18=1/18$. So, the probability of measuring $S_y=-\hbar/2$ is 1/18.

<p>There are two ways to calculate the expectation value:  We could do it this way:
$$\langle \hat S_y \rangle=\bra{\chi}\frac{\hbar}{2}\begincv 0&-i\\+i&0\endcv\ket{\chi}.$$
Or, since we know the probabilities, we could take the probability weighted average:
$$\langle \hat S_y \rangle=\left(+\frac{\hbar}{2}\right)P_+ + \left(-\frac{\hbar}{2}\right)P_-
=\frac{17}{18}\frac{\hbar}{2}-\frac{1}{18}\frac{\hbar}{2}=\frac{16}{36}\hbar=\frac{4}{9}\hbar$$
Either approach gives the same answer.


<p><b>Last problem</b> - Bell's inequality is:
$$1+P(\myv b, \myv c)\geq |P(\myv a,\myv b)-P(\myv a, \myv c)|$$
Since the vectors in $P$ are all unit vectors, 
$$P(\myv v_1,\myv v_2)=-\myv v_1\cdot\myv v_2=-|v_1||v_2|\cos\alpha = -\cos\alpha,$$
where $\alpha$ is the angle between $\myv v_1$ and $\myv v_2$.
<ol>
<li>For the case that $\myv a=\hat z$ and $\myv b=\hat x$:  
$P(\myv a,\myv b)=0$,  
$P(\myv a,\myv c)=-\cos\theta$,
$P(\myv b,\myv c)=-\cos(\pi/2-\theta)$.
<br><img src="homework/last1.jpg">

<li>For the case that $\myv a=\hat z$ and $\myv b=-\hat z$:  
$P(\myv a,\myv b)=1$,  
$P(\myv a,\myv c)=-\cos\theta$,
$P(\myv b,\myv c)=-\cos(\pi-\theta)$.
<br><img src="homework/last2.jpg">
  

<div class="justme"
<p><b>Griffiths</b><br>
  Chapter 4: 1: a only, <a href="#4.10">10</a>, 11: a only, <a href="#4.13">13: a,b only</a>, <a href="#4.16">16</a>, <a href="#4.17">17</a></p>




<h2 id="hw4">Assignment #4 - due Friday, April 7</h2>

  Chapter 4: <a href="#4.22">22</a>, <a href="#4.23">23</a>, <a href="#4.24">24</a>, <a href="#4.25">25</a>, <a href="#4.27">27</a>

<p id="4.22"><b>Problem 4.22, Construct $Y_l^l$ from ladder operators</b>
<p><img src="homework/4-22-1.gif">
<p><img src="homework/4-22-2.gif">
<p><img src="homework/4-22-3.gif">
<p><img src="homework/4-22-4.gif">
<p><img src="homework/4-22-5.gif">

<p id="4.23"><b>Problem 4.23, Applying the raising operator</b>
<p><img src="homework/4-23-1.gif">
<p><img src="homework/4-23-2.gif">

<p id="4.24"><b>Problem 4.24, 2 masses connected by a rod</b>
<p><img src="homework/4-24-1.gif">
<p><img src="homework/4-24-2.gif">

<p id="4.25"><b>Problem 4.25, classical spinning electron</b>
<p><img src="homework/4-25-1.gif">
<p><img src="homework/4-25-2.gif">

<p id="4.27"><b>Problem 4.27, Uncertainty relations for spin components</b></p>
<p><b>In part c:</b>  use the the general property that 
$$\sigma^2_{\hat{Q}} =\langle(\hat{Q} -\langle\hat{Q}\rangle)^2\rangle = \langle\hat{Q}^2\rangle - \langle\hat{Q}\rangle ^2.$$
<br><br>
<p><img src="homework/4-27-1.gif">
<p><img src="homework/4-27-2.gif">
<p><img src="homework/4-27-3.gif">




<h2 id="hw3">



Assignment #3 - due Wednesday, March 30</h2>

<p id="4.17"><b>Problem 4.17, Earth - Sun as quantized systemSequential measurements</b></p>
<p><img src="homework/4-17-1.gif">
<p><a href="http://www.wolframalpha.com/input/?i=%28hbar%29^2%2F%28%28Gravitational+constant%29%28mass+of+earth%29^2%28mass+of+sun%29%29">Wolfram Alpha calculation of Earth-sun Bohr radius</a>
<p><img src="homework/4-17-2.gif">
<p><img src="homework/4-17-3.gif">
<p><img src="homework/4-17-4.gif">
<p><img src="homework/4-17-5.gif">




<h2 id="hw2">Assignment #2 - due Monday, March 21</h2>
<p><b>Griffiths</b><br>
  Chapter 3: <a href="#3.22">22</a>, <a href="#3.27">27</a>, <a href="#3.37">37</a>, <a href="#3.39">39a</a><br>
  Chapter 4: <a href="#4.2">2</a>, 3, 5 (Just do $Y_3^2$)</p>
<p>&nbsp;</p>
<!--
<p id="3.22"><b>Problem 3.22</b>
<img src="homework/3-22-1.gif" /><br>
<img src="homework/3-22-2.gif" /><br>


<


<p id="3.39"><b>Problem 3.39a, generator of translations</b>
<p>Here's the general <a href="http://mathworld.wolfram.com/TaylorSeries.html">Taylor series</a> expansion to approximate $f(x)$ near the point $x=a$ where you know values for the derivatives $f^n(a)$:
<p>$$f(x) = f(a) + (x-a)f'(a)+\frac{(x-a)^2}{2!}f''(a)
+\frac{(x-a)^3}{3!}f'''(a)+...
$$
<p>The derivatives of $e^x$ are so convenient: $\left(\frac{d}{dx}\right)^m e^x = e^x$.
The Taylor expansion of $e^x=e^{x-a}$ around the point $x=a$ is
<p>$$e^{x} = e^a +e^a(x-a) + e^a(x-a)^2/2! + e^a(x-a)^3/3!$$
<p>and if we expand around a=0, this gives us the series representation of $e^x$...
<p>$$e^x = 1+x+x^2/2!+x^3/3!+x^4/4!+....$$</p>
<p>This is the basis for writing this operator expression as the series...
<p>$$e^{\hat{Q}}=1+\hat{Q} +(1/2)\hat{Q}^2 + (1/3!)\hat{Q}^3+...$$
<p><b>a.) show that $f(x+x_0)=e^{i\hat{p}x_0/\hbar}$  for functions that can be Taylor expanded</b>
<p>Start by Taylor expanding $f(x+x_0)$ around the fixed point $f(x)$. 

<p id="4.2"><b>Problem 4.2, Separation of variables in Cartesian coordinates
</b>
<p>We derived the energies when we talked about the <a href="http://www.goshen.edu/physix/310/gco/12.6.php">particle in a box</a> in Thermodynamics, though this doesn't include all the steps along the way of the separation of variables technique.

-->

<h2 id="hw1">Assignment #1 (due Friday, March 11)</h2>
<p><b>Griffiths</b><br>
  Chapter 3: 2, <a href='#3.6'>6</a>, 7, 13</p>
<p>&nbsp;</p>
<!--
<p id='3.2'><b>Chapter 3<br>Problem 2</b>
<p><img src="homework/3-2-1.gif"><br>
<img src="homework/3-2-2.gif"><br><br><br>

<p id='3.6'><b>Chapter 3<br>Problem 6</b>
<p><img src="homework/3-6-1.gif"><br>
<img src="homework/3-6-2.gif"><br>
<br><br>
-->

</div>
<?php include "../../classes/3.h" ?>

