<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Surface integrals of vector fields
[6.6]
</title>
<meta name="xweek" content="15">
<meta name="nolink" content="nolink">
<?php include "../../classes/2.h" ?>

<h1>
Surface integrals
</h1>
<p class="show">
<img src="0g/13.6.fungus.jpg" class="centeralign"><br>
For example: how much water is flowing out through a surface?



<h3>Parameterizing surfaces</h3>

<p class="show"><img src="0g/13.6.surfxynoP.jpg" class="centeralign">

<p class="show">In the topic on <a href="mv11.6.php">parametric surfaces [11.6]</a>
we saw how to express a surface $S$ in terms of two parameters $u$ and $v$ in a domain $D$.
The surface is specified by a mapping
$$\myv r=x(u,v)\uv i+y(u,v)\uv j+z(u,v)\uv k$$
<img src="0g/13.6.surfuv.jpg"><br>
<p>The surface area is
$$A_S=\iint_S 1\,dS = \iint_D\left|\myv r_u \times \myv r_v \right|\,dA.$$
where
$$\myv r_u
\equiv \langle \frac{\del x}{\del u},
\frac{\del y}{\del u},\frac{\del z}{\del u}
\rangle\equiv \langle x_u, y_u, z_u \rangle,$$
and similarly for $\myv r_v$.

<h3>The surface integral</h3>
<p class="show"><img src="0g/13.6.surfxy.jpg" class="centeralign">
<p>Defining the surface integral in terms of the Riemann sum<br>
<img src="0g/13.6.surfin.jpg" class="centeralign">


<p class="show"><b>General definition of a surface integral</b> if the surface $x=x(u,v)$, $y=y(u,v)$ and $z=z(u,v)$ is parameterized in the parameter space $u$, $v$:
<p class="show incremental def">$$\iint_S f(x,y,z)\,dS=
\iint_D f(\myv r(u,v))
\left|\myv r_u \times \myv r_v \right|\,du\,dv.$$

<p>But we
can define a surface in terms of $x=x$, $y=y$, and $z=g(x,y)$. That is, $x$ and $y$ are the two 'parameters'.
Then the definition of a surface integral is:
<p class="show incremental def">$$\iint_S f(x,y,z)\,dS=
\iint_D f(x,y,g(x,y))\sqrt{1 +
\left(\frac{\del g}{\del x}\right)^2
+\left(\frac{\del g}{\del y}\right)^2
}\,dx\,dy.$$

<h3>Oriented surface</h3>

<p class="show">We'll shortly be integrating normal components of vector fields.
<img src="0g/13.6.surfns.jpg" class="rightalign">
There are two possible surface normal orientations.

<p>For closed surfaces we can define a convention for which surface normal to choose.<br><img src="0g/13.6.surfconventions.jpg">


<h3>Surface, or flux integral</h3>
<p class="show"><img src="0g/13.6.normalcomponent.jpg" class="leftalign">If necessary, we will use a simpler convention that the positive normal direction is <i>up</i>.
<p>The <b>flux integral</b> or the surface integral of the normal component of a vector field is
$$\iint_S\myv F\cdot \uv n \,dS$$

<p>In terms of the parameters $u$ and $v$, note that <a href="12.6.php#surfacenormal">$\myv r_u \times \myv r_v$ is normal to the surface</a>.  Therefore,<br>
<img src="0g/13.6.flux1.jpg" class="big">
<p><img src="0g/13.6.flux2.jpg" class="big">

<h3 class="justme">Example-really ought to have one</h3>
<h3>To do</h3>
<div class="todo">
<p>Let $\myv F(x,y,z)=x^2\uv i$.  Find $\iint_S\myv F\cdot d\myv S$ where $S$ is the surface of a box with one vertex at the origin, and extending 1 unit in the positive $\uv i$, $\uv j$, and $\uv k$ directions. $d\myv S$ points in the direction normal to the surface. 

<p>First sketch the box.  Then find $d\myv S$ for each of the six faces. (For example, for the top face, it is $d\myv S=\uv k\,dA=\uv k\,dx\,dy$.)   Then calculate the double integral for each face. (It's easier than it sounds!)
</div>

<div class="answer justme">
<p>See <a href="0g/13.6.surf.nb">13.6.surf.nb</a>
</p>
</div>
<h4>Image credits</h4>
<p><a href="https://www.flickr.com/photos/annkelliott/19977305181">Anne Elliott</a>
<?php include "../../classes/3.h" ?>

