<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
The Divergence theorem
[06.8]
</title>
<meta name="week" content="">
<meta name="nolink" content="nolink">
<?php include "../../classes/2.h" ?>

<h1>
Stokes' and Divergence Theorems
</h1>
<p class="show"><img src="0g/13.6.tornado.jpg">

<h3>Parametric surfaces</h3>
<p class="show">
In the topic on <a href="/physix/213/gco/12.5.php">parametric surfaces [12.5]</a> we saw how to express a surface in terms of two parameters $u$ and $v$.  The surface is specified by 
$$\myv r=x(u,v)\uv i+y(u,v)\uv j+z(u,v)\uv k$$
<img src="0g/13.6.surfuv.jpg"><br>
<p>The surface area is
$$A_S=\iint_S 1\,dS = \iint_D\left|\myv r_u \times \myv r_v \right|\,dA.$$

<h3>The surface integral</h3>
<p class="show"><img src="0g/13.6.surfxy.jpg" class="centeralign">
<p>Defining the surface integral in terms of the Riemann sum<br>
<img src="0g/13.6.surfin.jpg" class="centeralign">

<h3>Definition</h3>
<p class="show">General definition in the parameter space $u$, $v$:
$$\iint_S f(x,y,z)\,dS=
\iint_D f(\myv r(u,v))
\left|\myv r_u \times \myv r_v \right|\,du\,dv.$$

<p>With $z=g(x,y)$, if we take the parameters to be $x$ and $y$ this turns into
$$\iint_S f(x,y,z)\,dS=
\iint_D f(x,y,g(x,y))\sqrt{1 +
\left(\frac{\del g}{\del x}\right)^2
+\left(\frac{\del g}{\del y}\right)^2
}\,dx\,dy.$$

<h3>Oriented surface</h3>

<p class="show">We'll shortly be integrating normal components of vector fields.
<img src="0g/13.6.surfns.jpg" class="rightalign">
There are two possible surface normal orientations.

<p>For closed surfaces we can define a convention for which surface normal to choose.<br><img src="0g/13.6.surfconventions.jpg">


<h3>Surface, or flux integral</h3>
<p class="show"><img src="0g/13.6.normalcomponent.jpg" class="leftalign">If necessary, we will use a simpler convention that the positive normal direction is <i>up</i>.
<p>The flux integral or the surface integral of a vector field is
$$\iint_S\myv F\cdot \uv n \,dS$$

<p>In terms of the parameters $u$ and $v$,<br>
<img src="0g/13.6.flux1.jpg" class="big">
<p><img src="0g/13.6.flux2.jpg" class="big">

<h3>Vector forms of Green's Theorem</h3>
<p class="show">Here again are the vector forms of Green's Theorem:
$$\oint_C \myv F\cdot \uv T\,ds = \iint_D \myv \grad \times \myv F \cdot \uv k\,dA.
$$

$$\oint_C \myv F\cdot \uv n\,ds = \iint_D \myv \grad \cdot \myv F \,dA.
$$

<h3>Stokes' Theorem</h3>
<p class="show"><img src="0g/13.6.Stokes.jpg" class="centeralign">
<p><img src="0g/13.6.Stokesdiagram.jpg" class="centeralign">

<p>Since...
$$\oint_C \myv F\cdot d\myv r=\oint_C \myv F\cdot \uv T\,ds$$
and
$$\iint_S\myv \grad \times \myv F \cdot d\myv S=\iint_S\myv \grad \times \myv F\cdot \uv n \,dS,$$
the content of Stokes' theorem is that
<ul><li>The integral of the circulation density over a surface is equal to 
<li>the circulation around the boundary of the surface.
</ul>
<h3>Meaning of curl / circulation</h3>
<p class="show"><img src="0g/13.6.curld1.jpg" class="leftalign">
Curl is a measure of <i>circulation per unit area</i>. If the vector field $\myv v$ is the velocity of fluid flow, then the circulation around a circle $C$ is the integral of the tangential component of $\myv v$ around the boundary of the circle.

<p>Circulation is a measure of the extent to which $\myv v$ maintains the direction of the unit tangent $\uv T$ - the extent to which the flow is rotating in the direction of $C$.<br clear="all">

<h3></h3>
<p class="show"><img src="0g/13.6.curld2.jpg" class="leftalign">
Take a point $P$ within the flow and a disk $D$ with unit normal $\uv n$ surrounding $P$.

<p>Stokes' theorem says that the circulation of $\myv v$ around $C$ is approximately equal to the average $\uv n$ component of $\myv \grad \times \myv v$ on $D$ multiplied by the area of $D$.

<p>So the average $\uv n$ component of $\myv \grad \times \myv v$ on $D$ is equal to the circulation around $C$ divided by the area of $D$.

<h3></h3>
<p class="show"><img src="0g/13.6.curld3.jpg" class="leftalign">
Integrating $\myv \grad \times \myv F$ for the region shown.

<ul class="else"><li>Arrows show the circulation for each patch of surface $\Delta S$.
</ul>

<p>Inside the large rectangle the rotations cancel so the integration of curl F for the region is equivalent to integrating the flow along the boundary.
<br clear="all">
<p><img src="0g/13.6.circulationconventiona.jpg" class="big">




<h3>The Divergence Theorem</h3>

<p class="show">

<p class="show">


<p class="show"><img src="0g/13.6.divergence.jpg" class="centeralign">
<p>Compare to this vector version of Green's theorem:
$$\oint_C \myv F\cdot \uv n\,ds = \iint_D \myv \grad \cdot \myv F \,dA.
$$

<p>The divergence at a point is something like the local 'flux density'.
<p>The integral of the flux density over a solid region is equal to the flux through the surface boundary of the region.

<h3>Example</h3>
<p class="show"><img src="0g/13.6.triangle.jpg" class="rightalign">

Calculate the flux through just the surface<br><br>
$\iint_S \myv F\cdot \uv n \,dS$<br><br>
where $S$ is the surface with vertices $(9,0,0)$, $(0,9,0)$, $(0,0,9)$,
and the vector field is
$$\myv F(x,y,z)=(x+y^2)\uv i+(y+z^2)\uv j+(z+x^2)\uv k$$

<p>I'll use this form of the surface integral:
$$\iint_S f(x,y,z)\,dS=
\iint_D f(x,y,g(x,y))\sqrt{1 +
\left(\frac{\del g}{\del x}\right)^2
+\left(\frac{\del g}{\del y}\right)^2
}\,dx\,dy.$$

<p>The equation of the plane containing the triangle is..
$$x+y+z=9 \Rightarrow z=g(x,y)=9-x-y$$
<ul><li>$g_x=g_y=-1$ so the square root factor is $\sqrt{3}$
<li> the limits of integration are
$$\iint_D=\int_{x=0}^9\int_{y=0}^{9-x}$$
</ul>

<p>The function $f(x,y,z)=f(x,y,g(x,y))$ in the integral is
$\myv F\cdot\uv n$.
<ul><li>The unit normal vector to the plane is $\uv n=\frac{1}{\sqrt 3}\langle 1,1,1\rangle$, 
<li>so 
$$\myv F\cdot \uv n = \frac{1}{\sqrt 3} \left(x+y^2+y+z^2+z+x^2\right)$$
<li>substituting in $z=9-x-y$ on the triangular surface, Mathematica expands this to...
$$\myv F\cdot\uv n = \frac{1}{\sqrt 3}(90 - 18 x + 2 x^2 - 18 y + 2 x y + 2 y^2)$$
</ul>
<p>Putting this all together...
$$\iint_D\myv F\cdot \uv n dS
=
\int_{x=0}^9\int_{y=0}^{9-x}(90 - 18 x + 2 x^2 - 18 y + 2 x y + 2 y^2)\,dy\,dx.$$
<h3>Example</h3>
<p class="show"><img src="0g/13.6.triangle.jpg" class="rightalign">
Calculate the total flux through *all* the surfaces of the volume bounded byt the triangle, and the planes $x=0$, $y=0$, $z=0$.
with<br><br>
$\iint_S \myv F\cdot \uv n \,dS$
<br><br>where
$$\myv F(x,y,z)=(x+y^2)\uv i+(y+z^2)\uv j+(z+x^2)\uv k=P\uv i+Q\uv j+R\uv k.$$
<p>This turns out to be significantly easier!  We'll calculate it from the right side of the divergence theorem:<br><br>
 &nbsp; &#x222f;${}_S \myv F \cdot \uv n dS = \iiint_E \myv \grad \cdot \myv F dV.$
<p>The divergence is
$$\myv \grad \cdot \myv F =\frac{\del P}{\del x}+\frac{\del Q}{\del y}
+\frac{\del R}{\del z}= 1+1+1=3.$$
<p>So, 
$$\iiint_E \myv \grad \cdot \myv F dV=3\iiint_E\,dV=3*(9*9*9/3)=729.$$


<h3>Example</h3>
<p class="show"> &nbsp; &#x222f;${}_S \myv F \cdot \uv n dS = \iiint_E \myv \grad \cdot \myv F dV.$
<p class="show"><img src="0g/13.6.lilbox.jpg" class="rightalign">
For some function $\myv F=P\uv x+Q\uv y+R\uv j$...
<br><br>[Normal vectors?]
<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/fadilfb/2146255462">Fadil Basymeleh</a>

<?php include "../../classes/3.h" ?>

