<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Scalar Line Integrals [6.D]
</title>
<meta name="week" content="13">
<!--meta name="nolink" content="nolink"-->

<?php include "../../classes/2.h" ?>
<style type="text/css">
.orangy{padding: .4ex; background-color: #fc9; font-weight:bold}
</style>
<h1>
<i>Scalar</i> Line Integrals 
</h1>
<p class="show">See <a href="https://openstax.org/books/calculus-volume-3/pages/6-2-line-integrals">Strang, section 6.2</a>

<p class="show"><img src="0g/13.2.curvyfence.jpg" class="big">


<h3>Line integral (scalar)</h3>
<p class="show">Area (scalar) of the wandering, irregular fence...
<p class="show">Consider the smooth curve, $C$, in the $x$-,$y$-plane described by the vector function parameterized in terms of $t$
$$\myv r(t)=\langle x(t),y(t)\rangle.$$
<img src="0g/13.2.pathC.jpg" class="big"><br>
If the curve is chopped up into $n$ arcs...
<p class="show def incremental">The <b>line integral of $f$ along $C$</b> is:
$$\int_C f(x,y)\,ds=\lim_{n\to\infty}\sum_{i=1}^n f(x_i^*,y_i^*)\Delta s_i.$$

<p>In  <a href="http://www.goshen.edu/physix/213/gco/mv09.8.php">section [9.8]--arclength</a>--we found that...
<ul><li>$\myv r'(t)=\langle x'(t),y'(t) \rangle$ is a vector tangent to the curve.  
<li>[If the parameter $t$ is time, then $\myv r'(t)$ is the <i>velocity</i> vector.]
<li>The arclength distance traversed when $t$ changes by $\Delta t$ is
$$\Delta s\approx |\myv r'|\Delta t=\sqrt{
\left(\frac{d x}{d t}\right)^2+\left(\frac{d y}{d t}\right)^2
}\Delta t$$
</ul>
<p class="show def incremental">
$$\int_Cf(x,y)\,ds = \int_{t=a}^b f(x(t),y(t)) 
\sqrt{
\left(\frac{d x}{d t}\right)^2+\left(\frac{d y}{d t}\right)^2
}
\,dt.$$

<h3>Example - <span class="orangy">$t$ as the parameter</span></h3>
<p class="show"><img src="0g/13.2.t32.jpg" class="rightalign">
$\int \frac yx\,ds$
 along the line $x(t)=t^4$, $y(t)=t^3$, $0\leq t \leq 1$.


<p>$$\begineq
\int_C \frac yx\,ds
&= \int_{t=0}^1 \frac {y(t)}{x(t)} 
\sqrt{
\left(\frac{d x}{d t}\right)^2+\left(\frac{d y}{d t}\right)^2
}
\,dt\\

&= \int_{t=0}^1 \frac {t^3}{t^4} 
\sqrt{
\left( 4t^3\right)^2+\left(3t^2\right)^2
}
\,dt\\

&= \int_{t=0}^1 \frac {1}{t} 
\sqrt{ 16t^6+9t^4
}
\,dt\\

&= \int_{t=0}^1 t 
\sqrt{ 16t^2+9
}
\,dt\\
\endeq
$$

<p>Substitution of variables: $u=16t^2+9$, so $du=32t\,dt$:

<p>$$\begineq
\int_C \frac yx\,ds
&= \frac{1}{32}\int_{u(0)}^{u(1)}  
\sqrt{ u
}
\,du\\

&= \frac{1}{32}\left[ \frac 23 u^{3/2}
\right]_9^{25}   = \frac{1}{16*3}(125-27)=\frac{49}{24}

\endeq
$$

<h3 id="XasParameter">Example <span class="orangy">$x$ as the parameter</span></h3>

<p class="show">$$\int_C xy\,ds$$
<img src="0g/xsquared.png" class="rightalign">where $C$ is the parabola $y=x^2$

<p>Instead of resorting to $t$ as our parameter, we could consider $x$ to be our "parameter".  So now, our curve $C$ is "parameterized" as
$$\myv r(x)=\myc{x,x^2}\ \ \text{with}\ \ 0\leq x \leq 2.$$
In terms of our parameter, $x$, we have:

<ul><li>$x(x)=x$ (whoa!)
<li>$y(x)=x^2$
</ul>
so $xy\to x*x^2=x^3$.

Instead of $ds=|\myv r'(t)|\,dt$ we'll have
$$\begineq ds&=|\myv r'(x)|\,dx=\sqrt{\left(\frac{dx}{dx}\right)^2+\left(\frac{dy(x)}{dx}\right)^2}\,dx\\
&=\sqrt{\left(\frac{dx}{dx}\right)^2+\left(\frac{dx^2}{dx}\right)^2}\,dx\\
&=\sqrt{\left(1\right)^2+\left(2x\right)^2}=\sqrt{1+4x^2}\,dx
\endeq
$$

Putting these together:
<p class="show">$$\begineq \int_C \color{blue}xy\color{red}\,ds
&=\int_{x=0}^2\color{blue}x^3\color{red}\sqrt{1+4x^2}\,dx
\endeq
$$
According WolframAlpha <a href="https://www.wolframalpha.com/input?i=integrate%28x%5E3*sqrt%281%2B4x%5E2%29+dx%29+from+x%3D0+to+2">this integral</a>$\approx$ <span class="answer">13.443</span>.

<h3>Example <span class="orangy">$x$ as the parameter again</span></h3>

<p class="show">$$\int_C(x+y^2)ds$$
where $C$ is the line from $(0,1)$ to $(3,1)$.
<ul>
<li>Along this line, $y=1$ so $x+y^2\to x+1$.
<li>$C$ is parallel to the $x$-axis.  Let's use $x$ as our parameter.  (When we do this, the "speed" in the integral is $\sqrt{(d x/dx)^2+(dy/dx)^2}=\sqrt{1^2+0^2}=1$ )
<li>So, parallel to the $x$-axis the increment of distance is $ds\equiv dx$.
</ul>
<p>$$\int_C(x+1)ds = \int_{x=0}^3(x+1)\,dx =\left(\frac{x^2}{2}+x\right)_{x=0}^3= \frac 92+3=\frac{15}{2}.$$

<h3>Example <span class="orangy">angle $\theta$ as the parameter</span></h3>

<p class="show"><img src="0g/13.2.halficecream.jpg" class="rightalign">
$\int (x+y)\,ds=?$
<p>This can be split into two integrals...
<p>Let's do the <span class="orangy">integral along $C_1$</span> in polar coordinates, that is our <span class="orangy">parameter will be $\theta$</span>.
<ul>
<li>$x=r\cos\theta;\ \ y=r\sin\theta$.  
But since $r=1$, we have $x=\cos\theta;\ \ y=\sin\theta$.
<li>Since we're moving from the point on the left to the right, we're going <i>clockwise</i> around $C_1$.  So our parameter starts at $\theta_i=\pi/2$, and ends at $\theta_f=0$.
<li>Arclength 
$$\begineq ds&=\sqrt{
\left(\frac{d\, \cos\theta}{d\theta}\right)^2 +
\left(\frac{d\, \sin\theta}{d\theta}\right)^2 
}\,d\theta \\
&=\sqrt{
\left(-\sin\theta \right)^2 +
\left(\cos\theta\right)^2 
}\,d\theta \\
&=d\theta
\endeq
$$

</ul>

<p>Putting these pieces together,
$$\int_{C_1} (x+y)\,ds
=\int_{\theta=\pi/2}^{0}\left(
\cos\theta + \sin\theta 
\right)\,d\theta=-2.$$

<p><br><br><span class="orangy">Along $C_2$</span>:  The equation of the line is $y(x)=x+1$.  Let's <span class="orangy">use $x$ as our parameter</span>...
$$ds=\sqrt{
\left(\frac{d x}{d x}\right)^2+\left(\frac{d(x+1)}{d x}\right)^2
}dx=\sqrt 2\,dx$$
<p>$$\begineq 
\int_{C_1} (x+y)\,ds &= \int_0^1 (x+(1+x))\sqrt 2\,dx\\
&=\sqrt 2 \int_0^1 (1+2x)\,dx=\sqrt 2\left[  (x+x^2)\right]_0^1=2\sqrt 2.

\endeq
$$

Combining these two results
$$\int_C(x+y^2)ds=\int_{C_2}(x+y^2)ds+\int_{C_1}(x+y^2)ds=\color{red}2\sqrt 2 -2.$$



<div class="justme">
<h4>Which way?</h4>
<p>Does it matter which way you traverse the path?  Should it matter?
...
<p>An increment of arclength, $ds$, is always positive, so
$$\int_{-C}f(x,y)\,ds = \int_C f(x,y)\,ds$$
</div>

<h3>Line integrals - 3D</h3>
<p class="show def">
$$\begineq
\int_Cf(x,y,z)\,ds&=\int_{t=a}^bf(\myv r(t))\,ds\\
&=\int_a^bf(x(t),y(t),z(t))\sqrt{
\left(\frac{d x}{d t}\right)^2+\left(\frac{d y}{d t}\right)^2
+\left(\frac{d z}{d t}\right)^2
}\,dt
\endeq
$$

<h3>Parameterizing a line segment</h3>
<p class="show">Many problems will ask you to "integrate along the straight line segment from point $P_1$ to $P_2$".

<p>A quick way to  parameterize such a line segment earlier in the course:  
<ul><li>Let $\myv r_1$ be the position vector pointing to $P_1$ and 
<li>$\myv r_2$ be the position vector pointing to $P_2$
<li>A parametric equation for the directed line segment from $P_1$ to $P_2$ is:
$$\myv r(t)=\color{blue}{(1-t)}\color{black}{}\myv r_1+\color{blue}{t}\color{black}{}\myv r_2=\myv r_1+t(\myv r_2-\myv r_1)$$
with $0\leq t \leq 1$.
</ul>
<p>E.g. the line segment from (1,2,1) to (1,1,3) is:
$$\begineq\myv r(t)&=(1-t)\langle 1,2,1\rangle+t\langle 1,1,3\rangle\\
&=\langle 1,2,1\rangle +t\langle 1-1,1-2,3-1\rangle\\
&=\langle 1,2-t,1+2t\rangle=\uv i+(2-t)\uv j+(1+2t)\uv k
\endeq
$$

<h3>To Do</h3>
<ul class="todo">
<li>mv06.2.Scalar line integrals
</ul>





<h4 class="handout">Image credits</h4>
<p class="handout"><a href="https://www.flickr.com/photos/85591545@N00/3906756290">Martin</a>



<?php include "../../classes/3.h" ?>


