<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Vector Line Integrals [6.E]
</title>
<meta name="week" content="13">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
<i>Vector</i> Line Integrals 
</h1>
<p class="show">See <a href="https://openstax.org/books/calculus-volume-3/pages/6-2-line-integrals#fs-id1167793431907">Strang, section 6.2</a>

<p class="show">...are useful in calculating the <b>work</b> $\approx \sum \myv F_i\cdot \Delta \myv s_i$ when moving in a force field.
<ul>
<li>At a location $\myv r_i$...
<li>There is a force $\myv F_i(\myv r_i)$
<li>Acting on a particle
<li>Which moves a distance $\Delta s_i$ (arclength) along a path
</ul>

<p class="show"><img src="0g/13.2.forcefield.jpg" class="rightalign">
Hollywood version of <b>fighting a force field!!!</b><br clear="both">

<h3></h3>
<p class="show">This is no longer science fiction:
Now, in the 21st century, even
<b>young children</b> are able to routinely press forward as they <b>face down  invisible force fields!!!</b>

<p><img src="0g/13.2.climb.jpg"><br>
<br><br><br>...such as the gravitational force field near Earth's surface
$$\myv F_g(x,y,z)=-mg\uv k.$$


<h3>Calculating the work</h3>
The <b>work</b>, $\Delta W$, (units of energy are joules:  1 J = 1 Newton$\cdot$meter)  done <b>by</b> a force, $\myv F$ acting <b>on</b> a particle, which moves a distance $\Delta \myv s$:
$$\Delta W = \myv F \cdot \Delta \myv s$$

<p>
In a force <i>field</i> the force acting on a particle, $\myv F(\myv r)=\myv F(x,y,z)$, depends on position.

<p><img src="0g/13.2.arcdiagram.jpg" class="rightalign">
A particle moves along the curve $C$ specified by $\myv r(t)$ shown.
The position is given as $P_i=\myv r(t_i)$. In one time-step, it moves a 
distance $\Delta \myv s_i=\myv r(t_i)-\myv r(t_{i-1})$.

<p>The work done <b>by the field</b> is
$\Delta W_i=\myv F(x_i,y_i,z_i)\cdot \Delta \myv s_i$, so...
$$W\approx\sum_{i=1}^n\myv F(x_i^*,y_i^*,z_i^*)
\cdot\uv T(x_i^*,y_i^*,z_i^*)\Delta s_i$$
where $\Delta s_i$ is the distance moved in interval $i$, and $\uv T$ is the unit tanget vector.

<p class="show incremental def">In the limit $n\to\infty$ the sum becomes an integral, the <b>line integral of $\myv F$ along $C$</b>:
$$W=\int_C\myv F\cdot\uv T\,ds=\int_C \myv F\cdot d\myv r = \int_{t=a}^b\myv F(t)\cdot \myv r'(t)\,dt.$$

<h3>Sign convention for work</h3>
<p>We tend to think about the energy (=work) needed from the point of view of
 a child / a car / 
the starship Enterprise  as it <b>fights against a force field</b>.  This is just (-1) $\times$ the <b>work that the force field does on</b> the child / car / Enterprise.  

<p>
So, to avoid having to carry a negative sign around through all these calculations, we'll take the point of view of the "Klingons" who have to pay the energy bill when their force field pushes against the starship Enterprise.

<div class="big show incremental">
Stubborn Klingon!  You <b>do not</b> need to carry around such a negative sign!<br>
<img src="0g/13.2.klingon.jpg"><br>
</div>
<p class="justme"><i>A man dressed as a Klingon carrying a negative sign around.  Maybe he's mixed up about his point of view on work?</i>




<h3></h3>

<p class="show">
$$dW = \myv F \cdot d\myv s=\myv F\cdot\myv r'(t)\,dt
=|\myv F| \,|\myv r'(t)| \cos \theta \,dt.$$

Positive, zero, negative dot products<br>
<img src="0g/13.2.posneg.jpg" class="big">

<h4>Positive, negative, or zero?</h4>
<p class="show"><img src="0g/13.2.posneg2.jpg" class="rightalign">
$\int_{C_1}\myv F\cdot d\myv r\ \ $?

<p>$\int_{C_2}\myv F\cdot d\myv r\ \ $?
<h3>To do</h3>
<ul class="todo">
<li>mv06.2.Visual...  izing Vector Line Integrals
</ul>


<h3>Example</h3>
<p class="show">Find the work done by the vector force field
$$\myv F = (y-x^2)\uv i + (z-y^2)\uv j +(x-z^2)\uv k$$

<p><img src="0g/13.2.t123.jpg" class="rightalign">
...over the oriented curve<br><br>
$\myv r(t)=t\uv i +t^2\uv j+t^3\uv k$
<br><br>
from $(0,0,0)$ to $(1,1,1)$.

<p>$$W=\int_{t=0}^1\myv F(t)\cdot \myv r'(t)\,dt.$$


<h3>Computing example</h3>
<p class="show">Find the work done by the vector force field
$$\myv F = x\uv i +z \uv j + y\uv k=P\uv i + Q\uv j+R\uv k$$


<p><img src="0g/13.2.sincos.jpg" class="rightalign">
...over the oriented curve<br><br>
$\myv r(t)=\cos t \uv i +\sin t \uv j +t\uv k$
<br><br>
for $0\leq t \leq \frac\pi 2$.

<p>$$W=\int_{t=0}^0\myv F(t)\cdot \myv r'(t)\,dt.$$

<h2>Line integral in differential form</h2>

<p class="show incremental def">In the limit $n\to\infty$ the sum becomes an integral, the <b>line integral of $\myv F$ along $C$</b>:
$$W=\int_C\myv F\cdot\uv T\,ds=\int_C \myv F\cdot d\myv r = \int_{t=a}^b\myv F(t)\cdot \myv r'(t)\,dt.$$

<p>
A vector field can always be expressed abstractly in terms of its $x$, $y$, and $z$ components:
$$\myv F(x,y,z)=P(x,y,z)\uv i +Q(x,y,z)\uv j +R(x,y,z)\uv k.$$
[$P$, $Q$, $R$ is a way of avoiding the double meaning of $F_x$, $F_y$, $F_z$...]
<p>We've been solving these line integrals, by parameterizing the curve, and using the last expression: 
$$\int_{t=a}^b\myv F(t)\cdot \myv r'(t)\,dt.$$
<img src="0g/13.2.lid1.jpg" class="big">



<p>But the next-to-last expression
$$\int_C \myv F\cdot d\myv r,$$
can also be used to calculate line integrals.

<p>The vector differential $d\myv r$ means:
$$d\myv r\equiv dx\,\uv i +dy\,\uv j+dz\,\uv k.$$


<p><img src="0g/13.2.lid2.jpg" class="big">

<p>Clearer(?) to write this as:
$$\int_C\myv F\cdot d\myv r=\int_c P\,dx +\int_c Q\,dy +\int_c R\,dz.$$



<h3 id='manypaths'>Example</h3>
<p class="show">$$\myv F(x,y)=x\uv i+x^2\uv j.$$
where $P(x,y)=x$ and $Q(x,y)=x^2$.
<p><img src="0g/13.2.3paths.jpg" class="rightalign">
Three paths from $(-1,0)$ to $(0,1)$.

<p><img src="0g/13.2.3paths1.jpg" class="big">
<p><img src="0g/13.2.3paths2b.jpg" class="big">
<!--<p><img src="0g/13.2.3paths2.jpg" class="big">-->
<p><img src="0g/13.2.3paths3c.jpg" class="big">
<!--<p><img src="0g/13.2.3paths4.jpg" class="big">-->
<p><img src="0g/13.2.3paths3b.jpg" class="big">

<h3>To Do</h3>
<ul class="todo"><!--<li>Group work 2: Computing Vector Line Integrals-->
<li>Compute the line integral of $\myv F=x^2\uv i+y^4\uv j+z^6\uv k = P\uv i+
Q\uv j +R\uv k$ over the path
$\myv r_1: x=t^3, y=t, z=t^2, 0 \leq t \leq 1$.
<li>Compute the line integral of the same vector field $F$, but this time over the path $\myv r_2 : x=y=z=t, 0\leq 0 \leq 1$. 
</ul>



<h4 class="handout">Image credits</h4>

<p class="handout"><a href="https://www.flickr.com/photos/jgoforth/3073368058">jonathan goforth</a>,
<a href="https://www.flickr.com/photos/perry_g/1316452852">Perry G</a>

<?php include "../../classes/3.h" ?>