<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Vectors [9.2]
</title>
<meta name="week" content="2">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>


<h1>Vectors [9.2]</h1>
<p class="show"><img src="0g/9.2.kayak.jpg"  class="big">

<p class="show why">Sure, many <b>physical quantities</b>--such as the
velocity of the kayak above--have both a magnitude and a
<b>direction</b>.  <br><br>

But <b>mathematically</b>, vectors are key in 3+ dimensions to
<i>generalizing</i> ideas about <b>lines and parallelism</b> and
<i>generating</i> new concepts such as <b>gradient</b> and <b>swirliness</b>.

<h3>Vectors and scalars</h3>

<p>Two vectors are <b>equal</b> if they have the <b>same direction</b>
and the <b>same magnitude</b>.  (Their positions don't matter.)<br>
<a href="https://www.geogebra.org/3d/snkqa7hq"><img src="0g/9.2.equal3dvectors.jpg"></a><br>

<p class="show">A <b>scalar number</b> is, for our purposes, usually
the same as a <b>real number</b>.

<p>A scalar number can be used to represent a quantity that does *not*
have a direction.  <br><br>

For example: time $t$, temperature $T$, the probability that a fish in
the ocean is a shark, $p_\text{shark}$.

<h4 >Notation</h4>
<p>Scalar quantities are typically typeset in italics:
$$\nonumber t, T, p_{\text shark}$$
<p>Vector quantities are typeset either in bold:
$$
\nonumber
\bf u, \bf v, \bf F
$$
and/or with an arrow on the top:
$$
\nonumber
 \myv u, \myv v, \myv F
$$

<p><span class="tip"><b>I recommend</b> that you always write an arrow
over a letter to distinguish a vector from a scalar, when you're
writing mathematics out by hand.  </span>

<p>In physics <ul>
<li>"Speed", $v$, is a scalar.  It can have a value
like 30 mph or 6 ft / sec and is always a positive number.

<li>"Velocity", $\myv v$, is a vector quantity.  The magnitude of
velocity, $|\myv v|=v$, is speed. The velocity might have a magnitude
like 4 meters / sec <i>and</i> a direction, such as north-east.
</ul>



<h3>Components</h3>

<p class="show"><img src="0g/9.2.compy.jpg" class='rightalign'>The
vector, $\myv a$, is drawn in a 2-d Cartesian coordinate system.  The
difference between the $x$-coordinate of its tip and of its base is
$\Delta x = a_1$.  The difference between the $y$-coordinate of its
tip and of its base is $\Delta y = a_2$. We write:

$$\myv a=\langle a_1,a_2\rangle$$

where

<ul>
<li>$a_1$ (also written $a_x$) is the "$x$-component" of the vector $\myv a$, 
<li>$a_2$ (also written as $a_y$) is the "$y$-component" of $\myv a$.
</ul>

<p>All of these vectors have the same <b>components</b>: $\langle 3,2\rangle$.
<p class="show"><img src="0g/9.2.vector32.jpg">
<p>And they all have the same <b>magnitude</b> and <b>direction</b>.
<p class='def'>A vector in <b>standard position</b> has its tail at the origin

<p class="todo"> What do you notice about the one vector in standard
position in relation to the point at the tip of the vector?


<p class="todo"> <a
href="https://activecalculus.org/multi/S-9-2-Vectors.html#A-9-2-1">Classroom
positions / vectors</a> (Tanner study).<br> Just do $\myvv{OB}$ and
$\myvv{AB}$.

<p class="def show incremental">Two vectors $\myv u=\langle u_1,u_2
\rangle$ and $\myv v=\langle v_1,v_2\rangle$, are equal, if and only
if their corresponding components are equal: $u_1=v_1$ and $u_2=v_2$.

<h3>Scalar multiplication</h3>

<p class="show"><img src="0g/9.2.scalarmult.jpg">

<p class="show">If $c$ is a scalar, and $\myv v$ is a vector, then the
<b>scalar multiple</b> $c\myv v$ is the vector with:

<ul>
<li> a length of $|c|$ times the length of $\myv v$, and
<li> a direction which is:
  <ul>
  <li>the <b>same</b> as $\myv v$ if $c \gt 0$, or
  <li><b>opposite</b> $\myv v$ if $c \lt 0$, or
  </ul>
</ul>





<h4>
Scalar multiplication (components)</h4>

<p><img src="0g/9.2.vectorcomponents.jpg" >  

<p>
$$\myv a = \myc{a_1,a_2};\ \ \ \ c\myv a = \myc{ ca_1,ca_2 }.$$

<div class="todo"> <img src="0g/9.2.parallel.jpg"><br>
<ul>
<li>For each vector...Which other vectors is it parallel to?
<li>What relationship
(involving scalar multiplication) must exist between two vectors $\myv
a$ and $\myv b$ iff [if and only if] they are <b>parallel</b>?
</div>



<h3>Adding vectors</h3>

<p class="show"><img src="0g/9.2.vectoraddition.jpg">

<ol>
<li>If $\myv u$ and $\myv v$ are vectors,
<li>positioned such that the tale of $\myv v$ is at the
tip of $\myv u$,

<li>then the <i>sum</i> $\myv u + \myv v$ is the vector from the
tail of $\myv u$ to the tip of $\myv v$.
</ol>

<h3>Vector subtraction</h3>
<p class="show">The idea is...
$$\nonumber
\myv u - \myv v \equiv \myv u + (-1)\myv v
$$
<p class="show"><img src="0g/9.2.vectorminus.jpg">

<h4>Vector addition and subtraction (components)</h4>
<p class="show"><img src="0g/9.2.addem.jpg"><br>
$$ \myv a + \myv b = \langle a_1+b_1, a_2+b_2 \rangle $$
<p>Subtraction:
$$ \myv a - \myv b = \langle a_1-b_1, a_2-b_2 \rangle $$
<p>All these results generalize to 3-d.

<p class="todo"><a href="https://activecalculus.org/multi/S-9-2-Vectors.html#A-9-2-5">Vector and scalar multiple addition</a>

<h3>Length</h3>
<p class="show">...of a vector in terms of its components.
<p class="show">Length $|\myv a|$ (a scalar number) of the 2-d vector $\myv a=\langle a_1,a_2 \rangle$:
$$|\myv a|=\sqrt{a_1^2+a_2^2}.$$

<p class="show">Length  of the 3-d vector $\myv a=\langle a_1,a_2,a_3 \rangle$:
$$|\myv a|=\sqrt{a_1^2+a_2^2+a_3^2}.$$



<h3>Standard basis vectors</h3>
<p class="show">The 3 standard "basis vectors" in a Cartesian coordinate system are:
$$\myv i \equiv \langle 1,0,0 \rangle; \ \ 
\myv j \equiv \langle 0,1,0 \rangle; \ \ 
\myv k \equiv \langle 0,0,1 \rangle$$
<p class="show"><img src="0g/9.2.basis.jpg">

<p>Notice that each of these vectors has a <b>length of 1</b>. That
is, they are <b>unit vectors</b>.

<p>I like to indicate unit
vectors with the caret ('^') symbol up top (replacing the arrow):

$$\uv i \equiv \langle 1,0,0 \rangle \equiv \uv x; \ \ 
\uv j \equiv \langle 0,1,0 \rangle \equiv \uv y; \ \ 
\uv k \equiv \langle 0,0,1 \rangle\equiv \uv z$$

<p>Another way of writing a vector: As a sum of scalars times basis vectors:
$$\langle 0.4, 0, -2 \rangle \equiv 0.4\uv i -2\uv k$$

<h3 id='unit'>Find the unit vectors</h3>
<p>Find the unit vector...
<ul><li> that  points in the direction $\langle 8, 0, 0 \rangle$.
<li> that points in the direction $\langle 5,5,0 \rangle$.
<li> that is <i>opposite</i> to the direction $\langle 1,-1,3 \rangle$.
</ul>

<p class="todo">Time permitting: <a href="https://activecalculus.org/multi/S-9-2-Vectors.html#A-9-2-7">Unit vectors</a>

<div class="key"><h4>Parallel</h4>

<p>Two vectors, $\myv a$ and $\myv b$, are <b>parallel</b> if $\myv b$
is a <i>scalar multiple of $\myv a$</i>.  That is:

$$\myv b = c\myv a,$$

where $c$ is any non-zero real number.
</div>

<p class="def show">If $\myv a$ is a vector, then a unit vector,
pointing in the same direction as $\myv a$, but with a length of 1
unit is:

$$\uv a = \frac {\myv a}{|\myv a|}\equiv\frac{1}{a}\myv a.$$

<p>For example, if $\myv a=\langle 5,5,0\rangle$, then
$a=\sqrt{5^2+5^2+0^2}=\sqrt{50}$, so

$$\uv a= \frac {\myv a}{a}= \frac {\myc{5,5,0}}{\sqrt{50}}=
\myc{ \frac{5}{\sqrt{50}},\frac{5}{\sqrt{50}},0}.$$

Checking the length of $\uv a$:

$$\begineq
|\uv a| &=\sqrt{\frac{5^2}{(\sqrt{50})^2} +\frac{5^2}{(\sqrt{50})^2} + 0^2}\\
&=\sqrt{\frac{25}{50} +\frac{25}{50}}=\sqrt{\frac{50}{50}}=1
\endeq$$

<p class="justme">Using the vectors (not necessarily unit vectors)
$\myv b = \langle 1,0\rangle$ and $\myv c = \langle 1,2\rangle$, try
to express and $\myv a$ as $r\myv b + s\myv c$.



<?php include "../../classes/3.h" ?>