<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Dot product (scalar product) [9.3]
</title>
<meta name="week" content="2">
<meta name="nolink" content="">
<?php include "../../classes/2.h" ?>

<h1>Dot product [9.3]</h1>
<p class="show"><img src="0g/9.3.dots.jpg">
<p class="show"><b>No, no</b>, not those kind of dots...

<h3>How effective is a force at  moving a cart along a road?</h3>
<p class="show">Consider pushing a cart, with the same force, $F=100N$, (the same force as the weight of a 10 kg bowling ball)
<p>but in different directions: (The <span style="color:blue">blue vector</span> is the direction we'd like the cart to move: along (parallel to) the road.)<br>
<img src="0g/9.2.pushcart.jpg"><br>
<span class="caption"><a href="https://flickr.com/photos/beegee49/27849650419">Brian Evans</a></span>
<ul><li>parallel to the road;
<li>at right angles to the road;
<li>at some intermediate angle $\theta$ (say $45^{o}$) to the road.
</ul>
<p>Which direction is most effective at moving the cart? <br><img src="0g/9.2.fdiag.jpg"><br>
<br>We'd like to multiply the force by some function of the angle that is greatest when $\theta=0$ and least (actually zero) when $\theta=\pi/2$
and "somewhat" effective when $\theta=\pi/4$.
<br><br><br>




<p>How about:
$$F\cos\theta??$$

<p class="def">$\cos \theta$ is a measure of <b>how closely aligned</b> two directions are (given by the directions of two vectors).</p>
<p>I'm trying hard not to say parallel...


<h3>How much energy?</h3>
<p class="show"><img src="0g/9.3.worker.jpg" class="big">
<p class="show">"Work" in physics is the energy expended when a constant force $\myv F$ acts to displace an object by a vector displacement $\myv d$.
It seems like this "Work" should depend on
<ul><li>The force, $F$,
<li>how far we move it: the displacement, $d$,
<li>and how parallel $\myv F$ and $\myv d$ are to each other, $\cos\theta$.
<p><img src="0g/9.3.work.jpg"><br>
Work is the product of the displacement and the component of the force along the direction of the displacement.
$$\nonumber \text{Work}=F_d d = (F \cos \theta) d=Fd\cos\theta.$$
<p>We shall see shortly that this can be written as
$$\text{Work}=\myv F \cdot \myv d.$$
[Units: Newton-meter = Joule]

<p class="todo">So... If the force is at right angles to the displacement no work is done?  Can you think of an example?



<h3>Component</h3>
<p class="show"><img src="0g/9.3.component.jpg">
<p class="show">The <b>component</b> of $\myv b$ along $\myv a$ is a scalar:
$$\text{comp}_{\myv a}\myv b = b \cos \theta.$$
...also called the <i>scalar projection</i>.

<h3>Projection</h3>
<p class="show"><img src="0g/9.3.projection.jpg">
<p class="show">The <b>vector projection</b> of $\myv b$ along  $\myv a$ is a <b>vector</b> which points along $\myv a$ and has a length of $b\cos\theta=\text{comp}_{\myv a}\myv b$.


<p class="todo">
Get the 09.3.Projections activity from the handouts folder.  Work on the first two parts.


<h3 id="dotp">The dot product</h3>
<p class="show">...of two non-zero vectors $\myv a$ and $\myv b$ is defined as
$$\myv a \cdot \myv b \equiv |\myv a| |\myv b| \cos \theta$$
where $\theta$ is the <b>smallest possible angle</b> between the vectors when they're drawn with the same initial point.  That is, $0 \leq \theta \leq \pi$.



<p class="center">
<img src="0g/9.3.thetasigns.jpg">

<p>Two vectors are <b>orthogonal</b> (which is a general way of saying "perpendicular") if and only if their dot product is zero.
$$\myv a \cdot \myv b=0 \ \ \Leftrightarrow \ \ \myv a \perp \myv b.$$




<h3>Component form</h3>
<p class="show">The dot product of $\myv a=\langle a_1,a_2,a_3\rangle$ and
$\myv b=\langle b_1,b_2,b_3\rangle$ can be written in terms of their components:
$$\myv a \cdot \myv b = a_1b_1+a_2b_2+a_3b_3.$$

Examples:
<p>
$$\nonumber 
  \langle 2,4 \rangle \cdot \langle 3,-1\rangle = 2(3)+4(-1)=2$$
<p>
$$\nonumber 
  \langle -1, 7, 4\rangle \cdot \langle 6,2,\frac 12\rangle =
-1(6)+7(2)+4(\frac 12)=10$$
<p>
$$\nonumber (\myv i + 2\myv j -3\myv k)\cdot(2\myv j -\myv k)=1(0)+2(2)-3(-1)=7$$
<p class="justme">Could also multiply out the product in that last one, and show how orthogonality is used.


<h3>Properties of the dot product</h3>
<p class="show"><img src="0g/9.3.properties.jpg" class="big">


<h3>Components and Projections re-visited</h3>


<h4>Component</h4>
<p class="show"><img src="0g/9.3.component.jpg">
<p class="show">The <b>component</b> of $\myv b$ along $\myv a$ is a scalar:
$$\text{comp}_{\myv a}\myv b = b \cos \theta = \frac{|\myv a|}{|\myv a|}
 |\myv b| \cos \theta = \frac{\myv a \cdot \myv b}{|\myv a|}.$$



<p class="show"><img src="0g/9.3.projection.jpg">
<p class="show">The <b>vector projection</b> of $\myv b$ along  $\myv a$ is a <b>vector</b> which points along $\myv a$ and has a length of $b\cos\theta=\text{comp}_{\myv a}\myv b$.

<p>We can construct a vector, $\uv{a}$ of unit length pointing in the $\myv a$ direction like this:

$$\uv{a}=\frac{\myv a}{|\myv a|}$$



<p>The vector projection is:
$$\text{proj}_{\myv a}\myv b = b\cos\theta \uv a = \frac{\myv a \cdot \myv b}{|\myv a|^2}\myv a.$$

<div class="todo">
<h3>To do</h3>
<ul>
<li>The Regular Hexagon (see the handouts folder)
</ul>
</div>




<h4 class="handout">Image credits</h4>
<p class="handout"><a 
href="http://www.flickr.com/photos/johnragai/8584968505/">John Ragai</a>,
<a href="https://www.flickr.com/photos/wallyg/3977179310">Wally Gobetz</a>
<?php include "../../classes/3.h" ?>