<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Lines and planes [9.5]
</title>
<meta name="week" content="3">
<meta name="nolink" content="">
<?php include "../../classes/2.h" ?>


<h1>Lines and planes [9.5]</h1>
<p class="show center"><img src="0g/9.5.gaudi.jpg" class="big"><br>
<i>Casa Batll&oacute;</i> by Antoni,  <i>"enemy of the straight line"</i> Gaud&iacute;
and Josep Maria Jujol.



<h2>Vector form of a line</h2>
<p class="show">It seems like "two points determine a line" should work in three dimensions as well as in 2-d.  But we may have hit a dead end with $y=mx+b$:  It's not obvious what the "slope" is in 3-d.  It's certainly not a scalar number.

<p>In the preview activity, you became acquainted with a new way of describing a line, that still works in 2-d but generalizes to 3-d more easily.  The line that passes through 2 points $P$ and $Q$...


<p><img src="0g/9.5.bline.jpg"><br>
<ul>
<li>$\myvv{OP}=\myv r_0$ is the <b>position vector</b> of a point on the line with tail at the origin, and head at point $P=(x_0,y_0,z_0)$.
<li>$\myvv{PQ}\equiv \myv a$ is the <b>difference vector</b>, which runs from $P$ to some other point $Q$, both on the desired line.
<li>$\myv v=\langle a,b,c\rangle$ is the <b>direction vector</b>, and it is parallel to $\myv a$.

<li><i>Any</i> vector parallel to $\myv v$ can be expressed as some scalar multiple $t\myv v$ of $v$.
</ul>
<p>So, using vector addition, we can express the set of points on the line in parametric form (as a function of the <i>parameter</i> $t$) as:

<p class="show def incremental"><b>Vector form of a line</b>
$$\myv r(t)=\myv r_0 + t\myv v$$

<ul><li>If you know any two points on a line, say $P$ and $Q$, you can use the difference vector $\myvv{PQ}$ as your direction vector.
<li>Even in 2-d, we could use this form to describe vertical lines, e.g. using $\myv v=\langle 0,1\rangle$, something we can't do with $y=mx+b$.
</ul>


<p class="todo">Do <a href="https://activecalculus.org/multi/S-9-5-Lines-Planes.html#A_9_5_2">Activity 9.5.2. Parallel lines?</a>

<h3>The parametric equations of a line</h3>
<p><img src="0g/9.5.linet.jpg">
$$\begineq \myv r(t) &= \myv r_0 + t\myv v \\

&= \langle x_0,y_0,z_0\rangle+t\langle a,b,c\rangle \\
\langle x(t), y(t), z(t)\rangle&= \langle x_0+ta, y_0+tb, z_0+tc \rangle
.\endeq
$$

<p>We know that a 3-d vector equation is really *3* equations.  In order for two vectors to be equal, their $x$-, $y$-, and $z$-components must each be equal. The three equations here are:
<p class="def show incremental"><b>Parametric equations for a line</b>
$$x(t)=x_0 +at;\ \  y(t)=y_0 +bt;\ \  z(t)=z_0 +ct$$




<p>Each of these 3 can be solved for $t$, e.g. $\frac{x(t)-x_0}{a}=t$.  We'll have three expressions each equal to $t$, so we can set them mutually equal:
<p class="def show incremental">
<b>Symmetric equations of a line</b>
$$\frac{x-x_0}{a}=\frac{y-y_0}{b}=\frac{z-z_0}{c}.$$

<ul><li>Notice that $a$, $b$, $c$ are the components of $\myv v$, the direction vector parallel to the line $L$.
<li>These are something like the point-slope form of the equation of a line in 2-d.  Indeed, the first two equations for a 2-d line can be arranged like this:
$$\frac{y-y_0}{x-x_0}=\frac ba \equiv m.$$


<p class="todo"><a href="https://activecalculus.org/multi/S-9-5-Lines-Planes.html#A_9_5_3">A 9.5.3 Is a point on the line?</a>

<h3>Example</h3>
<p class="show">Consider two lines:
$$\nonumber x=1+t;\ \ y=-2+3t;\ \ z=4-t$$
and 
$$\nonumber x=2s;\ \ y=3+s;\ \ z=-3+4s$$
<p><i>Do they intersect?</i>
<p><i>Solution:</i>
If they intersect at some common point (x,y,z), then that point should be a simultaneous solution in $s$ and $t$ to these three equations:
$$1+t=2s;\ \ -2+3t=3+s;\ \ 4-t=-3+4s$$

<h3></h3>
<p class="show">Those same two lines:
$$\nonumber x=1+t;\ \ y=-2+3t;\ \ z=4-t$$
and 
$$\nonumber x=2s;\ \ y=3+s;\ \ z=-3+4s$$
<p><i>Are the lines parallel?</i>
<p><i>Solution:</i>
Re-arrange the equations into the form of the symmetric equations (solve each equation for $t$...or for $s$...) to find the components (denominators) of a vector parallel to each line.

<p>Lines which are not parallel to each other, and do not intersect are called <b>skew lines</b>.

<div class="justme">
<h3>To do</h3>
<ul class="todo"><li>Lines in the plane</li>
</ul>
</div>

<h2>Planes</h2>
<p class="show">
A plane can be determined by
<ul>
<li>a point $P_0$ in the plane and
<li>
 a <b>normal vector</b>, $\myv n$, which is <b>orthogonal</b> (normal) to the plane.
</ul>

<p>In pictures...<br>
<img src="0g/9.5.plane.jpg" class="rightalign">
<ul>
<li>$\myv r_0=\langle x_0, y_0, z_0 \rangle$ is a vector pointing at $P_0$.
<li>$\myv n = \langle\color{blue}a, b, c\color{black} \rangle$ is the normal vector.
<li>$\myv r=\langle x,y,z\rangle$: Some point in the plane, which must satisfy the condition that $\myv r -\myv r_0$ is perpendicular to $\myv n$:
</ul>

<p>With these definitions:
<p class="show def incremental"><b>Equations of a plane</b>:
$$\begineq \text{"vector" eq:}\ \ \ \ 0&=\myv n \cdot (\myv r-\myv r_0)\\
&=\langle \color{blue}a,b,c\color{black}
\rangle \cdot \langle x-x_0,y-y_0,z-z_0\rangle\\
\text{"scalar" eq:}\ \ \ \ 0&=\color{blue}a\color{black}
(x-x_0)+\color{blue}b\color{black}(y-y_0)+\color{blue}c\color{black}(z-z_0)\rangle\\
\endeq
$$
</ul>





<p>Pushing the equation above one step further, let's expand the products and add up all the constant terms calling their sum $k=\myv n\cdot\myv r_0$:

$$\begineq
ax_0+by_0+cz_0&=ax+by+cz\\
k&=ax+by+cz
\endeq
$$

<p>So that if you see an equation for a plane such as:
$$56=7x-3y+2z,$$
You can just read off the components of a normal vector to the plane as:
$$\myv n=\langle 7,-3,2 \rangle.$$

<p class="todo">Do <a href="https://activecalculus.org/multi/S-9-5-Lines-Planes.html#ex-9-5-WW-plane_angle">Problem 7 - Angle between planes</a>.

<h4>Example</h4>
<p class="show">A plane intersects the $x$-, $y$-, and $z$-axes at the points shown.  Find the equation of the plane.

<p class="show"><img src="0g/9.5.ex4.jpg" class="rightalign">
<p>First find the normal to the plane.<br>
[Find two vectors that are in the plane, and then take their cross product.]

<p>Then find the equation for the plane.
[Take as $\myv r_0$ any of the three points shown.]
<br clear="both">
<p>Find the surface normal:<br>
<img src="0g/9.5.ex4b.jpg" class="rightalign">
$\myv a=\langle 0,-4,3 \rangle$<br>
$\myv b=\langle 6,-4,0 \rangle$<br>
$\myv a \times \myv b=12\uv i+18\uv j+24\uv k$
<p>Let's take for the normal vector $\frac16$ of the the vector above (just because we'll have smaller numbers to keep track of...):
$$\myv n=2\uv i+3\uv j+4\uv k =a \uv i + b \uv j +c \uv k$$
<p>Picking $(0,4,0)$ as the point in the plane, then the prescription above is...
$$\begineq 0 &=a(x-x_0)+b(y-y_0)+c(z-z_0)\\
&=2(x)+3(y-4)+4(z) = 2x+3y-12+4z\\
\endeq$$
So, the equation for the plane can be written as:
$$2x+3y+4z = 12.$$
where a normal vector to the plane was $\myv n=\myc{2,3,4}$.
<p>Notice that when the equation for a plane is written in this form that
 you can <b>read off</b> the components of the normal vector from the coefficients of $x$, $y$, and $z$!
<!--
<h3 id="todo">To do for next class</h3>
<ul class="todo">
<li>Assignment 9.5 on WebAssign.  This is not a short one.  Please keep track of the time you spend.
<li>Read 9.6
<li>Reading questions on 9.6
</ul>
-->
<div class="todo">
<p>Using algebra, find the intersection of the planes $x+2y+z=4$ and $4x+2y+3z=12$ in parametric form: For example, you could...

<ol><li>
solve the first equation for $z$ (which depends on $x$ and $y$), 
<li> substitute $z$ into the second equation and solve it for $y$ in terms of $x$, that is $y(x)$.
<li> go back to your equation for $z(x,y)$.  Substitute in your equation $y(x)$ to find z(x).  
</ol>

Now you can express the coordinates of your line as $(x, y(x), z(x))$.  This is a parametric expression for the line, in terms of a single parameter $x$.

<p>Confirm by graphing the two planes and the line...
</div>
<h4 class="handout">Image credits</h4>
<p class="handout"><a href="http://www.flickr.com/photos/vgm8383/2789863560">vgm8383</a>
<?php include "../../classes/3.h" ?>