<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Curvature [09.8]
</title>
<meta name="week" content="5">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h2>Curvature</h2>
<p class="show">The question: How to describe "curvature" in a useful way?
<p>The curvature should be... 
<ul>
<li>a scalar number which should be
<li>large when the path is changing direction "quickly",
<li>small when the path is more nearly straight.
</ul>

<h3></h3>
<p>
<img src="0g/10.3.acceleration.jpg" class="big">
The velocity vector $\myv r'(t)$ is tangent to the curve at each position on the curve.  So, as the direction of a curve changes,the velocity vector will also change.  So our first attempt to quantify the idea of "curvature" might be to look at at the <i>change of the velocity vector</i>, that is,  the <b>acceleration</b>:
$$\myv a (t)= \frac{d\myv r'(t)}{dt}$$

<p>Can you think of a situation in which the acceleration is not zero, even though the curvature of the path is zero?
<p class="justme">Acceleration in a straight line.

<p>The unit tangent 
$$\uv T(t)=\frac{\myv r'}{|\myv r'|}$$ is a vector quantity that is always the same length, no matter what the velocity $\myv r'$ is. So, what about 
$$\frac{d\uv T(t)}{dt}?$$ 
What's the problem with that?

<p>In this picture, the unit tangent vectors are evenly spaced along the curve:<br>
<img src="0g/10.3.unittangent.jpg"><br>
Does this suggest a useful way to think about curvature?


<p>...We should look at how $\uv T$ changes with respect to changes in the <i>arclength</i>, $s$, (instead of w.r.t time $t$):
<p class="show incremental def">The <b>curvature</b>, $\kappa$, is
$$\kappa = \frac{d\uv T}{ds},$$
the rate of change of unit tanget vector direction with respect to arclength.

<p>By the chain rule, this is
$$\kappa = \left|\frac{d\uv T}{dt}\right| \frac{dt}{ds} =\frac{\left|\frac{d\uv T}{dt}\right|}{ \frac{ds}{dt} }=
 \frac{|\uv T'(t)|}{|\myv r'(t)|} .$$

<h4>Curvature of a circle</h4>
<p class="show">It seems like a circle ought to have a <b>constant</b> curvature.  Let's see...
<p>Circle of radius $a$:
$$\nonumber\myv r(t)=a \cos t\uv i + a \sin t\uv j.$$
<p>$$\nonumber\myv r'(t)=-a\sin t \uv i + a \cos t\uv j.$$
<p>$$\begineq\nonumber|\myv r'(t)| &= \sqrt{(-a\sin t)^2+(a\cos t)^2}\\
  &=\sqrt{a^2\sin^2 t+a^2\cos^2 t}\\
  &=a\sqrt{\sin^2t+\cos^2t}=a\endeq$$.$$
<p>$$\nonumber\uv T(t) = \myv r'(t)/|\myv r'(t)|=\myv r'(t)/a=- \sin t \uv i+\cos t\uv j.$$
<p>$$\nonumber\uv T'(t) =- \cos t \uv i - \sin t\uv j.$$
<p>$$\nonumber|\uv T'| = \sqrt{(-\cos t)^2 +(-\sin t)^2}=\sqrt{\cos^2 t+\sin^2 t} = 1.$$

<p>$$\kappa = \frac{|\uv T'(t)|}{|\myv r'(t)|}=\frac{1}{a}.$$

<ul>
<li>The curvature $1/a$ is constant, independent of $t$.
<li><b>Small circles</b> have a <b>large curvature</b>, and
<li><b>large circles</b> have a <b>small curvature</b>.
<li>A <b>straight line</b> has a curvature of 0, because there is no change of the unit tangent vector.
</ul>
<p>This suggests a <b>geometric definition</b> of curvature...

<h3>Osculating circle</h3>
<p class="show">
<img src="0g/10.3.osc.jpg" class="big"><br>
The circle with the same curvature (that is, radius=$1/\kappa$) as $\myv r(t)$ at a point $P$ on the curve.




<h3>Another way to calculate curvature</h3>
<p class="show">
We had:
$$\kappa = \left|\frac{d\uv T}{dt}\right| \frac{dt}{ds} = \frac{|d\uv T(t)/dt|}{|\myv r'(t)|} = 
\frac{\left|\frac{d}{dt}\left[ \frac{\myv r'(t)}{|\myv r'(t)|}\right]\right|}{|\myv r'(t)|}.$$

<p class="show def"><b>Theorem</b>: The curvature of the curve given by $\myv r(t)$ is given by:
$$ \kappa(t)=\frac{|\myv r'(t)\times \myv r''(t)|}{|\myv r'(t)|^3}.$$

<p class="todo">Do <a href="https://activecalculus.org/multi/S-9-8-Arc-Length-Curvature.html#A_9_8_6">9.8.6 - curvature of an ellipse</a>, part a.  Start by graphing the ellipse with $a=1$ and $b=4$.  Based on the sketch, where do you think the curvature will be greatest or smallest? (and what values of $t$ locate those points?)

<h4>Example 4 - group work</h4>
<p>...uses the formula above to calculate the curvature of the 'twisted cubic' $\myv r(t)=\langle t,t^2,t^3 \rangle$:
$$\kappa(t)=\frac{2\sqrt{1+9t^2+9t^4}}{(1+4t^2+9t^4)^{3/2}}$$
The twisted cubic...[plot the twisted cubic.]
<ul><li>Would you expect the curvature function to be symmetric or not about $t=0$ which corresponds to $(0,0,0)$?
<li>Would you expect there to be a maximum, minimum, or neither at $t=0$?
</ul>
<p>[Graph $\kappa(t)$ to see...]


<h3>Unit tangent, unit normal, binormal</h3>
<p class="show">Several quantities, defined in terms of derivatives of $\myv r(t)$:
<p class="def show incremental">The unit tangent vector is
$$\uv T(t) \equiv \frac {\myv r'(t)}{|\myv r'(t)|}.$$

<p>Under what circumstances is $\uv T'(t)=0$?
<p>(That is to say, $\uv T'\equiv \frac{d}{dt}\uv T$ is not necessarily a <i>unit</i> vector.)

<p>But when $|\uv T'(t)|\neq 0$...
<ul><li>$\uv T(t)$ is a vector whose <i>length</i> (=1) is not changing with time.
<li>Therefore $\uv T'(t)$ must be at right angles to ("normal to") $\uv T$.
</ul>

<p class="def show incremental">The unit <b>normal</b> vector is

$$\uv N(t) \equiv \frac {\uv T'(t)}{|\uv T'(t)|}.$$

<p>$\uv N$ points towards the center of the osculating circle for $\myv r(t)$.

<p>What's the magnitude of the cross product of two unit vectors, which are at right angles?

<p class="def show incremental">The <b>binormal</b> vector is
$$\myv B(t)=\uv T(t)\times\uv N(t).$$
<p>We may as well write it as $\uv B(t)$ because it <i>must</i> have unit length by this definition.

<p><img src="0g/10.3.binormal.jpg">


<h3>Example</h3>
<p class="show">For $\myv r(t)=2\cos t \uv i + 2\sin t \uv j + 3t \uv k$: Find $\uv T$, $\uv N$, and $\uv B$ at $t=3\pi/2$.  Sketch these on a plot of $\myv r(t)$.<br>
<img src="0g/10.3.coil.jpg" class="big"><br>

<p class="justme">See <a href="10.3.TBN.nb">10.3.TBN.nb</a> for calculations

<h3>Acceleration- components</h3>
<p class="show">Interesting things happen when we resolve acceleration into components parallel (tangential) and perpendicular (normal) to the velocity...

<p>Since the unit tangent vector $\uv T=\frac{\myv r'(t)}{|\myv r'(t)|}=\frac{\myv v}{v}$,
$$\myv v= v\uv T.$$
<p>Differentiating both sides of this equation, using the product rule on the right, gives us
$$\myv v' = \myv a = v' \uv T + v \uv T'.\label{accel}$$
<p>Now re-writing 2 relations from 10.3 in terms of velocity/speed:  The curvature, $\kappa$,
$$\nonumber \kappa = \frac{|\uv T'|}{|\myv r'|}= \frac{|\uv T'|}{v},$$
and the unit normal vector $\uv N=\uv T'/|\uv T'|$,
$$\nonumber \uv T' = |\uv T'| \uv N=\kappa v \uv N.$$
<p>Substituting into \ref{accel},
<p class="def show incremental">$$\myv a = v' \uv T +\kappa v^2 \uv N.$$

<ul>
<li>No $\uv B$ component (binormal) to the acceleration??!!
<li>This means that acceleration is always in the $\uv T$-, $\uv N$-plane.
<li><img src="0g/10.4.acomponents.jpg" class="rightalign">A change in speed, $v'$ only affects the tangential component, $a_T$.

<li>A very important difference from motion in one dimension is the acceleration of the velocity vector due to a <b>change in direction</b>:
<p class="def show">If a particle is moving around a curve, <b>even at constant speed</b>,  it <b>must have a normal component of acceleration</b> towards the "inside" of the curve (towards the center of the osculating circle).

<li>The normal component of acceleration, $a_N$, is only sensitive to speed^2 and curvature, not the <i>change</i> in speed.
<li>Newton's law is: $\myv F = m \myv a$. 
<li>So, the "sideways force" (the normal force) that the rails/road exerts on a train/car in order to keep it on the track/road is the normal component of the force (also called  the centripetal force):
$$F_N=ma_N=m\kappa v^2.$$
There is a maximum sideways force that rails can exert before a train "hops the rails"...
<br>[People, > 70,  died in this accident :-<]
<iframe width="420" height="315" src="//www.youtube.com/embed/vt4G0RD77Ws" frameborder="0" allowfullscreen></iframe>
<p>"Twice the speed limit"...
<p>If you double the speed, the sideways force needed to stay on the rails <b>quadruples</b>.
</ul>


<h4>Components in terms of $\myv a$</h4> 
<p>$$\myv a(t)=a_T(t) \uv T(t)+a_N(t)\uv N(t).$$
<img src="0g/10.4.acomponents.jpg" class="rightalign">
<p>[In what follows, I'll stop writing the explicit time dependence, but just remember that all the quantities we're dealing with are time dependent.]

<p>The tangential component, $a_T$ is the dot product of $\myv a$ with a unit vector in the tangential direction, namely $\uv T$:
$$\begineq a_T&=\myv a\cdot\uv T\\
&=\myv a \cdot \frac{\myv v}{|\myv v|}=\frac{\myv a\cdot \myv v}{v}.\\
\endeq$$

<p>We can write the dot product as
 $\myv a \cdot \uv T=a \cos \theta$, where $\theta$ is the angle between $\myv a$ and $\uv T$.  

<p>Since  $\uv T \perp \uv N$,   We could write 
$$\nonumber a_N=\myv a \cdot \uv N = a \sin \theta.$$
<p>But  $|\myv a \times \uv T| = a \sin \theta$ too, so

<p>$$\begineq a_N &= |\myv a \times \uv T| \\
&= \left|\myv a \times \frac{\myv v}{v} \right| = \frac{|\myv a \times \myv v|}{v}
.\endeq$$


<div class="todo">
[Test 1 question, 2015] A particle is moving counterclockwise around a circle. Which of the
vectors in the figure below is <b>not</b> a possible acceleration
vector? Explain. For the remaining two possible acceleration vectors,
state whether the particle is speeding up or slowing down.<br>

<img src="0g/T1.circularacceleration.jpg"><br> 
</div>


<h3>Summary</h3>
<p class="show">Unit tangent vector
$$\uv T = \frac{\myv v}{v}$$
Unit Normal vector
$$\uv N = \frac{\uv T'}{|\uv T'|}$$
Decomposition of acceleration
$$\uv a(t)=a_T(t) \uv T(t) + a_N \uv N(t)$$
Tangential component
$$a_T=v'=\frac{\myv a \cdot \myv v}{v}$$
Normal component
$$a_N=\kappa v^2 =\frac{|\myv a \times \myv v |}{v}$$
<br><br>
$$a_N \uv N=\myv a -a_T\uv T = \myv a - \frac{\myv a \cdot \myv v}{\myv v\cdot\myv v}\myv v$$ 

<?php include "../../classes/3.h" ?>