<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Chapter 10 - DERIVATIVES - Learning objectives
</title>
<meta name="week" content="5">
<?php include "../../classes/2.h"; ?>
<h2>Chapter 10 - Derivatives of MV functions</h2>
<h4>Learning objectives</h4>


<h3>Partial differentiation</h3>

<p>The <i>partial derivative</i> of a function, $f(x,y,u,v,w....)$
$$\frac{\del f}{\del y}\equiv \left(\frac{\del f}{\del y} \right)_{x,u,v,w...
}$$


This notation means:
<ul>
<li>To take the "partial derivative"--denoted by $\del/\del y$  instead $d/dy$
--of a MV function, with respect to one of its independent variables (for example, with respect to $y$)...

<li>Consider that all the other independent variables are being held constant,
<li>Use all your single-variable derivative knowledge, while treating all the other variable symbols as constants.
</ul>

<p>If $f=f(x,y)$, then $\del f/\del y$ is the slope function for an $x=k$ trace of the surface $f(x,y)$. That is:
$$\left.\frac{\del f}{\del y}\right|^{x=k}\equiv \frac{df(k,y)}{dy}.$$


<p>More notation:
<ul>
<li>$f_x \equiv \frac{\del f}{\del x}$,
<li>$f_{xy} \equiv \frac{\del f}{\del y}\frac{\del f}{\del x}$.
</ul>



<h3>Second-order partial derivatives</h3>
<p>Graphical interpretations
<ul>
<li>$f_x$ and $f_y$ are the <b>slope</b> functions for $y=k$ and $x=k$ traces of the $f(x,y)$ surface.
<li>$f_{xx}$ and $f_{yy}$ are <b>concavity</b> functions for $y=k$ and $x=k$ traces.
<li>$f_{xy}$ and $f_{yx}$ are <b>twist</b> functions for the $f(x,y)$ surface.
</ul>

<p><b>Know how</b> to evaluate the sign of any second-order partial derivative at a particular point on a contour plot of the function. (See the last page, "Mixed Partials" of our <a href="https://people.goshen.edu/~paulmr/physix/213/mvhandouts/10.2-3.partials.pdf">Partial derivatives handout</a>.

<p>Clairaut's theorem:
<ul><li>the order of partial differentiation does not matter
$$f_{xy} = f_{yx}.$$
<li>This follows from<ul><li>the property of a function that there is one and only one "output" value of the function $f(x,y)$ for any point $(x,y)$ (function input) in the function's domain, and<li> Holds for functions which are continuous, and have continuous partial derivatives.
</ul>
</ul>

<h3>Linear model (and chain rule)</h3>
<p>If you have some information about a continuous function at a particular  point $(x_0,y_0)$ in its domain...
<ul><li>You know the height of the surface, $f(x_0,y_0)$,
<li>and the partial derivatives at $(x_0,y_0)$:
$$f_x=\left.\frac{\del f}{\del x}\right|^{(x,y)=(x_0,y_0)}
\ \ \ \text{and}\ \ \
f_x=\left.\frac{\del f}{\del y}\right|^{(x,y)=(x_0,y_0)},
$$
</ul>

then you can find the height of the surface, $f(x,y)$ at some nearby location $(x,y)$ by means of the linear approximation:

  $$f(x,y) \approx f(x_0,y_0)+f_x (x-x_0)+f_y (y-y_0).$$

This is the equation of a <b>tangent plane</b>: A plane which is tangent to the surface $f(x,y)$ at the point $(x_0,y_0,f(x_0,y_0))$.


<p>Re-arranging this last equation just a bit, and  re-writing it in terms of changes  (that is,  $\Delta y = y-y_0$; $\Delta x = x-x_0$; and $\Delta z = f(x,y)-f(x_0,y_0)$):

  $$\begineq f(x,y) - f(x_0,y_0) &\approx f_x (x-x_0)+f_y (y-y_0)\\
  \Delta z &\approx f_x \Delta x+f_y \Delta y\\
  \frac{\Delta z}{\Delta t}
  &\approx \frac{\del f}{\del x}
  \frac{\Delta x}{\Delta t}+\frac{\del f}{\del y} \frac{\Delta y}{\Delta t}\\
  \frac{dz}{dt}
  &= \frac{\del f}{\del x}\frac{dx}{dt}+\frac{\del f}{\del y} \frac{dy}{dt}\\
\endeq
$$

This is the <b>chain rule</b> for a function $f(x,y)$ if $x=x(t)$ and $y=y(t)$ are each functions of a parameter $t$.


<h3>The gradient, and directional derivatives</h3>

<p>The <b>gradient 
of a function</b>,  $\myv \grad f(x,y)$ is a vector in the $xy$ plane which has  components which are the partial derivatives wrt each of the independent variables:
$$\myv\grad f =\langle \frac{\del f}{\del x}, \frac{\del f}{\del y} \rangle.$$
<ul><li>It <b>points in the direction of <i>steepest increase</i></b> of the surface $f$.
<li>It is <b>perpendicular to the contour line</b> at that point.
<li>Its <b>magnitude is the slope of the surface</b> [meters of rise / meters of run...]  in that steepest direction.
</ul>

<p>The <b>directional derivative</b> or slope of a surface in a particular direction, specified in the $xy$ plane by the unit vector $\uv u$, is given by
$$D_{\uv u}f = \myv \grad f \cdot \uv u.$$

<h3>Optimization</h3>
<p>...Finding and characterizing maxima and minima and other critical points.

<h4>Critical points of a surface, $f(x,y)$.</h4>
<p>Look for points $(x,y)$ that simultaneously satisfy:
$$\frac {\del f}{\del x}=0
\ \ \ \ \text{and} \ \ \ \ \frac {\del f}{\del y}=0.$$
You should be able to use technology (E.g. GeoGebra and CoCalc) to make  surface plots and contour plots.  You should be able to examine these visualizations to identify likely <b>critical points</b> and classify them as maxima or minima (absolute or local), or neither (for example, saddle points and inflection points).
<p>You should also be able to  evaluate the Determinant of the Hessian matrix for an analytical test of the critical point type.

<h4>Critical points of a surface along a path $g(x,y)=k$</h4>
<p>...or critical points, subject to a "constraint" $g(x,y)=k$.

<p>You should be able to use technology to make contour plots and to make parametric plots of curves and constraint equations.  You should be able to identify and classify critical points along a path on a contour plot:  Locations where a path and a level curve are parallel.

<p>There are two ways to find the critical points along a path:
<ol><li><b>Parameterize  the path</b>:
<ol><li>Find $x(t)$ and $y(t)$ such that $g(x(t),y(t))=k$.
<li>Solve $df(x(t), y(t))/dt = 0$ to find one or more critical <i>parameters</i> $t_1, t_2,....$.
<li>Substitute the critical parameters into your expressions for $x$ and $y to find the critical points $(x(t_1),y(t_1))$, $(x(t_2),y(t_2)$,...
</ol>
<li>or, use <b>Lagrange multipliers</b>:  <ol>
<li>At a critical point, the two normal vectors must be parallel:  $$\myv \grad f = \lambda\myv \grad g.$$
<li>Write down a system of equations: one for each component of the gradient equation, together with the constraint equation:
$$\left(\myv \grad f\right)_x = \lambda\left(\myv \grad g\right)_x$$
$$\left(\myv \grad f\right)_y = \lambda\left(\myv \grad g\right)_y$$
$$g(x,y) = k$$

<li>solve the  system of equations for the the coordinates $(x,y)$ and the parameter $\lambda$.  (There may be multiple solution sets).

</ol>
</ol>

<h4>Using CoCalc...</h4>
<p>You should be able to
<ul><li>Make a contour plot of a function $f(x,y)$ over some particular domain.
<li>Plot a path on top of your contour plot.
<li>Examine the plot to determine where the path is at a local maximum / minimum / saddle point or something else.
</ul>
<?php include "../../classes/3.h" ?>