<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Tangent planes and differentials [10.4]
</title>
<meta name="week" content="6">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Linear approximations - Tangent planes and differentials [10.4]
</h1>

<p><img src="0g/11.4.balance.jpg"  class="big"><br>
The board is <b>tangent</b> to the bowling ball at the point of contact.

<h3>Tangent planes</h3>
<p class="show"><img src="0g/11.4.tangentplane.jpg"  class="big">
<p>Suppose $f$ has continuous partial derivatives, and it's <i>differentiable</i>.  An equation of the plane which is tangent to the surface $z=f(x,y)$ at the point $P(x_0,y_0, z_0)$ is
$$z=z_0+f_x(x_0,y_0)(x-x_0)+f_y(x_0,y_0)(y-y_0)$$

Differentiating this expression, holding $y$ constant we find...
$$z_x=f_x(x_0,y_0)\qquad\text{and}\qquad z_y=f_y(x_0,y_0).$$
So, at the point of contact $x_0,y_0,z_0$ the slope of the function in the $x$ direction and the slope of the function in the $y$ direction exactly match the corresponding slopes of the tangent plane.

<h3>Linear approximation</h3>
<h4 class="show">...geometric view</h4>
<p class="show">Any smoothly varying, continuous curve looks like a straight <i>line</i> if we zoom in far enough.

<p>A smoothly varying varying shape--say a sphere--looks like a flat <i>plane</i> if we zoom in far enough.  (Or if the inhabitants of the sphere are already very tiny in comparison!)<br>
<img src="0g/10.4.horizon.jpg" class="big"><br>
<span class="caption"><a href="https://flickr.com/photos/sparkyc/104995140">Chris [Flickr user sparkyc]</a></span>

<p>
So, the tangent plane should be a pretty good approximation to the original function, as long as $x$ and $y$ are "not too far" from the point of contact (which in this diagram, I'm saying has coordinates $(a,b)$):

$$f(x,y) \approx f(a, b) + f_x(a, b)(x – a) + f_y(a, b)(y – b)$$
is called the <b>linear approximation</b> or the <b>tangent plane
approximation</b> of $f$ at $(a, b)$.


<p>I could re-arrange this a bit to write things in terms of the change of the function: $\Delta z\equiv f(x,y)-f(a,b)$ to find out, and picture, how that depends on changes in $x$ and $y$, and how it compares with $dz$, which is the change in the height of the tangent plane:
$$\Delta z \approx f_x(a,b)\Delta x+f_y\Delta y.$$
<p><img src="0g/11.4.lineardetail.jpg" class="big">






<p>In the limit of vanishingly small 'steps', $\Delta x\to dx$ and $\Delta y\to dy$, the linear approximation becomes exact:
<p class="show incremental def">The <b>differential</b> of $f$ is
$$dz\equiv df = f_x(x,y)\,dx+f_y(x,y)\,dy =  \frac{\del f}{\del x}dx+
\frac{\del f}{\del y}dy.$$
<p>This only works if there's a unique plane tangent to the surface--See the textbook for a fuller discussion--and if the function is <i>differentiable</i>:
<h3>Differentiability</h3>
<p class="show def">If $z=f(x,y)$, then $f$ is <b>differentiable</b> at $(a,b)$ if $\Delta z$ can be expressed in the form
$$\Delta z = f_x(a,b) \Delta x + f_y(a,b) \Delta y + \epsilon_1 \Delta x
+\epsilon_2 \Delta y$$
where $\epsilon_1\to 0$ and $\epsilon_2 \to 0$ as $(\Delta x, \Delta y)\to 0$.


<p class="show incremental def"><b>Theorem:</b> If the partial derivatives $f_x$ and $f_y$ exist near $(a,b)$, and if they are continuous at $(a,b)$, then $f$ is differentiable at $(a,b)$.

<p>In hiking terms:
<blockquote>Use the linear approximation to calculate your change in height as you step in different directions.

<br><br>Unless your next step is off the edge of a cliff.</blockquote>
<p>...or you're on a sharp ridge (with no <i>unique</i> tangent plane).





<h3>To Do</h3>
<ul class="todo">
<li>Finish Tabular data
<li>Finish Graphical data
</ul>

<h4 class="handout">Image credits</h4>
<p class="handout"><a href="http://www.flickr.com/photos/lcwilder/3958141171">Larry Wilder</a>


<?php include "../../classes/3.h" ?>