<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Chain rule [10.5]
</title>
<meta name="week" content="7">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
The Chain Rule
</h1>
<p><img src="0g/11.5.Rubenvent.jpg" class="big">
<br>...a chain of events.
<p class="justme">When we take about the chain rule, we're referring to an image of a chain of events.

<h3>1-d chain rule</h3>
<p class="show">If $y=f(x)$, and in turn $x=g(t)$ then the
chain rule in an easy-to-remember form is:
$$\frac{dy}{dt}=\frac{dy}{dx}\frac{dx}{dt}.$$

<h4>Examples</h4>

<p class="show">$$y(x)=x^3;\ \  x(t)=\ln t;\ \  \Rightarrow y(x(t))=(\ln t)^3.$$
<p>$$\frac{dy}{dx}=3x^2;  \frac{dx}{dt}=\frac1t$$
<p>$$\Rightarrow \frac{dy}{dt}=\frac{dy}{dx}\frac{dx}{dt}=3x^2 \frac1t=\frac{3(\ln t)^2}{t}.$$

<p>Another way of talking about the chain rule is to call $y(x)$  the "outside" function, and $x(t)$ the "inside" function.  Then, we say that we take the derivative of the outside function (wrt to the inside function), and then multiply by the derivative of the inside function.  I think about "putting off" evaluating $x'(t)$ until the very end...x
<p>
To differentiate $y(t)=\frac{1}{7t}$ the outside function is $y(x)=\frac{1}{x}$, and the inside function is $x(t)=7t$. 
$$\begineq\frac{d}{dt}\left(\frac{1}{x}\right)&=\frac{d}{dt}(x)^{-1}
=\frac{d}{dx}\left(x^{-1}\right)\frac{d}{dt}(x)\\

&=-1(x)^{-2}\frac{d}{dt}(x)
=\frac{-1}{(7t)^2}(7)\\
&=-\frac{1}{7t^2}
\endeq
$$


<ul><li><a href="https://www.math.ucdavis.edu/~kouba/CalcOneDIRECTORY/chainruledirectory/ChainRule.html">Practice problems (w solutions) using the chain rule</a> (UC Davis)
</li>
</ul>

<h3>Multivariable chain rule</h3>
<p class="show">Our hiking approximation:
$$ \Delta z \approx f_x \Delta x + f_y \Delta y$$
<p>If $z=f(x,y)$ and in turn $x=g(t)$ and $y=h(t)$ are parametric functions of $t$, then $z$ must ultimately be a function of $t$ as well: $z=z(t)$.  
<p>The $\Delta$ symbols mean:
 $\Delta z= z(t+\Delta t)-z(t)$,

$\Delta x= x(t+\Delta t)-x(t)$, and
$\Delta y= y(t+\Delta t)-y(t)$.
<p>Now divide both sides of the hiking approximation by $\Delta t$:
$$ \frac{\Delta z}{\Delta t} \approx f_x
\frac{\Delta x}{\Delta t}
+ f_y \frac{\Delta y}{\Delta t}$$

<p>As  $\Delta t\to 0$
<ul><li>the change ratios become differentials, for example:
$$\frac{\Delta x}{\Delta t}\to \frac{dx}{dt},$$
and
<li>the approximate relation becomes exact.
</ul>

<p>Now, we'll also substitute in the definitions of $f_x$ and $f_y$ in terms of $z=f(x,y)$ to arrive at...

<p class="show incremental def">$$ \frac{dz}{dt} = \frac{\del z}{\del x} \frac{dx}{dt} + \frac{\del z}{\del y} \frac{dy}{dt}.$$
This is <b>"Case 1" of the multi-variable chain rule</b>.
<p class="justme">This also shows the difference between partial derivatives and exact derivatives).

<p>For example, if $f(x(t),y(t))=\sin(xy^2)$,
$$\begineq 
\frac{dz}{dt}&= \frac{\del z}{\del x} \frac{dx}{dt} + \frac{\del z}{\del y} \frac{dy}{dt}\\
&= \cos(xy^2)\cdot y^2 \frac{dx}{dt} + \cos(xy^2)\cdot x2y \frac{dy}{dt}\\
&= y\cos(xy^2)\left[y \frac{dx}{dt} + 2x \frac{dy}{dt}\right].
\endeq$$

<p>I use the derivatives (e.g. $d/dt$) when writing about a function that depends on just one variable.  I use the partial derivatives (e.g. $\del/\del x$) when talking about a rate of change of a function that depends on more than one variable (and implicitly, the other variables are held constant while calculating the partial derivative).



<h3>Chain rule for more than one independent variable</h3>
<h3>Example</h3>
<p class="show">4 intermediate variables which each depend on 2 total independent variables<br>
<img src="0g/11.5.tree.jpg"><br><br>
<img src="0g/11.5.treeds.jpg"><br><br>

<p>Now  you might proceed to <a href="mv10.6.php">topic 10.6</a>.


<h3>Implicit differentiation</h3>

<p>Read about implicit differentiation
<ul><li>At <a href="https://www.khanacademy.org/math/ap-calculus-ab/ab-differentiation-2-new/ab-3-2/a/implicit-differentiation-review">Khan  Academy</a>
</ul>

<div class="justme">
<h4>Typographical issues in WebAssign #6</h4>
<p>Your textbook starts by differentiating a function $F(x,y,z)=0$.  We make the assumption that $z$ is actually a function of $x$ and $y$. The development in Stewart results in *2* equations, but in problem 6, it looks like they might be just one long complicated equation.  My additions in red below are to make clear that these are <b>two</b> equations:<br>
<img src="0g/11.5.implicit.jpg">

<p>The example we did in class today:<br>
<img src="0g/11.5.implicit.png" class="big">

<h4>An example</h4>
<p>Consider the ideal gas law (this is called an "Equation of State")
$$PV=nRT$$
The symbols are $P$, pressure; $V$, volume; $n$, number of moles of a gas (considered a constant and not a variable);
$R$, the gas constant; and $T$, temperature.

<p>Using algebra you can re-arrange this to find the following function, which depends on $P$, $V$, and $T$ and is equal to 0:
$$
0 = PV-nRT \equiv F(P,V,T)
$$

<p>Now imagine that we can control the volume and temperature of a quantity of gas--say, it's in a piston (we can change the volume), surrounded by a heat bath (we can change the temperature). Then we view the pressure as a function of the temperature and volume, that is
$$F(\ P(V,T),\ \, V,T)=0.$$
One of Stewart's expressions tells us that
$$\frac{\del P}{\del T}=-\frac{\frac{\del F}{\del T}}{\frac{\del F}{\del P}}.$$ 

<p>Looking back at $F=PV-nRT$, we find $\del F/\del T = -nR$ and $\del F/\del P=V$.  Plugging these into the expression above:
$$\frac{\del P}{\del T}=-\frac{-nR}{V}=\frac{nR}{V}.$$
Is this right?  We can check the answer, in this case, because there's an easier way to find $\del P/\del T$.  We can solve the ideal gas law for $P$, to get:
$$P(T,V)=\frac{nRT}{V}.$$
And taking the partial derivative w.r.t. $T$ of both sides:
$$\frac{\del P}{\del T}=\frac{\del}{\del T}\left(\frac{nR}{V}\right)T =
\left(\frac{nR}{V}\right)\frac{\del}{\del T}T =\frac{nR}{V}.$$
Sure enough!


</div>

<h4 class="handout">Image credits</h4>
<p class="handout"><a href="http://en.wikipedia.org/wiki/File:Rubenvent.jpg">Cover of <i>Rube Goldberg's Inventions!</i></a>


<?php include "../../classes/3.h" ?>