<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Optimization [10.7]
</title>
<meta name="week" content="7">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Maximum and Minimum Values
</h1>
<p class="show"><img src="0g/11.7.maximization.jpg" class="big">

<h3>A definition and a theorem</h3>
<p class="show">A function of two variables has a <b>local maximum</b> at $(a,b)$...
<ul>
<li>if $f(x,y)\leq f(a,b)$
 when $(x,y)$ is near $(a,b)$.
<li>[This means that $f(x,y)\leq f(a,b)$ for all points $(x,y)$ on some disk centered at $(a,b)$.]
<li>The number $f(a,b)$ is called the <b>local maximum value</b>
</ul>
<p>...if instead $f(x,y)\geq f(a,b)$ near $(a,b)$, then $f(a,b)$ is a <b>local <i>minimum</i> value</b>.

<p class="show def increment"><b>Theorem</b> if $f$ has a local maximum (or minimum) at $(a,b)$, and the first order partial derivatives exist there, then
$$f_x(a,b)=0 \ \ \text{  and   }\ \  f_y(a,b)=0.$$

<p>Does this relationship go the other way?

<p>Consider the <i>saddle point</i> pictured...<br>
<img src="0g/11.7.saddle.jpg" class="big">

<h3>Second derivatives test</h3>
<p>In calculus of one variable, the second derivative can be used to decide if a point is a maximum, minimum, or neither.  There's a second derivative<b style="font-size:1.2em">s</b> test for functions of two variables:

<p>Suppose that the first partial derivatives exist, and vanish at $(a,b)$, that is $f_x(a,b)=f_y(a,b)=0$, then $(a,b)$ is a <b>critical point</b>.

<p>Now, suppose that in addition, the second partial derivatives of $f$ also exist on a disk centered at $(a,b)$.  The determinant of the <i>Hessian</i> matrix of 2nd derivatives, $D$, turns out to be useful for  testing critical points:
$$\begineq
D(a,b)&\equiv f_{xx}(a,b)f_{yy}(a,b)-\left[f_{xy}(a,b)\right]^2\\
&=\text{det} \begincv  
f_{xx} & f_{xy}\\
f_{yx} & f_{yy} 
\endcv
\endeq
$$

<div class="show def">
<h4>Second derivatives test</h4>

<p>If $(a,b)$ is a <b>critical point</b> of $f$, then....
<ol type='i'>
<li>if $D \gt 0$ and $f_{xx} \gt 0$ (*), $\Rightarrow f(a,b)$ is a <b>local minimum</b>.
<li>if $D \gt 0$ and $f_{xx} \lt 0$ (*), $\Rightarrow f(a,b)$ is a <b>local maximum</b>.
<li>if $D \lt 0$ then f(a,b) is a neither a local maximum, nor a local minimum. (saddlepoint)
</ol>

<p>If $D=0$ the test is inconclusive.  The critical point might be a max, a min, or a s.p.
</div>
<p>(*) Either $f_{xx}(a,b)$ or $f_{yy}(a,b)$ can be tested..
<p class="todo">Do <a href="https://activecalculus.org/multi/S-10-7-Optimization.html#A_10_7_5">A 10.7.4 - Find and classify the critical points</a>.

<h3>Example</h3>
<p>Find three positive numbers whose sum is $n$, and whose product is a maximum.
<p>We could define these two conditions as:
$$x+y+z=n$$
and $$xyz=\text{maximum}.$$

<p>One approach
<ol><li>Solve the first equation for $z$:
$$z=n-x-y$$
<li>Define the product of the three numbers as a function of $x$ and $y$, by subbing in for $z$:
$$f(x,y)=xy(n-x-y)=nxy-x^2y-xy^2.$$
<li>The maximum of this function will occur when both 
$\frac{\del f}{\del x}=0$, and $\frac{\del f}{\del y}=0$.

<li>This is  two equations and there are two unknowns, $x$ and $y$.  Solve the two equations for $x$ and $y$.

<li>Actually there is more than one $(x,y)$ pair that solves this,  but you can try them out, and see which gives the largest product. (Hint, some of them involve $x=0$ or $y=0$, which will give a  minimum for the product, instead of a maximum).

</ol>

<!--
<h3>To Do</h3>
<ul class="else"><li>Optimization: Unbounded region [We did this as a lab exercise.]
</ul>
-->

<h3>Bounded regions</h3>

<ul><li><a href="https://activecalculus.org/multi/S-10-7-Optimization.html#Extreme-value-theorem">The Extreme Value Theorem</a> claims that
<ol><li>there is always an absolute maximum and an absolute minimum...
<li>for some points in a closed and bounded region
<li>of a continuous function, $f(x,y)$.
</ol>
<p>The points could be in the interior, or on the boundary.
<p>To check the boundary, parameterize it, in segments if necessary,  and check for critical points on the boundary, or at the endpoints of the boundaries.
<p class="todo">
Do <a href="https://activecalculus.org/multi/S-10-7-Optimization.html#A_10_7_6">10.7.6 - a triangular domain</a>

<p>A quick way to view the bounded domain in GeoGebra is the plot the surface, and then the three planes, $x=0$, $y=0$, $y=-x$.
<div class="big">
<iframe src="https://www.geogebra.org/3d/ybp9tenm?embed" width="800" height="600" allowfullscreen style="border: 1px solid #e4e4e4;border-radius: 4px;" frameborder="0"></iframe>
</div>
<?php include "../../classes/3.h" ?>