<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Double integrals over rectangular areas [11.1]
</title>
<meta name="week" content="8">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Double integrals over rectangles [11.1]
</h1>
Approximating volumes with stacks of blocks...<br>
<img src="0g/12.1.frog.jpg">


<h3>Finding volumes using double integrals</h3>
<p class="show">Consider the volume, $V$, of the solid which is...<br>
<img src="0g/12.1.underneath.jpg" class="big">
<br>
<img src="0g/12.1.stack.jpg" class="rightalign">
<ul><li>bounded below by the rectangle, $R=[a,b]\times[c,d]$ in the $xy$ plane,
<li>Goes straight up from $R$,
<li>Is bounded above by the surface, $f(x,y)$.
<li>Split up $[a,b]$ into $m$ sub-intervals, split up $[c,d]$ into $n$ sub-intervals.
</ul>
<p>Approximate volume is 
$$V\approx\sum_{i=1}^m\sum_{j=1}^n f(x_{ij}^*,y_{ij}^*)\Delta A.$$
where...
<ul>

<li>$(x_{ij}^*,y_{ij}^*)$ is the coordinate of <i>some</i> point in rectangle $R_{ij}$;

<li>$\Delta A$ is the area of one of the small, identical rectangles with sides $\Delta x=(b-a)/m$ and $\Delta y=(d-c)/n$. That is to say...
$$\Delta A = \left(\frac{b-a}{m}\right)\left(\frac{d-c}{n}\right)=\frac{A}{mn},$$
 where $A=(b-a)(d-c)$ is the area of the large rectangular region $R$.




<p>In the limit $\Delta A \to dA \to 0$ this sum becomes exactly this <i>integral</i>
$$V=\iint_R f(x,y)dA.$$

<h3 id="todo">To do /handouts/</h3>
<ul class="todo">
<li>mv11.1.data - Double Integrals from Data
</ul>

<h3>$\langle f(x,y) \rangle$ above a rectangular region</h3>
<p class="show">
Average value of a 1-dimensional function on the interval $[a,b]$:
$$\begineq \langle f(x)\rangle&= \frac{1}{b-a}\int_a^b f(x)\,dx\\
&=\frac{1}{l}\int_a^b f(x)\,dx
\endeq$$
<p>
If you chopped off all the area in the peaks above this line at $y=\langle f(x)\rangle$, it would just fill in the area in the valleys below the line...
<br><img src="0g/12.1.fillvalleys2d.jpg"><br>
<p>Analogously, for a function of $x$ and $y$...

$$\begineq\langle f(x,y)\rangle &= \frac{1}{(b-a)(d-c)}\int_a^b\int_c^d f(x,y)\,dy\,dx\\
&= \frac{1}{A}\int_a^b\int_c^d f(x,y)\,dy\,dx.\endeq$$
<p>
If you chopped off all the volume in the peaks above this plane surface at $z=\langle f(x,y) \rangle$, it would just fill in the volume of the valleys below this plane.<br>
<img src="0g/12.1.fillvalleys3d.jpg"><br>

<h4>Approximating the average by sampling</h4>
$$\begineq\langle f(x,y)\rangle &=  \frac{1}{A}\int_a^b\int_c^d f(x,y)\,dy\,dx\\
&=  \frac{1}{A}\sum_i^m\sum_j^n f(x_{ij}*,y_{ij}^*)\Delta A
=  \frac{\Delta A}{A}\sum_i^m\sum_j^n f(x_{ij}*,y_{ij}^*)\\
&=  \frac{\Delta A*m*n}{A}\frac{\sum_{i=1}^m\sum_{j=1}^n f(x_{ij}*,y_{ij}^*)}{m*n}\\
&=  \frac{\sum_i^m\sum_j^n f(x_{ij}*,y_{ij}^*)}{m*n},\\
\endeq$$
because there are $m*n$ sub-rectangles, so $A=\Delta A*m*n$.  Therefore the average value $\langle f(x,y)\rangle$ is just the average of the sampled values of the function--one sample for each sub-rectangle.





<h3>To do /handouts/</h3>
<ul class="todo">
<li>mv11.1.park:  Back to the Park

</ul>


<h4 class="handout">Image credits</h4>
<p class="handout"><a href="http://www.seankenney.com/portfolio/">Sean Kenney</a>




<?php include "../../classes/3.h" ?>