<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Iterated integrals [11.2]
</title>
<meta name="week" content="8">
<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>

<h1>
Iterated integrals &amp; partial integration [11.2]
</h1>
<p class="show"><img src="0g/12.1.underneath.jpg"><br>
We saw that the double integral:
$$\iint_R f(x,y)\,dA$$
represents the volume between the rectangle $R\equiv[a,b]\times[c,d]$ (in the $x,y$ plane)  and the surface $z=f(x,y)$ above $R$.
<p class="show">Now we'll see how to <b>evaluate</b> such an integral.

<h2>Partial Integration</h2>
<p class="show">How to evaluate a double integral like
$$\iint_R f(x,y)\,dA=\iint_R f(x,y)\,dx\,dy?$$
<p>We'll do this in pieces, or to be more precise, in <i>slices</i>!<br>
<img src="0g/sliced-bread.jpg" class="big"><br>
<span class="caption"><a href="https://flickr.com/photos/30478819@N08/50388080482/">Marco Verch</a></span>

<p>We define...
<div class="show def">
<p><b>Partial integration</b> of a function $f(x,y)$ with respect to $y$ using this notation:
$$\int_{y=c}^d f(x,y)\,dy=A(x).$$
This means A(x) is the result of 
<ul><li>Treating $x$ as a constant,
<li>carrying out the integration with respect to $y$.
</ul>
</div>

<p><img src="0g/11.2.traceb.png" style="width: 300px" class="rightalign">
Holding $x=1$, and integrating the trace $f(1,y)$ gives us the area of the cross-section shown, $A(x=1)$.

<p>We write it as $\color{#8098d9}A({\color{green}x})$ because:
<ul><li>It is the <b style="color:#8098d9">area</b> of a slice resulting from the (partial) integration w.r.t. $y$,
<li>That area varies depending on <b style="color:green">the value of $\color{green}x$</b> of the slice.
</ul>

<p><b>example</b>: $f(x,y)=2-x-y$,
$$\begineq\int_0^1 (2-x-y)\,dy&=\int_0^1 (2-x)\,dy-\int_0^1 y\,dy\\
&=(2-x)\int_0^1 dy-\int_0^1 y\,dy\\
&=(2-x)\,\left. y \right|_0^1-\left.\frac12 y^2\right|_0^1\\
&=(2-x)(1-0)-\frac12(1^2-0^2)\\
&=2-x-\frac12\\
A(x)&=\frac32-x.
\endeq

$$


<h4>Double integral</h4>

<p><img src="0g/11.2.tracec.png" style="width: 300px" class="rightalign">
Multiplying the cross-section area by a width $\Delta x$, gives us a "bread slice" with a volume of $A\Delta x$.

<p><img src="0g/11.2.traced.png" style="width: 300px" class="rightalign">
And adding up the volumes of slices at different $x_i^*$ values can give us an approximation to the volume under the surface.
$$V\approx\sum_i A(x_i^*)\Delta x$$
<p>If we make the slices vanishingly thin 
$$\sum_i A(x_i^*)\Delta x\to\int A(x)\,dx.$$
<p>Carrying out the integration of $A(x)$ with respect to $x$...
$$\begineq
\int_{x=a}^b \color{blue}{A(x)}\,dx&=
\int_{x=a}^b \left(\color{blue}{\int_{y=c}^d f(x,y)\,dy}
\right)\,dx\\
&=\int_{x=a}^b \int_{y=c}^d f(x,y)\,dy
\,dx\\
\endeq
$$
...results in a double integral equal to the volume under the surface above the region $R$.

<p>This rather sloppy way of writing the double integral leaves it unclear whether you should evaluate the partial integral of $y$ first, and then integrate over $x$, or vice versa. Perhaps it doesn't matter?

<h4>Fubini's Theorem</h4>
<p>...says that integrating over a rectangular region, $R$, in the $xy$ plane, and some pretty general assumptions, <b>the order of partial integration does not matter</b>.


<h3>Example 1</h3>
<p class="show">Find the volume underneath $f(x,y)=2-x-y$ and above the rectangle defined by points in the $x$-$y$-plane: $0\lt x \lt 1$, and $0\lt y\lt 1$.  (Alternately, $R=[0,1]\times[0,1]$.)<br>
<img src="0g/12.1.int1.jpg"><br>
$$ \begineq V= \iint (2-x-y)\,dA &= \int_{x=0}^1\int_{y=0}^1(2-x-y) dy dx

\\&= \int_{x=0}^1\left(\int_{y=0}^1 (2-x-y)\,dy\right) dx
\endeq$$


<p>We already carried out the partial integral in $(...)$.  Substituting the result back into the expression for $V$,
$$
\begineq V&=\int_{x=0}^1\left(\frac 32 - x\right)\,dx = \frac 32\int_0^1 dx -\int_0^1x\,dx\\
&=\frac32-\frac12=1
\endeq
$$

<h3>Example 2</h3>
<p class="show"><img src="0g/12.1.int2.jpg"><br>
The function for the surface is
$f(x,y)=4-x-y$.
<div class="todo">
<ol>
<li><b>Estimate</b> the volume under this surface, for example, by estimating the <i>average height</i> of the surface, then multiplying by the area of the rectangle $R$ underneath.
<li><b>Evaluate</b> the double integral to find the exact volume.
 <ol><li>Evaluate the integral over $dy$  first, treating $x$ as a constant.
 <li>This results in  $A(x)$.
 <li>Evaluate the integral of $A(x)$ over $dx$.
</ol>
</div>
  
<p>How to do this in CoCalc:<br>
<img src="0g/12.2.doubleCC.jpg"><br>
<p>How to <a href="0g/12.2.how2.jpg">do this in <i>Mathematica</i></a>.


<h3>To Do</h3>

<ul class="todo"><li>
11.2.practice: Double integrals -  practice: #1-4
</li>
<li>11.2.shape: The shape of the solid
</ul>
<?php include "../../classes/3.h" ?>