<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
Cylindrical and Spherical Coordinates [11.8]
</title>
<meta name="week" content="11">
<!--meta name="nolink" content=""-->
<?php include "../../classes/2.h" ?>


<h1>Cylindrical and Spherical Coordinates [11.8]</h1>
<img src="0g/9.7.wholeworld.jpg">

<h3>Polar coordinates (2-d)</h3>
<p class="show"><img src="0g/9.7.polar.jpg">
<p>$(x,y)\to (r,\theta)$:
$$r^2=x^2+y^2;\ \ \ \tan \theta = \frac yx.$$
<p>$(r,\theta)\to(x,y)$:
$$x=r\cos\theta;\ \ \ y=r\sin\theta.$$


<h3>Cylindrical coordinates (3-d)</h3>
<p class="show"><img src="0g/9.7.cylindrical.jpg" class="rightalign">
Polar coordinates in the $x-y-$plane, plus $z$ which is the same in cylindrical and Cartesian coordinates.
<div class="justme">
<ul><a href="09.7.cylindrical.nb">Cylindrical Coordinates</a> (*.nb)<br>
<span style="font-size: 70%">"<a href="http://demonstrations.wolfram.com/CylindricalCoordinates">Cylindrical Coordinates</a>" from the Wolfram Demonstrations Project,Contributed by: Jeff Bryant</span>
</ul>
</div>

<h3>For example</h3>
<p class="show"><img src="0g/9.7.ex1.jpg" class="rightalign">
$(r,\theta,z)=(2,\frac{2\pi}{3},1)$:
<ul><li>$x=r\cos\theta = 2 (-\frac 12)=-1$
<li>$y=r\sin\theta=2 (\frac{\sqrt{3}}{2})=\sqrt 3$
<li>$z=z=1$
</ul>

<p>N.B. <b>If an angle measure doesn't explicitly have the degree mark, ${}^o$, it's in radians</b>!
<p>All the computer / math packages I've used, work primarily in radians.
<p><b>Converting</b>
$$\pi \text{ radians} = \frac 12\text{ rotation} = 180^o.$$
So, for example, $\pi/6$ radians...
$$\frac{\pi}{6}\text{ radians}\cdot \frac{180^o}{\pi\text{ radians}}=\frac{180^o}{6}=30^o.$$
 
<h3>Some surfaces</h3>
<p class="show">...which are easily specified in cylindrical coordinates
<p>$$r=c\nonumber$$<br>
<img src="0g/9.7.cylinder.jpg">

<p>$$r=z\nonumber$$
<img src="0g/9.7.cone.jpg">


<h3>Spherical coordinates (3-d)</h3>
<p class="show"><img src="0g/9.7.spherical.jpg">
<ul>
  <li>$\rho$ - "rho" - radial distance
  <li>$\theta$ - "theta" - <b>azimuthal</b> angle 
  <li>$\phi$ - "phi" - <b>polar</b> angle
</ul>



<p>This is the convention used by publishers of calculus textbooks, and Wolfram's own <i>MathWorld</i> website.

<p>However, physicists, engineers, <i>Mathematica</i> (in some contexts), <i>MatLab</i>, and even applied mathematicians use a <a href="0g/9.7.altconvention.jpg">different convention</a>, where $\theta$ is the polar angle and $\phi$ is the azimuthal angle.
<p> :-<

<p>In this course, we'll use the calc-textbook convention:

<p class="show"><img src="0g/9.7.spcalculate.jpg"><br>
Use $r\equiv$ projection of $\rho$ into $x-y-$plane=$\rho\sin\phi$:
<ul>
  <li>$x=r\cos\theta = \rho \sin\phi \cos\theta.$
  <li>$y=r\sin\theta = \rho \sin\phi \sin\theta.$
  <li>$z=\rho \cos \phi.$
</ul>


<h4>$(x,y,z)\to(\rho,\theta,\phi)$</h4>

<ul>
  <li>$\rho^2 = x^2+y^2+z^2.$
  <li>$\tan\theta = \frac yx.$
  <li>$\cos\phi =\frac z\rho.$
</ul>
<p class="justme">Discuss limits of angles phi and theta.
<h4>Example</h4>
<p class="show"><img src="0g/9.7.spexample.jpg">
<br>
$(\rho,\theta,\phi)=(2,\pi/4,\pi/3) \to (x,y,z)$?

<ul>
<li>$z=\rho \cos \frac{\pi}{3} = 1$
<li>$r=\rho \sin \frac{\pi}{3} = \sqrt 3$
<li>$x=r \cos \frac{\pi}{4}=\sqrt{3/2}\approx 1.22$
<li>$y=r \sin \frac{\pi}{4}\approx 1.22$
</ul>




<h3>Surfaces in spherical coordinates</h3>

<p class="show">$$\rho=c$$
<img src="0g/9.7.globe.jpg">

<p>
$$\theta=c$$
<img src="0g/9.7.sptheta.jpg">

<p>
$$\phi=c$$
<img src="0g/9.7.spcone.jpg">


<ul><li><a href="http://mathinsight.org/spherical_coordinates">Animation</a> at mathinsight.org

<li>In GeoGebra, you can plot a <tt>Surface( [x function], [y function], [z function], .....)</tt> parametrically in terms of two parameters. For example, <a href="https://www.geogebra.org/3d/gtaxkb8e">a sphere</a>.
<li class="justme"><a href="09.7.spherical.nb">Spherical Coordinates</a> (*.nb)<br>
<span style="size: 70%">"<a href="http://demonstrations.wolfram.com/SphericalCoordinates">Spherical Coordinates</a>" from the Wolfram Demonstrations Project,Contributed by: Jeff Bryant</span>
</ul>




<h3 id="goblet">To do</h3>
<div class="todo">
<ul class="else">
<li><img src="0g/9.7.goblet.jpg" class="rightalign"><b>Describe me</b>:<br><br>
Come up with an expression (in cylindrical coordinates) to approximately describe the surface of a goblet:
<p>Find an equation (well, actually several), $r(z),$ such that if you rotate the graph about the $z$ axis you'll get a shape that resembles a goblet .
You'll actually need one equation for each vertical segment of the goblet.  And then, if you don't specify $\theta$, it can take on any possible value. This is produces a "surface of rotation".

<p>To actually code this in Geogebra, you'll use the <b><tt>Surface(...)</tt></b> function, which allows you to specify a set of points, using two parameters.

<p>For example, a crude base to the goblet, might be to specify a straight cross section, (I'm thinking in millimeters):
$$r(z)=10-10z\ \text{ for }\ 0\lt z \lt 1$$
and then "rotate" this graph, by letting $\theta$ run from 0 to $2\pi$.

<p>In the $(x,y,z)$ coordinates that Geogebra wants, you'd have:
$$\nonumber x(\theta,z)=r(z)cos(\theta);$$
$$\nonumber y(\theta,z)=r(z)sin(\theta);$$
$$\nonumber z(\theta,z)=z$$

<p>Here's the <a href="https://www.geogebra.org/3d/uhnyqxsy">example</a>.
<p>You'll plot this in today's lab
</div>

<p>(Further detail about how to "hand in" this assignment in the "Lab 04" notebook file for today on CoCalc.)


<!--
<li>Mathematica: Coordinates - worksheet (See <a href="../handouts/Class04/">Class 4 Resources</a> for the notebook file.)
-->

</ul>

<br clear="all">
<h4 class="handout">Image credits</h4>
<p class="handout"><a href="http://www.flickr.com/photos/beth19/4923647610">Bethan Phillips</a>
<?php include "../../classes/3.h" ?>