<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>Line Integrals SUMMARY</title>
<meta name="week" content="15">
<meta name="description" content="
">
<?php include "../../classes/2.h" ?>

<h1>Line Integral summary</h1>
<p>By now, we've accumulated many strategies for calculating the line integral:
$$\int_C \myv F\cdot d\myv r$$
where
<ul><li>$\myv F$ is a vector function, with components $$\nonumber\myv F\equiv\myv
F(x,y,z)=P(x,y,z)\uv i+Q(x,y,z)\uv j+R(x,y,z)\uv k.$$
<li>$C$ is a label for a particular path / contour / curve in space.  Parameterized, the path is $\myv r(t)=\myc{ x(t), y(t), z(t)}$
<li>We can think of $d\myv r\equiv \uv T d s$ as a vector "step" along the path, (along the <i>arc</i>)  of length $|d\myv r|$ in a direction tangent to the path.
</ul>

<h2>Can you take the *Cosmic shortcut*?</h2>
<p>Is the curl of your vector field  zero everywhere??
$$\myv \grad \times \myv F \stackrel{?}{=}0 $$
If it is, then you know that a potential function exists such that
$\myv\grad f=\myv F$.  If you can guess the function $f$, great!  If you can't easily guess it, use our <a href="mv06.F.php#recipe">recipe to find it</a>.

<p>Once you have $f$ in hand, the answer will be:
$$\int_{\myv r_i}^{\myv r_f}\myv F\cdot d\myv r=f(\myv r_f)-f(\myv r_i).$$


<h2>Parameterize everything in sight!</h2>
<p>Parameterize the path in terms of a variable $t$, that is:
$$C\equiv \myv r(t)=\myc{ x(t), y(t), z(t) }.\nonumber$$
<p>In this approach, think of the parameter $t$ as the time. Then the velocity vector for a particle moving along the path $\myv r(t)$ is:
$$\nonumber \myv r'(t)=\myc{ x'(t), y'(t),z'(t)}
=\myc{ \frac{dx}{dt}, \frac{dy}{dt},\frac{dz}{dt}}.$$
The velocity vector is tangent to the path.  So, an increment of arclength $d\myv r$ along the path is (using displacement = velocity * time)
$$d\myv r= \myv r'\,dt\nonumber.$$

<p>We can write our vector integral as:
$$ \int_{t_i}^{t_f}\myv F(x(t),y(t),z(t))\cdot\langle x'(t),y'(t),z'(t)\rangle\,dt$$

<h3>Integrate the vector function's components separately</h3>
<p>With $\myv F= P(x,y,z)\uv i+Q(x,y,z)\uv j+R(x,y,z)\uv k$

<p>Write a line integral as:
$$\int \myv F\cdot d\myv r=\int P\,dx+\int Q\,dy+\int R\,dz.$$
This is particularly useful if some of your path is parallel to one of the $\uv i$, $\uv j$, or $\uv k$ directions.



<h3>Green's Theorem</h3>

<p>If you're integrating around a closed path, you can try <a href="mv06.Gr.php">using Green's theorem</a> to convert the line integral to a double integral over the enclosed area.




<?php include "../../classes/3.h" ?>