<?php $classpath="/213/"; include "../../classes/1.h"; ?>
<title>
10.2 - The Grim Reaper
</title>
<meta name="week" content="">

<!--meta name="nolink" content="nolink"-->
<?php include "../../classes/2.h" ?>
<link rel="stylesheet" href="0g/handoutprint.css" type="text/css" media="print" />
<h2>
10.2 - the Grim Reaper curve
</h2>

<p>Consider the curve $\myv r(w)=w\uv i-\ln(\cos w)\uv j$ 
on the interval $-\frac{\pi}{2} \lt w \lt \frac{\pi}{2}$.

<ol><li>Compute the tangent vector $\myv r'(w)$. For each value of $w$ in
$\{-\frac{\pi}{3},-\frac{\pi}{4},-\frac{\pi}{6},0,\frac{\pi}{6},
\frac{\pi}{4},\frac{\pi}{3}\}$
<img src="0g/10.2.grim.jpg" class="rightalign">
sketch a tangent vector.
<br clear="both">
<div class="justme result">
<p>$$\myv r(w)=\myc{w, -\ln(\cos w)}\equiv\myc{x(w),y(w)}.$$
Therefore the derivative vector is
$$\myv r'(w)\equiv\myc{\frac{d}{dw}x(w),\frac{d}{dw}y(w)}=\myc{1,\frac{\sin w}{\cos w}}.$$
Computing two values...
<p>$w=0$:
$$\myv r(0)=\myc{0, -\ln(\cos 0)}=\myc{0,0}.$$
$$\myv r'(0)=\myc{1,\frac{\sin 0}{\cos 0}}={1,0}$$

<p>$w=\frac \pi 3$:
$$\myv r(\pi/3)=\myc{\pi/3, -\ln(1/2)}\approx\myc{1.05,0.69}.$$
$$\myv r'(0)=\myc{1,\frac{\sin(\pi/3)}{\cos(\pi/3)}}=\myc{1,\sqrt 3}\approx\myc{1,1.73}$$

</div>
<li>For any value of $w$, what is the 
length of the tangent vector $\myv r'(w)$? 
Find an equation for the unit tangent vector $\uv T (w)$.
<br><br><p class="justme result">
$$|\myv r'(w)|=
\sqrt{1^2+\sin^2 w / \cos^2 w}
=\sqrt{\frac{\cos^2 w+\sin^2 w}{\cos^2 w}}=
\frac{1}{\cos w}$$
So, the unit tangent vector is:
$$\uv T(w)=\frac{\myv r'(w)}{|\myv r'(w)|}
=\frac{\myc{1,\frac{\sin w}{\cos w}}}{1/\cos w}
=\cos w\myc{1,\frac{\sin w}{\cos w}}
=\myc{\cos w, \sin w}

$$
<br><br>
<li>For any value of $w$, what angle does the unit 
tangent vector $\uv T (w) $ make with the $x$-axis?
<br><br><p class="justme result">
Call the angle with the $x$-axis "$\theta$".  Draw a right triangle, and you can hopefully readily see that, for any 2-d vector $\myv v$:
$$\tan\theta=\frac{v_y}{v_x}$$
So, we divide the $y$-component of our unit tangent vector by its $x$-component:
$$\tan\theta = \frac{\sin w}{\cos w}\equiv\tan w$$
Oh, one definition of tangent of $w$ is just $\sin w/\cos w$.  So based on the equation above, the angle that we're looking for is nothing other than 
$$\theta = w.$$
<br><br>
<li>Find a vector $\myv N(w)$ perpendicular to $\uv T(w)$ and pointing away from
the curve $\myv r(w)$.

<p class="justme result">
You may remember that two lines with slopes $m_1$ and $m_2$ are perpendicular to each other if $m_1m_2=-1$. Or, if we have a line with slope $m_1$, then a second line with slope $m_2=-1/m_1$ will be perpendicular.  The "slope" is the same as the tangent of the angle with the x-axis.  
<br><br>Seeing as how the slope of our tangent line is $\tan w=\sin w/\cos w$, we should like a vector with a ratio of $N_y/N_x=-1/(\sin w/\cos w)=-(\cos w/\sin w)$.  For example $\myv N=\myc {-\sin w, \cos w}$.  (Another choice, $\myv N=\myc{\sin w, -\cos w}$ is also perpendicular to the curve.)
</ol>

<h4>Mathematical history</h4>

<p>The grim reaper is an ancient solution to the problem of "curve-shortening flow".  The idea is to move every point on a curve:
<ul>
  <li>with a speed which is proportional to the curvature at that point,
  <li>in a normal direction from the curve,
  <li>in the convex direction.
</ul>

<p>See for example:
<iframe width="560" height="315" src="https://www.youtube.com/embed/8Ez0QoJ3XG8" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>


<p>Perhaps you can imagine that with these rules:
<ul>

<li>A line will not change at all, since its curvature is everywhere 0.
<li>Any convex, closed loop will eventually evolve towards a circle, and will eventually disappear,

</ul>

<p>The grim reaper has the peculiar property that it will move under curve-shortening flow, but <i>its shape will remain unchanged</i>.

 

<?php include "../../classes/3.h" ?>
