(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     19762,        536]
NotebookOptionsPosition[     17381,        476]
NotebookOutlinePosition[     17866,        495]
CellTagsIndexPosition[     17823,        492]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["9.2 Vectors in the Plane", "Section",
 CellChangeTimes->{{3.544177973642514*^9, 3.5441779790258217`*^9}, 
   3.5763508212679863`*^9, {3.64701474649677*^9, 
   3.6470147481803637`*^9}},ExpressionUUID->"261acaf0-5c25-43ef-b166-\
c6ed075ba389"],

Cell[CellGroupData[{

Cell["Vectors in the Plane", "Subsection",
 CellChangeTimes->{{3.544198386547574*^9, 3.544198389714862*^9}, {
  3.7342845823316708`*^9, 
  3.734284589897407*^9}},ExpressionUUID->"84dd0a40-0fc2-4f9b-b937-\
b7bcb5c03c5d"],

Cell[CellGroupData[{

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "=", 
    RowBox[{"(", 
     RowBox[{"1", ",", "3"}], ")"}]}], TraditionalForm]],ExpressionUUID->
  "d41a2b07-bfd9-4d7d-8b60-51bd5b89e5ca"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", "=", 
    RowBox[{"(", 
     RowBox[{"2", ",", "1"}], ")"}]}], TraditionalForm]],ExpressionUUID->
  "02bb4d9d-7b09-4eb8-ad75-f3b5306ca683"],
 " be points in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "2"], TraditionalForm]],
  ExpressionUUID->"9a1dc92d-c02e-4089-9491-f0d19955f30e"],
 ". \[LineSeparator]",
 Cell[BoxData[
  GraphicsBox[PointBox[{0, 0}],
   Axes->True,
   GridLines->{{-4, -3, -2, -1, 0, 1, 2, 3, 4}, {-4, -3, -2, -1, 0, 1, 2, 3, 
    4}},
   ImageSize->{399.1437499999969, Automatic},
   PlotRange->{{-4, 4}, {-4, 4}}]],
  CellChangeTimes->{{3.5441978892388363`*^9, 3.544197939945011*^9}, 
    3.544197973490328*^9},ExpressionUUID->
  "9880ff6d-80d5-4386-8a69-cce4aca40957"],
 " "
}], "ItemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
  3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
  3.544178473060079*^9}, {3.5441796907817287`*^9, 3.5441796907957296`*^9}, {
  3.544198005942904*^9, 3.5441980066294007`*^9}, {3.5441981499054036`*^9, 
  3.54419815137201*^9}, {3.544198306225419*^9, 
  3.5441983067402983`*^9}},ExpressionUUID->"9e634310-1e5c-4404-bfdd-\
65315506f7bc"],

Cell[CellGroupData[{

Cell["Graph these points.  ", "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
  3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
  3.544178473060079*^9}, {3.5441796907817287`*^9, 3.544179711743928*^9}, {
  3.647015163957395*^9, 
  3.647015177803481*^9}},ExpressionUUID->"803ea0d3-cc77-4f7f-b7f6-\
35f717c842c3"],

Cell[TextData[{
 "Graph the vector ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["PQ",
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]],
  ExpressionUUID->"d939466b-4f2f-47fa-937a-1cdcb8f68ded"],
 ".  What are its components?  \[LineSeparator]",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      RowBox[{"(", 
       OverscriptBox[
        StyleBox["PQ",
         FontSlant->"Italic"], "\[RightVector]"], ")"}], "x"], "\[Congruent]",
      "c"}], "="}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "3dac5935-e776-46b9-b129-114e915d40f5"],
 "____      ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      RowBox[{"(", 
       OverscriptBox[
        StyleBox["PQ",
         FontSlant->"Italic"], "\[RightVector]"], ")"}], "y"], "\[Congruent]",
      "d"}], "="}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "729cfb98-ae21-4ec5-bc30-a859d9514be4"],
 "____"
}], "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
   3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
   3.544178473060079*^9}, {3.5441796907817287`*^9, 3.544179722060518*^9}, {
   3.6470148316733*^9, 3.6470148354315653`*^9}, {3.6470151666041517`*^9, 
   3.647015175153879*^9}, 3.6470158427857227`*^9, {3.7657264672890997`*^9, 
   3.765726481094122*^9}, {3.765726549379381*^9, 3.765726679524214*^9}, {
   3.765726905060471*^9, 3.765726945448965*^9}, {3.765727012535082*^9, 
   3.765727023038418*^9}},ExpressionUUID->"32f5e094-3682-4ceb-bd86-\
c67d76c7e226"],

Cell["Graph the equivalent vector with base at the origin.  ", \
"SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
  3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
  3.544178473060079*^9}, {3.5441796907817287`*^9, 
  3.5441797255637183`*^9}},ExpressionUUID->"aef3bdbf-5df9-4cfd-a722-\
ada63d7b9f65"],

Cell["\<\
Graph an equivalent vector that does not have its base at the origin.  \
\>", "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
  3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
  3.544178473060079*^9}, {3.5441796907817287`*^9, 
  3.544179729634951*^9}},ExpressionUUID->"4151bca4-7c12-4854-ac02-\
de552e8e99c8"],

Cell[TextData[{
 "Graph a ",
 StyleBox["parallel vector that is not equivalent",
  FontSlant->"Italic"],
 ".  "
}], "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
  3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
  3.544178473060079*^9}, {3.5441796907817287`*^9, 
  3.5441797407315855`*^9}},ExpressionUUID->"57ed8cdc-c76a-41a9-8b5f-\
66d944f175fc"],

Cell[TextData[{
 StyleBox["Determine the length",
  FontSlant->"Italic"],
 " of the vector ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["PQ",
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]],
  ExpressionUUID->"0ff24790-6b2c-4b22-ba29-023cc27d753c"],
 ".  ",
 StyleBox["Explain why",
  FontSlant->"Italic"],
 " this is the length.  \[LineSeparator]\[LineSeparator]\[LineSeparator]"
}], "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
   3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
   3.544178473060079*^9}, {3.5441796907817287`*^9, 3.5441797709413137`*^9}, {
   3.647015187828985*^9, 3.6470151882937593`*^9}, 3.647015584077827*^9, {
   3.647015638073422*^9, 3.6470156395656157`*^9}, 
   3.647015848944762*^9},ExpressionUUID->"58789eaf-6b88-4834-9bc0-\
0ae8b37505ba"],

Cell[TextData[{
 "Draw the line that passes through the points ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]],ExpressionUUID->
  "368fa465-bdec-400a-91fc-3a98d09114d9"],
 " and ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]],ExpressionUUID->
  "f851e8a7-c2bb-4f9a-b094-14cff2d1136c"],
 ".  "
}], "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
   3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
   3.544178473060079*^9}, {3.5441796907817287`*^9, 3.544179776863652*^9}, {
   3.6470157263249817`*^9, 3.647015727293673*^9}, 3.6470158506663713`*^9, {
   3.734284510050156*^9, 3.734284517211913*^9}, {3.765725945679088*^9, 
   3.765725955475154*^9}},ExpressionUUID->"06732efa-b9a8-497e-bf98-\
12768f6498fc"],

Cell[TextData[{
 "Find the equation for this line in the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    RowBox[{
     RowBox[{"m", " ", "x"}], "+", "b"}]}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "3e0cc7b6-191e-4dc6-b627-e8fb5aa6d2fa"],
 ". "
}], "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
   3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
   3.544178473060079*^9}, {3.5441796907817287`*^9, 3.544179776863652*^9}, {
   3.6470157263249817`*^9, 3.647015727293673*^9}, 3.6470158506663713`*^9, {
   3.734284510050156*^9, 3.734284517211913*^9}, {3.765725945679088*^9, 
   3.765726075579012*^9}, {3.765727044805332*^9, 
   3.765727122776252*^9}},ExpressionUUID->"222bc858-49a8-4093-a485-\
5002817e3692"],

Cell[TextData[{
 "Express ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "06f1ed1e-f02c-4da5-a094-db1474ee8fc3"],
 " in terms of the components ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c471c4d4-7bea-4091-99a0-2d55ed15004d"],
 " and ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "2fb5db7e-7d5f-4625-b2d1-b73bdd802764"],
 " of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["PQ",
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]],
  ExpressionUUID->"b505d07a-1e0d-40ab-b16c-98a6ff918d18"],
 ". \[LineSeparator]\[LineSeparator]\[LineSeparator]"
}], "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
   3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
   3.544178473060079*^9}, {3.5441796907817287`*^9, 3.544179780011832*^9}, {
   3.544183523926747*^9, 3.5441835239423447`*^9}, {3.647014890825395*^9, 
   3.647014924804734*^9}, {3.64701519751375*^9, 3.6470152059739103`*^9}, 
   3.6470155820431356`*^9, {3.647015644840226*^9, 3.647015659909463*^9}, {
   3.647015720574963*^9, 3.647015730430785*^9}, 3.6470158525879717`*^9, 
   3.734284522130734*^9, {3.7342851362200117`*^9, 3.7342851374747953`*^9}, {
   3.7342852047791853`*^9, 3.73428520686654*^9}, 3.765727129301152*^9, {
   3.765730382794771*^9, 
   3.765730383885055*^9}},ExpressionUUID->"e4127ed6-ea36-48d5-8c20-\
d747dd3ba104"],

Cell[TextData[{
 "Find a ",
 StyleBox["parametric",
  FontSlant->"Italic"],
 " equation, in the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"(", " ", 
       RowBox[{
        RowBox[{"x", "(", "t", ")"}], ",", 
        RowBox[{"y", "(", "t", ")"}]}], " ", ")"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", ",", "b"}], ")"}], "+", 
        RowBox[{"t", " ", 
         RowBox[{"(", 
          RowBox[{"e", ",", "f"}], ")"}]}]}], ":", 
       RowBox[{"0", "<", "t", "<", "1"}]}]}], "}"}], " ", ","}], 
   TraditionalForm]],ExpressionUUID->"65fa3c46-6b61-483a-ae65-2593bdb95efd"],
 " describing the coordinates of the points on the line ",
 StyleBox["segment",
  FontSlant->"Italic"],
 " between ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]],ExpressionUUID->
  "3eb119fd-511f-4cca-abef-2033b06944f2"],
 " and ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]],ExpressionUUID->
  "76fdca78-4602-4231-a2dc-46715577c067"],
 ". [Hint to get you started: when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "c24d983c-b463-485a-9a9a-d2ed1af50ec6"],
 ", you only have to worry about finding ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "2f1da61b-a61e-411e-af49-bebbeb499442"],
 " and ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "0c88809b-2c36-45e5-8b06-9460a945a563"],
 ".]\[LineSeparator]\[LineSeparator]\[LineSeparator]\[LineSeparator]\
\[LineSeparator]"
}], "SubitemNumbered",
 CellChangeTimes->{{3.5441779926886034`*^9, 3.5441781549218826`*^9}, {
   3.544178212309165*^9, 3.5441782630910697`*^9}, {3.5441783887062545`*^9, 
   3.544178473060079*^9}, {3.5441796907817287`*^9, 3.5441797800048323`*^9}, {
   3.544197352474716*^9, 3.544197352474716*^9}, {3.6470149480994883`*^9, 
   3.647014982421617*^9}, {3.64701503039006*^9, 3.6470150687078667`*^9}, {
   3.647015211603298*^9, 3.6470152119547653`*^9}, 3.6470155801726923`*^9, 
   3.647015661757656*^9, {3.6470157323987503`*^9, 3.647015733094055*^9}, 
   3.64701585513405*^9, 3.73428452741327*^9, {3.765727222255167*^9, 
   3.765727223213881*^9}, {3.765727261128893*^9, 3.765727273433576*^9}, {
   3.7657273548668737`*^9, 3.765727363260153*^9}, {3.765727427335539*^9, 
   3.765727430607574*^9}, {3.765727474939649*^9, 3.765727551862412*^9}, {
   3.76572777979259*^9, 3.765727829423685*^9}, {3.765729844156979*^9, 
   3.7657299826887417`*^9}},ExpressionUUID->"0c113f3b-8b53-49ea-b291-\
b74fff0ae06f"]
}, Open  ]],

Cell[TextData[{
 "Consider the graphed vectors.",
 "\n",
 Cell[BoxData[
  GraphicsBox[{ArrowBox[{{0, 0}, {4, 2}}], ArrowBox[{{0, 0}, {-1, 3}}], 
    InsetBox["P", {4, 2}, {-1, -1}], InsetBox["Q", {-1, 3}, {1, -1}], 
    InsetBox["O", {0, 0}, {1, 1}]},
   Axes->True,
   GridLines->{{-2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, {0, 1, 2, 
     3, 4, 5, 6, 7, 8}},
   PlotRange->{{-2, 12}, {0, 8}}]],
  CellChangeTimes->{
   3.544178729232731*^9, {3.544178761747591*^9, 3.544178782856798*^9}, 
    3.544178949901353*^9, 3.544179025796694*^9, 3.544179064110885*^9, 
    3.54417910353514*^9, 3.54417922067484*^9},ExpressionUUID->
  "784c21c9-9726-4e95-8790-19fe7c5de079"]
}], "ItemNumbered",
 CellChangeTimes->{{3.544178812108472*^9, 3.544178871686879*^9}, {
   3.5441791529139643`*^9, 3.5441791569321947`*^9}, {3.544179241242017*^9, 
   3.5441793591367598`*^9}, {3.5441795351598277`*^9, 3.544179597560397*^9}, {
   3.544179819171072*^9, 3.544179830801738*^9}, 3.544179898590615*^9, {
   3.5441843657415423`*^9, 
   3.544184369079921*^9}},ExpressionUUID->"e320a9c7-6792-47e1-825f-\
5391bcd2a8f2"],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the components of the vectors ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]],ExpressionUUID->
  "8c80aa6b-339f-4962-ab8c-0171a10fdcb9"],
 "= ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["OP", "\[RightVector]"], TraditionalForm]],ExpressionUUID->
  "6ce92dd5-7774-4a32-9871-3ab4bb71c08c"],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]],
  FontWeight->"Bold",ExpressionUUID->"68bdb5bd-8545-4910-b1d3-860b828efe30"],
 "=",
 Cell[BoxData[
  FormBox[
   OverscriptBox["OQ", "\[RightVector]"], TraditionalForm]],ExpressionUUID->
  "5a19b3da-9af6-4476-8ed6-1c26cc4df424"],
 ".   \[LineSeparator]\[LineSeparator]",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]],ExpressionUUID->
  "955f56d5-6f20-4175-add1-0b0fca26e269"],
 "=<_____, _____>\[LineSeparator]\[LineSeparator]",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]],ExpressionUUID->
  "68c6f3bf-f523-4196-9626-b4b11b714843"],
 "=<_____, _____>\[LineSeparator]"
}], "SubitemNumbered",
 CellChangeTimes->{{3.544178812108472*^9, 3.544178871686879*^9}, {
   3.5441791529139643`*^9, 3.5441791569321947`*^9}, {3.544179241242017*^9, 
   3.5441793591367598`*^9}, {3.5441795351598277`*^9, 3.544179597560397*^9}, {
   3.544179819171072*^9, 3.5441798661197577`*^9}, 3.6470152438333063`*^9, {
   3.734253738948453*^9, 
   3.7342538787099123`*^9}},ExpressionUUID->"a19050cc-31f9-4383-aa5a-\
45d0e64d6217"],

Cell[TextData[{
 "Determine ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", 
    StyleBox["u",
     FontWeight->"Bold"]}], TraditionalForm]],ExpressionUUID->
  "f945268c-75cf-48a4-ae6c-0894f953fc55"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["u",
     FontWeight->"Bold"], "+", 
    StyleBox["v",
     FontWeight->"Bold"]}], TraditionalForm]],ExpressionUUID->
  "79e4204b-3070-454f-b665-75f55fb54cd7"],
 " numerically and graphically.  \[LineSeparator]"
}], "SubitemNumbered",
 CellChangeTimes->{{3.544178812108472*^9, 3.544178871686879*^9}, {
   3.5441791529139643`*^9, 3.5441791569321947`*^9}, {3.544179241242017*^9, 
   3.5441793591367598`*^9}, {3.5441795351598277`*^9, 3.544179597560397*^9}, {
   3.544179819171072*^9, 3.5441798709980364`*^9}, 
   3.647015252723262*^9},ExpressionUUID->"e9593639-14fd-4821-83db-\
3066924f23ad"],

Cell[TextData[{
 "Write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["w",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"2", ",", "8"}], "\[RightAngleBracket]"}]}], TraditionalForm]],
  ExpressionUUID->"5acd932b-ce2c-465f-ab90-a6888afa7886"],
 " as a ",
 StyleBox["linear combination",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]],ExpressionUUID->
  "bdb2b0fd-bef1-4847-84bb-29f3b2f0270f"],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]],
  FontWeight->"Bold",ExpressionUUID->"2f9638e8-c4c0-4f6f-9d65-0f8f22cc80dd"],
 ".  (A \[OpenCurlyDoubleQuote]linear combination\[CloseCurlyDoubleQuote] \
means adding and/or subtracting scalar multiples of of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]],ExpressionUUID->
  "f11276c5-de8f-4fd7-bbe0-ebe59231b80a"],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]],
  FontWeight->"Bold",ExpressionUUID->"16eec073-2fd5-4af0-b7b5-9014e41c30c4"],
 ".)"
}], "SubitemNumbered",
 CellChangeTimes->{{3.544178812108472*^9, 3.544178871686879*^9}, {
  3.5441791529139643`*^9, 3.5441791569321947`*^9}, {3.544179241242017*^9, 
  3.5441793591367598`*^9}, {3.5441795351598277`*^9, 3.544179597560397*^9}, {
  3.544179819171072*^9, 3.5441798709650345`*^9}, {3.7657276410997972`*^9, 
  3.765727692113168*^9}},ExpressionUUID->"5eae24d3-4940-4ebb-9bd1-\
be22925e10fc"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 867},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 27, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 247, 4, 64, "Section", "ExpressionUUID" -> \
"b2923de0-9831-433e-8fb9-ff3c746a0072"],
Cell[CellGroupData[{
Cell[851, 30, 219, 4, 44, "Subsection", "ExpressionUUID" -> \
"dc4564d3-8440-4bac-a4b0-11f94f4a76ab"],
Cell[CellGroupData[{
Cell[1095, 38, 1439, 39, 436, "ItemNumbered", "ExpressionUUID" -> \
"9e634310-1e5c-4404-bfdd-65315506f7bc"],
Cell[CellGroupData[{
Cell[2559, 81, 377, 6, 24, "SubitemNumbered", "ExpressionUUID" -> \
"e3e0cc6d-62f5-4ec6-a052-f7fb855be689"],
Cell[2939, 89, 1613, 44, 51, "SubitemNumbered", "ExpressionUUID" -> \
"32f5e094-3682-4ceb-bd86-c67d76c7e226"],
Cell[4555, 135, 365, 6, 24, "SubitemNumbered", "ExpressionUUID" -> \
"e594aefa-8a0c-469b-95f4-5d445ca0977a"],
Cell[4923, 143, 386, 7, 24, "SubitemNumbered", "ExpressionUUID" -> \
"89cfb180-3b44-4286-93dc-5b8fee63612a"],
Cell[5312, 152, 416, 10, 24, "SubitemNumbered", "ExpressionUUID" -> \
"fdea1651-ecdc-4211-863b-b381c8b1ae40"],
Cell[5731, 164, 867, 21, 78, "SubitemNumbered", "ExpressionUUID" -> \
"9b00a4c5-f635-4912-a11b-6eaf77f9425c"],
Cell[6601, 187, 776, 17, 25, "SubitemNumbered", "ExpressionUUID" -> \
"06732efa-b9a8-497e-bf98-12768f6498fc"],
Cell[7380, 206, 814, 18, 26, "SubitemNumbered", "ExpressionUUID" -> \
"222bc858-49a8-4093-a485-5002817e3692"],
Cell[8197, 226, 1546, 36, 79, "SubitemNumbered", "ExpressionUUID" -> \
"e4127ed6-ea36-48d5-8c20-d747dd3ba104"],
Cell[9746, 264, 2627, 66, 147, "SubitemNumbered", "ExpressionUUID" -> \
"0c113f3b-8b53-49ea-b291-b74fff0ae06f"]
}, Open  ]],
Cell[12388, 333, 1099, 23, 252, "ItemNumbered", "ExpressionUUID" -> \
"7d458129-5aac-4457-a164-b5f34d1a6f01"],
Cell[CellGroupData[{
Cell[13512, 360, 1495, 41, 115, "SubitemNumbered", "ExpressionUUID" -> \
"a2a215ee-f3a9-4eb5-a2da-5f78d2e8ca74"],
Cell[15010, 403, 848, 24, 42, "SubitemNumbered", "ExpressionUUID" -> \
"33ac1f4d-513f-4f26-a4ef-87d3f09f16c1"],
Cell[15861, 429, 1468, 41, 43, "SubitemNumbered", "ExpressionUUID" -> \
"5eae24d3-4940-4ebb-9bd1-be22925e10fc"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

