(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     38652,        983]
NotebookOptionsPosition[     37389,        936]
NotebookOutlinePosition[     38055,        962]
CellTagsIndexPosition[     38012,        959]
WindowTitle->Cross Product of Vectors in the y-z Plane - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "[Lab 2] Cross Product of Vectors in the ",
 StyleBox["y",
  FontSlant->"Italic"],
 "-",
 StyleBox["z",
  FontSlant->"Italic"],
 " Plane"
}], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 CellChangeTimes->{{3.650221503156438*^9, 3.6502215061361303`*^9}},
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"vv", ",", "ww", ",", "angles", ",", "proj", ",", "cros"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"vv", "=", 
       RowBox[{"Normalize", "[", "v", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ww", "=", 
       RowBox[{"Normalize", "[", "w", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"cros", "=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"v", "[", 
           RowBox[{"[", "1", "]"}], "]"}], 
          RowBox[{"w", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "-", 
         RowBox[{
          RowBox[{"v", "[", 
           RowBox[{"[", "2", "]"}], "]"}], 
          RowBox[{"w", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"angles", "=", 
       RowBox[{"Sort", "[", 
        RowBox[{"N", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ArcTan", "@@", "vv"}], ",", 
           RowBox[{"ArcTan", "@@", "ww"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<-x\>\"", ",", "Italic"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"2.5", ",", "2.5"}], "}"}], ",", 
            RowBox[{"-", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<-4\>\"", ",", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", 
                RowBox[{"-", "1."}]}], "}"}]}], "2"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<4\>\"", ",", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1."}], ",", 
               RowBox[{"-", "1."}]}], "}"}], "2"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1."}], ",", 
              RowBox[{"-", "1."}]}], "}"}], "2"}], "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1."}], ",", 
               RowBox[{"-", "1."}]}], "}"}]}], "2"}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<-3\>\"", ",", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", 
                RowBox[{"-", "1."}]}], "}"}]}], 
             RowBox[{"3", "/", "2"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<3\>\"", ",", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1."}], ",", 
               RowBox[{"-", "1."}]}], "}"}], 
             RowBox[{"3", "/", "2"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1."}], ",", 
              RowBox[{"-", "1."}]}], "}"}], 
            RowBox[{"3", "/", "2"}]}], "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1."}], ",", 
               RowBox[{"-", "1."}]}], "}"}]}], 
            RowBox[{"3", "/", "2"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<-2\>\"", ",", 
            RowBox[{"-", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1."}], ",", 
               RowBox[{"-", "1."}]}], "}"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<2\>\"", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1."}], ",", 
              RowBox[{"-", "1."}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1."}], ",", 
             RowBox[{"-", "1."}]}], "}"}], "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{"-", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1."}], ",", 
              RowBox[{"-", "1."}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<-1\>\"", ",", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", 
                RowBox[{"-", "1."}]}], "}"}]}], "/", "2"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<1\>\"", ",", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1."}], ",", 
               RowBox[{"-", "1."}]}], "}"}], "/", "2"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1."}], ",", 
              RowBox[{"-", "1."}]}], "}"}], "/", "2"}], "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1."}], ",", 
               RowBox[{"-", "1."}]}], "}"}]}], "/", "2"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.9", "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "2"}], ",", 
                 RowBox[{"-", "2"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"If", "[", 
            RowBox[{"showPar", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"cros", ">", "0"}], ",", 
                 RowBox[{"RGBColor", "[", 
                  RowBox[{"1", ",", "0.6", ",", "0.7"}], "]"}], ",", 
                 RowBox[{"RGBColor", "[", 
                  RowBox[{"0.6", ",", "0.7", ",", "1"}], "]"}]}], "]"}], ",", 
               RowBox[{"Polygon", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", "0"}], "}"}], ",", "v", ",", 
                  RowBox[{"v", "+", "w"}], ",", "w"}], "}"}], "]"}]}], "}"}], 
             ",", 
             RowBox[{"{", "}"}]}], "]"}], "}"}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"cros", "<", "0"}], ",", 
              RowBox[{"Hue", "[", ".7", "]"}], ",", 
              RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", ".47", ",", "0"}], "]"}]}], "]"}], ",", 
            RowBox[{"Circle", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", ".3", ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"Subtract", "@@", "angles"}]}], "<", "\[Pi]"}], ",",
                 "angles", ",", 
                RowBox[{
                 RowBox[{"Reverse", "[", "angles", "]"}], "+", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"2", "\[Pi]"}]}], "}"}]}]}], "]"}]}], "]"}]}], 
           "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", "v"}], "}"}], "]"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", "w"}], "}"}], "]"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"cros", ">", "0"}], ",", 
              RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", ".47", ",", "0"}], "]"}], ",", 
              RowBox[{"ColorData", "[", 
               RowBox[{"\"\<HTML\>\"", ",", "\"\<SlateBlue\>\""}], "]"}]}], 
             "]"}], ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", 
               RowBox[{"cros", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "/", "2"}], ",", 
                  RowBox[{
                   RowBox[{"-", "1"}], "/", "2"}]}], "}"}]}]}], "}"}], 
             "]"}]}], "}"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{
           "\"\<\!\(\*OverscriptBox[\(v\), \(\[RightVector]\)]\)\>\"", ",", 
            RowBox[{"v", " ", 
             RowBox[{"3", "/", "4"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{
           "\"\<\!\(\*OverscriptBox[\(w\), \(\[RightVector]\)]\)\>\"", ",", 
            RowBox[{"3", 
             RowBox[{"w", "/", "4"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{
           "\"\<\!\(\*OverscriptBox[\(v\), \(\[RightVector]\)]\)\[ThinSpace]\
\[Cross]\[ThinSpace]\!\(\*OverscriptBox[\(w\), \(\[RightVector]\)]\)\>\"", 
            ",", 
            RowBox[{"cros", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "/", "2"}], ",", 
               RowBox[{
                RowBox[{"-", "1"}], "/", "2"}]}], "}"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "\[IndentingNewLine]",
          "}"}], ",", 
        RowBox[{"Axes", "\[Rule]", "True"}], ",", 
        RowBox[{"Ticks", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "3"}], ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<y\>\"", ",", "Italic"}], "]"}], ",", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<z\>\"", ",", "Italic"}], "]"}]}], "}"}]}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Grid", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"cros", ">", "0"}], ",", 
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<acute or obtuse angle\>\"", ",", 
                  RowBox[{"RGBColor", "[", 
                   RowBox[{"1", ",", ".47", ",", "0"}], "]"}]}], "]"}], ",", 
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<reflex angle\>\"", ",", 
                  RowBox[{"ColorData", "[", 
                   RowBox[{"\"\<HTML\>\"", ",", "\"\<SlateBlue\>\""}], 
                   "]"}]}], "]"}]}], "]"}], ",", 
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                "\"\<|\!\(\*OverscriptBox[\(v\), \(\[RightVector]\)]\)\
\[ThinSpace]\[Cross]\[ThinSpace]\!\(\*OverscriptBox[\(w\), \
\(\[RightVector]\)]\)| = \>\"", ",", 
                 RowBox[{"NumberForm", "[", 
                  RowBox[{
                   RowBox[{"Abs", "[", "cros", "]"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"4", ",", "3"}], "}"}], ",", 
                   RowBox[{"ExponentFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{"Null", "&"}], ")"}]}]}], "]"}]}], "}"}], "]"}]}],
              "}"}], "}"}], ",", 
           RowBox[{"ItemSize", "\[Rule]", "10"}]}], "]"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"400", ",", "400"}], "}"}]}]}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"showPar", ",", "True", ",", "\"\<show parallelogram\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", ",", 
       RowBox[{"{", 
        RowBox[{"1.", ",", "0.5"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", "Locator", ",", 
     RowBox[{"Appearance", "\[Rule]", "None"}], ",", 
     RowBox[{"Exclusions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"w", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2."}], ",", "1."}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", "Locator", ",", 
     RowBox[{"Appearance", "\[Rule]", "None"}], ",", 
     RowBox[{"Exclusions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.4016591107396708`*^9, 3.4016595095313797`*^9, {
   3.401661170234079*^9, 3.401661190443899*^9}, {3.401661235254653*^9, 
   3.4016612867426357`*^9}, 3.4016613429606037`*^9, 3.401661764791361*^9, {
   3.4017127450847692`*^9, 3.401712756240876*^9}, {3.4017160557822065`*^9, 
   3.4017160667978315`*^9}, {3.4018213193642044`*^9, 
   3.4018213255361977`*^9}, {3.4029178619846597`*^9, 
   3.4029178621721597`*^9}, {3.407296165296875*^9, 3.407296216796875*^9}, {
   3.40729628525*^9, 3.40729632196875*^9}, {3.40729636703125*^9, 
   3.407296485640625*^9}, {3.4072965304375*^9, 3.40729655690625*^9}, {
   3.4072969008125*^9, 3.407296907265625*^9}, 3.40729701415625*^9, {
   3.407297093015625*^9, 3.407297155140625*^9}, {3.407297208296875*^9, 
   3.407297312109375*^9}, {3.40729753109375*^9, 3.407297531671875*^9}, {
   3.40729756215625*^9, 3.407297563515625*^9}, {3.407297652921875*^9, 
   3.407297658984375*^9}, {3.407297704703125*^9, 3.407297718453125*^9}, {
   3.407297898171875*^9, 3.407297907046875*^9}, {3.407298042625*^9, 
   3.407298093109375*^9}, 3.407298260359375*^9, {3.40729830975*^9, 
   3.407298339421875*^9}, {3.4072984046875*^9, 3.407298444234375*^9}, 
   3.407298498*^9, {3.407298570703125*^9, 3.407298572625*^9}, {
   3.407298613796875*^9, 3.40729864509375*^9}, 3.4072987195625*^9, {
   3.40729880996875*^9, 3.40729883940625*^9}, {3.407298883984375*^9, 
   3.407298886546875*^9}, {3.407298917359375*^9, 3.40729891984375*^9}, {
   3.40729898671875*^9, 3.407298987484375*^9}, {3.40729903396875*^9, 
   3.407299034984375*^9}, {3.407299117953125*^9, 3.407299153265625*^9}, {
   3.40729925053125*^9, 3.407299265859375*^9}, {3.407299726421875*^9, 
   3.407299744640625*^9}, {3.40730092671875*^9, 3.407300957921875*^9}, 
   3.40730099221875*^9, {3.40730120971875*^9, 3.407301280796875*^9}, {
   3.4073013195*^9, 3.407301334765625*^9}, {3.40730137275*^9, 
   3.407301375140625*^9}, {3.407301451984375*^9, 3.407301484984375*^9}, {
   3.407301531453125*^9, 3.407301630375*^9}, {3.407303847734375*^9, 
   3.407303902375*^9}, 3.40730395615625*^9, {3.40730398621875*^9, 
   3.40730401265625*^9}, {3.407304114515625*^9, 3.4073041189375*^9}, {
   3.4073041944375*^9, 3.4073042190625*^9}, {3.407304256703125*^9, 
   3.4073042596875*^9}, {3.407304638125*^9, 3.407304641921875*^9}, {
   3.40730471959375*^9, 3.40730472421875*^9}, {3.407304906515625*^9, 
   3.40730498796875*^9}, {3.407305060953125*^9, 3.407305103015625*^9}, {
   3.407305147140625*^9, 3.407305280234375*^9}, {3.407305313421875*^9, 
   3.40730531646875*^9}, {3.407305443578125*^9, 3.407305494765625*^9}, {
   3.40730553115625*^9, 3.407305580921875*^9}, 3.40730562859375*^9, {
   3.407305804109375*^9, 3.407305805375*^9}, {3.407305860796875*^9, 
   3.407305864453125*^9}, {3.40730591903125*^9, 3.407305952046875*^9}, {
   3.4073060010625*^9, 3.407306012984375*^9}, {3.407306076734375*^9, 
   3.40730608025*^9}, {3.40730613075*^9, 3.407306142421875*^9}, {
   3.407306182671875*^9, 3.40730623475*^9}, {3.4073063748125*^9, 
   3.407306377859375*^9}, {3.407306595421875*^9, 3.40730663646875*^9}, {
   3.407306753640625*^9, 3.40730683765625*^9}, {3.40730688165625*^9, 
   3.407306893625*^9}, {3.407306925875*^9, 3.407306940359375*^9}, {
   3.407307013078125*^9, 3.4073070139375*^9}, 3.407307165328125*^9, {
   3.407307333875*^9, 3.40730738203125*^9}, {3.407307413359375*^9, 
   3.407307434109375*^9}, {3.40730746890625*^9, 3.407307498765625*^9}, {
   3.40730754246875*^9, 3.407307556015625*^9}, {3.407307644015625*^9, 
   3.407307655265625*^9}, {3.407307686515625*^9, 3.40730769140625*^9}, {
   3.407307798125*^9, 3.40730780984375*^9}, {3.412053396984375*^9, 
   3.41205340034375*^9}, {3.41205354975*^9, 3.41205358178125*^9}, {
   3.4120536540625*^9, 3.41205366440625*^9}, {3.412053733015625*^9, 
   3.41205376034375*^9}, {3.4120537931875*^9, 3.412053798453125*^9}, {
   3.412053848046875*^9, 3.412053848703125*^9}, 3.412053920640625*^9, {
   3.41205397215625*^9, 3.412053972859375*^9}, 3.412054051609375*^9, 
   3.41205421609375*^9, {3.412054535125*^9, 3.412054652734375*^9}, {
   3.412054701734375*^9, 3.412054708375*^9}, 3.41205496284375*^9, {
   3.4120550115625*^9, 3.41205506165625*^9}, 3.412055131890625*^9, {
   3.412055186578125*^9, 3.412055234234375*^9}, {3.412055307796875*^9, 
   3.412055308171875*^9}, {3.412055364921875*^9, 3.412055376953125*^9}, {
   3.41205551028125*^9, 3.412055546328125*^9}, {3.412055668890625*^9, 
   3.41205567390625*^9}, {3.4120557074375*^9, 3.412055723828125*^9}, {
   3.412055773421875*^9, 3.412055777109375*^9}, {3.412081765690058*^9, 
   3.4120818256885223`*^9}, 3.412081862062591*^9, {3.4124326251169157`*^9, 
   3.4124326676012907`*^9}, {3.412447918933935*^9, 3.4124479370909986`*^9}, {
   3.4125376914772263`*^9, 3.4125377031334763`*^9}, {3.4125377774616013`*^9, 
   3.4125378019459763`*^9}},
 CellID->146922310],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`showPar$$ = True, $CellContext`v$$ = {
    2.045, -2.39}, $CellContext`w$$ = {0.54, 1.6100000000000003`}, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`showPar$$], True, "show parallelogram"}, {
      True, False}}, {{
       Hold[$CellContext`v$$], {1., 0.5}}, {-3, -3}, {3, 3}}, {{
       Hold[$CellContext`w$$], {-2., 1.}}, {-3, -3}, {3, 3}}}, 
    Typeset`size$$ = {400., {198., 202.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`showPar$968$$ = False, $CellContext`v$969$$ = {0, 
    0}, $CellContext`w$970$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`showPar$$ = 
        True, $CellContext`v$$ = {1., 0.5}, $CellContext`w$$ = {-2., 1.}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`showPar$$, $CellContext`showPar$968$$, False], 
        Hold[$CellContext`v$$, $CellContext`v$969$$, {0, 0}], 
        Hold[$CellContext`w$$, $CellContext`w$970$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`vv$, $CellContext`ww$, $CellContext`angles$, \
$CellContext`proj$, $CellContext`cros$}, $CellContext`vv$ = 
         Normalize[$CellContext`v$$]; $CellContext`ww$ = 
         Normalize[$CellContext`w$$]; $CellContext`cros$ = 
         Part[$CellContext`v$$, 1] Part[$CellContext`w$$, 2] - 
          Part[$CellContext`v$$, 2] 
          Part[$CellContext`w$$, 1]; $CellContext`angles$ = Sort[
           N[{
             Apply[ArcTan, $CellContext`vv$], 
             Apply[ArcTan, $CellContext`ww$]}]]; Graphics[{
           Text[
            Style["-x", Italic], {2.5, 2.5}, -{1, 1}], 
           Text["-4", (-{-1., -1.}) 2, {0, 1}], 
           Text["4", {-1., -1.} 2, {0, 1}], 
           Point[{-1., -1.} 2], 
           Point[(-{-1., -1.}) 2], 
           Text["-3", (-{-1., -1.}) (3/2), {0, 1}], 
           Text["3", {-1., -1.} (3/2), {0, 1}], 
           Point[{-1., -1.} (3/2)], 
           Point[(-{-1., -1.}) (3/2)], 
           Text["-2", -{-1., -1.}, {0, 1}], 
           Text["2", {-1., -1.}, {0, 1}], 
           Point[{-1., -1.}], 
           Point[-{-1., -1.}], 
           Text["-1", (-{-1., -1.})/2, {0, 1}], 
           Text["1", {-1., -1.}/2, {0, 1}], 
           Point[{-1., -1.}/2], 
           Point[(-{-1., -1.})/2], {
            GrayLevel[0.9], 
            Line[{{-2, -2}, {2, 2}}]}, {
            If[$CellContext`showPar$$, {
              If[$CellContext`cros$ > 0, 
               RGBColor[1, 0.6, 0.7], 
               RGBColor[0.6, 0.7, 1]], 
              
              Polygon[{{0, 
                0}, $CellContext`v$$, $CellContext`v$$ + $CellContext`w$$, \
$CellContext`w$$}]}, {}]}, {
            If[$CellContext`cros$ < 0, 
             Hue[0.7], 
             RGBColor[1, 0.47, 0]], 
            Circle[{0, 0}, 0.3, 
             
             If[-Apply[Subtract, $CellContext`angles$] < 
              Pi, $CellContext`angles$, 
              Reverse[$CellContext`angles$] + {0, 2 Pi}]]}, {
            GrayLevel[0], 
            Arrow[{{0, 0}, $CellContext`v$$}]}, {
            GrayLevel[0], 
            Arrow[{{0, 0}, $CellContext`w$$}]}, {
            If[$CellContext`cros$ > 0, 
             RGBColor[1, 0.47, 0], 
             ColorData["HTML", "SlateBlue"]], 
            Arrow[{{0, 0}, $CellContext`cros$ {(-1)/2, (-1)/2}}]}, 
           Text[
           "\!\(\*OverscriptBox[\(v\), \(\[RightVector]\)]\)", \
$CellContext`v$$ (3/4), {1, 1}], 
           Text[
           "\!\(\*OverscriptBox[\(w\), \(\[RightVector]\)]\)", 
            3 ($CellContext`w$$/4), {1, 1}], 
           Text[
           "\!\(\*OverscriptBox[\(v\), \(\[RightVector]\)]\)\[ThinSpace]\
\[Cross]\[ThinSpace]\!\(\*OverscriptBox[\(w\), \(\[RightVector]\)]\)", \
$CellContext`cros$ {(-1)/2, (-1)/2}, {1, 1}]}, Axes -> True, Ticks -> True, 
          PlotRange -> 3, AxesLabel -> {
            Style["y", Italic], 
            Style["z", Italic]}, PlotLabel -> Grid[{{
              If[$CellContext`cros$ > 0, 
               Style["acute or obtuse angle", 
                RGBColor[1, 0.47, 0]], 
               Style["reflex angle", 
                ColorData["HTML", "SlateBlue"]]], 
              
              Row[{"|\!\(\*OverscriptBox[\(v\), \(\[RightVector]\)]\)\
\[ThinSpace]\[Cross]\[ThinSpace]\!\(\*OverscriptBox[\(w\), \
\(\[RightVector]\)]\)| = ", 
                NumberForm[
                 Abs[$CellContext`cros$], {4, 3}, 
                 ExponentFunction -> (Null& )]}]}}, ItemSize -> 10], 
          ImageSize -> {400, 400}]], 
      "Specifications" :> {{{$CellContext`showPar$$, True, 
          "show parallelogram"}, {
         True, False}}, {{$CellContext`v$$, {1., 0.5}}, {-3, -3}, {3, 3}, 
         ControlType -> Locator, Appearance -> None, 
         Exclusions -> {0, 0}}, {{$CellContext`w$$, {-2., 1.}}, {-3, -3}, {3, 
         3}, ControlType -> Locator, Appearance -> None, 
         Exclusions -> {0, 0}}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{451., {242., 247.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.650221524997279*^9}]
}, Open  ]],

Cell[TextData[{
 "You can \[OpenCurlyDoubleQuote]grab\[CloseCurlyDoubleQuote] the tip of \
either vector and drag it around. ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["v", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["w", "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " are only ever in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]],
  FormatType->"TraditionalForm"],
 "- ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " plane."
}], "Text",
 CellChangeTimes->{{3.650221671525078*^9, 3.650221698699072*^9}, {
  3.650221782745701*^9, 3.650221861893549*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "This Demonstration shows the cross product ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["v", "\[RightVector]"], "\[Cross]", 
    OverscriptBox["w", "\[RightVector]"]}], TraditionalForm]], "InlineMath"],
 " of the vectors ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["v", "\[RightVector]"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["w", "\[RightVector]"], TraditionalForm]], "InlineMath"],
 ". Since both vectors are in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 "-",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", " "}], TraditionalForm]], "InlineMath"],
 " plane, the resulting vector is on the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Cross Product of Vectors in the ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/CrossProductOfVectorsInTheYZPlane/\
"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/CrossProductOfVectorsInTheYZPlane/"],
 StyleBox[ButtonBox["y",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/CrossProductOfVectorsInTheYZPlane/\
"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/CrossProductOfVectorsInTheYZPlane/"],
  FontSlant->"Italic"],
 ButtonBox["-",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/CrossProductOfVectorsInTheYZPlane/\
"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/CrossProductOfVectorsInTheYZPlane/"],
 StyleBox[ButtonBox["z",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/CrossProductOfVectorsInTheYZPlane/\
"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/CrossProductOfVectorsInTheYZPlane/"],
  FontSlant->"Italic"],
 ButtonBox[" Plane",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/CrossProductOfVectorsInTheYZPlane/\
"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/CrossProductOfVectorsInTheYZPlane/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
CrossProductOfVectorsInTheYZPlane/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/CrossProductOfVectorsInTheYZPlane/\
"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/CrossProductOfVectorsInTheYZPlane/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Izidor Hafner",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Izidor+Hafner"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Izidor+Hafner"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[TextData[{
 "Based on a program by: ",
 ButtonBox["Bruce Torrence",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Bruce+Torrence"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Bruce+Torrence"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->258052206],

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
CrossProductOfVectorsInTheYZPlane"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{890, 694},
WindowMargins->{{Automatic, 425}, {Automatic, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Cross Product of Vectors in the y-z Plane - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"10.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 6, \
2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[621, 21, 338, 12, 59, "Section"],
Cell[CellGroupData[{
Cell[984, 37, 3700, 64, 44, "Section"],
Cell[CellGroupData[{
Cell[4709, 105, 19612, 465, 669, "Input",
 CellID->146922310],
Cell[24324, 572, 5943, 127, 506, "Output"]
}, Open  ]],
Cell[30282, 702, 714, 23, 34, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31033, 730, 209, 6, 44, "Section"],
Cell[31245, 738, 787, 26, 70, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[32069, 769, 355, 9, 20, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[32427, 780, 2015, 59, 38, "Text"],
Cell[34445, 841, 436, 14, 20, "Text"],
Cell[34884, 857, 463, 15, 20, "Text",
 CellID->258052206],
Cell[35350, 874, 815, 24, 99, "Text"],
Cell[36168, 900, 1205, 33, 88, "Text"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 9QzHycu#GFFQBDT3EQgRSF1I *)
