(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     24186,        621]
NotebookOptionsPosition[     22972,        575]
NotebookOutlinePosition[     23614,        601]
CellTagsIndexPosition[     23571,        598]
WindowTitle->Dot Product - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["[Lab02] Dot Product", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 CellChangeTimes->{{3.650224917010118*^9, 3.6502249201099777`*^9}},
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"vv", "=", 
        RowBox[{"If", "[", 
         RowBox[{"unit", ",", 
          RowBox[{"Normalize", "[", "v", "]"}], ",", "v"}], "]"}]}], ",", 
       RowBox[{"uw", "=", 
        RowBox[{"Normalize", "[", "w", "]"}]}], ",", "ww", ",", "dot", ",", 
       "\[IndentingNewLine]", "angles", ",", "proj"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ww", "=", 
       RowBox[{"If", "[", 
        RowBox[{"unit", ",", "uw", ",", "w"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"dot", "=", 
       RowBox[{"vv", ".", "ww"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"proj", "=", 
       RowBox[{"dot", "*", "uw"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"angles", "=", 
       RowBox[{"Sort", "[", 
        RowBox[{"N", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ArcTan", "@@", "vv"}], ",", 
           RowBox[{"ArcTan", "@@", "ww"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", ".5", "]"}], ",", 
            RowBox[{"Circle", "[", "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"dot", ">", "0"}], ",", 
              RowBox[{"Hue", "[", ".7", "]"}], ",", 
              RowBox[{"Hue", "[", "1", "]"}]}], "]"}], ",", 
            RowBox[{"Circle", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", ".3", ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"Subtract", "@@", "angles"}]}], "<", "\[Pi]"}], ",",
                 "angles", ",", 
                RowBox[{
                 RowBox[{"Reverse", "[", "angles", "]"}], "+", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"2", "\[Pi]"}]}], "}"}]}]}], "]"}]}], "]"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"unit", "&&", "showDot"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"GrayLevel", "[", ".5", "]"}], ",", "Dashed"}], "]"}],
               ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{"vv", ",", "proj"}], "}"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{"showDot", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"dot", ">", "0"}], ",", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{"Hue", "[", ".7", "]"}], ",", "Thick"}], "]"}], ",", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{"Hue", "[", "1", "]"}], ",", "Thick"}], "]"}]}], 
               "]"}], ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", "proj"}], "}"}], 
               "]"}]}], "}"}], ",", 
            RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Arrow", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", "vv"}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Arrow", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", "ww"}], "}"}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"Axes", "\[Rule]", "True"}], ",", 
        RowBox[{"Ticks", "\[Rule]", "None"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "3"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Grid", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"dot", ">", "0"}], ",", 
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<acute angle\>\"", ",", 
                  RowBox[{"Hue", "[", ".7", "]"}]}], "]"}], ",", 
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<obtuse angle\>\"", ",", 
                  RowBox[{"Hue", "[", "1", "]"}]}], "]"}]}], "]"}], ",", 
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                "\"\<\!\(\*OverscriptBox[\(v\), \(\[RightVector]\)]\)\
\[ThinSpace]\[CenterDot]\[ThinSpace]\!\(\*OverscriptBox[\(w\), \(\
\[RightVector]\)]\) = \>\"", ",", "dot"}], "}"}], "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"dot", ">", "0"}], ",", 
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<positive\>\"", ",", 
                  RowBox[{"Hue", "[", ".7", "]"}]}], "]"}], ",", 
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<negative\>\"", ",", 
                  RowBox[{"Hue", "[", "1", "]"}]}], "]"}]}], "]"}]}], "}"}], 
            "}"}], ",", 
           RowBox[{"ItemSize", "\[Rule]", "10"}]}], "]"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"400", ",", "400"}], "}"}]}]}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"unit", ",", "False", ",", "\"\<use unit vectors\>\""}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"showDot", ",", "False", ",", "\"\<show dot product\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", ",", 
       RowBox[{"{", 
        RowBox[{"1.", ",", "0."}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", "Locator", ",", 
     RowBox[{"Appearance", "\[Rule]", "None"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"w", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2."}], ",", "1."}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", "Locator", ",", 
     RowBox[{"Appearance", "\[Rule]", "None"}]}], "}"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.4016591107396708`*^9, 3.4016595095313797`*^9, {
   3.401661170234079*^9, 3.401661190443899*^9}, {3.401661235254653*^9, 
   3.4016612867426357`*^9}, 3.4016613429606037`*^9, 3.401661764791361*^9, {
   3.4017127450847692`*^9, 3.401712756240876*^9}, {3.4017160557822065`*^9, 
   3.4017160667978315`*^9}, {3.4018213193642044`*^9, 
   3.4018213255361977`*^9}, {3.4029178619846597`*^9, 3.4029178621721597`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`showDot$$ = False, $CellContext`unit$$ = 
    False, $CellContext`v$$ = {1., 0.}, $CellContext`w$$ = {-2., 1.}, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`unit$$], False, "use unit vectors"}, {
      True, False}}, {{
       Hold[$CellContext`showDot$$], False, "show dot product"}, {
      True, False}}, {{
       Hold[$CellContext`v$$], {1., 0.}}, {-3, -3}, {3, 3}}, {{
       Hold[$CellContext`w$$], {-2., 1.}}, {-3, -3}, {3, 3}}}, 
    Typeset`size$$ = {400., {198., 202.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`unit$29563$$ = False, $CellContext`showDot$29564$$ = 
    False, $CellContext`v$29565$$ = {0, 0}, $CellContext`w$29566$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`showDot$$ = False, $CellContext`unit$$ = 
        False, $CellContext`v$$ = {1., 0.}, $CellContext`w$$ = {-2., 1.}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`unit$$, $CellContext`unit$29563$$, False], 
        Hold[$CellContext`showDot$$, $CellContext`showDot$29564$$, False], 
        Hold[$CellContext`v$$, $CellContext`v$29565$$, {0, 0}], 
        Hold[$CellContext`w$$, $CellContext`w$29566$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`vv$ = If[$CellContext`unit$$, 
           Normalize[$CellContext`v$$], $CellContext`v$$], $CellContext`uw$ = 
         Normalize[$CellContext`w$$], $CellContext`ww$, $CellContext`dot$, \
$CellContext`angles$, $CellContext`proj$}, $CellContext`ww$ = 
         If[$CellContext`unit$$, $CellContext`uw$, $CellContext`w$$]; \
$CellContext`dot$ = 
         Dot[$CellContext`vv$, $CellContext`ww$]; $CellContext`proj$ = \
$CellContext`dot$ $CellContext`uw$; $CellContext`angles$ = Sort[
           N[{
             Apply[ArcTan, $CellContext`vv$], 
             Apply[ArcTan, $CellContext`ww$]}]]; Graphics[{{
            GrayLevel[0.5], 
            Circle[]}, {
            If[$CellContext`dot$ > 0, 
             Hue[0.7], 
             Hue[1]], 
            Circle[{0, 0}, 0.3, 
             
             If[-Apply[Subtract, $CellContext`angles$] < 
              Pi, $CellContext`angles$, 
              Reverse[$CellContext`angles$] + {0, 2 Pi}]]}, 
           If[
            And[$CellContext`unit$$, $CellContext`showDot$$], {
             Directive[
              GrayLevel[0.5], Dashed], 
             Line[{$CellContext`vv$, $CellContext`proj$}]}, {}], 
           If[$CellContext`showDot$$, {
             If[$CellContext`dot$ > 0, 
              Directive[
               Hue[0.7], Thick], 
              Directive[
               Hue[1], Thick]], 
             Line[{{0, 0}, $CellContext`proj$}]}, {}], 
           Arrow[{{0, 0}, $CellContext`vv$}], 
           Arrow[{{0, 0}, $CellContext`ww$}]}, Axes -> True, Ticks -> None, 
          PlotRange -> 3, PlotLabel -> Grid[{{
              If[$CellContext`dot$ > 0, 
               Style["acute angle", 
                Hue[0.7]], 
               Style["obtuse angle", 
                Hue[1]]], 
              
              Row[{"\!\(\*OverscriptBox[\(v\), \(\[RightVector]\)]\)\
\[ThinSpace]\[CenterDot]\[ThinSpace]\!\(\*OverscriptBox[\(w\), \(\
\[RightVector]\)]\) = ", $CellContext`dot$}], 
              If[$CellContext`dot$ > 0, 
               Style["positive", 
                Hue[0.7]], 
               Style["negative", 
                Hue[1]]]}}, ItemSize -> 10], ImageSize -> {400, 400}]], 
      "Specifications" :> {{{$CellContext`unit$$, False, 
          "use unit vectors"}, {
         True, False}}, {{$CellContext`showDot$$, False, 
          "show dot product"}, {
         True, False}}, {{$CellContext`v$$, {1., 0.}}, {-3, -3}, {3, 3}, 
         ControlType -> Locator, Appearance -> 
         None}, {{$CellContext`w$$, {-2., 1.}}, {-3, -3}, {3, 3}, ControlType -> 
         Locator, Appearance -> None}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{451., {254., 259.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->538907591]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
Drag either of the two vectors to move them. The angle between the vectors is \
shown (in blue when acute and in red when obtuse). The unit circle is shown \
for scale. The vectors can be constrained to be unit vectors, in which case \
the dot product is the cosine of the angle between them.\
\>", "Text"],

Cell[TextData[{
 "The dot product is a number, not a vector. When \"show dot product\" is \
checked, a colored line segment is shown along one of the vectors. If the \
segment is blue, the dot product is simply the length of this segment; if the \
segment is red, the dot product is the negative of its length. For unit \
vectors, the length of the colored segment is precisely the length of the \
projection of one vector onto the other. For other vectors, the length is \
scaled by the product of the magnitudes of the vectors. In concise terms: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     OverscriptBox["v", "\[RightVector]"], "\[CenterDot]", 
     OverscriptBox["w", "\[RightVector]"]}], "=", 
    RowBox[{"\[LeftDoubleBracketingBar]", 
     RowBox[{
      OverscriptBox["v", "\[RightVector]"], 
      RowBox[{"\[LeftDoubleBracketingBar]", "\[ThinSpace]", 
       RowBox[{"\[LeftDoubleBracketingBar]", 
        RowBox[{
         OverscriptBox["w", "\[RightVector]"], 
         RowBox[{"\[LeftDoubleBracketingBar]", "\[ThinSpace]", 
          RowBox[{"cos", "(", "\[Theta]", ")"}]}]}]}]}]}]}]}], 
   TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " is the angle between the vectors."
}], "Text"],

Cell["\<\
The projection is only shown from the first vector to the second. You could, \
of course, project the second vector onto the first to produce a segment of \
equal length. In fact, you can simply switch the positions of the two vectors \
to see the other projection.\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Dot Product",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/DotProduct/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/DotProduct/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/DotProduct/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/DotProduct/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/DotProduct/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Bruce Torrence",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Bruce+Torrence"]\
, None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Bruce+Torrence"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
DotProduct"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Dot Product - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"10.2 for Mac OS X x86 (32-bit, 64-bit Kernel) (July 6, \
2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[591, 21, 207, 4, 59, "Section"],
Cell[CellGroupData[{
Cell[823, 29, 3700, 64, 44, "Section"],
Cell[CellGroupData[{
Cell[4548, 97, 7727, 199, 561, "Input"],
Cell[12278, 298, 4846, 101, 530, "Output",
 CellID->538907591]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17173, 405, 209, 6, 44, "Section"],
Cell[17385, 413, 316, 5, 70, "Text"],
Cell[17704, 420, 1285, 28, 70, "Text"],
Cell[18992, 450, 289, 5, 70, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[19318, 460, 355, 9, 20, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[19676, 471, 838, 24, 38, "Text"],
Cell[20517, 497, 436, 14, 20, "Text"],
Cell[20956, 513, 815, 24, 99, "Text"],
Cell[21774, 539, 1182, 33, 88, "Text"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature ESj9gmHDrWd6uDpNbaQWHIO8 *)
