(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[     79576,       2178]
NotebookOptionsPosition[     70372,       1964]
NotebookOutlinePosition[     70849,       1982]
CellTagsIndexPosition[     70806,       1979]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
01 Vectors
[Your names]\
\>", "Title",
 CellChangeTimes->{{3.543847653428233*^9, 3.5438476603879285`*^9}, {
   3.6814043549324923`*^9, 3.68140435934651*^9}, 3.6817595962664003`*^9, {
   3.6819318024760237`*^9, 3.681931803916046*^9}}],

Cell["\<\
Work with someone else, but submit your own completed Mathematica notebook \
file by uploading it to Moodle.\
\>", "Text",
 CellChangeTimes->{{3.543847682631153*^9, 3.543847690566946*^9}, {
  3.5442904675915427`*^9, 3.5442905126305428`*^9}, {3.576350931148992*^9, 
  3.576350932625811*^9}, {3.6497083743158073`*^9, 3.6497084361584883`*^9}, {
  3.6814043657309237`*^9, 3.681404390890294*^9}, {3.681406208316659*^9, 
  3.681406275680805*^9}, {3.681758608260414*^9, 3.681758612340034*^9}, {
  3.734973559667358*^9, 
  3.73497356038873*^9}},ExpressionUUID->"b01deb06-6cbc-445c-a388-\
09c0020c7d12"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Review"
}], "Section",
 CellChangeTimes->{{3.5438457632552347`*^9, 3.543845768166725*^9}, {
  3.681404415682578*^9, 3.681404417297805*^9}}],

Cell[TextData[{
 "[As you go through this notebook execute each computation cell, and make \
sure you understand the results you get.  Place the cursor anywhere in a \
computation cell and press \[ShiftKey]-\[EnterKey] to execute the \
computation.]\n",
 StyleBox["\nMathematica",
  FontSlant->"Italic"],
 " can be used like a calculator.    Multiplication can be represented with \
an asterisk (*), the times symbol (\[Times]), or a blank space (\[SpaceKey]). \
 Exponentiation is represented with a caret (^). Standard operator precedence \
is followed (e.g., in the computation below, exponentiation is performed \
first, multiplication and division are performed next, and subtraction and \
addition are performed last). [The first \[OpenCurlyDoubleQuote]computation \
cell\[CloseCurlyDoubleQuote] is below...]"
}], "Text",
 CellChangeTimes->{{3.5438457784317517`*^9, 3.543845787704679*^9}, {
   3.543845900260934*^9, 3.543845947008608*^9}, {3.543845979411848*^9, 
   3.543845988492756*^9}, {3.543846062781184*^9, 3.5438461601029153`*^9}, {
   3.543846220107915*^9, 3.5438462848593893`*^9}, {3.5438471896298575`*^9, 
   3.5438472422751217`*^9}, 3.543847420349927*^9, {3.543847511246016*^9, 
   3.5438475253914304`*^9}, {3.649708315937685*^9, 3.64970833743244*^9}, {
   3.681404457212487*^9, 3.6814045466328087`*^9}, {3.68140579238529*^9, 
   3.681405793239485*^9}, {3.6819228104144917`*^9, 3.68192288871285*^9}, {
   3.681923043359406*^9, 3.681923062119267*^9}}],

Cell[BoxData[
 RowBox[{"4", "-", 
  RowBox[{"2.1", "*", 
   RowBox[{"3", "^", "2"}]}], "+", 
  RowBox[{"5", "/", "6"}]}]], "Input",
 CellChangeTimes->{{3.5438457934122496`*^9, 3.543845829886897*^9}, {
  3.5438461689778023`*^9, 3.5438461818180866`*^9}, {3.5438462629471984`*^9, 
  3.5438462675066547`*^9}, {3.543847180494944*^9, 3.5438471807499695`*^9}}],

Cell[TextData[{
 "\[LineSeparator]Typically, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides exact answers.  Built in functions always begin with an uppercase \
letter and use square brackets (e.g., ",
 StyleBox["Cos[x]", "Input"],
 " rather than ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{"cos", 
      RowBox[{"(", "x"}]}], ")"}],
    FontFamily->"Source Code Pro",
    FontWeight->"Regular"], TraditionalForm]]],
 ")."
}], "Text",
 CellChangeTimes->{{3.543845874313339*^9, 3.543845891635071*^9}, {
   3.5438463350004034`*^9, 3.54384641447935*^9}, 3.6814060564223633`*^9, {
   3.6819229626000423`*^9, 3.6819229746638117`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"Cos", "[", "Pi", "]"}], "+", "13"}], "]"}], "/", 
  RowBox[{"10", "^", "2"}]}]], "Input",
 CellChangeTimes->{{3.543845996674574*^9, 3.5438460370756135`*^9}, {
  3.5438463119520984`*^9, 3.5438463125191555`*^9}, {3.5438471285857534`*^9, 
  3.5438471440022955`*^9}}],

Cell[TextData[{
 "\[LineSeparator]Numerical approximations can be obtained by using the ",
 StyleBox["N", "Input"],
 " function."
}], "Text",
 CellChangeTimes->{{3.5438464745093527`*^9, 3.543846494143316*^9}, {
   3.54384686852475*^9, 3.543846872285126*^9}, {3.54384694873277*^9, 
   3.5438469519170885`*^9}, 3.681406059365345*^9}],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"Cos", "[", "Pi", "]"}], "+", "13"}], "]"}], "/", 
   RowBox[{"10", "^", "2"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.5438469317240696`*^9, {3.54384696693659*^9, 3.543846971393036*^9}, {
   3.5438471215690517`*^9, 3.5438471529481897`*^9}, {3.5438472706399574`*^9, 
   3.543847270783972*^9}}],

Cell[TextData[{
 "An alternate way to get a numerical approximation is to ",
 StyleBox["add a decimal point",
  FontSlant->"Italic"],
 " to any number in your expression:"
}], "Text",
 CellChangeTimes->{{3.5438464745093527`*^9, 3.543846494143316*^9}, {
  3.54384686852475*^9, 3.543846872285126*^9}, {3.54384694873277*^9, 
  3.5438469519170885`*^9}, {3.681405946543415*^9, 3.681405978476441*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"Cos", "[", "Pi", "]"}], "+", 
    StyleBox[
     RowBox[{"13", 
      StyleBox[".",
       FontColor->RGBColor[1, 0, 0]]}]]}], "]"}], "/", 
  RowBox[{"10", "^", "2"}]}]], "Input",
 CellChangeTimes->{{3.6814059278711443`*^9, 3.68140592788237*^9}, {
  3.6814059827269573`*^9, 3.681406011726968*^9}}],

Cell["\<\
Numerical approximations can be obtained to however many digits are desired.\
\>", "Text",
 CellChangeTimes->{{3.543847018115708*^9, 3.543847049374833*^9}, 
   3.681405917252164*^9}],

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "Pi", "]"}], "+", "13"}], "]"}], "/", 
    RowBox[{"10", "^", "2"}]}], ",", "50"}], "]"}]], "Input",
 CellChangeTimes->{{3.543846998604757*^9, 3.543847010877984*^9}, {
  3.543847264495343*^9, 3.5438472648793817`*^9}}],

Cell["\<\
\[LineSeparator]Typesetting of expressions is possible using the Basic Math \
Assistant Palette or special keys (e.g., a fraction is obtained with \
\[ControlKey]-/, the square root is obtained with \[ControlKey]-2, \[Pi] is \
obtained with \[EscapeKey] p \[EscapeKey], and exponentiation is obtained \
with \[ControlKey]-^). \
\>", "Text",
 CellChangeTimes->{{3.5438473052644196`*^9, 3.543847498419733*^9}, {
   3.5438475377126627`*^9, 3.5438475706279535`*^9}, {3.5438477501028996`*^9, 
   3.543847752943183*^9}, 3.6814060650375223`*^9}],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   RowBox[{
    RowBox[{"Cos", "[", "\[Pi]", "]"}], "+", "13"}]], 
  SuperscriptBox["10", "2"]]], "Input",
 CellChangeTimes->{{3.5438470766895647`*^9, 3.5438471139122863`*^9}, {
  3.5438472811550093`*^9, 3.543847284723366*^9}, {3.5438473240212955`*^9, 
  3.543847328346728*^9}, {3.5438477259034796`*^9, 3.543847741160005*^9}}],

Cell["\<\
\[LineSeparator]An equation can be solved exactly and/or with a numerical \
approximation.  \
\>", "Text",
 CellChangeTimes->{{3.543847819810215*^9, 3.543847833445932*^9}, {
   3.5438479348106213`*^9, 3.543848022364752*^9}, {3.5438485032719584`*^9, 
   3.543848504943791*^9}, 3.649701439686192*^9, 3.6814060695811377`*^9}],

Cell[BoxData[{
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"3", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"3", "x"}], "+", "1"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.5438478368898296`*^9, 3.543847885929654*^9}, {
  3.543847925494014*^9, 3.5438479286271915`*^9}, {3.5438485151377716`*^9, 
  3.5438485184104443`*^9}}],

Cell[TextData[{
 "We discussed in class the idea of solving ",
 StyleBox["systems",
  FontSlant->"Italic"],
 " of equations.  Here\[CloseCurlyQuote]s an example: (Think of \
\[OpenCurlyDoubleQuote]&&\[CloseCurlyDoubleQuote] as meaning \
\[OpenCurlyDoubleQuote]and\[CloseCurlyDoubleQuote].)"
}], "Text",
 CellChangeTimes->{{3.6819300633821087`*^9, 3.681930107411586*^9}, {
  3.6819302651796293`*^9, 3.681930293801456*^9}}],

Cell[BoxData[
 RowBox[{"Solve", "[", "  ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", "a"}], " ", "+", " ", "b"}], " ", "\[Equal]", "14"}], 
    " ", "&&", " ", 
    RowBox[{
     RowBox[{"a", "-", "b"}], "\[Equal]", "2"}]}], ",", "\[IndentingNewLine]",
    " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.6819301127689342`*^9, 3.6819302422343473`*^9}}],

Cell[TextData[{
 "Note that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a ",
 StyleBox["double equals sign (",
  FontWeight->"Bold"],
 StyleBox["==", "Input",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox[")",
  FontWeight->"Bold"],
 " to represent the equality in an equation.  The single equals sign (",
 StyleBox["=", "Input",
  FontColor->RGBColor[1, 0, 0]],
 ") is the ",
 StyleBox["assignment operator",
  FontWeight->"Bold"],
 ", used to assign numbers and \[OpenCurlyDoubleQuote]expressions\
\[CloseCurlyDoubleQuote] to variables."
}], "Text",
 CellChangeTimes->{{3.5438480264011154`*^9, 3.543848099869934*^9}, {
  3.64970148084291*^9, 3.64970148419285*^9}, {3.681404628862977*^9, 
  3.6814046405113153`*^9}, {3.6819300515330267`*^9, 3.681930054501027*^9}}],

Cell[BoxData[{
 RowBox[{"a", "=", 
  RowBox[{
   SuperscriptBox["x", "2"], "+", "x"}]}], "\[IndentingNewLine]", 
 RowBox[{"b", "=", 
  RowBox[{
   RowBox[{"2", "x"}], "+", "1"}]}], "\[IndentingNewLine]", 
 RowBox[{"c", "=", 
  RowBox[{"a", "+", "b"}]}]}], "Input",
 CellChangeTimes->{{3.543848118866014*^9, 3.5438481503525653`*^9}}],

Cell[TextData[{
 StyleBox["\[LineSeparator]\[LineSeparator]Expression syntax for functions \
you define",
  FontWeight->"Bold"],
 "\[LineSeparator]\nAfter you\[CloseCurlyQuote]ve executed the line above, ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]]],
 " is an \[OpenCurlyDoubleQuote]expression\[CloseCurlyDoubleQuote] that \
represents a function, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", "(", "x", ")"}], TraditionalForm]]],
 " from real numbers to real numbers.  \[LineSeparator]\[LineSeparator]To \
evaluate the function for some specific value of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 ", say, you want to find ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", "(", "1", ")"}], TraditionalForm]]],
 ", you can use the ",
 StyleBox["replacement operator",
  FontWeight->"Bold"],
 ", ",
 StyleBox["/.",
  FontFamily->"Courier New",
  FontColor->RGBColor[1, 0, 0]],
 ", with a ",
 StyleBox["replacement rule",
  FontWeight->"Bold"],
 " (indicated by the arrow, which you type in as the two characters \
\[OpenCurlyDoubleQuote]",
 StyleBox["->",
  FontFamily->"Courier New",
  FontColor->RGBColor[1, 0, 0]],
 "\[CloseCurlyDoubleQuote].), as in this example, "
}], "Text",
 CellChangeTimes->{{3.543848229150919*^9, 3.543848297753332*^9}, {
  3.5438485623710475`*^9, 3.5438485835279317`*^9}, {3.649701468453573*^9, 
  3.649701471716524*^9}, {3.649701612200605*^9, 3.6497016999223633`*^9}, {
  3.649701749815564*^9, 3.649702017239154*^9}, {3.6497020883004313`*^9, 
  3.649702097766564*^9}, {3.649702134087179*^9, 3.649702165837679*^9}, {
  3.649702302077014*^9, 3.6497023513231497`*^9}, {3.681920068343849*^9, 
  3.681920091902891*^9}, {3.681920683888008*^9, 3.681920684256014*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", " ", "/.", " ", 
  RowBox[{"x", "\[Rule]", "1"}]}]], "Input",
 CellChangeTimes->{{3.6497021714377613`*^9, 3.64970217623967*^9}}],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{3.6819203559157*^9}]
}, Open  ]],

Cell["\<\
Expressions can also be graphed, differentiated, and integrated.\
\>", "Text",
 CellChangeTimes->{{3.649702191587902*^9, 3.6497022081349087`*^9}, 
   3.6497022805331306`*^9}],

Cell[BoxData[{
 RowBox[{"Plot", "[", 
  RowBox[{"c", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "2"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"D", "[", 
  RowBox[{"c", ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{"c", ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{"c", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5438483007854223`*^9, 3.543848384146406*^9}, {
  3.5438485866596184`*^9, 3.543848596954589*^9}, {3.649702257758526*^9, 
  3.649702261494987*^9}}],

Cell[CellGroupData[{

Cell["Exercise 1- 5pts", "Subsection",
 CellChangeTimes->{{3.543848529190366*^9, 3.543848532397045*^9}, {
  3.7349740746968718`*^9, 
  3.7349740771993303`*^9}},ExpressionUUID->"741adfa1-b676-407d-9cd7-\
e28974a72559"],

Cell[TextData[{
 "Consider the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"cos", "(", 
      RowBox[{"2", "x"}], ")"}]}]}], TraditionalForm]]],
 ".  Using expression syntax, find the exact value and a numerical \
approximation of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "4", ")"}], TraditionalForm]]],
 ".  Graph ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 " on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "]"}], TraditionalForm]]],
 ".  Find ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "'"}], 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "2"}], "2"], 
    RowBox[{
     RowBox[{"f", "(", "x", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]]],
 " ."
}], "Text",
 CellChangeTimes->{{3.543848544460839*^9, 3.54384854665162*^9}, {
  3.543848614069877*^9, 3.5438489371811056`*^9}, {3.5438494653751054`*^9, 
  3.543849467022105*^9}, {3.681920642351309*^9, 3.6819206576629143`*^9}}],

Cell[TextData[{
 StyleBox["\[LineSeparator]\[LineSeparator]\[LineSeparator]Function syntax \
for functions you define",
  FontWeight->"Bold"],
 "\[LineSeparator]\[LineSeparator]A different way to deal with mathematical \
functions is to define them as \[OpenCurlyDoubleQuote]Mathematica functions\
\[CloseCurlyDoubleQuote]. like this:"
}], "Text",
 CellChangeTimes->{{3.681919790973672*^9, 3.681919845378229*^9}, {
  3.6819201032650948`*^9, 3.681920115255818*^9}, {3.681920628656739*^9, 
  3.681920628960301*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"MyC", "[", "x_", "]"}], ":=", 
  RowBox[{"1", " ", "+", " ", 
   RowBox[{"3", " ", "x"}], " ", "+", 
   RowBox[{"x", "^", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.681919900707881*^9, 3.681919995146442*^9}}],

Cell[TextData[{
 "Here are examples of evaluating the function at a particular value of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]]],
 ", plotting, differentiating and integrating"
}], "Text",
 CellChangeTimes->{{3.6819200195458317`*^9, 3.681920036951483*^9}, {
  3.6819201325102386`*^9, 3.681920154085876*^9}}],

Cell[BoxData[{
 RowBox[{"MyC", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", " ", 
  RowBox[{
   RowBox[{"MyC", "[", "t", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", 
     RowBox[{"-", "5"}], ",", "2"}], "}"}]}], "   ", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"D", "[", " ", 
  RowBox[{
   RowBox[{"MyC", "[", "x", "]"}], ",", " ", "x"}], "     ", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", " ", 
  RowBox[{
   RowBox[{"MyC", "[", "x", "]"}], ",", " ", "x"}], "   ", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"-", "5"}], "2"], 
  RowBox[{
   RowBox[{"MyC", "[", "x", "]"}], " ", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]}], "Input",
 CellChangeTimes->{{3.681920007404348*^9, 3.68192000862432*^9}, {
  3.681920163262052*^9, 3.681920318462303*^9}}],

Cell[TextData[{
 "Note that you have greater latitude, with function syntax, of what you put \
in the argument of the function.  E.g. you can easily evaluate (and then \
simplify)  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"MyC", "[", 
    RowBox[{"x", "-", "2"}], "]"}], TraditionalForm]]],
 ":"
}], "Text",
 CellChangeTimes->{{3.6819203774528847`*^9, 3.681920449889967*^9}, {
  3.681920554946001*^9, 3.681920569804092*^9}, {3.681929867063593*^9, 
  3.681929868247176*^9}}],

Cell[BoxData[{
 RowBox[{"MyC", "[", 
  RowBox[{"x", "-", "2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", " ", "[", " ", "%", " ", "]"}]}], "Input",
 CellChangeTimes->{{3.681920459814623*^9, 3.6819204991137457`*^9}, 
   3.6819298772733603`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2 - 4 pts", "Subsection",
 CellChangeTimes->{{3.543849497517105*^9, 3.543849500588105*^9}, {
  3.7349741039937973`*^9, 3.734974107039081*^9}, {3.734974244614922*^9, 
  3.7349742454852333`*^9}},ExpressionUUID->"0184d503-6576-4efd-aa00-\
362c87a64739"],

Cell[TextData[{
 "Consider again the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"cos", "(", 
      RowBox[{"2", "x"}], ")"}]}]}], TraditionalForm]]],
 ".  This time use function syntax to define a function for f(x), and then \
find the exact value and a numerical approximation of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "4", ")"}], TraditionalForm]]],
 ".  Graph ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]]],
 " on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "]"}], TraditionalForm]]],
 ".  Find ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "'"}], 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "2"}], "2"], 
    RowBox[{
     RowBox[{"f", "(", "x", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]]],
 " ."
}], "Text",
 CellChangeTimes->{{3.681929944427005*^9, 3.681930004709405*^9}, {
  3.681930366592103*^9, 3.6819303869681683`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3 - 2 pts", "Subsection",
 CellChangeTimes->{{3.543849497517105*^9, 3.543849500588105*^9}, {
  3.6819298389866953`*^9, 3.6819298393034286`*^9}, {3.7349746586173067`*^9, 
  3.7349746612328672`*^9}},ExpressionUUID->"e9a3f8b5-d4d2-4b16-9c24-\
82906beed341"],

Cell[TextData[{
 "Attempt to find an approximate solution to the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", "0"}], TraditionalForm]]],
 " using the ",
 StyleBox["NSolve", "Input"],
 " function.  "
}], "Text",
 CellChangeTimes->{{3.543849503918105*^9, 3.5438497328441057`*^9}, 
   3.5438497678611054`*^9, {3.681930952618402*^9, 3.681930954320003*^9}}],

Cell[TextData[{
 "When that does not work, place the cursor on ",
 StyleBox["NSolve", "Input"],
 " and right-click your mouse, then choose \[OpenCurlyDoubleQuote]Get Help\
\[CloseCurlyDoubleQuote].   Notice the numerous examples showing how to use \
the NSolve function.  Look for the  ",
 Cell[BoxData[
  FormBox[
   FrameBox[
    RowBox[{"See", " ", "Also"}]], TraditionalForm]]],
 "  section.  Try some of the other methods until you are able to make one \
give you an approximate solution to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", "0"}], TraditionalForm]]],
 ".  Do it!"
}], "Text",
 CellChangeTimes->{{3.5438497719661055`*^9, 3.5438499613981056`*^9}, {
  3.543850058524105*^9, 3.543850063397105*^9}, {3.6819308005004883`*^9, 
  3.681930925576404*^9}, {3.6819309694316998`*^9, 3.6819309781834383`*^9}, {
  3.6819318711248426`*^9, 3.681931891986768*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vectors in the Plane", "Section",
 CellChangeTimes->{{3.543844327991749*^9, 3.543844329173684*^9}, {
  3.5438513565971055`*^9, 3.5438513585001054`*^9}}],

Cell[TextData[{
 "A ",
 StyleBox["point",
  FontSlant->"Italic"],
 " is a location in some space.  A point in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "n"], TraditionalForm]]],
 " is located by a ",
 StyleBox["list",
  FontWeight->"Bold"],
 " of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 " numbers.  For example, we may write ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "=", 
    RowBox[{"(", 
     RowBox[{"1", ",", "3"}], ")"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", "=", 
    RowBox[{"(", 
     RowBox[{"2", ",", "1"}], ")"}]}], TraditionalForm]]],
 " to locate two points ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]]],
 " in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "2"], TraditionalForm]]],
 ".  In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", we can assign a list of numbers to a variable.  Since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses parentheses to group together parts of arithmetic expressions, it \
uses braces--",
 StyleBox["{...}",
  FontFamily->"Courier New",
  FontColor->RGBColor[1, 0, 0]],
 " to indicate the beginning and ending of a list.  Since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " begins its built in names with a uppercase letter, I usually use names \
that begin with a lowercase letter, which is why I used lowercase p rather \
than uppercase P."
}], "Text",
 CellChangeTimes->{{3.5438443368317857`*^9, 3.543844343169077*^9}, {
  3.543844444557745*^9, 3.5438446898896766`*^9}, {3.5438504266071053`*^9, 
  3.5438506540371056`*^9}, {3.544174725940756*^9, 3.5441747626588564`*^9}, {
  3.544224200660205*^9, 3.5442242191982656`*^9}, {3.649702560476982*^9, 
  3.6497025826064587`*^9}, {3.6497026149387207`*^9, 3.649702616673689*^9}}],

Cell[BoxData[{
 RowBox[{"p", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"q", "=", 
  RowBox[{"{", 
   RowBox[{"2", ",", "1"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.5438446925328836`*^9, 3.543844696905571*^9}, {
  3.5442242275987463`*^9, 3.5442242349901686`*^9}}],

Cell["Points can be graphed.", "Text",
 CellChangeTimes->{{3.5438508828371058`*^9, 3.5438508943161054`*^9}, {
  3.5442242412415266`*^9, 3.5442242455787745`*^9}}],

Cell[BoxData[
 RowBox[{"plot1", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Point", "[", "p", "]"}], ",", 
      RowBox[{"Point", "[", "q", "]"}]}], "}"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "4"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5438506688741055`*^9, 3.5438506860301056`*^9}, 
   3.5438512618321056`*^9, {3.544224251114091*^9, 3.5442242580404873`*^9}, {
   3.544224512424037*^9, 3.5442245150291862`*^9}}],

Cell["\<\
Here is one way to add to the graph a line that passes through the two points.\
\>", "Text",
 CellChangeTimes->{{3.544224563110936*^9, 3.544224592711629*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plot2", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "t"}], ")"}], "p"}], "+", 
      RowBox[{"t", " ", "q"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plot1", ",", "plot2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5442243257103577`*^9, 3.5442243275244617`*^9}, {
  3.544224424508009*^9, 3.5442245415967054`*^9}}],

Cell[TextData[{
 "A ",
 StyleBox["vector",
  FontSlant->"Italic"],
 " is a list of two points.  For example, if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "=", 
    RowBox[{"(", 
     RowBox[{"1", ",", "3"}], ")"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", "=", 
    RowBox[{"(", 
     RowBox[{"2", ",", "1"}], ")"}]}], TraditionalForm]]],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox[
     StyleBox["PQ",
      FontSlant->"Italic"], "\[RightVector]"], "=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", ",", "3"}], ")"}], ",", 
      RowBox[{"(", 
       RowBox[{"2", ",", "1"}], ")"}]}], ")"}]}], TraditionalForm]]],
 ". The first point is the ",
 StyleBox["base",
  FontSlant->"Italic"],
 " or ",
 StyleBox["tail",
  FontSlant->"Italic"],
 " and the second point is the ",
 StyleBox["head",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.5438509068841057`*^9, 3.543850968852105*^9}, {
  3.5442225089204435`*^9, 3.544222591369159*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     OverscriptBox["pq", "\[RightVector]"], "=", 
     RowBox[{"{", 
      RowBox[{"p", ",", "q"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Point", "[", "p", "]"}], ",", 
       RowBox[{"Point", "[", "q", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        OverscriptBox["pq", "\[RightVector]"], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", "4"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.543845752969206*^9, 3.5438457531662254`*^9}, {
   3.5438510310141053`*^9, 3.5438512434341054`*^9}, {3.544290754148543*^9, 
   3.5442907733255424`*^9}, 3.649703924920924*^9, {3.6814048030597486`*^9, 
   3.681404804564612*^9}}],

Cell[TextData[{
 "[You don\[CloseCurlyQuote]t *have* to use the arrow expression name for a  \
vector.  In fact, below I\[CloseCurlyQuote]ll use \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
  FormBox["v", TraditionalForm]]],
 "\[CloseCurlyDoubleQuote] without an arrow.  But it\[CloseCurlyQuote]s nice \
to be able to add the arrow to the expression name to banish any doubt in \
your audience\[CloseCurlyQuote]s mind that we\[CloseCurlyQuote]re talking \
about a vector quantity.]\[LineSeparator]\[LineSeparator]The components of a \
vector ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["PQ",
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]]],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "=", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", 
      SubscriptBox["b", "1"]}], ")"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", "=", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["a", "2"], ",", 
      SubscriptBox["b", "2"]}], ")"}]}], TraditionalForm]]],
 ", are the quantities ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["v",
     FontWeight->"Bold"], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"a", ",", "b"}], "\[RightAngleBracket]"}], "=", 
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{
       RowBox[{
        SubscriptBox["a", "2"], "-", 
        SubscriptBox["a", "1"]}], ",", 
       RowBox[{
        SubscriptBox["b", "2"], "-", 
        SubscriptBox["b", "1"]}]}], "\[RightAngleBracket]"}]}]}], 
   TraditionalForm]]],
 ", and the length of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["PQ", "\[RightVector]"], TraditionalForm]]],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"||", 
     OverscriptBox["PQ", "\[RightVector]"], "||"}], "=", 
    RowBox[{
     RowBox[{"||", 
      StyleBox["v",
       FontWeight->"Bold"], "||"}], "=", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"]}]]}]}], TraditionalForm]]],
 ". [The \[OpenCurlyDoubleQuote]norm\[CloseCurlyDoubleQuote] of a vector is \
the same as the \[OpenCurlyDoubleQuote]length\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]magnitude\[CloseCurlyDoubleQuote] of a vector.]"
}], "Text",
 CellChangeTimes->{{3.5438518459167204`*^9, 3.5438520629071054`*^9}, {
  3.5442223782909718`*^9, 3.5442223910797033`*^9}, {3.544222429887923*^9, 
  3.544222438180397*^9}, {3.544222625323101*^9, 3.5442226489334517`*^9}, {
  3.5442227018684793`*^9, 3.544222934969812*^9}, {3.681404913092575*^9, 
  3.681405055425403*^9}, {3.681931106640019*^9, 3.6819311357658377`*^9}}],

Cell[BoxData[{
 OverscriptBox["pq", "\[RightVector]"], "\[IndentingNewLine]", 
 RowBox[{"v", "=", 
  RowBox[{
   RowBox[{"Last", "[", 
    OverscriptBox["pq", "\[RightVector]"], "]"}], "-", 
   RowBox[{"First", "[", 
    OverscriptBox["pq", "\[RightVector]"], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Norm", "[", "v", "]"}]}], "Input",
 CellChangeTimes->{{3.5438521089161053`*^9, 3.5438521268241053`*^9}, {
  3.5438522161011057`*^9, 3.543852217432105*^9}, {3.5438522700931053`*^9, 
  3.5438522734101057`*^9}, {3.5438523901731052`*^9, 3.5438523912041054`*^9}, {
  3.5442216308422203`*^9, 3.544221631000229*^9}, {3.544222944277344*^9, 
  3.5442229968923535`*^9}}],

Cell[TextData[{
 "In comparison with ",
 Cell[BoxData[
  OverscriptBox["pq", "\[RightVector]"]],
  CellChangeTimes->{{3.5438521089161053`*^9, 3.5438521268241053`*^9}, {
   3.5438522161011057`*^9, 3.543852217432105*^9}, {3.5438522700931053`*^9, 
   3.5438522734101057`*^9}, {3.5438523901731052`*^9, 
   3.5438523912041054`*^9}, {3.5442216308422203`*^9, 3.544221631000229*^9}}],
 ", ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   FormBox[
    OverscriptBox["ov", "\[RightVector]"], TraditionalForm]]]]]],
  CellChangeTimes->{{3.5438522775561056`*^9, 3.5438522805451055`*^9}, {
   3.5438524037731056`*^9, 3.5438524571061053`*^9}, {3.5442217005952096`*^9, 
   3.5442217156510706`*^9}, {3.544221754410288*^9, 3.5442217545142937`*^9}, {
   3.5442217924584637`*^9, 3.5442217975907574`*^9}, {3.5442219737508335`*^9, 
   3.5442220255067935`*^9}, {3.544222059754752*^9, 3.5442220978849335`*^9}}],
 " is an equivalent vector with its base at the origin. ",
 Cell[BoxData[
  OverscriptBox["av", "\[RightVector]"]],
  CellChangeTimes->{{3.5438522775561056`*^9, 3.5438522805451055`*^9}, {
   3.5438524037731056`*^9, 3.5438524571061053`*^9}, {3.5442217005952096`*^9, 
   3.5442217156510706`*^9}, {3.544221754410288*^9, 3.5442217545142937`*^9}, {
   3.5442217924584637`*^9, 3.5442217975907574`*^9}, {3.5442219737508335`*^9, 
   3.5442220255067935`*^9}, {3.544222059754752*^9, 3.5442220978849335`*^9}}],
 " (see the definitions below) is an equivalent vector that does not have its \
base at the origin, and ",
 Cell[BoxData[
  OverscriptBox["bv", "\[RightVector]"]],
  CellChangeTimes->{{3.5438522775561056`*^9, 3.5438522805451055`*^9}, {
   3.5438524037731056`*^9, 3.5438524571061053`*^9}, {3.5442217005952096`*^9, 
   3.5442217156510706`*^9}, {3.544221754410288*^9, 3.5442217545142937`*^9}, {
   3.5442217924584637`*^9, 3.5442217975907574`*^9}, {3.5442219737508335`*^9, 
   3.5442220255067935`*^9}, {3.544222059754752*^9, 3.5442220978849335`*^9}}],
 " is a parallel vector that is not equivalent."
}], "Text",
 CellChangeTimes->{{3.5438524789801054`*^9, 3.5438525156921053`*^9}, {
  3.544222129907765*^9, 3.5442222970933275`*^9}, {3.681405081313303*^9, 
  3.681405087736802*^9}, {3.681405225335383*^9, 3.681405226590787*^9}, {
  3.681405282414514*^9, 3.681405310085696*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"o", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   OverscriptBox["ov", "\[RightVector]"], "=", 
   RowBox[{"{", 
    RowBox[{"o", ",", "v"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   OverscriptBox["av", "\[RightVector]"], "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"a", "+", "v"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   OverscriptBox["bv", "\[RightVector]"], "=", 
   RowBox[{"{", 
    RowBox[{"b", ",", 
     RowBox[{"b", "-", "v"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Arrow", "[", 
      OverscriptBox["pq", "\[RightVector]"], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      OverscriptBox["ov", "\[RightVector]"], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      OverscriptBox["av", "\[RightVector]"], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      OverscriptBox["bv", "\[RightVector]"], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "4"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5438522775561056`*^9, 3.5438522805451055`*^9}, {
   3.5438524037731056`*^9, 3.5438524571061053`*^9}, {3.5442217005952096`*^9, 
   3.5442217156510706`*^9}, {3.544221754410288*^9, 3.5442217545142937`*^9}, {
   3.5442217924584637`*^9, 3.5442217975907574`*^9}, {3.5442219737508335`*^9, 
   3.5442220255067935`*^9}, {3.544222059754752*^9, 3.5442220978849335`*^9}, {
   3.6497036681874228`*^9, 3.6497037061817102`*^9}, 3.649703994300865*^9}],

Cell[TextData[{
 "[By the way:  The semi-colon character, ",
 StyleBox[";",
  FontFamily->"Courier New",
  FontColor->RGBColor[1, 0, 0]],
 ", is used to suppress the output of one line of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code (the line still gets \[OpenCurlyDoubleQuote]executed\
\[CloseCurlyDoubleQuote])]\[LineSeparator]\[LineSeparator]Now we\
\[CloseCurlyQuote]re going to re-define ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]]],
 " to be scalars, instead of vectors.\n\nThe following commands draw (in two \
dimensions) a vector ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 ", a vector ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 ", a vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", " ", 
     StyleBox["u",
      FontWeight->"Bold"]}], "+", 
    RowBox[{"b", " ", 
     StyleBox["v",
      FontWeight->"Bold"]}]}], TraditionalForm]]],
 ", and an ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]]],
 " by ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]]],
 " grid of vectors  equivalent to ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.544223090475706*^9, 3.5442232573232493`*^9}, {
  3.5442233666275015`*^9, 3.5442233763430567`*^9}, {3.5442248261229796`*^9, 
  3.544224831464285*^9}, {3.649702870038075*^9, 3.6497030084382563`*^9}, {
  3.649703121101575*^9, 3.6497031245219393`*^9}, {3.649703329016568*^9, 
  3.649703337933197*^9}, {3.649703383120428*^9, 3.649703399825675*^9}, {
  3.6497035331739607`*^9, 3.649703561103612*^9}, {3.649703632318701*^9, 
  3.6497036577966757`*^9}, {3.649704018322248*^9, 3.649704094575871*^9}, {
  3.649704133734301*^9, 3.649704170845416*^9}, {3.649706942248049*^9, 
  3.649706955236277*^9}, {3.6814053362139482`*^9, 3.681405400765297*^9}, {
  3.6819313362289343`*^9, 3.6819313892903423`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], ";", 
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", "2"}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", "=", "3"}], ";", 
  RowBox[{"n", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"o", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g0", "=", 
   RowBox[{"{", 
    RowBox[{"Dotted", ",", 
     RowBox[{"Arrowheads", "[", "0.02", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"i", "-", "1"}], ")"}], "u"}], "+", 
         RowBox[{"j", " ", "v"}]}], ",", 
        RowBox[{
         RowBox[{"i", " ", "u"}], "+", 
         RowBox[{"j", " ", "v"}]}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{
        RowBox[{"-", "m"}], "+", "1"}], ",", "m"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"-", "n"}], ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"i", " ", "u"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"j", "-", "1"}], ")"}], " ", "v"}]}], ",", 
        RowBox[{
         RowBox[{"i", " ", "u"}], "+", 
         RowBox[{"j", " ", "v"}]}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "m"}], ",", "m"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{
        RowBox[{"-", "n"}], "+", "1"}], ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Dashing", "[", 
      RowBox[{"{", "}"}], "]"}], ",", "Thick", ",", 
     RowBox[{"Arrowheads", "[", "0.03", "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<u\>\"", ",", "Larger", ",", "Bold"}], "]"}], ",", 
       RowBox[{"1.1", "u"}], ",", 
       RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{"o", ",", "u"}], "}"}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<v\>\"", ",", "Larger", ",", "Bold"}], "]"}], ",", 
       RowBox[{"1.1", "v"}], ",", 
       RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{"o", ",", "v"}], "}"}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<au+bv\>\"", ",", "Larger", ",", "Bold"}], "]"}], ",", 
       RowBox[{"1.1", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "u"}], "+", 
          RowBox[{"b", " ", "v"}]}], ")"}]}], ",", 
       RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{"o", ",", 
        RowBox[{
         RowBox[{"a", " ", "u"}], "+", 
         RowBox[{"b", " ", "v"}]}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"plot3", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{"g0", ",", "g1", ",", "g2", ",", "g3"}], "]"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5442190062761035`*^9, 3.54421918209816*^9}, {
  3.5442192202393417`*^9, 3.544219267180026*^9}, {3.5442194526836367`*^9, 
  3.544219467715496*^9}, {3.54421954908315*^9, 3.5442195647950487`*^9}, {
  3.544219611381714*^9, 3.5442196399343467`*^9}, {3.5442196897971983`*^9, 
  3.5442197131595345`*^9}, {3.544220173364857*^9, 3.544220247321087*^9}, {
  3.5442202802099686`*^9, 3.5442202893904934`*^9}, {3.5442204107564354`*^9, 
  3.544220534654522*^9}, {3.5442205901266947`*^9, 3.5442206264927745`*^9}, {
  3.544220825237142*^9, 3.5442208344136667`*^9}, {3.5442209296611147`*^9, 
  3.544220943602912*^9}, {3.5442210092456665`*^9, 3.5442211137646446`*^9}, {
  3.5442211553880253`*^9, 3.54422119883051*^9}, {3.5442213360443583`*^9, 
  3.5442213850671625`*^9}, {3.544224690370215*^9, 3.544224692711349*^9}}],

Cell[CellGroupData[{

Cell["Exercise 4 - 4 Pts", "Subsection",
 CellChangeTimes->{{3.5442233059790325`*^9, 3.544223308328167*^9}, {
  3.681931789349964*^9, 3.681931790036099*^9}, {3.734974668361014*^9, 
  3.734974672912045*^9}},ExpressionUUID->"ece10a4a-81ef-451e-87c7-\
a6bca3a7be93"],

Cell[TextData[{
 "Choose a variety of values for u, v, a, b, m, and n in the above commands \
to investigate the following.  Give a precise geometric description of the \
relationship among the vectors ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", " ", 
     StyleBox["u",
      FontWeight->"Bold"]}], "+", 
    RowBox[{"b", " ", 
     StyleBox["v",
      FontWeight->"Bold"]}]}], TraditionalForm]]],
 ".  Is there some special choice of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 " such that it would ",
 StyleBox["not",
  FontVariations->{"Underline"->True}],
 " be possible to obtain all vectors in two dimensions as linear combinations \
of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 "? Given an example of such a choice of  ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.544223401344487*^9, 3.5442235161610537`*^9}, {
  3.544223719911708*^9, 3.544223721726812*^9}, {3.544284938247917*^9, 
  3.544284965339917*^9}, {3.5442850077469177`*^9, 3.544285256275917*^9}, {
  3.6819314245781393`*^9, 3.681931536322055*^9}, {3.6819317623257*^9, 
  3.681931763301691*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vectors in Three Dimensions", "Section",
 CellChangeTimes->{{3.5442238479500313`*^9, 3.5442238547164183`*^9}}],

Cell[TextData[{
 "The default style of Plots in Mathematica is to show the bounding box with \
the axes along three of the edges: x is downward right diagonal, y is upward \
right diagonal, and z is upward vertical.  Use the mouse to obtain different \
viewpoints.  Dragging from side to side moves the graphic around the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " axis, while dragging up and down makes the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " axis tumble.  Pressing ",
 StyleBox["Ctrl", "KeyEvent"],
 " while dragging up and down zooms in and out. Pressing ",
 StyleBox["Shift", "KeyEvent"],
 " while dragging pans in the direction of the drag."
}], "Text",
 CellChangeTimes->{{3.5442798077017655`*^9, 3.5442799857195654`*^9}, {
  3.5442804330354223`*^9, 3.5442804505716257`*^9}, {3.681405474619955*^9, 
  3.681405483267771*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "1"}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "5"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5442797303350296`*^9, 3.5442797764856443`*^9}, {
  3.5442853648379173`*^9, 3.5442853678059177`*^9}}],

Cell["\<\
The ability to visualize is helped with the judicious use of some options. \
\>", "Text",
 CellChangeTimes->{{3.5442808929752936`*^9, 3.544280909380012*^9}, {
  3.544280981245636*^9, 3.54428100508531*^9}}],

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "0.03", "]"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "10"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.544185944353037*^9, 3.544186033896757*^9}, {
   3.5441861941875553`*^9, 3.544186202121267*^9}, {3.54418626573149*^9, 
   3.5441863445086455`*^9}, {3.5441863847017546`*^9, 
   3.5441863903770638`*^9}, {3.5441864579442863`*^9, 
   3.5441864602744117`*^9}, {3.544186498577087*^9, 3.544186516493019*^9}, {
   3.5441865735936832`*^9, 3.544186595082576*^9}, {3.5441866658279667`*^9, 
   3.544186670575291*^9}, {3.5441870060356073`*^9, 3.5441870139341154`*^9}, {
   3.5441917533639455`*^9, 3.5441917631951585`*^9}, {3.544279704248421*^9, 
   3.544279762364232*^9}, {3.544280608871028*^9, 3.5442806573883233`*^9}, {
   3.544280714703955*^9, 3.544280730195856*^9}, {3.544280795016889*^9, 
   3.5442808188851147`*^9}, 3.544280871105668*^9, {3.544280939100067*^9, 
   3.5442809600548754`*^9}, {3.544285372214917*^9, 3.544285372582917*^9}, {
   3.5442899847565427`*^9, 3.544289987491543*^9}, {3.649707450346315*^9, 
   3.649707488858262*^9}, {3.6497075265237207`*^9, 3.649707537073332*^9}}],

Cell[TextData[{
 "Here are two functions that Patricia Oakley wrote that helped my ability to \
visualize.  ",
 StyleBox["myAxis",
  FontFamily->"Courier New"],
 " returns graphic primitives, or \[OpenCurlyDoubleQuote]subroutines\
\[CloseCurlyDoubleQuote] that create an axis in the given component direction \
with the given label in the given color from lo to hi; the axis is dashed for \
negative values.  ",
 StyleBox["myPoint",
  FontFamily->"Courier New"],
 " includes dashed lines indicating how one might plot the point by hand.  \
(You do not need to understand all of this code.)"
}], "Text",
 CellChangeTimes->{{3.54428118967031*^9, 3.544281438904513*^9}, {
  3.5442900732715425`*^9, 3.5442900930145426`*^9}, {3.649707039175887*^9, 
  3.649707073872961*^9}, {3.681405514212914*^9, 3.681405537442855*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"myAxis", "[", 
    RowBox[{
    "label_", ",", "color_", ",", "component_", ",", "lo_", ",", "hi_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", "g", ",", "o"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"o", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
      RowBox[{"e", "=", "o"}], ";", 
      RowBox[{
       RowBox[{
       "e", "\[LeftDoubleBracket]", "component", "\[RightDoubleBracket]"}], 
       "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"g", "=", 
       RowBox[{"{", 
        RowBox[{"color", ",", 
         RowBox[{"Text", "[", 
          RowBox[{"label", ",", 
           RowBox[{"1.05", " ", "hi", " ", "e"}]}], "]"}], ",", 
         RowBox[{"Arrowheads", "[", "0.02", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{"o", ",", 
            RowBox[{"hi", " ", "e"}]}], "}"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"lo", "<", "0"}], ",", 
        RowBox[{"g", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"g", ",", 
           RowBox[{"{", 
            RowBox[{"Dashed", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"lo", " ", "e"}], ",", "o"}], "}"}], "]"}], ",", 
             RowBox[{"Dashing", "[", 
              RowBox[{"{", "}"}], "]"}]}], "}"}]}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "g"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"myPoint", "[", 
    RowBox[{"p_", ",", "color_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"color", ",", "Dashed", ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", 
          RowBox[{"p", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
     RowBox[{"Point", "[", "p", "]"}], ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", "}"}], "]"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544260709698449*^9, 3.5442607186279593`*^9}, {
  3.54428111716831*^9, 3.5442811280423098`*^9}, {3.5442856744219174`*^9, 
  3.5442856853789177`*^9}, {3.5442900062835426`*^9, 3.544290041155543*^9}}],

Cell[TextData[{
 "The following command makes use of ",
 StyleBox["myAxis",
  FontFamily->"Courier New"],
 " and ",
 StyleBox["myPoint",
  FontFamily->"Courier New"],
 " and moves the view point so that the result is similar to what we did by \
hand in the \[OpenCurlyDoubleQuote]pipe-cleaner\[CloseCurlyDoubleQuote] \
exercise.  You could change the colors to match your pipe cleaner axes."
}], "Text",
 CellChangeTimes->{{3.544281452649887*^9, 3.5442815308497066`*^9}, {
  3.5442865107203045`*^9, 3.544286530905323*^9}, {3.6497071257496758`*^9, 
  3.649707175569515*^9}}],

Cell[BoxData[
 RowBox[{"Graphics3D", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Join", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "7"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<y\>\"", ",", 
       RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
       RowBox[{"-", "5"}], ",", "7"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
       RowBox[{"-", "9"}], ",", "8"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"myPoint", "[", 
      RowBox[{"a", ",", "Black"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"myPoint", "[", 
      RowBox[{"b", ",", "Black"}], "]"}]}], "\[IndentingNewLine]", "]"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.544188998883645*^9, 3.544189003768761*^9}, {
   3.5441897207364597`*^9, 3.5441897323461676`*^9}, {3.544190060055626*^9, 
   3.54419009446349*^9}, {3.5441901254087315`*^9, 3.5441901463092475`*^9}, {
   3.544190177415721*^9, 3.5441902335381937`*^9}, 3.5441902947152634`*^9, {
   3.5441904213970203`*^9, 3.5441904708429275`*^9}, {3.544191432467061*^9, 
   3.5441914326231127`*^9}, {3.544191466267708*^9, 3.544191473633315*^9}, 
   3.5441915498818345`*^9, {3.5441915858838005`*^9, 3.544191637041529*^9}, {
   3.5441952332194257`*^9, 3.5441952922172594`*^9}, {3.544227068842256*^9, 
   3.5442270705913563`*^9}, {3.544227108415519*^9, 3.544227136351117*^9}, {
   3.54422717940758*^9, 3.544227211334406*^9}, {3.544227258272091*^9, 
   3.5442272583830967`*^9}, {3.544264576475616*^9, 3.544264578367724*^9}, {
   3.544264611410614*^9, 3.5442647285733156`*^9}, {3.5442655755097575`*^9, 
   3.5442656265276756`*^9}, {3.544265668290064*^9, 3.5442656717772636`*^9}, {
   3.5442657178929014`*^9, 3.5442657435013657`*^9}, {3.5442683095971384`*^9, 
   3.544268333300494*^9}, {3.544268372027709*^9, 3.5442684125960293`*^9}, {
   3.544271170958799*^9, 3.5442711717258425`*^9}, {3.5442792389278936`*^9, 
   3.544279242872288*^9}, {3.544279277134714*^9, 3.5442792808680873`*^9}, {
   3.5442793221212125`*^9, 3.54427934140314*^9}, 3.54428111298731*^9, {
   3.544284734286769*^9, 3.544284743923805*^9}, 3.5442855942729177`*^9, {
   3.681405573228262*^9, 3.681405619794486*^9}}],

Cell[CellGroupData[{

Cell["Exercise 5 - 4 pts", "Subsection",
 CellChangeTimes->{{3.5442854817239175`*^9, 3.5442854844989176`*^9}, {
  3.734974680816737*^9, 
  3.7349746840967197`*^9}},ExpressionUUID->"3f003a3c-f9af-4501-9a91-\
1e6ff6a95134"],

Cell[TextData[{
 "Add to the above graph the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", "=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], ",", 
      RowBox[{"-", "5"}], ",", 
      RowBox[{"-", "8"}]}], ")"}]}], TraditionalForm]]],
 " and the line segments ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["ab", "_"], TraditionalForm]],
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox[
     StyleBox["bc",
      FontSlant->"Italic"], "_"],
    FontSlant->"Italic"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox[
     StyleBox["ca",
      FontSlant->"Italic"], "_"],
    FontSlant->"Italic"], TraditionalForm]]],
 ". "
}], "Text",
 CellChangeTimes->{{3.5442854998039174`*^9, 3.5442855312509174`*^9}, {
  3.5442857787319174`*^9, 3.5442859677640142`*^9}, {3.5442860469699345`*^9, 
  3.5442860929975367`*^9}, {3.6497080316748247`*^9, 3.6497080325582733`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6 - 2 pts", "Subsection",
 CellChangeTimes->{{3.5442864645226855`*^9, 3.5442864672429576`*^9}, {
  3.734974691738503*^9, 
  3.734974694024638*^9}},ExpressionUUID->"2c0e7436-d73b-4269-beb5-\
911ec4383f48"],

Cell[TextData[{
 "Graph the three axes (pick an appropriate ",
 StyleBox["ViewPoint",
  FontFamily->"Courier New"],
 ") to match the view point given in this diagram.\n  ",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJzt3D1PG1kYhuEj7TSUadIvHRX9dlugNFRu6OPCjaWVVoo0XSoXpN1iXbqI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     "], {{0, 193}, {224, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   BaseStyle->"ImageGraphics",
   ImageSize->{123.99999999999967`, Automatic},
   ImageSizeRaw->{224, 193},
   PlotRange->{{0, 224}, {0, 193}}]],
  CellChangeTimes->{
   3.544195665069894*^9, {3.5441956963549113`*^9, 3.5441957758713474`*^9}, {
    3.5441958068765025`*^9, 3.544195821559396*^9}, {3.544195858774744*^9, 
    3.544195863362173*^9}}]
}], "Text",
 CellChangeTimes->{{3.5442864799402275`*^9, 3.544286487276961*^9}, {
  3.544286853217551*^9, 3.544286897661995*^9}, {3.5442869853037586`*^9, 
  3.5442870219774256`*^9}, {3.544287111396366*^9, 3.544287111803407*^9}, {
  3.649704229570866*^9, 3.6497042405076838`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lines in Three Dimensions", "Section",
 CellChangeTimes->{{3.544287151727399*^9, 3.544287159864213*^9}, {
  3.544288306376198*^9, 3.544288308352*^9}}],

Cell[TextData[{
 "Graph the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["P", "0"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"3", ",", 
      RowBox[{"-", "1"}], ",", "4"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 ", the vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["v",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"2", ",", "1", ",", "7"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 " based at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "0"], TraditionalForm]]],
 ", and the line ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["r",
      FontWeight->"Bold"], "(", "t", ")"}], "=", 
    RowBox[{
     SubscriptBox["P", "0"], "+", 
     RowBox[{"t", " ", 
      StyleBox["v",
       FontWeight->"Bold"]}]}]}], TraditionalForm]]],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "2"}], "\[LessEqual]", "t", "\[LessEqual]", "2"}], 
   TraditionalForm]]],
 " with these commands:"
}], "Text",
 CellChangeTimes->{{3.544288320134822*^9, 3.5442886177455425`*^9}, {
  3.576569146254602*^9, 3.576569147550625*^9}, {3.681758692382987*^9, 
  3.68175870233146*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p0", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ";", 
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "7"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Join", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<y\>\"", ",", 
       RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"PointSize", "[", "0.03", "]"}], ",", 
       RowBox[{"Point", "[", "p0", "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "0.03", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{"p0", ",", 
          RowBox[{"p0", "+", "v"}]}], "}"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"p0", "-", 
          RowBox[{"3", "v"}]}], ",", 
         RowBox[{"p0", "+", 
          RowBox[{"3", "v"}]}]}], "}"}], "]"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5442876980321083`*^9, 3.5442877389644356`*^9}, {
  3.5442877712138453`*^9, 3.5442877937340703`*^9}, {3.5442878481839285`*^9, 
  3.5442880899741387`*^9}, {3.5442881470197277`*^9, 3.5442881493382635`*^9}, {
  3.544290136093543*^9, 3.544290176029543*^9}, {3.5442902661325426`*^9, 
  3.544290269044543*^9}, {3.68175939042659*^9, 
  3.681759392658989*^9}},ExpressionUUID->"03c51bc2-82fe-47bf-8cf5-\
1ddaa66478e6"],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], Text3DBox["\<\"x\"\>", {5.25, 0., 0.}], 
   {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {5, 0, 0}}], 
    {Dashing[{Small, Small}], Line3DBox[{{-5, 0, 0}, {0, 0, 0}}]}, 
    {RGBColor[
      NCache[
       Rational[2, 3], 0.6666666666666666], 
      NCache[
       Rational[2, 3], 0.6666666666666666], 0], Dashing[{}], 
     Text3DBox["\<\"y\"\>", {0., 5.25, 0.}], 
     {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 5, 0}}], 
      {Dashing[{Small, Small}], Line3DBox[{{0, -5, 0}, {0, 0, 0}}]}, 
      {RGBColor[0, 1, 0], Dashing[{}], Text3DBox["\<\"z\"\>", {0., 0., 5.25}], 
       {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 5}}], 
        {Dashing[{Small, Small}], Line3DBox[{{0, 0, -5}, {0, 0, 0}}]}, 
        {GrayLevel[0], PointSize[0.03], Dashing[{}], Point3DBox[{3, -1, 4}], 
         {Arrowheads[0.03], Arrow3DBox[{{3, -1, 4}, {5, 0, 11}}], 
          Line3DBox[{{-3, -4, -17}, {9, 2, 25}}]}}}}}}}},
  Axes->True,
  ViewPoint->{100, 100, 100}]], "Output",
 CellChangeTimes->{
  3.734974729427744*^9},ExpressionUUID->"c63c637a-4d8c-4cfa-b6dd-\
a085ea766ec2"]
}, Open  ]],

Cell[TextData[{
 "Add the red point ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["r",
      FontWeight->"Bold"], "(", "t", ")"}], "=", 
    RowBox[{
     SubscriptBox["P", "0"], "+", 
     RowBox[{"t", " ", 
      StyleBox["v",
       FontWeight->"Bold"]}]}]}], TraditionalForm]]],
 " with ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]]],
 " controlled by a slider."
}], "Text",
 CellChangeTimes->{{3.5442886284225426`*^9, 3.544288684406543*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"p0", "=", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "1"}], ",", "4"}], "}"}]}], ";", 
    RowBox[{"v", "=", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "7"}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{
      RowBox[{"Join", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"myAxis", "[", 
         RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"myAxis", "[", 
         RowBox[{"\"\<y\>\"", ",", 
          RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"myAxis", "[", 
         RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"Black", ",", 
          RowBox[{"PointSize", "[", "0.03", "]"}], ",", 
          RowBox[{"Point", "[", "p0", "]"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Arrowheads", "[", "0.03", "]"}], ",", 
          RowBox[{"Arrow", "[", 
           RowBox[{"{", 
            RowBox[{"p0", ",", 
             RowBox[{"p0", "+", "v"}]}], "}"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"p0", "-", 
             RowBox[{"3", "v"}]}], ",", 
            RowBox[{"p0", "+", 
             RowBox[{"3", "v"}]}]}], "}"}], "]"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Point", "[", 
           RowBox[{"p0", "+", 
            RowBox[{"t", " ", "v"}]}], "]"}]}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Axes", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "2"}], ",", "2", ",", "0.1", ",", " ", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5442881789323435`*^9, 3.544288208242012*^9}, {
   3.544288244126423*^9, 3.5442882682520103`*^9}, 3.544289086103543*^9, {
   3.544289145983543*^9, 3.544289166919543*^9}, {3.544290213079543*^9, 
   3.5442902859135427`*^9}, {3.681759399837618*^9, 
   3.681759402275014*^9}},ExpressionUUID->"57c82cd7-29fd-4408-9ada-\
584e80b6a1b0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = -0.5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t$$], 0}, -2, 2, 0.1}}, Typeset`size$$ = {
    183., {214., 218.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`t$63474$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$63474$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`p0 = {3, -1, 4}; $CellContext`v = {2, 1, 7}; 
       Graphics3D[
         Join[
          $CellContext`myAxis["x", Orange, 1, -5, 5], 
          $CellContext`myAxis["y", 
           Darker[Yellow], 2, -5, 5], 
          $CellContext`myAxis["z", Green, 3, -5, 5], {Black, 
           PointSize[0.03], 
           Point[$CellContext`p0]}, {
           Arrowheads[0.03], 
           Arrow[{$CellContext`p0, $CellContext`p0 + $CellContext`v}]}, {
           
           Line[{$CellContext`p0 - 3 $CellContext`v, $CellContext`p0 + 
             3 $CellContext`v}]}, {Red, 
           Point[$CellContext`p0 + $CellContext`t$$ $CellContext`v]}], Axes -> 
         True, ViewPoint -> {100, 100, 100}]), 
      "Specifications" :> {{{$CellContext`t$$, 0}, -2, 2, 0.1, Appearance -> 
         "Labeled"}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{283., {259., 265.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.734974739678113*^9},ExpressionUUID->"22bde231-2aeb-46f9-8a26-\
9803a0767c40"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7 - 2 pts", "Subsection",
 CellChangeTimes->{{3.544289255654543*^9, 3.544289263358543*^9}, {
  3.734974882073004*^9, 
  3.7349748877422533`*^9}},ExpressionUUID->"7b3b1123-8637-43f9-8d20-\
2ca194d638a8"],

Cell[TextData[{
 "Choose a variety of values for ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]]],
 " in the above manipulator to investigate the following.  Give a precise \
geometric description of the vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["r",
      FontWeight->"Bold"], "(", "t", ")"}], "=", 
    RowBox[{
     SubscriptBox["P", "0"], "+", 
     RowBox[{"t", " ", 
      StyleBox["v",
       FontWeight->"Bold"]}]}]}], TraditionalForm]]],
 ". Include in your description the relationship of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "0"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    FontWeight->"Bold"], TraditionalForm]]],
 " to the line."
}], "Text",
 CellChangeTimes->{{3.5442892673215427`*^9, 3.5442892981835427`*^9}, {
  3.5442893996575427`*^9, 3.544289419817543*^9}, {3.681758422177417*^9, 
  3.681758474606043*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 8 - 3 pts", "Subsection",
 CellChangeTimes->{{3.544289534902543*^9, 3.5442895364865427`*^9}, {
  3.734974890254237*^9, 
  3.7349748939743223`*^9}},ExpressionUUID->"96fb154e-94c2-49bc-9d0b-\
c9255b68f598"],

Cell[TextData[{
 "Graph the lines ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["r",
       FontWeight->"Bold"], "1"], "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"1", ",", "0", ",", "1"}], "\[RightAngleBracket]"}], "+", 
     RowBox[{"t", 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"3", ",", "3", ",", "5"}], "\[RightAngleBracket]"}]}]}]}], 
   TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["r",
       FontWeight->"Bold"], "2"], "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{"\[LeftAngleBracket]", 
      RowBox[{"3", ",", "6", ",", "1"}], "\[RightAngleBracket]"}], "+", 
     RowBox[{"t", 
      RowBox[{"\[LeftAngleBracket]", 
       RowBox[{"4", ",", 
        RowBox[{"-", "2"}], ",", "7"}], "\[RightAngleBracket]"}]}]}]}], 
   TraditionalForm]]],
 " for t running from -3 to 3.  Rotate your graph this way and that to decide \
whether the two lines either do or do not intersect. State what you find."
}], "Text",
 CellChangeTimes->{{3.544289548350543*^9, 3.5442896890385427`*^9}, 
   3.576569154150428*^9, {3.681758499326171*^9, 3.68175856347676*^9}, {
   3.681759373529632*^9, 3.681759380954371*^9}, {3.681759436601259*^9, 
   3.6817594846089*^9}, {3.6819316409186697`*^9, 3.681931643574325*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{726, 719},
WindowMargins->{{159, Automatic}, {Automatic, 16}},
PrintingPageRange->{Automatic, Automatic},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 27, \
2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[422, 15, 243, 6, 148, "Title", "ExpressionUUID" -> \
"5bffff1f-85f2-4d60-9e24-8f3b0b5099c0"],
Cell[668, 23, 604, 11, 49, "Text", "ExpressionUUID" -> \
"b01deb06-6cbc-445c-a388-09c0020c7d12"],
Cell[CellGroupData[{
Cell[1297, 38, 207, 6, 64, "Section", "ExpressionUUID" -> \
"a8cc0d14-af25-4d5b-938a-68d555141bf5"],
Cell[1507, 46, 1466, 23, 182, "Text", "ExpressionUUID" -> \
"1885fad9-b791-4d1f-b430-66ae0234d775"],
Cell[2976, 71, 353, 7, 32, "Input", "ExpressionUUID" -> \
"62168d75-464c-4be1-869e-16c630a5deb6"],
Cell[3332, 80, 669, 20, 71, "Text", "ExpressionUUID" -> \
"b4715f72-0191-4125-9849-fbf3d10fc2f7"],
Cell[4004, 102, 336, 8, 32, "Input", "ExpressionUUID" -> \
"8dc387b9-4647-4d86-a08e-6fbe905d7b96"],
Cell[4343, 112, 331, 7, 50, "Text", "ExpressionUUID" -> \
"ac141d7d-3a3d-4e5d-b019-3f37ef3c2519"],
Cell[4677, 121, 392, 10, 32, "Input", "ExpressionUUID" -> \
"8253113f-5ddf-4bd2-9256-e8423f838faf"],
Cell[5072, 133, 395, 8, 49, "Text", "ExpressionUUID" -> \
"28dfcdb7-d14d-4ee0-b9e7-5760e7cc5c00"],
Cell[5470, 143, 370, 11, 32, "Input", "ExpressionUUID" -> \
"73d58a50-b63b-4d40-9230-cee920d9a701"],
Cell[5843, 156, 192, 4, 30, "Text", "ExpressionUUID" -> \
"d08655f2-eac8-450a-8799-902aebd8e42d"],
Cell[6038, 162, 340, 9, 32, "Input", "ExpressionUUID" -> \
"b81ef64d-fc02-4c76-8292-dbfff7ed38bc"],
Cell[6381, 173, 548, 9, 87, "Text", "ExpressionUUID" -> \
"23aa4a92-cd51-4c08-8966-71e4f7ee28f0"],
Cell[6932, 184, 365, 8, 56, "Input", "ExpressionUUID" -> \
"80e24463-4c8b-4298-9d85-33757a2ce1af"],
Cell[7300, 194, 332, 6, 49, "Text", "ExpressionUUID" -> \
"25aea8af-0934-4d47-be5d-a9178a57a444"],
Cell[7635, 202, 627, 18, 79, "Input", "ExpressionUUID" -> \
"3f5b56fb-2b20-46a0-9bf3-c96d302cc5ba"],
Cell[8265, 222, 421, 9, 49, "Text", "ExpressionUUID" -> \
"ba36d36c-c7b5-41ba-bc5a-537cb579b2f5"],
Cell[8689, 233, 483, 13, 96, "Input", "ExpressionUUID" -> \
"a66753e6-9d5f-450b-9bb8-55c077fc2937"],
Cell[9175, 248, 778, 22, 70, "Text", "ExpressionUUID" -> \
"0bad005d-b2d4-4b86-8423-800f71b3903e"],
Cell[9956, 272, 332, 9, 75, "Input", "ExpressionUUID" -> \
"e4980438-9fd7-40c8-b403-db0538bd1833"],
Cell[10291, 283, 1699, 43, 207, "Text", "ExpressionUUID" -> \
"de710df8-9b5d-4836-aae5-289a3aa74de7"],
Cell[CellGroupData[{
Cell[12015, 330, 156, 3, 32, "Input", "ExpressionUUID" -> \
"56d217b7-4250-47ae-a887-34a98436b234"],
Cell[12174, 335, 68, 1, 32, "Output", "ExpressionUUID" -> \
"71889071-bcdc-4053-93fc-76140897dd18"]
}, Open  ]],
Cell[12257, 339, 184, 4, 30, "Text", "ExpressionUUID" -> \
"cfd804ff-cd29-4bcd-aae7-0db64802ad1c"],
Cell[12444, 345, 660, 17, 96, "Input", "ExpressionUUID" -> \
"39b6443a-835c-4b01-97da-1c904d0d2380"],
Cell[CellGroupData[{
Cell[13129, 366, 217, 4, 44, "Subsection", "ExpressionUUID" -> \
"741adfa1-b676-407d-9cd7-e28974a72559"],
Cell[13349, 372, 1218, 43, 58, "Text", "ExpressionUUID" -> \
"868a1e78-43f1-4b61-8724-a26459b1c186"],
Cell[14570, 417, 513, 10, 144, "Text", "ExpressionUUID" -> \
"1c5a2a3b-3575-43ee-abe6-9c66fff87b15"],
Cell[15086, 429, 243, 6, 32, "Input", "ExpressionUUID" -> \
"3ff279f0-b931-4afc-b29d-d039b0e9338a"],
Cell[15332, 437, 318, 7, 50, "Text", "ExpressionUUID" -> \
"b831c96c-c87f-467a-99e6-af6806c747c6"],
Cell[15653, 446, 851, 24, 133, "Input", "ExpressionUUID" -> \
"b4f47f6c-b324-49f5-8e3b-37018d55e9be"],
Cell[16507, 472, 472, 12, 51, "Text", "ExpressionUUID" -> \
"3e8c9fda-c859-49c1-8ae1-a3d46b73d4bd"],
Cell[16982, 486, 254, 5, 54, "Input", "ExpressionUUID" -> \
"1487ab28-1501-43a0-a5c8-c817d056101c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17273, 496, 265, 4, 44, "Subsection", "ExpressionUUID" -> \
"0184d503-6576-4efd-aa00-362c87a64739"],
Cell[17541, 502, 1171, 42, 78, "Text", "ExpressionUUID" -> \
"e2b1abcb-91d7-4e58-ac50-d18d64c5e732"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18749, 549, 269, 4, 44, "Subsection", "ExpressionUUID" -> \
"e9a3f8b5-d4d2-4b16-9c24-82906beed341"],
Cell[19021, 555, 396, 11, 31, "Text", "ExpressionUUID" -> \
"d677124b-7fab-4935-aed2-c3aaa553757f"],
Cell[19420, 568, 898, 21, 101, "Text", "ExpressionUUID" -> \
"532169ad-e695-4567-9961-5d296041a866"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20367, 595, 158, 2, 64, "Section", "ExpressionUUID" -> \
"ae5799ed-dec1-4620-a918-1b321b1d4c86"],
Cell[20528, 599, 1883, 58, 149, "Text", "ExpressionUUID" -> \
"d5de9405-8d8d-4322-8046-4232ed1d3948"],
Cell[22414, 659, 316, 8, 54, "Input", "ExpressionUUID" -> \
"92fe132c-4673-4885-96cf-28371b8b45e2"],
Cell[22733, 669, 161, 2, 30, "Text", "ExpressionUUID" -> \
"3b72ac4a-6e6d-451b-bcff-0afbaf7e2932"],
Cell[22897, 673, 519, 12, 32, "Input", "ExpressionUUID" -> \
"6f1fb607-bcbd-4f5d-8216-957494335f20"],
Cell[23419, 687, 168, 3, 30, "Text", "ExpressionUUID" -> \
"d27ca90a-d34a-41a5-af26-c4b3e6e25be0"],
Cell[23590, 692, 573, 17, 54, "Input", "ExpressionUUID" -> \
"2185c764-9996-4375-8971-9b17958e75a8"],
Cell[24166, 711, 1038, 41, 55, "Text", "ExpressionUUID" -> \
"9352be64-1a72-42c6-a7dd-2c4e71ff8ee1"],
Cell[25207, 754, 906, 22, 121, "Input", "ExpressionUUID" -> \
"3fda6964-b0bd-4459-88a4-0c7319259ad2"],
Cell[26116, 778, 2628, 75, 163, "Text", "ExpressionUUID" -> \
"cf2827af-c4ea-4e9e-8b16-cb440e80f27a"],
Cell[28747, 855, 665, 13, 76, "Input", "ExpressionUUID" -> \
"6bba5e84-3c0c-46ae-a71f-d2580279696f"],
Cell[29415, 870, 2261, 39, 77, "Text", "ExpressionUUID" -> \
"47fbc48a-2eb0-43bb-8219-41ac8f76477c"],
Cell[31679, 911, 1911, 51, 200, "Input", "ExpressionUUID" -> \
"aa3bb1bc-6f47-4e1c-bfd2-4a6694611d15"],
Cell[33593, 964, 2115, 64, 149, "Text", "ExpressionUUID" -> \
"31cd4b58-8b1a-451c-8ccc-c99fea5fadb4"],
Cell[35711, 1030, 4607, 130, 285, "Input", "ExpressionUUID" -> \
"16530e4c-c1e8-456c-96c1-b08ed0e28a41"],
Cell[CellGroupData[{
Cell[40343, 1164, 263, 4, 44, "Subsection", "ExpressionUUID" -> \
"ece10a4a-81ef-451e-87c7-a6bca3a7be93"],
Cell[40609, 1170, 1746, 63, 110, "Text", "ExpressionUUID" -> \
"c0d2112b-fa3e-4bb8-9df9-d8444f7c6654"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42404, 1239, 116, 1, 64, "Section", "ExpressionUUID" -> \
"e77b4956-a734-44b1-b562-32a5e8e9f0db"],
Cell[42523, 1242, 891, 18, 107, "Text", "ExpressionUUID" -> \
"71a89fc8-22e5-44ae-8827-53061746efd9"],
Cell[43417, 1262, 459, 12, 54, "Input", "ExpressionUUID" -> \
"682bd82d-2524-4032-bb15-9ae84fbec2b9"],
Cell[43879, 1276, 215, 4, 30, "Text", "ExpressionUUID" -> \
"eaec4546-6435-4a0a-8375-bf067eb99028"],
Cell[44097, 1282, 1725, 35, 75, "Input", "ExpressionUUID" -> \
"5a09601e-2123-4e5b-b18e-fae37afc8fde"],
Cell[45825, 1319, 815, 16, 110, "Text", "ExpressionUUID" -> \
"006036d5-92be-48a8-9faa-820ea069d597"],
Cell[46643, 1337, 2720, 72, 159, "Input", "ExpressionUUID" -> \
"73d1c259-495f-4a1f-8fd2-f68d7390efa9"],
Cell[49366, 1411, 573, 13, 70, "Text", "ExpressionUUID" -> \
"3cda5f5c-8e7b-4c27-8f99-5afc1c51afb0"],
Cell[49942, 1426, 2576, 44, 222, "Input", "ExpressionUUID" -> \
"cc74ff3f-00c7-4cc4-aefb-11fd1565ff76"],
Cell[CellGroupData[{
Cell[52543, 1474, 221, 4, 44, "Subsection", "ExpressionUUID" -> \
"3f003a3c-f9af-4501-9a91-1e6ff6a95134"],
Cell[52767, 1480, 958, 35, 33, "Text", "ExpressionUUID" -> \
"dc36b157-2194-4058-b7ba-62787648307a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53762, 1520, 219, 4, 44, "Subsection", "ExpressionUUID" -> \
"2c0e7436-d73b-4269-beb5-911ec4383f48"],
Cell[53984, 1526, 3151, 59, 161, "Text", "ExpressionUUID" -> \
"50094ca6-18a1-46fa-b47f-49924156e642"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57184, 1591, 156, 2, 64, "Section", "ExpressionUUID" -> \
"d3b9559f-4eb7-4943-a17b-126c893d2bbd"],
Cell[57343, 1595, 1208, 45, 52, "Text", "ExpressionUUID" -> \
"bd3bb3b5-cc7a-4e19-8a85-94b38eb7bd3b"],
Cell[CellGroupData[{
Cell[58576, 1644, 2211, 54, 201, "Input", "ExpressionUUID" -> \
"03c51bc2-82fe-47bf-8cf5-1ddaa66478e6"],
Cell[60790, 1700, 1124, 23, 447, "Output", "ExpressionUUID" -> \
"c63c637a-4d8c-4cfa-b6dd-a085ea766ec2"]
}, Open  ]],
Cell[61929, 1726, 473, 18, 32, "Text", "ExpressionUUID" -> \
"1bfabf79-7eec-4e74-96c8-b9a9fc486dd3"],
Cell[CellGroupData[{
Cell[62427, 1748, 2752, 69, 222, "Input", "ExpressionUUID" -> \
"57c82cd7-29fd-4408-9ada-584e80b6a1b0"],
Cell[65182, 1819, 2355, 50, 541, "Output", "ExpressionUUID" -> \
"22bde231-2aeb-46f9-8a26-9803a0767c40"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67574, 1874, 217, 4, 44, "Subsection", "ExpressionUUID" -> \
"7b3b1123-8637-43f9-8d20-2ca194d638a8"],
Cell[67794, 1880, 907, 30, 73, "Text", "ExpressionUUID" -> \
"e7aa2466-ba24-4036-aa01-ddd38fb4e727"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68738, 1915, 219, 4, 44, "Subsection", "ExpressionUUID" -> \
"96fb154e-94c2-49bc-9d0b-c9255b68f598"],
Cell[68960, 1921, 1372, 38, 70, "Text", "ExpressionUUID" -> \
"0908ac08-fb10-4848-a9ec-26773c3337ef"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

